/*
*         Copyright (c), NXP Semiconductors Gratkorn / Austria
*
*                     (C)NXP Semiconductors
*       All rights are reserved. Reproduction in whole or in part is
*      prohibited without the written consent of the copyright owner.
*  NXP reserves the right to make changes without notice at any time.
* NXP makes no warranty, expressed, implied or statutory, including but
* not limited to any implied warranty of merchantability or fitness for any
*particular purpose, or that the use will not infringe any third party patent,
* copyright or trademark. NXP must not be liable for any loss or damage
*                          arising from its use.
*/

/** \file
* Build System Definitions for Reader Library Framework.
* $Author: Sandeep Sukumar (nxp66431) $
* $Revision: 4241 $ (NFCRDLIB_V4.010.01.001603 : 3241 )
* $Date: 2016-02-24 18:14:49 +0530 (Wed, 24 Feb 2016) $
*
* History:
*
*
*/

#ifndef PH_NXPBUILD_APP_H
#define PH_NXPBUILD_APP_H


/** \defgroup ph_NxpBuild NXP Build
* \brief Controls build behavior of components.
* @{
*/

/* NXPBUILD_DELETE: included code lines should be always removed from code */

/* NXP Build defines                            */
/* use #define to include components            */
/* comment out #define to exclude components    */

/* DEBUG build mode */
/* #define NXPBUILD__PH_DEBUG */                      /**< DEBUG build definition */

/* #define NXPRDLIB_REM_GEN_INTFS */
#define NXPBUILD__PH_PLATFORM

/* BAL components */
#define NXPBUILD__PHBAL_REG_STUB                /**< Stub BAL definition */

/* HAL components */
#define NXPBUILD__PHDL_HW_PN5180               /**< PN5180 HAL definition */




/** @}
* end of ph_NxpBuild
*/
#endif /* PH_NXPBUILD_APP_H */
