/*
 * File:		mma7455.c
 * Purpose:		3-axis accel for Tower Mechatronic board 
 * 
 * License:     All software covered by license agreement in -
 *              docs/Freescale_Software_License.pdf
 */

#include "common.h"
#include "iic.h"
#include "pit.h"

void MMA7455AccelInit( void )
{
	I2Cinit();
	I2CsendByte( 0x05, 0x16, 0x1D );	
}

void MMA7455AccelRead( unsigned char *results ) 
{
  PITDelay(10, 0);	// Without these delays, the I2C bus hangs ????  
  results[0] = I2CreceiveByte( 0x06, 0x1D ); 
  PITDelay(10, 0);  // Without these delays, the I2C bus hangs ????
  results[1] = I2CreceiveByte( 0x07, 0x1D );   
  PITDelay(10, 0);  // Without these delays, the I2C bus hangs ????
  results[2] = I2CreceiveByte( 0x08, 0x1D );     
}

