/*
 * File:		base_main.c
 * Purpose:		Tower Mechatronic board 
 * 
 * License:     All software covered by license agreement in -
 *              docs/Freescale_Software_License.pdf
 */

#include "common.h"
#include "uart.h"
#include "pit.h"
#include "pit_example.h"
#include "servos.h"
#include "mma7455.h"
#include "mpr121.h"

#define ENABLE_INTERRUPTS  	mcf5xxx_wr_sr(0x2000); // Global interrupt enable

/********************************************************************/
// Walking defines
/********************************************************************/
#define CENTER		128
#define HIPPOS1		156
#define HIPPOS2 	100
#define ANKLPOS1	150
#define ANKLPOS2	70


uint16 WaitTouch( uint8 delayinHundms )
{
	uint8 loop;
	uint16 touch;
	
	for( loop = delayinHundms; loop; --loop )
	{
		PITDelay(50, 0);
		touch = ReadMPR121_Status();
		if( touch ) break;
		PITDelay(50, 0);
		touch = ReadMPR121_Status();
		if( touch ) break;
	}
	
	return( touch );
}


/********************************************************************/
void main (void)
{
	uint8 i, mode;
	uint16 touch;
	uint8 results[3];
	
	//unmask UART0 interrupts in INTC0
	MCF_INTC0_IMRL &= ~(MCF_INTC_IMRL_INT_MASK13);
        
	/* Setup the interrupt level and priority for UART0 */
	MCF_INTC0_ICR13 = MCF_INTC_ICR_IL(4) | MCF_INTC_ICR_IP(4);
	
	/* Set the interrupt handlers in the vector table */
	mcf5xxx_set_handler(64 + 13, (ADDRESS)uart0_handler);	

	/* Set the interrupt handlers in the vector table */
	mcf5xxx_set_handler(64 + 55, (ADDRESS)pit0_isr);
	mcf5xxx_set_handler(64 + 56, (ADDRESS)pit1_isr);

	/* PIT Basic Initialization */
	(void) PITInit(0, 800, 0);

	InitServos();

	printf( "\nTower Mechatronic board\n" );
	MMA7455AccelInit();
	InitMPR121();
	
//		servo    1       2     3      4
//            R-Ankle R-Hip   L-Hip L-Ankle	
// MoveServos( CENTER,CENTER,CENTER,CENTER,CENTER,CENTER,CENTER,CENTER,25 ); // J31,J33,J35,J37		
	
	mode = 0;
	while( 1 )
	{
		MMA7455AccelRead( results );
		touch = ReadMPR121_Status();
		printf( "\n%d %d %d %d", results[0], results[1], results[2], touch );

		switch( mode )
		{
			case 0: // Stand up
				MoveServos( CENTER,CENTER,CENTER,CENTER,CENTER,CENTER,CENTER,CENTER,25 ); // J31,J33,J35,J37		
				if( touch & 0x0F00 ) // right ear
					mode = 1;
				if( touch & 0x000F ) // left ear
					mode = 2;
				if( touch & 0x0020 ) // face
					mode = 3;
				break;
				
			case 1: // lean left
				i = (char)results[0]/4;
				MoveServos( CENTER, CENTER, CENTER, 160-i, CENTER,CENTER,CENTER,CENTER,25 ); // J31,J33,J35,J37		
				if( touch & 0x000F ) // left ear
					mode = 2;
				if( touch & 0x0010 ) // face
					mode = 0;
				break;
			
			case 2: // lean right
				i = (char)results[0]/4;
				MoveServos( 80-i,CENTER, CENTER,CENTER,CENTER,CENTER,CENTER,CENTER,25 ); // J31,J33,J35,J37		
				if( touch & 0x0F00 ) // right ear
					mode = 1;
				if( touch & 0x0010 ) // face
					mode = 0;
				break;

			case 3: // walk - sequence 1 - lean right
				i = (char)results[0]/4;
				MoveServos( CENTER, CENTER,CENTER, ANKLPOS2 ,    CENTER,CENTER,CENTER,CENTER,20 ); // J31,J33,J35,J37		
				MoveServos( ANKLPOS2, CENTER,CENTER, ANKLPOS2 ,    CENTER,CENTER,CENTER,CENTER,20 ); // J31,J33,J35,J37		
				 MoveServos( 80-i, CENTER, CENTER,CENTER,    CENTER,CENTER,CENTER,CENTER,20 ); // J31,J33,J35,J37		
				touch = WaitTouch( 5 ); 
				if( touch & 0x0010 ) // face
					mode = 0;
				mode = 4;
				break;

			case 4: // walk - sequence 2 - rotate hips
				i = (char)results[0]/4;
				MoveServos( 80-i,HIPPOS1,HIPPOS1, CENTER,   CENTER,CENTER,CENTER,CENTER,20 ); // J31,J33,J35,J37		
				touch = WaitTouch( 5 ); 
				if( touch & 0x0010 ) // face
					mode = 0;
				mode = 5;
				break;

			case 5: // walk - sequence 3 - lean left
				i = (char)results[1]/4;
				MoveServos( ANKLPOS1,HIPPOS1, HIPPOS1, ANKLPOS1,  CENTER,CENTER,CENTER,CENTER,20 ); // J31,J33,J35,J37		
				MoveServos( ANKLPOS1, HIPPOS1, HIPPOS1 ,160-i,  CENTER,CENTER,CENTER,CENTER,20 ); // J31,J33,J35,J37		
				touch = WaitTouch( 5 ); 
				if( touch & 0x0010 ) // face
					mode = 0;
				mode = 6;
				break;

			case 6: // walk - sequence 3 - rotate hips
				i = (char)results[1]/4;
				MoveServos( ANKLPOS1, HIPPOS2, HIPPOS2, 160-i,  CENTER,CENTER,CENTER,CENTER,20 ); // J31,J33,J35,J37		
				touch = WaitTouch( 5 ); 
				if( touch & 0x0010 ) // face
					mode = 0;
				mode = 7;
				break;

			case 7: // walk - sequence 3 - lean right
				i = (char)results[1]/4;
				MoveServos( CENTER, CENTER,CENTER, ANKLPOS2 ,    CENTER,CENTER,CENTER,CENTER,20 ); // J31,J33,J35,J37		
				MoveServos( ANKLPOS2, CENTER,CENTER, ANKLPOS2 ,    CENTER,CENTER,CENTER,CENTER,20 ); // J31,J33,J35,J37		
				 MoveServos( 80-i, CENTER, CENTER,CENTER,    CENTER,CENTER,CENTER,CENTER,20 ); // J31,J33,J35,J37		

//				MoveServos( HIPPOS2, CENTER,ANKLPOS2,HIPPOS2,  CENTER,CENTER,CENTER,CENTER,10 ); // J31,J33,J35,J37		
//				MoveServos( HIPPOS2, 80-i,ANKLPOS2,HIPPOS2,  CENTER,CENTER,CENTER,CENTER,10 ); // J31,J33,J35,J37		
//				MoveServos( CENTER, 80-i,ANKLPOS2,CENTER,  CENTER,CENTER,CENTER,CENTER,10 ); // J31,J33,J35,J37		
				touch = WaitTouch( 5 ); 
				if( touch & 0x0010 ) // face
					mode = 0;
				mode = 4;
				break;
		}
	}

	for( ;; );
}
	