/*
 * app_ntag.h copied from original ndef_message.h
 *
 *  Created on: 01.2017
 *      Author: NXP53811
 */


/************************************************************************************
*************************************************************************************
* Include
*************************************************************************************
************************************************************************************/
#include "ntag_defines.h"
#include "ntag_driver.h"
#include "nfc_device.h"
#include "NDEF_Status.h"

/*! *********************************************************************************
*************************************************************************************
* Public Macros and Definitions
*************************************************************************************
********************************************************************************** */
#ifdef I2C_FSL
#define NTAG_I2C_MASTER_BASEADDR 	I2C1
#define I2C_MASTER_CLK_SRC 			I2C1_CLK_SRC
#endif

#define NDEF_MSG_LEN_MAX_1K   880  // (page_55 - page_0) * 16_bytes/page
#define NDEF_MSG_LEN_MAX_2K   1904 // (page_127 - page_63) * 16_bytes/page + NDEF_MSG_LEN_MAX_1K
#define NDEF_MSG_LEN_1B_TLV   0x00FF
#define NDEF_MSG_LEN_3B_TLV   0xFFFF

#define NULL_TLV              0x00
#define LOCK_CONTROL_TLV      0x01
#define MEMORY_CONTROL_TLV    0x02
#define NDEF_MESSAGE_TLV      0x03
#define PROPRIETARY_TLV       0xFD
#define TERMINATOR_TLV        0xFE

#define NDEF_MSG_TLV_LEN_LONG    4
#define NDEF_MSG_TLV_LEN_SHORT   2

static const uint8_t Default_Empty_NDEF_msg[] =
        {
         0xAA, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00,
         0xE1, 0x10, 0x6D, 0x00,
         0x03, 0x03, 0xD0, 0x00,
         0x00, 0xFE, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00};


/*! *********************************************************************************
*************************************************************************************
* Public macros
*************************************************************************************
********************************************************************************** */


/*! *********************************************************************************
*************************************************************************************
* Public memory declarations
*************************************************************************************
********************************************************************************** */
static const uint8_t Null_Block[] = {
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00};

static const uint8_t Default_Page_56[] = {
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xFF};

static const uint8_t Default_Page_57[] = {
	0x00, 0x00, 0x00, 0x00,
	0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00};

static const uint8_t Default_Page_58[] = {
	0x01, 0x00, 0xF8, 0x48,
	0x08, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00};

extern NFC_HANDLE_T ntag_handle;			 // NTAG
//static uint8_t sram_buf[NTAG_MEM_SRAM_SIZE]; // NTAG


/*! *********************************************************************************
*************************************************************************************
* Public prototypes
*************************************************************************************
********************************************************************************** */
Status_t NDEF_Pairing_Write(void);
Status_t NDEF_Demo_Write(void);


/*! *********************************************************************************
*************************************************************************************
* BTSSP NDEF record deep description
*************************************************************************************
********************************************************************************** */

/* BLE pairing NDEF message
 *
 * Default NDEF message: SmartPoster
 * Title: NTAG I2C Explorer
 * Link: http://www.nxp.com/demoboard/OM5569
 * Android Application: com.nxp.ntagi2cdemo
 *
 * content has to be multiples of 0x10
 * one block consist of the 0x10 bytes
 *
 * The memory access of NTAG I2C plus from the I²C interface:
 *
 * the NDEF message is necessary to write from address 0x10 or from first page (1)
 * to the NTAG I2C memory ...
 *
 * the NDEF message is in the format of T2T and consists of the TLV bytes
 *
 * NOTE: from the address 0x00 or from the zero "0" page has to be written,
 * if necessary, following field (2k mem NTAG I2C plus - the chip NT3H2211):
 *  0xAA, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
 *  0x00, 0x00, 0x00, 0x00, 0xE1, 0x10, 0x6D, 0x00,
 *
 */

//    uint8_t BLE_pairing_NDEF_msg1[] = {
//            /* 2  */    0x03, 0x2F, // TLV NDEF message / 0x2F = length
//            /* 4  */    0xD2, 0x20, 0x0c,
//            /* 32 */    'a','p','p','l','i','c','a','t','i','o','n','/','v','n','d','.','b','l','u','e','t','o','o','t','h','.','l','e','.','o','o','b',
//            /* 1  */    0x08,    // LE Bluetooth Device Address length: 8 bytes
//            /* 1  */    0x1B,    // LE Bluetooth Device Address data type
//            /* 6  */    0xc6, 0xc5, 0xc4, 0xc3, 0xc2, 0xc1, // Bluetooth Device Address: 6 bytes + 1 (next byte)
//            /* 1  */    0x00,    // added at the end of the Device Address
//            /* 1  */    0x02,    // LE Role Length: 2 bytes
//            /* 1  */    0x1c,    // LE Role data type
//            /* 1  */    0x02,    // LE Role:  PeripheralPrefered
//            /* 1  */    0xFE,    // TLV terminator
//            /* -- 51 --  */
//            /* 64-51 = 13 */   0,0,0,0,  0,0,0,0,  0,0,0,0,  0
//    };


/*! *********************************************************************************
* @}   end of file
********************************************************************************** */
