/*
 * NDEF_Wlc.h
 *
 *  Created on: 2. 10. 2017
 *      Author: nxf19239
 */

#ifndef NDEF_REC_WLC_H_
#define NDEF_REC_WLC_H_

#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

#include <stdint.h>
#include "NDEF_Status.h"
#include "NDEF_Record.h"

typedef struct
{
	RecordInfo_t sRecordInfo_Int;
	NDEF_Record_Header_t sHeader;
	uint8_t bWlcProtocolVer;
	uint8_t bSupportedModes;
	uint8_t bPowerClass;
	uint8_t bBatStat;
	uint8_t bBatWtInt;
	uint8_t bTiLisWt;
	uint8_t bRdConf;
	uint8_t bTiPolWtInt;
}NDEF_Record_Wlc_Cap_t;

typedef struct
{
	RecordInfo_t sRecordInfo_Int;
	NDEF_Record_Header_t sHeader;
	uint8_t bTransmitPowerLevel;
	uint8_t bJiFodReq;
}NDEF_Record_Wlc_Ti_Pol_t;

typedef struct
{
	RecordInfo_t sRecordInfo_Int;
	NDEF_Record_Header_t sHeader;
	uint8_t bTiPolReq;
	uint8_t bErrorPacketFlag;
	uint8_t bWptDurationInt;
	int8_t  bPowerAdjReq;
	uint8_t bBatteryLevel;
	uint8_t bDvrFlg;
	uint8_t bDvrInt;
	uint8_t bHoldOffWtInt;
	uint8_t bErrorPacket;

}NDEF_Record_Wlc_Ti_Lis_t;

extern Status_t NDEF_Record_Wlc_Cap_SetProtocolVer();
extern Status_t NDEF_Record_Wlc_Cap_SetSupportedModes();
extern Status_t NDEF_Record_Wlc_Cap_SetPowerClass();
extern Status_t NDEF_Record_Wlc_Cap_SetBatStat();
extern Status_t NDEF_Record_Wlc_Cap_SetBatStat();

#ifdef __cplusplus
} /* Extern C */
#endif

#endif /* NDEF_REC_WLC_H_ */
