/*
 * NDEF_Aar.h
 *
 *  Created on: 2. 10. 2017
 *      Author: nxf19239
 */

#ifndef NDEF_REC_AAR_H_
#define NDEF_REC_AAR_H_

#include <stdint.h>
#include "NDEF_Status.h"
#include "NDEF_Record.h"
#include "NDEF_Message.h"

/** \defgroup Aar Android Application Record
*
* \brief
* @{
*/

/**
* \brief Android application record structure
*/
typedef struct
{
	RecordInfo_t INT_sRecordInfo;	/**< Internal record information. */
	NDEF_Record_Header_t sHeader;	/**< Record header structure. */
	uint8_t * pPackage;				/**< Pointer to package. */

}NDEF_Rec_Aar_t;

/**
 * \brief This function will allocate Aar record on heap  and return a handle by which the record can be referenced. Content of all parameters is stored internally on heap.
 *
 * @param[in] 	  pPackage  Pointer to package string - NULL terminated.
 *
 * @return Record handle
 * @retval Pointer to NDEF_Rec_Aar_t allocated on heap
 * @retval NULL in case of an error
 */
extern NDEF_Rec_Aar_t * NDEF_Rec_Aar_Create(const uint8_t * pPackage);

/**
 * \brief This function is used to return the Package length from a record specified by handle in case the length needs to be known in advance of GetPackage function call.
 *
 * @param[in] pRecord	   		Pointer to Aar record structure.
 *
 * @return Length of the Package field
 */
extern uint16_t NDEF_Rec_Aar_GetPackageLen(const NDEF_Rec_Aar_t * pRecord);

/**
 * \brief This function is used to get the Package from a record specified by handle.
 *
 * @param[in] 	  pRecord   Pointer to Aar record.
 * @param[in] 	  wLength   Length of package array.
 * @param[out] 	  pPackage  Pointer to package - output will be NULL terminated.
 *
 * @return Number of bytes written into output buffer
 */
extern uint16_t NDEF_Rec_Aar_GetPackage(NDEF_Rec_Aar_t * pRecord, uint16_t  wLength , uint8_t * pPackage);

/** @}
* end of Aar Android Application Record
*/


#endif /* NDEF_REC_AAR_H_ */
