/*
*                    Copyright (c), NXP Semiconductors
*
*                       (C) NXP Semiconductors 2018
*
*         All rights are reserved. Reproduction in whole or in part is
*        prohibited without the written consent of the copyright owner.
*    NXP reserves the right to make changes without notice at any time.
*   NXP makes no warranty, expressed, implied or statutory, including but
*   not limited to any implied warranty of merchantability or fitness for any
*  particular purpose, or that the use will not infringe any third party patent,
*   copyright or trademark. NXP must not be liable for any loss or damage
*                            arising from its use.
*/

#ifndef NDEF_STATUS_H_
#define NDEF_STATUS_H_

#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */


#include <stdint.h>


#define RETURN_NULL_ON_NULL(x) if((x)==NULL){ return NULL;}
#define RETURN_ON_NULL_MEMBER(x) if((x)==NULL){ return NDEF_STATUS_ERROR_NULL_PTR;}
#define RETURN_ON_NULL_PARAM(x) if((x)==NULL){ return NDEF_STATUS_ERROR_INVALID_PARAM;}
#define BREAK_ON_NULL(x,y) if((x)==NULL){ (y)=ERROR_OCURRED; break;}
#define BREAK_ON_FAILURE(x) if((x)!=NDEF_STATUS_SUCCESS) {break;}

#define  NDEF_STATUS_SUCCESS                    0x0
#define  NDEF_STATUS_ERROR                      0x1
#define  NDEF_STATUS_ERROR_INVALID_PARAM        0x2
#define  NDEF_STATUS_ERROR_NULL_PTR             0x3
#define  NDEF_STATUS_ERROR_BUFF_OVF             0x4


 typedef uint8_t Status_t;

#ifdef __cplusplus
} /* Extern C */
#endif


#endif /* NDEF_STATUS_H_ */
