/*
 * Decompiled with CFR 0.152.
 */
package org.ndeftools.wellknown;

import android.nfc.FormatException;
import android.nfc.NdefRecord;
import org.ndeftools.Message;
import org.ndeftools.Record;
import org.ndeftools.wellknown.ActionRecord;
import org.ndeftools.wellknown.TextRecord;
import org.ndeftools.wellknown.UriRecord;

public class SmartPosterRecord
extends Record {
    private TextRecord title;
    private UriRecord uri;
    private ActionRecord action;

    public static SmartPosterRecord parseNdefRecord(NdefRecord ndefRecord) throws FormatException {
        byte[] payload = ndefRecord.getPayload();
        SmartPosterRecord.normalizeMessageBeginEnd(payload);
        SmartPosterRecord smartPosterRecord = new SmartPosterRecord();
        if (payload.length > 0) {
            Message records = Message.parseNdefMessage(payload);
            for (Record record : records) {
                if (record instanceof UriRecord) {
                    smartPosterRecord.setUri((UriRecord)record);
                    continue;
                }
                if (record instanceof TextRecord) {
                    smartPosterRecord.setTitle((TextRecord)record);
                    continue;
                }
                if (!(record instanceof ActionRecord)) continue;
                smartPosterRecord.setAction((ActionRecord)record);
            }
        }
        return smartPosterRecord;
    }

    public SmartPosterRecord(TextRecord title, UriRecord uri, ActionRecord action) {
        this.title = title;
        this.uri = uri;
        this.action = action;
    }

    public SmartPosterRecord() {
    }

    public TextRecord getTitle() {
        return this.title;
    }

    public void setTitle(TextRecord title) {
        this.title = title;
    }

    public UriRecord getUri() {
        return this.uri;
    }

    public void setUri(UriRecord uri) {
        this.uri = uri;
    }

    public ActionRecord getAction() {
        return this.action;
    }

    public void setAction(ActionRecord action) {
        this.action = action;
    }

    public boolean hasTitle() {
        return this.title != null;
    }

    public boolean hasUri() {
        return this.uri != null;
    }

    public boolean hasAction() {
        return this.action != null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.action == null ? 0 : this.action.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SmartPosterRecord other = (SmartPosterRecord)obj;
        if (this.action == null ? other.action != null : !this.action.equals(other.action)) {
            return false;
        }
        if (this.title == null ? other.title != null : !this.title.equals(other.title)) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }

    @Override
    public NdefRecord getNdefRecord() {
        Message message = new Message();
        if (this.hasTitle()) {
            message.add(this.title);
        }
        if (this.hasUri()) {
            message.add(this.uri);
        }
        if (this.hasAction()) {
            message.add(this.action);
        }
        return new NdefRecord(1, NdefRecord.RTD_SMART_POSTER, this.id != null ? this.id : this.EMPTY, message.getNdefMessage().toByteArray());
    }
}

