/*
 * Decompiled with CFR 0.152.
 */
package org.ndeftools.wellknown;

import android.nfc.FormatException;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import java.util.ArrayList;
import org.ndeftools.Message;
import org.ndeftools.Record;
import org.ndeftools.wellknown.GcActionRecord;
import org.ndeftools.wellknown.GcDataRecord;
import org.ndeftools.wellknown.GcTargetRecord;

public class GenericControlRecord
extends Record {
    private static final byte CB_CHECK_EXIT_CONDITION = 2;
    private static final byte CB_IGNORE_FOLLOWING_IF_FAILED = 4;
    public static byte[] type = new byte[]{71, 99};
    private byte configurationByte;
    private GcTargetRecord target;
    private GcActionRecord action;
    private GcDataRecord data;

    public static GenericControlRecord parseNdefRecord(NdefRecord ndefRecord) throws FormatException {
        byte[] payload = ndefRecord.getPayload();
        GenericControlRecord.normalizeMessageBeginEnd(payload, 1, payload.length - 1);
        Message payloadNdefMessage = Message.parseNdefMessage(payload, 1, payload.length - 1);
        GenericControlRecord genericControlRecord = new GenericControlRecord();
        genericControlRecord.setConfigurationByte(payload[0]);
        for (Record record : payloadNdefMessage) {
            if (record instanceof GcTargetRecord) {
                genericControlRecord.setTarget((GcTargetRecord)record);
                continue;
            }
            if (record instanceof GcActionRecord) {
                genericControlRecord.setAction((GcActionRecord)record);
                continue;
            }
            if (record instanceof GcDataRecord) {
                genericControlRecord.setData((GcDataRecord)record);
                continue;
            }
            throw new IllegalArgumentException("Unexpected record " + record.getClass().getName());
        }
        if (!genericControlRecord.hasTarget()) {
            throw new IllegalArgumentException("Expected target record");
        }
        return genericControlRecord;
    }

    public GenericControlRecord(GcTargetRecord target, byte configurationByte) {
        this.target = target;
        this.configurationByte = configurationByte;
    }

    public GenericControlRecord(byte configurationByte, GcTargetRecord target, GcActionRecord action, GcDataRecord data) {
        this.configurationByte = configurationByte;
        this.target = target;
        this.action = action;
        this.data = data;
    }

    public GenericControlRecord() {
    }

    public void setConfigurationByte(byte configurationByte) {
        this.configurationByte = configurationByte;
    }

    public byte getConfigurationByte() {
        return this.configurationByte;
    }

    public boolean isIgnoreFollowingIfFailed() {
        return (this.configurationByte & 4) != 0;
    }

    public void setIgnoreFollowingIfFailed() {
        this.configurationByte = (byte)(this.configurationByte | 4);
    }

    public boolean isCheckExitCondition() {
        return (this.configurationByte & 2) != 0;
    }

    public void setCheckExitCondition() {
        this.configurationByte = (byte)(this.configurationByte | 2);
    }

    public GcTargetRecord getTarget() {
        return this.target;
    }

    public void setTarget(GcTargetRecord target) {
        this.target = target;
    }

    public GcActionRecord getAction() {
        return this.action;
    }

    public void setAction(GcActionRecord action) {
        this.action = action;
    }

    public GcDataRecord getData() {
        return this.data;
    }

    public void setData(GcDataRecord data) {
        this.data = data;
    }

    public boolean hasTarget() {
        return this.target != null;
    }

    public boolean hasAction() {
        return this.action != null;
    }

    public boolean hasData() {
        return this.data != null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.action == null ? 0 : this.action.hashCode());
        result = 31 * result + this.configurationByte;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericControlRecord other = (GenericControlRecord)obj;
        if (this.action == null ? other.action != null : !this.action.equals(other.action)) {
            return false;
        }
        if (this.configurationByte != other.configurationByte) {
            return false;
        }
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        return !(this.target == null ? other.target != null : !this.target.equals(other.target));
    }

    @Override
    public NdefRecord getNdefRecord() {
        if (!this.hasTarget()) {
            throw new IllegalArgumentException("Expected target");
        }
        ArrayList<NdefRecord> records = new ArrayList<NdefRecord>();
        records.add(this.target.getNdefRecord());
        if (this.hasAction()) {
            records.add(this.action.getNdefRecord());
        }
        if (this.hasData()) {
            records.add(this.data.getNdefRecord());
        }
        byte[] array = new NdefMessage(records.toArray(new NdefRecord[records.size()])).toByteArray();
        byte[] payload = new byte[array.length + 1];
        payload[0] = this.configurationByte;
        System.arraycopy(array, 0, payload, 1, array.length);
        return new NdefRecord(1, type, this.id != null ? this.id : this.EMPTY, payload);
    }
}

