/*
 * Decompiled with CFR 0.152.
 */
package org.ndeftools.wellknown;

import android.annotation.SuppressLint;
import android.nfc.FormatException;
import android.nfc.NdefRecord;
import org.ndeftools.Record;
import org.ndeftools.wellknown.TextRecord;
import org.ndeftools.wellknown.UriRecord;

@SuppressLint(value={"NewApi"})
public class GcTargetRecord
extends Record {
    public static byte[] type = new byte[]{116};
    private Record targetIdentifier;

    public static GcTargetRecord parseNdefRecord(NdefRecord ndefRecord) throws FormatException {
        return new GcTargetRecord(GcTargetRecord.parse(ndefRecord.getPayload()));
    }

    public GcTargetRecord(Record targetIdentifier) {
        this.setTargetIdentifier(targetIdentifier);
    }

    public GcTargetRecord() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTargetIdentifier(Record targetIdentifier) {
        if (targetIdentifier != null) {
            if (!(targetIdentifier instanceof UriRecord) && !(targetIdentifier instanceof TextRecord)) throw new IllegalArgumentException("Expected " + TextRecord.class.getSimpleName() + " or " + UriRecord.class.getSimpleName() + " target identifier, not " + targetIdentifier.getClass().getName() + ".");
            this.targetIdentifier = targetIdentifier;
            return;
        } else {
            this.targetIdentifier = null;
        }
    }

    public Record getTargetIdentifier() {
        return this.targetIdentifier;
    }

    public boolean hasTargetIdentifier() {
        return this.targetIdentifier != null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.targetIdentifier == null ? 0 : this.targetIdentifier.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GcTargetRecord other = (GcTargetRecord)obj;
        return !(this.targetIdentifier == null ? other.targetIdentifier != null : !this.targetIdentifier.equals(other.targetIdentifier));
    }

    @Override
    public NdefRecord getNdefRecord() {
        if (!this.hasTargetIdentifier()) {
            throw new IllegalArgumentException("Expected target identifier");
        }
        return new NdefRecord(1, type, this.id != null ? this.id : this.EMPTY, this.targetIdentifier.toByteArray());
    }
}

