/*
 * Decompiled with CFR 0.152.
 */
package org.ndeftools.wellknown;

import android.annotation.SuppressLint;
import android.nfc.FormatException;
import android.nfc.NdefRecord;
import org.ndeftools.Record;
import org.ndeftools.wellknown.Action;

@SuppressLint(value={"NewApi"})
public class GcActionRecord
extends Record {
    public static byte[] type = new byte[]{97};
    public static final byte NUMERIC_CODE = 1;
    private Action action;
    private Record actionRecord;

    public static GcActionRecord parseNdefRecord(NdefRecord ndefRecord) throws FormatException {
        byte[] payload = ndefRecord.getPayload();
        if ((payload[0] & 1) != 0) {
            return new GcActionRecord(Action.getActionByValue(payload[1]));
        }
        return new GcActionRecord(Record.parse(payload, 1, payload.length - 1));
    }

    public GcActionRecord(Record actionRecord) {
        this.actionRecord = actionRecord;
    }

    public GcActionRecord(Action action) {
        this.action = action;
    }

    public GcActionRecord() {
    }

    public boolean hasActionRecord() {
        return this.actionRecord != null;
    }

    public boolean hasAction() {
        return this.action != null;
    }

    public Action getAction() {
        return this.action;
    }

    public void setActionRecord(Record actionRecord) {
        this.actionRecord = actionRecord;
    }

    public Record getActionRecord() {
        return this.actionRecord;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.action == null ? 0 : this.action.hashCode());
        result = 31 * result + (this.actionRecord == null ? 0 : this.actionRecord.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GcActionRecord other = (GcActionRecord)obj;
        if (this.action != other.action) {
            return false;
        }
        return !(this.actionRecord == null ? other.actionRecord != null : !this.actionRecord.equals(other.actionRecord));
    }

    @Override
    public NdefRecord getNdefRecord() {
        byte[] payload = null;
        if (this.hasAction() && this.hasActionRecord()) {
            throw new IllegalArgumentException("Expected action or action record, not both.");
        }
        if (this.hasAction()) {
            payload = new byte[]{1, this.action.getValue()};
        } else if (this.hasActionRecord()) {
            byte[] subPayload = this.actionRecord.toByteArray();
            payload = new byte[subPayload.length + 1];
            payload[0] = 0;
            System.arraycopy(subPayload, 0, payload, 1, subPayload.length);
        } else {
            throw new IllegalArgumentException("Expected action or action record.");
        }
        return new NdefRecord(1, type, this.id != null ? this.id : this.EMPTY, payload);
    }
}

