/*
 * Decompiled with CFR 0.152.
 */
package org.ndeftools.externaltype;

import android.annotation.SuppressLint;
import android.nfc.FormatException;
import android.nfc.NdefRecord;
import android.os.Build;
import java.nio.charset.Charset;
import java.util.Locale;
import org.ndeftools.Record;
import org.ndeftools.externaltype.AndroidApplicationRecord;
import org.ndeftools.externaltype.GenericExternalTypeRecord;

public abstract class ExternalTypeRecord
extends Record {
    public static ExternalTypeRecord parse(NdefRecord ndefRecord) {
        String type;
        String domain;
        String domainType = new String(ndefRecord.getType(), Charset.forName("UTF-8"));
        int colon = domainType.lastIndexOf(58);
        if (colon == -1) {
            domain = domainType;
            type = null;
        } else {
            domain = domainType.substring(0, colon);
            type = colon + 1 < domainType.length() ? domainType.substring(colon + 1) : "";
        }
        if (domain.equals("android.com") && type.equals("pkg")) {
            return new AndroidApplicationRecord(ndefRecord.getPayload());
        }
        return new GenericExternalTypeRecord(domain, type, ndefRecord.getPayload());
    }

    public abstract String getDomain();

    public abstract String getType();

    public abstract byte[] getData();

    @Override
    @SuppressLint(value={"NewApi"})
    public NdefRecord getNdefRecord() {
        if (Build.VERSION.SDK_INT >= 16) {
            return NdefRecord.createExternal((String)this.getDomain(), (String)this.getType(), (byte[])this.getData());
        }
        return this.createExternal(this.getDomain(), this.getType(), this.getData());
    }

    @Deprecated
    private NdefRecord createExternal(String domain, String type, byte[] data) {
        if (domain == null) {
            throw new NullPointerException("domain is null");
        }
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        domain = domain.trim().toLowerCase(Locale.US);
        type = type.trim().toLowerCase(Locale.US);
        if (domain.length() == 0) {
            throw new IllegalArgumentException("domain is empty");
        }
        if (type.length() == 0) {
            throw new IllegalArgumentException("type is empty");
        }
        byte[] byteDomain = domain.getBytes(Charset.forName("UTF_8"));
        byte[] byteType = type.getBytes(Charset.forName("UTF_8"));
        byte[] b = new byte[byteDomain.length + 1 + byteType.length];
        System.arraycopy(byteDomain, 0, b, 0, byteDomain.length);
        b[byteDomain.length] = 58;
        System.arraycopy(byteType, 0, b, byteDomain.length + 1, byteType.length);
        return new NdefRecord(4, b, this.EMPTY, data != null ? data : this.EMPTY);
    }

    public static /* bridge */ /* synthetic */ Record parse(NdefRecord ndefRecord) throws FormatException {
        return ExternalTypeRecord.parse(ndefRecord);
    }
}

