/*
 * Decompiled with CFR 0.152.
 */
package org.ndeftools;

import android.nfc.NdefRecord;
import org.ndeftools.Record;

public class UnknownRecord
extends Record {
    private byte[] payload;

    public static Record parse(NdefRecord ndefRecord) {
        byte[] type = ndefRecord.getType();
        if (type != null && type.length > 0) {
            throw new IllegalArgumentException("Record type not expected");
        }
        return new UnknownRecord(ndefRecord.getPayload());
    }

    public UnknownRecord(byte[] payload) {
        this.payload = payload;
    }

    public UnknownRecord() {
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    public boolean hasPayload() {
        return this.payload != null;
    }

    @Override
    public NdefRecord getNdefRecord() {
        return new NdefRecord(5, this.EMPTY, this.id != null ? this.id : this.EMPTY, this.payload != null ? this.payload : this.EMPTY);
    }
}

