/*
 * Decompiled with CFR 0.152.
 */
package org.ndeftools;

import android.nfc.FormatException;
import android.nfc.NdefRecord;
import java.nio.charset.Charset;
import org.ndeftools.Record;

public class AbsoluteUriRecord
extends Record {
    public static final byte[] TYPE = new byte[]{85};
    private String uri;

    public static AbsoluteUriRecord parse(NdefRecord ndefRecord) {
        return new AbsoluteUriRecord(new String(ndefRecord.getPayload(), Charset.forName("US-ASCII")));
    }

    public AbsoluteUriRecord(String uri) {
        this.uri = uri;
    }

    public AbsoluteUriRecord() {
    }

    public String getUri() {
        return this.uri;
    }

    public boolean hasUri() {
        return this.uri != null;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbsoluteUriRecord other = (AbsoluteUriRecord)obj;
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }

    @Override
    public NdefRecord getNdefRecord() {
        if (!this.hasUri()) {
            throw new IllegalArgumentException("Expected URI");
        }
        return new NdefRecord(3, TYPE, this.id != null ? this.id : this.EMPTY, this.uri.getBytes(Charset.forName("US-ASCII")));
    }

    public static /* bridge */ /* synthetic */ Record parse(NdefRecord ndefRecord) throws FormatException {
        return AbsoluteUriRecord.parse(ndefRecord);
    }
}

