/*
 * File:		flexcan_main.c
 * Purpose:		Flexcan Examples
 *
 * License:     All software covered by license agreement in -
 *              docs/Freescale_Software_License.pdf
 */

#include "common.h"
#include "flexcan.h"
#include "flexcan_example.h"

typedef int8 (* example_fuct) (void);

/*
 * Functions Available
 */
example_fuct example_functions[]={flexcan_baudrate,
                                  flexcan_loopback,
                                  flexcan_MB0txnoerrpoll,
                                  flexcan_MBxtxnoerrpoll,
                                  flexcan_MBxtxnoerrint,
                                  //flexcan_MBxrxnoerrpoll,
                                  //flexcan_MBxrxnoerrint,
                                  flexcan_MBxfilterrxnoerrint,
                                  flexcan_errpoll,
						         };

/********************************************************************/
void 
main (void)
{
	uint8 i;
	uint8 u8Continue =0;
	
    /* Global interrupt enable */

	printf("\"FlexCAN\" module examples on Kirin\n");
	
    /* FlexCAN Basic Initialization */
    FlexCANInit();

    mcf5xxx_wr_sr(0x2000);

    do{
    for (i=0;i<sizeof(example_functions)/sizeof(example_functions[0]);i++)
    {
        if (example_functions[i]() != 0x00)
        {
            printf ("Example #%d Failed!! \n", i);
        }
        else{
            printf ("Example #%d OK \n", i);
        }
    }
 
    printf ("Press 'Y' to repeat test\n");
    u8Continue = in_char();
    }while (u8Continue == 'Y' || u8Continue == 'y');

    printf ("--------------------------\n");
    printf ("End of FlexCAN Examples\n");

    
}

/********************************************************************/
	
