/*
 * File:		common.h
 * Purpose:		File to be included by all project files
 *
 * Notes:
 * 
 * License:     All software covered by license agreement in -
 *              docs/Freescale_Software_License.pdf
 */

#ifndef _COMMON_H_
#define _COMMON_H_

/********************************************************************/

/*
 * Debug prints ON (#define) or OFF (#undef)
 */
#undef DEBUG_PRINT
#undef DEBUG_PRINT_D0D1

/* 
 * Include the generic CPU header file 
 */
#include "mcf5xxx.h"

/* 
 * Include the specific CPU header file 
 */
#include "mcf5213.h"

/* 
 * Include the board specific header file 
 */
#if (defined(M5213EVB))
#include "m5213evb/m5213evb.h"
#elif (defined(M5211DEMO))
#include "m5211demo/m5211demo.h"
#elif (defined(M5213P))
#include "m5213p/m5213p.h"
#else
#error "No valid platform defined"
#endif

/* 
 * Include any toolchain specfic header files 
 */
#if (defined(__CWCC__))
#include "build/cw/cw.h"
#elif (defined(__DCC__))
#include "build/wrs/diab.h"
#elif (defined(__ghs__))
#include "build/ghs/ghs.h"
#endif

/* 
 * Include common utilities
 */
#include "assert.h"
#include "io.h"
#include "stdlib.h"

/********************************************************************/

#endif /* _COMMON_H_ */
