/*
 * Copyright (c) 2014 - 2015, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_iMX6SX_REGISTERS_H__
#define __HW_iMX6SX_REGISTERS_H__

#include "fsl_bitaccess.h"

/*
 * iMX6SX ADC
 *
 * Analog-to-Digital Converter
 *
 * Registers defined in this header file:
 * - HW_ADC_HC0 - Control register for hardware triggers
 * - HW_ADC_HC1 - Control register for hardware triggers
 * - HW_ADC_HS - Status register for HW triggers
 * - HW_ADC_R0 - Data result register for HW triggers
 * - HW_ADC_R1 - Data result register for HW triggers
 * - HW_ADC_CFG - Configuration register
 * - HW_ADC_GC - General control register
 * - HW_ADC_GS - General status register
 * - HW_ADC_CV - Compare value register
 * - HW_ADC_OFS - Offset correction value register
 * - HW_ADC_CAL - Calibration value register
 *
 * - hw_adc_t - Struct containing all module registers.
 */

#define HW_ADC_INSTANCE_COUNT (2U) /*!< Number of instances of the ADC module. */
#define HW_ADC1 (0U) /*!< Instance number for ADC1. */
#define HW_ADC2 (1U) /*!< Instance number for ADC2. */
#define ADC1_BASE             (0x2280000U) /*!< Base address for ADC1. */
#define ADC2_BASE             (0x2284000U) /*!< Base address for ADC2. */
/*! Array initializer of ADC base addresses. */
#define ADC_BASE_ADDRS        { ADC1_BASE, ADC2_BASE }

/*******************************************************************************
 * HW_ADC_HC0 - Control register for hardware triggers
 ******************************************************************************/

/*!
 * @brief HW_ADC_HC0 - Control register for hardware triggers (RW)
 *
 * Reset value: 0x0000001FU
 *
 * ADC_HC0 can be used for both software and hardware trigger mode. Other
 * ADC_HCn(n=1..) are for use only in hardware trigger mode. The ADC_HC0 to
 * ADC_HCn(n=0,1) registers have identical fields, and are used to control ADC operation. At
 * any one point in time, only one of the ADC_HC0 to ADC_HCn(n=0,1) registers is
 * actively controlling ADC conversions. Updating ADC_HC0 while ADC_HCn(n=0,1)
 * is actively controlling a conversion is allowed (and vice-versa for any of the
 * ADC_HCn (n=0,1) registers). Writing ADC_HC0 while ADC_HC0 is actively
 * controlling a conversion aborts the current conversion. In software trigger mode
 * (ADTRG=0), writes to ADC_HC0 subsequently initiates a new conversion (if the ADCH
 * bits are equal to a value other than all 1s). Similarly, writing any of the
 * ADC_HCn(n=0,1) registers while that specific ADC_HC register is actively
 * controlling a conversion aborts the current conversion. ADC_HC1 register is not used
 * for software trigger operation and therefore writes to any of them do not
 * initiate a new conversion.
 */
typedef union _hw_adc_hc0
{
    uint32_t U;
    struct _hw_adc_hc0_bitfields
    {
        uint32_t ADCH : 5;             /*!< [4:0] Input Channel Select */
        uint32_t RESERVED0 : 2;        /*!< [6:5]  */
        uint32_t AIEN : 1;             /*!< [7] Conversion Complete Interrupt
                                        * Enable/Disable Control */
        uint32_t RESERVED1 : 24;       /*!< [31:8]  */
    } B;
} hw_adc_hc0_t;

/*!
 * @name Constants and macros for entire ADC_HC0 register
 */
/*@{*/
#define HW_ADC_HC0_ADDR(x)       ((uintptr_t)(x) + 0x0U)

#define HW_ADC_HC0(x)            (*(__IO hw_adc_hc0_t *) HW_ADC_HC0_ADDR(x))
#define HW_ADC_HC0_RD(x)         (HW_ADC_HC0(x).U)
#define HW_ADC_HC0_WR(x, v)      (HW_ADC_HC0(x).U = (v))
#define HW_ADC_HC0_SET(x, v)     (HW_ADC_HC0_WR(x, HW_ADC_HC0_RD(x) |  (v)))
#define HW_ADC_HC0_CLR(x, v)     (HW_ADC_HC0_WR(x, HW_ADC_HC0_RD(x) & ~(v)))
#define HW_ADC_HC0_TOG(x, v)     (HW_ADC_HC0_WR(x, HW_ADC_HC0_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ADC_HC0 bitfields
 */

/*!
 * @name Register ADC_HC0, field ADCH[4:0] (RW)
 *
 * This 5-bit field selects one of the input channels. The successive
 * approximation converter subsystem is turned off when the channel select bits are all set
 * (ADCH = 11111b). This feature allows for explicit disabling of the ADC and
 * isolation of the input channel from all sources. Terminating continuous
 * conversions this way prevents an additional single conversion from being performed.
 *
 * Values:
 * - 11000 - Reserved.
 * - 11001 - VREFSH = internal channel, for ADC self-test, hard connected to VRH
 *     internally
 * - 11010 - Reserved.
 * - 11011 - Reserved.
 * - 11111 - Conversion Disabled. Hardware Triggers will not initiate any
 *     conversion.
 */
/*@{*/
#define BP_ADC_HC0_ADCH      (0U)          /*!< Bit position for ADC_HC0_ADCH. */
#define BM_ADC_HC0_ADCH      (0x0000001FU) /*!< Bit mask for ADC_HC0_ADCH. */
#define BS_ADC_HC0_ADCH      (5U)          /*!< Bit field size in bits for ADC_HC0_ADCH. */

/*! @brief Read current value of the ADC_HC0_ADCH field. */
#define BR_ADC_HC0_ADCH(x)   (HW_ADC_HC0(x).B.ADCH)

/*! @brief Format value for bitfield ADC_HC0_ADCH. */
#define BF_ADC_HC0_ADCH(v)   ((uint32_t)((uint32_t)(v) << BP_ADC_HC0_ADCH) & BM_ADC_HC0_ADCH)

/*! @brief Set the ADCH field to a new value. */
#define BW_ADC_HC0_ADCH(x, v) (HW_ADC_HC0_WR(x, (HW_ADC_HC0_RD(x) & ~BM_ADC_HC0_ADCH) | BF_ADC_HC0_ADCH(v)))
/*@}*/

/*!
 * @name Register ADC_HC0, field AIEN[7] (RW)
 *
 * An interrupt is generated whenever ADC_HS[COCO0]=1 (conversion ADC_HC0
 * completed), provided the corresponding interrupt is enabled.
 *
 * Values:
 * - 1 - Conversion complete interrupt enabled
 * - 0 - Conversion complete interrupt disabled
 */
/*@{*/
#define BP_ADC_HC0_AIEN      (7U)          /*!< Bit position for ADC_HC0_AIEN. */
#define BM_ADC_HC0_AIEN      (0x00000080U) /*!< Bit mask for ADC_HC0_AIEN. */
#define BS_ADC_HC0_AIEN      (1U)          /*!< Bit field size in bits for ADC_HC0_AIEN. */

/*! @brief Read current value of the ADC_HC0_AIEN field. */
#define BR_ADC_HC0_AIEN(x)   (HW_ADC_HC0(x).B.AIEN)

/*! @brief Format value for bitfield ADC_HC0_AIEN. */
#define BF_ADC_HC0_AIEN(v)   ((uint32_t)((uint32_t)(v) << BP_ADC_HC0_AIEN) & BM_ADC_HC0_AIEN)

/*! @brief Set the AIEN field to a new value. */
#define BW_ADC_HC0_AIEN(x, v) (HW_ADC_HC0_WR(x, (HW_ADC_HC0_RD(x) & ~BM_ADC_HC0_AIEN) | BF_ADC_HC0_AIEN(v)))
/*@}*/

/*******************************************************************************
 * HW_ADC_HC1 - Control register for hardware triggers
 ******************************************************************************/

/*!
 * @brief HW_ADC_HC1 - Control register for hardware triggers (RW)
 *
 * Reset value: 0x0000001FU
 *
 * ADC_HC1 are for use only in hardware trigger mode. The ADC_HC0 to ADC_HCn
 * registers have identical fields, and are used to control ADC operation. At any
 * one point in time, only one of the ADC_HC0 to ADC_HCn registers is actively
 * controlling ADC conversions. Updating ADC_HC0 while ADC_HCn is actively
 * controlling a conversion is allowed (and vice-versa for any of the ADC_HCn registers).
 * Writing any of the ADC_HCn registers while that specific ADC_HCn register is
 * actively controlling a conversion aborts the current conversion. Any of the
 * ADC_HC1 - ADC_HCn registers are not used for software trigger operation and
 * therefore writes to any of them do not initiate a new conversion.
 */
typedef union _hw_adc_hc1
{
    uint32_t U;
    struct _hw_adc_hc1_bitfields
    {
        uint32_t ADCH : 5;             /*!< [4:0] Input Channel Select */
        uint32_t RESERVED0 : 2;        /*!< [6:5]  */
        uint32_t AIEN : 1;             /*!< [7] Conversion Complete Interrupt
                                        * Enable/Disable Control */
        uint32_t RESERVED1 : 24;       /*!< [31:8]  */
    } B;
} hw_adc_hc1_t;

/*!
 * @name Constants and macros for entire ADC_HC1 register
 */
/*@{*/
#define HW_ADC_HC1_ADDR(x)       ((uintptr_t)(x) + 0x4U)

#define HW_ADC_HC1(x)            (*(__IO hw_adc_hc1_t *) HW_ADC_HC1_ADDR(x))
#define HW_ADC_HC1_RD(x)         (HW_ADC_HC1(x).U)
#define HW_ADC_HC1_WR(x, v)      (HW_ADC_HC1(x).U = (v))
#define HW_ADC_HC1_SET(x, v)     (HW_ADC_HC1_WR(x, HW_ADC_HC1_RD(x) |  (v)))
#define HW_ADC_HC1_CLR(x, v)     (HW_ADC_HC1_WR(x, HW_ADC_HC1_RD(x) & ~(v)))
#define HW_ADC_HC1_TOG(x, v)     (HW_ADC_HC1_WR(x, HW_ADC_HC1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ADC_HC1 bitfields
 */

/*!
 * @name Register ADC_HC1, field ADCH[4:0] (RW)
 *
 * This 5-bit field selects one of the input channels. The successive
 * approximation converter subsystem is turned off when the channel select bits are all set
 * (ADCH =11111b). This feature allows for explicit disabling of the ADC and
 * isolation of the input channel from all sources. Terminating continuous
 * conversions this way prevents an additional single conversion from being performed.
 *
 * Values:
 * - 11000 - Reserved.
 * - 11001 - VREFSH = internal channel, for ADC self-test, hard connected to VRH
 *     internally
 * - 11010 - Reserved.
 * - 11011 - Reserved.
 * - 11111 - Conversion Disabled. Hardware Triggers will not initiate any
 *     conversion.
 */
/*@{*/
#define BP_ADC_HC1_ADCH      (0U)          /*!< Bit position for ADC_HC1_ADCH. */
#define BM_ADC_HC1_ADCH      (0x0000001FU) /*!< Bit mask for ADC_HC1_ADCH. */
#define BS_ADC_HC1_ADCH      (5U)          /*!< Bit field size in bits for ADC_HC1_ADCH. */

/*! @brief Read current value of the ADC_HC1_ADCH field. */
#define BR_ADC_HC1_ADCH(x)   (HW_ADC_HC1(x).B.ADCH)

/*! @brief Format value for bitfield ADC_HC1_ADCH. */
#define BF_ADC_HC1_ADCH(v)   ((uint32_t)((uint32_t)(v) << BP_ADC_HC1_ADCH) & BM_ADC_HC1_ADCH)

/*! @brief Set the ADCH field to a new value. */
#define BW_ADC_HC1_ADCH(x, v) (HW_ADC_HC1_WR(x, (HW_ADC_HC1_RD(x) & ~BM_ADC_HC1_ADCH) | BF_ADC_HC1_ADCH(v)))
/*@}*/

/*!
 * @name Register ADC_HC1, field AIEN[7] (RW)
 *
 * An interrupt is generated whenever ADC_HS[COCO0]=1(conversion ADC_HC0
 * completed), provided the corresponding interrupt is enabled.
 *
 * Values:
 * - 1 - Conversion complete interrupt enabled
 * - 0 - Conversion complete interrupt disabled
 */
/*@{*/
#define BP_ADC_HC1_AIEN      (7U)          /*!< Bit position for ADC_HC1_AIEN. */
#define BM_ADC_HC1_AIEN      (0x00000080U) /*!< Bit mask for ADC_HC1_AIEN. */
#define BS_ADC_HC1_AIEN      (1U)          /*!< Bit field size in bits for ADC_HC1_AIEN. */

/*! @brief Read current value of the ADC_HC1_AIEN field. */
#define BR_ADC_HC1_AIEN(x)   (HW_ADC_HC1(x).B.AIEN)

/*! @brief Format value for bitfield ADC_HC1_AIEN. */
#define BF_ADC_HC1_AIEN(v)   ((uint32_t)((uint32_t)(v) << BP_ADC_HC1_AIEN) & BM_ADC_HC1_AIEN)

/*! @brief Set the AIEN field to a new value. */
#define BW_ADC_HC1_AIEN(x, v) (HW_ADC_HC1_WR(x, (HW_ADC_HC1_RD(x) & ~BM_ADC_HC1_AIEN) | BF_ADC_HC1_AIEN(v)))
/*@}*/

/*******************************************************************************
 * HW_ADC_HS - Status register for HW triggers
 ******************************************************************************/

/*!
 * @brief HW_ADC_HS - Status register for HW triggers (RO)
 *
 * Reset value: 0x00000000U
 *
 * Bit 0 is used for both software and hardware trigger modes of operation. Bit
 * 1 to bit (n-1) indicate the rest of the HW triggers' statuses similar to bit
 * 0, potentially corresponding to multiple ADC_HC registers (for use only in
 * hardware trigger mode).
 */
typedef union _hw_adc_hs
{
    uint32_t U;
    struct _hw_adc_hs_bitfields
    {
        uint32_t COCO0 : 1;            /*!< [0] Conversion Complete Flag */
        uint32_t COCO1 : 1;            /*!< [1]  */
        uint32_t RESERVED0 : 30;       /*!< [31:2]  */
    } B;
} hw_adc_hs_t;

/*!
 * @name Constants and macros for entire ADC_HS register
 */
/*@{*/
#define HW_ADC_HS_ADDR(x)        ((uintptr_t)(x) + 0x8U)

#define HW_ADC_HS(x)             (*(__I hw_adc_hs_t *) HW_ADC_HS_ADDR(x))
#define HW_ADC_HS_RD(x)          (HW_ADC_HS(x).U)
/*@}*/

/*
 * Constants & macros for individual ADC_HS bitfields
 */

/*!
 * @name Register ADC_HS, field COCO0[0] (RO)
 *
 * The COCOn flag is a read-only bit that is set each time a conversion is
 * completed when the compare function is disabled (ADC_GC[ACFE]=0) and the hardware
 * average function is disabled (ADC_GC[AVGE]=0). When the compare function is
 * enabled (ADC_GC[ACFE]=1), the COCOn flag is set upon completion of a conversion
 * only if the compare result is true. When the hardware average function is
 * enabled (ADC_GC[AVGE]=1), the COCOn flag is set upon completion of the selected
 * number of conversions (determined by the ADC_CFG[AVGS] field). The COCO0 flag
 * will also set at the completion of a Calibration and Test sequence. A COCOn bit
 * is cleared when the respective ADC_HCn is written or when the respective ADC_Rn
 * is read.
 */
/*@{*/
#define BP_ADC_HS_COCO0      (0U)          /*!< Bit position for ADC_HS_COCO0. */
#define BM_ADC_HS_COCO0      (0x00000001U) /*!< Bit mask for ADC_HS_COCO0. */
#define BS_ADC_HS_COCO0      (1U)          /*!< Bit field size in bits for ADC_HS_COCO0. */

/*! @brief Read current value of the ADC_HS_COCO0 field. */
#define BR_ADC_HS_COCO0(x)   (HW_ADC_HS(x).B.COCO0)
/*@}*/

/*!
 * @name Register ADC_HS, field COCO1[1] (RO)
 *
 * See description for COCO0.
 */
/*@{*/
#define BP_ADC_HS_COCO1      (1U)          /*!< Bit position for ADC_HS_COCO1. */
#define BM_ADC_HS_COCO1      (0x00000002U) /*!< Bit mask for ADC_HS_COCO1. */
#define BS_ADC_HS_COCO1      (1U)          /*!< Bit field size in bits for ADC_HS_COCO1. */

/*! @brief Read current value of the ADC_HS_COCO1 field. */
#define BR_ADC_HS_COCO1(x)   (HW_ADC_HS(x).B.COCO1)
/*@}*/

/*******************************************************************************
 * HW_ADC_R0 - Data result register for HW triggers
 ******************************************************************************/

/*!
 * @brief HW_ADC_R0 - Data result register for HW triggers (RO)
 *
 * Reset value: 0x00000000U
 *
 * Contains the result of an ADC conversion of the channel selected by the
 * respective hardware trigger and channel control register (ADC_HC0:ADC_HCn). For
 * every ADC_HC0:ADC_HCn status and channel control register, there is a respective
 * ADC_R0:ADC_Rn data result register. Unused bits in the ADC_Rn register are
 * cleared in unsigned right justified modes. For example when configured for 10-bit
 * single-ended mode, D[31:10] are cleared. The table below describes the
 * behavior of the data result registers in the different modes of operation. Data
 * Result Register Description Conversion Mode Data Result Register bits Format D31
 * D30 ….. D12 D11 D10 D9 D8 D7 D6 D5 D4 D3 D2 D1 D0 12b single-ended 0 0 0 0 D
 * D D D D D D D D D D D unsigned right justified 10b single-ended 0 0 0 0 0 0 D
 * D D D D D D D D D unsigned right justified 8b single-ended 0 0 0 0 0 0 0 0 D D
 * D D D D D D unsigned right justified
 */
typedef union _hw_adc_r0
{
    uint32_t U;
    struct _hw_adc_r0_bitfields
    {
        uint32_t CDATA : 12;           /*!< [11:0] Data (result of an ADC conversion) */
        uint32_t RESERVED0 : 20;       /*!< [31:12]  */
    } B;
} hw_adc_r0_t;

/*!
 * @name Constants and macros for entire ADC_R0 register
 */
/*@{*/
#define HW_ADC_R0_ADDR(x)        ((uintptr_t)(x) + 0xCU)

#define HW_ADC_R0(x)             (*(__I hw_adc_r0_t *) HW_ADC_R0_ADDR(x))
#define HW_ADC_R0_RD(x)          (HW_ADC_R0(x).U)
/*@}*/

/*
 * Constants & macros for individual ADC_R0 bitfields
 */

/*!
 * @name Register ADC_R0, field CDATA[11:0] (RO)
 */
/*@{*/
#define BP_ADC_R0_CDATA      (0U)          /*!< Bit position for ADC_R0_CDATA. */
#define BM_ADC_R0_CDATA      (0x00000FFFU) /*!< Bit mask for ADC_R0_CDATA. */
#define BS_ADC_R0_CDATA      (12U)         /*!< Bit field size in bits for ADC_R0_CDATA. */

/*! @brief Read current value of the ADC_R0_CDATA field. */
#define BR_ADC_R0_CDATA(x)   (HW_ADC_R0(x).B.CDATA)
/*@}*/

/*******************************************************************************
 * HW_ADC_R1 - Data result register for HW triggers
 ******************************************************************************/

/*!
 * @brief HW_ADC_R1 - Data result register for HW triggers (RO)
 *
 * Reset value: 0x00000000U
 *
 * Contains the result of an ADC conversion of the channel selected by the
 * respective Hardware Trigger and channel control register (ADC_HC0:ADC_HCn). For
 * every ADC_HC0:ADC_HCn status and channel control register, there is a respective
 * ADC_R0 to ADC_Rn data result register. Unused bits in the ADC_Rn register are
 * cleared in unsigned right justified modes. For example when configured for
 * 10-bit single-ended mode, D[31:10] are cleared. The table below describes the
 * behavior of the data result registers in the different modes of operation. Data
 * Result Register Description Conversion Mode Data Result Register bits Format
 * D31 D30 ….. D12 D11 D10 D9 D8 D7 D6 D5 D4 D3 D2 D1 D0 12b single-ended 0 0 0 0
 * D D D D D D D D D D D D unsigned right justified 10b single-ended 0 0 0 0 0 0
 * D D D D D D D D D D unsigned right justified 8b single-ended 0 0 0 0 0 0 0 0
 * D D D D D D D D unsigned right justified
 */
typedef union _hw_adc_r1
{
    uint32_t U;
    struct _hw_adc_r1_bitfields
    {
        uint32_t CDATA : 12;           /*!< [11:0]  */
        uint32_t RESERVED0 : 20;       /*!< [31:12]  */
    } B;
} hw_adc_r1_t;

/*!
 * @name Constants and macros for entire ADC_R1 register
 */
/*@{*/
#define HW_ADC_R1_ADDR(x)        ((uintptr_t)(x) + 0x10U)

#define HW_ADC_R1(x)             (*(__I hw_adc_r1_t *) HW_ADC_R1_ADDR(x))
#define HW_ADC_R1_RD(x)          (HW_ADC_R1(x).U)
/*@}*/

/*
 * Constants & macros for individual ADC_R1 bitfields
 */

/*!
 * @name Register ADC_R1, field CDATA[11:0] (RO)
 *
 * Data (result of an ADC conversion)
 */
/*@{*/
#define BP_ADC_R1_CDATA      (0U)          /*!< Bit position for ADC_R1_CDATA. */
#define BM_ADC_R1_CDATA      (0x00000FFFU) /*!< Bit mask for ADC_R1_CDATA. */
#define BS_ADC_R1_CDATA      (12U)         /*!< Bit field size in bits for ADC_R1_CDATA. */

/*! @brief Read current value of the ADC_R1_CDATA field. */
#define BR_ADC_R1_CDATA(x)   (HW_ADC_R1(x).B.CDATA)
/*@}*/

/*******************************************************************************
 * HW_ADC_CFG - Configuration register
 ******************************************************************************/

/*!
 * @brief HW_ADC_CFG - Configuration register (RW)
 *
 * Reset value: 0x00000200U
 *
 * Selects the mode of operation, clock source, clock divide, configure for low
 * power, long sample time, high speed configuration and selects the sample time
 * duration.
 */
typedef union _hw_adc_cfg
{
    uint32_t U;
    struct _hw_adc_cfg_bitfields
    {
        uint32_t ADICLK : 2;           /*!< [1:0] Input Clock Select */
        uint32_t MODE : 2;             /*!< [3:2] Conversion Mode Selection */
        uint32_t ADLSMP : 1;           /*!< [4] Long Sample Time Configuration */
        uint32_t ADIV : 2;             /*!< [6:5] Clock Divide Select */
        uint32_t ADLPC : 1;            /*!< [7] Low-Power Configuration */
        uint32_t ADSTS : 2;            /*!< [9:8]  */
        uint32_t ADHSC : 1;            /*!< [10] High Speed Configuration */
        uint32_t REFSEL : 2;           /*!< [12:11] Voltage Reference Selection */
        uint32_t ADTRG : 1;            /*!< [13] Conversion Trigger Select */
        uint32_t AVGS : 2;             /*!< [15:14] Hardware Average select */
        uint32_t OVWREN : 1;           /*!< [16] Data Overwrite Enable */
        uint32_t RESERVED0 : 15;       /*!< [31:17]  */
    } B;
} hw_adc_cfg_t;

/*!
 * @name Constants and macros for entire ADC_CFG register
 */
/*@{*/
#define HW_ADC_CFG_ADDR(x)       ((uintptr_t)(x) + 0x14U)

#define HW_ADC_CFG(x)            (*(__IO hw_adc_cfg_t *) HW_ADC_CFG_ADDR(x))
#define HW_ADC_CFG_RD(x)         (HW_ADC_CFG(x).U)
#define HW_ADC_CFG_WR(x, v)      (HW_ADC_CFG(x).U = (v))
#define HW_ADC_CFG_SET(x, v)     (HW_ADC_CFG_WR(x, HW_ADC_CFG_RD(x) |  (v)))
#define HW_ADC_CFG_CLR(x, v)     (HW_ADC_CFG_WR(x, HW_ADC_CFG_RD(x) & ~(v)))
#define HW_ADC_CFG_TOG(x, v)     (HW_ADC_CFG_WR(x, HW_ADC_CFG_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ADC_CFG bitfields
 */

/*!
 * @name Register ADC_CFG, field ADICLK[1:0] (RW)
 *
 * Selects the input clock source to generate the internal clock ADCK.
 *
 * Values:
 * - 00 - IPG clock
 * - 01 - IPG clock divided by 2
 * - 10 - Alternate clock (ALTCLK)
 * - 11 - Asynchronous clock (ADACK)
 */
/*@{*/
#define BP_ADC_CFG_ADICLK    (0U)          /*!< Bit position for ADC_CFG_ADICLK. */
#define BM_ADC_CFG_ADICLK    (0x00000003U) /*!< Bit mask for ADC_CFG_ADICLK. */
#define BS_ADC_CFG_ADICLK    (2U)          /*!< Bit field size in bits for ADC_CFG_ADICLK. */

/*! @brief Read current value of the ADC_CFG_ADICLK field. */
#define BR_ADC_CFG_ADICLK(x) (HW_ADC_CFG(x).B.ADICLK)

/*! @brief Format value for bitfield ADC_CFG_ADICLK. */
#define BF_ADC_CFG_ADICLK(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CFG_ADICLK) & BM_ADC_CFG_ADICLK)

/*! @brief Set the ADICLK field to a new value. */
#define BW_ADC_CFG_ADICLK(x, v) (HW_ADC_CFG_WR(x, (HW_ADC_CFG_RD(x) & ~BM_ADC_CFG_ADICLK) | BF_ADC_CFG_ADICLK(v)))
/*@}*/

/*!
 * @name Register ADC_CFG, field MODE[3:2] (RW)
 *
 * Used to set the ADC resolution mode.
 *
 * Values:
 * - 00 - 8-bit conversion
 * - 01 - 10-bit conversion
 * - 10 - 12-bit conversion
 * - 11 - Reserved
 */
/*@{*/
#define BP_ADC_CFG_MODE      (2U)          /*!< Bit position for ADC_CFG_MODE. */
#define BM_ADC_CFG_MODE      (0x0000000CU) /*!< Bit mask for ADC_CFG_MODE. */
#define BS_ADC_CFG_MODE      (2U)          /*!< Bit field size in bits for ADC_CFG_MODE. */

/*! @brief Read current value of the ADC_CFG_MODE field. */
#define BR_ADC_CFG_MODE(x)   (HW_ADC_CFG(x).B.MODE)

/*! @brief Format value for bitfield ADC_CFG_MODE. */
#define BF_ADC_CFG_MODE(v)   ((uint32_t)((uint32_t)(v) << BP_ADC_CFG_MODE) & BM_ADC_CFG_MODE)

/*! @brief Set the MODE field to a new value. */
#define BW_ADC_CFG_MODE(x, v) (HW_ADC_CFG_WR(x, (HW_ADC_CFG_RD(x) & ~BM_ADC_CFG_MODE) | BF_ADC_CFG_MODE(v)))
/*@}*/

/*!
 * @name Register ADC_CFG, field ADLSMP[4] (RW)
 *
 * Selects between different sample times based on the ADC_CFG[ADSTS] field.
 * This bit adjusts the sample period to allow higher impedance inputs to be
 * accurately sampled or to maximize conversion speed for lower impedance inputs. If
 * high conversion rates are not required, longer sample times can also be used to
 * lower overall power consumption when continuous conversions are enabled. When
 * ADLSMP=1, the Long Sample Time mode is selected and the time is defined by
 * ADSTS[1:0] of the ADC_CFG register.
 *
 * Values:
 * - 0 - Short sample mode.
 * - 1 - Long sample mode.
 */
/*@{*/
#define BP_ADC_CFG_ADLSMP    (4U)          /*!< Bit position for ADC_CFG_ADLSMP. */
#define BM_ADC_CFG_ADLSMP    (0x00000010U) /*!< Bit mask for ADC_CFG_ADLSMP. */
#define BS_ADC_CFG_ADLSMP    (1U)          /*!< Bit field size in bits for ADC_CFG_ADLSMP. */

/*! @brief Read current value of the ADC_CFG_ADLSMP field. */
#define BR_ADC_CFG_ADLSMP(x) (HW_ADC_CFG(x).B.ADLSMP)

/*! @brief Format value for bitfield ADC_CFG_ADLSMP. */
#define BF_ADC_CFG_ADLSMP(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CFG_ADLSMP) & BM_ADC_CFG_ADLSMP)

/*! @brief Set the ADLSMP field to a new value. */
#define BW_ADC_CFG_ADLSMP(x, v) (HW_ADC_CFG_WR(x, (HW_ADC_CFG_RD(x) & ~BM_ADC_CFG_ADLSMP) | BF_ADC_CFG_ADLSMP(v)))
/*@}*/

/*!
 * @name Register ADC_CFG, field ADIV[6:5] (RW)
 *
 * Selects the divide ratio used by the ADC to generate the internal clock ADCK.
 *
 * Values:
 * - 00 - Input clock
 * - 01 - Input clock / 2
 * - 10 - Input clock / 4
 * - 11 - Input clock / 8
 */
/*@{*/
#define BP_ADC_CFG_ADIV      (5U)          /*!< Bit position for ADC_CFG_ADIV. */
#define BM_ADC_CFG_ADIV      (0x00000060U) /*!< Bit mask for ADC_CFG_ADIV. */
#define BS_ADC_CFG_ADIV      (2U)          /*!< Bit field size in bits for ADC_CFG_ADIV. */

/*! @brief Read current value of the ADC_CFG_ADIV field. */
#define BR_ADC_CFG_ADIV(x)   (HW_ADC_CFG(x).B.ADIV)

/*! @brief Format value for bitfield ADC_CFG_ADIV. */
#define BF_ADC_CFG_ADIV(v)   ((uint32_t)((uint32_t)(v) << BP_ADC_CFG_ADIV) & BM_ADC_CFG_ADIV)

/*! @brief Set the ADIV field to a new value. */
#define BW_ADC_CFG_ADIV(x, v) (HW_ADC_CFG_WR(x, (HW_ADC_CFG_RD(x) & ~BM_ADC_CFG_ADIV) | BF_ADC_CFG_ADIV(v)))
/*@}*/

/*!
 * @name Register ADC_CFG, field ADLPC[7] (RW)
 *
 * Puts the ADC hard block into low power mode and reduces the comparator enable
 * period by controlling its timing in the SAR controller block towards the
 * anlong hard block. The signal indicating low power mode to the Analog block is
 * asserted when this bit is set.
 *
 * Values:
 * - 0 - ADC hard block not in low power mode.
 * - 1 - ADC hard block in low power mode.
 */
/*@{*/
#define BP_ADC_CFG_ADLPC     (7U)          /*!< Bit position for ADC_CFG_ADLPC. */
#define BM_ADC_CFG_ADLPC     (0x00000080U) /*!< Bit mask for ADC_CFG_ADLPC. */
#define BS_ADC_CFG_ADLPC     (1U)          /*!< Bit field size in bits for ADC_CFG_ADLPC. */

/*! @brief Read current value of the ADC_CFG_ADLPC field. */
#define BR_ADC_CFG_ADLPC(x)  (HW_ADC_CFG(x).B.ADLPC)

/*! @brief Format value for bitfield ADC_CFG_ADLPC. */
#define BF_ADC_CFG_ADLPC(v)  ((uint32_t)((uint32_t)(v) << BP_ADC_CFG_ADLPC) & BM_ADC_CFG_ADLPC)

/*! @brief Set the ADLPC field to a new value. */
#define BW_ADC_CFG_ADLPC(x, v) (HW_ADC_CFG_WR(x, (HW_ADC_CFG_RD(x) & ~BM_ADC_CFG_ADLPC) | BF_ADC_CFG_ADLPC(v)))
/*@}*/

/*!
 * @name Register ADC_CFG, field ADSTS[9:8] (RW)
 *
 * Defines the sample time duration. This has two modes, short and long. When
 * long sample time is selected (ADLSMP=1) this works for long sample time
 * otherwise this works for short sample. This allows higher impedance inputs to be
 * accurately sampled or to maximize conversion speed for lower impedance inputs.
 * Longer sample times can also be used to lower overall power consumption when
 * continuous conversions are enabled if high conversion rates are not required.
 *
 * Values:
 * - 00 - Sample period (ADC clocks) = 2 if ADLSMP=0b Sample period (ADC clocks)
 *     = 12 if ADLSMP=1b
 * - 01 - Sample period (ADC clocks) = 4 if ADLSMP=0b Sample period (ADC clocks)
 *     = 16 if ADLSMP=1b
 * - 10 - Sample period (ADC clocks) = 6 if ADLSMP=0b Sample period (ADC clocks)
 *     = 20 if ADLSMP=1b
 * - 11 - Sample period (ADC clocks) = 8 if ADLSMP=0b Sample period (ADC clocks)
 *     = 24 if ADLSMP=1b
 */
/*@{*/
#define BP_ADC_CFG_ADSTS     (8U)          /*!< Bit position for ADC_CFG_ADSTS. */
#define BM_ADC_CFG_ADSTS     (0x00000300U) /*!< Bit mask for ADC_CFG_ADSTS. */
#define BS_ADC_CFG_ADSTS     (2U)          /*!< Bit field size in bits for ADC_CFG_ADSTS. */

/*! @brief Read current value of the ADC_CFG_ADSTS field. */
#define BR_ADC_CFG_ADSTS(x)  (HW_ADC_CFG(x).B.ADSTS)

/*! @brief Format value for bitfield ADC_CFG_ADSTS. */
#define BF_ADC_CFG_ADSTS(v)  ((uint32_t)((uint32_t)(v) << BP_ADC_CFG_ADSTS) & BM_ADC_CFG_ADSTS)

/*! @brief Set the ADSTS field to a new value. */
#define BW_ADC_CFG_ADSTS(x, v) (HW_ADC_CFG_WR(x, (HW_ADC_CFG_RD(x) & ~BM_ADC_CFG_ADSTS) | BF_ADC_CFG_ADSTS(v)))
/*@}*/

/*!
 * @name Register ADC_CFG, field ADHSC[10] (RW)
 *
 * This bit configures the ADC for high speed operation. The internal ADC clock
 * is higher than normal.
 *
 * Values:
 * - 0 - Normal conversion selected.
 * - 1 - High speed conversion selected.
 */
/*@{*/
#define BP_ADC_CFG_ADHSC     (10U)         /*!< Bit position for ADC_CFG_ADHSC. */
#define BM_ADC_CFG_ADHSC     (0x00000400U) /*!< Bit mask for ADC_CFG_ADHSC. */
#define BS_ADC_CFG_ADHSC     (1U)          /*!< Bit field size in bits for ADC_CFG_ADHSC. */

/*! @brief Read current value of the ADC_CFG_ADHSC field. */
#define BR_ADC_CFG_ADHSC(x)  (HW_ADC_CFG(x).B.ADHSC)

/*! @brief Format value for bitfield ADC_CFG_ADHSC. */
#define BF_ADC_CFG_ADHSC(v)  ((uint32_t)((uint32_t)(v) << BP_ADC_CFG_ADHSC) & BM_ADC_CFG_ADHSC)

/*! @brief Set the ADHSC field to a new value. */
#define BW_ADC_CFG_ADHSC(x, v) (HW_ADC_CFG_WR(x, (HW_ADC_CFG_RD(x) & ~BM_ADC_CFG_ADHSC) | BF_ADC_CFG_ADHSC(v)))
/*@}*/

/*!
 * @name Register ADC_CFG, field REFSEL[12:11] (RW)
 *
 * Selects the voltage reference source used for conversions (see the
 * chip-specific SARADC information for details).
 *
 * Values:
 * - 00 - Selects VREFH/VREFL as reference voltage.
 * - 01 - Reserved
 * - 10 - Reserved
 * - 11 - Reserved
 */
/*@{*/
#define BP_ADC_CFG_REFSEL    (11U)         /*!< Bit position for ADC_CFG_REFSEL. */
#define BM_ADC_CFG_REFSEL    (0x00001800U) /*!< Bit mask for ADC_CFG_REFSEL. */
#define BS_ADC_CFG_REFSEL    (2U)          /*!< Bit field size in bits for ADC_CFG_REFSEL. */

/*! @brief Read current value of the ADC_CFG_REFSEL field. */
#define BR_ADC_CFG_REFSEL(x) (HW_ADC_CFG(x).B.REFSEL)

/*! @brief Format value for bitfield ADC_CFG_REFSEL. */
#define BF_ADC_CFG_REFSEL(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CFG_REFSEL) & BM_ADC_CFG_REFSEL)

/*! @brief Set the REFSEL field to a new value. */
#define BW_ADC_CFG_REFSEL(x, v) (HW_ADC_CFG_WR(x, (HW_ADC_CFG_RD(x) & ~BM_ADC_CFG_REFSEL) | BF_ADC_CFG_REFSEL(v)))
/*@}*/

/*!
 * @name Register ADC_CFG, field ADTRG[13] (RW)
 *
 * Selects the type of trigger used for initiating a conversion. Two types of
 * trigger are selectable: software trigger and hardware trigger. When software
 * trigger is selected, a conversion is initiated following a write to ADC_HC0. When
 * hardware trigger is selected, a conversion is initiated following the
 * assertion of a pulse on Alternate Hardware trigger input along with the assertion of
 * the enable of respective the hardware Triggers input .
 *
 * Values:
 * - 0 - Software trigger selected
 * - 1 - Hardware trigger selected
 */
/*@{*/
#define BP_ADC_CFG_ADTRG     (13U)         /*!< Bit position for ADC_CFG_ADTRG. */
#define BM_ADC_CFG_ADTRG     (0x00002000U) /*!< Bit mask for ADC_CFG_ADTRG. */
#define BS_ADC_CFG_ADTRG     (1U)          /*!< Bit field size in bits for ADC_CFG_ADTRG. */

/*! @brief Read current value of the ADC_CFG_ADTRG field. */
#define BR_ADC_CFG_ADTRG(x)  (HW_ADC_CFG(x).B.ADTRG)

/*! @brief Format value for bitfield ADC_CFG_ADTRG. */
#define BF_ADC_CFG_ADTRG(v)  ((uint32_t)((uint32_t)(v) << BP_ADC_CFG_ADTRG) & BM_ADC_CFG_ADTRG)

/*! @brief Set the ADTRG field to a new value. */
#define BW_ADC_CFG_ADTRG(x, v) (HW_ADC_CFG_WR(x, (HW_ADC_CFG_RD(x) & ~BM_ADC_CFG_ADTRG) | BF_ADC_CFG_ADTRG(v)))
/*@}*/

/*!
 * @name Register ADC_CFG, field AVGS[15:14] (RW)
 *
 * Determines how many ADC conversions will be averaged to create the ADC
 * average result. This functionality is activated when ADC_GC[AVGE] = 1.
 *
 * Values:
 * - 00 - 4 samples averaged
 * - 01 - 8 samples averaged
 * - 10 - 16 samples averaged
 * - 11 - 32 samples averaged
 */
/*@{*/
#define BP_ADC_CFG_AVGS      (14U)         /*!< Bit position for ADC_CFG_AVGS. */
#define BM_ADC_CFG_AVGS      (0x0000C000U) /*!< Bit mask for ADC_CFG_AVGS. */
#define BS_ADC_CFG_AVGS      (2U)          /*!< Bit field size in bits for ADC_CFG_AVGS. */

/*! @brief Read current value of the ADC_CFG_AVGS field. */
#define BR_ADC_CFG_AVGS(x)   (HW_ADC_CFG(x).B.AVGS)

/*! @brief Format value for bitfield ADC_CFG_AVGS. */
#define BF_ADC_CFG_AVGS(v)   ((uint32_t)((uint32_t)(v) << BP_ADC_CFG_AVGS) & BM_ADC_CFG_AVGS)

/*! @brief Set the AVGS field to a new value. */
#define BW_ADC_CFG_AVGS(x, v) (HW_ADC_CFG_WR(x, (HW_ADC_CFG_RD(x) & ~BM_ADC_CFG_AVGS) | BF_ADC_CFG_AVGS(v)))
/*@}*/

/*!
 * @name Register ADC_CFG, field OVWREN[16] (RW)
 *
 * Controls the overwriting of the next converted Data onto the existing
 * (previous) unread data into the Data result register.
 *
 * Values:
 * - 1 - Enable the overwritting.
 * - 0 - Disable the overwritting. Existing Data in Data result register will
 *     not be overwritten by subsequent converted data.
 */
/*@{*/
#define BP_ADC_CFG_OVWREN    (16U)         /*!< Bit position for ADC_CFG_OVWREN. */
#define BM_ADC_CFG_OVWREN    (0x00010000U) /*!< Bit mask for ADC_CFG_OVWREN. */
#define BS_ADC_CFG_OVWREN    (1U)          /*!< Bit field size in bits for ADC_CFG_OVWREN. */

/*! @brief Read current value of the ADC_CFG_OVWREN field. */
#define BR_ADC_CFG_OVWREN(x) (HW_ADC_CFG(x).B.OVWREN)

/*! @brief Format value for bitfield ADC_CFG_OVWREN. */
#define BF_ADC_CFG_OVWREN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CFG_OVWREN) & BM_ADC_CFG_OVWREN)

/*! @brief Set the OVWREN field to a new value. */
#define BW_ADC_CFG_OVWREN(x, v) (HW_ADC_CFG_WR(x, (HW_ADC_CFG_RD(x) & ~BM_ADC_CFG_OVWREN) | BF_ADC_CFG_OVWREN(v)))
/*@}*/

/*******************************************************************************
 * HW_ADC_GC - General control register
 ******************************************************************************/

/*!
 * @brief HW_ADC_GC - General control register (RW)
 *
 * Reset value: 0x00000000U
 *
 * Controls the calibration, continuous convert, hardware averaging functions,
 * conversion active, hardware/software trigger select, compare function and
 * voltage reference select of the ADC module.
 */
typedef union _hw_adc_gc
{
    uint32_t U;
    struct _hw_adc_gc_bitfields
    {
        uint32_t ADACKEN : 1;          /*!< [0] Asynchronous clock output enable */
        uint32_t DMAEN : 1;            /*!< [1] DMA Enable */
        uint32_t ACREN : 1;            /*!< [2] Compare Function Range Enable */
        uint32_t ACFGT : 1;            /*!< [3] Compare Function Greater Than Enable */
        uint32_t ACFE : 1;             /*!< [4] Compare Function Enable */
        uint32_t AVGE : 1;             /*!< [5] Hardware average enable */
        uint32_t ADCO : 1;             /*!< [6] Continuous Conversion Enable */
        uint32_t CAL : 1;              /*!< [7] Calibration */
        uint32_t RESERVED0 : 24;       /*!< [31:8]  */
    } B;
} hw_adc_gc_t;

/*!
 * @name Constants and macros for entire ADC_GC register
 */
/*@{*/
#define HW_ADC_GC_ADDR(x)        ((uintptr_t)(x) + 0x18U)

#define HW_ADC_GC(x)             (*(__IO hw_adc_gc_t *) HW_ADC_GC_ADDR(x))
#define HW_ADC_GC_RD(x)          (HW_ADC_GC(x).U)
#define HW_ADC_GC_WR(x, v)       (HW_ADC_GC(x).U = (v))
#define HW_ADC_GC_SET(x, v)      (HW_ADC_GC_WR(x, HW_ADC_GC_RD(x) |  (v)))
#define HW_ADC_GC_CLR(x, v)      (HW_ADC_GC_WR(x, HW_ADC_GC_RD(x) & ~(v)))
#define HW_ADC_GC_TOG(x, v)      (HW_ADC_GC_WR(x, HW_ADC_GC_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ADC_GC bitfields
 */

/*!
 * @name Register ADC_GC, field ADACKEN[0] (RW)
 *
 * Enables the ADC's asynchronous clock source and the clock source output
 * regardless of the conversion and input clock select (ADC_CFG[ADICLK]) settings of
 * the ADC. Based on MCU configuration, the asynchronous clock may be used by
 * other modules (see module introduction section). Setting this bit allows the clock
 * to be used even while the ADC is idle or operating from a different clock
 * source. Also, latency of initiating a single or first-continuous conversion with
 * the asynchronous clock selected is reduced since the ADACK clock is already
 * operational.
 *
 * Values:
 * - 0 - Asynchronous clock output disabled; Asynchronous clock only enabled if
 *     selected by ADICLK and a conversion is active.
 * - 1 - Asynchronous clock and clock output enabled regardless of the state of
 *     the ADC
 */
/*@{*/
#define BP_ADC_GC_ADACKEN    (0U)          /*!< Bit position for ADC_GC_ADACKEN. */
#define BM_ADC_GC_ADACKEN    (0x00000001U) /*!< Bit mask for ADC_GC_ADACKEN. */
#define BS_ADC_GC_ADACKEN    (1U)          /*!< Bit field size in bits for ADC_GC_ADACKEN. */

/*! @brief Read current value of the ADC_GC_ADACKEN field. */
#define BR_ADC_GC_ADACKEN(x) (HW_ADC_GC(x).B.ADACKEN)

/*! @brief Format value for bitfield ADC_GC_ADACKEN. */
#define BF_ADC_GC_ADACKEN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_GC_ADACKEN) & BM_ADC_GC_ADACKEN)

/*! @brief Set the ADACKEN field to a new value. */
#define BW_ADC_GC_ADACKEN(x, v) (HW_ADC_GC_WR(x, (HW_ADC_GC_RD(x) & ~BM_ADC_GC_ADACKEN) | BF_ADC_GC_ADACKEN(v)))
/*@}*/

/*!
 * @name Register ADC_GC, field DMAEN[1] (RW)
 *
 * Enables the DMA logic.
 *
 * Values:
 * - 0 - DMA disabled (default)
 * - 1 - DMA enabled
 */
/*@{*/
#define BP_ADC_GC_DMAEN      (1U)          /*!< Bit position for ADC_GC_DMAEN. */
#define BM_ADC_GC_DMAEN      (0x00000002U) /*!< Bit mask for ADC_GC_DMAEN. */
#define BS_ADC_GC_DMAEN      (1U)          /*!< Bit field size in bits for ADC_GC_DMAEN. */

/*! @brief Read current value of the ADC_GC_DMAEN field. */
#define BR_ADC_GC_DMAEN(x)   (HW_ADC_GC(x).B.DMAEN)

/*! @brief Format value for bitfield ADC_GC_DMAEN. */
#define BF_ADC_GC_DMAEN(v)   ((uint32_t)((uint32_t)(v) << BP_ADC_GC_DMAEN) & BM_ADC_GC_DMAEN)

/*! @brief Set the DMAEN field to a new value. */
#define BW_ADC_GC_DMAEN(x, v) (HW_ADC_GC_WR(x, (HW_ADC_GC_RD(x) & ~BM_ADC_GC_DMAEN) | BF_ADC_GC_DMAEN(v)))
/*@}*/

/*!
 * @name Register ADC_GC, field ACREN[2] (RW)
 *
 * Configures the compare function to check the conversion result of the input
 * being monitored is either between or outside the range formed by the compare
 * values in register (ADC_CV) determined by the value of ACFGT. The ACFE bit must
 * be set for ACFGT to have any effect.
 *
 * Values:
 * - 0 - Range function disabled. Only the compare value 1 of ADC_CV register
 *     (CV1) is compared.
 * - 1 - Range function enabled. Both compare values of ADC_CV registers (CV1
 *     and CV2) are compared.
 */
/*@{*/
#define BP_ADC_GC_ACREN      (2U)          /*!< Bit position for ADC_GC_ACREN. */
#define BM_ADC_GC_ACREN      (0x00000004U) /*!< Bit mask for ADC_GC_ACREN. */
#define BS_ADC_GC_ACREN      (1U)          /*!< Bit field size in bits for ADC_GC_ACREN. */

/*! @brief Read current value of the ADC_GC_ACREN field. */
#define BR_ADC_GC_ACREN(x)   (HW_ADC_GC(x).B.ACREN)

/*! @brief Format value for bitfield ADC_GC_ACREN. */
#define BF_ADC_GC_ACREN(v)   ((uint32_t)((uint32_t)(v) << BP_ADC_GC_ACREN) & BM_ADC_GC_ACREN)

/*! @brief Set the ACREN field to a new value. */
#define BW_ADC_GC_ACREN(x, v) (HW_ADC_GC_WR(x, (HW_ADC_GC_RD(x) & ~BM_ADC_GC_ACREN) | BF_ADC_GC_ACREN(v)))
/*@}*/

/*!
 * @name Register ADC_GC, field ACFGT[3] (RW)
 *
 * Configures the compare function to check the conversion result relative to
 * the compare value register (ADC_CV) based upon the value of ACREN (bit 2 in
 * ADC_GC register). The ACFE bit must be set for ACFGT to have any effect.
 *
 * Values:
 * - 0 - Configures "Less Than Threshold, Outside Range Not Inclusive and Inside
 *     Range Not Inclusive" functionality based on the values placed in the
 *     ADC_CV register.
 * - 1 - Configures "Greater Than Or Equal To Threshold, Outside Range Inclusive
 *     and Inside Range Inclusive" functionality based on the values placed in
 *     the ADC_CV registers.
 */
/*@{*/
#define BP_ADC_GC_ACFGT      (3U)          /*!< Bit position for ADC_GC_ACFGT. */
#define BM_ADC_GC_ACFGT      (0x00000008U) /*!< Bit mask for ADC_GC_ACFGT. */
#define BS_ADC_GC_ACFGT      (1U)          /*!< Bit field size in bits for ADC_GC_ACFGT. */

/*! @brief Read current value of the ADC_GC_ACFGT field. */
#define BR_ADC_GC_ACFGT(x)   (HW_ADC_GC(x).B.ACFGT)

/*! @brief Format value for bitfield ADC_GC_ACFGT. */
#define BF_ADC_GC_ACFGT(v)   ((uint32_t)((uint32_t)(v) << BP_ADC_GC_ACFGT) & BM_ADC_GC_ACFGT)

/*! @brief Set the ACFGT field to a new value. */
#define BW_ADC_GC_ACFGT(x, v) (HW_ADC_GC_WR(x, (HW_ADC_GC_RD(x) & ~BM_ADC_GC_ACFGT) | BF_ADC_GC_ACFGT(v)))
/*@}*/

/*!
 * @name Register ADC_GC, field ACFE[4] (RW)
 *
 * Enables the compare function.
 *
 * Values:
 * - 0 - Compare function disabled
 * - 1 - Compare function enabled
 */
/*@{*/
#define BP_ADC_GC_ACFE       (4U)          /*!< Bit position for ADC_GC_ACFE. */
#define BM_ADC_GC_ACFE       (0x00000010U) /*!< Bit mask for ADC_GC_ACFE. */
#define BS_ADC_GC_ACFE       (1U)          /*!< Bit field size in bits for ADC_GC_ACFE. */

/*! @brief Read current value of the ADC_GC_ACFE field. */
#define BR_ADC_GC_ACFE(x)    (HW_ADC_GC(x).B.ACFE)

/*! @brief Format value for bitfield ADC_GC_ACFE. */
#define BF_ADC_GC_ACFE(v)    ((uint32_t)((uint32_t)(v) << BP_ADC_GC_ACFE) & BM_ADC_GC_ACFE)

/*! @brief Set the ACFE field to a new value. */
#define BW_ADC_GC_ACFE(x, v) (HW_ADC_GC_WR(x, (HW_ADC_GC_RD(x) & ~BM_ADC_GC_ACFE) | BF_ADC_GC_ACFE(v)))
/*@}*/

/*!
 * @name Register ADC_GC, field AVGE[5] (RW)
 *
 * Enables the hardware average function of the ADC.
 *
 * Values:
 * - 0 - Hardware average function disabled
 * - 1 - Hardware average function enabled
 */
/*@{*/
#define BP_ADC_GC_AVGE       (5U)          /*!< Bit position for ADC_GC_AVGE. */
#define BM_ADC_GC_AVGE       (0x00000020U) /*!< Bit mask for ADC_GC_AVGE. */
#define BS_ADC_GC_AVGE       (1U)          /*!< Bit field size in bits for ADC_GC_AVGE. */

/*! @brief Read current value of the ADC_GC_AVGE field. */
#define BR_ADC_GC_AVGE(x)    (HW_ADC_GC(x).B.AVGE)

/*! @brief Format value for bitfield ADC_GC_AVGE. */
#define BF_ADC_GC_AVGE(v)    ((uint32_t)((uint32_t)(v) << BP_ADC_GC_AVGE) & BM_ADC_GC_AVGE)

/*! @brief Set the AVGE field to a new value. */
#define BW_ADC_GC_AVGE(x, v) (HW_ADC_GC_WR(x, (HW_ADC_GC_RD(x) & ~BM_ADC_GC_AVGE) | BF_ADC_GC_AVGE(v)))
/*@}*/

/*!
 * @name Register ADC_GC, field ADCO[6] (RW)
 *
 * Enables continuous conversions.
 *
 * Values:
 * - 0 - One conversion or one set of conversions if the hardware average
 *     function is enabled (AVGE=1) after initiating a conversion.
 * - 1 - Continuous conversions or sets of conversions if the hardware average
 *     function is enabled (AVGE=1) after initiating a conversion.
 */
/*@{*/
#define BP_ADC_GC_ADCO       (6U)          /*!< Bit position for ADC_GC_ADCO. */
#define BM_ADC_GC_ADCO       (0x00000040U) /*!< Bit mask for ADC_GC_ADCO. */
#define BS_ADC_GC_ADCO       (1U)          /*!< Bit field size in bits for ADC_GC_ADCO. */

/*! @brief Read current value of the ADC_GC_ADCO field. */
#define BR_ADC_GC_ADCO(x)    (HW_ADC_GC(x).B.ADCO)

/*! @brief Format value for bitfield ADC_GC_ADCO. */
#define BF_ADC_GC_ADCO(v)    ((uint32_t)((uint32_t)(v) << BP_ADC_GC_ADCO) & BM_ADC_GC_ADCO)

/*! @brief Set the ADCO field to a new value. */
#define BW_ADC_GC_ADCO(x, v) (HW_ADC_GC_WR(x, (HW_ADC_GC_RD(x) & ~BM_ADC_GC_ADCO) | BF_ADC_GC_ADCO(v)))
/*@}*/

/*!
 * @name Register ADC_GC, field CAL[7] (RW)
 *
 * CAL begins the calibration sequence when set. This bit stays set while the
 * calibration is in progress and is cleared when the calibration sequence is
 * complete. The ADC_GS[CALF] bit must be checked to determine the result of the
 * calibration sequence. Once started, the calibration routine cannot be interrupted
 * by writes to the ADC registers or the results will be invalid and the
 * ADC_GS[CALF] bit will set. Setting the CAL bit will abort any current conversion.
 */
/*@{*/
#define BP_ADC_GC_CAL        (7U)          /*!< Bit position for ADC_GC_CAL. */
#define BM_ADC_GC_CAL        (0x00000080U) /*!< Bit mask for ADC_GC_CAL. */
#define BS_ADC_GC_CAL        (1U)          /*!< Bit field size in bits for ADC_GC_CAL. */

/*! @brief Read current value of the ADC_GC_CAL field. */
#define BR_ADC_GC_CAL(x)     (HW_ADC_GC(x).B.CAL)

/*! @brief Format value for bitfield ADC_GC_CAL. */
#define BF_ADC_GC_CAL(v)     ((uint32_t)((uint32_t)(v) << BP_ADC_GC_CAL) & BM_ADC_GC_CAL)

/*! @brief Set the CAL field to a new value. */
#define BW_ADC_GC_CAL(x, v)  (HW_ADC_GC_WR(x, (HW_ADC_GC_RD(x) & ~BM_ADC_GC_CAL) | BF_ADC_GC_CAL(v)))
/*@}*/

/*******************************************************************************
 * HW_ADC_GS - General status register
 ******************************************************************************/

/*!
 * @brief HW_ADC_GS - General status register (RW)
 *
 * Reset value: 0x00000000U
 *
 * Controls the calibration, continuous convert, hardware averaging functions,
 * conversion active, hardware/software trigger select, compare function and
 * voltage reference select of the ADC module.
 */
typedef union _hw_adc_gs
{
    uint32_t U;
    struct _hw_adc_gs_bitfields
    {
        uint32_t ADACT : 1;            /*!< [0] Conversion Active */
        uint32_t CALF : 1;             /*!< [1] Calibration Failed Flag */
        uint32_t AWKST : 1;            /*!< [2] Asynchronous wakeup interrupt status */
        uint32_t RESERVED0 : 29;       /*!< [31:3]  */
    } B;
} hw_adc_gs_t;

/*!
 * @name Constants and macros for entire ADC_GS register
 */
/*@{*/
#define HW_ADC_GS_ADDR(x)        ((uintptr_t)(x) + 0x1CU)

#define HW_ADC_GS(x)             (*(__IO hw_adc_gs_t *) HW_ADC_GS_ADDR(x))
#define HW_ADC_GS_RD(x)          (HW_ADC_GS(x).U)
#define HW_ADC_GS_WR(x, v)       (HW_ADC_GS(x).U = (v))
#define HW_ADC_GS_SET(x, v)      (HW_ADC_GS_WR(x, HW_ADC_GS_RD(x) |  (v)))
#define HW_ADC_GS_CLR(x, v)      (HW_ADC_GS_WR(x, HW_ADC_GS_RD(x) & ~(v)))
#define HW_ADC_GS_TOG(x, v)      (HW_ADC_GS_WR(x, HW_ADC_GS_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ADC_GS bitfields
 */

/*!
 * @name Register ADC_GS, field ADACT[0] (RO)
 *
 * Indicates that a conversion or hardware averaging is in progress. ADACT is
 * set when a conversion is initiated and cleared when a conversion is completed or
 * aborted.
 *
 * Values:
 * - 0 - Conversion not in progress.
 * - 1 - Conversion in progress.
 */
/*@{*/
#define BP_ADC_GS_ADACT      (0U)          /*!< Bit position for ADC_GS_ADACT. */
#define BM_ADC_GS_ADACT      (0x00000001U) /*!< Bit mask for ADC_GS_ADACT. */
#define BS_ADC_GS_ADACT      (1U)          /*!< Bit field size in bits for ADC_GS_ADACT. */

/*! @brief Read current value of the ADC_GS_ADACT field. */
#define BR_ADC_GS_ADACT(x)   (HW_ADC_GS(x).B.ADACT)
/*@}*/

/*!
 * @name Register ADC_GS, field CALF[1] (W1C)
 *
 * Displays the result of the calibration sequence. The calibration sequence
 * will fail if Hardware Trigger is selected (i.e. ADC_CFG[ADTRG] = 1), or any ADC
 * register is written, or any stop mode is entered before the calibration
 * sequence completes. The CALF bit is cleared by writing a 1 to it.
 *
 * Values:
 * - 0 - Calibration completed normally.
 * - 1 - Calibration failed. ADC accuracy specifications are not guaranteed.
 */
/*@{*/
#define BP_ADC_GS_CALF       (1U)          /*!< Bit position for ADC_GS_CALF. */
#define BM_ADC_GS_CALF       (0x00000002U) /*!< Bit mask for ADC_GS_CALF. */
#define BS_ADC_GS_CALF       (1U)          /*!< Bit field size in bits for ADC_GS_CALF. */

/*! @brief Read current value of the ADC_GS_CALF field. */
#define BR_ADC_GS_CALF(x)    (HW_ADC_GS(x).B.CALF)

/*! @brief Format value for bitfield ADC_GS_CALF. */
#define BF_ADC_GS_CALF(v)    ((uint32_t)((uint32_t)(v) << BP_ADC_GS_CALF) & BM_ADC_GS_CALF)

/*! @brief Set the CALF field to a new value. */
#define BW_ADC_GS_CALF(x, v) (HW_ADC_GS_WR(x, (HW_ADC_GS_RD(x) & ~(BM_ADC_GS_CALF | BM_ADC_GS_AWKST)) | BF_ADC_GS_CALF(v)))
/*@}*/

/*!
 * @name Register ADC_GS, field AWKST[2] (W1C)
 *
 * Holds the status of asynchronous interrupt status that occured during stop
 * mode. This bit is set when ipg_stop is deasserted and ipg_clk has started. It is
 * cleared by writing '1' to it. Clearing this bit also deasserts the
 * Asynchronous interrupt to CPU.
 *
 * Values:
 * - 1 - Asynnchronous wake up interrupt occured in stop mode.
 * - 0 - No asynchronous interrupt.
 */
/*@{*/
#define BP_ADC_GS_AWKST      (2U)          /*!< Bit position for ADC_GS_AWKST. */
#define BM_ADC_GS_AWKST      (0x00000004U) /*!< Bit mask for ADC_GS_AWKST. */
#define BS_ADC_GS_AWKST      (1U)          /*!< Bit field size in bits for ADC_GS_AWKST. */

/*! @brief Read current value of the ADC_GS_AWKST field. */
#define BR_ADC_GS_AWKST(x)   (HW_ADC_GS(x).B.AWKST)

/*! @brief Format value for bitfield ADC_GS_AWKST. */
#define BF_ADC_GS_AWKST(v)   ((uint32_t)((uint32_t)(v) << BP_ADC_GS_AWKST) & BM_ADC_GS_AWKST)

/*! @brief Set the AWKST field to a new value. */
#define BW_ADC_GS_AWKST(x, v) (HW_ADC_GS_WR(x, (HW_ADC_GS_RD(x) & ~(BM_ADC_GS_AWKST | BM_ADC_GS_CALF)) | BF_ADC_GS_AWKST(v)))
/*@}*/

/*******************************************************************************
 * HW_ADC_CV - Compare value register
 ******************************************************************************/

/*!
 * @brief HW_ADC_CV - Compare value register (RW)
 *
 * Reset value: 0x00000000U
 *
 * Contains compare values used to compare with the conversion result when the
 * compare function is enabled (ADC_GC[ACFE]=1). The compare values are right
 * justified as shown Figure . Therfore, the compare function only uses the compare
 * value register bits that are related to the ADC mode of operation. (e.g. in 8
 * bit mode, CV1 = ADC_CV[7:0] and CV2 = ADC_CV[23:16], similarly in 10 bit mode,
 * CV1 = ADC_CV[9:0] and CV2 = ADC_CV[25:16] etc.) The compare value 2 in this
 * register is utilized only when the compare range function is enabled
 * (ADC_GC[ACREN]=1).
 */
typedef union _hw_adc_cv
{
    uint32_t U;
    struct _hw_adc_cv_bitfields
    {
        uint32_t CV1 : 12;             /*!< [11:0] Compare Value 1 */
        uint32_t RESERVED0 : 4;        /*!< [15:12]  */
        uint32_t CV2 : 12;             /*!< [27:16] Compare Value 2 */
        uint32_t RESERVED1 : 4;        /*!< [31:28]  */
    } B;
} hw_adc_cv_t;

/*!
 * @name Constants and macros for entire ADC_CV register
 */
/*@{*/
#define HW_ADC_CV_ADDR(x)        ((uintptr_t)(x) + 0x20U)

#define HW_ADC_CV(x)             (*(__IO hw_adc_cv_t *) HW_ADC_CV_ADDR(x))
#define HW_ADC_CV_RD(x)          (HW_ADC_CV(x).U)
#define HW_ADC_CV_WR(x, v)       (HW_ADC_CV(x).U = (v))
#define HW_ADC_CV_SET(x, v)      (HW_ADC_CV_WR(x, HW_ADC_CV_RD(x) |  (v)))
#define HW_ADC_CV_CLR(x, v)      (HW_ADC_CV_WR(x, HW_ADC_CV_RD(x) & ~(v)))
#define HW_ADC_CV_TOG(x, v)      (HW_ADC_CV_WR(x, HW_ADC_CV_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ADC_CV bitfields
 */

/*!
 * @name Register ADC_CV, field CV1[11:0] (RW)
 *
 * Contains a compare value used to compare with the conversion result when the
 * compare function ais enabled (ADC_GC[ACFE]=1).
 */
/*@{*/
#define BP_ADC_CV_CV1        (0U)          /*!< Bit position for ADC_CV_CV1. */
#define BM_ADC_CV_CV1        (0x00000FFFU) /*!< Bit mask for ADC_CV_CV1. */
#define BS_ADC_CV_CV1        (12U)         /*!< Bit field size in bits for ADC_CV_CV1. */

/*! @brief Read current value of the ADC_CV_CV1 field. */
#define BR_ADC_CV_CV1(x)     (HW_ADC_CV(x).B.CV1)

/*! @brief Format value for bitfield ADC_CV_CV1. */
#define BF_ADC_CV_CV1(v)     ((uint32_t)((uint32_t)(v) << BP_ADC_CV_CV1) & BM_ADC_CV_CV1)

/*! @brief Set the CV1 field to a new value. */
#define BW_ADC_CV_CV1(x, v)  (HW_ADC_CV_WR(x, (HW_ADC_CV_RD(x) & ~BM_ADC_CV_CV1) | BF_ADC_CV_CV1(v)))
/*@}*/

/*!
 * @name Register ADC_CV, field CV2[27:16] (RW)
 *
 * Contains a compare value used to compare with the conversion result when the
 * compare function and compare range function are enabled (ADC_GC[ACFE]=1,
 * ADC_GC[ACREN]=1).
 */
/*@{*/
#define BP_ADC_CV_CV2        (16U)         /*!< Bit position for ADC_CV_CV2. */
#define BM_ADC_CV_CV2        (0x0FFF0000U) /*!< Bit mask for ADC_CV_CV2. */
#define BS_ADC_CV_CV2        (12U)         /*!< Bit field size in bits for ADC_CV_CV2. */

/*! @brief Read current value of the ADC_CV_CV2 field. */
#define BR_ADC_CV_CV2(x)     (HW_ADC_CV(x).B.CV2)

/*! @brief Format value for bitfield ADC_CV_CV2. */
#define BF_ADC_CV_CV2(v)     ((uint32_t)((uint32_t)(v) << BP_ADC_CV_CV2) & BM_ADC_CV_CV2)

/*! @brief Set the CV2 field to a new value. */
#define BW_ADC_CV_CV2(x, v)  (HW_ADC_CV_WR(x, (HW_ADC_CV_RD(x) & ~BM_ADC_CV_CV2) | BF_ADC_CV_CV2(v)))
/*@}*/

/*******************************************************************************
 * HW_ADC_OFS - Offset correction value register
 ******************************************************************************/

/*!
 * @brief HW_ADC_OFS - Offset correction value register (RW)
 *
 * Reset value: 0x00000000U
 *
 * Contains the user-defined offset error correction value. This register is 13
 * bits wide. The value in the most significant bit (13th bit ) is the operation
 * bit. If this bit is '0' then the value in the other 12 bits is added with the
 * converted result value to generate final result to be loaded into ADC_Rn; if
 * this bit is '1' then this field is subtracted from converted value to generate
 * final result (ADC_Rn).
 */
typedef union _hw_adc_ofs
{
    uint32_t U;
    struct _hw_adc_ofs_bitfields
    {
        uint32_t OFS : 12;             /*!< [11:0] Offset value */
        uint32_t SIGN : 1;             /*!< [12] Sign bit */
        uint32_t RESERVED0 : 19;       /*!< [31:13]  */
    } B;
} hw_adc_ofs_t;

/*!
 * @name Constants and macros for entire ADC_OFS register
 */
/*@{*/
#define HW_ADC_OFS_ADDR(x)       ((uintptr_t)(x) + 0x24U)

#define HW_ADC_OFS(x)            (*(__IO hw_adc_ofs_t *) HW_ADC_OFS_ADDR(x))
#define HW_ADC_OFS_RD(x)         (HW_ADC_OFS(x).U)
#define HW_ADC_OFS_WR(x, v)      (HW_ADC_OFS(x).U = (v))
#define HW_ADC_OFS_SET(x, v)     (HW_ADC_OFS_WR(x, HW_ADC_OFS_RD(x) |  (v)))
#define HW_ADC_OFS_CLR(x, v)     (HW_ADC_OFS_WR(x, HW_ADC_OFS_RD(x) & ~(v)))
#define HW_ADC_OFS_TOG(x, v)     (HW_ADC_OFS_WR(x, HW_ADC_OFS_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ADC_OFS bitfields
 */

/*!
 * @name Register ADC_OFS, field OFS[11:0] (RW)
 *
 * User configurable offset value.
 */
/*@{*/
#define BP_ADC_OFS_OFS       (0U)          /*!< Bit position for ADC_OFS_OFS. */
#define BM_ADC_OFS_OFS       (0x00000FFFU) /*!< Bit mask for ADC_OFS_OFS. */
#define BS_ADC_OFS_OFS       (12U)         /*!< Bit field size in bits for ADC_OFS_OFS. */

/*! @brief Read current value of the ADC_OFS_OFS field. */
#define BR_ADC_OFS_OFS(x)    (HW_ADC_OFS(x).B.OFS)

/*! @brief Format value for bitfield ADC_OFS_OFS. */
#define BF_ADC_OFS_OFS(v)    ((uint32_t)((uint32_t)(v) << BP_ADC_OFS_OFS) & BM_ADC_OFS_OFS)

/*! @brief Set the OFS field to a new value. */
#define BW_ADC_OFS_OFS(x, v) (HW_ADC_OFS_WR(x, (HW_ADC_OFS_RD(x) & ~BM_ADC_OFS_OFS) | BF_ADC_OFS_OFS(v)))
/*@}*/

/*!
 * @name Register ADC_OFS, field SIGN[12] (RW)
 *
 * Values:
 * - 0 - The offset value is added with the raw result
 * - 1 - The offset value is subtracted from the raw converted value
 */
/*@{*/
#define BP_ADC_OFS_SIGN      (12U)         /*!< Bit position for ADC_OFS_SIGN. */
#define BM_ADC_OFS_SIGN      (0x00001000U) /*!< Bit mask for ADC_OFS_SIGN. */
#define BS_ADC_OFS_SIGN      (1U)          /*!< Bit field size in bits for ADC_OFS_SIGN. */

/*! @brief Read current value of the ADC_OFS_SIGN field. */
#define BR_ADC_OFS_SIGN(x)   (HW_ADC_OFS(x).B.SIGN)

/*! @brief Format value for bitfield ADC_OFS_SIGN. */
#define BF_ADC_OFS_SIGN(v)   ((uint32_t)((uint32_t)(v) << BP_ADC_OFS_SIGN) & BM_ADC_OFS_SIGN)

/*! @brief Set the SIGN field to a new value. */
#define BW_ADC_OFS_SIGN(x, v) (HW_ADC_OFS_WR(x, (HW_ADC_OFS_RD(x) & ~BM_ADC_OFS_SIGN) | BF_ADC_OFS_SIGN(v)))
/*@}*/

/*******************************************************************************
 * HW_ADC_CAL - Calibration value register
 ******************************************************************************/

/*!
 * @brief HW_ADC_CAL - Calibration value register (RW)
 *
 * Reset value: 0x00000000U
 *
 * Contains calibration information that is generated by the calibration
 * function. This register contains a calibration value of four bits(CAL[3:0]); this is
 * automatically set once the self calibration sequence is done (ADC_SC[CAL] bit
 * is cleared). If this register is written to by the user after calibration, the
 * linearity error specifications may not be met.
 */
typedef union _hw_adc_cal
{
    uint32_t U;
    struct _hw_adc_cal_bitfields
    {
        uint32_t CAL_CODE : 4;         /*!< [3:0] Calibration Result Value */
        uint32_t RESERVED0 : 28;       /*!< [31:4]  */
    } B;
} hw_adc_cal_t;

/*!
 * @name Constants and macros for entire ADC_CAL register
 */
/*@{*/
#define HW_ADC_CAL_ADDR(x)       ((uintptr_t)(x) + 0x28U)

#define HW_ADC_CAL(x)            (*(__IO hw_adc_cal_t *) HW_ADC_CAL_ADDR(x))
#define HW_ADC_CAL_RD(x)         (HW_ADC_CAL(x).U)
#define HW_ADC_CAL_WR(x, v)      (HW_ADC_CAL(x).U = (v))
#define HW_ADC_CAL_SET(x, v)     (HW_ADC_CAL_WR(x, HW_ADC_CAL_RD(x) |  (v)))
#define HW_ADC_CAL_CLR(x, v)     (HW_ADC_CAL_WR(x, HW_ADC_CAL_RD(x) & ~(v)))
#define HW_ADC_CAL_TOG(x, v)     (HW_ADC_CAL_WR(x, HW_ADC_CAL_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ADC_CAL bitfields
 */

/*!
 * @name Register ADC_CAL, field CAL_CODE[3:0] (RW)
 *
 * This value is automatically loaded and updated at the end of calibration.
 */
/*@{*/
#define BP_ADC_CAL_CAL_CODE  (0U)          /*!< Bit position for ADC_CAL_CAL_CODE. */
#define BM_ADC_CAL_CAL_CODE  (0x0000000FU) /*!< Bit mask for ADC_CAL_CAL_CODE. */
#define BS_ADC_CAL_CAL_CODE  (4U)          /*!< Bit field size in bits for ADC_CAL_CAL_CODE. */

/*! @brief Read current value of the ADC_CAL_CAL_CODE field. */
#define BR_ADC_CAL_CAL_CODE(x) (HW_ADC_CAL(x).B.CAL_CODE)

/*! @brief Format value for bitfield ADC_CAL_CAL_CODE. */
#define BF_ADC_CAL_CAL_CODE(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CAL_CAL_CODE) & BM_ADC_CAL_CAL_CODE)

/*! @brief Set the CAL_CODE field to a new value. */
#define BW_ADC_CAL_CAL_CODE(x, v) (HW_ADC_CAL_WR(x, (HW_ADC_CAL_RD(x) & ~BM_ADC_CAL_CAL_CODE) | BF_ADC_CAL_CAL_CODE(v)))
/*@}*/

/*******************************************************************************
 * hw_adc_t - module struct
 ******************************************************************************/
/*!
 * @brief All ADC module registers.
 */
#pragma pack(1)
typedef struct _hw_adc
{
    __IO hw_adc_hc0_t HC0;                 /*!< [0x0] Control register for hardware triggers */
    __IO hw_adc_hc1_t HC1;                 /*!< [0x4] Control register for hardware triggers */
    __I hw_adc_hs_t HS;                    /*!< [0x8] Status register for HW triggers */
    __I hw_adc_r0_t R0;                    /*!< [0xC] Data result register for HW triggers */
    __I hw_adc_r1_t R1;                    /*!< [0x10] Data result register for HW triggers */
    __IO hw_adc_cfg_t CFG;                 /*!< [0x14] Configuration register */
    __IO hw_adc_gc_t GC;                   /*!< [0x18] General control register */
    __IO hw_adc_gs_t GS;                   /*!< [0x1C] General status register */
    __IO hw_adc_cv_t CV;                   /*!< [0x20] Compare value register */
    __IO hw_adc_ofs_t OFS;                 /*!< [0x24] Offset correction value register */
    __IO hw_adc_cal_t CAL;                 /*!< [0x28] Calibration value register */
} hw_adc_t;
#pragma pack()

/*! @brief Macro to access all ADC registers. */
/*! @param x ADC module instance base address. */
/*! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
 *     use the '&' operator, like <code>&HW_ADC_REGS(ADC1_BASE)</code>. */
#define HW_ADC_REGS(x) (*(hw_adc_t *)(x))

/*
 * iMX6SX AFE
 *
 * Analog front-end registers
 *
 * Registers defined in this header file:
 * - HW_AFE_BLOCK_ID -
 * - HW_AFE_PDBUF - Power Down Buffers
 * - HW_AFE_SWRST - Software Reset
 * - HW_AFE_BGREG - Band Gap
 * - HW_AFE_ACCESSAR_ID - Accessar ID
 * - HW_AFE_PDADC - Power Down ADC
 * - HW_AFE_PDSARH - Power Down SAR High
 * - HW_AFE_PDSARL - Power Down SAR Low
 * - HW_AFE_PDADCRFH - Power Down ADC Ref. High
 * - HW_AFE_PDADCRFL - Power Down ADC Ref. Low
 * - HW_AFE_ADCGN - ADC Gain
 * - HW_AFE_REFTRIML - ADC Ref Trim Low
 * - HW_AFE_REFTRIMH - ADC Ref Trim High
 * - HW_AFE_DACAMP - Clamp DAC Trim
 * - HW_AFE_CLMPDAT - Clamp DAC Data
 * - HW_AFE_CLMPAMP - Clamp DAC Control
 * - HW_AFE_CLAMP - Clamp Control
 * - HW_AFE_INPBUF - Input Buffer
 * - HW_AFE_INPFLT - Analog Input Filter
 * - HW_AFE_ADCDGN - ADC Digital Gain
 * - HW_AFE_OFFDRV - Off-Chip Drive
 * - HW_AFE_INPCONFIG - VADC INPUT CONFIG
 * - HW_AFE_PROGDELAY - VADC PROG DELAY
 * - HW_AFE_ADCOMT - ADC COMPARATOR TIMING
 * - HW_AFE_ALGDELAY - ALGORITHM DELAY
 * - HW_AFE_ACC_ID - Acc ID
 * - HW_AFE_ACCSTA - ACC STATUS
 * - HW_AFE_ACCNOSLI - ACC NUMBER OF SLICE
 * - HW_AFE_ACCCALCON - ACC CALIBRATE CONTROL
 * - HW_AFE_BWEWRICTRL - ACC BWE WRITE CONTROL
 * - HW_AFE_SELSLI - ACC SELECT SLICE
 * - HW_AFE_SELBYT - ACC SELECT BYTE
 * - HW_AFE_REDVAL - ACC READ VALUE
 * - HW_AFE_WRIBYT - ACC WRITE BYTE
 *
 * - hw_afe_t - Struct containing all module registers.
 */

#define HW_AFE_INSTANCE_COUNT (1U) /*!< Number of instances of the AFE module. */
#define HW_AFE (0U) /*!< Instance number for AFE. */
#define AFE_BASE              (0x2228000U) /*!< Base address for AFE. */
/*! Array initializer of AFE base addresses. */
#define AFE_BASE_ADDRS        { AFE_BASE }

/*******************************************************************************
 * HW_AFE_BLOCK_ID -
 ******************************************************************************/

/*!
 * @brief HW_AFE_BLOCK_ID -  (RO)
 *
 * Reset value: 0x00000011U
 */
typedef union _hw_afe_block_id
{
    uint32_t U;
    struct _hw_afe_block_id_bitfields
    {
        uint32_t BLOCK_ID : 8;         /*!< [7:0] Block ID and revision number */
        uint32_t RESERVED0 : 24;       /*!< [31:8]  */
    } B;
} hw_afe_block_id_t;

/*!
 * @name Constants and macros for entire AFE_BLOCK_ID register
 */
/*@{*/
#define HW_AFE_BLOCK_ID_ADDR(x)  ((uintptr_t)(x) + 0x0U)

#define HW_AFE_BLOCK_ID(x)       (*(__I hw_afe_block_id_t *) HW_AFE_BLOCK_ID_ADDR(x))
#define HW_AFE_BLOCK_ID_RD(x)    (HW_AFE_BLOCK_ID(x).U)
/*@}*/

/*
 * Constants & macros for individual AFE_BLOCK_ID bitfields
 */

/*!
 * @name Register AFE_BLOCK_ID, field BLOCK_ID[7:0] (RO)
 */
/*@{*/
#define BP_AFE_BLOCK_ID_BLOCK_ID (0U)      /*!< Bit position for AFE_BLOCK_ID_BLOCK_ID. */
#define BM_AFE_BLOCK_ID_BLOCK_ID (0x000000FFU) /*!< Bit mask for AFE_BLOCK_ID_BLOCK_ID. */
#define BS_AFE_BLOCK_ID_BLOCK_ID (8U)      /*!< Bit field size in bits for AFE_BLOCK_ID_BLOCK_ID. */

/*! @brief Read current value of the AFE_BLOCK_ID_BLOCK_ID field. */
#define BR_AFE_BLOCK_ID_BLOCK_ID(x) (HW_AFE_BLOCK_ID(x).B.BLOCK_ID)
/*@}*/

/*******************************************************************************
 * HW_AFE_PDBUF - Power Down Buffers
 ******************************************************************************/

/*!
 * @brief HW_AFE_PDBUF - Power Down Buffers (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_afe_pdbuf
{
    uint32_t U;
    struct _hw_afe_pdbuf_bitfields
    {
        uint32_t ACAFE_PD_N : 1;       /*!< [0] Master power down control. */
        uint32_t BGR_BGR_PD_N : 1;     /*!< [1] Active-low power down of band gap
                                        * core. */
        uint32_t BGR_PD_N : 1;         /*!< [2] Active-low power down of band gap. */
        uint32_t TESTBUFFERS_PD_N : 2; /*!< [4:3] Active-low power down of
                                        * test buffers */
        uint32_t RESERVED0 : 27;       /*!< [31:5]  */
    } B;
} hw_afe_pdbuf_t;

/*!
 * @name Constants and macros for entire AFE_PDBUF register
 */
/*@{*/
#define HW_AFE_PDBUF_ADDR(x)     ((uintptr_t)(x) + 0x4U)

#define HW_AFE_PDBUF(x)          (*(__IO hw_afe_pdbuf_t *) HW_AFE_PDBUF_ADDR(x))
#define HW_AFE_PDBUF_RD(x)       (HW_AFE_PDBUF(x).U)
#define HW_AFE_PDBUF_WR(x, v)    (HW_AFE_PDBUF(x).U = (v))
#define HW_AFE_PDBUF_SET(x, v)   (HW_AFE_PDBUF_WR(x, HW_AFE_PDBUF_RD(x) |  (v)))
#define HW_AFE_PDBUF_CLR(x, v)   (HW_AFE_PDBUF_WR(x, HW_AFE_PDBUF_RD(x) & ~(v)))
#define HW_AFE_PDBUF_TOG(x, v)   (HW_AFE_PDBUF_WR(x, HW_AFE_PDBUF_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AFE_PDBUF bitfields
 */

/*!
 * @name Register AFE_PDBUF, field ACAFE_PD_N[0] (RW)
 *
 * Master power down control.
 *
 * Values:
 * - 0 - Power down
 * - 1 - Normal
 */
/*@{*/
#define BP_AFE_PDBUF_ACAFE_PD_N (0U)       /*!< Bit position for AFE_PDBUF_ACAFE_PD_N. */
#define BM_AFE_PDBUF_ACAFE_PD_N (0x00000001U) /*!< Bit mask for AFE_PDBUF_ACAFE_PD_N. */
#define BS_AFE_PDBUF_ACAFE_PD_N (1U)       /*!< Bit field size in bits for AFE_PDBUF_ACAFE_PD_N. */

/*! @brief Read current value of the AFE_PDBUF_ACAFE_PD_N field. */
#define BR_AFE_PDBUF_ACAFE_PD_N(x) (HW_AFE_PDBUF(x).B.ACAFE_PD_N)

/*! @brief Format value for bitfield AFE_PDBUF_ACAFE_PD_N. */
#define BF_AFE_PDBUF_ACAFE_PD_N(v) ((uint32_t)((uint32_t)(v) << BP_AFE_PDBUF_ACAFE_PD_N) & BM_AFE_PDBUF_ACAFE_PD_N)

/*! @brief Set the ACAFE_PD_N field to a new value. */
#define BW_AFE_PDBUF_ACAFE_PD_N(x, v) (HW_AFE_PDBUF_WR(x, (HW_AFE_PDBUF_RD(x) & ~BM_AFE_PDBUF_ACAFE_PD_N) | BF_AFE_PDBUF_ACAFE_PD_N(v)))
/*@}*/

/*!
 * @name Register AFE_PDBUF, field BGR_BGR_PD_N[1] (RW)
 *
 * Both bgr_npd and bgr_bgr_npd have to be enabled for the bandgap to be in
 * power up.
 *
 * Values:
 * - 0 - Power down
 * - 1 - Normal
 */
/*@{*/
#define BP_AFE_PDBUF_BGR_BGR_PD_N (1U)     /*!< Bit position for AFE_PDBUF_BGR_BGR_PD_N. */
#define BM_AFE_PDBUF_BGR_BGR_PD_N (0x00000002U) /*!< Bit mask for AFE_PDBUF_BGR_BGR_PD_N. */
#define BS_AFE_PDBUF_BGR_BGR_PD_N (1U)     /*!< Bit field size in bits for AFE_PDBUF_BGR_BGR_PD_N. */

/*! @brief Read current value of the AFE_PDBUF_BGR_BGR_PD_N field. */
#define BR_AFE_PDBUF_BGR_BGR_PD_N(x) (HW_AFE_PDBUF(x).B.BGR_BGR_PD_N)

/*! @brief Format value for bitfield AFE_PDBUF_BGR_BGR_PD_N. */
#define BF_AFE_PDBUF_BGR_BGR_PD_N(v) ((uint32_t)((uint32_t)(v) << BP_AFE_PDBUF_BGR_BGR_PD_N) & BM_AFE_PDBUF_BGR_BGR_PD_N)

/*! @brief Set the BGR_BGR_PD_N field to a new value. */
#define BW_AFE_PDBUF_BGR_BGR_PD_N(x, v) (HW_AFE_PDBUF_WR(x, (HW_AFE_PDBUF_RD(x) & ~BM_AFE_PDBUF_BGR_BGR_PD_N) | BF_AFE_PDBUF_BGR_BGR_PD_N(v)))
/*@}*/

/*!
 * @name Register AFE_PDBUF, field BGR_PD_N[2] (RW)
 *
 * Both bgr_pd_n and bgr_bgr_pd_n must be enabled for the bandgap to be in power
 * up.
 *
 * Values:
 * - 0 - Power down
 * - 1 - Normal
 */
/*@{*/
#define BP_AFE_PDBUF_BGR_PD_N (2U)         /*!< Bit position for AFE_PDBUF_BGR_PD_N. */
#define BM_AFE_PDBUF_BGR_PD_N (0x00000004U) /*!< Bit mask for AFE_PDBUF_BGR_PD_N. */
#define BS_AFE_PDBUF_BGR_PD_N (1U)         /*!< Bit field size in bits for AFE_PDBUF_BGR_PD_N. */

/*! @brief Read current value of the AFE_PDBUF_BGR_PD_N field. */
#define BR_AFE_PDBUF_BGR_PD_N(x) (HW_AFE_PDBUF(x).B.BGR_PD_N)

/*! @brief Format value for bitfield AFE_PDBUF_BGR_PD_N. */
#define BF_AFE_PDBUF_BGR_PD_N(v) ((uint32_t)((uint32_t)(v) << BP_AFE_PDBUF_BGR_PD_N) & BM_AFE_PDBUF_BGR_PD_N)

/*! @brief Set the BGR_PD_N field to a new value. */
#define BW_AFE_PDBUF_BGR_PD_N(x, v) (HW_AFE_PDBUF_WR(x, (HW_AFE_PDBUF_RD(x) & ~BM_AFE_PDBUF_BGR_PD_N) | BF_AFE_PDBUF_BGR_PD_N(v)))
/*@}*/

/*!
 * @name Register AFE_PDBUF, field TESTBUFFERS_PD_N[4:3] (RW)
 *
 * Values:
 * - 00 - Power down both
 * - 01 - Power down test buffer 1
 * - 10 - Power down test buffer 0
 * - 11 - Both enabled
 */
/*@{*/
#define BP_AFE_PDBUF_TESTBUFFERS_PD_N (3U) /*!< Bit position for AFE_PDBUF_TESTBUFFERS_PD_N. */
#define BM_AFE_PDBUF_TESTBUFFERS_PD_N (0x00000018U) /*!< Bit mask for AFE_PDBUF_TESTBUFFERS_PD_N. */
#define BS_AFE_PDBUF_TESTBUFFERS_PD_N (2U) /*!< Bit field size in bits for AFE_PDBUF_TESTBUFFERS_PD_N. */

/*! @brief Read current value of the AFE_PDBUF_TESTBUFFERS_PD_N field. */
#define BR_AFE_PDBUF_TESTBUFFERS_PD_N(x) (HW_AFE_PDBUF(x).B.TESTBUFFERS_PD_N)

/*! @brief Format value for bitfield AFE_PDBUF_TESTBUFFERS_PD_N. */
#define BF_AFE_PDBUF_TESTBUFFERS_PD_N(v) ((uint32_t)((uint32_t)(v) << BP_AFE_PDBUF_TESTBUFFERS_PD_N) & BM_AFE_PDBUF_TESTBUFFERS_PD_N)

/*! @brief Set the TESTBUFFERS_PD_N field to a new value. */
#define BW_AFE_PDBUF_TESTBUFFERS_PD_N(x, v) (HW_AFE_PDBUF_WR(x, (HW_AFE_PDBUF_RD(x) & ~BM_AFE_PDBUF_TESTBUFFERS_PD_N) | BF_AFE_PDBUF_TESTBUFFERS_PD_N(v)))
/*@}*/

/*******************************************************************************
 * HW_AFE_SWRST - Software Reset
 ******************************************************************************/

/*!
 * @brief HW_AFE_SWRST - Software Reset (RW)
 *
 * Reset value: 0x00000007U
 */
typedef union _hw_afe_swrst
{
    uint32_t U;
    struct _hw_afe_swrst_bitfields
    {
        uint32_t SYSCLK_SW_RST_N : 1;  /*!< [0] Software reset of sysclk */
        uint32_t ADC_PROC_CLK_SW_RST_N : 1; /*!< [1] Software reset of
                                        * adc_clk */
        uint32_t ACAFE_SW_RST_N : 1;   /*!< [2] Software reset of all clocks */
        uint32_t RESERVED0 : 29;       /*!< [31:3]  */
    } B;
} hw_afe_swrst_t;

/*!
 * @name Constants and macros for entire AFE_SWRST register
 */
/*@{*/
#define HW_AFE_SWRST_ADDR(x)     ((uintptr_t)(x) + 0x8U)

#define HW_AFE_SWRST(x)          (*(__IO hw_afe_swrst_t *) HW_AFE_SWRST_ADDR(x))
#define HW_AFE_SWRST_RD(x)       (HW_AFE_SWRST(x).U)
#define HW_AFE_SWRST_WR(x, v)    (HW_AFE_SWRST(x).U = (v))
#define HW_AFE_SWRST_SET(x, v)   (HW_AFE_SWRST_WR(x, HW_AFE_SWRST_RD(x) |  (v)))
#define HW_AFE_SWRST_CLR(x, v)   (HW_AFE_SWRST_WR(x, HW_AFE_SWRST_RD(x) & ~(v)))
#define HW_AFE_SWRST_TOG(x, v)   (HW_AFE_SWRST_WR(x, HW_AFE_SWRST_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AFE_SWRST bitfields
 */

/*!
 * @name Register AFE_SWRST, field SYSCLK_SW_RST_N[0] (RW)
 *
 * Values:
 * - 0 - Reset
 * - 1 - Normal
 */
/*@{*/
#define BP_AFE_SWRST_SYSCLK_SW_RST_N (0U)  /*!< Bit position for AFE_SWRST_SYSCLK_SW_RST_N. */
#define BM_AFE_SWRST_SYSCLK_SW_RST_N (0x00000001U) /*!< Bit mask for AFE_SWRST_SYSCLK_SW_RST_N. */
#define BS_AFE_SWRST_SYSCLK_SW_RST_N (1U)  /*!< Bit field size in bits for AFE_SWRST_SYSCLK_SW_RST_N. */

/*! @brief Read current value of the AFE_SWRST_SYSCLK_SW_RST_N field. */
#define BR_AFE_SWRST_SYSCLK_SW_RST_N(x) (HW_AFE_SWRST(x).B.SYSCLK_SW_RST_N)

/*! @brief Format value for bitfield AFE_SWRST_SYSCLK_SW_RST_N. */
#define BF_AFE_SWRST_SYSCLK_SW_RST_N(v) ((uint32_t)((uint32_t)(v) << BP_AFE_SWRST_SYSCLK_SW_RST_N) & BM_AFE_SWRST_SYSCLK_SW_RST_N)

/*! @brief Set the SYSCLK_SW_RST_N field to a new value. */
#define BW_AFE_SWRST_SYSCLK_SW_RST_N(x, v) (HW_AFE_SWRST_WR(x, (HW_AFE_SWRST_RD(x) & ~BM_AFE_SWRST_SYSCLK_SW_RST_N) | BF_AFE_SWRST_SYSCLK_SW_RST_N(v)))
/*@}*/

/*!
 * @name Register AFE_SWRST, field ADC_PROC_CLK_SW_RST_N[1] (RW)
 *
 * Values:
 * - 0 - Reset
 * - 1 - Normal
 */
/*@{*/
#define BP_AFE_SWRST_ADC_PROC_CLK_SW_RST_N (1U) /*!< Bit position for AFE_SWRST_ADC_PROC_CLK_SW_RST_N. */
#define BM_AFE_SWRST_ADC_PROC_CLK_SW_RST_N (0x00000002U) /*!< Bit mask for AFE_SWRST_ADC_PROC_CLK_SW_RST_N. */
#define BS_AFE_SWRST_ADC_PROC_CLK_SW_RST_N (1U) /*!< Bit field size in bits for AFE_SWRST_ADC_PROC_CLK_SW_RST_N. */

/*! @brief Read current value of the AFE_SWRST_ADC_PROC_CLK_SW_RST_N field. */
#define BR_AFE_SWRST_ADC_PROC_CLK_SW_RST_N(x) (HW_AFE_SWRST(x).B.ADC_PROC_CLK_SW_RST_N)

/*! @brief Format value for bitfield AFE_SWRST_ADC_PROC_CLK_SW_RST_N. */
#define BF_AFE_SWRST_ADC_PROC_CLK_SW_RST_N(v) ((uint32_t)((uint32_t)(v) << BP_AFE_SWRST_ADC_PROC_CLK_SW_RST_N) & BM_AFE_SWRST_ADC_PROC_CLK_SW_RST_N)

/*! @brief Set the ADC_PROC_CLK_SW_RST_N field to a new value. */
#define BW_AFE_SWRST_ADC_PROC_CLK_SW_RST_N(x, v) (HW_AFE_SWRST_WR(x, (HW_AFE_SWRST_RD(x) & ~BM_AFE_SWRST_ADC_PROC_CLK_SW_RST_N) | BF_AFE_SWRST_ADC_PROC_CLK_SW_RST_N(v)))
/*@}*/

/*!
 * @name Register AFE_SWRST, field ACAFE_SW_RST_N[2] (RW)
 *
 * Values:
 * - 0 - Reset
 * - 1 - Normal
 */
/*@{*/
#define BP_AFE_SWRST_ACAFE_SW_RST_N (2U)   /*!< Bit position for AFE_SWRST_ACAFE_SW_RST_N. */
#define BM_AFE_SWRST_ACAFE_SW_RST_N (0x00000004U) /*!< Bit mask for AFE_SWRST_ACAFE_SW_RST_N. */
#define BS_AFE_SWRST_ACAFE_SW_RST_N (1U)   /*!< Bit field size in bits for AFE_SWRST_ACAFE_SW_RST_N. */

/*! @brief Read current value of the AFE_SWRST_ACAFE_SW_RST_N field. */
#define BR_AFE_SWRST_ACAFE_SW_RST_N(x) (HW_AFE_SWRST(x).B.ACAFE_SW_RST_N)

/*! @brief Format value for bitfield AFE_SWRST_ACAFE_SW_RST_N. */
#define BF_AFE_SWRST_ACAFE_SW_RST_N(v) ((uint32_t)((uint32_t)(v) << BP_AFE_SWRST_ACAFE_SW_RST_N) & BM_AFE_SWRST_ACAFE_SW_RST_N)

/*! @brief Set the ACAFE_SW_RST_N field to a new value. */
#define BW_AFE_SWRST_ACAFE_SW_RST_N(x, v) (HW_AFE_SWRST_WR(x, (HW_AFE_SWRST_RD(x) & ~BM_AFE_SWRST_ACAFE_SW_RST_N) | BF_AFE_SWRST_ACAFE_SW_RST_N(v)))
/*@}*/

/*******************************************************************************
 * HW_AFE_BGREG - Band Gap
 ******************************************************************************/

/*!
 * @brief HW_AFE_BGREG - Band Gap (RW)
 *
 * Reset value: 0x00000008U
 */
typedef union _hw_afe_bgreg
{
    uint32_t U;
    struct _hw_afe_bgreg_bitfields
    {
        uint32_t BGR_TRIMLEVEL : 4;    /*!< [3:0] Bandgap trim. */
        uint32_t BGR_EN_EXT_CURRENT : 1; /*!< [4] Enable external current
                                        * reference */
        uint32_t RESERVED0 : 27;       /*!< [31:5]  */
    } B;
} hw_afe_bgreg_t;

/*!
 * @name Constants and macros for entire AFE_BGREG register
 */
/*@{*/
#define HW_AFE_BGREG_ADDR(x)     ((uintptr_t)(x) + 0x18U)

#define HW_AFE_BGREG(x)          (*(__IO hw_afe_bgreg_t *) HW_AFE_BGREG_ADDR(x))
#define HW_AFE_BGREG_RD(x)       (HW_AFE_BGREG(x).U)
#define HW_AFE_BGREG_WR(x, v)    (HW_AFE_BGREG(x).U = (v))
#define HW_AFE_BGREG_SET(x, v)   (HW_AFE_BGREG_WR(x, HW_AFE_BGREG_RD(x) |  (v)))
#define HW_AFE_BGREG_CLR(x, v)   (HW_AFE_BGREG_WR(x, HW_AFE_BGREG_RD(x) & ~(v)))
#define HW_AFE_BGREG_TOG(x, v)   (HW_AFE_BGREG_WR(x, HW_AFE_BGREG_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AFE_BGREG bitfields
 */

/*!
 * @name Register AFE_BGREG, field BGR_TRIMLEVEL[3:0] (RW)
 *
 * Vbg(x) = 0.6*(1+0.1*(x-8)/8)
 *
 * Values:
 * - 0000 - V0540
 * - 0001 - V05475
 * - 1000 - V0600
 * - 1111 - V06525
 */
/*@{*/
#define BP_AFE_BGREG_BGR_TRIMLEVEL (0U)    /*!< Bit position for AFE_BGREG_BGR_TRIMLEVEL. */
#define BM_AFE_BGREG_BGR_TRIMLEVEL (0x0000000FU) /*!< Bit mask for AFE_BGREG_BGR_TRIMLEVEL. */
#define BS_AFE_BGREG_BGR_TRIMLEVEL (4U)    /*!< Bit field size in bits for AFE_BGREG_BGR_TRIMLEVEL. */

/*! @brief Read current value of the AFE_BGREG_BGR_TRIMLEVEL field. */
#define BR_AFE_BGREG_BGR_TRIMLEVEL(x) (HW_AFE_BGREG(x).B.BGR_TRIMLEVEL)

/*! @brief Format value for bitfield AFE_BGREG_BGR_TRIMLEVEL. */
#define BF_AFE_BGREG_BGR_TRIMLEVEL(v) ((uint32_t)((uint32_t)(v) << BP_AFE_BGREG_BGR_TRIMLEVEL) & BM_AFE_BGREG_BGR_TRIMLEVEL)

/*! @brief Set the BGR_TRIMLEVEL field to a new value. */
#define BW_AFE_BGREG_BGR_TRIMLEVEL(x, v) (HW_AFE_BGREG_WR(x, (HW_AFE_BGREG_RD(x) & ~BM_AFE_BGREG_BGR_TRIMLEVEL) | BF_AFE_BGREG_BGR_TRIMLEVEL(v)))
/*@}*/

/*!
 * @name Register AFE_BGREG, field BGR_EN_EXT_CURRENT[4] (RW)
 *
 * Values:
 * - 0 - Internal
 * - 1 - External
 */
/*@{*/
#define BP_AFE_BGREG_BGR_EN_EXT_CURRENT (4U) /*!< Bit position for AFE_BGREG_BGR_EN_EXT_CURRENT. */
#define BM_AFE_BGREG_BGR_EN_EXT_CURRENT (0x00000010U) /*!< Bit mask for AFE_BGREG_BGR_EN_EXT_CURRENT. */
#define BS_AFE_BGREG_BGR_EN_EXT_CURRENT (1U) /*!< Bit field size in bits for AFE_BGREG_BGR_EN_EXT_CURRENT. */

/*! @brief Read current value of the AFE_BGREG_BGR_EN_EXT_CURRENT field. */
#define BR_AFE_BGREG_BGR_EN_EXT_CURRENT(x) (HW_AFE_BGREG(x).B.BGR_EN_EXT_CURRENT)

/*! @brief Format value for bitfield AFE_BGREG_BGR_EN_EXT_CURRENT. */
#define BF_AFE_BGREG_BGR_EN_EXT_CURRENT(v) ((uint32_t)((uint32_t)(v) << BP_AFE_BGREG_BGR_EN_EXT_CURRENT) & BM_AFE_BGREG_BGR_EN_EXT_CURRENT)

/*! @brief Set the BGR_EN_EXT_CURRENT field to a new value. */
#define BW_AFE_BGREG_BGR_EN_EXT_CURRENT(x, v) (HW_AFE_BGREG_WR(x, (HW_AFE_BGREG_RD(x) & ~BM_AFE_BGREG_BGR_EN_EXT_CURRENT) | BF_AFE_BGREG_BGR_EN_EXT_CURRENT(v)))
/*@}*/

/*******************************************************************************
 * HW_AFE_ACCESSAR_ID - Accessar ID
 ******************************************************************************/

/*!
 * @brief HW_AFE_ACCESSAR_ID - Accessar ID (RO)
 *
 * Reset value: 0x00000011U
 */
typedef union _hw_afe_accessar_id
{
    uint32_t U;
    struct _hw_afe_accessar_id_bitfields
    {
        uint32_t ACCESSAR_ID : 8;      /*!< [7:0] Block ID and revision number */
        uint32_t RESERVED0 : 24;       /*!< [31:8]  */
    } B;
} hw_afe_accessar_id_t;

/*!
 * @name Constants and macros for entire AFE_ACCESSAR_ID register
 */
/*@{*/
#define HW_AFE_ACCESSAR_ID_ADDR(x) ((uintptr_t)(x) + 0x400U)

#define HW_AFE_ACCESSAR_ID(x)    (*(__I hw_afe_accessar_id_t *) HW_AFE_ACCESSAR_ID_ADDR(x))
#define HW_AFE_ACCESSAR_ID_RD(x) (HW_AFE_ACCESSAR_ID(x).U)
/*@}*/

/*
 * Constants & macros for individual AFE_ACCESSAR_ID bitfields
 */

/*!
 * @name Register AFE_ACCESSAR_ID, field ACCESSAR_ID[7:0] (RO)
 */
/*@{*/
#define BP_AFE_ACCESSAR_ID_ACCESSAR_ID (0U) /*!< Bit position for AFE_ACCESSAR_ID_ACCESSAR_ID. */
#define BM_AFE_ACCESSAR_ID_ACCESSAR_ID (0x000000FFU) /*!< Bit mask for AFE_ACCESSAR_ID_ACCESSAR_ID. */
#define BS_AFE_ACCESSAR_ID_ACCESSAR_ID (8U) /*!< Bit field size in bits for AFE_ACCESSAR_ID_ACCESSAR_ID. */

/*! @brief Read current value of the AFE_ACCESSAR_ID_ACCESSAR_ID field. */
#define BR_AFE_ACCESSAR_ID_ACCESSAR_ID(x) (HW_AFE_ACCESSAR_ID(x).B.ACCESSAR_ID)
/*@}*/

/*******************************************************************************
 * HW_AFE_PDADC - Power Down ADC
 ******************************************************************************/

/*!
 * @brief HW_AFE_PDADC - Power Down ADC (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_afe_pdadc
{
    uint32_t U;
    struct _hw_afe_pdadc_bitfields
    {
        uint32_t ACCESSAR_PD_N : 1;    /*!< [0] Accessar master power down
                                        * control. */
        uint32_t DLYLOOP_PD_N : 1;     /*!< [1]  */
        uint32_t ADC_IREF_PD_N : 1;    /*!< [2] Active low power down of ADC
                                        * iref */
        uint32_t CLAMP_PD_N : 1;       /*!< [3] Active-low power down of clamp
                                        * circuitry */
        uint32_t RESERVED0 : 28;       /*!< [31:4]  */
    } B;
} hw_afe_pdadc_t;

/*!
 * @name Constants and macros for entire AFE_PDADC register
 */
/*@{*/
#define HW_AFE_PDADC_ADDR(x)     ((uintptr_t)(x) + 0x404U)

#define HW_AFE_PDADC(x)          (*(__IO hw_afe_pdadc_t *) HW_AFE_PDADC_ADDR(x))
#define HW_AFE_PDADC_RD(x)       (HW_AFE_PDADC(x).U)
#define HW_AFE_PDADC_WR(x, v)    (HW_AFE_PDADC(x).U = (v))
#define HW_AFE_PDADC_SET(x, v)   (HW_AFE_PDADC_WR(x, HW_AFE_PDADC_RD(x) |  (v)))
#define HW_AFE_PDADC_CLR(x, v)   (HW_AFE_PDADC_WR(x, HW_AFE_PDADC_RD(x) & ~(v)))
#define HW_AFE_PDADC_TOG(x, v)   (HW_AFE_PDADC_WR(x, HW_AFE_PDADC_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AFE_PDADC bitfields
 */

/*!
 * @name Register AFE_PDADC, field ACCESSAR_PD_N[0] (RW)
 *
 * Active low power down of all ADC related blocks.
 *
 * Values:
 * - 0 - Power down
 * - 1 - Normal
 */
/*@{*/
#define BP_AFE_PDADC_ACCESSAR_PD_N (0U)    /*!< Bit position for AFE_PDADC_ACCESSAR_PD_N. */
#define BM_AFE_PDADC_ACCESSAR_PD_N (0x00000001U) /*!< Bit mask for AFE_PDADC_ACCESSAR_PD_N. */
#define BS_AFE_PDADC_ACCESSAR_PD_N (1U)    /*!< Bit field size in bits for AFE_PDADC_ACCESSAR_PD_N. */

/*! @brief Read current value of the AFE_PDADC_ACCESSAR_PD_N field. */
#define BR_AFE_PDADC_ACCESSAR_PD_N(x) (HW_AFE_PDADC(x).B.ACCESSAR_PD_N)

/*! @brief Format value for bitfield AFE_PDADC_ACCESSAR_PD_N. */
#define BF_AFE_PDADC_ACCESSAR_PD_N(v) ((uint32_t)((uint32_t)(v) << BP_AFE_PDADC_ACCESSAR_PD_N) & BM_AFE_PDADC_ACCESSAR_PD_N)

/*! @brief Set the ACCESSAR_PD_N field to a new value. */
#define BW_AFE_PDADC_ACCESSAR_PD_N(x, v) (HW_AFE_PDADC_WR(x, (HW_AFE_PDADC_RD(x) & ~BM_AFE_PDADC_ACCESSAR_PD_N) | BF_AFE_PDADC_ACCESSAR_PD_N(v)))
/*@}*/

/*!
 * @name Register AFE_PDADC, field DLYLOOP_PD_N[1] (RW)
 *
 * Active low power down of ADC delay loop reference.
 *
 * Values:
 * - 0 - Power down
 * - 1 - Normal
 */
/*@{*/
#define BP_AFE_PDADC_DLYLOOP_PD_N (1U)     /*!< Bit position for AFE_PDADC_DLYLOOP_PD_N. */
#define BM_AFE_PDADC_DLYLOOP_PD_N (0x00000002U) /*!< Bit mask for AFE_PDADC_DLYLOOP_PD_N. */
#define BS_AFE_PDADC_DLYLOOP_PD_N (1U)     /*!< Bit field size in bits for AFE_PDADC_DLYLOOP_PD_N. */

/*! @brief Read current value of the AFE_PDADC_DLYLOOP_PD_N field. */
#define BR_AFE_PDADC_DLYLOOP_PD_N(x) (HW_AFE_PDADC(x).B.DLYLOOP_PD_N)

/*! @brief Format value for bitfield AFE_PDADC_DLYLOOP_PD_N. */
#define BF_AFE_PDADC_DLYLOOP_PD_N(v) ((uint32_t)((uint32_t)(v) << BP_AFE_PDADC_DLYLOOP_PD_N) & BM_AFE_PDADC_DLYLOOP_PD_N)

/*! @brief Set the DLYLOOP_PD_N field to a new value. */
#define BW_AFE_PDADC_DLYLOOP_PD_N(x, v) (HW_AFE_PDADC_WR(x, (HW_AFE_PDADC_RD(x) & ~BM_AFE_PDADC_DLYLOOP_PD_N) | BF_AFE_PDADC_DLYLOOP_PD_N(v)))
/*@}*/

/*!
 * @name Register AFE_PDADC, field ADC_IREF_PD_N[2] (RW)
 *
 * Values:
 * - 0 - Power down
 * - 1 - Normal
 */
/*@{*/
#define BP_AFE_PDADC_ADC_IREF_PD_N (2U)    /*!< Bit position for AFE_PDADC_ADC_IREF_PD_N. */
#define BM_AFE_PDADC_ADC_IREF_PD_N (0x00000004U) /*!< Bit mask for AFE_PDADC_ADC_IREF_PD_N. */
#define BS_AFE_PDADC_ADC_IREF_PD_N (1U)    /*!< Bit field size in bits for AFE_PDADC_ADC_IREF_PD_N. */

/*! @brief Read current value of the AFE_PDADC_ADC_IREF_PD_N field. */
#define BR_AFE_PDADC_ADC_IREF_PD_N(x) (HW_AFE_PDADC(x).B.ADC_IREF_PD_N)

/*! @brief Format value for bitfield AFE_PDADC_ADC_IREF_PD_N. */
#define BF_AFE_PDADC_ADC_IREF_PD_N(v) ((uint32_t)((uint32_t)(v) << BP_AFE_PDADC_ADC_IREF_PD_N) & BM_AFE_PDADC_ADC_IREF_PD_N)

/*! @brief Set the ADC_IREF_PD_N field to a new value. */
#define BW_AFE_PDADC_ADC_IREF_PD_N(x, v) (HW_AFE_PDADC_WR(x, (HW_AFE_PDADC_RD(x) & ~BM_AFE_PDADC_ADC_IREF_PD_N) | BF_AFE_PDADC_ADC_IREF_PD_N(v)))
/*@}*/

/*!
 * @name Register AFE_PDADC, field CLAMP_PD_N[3] (RW)
 *
 * Values:
 * - 0 - Power down
 * - 1 - Normal
 */
/*@{*/
#define BP_AFE_PDADC_CLAMP_PD_N (3U)       /*!< Bit position for AFE_PDADC_CLAMP_PD_N. */
#define BM_AFE_PDADC_CLAMP_PD_N (0x00000008U) /*!< Bit mask for AFE_PDADC_CLAMP_PD_N. */
#define BS_AFE_PDADC_CLAMP_PD_N (1U)       /*!< Bit field size in bits for AFE_PDADC_CLAMP_PD_N. */

/*! @brief Read current value of the AFE_PDADC_CLAMP_PD_N field. */
#define BR_AFE_PDADC_CLAMP_PD_N(x) (HW_AFE_PDADC(x).B.CLAMP_PD_N)

/*! @brief Format value for bitfield AFE_PDADC_CLAMP_PD_N. */
#define BF_AFE_PDADC_CLAMP_PD_N(v) ((uint32_t)((uint32_t)(v) << BP_AFE_PDADC_CLAMP_PD_N) & BM_AFE_PDADC_CLAMP_PD_N)

/*! @brief Set the CLAMP_PD_N field to a new value. */
#define BW_AFE_PDADC_CLAMP_PD_N(x, v) (HW_AFE_PDADC_WR(x, (HW_AFE_PDADC_RD(x) & ~BM_AFE_PDADC_CLAMP_PD_N) | BF_AFE_PDADC_CLAMP_PD_N(v)))
/*@}*/

/*******************************************************************************
 * HW_AFE_PDSARH - Power Down SAR High
 ******************************************************************************/

/*!
 * @brief HW_AFE_PDSARH - Power Down SAR High (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_afe_pdsarh
{
    uint32_t U;
    struct _hw_afe_pdsarh_bitfields
    {
        uint32_t ADC_PD_N : 1;         /*!< [0] Active-low power down of ADC, one bit
                                        * per SAR ADC */
        uint32_t RESERVED0 : 31;       /*!< [31:1]  */
    } B;
} hw_afe_pdsarh_t;

/*!
 * @name Constants and macros for entire AFE_PDSARH register
 */
/*@{*/
#define HW_AFE_PDSARH_ADDR(x)    ((uintptr_t)(x) + 0x408U)

#define HW_AFE_PDSARH(x)         (*(__IO hw_afe_pdsarh_t *) HW_AFE_PDSARH_ADDR(x))
#define HW_AFE_PDSARH_RD(x)      (HW_AFE_PDSARH(x).U)
#define HW_AFE_PDSARH_WR(x, v)   (HW_AFE_PDSARH(x).U = (v))
#define HW_AFE_PDSARH_SET(x, v)  (HW_AFE_PDSARH_WR(x, HW_AFE_PDSARH_RD(x) |  (v)))
#define HW_AFE_PDSARH_CLR(x, v)  (HW_AFE_PDSARH_WR(x, HW_AFE_PDSARH_RD(x) & ~(v)))
#define HW_AFE_PDSARH_TOG(x, v)  (HW_AFE_PDSARH_WR(x, HW_AFE_PDSARH_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AFE_PDSARH bitfields
 */

/*!
 * @name Register AFE_PDSARH, field ADC_PD_N[0] (RW)
 *
 * Values:
 * - 0 - Power down
 * - 1 - Normal
 */
/*@{*/
#define BP_AFE_PDSARH_ADC_PD_N (0U)        /*!< Bit position for AFE_PDSARH_ADC_PD_N. */
#define BM_AFE_PDSARH_ADC_PD_N (0x00000001U) /*!< Bit mask for AFE_PDSARH_ADC_PD_N. */
#define BS_AFE_PDSARH_ADC_PD_N (1U)        /*!< Bit field size in bits for AFE_PDSARH_ADC_PD_N. */

/*! @brief Read current value of the AFE_PDSARH_ADC_PD_N field. */
#define BR_AFE_PDSARH_ADC_PD_N(x) (HW_AFE_PDSARH(x).B.ADC_PD_N)

/*! @brief Format value for bitfield AFE_PDSARH_ADC_PD_N. */
#define BF_AFE_PDSARH_ADC_PD_N(v) ((uint32_t)((uint32_t)(v) << BP_AFE_PDSARH_ADC_PD_N) & BM_AFE_PDSARH_ADC_PD_N)

/*! @brief Set the ADC_PD_N field to a new value. */
#define BW_AFE_PDSARH_ADC_PD_N(x, v) (HW_AFE_PDSARH_WR(x, (HW_AFE_PDSARH_RD(x) & ~BM_AFE_PDSARH_ADC_PD_N) | BF_AFE_PDSARH_ADC_PD_N(v)))
/*@}*/

/*******************************************************************************
 * HW_AFE_PDSARL - Power Down SAR Low
 ******************************************************************************/

/*!
 * @brief HW_AFE_PDSARL - Power Down SAR Low (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_afe_pdsarl
{
    uint32_t U;
    struct _hw_afe_pdsarl_bitfields
    {
        uint32_t ADC_PD_N : 8;         /*!< [7:0] Active-low power down of ADC, one
                                        * bit per SAR ADC */
        uint32_t RESERVED0 : 24;       /*!< [31:8]  */
    } B;
} hw_afe_pdsarl_t;

/*!
 * @name Constants and macros for entire AFE_PDSARL register
 */
/*@{*/
#define HW_AFE_PDSARL_ADDR(x)    ((uintptr_t)(x) + 0x40CU)

#define HW_AFE_PDSARL(x)         (*(__IO hw_afe_pdsarl_t *) HW_AFE_PDSARL_ADDR(x))
#define HW_AFE_PDSARL_RD(x)      (HW_AFE_PDSARL(x).U)
#define HW_AFE_PDSARL_WR(x, v)   (HW_AFE_PDSARL(x).U = (v))
#define HW_AFE_PDSARL_SET(x, v)  (HW_AFE_PDSARL_WR(x, HW_AFE_PDSARL_RD(x) |  (v)))
#define HW_AFE_PDSARL_CLR(x, v)  (HW_AFE_PDSARL_WR(x, HW_AFE_PDSARL_RD(x) & ~(v)))
#define HW_AFE_PDSARL_TOG(x, v)  (HW_AFE_PDSARL_WR(x, HW_AFE_PDSARL_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AFE_PDSARL bitfields
 */

/*!
 * @name Register AFE_PDSARL, field ADC_PD_N[7:0] (RW)
 *
 * Values:
 * - 0 - Power down
 * - 1 - Normal
 */
/*@{*/
#define BP_AFE_PDSARL_ADC_PD_N (0U)        /*!< Bit position for AFE_PDSARL_ADC_PD_N. */
#define BM_AFE_PDSARL_ADC_PD_N (0x000000FFU) /*!< Bit mask for AFE_PDSARL_ADC_PD_N. */
#define BS_AFE_PDSARL_ADC_PD_N (8U)        /*!< Bit field size in bits for AFE_PDSARL_ADC_PD_N. */

/*! @brief Read current value of the AFE_PDSARL_ADC_PD_N field. */
#define BR_AFE_PDSARL_ADC_PD_N(x) (HW_AFE_PDSARL(x).B.ADC_PD_N)

/*! @brief Format value for bitfield AFE_PDSARL_ADC_PD_N. */
#define BF_AFE_PDSARL_ADC_PD_N(v) ((uint32_t)((uint32_t)(v) << BP_AFE_PDSARL_ADC_PD_N) & BM_AFE_PDSARL_ADC_PD_N)

/*! @brief Set the ADC_PD_N field to a new value. */
#define BW_AFE_PDSARL_ADC_PD_N(x, v) (HW_AFE_PDSARL_WR(x, (HW_AFE_PDSARL_RD(x) & ~BM_AFE_PDSARL_ADC_PD_N) | BF_AFE_PDSARL_ADC_PD_N(v)))
/*@}*/

/*******************************************************************************
 * HW_AFE_PDADCRFH - Power Down ADC Ref. High
 ******************************************************************************/

/*!
 * @brief HW_AFE_PDADCRFH - Power Down ADC Ref. High (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_afe_pdadcrfh
{
    uint32_t U;
    struct _hw_afe_pdadcrfh_bitfields
    {
        uint32_t ADCREF_REFBUFSLICE_PD_N : 1; /*!< [0] Active-low power down
                                        * of ADC reference, one bit per SAR ADC */
        uint32_t RESERVED0 : 31;       /*!< [31:1]  */
    } B;
} hw_afe_pdadcrfh_t;

/*!
 * @name Constants and macros for entire AFE_PDADCRFH register
 */
/*@{*/
#define HW_AFE_PDADCRFH_ADDR(x)  ((uintptr_t)(x) + 0x410U)

#define HW_AFE_PDADCRFH(x)       (*(__IO hw_afe_pdadcrfh_t *) HW_AFE_PDADCRFH_ADDR(x))
#define HW_AFE_PDADCRFH_RD(x)    (HW_AFE_PDADCRFH(x).U)
#define HW_AFE_PDADCRFH_WR(x, v) (HW_AFE_PDADCRFH(x).U = (v))
#define HW_AFE_PDADCRFH_SET(x, v) (HW_AFE_PDADCRFH_WR(x, HW_AFE_PDADCRFH_RD(x) |  (v)))
#define HW_AFE_PDADCRFH_CLR(x, v) (HW_AFE_PDADCRFH_WR(x, HW_AFE_PDADCRFH_RD(x) & ~(v)))
#define HW_AFE_PDADCRFH_TOG(x, v) (HW_AFE_PDADCRFH_WR(x, HW_AFE_PDADCRFH_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AFE_PDADCRFH bitfields
 */

/*!
 * @name Register AFE_PDADCRFH, field ADCREF_REFBUFSLICE_PD_N[0] (RW)
 *
 * Values:
 * - 0 - Power down
 * - 1 - Normal
 */
/*@{*/
#define BP_AFE_PDADCRFH_ADCREF_REFBUFSLICE_PD_N (0U) /*!< Bit position for AFE_PDADCRFH_ADCREF_REFBUFSLICE_PD_N. */
#define BM_AFE_PDADCRFH_ADCREF_REFBUFSLICE_PD_N (0x00000001U) /*!< Bit mask for AFE_PDADCRFH_ADCREF_REFBUFSLICE_PD_N. */
#define BS_AFE_PDADCRFH_ADCREF_REFBUFSLICE_PD_N (1U) /*!< Bit field size in bits for AFE_PDADCRFH_ADCREF_REFBUFSLICE_PD_N. */

/*! @brief Read current value of the AFE_PDADCRFH_ADCREF_REFBUFSLICE_PD_N field. */
#define BR_AFE_PDADCRFH_ADCREF_REFBUFSLICE_PD_N(x) (HW_AFE_PDADCRFH(x).B.ADCREF_REFBUFSLICE_PD_N)

/*! @brief Format value for bitfield AFE_PDADCRFH_ADCREF_REFBUFSLICE_PD_N. */
#define BF_AFE_PDADCRFH_ADCREF_REFBUFSLICE_PD_N(v) ((uint32_t)((uint32_t)(v) << BP_AFE_PDADCRFH_ADCREF_REFBUFSLICE_PD_N) & BM_AFE_PDADCRFH_ADCREF_REFBUFSLICE_PD_N)

/*! @brief Set the ADCREF_REFBUFSLICE_PD_N field to a new value. */
#define BW_AFE_PDADCRFH_ADCREF_REFBUFSLICE_PD_N(x, v) (HW_AFE_PDADCRFH_WR(x, (HW_AFE_PDADCRFH_RD(x) & ~BM_AFE_PDADCRFH_ADCREF_REFBUFSLICE_PD_N) | BF_AFE_PDADCRFH_ADCREF_REFBUFSLICE_PD_N(v)))
/*@}*/

/*******************************************************************************
 * HW_AFE_PDADCRFL - Power Down ADC Ref. Low
 ******************************************************************************/

/*!
 * @brief HW_AFE_PDADCRFL - Power Down ADC Ref. Low (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_afe_pdadcrfl
{
    uint32_t U;
    struct _hw_afe_pdadcrfl_bitfields
    {
        uint32_t ADCREF_REFBUFSLICE_PD_N : 8; /*!< [7:0] Active-low power
                                        * down of ADC reference, one bit per SAR ADC */
        uint32_t RESERVED0 : 24;       /*!< [31:8]  */
    } B;
} hw_afe_pdadcrfl_t;

/*!
 * @name Constants and macros for entire AFE_PDADCRFL register
 */
/*@{*/
#define HW_AFE_PDADCRFL_ADDR(x)  ((uintptr_t)(x) + 0x414U)

#define HW_AFE_PDADCRFL(x)       (*(__IO hw_afe_pdadcrfl_t *) HW_AFE_PDADCRFL_ADDR(x))
#define HW_AFE_PDADCRFL_RD(x)    (HW_AFE_PDADCRFL(x).U)
#define HW_AFE_PDADCRFL_WR(x, v) (HW_AFE_PDADCRFL(x).U = (v))
#define HW_AFE_PDADCRFL_SET(x, v) (HW_AFE_PDADCRFL_WR(x, HW_AFE_PDADCRFL_RD(x) |  (v)))
#define HW_AFE_PDADCRFL_CLR(x, v) (HW_AFE_PDADCRFL_WR(x, HW_AFE_PDADCRFL_RD(x) & ~(v)))
#define HW_AFE_PDADCRFL_TOG(x, v) (HW_AFE_PDADCRFL_WR(x, HW_AFE_PDADCRFL_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AFE_PDADCRFL bitfields
 */

/*!
 * @name Register AFE_PDADCRFL, field ADCREF_REFBUFSLICE_PD_N[7:0] (RW)
 *
 * Values:
 * - 0 - Power down
 * - 1 - Normal
 */
/*@{*/
#define BP_AFE_PDADCRFL_ADCREF_REFBUFSLICE_PD_N (0U) /*!< Bit position for AFE_PDADCRFL_ADCREF_REFBUFSLICE_PD_N. */
#define BM_AFE_PDADCRFL_ADCREF_REFBUFSLICE_PD_N (0x000000FFU) /*!< Bit mask for AFE_PDADCRFL_ADCREF_REFBUFSLICE_PD_N. */
#define BS_AFE_PDADCRFL_ADCREF_REFBUFSLICE_PD_N (8U) /*!< Bit field size in bits for AFE_PDADCRFL_ADCREF_REFBUFSLICE_PD_N. */

/*! @brief Read current value of the AFE_PDADCRFL_ADCREF_REFBUFSLICE_PD_N field. */
#define BR_AFE_PDADCRFL_ADCREF_REFBUFSLICE_PD_N(x) (HW_AFE_PDADCRFL(x).B.ADCREF_REFBUFSLICE_PD_N)

/*! @brief Format value for bitfield AFE_PDADCRFL_ADCREF_REFBUFSLICE_PD_N. */
#define BF_AFE_PDADCRFL_ADCREF_REFBUFSLICE_PD_N(v) ((uint32_t)((uint32_t)(v) << BP_AFE_PDADCRFL_ADCREF_REFBUFSLICE_PD_N) & BM_AFE_PDADCRFL_ADCREF_REFBUFSLICE_PD_N)

/*! @brief Set the ADCREF_REFBUFSLICE_PD_N field to a new value. */
#define BW_AFE_PDADCRFL_ADCREF_REFBUFSLICE_PD_N(x, v) (HW_AFE_PDADCRFL_WR(x, (HW_AFE_PDADCRFL_RD(x) & ~BM_AFE_PDADCRFL_ADCREF_REFBUFSLICE_PD_N) | BF_AFE_PDADCRFL_ADCREF_REFBUFSLICE_PD_N(v)))
/*@}*/

/*******************************************************************************
 * HW_AFE_ADCGN - ADC Gain
 ******************************************************************************/

/*!
 * @brief HW_AFE_ADCGN - ADC Gain (RW)
 *
 * Reset value: 0x0000000FU
 */
typedef union _hw_afe_adcgn
{
    uint32_t U;
    struct _hw_afe_adcgn_bitfields
    {
        uint32_t ADC_GAIN : 4;         /*!< [3:0] ADC gain setting */
        uint32_t RESERVED0 : 28;       /*!< [31:4]  */
    } B;
} hw_afe_adcgn_t;

/*!
 * @name Constants and macros for entire AFE_ADCGN register
 */
/*@{*/
#define HW_AFE_ADCGN_ADDR(x)     ((uintptr_t)(x) + 0x41CU)

#define HW_AFE_ADCGN(x)          (*(__IO hw_afe_adcgn_t *) HW_AFE_ADCGN_ADDR(x))
#define HW_AFE_ADCGN_RD(x)       (HW_AFE_ADCGN(x).U)
#define HW_AFE_ADCGN_WR(x, v)    (HW_AFE_ADCGN(x).U = (v))
#define HW_AFE_ADCGN_SET(x, v)   (HW_AFE_ADCGN_WR(x, HW_AFE_ADCGN_RD(x) |  (v)))
#define HW_AFE_ADCGN_CLR(x, v)   (HW_AFE_ADCGN_WR(x, HW_AFE_ADCGN_RD(x) & ~(v)))
#define HW_AFE_ADCGN_TOG(x, v)   (HW_AFE_ADCGN_WR(x, HW_AFE_ADCGN_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AFE_ADCGN bitfields
 */

/*!
 * @name Register AFE_ADCGN, field ADC_GAIN[3:0] (RW)
 *
 * Values:
 * - 0000 - No signal
 * - 0001 - 1/16
 * - 0010 - 2/16
 * - 1111 - 15/6
 */
/*@{*/
#define BP_AFE_ADCGN_ADC_GAIN (0U)         /*!< Bit position for AFE_ADCGN_ADC_GAIN. */
#define BM_AFE_ADCGN_ADC_GAIN (0x0000000FU) /*!< Bit mask for AFE_ADCGN_ADC_GAIN. */
#define BS_AFE_ADCGN_ADC_GAIN (4U)         /*!< Bit field size in bits for AFE_ADCGN_ADC_GAIN. */

/*! @brief Read current value of the AFE_ADCGN_ADC_GAIN field. */
#define BR_AFE_ADCGN_ADC_GAIN(x) (HW_AFE_ADCGN(x).B.ADC_GAIN)

/*! @brief Format value for bitfield AFE_ADCGN_ADC_GAIN. */
#define BF_AFE_ADCGN_ADC_GAIN(v) ((uint32_t)((uint32_t)(v) << BP_AFE_ADCGN_ADC_GAIN) & BM_AFE_ADCGN_ADC_GAIN)

/*! @brief Set the ADC_GAIN field to a new value. */
#define BW_AFE_ADCGN_ADC_GAIN(x, v) (HW_AFE_ADCGN_WR(x, (HW_AFE_ADCGN_RD(x) & ~BM_AFE_ADCGN_ADC_GAIN) | BF_AFE_ADCGN_ADC_GAIN(v)))
/*@}*/

/*******************************************************************************
 * HW_AFE_REFTRIML - ADC Ref Trim Low
 ******************************************************************************/

/*!
 * @brief HW_AFE_REFTRIML - ADC Ref Trim Low (RW)
 *
 * Reset value: 0x00000055U
 */
typedef union _hw_afe_reftriml
{
    uint32_t U;
    struct _hw_afe_reftriml_bitfields
    {
        uint32_t ADCREF_REFTRIM08 : 2; /*!< [1:0] ADC reference. */
        uint32_t ADCREF_REFTRIM04 : 2; /*!< [3:2] ADC reference */
        uint32_t ADCREF_REFTRIM02 : 2; /*!< [5:4] ADC reference */
        uint32_t ADCREF_REFTRIMOP : 2; /*!< [7:6] ADC reference. */
        uint32_t RESERVED0 : 24;       /*!< [31:8]  */
    } B;
} hw_afe_reftriml_t;

/*!
 * @name Constants and macros for entire AFE_REFTRIML register
 */
/*@{*/
#define HW_AFE_REFTRIML_ADDR(x)  ((uintptr_t)(x) + 0x434U)

#define HW_AFE_REFTRIML(x)       (*(__IO hw_afe_reftriml_t *) HW_AFE_REFTRIML_ADDR(x))
#define HW_AFE_REFTRIML_RD(x)    (HW_AFE_REFTRIML(x).U)
#define HW_AFE_REFTRIML_WR(x, v) (HW_AFE_REFTRIML(x).U = (v))
#define HW_AFE_REFTRIML_SET(x, v) (HW_AFE_REFTRIML_WR(x, HW_AFE_REFTRIML_RD(x) |  (v)))
#define HW_AFE_REFTRIML_CLR(x, v) (HW_AFE_REFTRIML_WR(x, HW_AFE_REFTRIML_RD(x) & ~(v)))
#define HW_AFE_REFTRIML_TOG(x, v) (HW_AFE_REFTRIML_WR(x, HW_AFE_REFTRIML_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AFE_REFTRIML bitfields
 */

/*!
 * @name Register AFE_REFTRIML, field ADCREF_REFTRIM08[1:0] (RW)
 *
 * Trim 0.8V reference.
 *
 * Values:
 * - 00 - Low
 * - 01 - Mid
 * - 10 - Mid
 * - 11 - High
 */
/*@{*/
#define BP_AFE_REFTRIML_ADCREF_REFTRIM08 (0U) /*!< Bit position for AFE_REFTRIML_ADCREF_REFTRIM08. */
#define BM_AFE_REFTRIML_ADCREF_REFTRIM08 (0x00000003U) /*!< Bit mask for AFE_REFTRIML_ADCREF_REFTRIM08. */
#define BS_AFE_REFTRIML_ADCREF_REFTRIM08 (2U) /*!< Bit field size in bits for AFE_REFTRIML_ADCREF_REFTRIM08. */

/*! @brief Read current value of the AFE_REFTRIML_ADCREF_REFTRIM08 field. */
#define BR_AFE_REFTRIML_ADCREF_REFTRIM08(x) (HW_AFE_REFTRIML(x).B.ADCREF_REFTRIM08)

/*! @brief Format value for bitfield AFE_REFTRIML_ADCREF_REFTRIM08. */
#define BF_AFE_REFTRIML_ADCREF_REFTRIM08(v) ((uint32_t)((uint32_t)(v) << BP_AFE_REFTRIML_ADCREF_REFTRIM08) & BM_AFE_REFTRIML_ADCREF_REFTRIM08)

/*! @brief Set the ADCREF_REFTRIM08 field to a new value. */
#define BW_AFE_REFTRIML_ADCREF_REFTRIM08(x, v) (HW_AFE_REFTRIML_WR(x, (HW_AFE_REFTRIML_RD(x) & ~BM_AFE_REFTRIML_ADCREF_REFTRIM08) | BF_AFE_REFTRIML_ADCREF_REFTRIM08(v)))
/*@}*/

/*!
 * @name Register AFE_REFTRIML, field ADCREF_REFTRIM04[3:2] (RW)
 *
 * Trim 0.8V common-mode reference.
 *
 * Values:
 * - 00 - Low
 * - 01 - Mid
 * - 10 - Mid
 * - 11 - High
 */
/*@{*/
#define BP_AFE_REFTRIML_ADCREF_REFTRIM04 (2U) /*!< Bit position for AFE_REFTRIML_ADCREF_REFTRIM04. */
#define BM_AFE_REFTRIML_ADCREF_REFTRIM04 (0x0000000CU) /*!< Bit mask for AFE_REFTRIML_ADCREF_REFTRIM04. */
#define BS_AFE_REFTRIML_ADCREF_REFTRIM04 (2U) /*!< Bit field size in bits for AFE_REFTRIML_ADCREF_REFTRIM04. */

/*! @brief Read current value of the AFE_REFTRIML_ADCREF_REFTRIM04 field. */
#define BR_AFE_REFTRIML_ADCREF_REFTRIM04(x) (HW_AFE_REFTRIML(x).B.ADCREF_REFTRIM04)

/*! @brief Format value for bitfield AFE_REFTRIML_ADCREF_REFTRIM04. */
#define BF_AFE_REFTRIML_ADCREF_REFTRIM04(v) ((uint32_t)((uint32_t)(v) << BP_AFE_REFTRIML_ADCREF_REFTRIM04) & BM_AFE_REFTRIML_ADCREF_REFTRIM04)

/*! @brief Set the ADCREF_REFTRIM04 field to a new value. */
#define BW_AFE_REFTRIML_ADCREF_REFTRIM04(x, v) (HW_AFE_REFTRIML_WR(x, (HW_AFE_REFTRIML_RD(x) & ~BM_AFE_REFTRIML_ADCREF_REFTRIM04) | BF_AFE_REFTRIML_ADCREF_REFTRIM04(v)))
/*@}*/

/*!
 * @name Register AFE_REFTRIML, field ADCREF_REFTRIM02[5:4] (RW)
 *
 * Trim 0.2V reference.
 *
 * Values:
 * - 00 - Low
 * - 01 - Mid
 * - 10 - Mid
 * - 11 - High
 */
/*@{*/
#define BP_AFE_REFTRIML_ADCREF_REFTRIM02 (4U) /*!< Bit position for AFE_REFTRIML_ADCREF_REFTRIM02. */
#define BM_AFE_REFTRIML_ADCREF_REFTRIM02 (0x00000030U) /*!< Bit mask for AFE_REFTRIML_ADCREF_REFTRIM02. */
#define BS_AFE_REFTRIML_ADCREF_REFTRIM02 (2U) /*!< Bit field size in bits for AFE_REFTRIML_ADCREF_REFTRIM02. */

/*! @brief Read current value of the AFE_REFTRIML_ADCREF_REFTRIM02 field. */
#define BR_AFE_REFTRIML_ADCREF_REFTRIM02(x) (HW_AFE_REFTRIML(x).B.ADCREF_REFTRIM02)

/*! @brief Format value for bitfield AFE_REFTRIML_ADCREF_REFTRIM02. */
#define BF_AFE_REFTRIML_ADCREF_REFTRIM02(v) ((uint32_t)((uint32_t)(v) << BP_AFE_REFTRIML_ADCREF_REFTRIM02) & BM_AFE_REFTRIML_ADCREF_REFTRIM02)

/*! @brief Set the ADCREF_REFTRIM02 field to a new value. */
#define BW_AFE_REFTRIML_ADCREF_REFTRIM02(x, v) (HW_AFE_REFTRIML_WR(x, (HW_AFE_REFTRIML_RD(x) & ~BM_AFE_REFTRIML_ADCREF_REFTRIM02) | BF_AFE_REFTRIML_ADCREF_REFTRIM02(v)))
/*@}*/

/*!
 * @name Register AFE_REFTRIML, field ADCREF_REFTRIMOP[7:6] (RW)
 *
 * Trim reference buffers. Binary coded.
 *
 * Values:
 * - 00 - X1
 * - 01 - X2
 * - 10 - X2
 * - 11 - X3
 */
/*@{*/
#define BP_AFE_REFTRIML_ADCREF_REFTRIMOP (6U) /*!< Bit position for AFE_REFTRIML_ADCREF_REFTRIMOP. */
#define BM_AFE_REFTRIML_ADCREF_REFTRIMOP (0x000000C0U) /*!< Bit mask for AFE_REFTRIML_ADCREF_REFTRIMOP. */
#define BS_AFE_REFTRIML_ADCREF_REFTRIMOP (2U) /*!< Bit field size in bits for AFE_REFTRIML_ADCREF_REFTRIMOP. */

/*! @brief Read current value of the AFE_REFTRIML_ADCREF_REFTRIMOP field. */
#define BR_AFE_REFTRIML_ADCREF_REFTRIMOP(x) (HW_AFE_REFTRIML(x).B.ADCREF_REFTRIMOP)

/*! @brief Format value for bitfield AFE_REFTRIML_ADCREF_REFTRIMOP. */
#define BF_AFE_REFTRIML_ADCREF_REFTRIMOP(v) ((uint32_t)((uint32_t)(v) << BP_AFE_REFTRIML_ADCREF_REFTRIMOP) & BM_AFE_REFTRIML_ADCREF_REFTRIMOP)

/*! @brief Set the ADCREF_REFTRIMOP field to a new value. */
#define BW_AFE_REFTRIML_ADCREF_REFTRIMOP(x, v) (HW_AFE_REFTRIML_WR(x, (HW_AFE_REFTRIML_RD(x) & ~BM_AFE_REFTRIML_ADCREF_REFTRIMOP) | BF_AFE_REFTRIML_ADCREF_REFTRIMOP(v)))
/*@}*/

/*******************************************************************************
 * HW_AFE_REFTRIMH - ADC Ref Trim High
 ******************************************************************************/

/*!
 * @brief HW_AFE_REFTRIMH - ADC Ref Trim High (RW)
 *
 * Reset value: 0x00000008U
 */
typedef union _hw_afe_reftrimh
{
    uint32_t U;
    struct _hw_afe_reftrimh_bitfields
    {
        uint32_t ADCREF_REFTRIM : 4;   /*!< [3:0] ADC reference */
        uint32_t RESERVED0 : 28;       /*!< [31:4]  */
    } B;
} hw_afe_reftrimh_t;

/*!
 * @name Constants and macros for entire AFE_REFTRIMH register
 */
/*@{*/
#define HW_AFE_REFTRIMH_ADDR(x)  ((uintptr_t)(x) + 0x438U)

#define HW_AFE_REFTRIMH(x)       (*(__IO hw_afe_reftrimh_t *) HW_AFE_REFTRIMH_ADDR(x))
#define HW_AFE_REFTRIMH_RD(x)    (HW_AFE_REFTRIMH(x).U)
#define HW_AFE_REFTRIMH_WR(x, v) (HW_AFE_REFTRIMH(x).U = (v))
#define HW_AFE_REFTRIMH_SET(x, v) (HW_AFE_REFTRIMH_WR(x, HW_AFE_REFTRIMH_RD(x) |  (v)))
#define HW_AFE_REFTRIMH_CLR(x, v) (HW_AFE_REFTRIMH_WR(x, HW_AFE_REFTRIMH_RD(x) & ~(v)))
#define HW_AFE_REFTRIMH_TOG(x, v) (HW_AFE_REFTRIMH_WR(x, HW_AFE_REFTRIMH_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AFE_REFTRIMH bitfields
 */

/*!
 * @name Register AFE_REFTRIMH, field ADCREF_REFTRIM[3:0] (RW)
 *
 * Master trim. Binary coded. Vref_master(x) = Vref * (12+0.25*x)/14
 *
 * Values:
 * - 0000 - REF_0_86
 * - 0001 - REF_0_88
 * - 0010 - REF_0_89
 * - 0100 - Ref_0_93
 * - 1000 - REF_1_00
 * - 1111 - REF_1_13
 */
/*@{*/
#define BP_AFE_REFTRIMH_ADCREF_REFTRIM (0U) /*!< Bit position for AFE_REFTRIMH_ADCREF_REFTRIM. */
#define BM_AFE_REFTRIMH_ADCREF_REFTRIM (0x0000000FU) /*!< Bit mask for AFE_REFTRIMH_ADCREF_REFTRIM. */
#define BS_AFE_REFTRIMH_ADCREF_REFTRIM (4U) /*!< Bit field size in bits for AFE_REFTRIMH_ADCREF_REFTRIM. */

/*! @brief Read current value of the AFE_REFTRIMH_ADCREF_REFTRIM field. */
#define BR_AFE_REFTRIMH_ADCREF_REFTRIM(x) (HW_AFE_REFTRIMH(x).B.ADCREF_REFTRIM)

/*! @brief Format value for bitfield AFE_REFTRIMH_ADCREF_REFTRIM. */
#define BF_AFE_REFTRIMH_ADCREF_REFTRIM(v) ((uint32_t)((uint32_t)(v) << BP_AFE_REFTRIMH_ADCREF_REFTRIM) & BM_AFE_REFTRIMH_ADCREF_REFTRIM)

/*! @brief Set the ADCREF_REFTRIM field to a new value. */
#define BW_AFE_REFTRIMH_ADCREF_REFTRIM(x, v) (HW_AFE_REFTRIMH_WR(x, (HW_AFE_REFTRIMH_RD(x) & ~BM_AFE_REFTRIMH_ADCREF_REFTRIM) | BF_AFE_REFTRIMH_ADCREF_REFTRIM(v)))
/*@}*/

/*******************************************************************************
 * HW_AFE_DACAMP - Clamp DAC Trim
 ******************************************************************************/

/*!
 * @brief HW_AFE_DACAMP - Clamp DAC Trim (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_afe_dacamp
{
    uint32_t U;
    struct _hw_afe_dacamp_bitfields
    {
        uint32_t CLAMPDAC_TRIM : 4;    /*!< [3:0] Trim of the clamp-DAC current.
                                        * */
        uint32_t RESERVED0 : 28;       /*!< [31:4]  */
    } B;
} hw_afe_dacamp_t;

/*!
 * @name Constants and macros for entire AFE_DACAMP register
 */
/*@{*/
#define HW_AFE_DACAMP_ADDR(x)    ((uintptr_t)(x) + 0x44CU)

#define HW_AFE_DACAMP(x)         (*(__IO hw_afe_dacamp_t *) HW_AFE_DACAMP_ADDR(x))
#define HW_AFE_DACAMP_RD(x)      (HW_AFE_DACAMP(x).U)
#define HW_AFE_DACAMP_WR(x, v)   (HW_AFE_DACAMP(x).U = (v))
#define HW_AFE_DACAMP_SET(x, v)  (HW_AFE_DACAMP_WR(x, HW_AFE_DACAMP_RD(x) |  (v)))
#define HW_AFE_DACAMP_CLR(x, v)  (HW_AFE_DACAMP_WR(x, HW_AFE_DACAMP_RD(x) & ~(v)))
#define HW_AFE_DACAMP_TOG(x, v)  (HW_AFE_DACAMP_WR(x, HW_AFE_DACAMP_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AFE_DACAMP bitfields
 */

/*!
 * @name Register AFE_DACAMP, field CLAMPDAC_TRIM[3:0] (RW)
 *
 * Values:
 * - 0000 - Low current
 * - 1000 - Mid current
 * - 1111 - High current
 */
/*@{*/
#define BP_AFE_DACAMP_CLAMPDAC_TRIM (0U)   /*!< Bit position for AFE_DACAMP_CLAMPDAC_TRIM. */
#define BM_AFE_DACAMP_CLAMPDAC_TRIM (0x0000000FU) /*!< Bit mask for AFE_DACAMP_CLAMPDAC_TRIM. */
#define BS_AFE_DACAMP_CLAMPDAC_TRIM (4U)   /*!< Bit field size in bits for AFE_DACAMP_CLAMPDAC_TRIM. */

/*! @brief Read current value of the AFE_DACAMP_CLAMPDAC_TRIM field. */
#define BR_AFE_DACAMP_CLAMPDAC_TRIM(x) (HW_AFE_DACAMP(x).B.CLAMPDAC_TRIM)

/*! @brief Format value for bitfield AFE_DACAMP_CLAMPDAC_TRIM. */
#define BF_AFE_DACAMP_CLAMPDAC_TRIM(v) ((uint32_t)((uint32_t)(v) << BP_AFE_DACAMP_CLAMPDAC_TRIM) & BM_AFE_DACAMP_CLAMPDAC_TRIM)

/*! @brief Set the CLAMPDAC_TRIM field to a new value. */
#define BW_AFE_DACAMP_CLAMPDAC_TRIM(x, v) (HW_AFE_DACAMP_WR(x, (HW_AFE_DACAMP_RD(x) & ~BM_AFE_DACAMP_CLAMPDAC_TRIM) | BF_AFE_DACAMP_CLAMPDAC_TRIM(v)))
/*@}*/

/*******************************************************************************
 * HW_AFE_CLMPDAT - Clamp DAC Data
 ******************************************************************************/

/*!
 * @brief HW_AFE_CLMPDAT - Clamp DAC Data (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_afe_clmpdat
{
    uint32_t U;
    struct _hw_afe_clmpdat_bitfields
    {
        uint32_t CLAMPDAC_DATA : 8;    /*!< [7:0] Clamp DAC data */
        uint32_t RESERVED0 : 24;       /*!< [31:8]  */
    } B;
} hw_afe_clmpdat_t;

/*!
 * @name Constants and macros for entire AFE_CLMPDAT register
 */
/*@{*/
#define HW_AFE_CLMPDAT_ADDR(x)   ((uintptr_t)(x) + 0x454U)

#define HW_AFE_CLMPDAT(x)        (*(__IO hw_afe_clmpdat_t *) HW_AFE_CLMPDAT_ADDR(x))
#define HW_AFE_CLMPDAT_RD(x)     (HW_AFE_CLMPDAT(x).U)
#define HW_AFE_CLMPDAT_WR(x, v)  (HW_AFE_CLMPDAT(x).U = (v))
#define HW_AFE_CLMPDAT_SET(x, v) (HW_AFE_CLMPDAT_WR(x, HW_AFE_CLMPDAT_RD(x) |  (v)))
#define HW_AFE_CLMPDAT_CLR(x, v) (HW_AFE_CLMPDAT_WR(x, HW_AFE_CLMPDAT_RD(x) & ~(v)))
#define HW_AFE_CLMPDAT_TOG(x, v) (HW_AFE_CLMPDAT_WR(x, HW_AFE_CLMPDAT_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AFE_CLMPDAT bitfields
 */

/*!
 * @name Register AFE_CLMPDAT, field CLAMPDAC_DATA[7:0] (RW)
 *
 * Only valid when parameter clamp_current_reg_override is set to register mode.
 *
 * Values:
 * - 0000 - Low current
 * - 1000 - Mid current
 * - 11111111 - High current
 */
/*@{*/
#define BP_AFE_CLMPDAT_CLAMPDAC_DATA (0U)  /*!< Bit position for AFE_CLMPDAT_CLAMPDAC_DATA. */
#define BM_AFE_CLMPDAT_CLAMPDAC_DATA (0x000000FFU) /*!< Bit mask for AFE_CLMPDAT_CLAMPDAC_DATA. */
#define BS_AFE_CLMPDAT_CLAMPDAC_DATA (8U)  /*!< Bit field size in bits for AFE_CLMPDAT_CLAMPDAC_DATA. */

/*! @brief Read current value of the AFE_CLMPDAT_CLAMPDAC_DATA field. */
#define BR_AFE_CLMPDAT_CLAMPDAC_DATA(x) (HW_AFE_CLMPDAT(x).B.CLAMPDAC_DATA)

/*! @brief Format value for bitfield AFE_CLMPDAT_CLAMPDAC_DATA. */
#define BF_AFE_CLMPDAT_CLAMPDAC_DATA(v) ((uint32_t)((uint32_t)(v) << BP_AFE_CLMPDAT_CLAMPDAC_DATA) & BM_AFE_CLMPDAT_CLAMPDAC_DATA)

/*! @brief Set the CLAMPDAC_DATA field to a new value. */
#define BW_AFE_CLMPDAT_CLAMPDAC_DATA(x, v) (HW_AFE_CLMPDAT_WR(x, (HW_AFE_CLMPDAT_RD(x) & ~BM_AFE_CLMPDAT_CLAMPDAC_DATA) | BF_AFE_CLMPDAT_CLAMPDAC_DATA(v)))
/*@}*/

/*******************************************************************************
 * HW_AFE_CLMPAMP - Clamp DAC Control
 ******************************************************************************/

/*!
 * @brief HW_AFE_CLMPAMP - Clamp DAC Control (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_afe_clmpamp
{
    uint32_t U;
    struct _hw_afe_clmpamp_bitfields
    {
        uint32_t CLAMP_DACDATA_EXTRA : 3; /*!< [2:0] Clamp DAC extra data */
        uint32_t CLAMP_DACDATA_WEIGHT : 2; /*!< [4:3] Maps clamp_current
                                        * input to clampdac_data port in mixed-signal block. */
        uint32_t CLAMP_UPDN_REG_OVERRIDE : 1; /*!< [5] Override clamp up down
                                        * ports and control through registers. */
        uint32_t CLAMP_CURRENT_REG_OVERRIDE : 1; /*!< [6] Override clamp
                                        * current ports and control through registers. */
        uint32_t RESERVED0 : 25;       /*!< [31:7]  */
    } B;
} hw_afe_clmpamp_t;

/*!
 * @name Constants and macros for entire AFE_CLMPAMP register
 */
/*@{*/
#define HW_AFE_CLMPAMP_ADDR(x)   ((uintptr_t)(x) + 0x458U)

#define HW_AFE_CLMPAMP(x)        (*(__IO hw_afe_clmpamp_t *) HW_AFE_CLMPAMP_ADDR(x))
#define HW_AFE_CLMPAMP_RD(x)     (HW_AFE_CLMPAMP(x).U)
#define HW_AFE_CLMPAMP_WR(x, v)  (HW_AFE_CLMPAMP(x).U = (v))
#define HW_AFE_CLMPAMP_SET(x, v) (HW_AFE_CLMPAMP_WR(x, HW_AFE_CLMPAMP_RD(x) |  (v)))
#define HW_AFE_CLMPAMP_CLR(x, v) (HW_AFE_CLMPAMP_WR(x, HW_AFE_CLMPAMP_RD(x) & ~(v)))
#define HW_AFE_CLMPAMP_TOG(x, v) (HW_AFE_CLMPAMP_WR(x, HW_AFE_CLMPAMP_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AFE_CLMPAMP bitfields
 */

/*!
 * @name Register AFE_CLMPAMP, field CLAMP_DACDATA_EXTRA[2:0] (RW)
 *
 * Defines non-assigned bits when in current leakage mode. Fills out missing
 * bits when mapping from five bits to eight bits.
 */
/*@{*/
#define BP_AFE_CLMPAMP_CLAMP_DACDATA_EXTRA (0U) /*!< Bit position for AFE_CLMPAMP_CLAMP_DACDATA_EXTRA. */
#define BM_AFE_CLMPAMP_CLAMP_DACDATA_EXTRA (0x00000007U) /*!< Bit mask for AFE_CLMPAMP_CLAMP_DACDATA_EXTRA. */
#define BS_AFE_CLMPAMP_CLAMP_DACDATA_EXTRA (3U) /*!< Bit field size in bits for AFE_CLMPAMP_CLAMP_DACDATA_EXTRA. */

/*! @brief Read current value of the AFE_CLMPAMP_CLAMP_DACDATA_EXTRA field. */
#define BR_AFE_CLMPAMP_CLAMP_DACDATA_EXTRA(x) (HW_AFE_CLMPAMP(x).B.CLAMP_DACDATA_EXTRA)

/*! @brief Format value for bitfield AFE_CLMPAMP_CLAMP_DACDATA_EXTRA. */
#define BF_AFE_CLMPAMP_CLAMP_DACDATA_EXTRA(v) ((uint32_t)((uint32_t)(v) << BP_AFE_CLMPAMP_CLAMP_DACDATA_EXTRA) & BM_AFE_CLMPAMP_CLAMP_DACDATA_EXTRA)

/*! @brief Set the CLAMP_DACDATA_EXTRA field to a new value. */
#define BW_AFE_CLMPAMP_CLAMP_DACDATA_EXTRA(x, v) (HW_AFE_CLMPAMP_WR(x, (HW_AFE_CLMPAMP_RD(x) & ~BM_AFE_CLMPAMP_CLAMP_DACDATA_EXTRA) | BF_AFE_CLMPAMP_CLAMP_DACDATA_EXTRA(v)))
/*@}*/

/*!
 * @name Register AFE_CLMPAMP, field CLAMP_DACDATA_WEIGHT[4:3] (RW)
 *
 * Values:
 * - 00 - No shift
 * - 01 - Shift by 1
 * - 10 - Shift by 2
 * - 11 - Shift by 3
 */
/*@{*/
#define BP_AFE_CLMPAMP_CLAMP_DACDATA_WEIGHT (3U) /*!< Bit position for AFE_CLMPAMP_CLAMP_DACDATA_WEIGHT. */
#define BM_AFE_CLMPAMP_CLAMP_DACDATA_WEIGHT (0x00000018U) /*!< Bit mask for AFE_CLMPAMP_CLAMP_DACDATA_WEIGHT. */
#define BS_AFE_CLMPAMP_CLAMP_DACDATA_WEIGHT (2U) /*!< Bit field size in bits for AFE_CLMPAMP_CLAMP_DACDATA_WEIGHT. */

/*! @brief Read current value of the AFE_CLMPAMP_CLAMP_DACDATA_WEIGHT field. */
#define BR_AFE_CLMPAMP_CLAMP_DACDATA_WEIGHT(x) (HW_AFE_CLMPAMP(x).B.CLAMP_DACDATA_WEIGHT)

/*! @brief Format value for bitfield AFE_CLMPAMP_CLAMP_DACDATA_WEIGHT. */
#define BF_AFE_CLMPAMP_CLAMP_DACDATA_WEIGHT(v) ((uint32_t)((uint32_t)(v) << BP_AFE_CLMPAMP_CLAMP_DACDATA_WEIGHT) & BM_AFE_CLMPAMP_CLAMP_DACDATA_WEIGHT)

/*! @brief Set the CLAMP_DACDATA_WEIGHT field to a new value. */
#define BW_AFE_CLMPAMP_CLAMP_DACDATA_WEIGHT(x, v) (HW_AFE_CLMPAMP_WR(x, (HW_AFE_CLMPAMP_RD(x) & ~BM_AFE_CLMPAMP_CLAMP_DACDATA_WEIGHT) | BF_AFE_CLMPAMP_CLAMP_DACDATA_WEIGHT(v)))
/*@}*/

/*!
 * @name Register AFE_CLMPAMP, field CLAMP_UPDN_REG_OVERRIDE[5] (RW)
 *
 * Values:
 * - 0 - Ports
 * - 1 - Register
 */
/*@{*/
#define BP_AFE_CLMPAMP_CLAMP_UPDN_REG_OVERRIDE (5U) /*!< Bit position for AFE_CLMPAMP_CLAMP_UPDN_REG_OVERRIDE. */
#define BM_AFE_CLMPAMP_CLAMP_UPDN_REG_OVERRIDE (0x00000020U) /*!< Bit mask for AFE_CLMPAMP_CLAMP_UPDN_REG_OVERRIDE. */
#define BS_AFE_CLMPAMP_CLAMP_UPDN_REG_OVERRIDE (1U) /*!< Bit field size in bits for AFE_CLMPAMP_CLAMP_UPDN_REG_OVERRIDE. */

/*! @brief Read current value of the AFE_CLMPAMP_CLAMP_UPDN_REG_OVERRIDE field. */
#define BR_AFE_CLMPAMP_CLAMP_UPDN_REG_OVERRIDE(x) (HW_AFE_CLMPAMP(x).B.CLAMP_UPDN_REG_OVERRIDE)

/*! @brief Format value for bitfield AFE_CLMPAMP_CLAMP_UPDN_REG_OVERRIDE. */
#define BF_AFE_CLMPAMP_CLAMP_UPDN_REG_OVERRIDE(v) ((uint32_t)((uint32_t)(v) << BP_AFE_CLMPAMP_CLAMP_UPDN_REG_OVERRIDE) & BM_AFE_CLMPAMP_CLAMP_UPDN_REG_OVERRIDE)

/*! @brief Set the CLAMP_UPDN_REG_OVERRIDE field to a new value. */
#define BW_AFE_CLMPAMP_CLAMP_UPDN_REG_OVERRIDE(x, v) (HW_AFE_CLMPAMP_WR(x, (HW_AFE_CLMPAMP_RD(x) & ~BM_AFE_CLMPAMP_CLAMP_UPDN_REG_OVERRIDE) | BF_AFE_CLMPAMP_CLAMP_UPDN_REG_OVERRIDE(v)))
/*@}*/

/*!
 * @name Register AFE_CLMPAMP, field CLAMP_CURRENT_REG_OVERRIDE[6] (RW)
 *
 * Values:
 * - 0 - Ports
 * - 1 - Register
 */
/*@{*/
#define BP_AFE_CLMPAMP_CLAMP_CURRENT_REG_OVERRIDE (6U) /*!< Bit position for AFE_CLMPAMP_CLAMP_CURRENT_REG_OVERRIDE. */
#define BM_AFE_CLMPAMP_CLAMP_CURRENT_REG_OVERRIDE (0x00000040U) /*!< Bit mask for AFE_CLMPAMP_CLAMP_CURRENT_REG_OVERRIDE. */
#define BS_AFE_CLMPAMP_CLAMP_CURRENT_REG_OVERRIDE (1U) /*!< Bit field size in bits for AFE_CLMPAMP_CLAMP_CURRENT_REG_OVERRIDE. */

/*! @brief Read current value of the AFE_CLMPAMP_CLAMP_CURRENT_REG_OVERRIDE field. */
#define BR_AFE_CLMPAMP_CLAMP_CURRENT_REG_OVERRIDE(x) (HW_AFE_CLMPAMP(x).B.CLAMP_CURRENT_REG_OVERRIDE)

/*! @brief Format value for bitfield AFE_CLMPAMP_CLAMP_CURRENT_REG_OVERRIDE. */
#define BF_AFE_CLMPAMP_CLAMP_CURRENT_REG_OVERRIDE(v) ((uint32_t)((uint32_t)(v) << BP_AFE_CLMPAMP_CLAMP_CURRENT_REG_OVERRIDE) & BM_AFE_CLMPAMP_CLAMP_CURRENT_REG_OVERRIDE)

/*! @brief Set the CLAMP_CURRENT_REG_OVERRIDE field to a new value. */
#define BW_AFE_CLMPAMP_CLAMP_CURRENT_REG_OVERRIDE(x, v) (HW_AFE_CLMPAMP_WR(x, (HW_AFE_CLMPAMP_RD(x) & ~BM_AFE_CLMPAMP_CLAMP_CURRENT_REG_OVERRIDE) | BF_AFE_CLMPAMP_CLAMP_CURRENT_REG_OVERRIDE(v)))
/*@}*/

/*******************************************************************************
 * HW_AFE_CLAMP - Clamp Control
 ******************************************************************************/

/*!
 * @brief HW_AFE_CLAMP - Clamp Control (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_afe_clamp
{
    uint32_t U;
    struct _hw_afe_clamp_bitfields
    {
        uint32_t NCLAMP_POWERSAVE : 1; /*!< [0] Active-low power save */
        uint32_t CLAMP_VN : 1;         /*!< [1] Enable voltage clamp mode. */
        uint32_t CLAMP_IPEN_REG : 1;   /*!< [2]  */
        uint32_t CLAMP_INEN_REG : 1;   /*!< [3] Clamp down. Remove charge. Only
                                        * valid when clamp_updn_reg_override. */
        uint32_t CLAMP_LOWCURRMODE : 1; /*!< [4] Enable low current mode. */
        uint32_t DIV_PROC_CLK : 1;     /*!< [5] Test mode. */
        uint32_t CLAMP_UP_DOWN_POLARITY : 1; /*!< [6] Defines polarity of MSB
                                        * in clamp_current port. */
        uint32_t CLAMP_PWN_MODE : 1;   /*!< [7] Enable PWM mode */
        uint32_t RESERVED0 : 24;       /*!< [31:8]  */
    } B;
} hw_afe_clamp_t;

/*!
 * @name Constants and macros for entire AFE_CLAMP register
 */
/*@{*/
#define HW_AFE_CLAMP_ADDR(x)     ((uintptr_t)(x) + 0x45CU)

#define HW_AFE_CLAMP(x)          (*(__IO hw_afe_clamp_t *) HW_AFE_CLAMP_ADDR(x))
#define HW_AFE_CLAMP_RD(x)       (HW_AFE_CLAMP(x).U)
#define HW_AFE_CLAMP_WR(x, v)    (HW_AFE_CLAMP(x).U = (v))
#define HW_AFE_CLAMP_SET(x, v)   (HW_AFE_CLAMP_WR(x, HW_AFE_CLAMP_RD(x) |  (v)))
#define HW_AFE_CLAMP_CLR(x, v)   (HW_AFE_CLAMP_WR(x, HW_AFE_CLAMP_RD(x) & ~(v)))
#define HW_AFE_CLAMP_TOG(x, v)   (HW_AFE_CLAMP_WR(x, HW_AFE_CLAMP_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AFE_CLAMP bitfields
 */

/*!
 * @name Register AFE_CLAMP, field NCLAMP_POWERSAVE[0] (RW)
 *
 * Values:
 * - 0 - Power save
 * - 1 - Normal
 */
/*@{*/
#define BP_AFE_CLAMP_NCLAMP_POWERSAVE (0U) /*!< Bit position for AFE_CLAMP_NCLAMP_POWERSAVE. */
#define BM_AFE_CLAMP_NCLAMP_POWERSAVE (0x00000001U) /*!< Bit mask for AFE_CLAMP_NCLAMP_POWERSAVE. */
#define BS_AFE_CLAMP_NCLAMP_POWERSAVE (1U) /*!< Bit field size in bits for AFE_CLAMP_NCLAMP_POWERSAVE. */

/*! @brief Read current value of the AFE_CLAMP_NCLAMP_POWERSAVE field. */
#define BR_AFE_CLAMP_NCLAMP_POWERSAVE(x) (HW_AFE_CLAMP(x).B.NCLAMP_POWERSAVE)

/*! @brief Format value for bitfield AFE_CLAMP_NCLAMP_POWERSAVE. */
#define BF_AFE_CLAMP_NCLAMP_POWERSAVE(v) ((uint32_t)((uint32_t)(v) << BP_AFE_CLAMP_NCLAMP_POWERSAVE) & BM_AFE_CLAMP_NCLAMP_POWERSAVE)

/*! @brief Set the NCLAMP_POWERSAVE field to a new value. */
#define BW_AFE_CLAMP_NCLAMP_POWERSAVE(x, v) (HW_AFE_CLAMP_WR(x, (HW_AFE_CLAMP_RD(x) & ~BM_AFE_CLAMP_NCLAMP_POWERSAVE) | BF_AFE_CLAMP_NCLAMP_POWERSAVE(v)))
/*@}*/

/*!
 * @name Register AFE_CLAMP, field CLAMP_VN[1] (RW)
 *
 * Values:
 * - 0 - iClamp
 * - 1 - vClamp
 */
/*@{*/
#define BP_AFE_CLAMP_CLAMP_VN (1U)         /*!< Bit position for AFE_CLAMP_CLAMP_VN. */
#define BM_AFE_CLAMP_CLAMP_VN (0x00000002U) /*!< Bit mask for AFE_CLAMP_CLAMP_VN. */
#define BS_AFE_CLAMP_CLAMP_VN (1U)         /*!< Bit field size in bits for AFE_CLAMP_CLAMP_VN. */

/*! @brief Read current value of the AFE_CLAMP_CLAMP_VN field. */
#define BR_AFE_CLAMP_CLAMP_VN(x) (HW_AFE_CLAMP(x).B.CLAMP_VN)

/*! @brief Format value for bitfield AFE_CLAMP_CLAMP_VN. */
#define BF_AFE_CLAMP_CLAMP_VN(v) ((uint32_t)((uint32_t)(v) << BP_AFE_CLAMP_CLAMP_VN) & BM_AFE_CLAMP_CLAMP_VN)

/*! @brief Set the CLAMP_VN field to a new value. */
#define BW_AFE_CLAMP_CLAMP_VN(x, v) (HW_AFE_CLAMP_WR(x, (HW_AFE_CLAMP_RD(x) & ~BM_AFE_CLAMP_CLAMP_VN) | BF_AFE_CLAMP_CLAMP_VN(v)))
/*@}*/

/*!
 * @name Register AFE_CLAMP, field CLAMP_IPEN_REG[2] (RW)
 *
 * Only valid when clamp_updn_reg_override.
 *
 * Values:
 * - 0 - No pump up
 * - 1 - Pump up
 */
/*@{*/
#define BP_AFE_CLAMP_CLAMP_IPEN_REG (2U)   /*!< Bit position for AFE_CLAMP_CLAMP_IPEN_REG. */
#define BM_AFE_CLAMP_CLAMP_IPEN_REG (0x00000004U) /*!< Bit mask for AFE_CLAMP_CLAMP_IPEN_REG. */
#define BS_AFE_CLAMP_CLAMP_IPEN_REG (1U)   /*!< Bit field size in bits for AFE_CLAMP_CLAMP_IPEN_REG. */

/*! @brief Read current value of the AFE_CLAMP_CLAMP_IPEN_REG field. */
#define BR_AFE_CLAMP_CLAMP_IPEN_REG(x) (HW_AFE_CLAMP(x).B.CLAMP_IPEN_REG)

/*! @brief Format value for bitfield AFE_CLAMP_CLAMP_IPEN_REG. */
#define BF_AFE_CLAMP_CLAMP_IPEN_REG(v) ((uint32_t)((uint32_t)(v) << BP_AFE_CLAMP_CLAMP_IPEN_REG) & BM_AFE_CLAMP_CLAMP_IPEN_REG)

/*! @brief Set the CLAMP_IPEN_REG field to a new value. */
#define BW_AFE_CLAMP_CLAMP_IPEN_REG(x, v) (HW_AFE_CLAMP_WR(x, (HW_AFE_CLAMP_RD(x) & ~BM_AFE_CLAMP_CLAMP_IPEN_REG) | BF_AFE_CLAMP_CLAMP_IPEN_REG(v)))
/*@}*/

/*!
 * @name Register AFE_CLAMP, field CLAMP_INEN_REG[3] (RW)
 *
 * Values:
 * - 0 - No pump down
 * - 1 - Pump down
 */
/*@{*/
#define BP_AFE_CLAMP_CLAMP_INEN_REG (3U)   /*!< Bit position for AFE_CLAMP_CLAMP_INEN_REG. */
#define BM_AFE_CLAMP_CLAMP_INEN_REG (0x00000008U) /*!< Bit mask for AFE_CLAMP_CLAMP_INEN_REG. */
#define BS_AFE_CLAMP_CLAMP_INEN_REG (1U)   /*!< Bit field size in bits for AFE_CLAMP_CLAMP_INEN_REG. */

/*! @brief Read current value of the AFE_CLAMP_CLAMP_INEN_REG field. */
#define BR_AFE_CLAMP_CLAMP_INEN_REG(x) (HW_AFE_CLAMP(x).B.CLAMP_INEN_REG)

/*! @brief Format value for bitfield AFE_CLAMP_CLAMP_INEN_REG. */
#define BF_AFE_CLAMP_CLAMP_INEN_REG(v) ((uint32_t)((uint32_t)(v) << BP_AFE_CLAMP_CLAMP_INEN_REG) & BM_AFE_CLAMP_CLAMP_INEN_REG)

/*! @brief Set the CLAMP_INEN_REG field to a new value. */
#define BW_AFE_CLAMP_CLAMP_INEN_REG(x, v) (HW_AFE_CLAMP_WR(x, (HW_AFE_CLAMP_RD(x) & ~BM_AFE_CLAMP_CLAMP_INEN_REG) | BF_AFE_CLAMP_CLAMP_INEN_REG(v)))
/*@}*/

/*!
 * @name Register AFE_CLAMP, field CLAMP_LOWCURRMODE[4] (RW)
 *
 * Values:
 * - 0 - Normal
 * - 1 - Low current
 */
/*@{*/
#define BP_AFE_CLAMP_CLAMP_LOWCURRMODE (4U) /*!< Bit position for AFE_CLAMP_CLAMP_LOWCURRMODE. */
#define BM_AFE_CLAMP_CLAMP_LOWCURRMODE (0x00000010U) /*!< Bit mask for AFE_CLAMP_CLAMP_LOWCURRMODE. */
#define BS_AFE_CLAMP_CLAMP_LOWCURRMODE (1U) /*!< Bit field size in bits for AFE_CLAMP_CLAMP_LOWCURRMODE. */

/*! @brief Read current value of the AFE_CLAMP_CLAMP_LOWCURRMODE field. */
#define BR_AFE_CLAMP_CLAMP_LOWCURRMODE(x) (HW_AFE_CLAMP(x).B.CLAMP_LOWCURRMODE)

/*! @brief Format value for bitfield AFE_CLAMP_CLAMP_LOWCURRMODE. */
#define BF_AFE_CLAMP_CLAMP_LOWCURRMODE(v) ((uint32_t)((uint32_t)(v) << BP_AFE_CLAMP_CLAMP_LOWCURRMODE) & BM_AFE_CLAMP_CLAMP_LOWCURRMODE)

/*! @brief Set the CLAMP_LOWCURRMODE field to a new value. */
#define BW_AFE_CLAMP_CLAMP_LOWCURRMODE(x, v) (HW_AFE_CLAMP_WR(x, (HW_AFE_CLAMP_RD(x) & ~BM_AFE_CLAMP_CLAMP_LOWCURRMODE) | BF_AFE_CLAMP_CLAMP_LOWCURRMODE(v)))
/*@}*/

/*!
 * @name Register AFE_CLAMP, field DIV_PROC_CLK[5] (RW)
 *
 * Divides proc_clock by 4 or 8.
 *
 * Values:
 * - 0 - Divide by 4.
 * - 1 - Divide by 8.
 */
/*@{*/
#define BP_AFE_CLAMP_DIV_PROC_CLK (5U)     /*!< Bit position for AFE_CLAMP_DIV_PROC_CLK. */
#define BM_AFE_CLAMP_DIV_PROC_CLK (0x00000020U) /*!< Bit mask for AFE_CLAMP_DIV_PROC_CLK. */
#define BS_AFE_CLAMP_DIV_PROC_CLK (1U)     /*!< Bit field size in bits for AFE_CLAMP_DIV_PROC_CLK. */

/*! @brief Read current value of the AFE_CLAMP_DIV_PROC_CLK field. */
#define BR_AFE_CLAMP_DIV_PROC_CLK(x) (HW_AFE_CLAMP(x).B.DIV_PROC_CLK)

/*! @brief Format value for bitfield AFE_CLAMP_DIV_PROC_CLK. */
#define BF_AFE_CLAMP_DIV_PROC_CLK(v) ((uint32_t)((uint32_t)(v) << BP_AFE_CLAMP_DIV_PROC_CLK) & BM_AFE_CLAMP_DIV_PROC_CLK)

/*! @brief Set the DIV_PROC_CLK field to a new value. */
#define BW_AFE_CLAMP_DIV_PROC_CLK(x, v) (HW_AFE_CLAMP_WR(x, (HW_AFE_CLAMP_RD(x) & ~BM_AFE_CLAMP_DIV_PROC_CLK) | BF_AFE_CLAMP_DIV_PROC_CLK(v)))
/*@}*/

/*!
 * @name Register AFE_CLAMP, field CLAMP_UP_DOWN_POLARITY[6] (RW)
 *
 * Values:
 * - 0 - Non-inverted
 * - 1 - Inverted
 */
/*@{*/
#define BP_AFE_CLAMP_CLAMP_UP_DOWN_POLARITY (6U) /*!< Bit position for AFE_CLAMP_CLAMP_UP_DOWN_POLARITY. */
#define BM_AFE_CLAMP_CLAMP_UP_DOWN_POLARITY (0x00000040U) /*!< Bit mask for AFE_CLAMP_CLAMP_UP_DOWN_POLARITY. */
#define BS_AFE_CLAMP_CLAMP_UP_DOWN_POLARITY (1U) /*!< Bit field size in bits for AFE_CLAMP_CLAMP_UP_DOWN_POLARITY. */

/*! @brief Read current value of the AFE_CLAMP_CLAMP_UP_DOWN_POLARITY field. */
#define BR_AFE_CLAMP_CLAMP_UP_DOWN_POLARITY(x) (HW_AFE_CLAMP(x).B.CLAMP_UP_DOWN_POLARITY)

/*! @brief Format value for bitfield AFE_CLAMP_CLAMP_UP_DOWN_POLARITY. */
#define BF_AFE_CLAMP_CLAMP_UP_DOWN_POLARITY(v) ((uint32_t)((uint32_t)(v) << BP_AFE_CLAMP_CLAMP_UP_DOWN_POLARITY) & BM_AFE_CLAMP_CLAMP_UP_DOWN_POLARITY)

/*! @brief Set the CLAMP_UP_DOWN_POLARITY field to a new value. */
#define BW_AFE_CLAMP_CLAMP_UP_DOWN_POLARITY(x, v) (HW_AFE_CLAMP_WR(x, (HW_AFE_CLAMP_RD(x) & ~BM_AFE_CLAMP_CLAMP_UP_DOWN_POLARITY) | BF_AFE_CLAMP_CLAMP_UP_DOWN_POLARITY(v)))
/*@}*/

/*!
 * @name Register AFE_CLAMP, field CLAMP_PWN_MODE[7] (RW)
 *
 * Values:
 * - 0 - Constant
 * - 1 - PWM
 */
/*@{*/
#define BP_AFE_CLAMP_CLAMP_PWN_MODE (7U)   /*!< Bit position for AFE_CLAMP_CLAMP_PWN_MODE. */
#define BM_AFE_CLAMP_CLAMP_PWN_MODE (0x00000080U) /*!< Bit mask for AFE_CLAMP_CLAMP_PWN_MODE. */
#define BS_AFE_CLAMP_CLAMP_PWN_MODE (1U)   /*!< Bit field size in bits for AFE_CLAMP_CLAMP_PWN_MODE. */

/*! @brief Read current value of the AFE_CLAMP_CLAMP_PWN_MODE field. */
#define BR_AFE_CLAMP_CLAMP_PWN_MODE(x) (HW_AFE_CLAMP(x).B.CLAMP_PWN_MODE)

/*! @brief Format value for bitfield AFE_CLAMP_CLAMP_PWN_MODE. */
#define BF_AFE_CLAMP_CLAMP_PWN_MODE(v) ((uint32_t)((uint32_t)(v) << BP_AFE_CLAMP_CLAMP_PWN_MODE) & BM_AFE_CLAMP_CLAMP_PWN_MODE)

/*! @brief Set the CLAMP_PWN_MODE field to a new value. */
#define BW_AFE_CLAMP_CLAMP_PWN_MODE(x, v) (HW_AFE_CLAMP_WR(x, (HW_AFE_CLAMP_RD(x) & ~BM_AFE_CLAMP_CLAMP_PWN_MODE) | BF_AFE_CLAMP_CLAMP_PWN_MODE(v)))
/*@}*/

/*******************************************************************************
 * HW_AFE_INPBUF - Input Buffer
 ******************************************************************************/

/*!
 * @brief HW_AFE_INPBUF - Input Buffer (RW)
 *
 * Reset value: 0x00000002U
 */
typedef union _hw_afe_inpbuf
{
    uint32_t U;
    struct _hw_afe_inpbuf_bitfields
    {
        uint32_t BUFF_EN_RI : 1;       /*!< [0] Differential output buffer enable */
        uint32_t BUFF_EN_DI : 1;       /*!< [1] Reserved */
        uint32_t BUFF_EN_CM : 1;       /*!< [2] Common mode input buffer enable */
        uint32_t MUX_BUFFER_BP_EN : 1; /*!< [3] Buffer bypass enable */
        uint32_t MUX_BUFFER_15M_EN : 1; /*!< [4] 15MHz buffer enable */
        uint32_t MUX_CLAMPEN : 1;      /*!< [5] Connect clamp node to analog
                                        * input. */
        uint32_t RESERVED0 : 26;       /*!< [31:6]  */
    } B;
} hw_afe_inpbuf_t;

/*!
 * @name Constants and macros for entire AFE_INPBUF register
 */
/*@{*/
#define HW_AFE_INPBUF_ADDR(x)    ((uintptr_t)(x) + 0x460U)

#define HW_AFE_INPBUF(x)         (*(__IO hw_afe_inpbuf_t *) HW_AFE_INPBUF_ADDR(x))
#define HW_AFE_INPBUF_RD(x)      (HW_AFE_INPBUF(x).U)
#define HW_AFE_INPBUF_WR(x, v)   (HW_AFE_INPBUF(x).U = (v))
#define HW_AFE_INPBUF_SET(x, v)  (HW_AFE_INPBUF_WR(x, HW_AFE_INPBUF_RD(x) |  (v)))
#define HW_AFE_INPBUF_CLR(x, v)  (HW_AFE_INPBUF_WR(x, HW_AFE_INPBUF_RD(x) & ~(v)))
#define HW_AFE_INPBUF_TOG(x, v)  (HW_AFE_INPBUF_WR(x, HW_AFE_INPBUF_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AFE_INPBUF bitfields
 */

/*!
 * @name Register AFE_INPBUF, field BUFF_EN_RI[0] (RW)
 *
 * Enable differential output of analog input buffer.
 *
 * Values:
 * - 0 - Disable
 * - 1 - Enable
 */
/*@{*/
#define BP_AFE_INPBUF_BUFF_EN_RI (0U)      /*!< Bit position for AFE_INPBUF_BUFF_EN_RI. */
#define BM_AFE_INPBUF_BUFF_EN_RI (0x00000001U) /*!< Bit mask for AFE_INPBUF_BUFF_EN_RI. */
#define BS_AFE_INPBUF_BUFF_EN_RI (1U)      /*!< Bit field size in bits for AFE_INPBUF_BUFF_EN_RI. */

/*! @brief Read current value of the AFE_INPBUF_BUFF_EN_RI field. */
#define BR_AFE_INPBUF_BUFF_EN_RI(x) (HW_AFE_INPBUF(x).B.BUFF_EN_RI)

/*! @brief Format value for bitfield AFE_INPBUF_BUFF_EN_RI. */
#define BF_AFE_INPBUF_BUFF_EN_RI(v) ((uint32_t)((uint32_t)(v) << BP_AFE_INPBUF_BUFF_EN_RI) & BM_AFE_INPBUF_BUFF_EN_RI)

/*! @brief Set the BUFF_EN_RI field to a new value. */
#define BW_AFE_INPBUF_BUFF_EN_RI(x, v) (HW_AFE_INPBUF_WR(x, (HW_AFE_INPBUF_RD(x) & ~BM_AFE_INPBUF_BUFF_EN_RI) | BF_AFE_INPBUF_BUFF_EN_RI(v)))
/*@}*/

/*!
 * @name Register AFE_INPBUF, field BUFF_EN_DI[1] (RW)
 *
 * Enable direct input output of analog input buffer.
 */
/*@{*/
#define BP_AFE_INPBUF_BUFF_EN_DI (1U)      /*!< Bit position for AFE_INPBUF_BUFF_EN_DI. */
#define BM_AFE_INPBUF_BUFF_EN_DI (0x00000002U) /*!< Bit mask for AFE_INPBUF_BUFF_EN_DI. */
#define BS_AFE_INPBUF_BUFF_EN_DI (1U)      /*!< Bit field size in bits for AFE_INPBUF_BUFF_EN_DI. */

/*! @brief Read current value of the AFE_INPBUF_BUFF_EN_DI field. */
#define BR_AFE_INPBUF_BUFF_EN_DI(x) (HW_AFE_INPBUF(x).B.BUFF_EN_DI)

/*! @brief Format value for bitfield AFE_INPBUF_BUFF_EN_DI. */
#define BF_AFE_INPBUF_BUFF_EN_DI(v) ((uint32_t)((uint32_t)(v) << BP_AFE_INPBUF_BUFF_EN_DI) & BM_AFE_INPBUF_BUFF_EN_DI)

/*! @brief Set the BUFF_EN_DI field to a new value. */
#define BW_AFE_INPBUF_BUFF_EN_DI(x, v) (HW_AFE_INPBUF_WR(x, (HW_AFE_INPBUF_RD(x) & ~BM_AFE_INPBUF_BUFF_EN_DI) | BF_AFE_INPBUF_BUFF_EN_DI(v)))
/*@}*/

/*!
 * @name Register AFE_INPBUF, field BUFF_EN_CM[2] (RW)
 *
 * Enable common-mode output of analog input buffer.
 *
 * Values:
 * - 0 - Disable
 * - 1 - Enable
 */
/*@{*/
#define BP_AFE_INPBUF_BUFF_EN_CM (2U)      /*!< Bit position for AFE_INPBUF_BUFF_EN_CM. */
#define BM_AFE_INPBUF_BUFF_EN_CM (0x00000004U) /*!< Bit mask for AFE_INPBUF_BUFF_EN_CM. */
#define BS_AFE_INPBUF_BUFF_EN_CM (1U)      /*!< Bit field size in bits for AFE_INPBUF_BUFF_EN_CM. */

/*! @brief Read current value of the AFE_INPBUF_BUFF_EN_CM field. */
#define BR_AFE_INPBUF_BUFF_EN_CM(x) (HW_AFE_INPBUF(x).B.BUFF_EN_CM)

/*! @brief Format value for bitfield AFE_INPBUF_BUFF_EN_CM. */
#define BF_AFE_INPBUF_BUFF_EN_CM(v) ((uint32_t)((uint32_t)(v) << BP_AFE_INPBUF_BUFF_EN_CM) & BM_AFE_INPBUF_BUFF_EN_CM)

/*! @brief Set the BUFF_EN_CM field to a new value. */
#define BW_AFE_INPBUF_BUFF_EN_CM(x, v) (HW_AFE_INPBUF_WR(x, (HW_AFE_INPBUF_RD(x) & ~BM_AFE_INPBUF_BUFF_EN_CM) | BF_AFE_INPBUF_BUFF_EN_CM(v)))
/*@}*/

/*!
 * @name Register AFE_INPBUF, field MUX_BUFFER_BP_EN[3] (RW)
 *
 * Bypasses filter when set together with register mux_filterbypass.
 *
 * Values:
 * - 0 - Filter enabled
 * - 1 - Bypass filter
 */
/*@{*/
#define BP_AFE_INPBUF_MUX_BUFFER_BP_EN (3U) /*!< Bit position for AFE_INPBUF_MUX_BUFFER_BP_EN. */
#define BM_AFE_INPBUF_MUX_BUFFER_BP_EN (0x00000008U) /*!< Bit mask for AFE_INPBUF_MUX_BUFFER_BP_EN. */
#define BS_AFE_INPBUF_MUX_BUFFER_BP_EN (1U) /*!< Bit field size in bits for AFE_INPBUF_MUX_BUFFER_BP_EN. */

/*! @brief Read current value of the AFE_INPBUF_MUX_BUFFER_BP_EN field. */
#define BR_AFE_INPBUF_MUX_BUFFER_BP_EN(x) (HW_AFE_INPBUF(x).B.MUX_BUFFER_BP_EN)

/*! @brief Format value for bitfield AFE_INPBUF_MUX_BUFFER_BP_EN. */
#define BF_AFE_INPBUF_MUX_BUFFER_BP_EN(v) ((uint32_t)((uint32_t)(v) << BP_AFE_INPBUF_MUX_BUFFER_BP_EN) & BM_AFE_INPBUF_MUX_BUFFER_BP_EN)

/*! @brief Set the MUX_BUFFER_BP_EN field to a new value. */
#define BW_AFE_INPBUF_MUX_BUFFER_BP_EN(x, v) (HW_AFE_INPBUF_WR(x, (HW_AFE_INPBUF_RD(x) & ~BM_AFE_INPBUF_MUX_BUFFER_BP_EN) | BF_AFE_INPBUF_MUX_BUFFER_BP_EN(v)))
/*@}*/

/*!
 * @name Register AFE_INPBUF, field MUX_BUFFER_15M_EN[4] (RW)
 *
 * Selects 15 MHz low-pass filter when set together with register
 * [mux_filter_15m_en].
 *
 * Values:
 * - 0 - Disable filter
 * - 1 - Enable filter
 */
/*@{*/
#define BP_AFE_INPBUF_MUX_BUFFER_15M_EN (4U) /*!< Bit position for AFE_INPBUF_MUX_BUFFER_15M_EN. */
#define BM_AFE_INPBUF_MUX_BUFFER_15M_EN (0x00000010U) /*!< Bit mask for AFE_INPBUF_MUX_BUFFER_15M_EN. */
#define BS_AFE_INPBUF_MUX_BUFFER_15M_EN (1U) /*!< Bit field size in bits for AFE_INPBUF_MUX_BUFFER_15M_EN. */

/*! @brief Read current value of the AFE_INPBUF_MUX_BUFFER_15M_EN field. */
#define BR_AFE_INPBUF_MUX_BUFFER_15M_EN(x) (HW_AFE_INPBUF(x).B.MUX_BUFFER_15M_EN)

/*! @brief Format value for bitfield AFE_INPBUF_MUX_BUFFER_15M_EN. */
#define BF_AFE_INPBUF_MUX_BUFFER_15M_EN(v) ((uint32_t)((uint32_t)(v) << BP_AFE_INPBUF_MUX_BUFFER_15M_EN) & BM_AFE_INPBUF_MUX_BUFFER_15M_EN)

/*! @brief Set the MUX_BUFFER_15M_EN field to a new value. */
#define BW_AFE_INPBUF_MUX_BUFFER_15M_EN(x, v) (HW_AFE_INPBUF_WR(x, (HW_AFE_INPBUF_RD(x) & ~BM_AFE_INPBUF_MUX_BUFFER_15M_EN) | BF_AFE_INPBUF_MUX_BUFFER_15M_EN(v)))
/*@}*/

/*!
 * @name Register AFE_INPBUF, field MUX_CLAMPEN[5] (RW)
 *
 * Values:
 * - 0 - Disable
 * - 1 - Enable
 */
/*@{*/
#define BP_AFE_INPBUF_MUX_CLAMPEN (5U)     /*!< Bit position for AFE_INPBUF_MUX_CLAMPEN. */
#define BM_AFE_INPBUF_MUX_CLAMPEN (0x00000020U) /*!< Bit mask for AFE_INPBUF_MUX_CLAMPEN. */
#define BS_AFE_INPBUF_MUX_CLAMPEN (1U)     /*!< Bit field size in bits for AFE_INPBUF_MUX_CLAMPEN. */

/*! @brief Read current value of the AFE_INPBUF_MUX_CLAMPEN field. */
#define BR_AFE_INPBUF_MUX_CLAMPEN(x) (HW_AFE_INPBUF(x).B.MUX_CLAMPEN)

/*! @brief Format value for bitfield AFE_INPBUF_MUX_CLAMPEN. */
#define BF_AFE_INPBUF_MUX_CLAMPEN(v) ((uint32_t)((uint32_t)(v) << BP_AFE_INPBUF_MUX_CLAMPEN) & BM_AFE_INPBUF_MUX_CLAMPEN)

/*! @brief Set the MUX_CLAMPEN field to a new value. */
#define BW_AFE_INPBUF_MUX_CLAMPEN(x, v) (HW_AFE_INPBUF_WR(x, (HW_AFE_INPBUF_RD(x) & ~BM_AFE_INPBUF_MUX_CLAMPEN) | BF_AFE_INPBUF_MUX_CLAMPEN(v)))
/*@}*/

/*******************************************************************************
 * HW_AFE_INPFLT - Analog Input Filter
 ******************************************************************************/

/*!
 * @brief HW_AFE_INPFLT - Analog Input Filter (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_afe_inpflt
{
    uint32_t U;
    struct _hw_afe_inpflt_bitfields
    {
        uint32_t MUX_PDCURRENTMIRROR : 1; /*!< [0] Power down current mirror
                                        * */
        uint32_t MUX_FILTER_15M_EN : 1; /*!< [1] 15 MHz filter enable */
        uint32_t MUX_FILTERBYPASS : 1; /*!< [2] Fiter bypass */
        uint32_t RESERVED0 : 29;       /*!< [31:3]  */
    } B;
} hw_afe_inpflt_t;

/*!
 * @name Constants and macros for entire AFE_INPFLT register
 */
/*@{*/
#define HW_AFE_INPFLT_ADDR(x)    ((uintptr_t)(x) + 0x464U)

#define HW_AFE_INPFLT(x)         (*(__IO hw_afe_inpflt_t *) HW_AFE_INPFLT_ADDR(x))
#define HW_AFE_INPFLT_RD(x)      (HW_AFE_INPFLT(x).U)
#define HW_AFE_INPFLT_WR(x, v)   (HW_AFE_INPFLT(x).U = (v))
#define HW_AFE_INPFLT_SET(x, v)  (HW_AFE_INPFLT_WR(x, HW_AFE_INPFLT_RD(x) |  (v)))
#define HW_AFE_INPFLT_CLR(x, v)  (HW_AFE_INPFLT_WR(x, HW_AFE_INPFLT_RD(x) & ~(v)))
#define HW_AFE_INPFLT_TOG(x, v)  (HW_AFE_INPFLT_WR(x, HW_AFE_INPFLT_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AFE_INPFLT bitfields
 */

/*!
 * @name Register AFE_INPFLT, field MUX_PDCURRENTMIRROR[0] (RW)
 *
 * Enable buffter current mirrors.
 *
 * Values:
 * - 0 - Power down
 * - 1 - Normal
 */
/*@{*/
#define BP_AFE_INPFLT_MUX_PDCURRENTMIRROR (0U) /*!< Bit position for AFE_INPFLT_MUX_PDCURRENTMIRROR. */
#define BM_AFE_INPFLT_MUX_PDCURRENTMIRROR (0x00000001U) /*!< Bit mask for AFE_INPFLT_MUX_PDCURRENTMIRROR. */
#define BS_AFE_INPFLT_MUX_PDCURRENTMIRROR (1U) /*!< Bit field size in bits for AFE_INPFLT_MUX_PDCURRENTMIRROR. */

/*! @brief Read current value of the AFE_INPFLT_MUX_PDCURRENTMIRROR field. */
#define BR_AFE_INPFLT_MUX_PDCURRENTMIRROR(x) (HW_AFE_INPFLT(x).B.MUX_PDCURRENTMIRROR)

/*! @brief Format value for bitfield AFE_INPFLT_MUX_PDCURRENTMIRROR. */
#define BF_AFE_INPFLT_MUX_PDCURRENTMIRROR(v) ((uint32_t)((uint32_t)(v) << BP_AFE_INPFLT_MUX_PDCURRENTMIRROR) & BM_AFE_INPFLT_MUX_PDCURRENTMIRROR)

/*! @brief Set the MUX_PDCURRENTMIRROR field to a new value. */
#define BW_AFE_INPFLT_MUX_PDCURRENTMIRROR(x, v) (HW_AFE_INPFLT_WR(x, (HW_AFE_INPFLT_RD(x) & ~BM_AFE_INPFLT_MUX_PDCURRENTMIRROR) | BF_AFE_INPFLT_MUX_PDCURRENTMIRROR(v)))
/*@}*/

/*!
 * @name Register AFE_INPFLT, field MUX_FILTER_15M_EN[1] (RW)
 *
 * Selects 15 MHz low-pass filter when set together with
 * AFE_INPBUF[mux_buffer_15m_en].
 *
 * Values:
 * - 0 - Disable filter
 * - 1 - Enable filter
 */
/*@{*/
#define BP_AFE_INPFLT_MUX_FILTER_15M_EN (1U) /*!< Bit position for AFE_INPFLT_MUX_FILTER_15M_EN. */
#define BM_AFE_INPFLT_MUX_FILTER_15M_EN (0x00000002U) /*!< Bit mask for AFE_INPFLT_MUX_FILTER_15M_EN. */
#define BS_AFE_INPFLT_MUX_FILTER_15M_EN (1U) /*!< Bit field size in bits for AFE_INPFLT_MUX_FILTER_15M_EN. */

/*! @brief Read current value of the AFE_INPFLT_MUX_FILTER_15M_EN field. */
#define BR_AFE_INPFLT_MUX_FILTER_15M_EN(x) (HW_AFE_INPFLT(x).B.MUX_FILTER_15M_EN)

/*! @brief Format value for bitfield AFE_INPFLT_MUX_FILTER_15M_EN. */
#define BF_AFE_INPFLT_MUX_FILTER_15M_EN(v) ((uint32_t)((uint32_t)(v) << BP_AFE_INPFLT_MUX_FILTER_15M_EN) & BM_AFE_INPFLT_MUX_FILTER_15M_EN)

/*! @brief Set the MUX_FILTER_15M_EN field to a new value. */
#define BW_AFE_INPFLT_MUX_FILTER_15M_EN(x, v) (HW_AFE_INPFLT_WR(x, (HW_AFE_INPFLT_RD(x) & ~BM_AFE_INPFLT_MUX_FILTER_15M_EN) | BF_AFE_INPFLT_MUX_FILTER_15M_EN(v)))
/*@}*/

/*!
 * @name Register AFE_INPFLT, field MUX_FILTERBYPASS[2] (RW)
 *
 * Bypasses filter when set together with register [mux_buffer_bp_en].
 *
 * Values:
 * - 0 - Disable bypass
 * - 1 - Enable bypass
 */
/*@{*/
#define BP_AFE_INPFLT_MUX_FILTERBYPASS (2U) /*!< Bit position for AFE_INPFLT_MUX_FILTERBYPASS. */
#define BM_AFE_INPFLT_MUX_FILTERBYPASS (0x00000004U) /*!< Bit mask for AFE_INPFLT_MUX_FILTERBYPASS. */
#define BS_AFE_INPFLT_MUX_FILTERBYPASS (1U) /*!< Bit field size in bits for AFE_INPFLT_MUX_FILTERBYPASS. */

/*! @brief Read current value of the AFE_INPFLT_MUX_FILTERBYPASS field. */
#define BR_AFE_INPFLT_MUX_FILTERBYPASS(x) (HW_AFE_INPFLT(x).B.MUX_FILTERBYPASS)

/*! @brief Format value for bitfield AFE_INPFLT_MUX_FILTERBYPASS. */
#define BF_AFE_INPFLT_MUX_FILTERBYPASS(v) ((uint32_t)((uint32_t)(v) << BP_AFE_INPFLT_MUX_FILTERBYPASS) & BM_AFE_INPFLT_MUX_FILTERBYPASS)

/*! @brief Set the MUX_FILTERBYPASS field to a new value. */
#define BW_AFE_INPFLT_MUX_FILTERBYPASS(x, v) (HW_AFE_INPFLT_WR(x, (HW_AFE_INPFLT_RD(x) & ~BM_AFE_INPFLT_MUX_FILTERBYPASS) | BF_AFE_INPFLT_MUX_FILTERBYPASS(v)))
/*@}*/

/*******************************************************************************
 * HW_AFE_ADCDGN - ADC Digital Gain
 ******************************************************************************/

/*!
 * @brief HW_AFE_ADCDGN - ADC Digital Gain (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_afe_adcdgn
{
    uint32_t U;
    struct _hw_afe_adcdgn_bitfields
    {
        uint32_t ADC_DIGITAL_GAIN : 6; /*!< [5:0] ADC digital gain */
        uint32_t ADC_DIGITAL_GAIN_BYPASS : 1; /*!< [6] Bypass digital gain */
        uint32_t RESERVED0 : 25;       /*!< [31:7]  */
    } B;
} hw_afe_adcdgn_t;

/*!
 * @name Constants and macros for entire AFE_ADCDGN register
 */
/*@{*/
#define HW_AFE_ADCDGN_ADDR(x)    ((uintptr_t)(x) + 0x468U)

#define HW_AFE_ADCDGN(x)         (*(__IO hw_afe_adcdgn_t *) HW_AFE_ADCDGN_ADDR(x))
#define HW_AFE_ADCDGN_RD(x)      (HW_AFE_ADCDGN(x).U)
#define HW_AFE_ADCDGN_WR(x, v)   (HW_AFE_ADCDGN(x).U = (v))
#define HW_AFE_ADCDGN_SET(x, v)  (HW_AFE_ADCDGN_WR(x, HW_AFE_ADCDGN_RD(x) |  (v)))
#define HW_AFE_ADCDGN_CLR(x, v)  (HW_AFE_ADCDGN_WR(x, HW_AFE_ADCDGN_RD(x) & ~(v)))
#define HW_AFE_ADCDGN_TOG(x, v)  (HW_AFE_ADCDGN_WR(x, HW_AFE_ADCDGN_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AFE_ADCDGN bitfields
 */

/*!
 * @name Register AFE_ADCDGN, field ADC_DIGITAL_GAIN[5:0] (RW)
 *
 * Digital gain. Binary coded from 1 to 1.25.
 */
/*@{*/
#define BP_AFE_ADCDGN_ADC_DIGITAL_GAIN (0U) /*!< Bit position for AFE_ADCDGN_ADC_DIGITAL_GAIN. */
#define BM_AFE_ADCDGN_ADC_DIGITAL_GAIN (0x0000003FU) /*!< Bit mask for AFE_ADCDGN_ADC_DIGITAL_GAIN. */
#define BS_AFE_ADCDGN_ADC_DIGITAL_GAIN (6U) /*!< Bit field size in bits for AFE_ADCDGN_ADC_DIGITAL_GAIN. */

/*! @brief Read current value of the AFE_ADCDGN_ADC_DIGITAL_GAIN field. */
#define BR_AFE_ADCDGN_ADC_DIGITAL_GAIN(x) (HW_AFE_ADCDGN(x).B.ADC_DIGITAL_GAIN)

/*! @brief Format value for bitfield AFE_ADCDGN_ADC_DIGITAL_GAIN. */
#define BF_AFE_ADCDGN_ADC_DIGITAL_GAIN(v) ((uint32_t)((uint32_t)(v) << BP_AFE_ADCDGN_ADC_DIGITAL_GAIN) & BM_AFE_ADCDGN_ADC_DIGITAL_GAIN)

/*! @brief Set the ADC_DIGITAL_GAIN field to a new value. */
#define BW_AFE_ADCDGN_ADC_DIGITAL_GAIN(x, v) (HW_AFE_ADCDGN_WR(x, (HW_AFE_ADCDGN_RD(x) & ~BM_AFE_ADCDGN_ADC_DIGITAL_GAIN) | BF_AFE_ADCDGN_ADC_DIGITAL_GAIN(v)))
/*@}*/

/*!
 * @name Register AFE_ADCDGN, field ADC_DIGITAL_GAIN_BYPASS[6] (RW)
 *
 * Values:
 * - 0 - Normal
 * - 1 - Bypass
 */
/*@{*/
#define BP_AFE_ADCDGN_ADC_DIGITAL_GAIN_BYPASS (6U) /*!< Bit position for AFE_ADCDGN_ADC_DIGITAL_GAIN_BYPASS. */
#define BM_AFE_ADCDGN_ADC_DIGITAL_GAIN_BYPASS (0x00000040U) /*!< Bit mask for AFE_ADCDGN_ADC_DIGITAL_GAIN_BYPASS. */
#define BS_AFE_ADCDGN_ADC_DIGITAL_GAIN_BYPASS (1U) /*!< Bit field size in bits for AFE_ADCDGN_ADC_DIGITAL_GAIN_BYPASS. */

/*! @brief Read current value of the AFE_ADCDGN_ADC_DIGITAL_GAIN_BYPASS field. */
#define BR_AFE_ADCDGN_ADC_DIGITAL_GAIN_BYPASS(x) (HW_AFE_ADCDGN(x).B.ADC_DIGITAL_GAIN_BYPASS)

/*! @brief Format value for bitfield AFE_ADCDGN_ADC_DIGITAL_GAIN_BYPASS. */
#define BF_AFE_ADCDGN_ADC_DIGITAL_GAIN_BYPASS(v) ((uint32_t)((uint32_t)(v) << BP_AFE_ADCDGN_ADC_DIGITAL_GAIN_BYPASS) & BM_AFE_ADCDGN_ADC_DIGITAL_GAIN_BYPASS)

/*! @brief Set the ADC_DIGITAL_GAIN_BYPASS field to a new value. */
#define BW_AFE_ADCDGN_ADC_DIGITAL_GAIN_BYPASS(x, v) (HW_AFE_ADCDGN_WR(x, (HW_AFE_ADCDGN_RD(x) & ~BM_AFE_ADCDGN_ADC_DIGITAL_GAIN_BYPASS) | BF_AFE_ADCDGN_ADC_DIGITAL_GAIN_BYPASS(v)))
/*@}*/

/*******************************************************************************
 * HW_AFE_OFFDRV - Off-Chip Drive
 ******************************************************************************/

/*!
 * @brief HW_AFE_OFFDRV - Off-Chip Drive (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_afe_offdrv
{
    uint32_t U;
    struct _hw_afe_offdrv_bitfields
    {
        uint32_t ENOFFCHIPDRIVE : 2;   /*!< [1:0] Test mode. */
        uint32_t SH_TRIM : 2;          /*!< [3:2] Test mode. */
        uint32_t RESERVED0 : 28;       /*!< [31:4]  */
    } B;
} hw_afe_offdrv_t;

/*!
 * @name Constants and macros for entire AFE_OFFDRV register
 */
/*@{*/
#define HW_AFE_OFFDRV_ADDR(x)    ((uintptr_t)(x) + 0x46CU)

#define HW_AFE_OFFDRV(x)         (*(__IO hw_afe_offdrv_t *) HW_AFE_OFFDRV_ADDR(x))
#define HW_AFE_OFFDRV_RD(x)      (HW_AFE_OFFDRV(x).U)
#define HW_AFE_OFFDRV_WR(x, v)   (HW_AFE_OFFDRV(x).U = (v))
#define HW_AFE_OFFDRV_SET(x, v)  (HW_AFE_OFFDRV_WR(x, HW_AFE_OFFDRV_RD(x) |  (v)))
#define HW_AFE_OFFDRV_CLR(x, v)  (HW_AFE_OFFDRV_WR(x, HW_AFE_OFFDRV_RD(x) & ~(v)))
#define HW_AFE_OFFDRV_TOG(x, v)  (HW_AFE_OFFDRV_WR(x, HW_AFE_OFFDRV_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AFE_OFFDRV bitfields
 */

/*!
 * @name Register AFE_OFFDRV, field ENOFFCHIPDRIVE[1:0] (RW)
 *
 * Connect input VIN3 directly to ADC P-input and input VIN2 directly to ADC
 * N-input.
 *
 * Values:
 * - 00 - Non connected
 * - 01 - Not allowed
 * - 10 - Not allowed
 * - 11 - Direct connect
 */
/*@{*/
#define BP_AFE_OFFDRV_ENOFFCHIPDRIVE (0U)  /*!< Bit position for AFE_OFFDRV_ENOFFCHIPDRIVE. */
#define BM_AFE_OFFDRV_ENOFFCHIPDRIVE (0x00000003U) /*!< Bit mask for AFE_OFFDRV_ENOFFCHIPDRIVE. */
#define BS_AFE_OFFDRV_ENOFFCHIPDRIVE (2U)  /*!< Bit field size in bits for AFE_OFFDRV_ENOFFCHIPDRIVE. */

/*! @brief Read current value of the AFE_OFFDRV_ENOFFCHIPDRIVE field. */
#define BR_AFE_OFFDRV_ENOFFCHIPDRIVE(x) (HW_AFE_OFFDRV(x).B.ENOFFCHIPDRIVE)

/*! @brief Format value for bitfield AFE_OFFDRV_ENOFFCHIPDRIVE. */
#define BF_AFE_OFFDRV_ENOFFCHIPDRIVE(v) ((uint32_t)((uint32_t)(v) << BP_AFE_OFFDRV_ENOFFCHIPDRIVE) & BM_AFE_OFFDRV_ENOFFCHIPDRIVE)

/*! @brief Set the ENOFFCHIPDRIVE field to a new value. */
#define BW_AFE_OFFDRV_ENOFFCHIPDRIVE(x, v) (HW_AFE_OFFDRV_WR(x, (HW_AFE_OFFDRV_RD(x) & ~BM_AFE_OFFDRV_ENOFFCHIPDRIVE) | BF_AFE_OFFDRV_ENOFFCHIPDRIVE(v)))
/*@}*/

/*!
 * @name Register AFE_OFFDRV, field SH_TRIM[3:2] (RW)
 *
 * Bit[0] enables test mode for ADC reference. Bit[1] is not used.
 *
 * Values:
 * - 00 - Normal 0
 * - 01 - Test ADC ref
 * - 10 - Normal
 * - 11 - Test ADC ref
 */
/*@{*/
#define BP_AFE_OFFDRV_SH_TRIM (2U)         /*!< Bit position for AFE_OFFDRV_SH_TRIM. */
#define BM_AFE_OFFDRV_SH_TRIM (0x0000000CU) /*!< Bit mask for AFE_OFFDRV_SH_TRIM. */
#define BS_AFE_OFFDRV_SH_TRIM (2U)         /*!< Bit field size in bits for AFE_OFFDRV_SH_TRIM. */

/*! @brief Read current value of the AFE_OFFDRV_SH_TRIM field. */
#define BR_AFE_OFFDRV_SH_TRIM(x) (HW_AFE_OFFDRV(x).B.SH_TRIM)

/*! @brief Format value for bitfield AFE_OFFDRV_SH_TRIM. */
#define BF_AFE_OFFDRV_SH_TRIM(v) ((uint32_t)((uint32_t)(v) << BP_AFE_OFFDRV_SH_TRIM) & BM_AFE_OFFDRV_SH_TRIM)

/*! @brief Set the SH_TRIM field to a new value. */
#define BW_AFE_OFFDRV_SH_TRIM(x, v) (HW_AFE_OFFDRV_WR(x, (HW_AFE_OFFDRV_RD(x) & ~BM_AFE_OFFDRV_SH_TRIM) | BF_AFE_OFFDRV_SH_TRIM(v)))
/*@}*/

/*******************************************************************************
 * HW_AFE_INPCONFIG - VADC INPUT CONFIG
 ******************************************************************************/

/*!
 * @brief HW_AFE_INPCONFIG - VADC INPUT CONFIG (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_afe_inpconfig
{
    uint32_t U;
    struct _hw_afe_inpconfig_bitfields
    {
        uint32_t INPUT_PULLDOWN_EN : 4; /*!< [3:0] Enable input pull-down. */
        uint32_t MUX_ENLF : 4;         /*!< [7:4] Select analog input. */
        uint32_t RESERVED0 : 24;       /*!< [31:8]  */
    } B;
} hw_afe_inpconfig_t;

/*!
 * @name Constants and macros for entire AFE_INPCONFIG register
 */
/*@{*/
#define HW_AFE_INPCONFIG_ADDR(x) ((uintptr_t)(x) + 0x470U)

#define HW_AFE_INPCONFIG(x)      (*(__IO hw_afe_inpconfig_t *) HW_AFE_INPCONFIG_ADDR(x))
#define HW_AFE_INPCONFIG_RD(x)   (HW_AFE_INPCONFIG(x).U)
#define HW_AFE_INPCONFIG_WR(x, v) (HW_AFE_INPCONFIG(x).U = (v))
#define HW_AFE_INPCONFIG_SET(x, v) (HW_AFE_INPCONFIG_WR(x, HW_AFE_INPCONFIG_RD(x) |  (v)))
#define HW_AFE_INPCONFIG_CLR(x, v) (HW_AFE_INPCONFIG_WR(x, HW_AFE_INPCONFIG_RD(x) & ~(v)))
#define HW_AFE_INPCONFIG_TOG(x, v) (HW_AFE_INPCONFIG_WR(x, HW_AFE_INPCONFIG_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AFE_INPCONFIG bitfields
 */

/*!
 * @name Register AFE_INPCONFIG, field INPUT_PULLDOWN_EN[3:0] (RW)
 *
 * Set on unused inputs to minimize crosstalk from unused inputs
 *
 * Values:
 * - 0000 - No pulldown on any inputs
 * - 1111 - Pulldown on all inputs
 */
/*@{*/
#define BP_AFE_INPCONFIG_INPUT_PULLDOWN_EN (0U) /*!< Bit position for AFE_INPCONFIG_INPUT_PULLDOWN_EN. */
#define BM_AFE_INPCONFIG_INPUT_PULLDOWN_EN (0x0000000FU) /*!< Bit mask for AFE_INPCONFIG_INPUT_PULLDOWN_EN. */
#define BS_AFE_INPCONFIG_INPUT_PULLDOWN_EN (4U) /*!< Bit field size in bits for AFE_INPCONFIG_INPUT_PULLDOWN_EN. */

/*! @brief Read current value of the AFE_INPCONFIG_INPUT_PULLDOWN_EN field. */
#define BR_AFE_INPCONFIG_INPUT_PULLDOWN_EN(x) (HW_AFE_INPCONFIG(x).B.INPUT_PULLDOWN_EN)

/*! @brief Format value for bitfield AFE_INPCONFIG_INPUT_PULLDOWN_EN. */
#define BF_AFE_INPCONFIG_INPUT_PULLDOWN_EN(v) ((uint32_t)((uint32_t)(v) << BP_AFE_INPCONFIG_INPUT_PULLDOWN_EN) & BM_AFE_INPCONFIG_INPUT_PULLDOWN_EN)

/*! @brief Set the INPUT_PULLDOWN_EN field to a new value. */
#define BW_AFE_INPCONFIG_INPUT_PULLDOWN_EN(x, v) (HW_AFE_INPCONFIG_WR(x, (HW_AFE_INPCONFIG_RD(x) & ~BM_AFE_INPCONFIG_INPUT_PULLDOWN_EN) | BF_AFE_INPCONFIG_INPUT_PULLDOWN_EN(v)))
/*@}*/

/*!
 * @name Register AFE_INPCONFIG, field MUX_ENLF[7:4] (RW)
 *
 * One bit per port. Only one bit can be set at the same time.
 *
 * Values:
 * - 0000 - All inputs disabled
 * - 0001 - Select VIN0
 * - 0010 - Select VIN1
 * - 0100 - Select VIN2
 * - 1000 - Select VIN3
 */
/*@{*/
#define BP_AFE_INPCONFIG_MUX_ENLF (4U)     /*!< Bit position for AFE_INPCONFIG_MUX_ENLF. */
#define BM_AFE_INPCONFIG_MUX_ENLF (0x000000F0U) /*!< Bit mask for AFE_INPCONFIG_MUX_ENLF. */
#define BS_AFE_INPCONFIG_MUX_ENLF (4U)     /*!< Bit field size in bits for AFE_INPCONFIG_MUX_ENLF. */

/*! @brief Read current value of the AFE_INPCONFIG_MUX_ENLF field. */
#define BR_AFE_INPCONFIG_MUX_ENLF(x) (HW_AFE_INPCONFIG(x).B.MUX_ENLF)

/*! @brief Format value for bitfield AFE_INPCONFIG_MUX_ENLF. */
#define BF_AFE_INPCONFIG_MUX_ENLF(v) ((uint32_t)((uint32_t)(v) << BP_AFE_INPCONFIG_MUX_ENLF) & BM_AFE_INPCONFIG_MUX_ENLF)

/*! @brief Set the MUX_ENLF field to a new value. */
#define BW_AFE_INPCONFIG_MUX_ENLF(x, v) (HW_AFE_INPCONFIG_WR(x, (HW_AFE_INPCONFIG_RD(x) & ~BM_AFE_INPCONFIG_MUX_ENLF) | BF_AFE_INPCONFIG_MUX_ENLF(v)))
/*@}*/

/*******************************************************************************
 * HW_AFE_PROGDELAY - VADC PROG DELAY
 ******************************************************************************/

/*!
 * @brief HW_AFE_PROGDELAY - VADC PROG DELAY (RW)
 *
 * Reset value: 0x000000FFU
 */
typedef union _hw_afe_progdelay
{
    uint32_t U;
    struct _hw_afe_progdelay_bitfields
    {
        uint32_t PROG_DELAY : 8;       /*!< [7:0] ADC comparator timing. */
        uint32_t RESERVED0 : 24;       /*!< [31:8]  */
    } B;
} hw_afe_progdelay_t;

/*!
 * @name Constants and macros for entire AFE_PROGDELAY register
 */
/*@{*/
#define HW_AFE_PROGDELAY_ADDR(x) ((uintptr_t)(x) + 0x474U)

#define HW_AFE_PROGDELAY(x)      (*(__IO hw_afe_progdelay_t *) HW_AFE_PROGDELAY_ADDR(x))
#define HW_AFE_PROGDELAY_RD(x)   (HW_AFE_PROGDELAY(x).U)
#define HW_AFE_PROGDELAY_WR(x, v) (HW_AFE_PROGDELAY(x).U = (v))
#define HW_AFE_PROGDELAY_SET(x, v) (HW_AFE_PROGDELAY_WR(x, HW_AFE_PROGDELAY_RD(x) |  (v)))
#define HW_AFE_PROGDELAY_CLR(x, v) (HW_AFE_PROGDELAY_WR(x, HW_AFE_PROGDELAY_RD(x) & ~(v)))
#define HW_AFE_PROGDELAY_TOG(x, v) (HW_AFE_PROGDELAY_WR(x, HW_AFE_PROGDELAY_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AFE_PROGDELAY bitfields
 */

/*!
 * @name Register AFE_PROGDELAY, field PROG_DELAY[7:0] (RW)
 *
 * Programmed value. Only valid when register override is defined.
 *
 * Values:
 * - 00000000 - Not applicable
 * - 00001000 - Not applicable
 * - 01111111 - Not applicable
 */
/*@{*/
#define BP_AFE_PROGDELAY_PROG_DELAY (0U)   /*!< Bit position for AFE_PROGDELAY_PROG_DELAY. */
#define BM_AFE_PROGDELAY_PROG_DELAY (0x000000FFU) /*!< Bit mask for AFE_PROGDELAY_PROG_DELAY. */
#define BS_AFE_PROGDELAY_PROG_DELAY (8U)   /*!< Bit field size in bits for AFE_PROGDELAY_PROG_DELAY. */

/*! @brief Read current value of the AFE_PROGDELAY_PROG_DELAY field. */
#define BR_AFE_PROGDELAY_PROG_DELAY(x) (HW_AFE_PROGDELAY(x).B.PROG_DELAY)

/*! @brief Format value for bitfield AFE_PROGDELAY_PROG_DELAY. */
#define BF_AFE_PROGDELAY_PROG_DELAY(v) ((uint32_t)((uint32_t)(v) << BP_AFE_PROGDELAY_PROG_DELAY) & BM_AFE_PROGDELAY_PROG_DELAY)

/*! @brief Set the PROG_DELAY field to a new value. */
#define BW_AFE_PROGDELAY_PROG_DELAY(x, v) (HW_AFE_PROGDELAY_WR(x, (HW_AFE_PROGDELAY_RD(x) & ~BM_AFE_PROGDELAY_PROG_DELAY) | BF_AFE_PROGDELAY_PROG_DELAY(v)))
/*@}*/

/*******************************************************************************
 * HW_AFE_ADCOMT - ADC COMPARATOR TIMING
 ******************************************************************************/

/*!
 * @brief HW_AFE_ADCOMT - ADC COMPARATOR TIMING (RW)
 *
 * Reset value: 0x00000080U
 */
typedef union _hw_afe_adcomt
{
    uint32_t U;
    struct _hw_afe_adcomt_bitfields
    {
        uint32_t OVERRIDE : 1;         /*!< [0]  */
        uint32_t WAIT_TIME : 5;        /*!< [5:1]  */
        uint32_t MEASURE_TIMING : 2;   /*!< [7:6]  */
        uint32_t RESERVED0 : 24;       /*!< [31:8]  */
    } B;
} hw_afe_adcomt_t;

/*!
 * @name Constants and macros for entire AFE_ADCOMT register
 */
/*@{*/
#define HW_AFE_ADCOMT_ADDR(x)    ((uintptr_t)(x) + 0x478U)

#define HW_AFE_ADCOMT(x)         (*(__IO hw_afe_adcomt_t *) HW_AFE_ADCOMT_ADDR(x))
#define HW_AFE_ADCOMT_RD(x)      (HW_AFE_ADCOMT(x).U)
#define HW_AFE_ADCOMT_WR(x, v)   (HW_AFE_ADCOMT(x).U = (v))
#define HW_AFE_ADCOMT_SET(x, v)  (HW_AFE_ADCOMT_WR(x, HW_AFE_ADCOMT_RD(x) |  (v)))
#define HW_AFE_ADCOMT_CLR(x, v)  (HW_AFE_ADCOMT_WR(x, HW_AFE_ADCOMT_RD(x) & ~(v)))
#define HW_AFE_ADCOMT_TOG(x, v)  (HW_AFE_ADCOMT_WR(x, HW_AFE_ADCOMT_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AFE_ADCOMT bitfields
 */

/*!
 * @name Register AFE_ADCOMT, field OVERRIDE[0] (RW)
 *
 * Selects programmed value instead of value found by algorithm.
 */
/*@{*/
#define BP_AFE_ADCOMT_OVERRIDE (0U)        /*!< Bit position for AFE_ADCOMT_OVERRIDE. */
#define BM_AFE_ADCOMT_OVERRIDE (0x00000001U) /*!< Bit mask for AFE_ADCOMT_OVERRIDE. */
#define BS_AFE_ADCOMT_OVERRIDE (1U)        /*!< Bit field size in bits for AFE_ADCOMT_OVERRIDE. */

/*! @brief Read current value of the AFE_ADCOMT_OVERRIDE field. */
#define BR_AFE_ADCOMT_OVERRIDE(x) (HW_AFE_ADCOMT(x).B.OVERRIDE)

/*! @brief Format value for bitfield AFE_ADCOMT_OVERRIDE. */
#define BF_AFE_ADCOMT_OVERRIDE(v) ((uint32_t)((uint32_t)(v) << BP_AFE_ADCOMT_OVERRIDE) & BM_AFE_ADCOMT_OVERRIDE)

/*! @brief Set the OVERRIDE field to a new value. */
#define BW_AFE_ADCOMT_OVERRIDE(x, v) (HW_AFE_ADCOMT_WR(x, (HW_AFE_ADCOMT_RD(x) & ~BM_AFE_ADCOMT_OVERRIDE) | BF_AFE_ADCOMT_OVERRIDE(v)))
/*@}*/

/*!
 * @name Register AFE_ADCOMT, field WAIT_TIME[5:1] (RW)
 *
 * Defines algorithm update frequency.
 *
 * Values:
 * - 00 - Eight times update rate
 * - 01 - Quad update rate
 * - 10 - Double update rate
 * - 11 - Slow update
 */
/*@{*/
#define BP_AFE_ADCOMT_WAIT_TIME (1U)       /*!< Bit position for AFE_ADCOMT_WAIT_TIME. */
#define BM_AFE_ADCOMT_WAIT_TIME (0x0000003EU) /*!< Bit mask for AFE_ADCOMT_WAIT_TIME. */
#define BS_AFE_ADCOMT_WAIT_TIME (5U)       /*!< Bit field size in bits for AFE_ADCOMT_WAIT_TIME. */

/*! @brief Read current value of the AFE_ADCOMT_WAIT_TIME field. */
#define BR_AFE_ADCOMT_WAIT_TIME(x) (HW_AFE_ADCOMT(x).B.WAIT_TIME)

/*! @brief Format value for bitfield AFE_ADCOMT_WAIT_TIME. */
#define BF_AFE_ADCOMT_WAIT_TIME(v) ((uint32_t)((uint32_t)(v) << BP_AFE_ADCOMT_WAIT_TIME) & BM_AFE_ADCOMT_WAIT_TIME)

/*! @brief Set the WAIT_TIME field to a new value. */
#define BW_AFE_ADCOMT_WAIT_TIME(x, v) (HW_AFE_ADCOMT_WR(x, (HW_AFE_ADCOMT_RD(x) & ~BM_AFE_ADCOMT_WAIT_TIME) | BF_AFE_ADCOMT_WAIT_TIME(v)))
/*@}*/

/*!
 * @name Register AFE_ADCOMT, field MEASURE_TIMING[7:6] (RW)
 *
 * Defines when to measure.
 *
 * Values:
 * - 00 - Not applicable
 * - 01 - Not applicable
 * - 10 - Used
 * - 11 - Not applicable
 */
/*@{*/
#define BP_AFE_ADCOMT_MEASURE_TIMING (6U)  /*!< Bit position for AFE_ADCOMT_MEASURE_TIMING. */
#define BM_AFE_ADCOMT_MEASURE_TIMING (0x000000C0U) /*!< Bit mask for AFE_ADCOMT_MEASURE_TIMING. */
#define BS_AFE_ADCOMT_MEASURE_TIMING (2U)  /*!< Bit field size in bits for AFE_ADCOMT_MEASURE_TIMING. */

/*! @brief Read current value of the AFE_ADCOMT_MEASURE_TIMING field. */
#define BR_AFE_ADCOMT_MEASURE_TIMING(x) (HW_AFE_ADCOMT(x).B.MEASURE_TIMING)

/*! @brief Format value for bitfield AFE_ADCOMT_MEASURE_TIMING. */
#define BF_AFE_ADCOMT_MEASURE_TIMING(v) ((uint32_t)((uint32_t)(v) << BP_AFE_ADCOMT_MEASURE_TIMING) & BM_AFE_ADCOMT_MEASURE_TIMING)

/*! @brief Set the MEASURE_TIMING field to a new value. */
#define BW_AFE_ADCOMT_MEASURE_TIMING(x, v) (HW_AFE_ADCOMT_WR(x, (HW_AFE_ADCOMT_RD(x) & ~BM_AFE_ADCOMT_MEASURE_TIMING) | BF_AFE_ADCOMT_MEASURE_TIMING(v)))
/*@}*/

/*******************************************************************************
 * HW_AFE_ALGDELAY - ALGORITHM DELAY
 ******************************************************************************/

/*!
 * @brief HW_AFE_ALGDELAY - ALGORITHM DELAY (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_afe_algdelay
{
    uint32_t U;
    struct _hw_afe_algdelay_bitfields
    {
        uint32_t ALGORITHM_DELAY : 8;  /*!< [7:0] ADC comparator timing. */
        uint32_t RESERVED0 : 24;       /*!< [31:8]  */
    } B;
} hw_afe_algdelay_t;

/*!
 * @name Constants and macros for entire AFE_ALGDELAY register
 */
/*@{*/
#define HW_AFE_ALGDELAY_ADDR(x)  ((uintptr_t)(x) + 0x47CU)

#define HW_AFE_ALGDELAY(x)       (*(__I hw_afe_algdelay_t *) HW_AFE_ALGDELAY_ADDR(x))
#define HW_AFE_ALGDELAY_RD(x)    (HW_AFE_ALGDELAY(x).U)
/*@}*/

/*
 * Constants & macros for individual AFE_ALGDELAY bitfields
 */

/*!
 * @name Register AFE_ALGDELAY, field ALGORITHM_DELAY[7:0] (RO)
 *
 * Value found by algorithm. Not used in register override mode.
 */
/*@{*/
#define BP_AFE_ALGDELAY_ALGORITHM_DELAY (0U) /*!< Bit position for AFE_ALGDELAY_ALGORITHM_DELAY. */
#define BM_AFE_ALGDELAY_ALGORITHM_DELAY (0x000000FFU) /*!< Bit mask for AFE_ALGDELAY_ALGORITHM_DELAY. */
#define BS_AFE_ALGDELAY_ALGORITHM_DELAY (8U) /*!< Bit field size in bits for AFE_ALGDELAY_ALGORITHM_DELAY. */

/*! @brief Read current value of the AFE_ALGDELAY_ALGORITHM_DELAY field. */
#define BR_AFE_ALGDELAY_ALGORITHM_DELAY(x) (HW_AFE_ALGDELAY(x).B.ALGORITHM_DELAY)
/*@}*/

/*******************************************************************************
 * HW_AFE_ACC_ID - Acc ID
 ******************************************************************************/

/*!
 * @brief HW_AFE_ACC_ID - Acc ID (RO)
 *
 * Reset value: 0x00000012U
 */
typedef union _hw_afe_acc_id
{
    uint32_t U;
    struct _hw_afe_acc_id_bitfields
    {
        uint32_t BLOCK_ID : 8;         /*!< [7:0] Block ID and revision number */
        uint32_t RESERVED0 : 24;       /*!< [31:8]  */
    } B;
} hw_afe_acc_id_t;

/*!
 * @name Constants and macros for entire AFE_ACC_ID register
 */
/*@{*/
#define HW_AFE_ACC_ID_ADDR(x)    ((uintptr_t)(x) + 0x800U)

#define HW_AFE_ACC_ID(x)         (*(__I hw_afe_acc_id_t *) HW_AFE_ACC_ID_ADDR(x))
#define HW_AFE_ACC_ID_RD(x)      (HW_AFE_ACC_ID(x).U)
/*@}*/

/*
 * Constants & macros for individual AFE_ACC_ID bitfields
 */

/*!
 * @name Register AFE_ACC_ID, field BLOCK_ID[7:0] (RO)
 */
/*@{*/
#define BP_AFE_ACC_ID_BLOCK_ID (0U)        /*!< Bit position for AFE_ACC_ID_BLOCK_ID. */
#define BM_AFE_ACC_ID_BLOCK_ID (0x000000FFU) /*!< Bit mask for AFE_ACC_ID_BLOCK_ID. */
#define BS_AFE_ACC_ID_BLOCK_ID (8U)        /*!< Bit field size in bits for AFE_ACC_ID_BLOCK_ID. */

/*! @brief Read current value of the AFE_ACC_ID_BLOCK_ID field. */
#define BR_AFE_ACC_ID_BLOCK_ID(x) (HW_AFE_ACC_ID(x).B.BLOCK_ID)
/*@}*/

/*******************************************************************************
 * HW_AFE_ACCSTA - ACC STATUS
 ******************************************************************************/

/*!
 * @brief HW_AFE_ACCSTA - ACC STATUS (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_afe_accsta
{
    uint32_t U;
    struct _hw_afe_accsta_bitfields
    {
        uint32_t STATUS : 5;           /*!< [4:0]  */
        uint32_t RESERVED0 : 27;       /*!< [31:5]  */
    } B;
} hw_afe_accsta_t;

/*!
 * @name Constants and macros for entire AFE_ACCSTA register
 */
/*@{*/
#define HW_AFE_ACCSTA_ADDR(x)    ((uintptr_t)(x) + 0x804U)

#define HW_AFE_ACCSTA(x)         (*(__I hw_afe_accsta_t *) HW_AFE_ACCSTA_ADDR(x))
#define HW_AFE_ACCSTA_RD(x)      (HW_AFE_ACCSTA(x).U)
/*@}*/

/*
 * Constants & macros for individual AFE_ACCSTA bitfields
 */

/*!
 * @name Register AFE_ACCSTA, field STATUS[4:0] (RO)
 *
 * Bit number [2:0] Indicate current function state of the ACC. Bit number [3]
 * Indicate invalid data for selected bit. Bit number [4] Indicate selected bit
 * calibrated.
 *
 * Values:
 * - 000 - Compensation mode
 * - 010 - Acquisition mode
 * - 100 - Idel mode
 * - 1xxx - Indicate invalid calibration data
 */
/*@{*/
#define BP_AFE_ACCSTA_STATUS (0U)          /*!< Bit position for AFE_ACCSTA_STATUS. */
#define BM_AFE_ACCSTA_STATUS (0x0000001FU) /*!< Bit mask for AFE_ACCSTA_STATUS. */
#define BS_AFE_ACCSTA_STATUS (5U)          /*!< Bit field size in bits for AFE_ACCSTA_STATUS. */

/*! @brief Read current value of the AFE_ACCSTA_STATUS field. */
#define BR_AFE_ACCSTA_STATUS(x) (HW_AFE_ACCSTA(x).B.STATUS)
/*@}*/

/*******************************************************************************
 * HW_AFE_ACCNOSLI - ACC NUMBER OF SLICE
 ******************************************************************************/

/*!
 * @brief HW_AFE_ACCNOSLI - ACC NUMBER OF SLICE (RW)
 *
 * Reset value: 0x00000008U
 */
typedef union _hw_afe_accnosli
{
    uint32_t U;
    struct _hw_afe_accnosli_bitfields
    {
        uint32_t NO_OF_SLICES : 6;     /*!< [5:0] Selects number of slices */
        uint32_t RESERVED0 : 26;       /*!< [31:6]  */
    } B;
} hw_afe_accnosli_t;

/*!
 * @name Constants and macros for entire AFE_ACCNOSLI register
 */
/*@{*/
#define HW_AFE_ACCNOSLI_ADDR(x)  ((uintptr_t)(x) + 0x808U)

#define HW_AFE_ACCNOSLI(x)       (*(__IO hw_afe_accnosli_t *) HW_AFE_ACCNOSLI_ADDR(x))
#define HW_AFE_ACCNOSLI_RD(x)    (HW_AFE_ACCNOSLI(x).U)
#define HW_AFE_ACCNOSLI_WR(x, v) (HW_AFE_ACCNOSLI(x).U = (v))
#define HW_AFE_ACCNOSLI_SET(x, v) (HW_AFE_ACCNOSLI_WR(x, HW_AFE_ACCNOSLI_RD(x) |  (v)))
#define HW_AFE_ACCNOSLI_CLR(x, v) (HW_AFE_ACCNOSLI_WR(x, HW_AFE_ACCNOSLI_RD(x) & ~(v)))
#define HW_AFE_ACCNOSLI_TOG(x, v) (HW_AFE_ACCNOSLI_WR(x, HW_AFE_ACCNOSLI_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AFE_ACCNOSLI bitfields
 */

/*!
 * @name Register AFE_ACCNOSLI, field NO_OF_SLICES[5:0] (RW)
 *
 * Values:
 * - 0001 - 1 slice
 * - 0010 - 3 slices
 * - 0100 - 5 slices
 * - 1000 - 9 slices
 * - 00010000 - 17 slices
 * - 00100000 - 12 slices
 */
/*@{*/
#define BP_AFE_ACCNOSLI_NO_OF_SLICES (0U)  /*!< Bit position for AFE_ACCNOSLI_NO_OF_SLICES. */
#define BM_AFE_ACCNOSLI_NO_OF_SLICES (0x0000003FU) /*!< Bit mask for AFE_ACCNOSLI_NO_OF_SLICES. */
#define BS_AFE_ACCNOSLI_NO_OF_SLICES (6U)  /*!< Bit field size in bits for AFE_ACCNOSLI_NO_OF_SLICES. */

/*! @brief Read current value of the AFE_ACCNOSLI_NO_OF_SLICES field. */
#define BR_AFE_ACCNOSLI_NO_OF_SLICES(x) (HW_AFE_ACCNOSLI(x).B.NO_OF_SLICES)

/*! @brief Format value for bitfield AFE_ACCNOSLI_NO_OF_SLICES. */
#define BF_AFE_ACCNOSLI_NO_OF_SLICES(v) ((uint32_t)((uint32_t)(v) << BP_AFE_ACCNOSLI_NO_OF_SLICES) & BM_AFE_ACCNOSLI_NO_OF_SLICES)

/*! @brief Set the NO_OF_SLICES field to a new value. */
#define BW_AFE_ACCNOSLI_NO_OF_SLICES(x, v) (HW_AFE_ACCNOSLI_WR(x, (HW_AFE_ACCNOSLI_RD(x) & ~BM_AFE_ACCNOSLI_NO_OF_SLICES) | BF_AFE_ACCNOSLI_NO_OF_SLICES(v)))
/*@}*/

/*******************************************************************************
 * HW_AFE_ACCCALCON - ACC CALIBRATE CONTROL
 ******************************************************************************/

/*!
 * @brief HW_AFE_ACCCALCON - ACC CALIBRATE CONTROL (RW)
 *
 * Reset value: 0x00000018U
 */
typedef union _hw_afe_acccalcon
{
    uint32_t U;
    struct _hw_afe_acccalcon_bitfields
    {
        uint32_t CALIBRATE_START : 1;  /*!< [0] Initiates acquisition when set
                                        * from 0 to 1 */
        uint32_t BYPASS : 1;           /*!< [1] Bypass ACC. */
        uint32_t BYPASS_CALIB : 1;     /*!< [2]  */
        uint32_t OFFSET_COMP_EN : 1;   /*!< [3] Controls offset compensation. */
        uint32_t ANA_OFFSET_COMP_EN : 1; /*!< [4] Controls analog offset
                                        * measurements */
        uint32_t RESERVED0 : 27;       /*!< [31:5]  */
    } B;
} hw_afe_acccalcon_t;

/*!
 * @name Constants and macros for entire AFE_ACCCALCON register
 */
/*@{*/
#define HW_AFE_ACCCALCON_ADDR(x) ((uintptr_t)(x) + 0x80CU)

#define HW_AFE_ACCCALCON(x)      (*(__IO hw_afe_acccalcon_t *) HW_AFE_ACCCALCON_ADDR(x))
#define HW_AFE_ACCCALCON_RD(x)   (HW_AFE_ACCCALCON(x).U)
#define HW_AFE_ACCCALCON_WR(x, v) (HW_AFE_ACCCALCON(x).U = (v))
#define HW_AFE_ACCCALCON_SET(x, v) (HW_AFE_ACCCALCON_WR(x, HW_AFE_ACCCALCON_RD(x) |  (v)))
#define HW_AFE_ACCCALCON_CLR(x, v) (HW_AFE_ACCCALCON_WR(x, HW_AFE_ACCCALCON_RD(x) & ~(v)))
#define HW_AFE_ACCCALCON_TOG(x, v) (HW_AFE_ACCCALCON_WR(x, HW_AFE_ACCCALCON_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AFE_ACCCALCON bitfields
 */

/*!
 * @name Register AFE_ACCCALCON, field CALIBRATE_START[0] (RW)
 *
 * Values:
 * - 0 - Normal
 * - 1 - Initiate acquisition
 */
/*@{*/
#define BP_AFE_ACCCALCON_CALIBRATE_START (0U) /*!< Bit position for AFE_ACCCALCON_CALIBRATE_START. */
#define BM_AFE_ACCCALCON_CALIBRATE_START (0x00000001U) /*!< Bit mask for AFE_ACCCALCON_CALIBRATE_START. */
#define BS_AFE_ACCCALCON_CALIBRATE_START (1U) /*!< Bit field size in bits for AFE_ACCCALCON_CALIBRATE_START. */

/*! @brief Read current value of the AFE_ACCCALCON_CALIBRATE_START field. */
#define BR_AFE_ACCCALCON_CALIBRATE_START(x) (HW_AFE_ACCCALCON(x).B.CALIBRATE_START)

/*! @brief Format value for bitfield AFE_ACCCALCON_CALIBRATE_START. */
#define BF_AFE_ACCCALCON_CALIBRATE_START(v) ((uint32_t)((uint32_t)(v) << BP_AFE_ACCCALCON_CALIBRATE_START) & BM_AFE_ACCCALCON_CALIBRATE_START)

/*! @brief Set the CALIBRATE_START field to a new value. */
#define BW_AFE_ACCCALCON_CALIBRATE_START(x, v) (HW_AFE_ACCCALCON_WR(x, (HW_AFE_ACCCALCON_RD(x) & ~BM_AFE_ACCCALCON_CALIBRATE_START) | BF_AFE_ACCCALCON_CALIBRATE_START(v)))
/*@}*/

/*!
 * @name Register AFE_ACCCALCON, field BYPASS[1] (RW)
 *
 * Data output in serial mode. Data from slice 0 on data output bit 16, data
 * from slice 1 on data output bit 15, and so on.
 *
 * Values:
 * - 0 - Normal
 * - 1 - Bypass
 */
/*@{*/
#define BP_AFE_ACCCALCON_BYPASS (1U)       /*!< Bit position for AFE_ACCCALCON_BYPASS. */
#define BM_AFE_ACCCALCON_BYPASS (0x00000002U) /*!< Bit mask for AFE_ACCCALCON_BYPASS. */
#define BS_AFE_ACCCALCON_BYPASS (1U)       /*!< Bit field size in bits for AFE_ACCCALCON_BYPASS. */

/*! @brief Read current value of the AFE_ACCCALCON_BYPASS field. */
#define BR_AFE_ACCCALCON_BYPASS(x) (HW_AFE_ACCCALCON(x).B.BYPASS)

/*! @brief Format value for bitfield AFE_ACCCALCON_BYPASS. */
#define BF_AFE_ACCCALCON_BYPASS(v) ((uint32_t)((uint32_t)(v) << BP_AFE_ACCCALCON_BYPASS) & BM_AFE_ACCCALCON_BYPASS)

/*! @brief Set the BYPASS field to a new value. */
#define BW_AFE_ACCCALCON_BYPASS(x, v) (HW_AFE_ACCCALCON_WR(x, (HW_AFE_ACCCALCON_RD(x) & ~BM_AFE_ACCCALCON_BYPASS) | BF_AFE_ACCCALCON_BYPASS(v)))
/*@}*/

/*!
 * @name Register AFE_ACCCALCON, field BYPASS_CALIB[2] (RW)
 *
 * Allow the user to bypass the calibration sequence for the coefficients and
 * instead use the default values.
 *
 * Values:
 * - 0 - Run calibration sequence
 * - 1 - Skip calibration sequence and start compensation
 */
/*@{*/
#define BP_AFE_ACCCALCON_BYPASS_CALIB (2U) /*!< Bit position for AFE_ACCCALCON_BYPASS_CALIB. */
#define BM_AFE_ACCCALCON_BYPASS_CALIB (0x00000004U) /*!< Bit mask for AFE_ACCCALCON_BYPASS_CALIB. */
#define BS_AFE_ACCCALCON_BYPASS_CALIB (1U) /*!< Bit field size in bits for AFE_ACCCALCON_BYPASS_CALIB. */

/*! @brief Read current value of the AFE_ACCCALCON_BYPASS_CALIB field. */
#define BR_AFE_ACCCALCON_BYPASS_CALIB(x) (HW_AFE_ACCCALCON(x).B.BYPASS_CALIB)

/*! @brief Format value for bitfield AFE_ACCCALCON_BYPASS_CALIB. */
#define BF_AFE_ACCCALCON_BYPASS_CALIB(v) ((uint32_t)((uint32_t)(v) << BP_AFE_ACCCALCON_BYPASS_CALIB) & BM_AFE_ACCCALCON_BYPASS_CALIB)

/*! @brief Set the BYPASS_CALIB field to a new value. */
#define BW_AFE_ACCCALCON_BYPASS_CALIB(x, v) (HW_AFE_ACCCALCON_WR(x, (HW_AFE_ACCCALCON_RD(x) & ~BM_AFE_ACCCALCON_BYPASS_CALIB) | BF_AFE_ACCCALCON_BYPASS_CALIB(v)))
/*@}*/

/*!
 * @name Register AFE_ACCCALCON, field OFFSET_COMP_EN[3] (RW)
 *
 * If enabled, the parameter ana_offset_comp_en should also be enabled.
 *
 * Values:
 * - 0 - No offset compensation
 * - 1 - Enable offset compensation
 */
/*@{*/
#define BP_AFE_ACCCALCON_OFFSET_COMP_EN (3U) /*!< Bit position for AFE_ACCCALCON_OFFSET_COMP_EN. */
#define BM_AFE_ACCCALCON_OFFSET_COMP_EN (0x00000008U) /*!< Bit mask for AFE_ACCCALCON_OFFSET_COMP_EN. */
#define BS_AFE_ACCCALCON_OFFSET_COMP_EN (1U) /*!< Bit field size in bits for AFE_ACCCALCON_OFFSET_COMP_EN. */

/*! @brief Read current value of the AFE_ACCCALCON_OFFSET_COMP_EN field. */
#define BR_AFE_ACCCALCON_OFFSET_COMP_EN(x) (HW_AFE_ACCCALCON(x).B.OFFSET_COMP_EN)

/*! @brief Format value for bitfield AFE_ACCCALCON_OFFSET_COMP_EN. */
#define BF_AFE_ACCCALCON_OFFSET_COMP_EN(v) ((uint32_t)((uint32_t)(v) << BP_AFE_ACCCALCON_OFFSET_COMP_EN) & BM_AFE_ACCCALCON_OFFSET_COMP_EN)

/*! @brief Set the OFFSET_COMP_EN field to a new value. */
#define BW_AFE_ACCCALCON_OFFSET_COMP_EN(x, v) (HW_AFE_ACCCALCON_WR(x, (HW_AFE_ACCCALCON_RD(x) & ~BM_AFE_ACCCALCON_OFFSET_COMP_EN) | BF_AFE_ACCCALCON_OFFSET_COMP_EN(v)))
/*@}*/

/*!
 * @name Register AFE_ACCCALCON, field ANA_OFFSET_COMP_EN[4] (RW)
 *
 * Values:
 * - 0 - Disable measurement
 * - 1 - Enable measurement
 */
/*@{*/
#define BP_AFE_ACCCALCON_ANA_OFFSET_COMP_EN (4U) /*!< Bit position for AFE_ACCCALCON_ANA_OFFSET_COMP_EN. */
#define BM_AFE_ACCCALCON_ANA_OFFSET_COMP_EN (0x00000010U) /*!< Bit mask for AFE_ACCCALCON_ANA_OFFSET_COMP_EN. */
#define BS_AFE_ACCCALCON_ANA_OFFSET_COMP_EN (1U) /*!< Bit field size in bits for AFE_ACCCALCON_ANA_OFFSET_COMP_EN. */

/*! @brief Read current value of the AFE_ACCCALCON_ANA_OFFSET_COMP_EN field. */
#define BR_AFE_ACCCALCON_ANA_OFFSET_COMP_EN(x) (HW_AFE_ACCCALCON(x).B.ANA_OFFSET_COMP_EN)

/*! @brief Format value for bitfield AFE_ACCCALCON_ANA_OFFSET_COMP_EN. */
#define BF_AFE_ACCCALCON_ANA_OFFSET_COMP_EN(v) ((uint32_t)((uint32_t)(v) << BP_AFE_ACCCALCON_ANA_OFFSET_COMP_EN) & BM_AFE_ACCCALCON_ANA_OFFSET_COMP_EN)

/*! @brief Set the ANA_OFFSET_COMP_EN field to a new value. */
#define BW_AFE_ACCCALCON_ANA_OFFSET_COMP_EN(x, v) (HW_AFE_ACCCALCON_WR(x, (HW_AFE_ACCCALCON_RD(x) & ~BM_AFE_ACCCALCON_ANA_OFFSET_COMP_EN) | BF_AFE_ACCCALCON_ANA_OFFSET_COMP_EN(v)))
/*@}*/

/*******************************************************************************
 * HW_AFE_BWEWRICTRL - ACC BWE WRITE CONTROL
 ******************************************************************************/

/*!
 * @brief HW_AFE_BWEWRICTRL - ACC BWE WRITE CONTROL (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_afe_bwewrictrl
{
    uint32_t U;
    struct _hw_afe_bwewrictrl_bitfields
    {
        uint32_t BWE_CTRL : 2;         /*!< [1:0] ADC Bit Weight Estimation. Control
                                        * of bwe. */
        uint32_t BWE_WRITE_CTRL : 1;   /*!< [2]  */
        uint32_t RESERVED0 : 29;       /*!< [31:3]  */
    } B;
} hw_afe_bwewrictrl_t;

/*!
 * @name Constants and macros for entire AFE_BWEWRICTRL register
 */
/*@{*/
#define HW_AFE_BWEWRICTRL_ADDR(x) ((uintptr_t)(x) + 0x810U)

#define HW_AFE_BWEWRICTRL(x)     (*(__IO hw_afe_bwewrictrl_t *) HW_AFE_BWEWRICTRL_ADDR(x))
#define HW_AFE_BWEWRICTRL_RD(x)  (HW_AFE_BWEWRICTRL(x).U)
#define HW_AFE_BWEWRICTRL_WR(x, v) (HW_AFE_BWEWRICTRL(x).U = (v))
#define HW_AFE_BWEWRICTRL_SET(x, v) (HW_AFE_BWEWRICTRL_WR(x, HW_AFE_BWEWRICTRL_RD(x) |  (v)))
#define HW_AFE_BWEWRICTRL_CLR(x, v) (HW_AFE_BWEWRICTRL_WR(x, HW_AFE_BWEWRICTRL_RD(x) & ~(v)))
#define HW_AFE_BWEWRICTRL_TOG(x, v) (HW_AFE_BWEWRICTRL_WR(x, HW_AFE_BWEWRICTRL_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AFE_BWEWRICTRL bitfields
 */

/*!
 * @name Register AFE_BWEWRICTRL, field BWE_CTRL[1:0] (RW)
 *
 * Values:
 * - 00 - Algorithm
 * - 01 - Write
 * - 10 - Read
 * - 11 - Acquire
 */
/*@{*/
#define BP_AFE_BWEWRICTRL_BWE_CTRL (0U)    /*!< Bit position for AFE_BWEWRICTRL_BWE_CTRL. */
#define BM_AFE_BWEWRICTRL_BWE_CTRL (0x00000003U) /*!< Bit mask for AFE_BWEWRICTRL_BWE_CTRL. */
#define BS_AFE_BWEWRICTRL_BWE_CTRL (2U)    /*!< Bit field size in bits for AFE_BWEWRICTRL_BWE_CTRL. */

/*! @brief Read current value of the AFE_BWEWRICTRL_BWE_CTRL field. */
#define BR_AFE_BWEWRICTRL_BWE_CTRL(x) (HW_AFE_BWEWRICTRL(x).B.BWE_CTRL)

/*! @brief Format value for bitfield AFE_BWEWRICTRL_BWE_CTRL. */
#define BF_AFE_BWEWRICTRL_BWE_CTRL(v) ((uint32_t)((uint32_t)(v) << BP_AFE_BWEWRICTRL_BWE_CTRL) & BM_AFE_BWEWRICTRL_BWE_CTRL)

/*! @brief Set the BWE_CTRL field to a new value. */
#define BW_AFE_BWEWRICTRL_BWE_CTRL(x, v) (HW_AFE_BWEWRICTRL_WR(x, (HW_AFE_BWEWRICTRL_RD(x) & ~BM_AFE_BWEWRICTRL_BWE_CTRL) | BF_AFE_BWEWRICTRL_BWE_CTRL(v)))
/*@}*/

/*!
 * @name Register AFE_BWEWRICTRL, field BWE_WRITE_CTRL[2] (RW)
 *
 * Select programming of new weights can be completed on individual slices or
 * all slices minimize the number of writes at once.
 *
 * Values:
 * - 0 - Individual slice
 * - 1 - All slices
 */
/*@{*/
#define BP_AFE_BWEWRICTRL_BWE_WRITE_CTRL (2U) /*!< Bit position for AFE_BWEWRICTRL_BWE_WRITE_CTRL. */
#define BM_AFE_BWEWRICTRL_BWE_WRITE_CTRL (0x00000004U) /*!< Bit mask for AFE_BWEWRICTRL_BWE_WRITE_CTRL. */
#define BS_AFE_BWEWRICTRL_BWE_WRITE_CTRL (1U) /*!< Bit field size in bits for AFE_BWEWRICTRL_BWE_WRITE_CTRL. */

/*! @brief Read current value of the AFE_BWEWRICTRL_BWE_WRITE_CTRL field. */
#define BR_AFE_BWEWRICTRL_BWE_WRITE_CTRL(x) (HW_AFE_BWEWRICTRL(x).B.BWE_WRITE_CTRL)

/*! @brief Format value for bitfield AFE_BWEWRICTRL_BWE_WRITE_CTRL. */
#define BF_AFE_BWEWRICTRL_BWE_WRITE_CTRL(v) ((uint32_t)((uint32_t)(v) << BP_AFE_BWEWRICTRL_BWE_WRITE_CTRL) & BM_AFE_BWEWRICTRL_BWE_WRITE_CTRL)

/*! @brief Set the BWE_WRITE_CTRL field to a new value. */
#define BW_AFE_BWEWRICTRL_BWE_WRITE_CTRL(x, v) (HW_AFE_BWEWRICTRL_WR(x, (HW_AFE_BWEWRICTRL_RD(x) & ~BM_AFE_BWEWRICTRL_BWE_WRITE_CTRL) | BF_AFE_BWEWRICTRL_BWE_WRITE_CTRL(v)))
/*@}*/

/*******************************************************************************
 * HW_AFE_SELSLI - ACC SELECT SLICE
 ******************************************************************************/

/*!
 * @brief HW_AFE_SELSLI - ACC SELECT SLICE (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_afe_selsli
{
    uint32_t U;
    struct _hw_afe_selsli_bitfields
    {
        uint32_t SELECT_SLICE : 8;     /*!< [7:0] ADC Bit Weight Estimation. */
        uint32_t RESERVED0 : 24;       /*!< [31:8]  */
    } B;
} hw_afe_selsli_t;

/*!
 * @name Constants and macros for entire AFE_SELSLI register
 */
/*@{*/
#define HW_AFE_SELSLI_ADDR(x)    ((uintptr_t)(x) + 0x814U)

#define HW_AFE_SELSLI(x)         (*(__IO hw_afe_selsli_t *) HW_AFE_SELSLI_ADDR(x))
#define HW_AFE_SELSLI_RD(x)      (HW_AFE_SELSLI(x).U)
#define HW_AFE_SELSLI_WR(x, v)   (HW_AFE_SELSLI(x).U = (v))
#define HW_AFE_SELSLI_SET(x, v)  (HW_AFE_SELSLI_WR(x, HW_AFE_SELSLI_RD(x) |  (v)))
#define HW_AFE_SELSLI_CLR(x, v)  (HW_AFE_SELSLI_WR(x, HW_AFE_SELSLI_RD(x) & ~(v)))
#define HW_AFE_SELSLI_TOG(x, v)  (HW_AFE_SELSLI_WR(x, HW_AFE_SELSLI_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AFE_SELSLI bitfields
 */

/*!
 * @name Register AFE_SELSLI, field SELECT_SLICE[7:0] (RW)
 *
 * Read/Write selector, lsb.
 */
/*@{*/
#define BP_AFE_SELSLI_SELECT_SLICE (0U)    /*!< Bit position for AFE_SELSLI_SELECT_SLICE. */
#define BM_AFE_SELSLI_SELECT_SLICE (0x000000FFU) /*!< Bit mask for AFE_SELSLI_SELECT_SLICE. */
#define BS_AFE_SELSLI_SELECT_SLICE (8U)    /*!< Bit field size in bits for AFE_SELSLI_SELECT_SLICE. */

/*! @brief Read current value of the AFE_SELSLI_SELECT_SLICE field. */
#define BR_AFE_SELSLI_SELECT_SLICE(x) (HW_AFE_SELSLI(x).B.SELECT_SLICE)

/*! @brief Format value for bitfield AFE_SELSLI_SELECT_SLICE. */
#define BF_AFE_SELSLI_SELECT_SLICE(v) ((uint32_t)((uint32_t)(v) << BP_AFE_SELSLI_SELECT_SLICE) & BM_AFE_SELSLI_SELECT_SLICE)

/*! @brief Set the SELECT_SLICE field to a new value. */
#define BW_AFE_SELSLI_SELECT_SLICE(x, v) (HW_AFE_SELSLI_WR(x, (HW_AFE_SELSLI_RD(x) & ~BM_AFE_SELSLI_SELECT_SLICE) | BF_AFE_SELSLI_SELECT_SLICE(v)))
/*@}*/

/*******************************************************************************
 * HW_AFE_SELBYT - ACC SELECT BYTE
 ******************************************************************************/

/*!
 * @brief HW_AFE_SELBYT - ACC SELECT BYTE (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_afe_selbyt
{
    uint32_t U;
    struct _hw_afe_selbyt_bitfields
    {
        uint32_t SELECT_BYTE : 8;      /*!< [7:0] ADC Bit Weight Estimation. */
        uint32_t RESERVED0 : 24;       /*!< [31:8]  */
    } B;
} hw_afe_selbyt_t;

/*!
 * @name Constants and macros for entire AFE_SELBYT register
 */
/*@{*/
#define HW_AFE_SELBYT_ADDR(x)    ((uintptr_t)(x) + 0x818U)

#define HW_AFE_SELBYT(x)         (*(__IO hw_afe_selbyt_t *) HW_AFE_SELBYT_ADDR(x))
#define HW_AFE_SELBYT_RD(x)      (HW_AFE_SELBYT(x).U)
#define HW_AFE_SELBYT_WR(x, v)   (HW_AFE_SELBYT(x).U = (v))
#define HW_AFE_SELBYT_SET(x, v)  (HW_AFE_SELBYT_WR(x, HW_AFE_SELBYT_RD(x) |  (v)))
#define HW_AFE_SELBYT_CLR(x, v)  (HW_AFE_SELBYT_WR(x, HW_AFE_SELBYT_RD(x) & ~(v)))
#define HW_AFE_SELBYT_TOG(x, v)  (HW_AFE_SELBYT_WR(x, HW_AFE_SELBYT_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AFE_SELBYT bitfields
 */

/*!
 * @name Register AFE_SELBYT, field SELECT_BYTE[7:0] (RW)
 *
 * Read/Write, msb.
 */
/*@{*/
#define BP_AFE_SELBYT_SELECT_BYTE (0U)     /*!< Bit position for AFE_SELBYT_SELECT_BYTE. */
#define BM_AFE_SELBYT_SELECT_BYTE (0x000000FFU) /*!< Bit mask for AFE_SELBYT_SELECT_BYTE. */
#define BS_AFE_SELBYT_SELECT_BYTE (8U)     /*!< Bit field size in bits for AFE_SELBYT_SELECT_BYTE. */

/*! @brief Read current value of the AFE_SELBYT_SELECT_BYTE field. */
#define BR_AFE_SELBYT_SELECT_BYTE(x) (HW_AFE_SELBYT(x).B.SELECT_BYTE)

/*! @brief Format value for bitfield AFE_SELBYT_SELECT_BYTE. */
#define BF_AFE_SELBYT_SELECT_BYTE(v) ((uint32_t)((uint32_t)(v) << BP_AFE_SELBYT_SELECT_BYTE) & BM_AFE_SELBYT_SELECT_BYTE)

/*! @brief Set the SELECT_BYTE field to a new value. */
#define BW_AFE_SELBYT_SELECT_BYTE(x, v) (HW_AFE_SELBYT_WR(x, (HW_AFE_SELBYT_RD(x) & ~BM_AFE_SELBYT_SELECT_BYTE) | BF_AFE_SELBYT_SELECT_BYTE(v)))
/*@}*/

/*******************************************************************************
 * HW_AFE_REDVAL - ACC READ VALUE
 ******************************************************************************/

/*!
 * @brief HW_AFE_REDVAL - ACC READ VALUE (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_afe_redval
{
    uint32_t U;
    struct _hw_afe_redval_bitfields
    {
        uint32_t READ_VALUE : 8;       /*!< [7:0] ADC Bit Weight Estimation. */
        uint32_t RESERVED0 : 24;       /*!< [31:8]  */
    } B;
} hw_afe_redval_t;

/*!
 * @name Constants and macros for entire AFE_REDVAL register
 */
/*@{*/
#define HW_AFE_REDVAL_ADDR(x)    ((uintptr_t)(x) + 0x820U)

#define HW_AFE_REDVAL(x)         (*(__I hw_afe_redval_t *) HW_AFE_REDVAL_ADDR(x))
#define HW_AFE_REDVAL_RD(x)      (HW_AFE_REDVAL(x).U)
/*@}*/

/*
 * Constants & macros for individual AFE_REDVAL bitfields
 */

/*!
 * @name Register AFE_REDVAL, field READ_VALUE[7:0] (RO)
 *
 * Weight read register, lsb.
 */
/*@{*/
#define BP_AFE_REDVAL_READ_VALUE (0U)      /*!< Bit position for AFE_REDVAL_READ_VALUE. */
#define BM_AFE_REDVAL_READ_VALUE (0x000000FFU) /*!< Bit mask for AFE_REDVAL_READ_VALUE. */
#define BS_AFE_REDVAL_READ_VALUE (8U)      /*!< Bit field size in bits for AFE_REDVAL_READ_VALUE. */

/*! @brief Read current value of the AFE_REDVAL_READ_VALUE field. */
#define BR_AFE_REDVAL_READ_VALUE(x) (HW_AFE_REDVAL(x).B.READ_VALUE)
/*@}*/

/*******************************************************************************
 * HW_AFE_WRIBYT - ACC WRITE BYTE
 ******************************************************************************/

/*!
 * @brief HW_AFE_WRIBYT - ACC WRITE BYTE (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_afe_wribyt
{
    uint32_t U;
    struct _hw_afe_wribyt_bitfields
    {
        uint32_t WRITE_BYTE : 8;       /*!< [7:0] ADC Bit Weight Estimation. */
        uint32_t RESERVED0 : 24;       /*!< [31:8]  */
    } B;
} hw_afe_wribyt_t;

/*!
 * @name Constants and macros for entire AFE_WRIBYT register
 */
/*@{*/
#define HW_AFE_WRIBYT_ADDR(x)    ((uintptr_t)(x) + 0x824U)

#define HW_AFE_WRIBYT(x)         (*(__IO hw_afe_wribyt_t *) HW_AFE_WRIBYT_ADDR(x))
#define HW_AFE_WRIBYT_RD(x)      (HW_AFE_WRIBYT(x).U)
#define HW_AFE_WRIBYT_WR(x, v)   (HW_AFE_WRIBYT(x).U = (v))
#define HW_AFE_WRIBYT_SET(x, v)  (HW_AFE_WRIBYT_WR(x, HW_AFE_WRIBYT_RD(x) |  (v)))
#define HW_AFE_WRIBYT_CLR(x, v)  (HW_AFE_WRIBYT_WR(x, HW_AFE_WRIBYT_RD(x) & ~(v)))
#define HW_AFE_WRIBYT_TOG(x, v)  (HW_AFE_WRIBYT_WR(x, HW_AFE_WRIBYT_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AFE_WRIBYT bitfields
 */

/*!
 * @name Register AFE_WRIBYT, field WRITE_BYTE[7:0] (RW)
 *
 * Weight write register, lsb.
 */
/*@{*/
#define BP_AFE_WRIBYT_WRITE_BYTE (0U)      /*!< Bit position for AFE_WRIBYT_WRITE_BYTE. */
#define BM_AFE_WRIBYT_WRITE_BYTE (0x000000FFU) /*!< Bit mask for AFE_WRIBYT_WRITE_BYTE. */
#define BS_AFE_WRIBYT_WRITE_BYTE (8U)      /*!< Bit field size in bits for AFE_WRIBYT_WRITE_BYTE. */

/*! @brief Read current value of the AFE_WRIBYT_WRITE_BYTE field. */
#define BR_AFE_WRIBYT_WRITE_BYTE(x) (HW_AFE_WRIBYT(x).B.WRITE_BYTE)

/*! @brief Format value for bitfield AFE_WRIBYT_WRITE_BYTE. */
#define BF_AFE_WRIBYT_WRITE_BYTE(v) ((uint32_t)((uint32_t)(v) << BP_AFE_WRIBYT_WRITE_BYTE) & BM_AFE_WRIBYT_WRITE_BYTE)

/*! @brief Set the WRITE_BYTE field to a new value. */
#define BW_AFE_WRIBYT_WRITE_BYTE(x, v) (HW_AFE_WRIBYT_WR(x, (HW_AFE_WRIBYT_RD(x) & ~BM_AFE_WRIBYT_WRITE_BYTE) | BF_AFE_WRIBYT_WRITE_BYTE(v)))
/*@}*/

/*******************************************************************************
 * hw_afe_t - module struct
 ******************************************************************************/
/*!
 * @brief All AFE module registers.
 */
#pragma pack(1)
typedef struct _hw_afe
{
    __I hw_afe_block_id_t BLOCK_ID;        /*!< [0x0]  */
    __IO hw_afe_pdbuf_t PDBUF;             /*!< [0x4] Power Down Buffers */
    __IO hw_afe_swrst_t SWRST;             /*!< [0x8] Software Reset */
    uint8_t _reserved0[12];
    __IO hw_afe_bgreg_t BGREG;             /*!< [0x18] Band Gap */
    uint8_t _reserved1[996];
    __I hw_afe_accessar_id_t ACCESSAR_ID;  /*!< [0x400] Accessar ID */
    __IO hw_afe_pdadc_t PDADC;             /*!< [0x404] Power Down ADC */
    __IO hw_afe_pdsarh_t PDSARH;           /*!< [0x408] Power Down SAR High */
    __IO hw_afe_pdsarl_t PDSARL;           /*!< [0x40C] Power Down SAR Low */
    __IO hw_afe_pdadcrfh_t PDADCRFH;       /*!< [0x410] Power Down ADC Ref. High */
    __IO hw_afe_pdadcrfl_t PDADCRFL;       /*!< [0x414] Power Down ADC Ref. Low */
    uint8_t _reserved2[4];
    __IO hw_afe_adcgn_t ADCGN;             /*!< [0x41C] ADC Gain */
    uint8_t _reserved3[20];
    __IO hw_afe_reftriml_t REFTRIML;       /*!< [0x434] ADC Ref Trim Low */
    __IO hw_afe_reftrimh_t REFTRIMH;       /*!< [0x438] ADC Ref Trim High */
    uint8_t _reserved4[16];
    __IO hw_afe_dacamp_t DACAMP;           /*!< [0x44C] Clamp DAC Trim */
    uint8_t _reserved5[4];
    __IO hw_afe_clmpdat_t CLMPDAT;         /*!< [0x454] Clamp DAC Data */
    __IO hw_afe_clmpamp_t CLMPAMP;         /*!< [0x458] Clamp DAC Control */
    __IO hw_afe_clamp_t CLAMP;             /*!< [0x45C] Clamp Control */
    __IO hw_afe_inpbuf_t INPBUF;           /*!< [0x460] Input Buffer */
    __IO hw_afe_inpflt_t INPFLT;           /*!< [0x464] Analog Input Filter */
    __IO hw_afe_adcdgn_t ADCDGN;           /*!< [0x468] ADC Digital Gain */
    __IO hw_afe_offdrv_t OFFDRV;           /*!< [0x46C] Off-Chip Drive */
    __IO hw_afe_inpconfig_t INPCONFIG;     /*!< [0x470] VADC INPUT CONFIG */
    __IO hw_afe_progdelay_t PROGDELAY;     /*!< [0x474] VADC PROG DELAY */
    __IO hw_afe_adcomt_t ADCOMT;           /*!< [0x478] ADC COMPARATOR TIMING */
    __I hw_afe_algdelay_t ALGDELAY;        /*!< [0x47C] ALGORITHM DELAY */
    uint8_t _reserved6[896];
    __I hw_afe_acc_id_t ACC_ID;            /*!< [0x800] Acc ID */
    __I hw_afe_accsta_t ACCSTA;            /*!< [0x804] ACC STATUS */
    __IO hw_afe_accnosli_t ACCNOSLI;       /*!< [0x808] ACC NUMBER OF SLICE */
    __IO hw_afe_acccalcon_t ACCCALCON;     /*!< [0x80C] ACC CALIBRATE CONTROL */
    __IO hw_afe_bwewrictrl_t BWEWRICTRL;   /*!< [0x810] ACC BWE WRITE CONTROL */
    __IO hw_afe_selsli_t SELSLI;           /*!< [0x814] ACC SELECT SLICE */
    __IO hw_afe_selbyt_t SELBYT;           /*!< [0x818] ACC SELECT BYTE */
    uint8_t _reserved7[4];
    __I hw_afe_redval_t REDVAL;            /*!< [0x820] ACC READ VALUE */
    __IO hw_afe_wribyt_t WRIBYT;           /*!< [0x824] ACC WRITE BYTE */
} hw_afe_t;
#pragma pack()

/*! @brief Macro to access all AFE registers. */
/*! @param x AFE module instance base address. */
/*! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
 *     use the '&' operator, like <code>&HW_AFE_REGS(AFE_BASE)</code>. */
#define HW_AFE_REGS(x) (*(hw_afe_t *)(x))

/*
 * iMX6SX ASRC
 *
 * ASRC Registers
 *
 * Registers defined in this header file:
 * - HW_ASRC_ASRCTR - ASRC Control Register
 * - HW_ASRC_ASRIER - ASRC Interrupt Enable Register
 * - HW_ASRC_ASRCNCR - ASRC Channel Number Configuration Register
 * - HW_ASRC_ASRCFG - ASRC Filter Configuration Status Register
 * - HW_ASRC_ASRCSR - ASRC Clock Source Register
 * - HW_ASRC_ASRCDR1 - ASRC Clock Divider Register 1
 * - HW_ASRC_ASRCDR2 - ASRC Clock Divider Register 2
 * - HW_ASRC_ASRSTR - ASRC Status Register
 * - HW_ASRC_ASRPMn1 - ASRC Parameter Register n
 * - HW_ASRC_ASRPMn2 - ASRC Parameter Register n
 * - HW_ASRC_ASRPMn3 - ASRC Parameter Register n
 * - HW_ASRC_ASRPMn4 - ASRC Parameter Register n
 * - HW_ASRC_ASRPMn5 - ASRC Parameter Register n
 * - HW_ASRC_ASRTFR1 - ASRC ASRC Task Queue FIFO Register 1
 * - HW_ASRC_ASRCCR - ASRC Channel Counter Register
 * - HW_ASRC_ASRDIn - ASRC Data Input Register for Pair x
 * - HW_ASRC_ASRDOn - ASRC Data Output Register for Pair x
 * - HW_ASRC_ASRIDRHA - ASRC Ideal Ratio for Pair A-High Part
 * - HW_ASRC_ASRIDRLA - ASRC Ideal Ratio for Pair A -Low Part
 * - HW_ASRC_ASRIDRHB - ASRC Ideal Ratio for Pair B-High Part
 * - HW_ASRC_ASRIDRLB - ASRC Ideal Ratio for Pair B-Low Part
 * - HW_ASRC_ASRIDRHC - ASRC Ideal Ratio for Pair C-High Part
 * - HW_ASRC_ASRIDRLC - ASRC Ideal Ratio for Pair C-Low Part
 * - HW_ASRC_ASR76K - ASRC 76kHz Period in terms of ASRC processing clock
 * - HW_ASRC_ASR56K - ASRC 56kHz Period in terms of ASRC processing clock
 * - HW_ASRC_ASRMCRA - ASRC Misc Control Register for Pair A
 * - HW_ASRC_ASRFSTA - ASRC FIFO Status Register for Pair A
 * - HW_ASRC_ASRMCRB - ASRC Misc Control Register for Pair B
 * - HW_ASRC_ASRFSTB - ASRC FIFO Status Register for Pair B
 * - HW_ASRC_ASRMCRC - ASRC Misc Control Register for Pair C
 * - HW_ASRC_ASRFSTC - ASRC FIFO Status Register for Pair C
 * - HW_ASRC_ASRMCR1n - ASRC Misc Control Register 1 for Pair X
 *
 * - hw_asrc_t - Struct containing all module registers.
 */

#define HW_ASRC_INSTANCE_COUNT (1U) /*!< Number of instances of the ASRC module. */
#define HW_ASRC (0U) /*!< Instance number for ASRC. */
#define ASRC_BASE             (0x2034000U) /*!< Base address for ASRC. */
/*! Array initializer of ASRC base addresses. */
#define ASRC_BASE_ADDRS       { ASRC_BASE }

/*******************************************************************************
 * HW_ASRC_ASRCTR - ASRC Control Register
 ******************************************************************************/

/*!
 * @brief HW_ASRC_ASRCTR - ASRC Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The ASRC control register (ASRCTR) is a 24-bit read/write register that
 * controls the ASRC operations.
 */
typedef union _hw_asrc_asrctr
{
    uint32_t U;
    struct _hw_asrc_asrctr_bitfields
    {
        uint32_t ASRCEN : 1;           /*!< [0]  */
        uint32_t ASREA : 1;            /*!< [1]  */
        uint32_t ASREB : 1;            /*!< [2]  */
        uint32_t ASREC : 1;            /*!< [3]  */
        uint32_t SRST : 1;             /*!< [4]  */
        uint32_t RESERVED0 : 8;        /*!< [12:5]  */
        uint32_t IDRA : 1;             /*!< [13]  */
        uint32_t USRA : 1;             /*!< [14]  */
        uint32_t IDRB : 1;             /*!< [15]  */
        uint32_t USRB : 1;             /*!< [16]  */
        uint32_t IDRC : 1;             /*!< [17]  */
        uint32_t USRC : 1;             /*!< [18]  */
        uint32_t RESERVED1 : 1;        /*!< [19]  */
        uint32_t ATSA : 1;             /*!< [20]  */
        uint32_t ATSB : 1;             /*!< [21]  */
        uint32_t ATSC : 1;             /*!< [22]  */
        uint32_t RESERVED2 : 9;        /*!< [31:23] This is a 24-bit register the
                                        * upper byte is unimplemented. */
    } B;
} hw_asrc_asrctr_t;

/*!
 * @name Constants and macros for entire ASRC_ASRCTR register
 */
/*@{*/
#define HW_ASRC_ASRCTR_ADDR(x)   ((uintptr_t)(x) + 0x0U)

#define HW_ASRC_ASRCTR(x)        (*(__IO hw_asrc_asrctr_t *) HW_ASRC_ASRCTR_ADDR(x))
#define HW_ASRC_ASRCTR_RD(x)     (HW_ASRC_ASRCTR(x).U)
#define HW_ASRC_ASRCTR_WR(x, v)  (HW_ASRC_ASRCTR(x).U = (v))
#define HW_ASRC_ASRCTR_SET(x, v) (HW_ASRC_ASRCTR_WR(x, HW_ASRC_ASRCTR_RD(x) |  (v)))
#define HW_ASRC_ASRCTR_CLR(x, v) (HW_ASRC_ASRCTR_WR(x, HW_ASRC_ASRCTR_RD(x) & ~(v)))
#define HW_ASRC_ASRCTR_TOG(x, v) (HW_ASRC_ASRCTR_WR(x, HW_ASRC_ASRCTR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ASRC_ASRCTR bitfields
 */

/*!
 * @name Register ASRC_ASRCTR, field ASRCEN[0] (RW)
 *
 * ASRC Enable Enable the operation of ASRC.
 */
/*@{*/
#define BP_ASRC_ASRCTR_ASRCEN (0U)         /*!< Bit position for ASRC_ASRCTR_ASRCEN. */
#define BM_ASRC_ASRCTR_ASRCEN (0x00000001U) /*!< Bit mask for ASRC_ASRCTR_ASRCEN. */
#define BS_ASRC_ASRCTR_ASRCEN (1U)         /*!< Bit field size in bits for ASRC_ASRCTR_ASRCEN. */

/*! @brief Read current value of the ASRC_ASRCTR_ASRCEN field. */
#define BR_ASRC_ASRCTR_ASRCEN(x) (HW_ASRC_ASRCTR(x).B.ASRCEN)

/*! @brief Format value for bitfield ASRC_ASRCTR_ASRCEN. */
#define BF_ASRC_ASRCTR_ASRCEN(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCTR_ASRCEN) & BM_ASRC_ASRCTR_ASRCEN)

/*! @brief Set the ASRCEN field to a new value. */
#define BW_ASRC_ASRCTR_ASRCEN(x, v) (HW_ASRC_ASRCTR_WR(x, (HW_ASRC_ASRCTR_RD(x) & ~BM_ASRC_ASRCTR_ASRCEN) | BF_ASRC_ASRCTR_ASRCEN(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCTR, field ASREA[1] (RW)
 *
 * ASRC Enable A Enable the operation of the conversion A of ASRC. When ASREA is
 * cleared, operation of conversion A is disabled.
 */
/*@{*/
#define BP_ASRC_ASRCTR_ASREA (1U)          /*!< Bit position for ASRC_ASRCTR_ASREA. */
#define BM_ASRC_ASRCTR_ASREA (0x00000002U) /*!< Bit mask for ASRC_ASRCTR_ASREA. */
#define BS_ASRC_ASRCTR_ASREA (1U)          /*!< Bit field size in bits for ASRC_ASRCTR_ASREA. */

/*! @brief Read current value of the ASRC_ASRCTR_ASREA field. */
#define BR_ASRC_ASRCTR_ASREA(x) (HW_ASRC_ASRCTR(x).B.ASREA)

/*! @brief Format value for bitfield ASRC_ASRCTR_ASREA. */
#define BF_ASRC_ASRCTR_ASREA(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCTR_ASREA) & BM_ASRC_ASRCTR_ASREA)

/*! @brief Set the ASREA field to a new value. */
#define BW_ASRC_ASRCTR_ASREA(x, v) (HW_ASRC_ASRCTR_WR(x, (HW_ASRC_ASRCTR_RD(x) & ~BM_ASRC_ASRCTR_ASREA) | BF_ASRC_ASRCTR_ASREA(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCTR, field ASREB[2] (RW)
 *
 * ASRC Enable B Enable the operation of the conversion B of ASRC. When ASREB is
 * cleared, operation of conversion B is disabled.
 */
/*@{*/
#define BP_ASRC_ASRCTR_ASREB (2U)          /*!< Bit position for ASRC_ASRCTR_ASREB. */
#define BM_ASRC_ASRCTR_ASREB (0x00000004U) /*!< Bit mask for ASRC_ASRCTR_ASREB. */
#define BS_ASRC_ASRCTR_ASREB (1U)          /*!< Bit field size in bits for ASRC_ASRCTR_ASREB. */

/*! @brief Read current value of the ASRC_ASRCTR_ASREB field. */
#define BR_ASRC_ASRCTR_ASREB(x) (HW_ASRC_ASRCTR(x).B.ASREB)

/*! @brief Format value for bitfield ASRC_ASRCTR_ASREB. */
#define BF_ASRC_ASRCTR_ASREB(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCTR_ASREB) & BM_ASRC_ASRCTR_ASREB)

/*! @brief Set the ASREB field to a new value. */
#define BW_ASRC_ASRCTR_ASREB(x, v) (HW_ASRC_ASRCTR_WR(x, (HW_ASRC_ASRCTR_RD(x) & ~BM_ASRC_ASRCTR_ASREB) | BF_ASRC_ASRCTR_ASREB(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCTR, field ASREC[3] (RW)
 *
 * ASRC Enable C Enable the operation of the conversion C of ASRC. When ASREC is
 * cleared, operation of conversion C is disabled.
 */
/*@{*/
#define BP_ASRC_ASRCTR_ASREC (3U)          /*!< Bit position for ASRC_ASRCTR_ASREC. */
#define BM_ASRC_ASRCTR_ASREC (0x00000008U) /*!< Bit mask for ASRC_ASRCTR_ASREC. */
#define BS_ASRC_ASRCTR_ASREC (1U)          /*!< Bit field size in bits for ASRC_ASRCTR_ASREC. */

/*! @brief Read current value of the ASRC_ASRCTR_ASREC field. */
#define BR_ASRC_ASRCTR_ASREC(x) (HW_ASRC_ASRCTR(x).B.ASREC)

/*! @brief Format value for bitfield ASRC_ASRCTR_ASREC. */
#define BF_ASRC_ASRCTR_ASREC(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCTR_ASREC) & BM_ASRC_ASRCTR_ASREC)

/*! @brief Set the ASREC field to a new value. */
#define BW_ASRC_ASRCTR_ASREC(x, v) (HW_ASRC_ASRCTR_WR(x, (HW_ASRC_ASRCTR_RD(x) & ~BM_ASRC_ASRCTR_ASREC) | BF_ASRC_ASRCTR_ASREC(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCTR, field SRST[4] (WO)
 *
 * Software Reset This bit is self-clear bit. Once it is been written as 1, it
 * will generate a software reset signal inside ASRC. After 9 cycles of the ASRC
 * processing clock, this reset process will stop, and this bit will be cleared
 * automatically.
 */
/*@{*/
#define BP_ASRC_ASRCTR_SRST  (4U)          /*!< Bit position for ASRC_ASRCTR_SRST. */
#define BM_ASRC_ASRCTR_SRST  (0x00000010U) /*!< Bit mask for ASRC_ASRCTR_SRST. */
#define BS_ASRC_ASRCTR_SRST  (1U)          /*!< Bit field size in bits for ASRC_ASRCTR_SRST. */

/*! @brief Format value for bitfield ASRC_ASRCTR_SRST. */
#define BF_ASRC_ASRCTR_SRST(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCTR_SRST) & BM_ASRC_ASRCTR_SRST)
/*@}*/

/*!
 * @name Register ASRC_ASRCTR, field IDRA[13] (RW)
 *
 * Use Ideal Ratio for Pair A When USRA=0, this bit has no usage. When USRA=1
 * and IDRA=0, ASRC internal measured ratio will be used. When USRA=1 and IDRA=1,
 * the idea ratio from the interface register ASRIDRHA, ASRIDRLA will be used. It
 * is suggested to manually set ASRCFG:POSTMODA, ASRCFG:PREMODA according to in
 * this case.
 */
/*@{*/
#define BP_ASRC_ASRCTR_IDRA  (13U)         /*!< Bit position for ASRC_ASRCTR_IDRA. */
#define BM_ASRC_ASRCTR_IDRA  (0x00002000U) /*!< Bit mask for ASRC_ASRCTR_IDRA. */
#define BS_ASRC_ASRCTR_IDRA  (1U)          /*!< Bit field size in bits for ASRC_ASRCTR_IDRA. */

/*! @brief Read current value of the ASRC_ASRCTR_IDRA field. */
#define BR_ASRC_ASRCTR_IDRA(x) (HW_ASRC_ASRCTR(x).B.IDRA)

/*! @brief Format value for bitfield ASRC_ASRCTR_IDRA. */
#define BF_ASRC_ASRCTR_IDRA(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCTR_IDRA) & BM_ASRC_ASRCTR_IDRA)

/*! @brief Set the IDRA field to a new value. */
#define BW_ASRC_ASRCTR_IDRA(x, v) (HW_ASRC_ASRCTR_WR(x, (HW_ASRC_ASRCTR_RD(x) & ~BM_ASRC_ASRCTR_IDRA) | BF_ASRC_ASRCTR_IDRA(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCTR, field USRA[14] (RW)
 *
 * Use Ratio for Pair A Use ratio as the input to ASRC. This bit is used in
 * conjunction with IDRA control bit.
 */
/*@{*/
#define BP_ASRC_ASRCTR_USRA  (14U)         /*!< Bit position for ASRC_ASRCTR_USRA. */
#define BM_ASRC_ASRCTR_USRA  (0x00004000U) /*!< Bit mask for ASRC_ASRCTR_USRA. */
#define BS_ASRC_ASRCTR_USRA  (1U)          /*!< Bit field size in bits for ASRC_ASRCTR_USRA. */

/*! @brief Read current value of the ASRC_ASRCTR_USRA field. */
#define BR_ASRC_ASRCTR_USRA(x) (HW_ASRC_ASRCTR(x).B.USRA)

/*! @brief Format value for bitfield ASRC_ASRCTR_USRA. */
#define BF_ASRC_ASRCTR_USRA(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCTR_USRA) & BM_ASRC_ASRCTR_USRA)

/*! @brief Set the USRA field to a new value. */
#define BW_ASRC_ASRCTR_USRA(x, v) (HW_ASRC_ASRCTR_WR(x, (HW_ASRC_ASRCTR_RD(x) & ~BM_ASRC_ASRCTR_USRA) | BF_ASRC_ASRCTR_USRA(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCTR, field IDRB[15] (RW)
 *
 * Use Ideal Ratio for Pair B When USRB=0, this bit has no usage. When USRB=1
 * and IDRB=0, ASRC internal measured ratio will be used. When USRB=1 and IDRB=1,
 * the idea ratio from the interface register ASRIDRHB, ASRIDRLB will be used.It
 * is suggested to manually set ASRCFG:POSTMODB, ASRCFG:PREMODB according to in
 * this case.
 */
/*@{*/
#define BP_ASRC_ASRCTR_IDRB  (15U)         /*!< Bit position for ASRC_ASRCTR_IDRB. */
#define BM_ASRC_ASRCTR_IDRB  (0x00008000U) /*!< Bit mask for ASRC_ASRCTR_IDRB. */
#define BS_ASRC_ASRCTR_IDRB  (1U)          /*!< Bit field size in bits for ASRC_ASRCTR_IDRB. */

/*! @brief Read current value of the ASRC_ASRCTR_IDRB field. */
#define BR_ASRC_ASRCTR_IDRB(x) (HW_ASRC_ASRCTR(x).B.IDRB)

/*! @brief Format value for bitfield ASRC_ASRCTR_IDRB. */
#define BF_ASRC_ASRCTR_IDRB(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCTR_IDRB) & BM_ASRC_ASRCTR_IDRB)

/*! @brief Set the IDRB field to a new value. */
#define BW_ASRC_ASRCTR_IDRB(x, v) (HW_ASRC_ASRCTR_WR(x, (HW_ASRC_ASRCTR_RD(x) & ~BM_ASRC_ASRCTR_IDRB) | BF_ASRC_ASRCTR_IDRB(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCTR, field USRB[16] (RW)
 *
 * Use Ratio for Pair B Use ratio as the input to ASRC. This bit is used in
 * conjunction with IDRB control bit.
 */
/*@{*/
#define BP_ASRC_ASRCTR_USRB  (16U)         /*!< Bit position for ASRC_ASRCTR_USRB. */
#define BM_ASRC_ASRCTR_USRB  (0x00010000U) /*!< Bit mask for ASRC_ASRCTR_USRB. */
#define BS_ASRC_ASRCTR_USRB  (1U)          /*!< Bit field size in bits for ASRC_ASRCTR_USRB. */

/*! @brief Read current value of the ASRC_ASRCTR_USRB field. */
#define BR_ASRC_ASRCTR_USRB(x) (HW_ASRC_ASRCTR(x).B.USRB)

/*! @brief Format value for bitfield ASRC_ASRCTR_USRB. */
#define BF_ASRC_ASRCTR_USRB(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCTR_USRB) & BM_ASRC_ASRCTR_USRB)

/*! @brief Set the USRB field to a new value. */
#define BW_ASRC_ASRCTR_USRB(x, v) (HW_ASRC_ASRCTR_WR(x, (HW_ASRC_ASRCTR_RD(x) & ~BM_ASRC_ASRCTR_USRB) | BF_ASRC_ASRCTR_USRB(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCTR, field IDRC[17] (RW)
 *
 * Use Ideal Ratio for Pair C When USRC=0, this bit has no usage. When USRC=1
 * and IDRC=0, ASRC internal measured ratio will be used. When USRC=1 and IDRC=1,
 * the idea ratio from the interface register ASRIDRHC, ASRIDRLC will be used. It
 * is suggested to manually set ASRCFG:POSTMODC, ASRCFG:PREMODC according to in
 * this case.
 */
/*@{*/
#define BP_ASRC_ASRCTR_IDRC  (17U)         /*!< Bit position for ASRC_ASRCTR_IDRC. */
#define BM_ASRC_ASRCTR_IDRC  (0x00020000U) /*!< Bit mask for ASRC_ASRCTR_IDRC. */
#define BS_ASRC_ASRCTR_IDRC  (1U)          /*!< Bit field size in bits for ASRC_ASRCTR_IDRC. */

/*! @brief Read current value of the ASRC_ASRCTR_IDRC field. */
#define BR_ASRC_ASRCTR_IDRC(x) (HW_ASRC_ASRCTR(x).B.IDRC)

/*! @brief Format value for bitfield ASRC_ASRCTR_IDRC. */
#define BF_ASRC_ASRCTR_IDRC(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCTR_IDRC) & BM_ASRC_ASRCTR_IDRC)

/*! @brief Set the IDRC field to a new value. */
#define BW_ASRC_ASRCTR_IDRC(x, v) (HW_ASRC_ASRCTR_WR(x, (HW_ASRC_ASRCTR_RD(x) & ~BM_ASRC_ASRCTR_IDRC) | BF_ASRC_ASRCTR_IDRC(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCTR, field USRC[18] (RW)
 *
 * Use Ratio for Pair C Use ratio as the input to ASRC. This bit is used in
 * conjunction with IDRC control bit.
 */
/*@{*/
#define BP_ASRC_ASRCTR_USRC  (18U)         /*!< Bit position for ASRC_ASRCTR_USRC. */
#define BM_ASRC_ASRCTR_USRC  (0x00040000U) /*!< Bit mask for ASRC_ASRCTR_USRC. */
#define BS_ASRC_ASRCTR_USRC  (1U)          /*!< Bit field size in bits for ASRC_ASRCTR_USRC. */

/*! @brief Read current value of the ASRC_ASRCTR_USRC field. */
#define BR_ASRC_ASRCTR_USRC(x) (HW_ASRC_ASRCTR(x).B.USRC)

/*! @brief Format value for bitfield ASRC_ASRCTR_USRC. */
#define BF_ASRC_ASRCTR_USRC(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCTR_USRC) & BM_ASRC_ASRCTR_USRC)

/*! @brief Set the USRC field to a new value. */
#define BW_ASRC_ASRCTR_USRC(x, v) (HW_ASRC_ASRCTR_WR(x, (HW_ASRC_ASRCTR_RD(x) & ~BM_ASRC_ASRCTR_USRC) | BF_ASRC_ASRCTR_USRC(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCTR, field ATSA[20] (RW)
 *
 * ASRC Pair A Automatic Selection For Processing Options When this bit is 1,
 * pair A will automatic update its pre-processing and post-processing options
 * (ASRCFG: PREMODA, ASRCFG:POSTMODA see ASRC Misc Control Register 1 for Pair CASRC
 * Filter Configuration Status Register ) based on the frequencies it detected.
 * To use this option, the two parameter registers(ASR76K and ASR56K) should be
 * set correctly (see ASRC Misc Control Register 1 for Pair CASRC 76kHz Period in
 * terms of ASRC processing clock and ASRC Misc Control Register 1 for Pair CASRC
 * 56kHz Period in terms of ASRC processing clock ). When this bit is 0, the user
 * is responsible for choosing the proper processing options for pair A. This
 * bit should be disabled when {USRA, IDRA}={1,1}.
 */
/*@{*/
#define BP_ASRC_ASRCTR_ATSA  (20U)         /*!< Bit position for ASRC_ASRCTR_ATSA. */
#define BM_ASRC_ASRCTR_ATSA  (0x00100000U) /*!< Bit mask for ASRC_ASRCTR_ATSA. */
#define BS_ASRC_ASRCTR_ATSA  (1U)          /*!< Bit field size in bits for ASRC_ASRCTR_ATSA. */

/*! @brief Read current value of the ASRC_ASRCTR_ATSA field. */
#define BR_ASRC_ASRCTR_ATSA(x) (HW_ASRC_ASRCTR(x).B.ATSA)

/*! @brief Format value for bitfield ASRC_ASRCTR_ATSA. */
#define BF_ASRC_ASRCTR_ATSA(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCTR_ATSA) & BM_ASRC_ASRCTR_ATSA)

/*! @brief Set the ATSA field to a new value. */
#define BW_ASRC_ASRCTR_ATSA(x, v) (HW_ASRC_ASRCTR_WR(x, (HW_ASRC_ASRCTR_RD(x) & ~BM_ASRC_ASRCTR_ATSA) | BF_ASRC_ASRCTR_ATSA(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCTR, field ATSB[21] (RW)
 *
 * ASRC Pair B Automatic Selection For Processing Options When this bit is 1,
 * pair B will automatic update its pre-processing and post-processing options
 * (ASRCFG: PREMODB, ASRCFG:POSTMODB see ASRC Misc Control Register 1 for Pair CASRC
 * Filter Configuration Status Register ) based on the frequencies it detected.
 * To use this option, the two parameter registers(ASR76K and ASR56K) should be
 * set correctly (see ASRC Misc Control Register 1 for Pair CASRC 76kHz Period in
 * terms of ASRC processing clock and ASRC Misc Control Register 1 for Pair CASRC
 * 56kHz Period in terms of ASRC processing clock ). When this bit is 0, the user
 * is responsible for choosing the proper processing options for pair B. This
 * bit should be disabled when {USRB, IDRB}={1,1}.
 */
/*@{*/
#define BP_ASRC_ASRCTR_ATSB  (21U)         /*!< Bit position for ASRC_ASRCTR_ATSB. */
#define BM_ASRC_ASRCTR_ATSB  (0x00200000U) /*!< Bit mask for ASRC_ASRCTR_ATSB. */
#define BS_ASRC_ASRCTR_ATSB  (1U)          /*!< Bit field size in bits for ASRC_ASRCTR_ATSB. */

/*! @brief Read current value of the ASRC_ASRCTR_ATSB field. */
#define BR_ASRC_ASRCTR_ATSB(x) (HW_ASRC_ASRCTR(x).B.ATSB)

/*! @brief Format value for bitfield ASRC_ASRCTR_ATSB. */
#define BF_ASRC_ASRCTR_ATSB(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCTR_ATSB) & BM_ASRC_ASRCTR_ATSB)

/*! @brief Set the ATSB field to a new value. */
#define BW_ASRC_ASRCTR_ATSB(x, v) (HW_ASRC_ASRCTR_WR(x, (HW_ASRC_ASRCTR_RD(x) & ~BM_ASRC_ASRCTR_ATSB) | BF_ASRC_ASRCTR_ATSB(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCTR, field ATSC[22] (RW)
 *
 * ASRC Pair C Automatic Selection For Processing Options When this bit is 1,
 * pair C will automatic update its pre-processing and post-processing options
 * (ASRCFG: PREMODC, ASRCFG:POSTMODC see ASRC Misc Control Register 1 for Pair CASRC
 * Filter Configuration Status Register ) based on the frequencies it detected.
 * To use this option, the two parameter registers(ASR76K and ASR56K) should be
 * set correctly (see ASRC Misc Control Register 1 for Pair CASRC 76kHz Period in
 * terms of ASRC processing clock and ASRC Misc Control Register 1 for Pair CASRC
 * 56kHz Period in terms of ASRC processing clock ). When this bit is 0, the user
 * is responsible for choosing the proper processing options for pair C. This
 * bit should be disabled when {USRC, IDRC}={1,1}.
 */
/*@{*/
#define BP_ASRC_ASRCTR_ATSC  (22U)         /*!< Bit position for ASRC_ASRCTR_ATSC. */
#define BM_ASRC_ASRCTR_ATSC  (0x00400000U) /*!< Bit mask for ASRC_ASRCTR_ATSC. */
#define BS_ASRC_ASRCTR_ATSC  (1U)          /*!< Bit field size in bits for ASRC_ASRCTR_ATSC. */

/*! @brief Read current value of the ASRC_ASRCTR_ATSC field. */
#define BR_ASRC_ASRCTR_ATSC(x) (HW_ASRC_ASRCTR(x).B.ATSC)

/*! @brief Format value for bitfield ASRC_ASRCTR_ATSC. */
#define BF_ASRC_ASRCTR_ATSC(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCTR_ATSC) & BM_ASRC_ASRCTR_ATSC)

/*! @brief Set the ATSC field to a new value. */
#define BW_ASRC_ASRCTR_ATSC(x, v) (HW_ASRC_ASRCTR_WR(x, (HW_ASRC_ASRCTR_RD(x) & ~BM_ASRC_ASRCTR_ATSC) | BF_ASRC_ASRCTR_ATSC(v)))
/*@}*/

/*******************************************************************************
 * HW_ASRC_ASRIER - ASRC Interrupt Enable Register
 ******************************************************************************/

/*!
 * @brief HW_ASRC_ASRIER - ASRC Interrupt Enable Register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_asrc_asrier
{
    uint32_t U;
    struct _hw_asrc_asrier_bitfields
    {
        uint32_t ADIEA : 1;            /*!< [0]  */
        uint32_t ADIEB : 1;            /*!< [1]  */
        uint32_t ADIEC : 1;            /*!< [2]  */
        uint32_t ADOEA : 1;            /*!< [3]  */
        uint32_t ADOEB : 1;            /*!< [4]  */
        uint32_t ADOEC : 1;            /*!< [5]  */
        uint32_t AOLIE : 1;            /*!< [6]  */
        uint32_t AFPWE : 1;            /*!< [7]  */
        uint32_t RESERVED0 : 24;       /*!< [31:8] This is a 24-bit register the
                                        * upper byte is unimplemented. */
    } B;
} hw_asrc_asrier_t;

/*!
 * @name Constants and macros for entire ASRC_ASRIER register
 */
/*@{*/
#define HW_ASRC_ASRIER_ADDR(x)   ((uintptr_t)(x) + 0x4U)

#define HW_ASRC_ASRIER(x)        (*(__IO hw_asrc_asrier_t *) HW_ASRC_ASRIER_ADDR(x))
#define HW_ASRC_ASRIER_RD(x)     (HW_ASRC_ASRIER(x).U)
#define HW_ASRC_ASRIER_WR(x, v)  (HW_ASRC_ASRIER(x).U = (v))
#define HW_ASRC_ASRIER_SET(x, v) (HW_ASRC_ASRIER_WR(x, HW_ASRC_ASRIER_RD(x) |  (v)))
#define HW_ASRC_ASRIER_CLR(x, v) (HW_ASRC_ASRIER_WR(x, HW_ASRC_ASRIER_RD(x) & ~(v)))
#define HW_ASRC_ASRIER_TOG(x, v) (HW_ASRC_ASRIER_WR(x, HW_ASRC_ASRIER_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ASRC_ASRIER bitfields
 */

/*!
 * @name Register ASRC_ASRIER, field ADIEA[0] (RW)
 *
 * Data Input A Interrupt Enable Enables the data input A Interrupt.
 *
 * Values:
 * - 1 - interrupt enabled
 * - 0 - interrupt disabled
 */
/*@{*/
#define BP_ASRC_ASRIER_ADIEA (0U)          /*!< Bit position for ASRC_ASRIER_ADIEA. */
#define BM_ASRC_ASRIER_ADIEA (0x00000001U) /*!< Bit mask for ASRC_ASRIER_ADIEA. */
#define BS_ASRC_ASRIER_ADIEA (1U)          /*!< Bit field size in bits for ASRC_ASRIER_ADIEA. */

/*! @brief Read current value of the ASRC_ASRIER_ADIEA field. */
#define BR_ASRC_ASRIER_ADIEA(x) (HW_ASRC_ASRIER(x).B.ADIEA)

/*! @brief Format value for bitfield ASRC_ASRIER_ADIEA. */
#define BF_ASRC_ASRIER_ADIEA(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRIER_ADIEA) & BM_ASRC_ASRIER_ADIEA)

/*! @brief Set the ADIEA field to a new value. */
#define BW_ASRC_ASRIER_ADIEA(x, v) (HW_ASRC_ASRIER_WR(x, (HW_ASRC_ASRIER_RD(x) & ~BM_ASRC_ASRIER_ADIEA) | BF_ASRC_ASRIER_ADIEA(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRIER, field ADIEB[1] (RW)
 *
 * Data Input B Interrupt Enable Enables the data input B interrupt.
 *
 * Values:
 * - 1 - interrupt enabled
 * - 0 - interrupt disabled
 */
/*@{*/
#define BP_ASRC_ASRIER_ADIEB (1U)          /*!< Bit position for ASRC_ASRIER_ADIEB. */
#define BM_ASRC_ASRIER_ADIEB (0x00000002U) /*!< Bit mask for ASRC_ASRIER_ADIEB. */
#define BS_ASRC_ASRIER_ADIEB (1U)          /*!< Bit field size in bits for ASRC_ASRIER_ADIEB. */

/*! @brief Read current value of the ASRC_ASRIER_ADIEB field. */
#define BR_ASRC_ASRIER_ADIEB(x) (HW_ASRC_ASRIER(x).B.ADIEB)

/*! @brief Format value for bitfield ASRC_ASRIER_ADIEB. */
#define BF_ASRC_ASRIER_ADIEB(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRIER_ADIEB) & BM_ASRC_ASRIER_ADIEB)

/*! @brief Set the ADIEB field to a new value. */
#define BW_ASRC_ASRIER_ADIEB(x, v) (HW_ASRC_ASRIER_WR(x, (HW_ASRC_ASRIER_RD(x) & ~BM_ASRC_ASRIER_ADIEB) | BF_ASRC_ASRIER_ADIEB(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRIER, field ADIEC[2] (RW)
 *
 * Data Input C Interrupt Enable Enables the data input C interrupt.
 *
 * Values:
 * - 1 - interrupt enabled
 * - 0 - interrupt disabled
 */
/*@{*/
#define BP_ASRC_ASRIER_ADIEC (2U)          /*!< Bit position for ASRC_ASRIER_ADIEC. */
#define BM_ASRC_ASRIER_ADIEC (0x00000004U) /*!< Bit mask for ASRC_ASRIER_ADIEC. */
#define BS_ASRC_ASRIER_ADIEC (1U)          /*!< Bit field size in bits for ASRC_ASRIER_ADIEC. */

/*! @brief Read current value of the ASRC_ASRIER_ADIEC field. */
#define BR_ASRC_ASRIER_ADIEC(x) (HW_ASRC_ASRIER(x).B.ADIEC)

/*! @brief Format value for bitfield ASRC_ASRIER_ADIEC. */
#define BF_ASRC_ASRIER_ADIEC(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRIER_ADIEC) & BM_ASRC_ASRIER_ADIEC)

/*! @brief Set the ADIEC field to a new value. */
#define BW_ASRC_ASRIER_ADIEC(x, v) (HW_ASRC_ASRIER_WR(x, (HW_ASRC_ASRIER_RD(x) & ~BM_ASRC_ASRIER_ADIEC) | BF_ASRC_ASRIER_ADIEC(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRIER, field ADOEA[3] (RW)
 *
 * Data Output A Interrupt Enable Enables the data output A interrupt.
 *
 * Values:
 * - 1 - interrupt enabled
 * - 0 - interrupt disabled
 */
/*@{*/
#define BP_ASRC_ASRIER_ADOEA (3U)          /*!< Bit position for ASRC_ASRIER_ADOEA. */
#define BM_ASRC_ASRIER_ADOEA (0x00000008U) /*!< Bit mask for ASRC_ASRIER_ADOEA. */
#define BS_ASRC_ASRIER_ADOEA (1U)          /*!< Bit field size in bits for ASRC_ASRIER_ADOEA. */

/*! @brief Read current value of the ASRC_ASRIER_ADOEA field. */
#define BR_ASRC_ASRIER_ADOEA(x) (HW_ASRC_ASRIER(x).B.ADOEA)

/*! @brief Format value for bitfield ASRC_ASRIER_ADOEA. */
#define BF_ASRC_ASRIER_ADOEA(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRIER_ADOEA) & BM_ASRC_ASRIER_ADOEA)

/*! @brief Set the ADOEA field to a new value. */
#define BW_ASRC_ASRIER_ADOEA(x, v) (HW_ASRC_ASRIER_WR(x, (HW_ASRC_ASRIER_RD(x) & ~BM_ASRC_ASRIER_ADOEA) | BF_ASRC_ASRIER_ADOEA(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRIER, field ADOEB[4] (RW)
 *
 * Data Output B Interrupt Enable Enables the data output B interrupt.
 *
 * Values:
 * - 1 - interrupt enabled
 * - 0 - interrupt disabled
 */
/*@{*/
#define BP_ASRC_ASRIER_ADOEB (4U)          /*!< Bit position for ASRC_ASRIER_ADOEB. */
#define BM_ASRC_ASRIER_ADOEB (0x00000010U) /*!< Bit mask for ASRC_ASRIER_ADOEB. */
#define BS_ASRC_ASRIER_ADOEB (1U)          /*!< Bit field size in bits for ASRC_ASRIER_ADOEB. */

/*! @brief Read current value of the ASRC_ASRIER_ADOEB field. */
#define BR_ASRC_ASRIER_ADOEB(x) (HW_ASRC_ASRIER(x).B.ADOEB)

/*! @brief Format value for bitfield ASRC_ASRIER_ADOEB. */
#define BF_ASRC_ASRIER_ADOEB(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRIER_ADOEB) & BM_ASRC_ASRIER_ADOEB)

/*! @brief Set the ADOEB field to a new value. */
#define BW_ASRC_ASRIER_ADOEB(x, v) (HW_ASRC_ASRIER_WR(x, (HW_ASRC_ASRIER_RD(x) & ~BM_ASRC_ASRIER_ADOEB) | BF_ASRC_ASRIER_ADOEB(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRIER, field ADOEC[5] (RW)
 *
 * Data Output C Interrupt Enable Enables the data output C interrupt.
 *
 * Values:
 * - 1 - interrupt enabled
 * - 0 - interrupt disabled
 */
/*@{*/
#define BP_ASRC_ASRIER_ADOEC (5U)          /*!< Bit position for ASRC_ASRIER_ADOEC. */
#define BM_ASRC_ASRIER_ADOEC (0x00000020U) /*!< Bit mask for ASRC_ASRIER_ADOEC. */
#define BS_ASRC_ASRIER_ADOEC (1U)          /*!< Bit field size in bits for ASRC_ASRIER_ADOEC. */

/*! @brief Read current value of the ASRC_ASRIER_ADOEC field. */
#define BR_ASRC_ASRIER_ADOEC(x) (HW_ASRC_ASRIER(x).B.ADOEC)

/*! @brief Format value for bitfield ASRC_ASRIER_ADOEC. */
#define BF_ASRC_ASRIER_ADOEC(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRIER_ADOEC) & BM_ASRC_ASRIER_ADOEC)

/*! @brief Set the ADOEC field to a new value. */
#define BW_ASRC_ASRIER_ADOEC(x, v) (HW_ASRC_ASRIER_WR(x, (HW_ASRC_ASRIER_RD(x) & ~BM_ASRC_ASRIER_ADOEC) | BF_ASRC_ASRIER_ADOEC(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRIER, field AOLIE[6] (RW)
 *
 * Overload Interrupt Enable Enables the overload interrupt.
 *
 * Values:
 * - 1 - interrupt enabled
 * - 0 - interrupt disabled
 */
/*@{*/
#define BP_ASRC_ASRIER_AOLIE (6U)          /*!< Bit position for ASRC_ASRIER_AOLIE. */
#define BM_ASRC_ASRIER_AOLIE (0x00000040U) /*!< Bit mask for ASRC_ASRIER_AOLIE. */
#define BS_ASRC_ASRIER_AOLIE (1U)          /*!< Bit field size in bits for ASRC_ASRIER_AOLIE. */

/*! @brief Read current value of the ASRC_ASRIER_AOLIE field. */
#define BR_ASRC_ASRIER_AOLIE(x) (HW_ASRC_ASRIER(x).B.AOLIE)

/*! @brief Format value for bitfield ASRC_ASRIER_AOLIE. */
#define BF_ASRC_ASRIER_AOLIE(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRIER_AOLIE) & BM_ASRC_ASRIER_AOLIE)

/*! @brief Set the AOLIE field to a new value. */
#define BW_ASRC_ASRIER_AOLIE(x, v) (HW_ASRC_ASRIER_WR(x, (HW_ASRC_ASRIER_RD(x) & ~BM_ASRC_ASRIER_AOLIE) | BF_ASRC_ASRIER_AOLIE(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRIER, field AFPWE[7] (RW)
 *
 * FP in Wait State Interrupt Enable Enables the FP in wait state interrupt.
 *
 * Values:
 * - 1 - interrupt enabled
 * - 0 - interrupt disabled
 */
/*@{*/
#define BP_ASRC_ASRIER_AFPWE (7U)          /*!< Bit position for ASRC_ASRIER_AFPWE. */
#define BM_ASRC_ASRIER_AFPWE (0x00000080U) /*!< Bit mask for ASRC_ASRIER_AFPWE. */
#define BS_ASRC_ASRIER_AFPWE (1U)          /*!< Bit field size in bits for ASRC_ASRIER_AFPWE. */

/*! @brief Read current value of the ASRC_ASRIER_AFPWE field. */
#define BR_ASRC_ASRIER_AFPWE(x) (HW_ASRC_ASRIER(x).B.AFPWE)

/*! @brief Format value for bitfield ASRC_ASRIER_AFPWE. */
#define BF_ASRC_ASRIER_AFPWE(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRIER_AFPWE) & BM_ASRC_ASRIER_AFPWE)

/*! @brief Set the AFPWE field to a new value. */
#define BW_ASRC_ASRIER_AFPWE(x, v) (HW_ASRC_ASRIER_WR(x, (HW_ASRC_ASRIER_RD(x) & ~BM_ASRC_ASRIER_AFPWE) | BF_ASRC_ASRIER_AFPWE(v)))
/*@}*/

/*******************************************************************************
 * HW_ASRC_ASRCNCR - ASRC Channel Number Configuration Register
 ******************************************************************************/

/*!
 * @brief HW_ASRC_ASRCNCR - ASRC Channel Number Configuration Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The ASRC channel number configuration register (ASRCNCR) is a 24-bit
 * read/write register that sets the number of channels used by each ASRC conversion
 * pair. There are 10 channels available for distribution among 3 conversion pairs,
 * they are ordered as 0,1,...,9. The bottom [0, ANCA-1] channels are used for
 * pair A, the top [10-ANCC, 9] channels are used for pair C, and the [ANCA,
 * ANCA+ANCB-1] channels are allocated for pair B. In case that ANCA=0, then the [0,
 * ANCB-1] channels are assigned for pair B.
 */
typedef union _hw_asrc_asrcncr
{
    uint32_t U;
    struct _hw_asrc_asrcncr_bitfields
    {
        uint32_t ANCA : 4;             /*!< [3:0]  */
        uint32_t ANCB : 4;             /*!< [7:4]  */
        uint32_t ANCC : 4;             /*!< [11:8]  */
        uint32_t RESERVED0 : 20;       /*!< [31:12] This is a 24-bit register the
                                        * upper byte is unimplemented. */
    } B;
} hw_asrc_asrcncr_t;

/*!
 * @name Constants and macros for entire ASRC_ASRCNCR register
 */
/*@{*/
#define HW_ASRC_ASRCNCR_ADDR(x)  ((uintptr_t)(x) + 0xCU)

#define HW_ASRC_ASRCNCR(x)       (*(__IO hw_asrc_asrcncr_t *) HW_ASRC_ASRCNCR_ADDR(x))
#define HW_ASRC_ASRCNCR_RD(x)    (HW_ASRC_ASRCNCR(x).U)
#define HW_ASRC_ASRCNCR_WR(x, v) (HW_ASRC_ASRCNCR(x).U = (v))
#define HW_ASRC_ASRCNCR_SET(x, v) (HW_ASRC_ASRCNCR_WR(x, HW_ASRC_ASRCNCR_RD(x) |  (v)))
#define HW_ASRC_ASRCNCR_CLR(x, v) (HW_ASRC_ASRCNCR_WR(x, HW_ASRC_ASRCNCR_RD(x) & ~(v)))
#define HW_ASRC_ASRCNCR_TOG(x, v) (HW_ASRC_ASRCNCR_WR(x, HW_ASRC_ASRCNCR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ASRC_ASRCNCR bitfields
 */

/*!
 * @name Register ASRC_ASRCNCR, field ANCA[3:0] (RW)
 *
 * Number of A Channels
 *
 * Values:
 * - 0000 - 0 channels in A (Pair A is disabled)
 * - 0001 - 1 channel in A
 * - 0010 - 2 channels in A
 * - 0011 - 3 channels in A
 * - 0100 - 4 channels in A
 * - 0101 - 5 channels in A
 * - 0110 - 6 channels in A
 * - 0111 - 7 channels in A
 * - 1000 - 8 channels in A
 * - 1001 - 9 channels in A
 * - 1010 - 10 channels in A
 */
/*@{*/
#define BP_ASRC_ASRCNCR_ANCA (0U)          /*!< Bit position for ASRC_ASRCNCR_ANCA. */
#define BM_ASRC_ASRCNCR_ANCA (0x0000000FU) /*!< Bit mask for ASRC_ASRCNCR_ANCA. */
#define BS_ASRC_ASRCNCR_ANCA (4U)          /*!< Bit field size in bits for ASRC_ASRCNCR_ANCA. */

/*! @brief Read current value of the ASRC_ASRCNCR_ANCA field. */
#define BR_ASRC_ASRCNCR_ANCA(x) (HW_ASRC_ASRCNCR(x).B.ANCA)

/*! @brief Format value for bitfield ASRC_ASRCNCR_ANCA. */
#define BF_ASRC_ASRCNCR_ANCA(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCNCR_ANCA) & BM_ASRC_ASRCNCR_ANCA)

/*! @brief Set the ANCA field to a new value. */
#define BW_ASRC_ASRCNCR_ANCA(x, v) (HW_ASRC_ASRCNCR_WR(x, (HW_ASRC_ASRCNCR_RD(x) & ~BM_ASRC_ASRCNCR_ANCA) | BF_ASRC_ASRCNCR_ANCA(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCNCR, field ANCB[7:4] (RW)
 *
 * Number of B Channels
 *
 * Values:
 * - 0000 - 0 channels in B (Pair B is disabled)
 * - 0001 - 1 channel in B
 * - 0010 - 2 channels in B
 * - 0011 - 3 channels in B
 * - 0100 - 4 channels in B
 * - 0101 - 5 channels in B
 * - 0110 - 6 channels in B
 * - 0111 - 7 channels in B
 * - 1000 - 8 channels in B
 * - 1001 - 9 channels in B
 * - 1010 - 10 channels in B
 */
/*@{*/
#define BP_ASRC_ASRCNCR_ANCB (4U)          /*!< Bit position for ASRC_ASRCNCR_ANCB. */
#define BM_ASRC_ASRCNCR_ANCB (0x000000F0U) /*!< Bit mask for ASRC_ASRCNCR_ANCB. */
#define BS_ASRC_ASRCNCR_ANCB (4U)          /*!< Bit field size in bits for ASRC_ASRCNCR_ANCB. */

/*! @brief Read current value of the ASRC_ASRCNCR_ANCB field. */
#define BR_ASRC_ASRCNCR_ANCB(x) (HW_ASRC_ASRCNCR(x).B.ANCB)

/*! @brief Format value for bitfield ASRC_ASRCNCR_ANCB. */
#define BF_ASRC_ASRCNCR_ANCB(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCNCR_ANCB) & BM_ASRC_ASRCNCR_ANCB)

/*! @brief Set the ANCB field to a new value. */
#define BW_ASRC_ASRCNCR_ANCB(x, v) (HW_ASRC_ASRCNCR_WR(x, (HW_ASRC_ASRCNCR_RD(x) & ~BM_ASRC_ASRCNCR_ANCB) | BF_ASRC_ASRCNCR_ANCB(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCNCR, field ANCC[11:8] (RW)
 *
 * Number of C ChannelsANCC+ANCB+ANCA<=10. Hardware is not checking the
 * constraint. Programmer should take the responsibility to ensure the constraint is
 * satisfied.
 *
 * Values:
 * - 0000 - 0 channels in C (Pair C is disabled)
 * - 0001 - 1 channel in C
 * - 0010 - 2 channels in C
 * - 0011 - 3 channels in C
 * - 0100 - 4 channels in C
 * - 0101 - 5 channels in C
 * - 0110 - 6 channels in C
 * - 0111 - 7 channels in C
 * - 1000 - 8 channels in C
 * - 1001 - 9 channels in C
 * - 1010 - 10 channels in C
 */
/*@{*/
#define BP_ASRC_ASRCNCR_ANCC (8U)          /*!< Bit position for ASRC_ASRCNCR_ANCC. */
#define BM_ASRC_ASRCNCR_ANCC (0x00000F00U) /*!< Bit mask for ASRC_ASRCNCR_ANCC. */
#define BS_ASRC_ASRCNCR_ANCC (4U)          /*!< Bit field size in bits for ASRC_ASRCNCR_ANCC. */

/*! @brief Read current value of the ASRC_ASRCNCR_ANCC field. */
#define BR_ASRC_ASRCNCR_ANCC(x) (HW_ASRC_ASRCNCR(x).B.ANCC)

/*! @brief Format value for bitfield ASRC_ASRCNCR_ANCC. */
#define BF_ASRC_ASRCNCR_ANCC(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCNCR_ANCC) & BM_ASRC_ASRCNCR_ANCC)

/*! @brief Set the ANCC field to a new value. */
#define BW_ASRC_ASRCNCR_ANCC(x, v) (HW_ASRC_ASRCNCR_WR(x, (HW_ASRC_ASRCNCR_RD(x) & ~BM_ASRC_ASRCNCR_ANCC) | BF_ASRC_ASRCNCR_ANCC(v)))
/*@}*/

/*******************************************************************************
 * HW_ASRC_ASRCFG - ASRC Filter Configuration Status Register
 ******************************************************************************/

/*!
 * @brief HW_ASRC_ASRCFG - ASRC Filter Configuration Status Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The ASRC configuration status register (ASRCFG) is a 24-bit read/write
 * register that sets and/or automatically senses the ASRC operations.
 */
typedef union _hw_asrc_asrcfg
{
    uint32_t U;
    struct _hw_asrc_asrcfg_bitfields
    {
        uint32_t RESERVED0 : 6;        /*!< [5:0]  */
        uint32_t PREMODA : 2;          /*!< [7:6]  */
        uint32_t POSTMODA : 2;         /*!< [9:8]  */
        uint32_t PREMODB : 2;          /*!< [11:10]  */
        uint32_t POSTMODB : 2;         /*!< [13:12]  */
        uint32_t PREMODC : 2;          /*!< [15:14]  */
        uint32_t POSTMODC : 2;         /*!< [17:16]  */
        uint32_t NDPRA : 1;            /*!< [18]  */
        uint32_t NDPRB : 1;            /*!< [19]  */
        uint32_t NDPRC : 1;            /*!< [20]  */
        uint32_t INIRQA : 1;           /*!< [21]  */
        uint32_t INIRQB : 1;           /*!< [22]  */
        uint32_t INIRQC : 1;           /*!< [23]  */
        uint32_t RESERVED1 : 8;        /*!< [31:24] This is a 24-bit register the
                                        * upper byte is unimplemented. */
    } B;
} hw_asrc_asrcfg_t;

/*!
 * @name Constants and macros for entire ASRC_ASRCFG register
 */
/*@{*/
#define HW_ASRC_ASRCFG_ADDR(x)   ((uintptr_t)(x) + 0x10U)

#define HW_ASRC_ASRCFG(x)        (*(__IO hw_asrc_asrcfg_t *) HW_ASRC_ASRCFG_ADDR(x))
#define HW_ASRC_ASRCFG_RD(x)     (HW_ASRC_ASRCFG(x).U)
#define HW_ASRC_ASRCFG_WR(x, v)  (HW_ASRC_ASRCFG(x).U = (v))
#define HW_ASRC_ASRCFG_SET(x, v) (HW_ASRC_ASRCFG_WR(x, HW_ASRC_ASRCFG_RD(x) |  (v)))
#define HW_ASRC_ASRCFG_CLR(x, v) (HW_ASRC_ASRCFG_WR(x, HW_ASRC_ASRCFG_RD(x) & ~(v)))
#define HW_ASRC_ASRCFG_TOG(x, v) (HW_ASRC_ASRCFG_WR(x, HW_ASRC_ASRCFG_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ASRC_ASRCFG bitfields
 */

/*!
 * @name Register ASRC_ASRCFG, field PREMODA[7:6] (RW)
 *
 * Pre-Processing Configuration for Conversion Pair A These bits will be
 * read/write by user if ASRCTR:ATSA=0, and can also be automatically updated by the
 * ASRC internal logic if ASRCTR:ATSA=1 (see ASRC Misc Control Register 1 for Pair
 * CASRC Control Register ). These bits set the selection of the pre-processing
 * configuration.
 *
 * Values:
 * - 00 - Select Upsampling-by-2 as defined in Signal processing flowBy flowing
 *     through different processing branches and different setups of the
 *     pre-filter, this ASRC scheme can be used to handle different rate conversion
 *     requirements.
 * - 01 - Select Direct-Connection as defined in Signal processing flowBy
 *     flowing through different processing branches and different setups of the
 *     pre-filter, this ASRC scheme can be used to handle different rate conversion
 *     requirements.
 * - 10 - Select Downsampling-by-2 as defined in Signal processing flowBy
 *     flowing through different processing branches and different setups of the
 *     pre-filter, this ASRC scheme can be used to handle different rate conversion
 *     requirements.
 * - 11 - Select passthrough mode. In this case, POSTMODA[1-0] have no use.
 */
/*@{*/
#define BP_ASRC_ASRCFG_PREMODA (6U)        /*!< Bit position for ASRC_ASRCFG_PREMODA. */
#define BM_ASRC_ASRCFG_PREMODA (0x000000C0U) /*!< Bit mask for ASRC_ASRCFG_PREMODA. */
#define BS_ASRC_ASRCFG_PREMODA (2U)        /*!< Bit field size in bits for ASRC_ASRCFG_PREMODA. */

/*! @brief Read current value of the ASRC_ASRCFG_PREMODA field. */
#define BR_ASRC_ASRCFG_PREMODA(x) (HW_ASRC_ASRCFG(x).B.PREMODA)

/*! @brief Format value for bitfield ASRC_ASRCFG_PREMODA. */
#define BF_ASRC_ASRCFG_PREMODA(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCFG_PREMODA) & BM_ASRC_ASRCFG_PREMODA)

/*! @brief Set the PREMODA field to a new value. */
#define BW_ASRC_ASRCFG_PREMODA(x, v) (HW_ASRC_ASRCFG_WR(x, (HW_ASRC_ASRCFG_RD(x) & ~BM_ASRC_ASRCFG_PREMODA) | BF_ASRC_ASRCFG_PREMODA(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCFG, field POSTMODA[9:8] (RW)
 *
 * Post-Processing Configuration for Conversion Pair A These bits will be
 * read/write by user if ASRCTR:ATSA=0, and can also be automatically updated by the
 * ASRC internal logic if ASRCTR:ATSA=1 (see ASRC Misc Control Register 1 for Pair
 * CASRC Control Register ). These bits set the selection of the post-processing
 * configuration.
 *
 * Values:
 * - 00 - Select Upsampling-by-2 as defined in Signal processing flowBy flowing
 *     through different processing branches and different setups of the
 *     pre-filter, this ASRC scheme can be used to handle different rate conversion
 *     requirements.
 * - 01 - Select Direct-Connection as defined in Signal processing flowBy
 *     flowing through different processing branches and different setups of the
 *     pre-filter, this ASRC scheme can be used to handle different rate conversion
 *     requirements.
 * - 10 - Select Downsampling-by-2 as defined in Signal processing flowBy
 *     flowing through different processing branches and different setups of the
 *     pre-filter, this ASRC scheme can be used to handle different rate conversion
 *     requirements.
 */
/*@{*/
#define BP_ASRC_ASRCFG_POSTMODA (8U)       /*!< Bit position for ASRC_ASRCFG_POSTMODA. */
#define BM_ASRC_ASRCFG_POSTMODA (0x00000300U) /*!< Bit mask for ASRC_ASRCFG_POSTMODA. */
#define BS_ASRC_ASRCFG_POSTMODA (2U)       /*!< Bit field size in bits for ASRC_ASRCFG_POSTMODA. */

/*! @brief Read current value of the ASRC_ASRCFG_POSTMODA field. */
#define BR_ASRC_ASRCFG_POSTMODA(x) (HW_ASRC_ASRCFG(x).B.POSTMODA)

/*! @brief Format value for bitfield ASRC_ASRCFG_POSTMODA. */
#define BF_ASRC_ASRCFG_POSTMODA(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCFG_POSTMODA) & BM_ASRC_ASRCFG_POSTMODA)

/*! @brief Set the POSTMODA field to a new value. */
#define BW_ASRC_ASRCFG_POSTMODA(x, v) (HW_ASRC_ASRCFG_WR(x, (HW_ASRC_ASRCFG_RD(x) & ~BM_ASRC_ASRCFG_POSTMODA) | BF_ASRC_ASRCFG_POSTMODA(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCFG, field PREMODB[11:10] (RW)
 *
 * Pre-Processing Configuration for Conversion Pair B These bits will be
 * read/write by user if ASRCTR:ATSB=0, and can also be automatically updated by the
 * ASRC internal logic if ASRCTR:ATSB=1 (see ASRC Misc Control Register 1 for Pair
 * CASRC Control Register ). These bits set the selection of the pre-processing
 * configuration.
 *
 * Values:
 * - 00 - Select Upsampling-by-2 as defined in Signal processing flowBy flowing
 *     through different processing branches and different setups of the
 *     pre-filter, this ASRC scheme can be used to handle different rate conversion
 *     requirements.
 * - 01 - Select Direct-Connection as defined in Signal processing flowBy
 *     flowing through different processing branches and different setups of the
 *     pre-filter, this ASRC scheme can be used to handle different rate conversion
 *     requirements.
 * - 10 - Select Downsampling-by-2 as defined in Signal processing flowBy
 *     flowing through different processing branches and different setups of the
 *     pre-filter, this ASRC scheme can be used to handle different rate conversion
 *     requirements.
 * - 11 - Select passthrough mode. In this case, POSTMODB[1-0] have no use.
 */
/*@{*/
#define BP_ASRC_ASRCFG_PREMODB (10U)       /*!< Bit position for ASRC_ASRCFG_PREMODB. */
#define BM_ASRC_ASRCFG_PREMODB (0x00000C00U) /*!< Bit mask for ASRC_ASRCFG_PREMODB. */
#define BS_ASRC_ASRCFG_PREMODB (2U)        /*!< Bit field size in bits for ASRC_ASRCFG_PREMODB. */

/*! @brief Read current value of the ASRC_ASRCFG_PREMODB field. */
#define BR_ASRC_ASRCFG_PREMODB(x) (HW_ASRC_ASRCFG(x).B.PREMODB)

/*! @brief Format value for bitfield ASRC_ASRCFG_PREMODB. */
#define BF_ASRC_ASRCFG_PREMODB(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCFG_PREMODB) & BM_ASRC_ASRCFG_PREMODB)

/*! @brief Set the PREMODB field to a new value. */
#define BW_ASRC_ASRCFG_PREMODB(x, v) (HW_ASRC_ASRCFG_WR(x, (HW_ASRC_ASRCFG_RD(x) & ~BM_ASRC_ASRCFG_PREMODB) | BF_ASRC_ASRCFG_PREMODB(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCFG, field POSTMODB[13:12] (RW)
 *
 * Post-Processing Configuration for Conversion Pair B These bits will be
 * read/write by user if ASRCTR:ATSB=0, and can also be automatically updated by the
 * ASRC internal logic if ASRCTR:ATSB=1 (see ASRC Misc Control Register 1 for Pair
 * CASRC Control Register ). These bits set the selection of the post-processing
 * configuration.
 *
 * Values:
 * - 00 - Select Upsampling-by-2 as defined in Signal processing flowBy flowing
 *     through different processing branches and different setups of the
 *     pre-filter, this ASRC scheme can be used to handle different rate conversion
 *     requirements.
 * - 01 - Select Direct-Connection as defined in Signal processing flowBy
 *     flowing through different processing branches and different setups of the
 *     pre-filter, this ASRC scheme can be used to handle different rate conversion
 *     requirements.
 * - 10 - Select Downsampling-by-2 as defined in Signal processing flowBy
 *     flowing through different processing branches and different setups of the
 *     pre-filter, this ASRC scheme can be used to handle different rate conversion
 *     requirements.
 */
/*@{*/
#define BP_ASRC_ASRCFG_POSTMODB (12U)      /*!< Bit position for ASRC_ASRCFG_POSTMODB. */
#define BM_ASRC_ASRCFG_POSTMODB (0x00003000U) /*!< Bit mask for ASRC_ASRCFG_POSTMODB. */
#define BS_ASRC_ASRCFG_POSTMODB (2U)       /*!< Bit field size in bits for ASRC_ASRCFG_POSTMODB. */

/*! @brief Read current value of the ASRC_ASRCFG_POSTMODB field. */
#define BR_ASRC_ASRCFG_POSTMODB(x) (HW_ASRC_ASRCFG(x).B.POSTMODB)

/*! @brief Format value for bitfield ASRC_ASRCFG_POSTMODB. */
#define BF_ASRC_ASRCFG_POSTMODB(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCFG_POSTMODB) & BM_ASRC_ASRCFG_POSTMODB)

/*! @brief Set the POSTMODB field to a new value. */
#define BW_ASRC_ASRCFG_POSTMODB(x, v) (HW_ASRC_ASRCFG_WR(x, (HW_ASRC_ASRCFG_RD(x) & ~BM_ASRC_ASRCFG_POSTMODB) | BF_ASRC_ASRCFG_POSTMODB(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCFG, field PREMODC[15:14] (RW)
 *
 * Pre-Processing Configuration for Conversion Pair C These bits will be
 * read/write by user if ASRCTR:ATSC=0, and can also be automatically updated by the
 * ASRC internal logic if ASRCTR:ATSC=1 (see ASRC Misc Control Register 1 for Pair
 * CASRC Control Register ). These bits set the selection of the pre-processing
 * configuration.
 *
 * Values:
 * - 00 - Select Upsampling-by-2 as defined in Signal processing flowBy flowing
 *     through different processing branches and different setups of the
 *     pre-filter, this ASRC scheme can be used to handle different rate conversion
 *     requirements.
 * - 01 - Select Direct-Connection as defined in Signal processing flowBy
 *     flowing through different processing branches and different setups of the
 *     pre-filter, this ASRC scheme can be used to handle different rate conversion
 *     requirements.
 * - 10 - Select Downsampling-by-2 as defined in Signal processing flowBy
 *     flowing through different processing branches and different setups of the
 *     pre-filter, this ASRC scheme can be used to handle different rate conversion
 *     requirements.
 * - 11 - Select passthrough mode. In this case, POSTMODC[1-0] have no use.
 */
/*@{*/
#define BP_ASRC_ASRCFG_PREMODC (14U)       /*!< Bit position for ASRC_ASRCFG_PREMODC. */
#define BM_ASRC_ASRCFG_PREMODC (0x0000C000U) /*!< Bit mask for ASRC_ASRCFG_PREMODC. */
#define BS_ASRC_ASRCFG_PREMODC (2U)        /*!< Bit field size in bits for ASRC_ASRCFG_PREMODC. */

/*! @brief Read current value of the ASRC_ASRCFG_PREMODC field. */
#define BR_ASRC_ASRCFG_PREMODC(x) (HW_ASRC_ASRCFG(x).B.PREMODC)

/*! @brief Format value for bitfield ASRC_ASRCFG_PREMODC. */
#define BF_ASRC_ASRCFG_PREMODC(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCFG_PREMODC) & BM_ASRC_ASRCFG_PREMODC)

/*! @brief Set the PREMODC field to a new value. */
#define BW_ASRC_ASRCFG_PREMODC(x, v) (HW_ASRC_ASRCFG_WR(x, (HW_ASRC_ASRCFG_RD(x) & ~BM_ASRC_ASRCFG_PREMODC) | BF_ASRC_ASRCFG_PREMODC(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCFG, field POSTMODC[17:16] (RW)
 *
 * Post-Processing Configuration for Conversion Pair C These bits will be
 * read/write by user if ASRCTR:ATSC=0, and can also be automatically updated by the
 * ASRC internal logic if ASRCTR:ATSC=1 (see ASRC Misc Control Register 1 for Pair
 * CASRC Control Register ). These bits set the selection of the post-processing
 * configuration.
 *
 * Values:
 * - 00 - Select Upsampling-by-2 as defined in Signal Processing Flow.
 * - 01 - Select Direct-Connection as defined in Signal Processing Flow.
 * - 10 - Select Downsampling-by-2 as defined in Signal Processing Flow.
 */
/*@{*/
#define BP_ASRC_ASRCFG_POSTMODC (16U)      /*!< Bit position for ASRC_ASRCFG_POSTMODC. */
#define BM_ASRC_ASRCFG_POSTMODC (0x00030000U) /*!< Bit mask for ASRC_ASRCFG_POSTMODC. */
#define BS_ASRC_ASRCFG_POSTMODC (2U)       /*!< Bit field size in bits for ASRC_ASRCFG_POSTMODC. */

/*! @brief Read current value of the ASRC_ASRCFG_POSTMODC field. */
#define BR_ASRC_ASRCFG_POSTMODC(x) (HW_ASRC_ASRCFG(x).B.POSTMODC)

/*! @brief Format value for bitfield ASRC_ASRCFG_POSTMODC. */
#define BF_ASRC_ASRCFG_POSTMODC(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCFG_POSTMODC) & BM_ASRC_ASRCFG_POSTMODC)

/*! @brief Set the POSTMODC field to a new value. */
#define BW_ASRC_ASRCFG_POSTMODC(x, v) (HW_ASRC_ASRCFG_WR(x, (HW_ASRC_ASRCFG_RD(x) & ~BM_ASRC_ASRCFG_POSTMODC) | BF_ASRC_ASRCFG_POSTMODC(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCFG, field NDPRA[18] (RW)
 *
 * Not Use Default Parameters for RAM-stored Parameters For Conversion Pair A
 *
 * Values:
 * - 0 - Use default parameters for RAM-stored parameters. Override any
 *     parameters already in RAM.
 * - 1 - Don't use default parameters for RAM-stored parameters. Use the
 *     parameters already stored in RAM.
 */
/*@{*/
#define BP_ASRC_ASRCFG_NDPRA (18U)         /*!< Bit position for ASRC_ASRCFG_NDPRA. */
#define BM_ASRC_ASRCFG_NDPRA (0x00040000U) /*!< Bit mask for ASRC_ASRCFG_NDPRA. */
#define BS_ASRC_ASRCFG_NDPRA (1U)          /*!< Bit field size in bits for ASRC_ASRCFG_NDPRA. */

/*! @brief Read current value of the ASRC_ASRCFG_NDPRA field. */
#define BR_ASRC_ASRCFG_NDPRA(x) (HW_ASRC_ASRCFG(x).B.NDPRA)

/*! @brief Format value for bitfield ASRC_ASRCFG_NDPRA. */
#define BF_ASRC_ASRCFG_NDPRA(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCFG_NDPRA) & BM_ASRC_ASRCFG_NDPRA)

/*! @brief Set the NDPRA field to a new value. */
#define BW_ASRC_ASRCFG_NDPRA(x, v) (HW_ASRC_ASRCFG_WR(x, (HW_ASRC_ASRCFG_RD(x) & ~BM_ASRC_ASRCFG_NDPRA) | BF_ASRC_ASRCFG_NDPRA(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCFG, field NDPRB[19] (RW)
 *
 * Not Use Default Parameters for RAM-stored Parameters For Conversion Pair B
 *
 * Values:
 * - 0 - Use default parameters for RAM-stored parameters. Override any
 *     parameters already in RAM.
 * - 1 - Don't use default parameters for RAM-stored parameter. Use the
 *     parameters already stored in RAM.
 */
/*@{*/
#define BP_ASRC_ASRCFG_NDPRB (19U)         /*!< Bit position for ASRC_ASRCFG_NDPRB. */
#define BM_ASRC_ASRCFG_NDPRB (0x00080000U) /*!< Bit mask for ASRC_ASRCFG_NDPRB. */
#define BS_ASRC_ASRCFG_NDPRB (1U)          /*!< Bit field size in bits for ASRC_ASRCFG_NDPRB. */

/*! @brief Read current value of the ASRC_ASRCFG_NDPRB field. */
#define BR_ASRC_ASRCFG_NDPRB(x) (HW_ASRC_ASRCFG(x).B.NDPRB)

/*! @brief Format value for bitfield ASRC_ASRCFG_NDPRB. */
#define BF_ASRC_ASRCFG_NDPRB(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCFG_NDPRB) & BM_ASRC_ASRCFG_NDPRB)

/*! @brief Set the NDPRB field to a new value. */
#define BW_ASRC_ASRCFG_NDPRB(x, v) (HW_ASRC_ASRCFG_WR(x, (HW_ASRC_ASRCFG_RD(x) & ~BM_ASRC_ASRCFG_NDPRB) | BF_ASRC_ASRCFG_NDPRB(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCFG, field NDPRC[20] (RW)
 *
 * Not Use Default Parameters for RAM-stored Parameters For Conversion Pair C
 *
 * Values:
 * - 0 - Use default parameters for RAM-stored parameters. Override any
 *     parameters already in RAM.
 * - 1 - Don't use default parameters for RAM-stored parameters. Use the
 *     parameters already stored in RAM.
 */
/*@{*/
#define BP_ASRC_ASRCFG_NDPRC (20U)         /*!< Bit position for ASRC_ASRCFG_NDPRC. */
#define BM_ASRC_ASRCFG_NDPRC (0x00100000U) /*!< Bit mask for ASRC_ASRCFG_NDPRC. */
#define BS_ASRC_ASRCFG_NDPRC (1U)          /*!< Bit field size in bits for ASRC_ASRCFG_NDPRC. */

/*! @brief Read current value of the ASRC_ASRCFG_NDPRC field. */
#define BR_ASRC_ASRCFG_NDPRC(x) (HW_ASRC_ASRCFG(x).B.NDPRC)

/*! @brief Format value for bitfield ASRC_ASRCFG_NDPRC. */
#define BF_ASRC_ASRCFG_NDPRC(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCFG_NDPRC) & BM_ASRC_ASRCFG_NDPRC)

/*! @brief Set the NDPRC field to a new value. */
#define BW_ASRC_ASRCFG_NDPRC(x, v) (HW_ASRC_ASRCFG_WR(x, (HW_ASRC_ASRCFG_RD(x) & ~BM_ASRC_ASRCFG_NDPRC) | BF_ASRC_ASRCFG_NDPRC(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCFG, field INIRQA[21] (RO)
 *
 * Initialization for Conversion Pair A is served When this bit is 1, it means
 * the initialization for conversion pair A is served. This bit is cleared by
 * disabling the ASRC conversion pair (ASRCTR:ASREA=0 or ASRCTR:ASRCEN=0).
 */
/*@{*/
#define BP_ASRC_ASRCFG_INIRQA (21U)        /*!< Bit position for ASRC_ASRCFG_INIRQA. */
#define BM_ASRC_ASRCFG_INIRQA (0x00200000U) /*!< Bit mask for ASRC_ASRCFG_INIRQA. */
#define BS_ASRC_ASRCFG_INIRQA (1U)         /*!< Bit field size in bits for ASRC_ASRCFG_INIRQA. */

/*! @brief Read current value of the ASRC_ASRCFG_INIRQA field. */
#define BR_ASRC_ASRCFG_INIRQA(x) (HW_ASRC_ASRCFG(x).B.INIRQA)
/*@}*/

/*!
 * @name Register ASRC_ASRCFG, field INIRQB[22] (RO)
 *
 * Initialization for Conversion Pair B is served When this bit is 1, it means
 * the initialization for conversion pair B is served. This bit is cleared by
 * disabling the ASRC conversion pair (ASRCTR:ASREB=0 or ASRCTR:ASRCEN=0).
 */
/*@{*/
#define BP_ASRC_ASRCFG_INIRQB (22U)        /*!< Bit position for ASRC_ASRCFG_INIRQB. */
#define BM_ASRC_ASRCFG_INIRQB (0x00400000U) /*!< Bit mask for ASRC_ASRCFG_INIRQB. */
#define BS_ASRC_ASRCFG_INIRQB (1U)         /*!< Bit field size in bits for ASRC_ASRCFG_INIRQB. */

/*! @brief Read current value of the ASRC_ASRCFG_INIRQB field. */
#define BR_ASRC_ASRCFG_INIRQB(x) (HW_ASRC_ASRCFG(x).B.INIRQB)
/*@}*/

/*!
 * @name Register ASRC_ASRCFG, field INIRQC[23] (RO)
 *
 * Initialization for Conversion Pair C is served When this bit is 1, it means
 * the initialization for conversion pair C is served. This bit is cleared by
 * disabling the ASRC conversion pair (ASRCTR:ASREC=0 or ASRCTR:ASRCEN=0).
 */
/*@{*/
#define BP_ASRC_ASRCFG_INIRQC (23U)        /*!< Bit position for ASRC_ASRCFG_INIRQC. */
#define BM_ASRC_ASRCFG_INIRQC (0x00800000U) /*!< Bit mask for ASRC_ASRCFG_INIRQC. */
#define BS_ASRC_ASRCFG_INIRQC (1U)         /*!< Bit field size in bits for ASRC_ASRCFG_INIRQC. */

/*! @brief Read current value of the ASRC_ASRCFG_INIRQC field. */
#define BR_ASRC_ASRCFG_INIRQC(x) (HW_ASRC_ASRCFG(x).B.INIRQC)
/*@}*/

/*******************************************************************************
 * HW_ASRC_ASRCSR - ASRC Clock Source Register
 ******************************************************************************/

/*!
 * @brief HW_ASRC_ASRCSR - ASRC Clock Source Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The ASRC clock source register (ASRCSR) is a 24-bit read/write register that
 * controls the sources of the input and output clocks of the ASRC. The clock
 * connections are shown in :
 */
typedef union _hw_asrc_asrcsr
{
    uint32_t U;
    struct _hw_asrc_asrcsr_bitfields
    {
        uint32_t AICSA : 4;            /*!< [3:0]  */
        uint32_t AICSB : 4;            /*!< [7:4]  */
        uint32_t AICSC : 4;            /*!< [11:8]  */
        uint32_t AOCSA : 4;            /*!< [15:12]  */
        uint32_t AOCSB : 4;            /*!< [19:16]  */
        uint32_t AOCSC : 4;            /*!< [23:20]  */
        uint32_t RESERVED0 : 8;        /*!< [31:24] This is a 24-bit register the
                                        * upper byte is unimplemented. */
    } B;
} hw_asrc_asrcsr_t;

/*!
 * @name Constants and macros for entire ASRC_ASRCSR register
 */
/*@{*/
#define HW_ASRC_ASRCSR_ADDR(x)   ((uintptr_t)(x) + 0x14U)

#define HW_ASRC_ASRCSR(x)        (*(__IO hw_asrc_asrcsr_t *) HW_ASRC_ASRCSR_ADDR(x))
#define HW_ASRC_ASRCSR_RD(x)     (HW_ASRC_ASRCSR(x).U)
#define HW_ASRC_ASRCSR_WR(x, v)  (HW_ASRC_ASRCSR(x).U = (v))
#define HW_ASRC_ASRCSR_SET(x, v) (HW_ASRC_ASRCSR_WR(x, HW_ASRC_ASRCSR_RD(x) |  (v)))
#define HW_ASRC_ASRCSR_CLR(x, v) (HW_ASRC_ASRCSR_WR(x, HW_ASRC_ASRCSR_RD(x) & ~(v)))
#define HW_ASRC_ASRCSR_TOG(x, v) (HW_ASRC_ASRCSR_WR(x, HW_ASRC_ASRCSR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ASRC_ASRCSR bitfields
 */

/*!
 * @name Register ASRC_ASRCSR, field AICSA[3:0] (RW)
 *
 * Input Clock Source A
 *
 * Values:
 * - 0000 - bit clock 0
 * - 0001 - bit clock 1
 * - 0010 - bit clock 2
 * - 0011 - bit clock 3
 * - 0100 - bit clock 4
 * - 0101 - bit clock 5
 * - 0110 - bit clock 6
 * - 0111 - bit clock 7
 * - 1000 - bit clock 8
 * - 1001 - bit clock 9
 * - 1010 - bit clock A
 * - 1011 - bit clock B
 * - 1100 - bit clock C
 * - 1101 - bit clock D
 * - 1110 - bit clock E
 * - 1111 - clock disabled, connected to zero
 */
/*@{*/
#define BP_ASRC_ASRCSR_AICSA (0U)          /*!< Bit position for ASRC_ASRCSR_AICSA. */
#define BM_ASRC_ASRCSR_AICSA (0x0000000FU) /*!< Bit mask for ASRC_ASRCSR_AICSA. */
#define BS_ASRC_ASRCSR_AICSA (4U)          /*!< Bit field size in bits for ASRC_ASRCSR_AICSA. */

/*! @brief Read current value of the ASRC_ASRCSR_AICSA field. */
#define BR_ASRC_ASRCSR_AICSA(x) (HW_ASRC_ASRCSR(x).B.AICSA)

/*! @brief Format value for bitfield ASRC_ASRCSR_AICSA. */
#define BF_ASRC_ASRCSR_AICSA(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCSR_AICSA) & BM_ASRC_ASRCSR_AICSA)

/*! @brief Set the AICSA field to a new value. */
#define BW_ASRC_ASRCSR_AICSA(x, v) (HW_ASRC_ASRCSR_WR(x, (HW_ASRC_ASRCSR_RD(x) & ~BM_ASRC_ASRCSR_AICSA) | BF_ASRC_ASRCSR_AICSA(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCSR, field AICSB[7:4] (RW)
 *
 * Input Clock Source B
 *
 * Values:
 * - 0000 - bit clock 0
 * - 0001 - bit clock 1
 * - 0010 - bit clock 2
 * - 0011 - bit clock 3
 * - 0100 - bit clock 4
 * - 0101 - bit clock 5
 * - 0110 - bit clock 6
 * - 0111 - bit clock 7
 * - 1000 - bit clock 8
 * - 1001 - bit clock 9
 * - 1010 - bit clock A
 * - 1011 - bit clock B
 * - 1100 - bit clock C
 * - 1101 - bit clock D
 * - 1110 - bit clock E
 * - 1111 - clock disabled, connected to zero
 */
/*@{*/
#define BP_ASRC_ASRCSR_AICSB (4U)          /*!< Bit position for ASRC_ASRCSR_AICSB. */
#define BM_ASRC_ASRCSR_AICSB (0x000000F0U) /*!< Bit mask for ASRC_ASRCSR_AICSB. */
#define BS_ASRC_ASRCSR_AICSB (4U)          /*!< Bit field size in bits for ASRC_ASRCSR_AICSB. */

/*! @brief Read current value of the ASRC_ASRCSR_AICSB field. */
#define BR_ASRC_ASRCSR_AICSB(x) (HW_ASRC_ASRCSR(x).B.AICSB)

/*! @brief Format value for bitfield ASRC_ASRCSR_AICSB. */
#define BF_ASRC_ASRCSR_AICSB(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCSR_AICSB) & BM_ASRC_ASRCSR_AICSB)

/*! @brief Set the AICSB field to a new value. */
#define BW_ASRC_ASRCSR_AICSB(x, v) (HW_ASRC_ASRCSR_WR(x, (HW_ASRC_ASRCSR_RD(x) & ~BM_ASRC_ASRCSR_AICSB) | BF_ASRC_ASRCSR_AICSB(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCSR, field AICSC[11:8] (RW)
 *
 * Input Clock Source C
 *
 * Values:
 * - 0000 - bit clock 0
 * - 0001 - bit clock 1
 * - 0010 - bit clock 2
 * - 0011 - bit clock 3
 * - 0100 - bit clock 4
 * - 0101 - bit clock 5
 * - 0110 - bit clock 6
 * - 0111 - bit clock 7
 * - 1000 - bit clock 8
 * - 1001 - bit clock 9
 * - 1010 - bit clock A
 * - 1011 - bit clock B
 * - 1100 - bit clock C
 * - 1101 - bit clock D
 * - 1110 - bit clock E
 * - 1111 - clock disabled, connected to zero
 */
/*@{*/
#define BP_ASRC_ASRCSR_AICSC (8U)          /*!< Bit position for ASRC_ASRCSR_AICSC. */
#define BM_ASRC_ASRCSR_AICSC (0x00000F00U) /*!< Bit mask for ASRC_ASRCSR_AICSC. */
#define BS_ASRC_ASRCSR_AICSC (4U)          /*!< Bit field size in bits for ASRC_ASRCSR_AICSC. */

/*! @brief Read current value of the ASRC_ASRCSR_AICSC field. */
#define BR_ASRC_ASRCSR_AICSC(x) (HW_ASRC_ASRCSR(x).B.AICSC)

/*! @brief Format value for bitfield ASRC_ASRCSR_AICSC. */
#define BF_ASRC_ASRCSR_AICSC(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCSR_AICSC) & BM_ASRC_ASRCSR_AICSC)

/*! @brief Set the AICSC field to a new value. */
#define BW_ASRC_ASRCSR_AICSC(x, v) (HW_ASRC_ASRCSR_WR(x, (HW_ASRC_ASRCSR_RD(x) & ~BM_ASRC_ASRCSR_AICSC) | BF_ASRC_ASRCSR_AICSC(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCSR, field AOCSA[15:12] (RW)
 *
 * Output Clock Source A
 *
 * Values:
 * - 0000 - bit clock 0
 * - 0001 - bit clock 1
 * - 0010 - bit clock 2
 * - 0011 - bit clock 3
 * - 0100 - bit clock 4
 * - 0101 - bit clock 5
 * - 0110 - bit clock 6
 * - 0111 - bit clock 7
 * - 1000 - bit clock 8
 * - 1001 - bit clock 9
 * - 1010 - bit clock A
 * - 1011 - bit clock B
 * - 1100 - bit clock C
 * - 1101 - bit clock D
 * - 1110 - bit clock E
 * - 1111 - clock disabled, connected to zero
 */
/*@{*/
#define BP_ASRC_ASRCSR_AOCSA (12U)         /*!< Bit position for ASRC_ASRCSR_AOCSA. */
#define BM_ASRC_ASRCSR_AOCSA (0x0000F000U) /*!< Bit mask for ASRC_ASRCSR_AOCSA. */
#define BS_ASRC_ASRCSR_AOCSA (4U)          /*!< Bit field size in bits for ASRC_ASRCSR_AOCSA. */

/*! @brief Read current value of the ASRC_ASRCSR_AOCSA field. */
#define BR_ASRC_ASRCSR_AOCSA(x) (HW_ASRC_ASRCSR(x).B.AOCSA)

/*! @brief Format value for bitfield ASRC_ASRCSR_AOCSA. */
#define BF_ASRC_ASRCSR_AOCSA(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCSR_AOCSA) & BM_ASRC_ASRCSR_AOCSA)

/*! @brief Set the AOCSA field to a new value. */
#define BW_ASRC_ASRCSR_AOCSA(x, v) (HW_ASRC_ASRCSR_WR(x, (HW_ASRC_ASRCSR_RD(x) & ~BM_ASRC_ASRCSR_AOCSA) | BF_ASRC_ASRCSR_AOCSA(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCSR, field AOCSB[19:16] (RW)
 *
 * Output Clock Source B
 *
 * Values:
 * - 0000 - bit clock 0
 * - 0001 - bit clock 1
 * - 0010 - bit clock 2
 * - 0011 - bit clock 3
 * - 0100 - bit clock 4
 * - 0101 - bit clock 5
 * - 0110 - bit clock 6
 * - 0111 - bit clock 7
 * - 1000 - bit clock 8
 * - 1001 - bit clock 9
 * - 1010 - bit clock A
 * - 1011 - bit clock B
 * - 1100 - bit clock C
 * - 1101 - bit clock D
 * - 1110 - bit clock E
 * - 1111 - clock disabled, connected to zero
 */
/*@{*/
#define BP_ASRC_ASRCSR_AOCSB (16U)         /*!< Bit position for ASRC_ASRCSR_AOCSB. */
#define BM_ASRC_ASRCSR_AOCSB (0x000F0000U) /*!< Bit mask for ASRC_ASRCSR_AOCSB. */
#define BS_ASRC_ASRCSR_AOCSB (4U)          /*!< Bit field size in bits for ASRC_ASRCSR_AOCSB. */

/*! @brief Read current value of the ASRC_ASRCSR_AOCSB field. */
#define BR_ASRC_ASRCSR_AOCSB(x) (HW_ASRC_ASRCSR(x).B.AOCSB)

/*! @brief Format value for bitfield ASRC_ASRCSR_AOCSB. */
#define BF_ASRC_ASRCSR_AOCSB(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCSR_AOCSB) & BM_ASRC_ASRCSR_AOCSB)

/*! @brief Set the AOCSB field to a new value. */
#define BW_ASRC_ASRCSR_AOCSB(x, v) (HW_ASRC_ASRCSR_WR(x, (HW_ASRC_ASRCSR_RD(x) & ~BM_ASRC_ASRCSR_AOCSB) | BF_ASRC_ASRCSR_AOCSB(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCSR, field AOCSC[23:20] (RW)
 *
 * Output Clock Source C
 *
 * Values:
 * - 0000 - bit clock 0
 * - 0001 - bit clock 1
 * - 0010 - bit clock 2
 * - 0011 - bit clock 3
 * - 0100 - bit clock 4
 * - 0101 - bit clock 5
 * - 0110 - bit clock 6
 * - 0111 - bit clock 7
 * - 1000 - bit clock 8
 * - 1001 - bit clock 9
 * - 1010 - bit clock A
 * - 1011 - bit clock B
 * - 1100 - bit clock C
 * - 1101 - bit clock D
 * - 1110 - bit clock E
 * - 1111 - clock disabled, connected to zero
 */
/*@{*/
#define BP_ASRC_ASRCSR_AOCSC (20U)         /*!< Bit position for ASRC_ASRCSR_AOCSC. */
#define BM_ASRC_ASRCSR_AOCSC (0x00F00000U) /*!< Bit mask for ASRC_ASRCSR_AOCSC. */
#define BS_ASRC_ASRCSR_AOCSC (4U)          /*!< Bit field size in bits for ASRC_ASRCSR_AOCSC. */

/*! @brief Read current value of the ASRC_ASRCSR_AOCSC field. */
#define BR_ASRC_ASRCSR_AOCSC(x) (HW_ASRC_ASRCSR(x).B.AOCSC)

/*! @brief Format value for bitfield ASRC_ASRCSR_AOCSC. */
#define BF_ASRC_ASRCSR_AOCSC(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCSR_AOCSC) & BM_ASRC_ASRCSR_AOCSC)

/*! @brief Set the AOCSC field to a new value. */
#define BW_ASRC_ASRCSR_AOCSC(x, v) (HW_ASRC_ASRCSR_WR(x, (HW_ASRC_ASRCSR_RD(x) & ~BM_ASRC_ASRCSR_AOCSC) | BF_ASRC_ASRCSR_AOCSC(v)))
/*@}*/

/*******************************************************************************
 * HW_ASRC_ASRCDR1 - ASRC Clock Divider Register 1
 ******************************************************************************/

/*!
 * @brief HW_ASRC_ASRCDR1 - ASRC Clock Divider Register 1 (RW)
 *
 * Reset value: 0x00000000U
 *
 * The ASRC clock divider register (ASRCDR1) is a 24-bit read/write register
 * that controls the division factors of the ASRC input and output clock sources.
 */
typedef union _hw_asrc_asrcdr1
{
    uint32_t U;
    struct _hw_asrc_asrcdr1_bitfields
    {
        uint32_t AICPA : 3;            /*!< [2:0]  */
        uint32_t AICDA : 3;            /*!< [5:3]  */
        uint32_t AICPB : 3;            /*!< [8:6]  */
        uint32_t AICDB : 3;            /*!< [11:9]  */
        uint32_t AOCPA : 3;            /*!< [14:12]  */
        uint32_t AOCDA : 3;            /*!< [17:15]  */
        uint32_t AOCPB : 3;            /*!< [20:18]  */
        uint32_t AOCDB : 3;            /*!< [23:21]  */
        uint32_t RESERVED0 : 8;        /*!< [31:24] This is a 24-bit register the
                                        * upper byte is unimplemented. */
    } B;
} hw_asrc_asrcdr1_t;

/*!
 * @name Constants and macros for entire ASRC_ASRCDR1 register
 */
/*@{*/
#define HW_ASRC_ASRCDR1_ADDR(x)  ((uintptr_t)(x) + 0x18U)

#define HW_ASRC_ASRCDR1(x)       (*(__IO hw_asrc_asrcdr1_t *) HW_ASRC_ASRCDR1_ADDR(x))
#define HW_ASRC_ASRCDR1_RD(x)    (HW_ASRC_ASRCDR1(x).U)
#define HW_ASRC_ASRCDR1_WR(x, v) (HW_ASRC_ASRCDR1(x).U = (v))
#define HW_ASRC_ASRCDR1_SET(x, v) (HW_ASRC_ASRCDR1_WR(x, HW_ASRC_ASRCDR1_RD(x) |  (v)))
#define HW_ASRC_ASRCDR1_CLR(x, v) (HW_ASRC_ASRCDR1_WR(x, HW_ASRC_ASRCDR1_RD(x) & ~(v)))
#define HW_ASRC_ASRCDR1_TOG(x, v) (HW_ASRC_ASRCDR1_WR(x, HW_ASRC_ASRCDR1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ASRC_ASRCDR1 bitfields
 */

/*!
 * @name Register ASRC_ASRCDR1, field AICPA[2:0] (RW)
 *
 * Input Clock Prescaler A Specify the prescaling factor of the input prescaler
 * A. The prescaling ratio may be any power of 2 from 1 to 128.
 */
/*@{*/
#define BP_ASRC_ASRCDR1_AICPA (0U)         /*!< Bit position for ASRC_ASRCDR1_AICPA. */
#define BM_ASRC_ASRCDR1_AICPA (0x00000007U) /*!< Bit mask for ASRC_ASRCDR1_AICPA. */
#define BS_ASRC_ASRCDR1_AICPA (3U)         /*!< Bit field size in bits for ASRC_ASRCDR1_AICPA. */

/*! @brief Read current value of the ASRC_ASRCDR1_AICPA field. */
#define BR_ASRC_ASRCDR1_AICPA(x) (HW_ASRC_ASRCDR1(x).B.AICPA)

/*! @brief Format value for bitfield ASRC_ASRCDR1_AICPA. */
#define BF_ASRC_ASRCDR1_AICPA(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCDR1_AICPA) & BM_ASRC_ASRCDR1_AICPA)

/*! @brief Set the AICPA field to a new value. */
#define BW_ASRC_ASRCDR1_AICPA(x, v) (HW_ASRC_ASRCDR1_WR(x, (HW_ASRC_ASRCDR1_RD(x) & ~BM_ASRC_ASRCDR1_AICPA) | BF_ASRC_ASRCDR1_AICPA(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCDR1, field AICDA[5:3] (RW)
 *
 * Input Clock Divider A Specify the divide ratio of the input clock divider A.
 * The divide ratio may range from 1 to 8 (AICDA[2:0] = 000 to 111).
 */
/*@{*/
#define BP_ASRC_ASRCDR1_AICDA (3U)         /*!< Bit position for ASRC_ASRCDR1_AICDA. */
#define BM_ASRC_ASRCDR1_AICDA (0x00000038U) /*!< Bit mask for ASRC_ASRCDR1_AICDA. */
#define BS_ASRC_ASRCDR1_AICDA (3U)         /*!< Bit field size in bits for ASRC_ASRCDR1_AICDA. */

/*! @brief Read current value of the ASRC_ASRCDR1_AICDA field. */
#define BR_ASRC_ASRCDR1_AICDA(x) (HW_ASRC_ASRCDR1(x).B.AICDA)

/*! @brief Format value for bitfield ASRC_ASRCDR1_AICDA. */
#define BF_ASRC_ASRCDR1_AICDA(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCDR1_AICDA) & BM_ASRC_ASRCDR1_AICDA)

/*! @brief Set the AICDA field to a new value. */
#define BW_ASRC_ASRCDR1_AICDA(x, v) (HW_ASRC_ASRCDR1_WR(x, (HW_ASRC_ASRCDR1_RD(x) & ~BM_ASRC_ASRCDR1_AICDA) | BF_ASRC_ASRCDR1_AICDA(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCDR1, field AICPB[8:6] (RW)
 *
 * Input Clock Prescaler B Specify the prescaling factor of the input prescaler
 * B. The prescaling ratio may be any power of 2 from 1 to 128.
 */
/*@{*/
#define BP_ASRC_ASRCDR1_AICPB (6U)         /*!< Bit position for ASRC_ASRCDR1_AICPB. */
#define BM_ASRC_ASRCDR1_AICPB (0x000001C0U) /*!< Bit mask for ASRC_ASRCDR1_AICPB. */
#define BS_ASRC_ASRCDR1_AICPB (3U)         /*!< Bit field size in bits for ASRC_ASRCDR1_AICPB. */

/*! @brief Read current value of the ASRC_ASRCDR1_AICPB field. */
#define BR_ASRC_ASRCDR1_AICPB(x) (HW_ASRC_ASRCDR1(x).B.AICPB)

/*! @brief Format value for bitfield ASRC_ASRCDR1_AICPB. */
#define BF_ASRC_ASRCDR1_AICPB(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCDR1_AICPB) & BM_ASRC_ASRCDR1_AICPB)

/*! @brief Set the AICPB field to a new value. */
#define BW_ASRC_ASRCDR1_AICPB(x, v) (HW_ASRC_ASRCDR1_WR(x, (HW_ASRC_ASRCDR1_RD(x) & ~BM_ASRC_ASRCDR1_AICPB) | BF_ASRC_ASRCDR1_AICPB(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCDR1, field AICDB[11:9] (RW)
 *
 * Input Clock Divider B Specify the divide ratio of the input clock divider B.
 * The divide ratio may range from 1 to 8 (AICDB[2:0] = 000 to 111).
 */
/*@{*/
#define BP_ASRC_ASRCDR1_AICDB (9U)         /*!< Bit position for ASRC_ASRCDR1_AICDB. */
#define BM_ASRC_ASRCDR1_AICDB (0x00000E00U) /*!< Bit mask for ASRC_ASRCDR1_AICDB. */
#define BS_ASRC_ASRCDR1_AICDB (3U)         /*!< Bit field size in bits for ASRC_ASRCDR1_AICDB. */

/*! @brief Read current value of the ASRC_ASRCDR1_AICDB field. */
#define BR_ASRC_ASRCDR1_AICDB(x) (HW_ASRC_ASRCDR1(x).B.AICDB)

/*! @brief Format value for bitfield ASRC_ASRCDR1_AICDB. */
#define BF_ASRC_ASRCDR1_AICDB(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCDR1_AICDB) & BM_ASRC_ASRCDR1_AICDB)

/*! @brief Set the AICDB field to a new value. */
#define BW_ASRC_ASRCDR1_AICDB(x, v) (HW_ASRC_ASRCDR1_WR(x, (HW_ASRC_ASRCDR1_RD(x) & ~BM_ASRC_ASRCDR1_AICDB) | BF_ASRC_ASRCDR1_AICDB(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCDR1, field AOCPA[14:12] (RW)
 *
 * Output Clock Prescaler A Specify the prescaling factor of the output
 * prescaler A. The prescaling ratio may be any power of 2 from 1 to 128.
 */
/*@{*/
#define BP_ASRC_ASRCDR1_AOCPA (12U)        /*!< Bit position for ASRC_ASRCDR1_AOCPA. */
#define BM_ASRC_ASRCDR1_AOCPA (0x00007000U) /*!< Bit mask for ASRC_ASRCDR1_AOCPA. */
#define BS_ASRC_ASRCDR1_AOCPA (3U)         /*!< Bit field size in bits for ASRC_ASRCDR1_AOCPA. */

/*! @brief Read current value of the ASRC_ASRCDR1_AOCPA field. */
#define BR_ASRC_ASRCDR1_AOCPA(x) (HW_ASRC_ASRCDR1(x).B.AOCPA)

/*! @brief Format value for bitfield ASRC_ASRCDR1_AOCPA. */
#define BF_ASRC_ASRCDR1_AOCPA(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCDR1_AOCPA) & BM_ASRC_ASRCDR1_AOCPA)

/*! @brief Set the AOCPA field to a new value. */
#define BW_ASRC_ASRCDR1_AOCPA(x, v) (HW_ASRC_ASRCDR1_WR(x, (HW_ASRC_ASRCDR1_RD(x) & ~BM_ASRC_ASRCDR1_AOCPA) | BF_ASRC_ASRCDR1_AOCPA(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCDR1, field AOCDA[17:15] (RW)
 *
 * Output Clock Divider A Specify the divide ratio of the output clock divider
 * A. The divide ratio may range from 1 to 8 (AOCDA[2:0] = 000 to 111).
 */
/*@{*/
#define BP_ASRC_ASRCDR1_AOCDA (15U)        /*!< Bit position for ASRC_ASRCDR1_AOCDA. */
#define BM_ASRC_ASRCDR1_AOCDA (0x00038000U) /*!< Bit mask for ASRC_ASRCDR1_AOCDA. */
#define BS_ASRC_ASRCDR1_AOCDA (3U)         /*!< Bit field size in bits for ASRC_ASRCDR1_AOCDA. */

/*! @brief Read current value of the ASRC_ASRCDR1_AOCDA field. */
#define BR_ASRC_ASRCDR1_AOCDA(x) (HW_ASRC_ASRCDR1(x).B.AOCDA)

/*! @brief Format value for bitfield ASRC_ASRCDR1_AOCDA. */
#define BF_ASRC_ASRCDR1_AOCDA(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCDR1_AOCDA) & BM_ASRC_ASRCDR1_AOCDA)

/*! @brief Set the AOCDA field to a new value. */
#define BW_ASRC_ASRCDR1_AOCDA(x, v) (HW_ASRC_ASRCDR1_WR(x, (HW_ASRC_ASRCDR1_RD(x) & ~BM_ASRC_ASRCDR1_AOCDA) | BF_ASRC_ASRCDR1_AOCDA(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCDR1, field AOCPB[20:18] (RW)
 *
 * Output Clock Prescaler B Specify the prescaling factor of the output
 * prescaler B. The prescaling ratio may be any power of 2 from 1 to 128.
 */
/*@{*/
#define BP_ASRC_ASRCDR1_AOCPB (18U)        /*!< Bit position for ASRC_ASRCDR1_AOCPB. */
#define BM_ASRC_ASRCDR1_AOCPB (0x001C0000U) /*!< Bit mask for ASRC_ASRCDR1_AOCPB. */
#define BS_ASRC_ASRCDR1_AOCPB (3U)         /*!< Bit field size in bits for ASRC_ASRCDR1_AOCPB. */

/*! @brief Read current value of the ASRC_ASRCDR1_AOCPB field. */
#define BR_ASRC_ASRCDR1_AOCPB(x) (HW_ASRC_ASRCDR1(x).B.AOCPB)

/*! @brief Format value for bitfield ASRC_ASRCDR1_AOCPB. */
#define BF_ASRC_ASRCDR1_AOCPB(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCDR1_AOCPB) & BM_ASRC_ASRCDR1_AOCPB)

/*! @brief Set the AOCPB field to a new value. */
#define BW_ASRC_ASRCDR1_AOCPB(x, v) (HW_ASRC_ASRCDR1_WR(x, (HW_ASRC_ASRCDR1_RD(x) & ~BM_ASRC_ASRCDR1_AOCPB) | BF_ASRC_ASRCDR1_AOCPB(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCDR1, field AOCDB[23:21] (RW)
 *
 * Output Clock Divider B Specify the divide ratio of the output clock divider
 * B. The divide ratio may range from 1 to 8 (AOCDB[2:0] = 000 to 111).
 */
/*@{*/
#define BP_ASRC_ASRCDR1_AOCDB (21U)        /*!< Bit position for ASRC_ASRCDR1_AOCDB. */
#define BM_ASRC_ASRCDR1_AOCDB (0x00E00000U) /*!< Bit mask for ASRC_ASRCDR1_AOCDB. */
#define BS_ASRC_ASRCDR1_AOCDB (3U)         /*!< Bit field size in bits for ASRC_ASRCDR1_AOCDB. */

/*! @brief Read current value of the ASRC_ASRCDR1_AOCDB field. */
#define BR_ASRC_ASRCDR1_AOCDB(x) (HW_ASRC_ASRCDR1(x).B.AOCDB)

/*! @brief Format value for bitfield ASRC_ASRCDR1_AOCDB. */
#define BF_ASRC_ASRCDR1_AOCDB(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCDR1_AOCDB) & BM_ASRC_ASRCDR1_AOCDB)

/*! @brief Set the AOCDB field to a new value. */
#define BW_ASRC_ASRCDR1_AOCDB(x, v) (HW_ASRC_ASRCDR1_WR(x, (HW_ASRC_ASRCDR1_RD(x) & ~BM_ASRC_ASRCDR1_AOCDB) | BF_ASRC_ASRCDR1_AOCDB(v)))
/*@}*/

/*******************************************************************************
 * HW_ASRC_ASRCDR2 - ASRC Clock Divider Register 2
 ******************************************************************************/

/*!
 * @brief HW_ASRC_ASRCDR2 - ASRC Clock Divider Register 2 (RW)
 *
 * Reset value: 0x00000000U
 *
 * The ASRC clock divider register (ASRCDR2) is a 24-bit read/write register
 * that controls the division factors of the ASRC input and output clock sources.
 */
typedef union _hw_asrc_asrcdr2
{
    uint32_t U;
    struct _hw_asrc_asrcdr2_bitfields
    {
        uint32_t AICPC : 3;            /*!< [2:0]  */
        uint32_t AICDC : 3;            /*!< [5:3]  */
        uint32_t AOCPC : 3;            /*!< [8:6]  */
        uint32_t AOCDC : 3;            /*!< [11:9]  */
        uint32_t RESERVED0 : 20;       /*!< [31:12] This is a 24-bit register the
                                        * upper byte is unimplemented. */
    } B;
} hw_asrc_asrcdr2_t;

/*!
 * @name Constants and macros for entire ASRC_ASRCDR2 register
 */
/*@{*/
#define HW_ASRC_ASRCDR2_ADDR(x)  ((uintptr_t)(x) + 0x1CU)

#define HW_ASRC_ASRCDR2(x)       (*(__IO hw_asrc_asrcdr2_t *) HW_ASRC_ASRCDR2_ADDR(x))
#define HW_ASRC_ASRCDR2_RD(x)    (HW_ASRC_ASRCDR2(x).U)
#define HW_ASRC_ASRCDR2_WR(x, v) (HW_ASRC_ASRCDR2(x).U = (v))
#define HW_ASRC_ASRCDR2_SET(x, v) (HW_ASRC_ASRCDR2_WR(x, HW_ASRC_ASRCDR2_RD(x) |  (v)))
#define HW_ASRC_ASRCDR2_CLR(x, v) (HW_ASRC_ASRCDR2_WR(x, HW_ASRC_ASRCDR2_RD(x) & ~(v)))
#define HW_ASRC_ASRCDR2_TOG(x, v) (HW_ASRC_ASRCDR2_WR(x, HW_ASRC_ASRCDR2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ASRC_ASRCDR2 bitfields
 */

/*!
 * @name Register ASRC_ASRCDR2, field AICPC[2:0] (RW)
 *
 * Input Clock Prescaler C Specify the prescaling factor of the input prescaler
 * C. The prescaling ratio may be any power of 2 from 1 to 128.
 */
/*@{*/
#define BP_ASRC_ASRCDR2_AICPC (0U)         /*!< Bit position for ASRC_ASRCDR2_AICPC. */
#define BM_ASRC_ASRCDR2_AICPC (0x00000007U) /*!< Bit mask for ASRC_ASRCDR2_AICPC. */
#define BS_ASRC_ASRCDR2_AICPC (3U)         /*!< Bit field size in bits for ASRC_ASRCDR2_AICPC. */

/*! @brief Read current value of the ASRC_ASRCDR2_AICPC field. */
#define BR_ASRC_ASRCDR2_AICPC(x) (HW_ASRC_ASRCDR2(x).B.AICPC)

/*! @brief Format value for bitfield ASRC_ASRCDR2_AICPC. */
#define BF_ASRC_ASRCDR2_AICPC(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCDR2_AICPC) & BM_ASRC_ASRCDR2_AICPC)

/*! @brief Set the AICPC field to a new value. */
#define BW_ASRC_ASRCDR2_AICPC(x, v) (HW_ASRC_ASRCDR2_WR(x, (HW_ASRC_ASRCDR2_RD(x) & ~BM_ASRC_ASRCDR2_AICPC) | BF_ASRC_ASRCDR2_AICPC(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCDR2, field AICDC[5:3] (RW)
 *
 * Input Clock Divider C Specify the divide ratio of the input clock divider C.
 * The divide ratio may range from 1 to 8 (AICDC[2:0] = 000 to 111).
 */
/*@{*/
#define BP_ASRC_ASRCDR2_AICDC (3U)         /*!< Bit position for ASRC_ASRCDR2_AICDC. */
#define BM_ASRC_ASRCDR2_AICDC (0x00000038U) /*!< Bit mask for ASRC_ASRCDR2_AICDC. */
#define BS_ASRC_ASRCDR2_AICDC (3U)         /*!< Bit field size in bits for ASRC_ASRCDR2_AICDC. */

/*! @brief Read current value of the ASRC_ASRCDR2_AICDC field. */
#define BR_ASRC_ASRCDR2_AICDC(x) (HW_ASRC_ASRCDR2(x).B.AICDC)

/*! @brief Format value for bitfield ASRC_ASRCDR2_AICDC. */
#define BF_ASRC_ASRCDR2_AICDC(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCDR2_AICDC) & BM_ASRC_ASRCDR2_AICDC)

/*! @brief Set the AICDC field to a new value. */
#define BW_ASRC_ASRCDR2_AICDC(x, v) (HW_ASRC_ASRCDR2_WR(x, (HW_ASRC_ASRCDR2_RD(x) & ~BM_ASRC_ASRCDR2_AICDC) | BF_ASRC_ASRCDR2_AICDC(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCDR2, field AOCPC[8:6] (RW)
 *
 * Output Clock Prescaler C Specify the prescaling factor of the output
 * prescaler C. The prescaling ratio may be any power of 2 from 1 to 128.
 */
/*@{*/
#define BP_ASRC_ASRCDR2_AOCPC (6U)         /*!< Bit position for ASRC_ASRCDR2_AOCPC. */
#define BM_ASRC_ASRCDR2_AOCPC (0x000001C0U) /*!< Bit mask for ASRC_ASRCDR2_AOCPC. */
#define BS_ASRC_ASRCDR2_AOCPC (3U)         /*!< Bit field size in bits for ASRC_ASRCDR2_AOCPC. */

/*! @brief Read current value of the ASRC_ASRCDR2_AOCPC field. */
#define BR_ASRC_ASRCDR2_AOCPC(x) (HW_ASRC_ASRCDR2(x).B.AOCPC)

/*! @brief Format value for bitfield ASRC_ASRCDR2_AOCPC. */
#define BF_ASRC_ASRCDR2_AOCPC(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCDR2_AOCPC) & BM_ASRC_ASRCDR2_AOCPC)

/*! @brief Set the AOCPC field to a new value. */
#define BW_ASRC_ASRCDR2_AOCPC(x, v) (HW_ASRC_ASRCDR2_WR(x, (HW_ASRC_ASRCDR2_RD(x) & ~BM_ASRC_ASRCDR2_AOCPC) | BF_ASRC_ASRCDR2_AOCPC(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCDR2, field AOCDC[11:9] (RW)
 *
 * Output Clock Divider C Specify the divide ratio of the output clock divider
 * C. The divide ratio may range from 1 to 8 (AOCDC[2:0] = 000 to 111).
 */
/*@{*/
#define BP_ASRC_ASRCDR2_AOCDC (9U)         /*!< Bit position for ASRC_ASRCDR2_AOCDC. */
#define BM_ASRC_ASRCDR2_AOCDC (0x00000E00U) /*!< Bit mask for ASRC_ASRCDR2_AOCDC. */
#define BS_ASRC_ASRCDR2_AOCDC (3U)         /*!< Bit field size in bits for ASRC_ASRCDR2_AOCDC. */

/*! @brief Read current value of the ASRC_ASRCDR2_AOCDC field. */
#define BR_ASRC_ASRCDR2_AOCDC(x) (HW_ASRC_ASRCDR2(x).B.AOCDC)

/*! @brief Format value for bitfield ASRC_ASRCDR2_AOCDC. */
#define BF_ASRC_ASRCDR2_AOCDC(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCDR2_AOCDC) & BM_ASRC_ASRCDR2_AOCDC)

/*! @brief Set the AOCDC field to a new value. */
#define BW_ASRC_ASRCDR2_AOCDC(x, v) (HW_ASRC_ASRCDR2_WR(x, (HW_ASRC_ASRCDR2_RD(x) & ~BM_ASRC_ASRCDR2_AOCDC) | BF_ASRC_ASRCDR2_AOCDC(v)))
/*@}*/

/*******************************************************************************
 * HW_ASRC_ASRSTR - ASRC Status Register
 ******************************************************************************/

/*!
 * @brief HW_ASRC_ASRSTR - ASRC Status Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * The ASRC status register (ASRSTR) is a 24-bit read-write register used by the
 * processor core to examine the status of the ASRC block and clear the overload
 * interrupt request and AOLE flag bit. Read the status register will return the
 * current state of ASRC.
 */
typedef union _hw_asrc_asrstr
{
    uint32_t U;
    struct _hw_asrc_asrstr_bitfields
    {
        uint32_t AIDEA : 1;            /*!< [0]  */
        uint32_t AIDEB : 1;            /*!< [1]  */
        uint32_t AIDEC : 1;            /*!< [2]  */
        uint32_t AODFA : 1;            /*!< [3]  */
        uint32_t AODFB : 1;            /*!< [4]  */
        uint32_t AODFC : 1;            /*!< [5]  */
        uint32_t AOLE : 1;             /*!< [6]  */
        uint32_t FPWT : 1;             /*!< [7]  */
        uint32_t AIDUA : 1;            /*!< [8]  */
        uint32_t AIDUB : 1;            /*!< [9]  */
        uint32_t AIDUC : 1;            /*!< [10]  */
        uint32_t AODOA : 1;            /*!< [11]  */
        uint32_t AODOB : 1;            /*!< [12]  */
        uint32_t AODOC : 1;            /*!< [13]  */
        uint32_t AIOLA : 1;            /*!< [14]  */
        uint32_t AIOLB : 1;            /*!< [15]  */
        uint32_t AIOLC : 1;            /*!< [16]  */
        uint32_t AOOLA : 1;            /*!< [17]  */
        uint32_t AOOLB : 1;            /*!< [18]  */
        uint32_t AOOLC : 1;            /*!< [19]  */
        uint32_t ATQOL : 1;            /*!< [20]  */
        uint32_t DSLCNT : 1;           /*!< [21]  */
        uint32_t RESERVED0 : 10;       /*!< [31:22] This is a 24-bit register the
                                        * upper byte is unimplemented. */
    } B;
} hw_asrc_asrstr_t;

/*!
 * @name Constants and macros for entire ASRC_ASRSTR register
 */
/*@{*/
#define HW_ASRC_ASRSTR_ADDR(x)   ((uintptr_t)(x) + 0x20U)

#define HW_ASRC_ASRSTR(x)        (*(__I hw_asrc_asrstr_t *) HW_ASRC_ASRSTR_ADDR(x))
#define HW_ASRC_ASRSTR_RD(x)     (HW_ASRC_ASRSTR(x).U)
/*@}*/

/*
 * Constants & macros for individual ASRC_ASRSTR bitfields
 */

/*!
 * @name Register ASRC_ASRSTR, field AIDEA[0] (RO)
 *
 * Number of data in Input Data Buffer A is less than threshold When set, this
 * bit indicates that number of data still available in ASRDIRA is less than
 * threshold and the processor can write data to ASRDIRA. When AIDEA is set, the ASRC
 * generates data input A interrupt request to the processor, if enabled (that
 * is, ASRIER:ADIEA = 1). A DMA request is always generated when the AIDEA bit is
 * set, but a DMA transfer takes place only if a DMA channel is active and
 * triggered by this event.
 */
/*@{*/
#define BP_ASRC_ASRSTR_AIDEA (0U)          /*!< Bit position for ASRC_ASRSTR_AIDEA. */
#define BM_ASRC_ASRSTR_AIDEA (0x00000001U) /*!< Bit mask for ASRC_ASRSTR_AIDEA. */
#define BS_ASRC_ASRSTR_AIDEA (1U)          /*!< Bit field size in bits for ASRC_ASRSTR_AIDEA. */

/*! @brief Read current value of the ASRC_ASRSTR_AIDEA field. */
#define BR_ASRC_ASRSTR_AIDEA(x) (HW_ASRC_ASRSTR(x).B.AIDEA)
/*@}*/

/*!
 * @name Register ASRC_ASRSTR, field AIDEB[1] (RO)
 *
 * Number of data in Input Data Buffer B is less than threshold When set, this
 * bit indicates that number of data still available in ASRDIRB is less than
 * threshold and the processor can write data to ASRDIRB. When AIDEB is set, the ASRC
 * generates data input B interrupt request to the processor, if enabled (that
 * is, ASRIER:ADIEB = 1). A DMA request is always generated when the AIDEB bit is
 * set, but a DMA transfer takes place only if a DMA channel is active and
 * triggered by this event.
 */
/*@{*/
#define BP_ASRC_ASRSTR_AIDEB (1U)          /*!< Bit position for ASRC_ASRSTR_AIDEB. */
#define BM_ASRC_ASRSTR_AIDEB (0x00000002U) /*!< Bit mask for ASRC_ASRSTR_AIDEB. */
#define BS_ASRC_ASRSTR_AIDEB (1U)          /*!< Bit field size in bits for ASRC_ASRSTR_AIDEB. */

/*! @brief Read current value of the ASRC_ASRSTR_AIDEB field. */
#define BR_ASRC_ASRSTR_AIDEB(x) (HW_ASRC_ASRSTR(x).B.AIDEB)
/*@}*/

/*!
 * @name Register ASRC_ASRSTR, field AIDEC[2] (RO)
 *
 * Number of data in Input Data Buffer C is less than threshold When set, this
 * bit indicates that number of data still available in ASRDIRC is less than
 * threshold and the processor can write data to ASRDIRC. When AIDEC is set, the ASRC
 * generates data input C interrupt request to the processor, if enabled (that
 * is, ASRIER:ADIEC = 1). A DMA request is always generated when the AIDEC bit is
 * set, but a DMA transfer takes place only if a DMA channel is active and
 * triggered by this event.
 */
/*@{*/
#define BP_ASRC_ASRSTR_AIDEC (2U)          /*!< Bit position for ASRC_ASRSTR_AIDEC. */
#define BM_ASRC_ASRSTR_AIDEC (0x00000004U) /*!< Bit mask for ASRC_ASRSTR_AIDEC. */
#define BS_ASRC_ASRSTR_AIDEC (1U)          /*!< Bit field size in bits for ASRC_ASRSTR_AIDEC. */

/*! @brief Read current value of the ASRC_ASRSTR_AIDEC field. */
#define BR_ASRC_ASRSTR_AIDEC(x) (HW_ASRC_ASRSTR(x).B.AIDEC)
/*@}*/

/*!
 * @name Register ASRC_ASRSTR, field AODFA[3] (RO)
 *
 * Number of data in Output Data Buffer A is greater than threshold When set,
 * this bit indicates that number of data already existing in ASRDORA is greater
 * than threshold and the processor can read data from ASRDORA. When AODFA is set,
 * the ASRC generates data output A interrupt request to the processor, if
 * enabled (that is, ASRIER:ADOEA = 1). A DMA request is always generated when the
 * AODFA bit is set, but a DMA transfer takes place only if a DMA channel is active
 * and triggered by this event.
 */
/*@{*/
#define BP_ASRC_ASRSTR_AODFA (3U)          /*!< Bit position for ASRC_ASRSTR_AODFA. */
#define BM_ASRC_ASRSTR_AODFA (0x00000008U) /*!< Bit mask for ASRC_ASRSTR_AODFA. */
#define BS_ASRC_ASRSTR_AODFA (1U)          /*!< Bit field size in bits for ASRC_ASRSTR_AODFA. */

/*! @brief Read current value of the ASRC_ASRSTR_AODFA field. */
#define BR_ASRC_ASRSTR_AODFA(x) (HW_ASRC_ASRSTR(x).B.AODFA)
/*@}*/

/*!
 * @name Register ASRC_ASRSTR, field AODFB[4] (RO)
 *
 * Number of data in Output Data Buffer B is greater than threshold When set,
 * this bit indicates that number of data already existing in ASRDORB is greater
 * than threshold and the processor can read data from ASRDORB. When AODFB is set,
 * the ASRC generates data output B interrupt request to the processor, if
 * enabled (that is, ASRIER:ADOEB = 1). A DMA request is always generated when the
 * AODFB bit is set, but a DMA transfer takes place only if a DMA channel is active
 * and triggered by this event.
 */
/*@{*/
#define BP_ASRC_ASRSTR_AODFB (4U)          /*!< Bit position for ASRC_ASRSTR_AODFB. */
#define BM_ASRC_ASRSTR_AODFB (0x00000010U) /*!< Bit mask for ASRC_ASRSTR_AODFB. */
#define BS_ASRC_ASRSTR_AODFB (1U)          /*!< Bit field size in bits for ASRC_ASRSTR_AODFB. */

/*! @brief Read current value of the ASRC_ASRSTR_AODFB field. */
#define BR_ASRC_ASRSTR_AODFB(x) (HW_ASRC_ASRSTR(x).B.AODFB)
/*@}*/

/*!
 * @name Register ASRC_ASRSTR, field AODFC[5] (RO)
 *
 * Number of data in Output Data Buffer C is greater than threshold When set,
 * this bit indicates that number of data already existing in ASRDORC is greater
 * than threshold and the processor can read data from ASRDORC. When AODFC is set,
 * the ASRC generates data output C interrupt request to the processor, if
 * enabled (that is, ASRIER:ADOEC = 1). A DMA request is always generated when the
 * AODFC bit is set, but a DMA transfer takes place only if a DMA channel is active
 * and triggered by this event.
 */
/*@{*/
#define BP_ASRC_ASRSTR_AODFC (5U)          /*!< Bit position for ASRC_ASRSTR_AODFC. */
#define BM_ASRC_ASRSTR_AODFC (0x00000020U) /*!< Bit mask for ASRC_ASRSTR_AODFC. */
#define BS_ASRC_ASRSTR_AODFC (1U)          /*!< Bit field size in bits for ASRC_ASRSTR_AODFC. */

/*! @brief Read current value of the ASRC_ASRSTR_AODFC field. */
#define BR_ASRC_ASRSTR_AODFC(x) (HW_ASRC_ASRSTR(x).B.AODFC)
/*@}*/

/*!
 * @name Register ASRC_ASRSTR, field AOLE[6] (RO)
 *
 * Overload Error Flag When set, this bit indicates that the task rate is too
 * high for the ASRC to handle. The reasons for overload may be: - too high input
 * clock frequency, - too high output clock frequency, - incorrect selection of
 * the pre-filter, - low ASRC processing clock, - too many channels, - underrun, -
 * or any combination of the reasons above. Since the ASRC uses the same hardware
 * resources to perform various tasks, the real reason for the overload is not
 * straight forward, and it should be carefully analyzed by the programmer. If
 * ASRIER:AOLIE=1, an interrupt will be proposed when this bit is set. Write any
 * value with this bit set as one into the status register will clear this bit and
 * the interrupt request proposed by this bit.
 */
/*@{*/
#define BP_ASRC_ASRSTR_AOLE  (6U)          /*!< Bit position for ASRC_ASRSTR_AOLE. */
#define BM_ASRC_ASRSTR_AOLE  (0x00000040U) /*!< Bit mask for ASRC_ASRSTR_AOLE. */
#define BS_ASRC_ASRSTR_AOLE  (1U)          /*!< Bit field size in bits for ASRC_ASRSTR_AOLE. */

/*! @brief Read current value of the ASRC_ASRSTR_AOLE field. */
#define BR_ASRC_ASRSTR_AOLE(x) (HW_ASRC_ASRSTR(x).B.AOLE)
/*@}*/

/*!
 * @name Register ASRC_ASRSTR, field FPWT[7] (RO)
 *
 * FP is in wait states This bit is for debug only. When set, this bit indicates
 * that ASRC is in wait states. When clear, this bit indicates that ASRC is not
 * in wait states.
 */
/*@{*/
#define BP_ASRC_ASRSTR_FPWT  (7U)          /*!< Bit position for ASRC_ASRSTR_FPWT. */
#define BM_ASRC_ASRSTR_FPWT  (0x00000080U) /*!< Bit mask for ASRC_ASRSTR_FPWT. */
#define BS_ASRC_ASRSTR_FPWT  (1U)          /*!< Bit field size in bits for ASRC_ASRSTR_FPWT. */

/*! @brief Read current value of the ASRC_ASRSTR_FPWT field. */
#define BR_ASRC_ASRSTR_FPWT(x) (HW_ASRC_ASRSTR(x).B.FPWT)
/*@}*/

/*!
 * @name Register ASRC_ASRSTR, field AIDUA[8] (RO)
 *
 * Input Data Buffer A has underflowed When set, this bit indicates that input
 * data buffer A has underflowed. When clear, this bit indicates that input data
 * buffer A has not underflowed. The bit is cleared when writing ASRSTR:AOLE as 1.
 */
/*@{*/
#define BP_ASRC_ASRSTR_AIDUA (8U)          /*!< Bit position for ASRC_ASRSTR_AIDUA. */
#define BM_ASRC_ASRSTR_AIDUA (0x00000100U) /*!< Bit mask for ASRC_ASRSTR_AIDUA. */
#define BS_ASRC_ASRSTR_AIDUA (1U)          /*!< Bit field size in bits for ASRC_ASRSTR_AIDUA. */

/*! @brief Read current value of the ASRC_ASRSTR_AIDUA field. */
#define BR_ASRC_ASRSTR_AIDUA(x) (HW_ASRC_ASRSTR(x).B.AIDUA)
/*@}*/

/*!
 * @name Register ASRC_ASRSTR, field AIDUB[9] (RO)
 *
 * Input Data Buffer B has underflowed When set, this bit indicates that input
 * data buffer B has underflowed. When clear, this bit indicates that input data
 * buffer B has not underflowed. The bit is cleared when writing ASRSTR:AOLE as 1.
 */
/*@{*/
#define BP_ASRC_ASRSTR_AIDUB (9U)          /*!< Bit position for ASRC_ASRSTR_AIDUB. */
#define BM_ASRC_ASRSTR_AIDUB (0x00000200U) /*!< Bit mask for ASRC_ASRSTR_AIDUB. */
#define BS_ASRC_ASRSTR_AIDUB (1U)          /*!< Bit field size in bits for ASRC_ASRSTR_AIDUB. */

/*! @brief Read current value of the ASRC_ASRSTR_AIDUB field. */
#define BR_ASRC_ASRSTR_AIDUB(x) (HW_ASRC_ASRSTR(x).B.AIDUB)
/*@}*/

/*!
 * @name Register ASRC_ASRSTR, field AIDUC[10] (RO)
 *
 * Input Data Buffer C has underflowed When set, this bit indicates that input
 * data buffer C has underflowed. When clear, this bit indicates that input data
 * buffer C has not underflowed. The bit is cleared when writing ASRSTR:AOLE as 1.
 */
/*@{*/
#define BP_ASRC_ASRSTR_AIDUC (10U)         /*!< Bit position for ASRC_ASRSTR_AIDUC. */
#define BM_ASRC_ASRSTR_AIDUC (0x00000400U) /*!< Bit mask for ASRC_ASRSTR_AIDUC. */
#define BS_ASRC_ASRSTR_AIDUC (1U)          /*!< Bit field size in bits for ASRC_ASRSTR_AIDUC. */

/*! @brief Read current value of the ASRC_ASRSTR_AIDUC field. */
#define BR_ASRC_ASRSTR_AIDUC(x) (HW_ASRC_ASRSTR(x).B.AIDUC)
/*@}*/

/*!
 * @name Register ASRC_ASRSTR, field AODOA[11] (RO)
 *
 * Output Data Buffer A has overflowed When set, this bit indicates that output
 * data buffer A has overflowed. When clear, this bit indicates that output data
 * buffer A has not overflowed The bit is cleared when writing ASRSTR:AOLE as 1.
 */
/*@{*/
#define BP_ASRC_ASRSTR_AODOA (11U)         /*!< Bit position for ASRC_ASRSTR_AODOA. */
#define BM_ASRC_ASRSTR_AODOA (0x00000800U) /*!< Bit mask for ASRC_ASRSTR_AODOA. */
#define BS_ASRC_ASRSTR_AODOA (1U)          /*!< Bit field size in bits for ASRC_ASRSTR_AODOA. */

/*! @brief Read current value of the ASRC_ASRSTR_AODOA field. */
#define BR_ASRC_ASRSTR_AODOA(x) (HW_ASRC_ASRSTR(x).B.AODOA)
/*@}*/

/*!
 * @name Register ASRC_ASRSTR, field AODOB[12] (RO)
 *
 * Output Data Buffer B has overflowed When set, this bit indicates that output
 * data buffer B has overflowed. When clear, this bit indicates that output data
 * buffer B has not overflowed The bit is cleared when writing ASRSTR:AOLE as 1.
 */
/*@{*/
#define BP_ASRC_ASRSTR_AODOB (12U)         /*!< Bit position for ASRC_ASRSTR_AODOB. */
#define BM_ASRC_ASRSTR_AODOB (0x00001000U) /*!< Bit mask for ASRC_ASRSTR_AODOB. */
#define BS_ASRC_ASRSTR_AODOB (1U)          /*!< Bit field size in bits for ASRC_ASRSTR_AODOB. */

/*! @brief Read current value of the ASRC_ASRSTR_AODOB field. */
#define BR_ASRC_ASRSTR_AODOB(x) (HW_ASRC_ASRSTR(x).B.AODOB)
/*@}*/

/*!
 * @name Register ASRC_ASRSTR, field AODOC[13] (RO)
 *
 * Output Data Buffer C has overflowed When set, this bit indicates that output
 * data buffer C has overflowed. When clear, this bit indicates that output data
 * buffer C has not overflowed The bit is cleared when writing ASRSTR:AOLE as 1.
 */
/*@{*/
#define BP_ASRC_ASRSTR_AODOC (13U)         /*!< Bit position for ASRC_ASRSTR_AODOC. */
#define BM_ASRC_ASRSTR_AODOC (0x00002000U) /*!< Bit mask for ASRC_ASRSTR_AODOC. */
#define BS_ASRC_ASRSTR_AODOC (1U)          /*!< Bit field size in bits for ASRC_ASRSTR_AODOC. */

/*! @brief Read current value of the ASRC_ASRSTR_AODOC field. */
#define BR_ASRC_ASRSTR_AODOC(x) (HW_ASRC_ASRSTR(x).B.AODOC)
/*@}*/

/*!
 * @name Register ASRC_ASRSTR, field AIOLA[14] (RO)
 *
 * Pair A Input Task Overload When set, this bit indicates that pair A input
 * task is oveloaded. This may help to check the reason why overload interrupt
 * happens. The bit is cleared when writing ASRSTR:AOLE as 1.
 */
/*@{*/
#define BP_ASRC_ASRSTR_AIOLA (14U)         /*!< Bit position for ASRC_ASRSTR_AIOLA. */
#define BM_ASRC_ASRSTR_AIOLA (0x00004000U) /*!< Bit mask for ASRC_ASRSTR_AIOLA. */
#define BS_ASRC_ASRSTR_AIOLA (1U)          /*!< Bit field size in bits for ASRC_ASRSTR_AIOLA. */

/*! @brief Read current value of the ASRC_ASRSTR_AIOLA field. */
#define BR_ASRC_ASRSTR_AIOLA(x) (HW_ASRC_ASRSTR(x).B.AIOLA)
/*@}*/

/*!
 * @name Register ASRC_ASRSTR, field AIOLB[15] (RO)
 *
 * Pair B Input Task Overload When set, this bit indicates that pair B input
 * task is oveloaded. This may help to check the reason why overload interrupt
 * happens. The bit is cleared when writing ASRSTR:AOLE as 1.
 */
/*@{*/
#define BP_ASRC_ASRSTR_AIOLB (15U)         /*!< Bit position for ASRC_ASRSTR_AIOLB. */
#define BM_ASRC_ASRSTR_AIOLB (0x00008000U) /*!< Bit mask for ASRC_ASRSTR_AIOLB. */
#define BS_ASRC_ASRSTR_AIOLB (1U)          /*!< Bit field size in bits for ASRC_ASRSTR_AIOLB. */

/*! @brief Read current value of the ASRC_ASRSTR_AIOLB field. */
#define BR_ASRC_ASRSTR_AIOLB(x) (HW_ASRC_ASRSTR(x).B.AIOLB)
/*@}*/

/*!
 * @name Register ASRC_ASRSTR, field AIOLC[16] (RO)
 *
 * Pair C Input Task Overload When set, this bit indicates that pair C input
 * task is oveloaded. This may help to check the reason why overload interrupt
 * happens. The bit is cleared when writing ASRSTR:AOLE as 1.
 */
/*@{*/
#define BP_ASRC_ASRSTR_AIOLC (16U)         /*!< Bit position for ASRC_ASRSTR_AIOLC. */
#define BM_ASRC_ASRSTR_AIOLC (0x00010000U) /*!< Bit mask for ASRC_ASRSTR_AIOLC. */
#define BS_ASRC_ASRSTR_AIOLC (1U)          /*!< Bit field size in bits for ASRC_ASRSTR_AIOLC. */

/*! @brief Read current value of the ASRC_ASRSTR_AIOLC field. */
#define BR_ASRC_ASRSTR_AIOLC(x) (HW_ASRC_ASRSTR(x).B.AIOLC)
/*@}*/

/*!
 * @name Register ASRC_ASRSTR, field AOOLA[17] (RO)
 *
 * Pair A Output Task Overload When set, this bit indicates that pair A output
 * task is oveloaded. This may help to check the reason why overload interrupt
 * happens. The bit is cleared when writing ASRSTR:AOLE as 1.
 */
/*@{*/
#define BP_ASRC_ASRSTR_AOOLA (17U)         /*!< Bit position for ASRC_ASRSTR_AOOLA. */
#define BM_ASRC_ASRSTR_AOOLA (0x00020000U) /*!< Bit mask for ASRC_ASRSTR_AOOLA. */
#define BS_ASRC_ASRSTR_AOOLA (1U)          /*!< Bit field size in bits for ASRC_ASRSTR_AOOLA. */

/*! @brief Read current value of the ASRC_ASRSTR_AOOLA field. */
#define BR_ASRC_ASRSTR_AOOLA(x) (HW_ASRC_ASRSTR(x).B.AOOLA)
/*@}*/

/*!
 * @name Register ASRC_ASRSTR, field AOOLB[18] (RO)
 *
 * Pair B Output Task Overload When set, this bit indicates that pair B output
 * task is oveloaded. This may help to check the reason why overload interrupt
 * happens. The bit is cleared when writing ASRSTR:AOLE as 1.
 */
/*@{*/
#define BP_ASRC_ASRSTR_AOOLB (18U)         /*!< Bit position for ASRC_ASRSTR_AOOLB. */
#define BM_ASRC_ASRSTR_AOOLB (0x00040000U) /*!< Bit mask for ASRC_ASRSTR_AOOLB. */
#define BS_ASRC_ASRSTR_AOOLB (1U)          /*!< Bit field size in bits for ASRC_ASRSTR_AOOLB. */

/*! @brief Read current value of the ASRC_ASRSTR_AOOLB field. */
#define BR_ASRC_ASRSTR_AOOLB(x) (HW_ASRC_ASRSTR(x).B.AOOLB)
/*@}*/

/*!
 * @name Register ASRC_ASRSTR, field AOOLC[19] (RO)
 *
 * Pair C Output Task Overload When set, this bit indicates that pair C output
 * task is oveloaded. This may help to check the reason why overload interrupt
 * happens. The bit is cleared when writing ASRSTR:AOLE as 1.
 */
/*@{*/
#define BP_ASRC_ASRSTR_AOOLC (19U)         /*!< Bit position for ASRC_ASRSTR_AOOLC. */
#define BM_ASRC_ASRSTR_AOOLC (0x00080000U) /*!< Bit mask for ASRC_ASRSTR_AOOLC. */
#define BS_ASRC_ASRSTR_AOOLC (1U)          /*!< Bit field size in bits for ASRC_ASRSTR_AOOLC. */

/*! @brief Read current value of the ASRC_ASRSTR_AOOLC field. */
#define BR_ASRC_ASRSTR_AOOLC(x) (HW_ASRC_ASRSTR(x).B.AOOLC)
/*@}*/

/*!
 * @name Register ASRC_ASRSTR, field ATQOL[20] (RO)
 *
 * Task Queue FIFO overload When set, this bit indicates that task queue FIFO
 * logic is oveloaded. This may help to check the reason why overload interrupt
 * happens. The bit is cleared when writing ASRSTR:AOLE as 1.
 */
/*@{*/
#define BP_ASRC_ASRSTR_ATQOL (20U)         /*!< Bit position for ASRC_ASRSTR_ATQOL. */
#define BM_ASRC_ASRSTR_ATQOL (0x00100000U) /*!< Bit mask for ASRC_ASRSTR_ATQOL. */
#define BS_ASRC_ASRSTR_ATQOL (1U)          /*!< Bit field size in bits for ASRC_ASRSTR_ATQOL. */

/*! @brief Read current value of the ASRC_ASRSTR_ATQOL field. */
#define BR_ASRC_ASRSTR_ATQOL(x) (HW_ASRC_ASRSTR(x).B.ATQOL)
/*@}*/

/*!
 * @name Register ASRC_ASRSTR, field DSLCNT[21] (RO)
 *
 * DSL Counter Input to FIFO ready When set, this bit indicates that new DSL
 * counter information is stored in the internal ASRC FIFO. When clear, this bit
 * indicates that new DSL counter information is in the process of storage into the
 * internal ASRC FIFO. When ASRIER:AFPWE=1, the rising edge of this signal will
 * propose an interrupt request. Writing any value with this bit set will clear
 * the interrupt request proposed by the rising edge of this bit.
 */
/*@{*/
#define BP_ASRC_ASRSTR_DSLCNT (21U)        /*!< Bit position for ASRC_ASRSTR_DSLCNT. */
#define BM_ASRC_ASRSTR_DSLCNT (0x00200000U) /*!< Bit mask for ASRC_ASRSTR_DSLCNT. */
#define BS_ASRC_ASRSTR_DSLCNT (1U)         /*!< Bit field size in bits for ASRC_ASRSTR_DSLCNT. */

/*! @brief Read current value of the ASRC_ASRSTR_DSLCNT field. */
#define BR_ASRC_ASRSTR_DSLCNT(x) (HW_ASRC_ASRSTR(x).B.DSLCNT)
/*@}*/

/*******************************************************************************
 * HW_ASRC_ASRPMn1 - ASRC Parameter Register n
 ******************************************************************************/

/*!
 * @brief HW_ASRC_ASRPMn1 - ASRC Parameter Register n (RW)
 *
 * Reset value: 0x00000000U
 *
 * Parameter registers determine the performance of ASRC. The parameter
 * registers must be initialized by software before ASRC is enabled. Recommended values
 * are given in ASRC Misc Control Register 1 for Pair CASRC Parameter Register n
 * below, ASRC Parameter Registers (ASRPM1~ASRPM5) Register Offset Access Reset
 * Value Recommend Value asrcpm1 0x40 R/W 0x00_0000 0x7fffff asrcpm2 0x44 R/W
 * 0x00_0000 0x255555 asrcpm3 0x48 R/W 0x00_0000 0xff7280 asrcpm4 0x4C R/W 0x00_0000
 * 0xff7280 asrcpm5 0x50 R/W 0x00_0000 0xff7280
 */
typedef union _hw_asrc_asrpmn1
{
    uint32_t U;
    struct _hw_asrc_asrpmn1_bitfields
    {
        uint32_t PARAMETER_VALUE : 24; /*!< [23:0]  */
        uint32_t RESERVED0 : 8;        /*!< [31:24] This is a 24-bit register the
                                        * upper byte is unimplemented. */
    } B;
} hw_asrc_asrpmn1_t;

/*!
 * @name Constants and macros for entire ASRC_ASRPMn1 register
 */
/*@{*/
#define HW_ASRC_ASRPMn1_ADDR(x)  ((uintptr_t)(x) + 0x40U)

#define HW_ASRC_ASRPMn1(x)       (*(__IO hw_asrc_asrpmn1_t *) HW_ASRC_ASRPMn1_ADDR(x))
#define HW_ASRC_ASRPMn1_RD(x)    (HW_ASRC_ASRPMn1(x).U)
#define HW_ASRC_ASRPMn1_WR(x, v) (HW_ASRC_ASRPMn1(x).U = (v))
#define HW_ASRC_ASRPMn1_SET(x, v) (HW_ASRC_ASRPMn1_WR(x, HW_ASRC_ASRPMn1_RD(x) |  (v)))
#define HW_ASRC_ASRPMn1_CLR(x, v) (HW_ASRC_ASRPMn1_WR(x, HW_ASRC_ASRPMn1_RD(x) & ~(v)))
#define HW_ASRC_ASRPMn1_TOG(x, v) (HW_ASRC_ASRPMn1_WR(x, HW_ASRC_ASRPMn1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ASRC_ASRPMn1 bitfields
 */

/*!
 * @name Register ASRC_ASRPMn1, field PARAMETER_VALUE[23:0] (RW)
 *
 * See recommended values table.
 */
/*@{*/
#define BP_ASRC_ASRPMn1_PARAMETER_VALUE (0U) /*!< Bit position for ASRC_ASRPMn1_PARAMETER_VALUE. */
#define BM_ASRC_ASRPMn1_PARAMETER_VALUE (0x00FFFFFFU) /*!< Bit mask for ASRC_ASRPMn1_PARAMETER_VALUE. */
#define BS_ASRC_ASRPMn1_PARAMETER_VALUE (24U) /*!< Bit field size in bits for ASRC_ASRPMn1_PARAMETER_VALUE. */

/*! @brief Read current value of the ASRC_ASRPMn1_PARAMETER_VALUE field. */
#define BR_ASRC_ASRPMn1_PARAMETER_VALUE(x) (HW_ASRC_ASRPMn1(x).B.PARAMETER_VALUE)

/*! @brief Format value for bitfield ASRC_ASRPMn1_PARAMETER_VALUE. */
#define BF_ASRC_ASRPMn1_PARAMETER_VALUE(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRPMn1_PARAMETER_VALUE) & BM_ASRC_ASRPMn1_PARAMETER_VALUE)

/*! @brief Set the PARAMETER_VALUE field to a new value. */
#define BW_ASRC_ASRPMn1_PARAMETER_VALUE(x, v) (HW_ASRC_ASRPMn1_WR(x, (HW_ASRC_ASRPMn1_RD(x) & ~BM_ASRC_ASRPMn1_PARAMETER_VALUE) | BF_ASRC_ASRPMn1_PARAMETER_VALUE(v)))
/*@}*/
/*******************************************************************************
 * HW_ASRC_ASRPMn2 - ASRC Parameter Register n
 ******************************************************************************/

/*!
 * @brief HW_ASRC_ASRPMn2 - ASRC Parameter Register n (RW)
 *
 * Reset value: 0x00000000U
 *
 * Parameter registers determine the performance of ASRC. The parameter
 * registers must be initialized by software before ASRC is enabled. Recommended values
 * are given in ASRC Misc Control Register 1 for Pair CASRC Parameter Register n
 * below, ASRC Parameter Registers (ASRPM1~ASRPM5) Register Offset Access Reset
 * Value Recommend Value asrcpm1 0x40 R/W 0x00_0000 0x7fffff asrcpm2 0x44 R/W
 * 0x00_0000 0x255555 asrcpm3 0x48 R/W 0x00_0000 0xff7280 asrcpm4 0x4C R/W 0x00_0000
 * 0xff7280 asrcpm5 0x50 R/W 0x00_0000 0xff7280
 */
typedef union _hw_asrc_asrpmn2
{
    uint32_t U;
    struct _hw_asrc_asrpmn2_bitfields
    {
        uint32_t PARAMETER_VALUE : 24; /*!< [23:0]  */
        uint32_t RESERVED0 : 8;        /*!< [31:24] This is a 24-bit register the
                                        * upper byte is unimplemented. */
    } B;
} hw_asrc_asrpmn2_t;

/*!
 * @name Constants and macros for entire ASRC_ASRPMn2 register
 */
/*@{*/
#define HW_ASRC_ASRPMn2_ADDR(x)  ((uintptr_t)(x) + 0x44U)

#define HW_ASRC_ASRPMn2(x)       (*(__IO hw_asrc_asrpmn2_t *) HW_ASRC_ASRPMn2_ADDR(x))
#define HW_ASRC_ASRPMn2_RD(x)    (HW_ASRC_ASRPMn2(x).U)
#define HW_ASRC_ASRPMn2_WR(x, v) (HW_ASRC_ASRPMn2(x).U = (v))
#define HW_ASRC_ASRPMn2_SET(x, v) (HW_ASRC_ASRPMn2_WR(x, HW_ASRC_ASRPMn2_RD(x) |  (v)))
#define HW_ASRC_ASRPMn2_CLR(x, v) (HW_ASRC_ASRPMn2_WR(x, HW_ASRC_ASRPMn2_RD(x) & ~(v)))
#define HW_ASRC_ASRPMn2_TOG(x, v) (HW_ASRC_ASRPMn2_WR(x, HW_ASRC_ASRPMn2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ASRC_ASRPMn2 bitfields
 */

/*!
 * @name Register ASRC_ASRPMn2, field PARAMETER_VALUE[23:0] (RW)
 *
 * See recommended values table.
 */
/*@{*/
#define BP_ASRC_ASRPMn2_PARAMETER_VALUE (0U) /*!< Bit position for ASRC_ASRPMn2_PARAMETER_VALUE. */
#define BM_ASRC_ASRPMn2_PARAMETER_VALUE (0x00FFFFFFU) /*!< Bit mask for ASRC_ASRPMn2_PARAMETER_VALUE. */
#define BS_ASRC_ASRPMn2_PARAMETER_VALUE (24U) /*!< Bit field size in bits for ASRC_ASRPMn2_PARAMETER_VALUE. */

/*! @brief Read current value of the ASRC_ASRPMn2_PARAMETER_VALUE field. */
#define BR_ASRC_ASRPMn2_PARAMETER_VALUE(x) (HW_ASRC_ASRPMn2(x).B.PARAMETER_VALUE)

/*! @brief Format value for bitfield ASRC_ASRPMn2_PARAMETER_VALUE. */
#define BF_ASRC_ASRPMn2_PARAMETER_VALUE(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRPMn2_PARAMETER_VALUE) & BM_ASRC_ASRPMn2_PARAMETER_VALUE)

/*! @brief Set the PARAMETER_VALUE field to a new value. */
#define BW_ASRC_ASRPMn2_PARAMETER_VALUE(x, v) (HW_ASRC_ASRPMn2_WR(x, (HW_ASRC_ASRPMn2_RD(x) & ~BM_ASRC_ASRPMn2_PARAMETER_VALUE) | BF_ASRC_ASRPMn2_PARAMETER_VALUE(v)))
/*@}*/
/*******************************************************************************
 * HW_ASRC_ASRPMn3 - ASRC Parameter Register n
 ******************************************************************************/

/*!
 * @brief HW_ASRC_ASRPMn3 - ASRC Parameter Register n (RW)
 *
 * Reset value: 0x00000000U
 *
 * Parameter registers determine the performance of ASRC. The parameter
 * registers must be initialized by software before ASRC is enabled. Recommended values
 * are given in ASRC Misc Control Register 1 for Pair CASRC Parameter Register n
 * below, ASRC Parameter Registers (ASRPM1~ASRPM5) Register Offset Access Reset
 * Value Recommend Value asrcpm1 0x40 R/W 0x00_0000 0x7fffff asrcpm2 0x44 R/W
 * 0x00_0000 0x255555 asrcpm3 0x48 R/W 0x00_0000 0xff7280 asrcpm4 0x4C R/W 0x00_0000
 * 0xff7280 asrcpm5 0x50 R/W 0x00_0000 0xff7280
 */
typedef union _hw_asrc_asrpmn3
{
    uint32_t U;
    struct _hw_asrc_asrpmn3_bitfields
    {
        uint32_t PARAMETER_VALUE : 24; /*!< [23:0]  */
        uint32_t RESERVED0 : 8;        /*!< [31:24] This is a 24-bit register the
                                        * upper byte is unimplemented. */
    } B;
} hw_asrc_asrpmn3_t;

/*!
 * @name Constants and macros for entire ASRC_ASRPMn3 register
 */
/*@{*/
#define HW_ASRC_ASRPMn3_ADDR(x)  ((uintptr_t)(x) + 0x48U)

#define HW_ASRC_ASRPMn3(x)       (*(__IO hw_asrc_asrpmn3_t *) HW_ASRC_ASRPMn3_ADDR(x))
#define HW_ASRC_ASRPMn3_RD(x)    (HW_ASRC_ASRPMn3(x).U)
#define HW_ASRC_ASRPMn3_WR(x, v) (HW_ASRC_ASRPMn3(x).U = (v))
#define HW_ASRC_ASRPMn3_SET(x, v) (HW_ASRC_ASRPMn3_WR(x, HW_ASRC_ASRPMn3_RD(x) |  (v)))
#define HW_ASRC_ASRPMn3_CLR(x, v) (HW_ASRC_ASRPMn3_WR(x, HW_ASRC_ASRPMn3_RD(x) & ~(v)))
#define HW_ASRC_ASRPMn3_TOG(x, v) (HW_ASRC_ASRPMn3_WR(x, HW_ASRC_ASRPMn3_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ASRC_ASRPMn3 bitfields
 */

/*!
 * @name Register ASRC_ASRPMn3, field PARAMETER_VALUE[23:0] (RW)
 *
 * See recommended values table.
 */
/*@{*/
#define BP_ASRC_ASRPMn3_PARAMETER_VALUE (0U) /*!< Bit position for ASRC_ASRPMn3_PARAMETER_VALUE. */
#define BM_ASRC_ASRPMn3_PARAMETER_VALUE (0x00FFFFFFU) /*!< Bit mask for ASRC_ASRPMn3_PARAMETER_VALUE. */
#define BS_ASRC_ASRPMn3_PARAMETER_VALUE (24U) /*!< Bit field size in bits for ASRC_ASRPMn3_PARAMETER_VALUE. */

/*! @brief Read current value of the ASRC_ASRPMn3_PARAMETER_VALUE field. */
#define BR_ASRC_ASRPMn3_PARAMETER_VALUE(x) (HW_ASRC_ASRPMn3(x).B.PARAMETER_VALUE)

/*! @brief Format value for bitfield ASRC_ASRPMn3_PARAMETER_VALUE. */
#define BF_ASRC_ASRPMn3_PARAMETER_VALUE(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRPMn3_PARAMETER_VALUE) & BM_ASRC_ASRPMn3_PARAMETER_VALUE)

/*! @brief Set the PARAMETER_VALUE field to a new value. */
#define BW_ASRC_ASRPMn3_PARAMETER_VALUE(x, v) (HW_ASRC_ASRPMn3_WR(x, (HW_ASRC_ASRPMn3_RD(x) & ~BM_ASRC_ASRPMn3_PARAMETER_VALUE) | BF_ASRC_ASRPMn3_PARAMETER_VALUE(v)))
/*@}*/
/*******************************************************************************
 * HW_ASRC_ASRPMn4 - ASRC Parameter Register n
 ******************************************************************************/

/*!
 * @brief HW_ASRC_ASRPMn4 - ASRC Parameter Register n (RW)
 *
 * Reset value: 0x00000000U
 *
 * Parameter registers determine the performance of ASRC. The parameter
 * registers must be initialized by software before ASRC is enabled. Recommended values
 * are given in ASRC Misc Control Register 1 for Pair CASRC Parameter Register n
 * below, ASRC Parameter Registers (ASRPM1~ASRPM5) Register Offset Access Reset
 * Value Recommend Value asrcpm1 0x40 R/W 0x00_0000 0x7fffff asrcpm2 0x44 R/W
 * 0x00_0000 0x255555 asrcpm3 0x48 R/W 0x00_0000 0xff7280 asrcpm4 0x4C R/W 0x00_0000
 * 0xff7280 asrcpm5 0x50 R/W 0x00_0000 0xff7280
 */
typedef union _hw_asrc_asrpmn4
{
    uint32_t U;
    struct _hw_asrc_asrpmn4_bitfields
    {
        uint32_t PARAMETER_VALUE : 24; /*!< [23:0]  */
        uint32_t RESERVED0 : 8;        /*!< [31:24] This is a 24-bit register the
                                        * upper byte is unimplemented. */
    } B;
} hw_asrc_asrpmn4_t;

/*!
 * @name Constants and macros for entire ASRC_ASRPMn4 register
 */
/*@{*/
#define HW_ASRC_ASRPMn4_ADDR(x)  ((uintptr_t)(x) + 0x4CU)

#define HW_ASRC_ASRPMn4(x)       (*(__IO hw_asrc_asrpmn4_t *) HW_ASRC_ASRPMn4_ADDR(x))
#define HW_ASRC_ASRPMn4_RD(x)    (HW_ASRC_ASRPMn4(x).U)
#define HW_ASRC_ASRPMn4_WR(x, v) (HW_ASRC_ASRPMn4(x).U = (v))
#define HW_ASRC_ASRPMn4_SET(x, v) (HW_ASRC_ASRPMn4_WR(x, HW_ASRC_ASRPMn4_RD(x) |  (v)))
#define HW_ASRC_ASRPMn4_CLR(x, v) (HW_ASRC_ASRPMn4_WR(x, HW_ASRC_ASRPMn4_RD(x) & ~(v)))
#define HW_ASRC_ASRPMn4_TOG(x, v) (HW_ASRC_ASRPMn4_WR(x, HW_ASRC_ASRPMn4_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ASRC_ASRPMn4 bitfields
 */

/*!
 * @name Register ASRC_ASRPMn4, field PARAMETER_VALUE[23:0] (RW)
 *
 * See recommended values table.
 */
/*@{*/
#define BP_ASRC_ASRPMn4_PARAMETER_VALUE (0U) /*!< Bit position for ASRC_ASRPMn4_PARAMETER_VALUE. */
#define BM_ASRC_ASRPMn4_PARAMETER_VALUE (0x00FFFFFFU) /*!< Bit mask for ASRC_ASRPMn4_PARAMETER_VALUE. */
#define BS_ASRC_ASRPMn4_PARAMETER_VALUE (24U) /*!< Bit field size in bits for ASRC_ASRPMn4_PARAMETER_VALUE. */

/*! @brief Read current value of the ASRC_ASRPMn4_PARAMETER_VALUE field. */
#define BR_ASRC_ASRPMn4_PARAMETER_VALUE(x) (HW_ASRC_ASRPMn4(x).B.PARAMETER_VALUE)

/*! @brief Format value for bitfield ASRC_ASRPMn4_PARAMETER_VALUE. */
#define BF_ASRC_ASRPMn4_PARAMETER_VALUE(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRPMn4_PARAMETER_VALUE) & BM_ASRC_ASRPMn4_PARAMETER_VALUE)

/*! @brief Set the PARAMETER_VALUE field to a new value. */
#define BW_ASRC_ASRPMn4_PARAMETER_VALUE(x, v) (HW_ASRC_ASRPMn4_WR(x, (HW_ASRC_ASRPMn4_RD(x) & ~BM_ASRC_ASRPMn4_PARAMETER_VALUE) | BF_ASRC_ASRPMn4_PARAMETER_VALUE(v)))
/*@}*/
/*******************************************************************************
 * HW_ASRC_ASRPMn5 - ASRC Parameter Register n
 ******************************************************************************/

/*!
 * @brief HW_ASRC_ASRPMn5 - ASRC Parameter Register n (RW)
 *
 * Reset value: 0x00000000U
 *
 * Parameter registers determine the performance of ASRC. The parameter
 * registers must be initialized by software before ASRC is enabled. Recommended values
 * are given in ASRC Misc Control Register 1 for Pair CASRC Parameter Register n
 * below, ASRC Parameter Registers (ASRPM1~ASRPM5) Register Offset Access Reset
 * Value Recommend Value asrcpm1 0x40 R/W 0x00_0000 0x7fffff asrcpm2 0x44 R/W
 * 0x00_0000 0x255555 asrcpm3 0x48 R/W 0x00_0000 0xff7280 asrcpm4 0x4C R/W 0x00_0000
 * 0xff7280 asrcpm5 0x50 R/W 0x00_0000 0xff7280
 */
typedef union _hw_asrc_asrpmn5
{
    uint32_t U;
    struct _hw_asrc_asrpmn5_bitfields
    {
        uint32_t PARAMETER_VALUE : 24; /*!< [23:0]  */
        uint32_t RESERVED0 : 8;        /*!< [31:24] This is a 24-bit register the
                                        * upper byte is unimplemented. */
    } B;
} hw_asrc_asrpmn5_t;

/*!
 * @name Constants and macros for entire ASRC_ASRPMn5 register
 */
/*@{*/
#define HW_ASRC_ASRPMn5_ADDR(x)  ((uintptr_t)(x) + 0x50U)

#define HW_ASRC_ASRPMn5(x)       (*(__IO hw_asrc_asrpmn5_t *) HW_ASRC_ASRPMn5_ADDR(x))
#define HW_ASRC_ASRPMn5_RD(x)    (HW_ASRC_ASRPMn5(x).U)
#define HW_ASRC_ASRPMn5_WR(x, v) (HW_ASRC_ASRPMn5(x).U = (v))
#define HW_ASRC_ASRPMn5_SET(x, v) (HW_ASRC_ASRPMn5_WR(x, HW_ASRC_ASRPMn5_RD(x) |  (v)))
#define HW_ASRC_ASRPMn5_CLR(x, v) (HW_ASRC_ASRPMn5_WR(x, HW_ASRC_ASRPMn5_RD(x) & ~(v)))
#define HW_ASRC_ASRPMn5_TOG(x, v) (HW_ASRC_ASRPMn5_WR(x, HW_ASRC_ASRPMn5_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ASRC_ASRPMn5 bitfields
 */

/*!
 * @name Register ASRC_ASRPMn5, field PARAMETER_VALUE[23:0] (RW)
 *
 * See recommended values table.
 */
/*@{*/
#define BP_ASRC_ASRPMn5_PARAMETER_VALUE (0U) /*!< Bit position for ASRC_ASRPMn5_PARAMETER_VALUE. */
#define BM_ASRC_ASRPMn5_PARAMETER_VALUE (0x00FFFFFFU) /*!< Bit mask for ASRC_ASRPMn5_PARAMETER_VALUE. */
#define BS_ASRC_ASRPMn5_PARAMETER_VALUE (24U) /*!< Bit field size in bits for ASRC_ASRPMn5_PARAMETER_VALUE. */

/*! @brief Read current value of the ASRC_ASRPMn5_PARAMETER_VALUE field. */
#define BR_ASRC_ASRPMn5_PARAMETER_VALUE(x) (HW_ASRC_ASRPMn5(x).B.PARAMETER_VALUE)

/*! @brief Format value for bitfield ASRC_ASRPMn5_PARAMETER_VALUE. */
#define BF_ASRC_ASRPMn5_PARAMETER_VALUE(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRPMn5_PARAMETER_VALUE) & BM_ASRC_ASRPMn5_PARAMETER_VALUE)

/*! @brief Set the PARAMETER_VALUE field to a new value. */
#define BW_ASRC_ASRPMn5_PARAMETER_VALUE(x, v) (HW_ASRC_ASRPMn5_WR(x, (HW_ASRC_ASRPMn5_RD(x) & ~BM_ASRC_ASRPMn5_PARAMETER_VALUE) | BF_ASRC_ASRPMn5_PARAMETER_VALUE(v)))
/*@}*/

/*******************************************************************************
 * HW_ASRC_ASRTFR1 - ASRC ASRC Task Queue FIFO Register 1
 ******************************************************************************/

/*!
 * @brief HW_ASRC_ASRTFR1 - ASRC ASRC Task Queue FIFO Register 1 (RW)
 *
 * Reset value: 0x00000000U
 *
 * The register defines and shows the parameters for ASRC inner task queue FIFOs.
 */
typedef union _hw_asrc_asrtfr1
{
    uint32_t U;
    struct _hw_asrc_asrtfr1_bitfields
    {
        uint32_t RESERVED0 : 6;        /*!< [5:0]  */
        uint32_t TF_BASE : 7;          /*!< [12:6]  */
        uint32_t TF_FILL : 7;          /*!< [19:13]  */
        uint32_t RESERVED1 : 12;       /*!< [31:20] This is a 24-bit register the
                                        * upper byte is unimplemented. */
    } B;
} hw_asrc_asrtfr1_t;

/*!
 * @name Constants and macros for entire ASRC_ASRTFR1 register
 */
/*@{*/
#define HW_ASRC_ASRTFR1_ADDR(x)  ((uintptr_t)(x) + 0x54U)

#define HW_ASRC_ASRTFR1(x)       (*(__IO hw_asrc_asrtfr1_t *) HW_ASRC_ASRTFR1_ADDR(x))
#define HW_ASRC_ASRTFR1_RD(x)    (HW_ASRC_ASRTFR1(x).U)
#define HW_ASRC_ASRTFR1_WR(x, v) (HW_ASRC_ASRTFR1(x).U = (v))
#define HW_ASRC_ASRTFR1_SET(x, v) (HW_ASRC_ASRTFR1_WR(x, HW_ASRC_ASRTFR1_RD(x) |  (v)))
#define HW_ASRC_ASRTFR1_CLR(x, v) (HW_ASRC_ASRTFR1_WR(x, HW_ASRC_ASRTFR1_RD(x) & ~(v)))
#define HW_ASRC_ASRTFR1_TOG(x, v) (HW_ASRC_ASRTFR1_WR(x, HW_ASRC_ASRTFR1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ASRC_ASRTFR1 bitfields
 */

/*!
 * @name Register ASRC_ASRTFR1, field TF_BASE[12:6] (RW)
 *
 * Base address for task queue FIFO. Set to 0x7C.
 */
/*@{*/
#define BP_ASRC_ASRTFR1_TF_BASE (6U)       /*!< Bit position for ASRC_ASRTFR1_TF_BASE. */
#define BM_ASRC_ASRTFR1_TF_BASE (0x00001FC0U) /*!< Bit mask for ASRC_ASRTFR1_TF_BASE. */
#define BS_ASRC_ASRTFR1_TF_BASE (7U)       /*!< Bit field size in bits for ASRC_ASRTFR1_TF_BASE. */

/*! @brief Read current value of the ASRC_ASRTFR1_TF_BASE field. */
#define BR_ASRC_ASRTFR1_TF_BASE(x) (HW_ASRC_ASRTFR1(x).B.TF_BASE)

/*! @brief Format value for bitfield ASRC_ASRTFR1_TF_BASE. */
#define BF_ASRC_ASRTFR1_TF_BASE(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRTFR1_TF_BASE) & BM_ASRC_ASRTFR1_TF_BASE)

/*! @brief Set the TF_BASE field to a new value. */
#define BW_ASRC_ASRTFR1_TF_BASE(x, v) (HW_ASRC_ASRTFR1_WR(x, (HW_ASRC_ASRTFR1_RD(x) & ~BM_ASRC_ASRTFR1_TF_BASE) | BF_ASRC_ASRTFR1_TF_BASE(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRTFR1, field TF_FILL[19:13] (RO)
 *
 * Current number of entries in task queue FIFO.
 */
/*@{*/
#define BP_ASRC_ASRTFR1_TF_FILL (13U)      /*!< Bit position for ASRC_ASRTFR1_TF_FILL. */
#define BM_ASRC_ASRTFR1_TF_FILL (0x000FE000U) /*!< Bit mask for ASRC_ASRTFR1_TF_FILL. */
#define BS_ASRC_ASRTFR1_TF_FILL (7U)       /*!< Bit field size in bits for ASRC_ASRTFR1_TF_FILL. */

/*! @brief Read current value of the ASRC_ASRTFR1_TF_FILL field. */
#define BR_ASRC_ASRTFR1_TF_FILL(x) (HW_ASRC_ASRTFR1(x).B.TF_FILL)
/*@}*/

/*******************************************************************************
 * HW_ASRC_ASRCCR - ASRC Channel Counter Register
 ******************************************************************************/

/*!
 * @brief HW_ASRC_ASRCCR - ASRC Channel Counter Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The ASRC channel counter register (ASRCCR) is a 24-bit read/write register
 * that sets and reflects the current specific input/output FIFO being accessed
 * through shared peripheral bus for each ASRC conversion pair.
 */
typedef union _hw_asrc_asrccr
{
    uint32_t U;
    struct _hw_asrc_asrccr_bitfields
    {
        uint32_t ACIA : 4;             /*!< [3:0]  */
        uint32_t ACIB : 4;             /*!< [7:4]  */
        uint32_t ACIC : 4;             /*!< [11:8]  */
        uint32_t ACOA : 4;             /*!< [15:12]  */
        uint32_t ACOB : 4;             /*!< [19:16]  */
        uint32_t ACOC : 4;             /*!< [23:20]  */
        uint32_t RESERVED0 : 8;        /*!< [31:24] This is a 24-bit register the
                                        * upper byte is unimplemented. */
    } B;
} hw_asrc_asrccr_t;

/*!
 * @name Constants and macros for entire ASRC_ASRCCR register
 */
/*@{*/
#define HW_ASRC_ASRCCR_ADDR(x)   ((uintptr_t)(x) + 0x5CU)

#define HW_ASRC_ASRCCR(x)        (*(__IO hw_asrc_asrccr_t *) HW_ASRC_ASRCCR_ADDR(x))
#define HW_ASRC_ASRCCR_RD(x)     (HW_ASRC_ASRCCR(x).U)
#define HW_ASRC_ASRCCR_WR(x, v)  (HW_ASRC_ASRCCR(x).U = (v))
#define HW_ASRC_ASRCCR_SET(x, v) (HW_ASRC_ASRCCR_WR(x, HW_ASRC_ASRCCR_RD(x) |  (v)))
#define HW_ASRC_ASRCCR_CLR(x, v) (HW_ASRC_ASRCCR_WR(x, HW_ASRC_ASRCCR_RD(x) & ~(v)))
#define HW_ASRC_ASRCCR_TOG(x, v) (HW_ASRC_ASRCCR_WR(x, HW_ASRC_ASRCCR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ASRC_ASRCCR bitfields
 */

/*!
 * @name Register ASRC_ASRCCR, field ACIA[3:0] (RW)
 *
 * The channel counter for Pair A's input FIFO These bits stand for the current
 * channel being accessed through shared peripheral bus for Pair A's input FIFO's
 * usage. The value can be any value between [0, ANCA-1]
 */
/*@{*/
#define BP_ASRC_ASRCCR_ACIA  (0U)          /*!< Bit position for ASRC_ASRCCR_ACIA. */
#define BM_ASRC_ASRCCR_ACIA  (0x0000000FU) /*!< Bit mask for ASRC_ASRCCR_ACIA. */
#define BS_ASRC_ASRCCR_ACIA  (4U)          /*!< Bit field size in bits for ASRC_ASRCCR_ACIA. */

/*! @brief Read current value of the ASRC_ASRCCR_ACIA field. */
#define BR_ASRC_ASRCCR_ACIA(x) (HW_ASRC_ASRCCR(x).B.ACIA)

/*! @brief Format value for bitfield ASRC_ASRCCR_ACIA. */
#define BF_ASRC_ASRCCR_ACIA(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCCR_ACIA) & BM_ASRC_ASRCCR_ACIA)

/*! @brief Set the ACIA field to a new value. */
#define BW_ASRC_ASRCCR_ACIA(x, v) (HW_ASRC_ASRCCR_WR(x, (HW_ASRC_ASRCCR_RD(x) & ~BM_ASRC_ASRCCR_ACIA) | BF_ASRC_ASRCCR_ACIA(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCCR, field ACIB[7:4] (RW)
 *
 * The channel counter for Pair B's input FIFO These bits stand for the current
 * channel being accessed through shared peripheral bus for Pair B's input FIFO's
 * usage. The value can be any value between [0, ANCB-1]
 */
/*@{*/
#define BP_ASRC_ASRCCR_ACIB  (4U)          /*!< Bit position for ASRC_ASRCCR_ACIB. */
#define BM_ASRC_ASRCCR_ACIB  (0x000000F0U) /*!< Bit mask for ASRC_ASRCCR_ACIB. */
#define BS_ASRC_ASRCCR_ACIB  (4U)          /*!< Bit field size in bits for ASRC_ASRCCR_ACIB. */

/*! @brief Read current value of the ASRC_ASRCCR_ACIB field. */
#define BR_ASRC_ASRCCR_ACIB(x) (HW_ASRC_ASRCCR(x).B.ACIB)

/*! @brief Format value for bitfield ASRC_ASRCCR_ACIB. */
#define BF_ASRC_ASRCCR_ACIB(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCCR_ACIB) & BM_ASRC_ASRCCR_ACIB)

/*! @brief Set the ACIB field to a new value. */
#define BW_ASRC_ASRCCR_ACIB(x, v) (HW_ASRC_ASRCCR_WR(x, (HW_ASRC_ASRCCR_RD(x) & ~BM_ASRC_ASRCCR_ACIB) | BF_ASRC_ASRCCR_ACIB(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCCR, field ACIC[11:8] (RW)
 *
 * The channel counter for Pair C's input FIFO These bits stand for the current
 * channel being accessed through shared peripheral bus for Pair C's input FIFO's
 * usage. The value can be any value between [0, ANCC-1]
 */
/*@{*/
#define BP_ASRC_ASRCCR_ACIC  (8U)          /*!< Bit position for ASRC_ASRCCR_ACIC. */
#define BM_ASRC_ASRCCR_ACIC  (0x00000F00U) /*!< Bit mask for ASRC_ASRCCR_ACIC. */
#define BS_ASRC_ASRCCR_ACIC  (4U)          /*!< Bit field size in bits for ASRC_ASRCCR_ACIC. */

/*! @brief Read current value of the ASRC_ASRCCR_ACIC field. */
#define BR_ASRC_ASRCCR_ACIC(x) (HW_ASRC_ASRCCR(x).B.ACIC)

/*! @brief Format value for bitfield ASRC_ASRCCR_ACIC. */
#define BF_ASRC_ASRCCR_ACIC(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCCR_ACIC) & BM_ASRC_ASRCCR_ACIC)

/*! @brief Set the ACIC field to a new value. */
#define BW_ASRC_ASRCCR_ACIC(x, v) (HW_ASRC_ASRCCR_WR(x, (HW_ASRC_ASRCCR_RD(x) & ~BM_ASRC_ASRCCR_ACIC) | BF_ASRC_ASRCCR_ACIC(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCCR, field ACOA[15:12] (RW)
 *
 * The channel counter for Pair A's output FIFO These bits stand for the current
 * channel being accessed through shared peripheral bus for Pair A's output
 * FIFO's usage. The value can be any value between [0, ANCA-1]
 */
/*@{*/
#define BP_ASRC_ASRCCR_ACOA  (12U)         /*!< Bit position for ASRC_ASRCCR_ACOA. */
#define BM_ASRC_ASRCCR_ACOA  (0x0000F000U) /*!< Bit mask for ASRC_ASRCCR_ACOA. */
#define BS_ASRC_ASRCCR_ACOA  (4U)          /*!< Bit field size in bits for ASRC_ASRCCR_ACOA. */

/*! @brief Read current value of the ASRC_ASRCCR_ACOA field. */
#define BR_ASRC_ASRCCR_ACOA(x) (HW_ASRC_ASRCCR(x).B.ACOA)

/*! @brief Format value for bitfield ASRC_ASRCCR_ACOA. */
#define BF_ASRC_ASRCCR_ACOA(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCCR_ACOA) & BM_ASRC_ASRCCR_ACOA)

/*! @brief Set the ACOA field to a new value. */
#define BW_ASRC_ASRCCR_ACOA(x, v) (HW_ASRC_ASRCCR_WR(x, (HW_ASRC_ASRCCR_RD(x) & ~BM_ASRC_ASRCCR_ACOA) | BF_ASRC_ASRCCR_ACOA(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCCR, field ACOB[19:16] (RW)
 *
 * The channel counter for Pair B's output FIFO These bits stand for the current
 * channel being accessed through shared peripheral bus for Pair B's output
 * FIFO's usage. The value can be any value between [0, ANCB-1]
 */
/*@{*/
#define BP_ASRC_ASRCCR_ACOB  (16U)         /*!< Bit position for ASRC_ASRCCR_ACOB. */
#define BM_ASRC_ASRCCR_ACOB  (0x000F0000U) /*!< Bit mask for ASRC_ASRCCR_ACOB. */
#define BS_ASRC_ASRCCR_ACOB  (4U)          /*!< Bit field size in bits for ASRC_ASRCCR_ACOB. */

/*! @brief Read current value of the ASRC_ASRCCR_ACOB field. */
#define BR_ASRC_ASRCCR_ACOB(x) (HW_ASRC_ASRCCR(x).B.ACOB)

/*! @brief Format value for bitfield ASRC_ASRCCR_ACOB. */
#define BF_ASRC_ASRCCR_ACOB(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCCR_ACOB) & BM_ASRC_ASRCCR_ACOB)

/*! @brief Set the ACOB field to a new value. */
#define BW_ASRC_ASRCCR_ACOB(x, v) (HW_ASRC_ASRCCR_WR(x, (HW_ASRC_ASRCCR_RD(x) & ~BM_ASRC_ASRCCR_ACOB) | BF_ASRC_ASRCCR_ACOB(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRCCR, field ACOC[23:20] (RW)
 *
 * The channel counter for Pair C's output FIFO These bits stand for the current
 * channel being accessed through shared peripheral bus for Pair C's output
 * FIFO's usage. The value can be any value between [0, ANCC-1]
 */
/*@{*/
#define BP_ASRC_ASRCCR_ACOC  (20U)         /*!< Bit position for ASRC_ASRCCR_ACOC. */
#define BM_ASRC_ASRCCR_ACOC  (0x00F00000U) /*!< Bit mask for ASRC_ASRCCR_ACOC. */
#define BS_ASRC_ASRCCR_ACOC  (4U)          /*!< Bit field size in bits for ASRC_ASRCCR_ACOC. */

/*! @brief Read current value of the ASRC_ASRCCR_ACOC field. */
#define BR_ASRC_ASRCCR_ACOC(x) (HW_ASRC_ASRCCR(x).B.ACOC)

/*! @brief Format value for bitfield ASRC_ASRCCR_ACOC. */
#define BF_ASRC_ASRCCR_ACOC(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRCCR_ACOC) & BM_ASRC_ASRCCR_ACOC)

/*! @brief Set the ACOC field to a new value. */
#define BW_ASRC_ASRCCR_ACOC(x, v) (HW_ASRC_ASRCCR_WR(x, (HW_ASRC_ASRCCR_RD(x) & ~BM_ASRC_ASRCCR_ACOC) | BF_ASRC_ASRCCR_ACOC(v)))
/*@}*/

/*******************************************************************************
 * HW_ASRC_ASRDIn - ASRC Data Input Register for Pair x
 ******************************************************************************/

/*!
 * @brief HW_ASRC_ASRDIn - ASRC Data Input Register for Pair x (WO)
 *
 * Reset value: 0x00000000U
 *
 * These registers are the interface registers for the audio data input of pair
 * A,B,C respectively. They are backed by FIFOs.
 */
typedef union _hw_asrc_asrdin
{
    uint32_t U;
    struct _hw_asrc_asrdin_bitfields
    {
        uint32_t DATA : 24;            /*!< [23:0]  */
        uint32_t RESERVED0 : 8;        /*!< [31:24] This is a 24-bit register the
                                        * upper byte is unimplemented. */
    } B;
} hw_asrc_asrdin_t;

/*!
 * @name Constants and macros for entire ASRC_ASRDIn register
 */
/*@{*/
#define HW_ASRC_ASRDIn_COUNT (3U)

#define HW_ASRC_ASRDIn_ADDR(x, n) ((uintptr_t)(x) + 0x60U + (0x8U * (n)))

#define HW_ASRC_ASRDIn(x, n)     (*(__O hw_asrc_asrdin_t *) HW_ASRC_ASRDIn_ADDR(x, n))
#define HW_ASRC_ASRDIn_WR(x, n, v) (HW_ASRC_ASRDIn(x, n).U = (v))
/*@}*/

/*
 * Constants & macros for individual ASRC_ASRDIn bitfields
 */

/*!
 * @name Register ASRC_ASRDIn, field DATA[23:0] (WO)
 *
 * Audio data input
 */
/*@{*/
#define BP_ASRC_ASRDIn_DATA  (0U)          /*!< Bit position for ASRC_ASRDIn_DATA. */
#define BM_ASRC_ASRDIn_DATA  (0x00FFFFFFU) /*!< Bit mask for ASRC_ASRDIn_DATA. */
#define BS_ASRC_ASRDIn_DATA  (24U)         /*!< Bit field size in bits for ASRC_ASRDIn_DATA. */

/*! @brief Format value for bitfield ASRC_ASRDIn_DATA. */
#define BF_ASRC_ASRDIn_DATA(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRDIn_DATA) & BM_ASRC_ASRDIn_DATA)
/*@}*/
/*******************************************************************************
 * HW_ASRC_ASRDOn - ASRC Data Output Register for Pair x
 ******************************************************************************/

/*!
 * @brief HW_ASRC_ASRDOn - ASRC Data Output Register for Pair x (RO)
 *
 * Reset value: 0x00000000U
 *
 * These registers are the interface registers for the audio data output of pair
 * A,B,C respectively. They are backed by FIFOs.
 */
typedef union _hw_asrc_asrdon
{
    uint32_t U;
    struct _hw_asrc_asrdon_bitfields
    {
        uint32_t DATA : 24;            /*!< [23:0]  */
        uint32_t RESERVED0 : 8;        /*!< [31:24] This is a 24-bit register the
                                        * upper byte is unimplemented. */
    } B;
} hw_asrc_asrdon_t;

/*!
 * @name Constants and macros for entire ASRC_ASRDOn register
 */
/*@{*/
#define HW_ASRC_ASRDOn_COUNT (3U)

#define HW_ASRC_ASRDOn_ADDR(x, n) ((uintptr_t)(x) + 0x64U + (0x8U * (n)))

#define HW_ASRC_ASRDOn(x, n)     (*(__I hw_asrc_asrdon_t *) HW_ASRC_ASRDOn_ADDR(x, n))
#define HW_ASRC_ASRDOn_RD(x, n)  (HW_ASRC_ASRDOn(x, n).U)
/*@}*/

/*
 * Constants & macros for individual ASRC_ASRDOn bitfields
 */

/*!
 * @name Register ASRC_ASRDOn, field DATA[23:0] (RO)
 *
 * Audio data output
 */
/*@{*/
#define BP_ASRC_ASRDOn_DATA  (0U)          /*!< Bit position for ASRC_ASRDOn_DATA. */
#define BM_ASRC_ASRDOn_DATA  (0x00FFFFFFU) /*!< Bit mask for ASRC_ASRDOn_DATA. */
#define BS_ASRC_ASRDOn_DATA  (24U)         /*!< Bit field size in bits for ASRC_ASRDOn_DATA. */

/*! @brief Read current value of the ASRC_ASRDOn_DATA field. */
#define BR_ASRC_ASRDOn_DATA(x, n) (HW_ASRC_ASRDOn(x, n).B.DATA)
/*@}*/

/*******************************************************************************
 * HW_ASRC_ASRIDRHA - ASRC Ideal Ratio for Pair A-High Part
 ******************************************************************************/

/*!
 * @brief HW_ASRC_ASRIDRHA - ASRC Ideal Ratio for Pair A-High Part (RW)
 *
 * Reset value: 0x00000000U
 *
 * The ideal ratio registers (ASRIDRHA, ASRIDRLA) hold the ratio value IDRATIOA.
 * IDRATIOA = FsinA/FsoutA = TsoutA/TsinA is a 32-bit fixed point value with 26
 * fractional bits. This value is only useful when ASRCTR:{USRA, IDRA}=2'b11.
 */
typedef union _hw_asrc_asridrha
{
    uint32_t U;
    struct _hw_asrc_asridrha_bitfields
    {
        uint32_t IDRATIOA : 8;         /*!< [7:0]  */
        uint32_t RESERVED0 : 24;       /*!< [31:8] This is a 24-bit register the
                                        * upper byte is unimplemented. */
    } B;
} hw_asrc_asridrha_t;

/*!
 * @name Constants and macros for entire ASRC_ASRIDRHA register
 */
/*@{*/
#define HW_ASRC_ASRIDRHA_ADDR(x) ((uintptr_t)(x) + 0x80U)

#define HW_ASRC_ASRIDRHA(x)      (*(__IO hw_asrc_asridrha_t *) HW_ASRC_ASRIDRHA_ADDR(x))
#define HW_ASRC_ASRIDRHA_RD(x)   (HW_ASRC_ASRIDRHA(x).U)
#define HW_ASRC_ASRIDRHA_WR(x, v) (HW_ASRC_ASRIDRHA(x).U = (v))
#define HW_ASRC_ASRIDRHA_SET(x, v) (HW_ASRC_ASRIDRHA_WR(x, HW_ASRC_ASRIDRHA_RD(x) |  (v)))
#define HW_ASRC_ASRIDRHA_CLR(x, v) (HW_ASRC_ASRIDRHA_WR(x, HW_ASRC_ASRIDRHA_RD(x) & ~(v)))
#define HW_ASRC_ASRIDRHA_TOG(x, v) (HW_ASRC_ASRIDRHA_WR(x, HW_ASRC_ASRIDRHA_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ASRC_ASRIDRHA bitfields
 */

/*!
 * @name Register ASRC_ASRIDRHA, field IDRATIOA[7:0] (RW)
 *
 * IDRATIOA[31:24]. High part of ideal ratio value for pair A
 */
/*@{*/
#define BP_ASRC_ASRIDRHA_IDRATIOA (0U)     /*!< Bit position for ASRC_ASRIDRHA_IDRATIOA. */
#define BM_ASRC_ASRIDRHA_IDRATIOA (0x000000FFU) /*!< Bit mask for ASRC_ASRIDRHA_IDRATIOA. */
#define BS_ASRC_ASRIDRHA_IDRATIOA (8U)     /*!< Bit field size in bits for ASRC_ASRIDRHA_IDRATIOA. */

/*! @brief Read current value of the ASRC_ASRIDRHA_IDRATIOA field. */
#define BR_ASRC_ASRIDRHA_IDRATIOA(x) (HW_ASRC_ASRIDRHA(x).B.IDRATIOA)

/*! @brief Format value for bitfield ASRC_ASRIDRHA_IDRATIOA. */
#define BF_ASRC_ASRIDRHA_IDRATIOA(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRIDRHA_IDRATIOA) & BM_ASRC_ASRIDRHA_IDRATIOA)

/*! @brief Set the IDRATIOA field to a new value. */
#define BW_ASRC_ASRIDRHA_IDRATIOA(x, v) (HW_ASRC_ASRIDRHA_WR(x, (HW_ASRC_ASRIDRHA_RD(x) & ~BM_ASRC_ASRIDRHA_IDRATIOA) | BF_ASRC_ASRIDRHA_IDRATIOA(v)))
/*@}*/

/*******************************************************************************
 * HW_ASRC_ASRIDRLA - ASRC Ideal Ratio for Pair A -Low Part
 ******************************************************************************/

/*!
 * @brief HW_ASRC_ASRIDRLA - ASRC Ideal Ratio for Pair A -Low Part (RW)
 *
 * Reset value: 0x00000000U
 *
 * The ideal ratio registers (ASRIDRHA, ASRIDRLA) hold the ratio value IDRATIOA.
 * IDRATIOA = FsinA/FsoutA = TsoutA/TsinA is a 32-bit fixed point value with 26
 * fractional bits. This value is only useful when ASRCTR:{USRA, IDRA}=2'b11.
 */
typedef union _hw_asrc_asridrla
{
    uint32_t U;
    struct _hw_asrc_asridrla_bitfields
    {
        uint32_t IDRATIOA : 24;        /*!< [23:0]  */
        uint32_t RESERVED0 : 8;        /*!< [31:24] This is a 24-bit register the
                                        * upper byte is unimplemented. */
    } B;
} hw_asrc_asridrla_t;

/*!
 * @name Constants and macros for entire ASRC_ASRIDRLA register
 */
/*@{*/
#define HW_ASRC_ASRIDRLA_ADDR(x) ((uintptr_t)(x) + 0x84U)

#define HW_ASRC_ASRIDRLA(x)      (*(__IO hw_asrc_asridrla_t *) HW_ASRC_ASRIDRLA_ADDR(x))
#define HW_ASRC_ASRIDRLA_RD(x)   (HW_ASRC_ASRIDRLA(x).U)
#define HW_ASRC_ASRIDRLA_WR(x, v) (HW_ASRC_ASRIDRLA(x).U = (v))
#define HW_ASRC_ASRIDRLA_SET(x, v) (HW_ASRC_ASRIDRLA_WR(x, HW_ASRC_ASRIDRLA_RD(x) |  (v)))
#define HW_ASRC_ASRIDRLA_CLR(x, v) (HW_ASRC_ASRIDRLA_WR(x, HW_ASRC_ASRIDRLA_RD(x) & ~(v)))
#define HW_ASRC_ASRIDRLA_TOG(x, v) (HW_ASRC_ASRIDRLA_WR(x, HW_ASRC_ASRIDRLA_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ASRC_ASRIDRLA bitfields
 */

/*!
 * @name Register ASRC_ASRIDRLA, field IDRATIOA[23:0] (RW)
 *
 * IDRATIOA[23:0]. Low part of ideal ratio value for pair A
 */
/*@{*/
#define BP_ASRC_ASRIDRLA_IDRATIOA (0U)     /*!< Bit position for ASRC_ASRIDRLA_IDRATIOA. */
#define BM_ASRC_ASRIDRLA_IDRATIOA (0x00FFFFFFU) /*!< Bit mask for ASRC_ASRIDRLA_IDRATIOA. */
#define BS_ASRC_ASRIDRLA_IDRATIOA (24U)    /*!< Bit field size in bits for ASRC_ASRIDRLA_IDRATIOA. */

/*! @brief Read current value of the ASRC_ASRIDRLA_IDRATIOA field. */
#define BR_ASRC_ASRIDRLA_IDRATIOA(x) (HW_ASRC_ASRIDRLA(x).B.IDRATIOA)

/*! @brief Format value for bitfield ASRC_ASRIDRLA_IDRATIOA. */
#define BF_ASRC_ASRIDRLA_IDRATIOA(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRIDRLA_IDRATIOA) & BM_ASRC_ASRIDRLA_IDRATIOA)

/*! @brief Set the IDRATIOA field to a new value. */
#define BW_ASRC_ASRIDRLA_IDRATIOA(x, v) (HW_ASRC_ASRIDRLA_WR(x, (HW_ASRC_ASRIDRLA_RD(x) & ~BM_ASRC_ASRIDRLA_IDRATIOA) | BF_ASRC_ASRIDRLA_IDRATIOA(v)))
/*@}*/

/*******************************************************************************
 * HW_ASRC_ASRIDRHB - ASRC Ideal Ratio for Pair B-High Part
 ******************************************************************************/

/*!
 * @brief HW_ASRC_ASRIDRHB - ASRC Ideal Ratio for Pair B-High Part (RW)
 *
 * Reset value: 0x00000000U
 *
 * The ideal ratio registers (ASRIDRHB, ASRIDRLB) hold the ratio value IDRATIOB.
 * IDRATIOB = FsinB/FsoutB = TsoutB/TsinB is a 32-bit fixed point value with 26
 * fractional bits. This value is only useful when ASRCTR:{USRB, IDRB}=2'b11.
 */
typedef union _hw_asrc_asridrhb
{
    uint32_t U;
    struct _hw_asrc_asridrhb_bitfields
    {
        uint32_t IDRATIOB : 8;         /*!< [7:0]  */
        uint32_t RESERVED0 : 24;       /*!< [31:8] This is a 24-bit register the
                                        * upper byte is unimplemented. */
    } B;
} hw_asrc_asridrhb_t;

/*!
 * @name Constants and macros for entire ASRC_ASRIDRHB register
 */
/*@{*/
#define HW_ASRC_ASRIDRHB_ADDR(x) ((uintptr_t)(x) + 0x88U)

#define HW_ASRC_ASRIDRHB(x)      (*(__IO hw_asrc_asridrhb_t *) HW_ASRC_ASRIDRHB_ADDR(x))
#define HW_ASRC_ASRIDRHB_RD(x)   (HW_ASRC_ASRIDRHB(x).U)
#define HW_ASRC_ASRIDRHB_WR(x, v) (HW_ASRC_ASRIDRHB(x).U = (v))
#define HW_ASRC_ASRIDRHB_SET(x, v) (HW_ASRC_ASRIDRHB_WR(x, HW_ASRC_ASRIDRHB_RD(x) |  (v)))
#define HW_ASRC_ASRIDRHB_CLR(x, v) (HW_ASRC_ASRIDRHB_WR(x, HW_ASRC_ASRIDRHB_RD(x) & ~(v)))
#define HW_ASRC_ASRIDRHB_TOG(x, v) (HW_ASRC_ASRIDRHB_WR(x, HW_ASRC_ASRIDRHB_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ASRC_ASRIDRHB bitfields
 */

/*!
 * @name Register ASRC_ASRIDRHB, field IDRATIOB[7:0] (RW)
 *
 * IDRATIOB[31:24]. High part of ideal ratio value for pair B.
 */
/*@{*/
#define BP_ASRC_ASRIDRHB_IDRATIOB (0U)     /*!< Bit position for ASRC_ASRIDRHB_IDRATIOB. */
#define BM_ASRC_ASRIDRHB_IDRATIOB (0x000000FFU) /*!< Bit mask for ASRC_ASRIDRHB_IDRATIOB. */
#define BS_ASRC_ASRIDRHB_IDRATIOB (8U)     /*!< Bit field size in bits for ASRC_ASRIDRHB_IDRATIOB. */

/*! @brief Read current value of the ASRC_ASRIDRHB_IDRATIOB field. */
#define BR_ASRC_ASRIDRHB_IDRATIOB(x) (HW_ASRC_ASRIDRHB(x).B.IDRATIOB)

/*! @brief Format value for bitfield ASRC_ASRIDRHB_IDRATIOB. */
#define BF_ASRC_ASRIDRHB_IDRATIOB(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRIDRHB_IDRATIOB) & BM_ASRC_ASRIDRHB_IDRATIOB)

/*! @brief Set the IDRATIOB field to a new value. */
#define BW_ASRC_ASRIDRHB_IDRATIOB(x, v) (HW_ASRC_ASRIDRHB_WR(x, (HW_ASRC_ASRIDRHB_RD(x) & ~BM_ASRC_ASRIDRHB_IDRATIOB) | BF_ASRC_ASRIDRHB_IDRATIOB(v)))
/*@}*/

/*******************************************************************************
 * HW_ASRC_ASRIDRLB - ASRC Ideal Ratio for Pair B-Low Part
 ******************************************************************************/

/*!
 * @brief HW_ASRC_ASRIDRLB - ASRC Ideal Ratio for Pair B-Low Part (RW)
 *
 * Reset value: 0x00000000U
 *
 * The ideal ratio registers (ASRIDRHB, ASRIDRLB) hold the ratio value IDRATIOB.
 * IDRATIOB = FsinB/FsoutB = TsoutB/TsinB is a 32-bit fixed point value with 26
 * fractional bits. This value is only useful when ASRCTR:{USRB, IDRB}=2'b11.
 */
typedef union _hw_asrc_asridrlb
{
    uint32_t U;
    struct _hw_asrc_asridrlb_bitfields
    {
        uint32_t IDRATIOB : 24;        /*!< [23:0]  */
        uint32_t RESERVED0 : 8;        /*!< [31:24] This is a 24-bit register the
                                        * upper byte is unimplemented. */
    } B;
} hw_asrc_asridrlb_t;

/*!
 * @name Constants and macros for entire ASRC_ASRIDRLB register
 */
/*@{*/
#define HW_ASRC_ASRIDRLB_ADDR(x) ((uintptr_t)(x) + 0x8CU)

#define HW_ASRC_ASRIDRLB(x)      (*(__IO hw_asrc_asridrlb_t *) HW_ASRC_ASRIDRLB_ADDR(x))
#define HW_ASRC_ASRIDRLB_RD(x)   (HW_ASRC_ASRIDRLB(x).U)
#define HW_ASRC_ASRIDRLB_WR(x, v) (HW_ASRC_ASRIDRLB(x).U = (v))
#define HW_ASRC_ASRIDRLB_SET(x, v) (HW_ASRC_ASRIDRLB_WR(x, HW_ASRC_ASRIDRLB_RD(x) |  (v)))
#define HW_ASRC_ASRIDRLB_CLR(x, v) (HW_ASRC_ASRIDRLB_WR(x, HW_ASRC_ASRIDRLB_RD(x) & ~(v)))
#define HW_ASRC_ASRIDRLB_TOG(x, v) (HW_ASRC_ASRIDRLB_WR(x, HW_ASRC_ASRIDRLB_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ASRC_ASRIDRLB bitfields
 */

/*!
 * @name Register ASRC_ASRIDRLB, field IDRATIOB[23:0] (RW)
 *
 * IDRATIOB[23:0]. Low part of ideal ratio value for pair B.
 */
/*@{*/
#define BP_ASRC_ASRIDRLB_IDRATIOB (0U)     /*!< Bit position for ASRC_ASRIDRLB_IDRATIOB. */
#define BM_ASRC_ASRIDRLB_IDRATIOB (0x00FFFFFFU) /*!< Bit mask for ASRC_ASRIDRLB_IDRATIOB. */
#define BS_ASRC_ASRIDRLB_IDRATIOB (24U)    /*!< Bit field size in bits for ASRC_ASRIDRLB_IDRATIOB. */

/*! @brief Read current value of the ASRC_ASRIDRLB_IDRATIOB field. */
#define BR_ASRC_ASRIDRLB_IDRATIOB(x) (HW_ASRC_ASRIDRLB(x).B.IDRATIOB)

/*! @brief Format value for bitfield ASRC_ASRIDRLB_IDRATIOB. */
#define BF_ASRC_ASRIDRLB_IDRATIOB(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRIDRLB_IDRATIOB) & BM_ASRC_ASRIDRLB_IDRATIOB)

/*! @brief Set the IDRATIOB field to a new value. */
#define BW_ASRC_ASRIDRLB_IDRATIOB(x, v) (HW_ASRC_ASRIDRLB_WR(x, (HW_ASRC_ASRIDRLB_RD(x) & ~BM_ASRC_ASRIDRLB_IDRATIOB) | BF_ASRC_ASRIDRLB_IDRATIOB(v)))
/*@}*/

/*******************************************************************************
 * HW_ASRC_ASRIDRHC - ASRC Ideal Ratio for Pair C-High Part
 ******************************************************************************/

/*!
 * @brief HW_ASRC_ASRIDRHC - ASRC Ideal Ratio for Pair C-High Part (RW)
 *
 * Reset value: 0x00000000U
 *
 * The ideal ratio registers (ASRIDRHC, ASRIDRLC) hold the ratio value IDRATIOC.
 * IDRATIOC = FsinC/FsoutC = TsoutC/TsinC is a 32-bit fixed point value with 26
 * fractional bits. This value is only useful when ASRCTR:{USRC, IDRC}=2'b11.
 */
typedef union _hw_asrc_asridrhc
{
    uint32_t U;
    struct _hw_asrc_asridrhc_bitfields
    {
        uint32_t IDRATIOC : 8;         /*!< [7:0]  */
        uint32_t RESERVED0 : 24;       /*!< [31:8] This is a 24-bit register the
                                        * upper byte is unimplemented. */
    } B;
} hw_asrc_asridrhc_t;

/*!
 * @name Constants and macros for entire ASRC_ASRIDRHC register
 */
/*@{*/
#define HW_ASRC_ASRIDRHC_ADDR(x) ((uintptr_t)(x) + 0x90U)

#define HW_ASRC_ASRIDRHC(x)      (*(__IO hw_asrc_asridrhc_t *) HW_ASRC_ASRIDRHC_ADDR(x))
#define HW_ASRC_ASRIDRHC_RD(x)   (HW_ASRC_ASRIDRHC(x).U)
#define HW_ASRC_ASRIDRHC_WR(x, v) (HW_ASRC_ASRIDRHC(x).U = (v))
#define HW_ASRC_ASRIDRHC_SET(x, v) (HW_ASRC_ASRIDRHC_WR(x, HW_ASRC_ASRIDRHC_RD(x) |  (v)))
#define HW_ASRC_ASRIDRHC_CLR(x, v) (HW_ASRC_ASRIDRHC_WR(x, HW_ASRC_ASRIDRHC_RD(x) & ~(v)))
#define HW_ASRC_ASRIDRHC_TOG(x, v) (HW_ASRC_ASRIDRHC_WR(x, HW_ASRC_ASRIDRHC_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ASRC_ASRIDRHC bitfields
 */

/*!
 * @name Register ASRC_ASRIDRHC, field IDRATIOC[7:0] (RW)
 *
 * IDRATIOC[31:24]. High part of ideal ratio value for pair C.
 */
/*@{*/
#define BP_ASRC_ASRIDRHC_IDRATIOC (0U)     /*!< Bit position for ASRC_ASRIDRHC_IDRATIOC. */
#define BM_ASRC_ASRIDRHC_IDRATIOC (0x000000FFU) /*!< Bit mask for ASRC_ASRIDRHC_IDRATIOC. */
#define BS_ASRC_ASRIDRHC_IDRATIOC (8U)     /*!< Bit field size in bits for ASRC_ASRIDRHC_IDRATIOC. */

/*! @brief Read current value of the ASRC_ASRIDRHC_IDRATIOC field. */
#define BR_ASRC_ASRIDRHC_IDRATIOC(x) (HW_ASRC_ASRIDRHC(x).B.IDRATIOC)

/*! @brief Format value for bitfield ASRC_ASRIDRHC_IDRATIOC. */
#define BF_ASRC_ASRIDRHC_IDRATIOC(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRIDRHC_IDRATIOC) & BM_ASRC_ASRIDRHC_IDRATIOC)

/*! @brief Set the IDRATIOC field to a new value. */
#define BW_ASRC_ASRIDRHC_IDRATIOC(x, v) (HW_ASRC_ASRIDRHC_WR(x, (HW_ASRC_ASRIDRHC_RD(x) & ~BM_ASRC_ASRIDRHC_IDRATIOC) | BF_ASRC_ASRIDRHC_IDRATIOC(v)))
/*@}*/

/*******************************************************************************
 * HW_ASRC_ASRIDRLC - ASRC Ideal Ratio for Pair C-Low Part
 ******************************************************************************/

/*!
 * @brief HW_ASRC_ASRIDRLC - ASRC Ideal Ratio for Pair C-Low Part (RW)
 *
 * Reset value: 0x00000000U
 *
 * The ideal ratio registers (ASRIDRHC, ASRIDRLC) hold the ratio value IDRATIOC.
 * IDRATIOC = FsinC/FsoutC = TsoutC/TsinC is a 32-bit fixed point value with 26
 * fractional bits. This value is only useful when ASRCTR:{USRC, IDRC}=2'b11.
 */
typedef union _hw_asrc_asridrlc
{
    uint32_t U;
    struct _hw_asrc_asridrlc_bitfields
    {
        uint32_t IDRATIOC : 24;        /*!< [23:0]  */
        uint32_t RESERVED0 : 8;        /*!< [31:24] This is a 24-bit register the
                                        * upper byte is unimplemented. */
    } B;
} hw_asrc_asridrlc_t;

/*!
 * @name Constants and macros for entire ASRC_ASRIDRLC register
 */
/*@{*/
#define HW_ASRC_ASRIDRLC_ADDR(x) ((uintptr_t)(x) + 0x94U)

#define HW_ASRC_ASRIDRLC(x)      (*(__IO hw_asrc_asridrlc_t *) HW_ASRC_ASRIDRLC_ADDR(x))
#define HW_ASRC_ASRIDRLC_RD(x)   (HW_ASRC_ASRIDRLC(x).U)
#define HW_ASRC_ASRIDRLC_WR(x, v) (HW_ASRC_ASRIDRLC(x).U = (v))
#define HW_ASRC_ASRIDRLC_SET(x, v) (HW_ASRC_ASRIDRLC_WR(x, HW_ASRC_ASRIDRLC_RD(x) |  (v)))
#define HW_ASRC_ASRIDRLC_CLR(x, v) (HW_ASRC_ASRIDRLC_WR(x, HW_ASRC_ASRIDRLC_RD(x) & ~(v)))
#define HW_ASRC_ASRIDRLC_TOG(x, v) (HW_ASRC_ASRIDRLC_WR(x, HW_ASRC_ASRIDRLC_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ASRC_ASRIDRLC bitfields
 */

/*!
 * @name Register ASRC_ASRIDRLC, field IDRATIOC[23:0] (RW)
 *
 * IDRATIOC[23:0]. Low part of ideal ratio value for pair C.
 */
/*@{*/
#define BP_ASRC_ASRIDRLC_IDRATIOC (0U)     /*!< Bit position for ASRC_ASRIDRLC_IDRATIOC. */
#define BM_ASRC_ASRIDRLC_IDRATIOC (0x00FFFFFFU) /*!< Bit mask for ASRC_ASRIDRLC_IDRATIOC. */
#define BS_ASRC_ASRIDRLC_IDRATIOC (24U)    /*!< Bit field size in bits for ASRC_ASRIDRLC_IDRATIOC. */

/*! @brief Read current value of the ASRC_ASRIDRLC_IDRATIOC field. */
#define BR_ASRC_ASRIDRLC_IDRATIOC(x) (HW_ASRC_ASRIDRLC(x).B.IDRATIOC)

/*! @brief Format value for bitfield ASRC_ASRIDRLC_IDRATIOC. */
#define BF_ASRC_ASRIDRLC_IDRATIOC(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRIDRLC_IDRATIOC) & BM_ASRC_ASRIDRLC_IDRATIOC)

/*! @brief Set the IDRATIOC field to a new value. */
#define BW_ASRC_ASRIDRLC_IDRATIOC(x, v) (HW_ASRC_ASRIDRLC_WR(x, (HW_ASRC_ASRIDRLC_RD(x) & ~BM_ASRC_ASRIDRLC_IDRATIOC) | BF_ASRC_ASRIDRLC_IDRATIOC(v)))
/*@}*/

/*******************************************************************************
 * HW_ASRC_ASR76K - ASRC 76kHz Period in terms of ASRC processing clock
 ******************************************************************************/

/*!
 * @brief HW_ASRC_ASR76K - ASRC 76kHz Period in terms of ASRC processing clock (RW)
 *
 * Reset value: 0x00000A47U
 *
 * The register (ASR76K) holds the period of the 76kHz sampling clock in terms
 * of the ASRC processing clock with frequency FsASRC. ASR76K = FsASRC/Fs76k.
 * Reset value is 0x0A47 which assumes that FsASRC=200MHz. This register is used to
 * help the ASRC internal logic to decide the pre-processing and the
 * post-processing options automatically (see ASRC Misc Control Register 1 for Pair CASRC
 * Control Register and ASRC Misc Control Register 1 for Pair CASRC Filter
 * Configuration Status Register ). In a system when FsASRC=133MHz, the value should be
 * assigned explicitly as 0x06D6 in user application code.
 */
typedef union _hw_asrc_asr76k
{
    uint32_t U;
    struct _hw_asrc_asr76k_bitfields
    {
        uint32_t ASR76K : 17;          /*!< [16:0]  */
        uint32_t RESERVED0 : 15;       /*!< [31:17] This is a 24-bit register the
                                        * upper byte is unimplemented. */
    } B;
} hw_asrc_asr76k_t;

/*!
 * @name Constants and macros for entire ASRC_ASR76K register
 */
/*@{*/
#define HW_ASRC_ASR76K_ADDR(x)   ((uintptr_t)(x) + 0x98U)

#define HW_ASRC_ASR76K(x)        (*(__IO hw_asrc_asr76k_t *) HW_ASRC_ASR76K_ADDR(x))
#define HW_ASRC_ASR76K_RD(x)     (HW_ASRC_ASR76K(x).U)
#define HW_ASRC_ASR76K_WR(x, v)  (HW_ASRC_ASR76K(x).U = (v))
#define HW_ASRC_ASR76K_SET(x, v) (HW_ASRC_ASR76K_WR(x, HW_ASRC_ASR76K_RD(x) |  (v)))
#define HW_ASRC_ASR76K_CLR(x, v) (HW_ASRC_ASR76K_WR(x, HW_ASRC_ASR76K_RD(x) & ~(v)))
#define HW_ASRC_ASR76K_TOG(x, v) (HW_ASRC_ASR76K_WR(x, HW_ASRC_ASR76K_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ASRC_ASR76K bitfields
 */

/*!
 * @name Register ASRC_ASR76K, field ASR76K[16:0] (RW)
 *
 * Value for the period of the 76kHz sampling clock.
 */
/*@{*/
#define BP_ASRC_ASR76K_ASR76K (0U)         /*!< Bit position for ASRC_ASR76K_ASR76K. */
#define BM_ASRC_ASR76K_ASR76K (0x0001FFFFU) /*!< Bit mask for ASRC_ASR76K_ASR76K. */
#define BS_ASRC_ASR76K_ASR76K (17U)        /*!< Bit field size in bits for ASRC_ASR76K_ASR76K. */

/*! @brief Read current value of the ASRC_ASR76K_ASR76K field. */
#define BR_ASRC_ASR76K_ASR76K(x) (HW_ASRC_ASR76K(x).B.ASR76K)

/*! @brief Format value for bitfield ASRC_ASR76K_ASR76K. */
#define BF_ASRC_ASR76K_ASR76K(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASR76K_ASR76K) & BM_ASRC_ASR76K_ASR76K)

/*! @brief Set the ASR76K field to a new value. */
#define BW_ASRC_ASR76K_ASR76K(x, v) (HW_ASRC_ASR76K_WR(x, (HW_ASRC_ASR76K_RD(x) & ~BM_ASRC_ASR76K_ASR76K) | BF_ASRC_ASR76K_ASR76K(v)))
/*@}*/

/*******************************************************************************
 * HW_ASRC_ASR56K - ASRC 56kHz Period in terms of ASRC processing clock
 ******************************************************************************/

/*!
 * @brief HW_ASRC_ASR56K - ASRC 56kHz Period in terms of ASRC processing clock (RW)
 *
 * Reset value: 0x00000DF3U
 *
 * The register (ASR56K) holds the period of the 56kHz sampling clock in terms
 * of the ASRC processing clock with frequency FsASRC. ASR56K = FsASRC/Fs56k.
 * Reset value is 0x0DF3 which assumes that FsASRC=200MHz. This register is used to
 * help the ASRC internal logic to decide the pre-processing and the
 * post-processing options automatically (see ASRC Misc Control Register 1 for Pair CASRC
 * Control Register and ASRC Misc Control Register 1 for Pair CASRC Filter
 * Configuration Status Register ). In a system when FsASRC=133MHz, the value should be
 * assigned explicitly as 0x0947 in user application code.
 */
typedef union _hw_asrc_asr56k
{
    uint32_t U;
    struct _hw_asrc_asr56k_bitfields
    {
        uint32_t ASR56K : 17;          /*!< [16:0]  */
        uint32_t RESERVED0 : 15;       /*!< [31:17] This is a 24-bit register the
                                        * upper byte is unimplemented. */
    } B;
} hw_asrc_asr56k_t;

/*!
 * @name Constants and macros for entire ASRC_ASR56K register
 */
/*@{*/
#define HW_ASRC_ASR56K_ADDR(x)   ((uintptr_t)(x) + 0x9CU)

#define HW_ASRC_ASR56K(x)        (*(__IO hw_asrc_asr56k_t *) HW_ASRC_ASR56K_ADDR(x))
#define HW_ASRC_ASR56K_RD(x)     (HW_ASRC_ASR56K(x).U)
#define HW_ASRC_ASR56K_WR(x, v)  (HW_ASRC_ASR56K(x).U = (v))
#define HW_ASRC_ASR56K_SET(x, v) (HW_ASRC_ASR56K_WR(x, HW_ASRC_ASR56K_RD(x) |  (v)))
#define HW_ASRC_ASR56K_CLR(x, v) (HW_ASRC_ASR56K_WR(x, HW_ASRC_ASR56K_RD(x) & ~(v)))
#define HW_ASRC_ASR56K_TOG(x, v) (HW_ASRC_ASR56K_WR(x, HW_ASRC_ASR56K_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ASRC_ASR56K bitfields
 */

/*!
 * @name Register ASRC_ASR56K, field ASR56K[16:0] (RW)
 *
 * Value for the period of the 56kHz sampling clock
 */
/*@{*/
#define BP_ASRC_ASR56K_ASR56K (0U)         /*!< Bit position for ASRC_ASR56K_ASR56K. */
#define BM_ASRC_ASR56K_ASR56K (0x0001FFFFU) /*!< Bit mask for ASRC_ASR56K_ASR56K. */
#define BS_ASRC_ASR56K_ASR56K (17U)        /*!< Bit field size in bits for ASRC_ASR56K_ASR56K. */

/*! @brief Read current value of the ASRC_ASR56K_ASR56K field. */
#define BR_ASRC_ASR56K_ASR56K(x) (HW_ASRC_ASR56K(x).B.ASR56K)

/*! @brief Format value for bitfield ASRC_ASR56K_ASR56K. */
#define BF_ASRC_ASR56K_ASR56K(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASR56K_ASR56K) & BM_ASRC_ASR56K_ASR56K)

/*! @brief Set the ASR56K field to a new value. */
#define BW_ASRC_ASR56K_ASR56K(x, v) (HW_ASRC_ASR56K_WR(x, (HW_ASRC_ASR56K_RD(x) & ~BM_ASRC_ASR56K_ASR56K) | BF_ASRC_ASR56K_ASR56K(v)))
/*@}*/

/*******************************************************************************
 * HW_ASRC_ASRMCRA - ASRC Misc Control Register for Pair A
 ******************************************************************************/

/*!
 * @brief HW_ASRC_ASRMCRA - ASRC Misc Control Register for Pair A (RW)
 *
 * Reset value: 0x00000000U
 *
 * The register (ASRMCRA) is used to control Pair A internal logic.
 */
typedef union _hw_asrc_asrmcra
{
    uint32_t U;
    struct _hw_asrc_asrmcra_bitfields
    {
        uint32_t INFIFO_THRESHOLDA : 6; /*!< [5:0]  */
        uint32_t RESERVED0 : 4;        /*!< [9:6]  */
        uint32_t RSYNOFA : 1;          /*!< [10]  */
        uint32_t RSYNIFA : 1;          /*!< [11]  */
        uint32_t OUTFIFO_THRESHOLDA : 6; /*!< [17:12]  */
        uint32_t RESERVED1 : 2;        /*!< [19:18]  */
        uint32_t BYPASSPOLYA : 1;      /*!< [20]  */
        uint32_t BUFSTALLA : 1;        /*!< [21]  */
        uint32_t EXTTHRSHA : 1;        /*!< [22]  */
        uint32_t ZEROBUFA : 1;         /*!< [23]  */
        uint32_t RESERVED2 : 8;        /*!< [31:24] This is a 24-bit register the
                                        * upper byte is unimplemented. */
    } B;
} hw_asrc_asrmcra_t;

/*!
 * @name Constants and macros for entire ASRC_ASRMCRA register
 */
/*@{*/
#define HW_ASRC_ASRMCRA_ADDR(x)  ((uintptr_t)(x) + 0xA0U)

#define HW_ASRC_ASRMCRA(x)       (*(__IO hw_asrc_asrmcra_t *) HW_ASRC_ASRMCRA_ADDR(x))
#define HW_ASRC_ASRMCRA_RD(x)    (HW_ASRC_ASRMCRA(x).U)
#define HW_ASRC_ASRMCRA_WR(x, v) (HW_ASRC_ASRMCRA(x).U = (v))
#define HW_ASRC_ASRMCRA_SET(x, v) (HW_ASRC_ASRMCRA_WR(x, HW_ASRC_ASRMCRA_RD(x) |  (v)))
#define HW_ASRC_ASRMCRA_CLR(x, v) (HW_ASRC_ASRMCRA_WR(x, HW_ASRC_ASRMCRA_RD(x) & ~(v)))
#define HW_ASRC_ASRMCRA_TOG(x, v) (HW_ASRC_ASRMCRA_WR(x, HW_ASRC_ASRMCRA_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ASRC_ASRMCRA bitfields
 */

/*!
 * @name Register ASRC_ASRMCRA, field INFIFO_THRESHOLDA[5:0] (RW)
 *
 * The threshold for Pair A's input FIFO per channel These bits stand for the
 * threshold for Pair A's input FIFO per channel. Possible range is [0,63]. When
 * the value is n, it means that: when the number of input FIFO fillings of the
 * pair is less than n samples per channel, the input data needed flag is set; when
 * the number of input FIFO fillings of the pair is greater than or equal to n
 * samples per channel, the input data needed flag is automatically cleared.
 */
/*@{*/
#define BP_ASRC_ASRMCRA_INFIFO_THRESHOLDA (0U) /*!< Bit position for ASRC_ASRMCRA_INFIFO_THRESHOLDA. */
#define BM_ASRC_ASRMCRA_INFIFO_THRESHOLDA (0x0000003FU) /*!< Bit mask for ASRC_ASRMCRA_INFIFO_THRESHOLDA. */
#define BS_ASRC_ASRMCRA_INFIFO_THRESHOLDA (6U) /*!< Bit field size in bits for ASRC_ASRMCRA_INFIFO_THRESHOLDA. */

/*! @brief Read current value of the ASRC_ASRMCRA_INFIFO_THRESHOLDA field. */
#define BR_ASRC_ASRMCRA_INFIFO_THRESHOLDA(x) (HW_ASRC_ASRMCRA(x).B.INFIFO_THRESHOLDA)

/*! @brief Format value for bitfield ASRC_ASRMCRA_INFIFO_THRESHOLDA. */
#define BF_ASRC_ASRMCRA_INFIFO_THRESHOLDA(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRMCRA_INFIFO_THRESHOLDA) & BM_ASRC_ASRMCRA_INFIFO_THRESHOLDA)

/*! @brief Set the INFIFO_THRESHOLDA field to a new value. */
#define BW_ASRC_ASRMCRA_INFIFO_THRESHOLDA(x, v) (HW_ASRC_ASRMCRA_WR(x, (HW_ASRC_ASRMCRA_RD(x) & ~BM_ASRC_ASRMCRA_INFIFO_THRESHOLDA) | BF_ASRC_ASRMCRA_INFIFO_THRESHOLDA(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRMCRA, field RSYNOFA[10] (RW)
 *
 * Re-sync Output FIFO Channel Counter If bit set, force ASRCCR:ACOA=0. If bit
 * clear, untouch ASRCCR:ACOA.
 */
/*@{*/
#define BP_ASRC_ASRMCRA_RSYNOFA (10U)      /*!< Bit position for ASRC_ASRMCRA_RSYNOFA. */
#define BM_ASRC_ASRMCRA_RSYNOFA (0x00000400U) /*!< Bit mask for ASRC_ASRMCRA_RSYNOFA. */
#define BS_ASRC_ASRMCRA_RSYNOFA (1U)       /*!< Bit field size in bits for ASRC_ASRMCRA_RSYNOFA. */

/*! @brief Read current value of the ASRC_ASRMCRA_RSYNOFA field. */
#define BR_ASRC_ASRMCRA_RSYNOFA(x) (HW_ASRC_ASRMCRA(x).B.RSYNOFA)

/*! @brief Format value for bitfield ASRC_ASRMCRA_RSYNOFA. */
#define BF_ASRC_ASRMCRA_RSYNOFA(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRMCRA_RSYNOFA) & BM_ASRC_ASRMCRA_RSYNOFA)

/*! @brief Set the RSYNOFA field to a new value. */
#define BW_ASRC_ASRMCRA_RSYNOFA(x, v) (HW_ASRC_ASRMCRA_WR(x, (HW_ASRC_ASRMCRA_RD(x) & ~BM_ASRC_ASRMCRA_RSYNOFA) | BF_ASRC_ASRMCRA_RSYNOFA(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRMCRA, field RSYNIFA[11] (RW)
 *
 * Re-sync Input FIFO Channel Counter If bit set, force ASRCCR:ACIA=0. If bit
 * clear, untouch ASRCCR:ACIA.
 */
/*@{*/
#define BP_ASRC_ASRMCRA_RSYNIFA (11U)      /*!< Bit position for ASRC_ASRMCRA_RSYNIFA. */
#define BM_ASRC_ASRMCRA_RSYNIFA (0x00000800U) /*!< Bit mask for ASRC_ASRMCRA_RSYNIFA. */
#define BS_ASRC_ASRMCRA_RSYNIFA (1U)       /*!< Bit field size in bits for ASRC_ASRMCRA_RSYNIFA. */

/*! @brief Read current value of the ASRC_ASRMCRA_RSYNIFA field. */
#define BR_ASRC_ASRMCRA_RSYNIFA(x) (HW_ASRC_ASRMCRA(x).B.RSYNIFA)

/*! @brief Format value for bitfield ASRC_ASRMCRA_RSYNIFA. */
#define BF_ASRC_ASRMCRA_RSYNIFA(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRMCRA_RSYNIFA) & BM_ASRC_ASRMCRA_RSYNIFA)

/*! @brief Set the RSYNIFA field to a new value. */
#define BW_ASRC_ASRMCRA_RSYNIFA(x, v) (HW_ASRC_ASRMCRA_WR(x, (HW_ASRC_ASRMCRA_RD(x) & ~BM_ASRC_ASRMCRA_RSYNIFA) | BF_ASRC_ASRMCRA_RSYNIFA(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRMCRA, field OUTFIFO_THRESHOLDA[17:12] (RW)
 *
 * The threshold for Pair A's output FIFO per channel These bits stand for the
 * threshold for Pair A's output FIFO per channel. Possible range is [0,63]. When
 * the value is n, it means that: when the number of output FIFO fillings of the
 * pair is greater than n samples per channel, the output data ready flag is set;
 * when the number of output FIFO fillings of the pair is less than or equal to
 * n samples per channel, the output data ready flag is automatically cleared.
 */
/*@{*/
#define BP_ASRC_ASRMCRA_OUTFIFO_THRESHOLDA (12U) /*!< Bit position for ASRC_ASRMCRA_OUTFIFO_THRESHOLDA. */
#define BM_ASRC_ASRMCRA_OUTFIFO_THRESHOLDA (0x0003F000U) /*!< Bit mask for ASRC_ASRMCRA_OUTFIFO_THRESHOLDA. */
#define BS_ASRC_ASRMCRA_OUTFIFO_THRESHOLDA (6U) /*!< Bit field size in bits for ASRC_ASRMCRA_OUTFIFO_THRESHOLDA. */

/*! @brief Read current value of the ASRC_ASRMCRA_OUTFIFO_THRESHOLDA field. */
#define BR_ASRC_ASRMCRA_OUTFIFO_THRESHOLDA(x) (HW_ASRC_ASRMCRA(x).B.OUTFIFO_THRESHOLDA)

/*! @brief Format value for bitfield ASRC_ASRMCRA_OUTFIFO_THRESHOLDA. */
#define BF_ASRC_ASRMCRA_OUTFIFO_THRESHOLDA(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRMCRA_OUTFIFO_THRESHOLDA) & BM_ASRC_ASRMCRA_OUTFIFO_THRESHOLDA)

/*! @brief Set the OUTFIFO_THRESHOLDA field to a new value. */
#define BW_ASRC_ASRMCRA_OUTFIFO_THRESHOLDA(x, v) (HW_ASRC_ASRMCRA_WR(x, (HW_ASRC_ASRMCRA_RD(x) & ~BM_ASRC_ASRMCRA_OUTFIFO_THRESHOLDA) | BF_ASRC_ASRMCRA_OUTFIFO_THRESHOLDA(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRMCRA, field BYPASSPOLYA[20] (RW)
 *
 * Bypass Polyphase Filtering for Pair A This bit will determine whether the
 * polyphase filtering part of Pair A conversion will be bypassed.
 *
 * Values:
 * - 1 - Bypass polyphase filtering.
 * - 0 - Don't bypass polyphase filtering.
 */
/*@{*/
#define BP_ASRC_ASRMCRA_BYPASSPOLYA (20U)  /*!< Bit position for ASRC_ASRMCRA_BYPASSPOLYA. */
#define BM_ASRC_ASRMCRA_BYPASSPOLYA (0x00100000U) /*!< Bit mask for ASRC_ASRMCRA_BYPASSPOLYA. */
#define BS_ASRC_ASRMCRA_BYPASSPOLYA (1U)   /*!< Bit field size in bits for ASRC_ASRMCRA_BYPASSPOLYA. */

/*! @brief Read current value of the ASRC_ASRMCRA_BYPASSPOLYA field. */
#define BR_ASRC_ASRMCRA_BYPASSPOLYA(x) (HW_ASRC_ASRMCRA(x).B.BYPASSPOLYA)

/*! @brief Format value for bitfield ASRC_ASRMCRA_BYPASSPOLYA. */
#define BF_ASRC_ASRMCRA_BYPASSPOLYA(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRMCRA_BYPASSPOLYA) & BM_ASRC_ASRMCRA_BYPASSPOLYA)

/*! @brief Set the BYPASSPOLYA field to a new value. */
#define BW_ASRC_ASRMCRA_BYPASSPOLYA(x, v) (HW_ASRC_ASRMCRA_WR(x, (HW_ASRC_ASRMCRA_RD(x) & ~BM_ASRC_ASRMCRA_BYPASSPOLYA) | BF_ASRC_ASRMCRA_BYPASSPOLYA(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRMCRA, field BUFSTALLA[21] (RW)
 *
 * Stall Pair A conversion in case of Buffer Near Empty/Full Condition This bit
 * will determine whether the near empty/full FIFO condition will stall the rate
 * conversion for pair A. This option can only work when external ratio is used.
 * Near empty condition is the condition when input FIFO has less than 4 useful
 * samples per channel. Near full condition is the condition when the output FIFO
 * has less than 4 vacant sample words to fill per channel.
 *
 * Values:
 * - 1 - Stall Pair A conversion in case of near empty/full FIFO conditions.
 * - 0 - Don't stall Pair A conversion even in case of near empty/full FIFO
 *     conditions.
 */
/*@{*/
#define BP_ASRC_ASRMCRA_BUFSTALLA (21U)    /*!< Bit position for ASRC_ASRMCRA_BUFSTALLA. */
#define BM_ASRC_ASRMCRA_BUFSTALLA (0x00200000U) /*!< Bit mask for ASRC_ASRMCRA_BUFSTALLA. */
#define BS_ASRC_ASRMCRA_BUFSTALLA (1U)     /*!< Bit field size in bits for ASRC_ASRMCRA_BUFSTALLA. */

/*! @brief Read current value of the ASRC_ASRMCRA_BUFSTALLA field. */
#define BR_ASRC_ASRMCRA_BUFSTALLA(x) (HW_ASRC_ASRMCRA(x).B.BUFSTALLA)

/*! @brief Format value for bitfield ASRC_ASRMCRA_BUFSTALLA. */
#define BF_ASRC_ASRMCRA_BUFSTALLA(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRMCRA_BUFSTALLA) & BM_ASRC_ASRMCRA_BUFSTALLA)

/*! @brief Set the BUFSTALLA field to a new value. */
#define BW_ASRC_ASRMCRA_BUFSTALLA(x, v) (HW_ASRC_ASRMCRA_WR(x, (HW_ASRC_ASRMCRA_RD(x) & ~BM_ASRC_ASRMCRA_BUFSTALLA) | BF_ASRC_ASRMCRA_BUFSTALLA(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRMCRA, field EXTTHRSHA[22] (RW)
 *
 * Use external thresholds for FIFO control of Pair A This bit will determine
 * whether the FIFO thresholds externally defined in this register is used to
 * control ASRC internal FIFO logic for pair A.
 *
 * Values:
 * - 1 - Use external defined thresholds.
 * - 0 - Use default thresholds.
 */
/*@{*/
#define BP_ASRC_ASRMCRA_EXTTHRSHA (22U)    /*!< Bit position for ASRC_ASRMCRA_EXTTHRSHA. */
#define BM_ASRC_ASRMCRA_EXTTHRSHA (0x00400000U) /*!< Bit mask for ASRC_ASRMCRA_EXTTHRSHA. */
#define BS_ASRC_ASRMCRA_EXTTHRSHA (1U)     /*!< Bit field size in bits for ASRC_ASRMCRA_EXTTHRSHA. */

/*! @brief Read current value of the ASRC_ASRMCRA_EXTTHRSHA field. */
#define BR_ASRC_ASRMCRA_EXTTHRSHA(x) (HW_ASRC_ASRMCRA(x).B.EXTTHRSHA)

/*! @brief Format value for bitfield ASRC_ASRMCRA_EXTTHRSHA. */
#define BF_ASRC_ASRMCRA_EXTTHRSHA(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRMCRA_EXTTHRSHA) & BM_ASRC_ASRMCRA_EXTTHRSHA)

/*! @brief Set the EXTTHRSHA field to a new value. */
#define BW_ASRC_ASRMCRA_EXTTHRSHA(x, v) (HW_ASRC_ASRMCRA_WR(x, (HW_ASRC_ASRMCRA_RD(x) & ~BM_ASRC_ASRMCRA_EXTTHRSHA) | BF_ASRC_ASRMCRA_EXTTHRSHA(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRMCRA, field ZEROBUFA[23] (RW)
 *
 * Initialize buf of Pair A when pair A is enabled. Always clear option. This
 * bit is used to control whether the buffer is to be zeroized when pair A is
 * enabled.
 *
 * Values:
 * - 1 - Don't zeroize the buffer
 * - 0 - Zeroize the buffer
 */
/*@{*/
#define BP_ASRC_ASRMCRA_ZEROBUFA (23U)     /*!< Bit position for ASRC_ASRMCRA_ZEROBUFA. */
#define BM_ASRC_ASRMCRA_ZEROBUFA (0x00800000U) /*!< Bit mask for ASRC_ASRMCRA_ZEROBUFA. */
#define BS_ASRC_ASRMCRA_ZEROBUFA (1U)      /*!< Bit field size in bits for ASRC_ASRMCRA_ZEROBUFA. */

/*! @brief Read current value of the ASRC_ASRMCRA_ZEROBUFA field. */
#define BR_ASRC_ASRMCRA_ZEROBUFA(x) (HW_ASRC_ASRMCRA(x).B.ZEROBUFA)

/*! @brief Format value for bitfield ASRC_ASRMCRA_ZEROBUFA. */
#define BF_ASRC_ASRMCRA_ZEROBUFA(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRMCRA_ZEROBUFA) & BM_ASRC_ASRMCRA_ZEROBUFA)

/*! @brief Set the ZEROBUFA field to a new value. */
#define BW_ASRC_ASRMCRA_ZEROBUFA(x, v) (HW_ASRC_ASRMCRA_WR(x, (HW_ASRC_ASRMCRA_RD(x) & ~BM_ASRC_ASRMCRA_ZEROBUFA) | BF_ASRC_ASRMCRA_ZEROBUFA(v)))
/*@}*/

/*******************************************************************************
 * HW_ASRC_ASRFSTA - ASRC FIFO Status Register for Pair A
 ******************************************************************************/

/*!
 * @brief HW_ASRC_ASRFSTA - ASRC FIFO Status Register for Pair A (RO)
 *
 * Reset value: 0x00000000U
 *
 * The register (ASRFSTA) is used to show Pair A internal FIFO conditions.
 */
typedef union _hw_asrc_asrfsta
{
    uint32_t U;
    struct _hw_asrc_asrfsta_bitfields
    {
        uint32_t INFIFO_FILLA : 7;     /*!< [6:0]  */
        uint32_t RESERVED0 : 4;        /*!< [10:7]  */
        uint32_t IAEA : 1;             /*!< [11]  */
        uint32_t OUTFIFO_FILLA : 7;    /*!< [18:12]  */
        uint32_t RESERVED1 : 4;        /*!< [22:19]  */
        uint32_t OAFA : 1;             /*!< [23]  */
        uint32_t RESERVED2 : 8;        /*!< [31:24] This is a 24-bit register the
                                        * upper byte is unimplemented. */
    } B;
} hw_asrc_asrfsta_t;

/*!
 * @name Constants and macros for entire ASRC_ASRFSTA register
 */
/*@{*/
#define HW_ASRC_ASRFSTA_ADDR(x)  ((uintptr_t)(x) + 0xA4U)

#define HW_ASRC_ASRFSTA(x)       (*(__I hw_asrc_asrfsta_t *) HW_ASRC_ASRFSTA_ADDR(x))
#define HW_ASRC_ASRFSTA_RD(x)    (HW_ASRC_ASRFSTA(x).U)
/*@}*/

/*
 * Constants & macros for individual ASRC_ASRFSTA bitfields
 */

/*!
 * @name Register ASRC_ASRFSTA, field INFIFO_FILLA[6:0] (RO)
 *
 * The fillings for Pair A's input FIFO per channel These bits stand for the
 * fillings for Pair A's input FIFO per channel. Possible range is [0,64].
 */
/*@{*/
#define BP_ASRC_ASRFSTA_INFIFO_FILLA (0U)  /*!< Bit position for ASRC_ASRFSTA_INFIFO_FILLA. */
#define BM_ASRC_ASRFSTA_INFIFO_FILLA (0x0000007FU) /*!< Bit mask for ASRC_ASRFSTA_INFIFO_FILLA. */
#define BS_ASRC_ASRFSTA_INFIFO_FILLA (7U)  /*!< Bit field size in bits for ASRC_ASRFSTA_INFIFO_FILLA. */

/*! @brief Read current value of the ASRC_ASRFSTA_INFIFO_FILLA field. */
#define BR_ASRC_ASRFSTA_INFIFO_FILLA(x) (HW_ASRC_ASRFSTA(x).B.INFIFO_FILLA)
/*@}*/

/*!
 * @name Register ASRC_ASRFSTA, field IAEA[11] (RO)
 *
 * Input FIFO is near Empty for Pair A This bit is to indicate whether the input
 * FIFO of Pair A is near empty.
 */
/*@{*/
#define BP_ASRC_ASRFSTA_IAEA (11U)         /*!< Bit position for ASRC_ASRFSTA_IAEA. */
#define BM_ASRC_ASRFSTA_IAEA (0x00000800U) /*!< Bit mask for ASRC_ASRFSTA_IAEA. */
#define BS_ASRC_ASRFSTA_IAEA (1U)          /*!< Bit field size in bits for ASRC_ASRFSTA_IAEA. */

/*! @brief Read current value of the ASRC_ASRFSTA_IAEA field. */
#define BR_ASRC_ASRFSTA_IAEA(x) (HW_ASRC_ASRFSTA(x).B.IAEA)
/*@}*/

/*!
 * @name Register ASRC_ASRFSTA, field OUTFIFO_FILLA[18:12] (RO)
 *
 * The fillings for Pair A's output FIFO per channel These bits stand for the
 * fillings for Pair A's output FIFO per channel. Possible range is [0,64].
 */
/*@{*/
#define BP_ASRC_ASRFSTA_OUTFIFO_FILLA (12U) /*!< Bit position for ASRC_ASRFSTA_OUTFIFO_FILLA. */
#define BM_ASRC_ASRFSTA_OUTFIFO_FILLA (0x0007F000U) /*!< Bit mask for ASRC_ASRFSTA_OUTFIFO_FILLA. */
#define BS_ASRC_ASRFSTA_OUTFIFO_FILLA (7U) /*!< Bit field size in bits for ASRC_ASRFSTA_OUTFIFO_FILLA. */

/*! @brief Read current value of the ASRC_ASRFSTA_OUTFIFO_FILLA field. */
#define BR_ASRC_ASRFSTA_OUTFIFO_FILLA(x) (HW_ASRC_ASRFSTA(x).B.OUTFIFO_FILLA)
/*@}*/

/*!
 * @name Register ASRC_ASRFSTA, field OAFA[23] (RO)
 *
 * Output FIFO is near Full for Pair A This bit is to indicate whether the
 * output FIFO of Pair A is near full.
 */
/*@{*/
#define BP_ASRC_ASRFSTA_OAFA (23U)         /*!< Bit position for ASRC_ASRFSTA_OAFA. */
#define BM_ASRC_ASRFSTA_OAFA (0x00800000U) /*!< Bit mask for ASRC_ASRFSTA_OAFA. */
#define BS_ASRC_ASRFSTA_OAFA (1U)          /*!< Bit field size in bits for ASRC_ASRFSTA_OAFA. */

/*! @brief Read current value of the ASRC_ASRFSTA_OAFA field. */
#define BR_ASRC_ASRFSTA_OAFA(x) (HW_ASRC_ASRFSTA(x).B.OAFA)
/*@}*/

/*******************************************************************************
 * HW_ASRC_ASRMCRB - ASRC Misc Control Register for Pair B
 ******************************************************************************/

/*!
 * @brief HW_ASRC_ASRMCRB - ASRC Misc Control Register for Pair B (RW)
 *
 * Reset value: 0x00000000U
 *
 * The register (ASRMCRB) is used to control Pair B internal logic.
 */
typedef union _hw_asrc_asrmcrb
{
    uint32_t U;
    struct _hw_asrc_asrmcrb_bitfields
    {
        uint32_t INFIFO_THRESHOLDB : 6; /*!< [5:0]  */
        uint32_t RESERVED0 : 4;        /*!< [9:6]  */
        uint32_t RSYNOFB : 1;          /*!< [10]  */
        uint32_t RSYNIFB : 1;          /*!< [11]  */
        uint32_t OUTFIFO_THRESHOLDB : 6; /*!< [17:12]  */
        uint32_t RESERVED1 : 2;        /*!< [19:18]  */
        uint32_t BYPASSPOLYB : 1;      /*!< [20]  */
        uint32_t BUFSTALLB : 1;        /*!< [21]  */
        uint32_t EXTTHRSHB : 1;        /*!< [22]  */
        uint32_t ZEROBUFB : 1;         /*!< [23]  */
        uint32_t RESERVED2 : 8;        /*!< [31:24] This is a 24-bit register the
                                        * upper byte is unimplemented. */
    } B;
} hw_asrc_asrmcrb_t;

/*!
 * @name Constants and macros for entire ASRC_ASRMCRB register
 */
/*@{*/
#define HW_ASRC_ASRMCRB_ADDR(x)  ((uintptr_t)(x) + 0xA8U)

#define HW_ASRC_ASRMCRB(x)       (*(__IO hw_asrc_asrmcrb_t *) HW_ASRC_ASRMCRB_ADDR(x))
#define HW_ASRC_ASRMCRB_RD(x)    (HW_ASRC_ASRMCRB(x).U)
#define HW_ASRC_ASRMCRB_WR(x, v) (HW_ASRC_ASRMCRB(x).U = (v))
#define HW_ASRC_ASRMCRB_SET(x, v) (HW_ASRC_ASRMCRB_WR(x, HW_ASRC_ASRMCRB_RD(x) |  (v)))
#define HW_ASRC_ASRMCRB_CLR(x, v) (HW_ASRC_ASRMCRB_WR(x, HW_ASRC_ASRMCRB_RD(x) & ~(v)))
#define HW_ASRC_ASRMCRB_TOG(x, v) (HW_ASRC_ASRMCRB_WR(x, HW_ASRC_ASRMCRB_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ASRC_ASRMCRB bitfields
 */

/*!
 * @name Register ASRC_ASRMCRB, field INFIFO_THRESHOLDB[5:0] (RW)
 *
 * The threshold for Pair B's input FIFO per channel These bits stand for the
 * threshold for Pair B's input FIFO per channel. Possible range is [0,63]. When
 * the value is n, it means that: when the number of input FIFO fillings of the
 * pair is less than n samples per channel, the input data needed flag is set; when
 * the number of input FIFO fillings of the pair is greater than or equal to n
 * samples per channel, the input data needed flag is automatically cleared.
 */
/*@{*/
#define BP_ASRC_ASRMCRB_INFIFO_THRESHOLDB (0U) /*!< Bit position for ASRC_ASRMCRB_INFIFO_THRESHOLDB. */
#define BM_ASRC_ASRMCRB_INFIFO_THRESHOLDB (0x0000003FU) /*!< Bit mask for ASRC_ASRMCRB_INFIFO_THRESHOLDB. */
#define BS_ASRC_ASRMCRB_INFIFO_THRESHOLDB (6U) /*!< Bit field size in bits for ASRC_ASRMCRB_INFIFO_THRESHOLDB. */

/*! @brief Read current value of the ASRC_ASRMCRB_INFIFO_THRESHOLDB field. */
#define BR_ASRC_ASRMCRB_INFIFO_THRESHOLDB(x) (HW_ASRC_ASRMCRB(x).B.INFIFO_THRESHOLDB)

/*! @brief Format value for bitfield ASRC_ASRMCRB_INFIFO_THRESHOLDB. */
#define BF_ASRC_ASRMCRB_INFIFO_THRESHOLDB(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRMCRB_INFIFO_THRESHOLDB) & BM_ASRC_ASRMCRB_INFIFO_THRESHOLDB)

/*! @brief Set the INFIFO_THRESHOLDB field to a new value. */
#define BW_ASRC_ASRMCRB_INFIFO_THRESHOLDB(x, v) (HW_ASRC_ASRMCRB_WR(x, (HW_ASRC_ASRMCRB_RD(x) & ~BM_ASRC_ASRMCRB_INFIFO_THRESHOLDB) | BF_ASRC_ASRMCRB_INFIFO_THRESHOLDB(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRMCRB, field RSYNOFB[10] (RW)
 *
 * Re-sync Output FIFO Channel Counter If bit set, force ASRCCR:ACOB=0. If bit
 * clear, untouch ASRCCR:ACOB.
 */
/*@{*/
#define BP_ASRC_ASRMCRB_RSYNOFB (10U)      /*!< Bit position for ASRC_ASRMCRB_RSYNOFB. */
#define BM_ASRC_ASRMCRB_RSYNOFB (0x00000400U) /*!< Bit mask for ASRC_ASRMCRB_RSYNOFB. */
#define BS_ASRC_ASRMCRB_RSYNOFB (1U)       /*!< Bit field size in bits for ASRC_ASRMCRB_RSYNOFB. */

/*! @brief Read current value of the ASRC_ASRMCRB_RSYNOFB field. */
#define BR_ASRC_ASRMCRB_RSYNOFB(x) (HW_ASRC_ASRMCRB(x).B.RSYNOFB)

/*! @brief Format value for bitfield ASRC_ASRMCRB_RSYNOFB. */
#define BF_ASRC_ASRMCRB_RSYNOFB(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRMCRB_RSYNOFB) & BM_ASRC_ASRMCRB_RSYNOFB)

/*! @brief Set the RSYNOFB field to a new value. */
#define BW_ASRC_ASRMCRB_RSYNOFB(x, v) (HW_ASRC_ASRMCRB_WR(x, (HW_ASRC_ASRMCRB_RD(x) & ~BM_ASRC_ASRMCRB_RSYNOFB) | BF_ASRC_ASRMCRB_RSYNOFB(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRMCRB, field RSYNIFB[11] (RW)
 *
 * Re-sync Input FIFO Channel Counter If bit set, force ASRCCR:ACIB=0. If bit
 * clear, untouch ASRCCR:ACIB.
 */
/*@{*/
#define BP_ASRC_ASRMCRB_RSYNIFB (11U)      /*!< Bit position for ASRC_ASRMCRB_RSYNIFB. */
#define BM_ASRC_ASRMCRB_RSYNIFB (0x00000800U) /*!< Bit mask for ASRC_ASRMCRB_RSYNIFB. */
#define BS_ASRC_ASRMCRB_RSYNIFB (1U)       /*!< Bit field size in bits for ASRC_ASRMCRB_RSYNIFB. */

/*! @brief Read current value of the ASRC_ASRMCRB_RSYNIFB field. */
#define BR_ASRC_ASRMCRB_RSYNIFB(x) (HW_ASRC_ASRMCRB(x).B.RSYNIFB)

/*! @brief Format value for bitfield ASRC_ASRMCRB_RSYNIFB. */
#define BF_ASRC_ASRMCRB_RSYNIFB(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRMCRB_RSYNIFB) & BM_ASRC_ASRMCRB_RSYNIFB)

/*! @brief Set the RSYNIFB field to a new value. */
#define BW_ASRC_ASRMCRB_RSYNIFB(x, v) (HW_ASRC_ASRMCRB_WR(x, (HW_ASRC_ASRMCRB_RD(x) & ~BM_ASRC_ASRMCRB_RSYNIFB) | BF_ASRC_ASRMCRB_RSYNIFB(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRMCRB, field OUTFIFO_THRESHOLDB[17:12] (RW)
 *
 * The threshold for Pair B's output FIFO per channel These bits stand for the
 * threshold for Pair B's output FIFO per channel. Possible range is [0,63]. When
 * the value is n, it means that: when the number of output FIFO fillings of the
 * pair is greater than n samples per channel, the output data ready flag is set;
 * when the number of output FIFO fillings of the pair is less than or equal to
 * n samples per channel, the output data ready flag is automatically cleared.
 */
/*@{*/
#define BP_ASRC_ASRMCRB_OUTFIFO_THRESHOLDB (12U) /*!< Bit position for ASRC_ASRMCRB_OUTFIFO_THRESHOLDB. */
#define BM_ASRC_ASRMCRB_OUTFIFO_THRESHOLDB (0x0003F000U) /*!< Bit mask for ASRC_ASRMCRB_OUTFIFO_THRESHOLDB. */
#define BS_ASRC_ASRMCRB_OUTFIFO_THRESHOLDB (6U) /*!< Bit field size in bits for ASRC_ASRMCRB_OUTFIFO_THRESHOLDB. */

/*! @brief Read current value of the ASRC_ASRMCRB_OUTFIFO_THRESHOLDB field. */
#define BR_ASRC_ASRMCRB_OUTFIFO_THRESHOLDB(x) (HW_ASRC_ASRMCRB(x).B.OUTFIFO_THRESHOLDB)

/*! @brief Format value for bitfield ASRC_ASRMCRB_OUTFIFO_THRESHOLDB. */
#define BF_ASRC_ASRMCRB_OUTFIFO_THRESHOLDB(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRMCRB_OUTFIFO_THRESHOLDB) & BM_ASRC_ASRMCRB_OUTFIFO_THRESHOLDB)

/*! @brief Set the OUTFIFO_THRESHOLDB field to a new value. */
#define BW_ASRC_ASRMCRB_OUTFIFO_THRESHOLDB(x, v) (HW_ASRC_ASRMCRB_WR(x, (HW_ASRC_ASRMCRB_RD(x) & ~BM_ASRC_ASRMCRB_OUTFIFO_THRESHOLDB) | BF_ASRC_ASRMCRB_OUTFIFO_THRESHOLDB(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRMCRB, field BYPASSPOLYB[20] (RW)
 *
 * Bypass Polyphase Filtering for Pair B This bit will determine whether the
 * polyphase filtering part of Pair B conversion will be bypassed.
 *
 * Values:
 * - 1 - Bypass polyphase filtering.
 * - 0 - Don't bypass polyphase filtering.
 */
/*@{*/
#define BP_ASRC_ASRMCRB_BYPASSPOLYB (20U)  /*!< Bit position for ASRC_ASRMCRB_BYPASSPOLYB. */
#define BM_ASRC_ASRMCRB_BYPASSPOLYB (0x00100000U) /*!< Bit mask for ASRC_ASRMCRB_BYPASSPOLYB. */
#define BS_ASRC_ASRMCRB_BYPASSPOLYB (1U)   /*!< Bit field size in bits for ASRC_ASRMCRB_BYPASSPOLYB. */

/*! @brief Read current value of the ASRC_ASRMCRB_BYPASSPOLYB field. */
#define BR_ASRC_ASRMCRB_BYPASSPOLYB(x) (HW_ASRC_ASRMCRB(x).B.BYPASSPOLYB)

/*! @brief Format value for bitfield ASRC_ASRMCRB_BYPASSPOLYB. */
#define BF_ASRC_ASRMCRB_BYPASSPOLYB(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRMCRB_BYPASSPOLYB) & BM_ASRC_ASRMCRB_BYPASSPOLYB)

/*! @brief Set the BYPASSPOLYB field to a new value. */
#define BW_ASRC_ASRMCRB_BYPASSPOLYB(x, v) (HW_ASRC_ASRMCRB_WR(x, (HW_ASRC_ASRMCRB_RD(x) & ~BM_ASRC_ASRMCRB_BYPASSPOLYB) | BF_ASRC_ASRMCRB_BYPASSPOLYB(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRMCRB, field BUFSTALLB[21] (RW)
 *
 * Stall Pair B conversion in case of Buffer Near Empty/Full Condition This bit
 * will determine whether the near empty/full FIFO condition will stall the rate
 * conversion for pair B. This option can only work when external ratio is used.
 * Near empty condition is the condition when input FIFO has less than 4 useful
 * samples per channel. Near full condition is the condition when the output FIFO
 * has less than 4 vacant sample words to fill per channel.
 *
 * Values:
 * - 1 - Stall Pair B conversion in case of near empty/full FIFO conditions.
 * - 0 - Don't stall Pair B conversion even in case of near empty/full FIFO
 *     conditions.
 */
/*@{*/
#define BP_ASRC_ASRMCRB_BUFSTALLB (21U)    /*!< Bit position for ASRC_ASRMCRB_BUFSTALLB. */
#define BM_ASRC_ASRMCRB_BUFSTALLB (0x00200000U) /*!< Bit mask for ASRC_ASRMCRB_BUFSTALLB. */
#define BS_ASRC_ASRMCRB_BUFSTALLB (1U)     /*!< Bit field size in bits for ASRC_ASRMCRB_BUFSTALLB. */

/*! @brief Read current value of the ASRC_ASRMCRB_BUFSTALLB field. */
#define BR_ASRC_ASRMCRB_BUFSTALLB(x) (HW_ASRC_ASRMCRB(x).B.BUFSTALLB)

/*! @brief Format value for bitfield ASRC_ASRMCRB_BUFSTALLB. */
#define BF_ASRC_ASRMCRB_BUFSTALLB(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRMCRB_BUFSTALLB) & BM_ASRC_ASRMCRB_BUFSTALLB)

/*! @brief Set the BUFSTALLB field to a new value. */
#define BW_ASRC_ASRMCRB_BUFSTALLB(x, v) (HW_ASRC_ASRMCRB_WR(x, (HW_ASRC_ASRMCRB_RD(x) & ~BM_ASRC_ASRMCRB_BUFSTALLB) | BF_ASRC_ASRMCRB_BUFSTALLB(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRMCRB, field EXTTHRSHB[22] (RW)
 *
 * Use external thresholds for FIFO control of Pair B This bit will determine
 * whether the FIFO thresholds externally defined in this register is used to
 * control ASRC internal FIFO logic for pair B.
 *
 * Values:
 * - 1 - Use external defined thresholds.
 * - 0 - Use default thresholds.
 */
/*@{*/
#define BP_ASRC_ASRMCRB_EXTTHRSHB (22U)    /*!< Bit position for ASRC_ASRMCRB_EXTTHRSHB. */
#define BM_ASRC_ASRMCRB_EXTTHRSHB (0x00400000U) /*!< Bit mask for ASRC_ASRMCRB_EXTTHRSHB. */
#define BS_ASRC_ASRMCRB_EXTTHRSHB (1U)     /*!< Bit field size in bits for ASRC_ASRMCRB_EXTTHRSHB. */

/*! @brief Read current value of the ASRC_ASRMCRB_EXTTHRSHB field. */
#define BR_ASRC_ASRMCRB_EXTTHRSHB(x) (HW_ASRC_ASRMCRB(x).B.EXTTHRSHB)

/*! @brief Format value for bitfield ASRC_ASRMCRB_EXTTHRSHB. */
#define BF_ASRC_ASRMCRB_EXTTHRSHB(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRMCRB_EXTTHRSHB) & BM_ASRC_ASRMCRB_EXTTHRSHB)

/*! @brief Set the EXTTHRSHB field to a new value. */
#define BW_ASRC_ASRMCRB_EXTTHRSHB(x, v) (HW_ASRC_ASRMCRB_WR(x, (HW_ASRC_ASRMCRB_RD(x) & ~BM_ASRC_ASRMCRB_EXTTHRSHB) | BF_ASRC_ASRMCRB_EXTTHRSHB(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRMCRB, field ZEROBUFB[23] (RW)
 *
 * Initialize buf of Pair B when pair B is enabled This bit is used to control
 * whether the buffer is to be zeroized when pair B is enabled.
 *
 * Values:
 * - 1 - Don't zeroize the buffer
 * - 0 - Zeroize the buffer
 */
/*@{*/
#define BP_ASRC_ASRMCRB_ZEROBUFB (23U)     /*!< Bit position for ASRC_ASRMCRB_ZEROBUFB. */
#define BM_ASRC_ASRMCRB_ZEROBUFB (0x00800000U) /*!< Bit mask for ASRC_ASRMCRB_ZEROBUFB. */
#define BS_ASRC_ASRMCRB_ZEROBUFB (1U)      /*!< Bit field size in bits for ASRC_ASRMCRB_ZEROBUFB. */

/*! @brief Read current value of the ASRC_ASRMCRB_ZEROBUFB field. */
#define BR_ASRC_ASRMCRB_ZEROBUFB(x) (HW_ASRC_ASRMCRB(x).B.ZEROBUFB)

/*! @brief Format value for bitfield ASRC_ASRMCRB_ZEROBUFB. */
#define BF_ASRC_ASRMCRB_ZEROBUFB(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRMCRB_ZEROBUFB) & BM_ASRC_ASRMCRB_ZEROBUFB)

/*! @brief Set the ZEROBUFB field to a new value. */
#define BW_ASRC_ASRMCRB_ZEROBUFB(x, v) (HW_ASRC_ASRMCRB_WR(x, (HW_ASRC_ASRMCRB_RD(x) & ~BM_ASRC_ASRMCRB_ZEROBUFB) | BF_ASRC_ASRMCRB_ZEROBUFB(v)))
/*@}*/

/*******************************************************************************
 * HW_ASRC_ASRFSTB - ASRC FIFO Status Register for Pair B
 ******************************************************************************/

/*!
 * @brief HW_ASRC_ASRFSTB - ASRC FIFO Status Register for Pair B (RO)
 *
 * Reset value: 0x00000000U
 *
 * The register (ASRFSTB) is used to show Pair B internal FIFO conditions.
 */
typedef union _hw_asrc_asrfstb
{
    uint32_t U;
    struct _hw_asrc_asrfstb_bitfields
    {
        uint32_t INFIFO_FILLB : 7;     /*!< [6:0]  */
        uint32_t RESERVED0 : 4;        /*!< [10:7]  */
        uint32_t IAEB : 1;             /*!< [11]  */
        uint32_t OUTFIFO_FILLB : 7;    /*!< [18:12]  */
        uint32_t RESERVED1 : 4;        /*!< [22:19]  */
        uint32_t OAFB : 1;             /*!< [23]  */
        uint32_t RESERVED2 : 8;        /*!< [31:24] This is a 24-bit register the
                                        * upper byte is unimplemented. */
    } B;
} hw_asrc_asrfstb_t;

/*!
 * @name Constants and macros for entire ASRC_ASRFSTB register
 */
/*@{*/
#define HW_ASRC_ASRFSTB_ADDR(x)  ((uintptr_t)(x) + 0xACU)

#define HW_ASRC_ASRFSTB(x)       (*(__I hw_asrc_asrfstb_t *) HW_ASRC_ASRFSTB_ADDR(x))
#define HW_ASRC_ASRFSTB_RD(x)    (HW_ASRC_ASRFSTB(x).U)
/*@}*/

/*
 * Constants & macros for individual ASRC_ASRFSTB bitfields
 */

/*!
 * @name Register ASRC_ASRFSTB, field INFIFO_FILLB[6:0] (RO)
 *
 * The fillings for Pair B's input FIFO per channel These bits stand for the
 * fillings for Pair B's input FIFO per channel. Possible range is [0,64].
 */
/*@{*/
#define BP_ASRC_ASRFSTB_INFIFO_FILLB (0U)  /*!< Bit position for ASRC_ASRFSTB_INFIFO_FILLB. */
#define BM_ASRC_ASRFSTB_INFIFO_FILLB (0x0000007FU) /*!< Bit mask for ASRC_ASRFSTB_INFIFO_FILLB. */
#define BS_ASRC_ASRFSTB_INFIFO_FILLB (7U)  /*!< Bit field size in bits for ASRC_ASRFSTB_INFIFO_FILLB. */

/*! @brief Read current value of the ASRC_ASRFSTB_INFIFO_FILLB field. */
#define BR_ASRC_ASRFSTB_INFIFO_FILLB(x) (HW_ASRC_ASRFSTB(x).B.INFIFO_FILLB)
/*@}*/

/*!
 * @name Register ASRC_ASRFSTB, field IAEB[11] (RO)
 *
 * Input FIFO is near Empty for Pair B This bit is to indicate whether the input
 * FIFO of Pair B is near empty.
 */
/*@{*/
#define BP_ASRC_ASRFSTB_IAEB (11U)         /*!< Bit position for ASRC_ASRFSTB_IAEB. */
#define BM_ASRC_ASRFSTB_IAEB (0x00000800U) /*!< Bit mask for ASRC_ASRFSTB_IAEB. */
#define BS_ASRC_ASRFSTB_IAEB (1U)          /*!< Bit field size in bits for ASRC_ASRFSTB_IAEB. */

/*! @brief Read current value of the ASRC_ASRFSTB_IAEB field. */
#define BR_ASRC_ASRFSTB_IAEB(x) (HW_ASRC_ASRFSTB(x).B.IAEB)
/*@}*/

/*!
 * @name Register ASRC_ASRFSTB, field OUTFIFO_FILLB[18:12] (RO)
 *
 * The fillings for Pair B's output FIFO per channel These bits stand for the
 * fillings for Pair B's output FIFO per channel. Possible range is [0,64].
 */
/*@{*/
#define BP_ASRC_ASRFSTB_OUTFIFO_FILLB (12U) /*!< Bit position for ASRC_ASRFSTB_OUTFIFO_FILLB. */
#define BM_ASRC_ASRFSTB_OUTFIFO_FILLB (0x0007F000U) /*!< Bit mask for ASRC_ASRFSTB_OUTFIFO_FILLB. */
#define BS_ASRC_ASRFSTB_OUTFIFO_FILLB (7U) /*!< Bit field size in bits for ASRC_ASRFSTB_OUTFIFO_FILLB. */

/*! @brief Read current value of the ASRC_ASRFSTB_OUTFIFO_FILLB field. */
#define BR_ASRC_ASRFSTB_OUTFIFO_FILLB(x) (HW_ASRC_ASRFSTB(x).B.OUTFIFO_FILLB)
/*@}*/

/*!
 * @name Register ASRC_ASRFSTB, field OAFB[23] (RO)
 *
 * Output FIFO is near Full for Pair B This bit is to indicate whether the
 * output FIFO of Pair B is near full.
 */
/*@{*/
#define BP_ASRC_ASRFSTB_OAFB (23U)         /*!< Bit position for ASRC_ASRFSTB_OAFB. */
#define BM_ASRC_ASRFSTB_OAFB (0x00800000U) /*!< Bit mask for ASRC_ASRFSTB_OAFB. */
#define BS_ASRC_ASRFSTB_OAFB (1U)          /*!< Bit field size in bits for ASRC_ASRFSTB_OAFB. */

/*! @brief Read current value of the ASRC_ASRFSTB_OAFB field. */
#define BR_ASRC_ASRFSTB_OAFB(x) (HW_ASRC_ASRFSTB(x).B.OAFB)
/*@}*/

/*******************************************************************************
 * HW_ASRC_ASRMCRC - ASRC Misc Control Register for Pair C
 ******************************************************************************/

/*!
 * @brief HW_ASRC_ASRMCRC - ASRC Misc Control Register for Pair C (RW)
 *
 * Reset value: 0x00000000U
 *
 * The register (ASRMCRC) is used to control Pair C internal logic.
 */
typedef union _hw_asrc_asrmcrc
{
    uint32_t U;
    struct _hw_asrc_asrmcrc_bitfields
    {
        uint32_t INFIFO_THRESHOLDC : 6; /*!< [5:0]  */
        uint32_t RESERVED0 : 4;        /*!< [9:6]  */
        uint32_t RSYNOFC : 1;          /*!< [10]  */
        uint32_t RSYNIFC : 1;          /*!< [11]  */
        uint32_t OUTFIFO_THRESHOLDC : 6; /*!< [17:12]  */
        uint32_t RESERVED1 : 2;        /*!< [19:18]  */
        uint32_t BYPASSPOLYC : 1;      /*!< [20]  */
        uint32_t BUFSTALLC : 1;        /*!< [21]  */
        uint32_t EXTTHRSHC : 1;        /*!< [22]  */
        uint32_t ZEROBUFC : 1;         /*!< [23]  */
        uint32_t RESERVED2 : 8;        /*!< [31:24] This is a 24-bit register the
                                        * upper byte is unimplemented. */
    } B;
} hw_asrc_asrmcrc_t;

/*!
 * @name Constants and macros for entire ASRC_ASRMCRC register
 */
/*@{*/
#define HW_ASRC_ASRMCRC_ADDR(x)  ((uintptr_t)(x) + 0xB0U)

#define HW_ASRC_ASRMCRC(x)       (*(__IO hw_asrc_asrmcrc_t *) HW_ASRC_ASRMCRC_ADDR(x))
#define HW_ASRC_ASRMCRC_RD(x)    (HW_ASRC_ASRMCRC(x).U)
#define HW_ASRC_ASRMCRC_WR(x, v) (HW_ASRC_ASRMCRC(x).U = (v))
#define HW_ASRC_ASRMCRC_SET(x, v) (HW_ASRC_ASRMCRC_WR(x, HW_ASRC_ASRMCRC_RD(x) |  (v)))
#define HW_ASRC_ASRMCRC_CLR(x, v) (HW_ASRC_ASRMCRC_WR(x, HW_ASRC_ASRMCRC_RD(x) & ~(v)))
#define HW_ASRC_ASRMCRC_TOG(x, v) (HW_ASRC_ASRMCRC_WR(x, HW_ASRC_ASRMCRC_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ASRC_ASRMCRC bitfields
 */

/*!
 * @name Register ASRC_ASRMCRC, field INFIFO_THRESHOLDC[5:0] (RW)
 *
 * The threshold for Pair C's input FIFO per channel These bits stand for the
 * threshold for Pair C's input FIFO per channel. Possible range is [0,63]. When
 * the value is n, it means that: when the number of input FIFO fillings of the
 * pair is less than n samples per channel, the input data needed flag is set; when
 * the number of input FIFO fillings of the pair is greater than or equal to n
 * samples per channel, the input data needed flag is automatically cleared.
 */
/*@{*/
#define BP_ASRC_ASRMCRC_INFIFO_THRESHOLDC (0U) /*!< Bit position for ASRC_ASRMCRC_INFIFO_THRESHOLDC. */
#define BM_ASRC_ASRMCRC_INFIFO_THRESHOLDC (0x0000003FU) /*!< Bit mask for ASRC_ASRMCRC_INFIFO_THRESHOLDC. */
#define BS_ASRC_ASRMCRC_INFIFO_THRESHOLDC (6U) /*!< Bit field size in bits for ASRC_ASRMCRC_INFIFO_THRESHOLDC. */

/*! @brief Read current value of the ASRC_ASRMCRC_INFIFO_THRESHOLDC field. */
#define BR_ASRC_ASRMCRC_INFIFO_THRESHOLDC(x) (HW_ASRC_ASRMCRC(x).B.INFIFO_THRESHOLDC)

/*! @brief Format value for bitfield ASRC_ASRMCRC_INFIFO_THRESHOLDC. */
#define BF_ASRC_ASRMCRC_INFIFO_THRESHOLDC(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRMCRC_INFIFO_THRESHOLDC) & BM_ASRC_ASRMCRC_INFIFO_THRESHOLDC)

/*! @brief Set the INFIFO_THRESHOLDC field to a new value. */
#define BW_ASRC_ASRMCRC_INFIFO_THRESHOLDC(x, v) (HW_ASRC_ASRMCRC_WR(x, (HW_ASRC_ASRMCRC_RD(x) & ~BM_ASRC_ASRMCRC_INFIFO_THRESHOLDC) | BF_ASRC_ASRMCRC_INFIFO_THRESHOLDC(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRMCRC, field RSYNOFC[10] (RW)
 *
 * Re-sync Output FIFO Channel Counter If bit set, force ASRCCR:ACOC=0. If bit
 * clear, untouch ASRCCR:ACOC.
 */
/*@{*/
#define BP_ASRC_ASRMCRC_RSYNOFC (10U)      /*!< Bit position for ASRC_ASRMCRC_RSYNOFC. */
#define BM_ASRC_ASRMCRC_RSYNOFC (0x00000400U) /*!< Bit mask for ASRC_ASRMCRC_RSYNOFC. */
#define BS_ASRC_ASRMCRC_RSYNOFC (1U)       /*!< Bit field size in bits for ASRC_ASRMCRC_RSYNOFC. */

/*! @brief Read current value of the ASRC_ASRMCRC_RSYNOFC field. */
#define BR_ASRC_ASRMCRC_RSYNOFC(x) (HW_ASRC_ASRMCRC(x).B.RSYNOFC)

/*! @brief Format value for bitfield ASRC_ASRMCRC_RSYNOFC. */
#define BF_ASRC_ASRMCRC_RSYNOFC(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRMCRC_RSYNOFC) & BM_ASRC_ASRMCRC_RSYNOFC)

/*! @brief Set the RSYNOFC field to a new value. */
#define BW_ASRC_ASRMCRC_RSYNOFC(x, v) (HW_ASRC_ASRMCRC_WR(x, (HW_ASRC_ASRMCRC_RD(x) & ~BM_ASRC_ASRMCRC_RSYNOFC) | BF_ASRC_ASRMCRC_RSYNOFC(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRMCRC, field RSYNIFC[11] (RW)
 *
 * Re-sync Input FIFO Channel Counter If bit set, force ASRCCR:ACIC=0. If bit
 * clear, untouch ASRCCR:ACIC.
 */
/*@{*/
#define BP_ASRC_ASRMCRC_RSYNIFC (11U)      /*!< Bit position for ASRC_ASRMCRC_RSYNIFC. */
#define BM_ASRC_ASRMCRC_RSYNIFC (0x00000800U) /*!< Bit mask for ASRC_ASRMCRC_RSYNIFC. */
#define BS_ASRC_ASRMCRC_RSYNIFC (1U)       /*!< Bit field size in bits for ASRC_ASRMCRC_RSYNIFC. */

/*! @brief Read current value of the ASRC_ASRMCRC_RSYNIFC field. */
#define BR_ASRC_ASRMCRC_RSYNIFC(x) (HW_ASRC_ASRMCRC(x).B.RSYNIFC)

/*! @brief Format value for bitfield ASRC_ASRMCRC_RSYNIFC. */
#define BF_ASRC_ASRMCRC_RSYNIFC(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRMCRC_RSYNIFC) & BM_ASRC_ASRMCRC_RSYNIFC)

/*! @brief Set the RSYNIFC field to a new value. */
#define BW_ASRC_ASRMCRC_RSYNIFC(x, v) (HW_ASRC_ASRMCRC_WR(x, (HW_ASRC_ASRMCRC_RD(x) & ~BM_ASRC_ASRMCRC_RSYNIFC) | BF_ASRC_ASRMCRC_RSYNIFC(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRMCRC, field OUTFIFO_THRESHOLDC[17:12] (RW)
 *
 * The threshold for Pair C's output FIFO per channel These bits stand for the
 * threshold for Pair C's output FIFO per channel. Possible range is [0,63]. When
 * the value is n, it means that: when the number of output FIFO fillings of the
 * pair is greater than n samples per channel, the output data ready flag is set;
 * when the number of output FIFO fillings of the pair is less than or equal to
 * n samples per channel, the output data ready flag is automatically cleared.
 */
/*@{*/
#define BP_ASRC_ASRMCRC_OUTFIFO_THRESHOLDC (12U) /*!< Bit position for ASRC_ASRMCRC_OUTFIFO_THRESHOLDC. */
#define BM_ASRC_ASRMCRC_OUTFIFO_THRESHOLDC (0x0003F000U) /*!< Bit mask for ASRC_ASRMCRC_OUTFIFO_THRESHOLDC. */
#define BS_ASRC_ASRMCRC_OUTFIFO_THRESHOLDC (6U) /*!< Bit field size in bits for ASRC_ASRMCRC_OUTFIFO_THRESHOLDC. */

/*! @brief Read current value of the ASRC_ASRMCRC_OUTFIFO_THRESHOLDC field. */
#define BR_ASRC_ASRMCRC_OUTFIFO_THRESHOLDC(x) (HW_ASRC_ASRMCRC(x).B.OUTFIFO_THRESHOLDC)

/*! @brief Format value for bitfield ASRC_ASRMCRC_OUTFIFO_THRESHOLDC. */
#define BF_ASRC_ASRMCRC_OUTFIFO_THRESHOLDC(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRMCRC_OUTFIFO_THRESHOLDC) & BM_ASRC_ASRMCRC_OUTFIFO_THRESHOLDC)

/*! @brief Set the OUTFIFO_THRESHOLDC field to a new value. */
#define BW_ASRC_ASRMCRC_OUTFIFO_THRESHOLDC(x, v) (HW_ASRC_ASRMCRC_WR(x, (HW_ASRC_ASRMCRC_RD(x) & ~BM_ASRC_ASRMCRC_OUTFIFO_THRESHOLDC) | BF_ASRC_ASRMCRC_OUTFIFO_THRESHOLDC(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRMCRC, field BYPASSPOLYC[20] (RW)
 *
 * Bypass Polyphase Filtering for Pair C This bit will determine whether the
 * polyphase filtering part of Pair C conversion will be bypassed.
 *
 * Values:
 * - 1 - Bypass polyphase filtering.
 * - 0 - Don't bypass polyphase filtering.
 */
/*@{*/
#define BP_ASRC_ASRMCRC_BYPASSPOLYC (20U)  /*!< Bit position for ASRC_ASRMCRC_BYPASSPOLYC. */
#define BM_ASRC_ASRMCRC_BYPASSPOLYC (0x00100000U) /*!< Bit mask for ASRC_ASRMCRC_BYPASSPOLYC. */
#define BS_ASRC_ASRMCRC_BYPASSPOLYC (1U)   /*!< Bit field size in bits for ASRC_ASRMCRC_BYPASSPOLYC. */

/*! @brief Read current value of the ASRC_ASRMCRC_BYPASSPOLYC field. */
#define BR_ASRC_ASRMCRC_BYPASSPOLYC(x) (HW_ASRC_ASRMCRC(x).B.BYPASSPOLYC)

/*! @brief Format value for bitfield ASRC_ASRMCRC_BYPASSPOLYC. */
#define BF_ASRC_ASRMCRC_BYPASSPOLYC(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRMCRC_BYPASSPOLYC) & BM_ASRC_ASRMCRC_BYPASSPOLYC)

/*! @brief Set the BYPASSPOLYC field to a new value. */
#define BW_ASRC_ASRMCRC_BYPASSPOLYC(x, v) (HW_ASRC_ASRMCRC_WR(x, (HW_ASRC_ASRMCRC_RD(x) & ~BM_ASRC_ASRMCRC_BYPASSPOLYC) | BF_ASRC_ASRMCRC_BYPASSPOLYC(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRMCRC, field BUFSTALLC[21] (RW)
 *
 * Stall Pair C conversion in case of Buffer Near Empty/Full Condition This bit
 * will determine whether the near empty/full FIFO condition will stall the rate
 * conversion for pair C. This option can only work when external ratio is used.
 * Near empty condition is the condition when input FIFO has less than 4 useful
 * samples per channel. Near full condition is the condition when the output FIFO
 * has less than 4 vacant sample words to fill per channel.
 *
 * Values:
 * - 1 - Stall Pair C conversion in case of near empty/full FIFO conditions.
 * - 0 - Don't stall Pair C conversion even in case of near empty/full FIFO
 *     conditions.
 */
/*@{*/
#define BP_ASRC_ASRMCRC_BUFSTALLC (21U)    /*!< Bit position for ASRC_ASRMCRC_BUFSTALLC. */
#define BM_ASRC_ASRMCRC_BUFSTALLC (0x00200000U) /*!< Bit mask for ASRC_ASRMCRC_BUFSTALLC. */
#define BS_ASRC_ASRMCRC_BUFSTALLC (1U)     /*!< Bit field size in bits for ASRC_ASRMCRC_BUFSTALLC. */

/*! @brief Read current value of the ASRC_ASRMCRC_BUFSTALLC field. */
#define BR_ASRC_ASRMCRC_BUFSTALLC(x) (HW_ASRC_ASRMCRC(x).B.BUFSTALLC)

/*! @brief Format value for bitfield ASRC_ASRMCRC_BUFSTALLC. */
#define BF_ASRC_ASRMCRC_BUFSTALLC(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRMCRC_BUFSTALLC) & BM_ASRC_ASRMCRC_BUFSTALLC)

/*! @brief Set the BUFSTALLC field to a new value. */
#define BW_ASRC_ASRMCRC_BUFSTALLC(x, v) (HW_ASRC_ASRMCRC_WR(x, (HW_ASRC_ASRMCRC_RD(x) & ~BM_ASRC_ASRMCRC_BUFSTALLC) | BF_ASRC_ASRMCRC_BUFSTALLC(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRMCRC, field EXTTHRSHC[22] (RW)
 *
 * Use external thresholds for FIFO control of Pair C This bit will determine
 * whether the FIFO thresholds externally defined in this register is used to
 * control ASRC internal FIFO logic for pair C.
 *
 * Values:
 * - 1 - Use external defined thresholds.
 * - 0 - Use default thresholds.
 */
/*@{*/
#define BP_ASRC_ASRMCRC_EXTTHRSHC (22U)    /*!< Bit position for ASRC_ASRMCRC_EXTTHRSHC. */
#define BM_ASRC_ASRMCRC_EXTTHRSHC (0x00400000U) /*!< Bit mask for ASRC_ASRMCRC_EXTTHRSHC. */
#define BS_ASRC_ASRMCRC_EXTTHRSHC (1U)     /*!< Bit field size in bits for ASRC_ASRMCRC_EXTTHRSHC. */

/*! @brief Read current value of the ASRC_ASRMCRC_EXTTHRSHC field. */
#define BR_ASRC_ASRMCRC_EXTTHRSHC(x) (HW_ASRC_ASRMCRC(x).B.EXTTHRSHC)

/*! @brief Format value for bitfield ASRC_ASRMCRC_EXTTHRSHC. */
#define BF_ASRC_ASRMCRC_EXTTHRSHC(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRMCRC_EXTTHRSHC) & BM_ASRC_ASRMCRC_EXTTHRSHC)

/*! @brief Set the EXTTHRSHC field to a new value. */
#define BW_ASRC_ASRMCRC_EXTTHRSHC(x, v) (HW_ASRC_ASRMCRC_WR(x, (HW_ASRC_ASRMCRC_RD(x) & ~BM_ASRC_ASRMCRC_EXTTHRSHC) | BF_ASRC_ASRMCRC_EXTTHRSHC(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRMCRC, field ZEROBUFC[23] (RW)
 *
 * Initialize buf of Pair C when pair C is enabled This bit is used to control
 * whether the buffer is to be zeroized when pair C is enabled.
 *
 * Values:
 * - 1 - Don't zeroize the buffer
 * - 0 - Zeroize the buffer
 */
/*@{*/
#define BP_ASRC_ASRMCRC_ZEROBUFC (23U)     /*!< Bit position for ASRC_ASRMCRC_ZEROBUFC. */
#define BM_ASRC_ASRMCRC_ZEROBUFC (0x00800000U) /*!< Bit mask for ASRC_ASRMCRC_ZEROBUFC. */
#define BS_ASRC_ASRMCRC_ZEROBUFC (1U)      /*!< Bit field size in bits for ASRC_ASRMCRC_ZEROBUFC. */

/*! @brief Read current value of the ASRC_ASRMCRC_ZEROBUFC field. */
#define BR_ASRC_ASRMCRC_ZEROBUFC(x) (HW_ASRC_ASRMCRC(x).B.ZEROBUFC)

/*! @brief Format value for bitfield ASRC_ASRMCRC_ZEROBUFC. */
#define BF_ASRC_ASRMCRC_ZEROBUFC(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRMCRC_ZEROBUFC) & BM_ASRC_ASRMCRC_ZEROBUFC)

/*! @brief Set the ZEROBUFC field to a new value. */
#define BW_ASRC_ASRMCRC_ZEROBUFC(x, v) (HW_ASRC_ASRMCRC_WR(x, (HW_ASRC_ASRMCRC_RD(x) & ~BM_ASRC_ASRMCRC_ZEROBUFC) | BF_ASRC_ASRMCRC_ZEROBUFC(v)))
/*@}*/

/*******************************************************************************
 * HW_ASRC_ASRFSTC - ASRC FIFO Status Register for Pair C
 ******************************************************************************/

/*!
 * @brief HW_ASRC_ASRFSTC - ASRC FIFO Status Register for Pair C (RO)
 *
 * Reset value: 0x00000000U
 *
 * The register (ASRFSTC) is used to show Pair C internal FIFO conditions.
 */
typedef union _hw_asrc_asrfstc
{
    uint32_t U;
    struct _hw_asrc_asrfstc_bitfields
    {
        uint32_t INFIFO_FILLC : 7;     /*!< [6:0]  */
        uint32_t RESERVED0 : 4;        /*!< [10:7]  */
        uint32_t IAEC : 1;             /*!< [11]  */
        uint32_t OUTFIFO_FILLC : 7;    /*!< [18:12]  */
        uint32_t RESERVED1 : 4;        /*!< [22:19]  */
        uint32_t OAFC : 1;             /*!< [23]  */
        uint32_t RESERVED2 : 8;        /*!< [31:24] This is a 24-bit register the
                                        * upper byte is unimplemented. */
    } B;
} hw_asrc_asrfstc_t;

/*!
 * @name Constants and macros for entire ASRC_ASRFSTC register
 */
/*@{*/
#define HW_ASRC_ASRFSTC_ADDR(x)  ((uintptr_t)(x) + 0xB4U)

#define HW_ASRC_ASRFSTC(x)       (*(__I hw_asrc_asrfstc_t *) HW_ASRC_ASRFSTC_ADDR(x))
#define HW_ASRC_ASRFSTC_RD(x)    (HW_ASRC_ASRFSTC(x).U)
/*@}*/

/*
 * Constants & macros for individual ASRC_ASRFSTC bitfields
 */

/*!
 * @name Register ASRC_ASRFSTC, field INFIFO_FILLC[6:0] (RO)
 *
 * The fillings for Pair C's input FIFO per channel These bits stand for the
 * fillings for Pair C's input FIFO per channel. Possible range is [0,64].
 */
/*@{*/
#define BP_ASRC_ASRFSTC_INFIFO_FILLC (0U)  /*!< Bit position for ASRC_ASRFSTC_INFIFO_FILLC. */
#define BM_ASRC_ASRFSTC_INFIFO_FILLC (0x0000007FU) /*!< Bit mask for ASRC_ASRFSTC_INFIFO_FILLC. */
#define BS_ASRC_ASRFSTC_INFIFO_FILLC (7U)  /*!< Bit field size in bits for ASRC_ASRFSTC_INFIFO_FILLC. */

/*! @brief Read current value of the ASRC_ASRFSTC_INFIFO_FILLC field. */
#define BR_ASRC_ASRFSTC_INFIFO_FILLC(x) (HW_ASRC_ASRFSTC(x).B.INFIFO_FILLC)
/*@}*/

/*!
 * @name Register ASRC_ASRFSTC, field IAEC[11] (RO)
 *
 * Input FIFO is near Empty for Pair C This bit is to indicate whether the input
 * FIFO of Pair C is near empty.
 */
/*@{*/
#define BP_ASRC_ASRFSTC_IAEC (11U)         /*!< Bit position for ASRC_ASRFSTC_IAEC. */
#define BM_ASRC_ASRFSTC_IAEC (0x00000800U) /*!< Bit mask for ASRC_ASRFSTC_IAEC. */
#define BS_ASRC_ASRFSTC_IAEC (1U)          /*!< Bit field size in bits for ASRC_ASRFSTC_IAEC. */

/*! @brief Read current value of the ASRC_ASRFSTC_IAEC field. */
#define BR_ASRC_ASRFSTC_IAEC(x) (HW_ASRC_ASRFSTC(x).B.IAEC)
/*@}*/

/*!
 * @name Register ASRC_ASRFSTC, field OUTFIFO_FILLC[18:12] (RO)
 *
 * The fillings for Pair C's output FIFO per channel These bits stand for the
 * fillings for Pair C's output FIFO per channel. Possible range is [0,64].
 */
/*@{*/
#define BP_ASRC_ASRFSTC_OUTFIFO_FILLC (12U) /*!< Bit position for ASRC_ASRFSTC_OUTFIFO_FILLC. */
#define BM_ASRC_ASRFSTC_OUTFIFO_FILLC (0x0007F000U) /*!< Bit mask for ASRC_ASRFSTC_OUTFIFO_FILLC. */
#define BS_ASRC_ASRFSTC_OUTFIFO_FILLC (7U) /*!< Bit field size in bits for ASRC_ASRFSTC_OUTFIFO_FILLC. */

/*! @brief Read current value of the ASRC_ASRFSTC_OUTFIFO_FILLC field. */
#define BR_ASRC_ASRFSTC_OUTFIFO_FILLC(x) (HW_ASRC_ASRFSTC(x).B.OUTFIFO_FILLC)
/*@}*/

/*!
 * @name Register ASRC_ASRFSTC, field OAFC[23] (RO)
 *
 * Output FIFO is near Full for Pair C This bit is to indicate whether the
 * output FIFO of Pair C is near full.
 */
/*@{*/
#define BP_ASRC_ASRFSTC_OAFC (23U)         /*!< Bit position for ASRC_ASRFSTC_OAFC. */
#define BM_ASRC_ASRFSTC_OAFC (0x00800000U) /*!< Bit mask for ASRC_ASRFSTC_OAFC. */
#define BS_ASRC_ASRFSTC_OAFC (1U)          /*!< Bit field size in bits for ASRC_ASRFSTC_OAFC. */

/*! @brief Read current value of the ASRC_ASRFSTC_OAFC field. */
#define BR_ASRC_ASRFSTC_OAFC(x) (HW_ASRC_ASRFSTC(x).B.OAFC)
/*@}*/

/*******************************************************************************
 * HW_ASRC_ASRMCR1n - ASRC Misc Control Register 1 for Pair X
 ******************************************************************************/

/*!
 * @brief HW_ASRC_ASRMCR1n - ASRC Misc Control Register 1 for Pair X (RW)
 *
 * Reset value: 0x00000000U
 *
 * The register (ASRMCR1x) is used to control Pair x internal logic (for data
 * alignment etc.). The bit assignment for all the input data formats is the same
 * as that supported by the SSI.
 */
typedef union _hw_asrc_asrmcr1n
{
    uint32_t U;
    struct _hw_asrc_asrmcr1n_bitfields
    {
        uint32_t OW16 : 1;             /*!< [0]  */
        uint32_t OSGN : 1;             /*!< [1]  */
        uint32_t OMSB : 1;             /*!< [2]  */
        uint32_t RESERVED0 : 5;        /*!< [7:3]  */
        uint32_t IMSB : 1;             /*!< [8]  */
        uint32_t IWD : 3;              /*!< [11:9]  */
        uint32_t RESERVED1 : 20;       /*!< [31:12] This is a 24-bit register the
                                        * upper byte is unimplemented. */
    } B;
} hw_asrc_asrmcr1n_t;

/*!
 * @name Constants and macros for entire ASRC_ASRMCR1n register
 */
/*@{*/
#define HW_ASRC_ASRMCR1n_COUNT (3U)

#define HW_ASRC_ASRMCR1n_ADDR(x, n) ((uintptr_t)(x) + 0xC0U + (0x4U * (n)))

#define HW_ASRC_ASRMCR1n(x, n)   (*(__IO hw_asrc_asrmcr1n_t *) HW_ASRC_ASRMCR1n_ADDR(x, n))
#define HW_ASRC_ASRMCR1n_RD(x, n) (HW_ASRC_ASRMCR1n(x, n).U)
#define HW_ASRC_ASRMCR1n_WR(x, n, v) (HW_ASRC_ASRMCR1n(x, n).U = (v))
#define HW_ASRC_ASRMCR1n_SET(x, n, v) (HW_ASRC_ASRMCR1n_WR(x, n, HW_ASRC_ASRMCR1n_RD(x, n) |  (v)))
#define HW_ASRC_ASRMCR1n_CLR(x, n, v) (HW_ASRC_ASRMCR1n_WR(x, n, HW_ASRC_ASRMCR1n_RD(x, n) & ~(v)))
#define HW_ASRC_ASRMCR1n_TOG(x, n, v) (HW_ASRC_ASRMCR1n_WR(x, n, HW_ASRC_ASRMCR1n_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ASRC_ASRMCR1n bitfields
 */

/*!
 * @name Register ASRC_ASRMCR1n, field OW16[0] (RW)
 *
 * Bit Width Option of the output FIFO This bit will determine the bit width
 * option of the output FIFO.
 *
 * Values:
 * - 1 - 16-bit output data
 * - 0 - 24-bit output data.
 */
/*@{*/
#define BP_ASRC_ASRMCR1n_OW16 (0U)         /*!< Bit position for ASRC_ASRMCR1n_OW16. */
#define BM_ASRC_ASRMCR1n_OW16 (0x00000001U) /*!< Bit mask for ASRC_ASRMCR1n_OW16. */
#define BS_ASRC_ASRMCR1n_OW16 (1U)         /*!< Bit field size in bits for ASRC_ASRMCR1n_OW16. */

/*! @brief Read current value of the ASRC_ASRMCR1n_OW16 field. */
#define BR_ASRC_ASRMCR1n_OW16(x, n) (HW_ASRC_ASRMCR1n(x, n).B.OW16)

/*! @brief Format value for bitfield ASRC_ASRMCR1n_OW16. */
#define BF_ASRC_ASRMCR1n_OW16(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRMCR1n_OW16) & BM_ASRC_ASRMCR1n_OW16)

/*! @brief Set the OW16 field to a new value. */
#define BW_ASRC_ASRMCR1n_OW16(x, n, v) (HW_ASRC_ASRMCR1n_WR(x, n, (HW_ASRC_ASRMCR1n_RD(x, n) & ~BM_ASRC_ASRMCR1n_OW16) | BF_ASRC_ASRMCR1n_OW16(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRMCR1n, field OSGN[1] (RW)
 *
 * Sign Extension Option of the output FIFO This bit will determine the sign
 * extension option of the output FIFO.
 *
 * Values:
 * - 1 - Sign extension.
 * - 0 - No sign extension.
 */
/*@{*/
#define BP_ASRC_ASRMCR1n_OSGN (1U)         /*!< Bit position for ASRC_ASRMCR1n_OSGN. */
#define BM_ASRC_ASRMCR1n_OSGN (0x00000002U) /*!< Bit mask for ASRC_ASRMCR1n_OSGN. */
#define BS_ASRC_ASRMCR1n_OSGN (1U)         /*!< Bit field size in bits for ASRC_ASRMCR1n_OSGN. */

/*! @brief Read current value of the ASRC_ASRMCR1n_OSGN field. */
#define BR_ASRC_ASRMCR1n_OSGN(x, n) (HW_ASRC_ASRMCR1n(x, n).B.OSGN)

/*! @brief Format value for bitfield ASRC_ASRMCR1n_OSGN. */
#define BF_ASRC_ASRMCR1n_OSGN(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRMCR1n_OSGN) & BM_ASRC_ASRMCR1n_OSGN)

/*! @brief Set the OSGN field to a new value. */
#define BW_ASRC_ASRMCR1n_OSGN(x, n, v) (HW_ASRC_ASRMCR1n_WR(x, n, (HW_ASRC_ASRMCR1n_RD(x, n) & ~BM_ASRC_ASRMCR1n_OSGN) | BF_ASRC_ASRMCR1n_OSGN(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRMCR1n, field OMSB[2] (RW)
 *
 * Data Alignment of the output FIFO This bit will determine the data alignment
 * of the output FIFO.
 *
 * Values:
 * - 1 - MSB aligned.
 * - 0 - LSB aligned.
 */
/*@{*/
#define BP_ASRC_ASRMCR1n_OMSB (2U)         /*!< Bit position for ASRC_ASRMCR1n_OMSB. */
#define BM_ASRC_ASRMCR1n_OMSB (0x00000004U) /*!< Bit mask for ASRC_ASRMCR1n_OMSB. */
#define BS_ASRC_ASRMCR1n_OMSB (1U)         /*!< Bit field size in bits for ASRC_ASRMCR1n_OMSB. */

/*! @brief Read current value of the ASRC_ASRMCR1n_OMSB field. */
#define BR_ASRC_ASRMCR1n_OMSB(x, n) (HW_ASRC_ASRMCR1n(x, n).B.OMSB)

/*! @brief Format value for bitfield ASRC_ASRMCR1n_OMSB. */
#define BF_ASRC_ASRMCR1n_OMSB(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRMCR1n_OMSB) & BM_ASRC_ASRMCR1n_OMSB)

/*! @brief Set the OMSB field to a new value. */
#define BW_ASRC_ASRMCR1n_OMSB(x, n, v) (HW_ASRC_ASRMCR1n_WR(x, n, (HW_ASRC_ASRMCR1n_RD(x, n) & ~BM_ASRC_ASRMCR1n_OMSB) | BF_ASRC_ASRMCR1n_OMSB(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRMCR1n, field IMSB[8] (RW)
 *
 * Data Alignment of the input FIFO This bit will determine the data alignment
 * of the input FIFO.
 *
 * Values:
 * - 1 - MSB aligned.
 * - 0 - LSB aligned.
 */
/*@{*/
#define BP_ASRC_ASRMCR1n_IMSB (8U)         /*!< Bit position for ASRC_ASRMCR1n_IMSB. */
#define BM_ASRC_ASRMCR1n_IMSB (0x00000100U) /*!< Bit mask for ASRC_ASRMCR1n_IMSB. */
#define BS_ASRC_ASRMCR1n_IMSB (1U)         /*!< Bit field size in bits for ASRC_ASRMCR1n_IMSB. */

/*! @brief Read current value of the ASRC_ASRMCR1n_IMSB field. */
#define BR_ASRC_ASRMCR1n_IMSB(x, n) (HW_ASRC_ASRMCR1n(x, n).B.IMSB)

/*! @brief Format value for bitfield ASRC_ASRMCR1n_IMSB. */
#define BF_ASRC_ASRMCR1n_IMSB(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRMCR1n_IMSB) & BM_ASRC_ASRMCR1n_IMSB)

/*! @brief Set the IMSB field to a new value. */
#define BW_ASRC_ASRMCR1n_IMSB(x, n, v) (HW_ASRC_ASRMCR1n_WR(x, n, (HW_ASRC_ASRMCR1n_RD(x, n) & ~BM_ASRC_ASRMCR1n_IMSB) | BF_ASRC_ASRMCR1n_IMSB(v)))
/*@}*/

/*!
 * @name Register ASRC_ASRMCR1n, field IWD[11:9] (RW)
 *
 * Data Width of the input FIFO These three bits will determine the bitwidth for
 * the audio data into ASRC All other settings not shown are reserved. 3'b000
 * 24-bit audio data. 3'b001 16-bit audio data. 3'b010 8-bit audio data.
 */
/*@{*/
#define BP_ASRC_ASRMCR1n_IWD (9U)          /*!< Bit position for ASRC_ASRMCR1n_IWD. */
#define BM_ASRC_ASRMCR1n_IWD (0x00000E00U) /*!< Bit mask for ASRC_ASRMCR1n_IWD. */
#define BS_ASRC_ASRMCR1n_IWD (3U)          /*!< Bit field size in bits for ASRC_ASRMCR1n_IWD. */

/*! @brief Read current value of the ASRC_ASRMCR1n_IWD field. */
#define BR_ASRC_ASRMCR1n_IWD(x, n) (HW_ASRC_ASRMCR1n(x, n).B.IWD)

/*! @brief Format value for bitfield ASRC_ASRMCR1n_IWD. */
#define BF_ASRC_ASRMCR1n_IWD(v) ((uint32_t)((uint32_t)(v) << BP_ASRC_ASRMCR1n_IWD) & BM_ASRC_ASRMCR1n_IWD)

/*! @brief Set the IWD field to a new value. */
#define BW_ASRC_ASRMCR1n_IWD(x, n, v) (HW_ASRC_ASRMCR1n_WR(x, n, (HW_ASRC_ASRMCR1n_RD(x, n) & ~BM_ASRC_ASRMCR1n_IWD) | BF_ASRC_ASRMCR1n_IWD(v)))
/*@}*/

/*******************************************************************************
 * hw_asrc_t - module struct
 ******************************************************************************/
/*!
 * @brief All ASRC module registers.
 */
#pragma pack(1)
typedef struct _hw_asrc
{
    __IO hw_asrc_asrctr_t ASRCTR;          /*!< [0x0] ASRC Control Register */
    __IO hw_asrc_asrier_t ASRIER;          /*!< [0x4] ASRC Interrupt Enable Register */
    uint8_t _reserved0[4];
    __IO hw_asrc_asrcncr_t ASRCNCR;        /*!< [0xC] ASRC Channel Number Configuration Register */
    __IO hw_asrc_asrcfg_t ASRCFG;          /*!< [0x10] ASRC Filter Configuration Status Register */
    __IO hw_asrc_asrcsr_t ASRCSR;          /*!< [0x14] ASRC Clock Source Register */
    __IO hw_asrc_asrcdr1_t ASRCDR1;        /*!< [0x18] ASRC Clock Divider Register 1 */
    __IO hw_asrc_asrcdr2_t ASRCDR2;        /*!< [0x1C] ASRC Clock Divider Register 2 */
    __I hw_asrc_asrstr_t ASRSTR;           /*!< [0x20] ASRC Status Register */
    uint8_t _reserved1[28];
    __IO hw_asrc_asrpmn1_t ASRPMn1;        /*!< [0x40] ASRC Parameter Register n */
    __IO hw_asrc_asrpmn2_t ASRPMn2;        /*!< [0x44] ASRC Parameter Register n */
    __IO hw_asrc_asrpmn3_t ASRPMn3;        /*!< [0x48] ASRC Parameter Register n */
    __IO hw_asrc_asrpmn4_t ASRPMn4;        /*!< [0x4C] ASRC Parameter Register n */
    __IO hw_asrc_asrpmn5_t ASRPMn5;        /*!< [0x50] ASRC Parameter Register n */
    __IO hw_asrc_asrtfr1_t ASRTFR1;        /*!< [0x54] ASRC ASRC Task Queue FIFO Register 1 */
    uint8_t _reserved2[4];
    __IO hw_asrc_asrccr_t ASRCCR;          /*!< [0x5C] ASRC Channel Counter Register */
    struct {
        __O hw_asrc_asrdin_t ASRDIn;       /*!< [0x60] ASRC Data Input Register for Pair x */
        __I hw_asrc_asrdon_t ASRDOn;       /*!< [0x64] ASRC Data Output Register for Pair x */
    } ASRD[3];
    uint8_t _reserved3[8];
    __IO hw_asrc_asridrha_t ASRIDRHA;      /*!< [0x80] ASRC Ideal Ratio for Pair A-High Part */
    __IO hw_asrc_asridrla_t ASRIDRLA;      /*!< [0x84] ASRC Ideal Ratio for Pair A -Low Part */
    __IO hw_asrc_asridrhb_t ASRIDRHB;      /*!< [0x88] ASRC Ideal Ratio for Pair B-High Part */
    __IO hw_asrc_asridrlb_t ASRIDRLB;      /*!< [0x8C] ASRC Ideal Ratio for Pair B-Low Part */
    __IO hw_asrc_asridrhc_t ASRIDRHC;      /*!< [0x90] ASRC Ideal Ratio for Pair C-High Part */
    __IO hw_asrc_asridrlc_t ASRIDRLC;      /*!< [0x94] ASRC Ideal Ratio for Pair C-Low Part */
    __IO hw_asrc_asr76k_t ASR76K;          /*!< [0x98] ASRC 76kHz Period in terms of ASRC processing clock */
    __IO hw_asrc_asr56k_t ASR56K;          /*!< [0x9C] ASRC 56kHz Period in terms of ASRC processing clock */
    __IO hw_asrc_asrmcra_t ASRMCRA;        /*!< [0xA0] ASRC Misc Control Register for Pair A */
    __I hw_asrc_asrfsta_t ASRFSTA;         /*!< [0xA4] ASRC FIFO Status Register for Pair A */
    __IO hw_asrc_asrmcrb_t ASRMCRB;        /*!< [0xA8] ASRC Misc Control Register for Pair B */
    __I hw_asrc_asrfstb_t ASRFSTB;         /*!< [0xAC] ASRC FIFO Status Register for Pair B */
    __IO hw_asrc_asrmcrc_t ASRMCRC;        /*!< [0xB0] ASRC Misc Control Register for Pair C */
    __I hw_asrc_asrfstc_t ASRFSTC;         /*!< [0xB4] ASRC FIFO Status Register for Pair C */
    uint8_t _reserved4[8];
    __IO hw_asrc_asrmcr1n_t ASRMCR1n[3];   /*!< [0xC0] ASRC Misc Control Register 1 for Pair X */
} hw_asrc_t;
#pragma pack()

/*! @brief Macro to access all ASRC registers. */
/*! @param x ASRC module instance base address. */
/*! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
 *     use the '&' operator, like <code>&HW_ASRC_REGS(ASRC_BASE)</code>. */
#define HW_ASRC_REGS(x) (*(hw_asrc_t *)(x))

/*
 * iMX6SX AUDMUX
 *
 * AUDMUX Registers
 *
 * Registers defined in this header file:
 * - HW_AUDMUX_PTCR1 - Port Timing Control Register 1
 * - HW_AUDMUX_PDCR1 - Port Data Control Register 1
 * - HW_AUDMUX_PTCR2 - Port Timing Control Register 2
 * - HW_AUDMUX_PDCR2 - Port Data Control Register 2
 * - HW_AUDMUX_PTCR3 - Port Timing Control Register 3
 * - HW_AUDMUX_PDCR3 - Port Data Control Register 3
 * - HW_AUDMUX_PTCR4 - Port Timing Control Register 4
 * - HW_AUDMUX_PDCR4 - Port Data Control Register 4
 * - HW_AUDMUX_PTCR5 - Port Timing Control Register 5
 * - HW_AUDMUX_PDCR5 - Port Data Control Register 5
 * - HW_AUDMUX_PTCR6 - Port Timing Control Register 6
 * - HW_AUDMUX_PDCR6 - Port Data Control Register 6
 * - HW_AUDMUX_PTCR7 - Port Timing Control Register 7
 * - HW_AUDMUX_PDCR7 - Port Data Control Register 7
 *
 * - hw_audmux_t - Struct containing all module registers.
 */

#define HW_AUDMUX_INSTANCE_COUNT (1U) /*!< Number of instances of the AUDMUX module. */
#define HW_AUDMUX (0U) /*!< Instance number for AUDMUX. */
#define AUDMUX_BASE           (0x21D8000U) /*!< Base address for AUDMUX. */
/*! Array initializer of AUDMUX base addresses. */
#define AUDMUX_BASE_ADDRS     { AUDMUX_BASE }

/*******************************************************************************
 * HW_AUDMUX_PTCR1 - Port Timing Control Register 1
 ******************************************************************************/

/*!
 * @brief HW_AUDMUX_PTCR1 - Port Timing Control Register 1 (RW)
 *
 * Reset value: 0xAD400800U
 *
 * PTCR1 is the Port Timing Control Register for Port 1.
 */
typedef union _hw_audmux_ptcr1
{
    uint32_t U;
    struct _hw_audmux_ptcr1_bitfields
    {
        uint32_t RESERVED0 : 11;       /*!< [10:0]  */
        uint32_t SYN : 1;              /*!< [11]  */
        uint32_t RCSEL : 4;            /*!< [15:12]  */
        uint32_t RCLKDIR : 1;          /*!< [16]  */
        uint32_t RFSEL : 4;            /*!< [20:17]  */
        uint32_t RFS_DIR : 1;          /*!< [21]  */
        uint32_t TCSEL : 4;            /*!< [25:22]  */
        uint32_t TCLKDIR : 1;          /*!< [26]  */
        uint32_t TFSEL : 4;            /*!< [30:27]  */
        uint32_t TFS_DIR : 1;          /*!< [31]  */
    } B;
} hw_audmux_ptcr1_t;

/*!
 * @name Constants and macros for entire AUDMUX_PTCR1 register
 */
/*@{*/
#define HW_AUDMUX_PTCR1_ADDR(x)  ((uintptr_t)(x) + 0x0U)

#define HW_AUDMUX_PTCR1(x)       (*(__IO hw_audmux_ptcr1_t *) HW_AUDMUX_PTCR1_ADDR(x))
#define HW_AUDMUX_PTCR1_RD(x)    (HW_AUDMUX_PTCR1(x).U)
#define HW_AUDMUX_PTCR1_WR(x, v) (HW_AUDMUX_PTCR1(x).U = (v))
#define HW_AUDMUX_PTCR1_SET(x, v) (HW_AUDMUX_PTCR1_WR(x, HW_AUDMUX_PTCR1_RD(x) |  (v)))
#define HW_AUDMUX_PTCR1_CLR(x, v) (HW_AUDMUX_PTCR1_WR(x, HW_AUDMUX_PTCR1_RD(x) & ~(v)))
#define HW_AUDMUX_PTCR1_TOG(x, v) (HW_AUDMUX_PTCR1_WR(x, HW_AUDMUX_PTCR1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AUDMUX_PTCR1 bitfields
 */

/*!
 * @name Register AUDMUX_PTCR1, field SYN[11] (RW)
 *
 * Synchronous/Asynchronous Select. When SYN is set, synchronous mode is chosen
 * and the transmit and receive sections use common clock and frame sync signals
 * (that is, the port is a 4-wire interface). When SYN is cleared, asynchronous
 * mode is chosen and separate clock and frame sync signals are used for the
 * transmit and receive sections (that is, the port is a 6-wire interface). RCLKDIR
 * and SYN should not be changed at the same time.
 *
 * Values:
 * - 0 - Asynchronous mode
 * - 1 - Synchronous mode (default)
 */
/*@{*/
#define BP_AUDMUX_PTCR1_SYN  (11U)         /*!< Bit position for AUDMUX_PTCR1_SYN. */
#define BM_AUDMUX_PTCR1_SYN  (0x00000800U) /*!< Bit mask for AUDMUX_PTCR1_SYN. */
#define BS_AUDMUX_PTCR1_SYN  (1U)          /*!< Bit field size in bits for AUDMUX_PTCR1_SYN. */

/*! @brief Read current value of the AUDMUX_PTCR1_SYN field. */
#define BR_AUDMUX_PTCR1_SYN(x) (HW_AUDMUX_PTCR1(x).B.SYN)

/*! @brief Format value for bitfield AUDMUX_PTCR1_SYN. */
#define BF_AUDMUX_PTCR1_SYN(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR1_SYN) & BM_AUDMUX_PTCR1_SYN)

/*! @brief Set the SYN field to a new value. */
#define BW_AUDMUX_PTCR1_SYN(x, v) (HW_AUDMUX_PTCR1_WR(x, (HW_AUDMUX_PTCR1_RD(x) & ~BM_AUDMUX_PTCR1_SYN) | BF_AUDMUX_PTCR1_SYN(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR1, field RCSEL[15:12] (RW)
 *
 * Receive Clock Select. Selects the source port from which RXC is sourced. RXC
 * can be sourced from TXC and RXC from other ports.
 *
 * Values:
 * - 1xxx - Selects RXC from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR1_RCSEL (12U)        /*!< Bit position for AUDMUX_PTCR1_RCSEL. */
#define BM_AUDMUX_PTCR1_RCSEL (0x0000F000U) /*!< Bit mask for AUDMUX_PTCR1_RCSEL. */
#define BS_AUDMUX_PTCR1_RCSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR1_RCSEL. */

/*! @brief Read current value of the AUDMUX_PTCR1_RCSEL field. */
#define BR_AUDMUX_PTCR1_RCSEL(x) (HW_AUDMUX_PTCR1(x).B.RCSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR1_RCSEL. */
#define BF_AUDMUX_PTCR1_RCSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR1_RCSEL) & BM_AUDMUX_PTCR1_RCSEL)

/*! @brief Set the RCSEL field to a new value. */
#define BW_AUDMUX_PTCR1_RCSEL(x, v) (HW_AUDMUX_PTCR1_WR(x, (HW_AUDMUX_PTCR1_RD(x) & ~BM_AUDMUX_PTCR1_RCSEL) | BF_AUDMUX_PTCR1_RCSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR1, field RCLKDIR[16] (RW)
 *
 * Receive Clock Direction Control. This bit sets the direction of the RXC pin
 * of the interface as an output or input. When set as an input, the RCSEL
 * settings are ignored. When set as an output, the RCSEL settings determine the source
 * port of the clock. RCLKDIR and SYN should not be changed at the same time.
 *
 * Values:
 * - 0 - RXC is an input.
 * - 1 - RXC is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR1_RCLKDIR (16U)      /*!< Bit position for AUDMUX_PTCR1_RCLKDIR. */
#define BM_AUDMUX_PTCR1_RCLKDIR (0x00010000U) /*!< Bit mask for AUDMUX_PTCR1_RCLKDIR. */
#define BS_AUDMUX_PTCR1_RCLKDIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR1_RCLKDIR. */

/*! @brief Read current value of the AUDMUX_PTCR1_RCLKDIR field. */
#define BR_AUDMUX_PTCR1_RCLKDIR(x) (HW_AUDMUX_PTCR1(x).B.RCLKDIR)

/*! @brief Format value for bitfield AUDMUX_PTCR1_RCLKDIR. */
#define BF_AUDMUX_PTCR1_RCLKDIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR1_RCLKDIR) & BM_AUDMUX_PTCR1_RCLKDIR)

/*! @brief Set the RCLKDIR field to a new value. */
#define BW_AUDMUX_PTCR1_RCLKDIR(x, v) (HW_AUDMUX_PTCR1_WR(x, (HW_AUDMUX_PTCR1_RD(x) & ~BM_AUDMUX_PTCR1_RCLKDIR) | BF_AUDMUX_PTCR1_RCLKDIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR1, field RFSEL[20:17] (RW)
 *
 * Receive Frame Sync Select. Selects the source port from which RXFS is
 * sourced. RXFS can be sourced from TXFS and RXFS from other ports.
 *
 * Values:
 * - 1xxx - Selects RXFS from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR1_RFSEL (17U)        /*!< Bit position for AUDMUX_PTCR1_RFSEL. */
#define BM_AUDMUX_PTCR1_RFSEL (0x001E0000U) /*!< Bit mask for AUDMUX_PTCR1_RFSEL. */
#define BS_AUDMUX_PTCR1_RFSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR1_RFSEL. */

/*! @brief Read current value of the AUDMUX_PTCR1_RFSEL field. */
#define BR_AUDMUX_PTCR1_RFSEL(x) (HW_AUDMUX_PTCR1(x).B.RFSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR1_RFSEL. */
#define BF_AUDMUX_PTCR1_RFSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR1_RFSEL) & BM_AUDMUX_PTCR1_RFSEL)

/*! @brief Set the RFSEL field to a new value. */
#define BW_AUDMUX_PTCR1_RFSEL(x, v) (HW_AUDMUX_PTCR1_WR(x, (HW_AUDMUX_PTCR1_RD(x) & ~BM_AUDMUX_PTCR1_RFSEL) | BF_AUDMUX_PTCR1_RFSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR1, field RFS_DIR[21] (RW)
 *
 * Receive Frame Sync Direction Control. This bit sets the direction of the RXFS
 * pin of the interface as an output or input. When set as an input, the RFSEL
 * settings are ignored. When set as an output, the RFSEL settings determine the
 * source port of the frame sync.
 *
 * Values:
 * - 0 - RXFS is an input.
 * - 1 - RXFS is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR1_RFS_DIR (21U)      /*!< Bit position for AUDMUX_PTCR1_RFS_DIR. */
#define BM_AUDMUX_PTCR1_RFS_DIR (0x00200000U) /*!< Bit mask for AUDMUX_PTCR1_RFS_DIR. */
#define BS_AUDMUX_PTCR1_RFS_DIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR1_RFS_DIR. */

/*! @brief Read current value of the AUDMUX_PTCR1_RFS_DIR field. */
#define BR_AUDMUX_PTCR1_RFS_DIR(x) (HW_AUDMUX_PTCR1(x).B.RFS_DIR)

/*! @brief Format value for bitfield AUDMUX_PTCR1_RFS_DIR. */
#define BF_AUDMUX_PTCR1_RFS_DIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR1_RFS_DIR) & BM_AUDMUX_PTCR1_RFS_DIR)

/*! @brief Set the RFS_DIR field to a new value. */
#define BW_AUDMUX_PTCR1_RFS_DIR(x, v) (HW_AUDMUX_PTCR1_WR(x, (HW_AUDMUX_PTCR1_RD(x) & ~BM_AUDMUX_PTCR1_RFS_DIR) | BF_AUDMUX_PTCR1_RFS_DIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR1, field TCSEL[25:22] (RW)
 *
 * Transmit Clock Select. Selects the source port from which TXC is sourced.
 *
 * Values:
 * - 1xxx - Selects RXC from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR1_TCSEL (22U)        /*!< Bit position for AUDMUX_PTCR1_TCSEL. */
#define BM_AUDMUX_PTCR1_TCSEL (0x03C00000U) /*!< Bit mask for AUDMUX_PTCR1_TCSEL. */
#define BS_AUDMUX_PTCR1_TCSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR1_TCSEL. */

/*! @brief Read current value of the AUDMUX_PTCR1_TCSEL field. */
#define BR_AUDMUX_PTCR1_TCSEL(x) (HW_AUDMUX_PTCR1(x).B.TCSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR1_TCSEL. */
#define BF_AUDMUX_PTCR1_TCSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR1_TCSEL) & BM_AUDMUX_PTCR1_TCSEL)

/*! @brief Set the TCSEL field to a new value. */
#define BW_AUDMUX_PTCR1_TCSEL(x, v) (HW_AUDMUX_PTCR1_WR(x, (HW_AUDMUX_PTCR1_RD(x) & ~BM_AUDMUX_PTCR1_TCSEL) | BF_AUDMUX_PTCR1_TCSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR1, field TCLKDIR[26] (RW)
 *
 * Transmit Clock Direction Control. This bit sets the direction of the TXC pin
 * of the interface as an output or input. When set as an input, the TCSEL
 * settings are ignored. When set as an output, the TCSEL settings determine the source
 * port of the clock.
 *
 * Values:
 * - 0 - TXC is an input.
 * - 1 - TXC is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR1_TCLKDIR (26U)      /*!< Bit position for AUDMUX_PTCR1_TCLKDIR. */
#define BM_AUDMUX_PTCR1_TCLKDIR (0x04000000U) /*!< Bit mask for AUDMUX_PTCR1_TCLKDIR. */
#define BS_AUDMUX_PTCR1_TCLKDIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR1_TCLKDIR. */

/*! @brief Read current value of the AUDMUX_PTCR1_TCLKDIR field. */
#define BR_AUDMUX_PTCR1_TCLKDIR(x) (HW_AUDMUX_PTCR1(x).B.TCLKDIR)

/*! @brief Format value for bitfield AUDMUX_PTCR1_TCLKDIR. */
#define BF_AUDMUX_PTCR1_TCLKDIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR1_TCLKDIR) & BM_AUDMUX_PTCR1_TCLKDIR)

/*! @brief Set the TCLKDIR field to a new value. */
#define BW_AUDMUX_PTCR1_TCLKDIR(x, v) (HW_AUDMUX_PTCR1_WR(x, (HW_AUDMUX_PTCR1_RD(x) & ~BM_AUDMUX_PTCR1_TCLKDIR) | BF_AUDMUX_PTCR1_TCLKDIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR1, field TFSEL[30:27] (RW)
 *
 * Transmit Frame Sync Select. Selects the source port from which TXFS is
 * sourced.
 *
 * Values:
 * - 1xxx - Selects RXFS from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR1_TFSEL (27U)        /*!< Bit position for AUDMUX_PTCR1_TFSEL. */
#define BM_AUDMUX_PTCR1_TFSEL (0x78000000U) /*!< Bit mask for AUDMUX_PTCR1_TFSEL. */
#define BS_AUDMUX_PTCR1_TFSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR1_TFSEL. */

/*! @brief Read current value of the AUDMUX_PTCR1_TFSEL field. */
#define BR_AUDMUX_PTCR1_TFSEL(x) (HW_AUDMUX_PTCR1(x).B.TFSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR1_TFSEL. */
#define BF_AUDMUX_PTCR1_TFSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR1_TFSEL) & BM_AUDMUX_PTCR1_TFSEL)

/*! @brief Set the TFSEL field to a new value. */
#define BW_AUDMUX_PTCR1_TFSEL(x, v) (HW_AUDMUX_PTCR1_WR(x, (HW_AUDMUX_PTCR1_RD(x) & ~BM_AUDMUX_PTCR1_TFSEL) | BF_AUDMUX_PTCR1_TFSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR1, field TFS_DIR[31] (RW)
 *
 * Transmit Frame Sync Direction Control. This bit sets the direction of the
 * TXFS pin of the interface as an output or input. When set as an input, the TFSEL
 * settings are ignored. When set as an output, the TFSEL settings determine the
 * source port of the frame sync.
 *
 * Values:
 * - 0 - TXFS is an input.
 * - 1 - TXFS is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR1_TFS_DIR (31U)      /*!< Bit position for AUDMUX_PTCR1_TFS_DIR. */
#define BM_AUDMUX_PTCR1_TFS_DIR (0x80000000U) /*!< Bit mask for AUDMUX_PTCR1_TFS_DIR. */
#define BS_AUDMUX_PTCR1_TFS_DIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR1_TFS_DIR. */

/*! @brief Read current value of the AUDMUX_PTCR1_TFS_DIR field. */
#define BR_AUDMUX_PTCR1_TFS_DIR(x) (HW_AUDMUX_PTCR1(x).B.TFS_DIR)

/*! @brief Format value for bitfield AUDMUX_PTCR1_TFS_DIR. */
#define BF_AUDMUX_PTCR1_TFS_DIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR1_TFS_DIR) & BM_AUDMUX_PTCR1_TFS_DIR)

/*! @brief Set the TFS_DIR field to a new value. */
#define BW_AUDMUX_PTCR1_TFS_DIR(x, v) (HW_AUDMUX_PTCR1_WR(x, (HW_AUDMUX_PTCR1_RD(x) & ~BM_AUDMUX_PTCR1_TFS_DIR) | BF_AUDMUX_PTCR1_TFS_DIR(v)))
/*@}*/

/*******************************************************************************
 * HW_AUDMUX_PDCR1 - Port Data Control Register 1
 ******************************************************************************/

/*!
 * @brief HW_AUDMUX_PDCR1 - Port Data Control Register 1 (RW)
 *
 * Reset value: 0x0000A000U
 *
 * PDCR1 is the Port Data Control Register for Port 1.
 */
typedef union _hw_audmux_pdcr1
{
    uint32_t U;
    struct _hw_audmux_pdcr1_bitfields
    {
        uint32_t INMMASK : 8;          /*!< [7:0]  */
        uint32_t MODE : 1;             /*!< [8]  */
        uint32_t RESERVED0 : 3;        /*!< [11:9]  */
        uint32_t TXRXEN : 1;           /*!< [12]  */
        uint32_t RXDSEL : 3;           /*!< [15:13]  */
        uint32_t RESERVED1 : 16;       /*!< [31:16]  */
    } B;
} hw_audmux_pdcr1_t;

/*!
 * @name Constants and macros for entire AUDMUX_PDCR1 register
 */
/*@{*/
#define HW_AUDMUX_PDCR1_ADDR(x)  ((uintptr_t)(x) + 0x4U)

#define HW_AUDMUX_PDCR1(x)       (*(__IO hw_audmux_pdcr1_t *) HW_AUDMUX_PDCR1_ADDR(x))
#define HW_AUDMUX_PDCR1_RD(x)    (HW_AUDMUX_PDCR1(x).U)
#define HW_AUDMUX_PDCR1_WR(x, v) (HW_AUDMUX_PDCR1(x).U = (v))
#define HW_AUDMUX_PDCR1_SET(x, v) (HW_AUDMUX_PDCR1_WR(x, HW_AUDMUX_PDCR1_RD(x) |  (v)))
#define HW_AUDMUX_PDCR1_CLR(x, v) (HW_AUDMUX_PDCR1_WR(x, HW_AUDMUX_PDCR1_RD(x) & ~(v)))
#define HW_AUDMUX_PDCR1_TOG(x, v) (HW_AUDMUX_PDCR1_WR(x, HW_AUDMUX_PDCR1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AUDMUX_PDCR1 bitfields
 */

/*!
 * @name Register AUDMUX_PDCR1, field INMMASK[7:0] (RW)
 *
 * Internal Network Mode Mask. Bit mask that selects the ports from which the
 * RXD signals are to be ANDed together for internal network mode. Bit 6 represents
 * RXD from Port 7 and bit0 represents RXD from Port 1.
 *
 * Values:
 * - 0 - Includes RXDn for ANDing
 * - 1 - Excludes RXDn from ANDing
 */
/*@{*/
#define BP_AUDMUX_PDCR1_INMMASK (0U)       /*!< Bit position for AUDMUX_PDCR1_INMMASK. */
#define BM_AUDMUX_PDCR1_INMMASK (0x000000FFU) /*!< Bit mask for AUDMUX_PDCR1_INMMASK. */
#define BS_AUDMUX_PDCR1_INMMASK (8U)       /*!< Bit field size in bits for AUDMUX_PDCR1_INMMASK. */

/*! @brief Read current value of the AUDMUX_PDCR1_INMMASK field. */
#define BR_AUDMUX_PDCR1_INMMASK(x) (HW_AUDMUX_PDCR1(x).B.INMMASK)

/*! @brief Format value for bitfield AUDMUX_PDCR1_INMMASK. */
#define BF_AUDMUX_PDCR1_INMMASK(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR1_INMMASK) & BM_AUDMUX_PDCR1_INMMASK)

/*! @brief Set the INMMASK field to a new value. */
#define BW_AUDMUX_PDCR1_INMMASK(x, v) (HW_AUDMUX_PDCR1_WR(x, (HW_AUDMUX_PDCR1_RD(x) & ~BM_AUDMUX_PDCR1_INMMASK) | BF_AUDMUX_PDCR1_INMMASK(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR1, field MODE[8] (RW)
 *
 * Mode Select. This field selects the mode in which the port is to operate. The
 * modes of operation include the following: Normal mode, in which the RXD from
 * the port selected by RXDSEL is routed to the port. Internal Network mode in
 * which RXD from other ports are ANDed together. RXDSEL is ignored. INMMASK
 * determines which RXD signals are ANDed together.
 *
 * Values:
 * - 0 - Normal mode
 * - 1 - Internal Network mode
 */
/*@{*/
#define BP_AUDMUX_PDCR1_MODE (8U)          /*!< Bit position for AUDMUX_PDCR1_MODE. */
#define BM_AUDMUX_PDCR1_MODE (0x00000100U) /*!< Bit mask for AUDMUX_PDCR1_MODE. */
#define BS_AUDMUX_PDCR1_MODE (1U)          /*!< Bit field size in bits for AUDMUX_PDCR1_MODE. */

/*! @brief Read current value of the AUDMUX_PDCR1_MODE field. */
#define BR_AUDMUX_PDCR1_MODE(x) (HW_AUDMUX_PDCR1(x).B.MODE)

/*! @brief Format value for bitfield AUDMUX_PDCR1_MODE. */
#define BF_AUDMUX_PDCR1_MODE(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR1_MODE) & BM_AUDMUX_PDCR1_MODE)

/*! @brief Set the MODE field to a new value. */
#define BW_AUDMUX_PDCR1_MODE(x, v) (HW_AUDMUX_PDCR1_WR(x, (HW_AUDMUX_PDCR1_RD(x) & ~BM_AUDMUX_PDCR1_MODE) | BF_AUDMUX_PDCR1_MODE(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR1, field TXRXEN[12] (RW)
 *
 * Transmit/Receive Switch Enable. Swaps the transmit and receive signals.
 *
 * Values:
 * - 0 - No switch (Transmit Pin = Transmit, Receive Pin = Receive)
 * - 1 - Switch (Transmit Pin = Receive, Receive Pin = Transmit)
 */
/*@{*/
#define BP_AUDMUX_PDCR1_TXRXEN (12U)       /*!< Bit position for AUDMUX_PDCR1_TXRXEN. */
#define BM_AUDMUX_PDCR1_TXRXEN (0x00001000U) /*!< Bit mask for AUDMUX_PDCR1_TXRXEN. */
#define BS_AUDMUX_PDCR1_TXRXEN (1U)        /*!< Bit field size in bits for AUDMUX_PDCR1_TXRXEN. */

/*! @brief Read current value of the AUDMUX_PDCR1_TXRXEN field. */
#define BR_AUDMUX_PDCR1_TXRXEN(x) (HW_AUDMUX_PDCR1(x).B.TXRXEN)

/*! @brief Format value for bitfield AUDMUX_PDCR1_TXRXEN. */
#define BF_AUDMUX_PDCR1_TXRXEN(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR1_TXRXEN) & BM_AUDMUX_PDCR1_TXRXEN)

/*! @brief Set the TXRXEN field to a new value. */
#define BW_AUDMUX_PDCR1_TXRXEN(x, v) (HW_AUDMUX_PDCR1_WR(x, (HW_AUDMUX_PDCR1_RD(x) & ~BM_AUDMUX_PDCR1_TXRXEN) | BF_AUDMUX_PDCR1_TXRXEN(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR1, field RXDSEL[15:13] (RW)
 *
 * Receive Data Select. Selects the source port for the RXD data. RXDSEL is
 * ignored if MODE = 1 (that is, Internal Network Mode is enabled).
 *
 * Values:
 * - xxx - Port number for RXD
 * - 000 - Port 1
 * - 110 - Port 7
 * - 111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PDCR1_RXDSEL (13U)       /*!< Bit position for AUDMUX_PDCR1_RXDSEL. */
#define BM_AUDMUX_PDCR1_RXDSEL (0x0000E000U) /*!< Bit mask for AUDMUX_PDCR1_RXDSEL. */
#define BS_AUDMUX_PDCR1_RXDSEL (3U)        /*!< Bit field size in bits for AUDMUX_PDCR1_RXDSEL. */

/*! @brief Read current value of the AUDMUX_PDCR1_RXDSEL field. */
#define BR_AUDMUX_PDCR1_RXDSEL(x) (HW_AUDMUX_PDCR1(x).B.RXDSEL)

/*! @brief Format value for bitfield AUDMUX_PDCR1_RXDSEL. */
#define BF_AUDMUX_PDCR1_RXDSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR1_RXDSEL) & BM_AUDMUX_PDCR1_RXDSEL)

/*! @brief Set the RXDSEL field to a new value. */
#define BW_AUDMUX_PDCR1_RXDSEL(x, v) (HW_AUDMUX_PDCR1_WR(x, (HW_AUDMUX_PDCR1_RD(x) & ~BM_AUDMUX_PDCR1_RXDSEL) | BF_AUDMUX_PDCR1_RXDSEL(v)))
/*@}*/

/*******************************************************************************
 * HW_AUDMUX_PTCR2 - Port Timing Control Register 2
 ******************************************************************************/

/*!
 * @brief HW_AUDMUX_PTCR2 - Port Timing Control Register 2 (RW)
 *
 * Reset value: 0xA5000800U
 *
 * PTCR2 is the Port Timing Control Register for Port 2.
 */
typedef union _hw_audmux_ptcr2
{
    uint32_t U;
    struct _hw_audmux_ptcr2_bitfields
    {
        uint32_t RESERVED0 : 11;       /*!< [10:0]  */
        uint32_t SYN : 1;              /*!< [11]  */
        uint32_t RCSEL : 4;            /*!< [15:12]  */
        uint32_t RCLKDIR : 1;          /*!< [16]  */
        uint32_t RFSEL : 4;            /*!< [20:17]  */
        uint32_t RFS_DIR : 1;          /*!< [21]  */
        uint32_t TCSEL : 4;            /*!< [25:22]  */
        uint32_t TCLKDIR : 1;          /*!< [26]  */
        uint32_t TFSEL : 4;            /*!< [30:27]  */
        uint32_t TFS_DIR : 1;          /*!< [31]  */
    } B;
} hw_audmux_ptcr2_t;

/*!
 * @name Constants and macros for entire AUDMUX_PTCR2 register
 */
/*@{*/
#define HW_AUDMUX_PTCR2_ADDR(x)  ((uintptr_t)(x) + 0x8U)

#define HW_AUDMUX_PTCR2(x)       (*(__IO hw_audmux_ptcr2_t *) HW_AUDMUX_PTCR2_ADDR(x))
#define HW_AUDMUX_PTCR2_RD(x)    (HW_AUDMUX_PTCR2(x).U)
#define HW_AUDMUX_PTCR2_WR(x, v) (HW_AUDMUX_PTCR2(x).U = (v))
#define HW_AUDMUX_PTCR2_SET(x, v) (HW_AUDMUX_PTCR2_WR(x, HW_AUDMUX_PTCR2_RD(x) |  (v)))
#define HW_AUDMUX_PTCR2_CLR(x, v) (HW_AUDMUX_PTCR2_WR(x, HW_AUDMUX_PTCR2_RD(x) & ~(v)))
#define HW_AUDMUX_PTCR2_TOG(x, v) (HW_AUDMUX_PTCR2_WR(x, HW_AUDMUX_PTCR2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AUDMUX_PTCR2 bitfields
 */

/*!
 * @name Register AUDMUX_PTCR2, field SYN[11] (RW)
 *
 * Synchronous/Asynchronous Select. When SYN is set, synchronous mode is chosen
 * and the transmit and receive sections use common clock and frame sync signals
 * (that is, the port is a 4-wire interface). When SYN is cleared, asynchronous
 * mode is chosen and separate clock and frame sync signals are used for the
 * transmit and receive sections (that is, the port is a 6-wire interface). RCLKDIR
 * and SYN should not be changed at the same time.
 *
 * Values:
 * - 0 - Asynchronous mode
 * - 1 - Synchronous mode (default)
 */
/*@{*/
#define BP_AUDMUX_PTCR2_SYN  (11U)         /*!< Bit position for AUDMUX_PTCR2_SYN. */
#define BM_AUDMUX_PTCR2_SYN  (0x00000800U) /*!< Bit mask for AUDMUX_PTCR2_SYN. */
#define BS_AUDMUX_PTCR2_SYN  (1U)          /*!< Bit field size in bits for AUDMUX_PTCR2_SYN. */

/*! @brief Read current value of the AUDMUX_PTCR2_SYN field. */
#define BR_AUDMUX_PTCR2_SYN(x) (HW_AUDMUX_PTCR2(x).B.SYN)

/*! @brief Format value for bitfield AUDMUX_PTCR2_SYN. */
#define BF_AUDMUX_PTCR2_SYN(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR2_SYN) & BM_AUDMUX_PTCR2_SYN)

/*! @brief Set the SYN field to a new value. */
#define BW_AUDMUX_PTCR2_SYN(x, v) (HW_AUDMUX_PTCR2_WR(x, (HW_AUDMUX_PTCR2_RD(x) & ~BM_AUDMUX_PTCR2_SYN) | BF_AUDMUX_PTCR2_SYN(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR2, field RCSEL[15:12] (RW)
 *
 * Receive Clock Select. Selects the source port from which RXC is sourced. RXC
 * can be sourced from TXC and RXC from other ports.
 *
 * Values:
 * - 1xxx - Selects RXC from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR2_RCSEL (12U)        /*!< Bit position for AUDMUX_PTCR2_RCSEL. */
#define BM_AUDMUX_PTCR2_RCSEL (0x0000F000U) /*!< Bit mask for AUDMUX_PTCR2_RCSEL. */
#define BS_AUDMUX_PTCR2_RCSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR2_RCSEL. */

/*! @brief Read current value of the AUDMUX_PTCR2_RCSEL field. */
#define BR_AUDMUX_PTCR2_RCSEL(x) (HW_AUDMUX_PTCR2(x).B.RCSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR2_RCSEL. */
#define BF_AUDMUX_PTCR2_RCSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR2_RCSEL) & BM_AUDMUX_PTCR2_RCSEL)

/*! @brief Set the RCSEL field to a new value. */
#define BW_AUDMUX_PTCR2_RCSEL(x, v) (HW_AUDMUX_PTCR2_WR(x, (HW_AUDMUX_PTCR2_RD(x) & ~BM_AUDMUX_PTCR2_RCSEL) | BF_AUDMUX_PTCR2_RCSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR2, field RCLKDIR[16] (RW)
 *
 * Receive Clock Direction Control. This bit sets the direction of the RXC pin
 * of the interface as an output or input. When set as an input, the RCSEL
 * settings are ignored. When set as an output, the RCSEL settings determine the source
 * port of the clock. RCLKDIR and SYN should not be changed at the same time.
 *
 * Values:
 * - 0 - RXC is an input.
 * - 1 - RXC is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR2_RCLKDIR (16U)      /*!< Bit position for AUDMUX_PTCR2_RCLKDIR. */
#define BM_AUDMUX_PTCR2_RCLKDIR (0x00010000U) /*!< Bit mask for AUDMUX_PTCR2_RCLKDIR. */
#define BS_AUDMUX_PTCR2_RCLKDIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR2_RCLKDIR. */

/*! @brief Read current value of the AUDMUX_PTCR2_RCLKDIR field. */
#define BR_AUDMUX_PTCR2_RCLKDIR(x) (HW_AUDMUX_PTCR2(x).B.RCLKDIR)

/*! @brief Format value for bitfield AUDMUX_PTCR2_RCLKDIR. */
#define BF_AUDMUX_PTCR2_RCLKDIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR2_RCLKDIR) & BM_AUDMUX_PTCR2_RCLKDIR)

/*! @brief Set the RCLKDIR field to a new value. */
#define BW_AUDMUX_PTCR2_RCLKDIR(x, v) (HW_AUDMUX_PTCR2_WR(x, (HW_AUDMUX_PTCR2_RD(x) & ~BM_AUDMUX_PTCR2_RCLKDIR) | BF_AUDMUX_PTCR2_RCLKDIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR2, field RFSEL[20:17] (RW)
 *
 * Receive Frame Sync Select. Selects the source port from which RXFS is
 * sourced. RXFS can be sourced from TXFS and RXFS from other ports.
 *
 * Values:
 * - 1xxx - Selects RXFS from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR2_RFSEL (17U)        /*!< Bit position for AUDMUX_PTCR2_RFSEL. */
#define BM_AUDMUX_PTCR2_RFSEL (0x001E0000U) /*!< Bit mask for AUDMUX_PTCR2_RFSEL. */
#define BS_AUDMUX_PTCR2_RFSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR2_RFSEL. */

/*! @brief Read current value of the AUDMUX_PTCR2_RFSEL field. */
#define BR_AUDMUX_PTCR2_RFSEL(x) (HW_AUDMUX_PTCR2(x).B.RFSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR2_RFSEL. */
#define BF_AUDMUX_PTCR2_RFSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR2_RFSEL) & BM_AUDMUX_PTCR2_RFSEL)

/*! @brief Set the RFSEL field to a new value. */
#define BW_AUDMUX_PTCR2_RFSEL(x, v) (HW_AUDMUX_PTCR2_WR(x, (HW_AUDMUX_PTCR2_RD(x) & ~BM_AUDMUX_PTCR2_RFSEL) | BF_AUDMUX_PTCR2_RFSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR2, field RFS_DIR[21] (RW)
 *
 * Receive Frame Sync Direction Control. This bit sets the direction of the RXFS
 * pin of the interface as an output or input. When set as an input, the RFSEL
 * settings are ignored. When set as an output, the RFSEL settings determine the
 * source port of the frame sync.
 *
 * Values:
 * - 0 - RXFS is an input.
 * - 1 - RXFS is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR2_RFS_DIR (21U)      /*!< Bit position for AUDMUX_PTCR2_RFS_DIR. */
#define BM_AUDMUX_PTCR2_RFS_DIR (0x00200000U) /*!< Bit mask for AUDMUX_PTCR2_RFS_DIR. */
#define BS_AUDMUX_PTCR2_RFS_DIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR2_RFS_DIR. */

/*! @brief Read current value of the AUDMUX_PTCR2_RFS_DIR field. */
#define BR_AUDMUX_PTCR2_RFS_DIR(x) (HW_AUDMUX_PTCR2(x).B.RFS_DIR)

/*! @brief Format value for bitfield AUDMUX_PTCR2_RFS_DIR. */
#define BF_AUDMUX_PTCR2_RFS_DIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR2_RFS_DIR) & BM_AUDMUX_PTCR2_RFS_DIR)

/*! @brief Set the RFS_DIR field to a new value. */
#define BW_AUDMUX_PTCR2_RFS_DIR(x, v) (HW_AUDMUX_PTCR2_WR(x, (HW_AUDMUX_PTCR2_RD(x) & ~BM_AUDMUX_PTCR2_RFS_DIR) | BF_AUDMUX_PTCR2_RFS_DIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR2, field TCSEL[25:22] (RW)
 *
 * Transmit Clock Select. Selects the source port from which TXC is sourced.
 *
 * Values:
 * - 1xxx - Selects RXC from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR2_TCSEL (22U)        /*!< Bit position for AUDMUX_PTCR2_TCSEL. */
#define BM_AUDMUX_PTCR2_TCSEL (0x03C00000U) /*!< Bit mask for AUDMUX_PTCR2_TCSEL. */
#define BS_AUDMUX_PTCR2_TCSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR2_TCSEL. */

/*! @brief Read current value of the AUDMUX_PTCR2_TCSEL field. */
#define BR_AUDMUX_PTCR2_TCSEL(x) (HW_AUDMUX_PTCR2(x).B.TCSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR2_TCSEL. */
#define BF_AUDMUX_PTCR2_TCSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR2_TCSEL) & BM_AUDMUX_PTCR2_TCSEL)

/*! @brief Set the TCSEL field to a new value. */
#define BW_AUDMUX_PTCR2_TCSEL(x, v) (HW_AUDMUX_PTCR2_WR(x, (HW_AUDMUX_PTCR2_RD(x) & ~BM_AUDMUX_PTCR2_TCSEL) | BF_AUDMUX_PTCR2_TCSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR2, field TCLKDIR[26] (RW)
 *
 * Transmit Clock Direction Control. This bit sets the direction of the TXC pin
 * of the interface as an output or input. When set as an input, the TCSEL
 * settings are ignored. When set as an output, the TCSEL settings determine the source
 * port of the clock.
 *
 * Values:
 * - 0 - TXC is an input.
 * - 1 - TXC is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR2_TCLKDIR (26U)      /*!< Bit position for AUDMUX_PTCR2_TCLKDIR. */
#define BM_AUDMUX_PTCR2_TCLKDIR (0x04000000U) /*!< Bit mask for AUDMUX_PTCR2_TCLKDIR. */
#define BS_AUDMUX_PTCR2_TCLKDIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR2_TCLKDIR. */

/*! @brief Read current value of the AUDMUX_PTCR2_TCLKDIR field. */
#define BR_AUDMUX_PTCR2_TCLKDIR(x) (HW_AUDMUX_PTCR2(x).B.TCLKDIR)

/*! @brief Format value for bitfield AUDMUX_PTCR2_TCLKDIR. */
#define BF_AUDMUX_PTCR2_TCLKDIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR2_TCLKDIR) & BM_AUDMUX_PTCR2_TCLKDIR)

/*! @brief Set the TCLKDIR field to a new value. */
#define BW_AUDMUX_PTCR2_TCLKDIR(x, v) (HW_AUDMUX_PTCR2_WR(x, (HW_AUDMUX_PTCR2_RD(x) & ~BM_AUDMUX_PTCR2_TCLKDIR) | BF_AUDMUX_PTCR2_TCLKDIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR2, field TFSEL[30:27] (RW)
 *
 * Transmit Frame Sync Select. Selects the source port from which TXFS is
 * sourced.
 *
 * Values:
 * - 1xxx - Selects RXFS from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR2_TFSEL (27U)        /*!< Bit position for AUDMUX_PTCR2_TFSEL. */
#define BM_AUDMUX_PTCR2_TFSEL (0x78000000U) /*!< Bit mask for AUDMUX_PTCR2_TFSEL. */
#define BS_AUDMUX_PTCR2_TFSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR2_TFSEL. */

/*! @brief Read current value of the AUDMUX_PTCR2_TFSEL field. */
#define BR_AUDMUX_PTCR2_TFSEL(x) (HW_AUDMUX_PTCR2(x).B.TFSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR2_TFSEL. */
#define BF_AUDMUX_PTCR2_TFSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR2_TFSEL) & BM_AUDMUX_PTCR2_TFSEL)

/*! @brief Set the TFSEL field to a new value. */
#define BW_AUDMUX_PTCR2_TFSEL(x, v) (HW_AUDMUX_PTCR2_WR(x, (HW_AUDMUX_PTCR2_RD(x) & ~BM_AUDMUX_PTCR2_TFSEL) | BF_AUDMUX_PTCR2_TFSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR2, field TFS_DIR[31] (RW)
 *
 * Transmit Frame Sync Direction Control. This bit sets the direction of the
 * TXFS pin of the interface as an output or input. When set as an input, the TFSEL
 * settings are ignored. When set as an output, the TFSEL settings determine the
 * source port of the frame sync.
 *
 * Values:
 * - 0 - TXFS is an input.
 * - 1 - TXFS is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR2_TFS_DIR (31U)      /*!< Bit position for AUDMUX_PTCR2_TFS_DIR. */
#define BM_AUDMUX_PTCR2_TFS_DIR (0x80000000U) /*!< Bit mask for AUDMUX_PTCR2_TFS_DIR. */
#define BS_AUDMUX_PTCR2_TFS_DIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR2_TFS_DIR. */

/*! @brief Read current value of the AUDMUX_PTCR2_TFS_DIR field. */
#define BR_AUDMUX_PTCR2_TFS_DIR(x) (HW_AUDMUX_PTCR2(x).B.TFS_DIR)

/*! @brief Format value for bitfield AUDMUX_PTCR2_TFS_DIR. */
#define BF_AUDMUX_PTCR2_TFS_DIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR2_TFS_DIR) & BM_AUDMUX_PTCR2_TFS_DIR)

/*! @brief Set the TFS_DIR field to a new value. */
#define BW_AUDMUX_PTCR2_TFS_DIR(x, v) (HW_AUDMUX_PTCR2_WR(x, (HW_AUDMUX_PTCR2_RD(x) & ~BM_AUDMUX_PTCR2_TFS_DIR) | BF_AUDMUX_PTCR2_TFS_DIR(v)))
/*@}*/

/*******************************************************************************
 * HW_AUDMUX_PDCR2 - Port Data Control Register 2
 ******************************************************************************/

/*!
 * @brief HW_AUDMUX_PDCR2 - Port Data Control Register 2 (RW)
 *
 * Reset value: 0x00008000U
 *
 * PDCR2 is the Port Data Control Register for Port 2.
 */
typedef union _hw_audmux_pdcr2
{
    uint32_t U;
    struct _hw_audmux_pdcr2_bitfields
    {
        uint32_t INMMASK : 8;          /*!< [7:0]  */
        uint32_t MODE : 1;             /*!< [8]  */
        uint32_t RESERVED0 : 3;        /*!< [11:9]  */
        uint32_t TXRXEN : 1;           /*!< [12]  */
        uint32_t RXDSEL : 3;           /*!< [15:13]  */
        uint32_t RESERVED1 : 16;       /*!< [31:16]  */
    } B;
} hw_audmux_pdcr2_t;

/*!
 * @name Constants and macros for entire AUDMUX_PDCR2 register
 */
/*@{*/
#define HW_AUDMUX_PDCR2_ADDR(x)  ((uintptr_t)(x) + 0xCU)

#define HW_AUDMUX_PDCR2(x)       (*(__IO hw_audmux_pdcr2_t *) HW_AUDMUX_PDCR2_ADDR(x))
#define HW_AUDMUX_PDCR2_RD(x)    (HW_AUDMUX_PDCR2(x).U)
#define HW_AUDMUX_PDCR2_WR(x, v) (HW_AUDMUX_PDCR2(x).U = (v))
#define HW_AUDMUX_PDCR2_SET(x, v) (HW_AUDMUX_PDCR2_WR(x, HW_AUDMUX_PDCR2_RD(x) |  (v)))
#define HW_AUDMUX_PDCR2_CLR(x, v) (HW_AUDMUX_PDCR2_WR(x, HW_AUDMUX_PDCR2_RD(x) & ~(v)))
#define HW_AUDMUX_PDCR2_TOG(x, v) (HW_AUDMUX_PDCR2_WR(x, HW_AUDMUX_PDCR2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AUDMUX_PDCR2 bitfields
 */

/*!
 * @name Register AUDMUX_PDCR2, field INMMASK[7:0] (RW)
 *
 * Internal Network Mode Mask. Bit mask that selects the ports from which the
 * RXD signals are to be ANDed together for internal network mode. Bit 6 represents
 * RXD from Port 7 and bit0 represents RXD from Port 1.
 *
 * Values:
 * - 0 - Includes RXDn for ANDing
 * - 1 - Excludes RXDn from ANDing
 */
/*@{*/
#define BP_AUDMUX_PDCR2_INMMASK (0U)       /*!< Bit position for AUDMUX_PDCR2_INMMASK. */
#define BM_AUDMUX_PDCR2_INMMASK (0x000000FFU) /*!< Bit mask for AUDMUX_PDCR2_INMMASK. */
#define BS_AUDMUX_PDCR2_INMMASK (8U)       /*!< Bit field size in bits for AUDMUX_PDCR2_INMMASK. */

/*! @brief Read current value of the AUDMUX_PDCR2_INMMASK field. */
#define BR_AUDMUX_PDCR2_INMMASK(x) (HW_AUDMUX_PDCR2(x).B.INMMASK)

/*! @brief Format value for bitfield AUDMUX_PDCR2_INMMASK. */
#define BF_AUDMUX_PDCR2_INMMASK(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR2_INMMASK) & BM_AUDMUX_PDCR2_INMMASK)

/*! @brief Set the INMMASK field to a new value. */
#define BW_AUDMUX_PDCR2_INMMASK(x, v) (HW_AUDMUX_PDCR2_WR(x, (HW_AUDMUX_PDCR2_RD(x) & ~BM_AUDMUX_PDCR2_INMMASK) | BF_AUDMUX_PDCR2_INMMASK(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR2, field MODE[8] (RW)
 *
 * Mode Select. This field selects the mode in which the port is to operate. The
 * modes of operation include the following: Normal mode, in which the RXD from
 * the port selected by RXDSEL is routed to the port. Internal Network mode in
 * which RXD from other ports are ANDed together. RXDSEL is ignored. INMMASK
 * determines which RXD signals are ANDed together.
 *
 * Values:
 * - 0 - Normal mode
 * - 1 - Internal Network mode
 */
/*@{*/
#define BP_AUDMUX_PDCR2_MODE (8U)          /*!< Bit position for AUDMUX_PDCR2_MODE. */
#define BM_AUDMUX_PDCR2_MODE (0x00000100U) /*!< Bit mask for AUDMUX_PDCR2_MODE. */
#define BS_AUDMUX_PDCR2_MODE (1U)          /*!< Bit field size in bits for AUDMUX_PDCR2_MODE. */

/*! @brief Read current value of the AUDMUX_PDCR2_MODE field. */
#define BR_AUDMUX_PDCR2_MODE(x) (HW_AUDMUX_PDCR2(x).B.MODE)

/*! @brief Format value for bitfield AUDMUX_PDCR2_MODE. */
#define BF_AUDMUX_PDCR2_MODE(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR2_MODE) & BM_AUDMUX_PDCR2_MODE)

/*! @brief Set the MODE field to a new value. */
#define BW_AUDMUX_PDCR2_MODE(x, v) (HW_AUDMUX_PDCR2_WR(x, (HW_AUDMUX_PDCR2_RD(x) & ~BM_AUDMUX_PDCR2_MODE) | BF_AUDMUX_PDCR2_MODE(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR2, field TXRXEN[12] (RW)
 *
 * Transmit/Receive Switch Enable. Swaps the transmit and receive signals.
 *
 * Values:
 * - 0 - No switch (Transmit Pin = Transmit, Receive Pin = Receive)
 * - 1 - Switch (Transmit Pin = Receive, Receive Pin = Transmit)
 */
/*@{*/
#define BP_AUDMUX_PDCR2_TXRXEN (12U)       /*!< Bit position for AUDMUX_PDCR2_TXRXEN. */
#define BM_AUDMUX_PDCR2_TXRXEN (0x00001000U) /*!< Bit mask for AUDMUX_PDCR2_TXRXEN. */
#define BS_AUDMUX_PDCR2_TXRXEN (1U)        /*!< Bit field size in bits for AUDMUX_PDCR2_TXRXEN. */

/*! @brief Read current value of the AUDMUX_PDCR2_TXRXEN field. */
#define BR_AUDMUX_PDCR2_TXRXEN(x) (HW_AUDMUX_PDCR2(x).B.TXRXEN)

/*! @brief Format value for bitfield AUDMUX_PDCR2_TXRXEN. */
#define BF_AUDMUX_PDCR2_TXRXEN(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR2_TXRXEN) & BM_AUDMUX_PDCR2_TXRXEN)

/*! @brief Set the TXRXEN field to a new value. */
#define BW_AUDMUX_PDCR2_TXRXEN(x, v) (HW_AUDMUX_PDCR2_WR(x, (HW_AUDMUX_PDCR2_RD(x) & ~BM_AUDMUX_PDCR2_TXRXEN) | BF_AUDMUX_PDCR2_TXRXEN(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR2, field RXDSEL[15:13] (RW)
 *
 * Receive Data Select. Selects the source port for the RXD data. RXDSEL is
 * ignored if MODE = 1 (that is, Internal Network Mode is enabled).
 *
 * Values:
 * - xxx - Port number for RXD
 * - 000 - Port 1
 * - 110 - Port 7
 * - 111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PDCR2_RXDSEL (13U)       /*!< Bit position for AUDMUX_PDCR2_RXDSEL. */
#define BM_AUDMUX_PDCR2_RXDSEL (0x0000E000U) /*!< Bit mask for AUDMUX_PDCR2_RXDSEL. */
#define BS_AUDMUX_PDCR2_RXDSEL (3U)        /*!< Bit field size in bits for AUDMUX_PDCR2_RXDSEL. */

/*! @brief Read current value of the AUDMUX_PDCR2_RXDSEL field. */
#define BR_AUDMUX_PDCR2_RXDSEL(x) (HW_AUDMUX_PDCR2(x).B.RXDSEL)

/*! @brief Format value for bitfield AUDMUX_PDCR2_RXDSEL. */
#define BF_AUDMUX_PDCR2_RXDSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR2_RXDSEL) & BM_AUDMUX_PDCR2_RXDSEL)

/*! @brief Set the RXDSEL field to a new value. */
#define BW_AUDMUX_PDCR2_RXDSEL(x, v) (HW_AUDMUX_PDCR2_WR(x, (HW_AUDMUX_PDCR2_RD(x) & ~BM_AUDMUX_PDCR2_RXDSEL) | BF_AUDMUX_PDCR2_RXDSEL(v)))
/*@}*/

/*******************************************************************************
 * HW_AUDMUX_PTCR3 - Port Timing Control Register 3
 ******************************************************************************/

/*!
 * @brief HW_AUDMUX_PTCR3 - Port Timing Control Register 3 (RW)
 *
 * Reset value: 0x9CC00800U
 *
 * PTCR3 is the Port Timing Control Register for Port 3.
 */
typedef union _hw_audmux_ptcr3
{
    uint32_t U;
    struct _hw_audmux_ptcr3_bitfields
    {
        uint32_t RESERVED0 : 11;       /*!< [10:0]  */
        uint32_t SYN : 1;              /*!< [11]  */
        uint32_t RCSEL : 4;            /*!< [15:12]  */
        uint32_t RCLKDIR : 1;          /*!< [16]  */
        uint32_t RFSEL : 4;            /*!< [20:17]  */
        uint32_t RFS_DIR : 1;          /*!< [21]  */
        uint32_t TCSEL : 4;            /*!< [25:22]  */
        uint32_t TCLKDIR : 1;          /*!< [26]  */
        uint32_t TFSEL : 4;            /*!< [30:27]  */
        uint32_t TFS_DIR : 1;          /*!< [31]  */
    } B;
} hw_audmux_ptcr3_t;

/*!
 * @name Constants and macros for entire AUDMUX_PTCR3 register
 */
/*@{*/
#define HW_AUDMUX_PTCR3_ADDR(x)  ((uintptr_t)(x) + 0x10U)

#define HW_AUDMUX_PTCR3(x)       (*(__IO hw_audmux_ptcr3_t *) HW_AUDMUX_PTCR3_ADDR(x))
#define HW_AUDMUX_PTCR3_RD(x)    (HW_AUDMUX_PTCR3(x).U)
#define HW_AUDMUX_PTCR3_WR(x, v) (HW_AUDMUX_PTCR3(x).U = (v))
#define HW_AUDMUX_PTCR3_SET(x, v) (HW_AUDMUX_PTCR3_WR(x, HW_AUDMUX_PTCR3_RD(x) |  (v)))
#define HW_AUDMUX_PTCR3_CLR(x, v) (HW_AUDMUX_PTCR3_WR(x, HW_AUDMUX_PTCR3_RD(x) & ~(v)))
#define HW_AUDMUX_PTCR3_TOG(x, v) (HW_AUDMUX_PTCR3_WR(x, HW_AUDMUX_PTCR3_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AUDMUX_PTCR3 bitfields
 */

/*!
 * @name Register AUDMUX_PTCR3, field SYN[11] (RW)
 *
 * Synchronous/Asynchronous Select. When SYN is set, synchronous mode is chosen
 * and the transmit and receive sections use common clock and frame sync signals
 * (that is, the port is a 4-wire interface). When SYN is cleared, asynchronous
 * mode is chosen and separate clock and frame sync signals are used for the
 * transmit and receive sections (that is, the port is a 6-wire interface). RCLKDIR
 * and SYN should not be changed at the same time.
 *
 * Values:
 * - 0 - Asynchronous mode
 * - 1 - Synchronous mode (default)
 */
/*@{*/
#define BP_AUDMUX_PTCR3_SYN  (11U)         /*!< Bit position for AUDMUX_PTCR3_SYN. */
#define BM_AUDMUX_PTCR3_SYN  (0x00000800U) /*!< Bit mask for AUDMUX_PTCR3_SYN. */
#define BS_AUDMUX_PTCR3_SYN  (1U)          /*!< Bit field size in bits for AUDMUX_PTCR3_SYN. */

/*! @brief Read current value of the AUDMUX_PTCR3_SYN field. */
#define BR_AUDMUX_PTCR3_SYN(x) (HW_AUDMUX_PTCR3(x).B.SYN)

/*! @brief Format value for bitfield AUDMUX_PTCR3_SYN. */
#define BF_AUDMUX_PTCR3_SYN(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR3_SYN) & BM_AUDMUX_PTCR3_SYN)

/*! @brief Set the SYN field to a new value. */
#define BW_AUDMUX_PTCR3_SYN(x, v) (HW_AUDMUX_PTCR3_WR(x, (HW_AUDMUX_PTCR3_RD(x) & ~BM_AUDMUX_PTCR3_SYN) | BF_AUDMUX_PTCR3_SYN(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR3, field RCSEL[15:12] (RW)
 *
 * Receive Clock Select. Selects the source port from which RXC is sourced. RXC
 * can be sourced from TXC and RXC from other ports.
 *
 * Values:
 * - 1xxx - Selects RXC from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR3_RCSEL (12U)        /*!< Bit position for AUDMUX_PTCR3_RCSEL. */
#define BM_AUDMUX_PTCR3_RCSEL (0x0000F000U) /*!< Bit mask for AUDMUX_PTCR3_RCSEL. */
#define BS_AUDMUX_PTCR3_RCSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR3_RCSEL. */

/*! @brief Read current value of the AUDMUX_PTCR3_RCSEL field. */
#define BR_AUDMUX_PTCR3_RCSEL(x) (HW_AUDMUX_PTCR3(x).B.RCSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR3_RCSEL. */
#define BF_AUDMUX_PTCR3_RCSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR3_RCSEL) & BM_AUDMUX_PTCR3_RCSEL)

/*! @brief Set the RCSEL field to a new value. */
#define BW_AUDMUX_PTCR3_RCSEL(x, v) (HW_AUDMUX_PTCR3_WR(x, (HW_AUDMUX_PTCR3_RD(x) & ~BM_AUDMUX_PTCR3_RCSEL) | BF_AUDMUX_PTCR3_RCSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR3, field RCLKDIR[16] (RW)
 *
 * Receive Clock Direction Control. This bit sets the direction of the RXC pin
 * of the interface as an output or input. When set as an input, the RCSEL
 * settings are ignored. When set as an output, the RCSEL settings determine the source
 * port of the clock. RCLKDIR and SYN should not be changed at the same time.
 *
 * Values:
 * - 0 - RXC is an input.
 * - 1 - RXC is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR3_RCLKDIR (16U)      /*!< Bit position for AUDMUX_PTCR3_RCLKDIR. */
#define BM_AUDMUX_PTCR3_RCLKDIR (0x00010000U) /*!< Bit mask for AUDMUX_PTCR3_RCLKDIR. */
#define BS_AUDMUX_PTCR3_RCLKDIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR3_RCLKDIR. */

/*! @brief Read current value of the AUDMUX_PTCR3_RCLKDIR field. */
#define BR_AUDMUX_PTCR3_RCLKDIR(x) (HW_AUDMUX_PTCR3(x).B.RCLKDIR)

/*! @brief Format value for bitfield AUDMUX_PTCR3_RCLKDIR. */
#define BF_AUDMUX_PTCR3_RCLKDIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR3_RCLKDIR) & BM_AUDMUX_PTCR3_RCLKDIR)

/*! @brief Set the RCLKDIR field to a new value. */
#define BW_AUDMUX_PTCR3_RCLKDIR(x, v) (HW_AUDMUX_PTCR3_WR(x, (HW_AUDMUX_PTCR3_RD(x) & ~BM_AUDMUX_PTCR3_RCLKDIR) | BF_AUDMUX_PTCR3_RCLKDIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR3, field RFSEL[20:17] (RW)
 *
 * Receive Frame Sync Select. Selects the source port from which RXFS is
 * sourced. RXFS can be sourced from TXFS and RXFS from other ports.
 *
 * Values:
 * - 1xxx - Selects RXFS from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR3_RFSEL (17U)        /*!< Bit position for AUDMUX_PTCR3_RFSEL. */
#define BM_AUDMUX_PTCR3_RFSEL (0x001E0000U) /*!< Bit mask for AUDMUX_PTCR3_RFSEL. */
#define BS_AUDMUX_PTCR3_RFSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR3_RFSEL. */

/*! @brief Read current value of the AUDMUX_PTCR3_RFSEL field. */
#define BR_AUDMUX_PTCR3_RFSEL(x) (HW_AUDMUX_PTCR3(x).B.RFSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR3_RFSEL. */
#define BF_AUDMUX_PTCR3_RFSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR3_RFSEL) & BM_AUDMUX_PTCR3_RFSEL)

/*! @brief Set the RFSEL field to a new value. */
#define BW_AUDMUX_PTCR3_RFSEL(x, v) (HW_AUDMUX_PTCR3_WR(x, (HW_AUDMUX_PTCR3_RD(x) & ~BM_AUDMUX_PTCR3_RFSEL) | BF_AUDMUX_PTCR3_RFSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR3, field RFS_DIR[21] (RW)
 *
 * Receive Frame Sync Direction Control. This bit sets the direction of the RXFS
 * pin of the interface as an output or input. When set as an input, the RFSEL
 * settings are ignored. When set as an output, the RFSEL settings determine the
 * source port of the frame sync.
 *
 * Values:
 * - 0 - RXFS is an input.
 * - 1 - RXFS is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR3_RFS_DIR (21U)      /*!< Bit position for AUDMUX_PTCR3_RFS_DIR. */
#define BM_AUDMUX_PTCR3_RFS_DIR (0x00200000U) /*!< Bit mask for AUDMUX_PTCR3_RFS_DIR. */
#define BS_AUDMUX_PTCR3_RFS_DIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR3_RFS_DIR. */

/*! @brief Read current value of the AUDMUX_PTCR3_RFS_DIR field. */
#define BR_AUDMUX_PTCR3_RFS_DIR(x) (HW_AUDMUX_PTCR3(x).B.RFS_DIR)

/*! @brief Format value for bitfield AUDMUX_PTCR3_RFS_DIR. */
#define BF_AUDMUX_PTCR3_RFS_DIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR3_RFS_DIR) & BM_AUDMUX_PTCR3_RFS_DIR)

/*! @brief Set the RFS_DIR field to a new value. */
#define BW_AUDMUX_PTCR3_RFS_DIR(x, v) (HW_AUDMUX_PTCR3_WR(x, (HW_AUDMUX_PTCR3_RD(x) & ~BM_AUDMUX_PTCR3_RFS_DIR) | BF_AUDMUX_PTCR3_RFS_DIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR3, field TCSEL[25:22] (RW)
 *
 * Transmit Clock Select. Selects the source port from which TXC is sourced.
 *
 * Values:
 * - 1xxx - Selects RXC from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR3_TCSEL (22U)        /*!< Bit position for AUDMUX_PTCR3_TCSEL. */
#define BM_AUDMUX_PTCR3_TCSEL (0x03C00000U) /*!< Bit mask for AUDMUX_PTCR3_TCSEL. */
#define BS_AUDMUX_PTCR3_TCSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR3_TCSEL. */

/*! @brief Read current value of the AUDMUX_PTCR3_TCSEL field. */
#define BR_AUDMUX_PTCR3_TCSEL(x) (HW_AUDMUX_PTCR3(x).B.TCSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR3_TCSEL. */
#define BF_AUDMUX_PTCR3_TCSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR3_TCSEL) & BM_AUDMUX_PTCR3_TCSEL)

/*! @brief Set the TCSEL field to a new value. */
#define BW_AUDMUX_PTCR3_TCSEL(x, v) (HW_AUDMUX_PTCR3_WR(x, (HW_AUDMUX_PTCR3_RD(x) & ~BM_AUDMUX_PTCR3_TCSEL) | BF_AUDMUX_PTCR3_TCSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR3, field TCLKDIR[26] (RW)
 *
 * Transmit Clock Direction Control. This bit sets the direction of the TXC pin
 * of the interface as an output or input. When set as an input, the TCSEL
 * settings are ignored. When set as an output, the TCSEL settings determine the source
 * port of the clock.
 *
 * Values:
 * - 0 - TXC is an input.
 * - 1 - TXC is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR3_TCLKDIR (26U)      /*!< Bit position for AUDMUX_PTCR3_TCLKDIR. */
#define BM_AUDMUX_PTCR3_TCLKDIR (0x04000000U) /*!< Bit mask for AUDMUX_PTCR3_TCLKDIR. */
#define BS_AUDMUX_PTCR3_TCLKDIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR3_TCLKDIR. */

/*! @brief Read current value of the AUDMUX_PTCR3_TCLKDIR field. */
#define BR_AUDMUX_PTCR3_TCLKDIR(x) (HW_AUDMUX_PTCR3(x).B.TCLKDIR)

/*! @brief Format value for bitfield AUDMUX_PTCR3_TCLKDIR. */
#define BF_AUDMUX_PTCR3_TCLKDIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR3_TCLKDIR) & BM_AUDMUX_PTCR3_TCLKDIR)

/*! @brief Set the TCLKDIR field to a new value. */
#define BW_AUDMUX_PTCR3_TCLKDIR(x, v) (HW_AUDMUX_PTCR3_WR(x, (HW_AUDMUX_PTCR3_RD(x) & ~BM_AUDMUX_PTCR3_TCLKDIR) | BF_AUDMUX_PTCR3_TCLKDIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR3, field TFSEL[30:27] (RW)
 *
 * Transmit Frame Sync Select. Selects the source port from which TXFS is
 * sourced.
 *
 * Values:
 * - 1xxx - Selects RXFS from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR3_TFSEL (27U)        /*!< Bit position for AUDMUX_PTCR3_TFSEL. */
#define BM_AUDMUX_PTCR3_TFSEL (0x78000000U) /*!< Bit mask for AUDMUX_PTCR3_TFSEL. */
#define BS_AUDMUX_PTCR3_TFSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR3_TFSEL. */

/*! @brief Read current value of the AUDMUX_PTCR3_TFSEL field. */
#define BR_AUDMUX_PTCR3_TFSEL(x) (HW_AUDMUX_PTCR3(x).B.TFSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR3_TFSEL. */
#define BF_AUDMUX_PTCR3_TFSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR3_TFSEL) & BM_AUDMUX_PTCR3_TFSEL)

/*! @brief Set the TFSEL field to a new value. */
#define BW_AUDMUX_PTCR3_TFSEL(x, v) (HW_AUDMUX_PTCR3_WR(x, (HW_AUDMUX_PTCR3_RD(x) & ~BM_AUDMUX_PTCR3_TFSEL) | BF_AUDMUX_PTCR3_TFSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR3, field TFS_DIR[31] (RW)
 *
 * Transmit Frame Sync Direction Control. This bit sets the direction of the
 * TXFS pin of the interface as an output or input. When set as an input, the TFSEL
 * settings are ignored. When set as an output, the TFSEL settings determine the
 * source port of the frame sync.
 *
 * Values:
 * - 0 - TXFS is an input.
 * - 1 - TXFS is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR3_TFS_DIR (31U)      /*!< Bit position for AUDMUX_PTCR3_TFS_DIR. */
#define BM_AUDMUX_PTCR3_TFS_DIR (0x80000000U) /*!< Bit mask for AUDMUX_PTCR3_TFS_DIR. */
#define BS_AUDMUX_PTCR3_TFS_DIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR3_TFS_DIR. */

/*! @brief Read current value of the AUDMUX_PTCR3_TFS_DIR field. */
#define BR_AUDMUX_PTCR3_TFS_DIR(x) (HW_AUDMUX_PTCR3(x).B.TFS_DIR)

/*! @brief Format value for bitfield AUDMUX_PTCR3_TFS_DIR. */
#define BF_AUDMUX_PTCR3_TFS_DIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR3_TFS_DIR) & BM_AUDMUX_PTCR3_TFS_DIR)

/*! @brief Set the TFS_DIR field to a new value. */
#define BW_AUDMUX_PTCR3_TFS_DIR(x, v) (HW_AUDMUX_PTCR3_WR(x, (HW_AUDMUX_PTCR3_RD(x) & ~BM_AUDMUX_PTCR3_TFS_DIR) | BF_AUDMUX_PTCR3_TFS_DIR(v)))
/*@}*/

/*******************************************************************************
 * HW_AUDMUX_PDCR3 - Port Data Control Register 3
 ******************************************************************************/

/*!
 * @brief HW_AUDMUX_PDCR3 - Port Data Control Register 3 (RW)
 *
 * Reset value: 0x00006000U
 *
 * PDCR3 is the Port Data Control Register for Port 3.
 */
typedef union _hw_audmux_pdcr3
{
    uint32_t U;
    struct _hw_audmux_pdcr3_bitfields
    {
        uint32_t INMMASK : 8;          /*!< [7:0]  */
        uint32_t MODE : 1;             /*!< [8]  */
        uint32_t RESERVED0 : 3;        /*!< [11:9]  */
        uint32_t TXRXEN : 1;           /*!< [12]  */
        uint32_t RXDSEL : 3;           /*!< [15:13]  */
        uint32_t RESERVED1 : 16;       /*!< [31:16]  */
    } B;
} hw_audmux_pdcr3_t;

/*!
 * @name Constants and macros for entire AUDMUX_PDCR3 register
 */
/*@{*/
#define HW_AUDMUX_PDCR3_ADDR(x)  ((uintptr_t)(x) + 0x14U)

#define HW_AUDMUX_PDCR3(x)       (*(__IO hw_audmux_pdcr3_t *) HW_AUDMUX_PDCR3_ADDR(x))
#define HW_AUDMUX_PDCR3_RD(x)    (HW_AUDMUX_PDCR3(x).U)
#define HW_AUDMUX_PDCR3_WR(x, v) (HW_AUDMUX_PDCR3(x).U = (v))
#define HW_AUDMUX_PDCR3_SET(x, v) (HW_AUDMUX_PDCR3_WR(x, HW_AUDMUX_PDCR3_RD(x) |  (v)))
#define HW_AUDMUX_PDCR3_CLR(x, v) (HW_AUDMUX_PDCR3_WR(x, HW_AUDMUX_PDCR3_RD(x) & ~(v)))
#define HW_AUDMUX_PDCR3_TOG(x, v) (HW_AUDMUX_PDCR3_WR(x, HW_AUDMUX_PDCR3_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AUDMUX_PDCR3 bitfields
 */

/*!
 * @name Register AUDMUX_PDCR3, field INMMASK[7:0] (RW)
 *
 * Internal Network Mode Mask. Bit mask that selects the ports from which the
 * RXD signals are to be ANDed together for internal network mode. Bit 6 represents
 * RXD from Port 7 and bit0 represents RXD from Port 1.
 *
 * Values:
 * - 0 - Includes RXDn for ANDing
 * - 1 - Excludes RXDn from ANDing
 */
/*@{*/
#define BP_AUDMUX_PDCR3_INMMASK (0U)       /*!< Bit position for AUDMUX_PDCR3_INMMASK. */
#define BM_AUDMUX_PDCR3_INMMASK (0x000000FFU) /*!< Bit mask for AUDMUX_PDCR3_INMMASK. */
#define BS_AUDMUX_PDCR3_INMMASK (8U)       /*!< Bit field size in bits for AUDMUX_PDCR3_INMMASK. */

/*! @brief Read current value of the AUDMUX_PDCR3_INMMASK field. */
#define BR_AUDMUX_PDCR3_INMMASK(x) (HW_AUDMUX_PDCR3(x).B.INMMASK)

/*! @brief Format value for bitfield AUDMUX_PDCR3_INMMASK. */
#define BF_AUDMUX_PDCR3_INMMASK(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR3_INMMASK) & BM_AUDMUX_PDCR3_INMMASK)

/*! @brief Set the INMMASK field to a new value. */
#define BW_AUDMUX_PDCR3_INMMASK(x, v) (HW_AUDMUX_PDCR3_WR(x, (HW_AUDMUX_PDCR3_RD(x) & ~BM_AUDMUX_PDCR3_INMMASK) | BF_AUDMUX_PDCR3_INMMASK(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR3, field MODE[8] (RW)
 *
 * Mode Select. This field selects the mode in which the port is to operate. The
 * modes of operation include the following: Normal mode, in which the RXD from
 * the port selected by RXDSEL is routed to the port. Internal Network mode in
 * which RXD from other ports are ANDed together. RXDSEL is ignored. INMMASK
 * determines which RXD signals are ANDed together.
 *
 * Values:
 * - 0 - Normal mode
 * - 1 - Internal Network mode
 */
/*@{*/
#define BP_AUDMUX_PDCR3_MODE (8U)          /*!< Bit position for AUDMUX_PDCR3_MODE. */
#define BM_AUDMUX_PDCR3_MODE (0x00000100U) /*!< Bit mask for AUDMUX_PDCR3_MODE. */
#define BS_AUDMUX_PDCR3_MODE (1U)          /*!< Bit field size in bits for AUDMUX_PDCR3_MODE. */

/*! @brief Read current value of the AUDMUX_PDCR3_MODE field. */
#define BR_AUDMUX_PDCR3_MODE(x) (HW_AUDMUX_PDCR3(x).B.MODE)

/*! @brief Format value for bitfield AUDMUX_PDCR3_MODE. */
#define BF_AUDMUX_PDCR3_MODE(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR3_MODE) & BM_AUDMUX_PDCR3_MODE)

/*! @brief Set the MODE field to a new value. */
#define BW_AUDMUX_PDCR3_MODE(x, v) (HW_AUDMUX_PDCR3_WR(x, (HW_AUDMUX_PDCR3_RD(x) & ~BM_AUDMUX_PDCR3_MODE) | BF_AUDMUX_PDCR3_MODE(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR3, field TXRXEN[12] (RW)
 *
 * Transmit/Receive Switch Enable. Swaps the transmit and receive signals.
 *
 * Values:
 * - 0 - No switch (Transmit Pin = Transmit, Receive Pin = Receive)
 * - 1 - Switch (Transmit Pin = Receive, Receive Pin = Transmit)
 */
/*@{*/
#define BP_AUDMUX_PDCR3_TXRXEN (12U)       /*!< Bit position for AUDMUX_PDCR3_TXRXEN. */
#define BM_AUDMUX_PDCR3_TXRXEN (0x00001000U) /*!< Bit mask for AUDMUX_PDCR3_TXRXEN. */
#define BS_AUDMUX_PDCR3_TXRXEN (1U)        /*!< Bit field size in bits for AUDMUX_PDCR3_TXRXEN. */

/*! @brief Read current value of the AUDMUX_PDCR3_TXRXEN field. */
#define BR_AUDMUX_PDCR3_TXRXEN(x) (HW_AUDMUX_PDCR3(x).B.TXRXEN)

/*! @brief Format value for bitfield AUDMUX_PDCR3_TXRXEN. */
#define BF_AUDMUX_PDCR3_TXRXEN(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR3_TXRXEN) & BM_AUDMUX_PDCR3_TXRXEN)

/*! @brief Set the TXRXEN field to a new value. */
#define BW_AUDMUX_PDCR3_TXRXEN(x, v) (HW_AUDMUX_PDCR3_WR(x, (HW_AUDMUX_PDCR3_RD(x) & ~BM_AUDMUX_PDCR3_TXRXEN) | BF_AUDMUX_PDCR3_TXRXEN(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR3, field RXDSEL[15:13] (RW)
 *
 * Receive Data Select. Selects the source port for the RXD data. RXDSEL is
 * ignored if MODE = 1 (that is, Internal Network Mode is enabled).
 *
 * Values:
 * - xxx - Port number for RXD
 * - 000 - Port 1
 * - 110 - Port 7
 * - 111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PDCR3_RXDSEL (13U)       /*!< Bit position for AUDMUX_PDCR3_RXDSEL. */
#define BM_AUDMUX_PDCR3_RXDSEL (0x0000E000U) /*!< Bit mask for AUDMUX_PDCR3_RXDSEL. */
#define BS_AUDMUX_PDCR3_RXDSEL (3U)        /*!< Bit field size in bits for AUDMUX_PDCR3_RXDSEL. */

/*! @brief Read current value of the AUDMUX_PDCR3_RXDSEL field. */
#define BR_AUDMUX_PDCR3_RXDSEL(x) (HW_AUDMUX_PDCR3(x).B.RXDSEL)

/*! @brief Format value for bitfield AUDMUX_PDCR3_RXDSEL. */
#define BF_AUDMUX_PDCR3_RXDSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR3_RXDSEL) & BM_AUDMUX_PDCR3_RXDSEL)

/*! @brief Set the RXDSEL field to a new value. */
#define BW_AUDMUX_PDCR3_RXDSEL(x, v) (HW_AUDMUX_PDCR3_WR(x, (HW_AUDMUX_PDCR3_RD(x) & ~BM_AUDMUX_PDCR3_RXDSEL) | BF_AUDMUX_PDCR3_RXDSEL(v)))
/*@}*/

/*******************************************************************************
 * HW_AUDMUX_PTCR4 - Port Timing Control Register 4
 ******************************************************************************/

/*!
 * @brief HW_AUDMUX_PTCR4 - Port Timing Control Register 4 (RW)
 *
 * Reset value: 0x00000800U
 *
 * Port Timing Control Register for Port 4
 */
typedef union _hw_audmux_ptcr4
{
    uint32_t U;
    struct _hw_audmux_ptcr4_bitfields
    {
        uint32_t RESERVED0 : 11;       /*!< [10:0]  */
        uint32_t SYN : 1;              /*!< [11]  */
        uint32_t RCSEL : 4;            /*!< [15:12]  */
        uint32_t RCLKDIR : 1;          /*!< [16]  */
        uint32_t RFSEL : 4;            /*!< [20:17]  */
        uint32_t RFS_DIR : 1;          /*!< [21]  */
        uint32_t TCSEL : 4;            /*!< [25:22]  */
        uint32_t TCLKDIR : 1;          /*!< [26]  */
        uint32_t TFSEL : 4;            /*!< [30:27]  */
        uint32_t TFS_DIR : 1;          /*!< [31]  */
    } B;
} hw_audmux_ptcr4_t;

/*!
 * @name Constants and macros for entire AUDMUX_PTCR4 register
 */
/*@{*/
#define HW_AUDMUX_PTCR4_ADDR(x)  ((uintptr_t)(x) + 0x18U)

#define HW_AUDMUX_PTCR4(x)       (*(__IO hw_audmux_ptcr4_t *) HW_AUDMUX_PTCR4_ADDR(x))
#define HW_AUDMUX_PTCR4_RD(x)    (HW_AUDMUX_PTCR4(x).U)
#define HW_AUDMUX_PTCR4_WR(x, v) (HW_AUDMUX_PTCR4(x).U = (v))
#define HW_AUDMUX_PTCR4_SET(x, v) (HW_AUDMUX_PTCR4_WR(x, HW_AUDMUX_PTCR4_RD(x) |  (v)))
#define HW_AUDMUX_PTCR4_CLR(x, v) (HW_AUDMUX_PTCR4_WR(x, HW_AUDMUX_PTCR4_RD(x) & ~(v)))
#define HW_AUDMUX_PTCR4_TOG(x, v) (HW_AUDMUX_PTCR4_WR(x, HW_AUDMUX_PTCR4_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AUDMUX_PTCR4 bitfields
 */

/*!
 * @name Register AUDMUX_PTCR4, field SYN[11] (RW)
 *
 * Synchronous/Asynchronous Select. When SYN is set, synchronous mode is chosen
 * and the transmit and receive sections use common clock and frame sync signals
 * (that is, the port is a 4-wire interface). When SYN is cleared, asynchronous
 * mode is chosen and separate clock and frame sync signals are used for the
 * transmit and receive sections (that is, the port is a 6-wire interface). RCLKDIR
 * and SYN should not be changed at the same time.
 *
 * Values:
 * - 0 - Asynchronous mode
 * - 1 - Synchronous mode (default)
 */
/*@{*/
#define BP_AUDMUX_PTCR4_SYN  (11U)         /*!< Bit position for AUDMUX_PTCR4_SYN. */
#define BM_AUDMUX_PTCR4_SYN  (0x00000800U) /*!< Bit mask for AUDMUX_PTCR4_SYN. */
#define BS_AUDMUX_PTCR4_SYN  (1U)          /*!< Bit field size in bits for AUDMUX_PTCR4_SYN. */

/*! @brief Read current value of the AUDMUX_PTCR4_SYN field. */
#define BR_AUDMUX_PTCR4_SYN(x) (HW_AUDMUX_PTCR4(x).B.SYN)

/*! @brief Format value for bitfield AUDMUX_PTCR4_SYN. */
#define BF_AUDMUX_PTCR4_SYN(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR4_SYN) & BM_AUDMUX_PTCR4_SYN)

/*! @brief Set the SYN field to a new value. */
#define BW_AUDMUX_PTCR4_SYN(x, v) (HW_AUDMUX_PTCR4_WR(x, (HW_AUDMUX_PTCR4_RD(x) & ~BM_AUDMUX_PTCR4_SYN) | BF_AUDMUX_PTCR4_SYN(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR4, field RCSEL[15:12] (RW)
 *
 * Receive Clock Select. Selects the source port from which RXC is sourced. RXC
 * can be sourced from TXC and RXC from other ports.
 *
 * Values:
 * - 1xxx - Selects RXC from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR4_RCSEL (12U)        /*!< Bit position for AUDMUX_PTCR4_RCSEL. */
#define BM_AUDMUX_PTCR4_RCSEL (0x0000F000U) /*!< Bit mask for AUDMUX_PTCR4_RCSEL. */
#define BS_AUDMUX_PTCR4_RCSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR4_RCSEL. */

/*! @brief Read current value of the AUDMUX_PTCR4_RCSEL field. */
#define BR_AUDMUX_PTCR4_RCSEL(x) (HW_AUDMUX_PTCR4(x).B.RCSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR4_RCSEL. */
#define BF_AUDMUX_PTCR4_RCSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR4_RCSEL) & BM_AUDMUX_PTCR4_RCSEL)

/*! @brief Set the RCSEL field to a new value. */
#define BW_AUDMUX_PTCR4_RCSEL(x, v) (HW_AUDMUX_PTCR4_WR(x, (HW_AUDMUX_PTCR4_RD(x) & ~BM_AUDMUX_PTCR4_RCSEL) | BF_AUDMUX_PTCR4_RCSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR4, field RCLKDIR[16] (RW)
 *
 * Receive Clock Direction Control. This bit sets the direction of the RXC pin
 * of the interface as an output or input. When set as an input, the RCSEL
 * settings are ignored. When set as an output, the RCSEL settings determine the source
 * port of the clock. RCLKDIR and SYN should not be changed at the same time.
 *
 * Values:
 * - 0 - RXC is an input.
 * - 1 - RXC is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR4_RCLKDIR (16U)      /*!< Bit position for AUDMUX_PTCR4_RCLKDIR. */
#define BM_AUDMUX_PTCR4_RCLKDIR (0x00010000U) /*!< Bit mask for AUDMUX_PTCR4_RCLKDIR. */
#define BS_AUDMUX_PTCR4_RCLKDIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR4_RCLKDIR. */

/*! @brief Read current value of the AUDMUX_PTCR4_RCLKDIR field. */
#define BR_AUDMUX_PTCR4_RCLKDIR(x) (HW_AUDMUX_PTCR4(x).B.RCLKDIR)

/*! @brief Format value for bitfield AUDMUX_PTCR4_RCLKDIR. */
#define BF_AUDMUX_PTCR4_RCLKDIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR4_RCLKDIR) & BM_AUDMUX_PTCR4_RCLKDIR)

/*! @brief Set the RCLKDIR field to a new value. */
#define BW_AUDMUX_PTCR4_RCLKDIR(x, v) (HW_AUDMUX_PTCR4_WR(x, (HW_AUDMUX_PTCR4_RD(x) & ~BM_AUDMUX_PTCR4_RCLKDIR) | BF_AUDMUX_PTCR4_RCLKDIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR4, field RFSEL[20:17] (RW)
 *
 * Receive Frame Sync Select. Selects the source port from which RXFS is
 * sourced. RXFS can be sourced from TXFS and RXFS from other ports.
 *
 * Values:
 * - 1xxx - Selects RXFS from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR4_RFSEL (17U)        /*!< Bit position for AUDMUX_PTCR4_RFSEL. */
#define BM_AUDMUX_PTCR4_RFSEL (0x001E0000U) /*!< Bit mask for AUDMUX_PTCR4_RFSEL. */
#define BS_AUDMUX_PTCR4_RFSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR4_RFSEL. */

/*! @brief Read current value of the AUDMUX_PTCR4_RFSEL field. */
#define BR_AUDMUX_PTCR4_RFSEL(x) (HW_AUDMUX_PTCR4(x).B.RFSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR4_RFSEL. */
#define BF_AUDMUX_PTCR4_RFSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR4_RFSEL) & BM_AUDMUX_PTCR4_RFSEL)

/*! @brief Set the RFSEL field to a new value. */
#define BW_AUDMUX_PTCR4_RFSEL(x, v) (HW_AUDMUX_PTCR4_WR(x, (HW_AUDMUX_PTCR4_RD(x) & ~BM_AUDMUX_PTCR4_RFSEL) | BF_AUDMUX_PTCR4_RFSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR4, field RFS_DIR[21] (RW)
 *
 * Receive Frame Sync Direction Control. This bit sets the direction of the RXFS
 * pin of the interface as an output or input. When set as an input, the RFSEL
 * settings are ignored. When set as an output, the RFSEL settings determine the
 * source port of the frame sync.
 *
 * Values:
 * - 0 - RXFS is an input.
 * - 1 - RXFS is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR4_RFS_DIR (21U)      /*!< Bit position for AUDMUX_PTCR4_RFS_DIR. */
#define BM_AUDMUX_PTCR4_RFS_DIR (0x00200000U) /*!< Bit mask for AUDMUX_PTCR4_RFS_DIR. */
#define BS_AUDMUX_PTCR4_RFS_DIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR4_RFS_DIR. */

/*! @brief Read current value of the AUDMUX_PTCR4_RFS_DIR field. */
#define BR_AUDMUX_PTCR4_RFS_DIR(x) (HW_AUDMUX_PTCR4(x).B.RFS_DIR)

/*! @brief Format value for bitfield AUDMUX_PTCR4_RFS_DIR. */
#define BF_AUDMUX_PTCR4_RFS_DIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR4_RFS_DIR) & BM_AUDMUX_PTCR4_RFS_DIR)

/*! @brief Set the RFS_DIR field to a new value. */
#define BW_AUDMUX_PTCR4_RFS_DIR(x, v) (HW_AUDMUX_PTCR4_WR(x, (HW_AUDMUX_PTCR4_RD(x) & ~BM_AUDMUX_PTCR4_RFS_DIR) | BF_AUDMUX_PTCR4_RFS_DIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR4, field TCSEL[25:22] (RW)
 *
 * Transmit Clock Select. Selects the source port from which TXC is sourced.
 *
 * Values:
 * - 1xxx - Selects RXC from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR4_TCSEL (22U)        /*!< Bit position for AUDMUX_PTCR4_TCSEL. */
#define BM_AUDMUX_PTCR4_TCSEL (0x03C00000U) /*!< Bit mask for AUDMUX_PTCR4_TCSEL. */
#define BS_AUDMUX_PTCR4_TCSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR4_TCSEL. */

/*! @brief Read current value of the AUDMUX_PTCR4_TCSEL field. */
#define BR_AUDMUX_PTCR4_TCSEL(x) (HW_AUDMUX_PTCR4(x).B.TCSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR4_TCSEL. */
#define BF_AUDMUX_PTCR4_TCSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR4_TCSEL) & BM_AUDMUX_PTCR4_TCSEL)

/*! @brief Set the TCSEL field to a new value. */
#define BW_AUDMUX_PTCR4_TCSEL(x, v) (HW_AUDMUX_PTCR4_WR(x, (HW_AUDMUX_PTCR4_RD(x) & ~BM_AUDMUX_PTCR4_TCSEL) | BF_AUDMUX_PTCR4_TCSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR4, field TCLKDIR[26] (RW)
 *
 * Transmit Clock Direction Control. This bit sets the direction of the TXC pin
 * of the interface as an output or input. When set as an input, the TCSEL
 * settings are ignored. When set as an output, the TCSEL settings determine the source
 * port of the clock.
 *
 * Values:
 * - 0 - TXC is an input.
 * - 1 - TXC is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR4_TCLKDIR (26U)      /*!< Bit position for AUDMUX_PTCR4_TCLKDIR. */
#define BM_AUDMUX_PTCR4_TCLKDIR (0x04000000U) /*!< Bit mask for AUDMUX_PTCR4_TCLKDIR. */
#define BS_AUDMUX_PTCR4_TCLKDIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR4_TCLKDIR. */

/*! @brief Read current value of the AUDMUX_PTCR4_TCLKDIR field. */
#define BR_AUDMUX_PTCR4_TCLKDIR(x) (HW_AUDMUX_PTCR4(x).B.TCLKDIR)

/*! @brief Format value for bitfield AUDMUX_PTCR4_TCLKDIR. */
#define BF_AUDMUX_PTCR4_TCLKDIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR4_TCLKDIR) & BM_AUDMUX_PTCR4_TCLKDIR)

/*! @brief Set the TCLKDIR field to a new value. */
#define BW_AUDMUX_PTCR4_TCLKDIR(x, v) (HW_AUDMUX_PTCR4_WR(x, (HW_AUDMUX_PTCR4_RD(x) & ~BM_AUDMUX_PTCR4_TCLKDIR) | BF_AUDMUX_PTCR4_TCLKDIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR4, field TFSEL[30:27] (RW)
 *
 * Transmit Frame Sync Select. Selects the source port from which TXFS is
 * sourced.
 *
 * Values:
 * - 1xxx - Selects RXFS from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR4_TFSEL (27U)        /*!< Bit position for AUDMUX_PTCR4_TFSEL. */
#define BM_AUDMUX_PTCR4_TFSEL (0x78000000U) /*!< Bit mask for AUDMUX_PTCR4_TFSEL. */
#define BS_AUDMUX_PTCR4_TFSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR4_TFSEL. */

/*! @brief Read current value of the AUDMUX_PTCR4_TFSEL field. */
#define BR_AUDMUX_PTCR4_TFSEL(x) (HW_AUDMUX_PTCR4(x).B.TFSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR4_TFSEL. */
#define BF_AUDMUX_PTCR4_TFSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR4_TFSEL) & BM_AUDMUX_PTCR4_TFSEL)

/*! @brief Set the TFSEL field to a new value. */
#define BW_AUDMUX_PTCR4_TFSEL(x, v) (HW_AUDMUX_PTCR4_WR(x, (HW_AUDMUX_PTCR4_RD(x) & ~BM_AUDMUX_PTCR4_TFSEL) | BF_AUDMUX_PTCR4_TFSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR4, field TFS_DIR[31] (RW)
 *
 * Transmit Frame Sync Direction Control. This bit sets the direction of the
 * TXFS pin of the interface as an output or input. When set as an input, the TFSEL
 * settings are ignored. When set as an output, the TFSEL settings determine the
 * source port of the frame sync.
 *
 * Values:
 * - 0 - TXFS is an input.
 * - 1 - TXFS is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR4_TFS_DIR (31U)      /*!< Bit position for AUDMUX_PTCR4_TFS_DIR. */
#define BM_AUDMUX_PTCR4_TFS_DIR (0x80000000U) /*!< Bit mask for AUDMUX_PTCR4_TFS_DIR. */
#define BS_AUDMUX_PTCR4_TFS_DIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR4_TFS_DIR. */

/*! @brief Read current value of the AUDMUX_PTCR4_TFS_DIR field. */
#define BR_AUDMUX_PTCR4_TFS_DIR(x) (HW_AUDMUX_PTCR4(x).B.TFS_DIR)

/*! @brief Format value for bitfield AUDMUX_PTCR4_TFS_DIR. */
#define BF_AUDMUX_PTCR4_TFS_DIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR4_TFS_DIR) & BM_AUDMUX_PTCR4_TFS_DIR)

/*! @brief Set the TFS_DIR field to a new value. */
#define BW_AUDMUX_PTCR4_TFS_DIR(x, v) (HW_AUDMUX_PTCR4_WR(x, (HW_AUDMUX_PTCR4_RD(x) & ~BM_AUDMUX_PTCR4_TFS_DIR) | BF_AUDMUX_PTCR4_TFS_DIR(v)))
/*@}*/

/*******************************************************************************
 * HW_AUDMUX_PDCR4 - Port Data Control Register 4
 ******************************************************************************/

/*!
 * @brief HW_AUDMUX_PDCR4 - Port Data Control Register 4 (RW)
 *
 * Reset value: 0x00004000U
 *
 * PDCR4 is the Port Data Control Register for Port 4.
 */
typedef union _hw_audmux_pdcr4
{
    uint32_t U;
    struct _hw_audmux_pdcr4_bitfields
    {
        uint32_t INMMASK : 8;          /*!< [7:0]  */
        uint32_t MODE : 1;             /*!< [8]  */
        uint32_t RESERVED0 : 3;        /*!< [11:9]  */
        uint32_t TXRXEN : 1;           /*!< [12]  */
        uint32_t RXDSEL : 3;           /*!< [15:13]  */
        uint32_t RESERVED1 : 16;       /*!< [31:16]  */
    } B;
} hw_audmux_pdcr4_t;

/*!
 * @name Constants and macros for entire AUDMUX_PDCR4 register
 */
/*@{*/
#define HW_AUDMUX_PDCR4_ADDR(x)  ((uintptr_t)(x) + 0x1CU)

#define HW_AUDMUX_PDCR4(x)       (*(__IO hw_audmux_pdcr4_t *) HW_AUDMUX_PDCR4_ADDR(x))
#define HW_AUDMUX_PDCR4_RD(x)    (HW_AUDMUX_PDCR4(x).U)
#define HW_AUDMUX_PDCR4_WR(x, v) (HW_AUDMUX_PDCR4(x).U = (v))
#define HW_AUDMUX_PDCR4_SET(x, v) (HW_AUDMUX_PDCR4_WR(x, HW_AUDMUX_PDCR4_RD(x) |  (v)))
#define HW_AUDMUX_PDCR4_CLR(x, v) (HW_AUDMUX_PDCR4_WR(x, HW_AUDMUX_PDCR4_RD(x) & ~(v)))
#define HW_AUDMUX_PDCR4_TOG(x, v) (HW_AUDMUX_PDCR4_WR(x, HW_AUDMUX_PDCR4_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AUDMUX_PDCR4 bitfields
 */

/*!
 * @name Register AUDMUX_PDCR4, field INMMASK[7:0] (RW)
 *
 * Internal Network Mode Mask. Bit mask that selects the ports from which the
 * RXD signals are to be ANDed together for internal network mode. Bit 6 represents
 * RXD from Port 7 and bit0 represents RXD from Port 1.
 *
 * Values:
 * - 0 - Includes RXDn for ANDing
 * - 1 - Excludes RXDn from ANDing
 */
/*@{*/
#define BP_AUDMUX_PDCR4_INMMASK (0U)       /*!< Bit position for AUDMUX_PDCR4_INMMASK. */
#define BM_AUDMUX_PDCR4_INMMASK (0x000000FFU) /*!< Bit mask for AUDMUX_PDCR4_INMMASK. */
#define BS_AUDMUX_PDCR4_INMMASK (8U)       /*!< Bit field size in bits for AUDMUX_PDCR4_INMMASK. */

/*! @brief Read current value of the AUDMUX_PDCR4_INMMASK field. */
#define BR_AUDMUX_PDCR4_INMMASK(x) (HW_AUDMUX_PDCR4(x).B.INMMASK)

/*! @brief Format value for bitfield AUDMUX_PDCR4_INMMASK. */
#define BF_AUDMUX_PDCR4_INMMASK(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR4_INMMASK) & BM_AUDMUX_PDCR4_INMMASK)

/*! @brief Set the INMMASK field to a new value. */
#define BW_AUDMUX_PDCR4_INMMASK(x, v) (HW_AUDMUX_PDCR4_WR(x, (HW_AUDMUX_PDCR4_RD(x) & ~BM_AUDMUX_PDCR4_INMMASK) | BF_AUDMUX_PDCR4_INMMASK(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR4, field MODE[8] (RW)
 *
 * Mode Select. This field selects the mode in which the port is to operate. The
 * modes of operation include the following: Normal mode, in which the RXD from
 * the port selected by RXDSEL is routed to the port. Internal Network mode in
 * which RXD from other ports are ANDed together. RXDSEL is ignored. INMMASK
 * determines which RXD signals are ANDed together.
 *
 * Values:
 * - 0 - Normal mode
 * - 1 - Internal Network mode
 */
/*@{*/
#define BP_AUDMUX_PDCR4_MODE (8U)          /*!< Bit position for AUDMUX_PDCR4_MODE. */
#define BM_AUDMUX_PDCR4_MODE (0x00000100U) /*!< Bit mask for AUDMUX_PDCR4_MODE. */
#define BS_AUDMUX_PDCR4_MODE (1U)          /*!< Bit field size in bits for AUDMUX_PDCR4_MODE. */

/*! @brief Read current value of the AUDMUX_PDCR4_MODE field. */
#define BR_AUDMUX_PDCR4_MODE(x) (HW_AUDMUX_PDCR4(x).B.MODE)

/*! @brief Format value for bitfield AUDMUX_PDCR4_MODE. */
#define BF_AUDMUX_PDCR4_MODE(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR4_MODE) & BM_AUDMUX_PDCR4_MODE)

/*! @brief Set the MODE field to a new value. */
#define BW_AUDMUX_PDCR4_MODE(x, v) (HW_AUDMUX_PDCR4_WR(x, (HW_AUDMUX_PDCR4_RD(x) & ~BM_AUDMUX_PDCR4_MODE) | BF_AUDMUX_PDCR4_MODE(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR4, field TXRXEN[12] (RW)
 *
 * Transmit/Receive Switch Enable. Swaps the transmit and receive signals.
 *
 * Values:
 * - 0 - No switch (Transmit Pin = Transmit, Receive Pin = Receive)
 * - 1 - Switch (Transmit Pin = Receive, Receive Pin = Transmit)
 */
/*@{*/
#define BP_AUDMUX_PDCR4_TXRXEN (12U)       /*!< Bit position for AUDMUX_PDCR4_TXRXEN. */
#define BM_AUDMUX_PDCR4_TXRXEN (0x00001000U) /*!< Bit mask for AUDMUX_PDCR4_TXRXEN. */
#define BS_AUDMUX_PDCR4_TXRXEN (1U)        /*!< Bit field size in bits for AUDMUX_PDCR4_TXRXEN. */

/*! @brief Read current value of the AUDMUX_PDCR4_TXRXEN field. */
#define BR_AUDMUX_PDCR4_TXRXEN(x) (HW_AUDMUX_PDCR4(x).B.TXRXEN)

/*! @brief Format value for bitfield AUDMUX_PDCR4_TXRXEN. */
#define BF_AUDMUX_PDCR4_TXRXEN(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR4_TXRXEN) & BM_AUDMUX_PDCR4_TXRXEN)

/*! @brief Set the TXRXEN field to a new value. */
#define BW_AUDMUX_PDCR4_TXRXEN(x, v) (HW_AUDMUX_PDCR4_WR(x, (HW_AUDMUX_PDCR4_RD(x) & ~BM_AUDMUX_PDCR4_TXRXEN) | BF_AUDMUX_PDCR4_TXRXEN(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR4, field RXDSEL[15:13] (RW)
 *
 * Receive Data Select. Selects the source port for the RXD data. RXDSEL is
 * ignored if MODE = 1 (that is, Internal Network Mode is enabled).
 *
 * Values:
 * - xxx - Port number for RXD
 * - 000 - Port 1
 * - 110 - Port 7
 * - 111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PDCR4_RXDSEL (13U)       /*!< Bit position for AUDMUX_PDCR4_RXDSEL. */
#define BM_AUDMUX_PDCR4_RXDSEL (0x0000E000U) /*!< Bit mask for AUDMUX_PDCR4_RXDSEL. */
#define BS_AUDMUX_PDCR4_RXDSEL (3U)        /*!< Bit field size in bits for AUDMUX_PDCR4_RXDSEL. */

/*! @brief Read current value of the AUDMUX_PDCR4_RXDSEL field. */
#define BR_AUDMUX_PDCR4_RXDSEL(x) (HW_AUDMUX_PDCR4(x).B.RXDSEL)

/*! @brief Format value for bitfield AUDMUX_PDCR4_RXDSEL. */
#define BF_AUDMUX_PDCR4_RXDSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR4_RXDSEL) & BM_AUDMUX_PDCR4_RXDSEL)

/*! @brief Set the RXDSEL field to a new value. */
#define BW_AUDMUX_PDCR4_RXDSEL(x, v) (HW_AUDMUX_PDCR4_WR(x, (HW_AUDMUX_PDCR4_RD(x) & ~BM_AUDMUX_PDCR4_RXDSEL) | BF_AUDMUX_PDCR4_RXDSEL(v)))
/*@}*/

/*******************************************************************************
 * HW_AUDMUX_PTCR5 - Port Timing Control Register 5
 ******************************************************************************/

/*!
 * @brief HW_AUDMUX_PTCR5 - Port Timing Control Register 5 (RW)
 *
 * Reset value: 0x00000800U
 *
 * Port Timing Control Register for Port 5
 */
typedef union _hw_audmux_ptcr5
{
    uint32_t U;
    struct _hw_audmux_ptcr5_bitfields
    {
        uint32_t RESERVED0 : 11;       /*!< [10:0]  */
        uint32_t SYN : 1;              /*!< [11]  */
        uint32_t RCSEL : 4;            /*!< [15:12]  */
        uint32_t RCLKDIR : 1;          /*!< [16]  */
        uint32_t RFSEL : 4;            /*!< [20:17]  */
        uint32_t RFS_DIR : 1;          /*!< [21]  */
        uint32_t TCSEL : 4;            /*!< [25:22]  */
        uint32_t TCLKDIR : 1;          /*!< [26]  */
        uint32_t TFSEL : 4;            /*!< [30:27]  */
        uint32_t TFS_DIR : 1;          /*!< [31]  */
    } B;
} hw_audmux_ptcr5_t;

/*!
 * @name Constants and macros for entire AUDMUX_PTCR5 register
 */
/*@{*/
#define HW_AUDMUX_PTCR5_ADDR(x)  ((uintptr_t)(x) + 0x20U)

#define HW_AUDMUX_PTCR5(x)       (*(__IO hw_audmux_ptcr5_t *) HW_AUDMUX_PTCR5_ADDR(x))
#define HW_AUDMUX_PTCR5_RD(x)    (HW_AUDMUX_PTCR5(x).U)
#define HW_AUDMUX_PTCR5_WR(x, v) (HW_AUDMUX_PTCR5(x).U = (v))
#define HW_AUDMUX_PTCR5_SET(x, v) (HW_AUDMUX_PTCR5_WR(x, HW_AUDMUX_PTCR5_RD(x) |  (v)))
#define HW_AUDMUX_PTCR5_CLR(x, v) (HW_AUDMUX_PTCR5_WR(x, HW_AUDMUX_PTCR5_RD(x) & ~(v)))
#define HW_AUDMUX_PTCR5_TOG(x, v) (HW_AUDMUX_PTCR5_WR(x, HW_AUDMUX_PTCR5_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AUDMUX_PTCR5 bitfields
 */

/*!
 * @name Register AUDMUX_PTCR5, field SYN[11] (RW)
 *
 * Synchronous/Asynchronous Select. When SYN is set, synchronous mode is chosen
 * and the transmit and receive sections use common clock and frame sync signals
 * (that is, the port is a 4-wire interface). When SYN is cleared, asynchronous
 * mode is chosen and separate clock and frame sync signals are used for the
 * transmit and receive sections (that is, the port is a 6-wire interface). RCLKDIR
 * and SYN should not be changed at the same time.
 *
 * Values:
 * - 0 - Asynchronous mode
 * - 1 - Synchronous mode (default)
 */
/*@{*/
#define BP_AUDMUX_PTCR5_SYN  (11U)         /*!< Bit position for AUDMUX_PTCR5_SYN. */
#define BM_AUDMUX_PTCR5_SYN  (0x00000800U) /*!< Bit mask for AUDMUX_PTCR5_SYN. */
#define BS_AUDMUX_PTCR5_SYN  (1U)          /*!< Bit field size in bits for AUDMUX_PTCR5_SYN. */

/*! @brief Read current value of the AUDMUX_PTCR5_SYN field. */
#define BR_AUDMUX_PTCR5_SYN(x) (HW_AUDMUX_PTCR5(x).B.SYN)

/*! @brief Format value for bitfield AUDMUX_PTCR5_SYN. */
#define BF_AUDMUX_PTCR5_SYN(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR5_SYN) & BM_AUDMUX_PTCR5_SYN)

/*! @brief Set the SYN field to a new value. */
#define BW_AUDMUX_PTCR5_SYN(x, v) (HW_AUDMUX_PTCR5_WR(x, (HW_AUDMUX_PTCR5_RD(x) & ~BM_AUDMUX_PTCR5_SYN) | BF_AUDMUX_PTCR5_SYN(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR5, field RCSEL[15:12] (RW)
 *
 * Receive Clock Select. Selects the source port from which RXC is sourced. RXC
 * can be sourced from TXC and RXC from other ports.
 *
 * Values:
 * - 1xxx - Selects RXC from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR5_RCSEL (12U)        /*!< Bit position for AUDMUX_PTCR5_RCSEL. */
#define BM_AUDMUX_PTCR5_RCSEL (0x0000F000U) /*!< Bit mask for AUDMUX_PTCR5_RCSEL. */
#define BS_AUDMUX_PTCR5_RCSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR5_RCSEL. */

/*! @brief Read current value of the AUDMUX_PTCR5_RCSEL field. */
#define BR_AUDMUX_PTCR5_RCSEL(x) (HW_AUDMUX_PTCR5(x).B.RCSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR5_RCSEL. */
#define BF_AUDMUX_PTCR5_RCSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR5_RCSEL) & BM_AUDMUX_PTCR5_RCSEL)

/*! @brief Set the RCSEL field to a new value. */
#define BW_AUDMUX_PTCR5_RCSEL(x, v) (HW_AUDMUX_PTCR5_WR(x, (HW_AUDMUX_PTCR5_RD(x) & ~BM_AUDMUX_PTCR5_RCSEL) | BF_AUDMUX_PTCR5_RCSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR5, field RCLKDIR[16] (RW)
 *
 * Receive Clock Direction Control. This bit sets the direction of the RXC pin
 * of the interface as an output or input. When set as an input, the RCSEL
 * settings are ignored. When set as an output, the RCSEL settings determine the source
 * port of the clock. RCLKDIR and SYN should not be changed at the same time.
 *
 * Values:
 * - 0 - RXC is an input.
 * - 1 - RXC is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR5_RCLKDIR (16U)      /*!< Bit position for AUDMUX_PTCR5_RCLKDIR. */
#define BM_AUDMUX_PTCR5_RCLKDIR (0x00010000U) /*!< Bit mask for AUDMUX_PTCR5_RCLKDIR. */
#define BS_AUDMUX_PTCR5_RCLKDIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR5_RCLKDIR. */

/*! @brief Read current value of the AUDMUX_PTCR5_RCLKDIR field. */
#define BR_AUDMUX_PTCR5_RCLKDIR(x) (HW_AUDMUX_PTCR5(x).B.RCLKDIR)

/*! @brief Format value for bitfield AUDMUX_PTCR5_RCLKDIR. */
#define BF_AUDMUX_PTCR5_RCLKDIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR5_RCLKDIR) & BM_AUDMUX_PTCR5_RCLKDIR)

/*! @brief Set the RCLKDIR field to a new value. */
#define BW_AUDMUX_PTCR5_RCLKDIR(x, v) (HW_AUDMUX_PTCR5_WR(x, (HW_AUDMUX_PTCR5_RD(x) & ~BM_AUDMUX_PTCR5_RCLKDIR) | BF_AUDMUX_PTCR5_RCLKDIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR5, field RFSEL[20:17] (RW)
 *
 * Receive Frame Sync Select. Selects the source port from which RXFS is
 * sourced. RXFS can be sourced from TXFS and RXFS from other ports.
 *
 * Values:
 * - 1xxx - Selects RXFS from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR5_RFSEL (17U)        /*!< Bit position for AUDMUX_PTCR5_RFSEL. */
#define BM_AUDMUX_PTCR5_RFSEL (0x001E0000U) /*!< Bit mask for AUDMUX_PTCR5_RFSEL. */
#define BS_AUDMUX_PTCR5_RFSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR5_RFSEL. */

/*! @brief Read current value of the AUDMUX_PTCR5_RFSEL field. */
#define BR_AUDMUX_PTCR5_RFSEL(x) (HW_AUDMUX_PTCR5(x).B.RFSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR5_RFSEL. */
#define BF_AUDMUX_PTCR5_RFSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR5_RFSEL) & BM_AUDMUX_PTCR5_RFSEL)

/*! @brief Set the RFSEL field to a new value. */
#define BW_AUDMUX_PTCR5_RFSEL(x, v) (HW_AUDMUX_PTCR5_WR(x, (HW_AUDMUX_PTCR5_RD(x) & ~BM_AUDMUX_PTCR5_RFSEL) | BF_AUDMUX_PTCR5_RFSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR5, field RFS_DIR[21] (RW)
 *
 * Receive Frame Sync Direction Control. This bit sets the direction of the RXFS
 * pin of the interface as an output or input. When set as an input, the RFSEL
 * settings are ignored. When set as an output, the RFSEL settings determine the
 * source port of the frame sync.
 *
 * Values:
 * - 0 - RXFS is an input.
 * - 1 - RXFS is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR5_RFS_DIR (21U)      /*!< Bit position for AUDMUX_PTCR5_RFS_DIR. */
#define BM_AUDMUX_PTCR5_RFS_DIR (0x00200000U) /*!< Bit mask for AUDMUX_PTCR5_RFS_DIR. */
#define BS_AUDMUX_PTCR5_RFS_DIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR5_RFS_DIR. */

/*! @brief Read current value of the AUDMUX_PTCR5_RFS_DIR field. */
#define BR_AUDMUX_PTCR5_RFS_DIR(x) (HW_AUDMUX_PTCR5(x).B.RFS_DIR)

/*! @brief Format value for bitfield AUDMUX_PTCR5_RFS_DIR. */
#define BF_AUDMUX_PTCR5_RFS_DIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR5_RFS_DIR) & BM_AUDMUX_PTCR5_RFS_DIR)

/*! @brief Set the RFS_DIR field to a new value. */
#define BW_AUDMUX_PTCR5_RFS_DIR(x, v) (HW_AUDMUX_PTCR5_WR(x, (HW_AUDMUX_PTCR5_RD(x) & ~BM_AUDMUX_PTCR5_RFS_DIR) | BF_AUDMUX_PTCR5_RFS_DIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR5, field TCSEL[25:22] (RW)
 *
 * Transmit Clock Select. Selects the source port from which TXC is sourced.
 *
 * Values:
 * - 1xxx - Selects RXC from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR5_TCSEL (22U)        /*!< Bit position for AUDMUX_PTCR5_TCSEL. */
#define BM_AUDMUX_PTCR5_TCSEL (0x03C00000U) /*!< Bit mask for AUDMUX_PTCR5_TCSEL. */
#define BS_AUDMUX_PTCR5_TCSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR5_TCSEL. */

/*! @brief Read current value of the AUDMUX_PTCR5_TCSEL field. */
#define BR_AUDMUX_PTCR5_TCSEL(x) (HW_AUDMUX_PTCR5(x).B.TCSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR5_TCSEL. */
#define BF_AUDMUX_PTCR5_TCSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR5_TCSEL) & BM_AUDMUX_PTCR5_TCSEL)

/*! @brief Set the TCSEL field to a new value. */
#define BW_AUDMUX_PTCR5_TCSEL(x, v) (HW_AUDMUX_PTCR5_WR(x, (HW_AUDMUX_PTCR5_RD(x) & ~BM_AUDMUX_PTCR5_TCSEL) | BF_AUDMUX_PTCR5_TCSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR5, field TCLKDIR[26] (RW)
 *
 * Transmit Clock Direction Control. This bit sets the direction of the TXC pin
 * of the interface as an output or input. When set as an input, the TCSEL
 * settings are ignored. When set as an output, the TCSEL settings determine the source
 * port of the clock.
 *
 * Values:
 * - 0 - TXC is an input.
 * - 1 - TXC is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR5_TCLKDIR (26U)      /*!< Bit position for AUDMUX_PTCR5_TCLKDIR. */
#define BM_AUDMUX_PTCR5_TCLKDIR (0x04000000U) /*!< Bit mask for AUDMUX_PTCR5_TCLKDIR. */
#define BS_AUDMUX_PTCR5_TCLKDIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR5_TCLKDIR. */

/*! @brief Read current value of the AUDMUX_PTCR5_TCLKDIR field. */
#define BR_AUDMUX_PTCR5_TCLKDIR(x) (HW_AUDMUX_PTCR5(x).B.TCLKDIR)

/*! @brief Format value for bitfield AUDMUX_PTCR5_TCLKDIR. */
#define BF_AUDMUX_PTCR5_TCLKDIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR5_TCLKDIR) & BM_AUDMUX_PTCR5_TCLKDIR)

/*! @brief Set the TCLKDIR field to a new value. */
#define BW_AUDMUX_PTCR5_TCLKDIR(x, v) (HW_AUDMUX_PTCR5_WR(x, (HW_AUDMUX_PTCR5_RD(x) & ~BM_AUDMUX_PTCR5_TCLKDIR) | BF_AUDMUX_PTCR5_TCLKDIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR5, field TFSEL[30:27] (RW)
 *
 * Transmit Frame Sync Select. Selects the source port from which TXFS is
 * sourced.
 *
 * Values:
 * - 1xxx - Selects RXFS from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR5_TFSEL (27U)        /*!< Bit position for AUDMUX_PTCR5_TFSEL. */
#define BM_AUDMUX_PTCR5_TFSEL (0x78000000U) /*!< Bit mask for AUDMUX_PTCR5_TFSEL. */
#define BS_AUDMUX_PTCR5_TFSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR5_TFSEL. */

/*! @brief Read current value of the AUDMUX_PTCR5_TFSEL field. */
#define BR_AUDMUX_PTCR5_TFSEL(x) (HW_AUDMUX_PTCR5(x).B.TFSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR5_TFSEL. */
#define BF_AUDMUX_PTCR5_TFSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR5_TFSEL) & BM_AUDMUX_PTCR5_TFSEL)

/*! @brief Set the TFSEL field to a new value. */
#define BW_AUDMUX_PTCR5_TFSEL(x, v) (HW_AUDMUX_PTCR5_WR(x, (HW_AUDMUX_PTCR5_RD(x) & ~BM_AUDMUX_PTCR5_TFSEL) | BF_AUDMUX_PTCR5_TFSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR5, field TFS_DIR[31] (RW)
 *
 * Transmit Frame Sync Direction Control. This bit sets the direction of the
 * TXFS pin of the interface as an output or input. When set as an input, the TFSEL
 * settings are ignored. When set as an output, the TFSEL settings determine the
 * source port of the frame sync.
 *
 * Values:
 * - 0 - TXFS is an input.
 * - 1 - TXFS is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR5_TFS_DIR (31U)      /*!< Bit position for AUDMUX_PTCR5_TFS_DIR. */
#define BM_AUDMUX_PTCR5_TFS_DIR (0x80000000U) /*!< Bit mask for AUDMUX_PTCR5_TFS_DIR. */
#define BS_AUDMUX_PTCR5_TFS_DIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR5_TFS_DIR. */

/*! @brief Read current value of the AUDMUX_PTCR5_TFS_DIR field. */
#define BR_AUDMUX_PTCR5_TFS_DIR(x) (HW_AUDMUX_PTCR5(x).B.TFS_DIR)

/*! @brief Format value for bitfield AUDMUX_PTCR5_TFS_DIR. */
#define BF_AUDMUX_PTCR5_TFS_DIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR5_TFS_DIR) & BM_AUDMUX_PTCR5_TFS_DIR)

/*! @brief Set the TFS_DIR field to a new value. */
#define BW_AUDMUX_PTCR5_TFS_DIR(x, v) (HW_AUDMUX_PTCR5_WR(x, (HW_AUDMUX_PTCR5_RD(x) & ~BM_AUDMUX_PTCR5_TFS_DIR) | BF_AUDMUX_PTCR5_TFS_DIR(v)))
/*@}*/

/*******************************************************************************
 * HW_AUDMUX_PDCR5 - Port Data Control Register 5
 ******************************************************************************/

/*!
 * @brief HW_AUDMUX_PDCR5 - Port Data Control Register 5 (RW)
 *
 * Reset value: 0x00002000U
 *
 * PDCR5 is the Port Data Control Register for Port 5.
 */
typedef union _hw_audmux_pdcr5
{
    uint32_t U;
    struct _hw_audmux_pdcr5_bitfields
    {
        uint32_t INMMASK : 8;          /*!< [7:0]  */
        uint32_t MODE : 1;             /*!< [8]  */
        uint32_t RESERVED0 : 3;        /*!< [11:9]  */
        uint32_t TXRXEN : 1;           /*!< [12]  */
        uint32_t RXDSEL : 3;           /*!< [15:13]  */
        uint32_t RESERVED1 : 16;       /*!< [31:16]  */
    } B;
} hw_audmux_pdcr5_t;

/*!
 * @name Constants and macros for entire AUDMUX_PDCR5 register
 */
/*@{*/
#define HW_AUDMUX_PDCR5_ADDR(x)  ((uintptr_t)(x) + 0x24U)

#define HW_AUDMUX_PDCR5(x)       (*(__IO hw_audmux_pdcr5_t *) HW_AUDMUX_PDCR5_ADDR(x))
#define HW_AUDMUX_PDCR5_RD(x)    (HW_AUDMUX_PDCR5(x).U)
#define HW_AUDMUX_PDCR5_WR(x, v) (HW_AUDMUX_PDCR5(x).U = (v))
#define HW_AUDMUX_PDCR5_SET(x, v) (HW_AUDMUX_PDCR5_WR(x, HW_AUDMUX_PDCR5_RD(x) |  (v)))
#define HW_AUDMUX_PDCR5_CLR(x, v) (HW_AUDMUX_PDCR5_WR(x, HW_AUDMUX_PDCR5_RD(x) & ~(v)))
#define HW_AUDMUX_PDCR5_TOG(x, v) (HW_AUDMUX_PDCR5_WR(x, HW_AUDMUX_PDCR5_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AUDMUX_PDCR5 bitfields
 */

/*!
 * @name Register AUDMUX_PDCR5, field INMMASK[7:0] (RW)
 *
 * Internal Network Mode Mask. Bit mask that selects the ports from which the
 * RXD signals are to be ANDed together for internal network mode. Bit 6 represents
 * RXD from Port 7 and bit0 represents RXD from Port 1.
 *
 * Values:
 * - 0 - Includes RXDn for ANDing
 * - 1 - Excludes RXDn from ANDing
 */
/*@{*/
#define BP_AUDMUX_PDCR5_INMMASK (0U)       /*!< Bit position for AUDMUX_PDCR5_INMMASK. */
#define BM_AUDMUX_PDCR5_INMMASK (0x000000FFU) /*!< Bit mask for AUDMUX_PDCR5_INMMASK. */
#define BS_AUDMUX_PDCR5_INMMASK (8U)       /*!< Bit field size in bits for AUDMUX_PDCR5_INMMASK. */

/*! @brief Read current value of the AUDMUX_PDCR5_INMMASK field. */
#define BR_AUDMUX_PDCR5_INMMASK(x) (HW_AUDMUX_PDCR5(x).B.INMMASK)

/*! @brief Format value for bitfield AUDMUX_PDCR5_INMMASK. */
#define BF_AUDMUX_PDCR5_INMMASK(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR5_INMMASK) & BM_AUDMUX_PDCR5_INMMASK)

/*! @brief Set the INMMASK field to a new value. */
#define BW_AUDMUX_PDCR5_INMMASK(x, v) (HW_AUDMUX_PDCR5_WR(x, (HW_AUDMUX_PDCR5_RD(x) & ~BM_AUDMUX_PDCR5_INMMASK) | BF_AUDMUX_PDCR5_INMMASK(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR5, field MODE[8] (RW)
 *
 * Mode Select. This field selects the mode in which the port is to operate. The
 * modes of operation include the following: Normal mode, in which the RXD from
 * the port selected by RXDSEL is routed to the port. Internal Network mode in
 * which RXD from other ports are ANDed together. RXDSEL is ignored. INMMASK
 * determines which RXD signals are ANDed together.
 *
 * Values:
 * - 0 - Normal mode
 * - 1 - Internal Network mode
 */
/*@{*/
#define BP_AUDMUX_PDCR5_MODE (8U)          /*!< Bit position for AUDMUX_PDCR5_MODE. */
#define BM_AUDMUX_PDCR5_MODE (0x00000100U) /*!< Bit mask for AUDMUX_PDCR5_MODE. */
#define BS_AUDMUX_PDCR5_MODE (1U)          /*!< Bit field size in bits for AUDMUX_PDCR5_MODE. */

/*! @brief Read current value of the AUDMUX_PDCR5_MODE field. */
#define BR_AUDMUX_PDCR5_MODE(x) (HW_AUDMUX_PDCR5(x).B.MODE)

/*! @brief Format value for bitfield AUDMUX_PDCR5_MODE. */
#define BF_AUDMUX_PDCR5_MODE(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR5_MODE) & BM_AUDMUX_PDCR5_MODE)

/*! @brief Set the MODE field to a new value. */
#define BW_AUDMUX_PDCR5_MODE(x, v) (HW_AUDMUX_PDCR5_WR(x, (HW_AUDMUX_PDCR5_RD(x) & ~BM_AUDMUX_PDCR5_MODE) | BF_AUDMUX_PDCR5_MODE(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR5, field TXRXEN[12] (RW)
 *
 * Transmit/Receive Switch Enable. Swaps the transmit and receive signals.
 *
 * Values:
 * - 0 - No switch (Transmit Pin = Transmit, Receive Pin = Receive)
 * - 1 - Switch (Transmit Pin = Receive, Receive Pin = Transmit)
 */
/*@{*/
#define BP_AUDMUX_PDCR5_TXRXEN (12U)       /*!< Bit position for AUDMUX_PDCR5_TXRXEN. */
#define BM_AUDMUX_PDCR5_TXRXEN (0x00001000U) /*!< Bit mask for AUDMUX_PDCR5_TXRXEN. */
#define BS_AUDMUX_PDCR5_TXRXEN (1U)        /*!< Bit field size in bits for AUDMUX_PDCR5_TXRXEN. */

/*! @brief Read current value of the AUDMUX_PDCR5_TXRXEN field. */
#define BR_AUDMUX_PDCR5_TXRXEN(x) (HW_AUDMUX_PDCR5(x).B.TXRXEN)

/*! @brief Format value for bitfield AUDMUX_PDCR5_TXRXEN. */
#define BF_AUDMUX_PDCR5_TXRXEN(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR5_TXRXEN) & BM_AUDMUX_PDCR5_TXRXEN)

/*! @brief Set the TXRXEN field to a new value. */
#define BW_AUDMUX_PDCR5_TXRXEN(x, v) (HW_AUDMUX_PDCR5_WR(x, (HW_AUDMUX_PDCR5_RD(x) & ~BM_AUDMUX_PDCR5_TXRXEN) | BF_AUDMUX_PDCR5_TXRXEN(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR5, field RXDSEL[15:13] (RW)
 *
 * Receive Data Select. Selects the source port for the RXD data. RXDSEL is
 * ignored if MODE = 1 (that is, Internal Network Mode is enabled).
 *
 * Values:
 * - xxx - Port number for RXD
 * - 000 - Port 1
 * - 110 - Port 7
 * - 111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PDCR5_RXDSEL (13U)       /*!< Bit position for AUDMUX_PDCR5_RXDSEL. */
#define BM_AUDMUX_PDCR5_RXDSEL (0x0000E000U) /*!< Bit mask for AUDMUX_PDCR5_RXDSEL. */
#define BS_AUDMUX_PDCR5_RXDSEL (3U)        /*!< Bit field size in bits for AUDMUX_PDCR5_RXDSEL. */

/*! @brief Read current value of the AUDMUX_PDCR5_RXDSEL field. */
#define BR_AUDMUX_PDCR5_RXDSEL(x) (HW_AUDMUX_PDCR5(x).B.RXDSEL)

/*! @brief Format value for bitfield AUDMUX_PDCR5_RXDSEL. */
#define BF_AUDMUX_PDCR5_RXDSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR5_RXDSEL) & BM_AUDMUX_PDCR5_RXDSEL)

/*! @brief Set the RXDSEL field to a new value. */
#define BW_AUDMUX_PDCR5_RXDSEL(x, v) (HW_AUDMUX_PDCR5_WR(x, (HW_AUDMUX_PDCR5_RD(x) & ~BM_AUDMUX_PDCR5_RXDSEL) | BF_AUDMUX_PDCR5_RXDSEL(v)))
/*@}*/

/*******************************************************************************
 * HW_AUDMUX_PTCR6 - Port Timing Control Register 6
 ******************************************************************************/

/*!
 * @brief HW_AUDMUX_PTCR6 - Port Timing Control Register 6 (RW)
 *
 * Reset value: 0x00000800U
 *
 * Port Timing Control Register for Port 6
 */
typedef union _hw_audmux_ptcr6
{
    uint32_t U;
    struct _hw_audmux_ptcr6_bitfields
    {
        uint32_t RESERVED0 : 11;       /*!< [10:0]  */
        uint32_t SYN : 1;              /*!< [11]  */
        uint32_t RCSEL : 4;            /*!< [15:12]  */
        uint32_t RCLKDIR : 1;          /*!< [16]  */
        uint32_t RFSEL : 4;            /*!< [20:17]  */
        uint32_t RFS_DIR : 1;          /*!< [21]  */
        uint32_t TCSEL : 4;            /*!< [25:22]  */
        uint32_t TCLKDIR : 1;          /*!< [26]  */
        uint32_t TFSEL : 4;            /*!< [30:27]  */
        uint32_t TFS_DIR : 1;          /*!< [31]  */
    } B;
} hw_audmux_ptcr6_t;

/*!
 * @name Constants and macros for entire AUDMUX_PTCR6 register
 */
/*@{*/
#define HW_AUDMUX_PTCR6_ADDR(x)  ((uintptr_t)(x) + 0x28U)

#define HW_AUDMUX_PTCR6(x)       (*(__IO hw_audmux_ptcr6_t *) HW_AUDMUX_PTCR6_ADDR(x))
#define HW_AUDMUX_PTCR6_RD(x)    (HW_AUDMUX_PTCR6(x).U)
#define HW_AUDMUX_PTCR6_WR(x, v) (HW_AUDMUX_PTCR6(x).U = (v))
#define HW_AUDMUX_PTCR6_SET(x, v) (HW_AUDMUX_PTCR6_WR(x, HW_AUDMUX_PTCR6_RD(x) |  (v)))
#define HW_AUDMUX_PTCR6_CLR(x, v) (HW_AUDMUX_PTCR6_WR(x, HW_AUDMUX_PTCR6_RD(x) & ~(v)))
#define HW_AUDMUX_PTCR6_TOG(x, v) (HW_AUDMUX_PTCR6_WR(x, HW_AUDMUX_PTCR6_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AUDMUX_PTCR6 bitfields
 */

/*!
 * @name Register AUDMUX_PTCR6, field SYN[11] (RW)
 *
 * Synchronous/Asynchronous Select. When SYN is set, synchronous mode is chosen
 * and the transmit and receive sections use common clock and frame sync signals
 * (that is, the port is a 4-wire interface). When SYN is cleared, asynchronous
 * mode is chosen and separate clock and frame sync signals are used for the
 * transmit and receive sections (that is, the port is a 6-wire interface). RCLKDIR
 * and SYN should not be changed at the same time.
 *
 * Values:
 * - 0 - Asynchronous mode
 * - 1 - Synchronous mode (default)
 */
/*@{*/
#define BP_AUDMUX_PTCR6_SYN  (11U)         /*!< Bit position for AUDMUX_PTCR6_SYN. */
#define BM_AUDMUX_PTCR6_SYN  (0x00000800U) /*!< Bit mask for AUDMUX_PTCR6_SYN. */
#define BS_AUDMUX_PTCR6_SYN  (1U)          /*!< Bit field size in bits for AUDMUX_PTCR6_SYN. */

/*! @brief Read current value of the AUDMUX_PTCR6_SYN field. */
#define BR_AUDMUX_PTCR6_SYN(x) (HW_AUDMUX_PTCR6(x).B.SYN)

/*! @brief Format value for bitfield AUDMUX_PTCR6_SYN. */
#define BF_AUDMUX_PTCR6_SYN(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR6_SYN) & BM_AUDMUX_PTCR6_SYN)

/*! @brief Set the SYN field to a new value. */
#define BW_AUDMUX_PTCR6_SYN(x, v) (HW_AUDMUX_PTCR6_WR(x, (HW_AUDMUX_PTCR6_RD(x) & ~BM_AUDMUX_PTCR6_SYN) | BF_AUDMUX_PTCR6_SYN(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR6, field RCSEL[15:12] (RW)
 *
 * Receive Clock Select. Selects the source port from which RXC is sourced. RXC
 * can be sourced from TXC and RXC from other ports.
 *
 * Values:
 * - 1xxx - Selects RXC from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR6_RCSEL (12U)        /*!< Bit position for AUDMUX_PTCR6_RCSEL. */
#define BM_AUDMUX_PTCR6_RCSEL (0x0000F000U) /*!< Bit mask for AUDMUX_PTCR6_RCSEL. */
#define BS_AUDMUX_PTCR6_RCSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR6_RCSEL. */

/*! @brief Read current value of the AUDMUX_PTCR6_RCSEL field. */
#define BR_AUDMUX_PTCR6_RCSEL(x) (HW_AUDMUX_PTCR6(x).B.RCSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR6_RCSEL. */
#define BF_AUDMUX_PTCR6_RCSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR6_RCSEL) & BM_AUDMUX_PTCR6_RCSEL)

/*! @brief Set the RCSEL field to a new value. */
#define BW_AUDMUX_PTCR6_RCSEL(x, v) (HW_AUDMUX_PTCR6_WR(x, (HW_AUDMUX_PTCR6_RD(x) & ~BM_AUDMUX_PTCR6_RCSEL) | BF_AUDMUX_PTCR6_RCSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR6, field RCLKDIR[16] (RW)
 *
 * Receive Clock Direction Control. This bit sets the direction of the RXC pin
 * of the interface as an output or input. When set as an input, the RCSEL
 * settings are ignored. When set as an output, the RCSEL settings determine the source
 * port of the clock. RCLKDIR and SYN should not be changed at the same time.
 *
 * Values:
 * - 0 - RXC is an input.
 * - 1 - RXC is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR6_RCLKDIR (16U)      /*!< Bit position for AUDMUX_PTCR6_RCLKDIR. */
#define BM_AUDMUX_PTCR6_RCLKDIR (0x00010000U) /*!< Bit mask for AUDMUX_PTCR6_RCLKDIR. */
#define BS_AUDMUX_PTCR6_RCLKDIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR6_RCLKDIR. */

/*! @brief Read current value of the AUDMUX_PTCR6_RCLKDIR field. */
#define BR_AUDMUX_PTCR6_RCLKDIR(x) (HW_AUDMUX_PTCR6(x).B.RCLKDIR)

/*! @brief Format value for bitfield AUDMUX_PTCR6_RCLKDIR. */
#define BF_AUDMUX_PTCR6_RCLKDIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR6_RCLKDIR) & BM_AUDMUX_PTCR6_RCLKDIR)

/*! @brief Set the RCLKDIR field to a new value. */
#define BW_AUDMUX_PTCR6_RCLKDIR(x, v) (HW_AUDMUX_PTCR6_WR(x, (HW_AUDMUX_PTCR6_RD(x) & ~BM_AUDMUX_PTCR6_RCLKDIR) | BF_AUDMUX_PTCR6_RCLKDIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR6, field RFSEL[20:17] (RW)
 *
 * Receive Frame Sync Select. Selects the source port from which RXFS is
 * sourced. RXFS can be sourced from TXFS and RXFS from other ports.
 *
 * Values:
 * - 1xxx - Selects RXFS from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR6_RFSEL (17U)        /*!< Bit position for AUDMUX_PTCR6_RFSEL. */
#define BM_AUDMUX_PTCR6_RFSEL (0x001E0000U) /*!< Bit mask for AUDMUX_PTCR6_RFSEL. */
#define BS_AUDMUX_PTCR6_RFSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR6_RFSEL. */

/*! @brief Read current value of the AUDMUX_PTCR6_RFSEL field. */
#define BR_AUDMUX_PTCR6_RFSEL(x) (HW_AUDMUX_PTCR6(x).B.RFSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR6_RFSEL. */
#define BF_AUDMUX_PTCR6_RFSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR6_RFSEL) & BM_AUDMUX_PTCR6_RFSEL)

/*! @brief Set the RFSEL field to a new value. */
#define BW_AUDMUX_PTCR6_RFSEL(x, v) (HW_AUDMUX_PTCR6_WR(x, (HW_AUDMUX_PTCR6_RD(x) & ~BM_AUDMUX_PTCR6_RFSEL) | BF_AUDMUX_PTCR6_RFSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR6, field RFS_DIR[21] (RW)
 *
 * Receive Frame Sync Direction Control. This bit sets the direction of the RXFS
 * pin of the interface as an output or input. When set as an input, the RFSEL
 * settings are ignored. When set as an output, the RFSEL settings determine the
 * source port of the frame sync.
 *
 * Values:
 * - 0 - RXFS is an input.
 * - 1 - RXFS is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR6_RFS_DIR (21U)      /*!< Bit position for AUDMUX_PTCR6_RFS_DIR. */
#define BM_AUDMUX_PTCR6_RFS_DIR (0x00200000U) /*!< Bit mask for AUDMUX_PTCR6_RFS_DIR. */
#define BS_AUDMUX_PTCR6_RFS_DIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR6_RFS_DIR. */

/*! @brief Read current value of the AUDMUX_PTCR6_RFS_DIR field. */
#define BR_AUDMUX_PTCR6_RFS_DIR(x) (HW_AUDMUX_PTCR6(x).B.RFS_DIR)

/*! @brief Format value for bitfield AUDMUX_PTCR6_RFS_DIR. */
#define BF_AUDMUX_PTCR6_RFS_DIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR6_RFS_DIR) & BM_AUDMUX_PTCR6_RFS_DIR)

/*! @brief Set the RFS_DIR field to a new value. */
#define BW_AUDMUX_PTCR6_RFS_DIR(x, v) (HW_AUDMUX_PTCR6_WR(x, (HW_AUDMUX_PTCR6_RD(x) & ~BM_AUDMUX_PTCR6_RFS_DIR) | BF_AUDMUX_PTCR6_RFS_DIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR6, field TCSEL[25:22] (RW)
 *
 * Transmit Clock Select. Selects the source port from which TXC is sourced.
 *
 * Values:
 * - 1xxx - Selects RXC from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR6_TCSEL (22U)        /*!< Bit position for AUDMUX_PTCR6_TCSEL. */
#define BM_AUDMUX_PTCR6_TCSEL (0x03C00000U) /*!< Bit mask for AUDMUX_PTCR6_TCSEL. */
#define BS_AUDMUX_PTCR6_TCSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR6_TCSEL. */

/*! @brief Read current value of the AUDMUX_PTCR6_TCSEL field. */
#define BR_AUDMUX_PTCR6_TCSEL(x) (HW_AUDMUX_PTCR6(x).B.TCSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR6_TCSEL. */
#define BF_AUDMUX_PTCR6_TCSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR6_TCSEL) & BM_AUDMUX_PTCR6_TCSEL)

/*! @brief Set the TCSEL field to a new value. */
#define BW_AUDMUX_PTCR6_TCSEL(x, v) (HW_AUDMUX_PTCR6_WR(x, (HW_AUDMUX_PTCR6_RD(x) & ~BM_AUDMUX_PTCR6_TCSEL) | BF_AUDMUX_PTCR6_TCSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR6, field TCLKDIR[26] (RW)
 *
 * Transmit Clock Direction Control. This bit sets the direction of the TXC pin
 * of the interface as an output or input. When set as an input, the TCSEL
 * settings are ignored. When set as an output, the TCSEL settings determine the source
 * port of the clock.
 *
 * Values:
 * - 0 - TXC is an input.
 * - 1 - TXC is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR6_TCLKDIR (26U)      /*!< Bit position for AUDMUX_PTCR6_TCLKDIR. */
#define BM_AUDMUX_PTCR6_TCLKDIR (0x04000000U) /*!< Bit mask for AUDMUX_PTCR6_TCLKDIR. */
#define BS_AUDMUX_PTCR6_TCLKDIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR6_TCLKDIR. */

/*! @brief Read current value of the AUDMUX_PTCR6_TCLKDIR field. */
#define BR_AUDMUX_PTCR6_TCLKDIR(x) (HW_AUDMUX_PTCR6(x).B.TCLKDIR)

/*! @brief Format value for bitfield AUDMUX_PTCR6_TCLKDIR. */
#define BF_AUDMUX_PTCR6_TCLKDIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR6_TCLKDIR) & BM_AUDMUX_PTCR6_TCLKDIR)

/*! @brief Set the TCLKDIR field to a new value. */
#define BW_AUDMUX_PTCR6_TCLKDIR(x, v) (HW_AUDMUX_PTCR6_WR(x, (HW_AUDMUX_PTCR6_RD(x) & ~BM_AUDMUX_PTCR6_TCLKDIR) | BF_AUDMUX_PTCR6_TCLKDIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR6, field TFSEL[30:27] (RW)
 *
 * Transmit Frame Sync Select. Selects the source port from which TXFS is
 * sourced.
 *
 * Values:
 * - 1xxx - Selects RXFS from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR6_TFSEL (27U)        /*!< Bit position for AUDMUX_PTCR6_TFSEL. */
#define BM_AUDMUX_PTCR6_TFSEL (0x78000000U) /*!< Bit mask for AUDMUX_PTCR6_TFSEL. */
#define BS_AUDMUX_PTCR6_TFSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR6_TFSEL. */

/*! @brief Read current value of the AUDMUX_PTCR6_TFSEL field. */
#define BR_AUDMUX_PTCR6_TFSEL(x) (HW_AUDMUX_PTCR6(x).B.TFSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR6_TFSEL. */
#define BF_AUDMUX_PTCR6_TFSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR6_TFSEL) & BM_AUDMUX_PTCR6_TFSEL)

/*! @brief Set the TFSEL field to a new value. */
#define BW_AUDMUX_PTCR6_TFSEL(x, v) (HW_AUDMUX_PTCR6_WR(x, (HW_AUDMUX_PTCR6_RD(x) & ~BM_AUDMUX_PTCR6_TFSEL) | BF_AUDMUX_PTCR6_TFSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR6, field TFS_DIR[31] (RW)
 *
 * Transmit Frame Sync Direction Control. This bit sets the direction of the
 * TXFS pin of the interface as an output or input. When set as an input, the TFSEL
 * settings are ignored. When set as an output, the TFSEL settings determine the
 * source port of the frame sync.
 *
 * Values:
 * - 0 - TXFS is an input.
 * - 1 - TXFS is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR6_TFS_DIR (31U)      /*!< Bit position for AUDMUX_PTCR6_TFS_DIR. */
#define BM_AUDMUX_PTCR6_TFS_DIR (0x80000000U) /*!< Bit mask for AUDMUX_PTCR6_TFS_DIR. */
#define BS_AUDMUX_PTCR6_TFS_DIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR6_TFS_DIR. */

/*! @brief Read current value of the AUDMUX_PTCR6_TFS_DIR field. */
#define BR_AUDMUX_PTCR6_TFS_DIR(x) (HW_AUDMUX_PTCR6(x).B.TFS_DIR)

/*! @brief Format value for bitfield AUDMUX_PTCR6_TFS_DIR. */
#define BF_AUDMUX_PTCR6_TFS_DIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR6_TFS_DIR) & BM_AUDMUX_PTCR6_TFS_DIR)

/*! @brief Set the TFS_DIR field to a new value. */
#define BW_AUDMUX_PTCR6_TFS_DIR(x, v) (HW_AUDMUX_PTCR6_WR(x, (HW_AUDMUX_PTCR6_RD(x) & ~BM_AUDMUX_PTCR6_TFS_DIR) | BF_AUDMUX_PTCR6_TFS_DIR(v)))
/*@}*/

/*******************************************************************************
 * HW_AUDMUX_PDCR6 - Port Data Control Register 6
 ******************************************************************************/

/*!
 * @brief HW_AUDMUX_PDCR6 - Port Data Control Register 6 (RW)
 *
 * Reset value: 0x00000000U
 *
 * PDCR6 is the Port Data Control Register for Port 6.
 */
typedef union _hw_audmux_pdcr6
{
    uint32_t U;
    struct _hw_audmux_pdcr6_bitfields
    {
        uint32_t INMMASK : 8;          /*!< [7:0]  */
        uint32_t MODE : 1;             /*!< [8]  */
        uint32_t RESERVED0 : 3;        /*!< [11:9]  */
        uint32_t TXRXEN : 1;           /*!< [12]  */
        uint32_t RXDSEL : 3;           /*!< [15:13]  */
        uint32_t RESERVED1 : 16;       /*!< [31:16]  */
    } B;
} hw_audmux_pdcr6_t;

/*!
 * @name Constants and macros for entire AUDMUX_PDCR6 register
 */
/*@{*/
#define HW_AUDMUX_PDCR6_ADDR(x)  ((uintptr_t)(x) + 0x2CU)

#define HW_AUDMUX_PDCR6(x)       (*(__IO hw_audmux_pdcr6_t *) HW_AUDMUX_PDCR6_ADDR(x))
#define HW_AUDMUX_PDCR6_RD(x)    (HW_AUDMUX_PDCR6(x).U)
#define HW_AUDMUX_PDCR6_WR(x, v) (HW_AUDMUX_PDCR6(x).U = (v))
#define HW_AUDMUX_PDCR6_SET(x, v) (HW_AUDMUX_PDCR6_WR(x, HW_AUDMUX_PDCR6_RD(x) |  (v)))
#define HW_AUDMUX_PDCR6_CLR(x, v) (HW_AUDMUX_PDCR6_WR(x, HW_AUDMUX_PDCR6_RD(x) & ~(v)))
#define HW_AUDMUX_PDCR6_TOG(x, v) (HW_AUDMUX_PDCR6_WR(x, HW_AUDMUX_PDCR6_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AUDMUX_PDCR6 bitfields
 */

/*!
 * @name Register AUDMUX_PDCR6, field INMMASK[7:0] (RW)
 *
 * Internal Network Mode Mask. Bit mask that selects the ports from which the
 * RXD signals are to be ANDed together for internal network mode. Bit 6 represents
 * RXD from Port 7 and bit0 represents RXD from Port 1.
 *
 * Values:
 * - 0 - Includes RXDn for ANDing
 * - 1 - Excludes RXDn from ANDing
 */
/*@{*/
#define BP_AUDMUX_PDCR6_INMMASK (0U)       /*!< Bit position for AUDMUX_PDCR6_INMMASK. */
#define BM_AUDMUX_PDCR6_INMMASK (0x000000FFU) /*!< Bit mask for AUDMUX_PDCR6_INMMASK. */
#define BS_AUDMUX_PDCR6_INMMASK (8U)       /*!< Bit field size in bits for AUDMUX_PDCR6_INMMASK. */

/*! @brief Read current value of the AUDMUX_PDCR6_INMMASK field. */
#define BR_AUDMUX_PDCR6_INMMASK(x) (HW_AUDMUX_PDCR6(x).B.INMMASK)

/*! @brief Format value for bitfield AUDMUX_PDCR6_INMMASK. */
#define BF_AUDMUX_PDCR6_INMMASK(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR6_INMMASK) & BM_AUDMUX_PDCR6_INMMASK)

/*! @brief Set the INMMASK field to a new value. */
#define BW_AUDMUX_PDCR6_INMMASK(x, v) (HW_AUDMUX_PDCR6_WR(x, (HW_AUDMUX_PDCR6_RD(x) & ~BM_AUDMUX_PDCR6_INMMASK) | BF_AUDMUX_PDCR6_INMMASK(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR6, field MODE[8] (RW)
 *
 * Mode Select. This field selects the mode in which the port is to operate. The
 * modes of operation include the following: Normal mode, in which the RXD from
 * the port selected by RXDSEL is routed to the port. Internal Network mode in
 * which RXD from other ports are ANDed together. RXDSEL is ignored. INMMASK
 * determines which RXD signals are ANDed together.
 *
 * Values:
 * - 0 - Normal mode
 * - 1 - Internal Network mode
 */
/*@{*/
#define BP_AUDMUX_PDCR6_MODE (8U)          /*!< Bit position for AUDMUX_PDCR6_MODE. */
#define BM_AUDMUX_PDCR6_MODE (0x00000100U) /*!< Bit mask for AUDMUX_PDCR6_MODE. */
#define BS_AUDMUX_PDCR6_MODE (1U)          /*!< Bit field size in bits for AUDMUX_PDCR6_MODE. */

/*! @brief Read current value of the AUDMUX_PDCR6_MODE field. */
#define BR_AUDMUX_PDCR6_MODE(x) (HW_AUDMUX_PDCR6(x).B.MODE)

/*! @brief Format value for bitfield AUDMUX_PDCR6_MODE. */
#define BF_AUDMUX_PDCR6_MODE(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR6_MODE) & BM_AUDMUX_PDCR6_MODE)

/*! @brief Set the MODE field to a new value. */
#define BW_AUDMUX_PDCR6_MODE(x, v) (HW_AUDMUX_PDCR6_WR(x, (HW_AUDMUX_PDCR6_RD(x) & ~BM_AUDMUX_PDCR6_MODE) | BF_AUDMUX_PDCR6_MODE(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR6, field TXRXEN[12] (RW)
 *
 * Transmit/Receive Switch Enable. Swaps the transmit and receive signals.
 *
 * Values:
 * - 0 - No switch (Transmit Pin = Transmit, Receive Pin = Receive)
 * - 1 - Switch (Transmit Pin = Receive, Receive Pin = Transmit)
 */
/*@{*/
#define BP_AUDMUX_PDCR6_TXRXEN (12U)       /*!< Bit position for AUDMUX_PDCR6_TXRXEN. */
#define BM_AUDMUX_PDCR6_TXRXEN (0x00001000U) /*!< Bit mask for AUDMUX_PDCR6_TXRXEN. */
#define BS_AUDMUX_PDCR6_TXRXEN (1U)        /*!< Bit field size in bits for AUDMUX_PDCR6_TXRXEN. */

/*! @brief Read current value of the AUDMUX_PDCR6_TXRXEN field. */
#define BR_AUDMUX_PDCR6_TXRXEN(x) (HW_AUDMUX_PDCR6(x).B.TXRXEN)

/*! @brief Format value for bitfield AUDMUX_PDCR6_TXRXEN. */
#define BF_AUDMUX_PDCR6_TXRXEN(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR6_TXRXEN) & BM_AUDMUX_PDCR6_TXRXEN)

/*! @brief Set the TXRXEN field to a new value. */
#define BW_AUDMUX_PDCR6_TXRXEN(x, v) (HW_AUDMUX_PDCR6_WR(x, (HW_AUDMUX_PDCR6_RD(x) & ~BM_AUDMUX_PDCR6_TXRXEN) | BF_AUDMUX_PDCR6_TXRXEN(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR6, field RXDSEL[15:13] (RW)
 *
 * Receive Data Select. Selects the source port for the RXD data. RXDSEL is
 * ignored if MODE = 1 (that is, Internal Network Mode is enabled).
 *
 * Values:
 * - xxx - Port number for RXD
 * - 000 - Port 1
 * - 110 - Port 7
 * - 111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PDCR6_RXDSEL (13U)       /*!< Bit position for AUDMUX_PDCR6_RXDSEL. */
#define BM_AUDMUX_PDCR6_RXDSEL (0x0000E000U) /*!< Bit mask for AUDMUX_PDCR6_RXDSEL. */
#define BS_AUDMUX_PDCR6_RXDSEL (3U)        /*!< Bit field size in bits for AUDMUX_PDCR6_RXDSEL. */

/*! @brief Read current value of the AUDMUX_PDCR6_RXDSEL field. */
#define BR_AUDMUX_PDCR6_RXDSEL(x) (HW_AUDMUX_PDCR6(x).B.RXDSEL)

/*! @brief Format value for bitfield AUDMUX_PDCR6_RXDSEL. */
#define BF_AUDMUX_PDCR6_RXDSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR6_RXDSEL) & BM_AUDMUX_PDCR6_RXDSEL)

/*! @brief Set the RXDSEL field to a new value. */
#define BW_AUDMUX_PDCR6_RXDSEL(x, v) (HW_AUDMUX_PDCR6_WR(x, (HW_AUDMUX_PDCR6_RD(x) & ~BM_AUDMUX_PDCR6_RXDSEL) | BF_AUDMUX_PDCR6_RXDSEL(v)))
/*@}*/

/*******************************************************************************
 * HW_AUDMUX_PTCR7 - Port Timing Control Register 7
 ******************************************************************************/

/*!
 * @brief HW_AUDMUX_PTCR7 - Port Timing Control Register 7 (RW)
 *
 * Reset value: 0x00000800U
 *
 * Port Timing Control Register for Port 7
 */
typedef union _hw_audmux_ptcr7
{
    uint32_t U;
    struct _hw_audmux_ptcr7_bitfields
    {
        uint32_t RESERVED0 : 11;       /*!< [10:0]  */
        uint32_t SYN : 1;              /*!< [11]  */
        uint32_t RCSEL : 4;            /*!< [15:12]  */
        uint32_t RCLKDIR : 1;          /*!< [16]  */
        uint32_t RFSEL : 4;            /*!< [20:17]  */
        uint32_t RFS_DIR : 1;          /*!< [21]  */
        uint32_t TCSEL : 4;            /*!< [25:22]  */
        uint32_t TCLKDIR : 1;          /*!< [26]  */
        uint32_t TFSEL : 4;            /*!< [30:27]  */
        uint32_t TFS_DIR : 1;          /*!< [31]  */
    } B;
} hw_audmux_ptcr7_t;

/*!
 * @name Constants and macros for entire AUDMUX_PTCR7 register
 */
/*@{*/
#define HW_AUDMUX_PTCR7_ADDR(x)  ((uintptr_t)(x) + 0x30U)

#define HW_AUDMUX_PTCR7(x)       (*(__IO hw_audmux_ptcr7_t *) HW_AUDMUX_PTCR7_ADDR(x))
#define HW_AUDMUX_PTCR7_RD(x)    (HW_AUDMUX_PTCR7(x).U)
#define HW_AUDMUX_PTCR7_WR(x, v) (HW_AUDMUX_PTCR7(x).U = (v))
#define HW_AUDMUX_PTCR7_SET(x, v) (HW_AUDMUX_PTCR7_WR(x, HW_AUDMUX_PTCR7_RD(x) |  (v)))
#define HW_AUDMUX_PTCR7_CLR(x, v) (HW_AUDMUX_PTCR7_WR(x, HW_AUDMUX_PTCR7_RD(x) & ~(v)))
#define HW_AUDMUX_PTCR7_TOG(x, v) (HW_AUDMUX_PTCR7_WR(x, HW_AUDMUX_PTCR7_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AUDMUX_PTCR7 bitfields
 */

/*!
 * @name Register AUDMUX_PTCR7, field SYN[11] (RW)
 *
 * Synchronous/Asynchronous Select. When SYN is set, synchronous mode is chosen
 * and the transmit and receive sections use common clock and frame sync signals
 * (that is, the port is a 4-wire interface). When SYN is cleared, asynchronous
 * mode is chosen and separate clock and frame sync signals are used for the
 * transmit and receive sections (that is, the port is a 6-wire interface). RCLKDIR
 * and SYN should not be changed at the same time.
 *
 * Values:
 * - 0 - Asynchronous mode
 * - 1 - Synchronous mode (default)
 */
/*@{*/
#define BP_AUDMUX_PTCR7_SYN  (11U)         /*!< Bit position for AUDMUX_PTCR7_SYN. */
#define BM_AUDMUX_PTCR7_SYN  (0x00000800U) /*!< Bit mask for AUDMUX_PTCR7_SYN. */
#define BS_AUDMUX_PTCR7_SYN  (1U)          /*!< Bit field size in bits for AUDMUX_PTCR7_SYN. */

/*! @brief Read current value of the AUDMUX_PTCR7_SYN field. */
#define BR_AUDMUX_PTCR7_SYN(x) (HW_AUDMUX_PTCR7(x).B.SYN)

/*! @brief Format value for bitfield AUDMUX_PTCR7_SYN. */
#define BF_AUDMUX_PTCR7_SYN(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR7_SYN) & BM_AUDMUX_PTCR7_SYN)

/*! @brief Set the SYN field to a new value. */
#define BW_AUDMUX_PTCR7_SYN(x, v) (HW_AUDMUX_PTCR7_WR(x, (HW_AUDMUX_PTCR7_RD(x) & ~BM_AUDMUX_PTCR7_SYN) | BF_AUDMUX_PTCR7_SYN(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR7, field RCSEL[15:12] (RW)
 *
 * Receive Clock Select. Selects the source port from which RXC is sourced. RXC
 * can be sourced from TXC and RXC from other ports.
 *
 * Values:
 * - 1xxx - Selects RXC from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR7_RCSEL (12U)        /*!< Bit position for AUDMUX_PTCR7_RCSEL. */
#define BM_AUDMUX_PTCR7_RCSEL (0x0000F000U) /*!< Bit mask for AUDMUX_PTCR7_RCSEL. */
#define BS_AUDMUX_PTCR7_RCSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR7_RCSEL. */

/*! @brief Read current value of the AUDMUX_PTCR7_RCSEL field. */
#define BR_AUDMUX_PTCR7_RCSEL(x) (HW_AUDMUX_PTCR7(x).B.RCSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR7_RCSEL. */
#define BF_AUDMUX_PTCR7_RCSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR7_RCSEL) & BM_AUDMUX_PTCR7_RCSEL)

/*! @brief Set the RCSEL field to a new value. */
#define BW_AUDMUX_PTCR7_RCSEL(x, v) (HW_AUDMUX_PTCR7_WR(x, (HW_AUDMUX_PTCR7_RD(x) & ~BM_AUDMUX_PTCR7_RCSEL) | BF_AUDMUX_PTCR7_RCSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR7, field RCLKDIR[16] (RW)
 *
 * Receive Clock Direction Control. This bit sets the direction of the RXC pin
 * of the interface as an output or input. When set as an input, the RCSEL
 * settings are ignored. When set as an output, the RCSEL settings determine the source
 * port of the clock. RCLKDIR and SYN should not be changed at the same time.
 *
 * Values:
 * - 0 - RXC is an input.
 * - 1 - RXC is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR7_RCLKDIR (16U)      /*!< Bit position for AUDMUX_PTCR7_RCLKDIR. */
#define BM_AUDMUX_PTCR7_RCLKDIR (0x00010000U) /*!< Bit mask for AUDMUX_PTCR7_RCLKDIR. */
#define BS_AUDMUX_PTCR7_RCLKDIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR7_RCLKDIR. */

/*! @brief Read current value of the AUDMUX_PTCR7_RCLKDIR field. */
#define BR_AUDMUX_PTCR7_RCLKDIR(x) (HW_AUDMUX_PTCR7(x).B.RCLKDIR)

/*! @brief Format value for bitfield AUDMUX_PTCR7_RCLKDIR. */
#define BF_AUDMUX_PTCR7_RCLKDIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR7_RCLKDIR) & BM_AUDMUX_PTCR7_RCLKDIR)

/*! @brief Set the RCLKDIR field to a new value. */
#define BW_AUDMUX_PTCR7_RCLKDIR(x, v) (HW_AUDMUX_PTCR7_WR(x, (HW_AUDMUX_PTCR7_RD(x) & ~BM_AUDMUX_PTCR7_RCLKDIR) | BF_AUDMUX_PTCR7_RCLKDIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR7, field RFSEL[20:17] (RW)
 *
 * Receive Frame Sync Select. Selects the source port from which RXFS is
 * sourced. RXFS can be sourced from TXFS and RXFS from other ports.
 *
 * Values:
 * - 1xxx - Selects RXFS from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR7_RFSEL (17U)        /*!< Bit position for AUDMUX_PTCR7_RFSEL. */
#define BM_AUDMUX_PTCR7_RFSEL (0x001E0000U) /*!< Bit mask for AUDMUX_PTCR7_RFSEL. */
#define BS_AUDMUX_PTCR7_RFSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR7_RFSEL. */

/*! @brief Read current value of the AUDMUX_PTCR7_RFSEL field. */
#define BR_AUDMUX_PTCR7_RFSEL(x) (HW_AUDMUX_PTCR7(x).B.RFSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR7_RFSEL. */
#define BF_AUDMUX_PTCR7_RFSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR7_RFSEL) & BM_AUDMUX_PTCR7_RFSEL)

/*! @brief Set the RFSEL field to a new value. */
#define BW_AUDMUX_PTCR7_RFSEL(x, v) (HW_AUDMUX_PTCR7_WR(x, (HW_AUDMUX_PTCR7_RD(x) & ~BM_AUDMUX_PTCR7_RFSEL) | BF_AUDMUX_PTCR7_RFSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR7, field RFS_DIR[21] (RW)
 *
 * Receive Frame Sync Direction Control. This bit sets the direction of the RXFS
 * pin of the interface as an output or input. When set as an input, the RFSEL
 * settings are ignored. When set as an output, the RFSEL settings determine the
 * source port of the frame sync.
 *
 * Values:
 * - 0 - RXFS is an input.
 * - 1 - RXFS is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR7_RFS_DIR (21U)      /*!< Bit position for AUDMUX_PTCR7_RFS_DIR. */
#define BM_AUDMUX_PTCR7_RFS_DIR (0x00200000U) /*!< Bit mask for AUDMUX_PTCR7_RFS_DIR. */
#define BS_AUDMUX_PTCR7_RFS_DIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR7_RFS_DIR. */

/*! @brief Read current value of the AUDMUX_PTCR7_RFS_DIR field. */
#define BR_AUDMUX_PTCR7_RFS_DIR(x) (HW_AUDMUX_PTCR7(x).B.RFS_DIR)

/*! @brief Format value for bitfield AUDMUX_PTCR7_RFS_DIR. */
#define BF_AUDMUX_PTCR7_RFS_DIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR7_RFS_DIR) & BM_AUDMUX_PTCR7_RFS_DIR)

/*! @brief Set the RFS_DIR field to a new value. */
#define BW_AUDMUX_PTCR7_RFS_DIR(x, v) (HW_AUDMUX_PTCR7_WR(x, (HW_AUDMUX_PTCR7_RD(x) & ~BM_AUDMUX_PTCR7_RFS_DIR) | BF_AUDMUX_PTCR7_RFS_DIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR7, field TCSEL[25:22] (RW)
 *
 * Transmit Clock Select. Selects the source port from which TXC is sourced.
 *
 * Values:
 * - 1xxx - Selects RXC from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR7_TCSEL (22U)        /*!< Bit position for AUDMUX_PTCR7_TCSEL. */
#define BM_AUDMUX_PTCR7_TCSEL (0x03C00000U) /*!< Bit mask for AUDMUX_PTCR7_TCSEL. */
#define BS_AUDMUX_PTCR7_TCSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR7_TCSEL. */

/*! @brief Read current value of the AUDMUX_PTCR7_TCSEL field. */
#define BR_AUDMUX_PTCR7_TCSEL(x) (HW_AUDMUX_PTCR7(x).B.TCSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR7_TCSEL. */
#define BF_AUDMUX_PTCR7_TCSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR7_TCSEL) & BM_AUDMUX_PTCR7_TCSEL)

/*! @brief Set the TCSEL field to a new value. */
#define BW_AUDMUX_PTCR7_TCSEL(x, v) (HW_AUDMUX_PTCR7_WR(x, (HW_AUDMUX_PTCR7_RD(x) & ~BM_AUDMUX_PTCR7_TCSEL) | BF_AUDMUX_PTCR7_TCSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR7, field TCLKDIR[26] (RW)
 *
 * Transmit Clock Direction Control. This bit sets the direction of the TXC pin
 * of the interface as an output or input. When set as an input, the TCSEL
 * settings are ignored. When set as an output, the TCSEL settings determine the source
 * port of the clock.
 *
 * Values:
 * - 0 - TXC is an input.
 * - 1 - TXC is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR7_TCLKDIR (26U)      /*!< Bit position for AUDMUX_PTCR7_TCLKDIR. */
#define BM_AUDMUX_PTCR7_TCLKDIR (0x04000000U) /*!< Bit mask for AUDMUX_PTCR7_TCLKDIR. */
#define BS_AUDMUX_PTCR7_TCLKDIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR7_TCLKDIR. */

/*! @brief Read current value of the AUDMUX_PTCR7_TCLKDIR field. */
#define BR_AUDMUX_PTCR7_TCLKDIR(x) (HW_AUDMUX_PTCR7(x).B.TCLKDIR)

/*! @brief Format value for bitfield AUDMUX_PTCR7_TCLKDIR. */
#define BF_AUDMUX_PTCR7_TCLKDIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR7_TCLKDIR) & BM_AUDMUX_PTCR7_TCLKDIR)

/*! @brief Set the TCLKDIR field to a new value. */
#define BW_AUDMUX_PTCR7_TCLKDIR(x, v) (HW_AUDMUX_PTCR7_WR(x, (HW_AUDMUX_PTCR7_RD(x) & ~BM_AUDMUX_PTCR7_TCLKDIR) | BF_AUDMUX_PTCR7_TCLKDIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR7, field TFSEL[30:27] (RW)
 *
 * Transmit Frame Sync Select. Selects the source port from which TXFS is
 * sourced.
 *
 * Values:
 * - 1xxx - Selects RXFS from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR7_TFSEL (27U)        /*!< Bit position for AUDMUX_PTCR7_TFSEL. */
#define BM_AUDMUX_PTCR7_TFSEL (0x78000000U) /*!< Bit mask for AUDMUX_PTCR7_TFSEL. */
#define BS_AUDMUX_PTCR7_TFSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR7_TFSEL. */

/*! @brief Read current value of the AUDMUX_PTCR7_TFSEL field. */
#define BR_AUDMUX_PTCR7_TFSEL(x) (HW_AUDMUX_PTCR7(x).B.TFSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR7_TFSEL. */
#define BF_AUDMUX_PTCR7_TFSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR7_TFSEL) & BM_AUDMUX_PTCR7_TFSEL)

/*! @brief Set the TFSEL field to a new value. */
#define BW_AUDMUX_PTCR7_TFSEL(x, v) (HW_AUDMUX_PTCR7_WR(x, (HW_AUDMUX_PTCR7_RD(x) & ~BM_AUDMUX_PTCR7_TFSEL) | BF_AUDMUX_PTCR7_TFSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR7, field TFS_DIR[31] (RW)
 *
 * Transmit Frame Sync Direction Control. This bit sets the direction of the
 * TXFS pin of the interface as an output or input. When set as an input, the TFSEL
 * settings are ignored. When set as an output, the TFSEL settings determine the
 * source port of the frame sync.
 *
 * Values:
 * - 0 - TXFS is an input.
 * - 1 - TXFS is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR7_TFS_DIR (31U)      /*!< Bit position for AUDMUX_PTCR7_TFS_DIR. */
#define BM_AUDMUX_PTCR7_TFS_DIR (0x80000000U) /*!< Bit mask for AUDMUX_PTCR7_TFS_DIR. */
#define BS_AUDMUX_PTCR7_TFS_DIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR7_TFS_DIR. */

/*! @brief Read current value of the AUDMUX_PTCR7_TFS_DIR field. */
#define BR_AUDMUX_PTCR7_TFS_DIR(x) (HW_AUDMUX_PTCR7(x).B.TFS_DIR)

/*! @brief Format value for bitfield AUDMUX_PTCR7_TFS_DIR. */
#define BF_AUDMUX_PTCR7_TFS_DIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR7_TFS_DIR) & BM_AUDMUX_PTCR7_TFS_DIR)

/*! @brief Set the TFS_DIR field to a new value. */
#define BW_AUDMUX_PTCR7_TFS_DIR(x, v) (HW_AUDMUX_PTCR7_WR(x, (HW_AUDMUX_PTCR7_RD(x) & ~BM_AUDMUX_PTCR7_TFS_DIR) | BF_AUDMUX_PTCR7_TFS_DIR(v)))
/*@}*/

/*******************************************************************************
 * HW_AUDMUX_PDCR7 - Port Data Control Register 7
 ******************************************************************************/

/*!
 * @brief HW_AUDMUX_PDCR7 - Port Data Control Register 7 (RW)
 *
 * Reset value: 0x0000C000U
 *
 * PDCR7 is the Port Data Control Register for Port 7.
 */
typedef union _hw_audmux_pdcr7
{
    uint32_t U;
    struct _hw_audmux_pdcr7_bitfields
    {
        uint32_t INMMASK : 8;          /*!< [7:0]  */
        uint32_t MODE : 1;             /*!< [8]  */
        uint32_t RESERVED0 : 3;        /*!< [11:9]  */
        uint32_t TXRXEN : 1;           /*!< [12]  */
        uint32_t RXDSEL : 3;           /*!< [15:13]  */
        uint32_t RESERVED1 : 16;       /*!< [31:16]  */
    } B;
} hw_audmux_pdcr7_t;

/*!
 * @name Constants and macros for entire AUDMUX_PDCR7 register
 */
/*@{*/
#define HW_AUDMUX_PDCR7_ADDR(x)  ((uintptr_t)(x) + 0x34U)

#define HW_AUDMUX_PDCR7(x)       (*(__IO hw_audmux_pdcr7_t *) HW_AUDMUX_PDCR7_ADDR(x))
#define HW_AUDMUX_PDCR7_RD(x)    (HW_AUDMUX_PDCR7(x).U)
#define HW_AUDMUX_PDCR7_WR(x, v) (HW_AUDMUX_PDCR7(x).U = (v))
#define HW_AUDMUX_PDCR7_SET(x, v) (HW_AUDMUX_PDCR7_WR(x, HW_AUDMUX_PDCR7_RD(x) |  (v)))
#define HW_AUDMUX_PDCR7_CLR(x, v) (HW_AUDMUX_PDCR7_WR(x, HW_AUDMUX_PDCR7_RD(x) & ~(v)))
#define HW_AUDMUX_PDCR7_TOG(x, v) (HW_AUDMUX_PDCR7_WR(x, HW_AUDMUX_PDCR7_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AUDMUX_PDCR7 bitfields
 */

/*!
 * @name Register AUDMUX_PDCR7, field INMMASK[7:0] (RW)
 *
 * Internal Network Mode Mask. Bit mask that selects the ports from which the
 * RXD signals are to be ANDed together for internal network mode. Bit 6 represents
 * RXD from Port 7 and bit0 represents RXD from Port 1.
 *
 * Values:
 * - 0 - Includes RXDn for ANDing
 * - 1 - Excludes RXDn from ANDing
 */
/*@{*/
#define BP_AUDMUX_PDCR7_INMMASK (0U)       /*!< Bit position for AUDMUX_PDCR7_INMMASK. */
#define BM_AUDMUX_PDCR7_INMMASK (0x000000FFU) /*!< Bit mask for AUDMUX_PDCR7_INMMASK. */
#define BS_AUDMUX_PDCR7_INMMASK (8U)       /*!< Bit field size in bits for AUDMUX_PDCR7_INMMASK. */

/*! @brief Read current value of the AUDMUX_PDCR7_INMMASK field. */
#define BR_AUDMUX_PDCR7_INMMASK(x) (HW_AUDMUX_PDCR7(x).B.INMMASK)

/*! @brief Format value for bitfield AUDMUX_PDCR7_INMMASK. */
#define BF_AUDMUX_PDCR7_INMMASK(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR7_INMMASK) & BM_AUDMUX_PDCR7_INMMASK)

/*! @brief Set the INMMASK field to a new value. */
#define BW_AUDMUX_PDCR7_INMMASK(x, v) (HW_AUDMUX_PDCR7_WR(x, (HW_AUDMUX_PDCR7_RD(x) & ~BM_AUDMUX_PDCR7_INMMASK) | BF_AUDMUX_PDCR7_INMMASK(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR7, field MODE[8] (RW)
 *
 * Mode Select. This field selects the mode in which the port is to operate. The
 * modes of operation include the following: Normal mode, in which the RXD from
 * the port selected by RXDSEL is routed to the port. Internal Network mode in
 * which RXD from other ports are ANDed together. RXDSEL is ignored. INMMASK
 * determines which RXD signals are ANDed together.
 *
 * Values:
 * - 0 - Normal mode
 * - 1 - Internal Network mode
 */
/*@{*/
#define BP_AUDMUX_PDCR7_MODE (8U)          /*!< Bit position for AUDMUX_PDCR7_MODE. */
#define BM_AUDMUX_PDCR7_MODE (0x00000100U) /*!< Bit mask for AUDMUX_PDCR7_MODE. */
#define BS_AUDMUX_PDCR7_MODE (1U)          /*!< Bit field size in bits for AUDMUX_PDCR7_MODE. */

/*! @brief Read current value of the AUDMUX_PDCR7_MODE field. */
#define BR_AUDMUX_PDCR7_MODE(x) (HW_AUDMUX_PDCR7(x).B.MODE)

/*! @brief Format value for bitfield AUDMUX_PDCR7_MODE. */
#define BF_AUDMUX_PDCR7_MODE(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR7_MODE) & BM_AUDMUX_PDCR7_MODE)

/*! @brief Set the MODE field to a new value. */
#define BW_AUDMUX_PDCR7_MODE(x, v) (HW_AUDMUX_PDCR7_WR(x, (HW_AUDMUX_PDCR7_RD(x) & ~BM_AUDMUX_PDCR7_MODE) | BF_AUDMUX_PDCR7_MODE(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR7, field TXRXEN[12] (RW)
 *
 * Transmit/Receive Switch Enable. Swaps the transmit and receive signals.
 *
 * Values:
 * - 0 - No switch (Transmit Pin = Transmit, Receive Pin = Receive)
 * - 1 - Switch (Transmit Pin = Receive, Receive Pin = Transmit)
 */
/*@{*/
#define BP_AUDMUX_PDCR7_TXRXEN (12U)       /*!< Bit position for AUDMUX_PDCR7_TXRXEN. */
#define BM_AUDMUX_PDCR7_TXRXEN (0x00001000U) /*!< Bit mask for AUDMUX_PDCR7_TXRXEN. */
#define BS_AUDMUX_PDCR7_TXRXEN (1U)        /*!< Bit field size in bits for AUDMUX_PDCR7_TXRXEN. */

/*! @brief Read current value of the AUDMUX_PDCR7_TXRXEN field. */
#define BR_AUDMUX_PDCR7_TXRXEN(x) (HW_AUDMUX_PDCR7(x).B.TXRXEN)

/*! @brief Format value for bitfield AUDMUX_PDCR7_TXRXEN. */
#define BF_AUDMUX_PDCR7_TXRXEN(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR7_TXRXEN) & BM_AUDMUX_PDCR7_TXRXEN)

/*! @brief Set the TXRXEN field to a new value. */
#define BW_AUDMUX_PDCR7_TXRXEN(x, v) (HW_AUDMUX_PDCR7_WR(x, (HW_AUDMUX_PDCR7_RD(x) & ~BM_AUDMUX_PDCR7_TXRXEN) | BF_AUDMUX_PDCR7_TXRXEN(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR7, field RXDSEL[15:13] (RW)
 *
 * Receive Data Select. Selects the source port for the RXD data. RXDSEL is
 * ignored if MODE = 1 (that is, Internal Network Mode is enabled).
 *
 * Values:
 * - xxx - Port number for RXD
 * - 000 - Port 1
 * - 110 - Port 7
 * - 111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PDCR7_RXDSEL (13U)       /*!< Bit position for AUDMUX_PDCR7_RXDSEL. */
#define BM_AUDMUX_PDCR7_RXDSEL (0x0000E000U) /*!< Bit mask for AUDMUX_PDCR7_RXDSEL. */
#define BS_AUDMUX_PDCR7_RXDSEL (3U)        /*!< Bit field size in bits for AUDMUX_PDCR7_RXDSEL. */

/*! @brief Read current value of the AUDMUX_PDCR7_RXDSEL field. */
#define BR_AUDMUX_PDCR7_RXDSEL(x) (HW_AUDMUX_PDCR7(x).B.RXDSEL)

/*! @brief Format value for bitfield AUDMUX_PDCR7_RXDSEL. */
#define BF_AUDMUX_PDCR7_RXDSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR7_RXDSEL) & BM_AUDMUX_PDCR7_RXDSEL)

/*! @brief Set the RXDSEL field to a new value. */
#define BW_AUDMUX_PDCR7_RXDSEL(x, v) (HW_AUDMUX_PDCR7_WR(x, (HW_AUDMUX_PDCR7_RD(x) & ~BM_AUDMUX_PDCR7_RXDSEL) | BF_AUDMUX_PDCR7_RXDSEL(v)))
/*@}*/

/*******************************************************************************
 * hw_audmux_t - module struct
 ******************************************************************************/
/*!
 * @brief All AUDMUX module registers.
 */
#pragma pack(1)
typedef struct _hw_audmux
{
    __IO hw_audmux_ptcr1_t PTCR1;          /*!< [0x0] Port Timing Control Register 1 */
    __IO hw_audmux_pdcr1_t PDCR1;          /*!< [0x4] Port Data Control Register 1 */
    __IO hw_audmux_ptcr2_t PTCR2;          /*!< [0x8] Port Timing Control Register 2 */
    __IO hw_audmux_pdcr2_t PDCR2;          /*!< [0xC] Port Data Control Register 2 */
    __IO hw_audmux_ptcr3_t PTCR3;          /*!< [0x10] Port Timing Control Register 3 */
    __IO hw_audmux_pdcr3_t PDCR3;          /*!< [0x14] Port Data Control Register 3 */
    __IO hw_audmux_ptcr4_t PTCR4;          /*!< [0x18] Port Timing Control Register 4 */
    __IO hw_audmux_pdcr4_t PDCR4;          /*!< [0x1C] Port Data Control Register 4 */
    __IO hw_audmux_ptcr5_t PTCR5;          /*!< [0x20] Port Timing Control Register 5 */
    __IO hw_audmux_pdcr5_t PDCR5;          /*!< [0x24] Port Data Control Register 5 */
    __IO hw_audmux_ptcr6_t PTCR6;          /*!< [0x28] Port Timing Control Register 6 */
    __IO hw_audmux_pdcr6_t PDCR6;          /*!< [0x2C] Port Data Control Register 6 */
    __IO hw_audmux_ptcr7_t PTCR7;          /*!< [0x30] Port Timing Control Register 7 */
    __IO hw_audmux_pdcr7_t PDCR7;          /*!< [0x34] Port Data Control Register 7 */
} hw_audmux_t;
#pragma pack()

/*! @brief Macro to access all AUDMUX registers. */
/*! @param x AUDMUX module instance base address. */
/*! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
 *     use the '&' operator, like <code>&HW_AUDMUX_REGS(AUDMUX_BASE)</code>. */
#define HW_AUDMUX_REGS(x) (*(hw_audmux_t *)(x))

/*
 * iMX6SX BCH
 *
 * BCH Register Reference Index
 *
 * Registers defined in this header file:
 * - HW_BCH_CTRL - Hardware BCH ECC Accelerator Control Register
 * - HW_BCH_STATUS0 - Hardware ECC Accelerator Status Register 0
 * - HW_BCH_MODE - Hardware ECC Accelerator Mode Register
 * - HW_BCH_ENCODEPTR - Hardware BCH ECC Loopback Encode Buffer Register
 * - HW_BCH_DATAPTR - Hardware BCH ECC Loopback Data Buffer Register
 * - HW_BCH_METAPTR - Hardware BCH ECC Loopback Metadata Buffer Register
 * - HW_BCH_LAYOUTSELECT - Hardware ECC Accelerator Layout Select Register
 * - HW_BCH_FLASH0LAYOUT0 - Hardware BCH ECC Flash 0 Layout 0 Register
 * - HW_BCH_FLASH0LAYOUT1 - Hardware BCH ECC Flash 0 Layout 1 Register
 * - HW_BCH_FLASH1LAYOUT0 - Hardware BCH ECC Flash 1 Layout 0 Register
 * - HW_BCH_FLASH1LAYOUT1 - Hardware BCH ECC Flash 1 Layout 1 Register
 * - HW_BCH_FLASH2LAYOUT0 - Hardware BCH ECC Flash 2 Layout 0 Register
 * - HW_BCH_FLASH2LAYOUT1 - Hardware BCH ECC Flash 2 Layout 1 Register
 * - HW_BCH_FLASH3LAYOUT0 - Hardware BCH ECC Flash 3 Layout 0 Register
 * - HW_BCH_FLASH3LAYOUT1 - Hardware BCH ECC Flash 3 Layout 1 Register
 * - HW_BCH_DEBUG0 - Hardware BCH ECC Debug Register0
 * - HW_BCH_DBGKESREAD - KES Debug Read Register
 * - HW_BCH_DBGCSFEREAD - Chien Search Debug Read Register
 * - HW_BCH_DBGSYNDGENREAD - Syndrome Generator Debug Read Register
 * - HW_BCH_DBGAHBMREAD - Bus Master and ECC Controller Debug Read Register
 * - HW_BCH_BLOCKNAME - Block Name Register
 * - HW_BCH_VERSION - BCH Version Register
 * - HW_BCH_DEBUG1 - Hardware BCH ECC Debug Register 1
 *
 * - hw_bch_t - Struct containing all module registers.
 */

#define HW_BCH_INSTANCE_COUNT (1U) /*!< Number of instances of the BCH module. */
#define HW_BCH (0U) /*!< Instance number for BCH. */
#define BCH_BASE              (0x1808000U) /*!< Base address for BCH. */
/*! Array initializer of BCH base addresses. */
#define BCH_BASE_ADDRS        { BCH_BASE }

/*******************************************************************************
 * HW_BCH_CTRL - Hardware BCH ECC Accelerator Control Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_CTRL - Hardware BCH ECC Accelerator Control Register (RW)
 *
 * Reset value: 0xC0000000U
 *
 * The BCH CTRL provides overall control of the hardware ECC accelerator
 */
typedef union _hw_bch_ctrl
{
    uint32_t U;
    struct _hw_bch_ctrl_bitfields
    {
        uint32_t COMPLETE_IRQ : 1;     /*!< [0]  */
        uint32_t RSVD0 : 1;            /*!< [1] This field is reserved. */
        uint32_t DEBUG_STALL_IRQ : 1;  /*!< [2]  */
        uint32_t BM_ERROR_IRQ : 1;     /*!< [3]  */
        uint32_t RSVD1 : 4;            /*!< [7:4] This field is reserved. */
        uint32_t COMPLETE_IRQ_EN : 1;  /*!< [8]  */
        uint32_t RSVD2 : 1;            /*!< [9] This field is reserved. */
        uint32_t DEBUG_STALL_IRQ_EN : 1; /*!< [10]  */
        uint32_t RSVD3 : 5;            /*!< [15:11] This field is reserved. */
        uint32_t M2M_ENABLE : 1;       /*!< [16]  */
        uint32_t M2M_ENCODE : 1;       /*!< [17]  */
        uint32_t M2M_LAYOUT : 2;       /*!< [19:18]  */
        uint32_t RSVD4 : 2;            /*!< [21:20] This field is reserved. */
        uint32_t DEBUGSYNDROME : 1;    /*!< [22]  */
        uint32_t RSVD5 : 7;            /*!< [29:23] This field is reserved. */
        uint32_t CLKGATE : 1;          /*!< [30]  */
        uint32_t SFTRST : 1;           /*!< [31]  */
    } B;
} hw_bch_ctrl_t;

/*!
 * @name Constants and macros for entire BCH_CTRL register
 */
/*@{*/
#define HW_BCH_CTRL_ADDR(x)      ((uintptr_t)(x) + 0x0U)
#define HW_BCH_CTRL_SET_ADDR(x)  (HW_BCH_CTRL_ADDR(x) + 0x4U)
#define HW_BCH_CTRL_CLR_ADDR(x)  (HW_BCH_CTRL_ADDR(x) + 0x8U)
#define HW_BCH_CTRL_TOG_ADDR(x)  (HW_BCH_CTRL_ADDR(x) + 0xCU)

#define HW_BCH_CTRL(x)           (*(__IO hw_bch_ctrl_t *) HW_BCH_CTRL_ADDR(x))
#define HW_BCH_CTRL_RD(x)        (HW_BCH_CTRL(x).U)
#define HW_BCH_CTRL_WR(x, v)     (HW_BCH_CTRL(x).U = (v))
#define HW_BCH_CTRL_SET(x, v)    ((*(uint32_t *) HW_BCH_CTRL_SET_ADDR(x)) = (v))
#define HW_BCH_CTRL_CLR(x, v)    ((*(uint32_t *) HW_BCH_CTRL_CLR_ADDR(x)) = (v))
#define HW_BCH_CTRL_TOG(x, v)    ((*(uint32_t *) HW_BCH_CTRL_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual BCH_CTRL bitfields
 */

/*!
 * @name Register BCH_CTRL, field COMPLETE_IRQ[0] (RW)
 *
 * This bit indicates the state of the external interrupt line. Write a 1 to the
 * SCT clear address to clear the interrupt status bit. NOTE: subsequent ECC
 * completions will be held off as long as this bit is set. Be sure to read the data
 * from BCH_STATUS0, 1 before clearing this interrupt bit.
 */
/*@{*/
#define BP_BCH_CTRL_COMPLETE_IRQ (0U)      /*!< Bit position for BCH_CTRL_COMPLETE_IRQ. */
#define BM_BCH_CTRL_COMPLETE_IRQ (0x00000001U) /*!< Bit mask for BCH_CTRL_COMPLETE_IRQ. */
#define BS_BCH_CTRL_COMPLETE_IRQ (1U)      /*!< Bit field size in bits for BCH_CTRL_COMPLETE_IRQ. */

/*! @brief Read current value of the BCH_CTRL_COMPLETE_IRQ field. */
#define BR_BCH_CTRL_COMPLETE_IRQ(x) (HW_BCH_CTRL(x).B.COMPLETE_IRQ)

/*! @brief Format value for bitfield BCH_CTRL_COMPLETE_IRQ. */
#define BF_BCH_CTRL_COMPLETE_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_BCH_CTRL_COMPLETE_IRQ) & BM_BCH_CTRL_COMPLETE_IRQ)

/*! @brief Set the COMPLETE_IRQ field to a new value. */
#define BW_BCH_CTRL_COMPLETE_IRQ(x, v) (HW_BCH_CTRL_WR(x, (HW_BCH_CTRL_RD(x) & ~BM_BCH_CTRL_COMPLETE_IRQ) | BF_BCH_CTRL_COMPLETE_IRQ(v)))
/*@}*/

/*!
 * @name Register BCH_CTRL, field RSVD0[1] (RO)
 *
 * This read-only field is reserved and always has the value 0.
 */
/*@{*/
#define BP_BCH_CTRL_RSVD0    (1U)          /*!< Bit position for BCH_CTRL_RSVD0. */
#define BM_BCH_CTRL_RSVD0    (0x00000002U) /*!< Bit mask for BCH_CTRL_RSVD0. */
#define BS_BCH_CTRL_RSVD0    (1U)          /*!< Bit field size in bits for BCH_CTRL_RSVD0. */

/*! @brief Read current value of the BCH_CTRL_RSVD0 field. */
#define BR_BCH_CTRL_RSVD0(x) (HW_BCH_CTRL(x).B.RSVD0)
/*@}*/

/*!
 * @name Register BCH_CTRL, field DEBUG_STALL_IRQ[2] (RW)
 *
 * DEBUG STALL Interrupt Status. Write a 1 to the SCT clear address to clear the
 * interrupt status bit.
 */
/*@{*/
#define BP_BCH_CTRL_DEBUG_STALL_IRQ (2U)   /*!< Bit position for BCH_CTRL_DEBUG_STALL_IRQ. */
#define BM_BCH_CTRL_DEBUG_STALL_IRQ (0x00000004U) /*!< Bit mask for BCH_CTRL_DEBUG_STALL_IRQ. */
#define BS_BCH_CTRL_DEBUG_STALL_IRQ (1U)   /*!< Bit field size in bits for BCH_CTRL_DEBUG_STALL_IRQ. */

/*! @brief Read current value of the BCH_CTRL_DEBUG_STALL_IRQ field. */
#define BR_BCH_CTRL_DEBUG_STALL_IRQ(x) (HW_BCH_CTRL(x).B.DEBUG_STALL_IRQ)

/*! @brief Format value for bitfield BCH_CTRL_DEBUG_STALL_IRQ. */
#define BF_BCH_CTRL_DEBUG_STALL_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_BCH_CTRL_DEBUG_STALL_IRQ) & BM_BCH_CTRL_DEBUG_STALL_IRQ)

/*! @brief Set the DEBUG_STALL_IRQ field to a new value. */
#define BW_BCH_CTRL_DEBUG_STALL_IRQ(x, v) (HW_BCH_CTRL_WR(x, (HW_BCH_CTRL_RD(x) & ~BM_BCH_CTRL_DEBUG_STALL_IRQ) | BF_BCH_CTRL_DEBUG_STALL_IRQ(v)))
/*@}*/

/*!
 * @name Register BCH_CTRL, field BM_ERROR_IRQ[3] (RW)
 *
 * AHB Bus interface Error Interrupt Status. Write a 1 to the SCT clear address
 * to clear the interrupt status bit.
 */
/*@{*/
#define BP_BCH_CTRL_BM_ERROR_IRQ (3U)      /*!< Bit position for BCH_CTRL_BM_ERROR_IRQ. */
#define BM_BCH_CTRL_BM_ERROR_IRQ (0x00000008U) /*!< Bit mask for BCH_CTRL_BM_ERROR_IRQ. */
#define BS_BCH_CTRL_BM_ERROR_IRQ (1U)      /*!< Bit field size in bits for BCH_CTRL_BM_ERROR_IRQ. */

/*! @brief Read current value of the BCH_CTRL_BM_ERROR_IRQ field. */
#define BR_BCH_CTRL_BM_ERROR_IRQ(x) (HW_BCH_CTRL(x).B.BM_ERROR_IRQ)

/*! @brief Format value for bitfield BCH_CTRL_BM_ERROR_IRQ. */
#define BF_BCH_CTRL_BM_ERROR_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_BCH_CTRL_BM_ERROR_IRQ) & BM_BCH_CTRL_BM_ERROR_IRQ)

/*! @brief Set the BM_ERROR_IRQ field to a new value. */
#define BW_BCH_CTRL_BM_ERROR_IRQ(x, v) (HW_BCH_CTRL_WR(x, (HW_BCH_CTRL_RD(x) & ~BM_BCH_CTRL_BM_ERROR_IRQ) | BF_BCH_CTRL_BM_ERROR_IRQ(v)))
/*@}*/

/*!
 * @name Register BCH_CTRL, field RSVD1[7:4] (RO)
 *
 * This read-only field is reserved and always has the value 0.
 */
/*@{*/
#define BP_BCH_CTRL_RSVD1    (4U)          /*!< Bit position for BCH_CTRL_RSVD1. */
#define BM_BCH_CTRL_RSVD1    (0x000000F0U) /*!< Bit mask for BCH_CTRL_RSVD1. */
#define BS_BCH_CTRL_RSVD1    (4U)          /*!< Bit field size in bits for BCH_CTRL_RSVD1. */

/*! @brief Read current value of the BCH_CTRL_RSVD1 field. */
#define BR_BCH_CTRL_RSVD1(x) (HW_BCH_CTRL(x).B.RSVD1)
/*@}*/

/*!
 * @name Register BCH_CTRL, field COMPLETE_IRQ_EN[8] (RW)
 *
 * 1 = interrupt on completion of correction is enabled.
 */
/*@{*/
#define BP_BCH_CTRL_COMPLETE_IRQ_EN (8U)   /*!< Bit position for BCH_CTRL_COMPLETE_IRQ_EN. */
#define BM_BCH_CTRL_COMPLETE_IRQ_EN (0x00000100U) /*!< Bit mask for BCH_CTRL_COMPLETE_IRQ_EN. */
#define BS_BCH_CTRL_COMPLETE_IRQ_EN (1U)   /*!< Bit field size in bits for BCH_CTRL_COMPLETE_IRQ_EN. */

/*! @brief Read current value of the BCH_CTRL_COMPLETE_IRQ_EN field. */
#define BR_BCH_CTRL_COMPLETE_IRQ_EN(x) (HW_BCH_CTRL(x).B.COMPLETE_IRQ_EN)

/*! @brief Format value for bitfield BCH_CTRL_COMPLETE_IRQ_EN. */
#define BF_BCH_CTRL_COMPLETE_IRQ_EN(v) ((uint32_t)((uint32_t)(v) << BP_BCH_CTRL_COMPLETE_IRQ_EN) & BM_BCH_CTRL_COMPLETE_IRQ_EN)

/*! @brief Set the COMPLETE_IRQ_EN field to a new value. */
#define BW_BCH_CTRL_COMPLETE_IRQ_EN(x, v) (HW_BCH_CTRL_WR(x, (HW_BCH_CTRL_RD(x) & ~BM_BCH_CTRL_COMPLETE_IRQ_EN) | BF_BCH_CTRL_COMPLETE_IRQ_EN(v)))
/*@}*/

/*!
 * @name Register BCH_CTRL, field RSVD2[9] (RO)
 *
 * This read-only field is reserved and always has the value 0.
 */
/*@{*/
#define BP_BCH_CTRL_RSVD2    (9U)          /*!< Bit position for BCH_CTRL_RSVD2. */
#define BM_BCH_CTRL_RSVD2    (0x00000200U) /*!< Bit mask for BCH_CTRL_RSVD2. */
#define BS_BCH_CTRL_RSVD2    (1U)          /*!< Bit field size in bits for BCH_CTRL_RSVD2. */

/*! @brief Read current value of the BCH_CTRL_RSVD2 field. */
#define BR_BCH_CTRL_RSVD2(x) (HW_BCH_CTRL(x).B.RSVD2)
/*@}*/

/*!
 * @name Register BCH_CTRL, field DEBUG_STALL_IRQ_EN[10] (RW)
 *
 * 1 = interrupt on debug stall mode is enabled. The IRQ is raised on every block
 */
/*@{*/
#define BP_BCH_CTRL_DEBUG_STALL_IRQ_EN (10U) /*!< Bit position for BCH_CTRL_DEBUG_STALL_IRQ_EN. */
#define BM_BCH_CTRL_DEBUG_STALL_IRQ_EN (0x00000400U) /*!< Bit mask for BCH_CTRL_DEBUG_STALL_IRQ_EN. */
#define BS_BCH_CTRL_DEBUG_STALL_IRQ_EN (1U) /*!< Bit field size in bits for BCH_CTRL_DEBUG_STALL_IRQ_EN. */

/*! @brief Read current value of the BCH_CTRL_DEBUG_STALL_IRQ_EN field. */
#define BR_BCH_CTRL_DEBUG_STALL_IRQ_EN(x) (HW_BCH_CTRL(x).B.DEBUG_STALL_IRQ_EN)

/*! @brief Format value for bitfield BCH_CTRL_DEBUG_STALL_IRQ_EN. */
#define BF_BCH_CTRL_DEBUG_STALL_IRQ_EN(v) ((uint32_t)((uint32_t)(v) << BP_BCH_CTRL_DEBUG_STALL_IRQ_EN) & BM_BCH_CTRL_DEBUG_STALL_IRQ_EN)

/*! @brief Set the DEBUG_STALL_IRQ_EN field to a new value. */
#define BW_BCH_CTRL_DEBUG_STALL_IRQ_EN(x, v) (HW_BCH_CTRL_WR(x, (HW_BCH_CTRL_RD(x) & ~BM_BCH_CTRL_DEBUG_STALL_IRQ_EN) | BF_BCH_CTRL_DEBUG_STALL_IRQ_EN(v)))
/*@}*/

/*!
 * @name Register BCH_CTRL, field RSVD3[15:11] (RO)
 *
 * This read-only field is reserved and always has the value 0
 */
/*@{*/
#define BP_BCH_CTRL_RSVD3    (11U)         /*!< Bit position for BCH_CTRL_RSVD3. */
#define BM_BCH_CTRL_RSVD3    (0x0000F800U) /*!< Bit mask for BCH_CTRL_RSVD3. */
#define BS_BCH_CTRL_RSVD3    (5U)          /*!< Bit field size in bits for BCH_CTRL_RSVD3. */

/*! @brief Read current value of the BCH_CTRL_RSVD3 field. */
#define BR_BCH_CTRL_RSVD3(x) (HW_BCH_CTRL(x).B.RSVD3)
/*@}*/

/*!
 * @name Register BCH_CTRL, field M2M_ENABLE[16] (RW)
 *
 * NOTE! WRITING THIS BIT INITIATES A MEMORY-TO-MEMORY OPERATION. The BCH module
 * must be inactive (not processing data from the GPMI) when this bit is set.
 * The M2M_ENCODE and M2M_LAYOUT bits as well as the ENCODEPTR, DATAPTR, and
 * METAPTR registers are used for memory-to-memory operations and must be correctly
 * programmed before writing this bit.
 */
/*@{*/
#define BP_BCH_CTRL_M2M_ENABLE (16U)       /*!< Bit position for BCH_CTRL_M2M_ENABLE. */
#define BM_BCH_CTRL_M2M_ENABLE (0x00010000U) /*!< Bit mask for BCH_CTRL_M2M_ENABLE. */
#define BS_BCH_CTRL_M2M_ENABLE (1U)        /*!< Bit field size in bits for BCH_CTRL_M2M_ENABLE. */

/*! @brief Read current value of the BCH_CTRL_M2M_ENABLE field. */
#define BR_BCH_CTRL_M2M_ENABLE(x) (HW_BCH_CTRL(x).B.M2M_ENABLE)

/*! @brief Format value for bitfield BCH_CTRL_M2M_ENABLE. */
#define BF_BCH_CTRL_M2M_ENABLE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_CTRL_M2M_ENABLE) & BM_BCH_CTRL_M2M_ENABLE)

/*! @brief Set the M2M_ENABLE field to a new value. */
#define BW_BCH_CTRL_M2M_ENABLE(x, v) (HW_BCH_CTRL_WR(x, (HW_BCH_CTRL_RD(x) & ~BM_BCH_CTRL_M2M_ENABLE) | BF_BCH_CTRL_M2M_ENABLE(v)))
/*@}*/

/*!
 * @name Register BCH_CTRL, field M2M_ENCODE[17] (RW)
 *
 * Selects encode (parity generation) or decode (correction) mode for
 * memory-to-memory operations.
 */
/*@{*/
#define BP_BCH_CTRL_M2M_ENCODE (17U)       /*!< Bit position for BCH_CTRL_M2M_ENCODE. */
#define BM_BCH_CTRL_M2M_ENCODE (0x00020000U) /*!< Bit mask for BCH_CTRL_M2M_ENCODE. */
#define BS_BCH_CTRL_M2M_ENCODE (1U)        /*!< Bit field size in bits for BCH_CTRL_M2M_ENCODE. */

/*! @brief Read current value of the BCH_CTRL_M2M_ENCODE field. */
#define BR_BCH_CTRL_M2M_ENCODE(x) (HW_BCH_CTRL(x).B.M2M_ENCODE)

/*! @brief Format value for bitfield BCH_CTRL_M2M_ENCODE. */
#define BF_BCH_CTRL_M2M_ENCODE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_CTRL_M2M_ENCODE) & BM_BCH_CTRL_M2M_ENCODE)

/*! @brief Set the M2M_ENCODE field to a new value. */
#define BW_BCH_CTRL_M2M_ENCODE(x, v) (HW_BCH_CTRL_WR(x, (HW_BCH_CTRL_RD(x) & ~BM_BCH_CTRL_M2M_ENCODE) | BF_BCH_CTRL_M2M_ENCODE(v)))
/*@}*/

/*!
 * @name Register BCH_CTRL, field M2M_LAYOUT[19:18] (RW)
 *
 * Selects the flash page format for memory-to-memory operations.
 */
/*@{*/
#define BP_BCH_CTRL_M2M_LAYOUT (18U)       /*!< Bit position for BCH_CTRL_M2M_LAYOUT. */
#define BM_BCH_CTRL_M2M_LAYOUT (0x000C0000U) /*!< Bit mask for BCH_CTRL_M2M_LAYOUT. */
#define BS_BCH_CTRL_M2M_LAYOUT (2U)        /*!< Bit field size in bits for BCH_CTRL_M2M_LAYOUT. */

/*! @brief Read current value of the BCH_CTRL_M2M_LAYOUT field. */
#define BR_BCH_CTRL_M2M_LAYOUT(x) (HW_BCH_CTRL(x).B.M2M_LAYOUT)

/*! @brief Format value for bitfield BCH_CTRL_M2M_LAYOUT. */
#define BF_BCH_CTRL_M2M_LAYOUT(v) ((uint32_t)((uint32_t)(v) << BP_BCH_CTRL_M2M_LAYOUT) & BM_BCH_CTRL_M2M_LAYOUT)

/*! @brief Set the M2M_LAYOUT field to a new value. */
#define BW_BCH_CTRL_M2M_LAYOUT(x, v) (HW_BCH_CTRL_WR(x, (HW_BCH_CTRL_RD(x) & ~BM_BCH_CTRL_M2M_LAYOUT) | BF_BCH_CTRL_M2M_LAYOUT(v)))
/*@}*/

/*!
 * @name Register BCH_CTRL, field RSVD4[21:20] (RO)
 *
 * This read-only field is reserved and always has the value 0
 */
/*@{*/
#define BP_BCH_CTRL_RSVD4    (20U)         /*!< Bit position for BCH_CTRL_RSVD4. */
#define BM_BCH_CTRL_RSVD4    (0x00300000U) /*!< Bit mask for BCH_CTRL_RSVD4. */
#define BS_BCH_CTRL_RSVD4    (2U)          /*!< Bit field size in bits for BCH_CTRL_RSVD4. */

/*! @brief Read current value of the BCH_CTRL_RSVD4 field. */
#define BR_BCH_CTRL_RSVD4(x) (HW_BCH_CTRL(x).B.RSVD4)
/*@}*/

/*!
 * @name Register BCH_CTRL, field DEBUGSYNDROME[22] (RW)
 *
 * (For debug purposes only). Enable write of computed syndromes to memory on
 * BCH decode operations. Computed syndromes will be written to the auxiliary
 * buffer after the status block. Syndromes will be written as padded 16-bit values.
 */
/*@{*/
#define BP_BCH_CTRL_DEBUGSYNDROME (22U)    /*!< Bit position for BCH_CTRL_DEBUGSYNDROME. */
#define BM_BCH_CTRL_DEBUGSYNDROME (0x00400000U) /*!< Bit mask for BCH_CTRL_DEBUGSYNDROME. */
#define BS_BCH_CTRL_DEBUGSYNDROME (1U)     /*!< Bit field size in bits for BCH_CTRL_DEBUGSYNDROME. */

/*! @brief Read current value of the BCH_CTRL_DEBUGSYNDROME field. */
#define BR_BCH_CTRL_DEBUGSYNDROME(x) (HW_BCH_CTRL(x).B.DEBUGSYNDROME)

/*! @brief Format value for bitfield BCH_CTRL_DEBUGSYNDROME. */
#define BF_BCH_CTRL_DEBUGSYNDROME(v) ((uint32_t)((uint32_t)(v) << BP_BCH_CTRL_DEBUGSYNDROME) & BM_BCH_CTRL_DEBUGSYNDROME)

/*! @brief Set the DEBUGSYNDROME field to a new value. */
#define BW_BCH_CTRL_DEBUGSYNDROME(x, v) (HW_BCH_CTRL_WR(x, (HW_BCH_CTRL_RD(x) & ~BM_BCH_CTRL_DEBUGSYNDROME) | BF_BCH_CTRL_DEBUGSYNDROME(v)))
/*@}*/

/*!
 * @name Register BCH_CTRL, field RSVD5[29:23] (RO)
 *
 * This read-only field is reserved and always has the value 0.
 */
/*@{*/
#define BP_BCH_CTRL_RSVD5    (23U)         /*!< Bit position for BCH_CTRL_RSVD5. */
#define BM_BCH_CTRL_RSVD5    (0x3F800000U) /*!< Bit mask for BCH_CTRL_RSVD5. */
#define BS_BCH_CTRL_RSVD5    (7U)          /*!< Bit field size in bits for BCH_CTRL_RSVD5. */

/*! @brief Read current value of the BCH_CTRL_RSVD5 field. */
#define BR_BCH_CTRL_RSVD5(x) (HW_BCH_CTRL(x).B.RSVD5)
/*@}*/

/*!
 * @name Register BCH_CTRL, field CLKGATE[30] (RW)
 *
 * This bit must be set to 0 for normal operation. When set to 1 it gates off
 * the clocks to the block.
 *
 * Values:
 * - 0 - Allow BCH to operate normally.
 * - 1 - Do not clock BCH gates in order to minimize power consumption.
 */
/*@{*/
#define BP_BCH_CTRL_CLKGATE  (30U)         /*!< Bit position for BCH_CTRL_CLKGATE. */
#define BM_BCH_CTRL_CLKGATE  (0x40000000U) /*!< Bit mask for BCH_CTRL_CLKGATE. */
#define BS_BCH_CTRL_CLKGATE  (1U)          /*!< Bit field size in bits for BCH_CTRL_CLKGATE. */

#define BV_BCH_CTRL_CLKGATE_RUN        (0U)          /*!< Bit field value for BCH_CTRL_CLKGATE: Allow BCH to operate normally. */
#define BV_BCH_CTRL_CLKGATE_NO_CLKS    (0x1U)        /*!< Bit field value for BCH_CTRL_CLKGATE: Do not clock BCH gates in order to minimize power consumption. */

/*! @brief Read current value of the BCH_CTRL_CLKGATE field. */
#define BR_BCH_CTRL_CLKGATE(x) (HW_BCH_CTRL(x).B.CLKGATE)

/*! @brief Format value for bitfield BCH_CTRL_CLKGATE. */
#define BF_BCH_CTRL_CLKGATE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_CTRL_CLKGATE) & BM_BCH_CTRL_CLKGATE)

/*! @brief Set the CLKGATE field to a new value. */
#define BW_BCH_CTRL_CLKGATE(x, v) (HW_BCH_CTRL_WR(x, (HW_BCH_CTRL_RD(x) & ~BM_BCH_CTRL_CLKGATE) | BF_BCH_CTRL_CLKGATE(v)))
/*@}*/

/*!
 * @name Register BCH_CTRL, field SFTRST[31] (RW)
 *
 * Set this bit to 0 to enable normal BCH operation. Set this bit to 1 (default)
 * to disable clocking with the BCH and hold it in its reset (lowest power)
 * state. This bit can be turned on and then off to reset the BCH block to its
 * default state. This bit resets all state machines except for the AHB master state
 * machine
 *
 * Values:
 * - 0 - Allow BCH to operate normally.
 * - 1 - Hold BCH in reset.
 */
/*@{*/
#define BP_BCH_CTRL_SFTRST   (31U)         /*!< Bit position for BCH_CTRL_SFTRST. */
#define BM_BCH_CTRL_SFTRST   (0x80000000U) /*!< Bit mask for BCH_CTRL_SFTRST. */
#define BS_BCH_CTRL_SFTRST   (1U)          /*!< Bit field size in bits for BCH_CTRL_SFTRST. */

#define BV_BCH_CTRL_SFTRST_RUN         (0U)          /*!< Bit field value for BCH_CTRL_SFTRST: Allow BCH to operate normally. */
#define BV_BCH_CTRL_SFTRST_RESET       (0x1U)        /*!< Bit field value for BCH_CTRL_SFTRST: Hold BCH in reset. */

/*! @brief Read current value of the BCH_CTRL_SFTRST field. */
#define BR_BCH_CTRL_SFTRST(x) (HW_BCH_CTRL(x).B.SFTRST)

/*! @brief Format value for bitfield BCH_CTRL_SFTRST. */
#define BF_BCH_CTRL_SFTRST(v) ((uint32_t)((uint32_t)(v) << BP_BCH_CTRL_SFTRST) & BM_BCH_CTRL_SFTRST)

/*! @brief Set the SFTRST field to a new value. */
#define BW_BCH_CTRL_SFTRST(x, v) (HW_BCH_CTRL_WR(x, (HW_BCH_CTRL_RD(x) & ~BM_BCH_CTRL_SFTRST) | BF_BCH_CTRL_SFTRST(v)))
/*@}*/




/*******************************************************************************
 * HW_BCH_STATUS0 - Hardware ECC Accelerator Status Register 0
 ******************************************************************************/

/*!
 * @brief HW_BCH_STATUS0 - Hardware ECC Accelerator Status Register 0 (RO)
 *
 * Reset value: 0x00000010U
 *
 * The BCH STAT register provides visibility into the run-time status of the BCH
 * and status information when processing is complete. It provides overall
 * status of the hardware ECC accelerator.
 */
typedef union _hw_bch_status0
{
    uint32_t U;
    struct _hw_bch_status0_bitfields
    {
        uint32_t RSVD0 : 2;            /*!< [1:0] This field is reserved. */
        uint32_t UNCORRECTABLE : 1;    /*!< [2]  */
        uint32_t CORRECTED : 1;        /*!< [3]  */
        uint32_t ALLONES : 1;          /*!< [4]  */
        uint32_t RSVD1 : 3;            /*!< [7:5] This field is reserved. */
        uint32_t STATUS_BLK0 : 8;      /*!< [15:8]  */
        uint32_t COMPLETED_CE : 4;     /*!< [19:16]  */
        uint32_t HANDLE : 12;          /*!< [31:20]  */
    } B;
} hw_bch_status0_t;

/*!
 * @name Constants and macros for entire BCH_STATUS0 register
 */
/*@{*/
#define HW_BCH_STATUS0_ADDR(x)   ((uintptr_t)(x) + 0x10U)
#define HW_BCH_STATUS0_SET_ADDR(x) (HW_BCH_STATUS0_ADDR(x) + 0x4U)
#define HW_BCH_STATUS0_CLR_ADDR(x) (HW_BCH_STATUS0_ADDR(x) + 0x8U)
#define HW_BCH_STATUS0_TOG_ADDR(x) (HW_BCH_STATUS0_ADDR(x) + 0xCU)

#define HW_BCH_STATUS0(x)        (*(__I hw_bch_status0_t *) HW_BCH_STATUS0_ADDR(x))
#define HW_BCH_STATUS0_RD(x)     (HW_BCH_STATUS0(x).U)
/*@}*/

/*
 * Constants & macros for individual BCH_STATUS0 bitfields
 */

/*!
 * @name Register BCH_STATUS0, field RSVD0[1:0] (RO)
 *
 * This read-only field is reserved and always has the value 0.
 */
/*@{*/
#define BP_BCH_STATUS0_RSVD0 (0U)          /*!< Bit position for BCH_STATUS0_RSVD0. */
#define BM_BCH_STATUS0_RSVD0 (0x00000003U) /*!< Bit mask for BCH_STATUS0_RSVD0. */
#define BS_BCH_STATUS0_RSVD0 (2U)          /*!< Bit field size in bits for BCH_STATUS0_RSVD0. */

/*! @brief Read current value of the BCH_STATUS0_RSVD0 field. */
#define BR_BCH_STATUS0_RSVD0(x) (HW_BCH_STATUS0(x).B.RSVD0)
/*@}*/

/*!
 * @name Register BCH_STATUS0, field UNCORRECTABLE[2] (RO)
 *
 * 1 = Uncorrectable error encountered during last processing cycle.
 */
/*@{*/
#define BP_BCH_STATUS0_UNCORRECTABLE (2U)  /*!< Bit position for BCH_STATUS0_UNCORRECTABLE. */
#define BM_BCH_STATUS0_UNCORRECTABLE (0x00000004U) /*!< Bit mask for BCH_STATUS0_UNCORRECTABLE. */
#define BS_BCH_STATUS0_UNCORRECTABLE (1U)  /*!< Bit field size in bits for BCH_STATUS0_UNCORRECTABLE. */

/*! @brief Read current value of the BCH_STATUS0_UNCORRECTABLE field. */
#define BR_BCH_STATUS0_UNCORRECTABLE(x) (HW_BCH_STATUS0(x).B.UNCORRECTABLE)
/*@}*/

/*!
 * @name Register BCH_STATUS0, field CORRECTED[3] (RO)
 *
 * 1 = At least one correctable error encountered during last processing cycle.
 */
/*@{*/
#define BP_BCH_STATUS0_CORRECTED (3U)      /*!< Bit position for BCH_STATUS0_CORRECTED. */
#define BM_BCH_STATUS0_CORRECTED (0x00000008U) /*!< Bit mask for BCH_STATUS0_CORRECTED. */
#define BS_BCH_STATUS0_CORRECTED (1U)      /*!< Bit field size in bits for BCH_STATUS0_CORRECTED. */

/*! @brief Read current value of the BCH_STATUS0_CORRECTED field. */
#define BR_BCH_STATUS0_CORRECTED(x) (HW_BCH_STATUS0(x).B.CORRECTED)
/*@}*/

/*!
 * @name Register BCH_STATUS0, field ALLONES[4] (RO)
 *
 * 1 = All data bits of this transaction are ONE.
 */
/*@{*/
#define BP_BCH_STATUS0_ALLONES (4U)        /*!< Bit position for BCH_STATUS0_ALLONES. */
#define BM_BCH_STATUS0_ALLONES (0x00000010U) /*!< Bit mask for BCH_STATUS0_ALLONES. */
#define BS_BCH_STATUS0_ALLONES (1U)        /*!< Bit field size in bits for BCH_STATUS0_ALLONES. */

/*! @brief Read current value of the BCH_STATUS0_ALLONES field. */
#define BR_BCH_STATUS0_ALLONES(x) (HW_BCH_STATUS0(x).B.ALLONES)
/*@}*/

/*!
 * @name Register BCH_STATUS0, field RSVD1[7:5] (RO)
 *
 * This read-only field is reserved and always has the value 0.
 */
/*@{*/
#define BP_BCH_STATUS0_RSVD1 (5U)          /*!< Bit position for BCH_STATUS0_RSVD1. */
#define BM_BCH_STATUS0_RSVD1 (0x000000E0U) /*!< Bit mask for BCH_STATUS0_RSVD1. */
#define BS_BCH_STATUS0_RSVD1 (3U)          /*!< Bit field size in bits for BCH_STATUS0_RSVD1. */

/*! @brief Read current value of the BCH_STATUS0_RSVD1 field. */
#define BR_BCH_STATUS0_RSVD1(x) (HW_BCH_STATUS0(x).B.RSVD1)
/*@}*/

/*!
 * @name Register BCH_STATUS0, field STATUS_BLK0[15:8] (RO)
 *
 * Count of symbols in error during processing of first block of flash (metadata
 * block). The number of errors reported will be in the range of 0 to the ECC
 * correction level for block 0.
 *
 * Values:
 * - 0 - No errors found on block.
 * - 1 - One error found on block.
 * - 10 - One errors found on block.
 * - 11 - One errors found on block.
 * - 100 - One errors found on block.
 * - 11111110 - Block exhibited uncorrectable errors.
 * - 11111111 - Page is erased.
 */
/*@{*/
#define BP_BCH_STATUS0_STATUS_BLK0 (8U)    /*!< Bit position for BCH_STATUS0_STATUS_BLK0. */
#define BM_BCH_STATUS0_STATUS_BLK0 (0x0000FF00U) /*!< Bit mask for BCH_STATUS0_STATUS_BLK0. */
#define BS_BCH_STATUS0_STATUS_BLK0 (8U)    /*!< Bit field size in bits for BCH_STATUS0_STATUS_BLK0. */

#define BV_BCH_STATUS0_STATUS_BLK0_ZERO (0U)         /*!< Bit field value for BCH_STATUS0_STATUS_BLK0: No errors found on block. */
#define BV_BCH_STATUS0_STATUS_BLK0_ERROR1 (0x1U)     /*!< Bit field value for BCH_STATUS0_STATUS_BLK0: One error found on block. */
#define BV_BCH_STATUS0_STATUS_BLK0_ERROR2 (0x2U)     /*!< Bit field value for BCH_STATUS0_STATUS_BLK0: One errors found on block. */
#define BV_BCH_STATUS0_STATUS_BLK0_ERROR3 (0x3U)     /*!< Bit field value for BCH_STATUS0_STATUS_BLK0: One errors found on block. */
#define BV_BCH_STATUS0_STATUS_BLK0_ERROR4 (0x4U)     /*!< Bit field value for BCH_STATUS0_STATUS_BLK0: One errors found on block. */
#define BV_BCH_STATUS0_STATUS_BLK0_UNCORRECTABLE (0xFEU) /*!< Bit field value for BCH_STATUS0_STATUS_BLK0: Block exhibited uncorrectable errors. */
#define BV_BCH_STATUS0_STATUS_BLK0_ERASED (0xFFU)    /*!< Bit field value for BCH_STATUS0_STATUS_BLK0: Page is erased. */

/*! @brief Read current value of the BCH_STATUS0_STATUS_BLK0 field. */
#define BR_BCH_STATUS0_STATUS_BLK0(x) (HW_BCH_STATUS0(x).B.STATUS_BLK0)
/*@}*/

/*!
 * @name Register BCH_STATUS0, field COMPLETED_CE[19:16] (RO)
 *
 * This is the chip enable number corresponding to the NAND device from which
 * this data came.
 */
/*@{*/
#define BP_BCH_STATUS0_COMPLETED_CE (16U)  /*!< Bit position for BCH_STATUS0_COMPLETED_CE. */
#define BM_BCH_STATUS0_COMPLETED_CE (0x000F0000U) /*!< Bit mask for BCH_STATUS0_COMPLETED_CE. */
#define BS_BCH_STATUS0_COMPLETED_CE (4U)   /*!< Bit field size in bits for BCH_STATUS0_COMPLETED_CE. */

/*! @brief Read current value of the BCH_STATUS0_COMPLETED_CE field. */
#define BR_BCH_STATUS0_COMPLETED_CE(x) (HW_BCH_STATUS0(x).B.COMPLETED_CE)
/*@}*/

/*!
 * @name Register BCH_STATUS0, field HANDLE[31:20] (RO)
 *
 * Software supplies a 12 bit handle for this transfer as part of the GPMI DMA
 * PIO operation that started the transaction. That handle passes down the
 * pipeline and ends up here at the time the BCH interrupt is signaled.
 */
/*@{*/
#define BP_BCH_STATUS0_HANDLE (20U)        /*!< Bit position for BCH_STATUS0_HANDLE. */
#define BM_BCH_STATUS0_HANDLE (0xFFF00000U) /*!< Bit mask for BCH_STATUS0_HANDLE. */
#define BS_BCH_STATUS0_HANDLE (12U)        /*!< Bit field size in bits for BCH_STATUS0_HANDLE. */

/*! @brief Read current value of the BCH_STATUS0_HANDLE field. */
#define BR_BCH_STATUS0_HANDLE(x) (HW_BCH_STATUS0(x).B.HANDLE)
/*@}*/




/*******************************************************************************
 * HW_BCH_MODE - Hardware ECC Accelerator Mode Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_MODE - Hardware ECC Accelerator Mode Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The BCH MODE register provides additional mode controls. Contains additional
 * global mode controls for the BCH engine.
 */
typedef union _hw_bch_mode
{
    uint32_t U;
    struct _hw_bch_mode_bitfields
    {
        uint32_t ERASE_THRESHOLD : 8;  /*!< [7:0]  */
        uint32_t RSVD : 24;            /*!< [31:8] This field is reserved. */
    } B;
} hw_bch_mode_t;

/*!
 * @name Constants and macros for entire BCH_MODE register
 */
/*@{*/
#define HW_BCH_MODE_ADDR(x)      ((uintptr_t)(x) + 0x20U)
#define HW_BCH_MODE_SET_ADDR(x)  (HW_BCH_MODE_ADDR(x) + 0x4U)
#define HW_BCH_MODE_CLR_ADDR(x)  (HW_BCH_MODE_ADDR(x) + 0x8U)
#define HW_BCH_MODE_TOG_ADDR(x)  (HW_BCH_MODE_ADDR(x) + 0xCU)

#define HW_BCH_MODE(x)           (*(__IO hw_bch_mode_t *) HW_BCH_MODE_ADDR(x))
#define HW_BCH_MODE_RD(x)        (HW_BCH_MODE(x).U)
#define HW_BCH_MODE_WR(x, v)     (HW_BCH_MODE(x).U = (v))
#define HW_BCH_MODE_SET(x, v)    ((*(uint32_t *) HW_BCH_MODE_SET_ADDR(x)) = (v))
#define HW_BCH_MODE_CLR(x, v)    ((*(uint32_t *) HW_BCH_MODE_CLR_ADDR(x)) = (v))
#define HW_BCH_MODE_TOG(x, v)    ((*(uint32_t *) HW_BCH_MODE_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual BCH_MODE bitfields
 */

/*!
 * @name Register BCH_MODE, field ERASE_THRESHOLD[7:0] (RW)
 *
 * This value indicates the maximum number of zero bits on a flash subpage for
 * it to be considered erased. For SLC NAND devices, this value should be
 * programmed to 0 (meaning that the entire page should consist of bytes of 0xFF. For MLC
 * NAND devices, bit errors may occur on reads (even on blank pages), so this
 * threshold can be used to tune the erased page checking algorithm.
 */
/*@{*/
#define BP_BCH_MODE_ERASE_THRESHOLD (0U)   /*!< Bit position for BCH_MODE_ERASE_THRESHOLD. */
#define BM_BCH_MODE_ERASE_THRESHOLD (0x000000FFU) /*!< Bit mask for BCH_MODE_ERASE_THRESHOLD. */
#define BS_BCH_MODE_ERASE_THRESHOLD (8U)   /*!< Bit field size in bits for BCH_MODE_ERASE_THRESHOLD. */

/*! @brief Read current value of the BCH_MODE_ERASE_THRESHOLD field. */
#define BR_BCH_MODE_ERASE_THRESHOLD(x) (HW_BCH_MODE(x).B.ERASE_THRESHOLD)

/*! @brief Format value for bitfield BCH_MODE_ERASE_THRESHOLD. */
#define BF_BCH_MODE_ERASE_THRESHOLD(v) ((uint32_t)((uint32_t)(v) << BP_BCH_MODE_ERASE_THRESHOLD) & BM_BCH_MODE_ERASE_THRESHOLD)

/*! @brief Set the ERASE_THRESHOLD field to a new value. */
#define BW_BCH_MODE_ERASE_THRESHOLD(x, v) (HW_BCH_MODE_WR(x, (HW_BCH_MODE_RD(x) & ~BM_BCH_MODE_ERASE_THRESHOLD) | BF_BCH_MODE_ERASE_THRESHOLD(v)))
/*@}*/

/*!
 * @name Register BCH_MODE, field RSVD[31:8] (RO)
 *
 * This read-only field is reserved and always has the value 0.
 */
/*@{*/
#define BP_BCH_MODE_RSVD     (8U)          /*!< Bit position for BCH_MODE_RSVD. */
#define BM_BCH_MODE_RSVD     (0xFFFFFF00U) /*!< Bit mask for BCH_MODE_RSVD. */
#define BS_BCH_MODE_RSVD     (24U)         /*!< Bit field size in bits for BCH_MODE_RSVD. */

/*! @brief Read current value of the BCH_MODE_RSVD field. */
#define BR_BCH_MODE_RSVD(x)  (HW_BCH_MODE(x).B.RSVD)
/*@}*/




/*******************************************************************************
 * HW_BCH_ENCODEPTR - Hardware BCH ECC Loopback Encode Buffer Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_ENCODEPTR - Hardware BCH ECC Loopback Encode Buffer Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * When performing memory to memory operations, indicates the address of the
 * encode buffer. This register should be programmed before writing a 1 to the
 * M2M_ENABLE bit in the CTRL register. For memory to memory operations, this register
 * is used as the pointer to the encoded data, which is an output when encoding
 * and an input while decoding.
 */
typedef union _hw_bch_encodeptr
{
    uint32_t U;
    struct _hw_bch_encodeptr_bitfields
    {
        uint32_t ADDR : 32;            /*!< [31:0]  */
    } B;
} hw_bch_encodeptr_t;

/*!
 * @name Constants and macros for entire BCH_ENCODEPTR register
 */
/*@{*/
#define HW_BCH_ENCODEPTR_ADDR(x) ((uintptr_t)(x) + 0x30U)
#define HW_BCH_ENCODEPTR_SET_ADDR(x) (HW_BCH_ENCODEPTR_ADDR(x) + 0x4U)
#define HW_BCH_ENCODEPTR_CLR_ADDR(x) (HW_BCH_ENCODEPTR_ADDR(x) + 0x8U)
#define HW_BCH_ENCODEPTR_TOG_ADDR(x) (HW_BCH_ENCODEPTR_ADDR(x) + 0xCU)

#define HW_BCH_ENCODEPTR(x)      (*(__IO hw_bch_encodeptr_t *) HW_BCH_ENCODEPTR_ADDR(x))
#define HW_BCH_ENCODEPTR_RD(x)   (HW_BCH_ENCODEPTR(x).U)
#define HW_BCH_ENCODEPTR_WR(x, v) (HW_BCH_ENCODEPTR(x).U = (v))
#define HW_BCH_ENCODEPTR_SET(x, v) ((*(uint32_t *) HW_BCH_ENCODEPTR_SET_ADDR(x)) = (v))
#define HW_BCH_ENCODEPTR_CLR(x, v) ((*(uint32_t *) HW_BCH_ENCODEPTR_CLR_ADDR(x)) = (v))
#define HW_BCH_ENCODEPTR_TOG(x, v) ((*(uint32_t *) HW_BCH_ENCODEPTR_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual BCH_ENCODEPTR bitfields
 */

/*!
 * @name Register BCH_ENCODEPTR, field ADDR[31:0] (RW)
 *
 * Address pointer to encode buffer. This is the source for decode operations
 * and the destination for encode operations. This value must be aligned on a 4
 * bytes boundary.
 */
/*@{*/
#define BP_BCH_ENCODEPTR_ADDR (0U)         /*!< Bit position for BCH_ENCODEPTR_ADDR. */
#define BM_BCH_ENCODEPTR_ADDR (0xFFFFFFFFU) /*!< Bit mask for BCH_ENCODEPTR_ADDR. */
#define BS_BCH_ENCODEPTR_ADDR (32U)        /*!< Bit field size in bits for BCH_ENCODEPTR_ADDR. */

/*! @brief Read current value of the BCH_ENCODEPTR_ADDR field. */
#define BR_BCH_ENCODEPTR_ADDR(x) (HW_BCH_ENCODEPTR(x).U)

/*! @brief Format value for bitfield BCH_ENCODEPTR_ADDR. */
#define BF_BCH_ENCODEPTR_ADDR(v) ((uint32_t)((uint32_t)(v) << BP_BCH_ENCODEPTR_ADDR) & BM_BCH_ENCODEPTR_ADDR)

/*! @brief Set the ADDR field to a new value. */
#define BW_BCH_ENCODEPTR_ADDR(x, v) (HW_BCH_ENCODEPTR_WR(x, v))
/*@}*/




/*******************************************************************************
 * HW_BCH_DATAPTR - Hardware BCH ECC Loopback Data Buffer Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_DATAPTR - Hardware BCH ECC Loopback Data Buffer Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * When performing memory to memory operations, indicates the address of the
 * data buffer. For memory to memory operations, this register is used as the
 * pointer to the data to encode or the destination buffer for decode operations.
 */
typedef union _hw_bch_dataptr
{
    uint32_t U;
    struct _hw_bch_dataptr_bitfields
    {
        uint32_t ADDR : 32;            /*!< [31:0]  */
    } B;
} hw_bch_dataptr_t;

/*!
 * @name Constants and macros for entire BCH_DATAPTR register
 */
/*@{*/
#define HW_BCH_DATAPTR_ADDR(x)   ((uintptr_t)(x) + 0x40U)
#define HW_BCH_DATAPTR_SET_ADDR(x) (HW_BCH_DATAPTR_ADDR(x) + 0x4U)
#define HW_BCH_DATAPTR_CLR_ADDR(x) (HW_BCH_DATAPTR_ADDR(x) + 0x8U)
#define HW_BCH_DATAPTR_TOG_ADDR(x) (HW_BCH_DATAPTR_ADDR(x) + 0xCU)

#define HW_BCH_DATAPTR(x)        (*(__IO hw_bch_dataptr_t *) HW_BCH_DATAPTR_ADDR(x))
#define HW_BCH_DATAPTR_RD(x)     (HW_BCH_DATAPTR(x).U)
#define HW_BCH_DATAPTR_WR(x, v)  (HW_BCH_DATAPTR(x).U = (v))
#define HW_BCH_DATAPTR_SET(x, v) ((*(uint32_t *) HW_BCH_DATAPTR_SET_ADDR(x)) = (v))
#define HW_BCH_DATAPTR_CLR(x, v) ((*(uint32_t *) HW_BCH_DATAPTR_CLR_ADDR(x)) = (v))
#define HW_BCH_DATAPTR_TOG(x, v) ((*(uint32_t *) HW_BCH_DATAPTR_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual BCH_DATAPTR bitfields
 */

/*!
 * @name Register BCH_DATAPTR, field ADDR[31:0] (RW)
 *
 * Address pointer to data buffer. This is the source for encode operations and
 * the destination for decode operations. This register should be programmed
 * before writing a 1 to the M2M_ENABLE bit in the CTRL register. This value must be
 * aligned on a 4 byte boundary.
 */
/*@{*/
#define BP_BCH_DATAPTR_ADDR  (0U)          /*!< Bit position for BCH_DATAPTR_ADDR. */
#define BM_BCH_DATAPTR_ADDR  (0xFFFFFFFFU) /*!< Bit mask for BCH_DATAPTR_ADDR. */
#define BS_BCH_DATAPTR_ADDR  (32U)         /*!< Bit field size in bits for BCH_DATAPTR_ADDR. */

/*! @brief Read current value of the BCH_DATAPTR_ADDR field. */
#define BR_BCH_DATAPTR_ADDR(x) (HW_BCH_DATAPTR(x).U)

/*! @brief Format value for bitfield BCH_DATAPTR_ADDR. */
#define BF_BCH_DATAPTR_ADDR(v) ((uint32_t)((uint32_t)(v) << BP_BCH_DATAPTR_ADDR) & BM_BCH_DATAPTR_ADDR)

/*! @brief Set the ADDR field to a new value. */
#define BW_BCH_DATAPTR_ADDR(x, v) (HW_BCH_DATAPTR_WR(x, v))
/*@}*/




/*******************************************************************************
 * HW_BCH_METAPTR - Hardware BCH ECC Loopback Metadata Buffer Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_METAPTR - Hardware BCH ECC Loopback Metadata Buffer Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * When performing memory to memory operations, indicates the address of the
 * metadata buffer. For memory to memory operations, this register is used as the
 * pointer to the metadata to encode or the extracted metadata for decode
 * operations.
 */
typedef union _hw_bch_metaptr
{
    uint32_t U;
    struct _hw_bch_metaptr_bitfields
    {
        uint32_t ADDR : 32;            /*!< [31:0]  */
    } B;
} hw_bch_metaptr_t;

/*!
 * @name Constants and macros for entire BCH_METAPTR register
 */
/*@{*/
#define HW_BCH_METAPTR_ADDR(x)   ((uintptr_t)(x) + 0x50U)
#define HW_BCH_METAPTR_SET_ADDR(x) (HW_BCH_METAPTR_ADDR(x) + 0x4U)
#define HW_BCH_METAPTR_CLR_ADDR(x) (HW_BCH_METAPTR_ADDR(x) + 0x8U)
#define HW_BCH_METAPTR_TOG_ADDR(x) (HW_BCH_METAPTR_ADDR(x) + 0xCU)

#define HW_BCH_METAPTR(x)        (*(__IO hw_bch_metaptr_t *) HW_BCH_METAPTR_ADDR(x))
#define HW_BCH_METAPTR_RD(x)     (HW_BCH_METAPTR(x).U)
#define HW_BCH_METAPTR_WR(x, v)  (HW_BCH_METAPTR(x).U = (v))
#define HW_BCH_METAPTR_SET(x, v) ((*(uint32_t *) HW_BCH_METAPTR_SET_ADDR(x)) = (v))
#define HW_BCH_METAPTR_CLR(x, v) ((*(uint32_t *) HW_BCH_METAPTR_CLR_ADDR(x)) = (v))
#define HW_BCH_METAPTR_TOG(x, v) ((*(uint32_t *) HW_BCH_METAPTR_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual BCH_METAPTR bitfields
 */

/*!
 * @name Register BCH_METAPTR, field ADDR[31:0] (RW)
 *
 * Address pointer to metadata buffer. This is the source for encode metadata
 * read operations and the destination for metadata decode operations. This
 * register should be programmed before writing a 1 to the M2M_ENABLE bit in the CTRL
 * register. This value must be aligned on a 4 bytes boundary.
 */
/*@{*/
#define BP_BCH_METAPTR_ADDR  (0U)          /*!< Bit position for BCH_METAPTR_ADDR. */
#define BM_BCH_METAPTR_ADDR  (0xFFFFFFFFU) /*!< Bit mask for BCH_METAPTR_ADDR. */
#define BS_BCH_METAPTR_ADDR  (32U)         /*!< Bit field size in bits for BCH_METAPTR_ADDR. */

/*! @brief Read current value of the BCH_METAPTR_ADDR field. */
#define BR_BCH_METAPTR_ADDR(x) (HW_BCH_METAPTR(x).U)

/*! @brief Format value for bitfield BCH_METAPTR_ADDR. */
#define BF_BCH_METAPTR_ADDR(v) ((uint32_t)((uint32_t)(v) << BP_BCH_METAPTR_ADDR) & BM_BCH_METAPTR_ADDR)

/*! @brief Set the ADDR field to a new value. */
#define BW_BCH_METAPTR_ADDR(x, v) (HW_BCH_METAPTR_WR(x, v))
/*@}*/




/*******************************************************************************
 * HW_BCH_LAYOUTSELECT - Hardware ECC Accelerator Layout Select Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_LAYOUTSELECT - Hardware ECC Accelerator Layout Select Register (RW)
 *
 * Reset value: 0xE4E4E4E4U
 *
 * The BCH LAYOUTSELECT register provides a mapping of chip selects to layout
 * registers. When the BCH engine receives a request to process a data block from
 * the GPMI interface, it will use this register to map the incoming chip select
 * to one of the four possible flash layout registers
 */
typedef union _hw_bch_layoutselect
{
    uint32_t U;
    struct _hw_bch_layoutselect_bitfields
    {
        uint32_t CS0_SELECT : 2;       /*!< [1:0]  */
        uint32_t CS1_SELECT : 2;       /*!< [3:2]  */
        uint32_t CS2_SELECT : 2;       /*!< [5:4]  */
        uint32_t CS3_SELECT : 2;       /*!< [7:6]  */
        uint32_t CS4_SELECT : 2;       /*!< [9:8]  */
        uint32_t CS5_SELECT : 2;       /*!< [11:10]  */
        uint32_t CS6_SELECT : 2;       /*!< [13:12]  */
        uint32_t CS7_SELECT : 2;       /*!< [15:14]  */
        uint32_t CS8_SELECT : 2;       /*!< [17:16]  */
        uint32_t CS9_SELECT : 2;       /*!< [19:18]  */
        uint32_t CS10_SELECT : 2;      /*!< [21:20]  */
        uint32_t CS11_SELECT : 2;      /*!< [23:22]  */
        uint32_t CS12_SELECT : 2;      /*!< [25:24]  */
        uint32_t CS13_SELECT : 2;      /*!< [27:26]  */
        uint32_t CS14_SELECT : 2;      /*!< [29:28]  */
        uint32_t CS15_SELECT : 2;      /*!< [31:30]  */
    } B;
} hw_bch_layoutselect_t;

/*!
 * @name Constants and macros for entire BCH_LAYOUTSELECT register
 */
/*@{*/
#define HW_BCH_LAYOUTSELECT_ADDR(x) ((uintptr_t)(x) + 0x70U)
#define HW_BCH_LAYOUTSELECT_SET_ADDR(x) (HW_BCH_LAYOUTSELECT_ADDR(x) + 0x4U)
#define HW_BCH_LAYOUTSELECT_CLR_ADDR(x) (HW_BCH_LAYOUTSELECT_ADDR(x) + 0x8U)
#define HW_BCH_LAYOUTSELECT_TOG_ADDR(x) (HW_BCH_LAYOUTSELECT_ADDR(x) + 0xCU)

#define HW_BCH_LAYOUTSELECT(x)   (*(__IO hw_bch_layoutselect_t *) HW_BCH_LAYOUTSELECT_ADDR(x))
#define HW_BCH_LAYOUTSELECT_RD(x) (HW_BCH_LAYOUTSELECT(x).U)
#define HW_BCH_LAYOUTSELECT_WR(x, v) (HW_BCH_LAYOUTSELECT(x).U = (v))
#define HW_BCH_LAYOUTSELECT_SET(x, v) ((*(uint32_t *) HW_BCH_LAYOUTSELECT_SET_ADDR(x)) = (v))
#define HW_BCH_LAYOUTSELECT_CLR(x, v) ((*(uint32_t *) HW_BCH_LAYOUTSELECT_CLR_ADDR(x)) = (v))
#define HW_BCH_LAYOUTSELECT_TOG(x, v) ((*(uint32_t *) HW_BCH_LAYOUTSELECT_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual BCH_LAYOUTSELECT bitfields
 */

/*!
 * @name Register BCH_LAYOUTSELECT, field CS0_SELECT[1:0] (RW)
 *
 * Selects which layout is used for chip select 0.
 */
/*@{*/
#define BP_BCH_LAYOUTSELECT_CS0_SELECT (0U) /*!< Bit position for BCH_LAYOUTSELECT_CS0_SELECT. */
#define BM_BCH_LAYOUTSELECT_CS0_SELECT (0x00000003U) /*!< Bit mask for BCH_LAYOUTSELECT_CS0_SELECT. */
#define BS_BCH_LAYOUTSELECT_CS0_SELECT (2U) /*!< Bit field size in bits for BCH_LAYOUTSELECT_CS0_SELECT. */

/*! @brief Read current value of the BCH_LAYOUTSELECT_CS0_SELECT field. */
#define BR_BCH_LAYOUTSELECT_CS0_SELECT(x) (HW_BCH_LAYOUTSELECT(x).B.CS0_SELECT)

/*! @brief Format value for bitfield BCH_LAYOUTSELECT_CS0_SELECT. */
#define BF_BCH_LAYOUTSELECT_CS0_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_BCH_LAYOUTSELECT_CS0_SELECT) & BM_BCH_LAYOUTSELECT_CS0_SELECT)

/*! @brief Set the CS0_SELECT field to a new value. */
#define BW_BCH_LAYOUTSELECT_CS0_SELECT(x, v) (HW_BCH_LAYOUTSELECT_WR(x, (HW_BCH_LAYOUTSELECT_RD(x) & ~BM_BCH_LAYOUTSELECT_CS0_SELECT) | BF_BCH_LAYOUTSELECT_CS0_SELECT(v)))
/*@}*/

/*!
 * @name Register BCH_LAYOUTSELECT, field CS1_SELECT[3:2] (RW)
 *
 * Selects which layout is used for chip select 1.
 */
/*@{*/
#define BP_BCH_LAYOUTSELECT_CS1_SELECT (2U) /*!< Bit position for BCH_LAYOUTSELECT_CS1_SELECT. */
#define BM_BCH_LAYOUTSELECT_CS1_SELECT (0x0000000CU) /*!< Bit mask for BCH_LAYOUTSELECT_CS1_SELECT. */
#define BS_BCH_LAYOUTSELECT_CS1_SELECT (2U) /*!< Bit field size in bits for BCH_LAYOUTSELECT_CS1_SELECT. */

/*! @brief Read current value of the BCH_LAYOUTSELECT_CS1_SELECT field. */
#define BR_BCH_LAYOUTSELECT_CS1_SELECT(x) (HW_BCH_LAYOUTSELECT(x).B.CS1_SELECT)

/*! @brief Format value for bitfield BCH_LAYOUTSELECT_CS1_SELECT. */
#define BF_BCH_LAYOUTSELECT_CS1_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_BCH_LAYOUTSELECT_CS1_SELECT) & BM_BCH_LAYOUTSELECT_CS1_SELECT)

/*! @brief Set the CS1_SELECT field to a new value. */
#define BW_BCH_LAYOUTSELECT_CS1_SELECT(x, v) (HW_BCH_LAYOUTSELECT_WR(x, (HW_BCH_LAYOUTSELECT_RD(x) & ~BM_BCH_LAYOUTSELECT_CS1_SELECT) | BF_BCH_LAYOUTSELECT_CS1_SELECT(v)))
/*@}*/

/*!
 * @name Register BCH_LAYOUTSELECT, field CS2_SELECT[5:4] (RW)
 *
 * Selects which layout is used for chip select 2.
 */
/*@{*/
#define BP_BCH_LAYOUTSELECT_CS2_SELECT (4U) /*!< Bit position for BCH_LAYOUTSELECT_CS2_SELECT. */
#define BM_BCH_LAYOUTSELECT_CS2_SELECT (0x00000030U) /*!< Bit mask for BCH_LAYOUTSELECT_CS2_SELECT. */
#define BS_BCH_LAYOUTSELECT_CS2_SELECT (2U) /*!< Bit field size in bits for BCH_LAYOUTSELECT_CS2_SELECT. */

/*! @brief Read current value of the BCH_LAYOUTSELECT_CS2_SELECT field. */
#define BR_BCH_LAYOUTSELECT_CS2_SELECT(x) (HW_BCH_LAYOUTSELECT(x).B.CS2_SELECT)

/*! @brief Format value for bitfield BCH_LAYOUTSELECT_CS2_SELECT. */
#define BF_BCH_LAYOUTSELECT_CS2_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_BCH_LAYOUTSELECT_CS2_SELECT) & BM_BCH_LAYOUTSELECT_CS2_SELECT)

/*! @brief Set the CS2_SELECT field to a new value. */
#define BW_BCH_LAYOUTSELECT_CS2_SELECT(x, v) (HW_BCH_LAYOUTSELECT_WR(x, (HW_BCH_LAYOUTSELECT_RD(x) & ~BM_BCH_LAYOUTSELECT_CS2_SELECT) | BF_BCH_LAYOUTSELECT_CS2_SELECT(v)))
/*@}*/

/*!
 * @name Register BCH_LAYOUTSELECT, field CS3_SELECT[7:6] (RW)
 *
 * Selects which layout is used for chip select 3.
 */
/*@{*/
#define BP_BCH_LAYOUTSELECT_CS3_SELECT (6U) /*!< Bit position for BCH_LAYOUTSELECT_CS3_SELECT. */
#define BM_BCH_LAYOUTSELECT_CS3_SELECT (0x000000C0U) /*!< Bit mask for BCH_LAYOUTSELECT_CS3_SELECT. */
#define BS_BCH_LAYOUTSELECT_CS3_SELECT (2U) /*!< Bit field size in bits for BCH_LAYOUTSELECT_CS3_SELECT. */

/*! @brief Read current value of the BCH_LAYOUTSELECT_CS3_SELECT field. */
#define BR_BCH_LAYOUTSELECT_CS3_SELECT(x) (HW_BCH_LAYOUTSELECT(x).B.CS3_SELECT)

/*! @brief Format value for bitfield BCH_LAYOUTSELECT_CS3_SELECT. */
#define BF_BCH_LAYOUTSELECT_CS3_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_BCH_LAYOUTSELECT_CS3_SELECT) & BM_BCH_LAYOUTSELECT_CS3_SELECT)

/*! @brief Set the CS3_SELECT field to a new value. */
#define BW_BCH_LAYOUTSELECT_CS3_SELECT(x, v) (HW_BCH_LAYOUTSELECT_WR(x, (HW_BCH_LAYOUTSELECT_RD(x) & ~BM_BCH_LAYOUTSELECT_CS3_SELECT) | BF_BCH_LAYOUTSELECT_CS3_SELECT(v)))
/*@}*/

/*!
 * @name Register BCH_LAYOUTSELECT, field CS4_SELECT[9:8] (RW)
 *
 * Selects which layout is used for chip select 4.
 */
/*@{*/
#define BP_BCH_LAYOUTSELECT_CS4_SELECT (8U) /*!< Bit position for BCH_LAYOUTSELECT_CS4_SELECT. */
#define BM_BCH_LAYOUTSELECT_CS4_SELECT (0x00000300U) /*!< Bit mask for BCH_LAYOUTSELECT_CS4_SELECT. */
#define BS_BCH_LAYOUTSELECT_CS4_SELECT (2U) /*!< Bit field size in bits for BCH_LAYOUTSELECT_CS4_SELECT. */

/*! @brief Read current value of the BCH_LAYOUTSELECT_CS4_SELECT field. */
#define BR_BCH_LAYOUTSELECT_CS4_SELECT(x) (HW_BCH_LAYOUTSELECT(x).B.CS4_SELECT)

/*! @brief Format value for bitfield BCH_LAYOUTSELECT_CS4_SELECT. */
#define BF_BCH_LAYOUTSELECT_CS4_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_BCH_LAYOUTSELECT_CS4_SELECT) & BM_BCH_LAYOUTSELECT_CS4_SELECT)

/*! @brief Set the CS4_SELECT field to a new value. */
#define BW_BCH_LAYOUTSELECT_CS4_SELECT(x, v) (HW_BCH_LAYOUTSELECT_WR(x, (HW_BCH_LAYOUTSELECT_RD(x) & ~BM_BCH_LAYOUTSELECT_CS4_SELECT) | BF_BCH_LAYOUTSELECT_CS4_SELECT(v)))
/*@}*/

/*!
 * @name Register BCH_LAYOUTSELECT, field CS5_SELECT[11:10] (RW)
 *
 * Selects which layout is used for chip select 5.
 */
/*@{*/
#define BP_BCH_LAYOUTSELECT_CS5_SELECT (10U) /*!< Bit position for BCH_LAYOUTSELECT_CS5_SELECT. */
#define BM_BCH_LAYOUTSELECT_CS5_SELECT (0x00000C00U) /*!< Bit mask for BCH_LAYOUTSELECT_CS5_SELECT. */
#define BS_BCH_LAYOUTSELECT_CS5_SELECT (2U) /*!< Bit field size in bits for BCH_LAYOUTSELECT_CS5_SELECT. */

/*! @brief Read current value of the BCH_LAYOUTSELECT_CS5_SELECT field. */
#define BR_BCH_LAYOUTSELECT_CS5_SELECT(x) (HW_BCH_LAYOUTSELECT(x).B.CS5_SELECT)

/*! @brief Format value for bitfield BCH_LAYOUTSELECT_CS5_SELECT. */
#define BF_BCH_LAYOUTSELECT_CS5_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_BCH_LAYOUTSELECT_CS5_SELECT) & BM_BCH_LAYOUTSELECT_CS5_SELECT)

/*! @brief Set the CS5_SELECT field to a new value. */
#define BW_BCH_LAYOUTSELECT_CS5_SELECT(x, v) (HW_BCH_LAYOUTSELECT_WR(x, (HW_BCH_LAYOUTSELECT_RD(x) & ~BM_BCH_LAYOUTSELECT_CS5_SELECT) | BF_BCH_LAYOUTSELECT_CS5_SELECT(v)))
/*@}*/

/*!
 * @name Register BCH_LAYOUTSELECT, field CS6_SELECT[13:12] (RW)
 *
 * Selects which layout is used for chip select 6.
 */
/*@{*/
#define BP_BCH_LAYOUTSELECT_CS6_SELECT (12U) /*!< Bit position for BCH_LAYOUTSELECT_CS6_SELECT. */
#define BM_BCH_LAYOUTSELECT_CS6_SELECT (0x00003000U) /*!< Bit mask for BCH_LAYOUTSELECT_CS6_SELECT. */
#define BS_BCH_LAYOUTSELECT_CS6_SELECT (2U) /*!< Bit field size in bits for BCH_LAYOUTSELECT_CS6_SELECT. */

/*! @brief Read current value of the BCH_LAYOUTSELECT_CS6_SELECT field. */
#define BR_BCH_LAYOUTSELECT_CS6_SELECT(x) (HW_BCH_LAYOUTSELECT(x).B.CS6_SELECT)

/*! @brief Format value for bitfield BCH_LAYOUTSELECT_CS6_SELECT. */
#define BF_BCH_LAYOUTSELECT_CS6_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_BCH_LAYOUTSELECT_CS6_SELECT) & BM_BCH_LAYOUTSELECT_CS6_SELECT)

/*! @brief Set the CS6_SELECT field to a new value. */
#define BW_BCH_LAYOUTSELECT_CS6_SELECT(x, v) (HW_BCH_LAYOUTSELECT_WR(x, (HW_BCH_LAYOUTSELECT_RD(x) & ~BM_BCH_LAYOUTSELECT_CS6_SELECT) | BF_BCH_LAYOUTSELECT_CS6_SELECT(v)))
/*@}*/

/*!
 * @name Register BCH_LAYOUTSELECT, field CS7_SELECT[15:14] (RW)
 *
 * Selects which layout is used for chip select 7.
 */
/*@{*/
#define BP_BCH_LAYOUTSELECT_CS7_SELECT (14U) /*!< Bit position for BCH_LAYOUTSELECT_CS7_SELECT. */
#define BM_BCH_LAYOUTSELECT_CS7_SELECT (0x0000C000U) /*!< Bit mask for BCH_LAYOUTSELECT_CS7_SELECT. */
#define BS_BCH_LAYOUTSELECT_CS7_SELECT (2U) /*!< Bit field size in bits for BCH_LAYOUTSELECT_CS7_SELECT. */

/*! @brief Read current value of the BCH_LAYOUTSELECT_CS7_SELECT field. */
#define BR_BCH_LAYOUTSELECT_CS7_SELECT(x) (HW_BCH_LAYOUTSELECT(x).B.CS7_SELECT)

/*! @brief Format value for bitfield BCH_LAYOUTSELECT_CS7_SELECT. */
#define BF_BCH_LAYOUTSELECT_CS7_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_BCH_LAYOUTSELECT_CS7_SELECT) & BM_BCH_LAYOUTSELECT_CS7_SELECT)

/*! @brief Set the CS7_SELECT field to a new value. */
#define BW_BCH_LAYOUTSELECT_CS7_SELECT(x, v) (HW_BCH_LAYOUTSELECT_WR(x, (HW_BCH_LAYOUTSELECT_RD(x) & ~BM_BCH_LAYOUTSELECT_CS7_SELECT) | BF_BCH_LAYOUTSELECT_CS7_SELECT(v)))
/*@}*/

/*!
 * @name Register BCH_LAYOUTSELECT, field CS8_SELECT[17:16] (RW)
 *
 * Selects which layout is used for chip select 8.
 */
/*@{*/
#define BP_BCH_LAYOUTSELECT_CS8_SELECT (16U) /*!< Bit position for BCH_LAYOUTSELECT_CS8_SELECT. */
#define BM_BCH_LAYOUTSELECT_CS8_SELECT (0x00030000U) /*!< Bit mask for BCH_LAYOUTSELECT_CS8_SELECT. */
#define BS_BCH_LAYOUTSELECT_CS8_SELECT (2U) /*!< Bit field size in bits for BCH_LAYOUTSELECT_CS8_SELECT. */

/*! @brief Read current value of the BCH_LAYOUTSELECT_CS8_SELECT field. */
#define BR_BCH_LAYOUTSELECT_CS8_SELECT(x) (HW_BCH_LAYOUTSELECT(x).B.CS8_SELECT)

/*! @brief Format value for bitfield BCH_LAYOUTSELECT_CS8_SELECT. */
#define BF_BCH_LAYOUTSELECT_CS8_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_BCH_LAYOUTSELECT_CS8_SELECT) & BM_BCH_LAYOUTSELECT_CS8_SELECT)

/*! @brief Set the CS8_SELECT field to a new value. */
#define BW_BCH_LAYOUTSELECT_CS8_SELECT(x, v) (HW_BCH_LAYOUTSELECT_WR(x, (HW_BCH_LAYOUTSELECT_RD(x) & ~BM_BCH_LAYOUTSELECT_CS8_SELECT) | BF_BCH_LAYOUTSELECT_CS8_SELECT(v)))
/*@}*/

/*!
 * @name Register BCH_LAYOUTSELECT, field CS9_SELECT[19:18] (RW)
 *
 * Selects which layout is used for chip select 9.
 */
/*@{*/
#define BP_BCH_LAYOUTSELECT_CS9_SELECT (18U) /*!< Bit position for BCH_LAYOUTSELECT_CS9_SELECT. */
#define BM_BCH_LAYOUTSELECT_CS9_SELECT (0x000C0000U) /*!< Bit mask for BCH_LAYOUTSELECT_CS9_SELECT. */
#define BS_BCH_LAYOUTSELECT_CS9_SELECT (2U) /*!< Bit field size in bits for BCH_LAYOUTSELECT_CS9_SELECT. */

/*! @brief Read current value of the BCH_LAYOUTSELECT_CS9_SELECT field. */
#define BR_BCH_LAYOUTSELECT_CS9_SELECT(x) (HW_BCH_LAYOUTSELECT(x).B.CS9_SELECT)

/*! @brief Format value for bitfield BCH_LAYOUTSELECT_CS9_SELECT. */
#define BF_BCH_LAYOUTSELECT_CS9_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_BCH_LAYOUTSELECT_CS9_SELECT) & BM_BCH_LAYOUTSELECT_CS9_SELECT)

/*! @brief Set the CS9_SELECT field to a new value. */
#define BW_BCH_LAYOUTSELECT_CS9_SELECT(x, v) (HW_BCH_LAYOUTSELECT_WR(x, (HW_BCH_LAYOUTSELECT_RD(x) & ~BM_BCH_LAYOUTSELECT_CS9_SELECT) | BF_BCH_LAYOUTSELECT_CS9_SELECT(v)))
/*@}*/

/*!
 * @name Register BCH_LAYOUTSELECT, field CS10_SELECT[21:20] (RW)
 *
 * Selects which layout is used for chip select 10.
 */
/*@{*/
#define BP_BCH_LAYOUTSELECT_CS10_SELECT (20U) /*!< Bit position for BCH_LAYOUTSELECT_CS10_SELECT. */
#define BM_BCH_LAYOUTSELECT_CS10_SELECT (0x00300000U) /*!< Bit mask for BCH_LAYOUTSELECT_CS10_SELECT. */
#define BS_BCH_LAYOUTSELECT_CS10_SELECT (2U) /*!< Bit field size in bits for BCH_LAYOUTSELECT_CS10_SELECT. */

/*! @brief Read current value of the BCH_LAYOUTSELECT_CS10_SELECT field. */
#define BR_BCH_LAYOUTSELECT_CS10_SELECT(x) (HW_BCH_LAYOUTSELECT(x).B.CS10_SELECT)

/*! @brief Format value for bitfield BCH_LAYOUTSELECT_CS10_SELECT. */
#define BF_BCH_LAYOUTSELECT_CS10_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_BCH_LAYOUTSELECT_CS10_SELECT) & BM_BCH_LAYOUTSELECT_CS10_SELECT)

/*! @brief Set the CS10_SELECT field to a new value. */
#define BW_BCH_LAYOUTSELECT_CS10_SELECT(x, v) (HW_BCH_LAYOUTSELECT_WR(x, (HW_BCH_LAYOUTSELECT_RD(x) & ~BM_BCH_LAYOUTSELECT_CS10_SELECT) | BF_BCH_LAYOUTSELECT_CS10_SELECT(v)))
/*@}*/

/*!
 * @name Register BCH_LAYOUTSELECT, field CS11_SELECT[23:22] (RW)
 *
 * Selects which layout is used for chip select 11.
 */
/*@{*/
#define BP_BCH_LAYOUTSELECT_CS11_SELECT (22U) /*!< Bit position for BCH_LAYOUTSELECT_CS11_SELECT. */
#define BM_BCH_LAYOUTSELECT_CS11_SELECT (0x00C00000U) /*!< Bit mask for BCH_LAYOUTSELECT_CS11_SELECT. */
#define BS_BCH_LAYOUTSELECT_CS11_SELECT (2U) /*!< Bit field size in bits for BCH_LAYOUTSELECT_CS11_SELECT. */

/*! @brief Read current value of the BCH_LAYOUTSELECT_CS11_SELECT field. */
#define BR_BCH_LAYOUTSELECT_CS11_SELECT(x) (HW_BCH_LAYOUTSELECT(x).B.CS11_SELECT)

/*! @brief Format value for bitfield BCH_LAYOUTSELECT_CS11_SELECT. */
#define BF_BCH_LAYOUTSELECT_CS11_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_BCH_LAYOUTSELECT_CS11_SELECT) & BM_BCH_LAYOUTSELECT_CS11_SELECT)

/*! @brief Set the CS11_SELECT field to a new value. */
#define BW_BCH_LAYOUTSELECT_CS11_SELECT(x, v) (HW_BCH_LAYOUTSELECT_WR(x, (HW_BCH_LAYOUTSELECT_RD(x) & ~BM_BCH_LAYOUTSELECT_CS11_SELECT) | BF_BCH_LAYOUTSELECT_CS11_SELECT(v)))
/*@}*/

/*!
 * @name Register BCH_LAYOUTSELECT, field CS12_SELECT[25:24] (RW)
 *
 * Selects which layout is used for chip select 12.
 */
/*@{*/
#define BP_BCH_LAYOUTSELECT_CS12_SELECT (24U) /*!< Bit position for BCH_LAYOUTSELECT_CS12_SELECT. */
#define BM_BCH_LAYOUTSELECT_CS12_SELECT (0x03000000U) /*!< Bit mask for BCH_LAYOUTSELECT_CS12_SELECT. */
#define BS_BCH_LAYOUTSELECT_CS12_SELECT (2U) /*!< Bit field size in bits for BCH_LAYOUTSELECT_CS12_SELECT. */

/*! @brief Read current value of the BCH_LAYOUTSELECT_CS12_SELECT field. */
#define BR_BCH_LAYOUTSELECT_CS12_SELECT(x) (HW_BCH_LAYOUTSELECT(x).B.CS12_SELECT)

/*! @brief Format value for bitfield BCH_LAYOUTSELECT_CS12_SELECT. */
#define BF_BCH_LAYOUTSELECT_CS12_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_BCH_LAYOUTSELECT_CS12_SELECT) & BM_BCH_LAYOUTSELECT_CS12_SELECT)

/*! @brief Set the CS12_SELECT field to a new value. */
#define BW_BCH_LAYOUTSELECT_CS12_SELECT(x, v) (HW_BCH_LAYOUTSELECT_WR(x, (HW_BCH_LAYOUTSELECT_RD(x) & ~BM_BCH_LAYOUTSELECT_CS12_SELECT) | BF_BCH_LAYOUTSELECT_CS12_SELECT(v)))
/*@}*/

/*!
 * @name Register BCH_LAYOUTSELECT, field CS13_SELECT[27:26] (RW)
 *
 * Selects which layout is used for chip select 13.
 */
/*@{*/
#define BP_BCH_LAYOUTSELECT_CS13_SELECT (26U) /*!< Bit position for BCH_LAYOUTSELECT_CS13_SELECT. */
#define BM_BCH_LAYOUTSELECT_CS13_SELECT (0x0C000000U) /*!< Bit mask for BCH_LAYOUTSELECT_CS13_SELECT. */
#define BS_BCH_LAYOUTSELECT_CS13_SELECT (2U) /*!< Bit field size in bits for BCH_LAYOUTSELECT_CS13_SELECT. */

/*! @brief Read current value of the BCH_LAYOUTSELECT_CS13_SELECT field. */
#define BR_BCH_LAYOUTSELECT_CS13_SELECT(x) (HW_BCH_LAYOUTSELECT(x).B.CS13_SELECT)

/*! @brief Format value for bitfield BCH_LAYOUTSELECT_CS13_SELECT. */
#define BF_BCH_LAYOUTSELECT_CS13_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_BCH_LAYOUTSELECT_CS13_SELECT) & BM_BCH_LAYOUTSELECT_CS13_SELECT)

/*! @brief Set the CS13_SELECT field to a new value. */
#define BW_BCH_LAYOUTSELECT_CS13_SELECT(x, v) (HW_BCH_LAYOUTSELECT_WR(x, (HW_BCH_LAYOUTSELECT_RD(x) & ~BM_BCH_LAYOUTSELECT_CS13_SELECT) | BF_BCH_LAYOUTSELECT_CS13_SELECT(v)))
/*@}*/

/*!
 * @name Register BCH_LAYOUTSELECT, field CS14_SELECT[29:28] (RW)
 *
 * Selects which layout is used for chip select 14.
 */
/*@{*/
#define BP_BCH_LAYOUTSELECT_CS14_SELECT (28U) /*!< Bit position for BCH_LAYOUTSELECT_CS14_SELECT. */
#define BM_BCH_LAYOUTSELECT_CS14_SELECT (0x30000000U) /*!< Bit mask for BCH_LAYOUTSELECT_CS14_SELECT. */
#define BS_BCH_LAYOUTSELECT_CS14_SELECT (2U) /*!< Bit field size in bits for BCH_LAYOUTSELECT_CS14_SELECT. */

/*! @brief Read current value of the BCH_LAYOUTSELECT_CS14_SELECT field. */
#define BR_BCH_LAYOUTSELECT_CS14_SELECT(x) (HW_BCH_LAYOUTSELECT(x).B.CS14_SELECT)

/*! @brief Format value for bitfield BCH_LAYOUTSELECT_CS14_SELECT. */
#define BF_BCH_LAYOUTSELECT_CS14_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_BCH_LAYOUTSELECT_CS14_SELECT) & BM_BCH_LAYOUTSELECT_CS14_SELECT)

/*! @brief Set the CS14_SELECT field to a new value. */
#define BW_BCH_LAYOUTSELECT_CS14_SELECT(x, v) (HW_BCH_LAYOUTSELECT_WR(x, (HW_BCH_LAYOUTSELECT_RD(x) & ~BM_BCH_LAYOUTSELECT_CS14_SELECT) | BF_BCH_LAYOUTSELECT_CS14_SELECT(v)))
/*@}*/

/*!
 * @name Register BCH_LAYOUTSELECT, field CS15_SELECT[31:30] (RW)
 *
 * Selects which layout is used for chip select 15.
 */
/*@{*/
#define BP_BCH_LAYOUTSELECT_CS15_SELECT (30U) /*!< Bit position for BCH_LAYOUTSELECT_CS15_SELECT. */
#define BM_BCH_LAYOUTSELECT_CS15_SELECT (0xC0000000U) /*!< Bit mask for BCH_LAYOUTSELECT_CS15_SELECT. */
#define BS_BCH_LAYOUTSELECT_CS15_SELECT (2U) /*!< Bit field size in bits for BCH_LAYOUTSELECT_CS15_SELECT. */

/*! @brief Read current value of the BCH_LAYOUTSELECT_CS15_SELECT field. */
#define BR_BCH_LAYOUTSELECT_CS15_SELECT(x) (HW_BCH_LAYOUTSELECT(x).B.CS15_SELECT)

/*! @brief Format value for bitfield BCH_LAYOUTSELECT_CS15_SELECT. */
#define BF_BCH_LAYOUTSELECT_CS15_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_BCH_LAYOUTSELECT_CS15_SELECT) & BM_BCH_LAYOUTSELECT_CS15_SELECT)

/*! @brief Set the CS15_SELECT field to a new value. */
#define BW_BCH_LAYOUTSELECT_CS15_SELECT(x, v) (HW_BCH_LAYOUTSELECT_WR(x, (HW_BCH_LAYOUTSELECT_RD(x) & ~BM_BCH_LAYOUTSELECT_CS15_SELECT) | BF_BCH_LAYOUTSELECT_CS15_SELECT(v)))
/*@}*/




/*******************************************************************************
 * HW_BCH_FLASH0LAYOUT0 - Hardware BCH ECC Flash 0 Layout 0 Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_FLASH0LAYOUT0 - Hardware BCH ECC Flash 0 Layout 0 Register (RW)
 *
 * Reset value: 0x070A4080U
 *
 * The flash format register contains a description of the logical layout of
 * data on the flash device. This register is used in conjunction with the
 * FLASH0LAYOUT1 register to control the format for the devices selecting layout 0 in the
 * LAYOUTSELECT register. Each pair of layout registers describes one of four
 * supported flash configurations. Software should program the LAYOUTSELECT register
 * for each supported GPMI chip select to select from one of the four layout
 * values. Each pair of registers contains settings that are used by the BCH block
 * while reading / writing the flash page to control data, metadata, and flash
 * page sizes as well as the ECC correction level. The first block written to flash
 * can be programmed to have different ECC, metadata, and data sizes from
 * subsequent data blocks on the device. In addition, the number of blocks stored on a
 * page of flash is not fixed, but instead is determined by the number of bytes
 * consumed by the initial (block 0) and subsequent data blocks. See the BCH
 * programming reference manual for more information on setting up the flash layout
 * registers.
 */
typedef union _hw_bch_flash0layout0
{
    uint32_t U;
    struct _hw_bch_flash0layout0_bitfields
    {
        uint32_t DATA0_SIZE : 10;      /*!< [9:0]  */
        uint32_t GF13_0_GF14_1 : 1;    /*!< [10]  */
        uint32_t ECC0 : 5;             /*!< [15:11]  */
        uint32_t META_SIZE : 8;        /*!< [23:16]  */
        uint32_t NBLOCKS : 8;          /*!< [31:24]  */
    } B;
} hw_bch_flash0layout0_t;

/*!
 * @name Constants and macros for entire BCH_FLASH0LAYOUT0 register
 */
/*@{*/
#define HW_BCH_FLASH0LAYOUT0_ADDR(x) ((uintptr_t)(x) + 0x80U)
#define HW_BCH_FLASH0LAYOUT0_SET_ADDR(x) (HW_BCH_FLASH0LAYOUT0_ADDR(x) + 0x4U)
#define HW_BCH_FLASH0LAYOUT0_CLR_ADDR(x) (HW_BCH_FLASH0LAYOUT0_ADDR(x) + 0x8U)
#define HW_BCH_FLASH0LAYOUT0_TOG_ADDR(x) (HW_BCH_FLASH0LAYOUT0_ADDR(x) + 0xCU)

#define HW_BCH_FLASH0LAYOUT0(x)  (*(__IO hw_bch_flash0layout0_t *) HW_BCH_FLASH0LAYOUT0_ADDR(x))
#define HW_BCH_FLASH0LAYOUT0_RD(x) (HW_BCH_FLASH0LAYOUT0(x).U)
#define HW_BCH_FLASH0LAYOUT0_WR(x, v) (HW_BCH_FLASH0LAYOUT0(x).U = (v))
#define HW_BCH_FLASH0LAYOUT0_SET(x, v) ((*(uint32_t *) HW_BCH_FLASH0LAYOUT0_SET_ADDR(x)) = (v))
#define HW_BCH_FLASH0LAYOUT0_CLR(x, v) ((*(uint32_t *) HW_BCH_FLASH0LAYOUT0_CLR_ADDR(x)) = (v))
#define HW_BCH_FLASH0LAYOUT0_TOG(x, v) ((*(uint32_t *) HW_BCH_FLASH0LAYOUT0_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual BCH_FLASH0LAYOUT0 bitfields
 */

/*!
 * @name Register BCH_FLASH0LAYOUT0, field DATA0_SIZE[9:0] (RW)
 *
 * Indicates the size of the data 0 block (in DWORDS / four bytes) to be stored
 * on the flash page. If set to 0, the first block only contains metadata.
 */
/*@{*/
#define BP_BCH_FLASH0LAYOUT0_DATA0_SIZE (0U) /*!< Bit position for BCH_FLASH0LAYOUT0_DATA0_SIZE. */
#define BM_BCH_FLASH0LAYOUT0_DATA0_SIZE (0x000003FFU) /*!< Bit mask for BCH_FLASH0LAYOUT0_DATA0_SIZE. */
#define BS_BCH_FLASH0LAYOUT0_DATA0_SIZE (10U) /*!< Bit field size in bits for BCH_FLASH0LAYOUT0_DATA0_SIZE. */

/*! @brief Read current value of the BCH_FLASH0LAYOUT0_DATA0_SIZE field. */
#define BR_BCH_FLASH0LAYOUT0_DATA0_SIZE(x) (HW_BCH_FLASH0LAYOUT0(x).B.DATA0_SIZE)

/*! @brief Format value for bitfield BCH_FLASH0LAYOUT0_DATA0_SIZE. */
#define BF_BCH_FLASH0LAYOUT0_DATA0_SIZE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH0LAYOUT0_DATA0_SIZE) & BM_BCH_FLASH0LAYOUT0_DATA0_SIZE)

/*! @brief Set the DATA0_SIZE field to a new value. */
#define BW_BCH_FLASH0LAYOUT0_DATA0_SIZE(x, v) (HW_BCH_FLASH0LAYOUT0_WR(x, (HW_BCH_FLASH0LAYOUT0_RD(x) & ~BM_BCH_FLASH0LAYOUT0_DATA0_SIZE) | BF_BCH_FLASH0LAYOUT0_DATA0_SIZE(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH0LAYOUT0, field GF13_0_GF14_1[10] (RW)
 *
 * Select GF13 or GF14: 0-GF13; 1-GF14
 */
/*@{*/
#define BP_BCH_FLASH0LAYOUT0_GF13_0_GF14_1 (10U) /*!< Bit position for BCH_FLASH0LAYOUT0_GF13_0_GF14_1. */
#define BM_BCH_FLASH0LAYOUT0_GF13_0_GF14_1 (0x00000400U) /*!< Bit mask for BCH_FLASH0LAYOUT0_GF13_0_GF14_1. */
#define BS_BCH_FLASH0LAYOUT0_GF13_0_GF14_1 (1U) /*!< Bit field size in bits for BCH_FLASH0LAYOUT0_GF13_0_GF14_1. */

/*! @brief Read current value of the BCH_FLASH0LAYOUT0_GF13_0_GF14_1 field. */
#define BR_BCH_FLASH0LAYOUT0_GF13_0_GF14_1(x) (HW_BCH_FLASH0LAYOUT0(x).B.GF13_0_GF14_1)

/*! @brief Format value for bitfield BCH_FLASH0LAYOUT0_GF13_0_GF14_1. */
#define BF_BCH_FLASH0LAYOUT0_GF13_0_GF14_1(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH0LAYOUT0_GF13_0_GF14_1) & BM_BCH_FLASH0LAYOUT0_GF13_0_GF14_1)

/*! @brief Set the GF13_0_GF14_1 field to a new value. */
#define BW_BCH_FLASH0LAYOUT0_GF13_0_GF14_1(x, v) (HW_BCH_FLASH0LAYOUT0_WR(x, (HW_BCH_FLASH0LAYOUT0_RD(x) & ~BM_BCH_FLASH0LAYOUT0_GF13_0_GF14_1) | BF_BCH_FLASH0LAYOUT0_GF13_0_GF14_1(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH0LAYOUT0, field ECC0[15:11] (RW)
 *
 * Indicates the ECC level for the first block on the flash page. The first
 * block covers metadata plus the associated data from the DATA0_SIZE field.
 *
 * Values:
 * - 0 - No ECC to be performed
 * - 1 - ECC 2 to be performed
 * - 10 - ECC 4 to be performed
 * - 11110 - ECC 60 to be performed
 * - 11111 - ECC 62 to be performed
 */
/*@{*/
#define BP_BCH_FLASH0LAYOUT0_ECC0 (11U)    /*!< Bit position for BCH_FLASH0LAYOUT0_ECC0. */
#define BM_BCH_FLASH0LAYOUT0_ECC0 (0x0000F800U) /*!< Bit mask for BCH_FLASH0LAYOUT0_ECC0. */
#define BS_BCH_FLASH0LAYOUT0_ECC0 (5U)     /*!< Bit field size in bits for BCH_FLASH0LAYOUT0_ECC0. */

#define BV_BCH_FLASH0LAYOUT0_ECC0_NONE (0U)          /*!< Bit field value for BCH_FLASH0LAYOUT0_ECC0: No ECC to be performed */
#define BV_BCH_FLASH0LAYOUT0_ECC0_ECC2 (0x1U)        /*!< Bit field value for BCH_FLASH0LAYOUT0_ECC0: ECC 2 to be performed */
#define BV_BCH_FLASH0LAYOUT0_ECC0_ECC4 (0x2U)        /*!< Bit field value for BCH_FLASH0LAYOUT0_ECC0: ECC 4 to be performed */
#define BV_BCH_FLASH0LAYOUT0_ECC0_ECC60 (0x1EU)      /*!< Bit field value for BCH_FLASH0LAYOUT0_ECC0: ECC 60 to be performed */
#define BV_BCH_FLASH0LAYOUT0_ECC0_ECC62 (0x1FU)      /*!< Bit field value for BCH_FLASH0LAYOUT0_ECC0: ECC 62 to be performed */

/*! @brief Read current value of the BCH_FLASH0LAYOUT0_ECC0 field. */
#define BR_BCH_FLASH0LAYOUT0_ECC0(x) (HW_BCH_FLASH0LAYOUT0(x).B.ECC0)

/*! @brief Format value for bitfield BCH_FLASH0LAYOUT0_ECC0. */
#define BF_BCH_FLASH0LAYOUT0_ECC0(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH0LAYOUT0_ECC0) & BM_BCH_FLASH0LAYOUT0_ECC0)

/*! @brief Set the ECC0 field to a new value. */
#define BW_BCH_FLASH0LAYOUT0_ECC0(x, v) (HW_BCH_FLASH0LAYOUT0_WR(x, (HW_BCH_FLASH0LAYOUT0_RD(x) & ~BM_BCH_FLASH0LAYOUT0_ECC0) | BF_BCH_FLASH0LAYOUT0_ECC0(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH0LAYOUT0, field META_SIZE[23:16] (RW)
 *
 * Indicates the size of the metadata (in bytes) to be stored on a flash page.
 * The BCH design support from 0 to 255 bytes for metadata-if set to 0, no
 * metadata will be stored. Metadata is stored before the associated data in block 0. If
 * the DATA0_SIZE field is programmed to a 0, then metadata effectively be
 * stored with its own parity. When both the metadata and data0 fields are programmed
 * with non-zero values, the first block will contain both portions of data and
 * covered by a single parity block.
 */
/*@{*/
#define BP_BCH_FLASH0LAYOUT0_META_SIZE (16U) /*!< Bit position for BCH_FLASH0LAYOUT0_META_SIZE. */
#define BM_BCH_FLASH0LAYOUT0_META_SIZE (0x00FF0000U) /*!< Bit mask for BCH_FLASH0LAYOUT0_META_SIZE. */
#define BS_BCH_FLASH0LAYOUT0_META_SIZE (8U) /*!< Bit field size in bits for BCH_FLASH0LAYOUT0_META_SIZE. */

/*! @brief Read current value of the BCH_FLASH0LAYOUT0_META_SIZE field. */
#define BR_BCH_FLASH0LAYOUT0_META_SIZE(x) (HW_BCH_FLASH0LAYOUT0(x).B.META_SIZE)

/*! @brief Format value for bitfield BCH_FLASH0LAYOUT0_META_SIZE. */
#define BF_BCH_FLASH0LAYOUT0_META_SIZE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH0LAYOUT0_META_SIZE) & BM_BCH_FLASH0LAYOUT0_META_SIZE)

/*! @brief Set the META_SIZE field to a new value. */
#define BW_BCH_FLASH0LAYOUT0_META_SIZE(x, v) (HW_BCH_FLASH0LAYOUT0_WR(x, (HW_BCH_FLASH0LAYOUT0_RD(x) & ~BM_BCH_FLASH0LAYOUT0_META_SIZE) | BF_BCH_FLASH0LAYOUT0_META_SIZE(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH0LAYOUT0, field NBLOCKS[31:24] (RW)
 *
 * Number of subsequent blocks on the flash page (excluding the data0 block). A
 * value of 0 indicates that only the DATA0 block is present and a value of 8
 * indicates that 8 subsequent blocks are present for a total of 9 blocks on the
 * flash (including the DATA0 block). Any values from 0 to 255 are supported by the
 * hardware.
 */
/*@{*/
#define BP_BCH_FLASH0LAYOUT0_NBLOCKS (24U) /*!< Bit position for BCH_FLASH0LAYOUT0_NBLOCKS. */
#define BM_BCH_FLASH0LAYOUT0_NBLOCKS (0xFF000000U) /*!< Bit mask for BCH_FLASH0LAYOUT0_NBLOCKS. */
#define BS_BCH_FLASH0LAYOUT0_NBLOCKS (8U)  /*!< Bit field size in bits for BCH_FLASH0LAYOUT0_NBLOCKS. */

/*! @brief Read current value of the BCH_FLASH0LAYOUT0_NBLOCKS field. */
#define BR_BCH_FLASH0LAYOUT0_NBLOCKS(x) (HW_BCH_FLASH0LAYOUT0(x).B.NBLOCKS)

/*! @brief Format value for bitfield BCH_FLASH0LAYOUT0_NBLOCKS. */
#define BF_BCH_FLASH0LAYOUT0_NBLOCKS(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH0LAYOUT0_NBLOCKS) & BM_BCH_FLASH0LAYOUT0_NBLOCKS)

/*! @brief Set the NBLOCKS field to a new value. */
#define BW_BCH_FLASH0LAYOUT0_NBLOCKS(x, v) (HW_BCH_FLASH0LAYOUT0_WR(x, (HW_BCH_FLASH0LAYOUT0_RD(x) & ~BM_BCH_FLASH0LAYOUT0_NBLOCKS) | BF_BCH_FLASH0LAYOUT0_NBLOCKS(v)))
/*@}*/




/*******************************************************************************
 * HW_BCH_FLASH0LAYOUT1 - Hardware BCH ECC Flash 0 Layout 1 Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_FLASH0LAYOUT1 - Hardware BCH ECC Flash 0 Layout 1 Register (RW)
 *
 * Reset value: 0x10DA4080U
 *
 * The flash format register contains a description of the logical layout of
 * data on the flash device. This register is used in conjunction with the
 * FLASH0LAYOUT0 register to control the format for the device selecting layout 0 in the
 * LAYOUTSELECT register.
 */
typedef union _hw_bch_flash0layout1
{
    uint32_t U;
    struct _hw_bch_flash0layout1_bitfields
    {
        uint32_t DATAN_SIZE : 10;      /*!< [9:0]  */
        uint32_t GF13_0_GF14_1 : 1;    /*!< [10]  */
        uint32_t ECCN : 5;             /*!< [15:11]  */
        uint32_t PAGE_SIZE : 16;       /*!< [31:16]  */
    } B;
} hw_bch_flash0layout1_t;

/*!
 * @name Constants and macros for entire BCH_FLASH0LAYOUT1 register
 */
/*@{*/
#define HW_BCH_FLASH0LAYOUT1_ADDR(x) ((uintptr_t)(x) + 0x90U)
#define HW_BCH_FLASH0LAYOUT1_SET_ADDR(x) (HW_BCH_FLASH0LAYOUT1_ADDR(x) + 0x4U)
#define HW_BCH_FLASH0LAYOUT1_CLR_ADDR(x) (HW_BCH_FLASH0LAYOUT1_ADDR(x) + 0x8U)
#define HW_BCH_FLASH0LAYOUT1_TOG_ADDR(x) (HW_BCH_FLASH0LAYOUT1_ADDR(x) + 0xCU)

#define HW_BCH_FLASH0LAYOUT1(x)  (*(__IO hw_bch_flash0layout1_t *) HW_BCH_FLASH0LAYOUT1_ADDR(x))
#define HW_BCH_FLASH0LAYOUT1_RD(x) (HW_BCH_FLASH0LAYOUT1(x).U)
#define HW_BCH_FLASH0LAYOUT1_WR(x, v) (HW_BCH_FLASH0LAYOUT1(x).U = (v))
#define HW_BCH_FLASH0LAYOUT1_SET(x, v) ((*(uint32_t *) HW_BCH_FLASH0LAYOUT1_SET_ADDR(x)) = (v))
#define HW_BCH_FLASH0LAYOUT1_CLR(x, v) ((*(uint32_t *) HW_BCH_FLASH0LAYOUT1_CLR_ADDR(x)) = (v))
#define HW_BCH_FLASH0LAYOUT1_TOG(x, v) ((*(uint32_t *) HW_BCH_FLASH0LAYOUT1_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual BCH_FLASH0LAYOUT1 bitfields
 */

/*!
 * @name Register BCH_FLASH0LAYOUT1, field DATAN_SIZE[9:0] (RW)
 *
 * Indicates the size of the subsequent data blocks (in DWORDS / four bytes) to
 * be stored on the flash page. The size of subsequent data blocks does not have
 * to match the data size for block 0, which is important when metadata is stored
 * separately or for balancing the amount of data stored in each block.
 */
/*@{*/
#define BP_BCH_FLASH0LAYOUT1_DATAN_SIZE (0U) /*!< Bit position for BCH_FLASH0LAYOUT1_DATAN_SIZE. */
#define BM_BCH_FLASH0LAYOUT1_DATAN_SIZE (0x000003FFU) /*!< Bit mask for BCH_FLASH0LAYOUT1_DATAN_SIZE. */
#define BS_BCH_FLASH0LAYOUT1_DATAN_SIZE (10U) /*!< Bit field size in bits for BCH_FLASH0LAYOUT1_DATAN_SIZE. */

/*! @brief Read current value of the BCH_FLASH0LAYOUT1_DATAN_SIZE field. */
#define BR_BCH_FLASH0LAYOUT1_DATAN_SIZE(x) (HW_BCH_FLASH0LAYOUT1(x).B.DATAN_SIZE)

/*! @brief Format value for bitfield BCH_FLASH0LAYOUT1_DATAN_SIZE. */
#define BF_BCH_FLASH0LAYOUT1_DATAN_SIZE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH0LAYOUT1_DATAN_SIZE) & BM_BCH_FLASH0LAYOUT1_DATAN_SIZE)

/*! @brief Set the DATAN_SIZE field to a new value. */
#define BW_BCH_FLASH0LAYOUT1_DATAN_SIZE(x, v) (HW_BCH_FLASH0LAYOUT1_WR(x, (HW_BCH_FLASH0LAYOUT1_RD(x) & ~BM_BCH_FLASH0LAYOUT1_DATAN_SIZE) | BF_BCH_FLASH0LAYOUT1_DATAN_SIZE(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH0LAYOUT1, field GF13_0_GF14_1[10] (RW)
 *
 * Select GF13 or GF14: 0-GF13; 1-GF14
 */
/*@{*/
#define BP_BCH_FLASH0LAYOUT1_GF13_0_GF14_1 (10U) /*!< Bit position for BCH_FLASH0LAYOUT1_GF13_0_GF14_1. */
#define BM_BCH_FLASH0LAYOUT1_GF13_0_GF14_1 (0x00000400U) /*!< Bit mask for BCH_FLASH0LAYOUT1_GF13_0_GF14_1. */
#define BS_BCH_FLASH0LAYOUT1_GF13_0_GF14_1 (1U) /*!< Bit field size in bits for BCH_FLASH0LAYOUT1_GF13_0_GF14_1. */

/*! @brief Read current value of the BCH_FLASH0LAYOUT1_GF13_0_GF14_1 field. */
#define BR_BCH_FLASH0LAYOUT1_GF13_0_GF14_1(x) (HW_BCH_FLASH0LAYOUT1(x).B.GF13_0_GF14_1)

/*! @brief Format value for bitfield BCH_FLASH0LAYOUT1_GF13_0_GF14_1. */
#define BF_BCH_FLASH0LAYOUT1_GF13_0_GF14_1(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH0LAYOUT1_GF13_0_GF14_1) & BM_BCH_FLASH0LAYOUT1_GF13_0_GF14_1)

/*! @brief Set the GF13_0_GF14_1 field to a new value. */
#define BW_BCH_FLASH0LAYOUT1_GF13_0_GF14_1(x, v) (HW_BCH_FLASH0LAYOUT1_WR(x, (HW_BCH_FLASH0LAYOUT1_RD(x) & ~BM_BCH_FLASH0LAYOUT1_GF13_0_GF14_1) | BF_BCH_FLASH0LAYOUT1_GF13_0_GF14_1(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH0LAYOUT1, field ECCN[15:11] (RW)
 *
 * Indicates the ECC level for the subsequent blocks on the flash page (blocks
 * 1-n). Subsequent blocks only contain data (no metadata).
 *
 * Values:
 * - 0 - No ECC to be performed
 * - 1 - ECC 2 to be performed
 * - 10 - ECC 4 to be performed
 * - 11110 - ECC 60 to be performed
 * - 11111 - ECC 62 to be performed
 */
/*@{*/
#define BP_BCH_FLASH0LAYOUT1_ECCN (11U)    /*!< Bit position for BCH_FLASH0LAYOUT1_ECCN. */
#define BM_BCH_FLASH0LAYOUT1_ECCN (0x0000F800U) /*!< Bit mask for BCH_FLASH0LAYOUT1_ECCN. */
#define BS_BCH_FLASH0LAYOUT1_ECCN (5U)     /*!< Bit field size in bits for BCH_FLASH0LAYOUT1_ECCN. */

#define BV_BCH_FLASH0LAYOUT1_ECCN_NONE (0U)          /*!< Bit field value for BCH_FLASH0LAYOUT1_ECCN: No ECC to be performed */
#define BV_BCH_FLASH0LAYOUT1_ECCN_ECC2 (0x1U)        /*!< Bit field value for BCH_FLASH0LAYOUT1_ECCN: ECC 2 to be performed */
#define BV_BCH_FLASH0LAYOUT1_ECCN_ECC4 (0x2U)        /*!< Bit field value for BCH_FLASH0LAYOUT1_ECCN: ECC 4 to be performed */
#define BV_BCH_FLASH0LAYOUT1_ECCN_ECC60 (0x1EU)      /*!< Bit field value for BCH_FLASH0LAYOUT1_ECCN: ECC 60 to be performed */
#define BV_BCH_FLASH0LAYOUT1_ECCN_ECC62 (0x1FU)      /*!< Bit field value for BCH_FLASH0LAYOUT1_ECCN: ECC 62 to be performed */

/*! @brief Read current value of the BCH_FLASH0LAYOUT1_ECCN field. */
#define BR_BCH_FLASH0LAYOUT1_ECCN(x) (HW_BCH_FLASH0LAYOUT1(x).B.ECCN)

/*! @brief Format value for bitfield BCH_FLASH0LAYOUT1_ECCN. */
#define BF_BCH_FLASH0LAYOUT1_ECCN(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH0LAYOUT1_ECCN) & BM_BCH_FLASH0LAYOUT1_ECCN)

/*! @brief Set the ECCN field to a new value. */
#define BW_BCH_FLASH0LAYOUT1_ECCN(x, v) (HW_BCH_FLASH0LAYOUT1_WR(x, (HW_BCH_FLASH0LAYOUT1_RD(x) & ~BM_BCH_FLASH0LAYOUT1_ECCN) | BF_BCH_FLASH0LAYOUT1_ECCN(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH0LAYOUT1, field PAGE_SIZE[31:16] (RW)
 *
 * Indicates the total size of the flash page (in bytes). This should be set to
 * the page size including spare area. The page size is programmable to
 * accomodate different flash configurations that may be available in the future.
 */
/*@{*/
#define BP_BCH_FLASH0LAYOUT1_PAGE_SIZE (16U) /*!< Bit position for BCH_FLASH0LAYOUT1_PAGE_SIZE. */
#define BM_BCH_FLASH0LAYOUT1_PAGE_SIZE (0xFFFF0000U) /*!< Bit mask for BCH_FLASH0LAYOUT1_PAGE_SIZE. */
#define BS_BCH_FLASH0LAYOUT1_PAGE_SIZE (16U) /*!< Bit field size in bits for BCH_FLASH0LAYOUT1_PAGE_SIZE. */

/*! @brief Read current value of the BCH_FLASH0LAYOUT1_PAGE_SIZE field. */
#define BR_BCH_FLASH0LAYOUT1_PAGE_SIZE(x) (HW_BCH_FLASH0LAYOUT1(x).B.PAGE_SIZE)

/*! @brief Format value for bitfield BCH_FLASH0LAYOUT1_PAGE_SIZE. */
#define BF_BCH_FLASH0LAYOUT1_PAGE_SIZE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH0LAYOUT1_PAGE_SIZE) & BM_BCH_FLASH0LAYOUT1_PAGE_SIZE)

/*! @brief Set the PAGE_SIZE field to a new value. */
#define BW_BCH_FLASH0LAYOUT1_PAGE_SIZE(x, v) (HW_BCH_FLASH0LAYOUT1_WR(x, (HW_BCH_FLASH0LAYOUT1_RD(x) & ~BM_BCH_FLASH0LAYOUT1_PAGE_SIZE) | BF_BCH_FLASH0LAYOUT1_PAGE_SIZE(v)))
/*@}*/




/*******************************************************************************
 * HW_BCH_FLASH1LAYOUT0 - Hardware BCH ECC Flash 1 Layout 0 Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_FLASH1LAYOUT0 - Hardware BCH ECC Flash 1 Layout 0 Register (RW)
 *
 * Reset value: 0x070A4080U
 *
 * The flash format register contains a description of the logical layout of
 * data on the flash device. This register is used in conjunction with the
 * FLASH1LAYOUT1 register to control the format for the devices selecting layout 1 in the
 * LAYOUTSELECT register. Each pair of layout registers describes one of four
 * supported flash configurations. Software should program the LAYOUTSELECT register
 * for each supported GPMI chip select to select from one of the four layout
 * values. Each pair of registers contains settings that are used by the BCH block
 * while reading / writing the flash page to control data, metadata, and flash
 * page sizes as well as the ECC correction level. The first block written to flash
 * can be programmed to have different ECC, metadata, and data sizes from
 * subsequent data blocks on the device. In addition, the number of blocks stored on a
 * page of flash is not fixed, but instead is determined by the number of bytes
 * consumed by the initial (block 0) and subsequent data blocks. See the BCH
 * programming reference manual for more information on setting up the flash layout
 * registers.
 */
typedef union _hw_bch_flash1layout0
{
    uint32_t U;
    struct _hw_bch_flash1layout0_bitfields
    {
        uint32_t DATA0_SIZE : 10;      /*!< [9:0]  */
        uint32_t GF13_0_GF14_1 : 1;    /*!< [10]  */
        uint32_t ECC0 : 5;             /*!< [15:11]  */
        uint32_t META_SIZE : 8;        /*!< [23:16]  */
        uint32_t NBLOCKS : 8;          /*!< [31:24]  */
    } B;
} hw_bch_flash1layout0_t;

/*!
 * @name Constants and macros for entire BCH_FLASH1LAYOUT0 register
 */
/*@{*/
#define HW_BCH_FLASH1LAYOUT0_ADDR(x) ((uintptr_t)(x) + 0xA0U)
#define HW_BCH_FLASH1LAYOUT0_SET_ADDR(x) (HW_BCH_FLASH1LAYOUT0_ADDR(x) + 0x4U)
#define HW_BCH_FLASH1LAYOUT0_CLR_ADDR(x) (HW_BCH_FLASH1LAYOUT0_ADDR(x) + 0x8U)
#define HW_BCH_FLASH1LAYOUT0_TOG_ADDR(x) (HW_BCH_FLASH1LAYOUT0_ADDR(x) + 0xCU)

#define HW_BCH_FLASH1LAYOUT0(x)  (*(__IO hw_bch_flash1layout0_t *) HW_BCH_FLASH1LAYOUT0_ADDR(x))
#define HW_BCH_FLASH1LAYOUT0_RD(x) (HW_BCH_FLASH1LAYOUT0(x).U)
#define HW_BCH_FLASH1LAYOUT0_WR(x, v) (HW_BCH_FLASH1LAYOUT0(x).U = (v))
#define HW_BCH_FLASH1LAYOUT0_SET(x, v) ((*(uint32_t *) HW_BCH_FLASH1LAYOUT0_SET_ADDR(x)) = (v))
#define HW_BCH_FLASH1LAYOUT0_CLR(x, v) ((*(uint32_t *) HW_BCH_FLASH1LAYOUT0_CLR_ADDR(x)) = (v))
#define HW_BCH_FLASH1LAYOUT0_TOG(x, v) ((*(uint32_t *) HW_BCH_FLASH1LAYOUT0_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual BCH_FLASH1LAYOUT0 bitfields
 */

/*!
 * @name Register BCH_FLASH1LAYOUT0, field DATA0_SIZE[9:0] (RW)
 *
 * Indicates the size of the data 0 block (in DWORDS / four bytes) to be stored
 * on the flash page. If set to 0, the first block will contains metadata.
 */
/*@{*/
#define BP_BCH_FLASH1LAYOUT0_DATA0_SIZE (0U) /*!< Bit position for BCH_FLASH1LAYOUT0_DATA0_SIZE. */
#define BM_BCH_FLASH1LAYOUT0_DATA0_SIZE (0x000003FFU) /*!< Bit mask for BCH_FLASH1LAYOUT0_DATA0_SIZE. */
#define BS_BCH_FLASH1LAYOUT0_DATA0_SIZE (10U) /*!< Bit field size in bits for BCH_FLASH1LAYOUT0_DATA0_SIZE. */

/*! @brief Read current value of the BCH_FLASH1LAYOUT0_DATA0_SIZE field. */
#define BR_BCH_FLASH1LAYOUT0_DATA0_SIZE(x) (HW_BCH_FLASH1LAYOUT0(x).B.DATA0_SIZE)

/*! @brief Format value for bitfield BCH_FLASH1LAYOUT0_DATA0_SIZE. */
#define BF_BCH_FLASH1LAYOUT0_DATA0_SIZE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH1LAYOUT0_DATA0_SIZE) & BM_BCH_FLASH1LAYOUT0_DATA0_SIZE)

/*! @brief Set the DATA0_SIZE field to a new value. */
#define BW_BCH_FLASH1LAYOUT0_DATA0_SIZE(x, v) (HW_BCH_FLASH1LAYOUT0_WR(x, (HW_BCH_FLASH1LAYOUT0_RD(x) & ~BM_BCH_FLASH1LAYOUT0_DATA0_SIZE) | BF_BCH_FLASH1LAYOUT0_DATA0_SIZE(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH1LAYOUT0, field GF13_0_GF14_1[10] (RW)
 *
 * Select GF13 or GF14: 0-GF13; 1-GF14
 */
/*@{*/
#define BP_BCH_FLASH1LAYOUT0_GF13_0_GF14_1 (10U) /*!< Bit position for BCH_FLASH1LAYOUT0_GF13_0_GF14_1. */
#define BM_BCH_FLASH1LAYOUT0_GF13_0_GF14_1 (0x00000400U) /*!< Bit mask for BCH_FLASH1LAYOUT0_GF13_0_GF14_1. */
#define BS_BCH_FLASH1LAYOUT0_GF13_0_GF14_1 (1U) /*!< Bit field size in bits for BCH_FLASH1LAYOUT0_GF13_0_GF14_1. */

/*! @brief Read current value of the BCH_FLASH1LAYOUT0_GF13_0_GF14_1 field. */
#define BR_BCH_FLASH1LAYOUT0_GF13_0_GF14_1(x) (HW_BCH_FLASH1LAYOUT0(x).B.GF13_0_GF14_1)

/*! @brief Format value for bitfield BCH_FLASH1LAYOUT0_GF13_0_GF14_1. */
#define BF_BCH_FLASH1LAYOUT0_GF13_0_GF14_1(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH1LAYOUT0_GF13_0_GF14_1) & BM_BCH_FLASH1LAYOUT0_GF13_0_GF14_1)

/*! @brief Set the GF13_0_GF14_1 field to a new value. */
#define BW_BCH_FLASH1LAYOUT0_GF13_0_GF14_1(x, v) (HW_BCH_FLASH1LAYOUT0_WR(x, (HW_BCH_FLASH1LAYOUT0_RD(x) & ~BM_BCH_FLASH1LAYOUT0_GF13_0_GF14_1) | BF_BCH_FLASH1LAYOUT0_GF13_0_GF14_1(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH1LAYOUT0, field ECC0[15:11] (RW)
 *
 * Indicates the ECC level for the first block on the flash page. The first
 * block covers metadata plus the associated data from the DATA0_SIZE field.
 *
 * Values:
 * - 0 - No ECC to be performed
 * - 1 - ECC 2 to be performed
 * - 10 - ECC 4 to be performed
 * - 11110 - ECC 60 to be performed
 * - 11111 - ECC 62 to be performed
 */
/*@{*/
#define BP_BCH_FLASH1LAYOUT0_ECC0 (11U)    /*!< Bit position for BCH_FLASH1LAYOUT0_ECC0. */
#define BM_BCH_FLASH1LAYOUT0_ECC0 (0x0000F800U) /*!< Bit mask for BCH_FLASH1LAYOUT0_ECC0. */
#define BS_BCH_FLASH1LAYOUT0_ECC0 (5U)     /*!< Bit field size in bits for BCH_FLASH1LAYOUT0_ECC0. */

#define BV_BCH_FLASH1LAYOUT0_ECC0_NONE (0U)          /*!< Bit field value for BCH_FLASH1LAYOUT0_ECC0: No ECC to be performed */
#define BV_BCH_FLASH1LAYOUT0_ECC0_ECC2 (0x1U)        /*!< Bit field value for BCH_FLASH1LAYOUT0_ECC0: ECC 2 to be performed */
#define BV_BCH_FLASH1LAYOUT0_ECC0_ECC4 (0x2U)        /*!< Bit field value for BCH_FLASH1LAYOUT0_ECC0: ECC 4 to be performed */
#define BV_BCH_FLASH1LAYOUT0_ECC0_ECC60 (0x1EU)      /*!< Bit field value for BCH_FLASH1LAYOUT0_ECC0: ECC 60 to be performed */
#define BV_BCH_FLASH1LAYOUT0_ECC0_ECC62 (0x1FU)      /*!< Bit field value for BCH_FLASH1LAYOUT0_ECC0: ECC 62 to be performed */

/*! @brief Read current value of the BCH_FLASH1LAYOUT0_ECC0 field. */
#define BR_BCH_FLASH1LAYOUT0_ECC0(x) (HW_BCH_FLASH1LAYOUT0(x).B.ECC0)

/*! @brief Format value for bitfield BCH_FLASH1LAYOUT0_ECC0. */
#define BF_BCH_FLASH1LAYOUT0_ECC0(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH1LAYOUT0_ECC0) & BM_BCH_FLASH1LAYOUT0_ECC0)

/*! @brief Set the ECC0 field to a new value. */
#define BW_BCH_FLASH1LAYOUT0_ECC0(x, v) (HW_BCH_FLASH1LAYOUT0_WR(x, (HW_BCH_FLASH1LAYOUT0_RD(x) & ~BM_BCH_FLASH1LAYOUT0_ECC0) | BF_BCH_FLASH1LAYOUT0_ECC0(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH1LAYOUT0, field META_SIZE[23:16] (RW)
 *
 * Indicates the size of the metadata (in bytes) to be stored on a flash page.
 * The BCH design supports from 0 to 255 bytes for metadata-if set to 0, no
 * metadata will be stored. Metadata is stored before the associated data is in block
 * 0. If the DATA0_SIZE field is programmed to a 0, then metadata effectively be
 * stored with its own parity. When both the metadata and data0 fields are
 * programmed with non-zero values, the first block will contain both portions of data
 * and covered by a single parity block.
 */
/*@{*/
#define BP_BCH_FLASH1LAYOUT0_META_SIZE (16U) /*!< Bit position for BCH_FLASH1LAYOUT0_META_SIZE. */
#define BM_BCH_FLASH1LAYOUT0_META_SIZE (0x00FF0000U) /*!< Bit mask for BCH_FLASH1LAYOUT0_META_SIZE. */
#define BS_BCH_FLASH1LAYOUT0_META_SIZE (8U) /*!< Bit field size in bits for BCH_FLASH1LAYOUT0_META_SIZE. */

/*! @brief Read current value of the BCH_FLASH1LAYOUT0_META_SIZE field. */
#define BR_BCH_FLASH1LAYOUT0_META_SIZE(x) (HW_BCH_FLASH1LAYOUT0(x).B.META_SIZE)

/*! @brief Format value for bitfield BCH_FLASH1LAYOUT0_META_SIZE. */
#define BF_BCH_FLASH1LAYOUT0_META_SIZE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH1LAYOUT0_META_SIZE) & BM_BCH_FLASH1LAYOUT0_META_SIZE)

/*! @brief Set the META_SIZE field to a new value. */
#define BW_BCH_FLASH1LAYOUT0_META_SIZE(x, v) (HW_BCH_FLASH1LAYOUT0_WR(x, (HW_BCH_FLASH1LAYOUT0_RD(x) & ~BM_BCH_FLASH1LAYOUT0_META_SIZE) | BF_BCH_FLASH1LAYOUT0_META_SIZE(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH1LAYOUT0, field NBLOCKS[31:24] (RW)
 *
 * Number of subsequent blocks on the flash page (excluding the data0 block). A
 * value of 0 indicates that only the DATA0 block is present and a value of 8
 * indicates that 8 subsequent blocks are present for a total of 9 blocks on the
 * flash (including the DATA0 block). Any values from 0 to 255 are supported by the
 * hardware.
 */
/*@{*/
#define BP_BCH_FLASH1LAYOUT0_NBLOCKS (24U) /*!< Bit position for BCH_FLASH1LAYOUT0_NBLOCKS. */
#define BM_BCH_FLASH1LAYOUT0_NBLOCKS (0xFF000000U) /*!< Bit mask for BCH_FLASH1LAYOUT0_NBLOCKS. */
#define BS_BCH_FLASH1LAYOUT0_NBLOCKS (8U)  /*!< Bit field size in bits for BCH_FLASH1LAYOUT0_NBLOCKS. */

/*! @brief Read current value of the BCH_FLASH1LAYOUT0_NBLOCKS field. */
#define BR_BCH_FLASH1LAYOUT0_NBLOCKS(x) (HW_BCH_FLASH1LAYOUT0(x).B.NBLOCKS)

/*! @brief Format value for bitfield BCH_FLASH1LAYOUT0_NBLOCKS. */
#define BF_BCH_FLASH1LAYOUT0_NBLOCKS(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH1LAYOUT0_NBLOCKS) & BM_BCH_FLASH1LAYOUT0_NBLOCKS)

/*! @brief Set the NBLOCKS field to a new value. */
#define BW_BCH_FLASH1LAYOUT0_NBLOCKS(x, v) (HW_BCH_FLASH1LAYOUT0_WR(x, (HW_BCH_FLASH1LAYOUT0_RD(x) & ~BM_BCH_FLASH1LAYOUT0_NBLOCKS) | BF_BCH_FLASH1LAYOUT0_NBLOCKS(v)))
/*@}*/




/*******************************************************************************
 * HW_BCH_FLASH1LAYOUT1 - Hardware BCH ECC Flash 1 Layout 1 Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_FLASH1LAYOUT1 - Hardware BCH ECC Flash 1 Layout 1 Register (RW)
 *
 * Reset value: 0x10DA4080U
 *
 * The flash format register contains a description of the logical layout of
 * data on the flash device. This register is used in conjunction with the
 * FLASH1LAYOUT0 register to control the format for the device selecting layout 1 in the
 * LAYOUTSELECT register.
 */
typedef union _hw_bch_flash1layout1
{
    uint32_t U;
    struct _hw_bch_flash1layout1_bitfields
    {
        uint32_t DATAN_SIZE : 10;      /*!< [9:0]  */
        uint32_t GF13_0_GF14_1 : 1;    /*!< [10]  */
        uint32_t ECCN : 5;             /*!< [15:11]  */
        uint32_t PAGE_SIZE : 16;       /*!< [31:16]  */
    } B;
} hw_bch_flash1layout1_t;

/*!
 * @name Constants and macros for entire BCH_FLASH1LAYOUT1 register
 */
/*@{*/
#define HW_BCH_FLASH1LAYOUT1_ADDR(x) ((uintptr_t)(x) + 0xB0U)
#define HW_BCH_FLASH1LAYOUT1_SET_ADDR(x) (HW_BCH_FLASH1LAYOUT1_ADDR(x) + 0x4U)
#define HW_BCH_FLASH1LAYOUT1_CLR_ADDR(x) (HW_BCH_FLASH1LAYOUT1_ADDR(x) + 0x8U)
#define HW_BCH_FLASH1LAYOUT1_TOG_ADDR(x) (HW_BCH_FLASH1LAYOUT1_ADDR(x) + 0xCU)

#define HW_BCH_FLASH1LAYOUT1(x)  (*(__IO hw_bch_flash1layout1_t *) HW_BCH_FLASH1LAYOUT1_ADDR(x))
#define HW_BCH_FLASH1LAYOUT1_RD(x) (HW_BCH_FLASH1LAYOUT1(x).U)
#define HW_BCH_FLASH1LAYOUT1_WR(x, v) (HW_BCH_FLASH1LAYOUT1(x).U = (v))
#define HW_BCH_FLASH1LAYOUT1_SET(x, v) ((*(uint32_t *) HW_BCH_FLASH1LAYOUT1_SET_ADDR(x)) = (v))
#define HW_BCH_FLASH1LAYOUT1_CLR(x, v) ((*(uint32_t *) HW_BCH_FLASH1LAYOUT1_CLR_ADDR(x)) = (v))
#define HW_BCH_FLASH1LAYOUT1_TOG(x, v) ((*(uint32_t *) HW_BCH_FLASH1LAYOUT1_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual BCH_FLASH1LAYOUT1 bitfields
 */

/*!
 * @name Register BCH_FLASH1LAYOUT1, field DATAN_SIZE[9:0] (RW)
 *
 * Indicates the size of the subsequent data blocks (in DWORDS / four bytes) to
 * be stored on the flash page. The size of subsequent data blocks does not have
 * to match the data size for block 0, which is important when metadata is stored
 * separately or for balancing the amount of data stored in each block.
 */
/*@{*/
#define BP_BCH_FLASH1LAYOUT1_DATAN_SIZE (0U) /*!< Bit position for BCH_FLASH1LAYOUT1_DATAN_SIZE. */
#define BM_BCH_FLASH1LAYOUT1_DATAN_SIZE (0x000003FFU) /*!< Bit mask for BCH_FLASH1LAYOUT1_DATAN_SIZE. */
#define BS_BCH_FLASH1LAYOUT1_DATAN_SIZE (10U) /*!< Bit field size in bits for BCH_FLASH1LAYOUT1_DATAN_SIZE. */

/*! @brief Read current value of the BCH_FLASH1LAYOUT1_DATAN_SIZE field. */
#define BR_BCH_FLASH1LAYOUT1_DATAN_SIZE(x) (HW_BCH_FLASH1LAYOUT1(x).B.DATAN_SIZE)

/*! @brief Format value for bitfield BCH_FLASH1LAYOUT1_DATAN_SIZE. */
#define BF_BCH_FLASH1LAYOUT1_DATAN_SIZE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH1LAYOUT1_DATAN_SIZE) & BM_BCH_FLASH1LAYOUT1_DATAN_SIZE)

/*! @brief Set the DATAN_SIZE field to a new value. */
#define BW_BCH_FLASH1LAYOUT1_DATAN_SIZE(x, v) (HW_BCH_FLASH1LAYOUT1_WR(x, (HW_BCH_FLASH1LAYOUT1_RD(x) & ~BM_BCH_FLASH1LAYOUT1_DATAN_SIZE) | BF_BCH_FLASH1LAYOUT1_DATAN_SIZE(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH1LAYOUT1, field GF13_0_GF14_1[10] (RW)
 *
 * Select GF13 or GF14: 0-GF13; 1-GF14
 */
/*@{*/
#define BP_BCH_FLASH1LAYOUT1_GF13_0_GF14_1 (10U) /*!< Bit position for BCH_FLASH1LAYOUT1_GF13_0_GF14_1. */
#define BM_BCH_FLASH1LAYOUT1_GF13_0_GF14_1 (0x00000400U) /*!< Bit mask for BCH_FLASH1LAYOUT1_GF13_0_GF14_1. */
#define BS_BCH_FLASH1LAYOUT1_GF13_0_GF14_1 (1U) /*!< Bit field size in bits for BCH_FLASH1LAYOUT1_GF13_0_GF14_1. */

/*! @brief Read current value of the BCH_FLASH1LAYOUT1_GF13_0_GF14_1 field. */
#define BR_BCH_FLASH1LAYOUT1_GF13_0_GF14_1(x) (HW_BCH_FLASH1LAYOUT1(x).B.GF13_0_GF14_1)

/*! @brief Format value for bitfield BCH_FLASH1LAYOUT1_GF13_0_GF14_1. */
#define BF_BCH_FLASH1LAYOUT1_GF13_0_GF14_1(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH1LAYOUT1_GF13_0_GF14_1) & BM_BCH_FLASH1LAYOUT1_GF13_0_GF14_1)

/*! @brief Set the GF13_0_GF14_1 field to a new value. */
#define BW_BCH_FLASH1LAYOUT1_GF13_0_GF14_1(x, v) (HW_BCH_FLASH1LAYOUT1_WR(x, (HW_BCH_FLASH1LAYOUT1_RD(x) & ~BM_BCH_FLASH1LAYOUT1_GF13_0_GF14_1) | BF_BCH_FLASH1LAYOUT1_GF13_0_GF14_1(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH1LAYOUT1, field ECCN[15:11] (RW)
 *
 * Indicates the ECC level for the subsequent blocks on the flash page (blocks
 * 1-n). Subsequent blocks only contain data (no metadata).
 *
 * Values:
 * - 0 - No ECC to be performed
 * - 1 - ECC 2 to be performed
 * - 10 - ECC 4 to be performed
 * - 11110 - ECC 60 to be performed
 * - 11111 - ECC 62 to be performed
 */
/*@{*/
#define BP_BCH_FLASH1LAYOUT1_ECCN (11U)    /*!< Bit position for BCH_FLASH1LAYOUT1_ECCN. */
#define BM_BCH_FLASH1LAYOUT1_ECCN (0x0000F800U) /*!< Bit mask for BCH_FLASH1LAYOUT1_ECCN. */
#define BS_BCH_FLASH1LAYOUT1_ECCN (5U)     /*!< Bit field size in bits for BCH_FLASH1LAYOUT1_ECCN. */

#define BV_BCH_FLASH1LAYOUT1_ECCN_NONE (0U)          /*!< Bit field value for BCH_FLASH1LAYOUT1_ECCN: No ECC to be performed */
#define BV_BCH_FLASH1LAYOUT1_ECCN_ECC2 (0x1U)        /*!< Bit field value for BCH_FLASH1LAYOUT1_ECCN: ECC 2 to be performed */
#define BV_BCH_FLASH1LAYOUT1_ECCN_ECC4 (0x2U)        /*!< Bit field value for BCH_FLASH1LAYOUT1_ECCN: ECC 4 to be performed */
#define BV_BCH_FLASH1LAYOUT1_ECCN_ECC60 (0x1EU)      /*!< Bit field value for BCH_FLASH1LAYOUT1_ECCN: ECC 60 to be performed */
#define BV_BCH_FLASH1LAYOUT1_ECCN_ECC62 (0x1FU)      /*!< Bit field value for BCH_FLASH1LAYOUT1_ECCN: ECC 62 to be performed */

/*! @brief Read current value of the BCH_FLASH1LAYOUT1_ECCN field. */
#define BR_BCH_FLASH1LAYOUT1_ECCN(x) (HW_BCH_FLASH1LAYOUT1(x).B.ECCN)

/*! @brief Format value for bitfield BCH_FLASH1LAYOUT1_ECCN. */
#define BF_BCH_FLASH1LAYOUT1_ECCN(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH1LAYOUT1_ECCN) & BM_BCH_FLASH1LAYOUT1_ECCN)

/*! @brief Set the ECCN field to a new value. */
#define BW_BCH_FLASH1LAYOUT1_ECCN(x, v) (HW_BCH_FLASH1LAYOUT1_WR(x, (HW_BCH_FLASH1LAYOUT1_RD(x) & ~BM_BCH_FLASH1LAYOUT1_ECCN) | BF_BCH_FLASH1LAYOUT1_ECCN(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH1LAYOUT1, field PAGE_SIZE[31:16] (RW)
 *
 * Indicates the total size of the flash page (in bytes). This should be set to
 * the page size including spare area. The page size is programmable to
 * accomodate different flash configurations that may be available in the future.
 */
/*@{*/
#define BP_BCH_FLASH1LAYOUT1_PAGE_SIZE (16U) /*!< Bit position for BCH_FLASH1LAYOUT1_PAGE_SIZE. */
#define BM_BCH_FLASH1LAYOUT1_PAGE_SIZE (0xFFFF0000U) /*!< Bit mask for BCH_FLASH1LAYOUT1_PAGE_SIZE. */
#define BS_BCH_FLASH1LAYOUT1_PAGE_SIZE (16U) /*!< Bit field size in bits for BCH_FLASH1LAYOUT1_PAGE_SIZE. */

/*! @brief Read current value of the BCH_FLASH1LAYOUT1_PAGE_SIZE field. */
#define BR_BCH_FLASH1LAYOUT1_PAGE_SIZE(x) (HW_BCH_FLASH1LAYOUT1(x).B.PAGE_SIZE)

/*! @brief Format value for bitfield BCH_FLASH1LAYOUT1_PAGE_SIZE. */
#define BF_BCH_FLASH1LAYOUT1_PAGE_SIZE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH1LAYOUT1_PAGE_SIZE) & BM_BCH_FLASH1LAYOUT1_PAGE_SIZE)

/*! @brief Set the PAGE_SIZE field to a new value. */
#define BW_BCH_FLASH1LAYOUT1_PAGE_SIZE(x, v) (HW_BCH_FLASH1LAYOUT1_WR(x, (HW_BCH_FLASH1LAYOUT1_RD(x) & ~BM_BCH_FLASH1LAYOUT1_PAGE_SIZE) | BF_BCH_FLASH1LAYOUT1_PAGE_SIZE(v)))
/*@}*/




/*******************************************************************************
 * HW_BCH_FLASH2LAYOUT0 - Hardware BCH ECC Flash 2 Layout 0 Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_FLASH2LAYOUT0 - Hardware BCH ECC Flash 2 Layout 0 Register (RW)
 *
 * Reset value: 0x070A4080U
 *
 * The flash format register contains a description of the logical layout of
 * data on the flash device. This register is used in conjunction with the
 * FLASH2LAYOUT1 register to control the format for the devices selecting layout 2 in the
 * LAYOUTSELECT register. Each pair of layout registers describes one of four
 * supported flash configurations. Software should program the LAYOUTSELECT register
 * for each supported GPMI chip select to select from one of the four layout
 * values. Each pair of registers contains settings that are used by the BCH block
 * while reading / writing the flash page to control data, metadata, and flash
 * page sizes as well as the ECC correction level. The first block written to flash
 * can be programmed to have different ECC, metadata, and data sizes from
 * subsequent data blocks on the device. In addition, the number of blocks stored on a
 * page of flash is not fixed, but instead is determined by the number of bytes
 * consumed by the initial (block 0) and subsequent data blocks. See the BCH
 * programming reference manual for more information on setting up the flash layout
 * registers.
 */
typedef union _hw_bch_flash2layout0
{
    uint32_t U;
    struct _hw_bch_flash2layout0_bitfields
    {
        uint32_t DATA0_SIZE : 10;      /*!< [9:0]  */
        uint32_t GF13_0_GF14_1 : 1;    /*!< [10]  */
        uint32_t ECC0 : 5;             /*!< [15:11]  */
        uint32_t META_SIZE : 8;        /*!< [23:16]  */
        uint32_t NBLOCKS : 8;          /*!< [31:24]  */
    } B;
} hw_bch_flash2layout0_t;

/*!
 * @name Constants and macros for entire BCH_FLASH2LAYOUT0 register
 */
/*@{*/
#define HW_BCH_FLASH2LAYOUT0_ADDR(x) ((uintptr_t)(x) + 0xC0U)
#define HW_BCH_FLASH2LAYOUT0_SET_ADDR(x) (HW_BCH_FLASH2LAYOUT0_ADDR(x) + 0x4U)
#define HW_BCH_FLASH2LAYOUT0_CLR_ADDR(x) (HW_BCH_FLASH2LAYOUT0_ADDR(x) + 0x8U)
#define HW_BCH_FLASH2LAYOUT0_TOG_ADDR(x) (HW_BCH_FLASH2LAYOUT0_ADDR(x) + 0xCU)

#define HW_BCH_FLASH2LAYOUT0(x)  (*(__IO hw_bch_flash2layout0_t *) HW_BCH_FLASH2LAYOUT0_ADDR(x))
#define HW_BCH_FLASH2LAYOUT0_RD(x) (HW_BCH_FLASH2LAYOUT0(x).U)
#define HW_BCH_FLASH2LAYOUT0_WR(x, v) (HW_BCH_FLASH2LAYOUT0(x).U = (v))
#define HW_BCH_FLASH2LAYOUT0_SET(x, v) ((*(uint32_t *) HW_BCH_FLASH2LAYOUT0_SET_ADDR(x)) = (v))
#define HW_BCH_FLASH2LAYOUT0_CLR(x, v) ((*(uint32_t *) HW_BCH_FLASH2LAYOUT0_CLR_ADDR(x)) = (v))
#define HW_BCH_FLASH2LAYOUT0_TOG(x, v) ((*(uint32_t *) HW_BCH_FLASH2LAYOUT0_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual BCH_FLASH2LAYOUT0 bitfields
 */

/*!
 * @name Register BCH_FLASH2LAYOUT0, field DATA0_SIZE[9:0] (RW)
 *
 * Indicates the size of the data 0 block (in DWORDS / four bytes) to be stored
 * on the flash page. If set to 0, the first block will only contain metadata.
 */
/*@{*/
#define BP_BCH_FLASH2LAYOUT0_DATA0_SIZE (0U) /*!< Bit position for BCH_FLASH2LAYOUT0_DATA0_SIZE. */
#define BM_BCH_FLASH2LAYOUT0_DATA0_SIZE (0x000003FFU) /*!< Bit mask for BCH_FLASH2LAYOUT0_DATA0_SIZE. */
#define BS_BCH_FLASH2LAYOUT0_DATA0_SIZE (10U) /*!< Bit field size in bits for BCH_FLASH2LAYOUT0_DATA0_SIZE. */

/*! @brief Read current value of the BCH_FLASH2LAYOUT0_DATA0_SIZE field. */
#define BR_BCH_FLASH2LAYOUT0_DATA0_SIZE(x) (HW_BCH_FLASH2LAYOUT0(x).B.DATA0_SIZE)

/*! @brief Format value for bitfield BCH_FLASH2LAYOUT0_DATA0_SIZE. */
#define BF_BCH_FLASH2LAYOUT0_DATA0_SIZE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH2LAYOUT0_DATA0_SIZE) & BM_BCH_FLASH2LAYOUT0_DATA0_SIZE)

/*! @brief Set the DATA0_SIZE field to a new value. */
#define BW_BCH_FLASH2LAYOUT0_DATA0_SIZE(x, v) (HW_BCH_FLASH2LAYOUT0_WR(x, (HW_BCH_FLASH2LAYOUT0_RD(x) & ~BM_BCH_FLASH2LAYOUT0_DATA0_SIZE) | BF_BCH_FLASH2LAYOUT0_DATA0_SIZE(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH2LAYOUT0, field GF13_0_GF14_1[10] (RW)
 *
 * Select GF13 or GF14: 0-GF13; 1-GF14
 */
/*@{*/
#define BP_BCH_FLASH2LAYOUT0_GF13_0_GF14_1 (10U) /*!< Bit position for BCH_FLASH2LAYOUT0_GF13_0_GF14_1. */
#define BM_BCH_FLASH2LAYOUT0_GF13_0_GF14_1 (0x00000400U) /*!< Bit mask for BCH_FLASH2LAYOUT0_GF13_0_GF14_1. */
#define BS_BCH_FLASH2LAYOUT0_GF13_0_GF14_1 (1U) /*!< Bit field size in bits for BCH_FLASH2LAYOUT0_GF13_0_GF14_1. */

/*! @brief Read current value of the BCH_FLASH2LAYOUT0_GF13_0_GF14_1 field. */
#define BR_BCH_FLASH2LAYOUT0_GF13_0_GF14_1(x) (HW_BCH_FLASH2LAYOUT0(x).B.GF13_0_GF14_1)

/*! @brief Format value for bitfield BCH_FLASH2LAYOUT0_GF13_0_GF14_1. */
#define BF_BCH_FLASH2LAYOUT0_GF13_0_GF14_1(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH2LAYOUT0_GF13_0_GF14_1) & BM_BCH_FLASH2LAYOUT0_GF13_0_GF14_1)

/*! @brief Set the GF13_0_GF14_1 field to a new value. */
#define BW_BCH_FLASH2LAYOUT0_GF13_0_GF14_1(x, v) (HW_BCH_FLASH2LAYOUT0_WR(x, (HW_BCH_FLASH2LAYOUT0_RD(x) & ~BM_BCH_FLASH2LAYOUT0_GF13_0_GF14_1) | BF_BCH_FLASH2LAYOUT0_GF13_0_GF14_1(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH2LAYOUT0, field ECC0[15:11] (RW)
 *
 * Indicates the ECC level for the first block on the flash page. The first
 * block covers metadata plus the associated data from the DATA0_SIZE field.
 *
 * Values:
 * - 0 - No ECC to be performed
 * - 1 - ECC 2 to be performed
 * - 10 - ECC 4 to be performed
 * - 11110 - ECC 60 to be performed
 * - 11111 - ECC 62 to be performed
 */
/*@{*/
#define BP_BCH_FLASH2LAYOUT0_ECC0 (11U)    /*!< Bit position for BCH_FLASH2LAYOUT0_ECC0. */
#define BM_BCH_FLASH2LAYOUT0_ECC0 (0x0000F800U) /*!< Bit mask for BCH_FLASH2LAYOUT0_ECC0. */
#define BS_BCH_FLASH2LAYOUT0_ECC0 (5U)     /*!< Bit field size in bits for BCH_FLASH2LAYOUT0_ECC0. */

#define BV_BCH_FLASH2LAYOUT0_ECC0_NONE (0U)          /*!< Bit field value for BCH_FLASH2LAYOUT0_ECC0: No ECC to be performed */
#define BV_BCH_FLASH2LAYOUT0_ECC0_ECC2 (0x1U)        /*!< Bit field value for BCH_FLASH2LAYOUT0_ECC0: ECC 2 to be performed */
#define BV_BCH_FLASH2LAYOUT0_ECC0_ECC4 (0x2U)        /*!< Bit field value for BCH_FLASH2LAYOUT0_ECC0: ECC 4 to be performed */
#define BV_BCH_FLASH2LAYOUT0_ECC0_ECC60 (0x1EU)      /*!< Bit field value for BCH_FLASH2LAYOUT0_ECC0: ECC 60 to be performed */
#define BV_BCH_FLASH2LAYOUT0_ECC0_ECC62 (0x1FU)      /*!< Bit field value for BCH_FLASH2LAYOUT0_ECC0: ECC 62 to be performed */

/*! @brief Read current value of the BCH_FLASH2LAYOUT0_ECC0 field. */
#define BR_BCH_FLASH2LAYOUT0_ECC0(x) (HW_BCH_FLASH2LAYOUT0(x).B.ECC0)

/*! @brief Format value for bitfield BCH_FLASH2LAYOUT0_ECC0. */
#define BF_BCH_FLASH2LAYOUT0_ECC0(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH2LAYOUT0_ECC0) & BM_BCH_FLASH2LAYOUT0_ECC0)

/*! @brief Set the ECC0 field to a new value. */
#define BW_BCH_FLASH2LAYOUT0_ECC0(x, v) (HW_BCH_FLASH2LAYOUT0_WR(x, (HW_BCH_FLASH2LAYOUT0_RD(x) & ~BM_BCH_FLASH2LAYOUT0_ECC0) | BF_BCH_FLASH2LAYOUT0_ECC0(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH2LAYOUT0, field META_SIZE[23:16] (RW)
 *
 * Indicates the size of the metadata (in bytes) to be stored on a flash page.
 * The BCH design support from 0 to 255 bytes for metadata-if set to 0, no
 * metadata will be stored. Metadata is stored before the associated data in block 0. If
 * the DATA0_SIZE field is programmed to a 0, then metadata effectively be
 * stored with its own parity. When both the metadata and data0 fields are programmed
 * with non-zero values, the first block will contain both portions of data and
 * will be covered by a single parity block.
 */
/*@{*/
#define BP_BCH_FLASH2LAYOUT0_META_SIZE (16U) /*!< Bit position for BCH_FLASH2LAYOUT0_META_SIZE. */
#define BM_BCH_FLASH2LAYOUT0_META_SIZE (0x00FF0000U) /*!< Bit mask for BCH_FLASH2LAYOUT0_META_SIZE. */
#define BS_BCH_FLASH2LAYOUT0_META_SIZE (8U) /*!< Bit field size in bits for BCH_FLASH2LAYOUT0_META_SIZE. */

/*! @brief Read current value of the BCH_FLASH2LAYOUT0_META_SIZE field. */
#define BR_BCH_FLASH2LAYOUT0_META_SIZE(x) (HW_BCH_FLASH2LAYOUT0(x).B.META_SIZE)

/*! @brief Format value for bitfield BCH_FLASH2LAYOUT0_META_SIZE. */
#define BF_BCH_FLASH2LAYOUT0_META_SIZE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH2LAYOUT0_META_SIZE) & BM_BCH_FLASH2LAYOUT0_META_SIZE)

/*! @brief Set the META_SIZE field to a new value. */
#define BW_BCH_FLASH2LAYOUT0_META_SIZE(x, v) (HW_BCH_FLASH2LAYOUT0_WR(x, (HW_BCH_FLASH2LAYOUT0_RD(x) & ~BM_BCH_FLASH2LAYOUT0_META_SIZE) | BF_BCH_FLASH2LAYOUT0_META_SIZE(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH2LAYOUT0, field NBLOCKS[31:24] (RW)
 *
 * Number of subsequent blocks on the flash page (excluding the data0 block). A
 * value of 0 indicates that only the DATA0 block is present and a value of 8
 * indicates that eight subsequent blocks are present for a total of nine blocks on
 * the flash (including the DATA0 block). Any values from 0 to 255 are supported
 * by the hardware.
 */
/*@{*/
#define BP_BCH_FLASH2LAYOUT0_NBLOCKS (24U) /*!< Bit position for BCH_FLASH2LAYOUT0_NBLOCKS. */
#define BM_BCH_FLASH2LAYOUT0_NBLOCKS (0xFF000000U) /*!< Bit mask for BCH_FLASH2LAYOUT0_NBLOCKS. */
#define BS_BCH_FLASH2LAYOUT0_NBLOCKS (8U)  /*!< Bit field size in bits for BCH_FLASH2LAYOUT0_NBLOCKS. */

/*! @brief Read current value of the BCH_FLASH2LAYOUT0_NBLOCKS field. */
#define BR_BCH_FLASH2LAYOUT0_NBLOCKS(x) (HW_BCH_FLASH2LAYOUT0(x).B.NBLOCKS)

/*! @brief Format value for bitfield BCH_FLASH2LAYOUT0_NBLOCKS. */
#define BF_BCH_FLASH2LAYOUT0_NBLOCKS(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH2LAYOUT0_NBLOCKS) & BM_BCH_FLASH2LAYOUT0_NBLOCKS)

/*! @brief Set the NBLOCKS field to a new value. */
#define BW_BCH_FLASH2LAYOUT0_NBLOCKS(x, v) (HW_BCH_FLASH2LAYOUT0_WR(x, (HW_BCH_FLASH2LAYOUT0_RD(x) & ~BM_BCH_FLASH2LAYOUT0_NBLOCKS) | BF_BCH_FLASH2LAYOUT0_NBLOCKS(v)))
/*@}*/




/*******************************************************************************
 * HW_BCH_FLASH2LAYOUT1 - Hardware BCH ECC Flash 2 Layout 1 Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_FLASH2LAYOUT1 - Hardware BCH ECC Flash 2 Layout 1 Register (RW)
 *
 * Reset value: 0x10DA4080U
 *
 * The flash format register contains a description of the logical layout of
 * data on the flash device. This register is used in conjunction with the
 * FLASH2LAYOUT0 register to control the format for the device selecting layout 2 in the
 * LAYOUTSELECT register.
 */
typedef union _hw_bch_flash2layout1
{
    uint32_t U;
    struct _hw_bch_flash2layout1_bitfields
    {
        uint32_t DATAN_SIZE : 10;      /*!< [9:0]  */
        uint32_t GF13_0_GF14_1 : 1;    /*!< [10]  */
        uint32_t ECCN : 5;             /*!< [15:11]  */
        uint32_t PAGE_SIZE : 16;       /*!< [31:16]  */
    } B;
} hw_bch_flash2layout1_t;

/*!
 * @name Constants and macros for entire BCH_FLASH2LAYOUT1 register
 */
/*@{*/
#define HW_BCH_FLASH2LAYOUT1_ADDR(x) ((uintptr_t)(x) + 0xD0U)
#define HW_BCH_FLASH2LAYOUT1_SET_ADDR(x) (HW_BCH_FLASH2LAYOUT1_ADDR(x) + 0x4U)
#define HW_BCH_FLASH2LAYOUT1_CLR_ADDR(x) (HW_BCH_FLASH2LAYOUT1_ADDR(x) + 0x8U)
#define HW_BCH_FLASH2LAYOUT1_TOG_ADDR(x) (HW_BCH_FLASH2LAYOUT1_ADDR(x) + 0xCU)

#define HW_BCH_FLASH2LAYOUT1(x)  (*(__IO hw_bch_flash2layout1_t *) HW_BCH_FLASH2LAYOUT1_ADDR(x))
#define HW_BCH_FLASH2LAYOUT1_RD(x) (HW_BCH_FLASH2LAYOUT1(x).U)
#define HW_BCH_FLASH2LAYOUT1_WR(x, v) (HW_BCH_FLASH2LAYOUT1(x).U = (v))
#define HW_BCH_FLASH2LAYOUT1_SET(x, v) ((*(uint32_t *) HW_BCH_FLASH2LAYOUT1_SET_ADDR(x)) = (v))
#define HW_BCH_FLASH2LAYOUT1_CLR(x, v) ((*(uint32_t *) HW_BCH_FLASH2LAYOUT1_CLR_ADDR(x)) = (v))
#define HW_BCH_FLASH2LAYOUT1_TOG(x, v) ((*(uint32_t *) HW_BCH_FLASH2LAYOUT1_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual BCH_FLASH2LAYOUT1 bitfields
 */

/*!
 * @name Register BCH_FLASH2LAYOUT1, field DATAN_SIZE[9:0] (RW)
 *
 * Indicates the size of the subsequent data blocks (in DWORDS / four bytes) to
 * be stored on the flash page. The size of subsequent data blocks does not have
 * to match the data size for block 0, which is important when metadata is stored
 * separately or for balancing the amount of data stored in each block.
 */
/*@{*/
#define BP_BCH_FLASH2LAYOUT1_DATAN_SIZE (0U) /*!< Bit position for BCH_FLASH2LAYOUT1_DATAN_SIZE. */
#define BM_BCH_FLASH2LAYOUT1_DATAN_SIZE (0x000003FFU) /*!< Bit mask for BCH_FLASH2LAYOUT1_DATAN_SIZE. */
#define BS_BCH_FLASH2LAYOUT1_DATAN_SIZE (10U) /*!< Bit field size in bits for BCH_FLASH2LAYOUT1_DATAN_SIZE. */

/*! @brief Read current value of the BCH_FLASH2LAYOUT1_DATAN_SIZE field. */
#define BR_BCH_FLASH2LAYOUT1_DATAN_SIZE(x) (HW_BCH_FLASH2LAYOUT1(x).B.DATAN_SIZE)

/*! @brief Format value for bitfield BCH_FLASH2LAYOUT1_DATAN_SIZE. */
#define BF_BCH_FLASH2LAYOUT1_DATAN_SIZE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH2LAYOUT1_DATAN_SIZE) & BM_BCH_FLASH2LAYOUT1_DATAN_SIZE)

/*! @brief Set the DATAN_SIZE field to a new value. */
#define BW_BCH_FLASH2LAYOUT1_DATAN_SIZE(x, v) (HW_BCH_FLASH2LAYOUT1_WR(x, (HW_BCH_FLASH2LAYOUT1_RD(x) & ~BM_BCH_FLASH2LAYOUT1_DATAN_SIZE) | BF_BCH_FLASH2LAYOUT1_DATAN_SIZE(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH2LAYOUT1, field GF13_0_GF14_1[10] (RW)
 *
 * Select GF13 or GF14: 0-GF13; 1-GF14
 */
/*@{*/
#define BP_BCH_FLASH2LAYOUT1_GF13_0_GF14_1 (10U) /*!< Bit position for BCH_FLASH2LAYOUT1_GF13_0_GF14_1. */
#define BM_BCH_FLASH2LAYOUT1_GF13_0_GF14_1 (0x00000400U) /*!< Bit mask for BCH_FLASH2LAYOUT1_GF13_0_GF14_1. */
#define BS_BCH_FLASH2LAYOUT1_GF13_0_GF14_1 (1U) /*!< Bit field size in bits for BCH_FLASH2LAYOUT1_GF13_0_GF14_1. */

/*! @brief Read current value of the BCH_FLASH2LAYOUT1_GF13_0_GF14_1 field. */
#define BR_BCH_FLASH2LAYOUT1_GF13_0_GF14_1(x) (HW_BCH_FLASH2LAYOUT1(x).B.GF13_0_GF14_1)

/*! @brief Format value for bitfield BCH_FLASH2LAYOUT1_GF13_0_GF14_1. */
#define BF_BCH_FLASH2LAYOUT1_GF13_0_GF14_1(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH2LAYOUT1_GF13_0_GF14_1) & BM_BCH_FLASH2LAYOUT1_GF13_0_GF14_1)

/*! @brief Set the GF13_0_GF14_1 field to a new value. */
#define BW_BCH_FLASH2LAYOUT1_GF13_0_GF14_1(x, v) (HW_BCH_FLASH2LAYOUT1_WR(x, (HW_BCH_FLASH2LAYOUT1_RD(x) & ~BM_BCH_FLASH2LAYOUT1_GF13_0_GF14_1) | BF_BCH_FLASH2LAYOUT1_GF13_0_GF14_1(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH2LAYOUT1, field ECCN[15:11] (RW)
 *
 * Indicates the ECC level for the subsequent blocks on the flash page (blocks
 * 1-n). Subsequent blocks only contain data (no metadata).
 *
 * Values:
 * - 0 - No ECC to be performed
 * - 1 - ECC 2 to be performed
 * - 10 - ECC 4 to be performed
 * - 11110 - ECC 60 to be performed
 * - 11111 - ECC 62 to be performed
 */
/*@{*/
#define BP_BCH_FLASH2LAYOUT1_ECCN (11U)    /*!< Bit position for BCH_FLASH2LAYOUT1_ECCN. */
#define BM_BCH_FLASH2LAYOUT1_ECCN (0x0000F800U) /*!< Bit mask for BCH_FLASH2LAYOUT1_ECCN. */
#define BS_BCH_FLASH2LAYOUT1_ECCN (5U)     /*!< Bit field size in bits for BCH_FLASH2LAYOUT1_ECCN. */

#define BV_BCH_FLASH2LAYOUT1_ECCN_NONE (0U)          /*!< Bit field value for BCH_FLASH2LAYOUT1_ECCN: No ECC to be performed */
#define BV_BCH_FLASH2LAYOUT1_ECCN_ECC2 (0x1U)        /*!< Bit field value for BCH_FLASH2LAYOUT1_ECCN: ECC 2 to be performed */
#define BV_BCH_FLASH2LAYOUT1_ECCN_ECC4 (0x2U)        /*!< Bit field value for BCH_FLASH2LAYOUT1_ECCN: ECC 4 to be performed */
#define BV_BCH_FLASH2LAYOUT1_ECCN_ECC60 (0x1EU)      /*!< Bit field value for BCH_FLASH2LAYOUT1_ECCN: ECC 60 to be performed */
#define BV_BCH_FLASH2LAYOUT1_ECCN_ECC62 (0x1FU)      /*!< Bit field value for BCH_FLASH2LAYOUT1_ECCN: ECC 62 to be performed */

/*! @brief Read current value of the BCH_FLASH2LAYOUT1_ECCN field. */
#define BR_BCH_FLASH2LAYOUT1_ECCN(x) (HW_BCH_FLASH2LAYOUT1(x).B.ECCN)

/*! @brief Format value for bitfield BCH_FLASH2LAYOUT1_ECCN. */
#define BF_BCH_FLASH2LAYOUT1_ECCN(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH2LAYOUT1_ECCN) & BM_BCH_FLASH2LAYOUT1_ECCN)

/*! @brief Set the ECCN field to a new value. */
#define BW_BCH_FLASH2LAYOUT1_ECCN(x, v) (HW_BCH_FLASH2LAYOUT1_WR(x, (HW_BCH_FLASH2LAYOUT1_RD(x) & ~BM_BCH_FLASH2LAYOUT1_ECCN) | BF_BCH_FLASH2LAYOUT1_ECCN(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH2LAYOUT1, field PAGE_SIZE[31:16] (RW)
 *
 * Indicates the total size of the flash page (in bytes). This should be set to
 * the page size including spare area. The page size is programmable to
 * accomodate different flash configurations that may be available in the future.
 */
/*@{*/
#define BP_BCH_FLASH2LAYOUT1_PAGE_SIZE (16U) /*!< Bit position for BCH_FLASH2LAYOUT1_PAGE_SIZE. */
#define BM_BCH_FLASH2LAYOUT1_PAGE_SIZE (0xFFFF0000U) /*!< Bit mask for BCH_FLASH2LAYOUT1_PAGE_SIZE. */
#define BS_BCH_FLASH2LAYOUT1_PAGE_SIZE (16U) /*!< Bit field size in bits for BCH_FLASH2LAYOUT1_PAGE_SIZE. */

/*! @brief Read current value of the BCH_FLASH2LAYOUT1_PAGE_SIZE field. */
#define BR_BCH_FLASH2LAYOUT1_PAGE_SIZE(x) (HW_BCH_FLASH2LAYOUT1(x).B.PAGE_SIZE)

/*! @brief Format value for bitfield BCH_FLASH2LAYOUT1_PAGE_SIZE. */
#define BF_BCH_FLASH2LAYOUT1_PAGE_SIZE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH2LAYOUT1_PAGE_SIZE) & BM_BCH_FLASH2LAYOUT1_PAGE_SIZE)

/*! @brief Set the PAGE_SIZE field to a new value. */
#define BW_BCH_FLASH2LAYOUT1_PAGE_SIZE(x, v) (HW_BCH_FLASH2LAYOUT1_WR(x, (HW_BCH_FLASH2LAYOUT1_RD(x) & ~BM_BCH_FLASH2LAYOUT1_PAGE_SIZE) | BF_BCH_FLASH2LAYOUT1_PAGE_SIZE(v)))
/*@}*/




/*******************************************************************************
 * HW_BCH_FLASH3LAYOUT0 - Hardware BCH ECC Flash 3 Layout 0 Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_FLASH3LAYOUT0 - Hardware BCH ECC Flash 3 Layout 0 Register (RW)
 *
 * Reset value: 0x070A4080U
 *
 * The flash format register contains a description of the logical layout of
 * data on the flash device. This register is used in conjunction with the
 * FLASH3LAYOUT1 register to control the format for the devices selecting layout 3 in the
 * LAYOUTSELECT register. Each pair of layout registers describes one of four
 * supported flash configurations. Software should program the LAYOUTSELECT register
 * for each supported GPMI chip select to select from one of the four layout
 * values. Each pair of registers contains settings that are used by the BCH block
 * while reading / writing the flash page to control data, metadata, and flash
 * page sizes as well as the ECC correction level. The first block written to flash
 * can be programmed to have different ECC, metadata, and data sizes from
 * subsequent data blocks on the device. In addition, the number of blocks stored on a
 * page of flash is not fixed, but instead is determined by the number of bytes
 * consumed by the initial (block 0) and subsequent data blocks. See the BCH
 * programming reference manual for more information on setting up the flash layout
 * registers.
 */
typedef union _hw_bch_flash3layout0
{
    uint32_t U;
    struct _hw_bch_flash3layout0_bitfields
    {
        uint32_t DATA0_SIZE : 10;      /*!< [9:0]  */
        uint32_t GF13_0_GF14_1 : 1;    /*!< [10]  */
        uint32_t ECC0 : 5;             /*!< [15:11]  */
        uint32_t META_SIZE : 8;        /*!< [23:16]  */
        uint32_t NBLOCKS : 8;          /*!< [31:24]  */
    } B;
} hw_bch_flash3layout0_t;

/*!
 * @name Constants and macros for entire BCH_FLASH3LAYOUT0 register
 */
/*@{*/
#define HW_BCH_FLASH3LAYOUT0_ADDR(x) ((uintptr_t)(x) + 0xE0U)
#define HW_BCH_FLASH3LAYOUT0_SET_ADDR(x) (HW_BCH_FLASH3LAYOUT0_ADDR(x) + 0x4U)
#define HW_BCH_FLASH3LAYOUT0_CLR_ADDR(x) (HW_BCH_FLASH3LAYOUT0_ADDR(x) + 0x8U)
#define HW_BCH_FLASH3LAYOUT0_TOG_ADDR(x) (HW_BCH_FLASH3LAYOUT0_ADDR(x) + 0xCU)

#define HW_BCH_FLASH3LAYOUT0(x)  (*(__IO hw_bch_flash3layout0_t *) HW_BCH_FLASH3LAYOUT0_ADDR(x))
#define HW_BCH_FLASH3LAYOUT0_RD(x) (HW_BCH_FLASH3LAYOUT0(x).U)
#define HW_BCH_FLASH3LAYOUT0_WR(x, v) (HW_BCH_FLASH3LAYOUT0(x).U = (v))
#define HW_BCH_FLASH3LAYOUT0_SET(x, v) ((*(uint32_t *) HW_BCH_FLASH3LAYOUT0_SET_ADDR(x)) = (v))
#define HW_BCH_FLASH3LAYOUT0_CLR(x, v) ((*(uint32_t *) HW_BCH_FLASH3LAYOUT0_CLR_ADDR(x)) = (v))
#define HW_BCH_FLASH3LAYOUT0_TOG(x, v) ((*(uint32_t *) HW_BCH_FLASH3LAYOUT0_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual BCH_FLASH3LAYOUT0 bitfields
 */

/*!
 * @name Register BCH_FLASH3LAYOUT0, field DATA0_SIZE[9:0] (RW)
 *
 * Indicates the size of the data 0 block (in DWORDS / four bytes) to be stored
 * on the flash page. If set to 0, the first block will only contain metadata.
 */
/*@{*/
#define BP_BCH_FLASH3LAYOUT0_DATA0_SIZE (0U) /*!< Bit position for BCH_FLASH3LAYOUT0_DATA0_SIZE. */
#define BM_BCH_FLASH3LAYOUT0_DATA0_SIZE (0x000003FFU) /*!< Bit mask for BCH_FLASH3LAYOUT0_DATA0_SIZE. */
#define BS_BCH_FLASH3LAYOUT0_DATA0_SIZE (10U) /*!< Bit field size in bits for BCH_FLASH3LAYOUT0_DATA0_SIZE. */

/*! @brief Read current value of the BCH_FLASH3LAYOUT0_DATA0_SIZE field. */
#define BR_BCH_FLASH3LAYOUT0_DATA0_SIZE(x) (HW_BCH_FLASH3LAYOUT0(x).B.DATA0_SIZE)

/*! @brief Format value for bitfield BCH_FLASH3LAYOUT0_DATA0_SIZE. */
#define BF_BCH_FLASH3LAYOUT0_DATA0_SIZE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH3LAYOUT0_DATA0_SIZE) & BM_BCH_FLASH3LAYOUT0_DATA0_SIZE)

/*! @brief Set the DATA0_SIZE field to a new value. */
#define BW_BCH_FLASH3LAYOUT0_DATA0_SIZE(x, v) (HW_BCH_FLASH3LAYOUT0_WR(x, (HW_BCH_FLASH3LAYOUT0_RD(x) & ~BM_BCH_FLASH3LAYOUT0_DATA0_SIZE) | BF_BCH_FLASH3LAYOUT0_DATA0_SIZE(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH3LAYOUT0, field GF13_0_GF14_1[10] (RW)
 *
 * Select GF13 or GF14: 0-GF13; 1-GF14
 */
/*@{*/
#define BP_BCH_FLASH3LAYOUT0_GF13_0_GF14_1 (10U) /*!< Bit position for BCH_FLASH3LAYOUT0_GF13_0_GF14_1. */
#define BM_BCH_FLASH3LAYOUT0_GF13_0_GF14_1 (0x00000400U) /*!< Bit mask for BCH_FLASH3LAYOUT0_GF13_0_GF14_1. */
#define BS_BCH_FLASH3LAYOUT0_GF13_0_GF14_1 (1U) /*!< Bit field size in bits for BCH_FLASH3LAYOUT0_GF13_0_GF14_1. */

/*! @brief Read current value of the BCH_FLASH3LAYOUT0_GF13_0_GF14_1 field. */
#define BR_BCH_FLASH3LAYOUT0_GF13_0_GF14_1(x) (HW_BCH_FLASH3LAYOUT0(x).B.GF13_0_GF14_1)

/*! @brief Format value for bitfield BCH_FLASH3LAYOUT0_GF13_0_GF14_1. */
#define BF_BCH_FLASH3LAYOUT0_GF13_0_GF14_1(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH3LAYOUT0_GF13_0_GF14_1) & BM_BCH_FLASH3LAYOUT0_GF13_0_GF14_1)

/*! @brief Set the GF13_0_GF14_1 field to a new value. */
#define BW_BCH_FLASH3LAYOUT0_GF13_0_GF14_1(x, v) (HW_BCH_FLASH3LAYOUT0_WR(x, (HW_BCH_FLASH3LAYOUT0_RD(x) & ~BM_BCH_FLASH3LAYOUT0_GF13_0_GF14_1) | BF_BCH_FLASH3LAYOUT0_GF13_0_GF14_1(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH3LAYOUT0, field ECC0[15:11] (RW)
 *
 * Indicates the ECC level for the first block on the flash page. The first
 * block covers metadata plus the associated data from the DATA0_SIZE field.
 *
 * Values:
 * - 0 - No ECC to be performed
 * - 1 - ECC 2 to be performed
 * - 10 - ECC 4 to be performed
 * - 11110 - ECC 60 to be performed
 * - 11111 - ECC 62 to be performed
 */
/*@{*/
#define BP_BCH_FLASH3LAYOUT0_ECC0 (11U)    /*!< Bit position for BCH_FLASH3LAYOUT0_ECC0. */
#define BM_BCH_FLASH3LAYOUT0_ECC0 (0x0000F800U) /*!< Bit mask for BCH_FLASH3LAYOUT0_ECC0. */
#define BS_BCH_FLASH3LAYOUT0_ECC0 (5U)     /*!< Bit field size in bits for BCH_FLASH3LAYOUT0_ECC0. */

#define BV_BCH_FLASH3LAYOUT0_ECC0_NONE (0U)          /*!< Bit field value for BCH_FLASH3LAYOUT0_ECC0: No ECC to be performed */
#define BV_BCH_FLASH3LAYOUT0_ECC0_ECC2 (0x1U)        /*!< Bit field value for BCH_FLASH3LAYOUT0_ECC0: ECC 2 to be performed */
#define BV_BCH_FLASH3LAYOUT0_ECC0_ECC4 (0x2U)        /*!< Bit field value for BCH_FLASH3LAYOUT0_ECC0: ECC 4 to be performed */
#define BV_BCH_FLASH3LAYOUT0_ECC0_ECC60 (0x1EU)      /*!< Bit field value for BCH_FLASH3LAYOUT0_ECC0: ECC 60 to be performed */
#define BV_BCH_FLASH3LAYOUT0_ECC0_ECC62 (0x1FU)      /*!< Bit field value for BCH_FLASH3LAYOUT0_ECC0: ECC 62 to be performed */

/*! @brief Read current value of the BCH_FLASH3LAYOUT0_ECC0 field. */
#define BR_BCH_FLASH3LAYOUT0_ECC0(x) (HW_BCH_FLASH3LAYOUT0(x).B.ECC0)

/*! @brief Format value for bitfield BCH_FLASH3LAYOUT0_ECC0. */
#define BF_BCH_FLASH3LAYOUT0_ECC0(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH3LAYOUT0_ECC0) & BM_BCH_FLASH3LAYOUT0_ECC0)

/*! @brief Set the ECC0 field to a new value. */
#define BW_BCH_FLASH3LAYOUT0_ECC0(x, v) (HW_BCH_FLASH3LAYOUT0_WR(x, (HW_BCH_FLASH3LAYOUT0_RD(x) & ~BM_BCH_FLASH3LAYOUT0_ECC0) | BF_BCH_FLASH3LAYOUT0_ECC0(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH3LAYOUT0, field META_SIZE[23:16] (RW)
 *
 * Indicates the size of the metadata (in bytes) to be stored on a flash page.
 * The BCH design support from 0 to 255 bytes for metadata-if set to 0, no
 * metadata will be stored. Metadata is stored before the associated data in block 0. If
 * the DATA0_SIZE field is programmed to a 0, then metadata effectively be
 * stored with its own parity. When both the metadata and data0 fields are programmed
 * with non-zero values, the first block will contain both portions of data and
 * will be covered by a single parity block.
 */
/*@{*/
#define BP_BCH_FLASH3LAYOUT0_META_SIZE (16U) /*!< Bit position for BCH_FLASH3LAYOUT0_META_SIZE. */
#define BM_BCH_FLASH3LAYOUT0_META_SIZE (0x00FF0000U) /*!< Bit mask for BCH_FLASH3LAYOUT0_META_SIZE. */
#define BS_BCH_FLASH3LAYOUT0_META_SIZE (8U) /*!< Bit field size in bits for BCH_FLASH3LAYOUT0_META_SIZE. */

/*! @brief Read current value of the BCH_FLASH3LAYOUT0_META_SIZE field. */
#define BR_BCH_FLASH3LAYOUT0_META_SIZE(x) (HW_BCH_FLASH3LAYOUT0(x).B.META_SIZE)

/*! @brief Format value for bitfield BCH_FLASH3LAYOUT0_META_SIZE. */
#define BF_BCH_FLASH3LAYOUT0_META_SIZE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH3LAYOUT0_META_SIZE) & BM_BCH_FLASH3LAYOUT0_META_SIZE)

/*! @brief Set the META_SIZE field to a new value. */
#define BW_BCH_FLASH3LAYOUT0_META_SIZE(x, v) (HW_BCH_FLASH3LAYOUT0_WR(x, (HW_BCH_FLASH3LAYOUT0_RD(x) & ~BM_BCH_FLASH3LAYOUT0_META_SIZE) | BF_BCH_FLASH3LAYOUT0_META_SIZE(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH3LAYOUT0, field NBLOCKS[31:24] (RW)
 *
 * Number of subsequent blocks on the flash page (excluding the data0 block). A
 * value of 0 indicates that only the DATA0 block is present and a value of 8
 * indicates that 8 subsequent blocks are present for a total of 9 blocks on the
 * flash (including the DATA0 block). Any values from 0 to 255 are supported by the
 * hardware.
 */
/*@{*/
#define BP_BCH_FLASH3LAYOUT0_NBLOCKS (24U) /*!< Bit position for BCH_FLASH3LAYOUT0_NBLOCKS. */
#define BM_BCH_FLASH3LAYOUT0_NBLOCKS (0xFF000000U) /*!< Bit mask for BCH_FLASH3LAYOUT0_NBLOCKS. */
#define BS_BCH_FLASH3LAYOUT0_NBLOCKS (8U)  /*!< Bit field size in bits for BCH_FLASH3LAYOUT0_NBLOCKS. */

/*! @brief Read current value of the BCH_FLASH3LAYOUT0_NBLOCKS field. */
#define BR_BCH_FLASH3LAYOUT0_NBLOCKS(x) (HW_BCH_FLASH3LAYOUT0(x).B.NBLOCKS)

/*! @brief Format value for bitfield BCH_FLASH3LAYOUT0_NBLOCKS. */
#define BF_BCH_FLASH3LAYOUT0_NBLOCKS(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH3LAYOUT0_NBLOCKS) & BM_BCH_FLASH3LAYOUT0_NBLOCKS)

/*! @brief Set the NBLOCKS field to a new value. */
#define BW_BCH_FLASH3LAYOUT0_NBLOCKS(x, v) (HW_BCH_FLASH3LAYOUT0_WR(x, (HW_BCH_FLASH3LAYOUT0_RD(x) & ~BM_BCH_FLASH3LAYOUT0_NBLOCKS) | BF_BCH_FLASH3LAYOUT0_NBLOCKS(v)))
/*@}*/




/*******************************************************************************
 * HW_BCH_FLASH3LAYOUT1 - Hardware BCH ECC Flash 3 Layout 1 Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_FLASH3LAYOUT1 - Hardware BCH ECC Flash 3 Layout 1 Register (RW)
 *
 * Reset value: 0x10DA4080U
 *
 * The flash format register contains a description of the logical layout of
 * data on the flash device. This register is used in conjunction with the
 * FLASH3LAYOUT0 register to control the format for the device selecting layout 3 in the
 * LAYOUTSELECT register.
 */
typedef union _hw_bch_flash3layout1
{
    uint32_t U;
    struct _hw_bch_flash3layout1_bitfields
    {
        uint32_t DATAN_SIZE : 10;      /*!< [9:0]  */
        uint32_t GF13_0_GF14_1 : 1;    /*!< [10]  */
        uint32_t ECCN : 5;             /*!< [15:11]  */
        uint32_t PAGE_SIZE : 16;       /*!< [31:16]  */
    } B;
} hw_bch_flash3layout1_t;

/*!
 * @name Constants and macros for entire BCH_FLASH3LAYOUT1 register
 */
/*@{*/
#define HW_BCH_FLASH3LAYOUT1_ADDR(x) ((uintptr_t)(x) + 0xF0U)
#define HW_BCH_FLASH3LAYOUT1_SET_ADDR(x) (HW_BCH_FLASH3LAYOUT1_ADDR(x) + 0x4U)
#define HW_BCH_FLASH3LAYOUT1_CLR_ADDR(x) (HW_BCH_FLASH3LAYOUT1_ADDR(x) + 0x8U)
#define HW_BCH_FLASH3LAYOUT1_TOG_ADDR(x) (HW_BCH_FLASH3LAYOUT1_ADDR(x) + 0xCU)

#define HW_BCH_FLASH3LAYOUT1(x)  (*(__IO hw_bch_flash3layout1_t *) HW_BCH_FLASH3LAYOUT1_ADDR(x))
#define HW_BCH_FLASH3LAYOUT1_RD(x) (HW_BCH_FLASH3LAYOUT1(x).U)
#define HW_BCH_FLASH3LAYOUT1_WR(x, v) (HW_BCH_FLASH3LAYOUT1(x).U = (v))
#define HW_BCH_FLASH3LAYOUT1_SET(x, v) ((*(uint32_t *) HW_BCH_FLASH3LAYOUT1_SET_ADDR(x)) = (v))
#define HW_BCH_FLASH3LAYOUT1_CLR(x, v) ((*(uint32_t *) HW_BCH_FLASH3LAYOUT1_CLR_ADDR(x)) = (v))
#define HW_BCH_FLASH3LAYOUT1_TOG(x, v) ((*(uint32_t *) HW_BCH_FLASH3LAYOUT1_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual BCH_FLASH3LAYOUT1 bitfields
 */

/*!
 * @name Register BCH_FLASH3LAYOUT1, field DATAN_SIZE[9:0] (RW)
 *
 * Indicates the size of the subsequent data blocks (in DWORDS / four bytes) to
 * be stored on the flash page. The size of subsequent data blocks does not have
 * to match the data size for block 0, which is important when metadata is stored
 * separately or for balancing the amount of data stored in each block.
 */
/*@{*/
#define BP_BCH_FLASH3LAYOUT1_DATAN_SIZE (0U) /*!< Bit position for BCH_FLASH3LAYOUT1_DATAN_SIZE. */
#define BM_BCH_FLASH3LAYOUT1_DATAN_SIZE (0x000003FFU) /*!< Bit mask for BCH_FLASH3LAYOUT1_DATAN_SIZE. */
#define BS_BCH_FLASH3LAYOUT1_DATAN_SIZE (10U) /*!< Bit field size in bits for BCH_FLASH3LAYOUT1_DATAN_SIZE. */

/*! @brief Read current value of the BCH_FLASH3LAYOUT1_DATAN_SIZE field. */
#define BR_BCH_FLASH3LAYOUT1_DATAN_SIZE(x) (HW_BCH_FLASH3LAYOUT1(x).B.DATAN_SIZE)

/*! @brief Format value for bitfield BCH_FLASH3LAYOUT1_DATAN_SIZE. */
#define BF_BCH_FLASH3LAYOUT1_DATAN_SIZE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH3LAYOUT1_DATAN_SIZE) & BM_BCH_FLASH3LAYOUT1_DATAN_SIZE)

/*! @brief Set the DATAN_SIZE field to a new value. */
#define BW_BCH_FLASH3LAYOUT1_DATAN_SIZE(x, v) (HW_BCH_FLASH3LAYOUT1_WR(x, (HW_BCH_FLASH3LAYOUT1_RD(x) & ~BM_BCH_FLASH3LAYOUT1_DATAN_SIZE) | BF_BCH_FLASH3LAYOUT1_DATAN_SIZE(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH3LAYOUT1, field GF13_0_GF14_1[10] (RW)
 *
 * Select GF13 or GF14: 0-GF13; 1-GF14
 */
/*@{*/
#define BP_BCH_FLASH3LAYOUT1_GF13_0_GF14_1 (10U) /*!< Bit position for BCH_FLASH3LAYOUT1_GF13_0_GF14_1. */
#define BM_BCH_FLASH3LAYOUT1_GF13_0_GF14_1 (0x00000400U) /*!< Bit mask for BCH_FLASH3LAYOUT1_GF13_0_GF14_1. */
#define BS_BCH_FLASH3LAYOUT1_GF13_0_GF14_1 (1U) /*!< Bit field size in bits for BCH_FLASH3LAYOUT1_GF13_0_GF14_1. */

/*! @brief Read current value of the BCH_FLASH3LAYOUT1_GF13_0_GF14_1 field. */
#define BR_BCH_FLASH3LAYOUT1_GF13_0_GF14_1(x) (HW_BCH_FLASH3LAYOUT1(x).B.GF13_0_GF14_1)

/*! @brief Format value for bitfield BCH_FLASH3LAYOUT1_GF13_0_GF14_1. */
#define BF_BCH_FLASH3LAYOUT1_GF13_0_GF14_1(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH3LAYOUT1_GF13_0_GF14_1) & BM_BCH_FLASH3LAYOUT1_GF13_0_GF14_1)

/*! @brief Set the GF13_0_GF14_1 field to a new value. */
#define BW_BCH_FLASH3LAYOUT1_GF13_0_GF14_1(x, v) (HW_BCH_FLASH3LAYOUT1_WR(x, (HW_BCH_FLASH3LAYOUT1_RD(x) & ~BM_BCH_FLASH3LAYOUT1_GF13_0_GF14_1) | BF_BCH_FLASH3LAYOUT1_GF13_0_GF14_1(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH3LAYOUT1, field ECCN[15:11] (RW)
 *
 * Indicates the ECC level for the subsequent blocks on the flash page (blocks
 * 1-n). Subsequent blocks only contain data (no metadata).
 *
 * Values:
 * - 0 - No ECC to be performed
 * - 1 - ECC 2 to be performed
 * - 10 - ECC 4 to be performed
 * - 11110 - ECC 60 to be performed
 * - 11111 - ECC 62 to be performed
 */
/*@{*/
#define BP_BCH_FLASH3LAYOUT1_ECCN (11U)    /*!< Bit position for BCH_FLASH3LAYOUT1_ECCN. */
#define BM_BCH_FLASH3LAYOUT1_ECCN (0x0000F800U) /*!< Bit mask for BCH_FLASH3LAYOUT1_ECCN. */
#define BS_BCH_FLASH3LAYOUT1_ECCN (5U)     /*!< Bit field size in bits for BCH_FLASH3LAYOUT1_ECCN. */

#define BV_BCH_FLASH3LAYOUT1_ECCN_NONE (0U)          /*!< Bit field value for BCH_FLASH3LAYOUT1_ECCN: No ECC to be performed */
#define BV_BCH_FLASH3LAYOUT1_ECCN_ECC2 (0x1U)        /*!< Bit field value for BCH_FLASH3LAYOUT1_ECCN: ECC 2 to be performed */
#define BV_BCH_FLASH3LAYOUT1_ECCN_ECC4 (0x2U)        /*!< Bit field value for BCH_FLASH3LAYOUT1_ECCN: ECC 4 to be performed */
#define BV_BCH_FLASH3LAYOUT1_ECCN_ECC60 (0x1EU)      /*!< Bit field value for BCH_FLASH3LAYOUT1_ECCN: ECC 60 to be performed */
#define BV_BCH_FLASH3LAYOUT1_ECCN_ECC62 (0x1FU)      /*!< Bit field value for BCH_FLASH3LAYOUT1_ECCN: ECC 62 to be performed */

/*! @brief Read current value of the BCH_FLASH3LAYOUT1_ECCN field. */
#define BR_BCH_FLASH3LAYOUT1_ECCN(x) (HW_BCH_FLASH3LAYOUT1(x).B.ECCN)

/*! @brief Format value for bitfield BCH_FLASH3LAYOUT1_ECCN. */
#define BF_BCH_FLASH3LAYOUT1_ECCN(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH3LAYOUT1_ECCN) & BM_BCH_FLASH3LAYOUT1_ECCN)

/*! @brief Set the ECCN field to a new value. */
#define BW_BCH_FLASH3LAYOUT1_ECCN(x, v) (HW_BCH_FLASH3LAYOUT1_WR(x, (HW_BCH_FLASH3LAYOUT1_RD(x) & ~BM_BCH_FLASH3LAYOUT1_ECCN) | BF_BCH_FLASH3LAYOUT1_ECCN(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH3LAYOUT1, field PAGE_SIZE[31:16] (RW)
 *
 * Indicates the total size of the flash page (in bytes). This should be set to
 * the page size including spare area. The page size is programmable to
 * accomodate different flash configurations that may be available in the future.
 */
/*@{*/
#define BP_BCH_FLASH3LAYOUT1_PAGE_SIZE (16U) /*!< Bit position for BCH_FLASH3LAYOUT1_PAGE_SIZE. */
#define BM_BCH_FLASH3LAYOUT1_PAGE_SIZE (0xFFFF0000U) /*!< Bit mask for BCH_FLASH3LAYOUT1_PAGE_SIZE. */
#define BS_BCH_FLASH3LAYOUT1_PAGE_SIZE (16U) /*!< Bit field size in bits for BCH_FLASH3LAYOUT1_PAGE_SIZE. */

/*! @brief Read current value of the BCH_FLASH3LAYOUT1_PAGE_SIZE field. */
#define BR_BCH_FLASH3LAYOUT1_PAGE_SIZE(x) (HW_BCH_FLASH3LAYOUT1(x).B.PAGE_SIZE)

/*! @brief Format value for bitfield BCH_FLASH3LAYOUT1_PAGE_SIZE. */
#define BF_BCH_FLASH3LAYOUT1_PAGE_SIZE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH3LAYOUT1_PAGE_SIZE) & BM_BCH_FLASH3LAYOUT1_PAGE_SIZE)

/*! @brief Set the PAGE_SIZE field to a new value. */
#define BW_BCH_FLASH3LAYOUT1_PAGE_SIZE(x, v) (HW_BCH_FLASH3LAYOUT1_WR(x, (HW_BCH_FLASH3LAYOUT1_RD(x) & ~BM_BCH_FLASH3LAYOUT1_PAGE_SIZE) | BF_BCH_FLASH3LAYOUT1_PAGE_SIZE(v)))
/*@}*/




/*******************************************************************************
 * HW_BCH_DEBUG0 - Hardware BCH ECC Debug Register0
 ******************************************************************************/

/*!
 * @brief HW_BCH_DEBUG0 - Hardware BCH ECC Debug Register0 (RW)
 *
 * Reset value: 0x00000000U
 *
 * The hardware BCH accelerator internal state machines and signals can be seen
 * in the ECC debug register. The BCH_DEBUG0 register provides access to various
 * internal state information which might prove useful during hardware debug and
 * validation.
 */
typedef union _hw_bch_debug0
{
    uint32_t U;
    struct _hw_bch_debug0_bitfields
    {
        uint32_t DEBUG_REG_SELECT : 6; /*!< [5:0]  */
        uint32_t RSVD0 : 2;            /*!< [7:6] This field is reserved. */
        uint32_t BM_KES_TEST_BYPASS : 1; /*!< [8]  */
        uint32_t KES_DEBUG_STALL : 1;  /*!< [9]  */
        uint32_t KES_DEBUG_STEP : 1;   /*!< [10]  */
        uint32_t KES_STANDALONE : 1;   /*!< [11]  */
        uint32_t KES_DEBUG_KICK : 1;   /*!< [12]  */
        uint32_t KES_DEBUG_MODE4K : 1; /*!< [13]  */
        uint32_t KES_DEBUG_PAYLOAD_FLAG : 1; /*!< [14]  */
        uint32_t KES_DEBUG_SHIFT_SYND : 1; /*!< [15]  */
        uint32_t KES_DEBUG_SYNDROME_SYMBOL : 9; /*!< [24:16]  */
        uint32_t RSVD1 : 7;            /*!< [31:25] This field is reserved. */
    } B;
} hw_bch_debug0_t;

/*!
 * @name Constants and macros for entire BCH_DEBUG0 register
 */
/*@{*/
#define HW_BCH_DEBUG0_ADDR(x)    ((uintptr_t)(x) + 0x100U)
#define HW_BCH_DEBUG0_SET_ADDR(x) (HW_BCH_DEBUG0_ADDR(x) + 0x4U)
#define HW_BCH_DEBUG0_CLR_ADDR(x) (HW_BCH_DEBUG0_ADDR(x) + 0x8U)
#define HW_BCH_DEBUG0_TOG_ADDR(x) (HW_BCH_DEBUG0_ADDR(x) + 0xCU)

#define HW_BCH_DEBUG0(x)         (*(__IO hw_bch_debug0_t *) HW_BCH_DEBUG0_ADDR(x))
#define HW_BCH_DEBUG0_RD(x)      (HW_BCH_DEBUG0(x).U)
#define HW_BCH_DEBUG0_WR(x, v)   (HW_BCH_DEBUG0(x).U = (v))
#define HW_BCH_DEBUG0_SET(x, v)  ((*(uint32_t *) HW_BCH_DEBUG0_SET_ADDR(x)) = (v))
#define HW_BCH_DEBUG0_CLR(x, v)  ((*(uint32_t *) HW_BCH_DEBUG0_CLR_ADDR(x)) = (v))
#define HW_BCH_DEBUG0_TOG(x, v)  ((*(uint32_t *) HW_BCH_DEBUG0_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual BCH_DEBUG0 bitfields
 */

/*!
 * @name Register BCH_DEBUG0, field DEBUG_REG_SELECT[5:0] (RW)
 *
 * The value loaded in this bit field is used to select the internal register
 * state view of KES engine or the Chien search engine.
 */
/*@{*/
#define BP_BCH_DEBUG0_DEBUG_REG_SELECT (0U) /*!< Bit position for BCH_DEBUG0_DEBUG_REG_SELECT. */
#define BM_BCH_DEBUG0_DEBUG_REG_SELECT (0x0000003FU) /*!< Bit mask for BCH_DEBUG0_DEBUG_REG_SELECT. */
#define BS_BCH_DEBUG0_DEBUG_REG_SELECT (6U) /*!< Bit field size in bits for BCH_DEBUG0_DEBUG_REG_SELECT. */

/*! @brief Read current value of the BCH_DEBUG0_DEBUG_REG_SELECT field. */
#define BR_BCH_DEBUG0_DEBUG_REG_SELECT(x) (HW_BCH_DEBUG0(x).B.DEBUG_REG_SELECT)

/*! @brief Format value for bitfield BCH_DEBUG0_DEBUG_REG_SELECT. */
#define BF_BCH_DEBUG0_DEBUG_REG_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_BCH_DEBUG0_DEBUG_REG_SELECT) & BM_BCH_DEBUG0_DEBUG_REG_SELECT)

/*! @brief Set the DEBUG_REG_SELECT field to a new value. */
#define BW_BCH_DEBUG0_DEBUG_REG_SELECT(x, v) (HW_BCH_DEBUG0_WR(x, (HW_BCH_DEBUG0_RD(x) & ~BM_BCH_DEBUG0_DEBUG_REG_SELECT) | BF_BCH_DEBUG0_DEBUG_REG_SELECT(v)))
/*@}*/

/*!
 * @name Register BCH_DEBUG0, field RSVD0[7:6] (RO)
 *
 * This read-only field is reserved and always has the value 0.
 */
/*@{*/
#define BP_BCH_DEBUG0_RSVD0  (6U)          /*!< Bit position for BCH_DEBUG0_RSVD0. */
#define BM_BCH_DEBUG0_RSVD0  (0x000000C0U) /*!< Bit mask for BCH_DEBUG0_RSVD0. */
#define BS_BCH_DEBUG0_RSVD0  (2U)          /*!< Bit field size in bits for BCH_DEBUG0_RSVD0. */

/*! @brief Read current value of the BCH_DEBUG0_RSVD0 field. */
#define BR_BCH_DEBUG0_RSVD0(x) (HW_BCH_DEBUG0(x).B.RSVD0)
/*@}*/

/*!
 * @name Register BCH_DEBUG0, field BM_KES_TEST_BYPASS[8] (RW)
 *
 * 1 = Point all SYND_GEN writes to dummy area at the end of the AUXILLIARY
 * block so that diagnostics can preload all payload, parity bytes and computed
 * syndrome bytes for test the KES engine.
 *
 * Values:
 * - 0 - Bus master address generator for SYND_GEN writes operates normally.
 * - 1 - Bus master address generator always addresses last four bytes in
 *     Auxiliary block.
 */
/*@{*/
#define BP_BCH_DEBUG0_BM_KES_TEST_BYPASS (8U) /*!< Bit position for BCH_DEBUG0_BM_KES_TEST_BYPASS. */
#define BM_BCH_DEBUG0_BM_KES_TEST_BYPASS (0x00000100U) /*!< Bit mask for BCH_DEBUG0_BM_KES_TEST_BYPASS. */
#define BS_BCH_DEBUG0_BM_KES_TEST_BYPASS (1U) /*!< Bit field size in bits for BCH_DEBUG0_BM_KES_TEST_BYPASS. */

#define BV_BCH_DEBUG0_BM_KES_TEST_BYPASS_NORMAL (0U) /*!< Bit field value for BCH_DEBUG0_BM_KES_TEST_BYPASS: Bus master address generator for SYND_GEN writes operates normally. */
#define BV_BCH_DEBUG0_BM_KES_TEST_BYPASS_TEST_MODE (0x1U) /*!< Bit field value for BCH_DEBUG0_BM_KES_TEST_BYPASS: Bus master address generator always addresses last four bytes in Auxiliary block. */

/*! @brief Read current value of the BCH_DEBUG0_BM_KES_TEST_BYPASS field. */
#define BR_BCH_DEBUG0_BM_KES_TEST_BYPASS(x) (HW_BCH_DEBUG0(x).B.BM_KES_TEST_BYPASS)

/*! @brief Format value for bitfield BCH_DEBUG0_BM_KES_TEST_BYPASS. */
#define BF_BCH_DEBUG0_BM_KES_TEST_BYPASS(v) ((uint32_t)((uint32_t)(v) << BP_BCH_DEBUG0_BM_KES_TEST_BYPASS) & BM_BCH_DEBUG0_BM_KES_TEST_BYPASS)

/*! @brief Set the BM_KES_TEST_BYPASS field to a new value. */
#define BW_BCH_DEBUG0_BM_KES_TEST_BYPASS(x, v) (HW_BCH_DEBUG0_WR(x, (HW_BCH_DEBUG0_RD(x) & ~BM_BCH_DEBUG0_BM_KES_TEST_BYPASS) | BF_BCH_DEBUG0_BM_KES_TEST_BYPASS(v)))
/*@}*/

/*!
 * @name Register BCH_DEBUG0, field KES_DEBUG_STALL[9] (RW)
 *
 * Set to one to cause KES FSM to stall after notifying Chien search engine to
 * start processing its block but before notifying the bus master that the KES
 * computation is complete. This allows a diagnostic to stall the FSM after each
 * blocks key equations are solved. This also has the effect of stalling the CSFE
 * search engine so it's state can be examined after it finishes processing the KES
 * stalled block.
 *
 * Values:
 * - 0 - KES FSM proceeds to next block supplied by bus master.
 * - 1 - KES FSM waits after current equations are solved and the search engine
 *     is started.
 */
/*@{*/
#define BP_BCH_DEBUG0_KES_DEBUG_STALL (9U) /*!< Bit position for BCH_DEBUG0_KES_DEBUG_STALL. */
#define BM_BCH_DEBUG0_KES_DEBUG_STALL (0x00000200U) /*!< Bit mask for BCH_DEBUG0_KES_DEBUG_STALL. */
#define BS_BCH_DEBUG0_KES_DEBUG_STALL (1U) /*!< Bit field size in bits for BCH_DEBUG0_KES_DEBUG_STALL. */

#define BV_BCH_DEBUG0_KES_DEBUG_STALL_NORMAL (0U)    /*!< Bit field value for BCH_DEBUG0_KES_DEBUG_STALL: KES FSM proceeds to next block supplied by bus master. */
#define BV_BCH_DEBUG0_KES_DEBUG_STALL_WAIT (0x1U)    /*!< Bit field value for BCH_DEBUG0_KES_DEBUG_STALL: KES FSM waits after current equations are solved and the search engine is started. */

/*! @brief Read current value of the BCH_DEBUG0_KES_DEBUG_STALL field. */
#define BR_BCH_DEBUG0_KES_DEBUG_STALL(x) (HW_BCH_DEBUG0(x).B.KES_DEBUG_STALL)

/*! @brief Format value for bitfield BCH_DEBUG0_KES_DEBUG_STALL. */
#define BF_BCH_DEBUG0_KES_DEBUG_STALL(v) ((uint32_t)((uint32_t)(v) << BP_BCH_DEBUG0_KES_DEBUG_STALL) & BM_BCH_DEBUG0_KES_DEBUG_STALL)

/*! @brief Set the KES_DEBUG_STALL field to a new value. */
#define BW_BCH_DEBUG0_KES_DEBUG_STALL(x, v) (HW_BCH_DEBUG0_WR(x, (HW_BCH_DEBUG0_RD(x) & ~BM_BCH_DEBUG0_KES_DEBUG_STALL) | BF_BCH_DEBUG0_KES_DEBUG_STALL(v)))
/*@}*/

/*!
 * @name Register BCH_DEBUG0, field KES_DEBUG_STEP[10] (RW)
 *
 * Toggling this bit causes the KES FSM to skip passed the stall state if it is
 * in DEBUG_STALL mode and completed processing a block.
 */
/*@{*/
#define BP_BCH_DEBUG0_KES_DEBUG_STEP (10U) /*!< Bit position for BCH_DEBUG0_KES_DEBUG_STEP. */
#define BM_BCH_DEBUG0_KES_DEBUG_STEP (0x00000400U) /*!< Bit mask for BCH_DEBUG0_KES_DEBUG_STEP. */
#define BS_BCH_DEBUG0_KES_DEBUG_STEP (1U)  /*!< Bit field size in bits for BCH_DEBUG0_KES_DEBUG_STEP. */

/*! @brief Read current value of the BCH_DEBUG0_KES_DEBUG_STEP field. */
#define BR_BCH_DEBUG0_KES_DEBUG_STEP(x) (HW_BCH_DEBUG0(x).B.KES_DEBUG_STEP)

/*! @brief Format value for bitfield BCH_DEBUG0_KES_DEBUG_STEP. */
#define BF_BCH_DEBUG0_KES_DEBUG_STEP(v) ((uint32_t)((uint32_t)(v) << BP_BCH_DEBUG0_KES_DEBUG_STEP) & BM_BCH_DEBUG0_KES_DEBUG_STEP)

/*! @brief Set the KES_DEBUG_STEP field to a new value. */
#define BW_BCH_DEBUG0_KES_DEBUG_STEP(x, v) (HW_BCH_DEBUG0_WR(x, (HW_BCH_DEBUG0_RD(x) & ~BM_BCH_DEBUG0_KES_DEBUG_STEP) | BF_BCH_DEBUG0_KES_DEBUG_STEP(v)))
/*@}*/

/*!
 * @name Register BCH_DEBUG0, field KES_STANDALONE[11] (RW)
 *
 * Set to one, cause the KES engine to suppress toggling the KES_BM_DONE signal
 * to the bus master and suppress toggling the CF_BM_DONE signal by the CF engine.
 *
 * Values:
 * - 0 - Bus master address generator for SYND_GEN writes operates normally.
 * - 1 - Bus master address generator always addresses last four bytes in
 *     Auxiliary block.
 */
/*@{*/
#define BP_BCH_DEBUG0_KES_STANDALONE (11U) /*!< Bit position for BCH_DEBUG0_KES_STANDALONE. */
#define BM_BCH_DEBUG0_KES_STANDALONE (0x00000800U) /*!< Bit mask for BCH_DEBUG0_KES_STANDALONE. */
#define BS_BCH_DEBUG0_KES_STANDALONE (1U)  /*!< Bit field size in bits for BCH_DEBUG0_KES_STANDALONE. */

#define BV_BCH_DEBUG0_KES_STANDALONE_NORMAL (0U)     /*!< Bit field value for BCH_DEBUG0_KES_STANDALONE: Bus master address generator for SYND_GEN writes operates normally. */
#define BV_BCH_DEBUG0_KES_STANDALONE_TEST_MODE (0x1U) /*!< Bit field value for BCH_DEBUG0_KES_STANDALONE: Bus master address generator always addresses last four bytes in Auxiliary block. */

/*! @brief Read current value of the BCH_DEBUG0_KES_STANDALONE field. */
#define BR_BCH_DEBUG0_KES_STANDALONE(x) (HW_BCH_DEBUG0(x).B.KES_STANDALONE)

/*! @brief Format value for bitfield BCH_DEBUG0_KES_STANDALONE. */
#define BF_BCH_DEBUG0_KES_STANDALONE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_DEBUG0_KES_STANDALONE) & BM_BCH_DEBUG0_KES_STANDALONE)

/*! @brief Set the KES_STANDALONE field to a new value. */
#define BW_BCH_DEBUG0_KES_STANDALONE(x, v) (HW_BCH_DEBUG0_WR(x, (HW_BCH_DEBUG0_RD(x) & ~BM_BCH_DEBUG0_KES_STANDALONE) | BF_BCH_DEBUG0_KES_STANDALONE(v)))
/*@}*/

/*!
 * @name Register BCH_DEBUG0, field KES_DEBUG_KICK[12] (RW)
 *
 * Toggling causes KES engine FSM to start as if kick by the Bus Master. This
 * allows stand alone testing of the KES and Chien Search engines. Be sure to set
 * KES_BCH_DEBUG0_KES_STANDALONE mode to 1 before kicking.
 */
/*@{*/
#define BP_BCH_DEBUG0_KES_DEBUG_KICK (12U) /*!< Bit position for BCH_DEBUG0_KES_DEBUG_KICK. */
#define BM_BCH_DEBUG0_KES_DEBUG_KICK (0x00001000U) /*!< Bit mask for BCH_DEBUG0_KES_DEBUG_KICK. */
#define BS_BCH_DEBUG0_KES_DEBUG_KICK (1U)  /*!< Bit field size in bits for BCH_DEBUG0_KES_DEBUG_KICK. */

/*! @brief Read current value of the BCH_DEBUG0_KES_DEBUG_KICK field. */
#define BR_BCH_DEBUG0_KES_DEBUG_KICK(x) (HW_BCH_DEBUG0(x).B.KES_DEBUG_KICK)

/*! @brief Format value for bitfield BCH_DEBUG0_KES_DEBUG_KICK. */
#define BF_BCH_DEBUG0_KES_DEBUG_KICK(v) ((uint32_t)((uint32_t)(v) << BP_BCH_DEBUG0_KES_DEBUG_KICK) & BM_BCH_DEBUG0_KES_DEBUG_KICK)

/*! @brief Set the KES_DEBUG_KICK field to a new value. */
#define BW_BCH_DEBUG0_KES_DEBUG_KICK(x, v) (HW_BCH_DEBUG0_WR(x, (HW_BCH_DEBUG0_RD(x) & ~BM_BCH_DEBUG0_KES_DEBUG_KICK) | BF_BCH_DEBUG0_KES_DEBUG_KICK(v)))
/*@}*/

/*!
 * @name Register BCH_DEBUG0, field KES_DEBUG_MODE4K[13] (RW)
 *
 * When running the stand alone debug mode on the error calculator, the state of
 * this bit is presented to the KES engine as the input mode (4K or 2K pages).
 *
 * Values:
 * - 1 - Mode is set for 4K NAND pages.
 * - 1 - Mode is set for 2K NAND pages.
 */
/*@{*/
#define BP_BCH_DEBUG0_KES_DEBUG_MODE4K (13U) /*!< Bit position for BCH_DEBUG0_KES_DEBUG_MODE4K. */
#define BM_BCH_DEBUG0_KES_DEBUG_MODE4K (0x00002000U) /*!< Bit mask for BCH_DEBUG0_KES_DEBUG_MODE4K. */
#define BS_BCH_DEBUG0_KES_DEBUG_MODE4K (1U) /*!< Bit field size in bits for BCH_DEBUG0_KES_DEBUG_MODE4K. */

#define BV_BCH_DEBUG0_KES_DEBUG_MODE4K_4k (0x1U)     /*!< Bit field value for BCH_DEBUG0_KES_DEBUG_MODE4K: Mode is set for 4K NAND pages. */
#define BV_BCH_DEBUG0_KES_DEBUG_MODE4K_2k (0x1U)     /*!< Bit field value for BCH_DEBUG0_KES_DEBUG_MODE4K: Mode is set for 2K NAND pages. */

/*! @brief Read current value of the BCH_DEBUG0_KES_DEBUG_MODE4K field. */
#define BR_BCH_DEBUG0_KES_DEBUG_MODE4K(x) (HW_BCH_DEBUG0(x).B.KES_DEBUG_MODE4K)

/*! @brief Format value for bitfield BCH_DEBUG0_KES_DEBUG_MODE4K. */
#define BF_BCH_DEBUG0_KES_DEBUG_MODE4K(v) ((uint32_t)((uint32_t)(v) << BP_BCH_DEBUG0_KES_DEBUG_MODE4K) & BM_BCH_DEBUG0_KES_DEBUG_MODE4K)

/*! @brief Set the KES_DEBUG_MODE4K field to a new value. */
#define BW_BCH_DEBUG0_KES_DEBUG_MODE4K(x, v) (HW_BCH_DEBUG0_WR(x, (HW_BCH_DEBUG0_RD(x) & ~BM_BCH_DEBUG0_KES_DEBUG_MODE4K) | BF_BCH_DEBUG0_KES_DEBUG_MODE4K(v)))
/*@}*/

/*!
 * @name Register BCH_DEBUG0, field KES_DEBUG_PAYLOAD_FLAG[14] (RW)
 *
 * When running the stand alone debug mode on the error calculator, the state of
 * this bit is presented to the KES engine as the input payload flag.
 *
 * Values:
 * - 1 - Payload is set for 512 bytes data block.
 * - 1 - Payload is set for 65 or 19 bytes auxiliary block.
 */
/*@{*/
#define BP_BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG (14U) /*!< Bit position for BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG. */
#define BM_BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG (0x00004000U) /*!< Bit mask for BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG. */
#define BS_BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG (1U) /*!< Bit field size in bits for BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG. */

#define BV_BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG_DATA (0x1U) /*!< Bit field value for BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG: Payload is set for 512 bytes data block. */
#define BV_BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG_AUX (0x1U) /*!< Bit field value for BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG: Payload is set for 65 or 19 bytes auxiliary block. */

/*! @brief Read current value of the BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG field. */
#define BR_BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG(x) (HW_BCH_DEBUG0(x).B.KES_DEBUG_PAYLOAD_FLAG)

/*! @brief Format value for bitfield BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG. */
#define BF_BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG(v) ((uint32_t)((uint32_t)(v) << BP_BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG) & BM_BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG)

/*! @brief Set the KES_DEBUG_PAYLOAD_FLAG field to a new value. */
#define BW_BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG(x, v) (HW_BCH_DEBUG0_WR(x, (HW_BCH_DEBUG0_RD(x) & ~BM_BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG) | BF_BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG(v)))
/*@}*/

/*!
 * @name Register BCH_DEBUG0, field KES_DEBUG_SHIFT_SYND[15] (RW)
 *
 * Toggling this bit causes the value in BCH_DEBUG0_KES_SYNDROME_SYMBOL to be
 * shift into the syndrome register array at the input to the KES engine. After
 * shifting in 16 symbols, one can kick off both KES and CF cycles by toggling
 * BCH_DEBUG0_KES_DEBUG_KICK. Make sure that set KES_BCH_DEBUG0_KES_STANDALONE mode to
 * 1 before kicking.
 */
/*@{*/
#define BP_BCH_DEBUG0_KES_DEBUG_SHIFT_SYND (15U) /*!< Bit position for BCH_DEBUG0_KES_DEBUG_SHIFT_SYND. */
#define BM_BCH_DEBUG0_KES_DEBUG_SHIFT_SYND (0x00008000U) /*!< Bit mask for BCH_DEBUG0_KES_DEBUG_SHIFT_SYND. */
#define BS_BCH_DEBUG0_KES_DEBUG_SHIFT_SYND (1U) /*!< Bit field size in bits for BCH_DEBUG0_KES_DEBUG_SHIFT_SYND. */

/*! @brief Read current value of the BCH_DEBUG0_KES_DEBUG_SHIFT_SYND field. */
#define BR_BCH_DEBUG0_KES_DEBUG_SHIFT_SYND(x) (HW_BCH_DEBUG0(x).B.KES_DEBUG_SHIFT_SYND)

/*! @brief Format value for bitfield BCH_DEBUG0_KES_DEBUG_SHIFT_SYND. */
#define BF_BCH_DEBUG0_KES_DEBUG_SHIFT_SYND(v) ((uint32_t)((uint32_t)(v) << BP_BCH_DEBUG0_KES_DEBUG_SHIFT_SYND) & BM_BCH_DEBUG0_KES_DEBUG_SHIFT_SYND)

/*! @brief Set the KES_DEBUG_SHIFT_SYND field to a new value. */
#define BW_BCH_DEBUG0_KES_DEBUG_SHIFT_SYND(x, v) (HW_BCH_DEBUG0_WR(x, (HW_BCH_DEBUG0_RD(x) & ~BM_BCH_DEBUG0_KES_DEBUG_SHIFT_SYND) | BF_BCH_DEBUG0_KES_DEBUG_SHIFT_SYND(v)))
/*@}*/

/*!
 * @name Register BCH_DEBUG0, field KES_DEBUG_SYNDROME_SYMBOL[24:16] (RW)
 *
 * The 9 bit value in this bit field shifts into the syndrome register array at
 * the input of the KES engine whenever BCH_DEBUG0_KES_DEBUG_SHIFT_SYND is
 * toggled.
 *
 * Values:
 * - 0 - Bus master address generator for SYND_GEN writes operates normally.
 * - 1 - Bus master address generator always addresses last four bytes in
 *     Auxiliary block.
 */
/*@{*/
#define BP_BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL (16U) /*!< Bit position for BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL. */
#define BM_BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL (0x01FF0000U) /*!< Bit mask for BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL. */
#define BS_BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL (9U) /*!< Bit field size in bits for BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL. */

#define BV_BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL_NORMAL (0U) /*!< Bit field value for BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL: Bus master address generator for SYND_GEN writes operates normally. */
#define BV_BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL_TEST_MODE (0x1U) /*!< Bit field value for BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL: Bus master address generator always addresses last four bytes in Auxiliary block. */

/*! @brief Read current value of the BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL field. */
#define BR_BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL(x) (HW_BCH_DEBUG0(x).B.KES_DEBUG_SYNDROME_SYMBOL)

/*! @brief Format value for bitfield BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL. */
#define BF_BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL(v) ((uint32_t)((uint32_t)(v) << BP_BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL) & BM_BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL)

/*! @brief Set the KES_DEBUG_SYNDROME_SYMBOL field to a new value. */
#define BW_BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL(x, v) (HW_BCH_DEBUG0_WR(x, (HW_BCH_DEBUG0_RD(x) & ~BM_BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL) | BF_BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL(v)))
/*@}*/

/*!
 * @name Register BCH_DEBUG0, field RSVD1[31:25] (RO)
 *
 * This read-only field is reserved and always has the value 0.
 */
/*@{*/
#define BP_BCH_DEBUG0_RSVD1  (25U)         /*!< Bit position for BCH_DEBUG0_RSVD1. */
#define BM_BCH_DEBUG0_RSVD1  (0xFE000000U) /*!< Bit mask for BCH_DEBUG0_RSVD1. */
#define BS_BCH_DEBUG0_RSVD1  (7U)          /*!< Bit field size in bits for BCH_DEBUG0_RSVD1. */

/*! @brief Read current value of the BCH_DEBUG0_RSVD1 field. */
#define BR_BCH_DEBUG0_RSVD1(x) (HW_BCH_DEBUG0(x).B.RSVD1)
/*@}*/




/*******************************************************************************
 * HW_BCH_DBGKESREAD - KES Debug Read Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_DBGKESREAD - KES Debug Read Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * The hardware BCH ECC accelerator key equation solver internal state machines
 * and signals can be seen in the ECC debug registers.
 */
typedef union _hw_bch_dbgkesread
{
    uint32_t U;
    struct _hw_bch_dbgkesread_bitfields
    {
        uint32_t VALUES : 32;          /*!< [31:0]  */
    } B;
} hw_bch_dbgkesread_t;

/*!
 * @name Constants and macros for entire BCH_DBGKESREAD register
 */
/*@{*/
#define HW_BCH_DBGKESREAD_ADDR(x) ((uintptr_t)(x) + 0x110U)
#define HW_BCH_DBGKESREAD_SET_ADDR(x) (HW_BCH_DBGKESREAD_ADDR(x) + 0x4U)
#define HW_BCH_DBGKESREAD_CLR_ADDR(x) (HW_BCH_DBGKESREAD_ADDR(x) + 0x8U)
#define HW_BCH_DBGKESREAD_TOG_ADDR(x) (HW_BCH_DBGKESREAD_ADDR(x) + 0xCU)

#define HW_BCH_DBGKESREAD(x)     (*(__I hw_bch_dbgkesread_t *) HW_BCH_DBGKESREAD_ADDR(x))
#define HW_BCH_DBGKESREAD_RD(x)  (HW_BCH_DBGKESREAD(x).U)
/*@}*/

/*
 * Constants & macros for individual BCH_DBGKESREAD bitfields
 */

/*!
 * @name Register BCH_DBGKESREAD, field VALUES[31:0] (RO)
 *
 * This register returns the ROM BIST CRC value after a BIST test.
 */
/*@{*/
#define BP_BCH_DBGKESREAD_VALUES (0U)      /*!< Bit position for BCH_DBGKESREAD_VALUES. */
#define BM_BCH_DBGKESREAD_VALUES (0xFFFFFFFFU) /*!< Bit mask for BCH_DBGKESREAD_VALUES. */
#define BS_BCH_DBGKESREAD_VALUES (32U)     /*!< Bit field size in bits for BCH_DBGKESREAD_VALUES. */

/*! @brief Read current value of the BCH_DBGKESREAD_VALUES field. */
#define BR_BCH_DBGKESREAD_VALUES(x) (HW_BCH_DBGKESREAD(x).U)
/*@}*/




/*******************************************************************************
 * HW_BCH_DBGCSFEREAD - Chien Search Debug Read Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_DBGCSFEREAD - Chien Search Debug Read Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * The hardware BCH ECC accelerator Chien Search internal state machines and
 * signals can be seen in the ECC debug registers.
 */
typedef union _hw_bch_dbgcsferead
{
    uint32_t U;
    struct _hw_bch_dbgcsferead_bitfields
    {
        uint32_t VALUES : 32;          /*!< [31:0]  */
    } B;
} hw_bch_dbgcsferead_t;

/*!
 * @name Constants and macros for entire BCH_DBGCSFEREAD register
 */
/*@{*/
#define HW_BCH_DBGCSFEREAD_ADDR(x) ((uintptr_t)(x) + 0x120U)
#define HW_BCH_DBGCSFEREAD_SET_ADDR(x) (HW_BCH_DBGCSFEREAD_ADDR(x) + 0x4U)
#define HW_BCH_DBGCSFEREAD_CLR_ADDR(x) (HW_BCH_DBGCSFEREAD_ADDR(x) + 0x8U)
#define HW_BCH_DBGCSFEREAD_TOG_ADDR(x) (HW_BCH_DBGCSFEREAD_ADDR(x) + 0xCU)

#define HW_BCH_DBGCSFEREAD(x)    (*(__I hw_bch_dbgcsferead_t *) HW_BCH_DBGCSFEREAD_ADDR(x))
#define HW_BCH_DBGCSFEREAD_RD(x) (HW_BCH_DBGCSFEREAD(x).U)
/*@}*/

/*
 * Constants & macros for individual BCH_DBGCSFEREAD bitfields
 */

/*!
 * @name Register BCH_DBGCSFEREAD, field VALUES[31:0] (RO)
 *
 * Reserved
 */
/*@{*/
#define BP_BCH_DBGCSFEREAD_VALUES (0U)     /*!< Bit position for BCH_DBGCSFEREAD_VALUES. */
#define BM_BCH_DBGCSFEREAD_VALUES (0xFFFFFFFFU) /*!< Bit mask for BCH_DBGCSFEREAD_VALUES. */
#define BS_BCH_DBGCSFEREAD_VALUES (32U)    /*!< Bit field size in bits for BCH_DBGCSFEREAD_VALUES. */

/*! @brief Read current value of the BCH_DBGCSFEREAD_VALUES field. */
#define BR_BCH_DBGCSFEREAD_VALUES(x) (HW_BCH_DBGCSFEREAD(x).U)
/*@}*/




/*******************************************************************************
 * HW_BCH_DBGSYNDGENREAD - Syndrome Generator Debug Read Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_DBGSYNDGENREAD - Syndrome Generator Debug Read Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * The hardware BCH ECC accelerator syndrome generator internal state machines
 * and signals can be seen in the ECC debug registers.
 */
typedef union _hw_bch_dbgsyndgenread
{
    uint32_t U;
    struct _hw_bch_dbgsyndgenread_bitfields
    {
        uint32_t VALUES : 32;          /*!< [31:0]  */
    } B;
} hw_bch_dbgsyndgenread_t;

/*!
 * @name Constants and macros for entire BCH_DBGSYNDGENREAD register
 */
/*@{*/
#define HW_BCH_DBGSYNDGENREAD_ADDR(x) ((uintptr_t)(x) + 0x130U)
#define HW_BCH_DBGSYNDGENREAD_SET_ADDR(x) (HW_BCH_DBGSYNDGENREAD_ADDR(x) + 0x4U)
#define HW_BCH_DBGSYNDGENREAD_CLR_ADDR(x) (HW_BCH_DBGSYNDGENREAD_ADDR(x) + 0x8U)
#define HW_BCH_DBGSYNDGENREAD_TOG_ADDR(x) (HW_BCH_DBGSYNDGENREAD_ADDR(x) + 0xCU)

#define HW_BCH_DBGSYNDGENREAD(x) (*(__I hw_bch_dbgsyndgenread_t *) HW_BCH_DBGSYNDGENREAD_ADDR(x))
#define HW_BCH_DBGSYNDGENREAD_RD(x) (HW_BCH_DBGSYNDGENREAD(x).U)
/*@}*/

/*
 * Constants & macros for individual BCH_DBGSYNDGENREAD bitfields
 */

/*!
 * @name Register BCH_DBGSYNDGENREAD, field VALUES[31:0] (RO)
 *
 * Reserved
 */
/*@{*/
#define BP_BCH_DBGSYNDGENREAD_VALUES (0U)  /*!< Bit position for BCH_DBGSYNDGENREAD_VALUES. */
#define BM_BCH_DBGSYNDGENREAD_VALUES (0xFFFFFFFFU) /*!< Bit mask for BCH_DBGSYNDGENREAD_VALUES. */
#define BS_BCH_DBGSYNDGENREAD_VALUES (32U) /*!< Bit field size in bits for BCH_DBGSYNDGENREAD_VALUES. */

/*! @brief Read current value of the BCH_DBGSYNDGENREAD_VALUES field. */
#define BR_BCH_DBGSYNDGENREAD_VALUES(x) (HW_BCH_DBGSYNDGENREAD(x).U)
/*@}*/




/*******************************************************************************
 * HW_BCH_DBGAHBMREAD - Bus Master and ECC Controller Debug Read Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_DBGAHBMREAD - Bus Master and ECC Controller Debug Read Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * The hardware BCH ECC accelerator bus master, ECC controller internal state
 * machines, and signals can be seen in the ECC debug registers.
 */
typedef union _hw_bch_dbgahbmread
{
    uint32_t U;
    struct _hw_bch_dbgahbmread_bitfields
    {
        uint32_t VALUES : 32;          /*!< [31:0]  */
    } B;
} hw_bch_dbgahbmread_t;

/*!
 * @name Constants and macros for entire BCH_DBGAHBMREAD register
 */
/*@{*/
#define HW_BCH_DBGAHBMREAD_ADDR(x) ((uintptr_t)(x) + 0x140U)
#define HW_BCH_DBGAHBMREAD_SET_ADDR(x) (HW_BCH_DBGAHBMREAD_ADDR(x) + 0x4U)
#define HW_BCH_DBGAHBMREAD_CLR_ADDR(x) (HW_BCH_DBGAHBMREAD_ADDR(x) + 0x8U)
#define HW_BCH_DBGAHBMREAD_TOG_ADDR(x) (HW_BCH_DBGAHBMREAD_ADDR(x) + 0xCU)

#define HW_BCH_DBGAHBMREAD(x)    (*(__I hw_bch_dbgahbmread_t *) HW_BCH_DBGAHBMREAD_ADDR(x))
#define HW_BCH_DBGAHBMREAD_RD(x) (HW_BCH_DBGAHBMREAD(x).U)
/*@}*/

/*
 * Constants & macros for individual BCH_DBGAHBMREAD bitfields
 */

/*!
 * @name Register BCH_DBGAHBMREAD, field VALUES[31:0] (RO)
 *
 * Reserved
 */
/*@{*/
#define BP_BCH_DBGAHBMREAD_VALUES (0U)     /*!< Bit position for BCH_DBGAHBMREAD_VALUES. */
#define BM_BCH_DBGAHBMREAD_VALUES (0xFFFFFFFFU) /*!< Bit mask for BCH_DBGAHBMREAD_VALUES. */
#define BS_BCH_DBGAHBMREAD_VALUES (32U)    /*!< Bit field size in bits for BCH_DBGAHBMREAD_VALUES. */

/*! @brief Read current value of the BCH_DBGAHBMREAD_VALUES field. */
#define BR_BCH_DBGAHBMREAD_VALUES(x) (HW_BCH_DBGAHBMREAD(x).U)
/*@}*/




/*******************************************************************************
 * HW_BCH_BLOCKNAME - Block Name Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_BLOCKNAME - Block Name Register (RO)
 *
 * Reset value: 0x20484342U
 *
 * Read only view of the block name string BCH. Fixed pattern read only value is
 * for test purposes. It can be read as an ASCII string with the zero
 * termination coming from the first byte of the BLOCKVERSION register.
 */
typedef union _hw_bch_blockname
{
    uint32_t U;
    struct _hw_bch_blockname_bitfields
    {
        uint32_t NAME : 32;            /*!< [31:0]  */
    } B;
} hw_bch_blockname_t;

/*!
 * @name Constants and macros for entire BCH_BLOCKNAME register
 */
/*@{*/
#define HW_BCH_BLOCKNAME_ADDR(x) ((uintptr_t)(x) + 0x150U)
#define HW_BCH_BLOCKNAME_SET_ADDR(x) (HW_BCH_BLOCKNAME_ADDR(x) + 0x4U)
#define HW_BCH_BLOCKNAME_CLR_ADDR(x) (HW_BCH_BLOCKNAME_ADDR(x) + 0x8U)
#define HW_BCH_BLOCKNAME_TOG_ADDR(x) (HW_BCH_BLOCKNAME_ADDR(x) + 0xCU)

#define HW_BCH_BLOCKNAME(x)      (*(__I hw_bch_blockname_t *) HW_BCH_BLOCKNAME_ADDR(x))
#define HW_BCH_BLOCKNAME_RD(x)   (HW_BCH_BLOCKNAME(x).U)
/*@}*/

/*
 * Constants & macros for individual BCH_BLOCKNAME bitfields
 */

/*!
 * @name Register BCH_BLOCKNAME, field NAME[31:0] (RO)
 *
 * The name is in the ASCII characters BCH (0x20, H, C, B).
 */
/*@{*/
#define BP_BCH_BLOCKNAME_NAME (0U)         /*!< Bit position for BCH_BLOCKNAME_NAME. */
#define BM_BCH_BLOCKNAME_NAME (0xFFFFFFFFU) /*!< Bit mask for BCH_BLOCKNAME_NAME. */
#define BS_BCH_BLOCKNAME_NAME (32U)        /*!< Bit field size in bits for BCH_BLOCKNAME_NAME. */

/*! @brief Read current value of the BCH_BLOCKNAME_NAME field. */
#define BR_BCH_BLOCKNAME_NAME(x) (HW_BCH_BLOCKNAME(x).U)
/*@}*/




/*******************************************************************************
 * HW_BCH_VERSION - BCH Version Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_VERSION - BCH Version Register (RO)
 *
 * Reset value: 0x01000000U
 *
 * This register always returns a known read value for debug purposes and
 * indicates the version of the block and RTL version in use.
 */
typedef union _hw_bch_version
{
    uint32_t U;
    struct _hw_bch_version_bitfields
    {
        uint32_t STEP : 16;            /*!< [15:0]  */
        uint32_t MINOR : 8;            /*!< [23:16]  */
        uint32_t MAJOR : 8;            /*!< [31:24]  */
    } B;
} hw_bch_version_t;

/*!
 * @name Constants and macros for entire BCH_VERSION register
 */
/*@{*/
#define HW_BCH_VERSION_ADDR(x)   ((uintptr_t)(x) + 0x160U)
#define HW_BCH_VERSION_SET_ADDR(x) (HW_BCH_VERSION_ADDR(x) + 0x4U)
#define HW_BCH_VERSION_CLR_ADDR(x) (HW_BCH_VERSION_ADDR(x) + 0x8U)
#define HW_BCH_VERSION_TOG_ADDR(x) (HW_BCH_VERSION_ADDR(x) + 0xCU)

#define HW_BCH_VERSION(x)        (*(__I hw_bch_version_t *) HW_BCH_VERSION_ADDR(x))
#define HW_BCH_VERSION_RD(x)     (HW_BCH_VERSION(x).U)
/*@}*/

/*
 * Constants & macros for individual BCH_VERSION bitfields
 */

/*!
 * @name Register BCH_VERSION, field STEP[15:0] (RO)
 *
 * Fixed read-only value reflecting the stepping of the RTL version.
 */
/*@{*/
#define BP_BCH_VERSION_STEP  (0U)          /*!< Bit position for BCH_VERSION_STEP. */
#define BM_BCH_VERSION_STEP  (0x0000FFFFU) /*!< Bit mask for BCH_VERSION_STEP. */
#define BS_BCH_VERSION_STEP  (16U)         /*!< Bit field size in bits for BCH_VERSION_STEP. */

/*! @brief Read current value of the BCH_VERSION_STEP field. */
#define BR_BCH_VERSION_STEP(x) (HW_BCH_VERSION(x).B.STEP)
/*@}*/

/*!
 * @name Register BCH_VERSION, field MINOR[23:16] (RO)
 *
 * Fixed read-only value indicates the MINOR field of the RTL version.
 */
/*@{*/
#define BP_BCH_VERSION_MINOR (16U)         /*!< Bit position for BCH_VERSION_MINOR. */
#define BM_BCH_VERSION_MINOR (0x00FF0000U) /*!< Bit mask for BCH_VERSION_MINOR. */
#define BS_BCH_VERSION_MINOR (8U)          /*!< Bit field size in bits for BCH_VERSION_MINOR. */

/*! @brief Read current value of the BCH_VERSION_MINOR field. */
#define BR_BCH_VERSION_MINOR(x) (HW_BCH_VERSION(x).B.MINOR)
/*@}*/

/*!
 * @name Register BCH_VERSION, field MAJOR[31:24] (RO)
 *
 * Fixed read-only value indicates the MAJOR field of the RTL version.
 */
/*@{*/
#define BP_BCH_VERSION_MAJOR (24U)         /*!< Bit position for BCH_VERSION_MAJOR. */
#define BM_BCH_VERSION_MAJOR (0xFF000000U) /*!< Bit mask for BCH_VERSION_MAJOR. */
#define BS_BCH_VERSION_MAJOR (8U)          /*!< Bit field size in bits for BCH_VERSION_MAJOR. */

/*! @brief Read current value of the BCH_VERSION_MAJOR field. */
#define BR_BCH_VERSION_MAJOR(x) (HW_BCH_VERSION(x).B.MAJOR)
/*@}*/




/*******************************************************************************
 * HW_BCH_DEBUG1 - Hardware BCH ECC Debug Register 1
 ******************************************************************************/

/*!
 * @brief HW_BCH_DEBUG1 - Hardware BCH ECC Debug Register 1 (RW)
 *
 * Reset value: 0x00000000U
 *
 * The BCH_DEBUG1 register provides erased zero count information and pre-erase
 * check.
 */
typedef union _hw_bch_debug1
{
    uint32_t U;
    struct _hw_bch_debug1_bitfields
    {
        uint32_t ERASED_ZERO_COUNT : 9; /*!< [8:0]  */
        uint32_t RSVD : 22;            /*!< [30:9] This field is reserved. */
        uint32_t DEBUG1_PREERASECHK : 1; /*!< [31]  */
    } B;
} hw_bch_debug1_t;

/*!
 * @name Constants and macros for entire BCH_DEBUG1 register
 */
/*@{*/
#define HW_BCH_DEBUG1_ADDR(x)    ((uintptr_t)(x) + 0x170U)
#define HW_BCH_DEBUG1_SET_ADDR(x) (HW_BCH_DEBUG1_ADDR(x) + 0x4U)
#define HW_BCH_DEBUG1_CLR_ADDR(x) (HW_BCH_DEBUG1_ADDR(x) + 0x8U)
#define HW_BCH_DEBUG1_TOG_ADDR(x) (HW_BCH_DEBUG1_ADDR(x) + 0xCU)

#define HW_BCH_DEBUG1(x)         (*(__IO hw_bch_debug1_t *) HW_BCH_DEBUG1_ADDR(x))
#define HW_BCH_DEBUG1_RD(x)      (HW_BCH_DEBUG1(x).U)
#define HW_BCH_DEBUG1_WR(x, v)   (HW_BCH_DEBUG1(x).U = (v))
#define HW_BCH_DEBUG1_SET(x, v)  ((*(uint32_t *) HW_BCH_DEBUG1_SET_ADDR(x)) = (v))
#define HW_BCH_DEBUG1_CLR(x, v)  ((*(uint32_t *) HW_BCH_DEBUG1_CLR_ADDR(x)) = (v))
#define HW_BCH_DEBUG1_TOG(x, v)  ((*(uint32_t *) HW_BCH_DEBUG1_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual BCH_DEBUG1 bitfields
 */

/*!
 * @name Register BCH_DEBUG1, field ERASED_ZERO_COUNT[8:0] (RO)
 *
 * The zero counts on one page.
 */
/*@{*/
#define BP_BCH_DEBUG1_ERASED_ZERO_COUNT (0U) /*!< Bit position for BCH_DEBUG1_ERASED_ZERO_COUNT. */
#define BM_BCH_DEBUG1_ERASED_ZERO_COUNT (0x000001FFU) /*!< Bit mask for BCH_DEBUG1_ERASED_ZERO_COUNT. */
#define BS_BCH_DEBUG1_ERASED_ZERO_COUNT (9U) /*!< Bit field size in bits for BCH_DEBUG1_ERASED_ZERO_COUNT. */

/*! @brief Read current value of the BCH_DEBUG1_ERASED_ZERO_COUNT field. */
#define BR_BCH_DEBUG1_ERASED_ZERO_COUNT(x) (HW_BCH_DEBUG1(x).B.ERASED_ZERO_COUNT)
/*@}*/

/*!
 * @name Register BCH_DEBUG1, field RSVD[30:9] (RO)
 *
 * This read-only field is reserved and always has the value 0.
 */
/*@{*/
#define BP_BCH_DEBUG1_RSVD   (9U)          /*!< Bit position for BCH_DEBUG1_RSVD. */
#define BM_BCH_DEBUG1_RSVD   (0x7FFFFE00U) /*!< Bit mask for BCH_DEBUG1_RSVD. */
#define BS_BCH_DEBUG1_RSVD   (22U)         /*!< Bit field size in bits for BCH_DEBUG1_RSVD. */

/*! @brief Read current value of the BCH_DEBUG1_RSVD field. */
#define BR_BCH_DEBUG1_RSVD(x) (HW_BCH_DEBUG1(x).B.RSVD)
/*@}*/

/*!
 * @name Register BCH_DEBUG1, field DEBUG1_PREERASECHK[31] (RW)
 *
 * Blank page enables pre-erase check.
 *
 * Values:
 * - 0 - Turn off pre-erase check
 * - 1 - Turn on pre-erase check
 */
/*@{*/
#define BP_BCH_DEBUG1_DEBUG1_PREERASECHK (31U) /*!< Bit position for BCH_DEBUG1_DEBUG1_PREERASECHK. */
#define BM_BCH_DEBUG1_DEBUG1_PREERASECHK (0x80000000U) /*!< Bit mask for BCH_DEBUG1_DEBUG1_PREERASECHK. */
#define BS_BCH_DEBUG1_DEBUG1_PREERASECHK (1U) /*!< Bit field size in bits for BCH_DEBUG1_DEBUG1_PREERASECHK. */

/*! @brief Read current value of the BCH_DEBUG1_DEBUG1_PREERASECHK field. */
#define BR_BCH_DEBUG1_DEBUG1_PREERASECHK(x) (HW_BCH_DEBUG1(x).B.DEBUG1_PREERASECHK)

/*! @brief Format value for bitfield BCH_DEBUG1_DEBUG1_PREERASECHK. */
#define BF_BCH_DEBUG1_DEBUG1_PREERASECHK(v) ((uint32_t)((uint32_t)(v) << BP_BCH_DEBUG1_DEBUG1_PREERASECHK) & BM_BCH_DEBUG1_DEBUG1_PREERASECHK)

/*! @brief Set the DEBUG1_PREERASECHK field to a new value. */
#define BW_BCH_DEBUG1_DEBUG1_PREERASECHK(x, v) (HW_BCH_DEBUG1_WR(x, (HW_BCH_DEBUG1_RD(x) & ~BM_BCH_DEBUG1_DEBUG1_PREERASECHK) | BF_BCH_DEBUG1_DEBUG1_PREERASECHK(v)))
/*@}*/




/*******************************************************************************
 * hw_bch_t - module struct
 ******************************************************************************/
/*!
 * @brief All BCH module registers.
 */
#pragma pack(1)
typedef struct _hw_bch
{
    __IO hw_bch_ctrl_t CTRL;               /*!< [0x0] Hardware BCH ECC Accelerator Control Register */
    uint8_t _reserved0[12];
    __I hw_bch_status0_t STATUS0;          /*!< [0x10] Hardware ECC Accelerator Status Register 0 */
    uint8_t _reserved1[12];
    __IO hw_bch_mode_t MODE;               /*!< [0x20] Hardware ECC Accelerator Mode Register */
    uint8_t _reserved2[12];
    __IO hw_bch_encodeptr_t ENCODEPTR;     /*!< [0x30] Hardware BCH ECC Loopback Encode Buffer Register */
    uint8_t _reserved3[12];
    __IO hw_bch_dataptr_t DATAPTR;         /*!< [0x40] Hardware BCH ECC Loopback Data Buffer Register */
    uint8_t _reserved4[12];
    __IO hw_bch_metaptr_t METAPTR;         /*!< [0x50] Hardware BCH ECC Loopback Metadata Buffer Register */
    uint8_t _reserved5[28];
    __IO hw_bch_layoutselect_t LAYOUTSELECT; /*!< [0x70] Hardware ECC Accelerator Layout Select Register */
    uint8_t _reserved6[12];
    __IO hw_bch_flash0layout0_t FLASH0LAYOUT0; /*!< [0x80] Hardware BCH ECC Flash 0 Layout 0 Register */
    uint8_t _reserved7[12];
    __IO hw_bch_flash0layout1_t FLASH0LAYOUT1; /*!< [0x90] Hardware BCH ECC Flash 0 Layout 1 Register */
    uint8_t _reserved8[12];
    __IO hw_bch_flash1layout0_t FLASH1LAYOUT0; /*!< [0xA0] Hardware BCH ECC Flash 1 Layout 0 Register */
    uint8_t _reserved9[12];
    __IO hw_bch_flash1layout1_t FLASH1LAYOUT1; /*!< [0xB0] Hardware BCH ECC Flash 1 Layout 1 Register */
    uint8_t _reserved10[12];
    __IO hw_bch_flash2layout0_t FLASH2LAYOUT0; /*!< [0xC0] Hardware BCH ECC Flash 2 Layout 0 Register */
    uint8_t _reserved11[12];
    __IO hw_bch_flash2layout1_t FLASH2LAYOUT1; /*!< [0xD0] Hardware BCH ECC Flash 2 Layout 1 Register */
    uint8_t _reserved12[12];
    __IO hw_bch_flash3layout0_t FLASH3LAYOUT0; /*!< [0xE0] Hardware BCH ECC Flash 3 Layout 0 Register */
    uint8_t _reserved13[12];
    __IO hw_bch_flash3layout1_t FLASH3LAYOUT1; /*!< [0xF0] Hardware BCH ECC Flash 3 Layout 1 Register */
    uint8_t _reserved14[12];
    __IO hw_bch_debug0_t DEBUG0;           /*!< [0x100] Hardware BCH ECC Debug Register0 */
    uint8_t _reserved15[12];
    __I hw_bch_dbgkesread_t DBGKESREAD;    /*!< [0x110] KES Debug Read Register */
    uint8_t _reserved16[12];
    __I hw_bch_dbgcsferead_t DBGCSFEREAD;  /*!< [0x120] Chien Search Debug Read Register */
    uint8_t _reserved17[12];
    __I hw_bch_dbgsyndgenread_t DBGSYNDGENREAD; /*!< [0x130] Syndrome Generator Debug Read Register */
    uint8_t _reserved18[12];
    __I hw_bch_dbgahbmread_t DBGAHBMREAD;  /*!< [0x140] Bus Master and ECC Controller Debug Read Register */
    uint8_t _reserved19[12];
    __I hw_bch_blockname_t BLOCKNAME;      /*!< [0x150] Block Name Register */
    uint8_t _reserved20[12];
    __I hw_bch_version_t VERSION;          /*!< [0x160] BCH Version Register */
    uint8_t _reserved21[12];
    __IO hw_bch_debug1_t DEBUG1;           /*!< [0x170] Hardware BCH ECC Debug Register 1 */
} hw_bch_t;
#pragma pack()

/*! @brief Macro to access all BCH registers. */
/*! @param x BCH module instance base address. */
/*! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
 *     use the '&' operator, like <code>&HW_BCH_REGS(BCH_BASE)</code>. */
#define HW_BCH_REGS(x) (*(hw_bch_t *)(x))

/*
 * iMX6SX CAN
 *
 * FLEXCAN
 *
 * Registers defined in this header file:
 * - HW_CAN_MCR - Module Configuration Register
 * - HW_CAN_CTRL1 - Control 1 Register
 * - HW_CAN_TIMER - Free Running Timer Register
 * - HW_CAN_RXMGMASK - Rx Mailboxes Global Mask Register
 * - HW_CAN_RX14MASK - Rx Buffer 14 Mask Register
 * - HW_CAN_RX15MASK - Rx Buffer 15 Mask Register
 * - HW_CAN_ECR - Error Counter Register
 * - HW_CAN_ESR1 - Error and Status 1 Register
 * - HW_CAN_IMASK2 - Interrupt Masks 2 Register
 * - HW_CAN_IMASK1 - Interrupt Masks 1 Register
 * - HW_CAN_IFLAG2 - Interrupt Flags 2 Register
 * - HW_CAN_IFLAG1 - Interrupt Flags 1 Register
 * - HW_CAN_CTRL2 - Control 2 Register
 * - HW_CAN_ESR2 - Error and Status 2 Register
 * - HW_CAN_CRCR - CRC Register
 * - HW_CAN_RXFGMASK - Rx FIFO Global Mask Register
 * - HW_CAN_RXFIR - Rx FIFO Information Register
 * - HW_CAN_CSn - Message Buffer 0 CS Register
 * - HW_CAN_IDn - Message Buffer 0 ID Register
 * - HW_CAN_WORD0n - Message Buffer 0 WORD0 Register
 * - HW_CAN_WORD1n - Message Buffer 0 WORD1 Register
 * - HW_CAN_RXIMRn - RXIMR
 * - HW_CAN_GFWR - Glitch Filter Width Registers
 *
 * - hw_can_t - Struct containing all module registers.
 */

#define HW_CAN_INSTANCE_COUNT (2U) /*!< Number of instances of the CAN module. */
#define HW_CAN1 (0U) /*!< Instance number for CAN1. */
#define HW_CAN2 (1U) /*!< Instance number for CAN2. */
#define CAN1_BASE             (0x2090000U) /*!< Base address for CAN1. */
#define CAN2_BASE             (0x2094000U) /*!< Base address for CAN2. */
/*! Array initializer of CAN base addresses. */
#define CAN_BASE_ADDRS        { CAN1_BASE, CAN2_BASE }

/*******************************************************************************
 * HW_CAN_MCR - Module Configuration Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_MCR - Module Configuration Register (RW)
 *
 * Reset value: 0x5980000FU
 *
 * This register defines global system configurations, such as the module
 * operation mode (e.g., low power) and maximum message buffer configuration.
 */
typedef union _hw_can_mcr
{
    uint32_t U;
    struct _hw_can_mcr_bitfields
    {
        uint32_t MAXMB : 7;            /*!< [6:0]  */
        uint32_t RESERVED0 : 1;        /*!< [7]  */
        uint32_t IDAM : 2;             /*!< [9:8]  */
        uint32_t RESERVED1 : 2;        /*!< [11:10]  */
        uint32_t AEN : 1;              /*!< [12]  */
        uint32_t LPRIO_EN : 1;         /*!< [13]  */
        uint32_t RESERVED2 : 2;        /*!< [15:14]  */
        uint32_t IRMQ : 1;             /*!< [16]  */
        uint32_t SRX_DIS : 1;          /*!< [17]  */
        uint32_t RESERVED3 : 1;        /*!< [18]  */
        uint32_t WAK_SRC : 1;          /*!< [19]  */
        uint32_t LPM_ACK : 1;          /*!< [20]  */
        uint32_t WRN_EN : 1;           /*!< [21]  */
        uint32_t SLF_WAK : 1;          /*!< [22]  */
        uint32_t SUPV : 1;             /*!< [23]  */
        uint32_t FRZ_ACK : 1;          /*!< [24]  */
        uint32_t SOFT_RST : 1;         /*!< [25]  */
        uint32_t WAK_MSK : 1;          /*!< [26]  */
        uint32_t NOT_RDY : 1;          /*!< [27]  */
        uint32_t HALT : 1;             /*!< [28]  */
        uint32_t RFEN : 1;             /*!< [29]  */
        uint32_t FRZ : 1;              /*!< [30]  */
        uint32_t MDIS : 1;             /*!< [31]  */
    } B;
} hw_can_mcr_t;

/*!
 * @name Constants and macros for entire CAN_MCR register
 */
/*@{*/
#define HW_CAN_MCR_ADDR(x)       ((uintptr_t)(x) + 0x0U)

#define HW_CAN_MCR(x)            (*(__IO hw_can_mcr_t *) HW_CAN_MCR_ADDR(x))
#define HW_CAN_MCR_RD(x)         (HW_CAN_MCR(x).U)
#define HW_CAN_MCR_WR(x, v)      (HW_CAN_MCR(x).U = (v))
#define HW_CAN_MCR_SET(x, v)     (HW_CAN_MCR_WR(x, HW_CAN_MCR_RD(x) |  (v)))
#define HW_CAN_MCR_CLR(x, v)     (HW_CAN_MCR_WR(x, HW_CAN_MCR_RD(x) & ~(v)))
#define HW_CAN_MCR_TOG(x, v)     (HW_CAN_MCR_WR(x, HW_CAN_MCR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_MCR bitfields
 */

/*!
 * @name Register CAN_MCR, field MAXMB[6:0] (RW)
 *
 * This 7-bit field defines the number of the last Message Buffers that will
 * take part in the matching and arbitration processes. The reset value (0x0F) is
 * equivalent to 16 MB configuration. This field can only be written in Freeze Mode
 * as it is blocked by hardware in other modes Number of the last MB = MAXMB.
 * Additionally, the value of MAXMB must encompass the FIFO size defined by
 * CTRL2[RFFN] MAXMB also impacts the definition of the minimum number of peripheral
 * clocks per CAN bit as described in (see Arbitration and Matching Timing).
 */
/*@{*/
#define BP_CAN_MCR_MAXMB     (0U)          /*!< Bit position for CAN_MCR_MAXMB. */
#define BM_CAN_MCR_MAXMB     (0x0000007FU) /*!< Bit mask for CAN_MCR_MAXMB. */
#define BS_CAN_MCR_MAXMB     (7U)          /*!< Bit field size in bits for CAN_MCR_MAXMB. */

/*! @brief Read current value of the CAN_MCR_MAXMB field. */
#define BR_CAN_MCR_MAXMB(x)  (HW_CAN_MCR(x).B.MAXMB)

/*! @brief Format value for bitfield CAN_MCR_MAXMB. */
#define BF_CAN_MCR_MAXMB(v)  ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_MAXMB) & BM_CAN_MCR_MAXMB)

/*! @brief Set the MAXMB field to a new value. */
#define BW_CAN_MCR_MAXMB(x, v) (HW_CAN_MCR_WR(x, (HW_CAN_MCR_RD(x) & ~BM_CAN_MCR_MAXMB) | BF_CAN_MCR_MAXMB(v)))
/*@}*/

/*!
 * @name Register CAN_MCR, field IDAM[9:8] (RW)
 *
 * This 2-bit field identifies the format of the elements of the Rx FIFO filter
 * table, as shown below. Note that all elements of the table are configured at
 * the same time by this field (they are all the same format). See Rx FIFO
 * StructureWhen the MCR[RFEN] bit is set, the memory area from $80 to $DC (which is
 * normally occupied by MBs 0 to 5) is used by the reception FIFO engine. . This bit
 * can only be written in Freeze mode as it is blocked by hardware in other
 * modes.
 *
 * Values:
 * - 00 - Format A One full ID (standard or extended) per ID filter Table
 *     element.
 * - 01 - Format B Two full standard IDs or two partial 14-bit extended IDs per
 *     ID filter Table element.
 * - 10 - Format C Four partial 8-bit IDs (standard or extended) per ID filter
 *     Table element.
 * - 11 - Format D All frames rejected.
 */
/*@{*/
#define BP_CAN_MCR_IDAM      (8U)          /*!< Bit position for CAN_MCR_IDAM. */
#define BM_CAN_MCR_IDAM      (0x00000300U) /*!< Bit mask for CAN_MCR_IDAM. */
#define BS_CAN_MCR_IDAM      (2U)          /*!< Bit field size in bits for CAN_MCR_IDAM. */

/*! @brief Read current value of the CAN_MCR_IDAM field. */
#define BR_CAN_MCR_IDAM(x)   (HW_CAN_MCR(x).B.IDAM)

/*! @brief Format value for bitfield CAN_MCR_IDAM. */
#define BF_CAN_MCR_IDAM(v)   ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_IDAM) & BM_CAN_MCR_IDAM)

/*! @brief Set the IDAM field to a new value. */
#define BW_CAN_MCR_IDAM(x, v) (HW_CAN_MCR_WR(x, (HW_CAN_MCR_RD(x) & ~BM_CAN_MCR_IDAM) | BF_CAN_MCR_IDAM(v)))
/*@}*/

/*!
 * @name Register CAN_MCR, field AEN[12] (RW)
 *
 * This bit is supplied for backwards compatibility reasons. When asserted, it
 * enables the Tx abort feature. This feature guarantees a safe procedure for
 * aborting a pending transmission, so that no frame is sent in the CAN bus without
 * notification. This bit can only be written in Freeze mode as it is blocked by
 * hardware in other modes.Write Abort code into Rx Mailboxes can cause
 * unpredictable results when the MCR[AEN] is asserted.
 *
 * Values:
 * - 1 - Abort enabled
 * - 0 - Abort disabled
 */
/*@{*/
#define BP_CAN_MCR_AEN       (12U)         /*!< Bit position for CAN_MCR_AEN. */
#define BM_CAN_MCR_AEN       (0x00001000U) /*!< Bit mask for CAN_MCR_AEN. */
#define BS_CAN_MCR_AEN       (1U)          /*!< Bit field size in bits for CAN_MCR_AEN. */

/*! @brief Read current value of the CAN_MCR_AEN field. */
#define BR_CAN_MCR_AEN(x)    (HW_CAN_MCR(x).B.AEN)

/*! @brief Format value for bitfield CAN_MCR_AEN. */
#define BF_CAN_MCR_AEN(v)    ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_AEN) & BM_CAN_MCR_AEN)

/*! @brief Set the AEN field to a new value. */
#define BW_CAN_MCR_AEN(x, v) (HW_CAN_MCR_WR(x, (HW_CAN_MCR_RD(x) & ~BM_CAN_MCR_AEN) | BF_CAN_MCR_AEN(v)))
/*@}*/

/*!
 * @name Register CAN_MCR, field LPRIO_EN[13] (RW)
 *
 * This bit is provided for backwards compatibility reasons. It controls whether
 * the local priority feature is enabled or not. It is used to extend the ID
 * used during the arbitration process. With this extended ID concept, the
 * arbitration process is done based on the full 32-bit word, but the actual transmitted
 * ID still has 11-bit for standard frames and 29-bit for extended frames.This bit
 * can only be written in Freeze mode as it is blocked by hardware in other
 * modes.
 *
 * Values:
 * - 1 - Local Priority enabled
 * - 0 - Local Priority disabled
 */
/*@{*/
#define BP_CAN_MCR_LPRIO_EN  (13U)         /*!< Bit position for CAN_MCR_LPRIO_EN. */
#define BM_CAN_MCR_LPRIO_EN  (0x00002000U) /*!< Bit mask for CAN_MCR_LPRIO_EN. */
#define BS_CAN_MCR_LPRIO_EN  (1U)          /*!< Bit field size in bits for CAN_MCR_LPRIO_EN. */

/*! @brief Read current value of the CAN_MCR_LPRIO_EN field. */
#define BR_CAN_MCR_LPRIO_EN(x) (HW_CAN_MCR(x).B.LPRIO_EN)

/*! @brief Format value for bitfield CAN_MCR_LPRIO_EN. */
#define BF_CAN_MCR_LPRIO_EN(v) ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_LPRIO_EN) & BM_CAN_MCR_LPRIO_EN)

/*! @brief Set the LPRIO_EN field to a new value. */
#define BW_CAN_MCR_LPRIO_EN(x, v) (HW_CAN_MCR_WR(x, (HW_CAN_MCR_RD(x) & ~BM_CAN_MCR_LPRIO_EN) | BF_CAN_MCR_LPRIO_EN(v)))
/*@}*/

/*!
 * @name Register CAN_MCR, field IRMQ[16] (RW)
 *
 * This bit indicates whether Rx matching process will be based either on
 * individual masking and queue or on masking scheme with RXMGMASK, RX14MASK and
 * RX15MASK, RXFGMASK. This bit can only be written in Freeze mode as it is blocked by
 * hardware in other modes.
 *
 * Values:
 * - 1 - Individual Rx masking and queue feature are enabled.
 * - 0 - Individual Rx masking and queue feature are disabled.For backward
 *     compatibility, the reading of C/S word locks the MB even if it is EMPTY.
 */
/*@{*/
#define BP_CAN_MCR_IRMQ      (16U)         /*!< Bit position for CAN_MCR_IRMQ. */
#define BM_CAN_MCR_IRMQ      (0x00010000U) /*!< Bit mask for CAN_MCR_IRMQ. */
#define BS_CAN_MCR_IRMQ      (1U)          /*!< Bit field size in bits for CAN_MCR_IRMQ. */

/*! @brief Read current value of the CAN_MCR_IRMQ field. */
#define BR_CAN_MCR_IRMQ(x)   (HW_CAN_MCR(x).B.IRMQ)

/*! @brief Format value for bitfield CAN_MCR_IRMQ. */
#define BF_CAN_MCR_IRMQ(v)   ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_IRMQ) & BM_CAN_MCR_IRMQ)

/*! @brief Set the IRMQ field to a new value. */
#define BW_CAN_MCR_IRMQ(x, v) (HW_CAN_MCR_WR(x, (HW_CAN_MCR_RD(x) & ~BM_CAN_MCR_IRMQ) | BF_CAN_MCR_IRMQ(v)))
/*@}*/

/*!
 * @name Register CAN_MCR, field SRX_DIS[17] (RW)
 *
 * This bit defines whether FlexCAN is allowed to receive frames transmitted by
 * itself. If this bit is asserted, frames transmitted by the module will not be
 * stored in any MB, regardless if the MB is programmed with an ID that matches
 * the transmitted frame, and no interrupt flag or interrupt signal will be
 * generated due to the frame reception. This bit can only be written in Freeze mode as
 * it is blocked by hardware in other modes.
 *
 * Values:
 * - 1 - Self reception disabled
 * - 0 - Self reception enabled
 */
/*@{*/
#define BP_CAN_MCR_SRX_DIS   (17U)         /*!< Bit position for CAN_MCR_SRX_DIS. */
#define BM_CAN_MCR_SRX_DIS   (0x00020000U) /*!< Bit mask for CAN_MCR_SRX_DIS. */
#define BS_CAN_MCR_SRX_DIS   (1U)          /*!< Bit field size in bits for CAN_MCR_SRX_DIS. */

/*! @brief Read current value of the CAN_MCR_SRX_DIS field. */
#define BR_CAN_MCR_SRX_DIS(x) (HW_CAN_MCR(x).B.SRX_DIS)

/*! @brief Format value for bitfield CAN_MCR_SRX_DIS. */
#define BF_CAN_MCR_SRX_DIS(v) ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_SRX_DIS) & BM_CAN_MCR_SRX_DIS)

/*! @brief Set the SRX_DIS field to a new value. */
#define BW_CAN_MCR_SRX_DIS(x, v) (HW_CAN_MCR_WR(x, (HW_CAN_MCR_RD(x) & ~BM_CAN_MCR_SRX_DIS) | BF_CAN_MCR_SRX_DIS(v)))
/*@}*/

/*!
 * @name Register CAN_MCR, field WAK_SRC[19] (RW)
 *
 * This bit defines whether the integrated low-pass filter is applied to protect
 * the FLEXCAN_RX input from spurious wake up. See Stop ModeThis is a system low
 * power mode in which system clocks can be stopped for maximum power savings..
 * To enter stop mode, the CPU should manually assert a global Stop Mode request
 * (see the CAN1_STOP_REQ and CAN2_STOP_REQ bit in the register IOMUXC_GPR13)and
 * check the acknowledgement asserted by the FlexCAN (see the CAN1_STOP_ARK and
 * CAN2_STOP_ARK in the register IOMUXC_GPR4) . The CPU must only consider the
 * FlexCAN in Stop Mode when both request and acknowledgement conditions are
 * satisfied. for more information. This bit can only be written in Freeze mode as it is
 * blocked by hardware in other modes.
 *
 * Values:
 * - 1 - FLEXCAN uses the filtered FLEXCAN_RX input to detect recessive to
 *     dominant edges on the CAN bus
 * - 0 - FLEXCAN uses the unfiltered FLEXCAN_RX input to detect recessive to
 *     dominant edges on the CAN bus.
 */
/*@{*/
#define BP_CAN_MCR_WAK_SRC   (19U)         /*!< Bit position for CAN_MCR_WAK_SRC. */
#define BM_CAN_MCR_WAK_SRC   (0x00080000U) /*!< Bit mask for CAN_MCR_WAK_SRC. */
#define BS_CAN_MCR_WAK_SRC   (1U)          /*!< Bit field size in bits for CAN_MCR_WAK_SRC. */

/*! @brief Read current value of the CAN_MCR_WAK_SRC field. */
#define BR_CAN_MCR_WAK_SRC(x) (HW_CAN_MCR(x).B.WAK_SRC)

/*! @brief Format value for bitfield CAN_MCR_WAK_SRC. */
#define BF_CAN_MCR_WAK_SRC(v) ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_WAK_SRC) & BM_CAN_MCR_WAK_SRC)

/*! @brief Set the WAK_SRC field to a new value. */
#define BW_CAN_MCR_WAK_SRC(x, v) (HW_CAN_MCR_WR(x, (HW_CAN_MCR_RD(x) & ~BM_CAN_MCR_WAK_SRC) | BF_CAN_MCR_WAK_SRC(v)))
/*@}*/

/*!
 * @name Register CAN_MCR, field LPM_ACK[20] (RO)
 *
 * This read-only bit indicates that FLEXCAN is either in Disable Mode or Stop
 * Mode. Either of these low power modes can not be entered until all current
 * transmission or reception processes have finished, so the ARM can poll the LPM_ACK
 * bit to know when FLEXCAN has actually entered low power mode. See Module
 * Disable ModeThis low power mode is normally used to temporarily disable a complete
 * FlexCAN block, with no power consumption. It is requested by the ARM through
 * the assertion of the MDIS bit in the MCR Register and the acknowledgement is
 * obtained through the assertion by the FlexCAN of the LPM_ACK bit in the same
 * register. The ARM must only consider the FlexCAN in Disable Mode when both
 * request and acknowledgement conditions are satisfied. , and Stop ModeThis is a
 * system low power mode in which system clocks can be stopped for maximum power
 * savings.. To enter stop mode, the CPU should manually assert a global Stop Mode
 * request (see the CAN1_STOP_REQ and CAN2_STOP_REQ bit in the register
 * IOMUXC_GPR13)and check the acknowledgement asserted by the FlexCAN (see the CAN1_STOP_ARK
 * and CAN2_STOP_ARK in the register IOMUXC_GPR4) . The CPU must only consider
 * the FlexCAN in Stop Mode when both request and acknowledgement conditions are
 * satisfied. for more information
 *
 * Values:
 * - 1 - FLEXCAN is either in Disable Mode, or Stop mode
 * - 0 - FLEXCAN not in any of the low power modes
 */
/*@{*/
#define BP_CAN_MCR_LPM_ACK   (20U)         /*!< Bit position for CAN_MCR_LPM_ACK. */
#define BM_CAN_MCR_LPM_ACK   (0x00100000U) /*!< Bit mask for CAN_MCR_LPM_ACK. */
#define BS_CAN_MCR_LPM_ACK   (1U)          /*!< Bit field size in bits for CAN_MCR_LPM_ACK. */

/*! @brief Read current value of the CAN_MCR_LPM_ACK field. */
#define BR_CAN_MCR_LPM_ACK(x) (HW_CAN_MCR(x).B.LPM_ACK)
/*@}*/

/*!
 * @name Register CAN_MCR, field WRN_EN[21] (RW)
 *
 * When asserted, this bit enables the generation of the TWRN_INT and RWRN_INT
 * flags in the Error and Status Register. If WRN_EN is negated, the TWRN_INT and
 * RWRN_INT flags will always be zero, independent of the values of the error
 * counters, and no warning interrupt will ever be generated.This bit can only be
 * written in Freeze mode as it is blocked by hardware in other modes.
 *
 * Values:
 * - 1 - TWRN_INT and RWRN_INT bits are set when the respective error counter
 *     transition from <96 to >= 96.
 * - 0 - TWRN_INT and RWRN_INT bits are zero, independent of the values in the
 *     error counters.
 */
/*@{*/
#define BP_CAN_MCR_WRN_EN    (21U)         /*!< Bit position for CAN_MCR_WRN_EN. */
#define BM_CAN_MCR_WRN_EN    (0x00200000U) /*!< Bit mask for CAN_MCR_WRN_EN. */
#define BS_CAN_MCR_WRN_EN    (1U)          /*!< Bit field size in bits for CAN_MCR_WRN_EN. */

/*! @brief Read current value of the CAN_MCR_WRN_EN field. */
#define BR_CAN_MCR_WRN_EN(x) (HW_CAN_MCR(x).B.WRN_EN)

/*! @brief Format value for bitfield CAN_MCR_WRN_EN. */
#define BF_CAN_MCR_WRN_EN(v) ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_WRN_EN) & BM_CAN_MCR_WRN_EN)

/*! @brief Set the WRN_EN field to a new value. */
#define BW_CAN_MCR_WRN_EN(x, v) (HW_CAN_MCR_WR(x, (HW_CAN_MCR_RD(x) & ~BM_CAN_MCR_WRN_EN) | BF_CAN_MCR_WRN_EN(v)))
/*@}*/

/*!
 * @name Register CAN_MCR, field SLF_WAK[22] (RW)
 *
 * This bit enables the Self Wake Up feature when FLEXCAN is in Stop Mode. If
 * this bit had been asserted by the time FLEXCAN entered Stop Mode, then FLEXCAN
 * will look for a recessive to dominant transition on the bus during these modes.
 * If a transition from recessive to dominant is detected during Stop Mode, then
 * FLEXCAN generates, if enabled to do so, a Wake Up interrupt to the ARM so
 * that it can resume the clocks globally and FlexCAN can request to resume the
 * clocks. This bit can not be written while the module is in Stop Mode.
 *
 * Values:
 * - 1 - FLEXCAN Self Wake Up feature is enabled
 * - 0 - FLEXCAN Self Wake Up feature is disabled
 */
/*@{*/
#define BP_CAN_MCR_SLF_WAK   (22U)         /*!< Bit position for CAN_MCR_SLF_WAK. */
#define BM_CAN_MCR_SLF_WAK   (0x00400000U) /*!< Bit mask for CAN_MCR_SLF_WAK. */
#define BS_CAN_MCR_SLF_WAK   (1U)          /*!< Bit field size in bits for CAN_MCR_SLF_WAK. */

/*! @brief Read current value of the CAN_MCR_SLF_WAK field. */
#define BR_CAN_MCR_SLF_WAK(x) (HW_CAN_MCR(x).B.SLF_WAK)

/*! @brief Format value for bitfield CAN_MCR_SLF_WAK. */
#define BF_CAN_MCR_SLF_WAK(v) ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_SLF_WAK) & BM_CAN_MCR_SLF_WAK)

/*! @brief Set the SLF_WAK field to a new value. */
#define BW_CAN_MCR_SLF_WAK(x, v) (HW_CAN_MCR_WR(x, (HW_CAN_MCR_RD(x) & ~BM_CAN_MCR_SLF_WAK) | BF_CAN_MCR_SLF_WAK(v)))
/*@}*/

/*!
 * @name Register CAN_MCR, field SUPV[23] (RW)
 *
 * This bit configures some of the FLEXCAN registers to be either in Supervisor
 * or User Mode. Reset value of this bit is '1', so the affected registers start
 * with Supervisor access allowance only. This bit can only be written in Freeze
 * mode as it is blocked by hardware in other modes.
 *
 * Values:
 * - 1 - FlexCAN is in Supervisor Mode. Affected registers allow only Supervisor
 *     access. Unrestricted access behaves as though the access was done to an
 *     unimplemented register location
 * - 0 - FlexCAN is in User Mode. Affected registers allow both Supervisor and
 *     Unrestricted accesses
 */
/*@{*/
#define BP_CAN_MCR_SUPV      (23U)         /*!< Bit position for CAN_MCR_SUPV. */
#define BM_CAN_MCR_SUPV      (0x00800000U) /*!< Bit mask for CAN_MCR_SUPV. */
#define BS_CAN_MCR_SUPV      (1U)          /*!< Bit field size in bits for CAN_MCR_SUPV. */

/*! @brief Read current value of the CAN_MCR_SUPV field. */
#define BR_CAN_MCR_SUPV(x)   (HW_CAN_MCR(x).B.SUPV)

/*! @brief Format value for bitfield CAN_MCR_SUPV. */
#define BF_CAN_MCR_SUPV(v)   ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_SUPV) & BM_CAN_MCR_SUPV)

/*! @brief Set the SUPV field to a new value. */
#define BW_CAN_MCR_SUPV(x, v) (HW_CAN_MCR_WR(x, (HW_CAN_MCR_RD(x) & ~BM_CAN_MCR_SUPV) | BF_CAN_MCR_SUPV(v)))
/*@}*/

/*!
 * @name Register CAN_MCR, field FRZ_ACK[24] (RO)
 *
 * This read-only bit indicates that FLEXCAN is in Freeze Mode and its prescaler
 * is stopped. The Freeze Mode request cannot be granted until current
 * transmission or reception processes have finished. Therefore the software can poll the
 * FRZ_ACK bit to know when FLEXCAN has actually entered Freeze Mode. If Freeze
 * Mode request is negated, then this bit is negated once the FLEXCAN prescaler is
 * running again. If Freeze Mode is requested while FLEXCAN is in any of the low
 * power modes, then the FRZ_ACK bit will only be set when the low power mode is
 * exited. See Freeze ModeThis mode is requested by ARM through the assertion of
 * the HALT bit in the MCR Register or when the MCU is put into Debug Mode . In
 * both cases it is also necessary that the FRZ bit is asserted in the MCR
 * Register and the module is not in any of the low power modes (Disable, Stop). The
 * acknowledgement is obtained through the assertion by the FlexCAN of FRZ_ACK bit
 * in the same register. The ARM must only consider the FlexCAN in Freeze Mode
 * when both request and acknowledgement conditions are satisfied. for more
 * information
 *
 * Values:
 * - 1 - FLEXCAN in Freeze Mode, prescaler stopped
 * - 0 - FLEXCAN not in Freeze Mode, prescaler running
 */
/*@{*/
#define BP_CAN_MCR_FRZ_ACK   (24U)         /*!< Bit position for CAN_MCR_FRZ_ACK. */
#define BM_CAN_MCR_FRZ_ACK   (0x01000000U) /*!< Bit mask for CAN_MCR_FRZ_ACK. */
#define BS_CAN_MCR_FRZ_ACK   (1U)          /*!< Bit field size in bits for CAN_MCR_FRZ_ACK. */

/*! @brief Read current value of the CAN_MCR_FRZ_ACK field. */
#define BR_CAN_MCR_FRZ_ACK(x) (HW_CAN_MCR(x).B.FRZ_ACK)
/*@}*/

/*!
 * @name Register CAN_MCR, field SOFT_RST[25] (RW)
 *
 * When this bit is asserted, FlexCAN resets its internal state machines and
 * some of the memory mapped registers. The following registers are reset: MCR
 * (except the MDIS bit), TIMER, ECR, ESR1, ESR2, IMASK1, IMASK2, IFLAG1, IFLAG2 and
 * CRCR. Configuration registers that control the interface to the CAN bus are not
 * affected by soft reset. The following registers are unaffected: CTRL1, CTRL2,
 * RXIMR0_RXIMR63, RXGMASK, RX14MASK, RX15MASK, RXFGMASK, RXFIR and all Message
 * Buffers The SOFT_RST bit can be asserted directly by the ARM when it writes to
 * the MCR Register. It may take some time to fully propagate its effect. The
 * SOFT_RST bit remains asserted while reset is pending, and is automatically
 * negated when reset completes. Therefore, software can poll this bit to know when
 * the soft reset has completed. Soft reset cannot be applied while clocks are shut
 * down in any of the low power modes. The module should be first removed from
 * low power mode, and then soft reset can be applied.
 *
 * Values:
 * - 1 - Reset the registers
 * - 0 - No reset request
 */
/*@{*/
#define BP_CAN_MCR_SOFT_RST  (25U)         /*!< Bit position for CAN_MCR_SOFT_RST. */
#define BM_CAN_MCR_SOFT_RST  (0x02000000U) /*!< Bit mask for CAN_MCR_SOFT_RST. */
#define BS_CAN_MCR_SOFT_RST  (1U)          /*!< Bit field size in bits for CAN_MCR_SOFT_RST. */

/*! @brief Read current value of the CAN_MCR_SOFT_RST field. */
#define BR_CAN_MCR_SOFT_RST(x) (HW_CAN_MCR(x).B.SOFT_RST)

/*! @brief Format value for bitfield CAN_MCR_SOFT_RST. */
#define BF_CAN_MCR_SOFT_RST(v) ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_SOFT_RST) & BM_CAN_MCR_SOFT_RST)

/*! @brief Set the SOFT_RST field to a new value. */
#define BW_CAN_MCR_SOFT_RST(x, v) (HW_CAN_MCR_WR(x, (HW_CAN_MCR_RD(x) & ~BM_CAN_MCR_SOFT_RST) | BF_CAN_MCR_SOFT_RST(v)))
/*@}*/

/*!
 * @name Register CAN_MCR, field WAK_MSK[26] (RW)
 *
 * This bit enables the Wake Up Interrupt generation.
 *
 * Values:
 * - 1 - Wake Up Interrupt is enabled
 * - 0 - Wake Up Interrupt is disabled
 */
/*@{*/
#define BP_CAN_MCR_WAK_MSK   (26U)         /*!< Bit position for CAN_MCR_WAK_MSK. */
#define BM_CAN_MCR_WAK_MSK   (0x04000000U) /*!< Bit mask for CAN_MCR_WAK_MSK. */
#define BS_CAN_MCR_WAK_MSK   (1U)          /*!< Bit field size in bits for CAN_MCR_WAK_MSK. */

/*! @brief Read current value of the CAN_MCR_WAK_MSK field. */
#define BR_CAN_MCR_WAK_MSK(x) (HW_CAN_MCR(x).B.WAK_MSK)

/*! @brief Format value for bitfield CAN_MCR_WAK_MSK. */
#define BF_CAN_MCR_WAK_MSK(v) ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_WAK_MSK) & BM_CAN_MCR_WAK_MSK)

/*! @brief Set the WAK_MSK field to a new value. */
#define BW_CAN_MCR_WAK_MSK(x, v) (HW_CAN_MCR_WR(x, (HW_CAN_MCR_RD(x) & ~BM_CAN_MCR_WAK_MSK) | BF_CAN_MCR_WAK_MSK(v)))
/*@}*/

/*!
 * @name Register CAN_MCR, field NOT_RDY[27] (RO)
 *
 * This read-only bit indicates that FLEXCAN is either in Disable Mode, Stop
 * Mode or Freeze Mode. It is negated once FLEXCAN has exited these modes.
 *
 * Values:
 * - 1 - FLEXCAN module is either in Disable Mode, Stop Mode or Freeze Mode
 * - 0 - FLEXCAN module is either in Normal Mode, Listen-Only Mode or Loop-Back
 *     Mode
 */
/*@{*/
#define BP_CAN_MCR_NOT_RDY   (27U)         /*!< Bit position for CAN_MCR_NOT_RDY. */
#define BM_CAN_MCR_NOT_RDY   (0x08000000U) /*!< Bit mask for CAN_MCR_NOT_RDY. */
#define BS_CAN_MCR_NOT_RDY   (1U)          /*!< Bit field size in bits for CAN_MCR_NOT_RDY. */

/*! @brief Read current value of the CAN_MCR_NOT_RDY field. */
#define BR_CAN_MCR_NOT_RDY(x) (HW_CAN_MCR(x).B.NOT_RDY)
/*@}*/

/*!
 * @name Register CAN_MCR, field HALT[28] (RW)
 *
 * Assertion of this bit puts the FLEXCAN module into Freeze Mode. The ARM
 * should clear it after initializing the Message Buffers and Control Register. No
 * reception or transmission is performed by FLEXCAN before this bit is cleared.
 * Freeze Mode can not be entered while FLEXCAN is in any of the low power modes.See
 * Freeze ModeThis mode is requested by ARM through the assertion of the HALT
 * bit in the MCR Register or when the MCU is put into Debug Mode . In both cases
 * it is also necessary that the FRZ bit is asserted in the MCR Register and the
 * module is not in any of the low power modes (Disable, Stop). The
 * acknowledgement is obtained through the assertion by the FlexCAN of FRZ_ACK bit in the same
 * register. The ARM must only consider the FlexCAN in Freeze Mode when both
 * request and acknowledgement conditions are satisfied. for more information
 *
 * Values:
 * - 1 - Enters Freeze Mode if the FRZ bit is asserted.
 * - 0 - No Freeze Mode request.
 */
/*@{*/
#define BP_CAN_MCR_HALT      (28U)         /*!< Bit position for CAN_MCR_HALT. */
#define BM_CAN_MCR_HALT      (0x10000000U) /*!< Bit mask for CAN_MCR_HALT. */
#define BS_CAN_MCR_HALT      (1U)          /*!< Bit field size in bits for CAN_MCR_HALT. */

/*! @brief Read current value of the CAN_MCR_HALT field. */
#define BR_CAN_MCR_HALT(x)   (HW_CAN_MCR(x).B.HALT)

/*! @brief Format value for bitfield CAN_MCR_HALT. */
#define BF_CAN_MCR_HALT(v)   ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_HALT) & BM_CAN_MCR_HALT)

/*! @brief Set the HALT field to a new value. */
#define BW_CAN_MCR_HALT(x, v) (HW_CAN_MCR_WR(x, (HW_CAN_MCR_RD(x) & ~BM_CAN_MCR_HALT) | BF_CAN_MCR_HALT(v)))
/*@}*/

/*!
 * @name Register CAN_MCR, field RFEN[29] (RW)
 *
 * This bit controls whether the Rx FIFO feature is enabled or not. When RFEN is
 * set, MBs 0 to 5 cannot be used for normal reception and transmission because
 * the corresponding memory region (0x80-0xDC) is used by the FIFO engine as well
 * as additional MBs (up to 32, depending on CTRL2[RFFN] setting) which are used
 * as Rx FIFO ID Filter Table elements.RFEN also impacts the definition of the
 * minimum number of peripheral clocks per CAN bit as described in (see
 * Arbitration and Matching Timing).This bit can only be written in Freeze mode as it is
 * blocked by hardware in other modes.
 *
 * Values:
 * - 1 - FIFO enabled
 * - 0 - FIFO not enabled
 */
/*@{*/
#define BP_CAN_MCR_RFEN      (29U)         /*!< Bit position for CAN_MCR_RFEN. */
#define BM_CAN_MCR_RFEN      (0x20000000U) /*!< Bit mask for CAN_MCR_RFEN. */
#define BS_CAN_MCR_RFEN      (1U)          /*!< Bit field size in bits for CAN_MCR_RFEN. */

/*! @brief Read current value of the CAN_MCR_RFEN field. */
#define BR_CAN_MCR_RFEN(x)   (HW_CAN_MCR(x).B.RFEN)

/*! @brief Format value for bitfield CAN_MCR_RFEN. */
#define BF_CAN_MCR_RFEN(v)   ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_RFEN) & BM_CAN_MCR_RFEN)

/*! @brief Set the RFEN field to a new value. */
#define BW_CAN_MCR_RFEN(x, v) (HW_CAN_MCR_WR(x, (HW_CAN_MCR_RD(x) & ~BM_CAN_MCR_RFEN) | BF_CAN_MCR_RFEN(v)))
/*@}*/

/*!
 * @name Register CAN_MCR, field FRZ[30] (RW)
 *
 * The FRZ bit specifies the FLEXCAN behavior when the HALT bit in the MCR
 * Register is set or when Debug Mode is requested at ARM level. When FRZ is asserted,
 * FLEXCAN is enabled to enter Freeze Mode. Negation of this bit field causes
 * FLEXCAN to exit from Freeze Mode.
 *
 * Values:
 * - 1 - Enabled to enter Freeze Mode
 * - 0 - Not enabled to enter Freeze Mode
 */
/*@{*/
#define BP_CAN_MCR_FRZ       (30U)         /*!< Bit position for CAN_MCR_FRZ. */
#define BM_CAN_MCR_FRZ       (0x40000000U) /*!< Bit mask for CAN_MCR_FRZ. */
#define BS_CAN_MCR_FRZ       (1U)          /*!< Bit field size in bits for CAN_MCR_FRZ. */

/*! @brief Read current value of the CAN_MCR_FRZ field. */
#define BR_CAN_MCR_FRZ(x)    (HW_CAN_MCR(x).B.FRZ)

/*! @brief Format value for bitfield CAN_MCR_FRZ. */
#define BF_CAN_MCR_FRZ(v)    ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_FRZ) & BM_CAN_MCR_FRZ)

/*! @brief Set the FRZ field to a new value. */
#define BW_CAN_MCR_FRZ(x, v) (HW_CAN_MCR_WR(x, (HW_CAN_MCR_RD(x) & ~BM_CAN_MCR_FRZ) | BF_CAN_MCR_FRZ(v)))
/*@}*/

/*!
 * @name Register CAN_MCR, field MDIS[31] (RW)
 *
 * This bit controls whether FLEXCAN is enabled or not. When disabled, FLEXCAN
 * shuts down the clocks to the CAN Protocol Interface and Message Buffer
 * Management sub-modules. This is the only bit in MCR not affected by soft reset. See
 * Module Disable ModeThis low power mode is normally used to temporarily disable a
 * complete FlexCAN block, with no power consumption. It is requested by the ARM
 * through the assertion of the MDIS bit in the MCR Register and the
 * acknowledgement is obtained through the assertion by the FlexCAN of the LPM_ACK bit in
 * the same register. The ARM must only consider the FlexCAN in Disable Mode when
 * both request and acknowledgement conditions are satisfied. for more information.
 *
 * Values:
 * - 1 - Disable the FLEXCAN module
 * - 0 - Enable the FLEXCAN module
 */
/*@{*/
#define BP_CAN_MCR_MDIS      (31U)         /*!< Bit position for CAN_MCR_MDIS. */
#define BM_CAN_MCR_MDIS      (0x80000000U) /*!< Bit mask for CAN_MCR_MDIS. */
#define BS_CAN_MCR_MDIS      (1U)          /*!< Bit field size in bits for CAN_MCR_MDIS. */

/*! @brief Read current value of the CAN_MCR_MDIS field. */
#define BR_CAN_MCR_MDIS(x)   (HW_CAN_MCR(x).B.MDIS)

/*! @brief Format value for bitfield CAN_MCR_MDIS. */
#define BF_CAN_MCR_MDIS(v)   ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_MDIS) & BM_CAN_MCR_MDIS)

/*! @brief Set the MDIS field to a new value. */
#define BW_CAN_MCR_MDIS(x, v) (HW_CAN_MCR_WR(x, (HW_CAN_MCR_RD(x) & ~BM_CAN_MCR_MDIS) | BF_CAN_MCR_MDIS(v)))
/*@}*/

/*******************************************************************************
 * HW_CAN_CTRL1 - Control 1 Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_CTRL1 - Control 1 Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register is defined for specific FLEXCAN control features related to the
 * CAN bus, such as bit-rate, programmable sampling point within an Rx bit, Loop
 * Back Mode, Listen Only Mode, Bus Off recovery behavior and interrupt enabling
 * (Bus-Off, Error, Warning). It also determines the Division Factor for the
 * clock prescaler.
 */
typedef union _hw_can_ctrl1
{
    uint32_t U;
    struct _hw_can_ctrl1_bitfields
    {
        uint32_t PROP_SEG : 3;         /*!< [2:0]  */
        uint32_t LOM : 1;              /*!< [3]  */
        uint32_t LBUF : 1;             /*!< [4]  */
        uint32_t TSYN : 1;             /*!< [5]  */
        uint32_t BOFF_REC : 1;         /*!< [6]  */
        uint32_t SMP : 1;              /*!< [7]  */
        uint32_t RESERVED0 : 2;        /*!< [9:8]  */
        uint32_t RWRN_MSK : 1;         /*!< [10]  */
        uint32_t TWRN_MSK : 1;         /*!< [11]  */
        uint32_t LPB : 1;              /*!< [12]  */
        uint32_t RESERVED1 : 1;        /*!< [13]  */
        uint32_t ERR_MSK : 1;          /*!< [14]  */
        uint32_t BOFF_MSK : 1;         /*!< [15]  */
        uint32_t PSEG2 : 3;            /*!< [18:16]  */
        uint32_t PSEG1 : 3;            /*!< [21:19]  */
        uint32_t RJW : 2;              /*!< [23:22]  */
        uint32_t PRESDIV : 8;          /*!< [31:24]  */
    } B;
} hw_can_ctrl1_t;

/*!
 * @name Constants and macros for entire CAN_CTRL1 register
 */
/*@{*/
#define HW_CAN_CTRL1_ADDR(x)     ((uintptr_t)(x) + 0x4U)

#define HW_CAN_CTRL1(x)          (*(__IO hw_can_ctrl1_t *) HW_CAN_CTRL1_ADDR(x))
#define HW_CAN_CTRL1_RD(x)       (HW_CAN_CTRL1(x).U)
#define HW_CAN_CTRL1_WR(x, v)    (HW_CAN_CTRL1(x).U = (v))
#define HW_CAN_CTRL1_SET(x, v)   (HW_CAN_CTRL1_WR(x, HW_CAN_CTRL1_RD(x) |  (v)))
#define HW_CAN_CTRL1_CLR(x, v)   (HW_CAN_CTRL1_WR(x, HW_CAN_CTRL1_RD(x) & ~(v)))
#define HW_CAN_CTRL1_TOG(x, v)   (HW_CAN_CTRL1_WR(x, HW_CAN_CTRL1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_CTRL1 bitfields
 */

/*!
 * @name Register CAN_CTRL1, field PROP_SEG[2:0] (RW)
 *
 * This 3-bit field defines the length of the Propagation Segment in the bit
 * time. The valid programmable values are 0-7. This field can only be written in
 * Freeze mode as it is blocked by hardware in other modes Propagation Segment Time
 * = (PROPSEG + 1) * Time-Quanta. Time-Quantum = one Sclock period.
 */
/*@{*/
#define BP_CAN_CTRL1_PROP_SEG (0U)         /*!< Bit position for CAN_CTRL1_PROP_SEG. */
#define BM_CAN_CTRL1_PROP_SEG (0x00000007U) /*!< Bit mask for CAN_CTRL1_PROP_SEG. */
#define BS_CAN_CTRL1_PROP_SEG (3U)         /*!< Bit field size in bits for CAN_CTRL1_PROP_SEG. */

/*! @brief Read current value of the CAN_CTRL1_PROP_SEG field. */
#define BR_CAN_CTRL1_PROP_SEG(x) (HW_CAN_CTRL1(x).B.PROP_SEG)

/*! @brief Format value for bitfield CAN_CTRL1_PROP_SEG. */
#define BF_CAN_CTRL1_PROP_SEG(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_PROP_SEG) & BM_CAN_CTRL1_PROP_SEG)

/*! @brief Set the PROP_SEG field to a new value. */
#define BW_CAN_CTRL1_PROP_SEG(x, v) (HW_CAN_CTRL1_WR(x, (HW_CAN_CTRL1_RD(x) & ~BM_CAN_CTRL1_PROP_SEG) | BF_CAN_CTRL1_PROP_SEG(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field LOM[3] (RW)
 *
 * This bit configures FLEXCAN to operate in Listen Only Mode. In this mode,
 * transmission is disabled, all error counters are frozen and the module operates
 * in a CAN Error Passive mode . Only messages acknowledged by another CAN station
 * will be received. If FLEXCAN detects a message that has not been
 * acknowledged, it will flag a BIT0 error (without changing the REC), as if it was trying to
 * acknowledge the message. Listen-Only Mode acknowledgement can be obtained by
 * the state of ESR1[FLT_CONF] field which is Passive Error when Listen-Only Mode
 * is entered. There can be some delay between the Listen-Only Mode request and
 * acknowledge. This bit can only be written in Freeze mode as it is blocked by
 * hardware in other modes.
 *
 * Values:
 * - 1 - FLEXCAN module operates in Listen Only Mode
 * - 0 - Listen Only Mode is deactivated
 */
/*@{*/
#define BP_CAN_CTRL1_LOM     (3U)          /*!< Bit position for CAN_CTRL1_LOM. */
#define BM_CAN_CTRL1_LOM     (0x00000008U) /*!< Bit mask for CAN_CTRL1_LOM. */
#define BS_CAN_CTRL1_LOM     (1U)          /*!< Bit field size in bits for CAN_CTRL1_LOM. */

/*! @brief Read current value of the CAN_CTRL1_LOM field. */
#define BR_CAN_CTRL1_LOM(x)  (HW_CAN_CTRL1(x).B.LOM)

/*! @brief Format value for bitfield CAN_CTRL1_LOM. */
#define BF_CAN_CTRL1_LOM(v)  ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_LOM) & BM_CAN_CTRL1_LOM)

/*! @brief Set the LOM field to a new value. */
#define BW_CAN_CTRL1_LOM(x, v) (HW_CAN_CTRL1_WR(x, (HW_CAN_CTRL1_RD(x) & ~BM_CAN_CTRL1_LOM) | BF_CAN_CTRL1_LOM(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field LBUF[4] (RW)
 *
 * This bit defines the ordering mechanism for Message Buffer transmission. When
 * asserted, the LPRIO_EN bit does not affect the priority arbitration.This bit
 * can only be written in Freeze mode as it is blocked by hardware in other modes.
 *
 * Values:
 * - 1 - Lowest number buffer is transmitted first
 * - 0 - Buffer with highest priority is transmitted first
 */
/*@{*/
#define BP_CAN_CTRL1_LBUF    (4U)          /*!< Bit position for CAN_CTRL1_LBUF. */
#define BM_CAN_CTRL1_LBUF    (0x00000010U) /*!< Bit mask for CAN_CTRL1_LBUF. */
#define BS_CAN_CTRL1_LBUF    (1U)          /*!< Bit field size in bits for CAN_CTRL1_LBUF. */

/*! @brief Read current value of the CAN_CTRL1_LBUF field. */
#define BR_CAN_CTRL1_LBUF(x) (HW_CAN_CTRL1(x).B.LBUF)

/*! @brief Format value for bitfield CAN_CTRL1_LBUF. */
#define BF_CAN_CTRL1_LBUF(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_LBUF) & BM_CAN_CTRL1_LBUF)

/*! @brief Set the LBUF field to a new value. */
#define BW_CAN_CTRL1_LBUF(x, v) (HW_CAN_CTRL1_WR(x, (HW_CAN_CTRL1_RD(x) & ~BM_CAN_CTRL1_LBUF) | BF_CAN_CTRL1_LBUF(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field TSYN[5] (RW)
 *
 * This bit enables a mechanism that resets the free-running timer each time a
 * message is received in Message Buffer 0. This feature provides means to
 * synchronize multiple FLEXCAN stations with a special "SYNC" message (i.e., global
 * network time). If the RFEN bit in MCR is set (FIFO enabled), the first available
 * Mailbox, according to CTRL2[RFFN] setting, is used for timer synchronization
 * instead of MB0.This bit can only be written in Freeze mode as it is blocked by
 * hardware in other modes.
 *
 * Values:
 * - 1 - Timer Sync feature enabled
 * - 0 - Timer Sync feature disabled
 */
/*@{*/
#define BP_CAN_CTRL1_TSYN    (5U)          /*!< Bit position for CAN_CTRL1_TSYN. */
#define BM_CAN_CTRL1_TSYN    (0x00000020U) /*!< Bit mask for CAN_CTRL1_TSYN. */
#define BS_CAN_CTRL1_TSYN    (1U)          /*!< Bit field size in bits for CAN_CTRL1_TSYN. */

/*! @brief Read current value of the CAN_CTRL1_TSYN field. */
#define BR_CAN_CTRL1_TSYN(x) (HW_CAN_CTRL1(x).B.TSYN)

/*! @brief Format value for bitfield CAN_CTRL1_TSYN. */
#define BF_CAN_CTRL1_TSYN(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_TSYN) & BM_CAN_CTRL1_TSYN)

/*! @brief Set the TSYN field to a new value. */
#define BW_CAN_CTRL1_TSYN(x, v) (HW_CAN_CTRL1_WR(x, (HW_CAN_CTRL1_RD(x) & ~BM_CAN_CTRL1_TSYN) | BF_CAN_CTRL1_TSYN(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field BOFF_REC[6] (RW)
 *
 * This bit defines how FLEXCAN recovers from Bus Off state. If this bit is
 * negated, automatic recovering from Bus Off state occurs according to the CAN
 * Specification 2.0B. If the bit is asserted, automatic recovering from Bus Off is
 * disabled and the module remains in Bus Off state until the bit is negated by the
 * user. If the negation occurs before 128 sequences of 11 recessive bits are
 * detected on the CAN bus, then Bus Off recovery happens as if the BOFF_REC bit
 * had never been asserted. If the negation occurs after 128 sequences of 11
 * recessive bits occurred, then FLEXCAN will re-synchronize to the bus by waiting for
 * 11 recessive bits before joining the bus. After negation, the BOFF_REC bit can
 * be re-asserted again during Bus Off, but it will only be effective the next
 * time the module enters Bus Off. If BOFF_REC was negated when the module entered
 * Bus Off, asserting it during Bus Off will not be effective for the current
 * Bus Off recovery.
 *
 * Values:
 * - 1 - Automatic recovering from Bus Off state disabled
 * - 0 - Automatic recovering from Bus Off state enabled, according to CAN Spec
 *     2.0 part B
 */
/*@{*/
#define BP_CAN_CTRL1_BOFF_REC (6U)         /*!< Bit position for CAN_CTRL1_BOFF_REC. */
#define BM_CAN_CTRL1_BOFF_REC (0x00000040U) /*!< Bit mask for CAN_CTRL1_BOFF_REC. */
#define BS_CAN_CTRL1_BOFF_REC (1U)         /*!< Bit field size in bits for CAN_CTRL1_BOFF_REC. */

/*! @brief Read current value of the CAN_CTRL1_BOFF_REC field. */
#define BR_CAN_CTRL1_BOFF_REC(x) (HW_CAN_CTRL1(x).B.BOFF_REC)

/*! @brief Format value for bitfield CAN_CTRL1_BOFF_REC. */
#define BF_CAN_CTRL1_BOFF_REC(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_BOFF_REC) & BM_CAN_CTRL1_BOFF_REC)

/*! @brief Set the BOFF_REC field to a new value. */
#define BW_CAN_CTRL1_BOFF_REC(x, v) (HW_CAN_CTRL1_WR(x, (HW_CAN_CTRL1_RD(x) & ~BM_CAN_CTRL1_BOFF_REC) | BF_CAN_CTRL1_BOFF_REC(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field SMP[7] (RW)
 *
 * This bit defines the sampling mode of CAN bits at the FLEXCAN_RX. This bit
 * can only be written in Freeze mode as it is blocked by hardware in other modes.
 *
 * Values:
 * - 1 - Three samples are used to determine the value of the received bit: the
 *     regular one (sample point) and 2 preceding samples, a majority rule is used
 * - 0 - Just one sample is used to determine the bit value
 */
/*@{*/
#define BP_CAN_CTRL1_SMP     (7U)          /*!< Bit position for CAN_CTRL1_SMP. */
#define BM_CAN_CTRL1_SMP     (0x00000080U) /*!< Bit mask for CAN_CTRL1_SMP. */
#define BS_CAN_CTRL1_SMP     (1U)          /*!< Bit field size in bits for CAN_CTRL1_SMP. */

/*! @brief Read current value of the CAN_CTRL1_SMP field. */
#define BR_CAN_CTRL1_SMP(x)  (HW_CAN_CTRL1(x).B.SMP)

/*! @brief Format value for bitfield CAN_CTRL1_SMP. */
#define BF_CAN_CTRL1_SMP(v)  ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_SMP) & BM_CAN_CTRL1_SMP)

/*! @brief Set the SMP field to a new value. */
#define BW_CAN_CTRL1_SMP(x, v) (HW_CAN_CTRL1_WR(x, (HW_CAN_CTRL1_RD(x) & ~BM_CAN_CTRL1_SMP) | BF_CAN_CTRL1_SMP(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field RWRN_MSK[10] (RW)
 *
 * This bit provides a mask for the Rx Warning Interrupt associated with the
 * RWRN_INT flag in the Error and Status Register. This bit is read as zero when
 * MCR[WRN_EN] bit is negated. This bit can only be written if MCR[WRN_EN] bit is
 * asserted.
 *
 * Values:
 * - 1 - Rx Warning Interrupt enabled
 * - 0 - Rx Warning Interrupt disabled
 */
/*@{*/
#define BP_CAN_CTRL1_RWRN_MSK (10U)        /*!< Bit position for CAN_CTRL1_RWRN_MSK. */
#define BM_CAN_CTRL1_RWRN_MSK (0x00000400U) /*!< Bit mask for CAN_CTRL1_RWRN_MSK. */
#define BS_CAN_CTRL1_RWRN_MSK (1U)         /*!< Bit field size in bits for CAN_CTRL1_RWRN_MSK. */

/*! @brief Read current value of the CAN_CTRL1_RWRN_MSK field. */
#define BR_CAN_CTRL1_RWRN_MSK(x) (HW_CAN_CTRL1(x).B.RWRN_MSK)

/*! @brief Format value for bitfield CAN_CTRL1_RWRN_MSK. */
#define BF_CAN_CTRL1_RWRN_MSK(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_RWRN_MSK) & BM_CAN_CTRL1_RWRN_MSK)

/*! @brief Set the RWRN_MSK field to a new value. */
#define BW_CAN_CTRL1_RWRN_MSK(x, v) (HW_CAN_CTRL1_WR(x, (HW_CAN_CTRL1_RD(x) & ~BM_CAN_CTRL1_RWRN_MSK) | BF_CAN_CTRL1_RWRN_MSK(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field TWRN_MSK[11] (RW)
 *
 * This bit provides a mask for the Tx Warning Interrupt associated with the
 * TWRN_INT flag in the Error and Status Register. This bit is read as zero when
 * MCR[WRN_EN] bit is negated. This bit can only be written if MCR[WRN_EN] bit is
 * asserted.
 *
 * Values:
 * - 1 - Tx Warning Interrupt enabled
 * - 0 - Tx Warning Interrupt disabled
 */
/*@{*/
#define BP_CAN_CTRL1_TWRN_MSK (11U)        /*!< Bit position for CAN_CTRL1_TWRN_MSK. */
#define BM_CAN_CTRL1_TWRN_MSK (0x00000800U) /*!< Bit mask for CAN_CTRL1_TWRN_MSK. */
#define BS_CAN_CTRL1_TWRN_MSK (1U)         /*!< Bit field size in bits for CAN_CTRL1_TWRN_MSK. */

/*! @brief Read current value of the CAN_CTRL1_TWRN_MSK field. */
#define BR_CAN_CTRL1_TWRN_MSK(x) (HW_CAN_CTRL1(x).B.TWRN_MSK)

/*! @brief Format value for bitfield CAN_CTRL1_TWRN_MSK. */
#define BF_CAN_CTRL1_TWRN_MSK(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_TWRN_MSK) & BM_CAN_CTRL1_TWRN_MSK)

/*! @brief Set the TWRN_MSK field to a new value. */
#define BW_CAN_CTRL1_TWRN_MSK(x, v) (HW_CAN_CTRL1_WR(x, (HW_CAN_CTRL1_RD(x) & ~BM_CAN_CTRL1_TWRN_MSK) | BF_CAN_CTRL1_TWRN_MSK(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field LPB[12] (RW)
 *
 * This bit configures FlexCAN to operate in Loop-Back Mode. In this mode,
 * FlexCAN performs an internal loop back that can be used for self test operation.
 * The bit stream output of the transmitter is fed back internally to the receiver
 * input. The FLEXCAN_RX input pin is ignored and the FLEXCAN_TX output goes to
 * the recessive state (logic '1'). FlexCAN behaves as it normally does when
 * transmitting, and treats its own transmitted message as a message received from a
 * remote node. In this mode, FlexCAN ignores the bit sent during the ACK slot in
 * the CAN frame acknowledge field, generating an internal acknowledge bit to
 * ensure proper reception of its own message. Both transmit and receive interrupts
 * are generated. This bit can only be written in Freeze mode as it is blocked by
 * hardware in other modes.
 *
 * Values:
 * - 1 - Loop Back enabled
 * - 0 - Loop Back disabled
 */
/*@{*/
#define BP_CAN_CTRL1_LPB     (12U)         /*!< Bit position for CAN_CTRL1_LPB. */
#define BM_CAN_CTRL1_LPB     (0x00001000U) /*!< Bit mask for CAN_CTRL1_LPB. */
#define BS_CAN_CTRL1_LPB     (1U)          /*!< Bit field size in bits for CAN_CTRL1_LPB. */

/*! @brief Read current value of the CAN_CTRL1_LPB field. */
#define BR_CAN_CTRL1_LPB(x)  (HW_CAN_CTRL1(x).B.LPB)

/*! @brief Format value for bitfield CAN_CTRL1_LPB. */
#define BF_CAN_CTRL1_LPB(v)  ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_LPB) & BM_CAN_CTRL1_LPB)

/*! @brief Set the LPB field to a new value. */
#define BW_CAN_CTRL1_LPB(x, v) (HW_CAN_CTRL1_WR(x, (HW_CAN_CTRL1_RD(x) & ~BM_CAN_CTRL1_LPB) | BF_CAN_CTRL1_LPB(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field ERR_MSK[14] (RW)
 *
 * This bit provides a mask for the Error Interrupt.
 *
 * Values:
 * - 1 - Error interrupt enabled
 * - 0 - Error interrupt disabled
 */
/*@{*/
#define BP_CAN_CTRL1_ERR_MSK (14U)         /*!< Bit position for CAN_CTRL1_ERR_MSK. */
#define BM_CAN_CTRL1_ERR_MSK (0x00004000U) /*!< Bit mask for CAN_CTRL1_ERR_MSK. */
#define BS_CAN_CTRL1_ERR_MSK (1U)          /*!< Bit field size in bits for CAN_CTRL1_ERR_MSK. */

/*! @brief Read current value of the CAN_CTRL1_ERR_MSK field. */
#define BR_CAN_CTRL1_ERR_MSK(x) (HW_CAN_CTRL1(x).B.ERR_MSK)

/*! @brief Format value for bitfield CAN_CTRL1_ERR_MSK. */
#define BF_CAN_CTRL1_ERR_MSK(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_ERR_MSK) & BM_CAN_CTRL1_ERR_MSK)

/*! @brief Set the ERR_MSK field to a new value. */
#define BW_CAN_CTRL1_ERR_MSK(x, v) (HW_CAN_CTRL1_WR(x, (HW_CAN_CTRL1_RD(x) & ~BM_CAN_CTRL1_ERR_MSK) | BF_CAN_CTRL1_ERR_MSK(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field BOFF_MSK[15] (RW)
 *
 * This bit provides a mask for the Bus Off Interrupt.
 *
 * Values:
 * - 1 - Bus Off interrupt enabled
 * - 0 - Bus Off interrupt disabled
 */
/*@{*/
#define BP_CAN_CTRL1_BOFF_MSK (15U)        /*!< Bit position for CAN_CTRL1_BOFF_MSK. */
#define BM_CAN_CTRL1_BOFF_MSK (0x00008000U) /*!< Bit mask for CAN_CTRL1_BOFF_MSK. */
#define BS_CAN_CTRL1_BOFF_MSK (1U)         /*!< Bit field size in bits for CAN_CTRL1_BOFF_MSK. */

/*! @brief Read current value of the CAN_CTRL1_BOFF_MSK field. */
#define BR_CAN_CTRL1_BOFF_MSK(x) (HW_CAN_CTRL1(x).B.BOFF_MSK)

/*! @brief Format value for bitfield CAN_CTRL1_BOFF_MSK. */
#define BF_CAN_CTRL1_BOFF_MSK(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_BOFF_MSK) & BM_CAN_CTRL1_BOFF_MSK)

/*! @brief Set the BOFF_MSK field to a new value. */
#define BW_CAN_CTRL1_BOFF_MSK(x, v) (HW_CAN_CTRL1_WR(x, (HW_CAN_CTRL1_RD(x) & ~BM_CAN_CTRL1_BOFF_MSK) | BF_CAN_CTRL1_BOFF_MSK(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field PSEG2[18:16] (RW)
 *
 * This 3-bit field defines the length of Phase Buffer Segment 2 in the bit
 * time. The valid programmable values are 1-7. This field can only be written in
 * Freeze mode as it is blocked by hardware in other modes Phase Buffer Segment 2 =
 * (PSEG2 + 1) x Time-Quanta.
 */
/*@{*/
#define BP_CAN_CTRL1_PSEG2   (16U)         /*!< Bit position for CAN_CTRL1_PSEG2. */
#define BM_CAN_CTRL1_PSEG2   (0x00070000U) /*!< Bit mask for CAN_CTRL1_PSEG2. */
#define BS_CAN_CTRL1_PSEG2   (3U)          /*!< Bit field size in bits for CAN_CTRL1_PSEG2. */

/*! @brief Read current value of the CAN_CTRL1_PSEG2 field. */
#define BR_CAN_CTRL1_PSEG2(x) (HW_CAN_CTRL1(x).B.PSEG2)

/*! @brief Format value for bitfield CAN_CTRL1_PSEG2. */
#define BF_CAN_CTRL1_PSEG2(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_PSEG2) & BM_CAN_CTRL1_PSEG2)

/*! @brief Set the PSEG2 field to a new value. */
#define BW_CAN_CTRL1_PSEG2(x, v) (HW_CAN_CTRL1_WR(x, (HW_CAN_CTRL1_RD(x) & ~BM_CAN_CTRL1_PSEG2) | BF_CAN_CTRL1_PSEG2(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field PSEG1[21:19] (RW)
 *
 * This 3-bit field defines the length of Phase Buffer Segment 1 in the bit
 * time. The valid programmable values are 0-7. This field can only be written in
 * Freeze mode as it is blocked by hardware in other modes Phase Buffer Segment 1 =
 * (PSEG1 + 1) x Time-Quanta.
 */
/*@{*/
#define BP_CAN_CTRL1_PSEG1   (19U)         /*!< Bit position for CAN_CTRL1_PSEG1. */
#define BM_CAN_CTRL1_PSEG1   (0x00380000U) /*!< Bit mask for CAN_CTRL1_PSEG1. */
#define BS_CAN_CTRL1_PSEG1   (3U)          /*!< Bit field size in bits for CAN_CTRL1_PSEG1. */

/*! @brief Read current value of the CAN_CTRL1_PSEG1 field. */
#define BR_CAN_CTRL1_PSEG1(x) (HW_CAN_CTRL1(x).B.PSEG1)

/*! @brief Format value for bitfield CAN_CTRL1_PSEG1. */
#define BF_CAN_CTRL1_PSEG1(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_PSEG1) & BM_CAN_CTRL1_PSEG1)

/*! @brief Set the PSEG1 field to a new value. */
#define BW_CAN_CTRL1_PSEG1(x, v) (HW_CAN_CTRL1_WR(x, (HW_CAN_CTRL1_RD(x) & ~BM_CAN_CTRL1_PSEG1) | BF_CAN_CTRL1_PSEG1(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field RJW[23:22] (RW)
 *
 * This 2-bit field defines the maximum number of time quanta One time quantum
 * is equal to the Sclock period. that a bit time can be changed by one
 * re-synchronization. The valid programmable values are 0-3. This field can only be
 * written in Freeze mode as it is blocked by hardware in other modes Resync Jump Width
 * = RJW + 1.
 */
/*@{*/
#define BP_CAN_CTRL1_RJW     (22U)         /*!< Bit position for CAN_CTRL1_RJW. */
#define BM_CAN_CTRL1_RJW     (0x00C00000U) /*!< Bit mask for CAN_CTRL1_RJW. */
#define BS_CAN_CTRL1_RJW     (2U)          /*!< Bit field size in bits for CAN_CTRL1_RJW. */

/*! @brief Read current value of the CAN_CTRL1_RJW field. */
#define BR_CAN_CTRL1_RJW(x)  (HW_CAN_CTRL1(x).B.RJW)

/*! @brief Format value for bitfield CAN_CTRL1_RJW. */
#define BF_CAN_CTRL1_RJW(v)  ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_RJW) & BM_CAN_CTRL1_RJW)

/*! @brief Set the RJW field to a new value. */
#define BW_CAN_CTRL1_RJW(x, v) (HW_CAN_CTRL1_WR(x, (HW_CAN_CTRL1_RD(x) & ~BM_CAN_CTRL1_RJW) | BF_CAN_CTRL1_RJW(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field PRESDIV[31:24] (RW)
 *
 * This 8-bit field defines the ratio between the PE clock frequency and the
 * Serial Clock (Sclock) frequency. The Sclock period defines the time quantum of
 * the CAN protocol. For the reset value, the Sclock frequency is equal to the PE
 * clock frequency. The Maximum value of this register is 0xFF, that gives a
 * minimum Sclock frequency equal to the PE clock frequency divided by 256.For more
 * information refer to Protocol Timing. This field can only be written in Freeze
 * mode as it is blocked by hardware in other modes. Sclock frequency = CPI clock
 * frequency / (PRESDIV+1)
 */
/*@{*/
#define BP_CAN_CTRL1_PRESDIV (24U)         /*!< Bit position for CAN_CTRL1_PRESDIV. */
#define BM_CAN_CTRL1_PRESDIV (0xFF000000U) /*!< Bit mask for CAN_CTRL1_PRESDIV. */
#define BS_CAN_CTRL1_PRESDIV (8U)          /*!< Bit field size in bits for CAN_CTRL1_PRESDIV. */

/*! @brief Read current value of the CAN_CTRL1_PRESDIV field. */
#define BR_CAN_CTRL1_PRESDIV(x) (HW_CAN_CTRL1(x).B.PRESDIV)

/*! @brief Format value for bitfield CAN_CTRL1_PRESDIV. */
#define BF_CAN_CTRL1_PRESDIV(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_PRESDIV) & BM_CAN_CTRL1_PRESDIV)

/*! @brief Set the PRESDIV field to a new value. */
#define BW_CAN_CTRL1_PRESDIV(x, v) (HW_CAN_CTRL1_WR(x, (HW_CAN_CTRL1_RD(x) & ~BM_CAN_CTRL1_PRESDIV) | BF_CAN_CTRL1_PRESDIV(v)))
/*@}*/

/*******************************************************************************
 * HW_CAN_TIMER - Free Running Timer Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_TIMER - Free Running Timer Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register represents a 16-bit free running counter that can be read and
 * written by the ARM. The timer starts from $0000 after Reset, counts linearly to
 * $FFFF, and wraps around. The timer is clocked by the FLEXCAN bit-clock (which
 * defines the baud rate on the CAN bus). During a message
 * transmission/reception, it increments by one for each bit that is received or transmitted. When
 * there is no message on the bus, it counts using the previously programmed baud
 * rate. During Freeze Mode, disable, and stop mode, the timer is not incremented.
 * The timer value is captured at the beginning of the identifier field of any
 * frame on the CAN bus. This captured value is written into the Time Stamp entry
 * in a message buffer after a successful reception or transmission of a message.
 * If bit CTRL1[TSYN] is asserted the Timer is reset whenever a message is
 * received in the first available Mailbox, according to CTRL2[RFFN] setting. ARM can
 * write to this register anytime. However, if the write occurs at the same time
 * that the Timer is being reset by a reception in the first Mailbox, then the
 * write value is discarded. Reading this register affects the Mailbox Unlocking
 * procedure. For additional details, refer to Message Buffer Lock MechanismBesides
 * MB inactivation, FlexCAN has another data coherence mechanism for the receive
 * process. When ARM reads the Control and Status word of an Rx MB with codes
 * FULL or OVERRUN, FlexCAN assumes that ARM wants to read the whole MB in an atomic
 * operation, and thus it sets an internal lock flag for that MB. The lock is
 * released when ARM reads the Free Running Timer (global unlock operation), or
 * when it reads the Control and Status word of another MB regardless of its code or
 * when ARM writes into C/S word from locked MB. The MB locking is done to
 * prevent a new frame to be written into the MB while ARM is reading it. .
 */
typedef union _hw_can_timer
{
    uint32_t U;
    struct _hw_can_timer_bitfields
    {
        uint32_t TIMER : 16;           /*!< [15:0]  */
        uint32_t RESERVED0 : 16;       /*!< [31:16]  */
    } B;
} hw_can_timer_t;

/*!
 * @name Constants and macros for entire CAN_TIMER register
 */
/*@{*/
#define HW_CAN_TIMER_ADDR(x)     ((uintptr_t)(x) + 0x8U)

#define HW_CAN_TIMER(x)          (*(__IO hw_can_timer_t *) HW_CAN_TIMER_ADDR(x))
#define HW_CAN_TIMER_RD(x)       (HW_CAN_TIMER(x).U)
#define HW_CAN_TIMER_WR(x, v)    (HW_CAN_TIMER(x).U = (v))
#define HW_CAN_TIMER_SET(x, v)   (HW_CAN_TIMER_WR(x, HW_CAN_TIMER_RD(x) |  (v)))
#define HW_CAN_TIMER_CLR(x, v)   (HW_CAN_TIMER_WR(x, HW_CAN_TIMER_RD(x) & ~(v)))
#define HW_CAN_TIMER_TOG(x, v)   (HW_CAN_TIMER_WR(x, HW_CAN_TIMER_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_TIMER bitfields
 */

/*!
 * @name Register CAN_TIMER, field TIMER[15:0] (RW)
 *
 * TIMER
 */
/*@{*/
#define BP_CAN_TIMER_TIMER   (0U)          /*!< Bit position for CAN_TIMER_TIMER. */
#define BM_CAN_TIMER_TIMER   (0x0000FFFFU) /*!< Bit mask for CAN_TIMER_TIMER. */
#define BS_CAN_TIMER_TIMER   (16U)         /*!< Bit field size in bits for CAN_TIMER_TIMER. */

/*! @brief Read current value of the CAN_TIMER_TIMER field. */
#define BR_CAN_TIMER_TIMER(x) (HW_CAN_TIMER(x).B.TIMER)

/*! @brief Format value for bitfield CAN_TIMER_TIMER. */
#define BF_CAN_TIMER_TIMER(v) ((uint32_t)((uint32_t)(v) << BP_CAN_TIMER_TIMER) & BM_CAN_TIMER_TIMER)

/*! @brief Set the TIMER field to a new value. */
#define BW_CAN_TIMER_TIMER(x, v) (HW_CAN_TIMER_WR(x, (HW_CAN_TIMER_RD(x) & ~BM_CAN_TIMER_TIMER) | BF_CAN_TIMER_TIMER(v)))
/*@}*/

/*******************************************************************************
 * HW_CAN_RXMGMASK - Rx Mailboxes Global Mask Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_RXMGMASK - Rx Mailboxes Global Mask Register (RW)
 *
 * Reset value: 0xFFFFFFFFU
 *
 * RXMGMASK is provided for legacy support. Asserting the MCR[IRMQ] bit causes
 * the RXMGMASK Register to have no effect on the module operation. RXMGMASK is
 * used to mask the filter fields of all Rx MBs, excluding MBs 14-15, which have
 * individual mask registers. This register can only be written in Freeze mode as
 * it is blocked by hardware in other modes. Rx Mailboxes Global Mask usage
 * SMB[RTR]RTR bit of the Incoming Frame. It is saved into an auxiliary MB called Rx
 * Serial Message Buffer (Rx SMB). CTRL2[RRS] CTRL2[EACEN] Mailbox filter fields
 * MB[RTR] MB[IDE] MB[ID] reserved 0 - 0 - NoteIf CTRL2[EACEN] bit is negated the
 * RTR bit of Mailbox is never compared with the RTR bit of the Incoming Frame (Rx
 * SMB[RTR]). - NoteIf CTRL2[EACEN] bit is negated the IDE bit of Mailbox is
 * always compared with the IDE bit of the Incoming Frame (Rx SMB[IDE]). MG[28:0]
 * MG[31:29] 0 - 1 MG[31] MG[30] MG[28:0] MG[29] 1 0 - - - - MG[31:0] 1 1 0 - -
 * MG[28:0] MG[31:29] 1 1 1 MG[31] MG[30] MG[28:0] MG[29]
 */
typedef union _hw_can_rxmgmask
{
    uint32_t U;
    struct _hw_can_rxmgmask_bitfields
    {
        uint32_t MG31_MG0 : 32;        /*!< [31:0]  */
    } B;
} hw_can_rxmgmask_t;

/*!
 * @name Constants and macros for entire CAN_RXMGMASK register
 */
/*@{*/
#define HW_CAN_RXMGMASK_ADDR(x)  ((uintptr_t)(x) + 0x10U)

#define HW_CAN_RXMGMASK(x)       (*(__IO hw_can_rxmgmask_t *) HW_CAN_RXMGMASK_ADDR(x))
#define HW_CAN_RXMGMASK_RD(x)    (HW_CAN_RXMGMASK(x).U)
#define HW_CAN_RXMGMASK_WR(x, v) (HW_CAN_RXMGMASK(x).U = (v))
#define HW_CAN_RXMGMASK_SET(x, v) (HW_CAN_RXMGMASK_WR(x, HW_CAN_RXMGMASK_RD(x) |  (v)))
#define HW_CAN_RXMGMASK_CLR(x, v) (HW_CAN_RXMGMASK_WR(x, HW_CAN_RXMGMASK_RD(x) & ~(v)))
#define HW_CAN_RXMGMASK_TOG(x, v) (HW_CAN_RXMGMASK_WR(x, HW_CAN_RXMGMASK_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_RXMGMASK bitfields
 */

/*!
 * @name Register CAN_RXMGMASK, field MG31_MG0[31:0] (RW)
 *
 * These bits mask the Mailbox filter bits as shown in the figure above. Note
 * that the alignment with the ID word of the Mailbox is not perfect as the two
 * most significant MG bits affect the fields RTR and IDE which are located in the
 * Control and Status word of the Mailbox. RXMGMASKRx Mailboxes Global Mask
 * Register shows in detail which MG bits mask each Mailbox filter field.
 *
 * Values:
 * - 1 - The corresponding bit in the filter is checked against the one received
 * - 0 - the corresponding bit in the filter is "don't care"
 */
/*@{*/
#define BP_CAN_RXMGMASK_MG31_MG0 (0U)      /*!< Bit position for CAN_RXMGMASK_MG31_MG0. */
#define BM_CAN_RXMGMASK_MG31_MG0 (0xFFFFFFFFU) /*!< Bit mask for CAN_RXMGMASK_MG31_MG0. */
#define BS_CAN_RXMGMASK_MG31_MG0 (32U)     /*!< Bit field size in bits for CAN_RXMGMASK_MG31_MG0. */

/*! @brief Read current value of the CAN_RXMGMASK_MG31_MG0 field. */
#define BR_CAN_RXMGMASK_MG31_MG0(x) (HW_CAN_RXMGMASK(x).U)

/*! @brief Format value for bitfield CAN_RXMGMASK_MG31_MG0. */
#define BF_CAN_RXMGMASK_MG31_MG0(v) ((uint32_t)((uint32_t)(v) << BP_CAN_RXMGMASK_MG31_MG0) & BM_CAN_RXMGMASK_MG31_MG0)

/*! @brief Set the MG31_MG0 field to a new value. */
#define BW_CAN_RXMGMASK_MG31_MG0(x, v) (HW_CAN_RXMGMASK_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_CAN_RX14MASK - Rx Buffer 14 Mask Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_RX14MASK - Rx Buffer 14 Mask Register (RW)
 *
 * Reset value: 0xFFFFFFFFU
 *
 * RX14MASK is provided for legacy support, asserting the MCR[IRMQ] bit causes
 * the RX14MASK to have no effect on the module operation. RX14MASK is used to
 * mask the filter fields of Message Buffer 14. This register can only be programmed
 * while the module is in Freeze Mode as it is blocked by hardware in other
 * modes.
 */
typedef union _hw_can_rx14mask
{
    uint32_t U;
    struct _hw_can_rx14mask_bitfields
    {
        uint32_t RX14M31_RX14M0 : 32;  /*!< [31:0]  */
    } B;
} hw_can_rx14mask_t;

/*!
 * @name Constants and macros for entire CAN_RX14MASK register
 */
/*@{*/
#define HW_CAN_RX14MASK_ADDR(x)  ((uintptr_t)(x) + 0x14U)

#define HW_CAN_RX14MASK(x)       (*(__IO hw_can_rx14mask_t *) HW_CAN_RX14MASK_ADDR(x))
#define HW_CAN_RX14MASK_RD(x)    (HW_CAN_RX14MASK(x).U)
#define HW_CAN_RX14MASK_WR(x, v) (HW_CAN_RX14MASK(x).U = (v))
#define HW_CAN_RX14MASK_SET(x, v) (HW_CAN_RX14MASK_WR(x, HW_CAN_RX14MASK_RD(x) |  (v)))
#define HW_CAN_RX14MASK_CLR(x, v) (HW_CAN_RX14MASK_WR(x, HW_CAN_RX14MASK_RD(x) & ~(v)))
#define HW_CAN_RX14MASK_TOG(x, v) (HW_CAN_RX14MASK_WR(x, HW_CAN_RX14MASK_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_RX14MASK bitfields
 */

/*!
 * @name Register CAN_RX14MASK, field RX14M31_RX14M0[31:0] (RW)
 *
 * These bits mask Mailbox 14 filter bits in the same fashion as RXMGMASK masks
 * other Mailboxes filters (see RXMGMASKRx Mailboxes Global Mask Register )
 *
 * Values:
 * - 1 - The corresponding bit in the filter is checked
 * - 0 - the corresponding bit in the filter is "don't care"
 */
/*@{*/
#define BP_CAN_RX14MASK_RX14M31_RX14M0 (0U) /*!< Bit position for CAN_RX14MASK_RX14M31_RX14M0. */
#define BM_CAN_RX14MASK_RX14M31_RX14M0 (0xFFFFFFFFU) /*!< Bit mask for CAN_RX14MASK_RX14M31_RX14M0. */
#define BS_CAN_RX14MASK_RX14M31_RX14M0 (32U) /*!< Bit field size in bits for CAN_RX14MASK_RX14M31_RX14M0. */

/*! @brief Read current value of the CAN_RX14MASK_RX14M31_RX14M0 field. */
#define BR_CAN_RX14MASK_RX14M31_RX14M0(x) (HW_CAN_RX14MASK(x).U)

/*! @brief Format value for bitfield CAN_RX14MASK_RX14M31_RX14M0. */
#define BF_CAN_RX14MASK_RX14M31_RX14M0(v) ((uint32_t)((uint32_t)(v) << BP_CAN_RX14MASK_RX14M31_RX14M0) & BM_CAN_RX14MASK_RX14M31_RX14M0)

/*! @brief Set the RX14M31_RX14M0 field to a new value. */
#define BW_CAN_RX14MASK_RX14M31_RX14M0(x, v) (HW_CAN_RX14MASK_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_CAN_RX15MASK - Rx Buffer 15 Mask Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_RX15MASK - Rx Buffer 15 Mask Register (RW)
 *
 * Reset value: 0xFFFFFFFFU
 *
 * RX15MASK is provided for legacy support, asserting the MCR[IRMQ] bit causes
 * the RX15MASK Register to have no effect on the module operation. RX15MASK is
 * used to mask the filter fields of Message Buffer 15. This register can only be
 * programmed while the module is in Freeze Mode as it is blocked by hardware in
 * other modes.
 */
typedef union _hw_can_rx15mask
{
    uint32_t U;
    struct _hw_can_rx15mask_bitfields
    {
        uint32_t RX15M31_RX15M0 : 32;  /*!< [31:0]  */
    } B;
} hw_can_rx15mask_t;

/*!
 * @name Constants and macros for entire CAN_RX15MASK register
 */
/*@{*/
#define HW_CAN_RX15MASK_ADDR(x)  ((uintptr_t)(x) + 0x18U)

#define HW_CAN_RX15MASK(x)       (*(__IO hw_can_rx15mask_t *) HW_CAN_RX15MASK_ADDR(x))
#define HW_CAN_RX15MASK_RD(x)    (HW_CAN_RX15MASK(x).U)
#define HW_CAN_RX15MASK_WR(x, v) (HW_CAN_RX15MASK(x).U = (v))
#define HW_CAN_RX15MASK_SET(x, v) (HW_CAN_RX15MASK_WR(x, HW_CAN_RX15MASK_RD(x) |  (v)))
#define HW_CAN_RX15MASK_CLR(x, v) (HW_CAN_RX15MASK_WR(x, HW_CAN_RX15MASK_RD(x) & ~(v)))
#define HW_CAN_RX15MASK_TOG(x, v) (HW_CAN_RX15MASK_WR(x, HW_CAN_RX15MASK_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_RX15MASK bitfields
 */

/*!
 * @name Register CAN_RX15MASK, field RX15M31_RX15M0[31:0] (RW)
 *
 * These bits mask Mailbox 15 filter bits in the same fashion as RXMGMASK masks
 * other Mailboxes filters (see RXMGMASKRx Mailboxes Global Mask Register ).
 *
 * Values:
 * - 1 - The corresponding bit in the filter is checked
 * - 0 - the corresponding bit in the filter is "don't care"
 */
/*@{*/
#define BP_CAN_RX15MASK_RX15M31_RX15M0 (0U) /*!< Bit position for CAN_RX15MASK_RX15M31_RX15M0. */
#define BM_CAN_RX15MASK_RX15M31_RX15M0 (0xFFFFFFFFU) /*!< Bit mask for CAN_RX15MASK_RX15M31_RX15M0. */
#define BS_CAN_RX15MASK_RX15M31_RX15M0 (32U) /*!< Bit field size in bits for CAN_RX15MASK_RX15M31_RX15M0. */

/*! @brief Read current value of the CAN_RX15MASK_RX15M31_RX15M0 field. */
#define BR_CAN_RX15MASK_RX15M31_RX15M0(x) (HW_CAN_RX15MASK(x).U)

/*! @brief Format value for bitfield CAN_RX15MASK_RX15M31_RX15M0. */
#define BF_CAN_RX15MASK_RX15M31_RX15M0(v) ((uint32_t)((uint32_t)(v) << BP_CAN_RX15MASK_RX15M31_RX15M0) & BM_CAN_RX15MASK_RX15M31_RX15M0)

/*! @brief Set the RX15M31_RX15M0 field to a new value. */
#define BW_CAN_RX15MASK_RX15M31_RX15M0(x, v) (HW_CAN_RX15MASK_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_CAN_ECR - Error Counter Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_ECR - Error Counter Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register has 2 8-bit fields reflecting the value of two FLEXCAN error
 * counters: Transmit Error Counter (Tx_Err_Counter field) and Receive Error
 * Counter (Rx_Err_Counter field). The rules for increasing and decreasing these
 * counters are described in the CAN protocol and are completely implemented in the
 * FLEXCAN module. Both counters are read only except in Freeze Mode, where they can
 * be written by the ARM. FLEXCAN responds to any bus state as described in the
 * protocol, e.g. transmit 'Error Active' or 'Error Passive' flag, delay its
 * transmission start time ('Error Passive') and avoid any influence on the bus when
 * in 'Bus Off' state. The following are the basic rules for FLEXCAN bus state
 * transitions. If the value of Tx_Err_Counter or Rx_Err_Counter increases to be
 * greater than or equal to 128, the FLT_CONF field in the Error and Status
 * Register is updated to reflect 'Error Passive' state. If the FLEXCAN state is 'Error
 * Passive', and either Tx_Err_Counter or Rx_Err_Counter decrements to a value
 * less than or equal to 127 while the other already satisfies this condition, the
 * FLT_CONF field in the Error and Status Register is updated to reflect 'Error
 * Active' state. If the value of Tx_Err_Counter increases to be greater than 255,
 * the FLT_CONF field in the Error and Status Register is updated to reflect
 * 'Bus Off' state, and an interrupt may be issued. The value of Tx_Err_Counter is
 * then reset to zero. If FLEXCAN is in 'Bus Off' state, then Tx_Err_Counter is
 * cascaded together with another internal counter to count the 128th occurrences
 * of 11 consecutive recessive bits on the bus. Hence, Tx_Err_Counter is reset to
 * zero and counts in a manner where the internal counter counts 11 such bits and
 * then wraps around while incrementing the Tx_Err_Counter. When Tx_Err_Counter
 * reaches the value of 128, the FLT_CONF field in the Error and Status Register
 * is updated to be 'Error Active' and both error counters are reset to zero. At
 * any instance of dominant bit following a stream of less than 11 consecutive
 * recessive bits, the internal counter resets itself to zero without affecting the
 * Tx_Err_Counter value. If during system start-up, only one node is operating,
 * then its Tx_Err_Counter increases in each message it is trying to transmit, as
 * a result of acknowledge errors (indicated by the ACK_ERR bit in the Error and
 * Status Register). After the transition to 'Error Passive' state, the
 * Tx_Err_Counter does not increment anymore by acknowledge errors. Therefore the device
 * never goes to the 'Bus Off' state. If the Rx_Err_Counter increases to a value
 * greater than 127, it is not incremented further, even if more errors are
 * detected while being a receiver. At the next successful message reception, the
 * counter is set to a value between 119 and 127 to resume to 'Error Active' state.
 */
typedef union _hw_can_ecr
{
    uint32_t U;
    struct _hw_can_ecr_bitfields
    {
        uint32_t Tx_Err_Counter : 8;   /*!< [7:0]  */
        uint32_t Rx_Err_Counter : 8;   /*!< [15:8]  */
        uint32_t RESERVED0 : 16;       /*!< [31:16]  */
    } B;
} hw_can_ecr_t;

/*!
 * @name Constants and macros for entire CAN_ECR register
 */
/*@{*/
#define HW_CAN_ECR_ADDR(x)       ((uintptr_t)(x) + 0x1CU)

#define HW_CAN_ECR(x)            (*(__IO hw_can_ecr_t *) HW_CAN_ECR_ADDR(x))
#define HW_CAN_ECR_RD(x)         (HW_CAN_ECR(x).U)
#define HW_CAN_ECR_WR(x, v)      (HW_CAN_ECR(x).U = (v))
#define HW_CAN_ECR_SET(x, v)     (HW_CAN_ECR_WR(x, HW_CAN_ECR_RD(x) |  (v)))
#define HW_CAN_ECR_CLR(x, v)     (HW_CAN_ECR_WR(x, HW_CAN_ECR_RD(x) & ~(v)))
#define HW_CAN_ECR_TOG(x, v)     (HW_CAN_ECR_WR(x, HW_CAN_ECR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_ECR bitfields
 */

/*!
 * @name Register CAN_ECR, field Tx_Err_Counter[7:0] (RW)
 *
 * Tx_Err_Counter
 */
/*@{*/
#define BP_CAN_ECR_Tx_Err_Counter (0U)     /*!< Bit position for CAN_ECR_Tx_Err_Counter. */
#define BM_CAN_ECR_Tx_Err_Counter (0x000000FFU) /*!< Bit mask for CAN_ECR_Tx_Err_Counter. */
#define BS_CAN_ECR_Tx_Err_Counter (8U)     /*!< Bit field size in bits for CAN_ECR_Tx_Err_Counter. */

/*! @brief Read current value of the CAN_ECR_Tx_Err_Counter field. */
#define BR_CAN_ECR_Tx_Err_Counter(x) (HW_CAN_ECR(x).B.Tx_Err_Counter)

/*! @brief Format value for bitfield CAN_ECR_Tx_Err_Counter. */
#define BF_CAN_ECR_Tx_Err_Counter(v) ((uint32_t)((uint32_t)(v) << BP_CAN_ECR_Tx_Err_Counter) & BM_CAN_ECR_Tx_Err_Counter)

/*! @brief Set the Tx_Err_Counter field to a new value. */
#define BW_CAN_ECR_Tx_Err_Counter(x, v) (HW_CAN_ECR_WR(x, (HW_CAN_ECR_RD(x) & ~BM_CAN_ECR_Tx_Err_Counter) | BF_CAN_ECR_Tx_Err_Counter(v)))
/*@}*/

/*!
 * @name Register CAN_ECR, field Rx_Err_Counter[15:8] (RW)
 *
 * Rx_Err_Counter
 */
/*@{*/
#define BP_CAN_ECR_Rx_Err_Counter (8U)     /*!< Bit position for CAN_ECR_Rx_Err_Counter. */
#define BM_CAN_ECR_Rx_Err_Counter (0x0000FF00U) /*!< Bit mask for CAN_ECR_Rx_Err_Counter. */
#define BS_CAN_ECR_Rx_Err_Counter (8U)     /*!< Bit field size in bits for CAN_ECR_Rx_Err_Counter. */

/*! @brief Read current value of the CAN_ECR_Rx_Err_Counter field. */
#define BR_CAN_ECR_Rx_Err_Counter(x) (HW_CAN_ECR(x).B.Rx_Err_Counter)

/*! @brief Format value for bitfield CAN_ECR_Rx_Err_Counter. */
#define BF_CAN_ECR_Rx_Err_Counter(v) ((uint32_t)((uint32_t)(v) << BP_CAN_ECR_Rx_Err_Counter) & BM_CAN_ECR_Rx_Err_Counter)

/*! @brief Set the Rx_Err_Counter field to a new value. */
#define BW_CAN_ECR_Rx_Err_Counter(x, v) (HW_CAN_ECR_WR(x, (HW_CAN_ECR_RD(x) & ~BM_CAN_ECR_Rx_Err_Counter) | BF_CAN_ECR_Rx_Err_Counter(v)))
/*@}*/

/*******************************************************************************
 * HW_CAN_ESR1 - Error and Status 1 Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_ESR1 - Error and Status 1 Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register reflects various error conditions, some general status of the
 * device and it is the source of four interrupts to the ARM. The ARM read action
 * clears bits 15-10, therefore the reported error conditions (bits 15-10) are
 * those that occurred since the last time the ARM read this register. Bits 9-3 are
 * status bits. Some bits in this register are read-only and some are not.
 * FlexCAN State SYNCH IDLE TX RX FlexCAN state 0 0 0 0 Not synchronized to CAN bus 1
 * 1 x x Idle 1 0 1 0 Transmitting 1 0 0 1 Receiving other combinations Reserved
 */
typedef union _hw_can_esr1
{
    uint32_t U;
    struct _hw_can_esr1_bitfields
    {
        uint32_t WAK_INT : 1;          /*!< [0]  */
        uint32_t ERR_INT : 1;          /*!< [1]  */
        uint32_t BOFF_INT : 1;         /*!< [2]  */
        uint32_t RX : 1;               /*!< [3]  */
        uint32_t FLT_CONF : 2;         /*!< [5:4]  */
        uint32_t TX : 1;               /*!< [6]  */
        uint32_t IDLE : 1;             /*!< [7]  */
        uint32_t RX_WRN : 1;           /*!< [8]  */
        uint32_t TX_WRN : 1;           /*!< [9]  */
        uint32_t STF_ERR : 1;          /*!< [10]  */
        uint32_t FRM_ERR : 1;          /*!< [11]  */
        uint32_t CRC_ERR : 1;          /*!< [12]  */
        uint32_t ACK_ERR : 1;          /*!< [13]  */
        uint32_t BIT0_ERR : 1;         /*!< [14]  */
        uint32_t BIT1_ERR : 1;         /*!< [15]  */
        uint32_t RWRN_INT : 1;         /*!< [16]  */
        uint32_t TWRN_INT : 1;         /*!< [17]  */
        uint32_t SYNCH : 1;            /*!< [18]  */
        uint32_t RESERVED0 : 13;       /*!< [31:19]  */
    } B;
} hw_can_esr1_t;

/*!
 * @name Constants and macros for entire CAN_ESR1 register
 */
/*@{*/
#define HW_CAN_ESR1_ADDR(x)      ((uintptr_t)(x) + 0x20U)

#define HW_CAN_ESR1(x)           (*(__IO hw_can_esr1_t *) HW_CAN_ESR1_ADDR(x))
#define HW_CAN_ESR1_RD(x)        (HW_CAN_ESR1(x).U)
#define HW_CAN_ESR1_WR(x, v)     (HW_CAN_ESR1(x).U = (v))
#define HW_CAN_ESR1_SET(x, v)    (HW_CAN_ESR1_WR(x, HW_CAN_ESR1_RD(x) |  (v)))
#define HW_CAN_ESR1_CLR(x, v)    (HW_CAN_ESR1_WR(x, HW_CAN_ESR1_RD(x) & ~(v)))
#define HW_CAN_ESR1_TOG(x, v)    (HW_CAN_ESR1_WR(x, HW_CAN_ESR1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_ESR1 bitfields
 */

/*!
 * @name Register CAN_ESR1, field WAK_INT[0] (RW)
 *
 * When FLEXCAN is Stop Mode and a recessive to dominant transition is detected
 * on the CAN bus and if the WAK_MSK bit in the MCR Register is set, an interrupt
 * is generated to the ARM. This bit is cleared by writing it to '1'. When
 * SLF_WAK is negated, this flag is masked. ARM must clear this flag before disabling
 * the bit. Otherwise it will be set when the SLF_WAK is set again. Writing '0'
 * has no effect
 *
 * Values:
 * - 1 - Indicates a recessive to dominant transition received on the CAN bus
 *     when the FLEXCAN module is in Stop Mode
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_ESR1_WAK_INT  (0U)          /*!< Bit position for CAN_ESR1_WAK_INT. */
#define BM_CAN_ESR1_WAK_INT  (0x00000001U) /*!< Bit mask for CAN_ESR1_WAK_INT. */
#define BS_CAN_ESR1_WAK_INT  (1U)          /*!< Bit field size in bits for CAN_ESR1_WAK_INT. */

/*! @brief Read current value of the CAN_ESR1_WAK_INT field. */
#define BR_CAN_ESR1_WAK_INT(x) (HW_CAN_ESR1(x).B.WAK_INT)

/*! @brief Format value for bitfield CAN_ESR1_WAK_INT. */
#define BF_CAN_ESR1_WAK_INT(v) ((uint32_t)((uint32_t)(v) << BP_CAN_ESR1_WAK_INT) & BM_CAN_ESR1_WAK_INT)

/*! @brief Set the WAK_INT field to a new value. */
#define BW_CAN_ESR1_WAK_INT(x, v) (HW_CAN_ESR1_WR(x, (HW_CAN_ESR1_RD(x) & ~BM_CAN_ESR1_WAK_INT) | BF_CAN_ESR1_WAK_INT(v)))
/*@}*/

/*!
 * @name Register CAN_ESR1, field ERR_INT[1] (RW)
 *
 * This bit indicates that at least one of the Error Bits (bits 15-10) is set.
 * If the corresponding mask bit in the Control Register (ERR_MSK) is set, an
 * interrupt is generated to the ARM. This bit is cleared by writing it to
 * '1'.Writing '0' has no effect.
 *
 * Values:
 * - 1 - Indicates setting of any Error Bit in the Error and Status Register
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_ESR1_ERR_INT  (1U)          /*!< Bit position for CAN_ESR1_ERR_INT. */
#define BM_CAN_ESR1_ERR_INT  (0x00000002U) /*!< Bit mask for CAN_ESR1_ERR_INT. */
#define BS_CAN_ESR1_ERR_INT  (1U)          /*!< Bit field size in bits for CAN_ESR1_ERR_INT. */

/*! @brief Read current value of the CAN_ESR1_ERR_INT field. */
#define BR_CAN_ESR1_ERR_INT(x) (HW_CAN_ESR1(x).B.ERR_INT)

/*! @brief Format value for bitfield CAN_ESR1_ERR_INT. */
#define BF_CAN_ESR1_ERR_INT(v) ((uint32_t)((uint32_t)(v) << BP_CAN_ESR1_ERR_INT) & BM_CAN_ESR1_ERR_INT)

/*! @brief Set the ERR_INT field to a new value. */
#define BW_CAN_ESR1_ERR_INT(x, v) (HW_CAN_ESR1_WR(x, (HW_CAN_ESR1_RD(x) & ~BM_CAN_ESR1_ERR_INT) | BF_CAN_ESR1_ERR_INT(v)))
/*@}*/

/*!
 * @name Register CAN_ESR1, field BOFF_INT[2] (RW)
 *
 * This bit is set when FLEXCAN enters 'Bus Off' state. If the corresponding
 * mask bit in the Control Register (BOFF_MSK) is set, an interrupt is generated to
 * the ARM. This bit is cleared by writing it to '1'. Writing '0' has no effect.
 *
 * Values:
 * - 1 - FLEXCAN module entered 'Bus Off' state
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_ESR1_BOFF_INT (2U)          /*!< Bit position for CAN_ESR1_BOFF_INT. */
#define BM_CAN_ESR1_BOFF_INT (0x00000004U) /*!< Bit mask for CAN_ESR1_BOFF_INT. */
#define BS_CAN_ESR1_BOFF_INT (1U)          /*!< Bit field size in bits for CAN_ESR1_BOFF_INT. */

/*! @brief Read current value of the CAN_ESR1_BOFF_INT field. */
#define BR_CAN_ESR1_BOFF_INT(x) (HW_CAN_ESR1(x).B.BOFF_INT)

/*! @brief Format value for bitfield CAN_ESR1_BOFF_INT. */
#define BF_CAN_ESR1_BOFF_INT(v) ((uint32_t)((uint32_t)(v) << BP_CAN_ESR1_BOFF_INT) & BM_CAN_ESR1_BOFF_INT)

/*! @brief Set the BOFF_INT field to a new value. */
#define BW_CAN_ESR1_BOFF_INT(x, v) (HW_CAN_ESR1_WR(x, (HW_CAN_ESR1_RD(x) & ~BM_CAN_ESR1_BOFF_INT) | BF_CAN_ESR1_BOFF_INT(v)))
/*@}*/

/*!
 * @name Register CAN_ESR1, field RX[3] (RO)
 *
 * This bit indicates if FlexCAN is receiving a message. Refer to .
 *
 * Values:
 * - 1 - FLEXCAN is transmitting a message
 * - 0 - FLEXCAN is receiving a message
 */
/*@{*/
#define BP_CAN_ESR1_RX       (3U)          /*!< Bit position for CAN_ESR1_RX. */
#define BM_CAN_ESR1_RX       (0x00000008U) /*!< Bit mask for CAN_ESR1_RX. */
#define BS_CAN_ESR1_RX       (1U)          /*!< Bit field size in bits for CAN_ESR1_RX. */

/*! @brief Read current value of the CAN_ESR1_RX field. */
#define BR_CAN_ESR1_RX(x)    (HW_CAN_ESR1(x).B.RX)
/*@}*/

/*!
 * @name Register CAN_ESR1, field FLT_CONF[5:4] (RO)
 *
 * If the LOM bit in the Control Register is asserted, after some delay that
 * depends on the CAN bit timing the FLT_CONF field will indicate "Error Passive".
 * The very same delay affects the way how FLT_CONF reflects an update to ECR
 * register by the ARM. It may be necessary up to one CAN bit time to get them
 * coherent again. Since the Control Register is not affected by soft reset, the
 * FLT_CONF field will not be affected by soft reset if the LOM bit is asserted. This
 * 2-bit field indicates the Confinement State of the FLEXCAN module, as shown in
 * below:
 *
 * Values:
 * - 00 - Error Active
 * - 01 - Error Passive
 * - 1x - Bus off
 */
/*@{*/
#define BP_CAN_ESR1_FLT_CONF (4U)          /*!< Bit position for CAN_ESR1_FLT_CONF. */
#define BM_CAN_ESR1_FLT_CONF (0x00000030U) /*!< Bit mask for CAN_ESR1_FLT_CONF. */
#define BS_CAN_ESR1_FLT_CONF (2U)          /*!< Bit field size in bits for CAN_ESR1_FLT_CONF. */

/*! @brief Read current value of the CAN_ESR1_FLT_CONF field. */
#define BR_CAN_ESR1_FLT_CONF(x) (HW_CAN_ESR1(x).B.FLT_CONF)
/*@}*/

/*!
 * @name Register CAN_ESR1, field TX[6] (RO)
 *
 * This bit indicates if FLEXCAN is transmitting a message.Refer to .
 *
 * Values:
 * - 1 - FLEXCAN is transmitting a message
 * - 0 - FLEXCAN is receiving a message
 */
/*@{*/
#define BP_CAN_ESR1_TX       (6U)          /*!< Bit position for CAN_ESR1_TX. */
#define BM_CAN_ESR1_TX       (0x00000040U) /*!< Bit mask for CAN_ESR1_TX. */
#define BS_CAN_ESR1_TX       (1U)          /*!< Bit field size in bits for CAN_ESR1_TX. */

/*! @brief Read current value of the CAN_ESR1_TX field. */
#define BR_CAN_ESR1_TX(x)    (HW_CAN_ESR1(x).B.TX)
/*@}*/

/*!
 * @name Register CAN_ESR1, field IDLE[7] (RO)
 *
 * This bit indicates when CAN bus is in IDLE state.Refer to .
 *
 * Values:
 * - 1 - CAN bus is now IDLE
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_ESR1_IDLE     (7U)          /*!< Bit position for CAN_ESR1_IDLE. */
#define BM_CAN_ESR1_IDLE     (0x00000080U) /*!< Bit mask for CAN_ESR1_IDLE. */
#define BS_CAN_ESR1_IDLE     (1U)          /*!< Bit field size in bits for CAN_ESR1_IDLE. */

/*! @brief Read current value of the CAN_ESR1_IDLE field. */
#define BR_CAN_ESR1_IDLE(x)  (HW_CAN_ESR1(x).B.IDLE)
/*@}*/

/*!
 * @name Register CAN_ESR1, field RX_WRN[8] (RO)
 *
 * This bit indicates when repetitive errors are occurring during message
 * reception.
 *
 * Values:
 * - 1 - Rx_Err_Counter >= 96
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_ESR1_RX_WRN   (8U)          /*!< Bit position for CAN_ESR1_RX_WRN. */
#define BM_CAN_ESR1_RX_WRN   (0x00000100U) /*!< Bit mask for CAN_ESR1_RX_WRN. */
#define BS_CAN_ESR1_RX_WRN   (1U)          /*!< Bit field size in bits for CAN_ESR1_RX_WRN. */

/*! @brief Read current value of the CAN_ESR1_RX_WRN field. */
#define BR_CAN_ESR1_RX_WRN(x) (HW_CAN_ESR1(x).B.RX_WRN)
/*@}*/

/*!
 * @name Register CAN_ESR1, field TX_WRN[9] (RO)
 *
 * This bit indicates when repetitive errors are occurring during message
 * transmission.
 *
 * Values:
 * - 1 - TX_Err_Counter >= 96
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_ESR1_TX_WRN   (9U)          /*!< Bit position for CAN_ESR1_TX_WRN. */
#define BM_CAN_ESR1_TX_WRN   (0x00000200U) /*!< Bit mask for CAN_ESR1_TX_WRN. */
#define BS_CAN_ESR1_TX_WRN   (1U)          /*!< Bit field size in bits for CAN_ESR1_TX_WRN. */

/*! @brief Read current value of the CAN_ESR1_TX_WRN field. */
#define BR_CAN_ESR1_TX_WRN(x) (HW_CAN_ESR1(x).B.TX_WRN)
/*@}*/

/*!
 * @name Register CAN_ESR1, field STF_ERR[10] (RO)
 *
 * This bit indicates that a Stuffing Error has been detected.
 *
 * Values:
 * - 1 - A Stuffing Error occurred since last read of this register.
 * - 0 - No such occurrence.
 */
/*@{*/
#define BP_CAN_ESR1_STF_ERR  (10U)         /*!< Bit position for CAN_ESR1_STF_ERR. */
#define BM_CAN_ESR1_STF_ERR  (0x00000400U) /*!< Bit mask for CAN_ESR1_STF_ERR. */
#define BS_CAN_ESR1_STF_ERR  (1U)          /*!< Bit field size in bits for CAN_ESR1_STF_ERR. */

/*! @brief Read current value of the CAN_ESR1_STF_ERR field. */
#define BR_CAN_ESR1_STF_ERR(x) (HW_CAN_ESR1(x).B.STF_ERR)
/*@}*/

/*!
 * @name Register CAN_ESR1, field FRM_ERR[11] (RO)
 *
 * This bit indicates that a Form Error has been detected by the receiver node,
 * i.e., a fixed-form bit field contains at least one illegal bit.
 *
 * Values:
 * - 1 - A Form Error occurred since last read of this register
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_ESR1_FRM_ERR  (11U)         /*!< Bit position for CAN_ESR1_FRM_ERR. */
#define BM_CAN_ESR1_FRM_ERR  (0x00000800U) /*!< Bit mask for CAN_ESR1_FRM_ERR. */
#define BS_CAN_ESR1_FRM_ERR  (1U)          /*!< Bit field size in bits for CAN_ESR1_FRM_ERR. */

/*! @brief Read current value of the CAN_ESR1_FRM_ERR field. */
#define BR_CAN_ESR1_FRM_ERR(x) (HW_CAN_ESR1(x).B.FRM_ERR)
/*@}*/

/*!
 * @name Register CAN_ESR1, field CRC_ERR[12] (RO)
 *
 * This bit indicates that a CRC Error has been detected by the receiver node,
 * i.e., the calculated CRC is different from the received.
 *
 * Values:
 * - 1 - A CRC error occurred since last read of this register.
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_ESR1_CRC_ERR  (12U)         /*!< Bit position for CAN_ESR1_CRC_ERR. */
#define BM_CAN_ESR1_CRC_ERR  (0x00001000U) /*!< Bit mask for CAN_ESR1_CRC_ERR. */
#define BS_CAN_ESR1_CRC_ERR  (1U)          /*!< Bit field size in bits for CAN_ESR1_CRC_ERR. */

/*! @brief Read current value of the CAN_ESR1_CRC_ERR field. */
#define BR_CAN_ESR1_CRC_ERR(x) (HW_CAN_ESR1(x).B.CRC_ERR)
/*@}*/

/*!
 * @name Register CAN_ESR1, field ACK_ERR[13] (RO)
 *
 * This bit indicates that an Acknowledge Error has been detected by the
 * transmitter node, i.e., a dominant bit has not been detected during the ACK SLOT.
 *
 * Values:
 * - 1 - An ACK error occurred since last read of this register
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_ESR1_ACK_ERR  (13U)         /*!< Bit position for CAN_ESR1_ACK_ERR. */
#define BM_CAN_ESR1_ACK_ERR  (0x00002000U) /*!< Bit mask for CAN_ESR1_ACK_ERR. */
#define BS_CAN_ESR1_ACK_ERR  (1U)          /*!< Bit field size in bits for CAN_ESR1_ACK_ERR. */

/*! @brief Read current value of the CAN_ESR1_ACK_ERR field. */
#define BR_CAN_ESR1_ACK_ERR(x) (HW_CAN_ESR1(x).B.ACK_ERR)
/*@}*/

/*!
 * @name Register CAN_ESR1, field BIT0_ERR[14] (RO)
 *
 * This bit indicates when an inconsistency occurs between the transmitted and
 * the received bit in a message.
 *
 * Values:
 * - 1 - At least one bit sent as dominant is received as recessive
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_ESR1_BIT0_ERR (14U)         /*!< Bit position for CAN_ESR1_BIT0_ERR. */
#define BM_CAN_ESR1_BIT0_ERR (0x00004000U) /*!< Bit mask for CAN_ESR1_BIT0_ERR. */
#define BS_CAN_ESR1_BIT0_ERR (1U)          /*!< Bit field size in bits for CAN_ESR1_BIT0_ERR. */

/*! @brief Read current value of the CAN_ESR1_BIT0_ERR field. */
#define BR_CAN_ESR1_BIT0_ERR(x) (HW_CAN_ESR1(x).B.BIT0_ERR)
/*@}*/

/*!
 * @name Register CAN_ESR1, field BIT1_ERR[15] (RO)
 *
 * This bit indicates when an inconsistency occurs between the transmitted and
 * the received bit in a message. This bit is not set by a transmitter in case of
 * arbitration field or ACK slot, or in case of a node sending a passive error
 * flag that detects dominant bits.
 *
 * Values:
 * - 1 - At least one bit sent as recessive is received as dominant
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_ESR1_BIT1_ERR (15U)         /*!< Bit position for CAN_ESR1_BIT1_ERR. */
#define BM_CAN_ESR1_BIT1_ERR (0x00008000U) /*!< Bit mask for CAN_ESR1_BIT1_ERR. */
#define BS_CAN_ESR1_BIT1_ERR (1U)          /*!< Bit field size in bits for CAN_ESR1_BIT1_ERR. */

/*! @brief Read current value of the CAN_ESR1_BIT1_ERR field. */
#define BR_CAN_ESR1_BIT1_ERR(x) (HW_CAN_ESR1(x).B.BIT1_ERR)
/*@}*/

/*!
 * @name Register CAN_ESR1, field RWRN_INT[16] (RW)
 *
 * If the WRN_EN bit in MCR is asserted, the RWRN_INT bit is set when the RX_WRN
 * flag transition from '0' to '1', meaning that the Rx error counters reached
 * 96. If the corresponding mask bit in the Control Register (RWRN_MSK) is set, an
 * interrupt is generated to the ARM. This bit is cleared by writing it to '1'.
 * When WRN_EN is negated, this flag is masked. ARM must clear this flag before
 * disabling the bit. Otherwise it will be set when the WRN_EN is set again.
 * Writing '0' has no effect. This bit is not updated during Freeze mode.
 *
 * Values:
 * - 1 - The Rx error counter transition from < 96 to >= 96
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_ESR1_RWRN_INT (16U)         /*!< Bit position for CAN_ESR1_RWRN_INT. */
#define BM_CAN_ESR1_RWRN_INT (0x00010000U) /*!< Bit mask for CAN_ESR1_RWRN_INT. */
#define BS_CAN_ESR1_RWRN_INT (1U)          /*!< Bit field size in bits for CAN_ESR1_RWRN_INT. */

/*! @brief Read current value of the CAN_ESR1_RWRN_INT field. */
#define BR_CAN_ESR1_RWRN_INT(x) (HW_CAN_ESR1(x).B.RWRN_INT)

/*! @brief Format value for bitfield CAN_ESR1_RWRN_INT. */
#define BF_CAN_ESR1_RWRN_INT(v) ((uint32_t)((uint32_t)(v) << BP_CAN_ESR1_RWRN_INT) & BM_CAN_ESR1_RWRN_INT)

/*! @brief Set the RWRN_INT field to a new value. */
#define BW_CAN_ESR1_RWRN_INT(x, v) (HW_CAN_ESR1_WR(x, (HW_CAN_ESR1_RD(x) & ~BM_CAN_ESR1_RWRN_INT) | BF_CAN_ESR1_RWRN_INT(v)))
/*@}*/

/*!
 * @name Register CAN_ESR1, field TWRN_INT[17] (RW)
 *
 * If the WRN_EN bit in MCR is asserted, the TWRN_INT bit is set when the TX_WRN
 * flag transition from '0' to '1', meaning that the Tx error counter reached
 * 96. If the corresponding mask bit in the Control Register (TWRN_MSK) is set, an
 * interrupt is generated to the ARM. This bit is cleared by writing it to '1'.
 * When WRN_EN is negated, this flag is masked. ARM must clear this flag before
 * disabling the bit. Otherwise it will be set when the WRN_EN is set again.
 * Writing '0' has no effect. This flag is not generated during "Bus Off" state. This
 * bit is not updated during Freeze mode.
 *
 * Values:
 * - 1 - The Tx error counter transition from < 96 to >= 96
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_ESR1_TWRN_INT (17U)         /*!< Bit position for CAN_ESR1_TWRN_INT. */
#define BM_CAN_ESR1_TWRN_INT (0x00020000U) /*!< Bit mask for CAN_ESR1_TWRN_INT. */
#define BS_CAN_ESR1_TWRN_INT (1U)          /*!< Bit field size in bits for CAN_ESR1_TWRN_INT. */

/*! @brief Read current value of the CAN_ESR1_TWRN_INT field. */
#define BR_CAN_ESR1_TWRN_INT(x) (HW_CAN_ESR1(x).B.TWRN_INT)

/*! @brief Format value for bitfield CAN_ESR1_TWRN_INT. */
#define BF_CAN_ESR1_TWRN_INT(v) ((uint32_t)((uint32_t)(v) << BP_CAN_ESR1_TWRN_INT) & BM_CAN_ESR1_TWRN_INT)

/*! @brief Set the TWRN_INT field to a new value. */
#define BW_CAN_ESR1_TWRN_INT(x, v) (HW_CAN_ESR1_WR(x, (HW_CAN_ESR1_RD(x) & ~BM_CAN_ESR1_TWRN_INT) | BF_CAN_ESR1_TWRN_INT(v)))
/*@}*/

/*!
 * @name Register CAN_ESR1, field SYNCH[18] (RO)
 *
 * This read-only flag indicates whether the FlexCAN is synchronized to the CAN
 * bus and able to participate in the communication process. It is set and
 * cleared by the FlexCAN. Refer to
 *
 * Values:
 * - 1 - FlexCAN is synchronized to the CAN bus
 * - 0 - FlexCAN is not synchronized to the CAN bus
 */
/*@{*/
#define BP_CAN_ESR1_SYNCH    (18U)         /*!< Bit position for CAN_ESR1_SYNCH. */
#define BM_CAN_ESR1_SYNCH    (0x00040000U) /*!< Bit mask for CAN_ESR1_SYNCH. */
#define BS_CAN_ESR1_SYNCH    (1U)          /*!< Bit field size in bits for CAN_ESR1_SYNCH. */

/*! @brief Read current value of the CAN_ESR1_SYNCH field. */
#define BR_CAN_ESR1_SYNCH(x) (HW_CAN_ESR1(x).B.SYNCH)
/*@}*/

/*******************************************************************************
 * HW_CAN_IMASK2 - Interrupt Masks 2 Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_IMASK2 - Interrupt Masks 2 Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register allows any number of a range of 32 Message Buffer Interrupts to
 * be enabled or disabled. It contains one interrupt mask bit per buffer,
 * enabling the ARM to determine which buffer generates an interrupt after a successful
 * transmission or reception (i.e. when the corresponding IFLAG2 bit is set).
 */
typedef union _hw_can_imask2
{
    uint32_t U;
    struct _hw_can_imask2_bitfields
    {
        uint32_t BUF63M_BUF32M : 32;   /*!< [31:0]  */
    } B;
} hw_can_imask2_t;

/*!
 * @name Constants and macros for entire CAN_IMASK2 register
 */
/*@{*/
#define HW_CAN_IMASK2_ADDR(x)    ((uintptr_t)(x) + 0x24U)

#define HW_CAN_IMASK2(x)         (*(__IO hw_can_imask2_t *) HW_CAN_IMASK2_ADDR(x))
#define HW_CAN_IMASK2_RD(x)      (HW_CAN_IMASK2(x).U)
#define HW_CAN_IMASK2_WR(x, v)   (HW_CAN_IMASK2(x).U = (v))
#define HW_CAN_IMASK2_SET(x, v)  (HW_CAN_IMASK2_WR(x, HW_CAN_IMASK2_RD(x) |  (v)))
#define HW_CAN_IMASK2_CLR(x, v)  (HW_CAN_IMASK2_WR(x, HW_CAN_IMASK2_RD(x) & ~(v)))
#define HW_CAN_IMASK2_TOG(x, v)  (HW_CAN_IMASK2_WR(x, HW_CAN_IMASK2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_IMASK2 bitfields
 */

/*!
 * @name Register CAN_IMASK2, field BUF63M_BUF32M[31:0] (RW)
 *
 * Each bit enables or disables the respective FLEXCAN Message Buffer (MB32 to
 * MB63) Interrupt. Setting or clearing a bit in the IMASK2 Register can assert or
 * negate an interrupt request, if the corresponding IFLAG2 bit is set.
 *
 * Values:
 * - 1 - The corresponding buffer Interrupt is enabled
 * - 0 - The corresponding buffer Interrupt is disabled
 */
/*@{*/
#define BP_CAN_IMASK2_BUF63M_BUF32M (0U)   /*!< Bit position for CAN_IMASK2_BUF63M_BUF32M. */
#define BM_CAN_IMASK2_BUF63M_BUF32M (0xFFFFFFFFU) /*!< Bit mask for CAN_IMASK2_BUF63M_BUF32M. */
#define BS_CAN_IMASK2_BUF63M_BUF32M (32U)  /*!< Bit field size in bits for CAN_IMASK2_BUF63M_BUF32M. */

/*! @brief Read current value of the CAN_IMASK2_BUF63M_BUF32M field. */
#define BR_CAN_IMASK2_BUF63M_BUF32M(x) (HW_CAN_IMASK2(x).U)

/*! @brief Format value for bitfield CAN_IMASK2_BUF63M_BUF32M. */
#define BF_CAN_IMASK2_BUF63M_BUF32M(v) ((uint32_t)((uint32_t)(v) << BP_CAN_IMASK2_BUF63M_BUF32M) & BM_CAN_IMASK2_BUF63M_BUF32M)

/*! @brief Set the BUF63M_BUF32M field to a new value. */
#define BW_CAN_IMASK2_BUF63M_BUF32M(x, v) (HW_CAN_IMASK2_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_CAN_IMASK1 - Interrupt Masks 1 Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_IMASK1 - Interrupt Masks 1 Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register allows to enable or disable any number of a range of 32 Message
 * Buffer Interrupts. It contains one interrupt mask bit per buffer, enabling
 * the ARM to determine which buffer generates an interrupt after a successful
 * transmission or reception (i.e., when the corresponding IFLAG1 bit is set).
 */
typedef union _hw_can_imask1
{
    uint32_t U;
    struct _hw_can_imask1_bitfields
    {
        uint32_t BUF31M_BUF0M : 32;    /*!< [31:0]  */
    } B;
} hw_can_imask1_t;

/*!
 * @name Constants and macros for entire CAN_IMASK1 register
 */
/*@{*/
#define HW_CAN_IMASK1_ADDR(x)    ((uintptr_t)(x) + 0x28U)

#define HW_CAN_IMASK1(x)         (*(__IO hw_can_imask1_t *) HW_CAN_IMASK1_ADDR(x))
#define HW_CAN_IMASK1_RD(x)      (HW_CAN_IMASK1(x).U)
#define HW_CAN_IMASK1_WR(x, v)   (HW_CAN_IMASK1(x).U = (v))
#define HW_CAN_IMASK1_SET(x, v)  (HW_CAN_IMASK1_WR(x, HW_CAN_IMASK1_RD(x) |  (v)))
#define HW_CAN_IMASK1_CLR(x, v)  (HW_CAN_IMASK1_WR(x, HW_CAN_IMASK1_RD(x) & ~(v)))
#define HW_CAN_IMASK1_TOG(x, v)  (HW_CAN_IMASK1_WR(x, HW_CAN_IMASK1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_IMASK1 bitfields
 */

/*!
 * @name Register CAN_IMASK1, field BUF31M_BUF0M[31:0] (RW)
 *
 * Each bit enables or disables the respective FLEXCAN Message Buffer (MB0 to
 * MB31) Interrupt. Setting or clearing a bit in the IMASK1 Register can assert or
 * negate an interrupt request, if the corresponding IFLAG1 bit is set
 *
 * Values:
 * - 1 - The corresponding buffer Interrupt is enabled
 * - 0 - The corresponding buffer Interrupt is disabled
 */
/*@{*/
#define BP_CAN_IMASK1_BUF31M_BUF0M (0U)    /*!< Bit position for CAN_IMASK1_BUF31M_BUF0M. */
#define BM_CAN_IMASK1_BUF31M_BUF0M (0xFFFFFFFFU) /*!< Bit mask for CAN_IMASK1_BUF31M_BUF0M. */
#define BS_CAN_IMASK1_BUF31M_BUF0M (32U)   /*!< Bit field size in bits for CAN_IMASK1_BUF31M_BUF0M. */

/*! @brief Read current value of the CAN_IMASK1_BUF31M_BUF0M field. */
#define BR_CAN_IMASK1_BUF31M_BUF0M(x) (HW_CAN_IMASK1(x).U)

/*! @brief Format value for bitfield CAN_IMASK1_BUF31M_BUF0M. */
#define BF_CAN_IMASK1_BUF31M_BUF0M(v) ((uint32_t)((uint32_t)(v) << BP_CAN_IMASK1_BUF31M_BUF0M) & BM_CAN_IMASK1_BUF31M_BUF0M)

/*! @brief Set the BUF31M_BUF0M field to a new value. */
#define BW_CAN_IMASK1_BUF31M_BUF0M(x, v) (HW_CAN_IMASK1_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_CAN_IFLAG2 - Interrupt Flags 2 Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_IFLAG2 - Interrupt Flags 2 Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register defines the flags for 32 Message Buffer interrupts. It contains
 * one interrupt flag bit per buffer. Each successful transmission or reception
 * sets the corresponding IFLAG2 bit. If the corresponding IMASK2 bit is set, an
 * interrupt will be generated. The interrupt flag must be cleared by writing it
 * to '1'. Writing '0' has no effect.Before updating MCR[MAXMB] field, ARM must
 * treat the IFLAG2 bits which MB value is greater than the MCR[MAXMB] to be
 * updated, otherwise they will keep set and be inconsistent with the amount of MBs
 * available.
 */
typedef union _hw_can_iflag2
{
    uint32_t U;
    struct _hw_can_iflag2_bitfields
    {
        uint32_t BUF63I_BUF32I : 32;   /*!< [31:0]  */
    } B;
} hw_can_iflag2_t;

/*!
 * @name Constants and macros for entire CAN_IFLAG2 register
 */
/*@{*/
#define HW_CAN_IFLAG2_ADDR(x)    ((uintptr_t)(x) + 0x2CU)

#define HW_CAN_IFLAG2(x)         (*(__IO hw_can_iflag2_t *) HW_CAN_IFLAG2_ADDR(x))
#define HW_CAN_IFLAG2_RD(x)      (HW_CAN_IFLAG2(x).U)
#define HW_CAN_IFLAG2_WR(x, v)   (HW_CAN_IFLAG2(x).U = (v))
#define HW_CAN_IFLAG2_SET(x, v)  (HW_CAN_IFLAG2_WR(x, HW_CAN_IFLAG2_RD(x) |  (v)))
#define HW_CAN_IFLAG2_CLR(x, v)  (HW_CAN_IFLAG2_WR(x, HW_CAN_IFLAG2_RD(x) & ~(v)))
#define HW_CAN_IFLAG2_TOG(x, v)  (HW_CAN_IFLAG2_WR(x, HW_CAN_IFLAG2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_IFLAG2 bitfields
 */

/*!
 * @name Register CAN_IFLAG2, field BUF63I_BUF32I[31:0] (RW)
 *
 * Each bit flags the respective FLEXCAN Message Buffer (MB32 to MB63) interrupt.
 *
 * Values:
 * - 1 - The corresponding buffer has successfully completed transmission or
 *     reception
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_IFLAG2_BUF63I_BUF32I (0U)   /*!< Bit position for CAN_IFLAG2_BUF63I_BUF32I. */
#define BM_CAN_IFLAG2_BUF63I_BUF32I (0xFFFFFFFFU) /*!< Bit mask for CAN_IFLAG2_BUF63I_BUF32I. */
#define BS_CAN_IFLAG2_BUF63I_BUF32I (32U)  /*!< Bit field size in bits for CAN_IFLAG2_BUF63I_BUF32I. */

/*! @brief Read current value of the CAN_IFLAG2_BUF63I_BUF32I field. */
#define BR_CAN_IFLAG2_BUF63I_BUF32I(x) (HW_CAN_IFLAG2(x).U)

/*! @brief Format value for bitfield CAN_IFLAG2_BUF63I_BUF32I. */
#define BF_CAN_IFLAG2_BUF63I_BUF32I(v) ((uint32_t)((uint32_t)(v) << BP_CAN_IFLAG2_BUF63I_BUF32I) & BM_CAN_IFLAG2_BUF63I_BUF32I)

/*! @brief Set the BUF63I_BUF32I field to a new value. */
#define BW_CAN_IFLAG2_BUF63I_BUF32I(x, v) (HW_CAN_IFLAG2_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_CAN_IFLAG1 - Interrupt Flags 1 Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_IFLAG1 - Interrupt Flags 1 Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register defines the flags for 32 Message Buffer interrupts and FIFO
 * interrupts. It contains one interrupt flag bit per buffer. Each successful
 * transmission or reception sets the corresponding IFLAG1 bit. If the corresponding
 * IMASK1 bit is set, an interrupt will be generated. The Interrupt flag must be
 * cleared by writing it to '1'. Writing '0' has no effect. When the RFEN bit in
 * the MCR is set (Rx FIFO enabled), the function of the 8 least significant
 * interrupt flags (BUF7I - BUF0I) is changed to support the FIFO operation. BUF7I,
 * BUF6I and BUF5I indicate operating conditions of the FIFO, while BUF4I to BUF0I
 * are not used. Before enabling the RFEN, ARM must service the IFLAGS asserted in
 * the Rx FIFO region (see Rx FIFOThe receive-only FIFO is enabled by asserting
 * the RFEN bit in the MCR. ). Otherwise, these IFLAGS will mistakenly show the
 * related MBs now belonging to FIFO as having contents to be serviced. When the
 * RFEN is negated, the FIFO flags must be cleared. The same care must be taken
 * when a RFFN value is selected extending Rx FIFO filters beyond MB7 (see
 * CTRL2Control 2 Register ). For example, when RFFN is 0x8, the MB0-23 range is occupied
 * by Rx FIFO filters and related IFLAGS must be cleared. Before updating
 * MCR[MAXMB] field, ARM must service the IFLAG1 which MB value is greater than the
 * MCR[MAXMB] to be updated, otherwise they will keep set and be inconsistent with
 * the amount of MBs available.
 */
typedef union _hw_can_iflag1
{
    uint32_t U;
    struct _hw_can_iflag1_bitfields
    {
        uint32_t BUF4I_BUF0I : 5;      /*!< [4:0]  */
        uint32_t BUF5I : 1;            /*!< [5]  */
        uint32_t BUF6I : 1;            /*!< [6]  */
        uint32_t BUF7I : 1;            /*!< [7]  */
        uint32_t BUF31I_BUF8I : 24;    /*!< [31:8]  */
    } B;
} hw_can_iflag1_t;

/*!
 * @name Constants and macros for entire CAN_IFLAG1 register
 */
/*@{*/
#define HW_CAN_IFLAG1_ADDR(x)    ((uintptr_t)(x) + 0x30U)

#define HW_CAN_IFLAG1(x)         (*(__IO hw_can_iflag1_t *) HW_CAN_IFLAG1_ADDR(x))
#define HW_CAN_IFLAG1_RD(x)      (HW_CAN_IFLAG1(x).U)
#define HW_CAN_IFLAG1_WR(x, v)   (HW_CAN_IFLAG1(x).U = (v))
#define HW_CAN_IFLAG1_SET(x, v)  (HW_CAN_IFLAG1_WR(x, HW_CAN_IFLAG1_RD(x) |  (v)))
#define HW_CAN_IFLAG1_CLR(x, v)  (HW_CAN_IFLAG1_WR(x, HW_CAN_IFLAG1_RD(x) & ~(v)))
#define HW_CAN_IFLAG1_TOG(x, v)  (HW_CAN_IFLAG1_WR(x, HW_CAN_IFLAG1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_IFLAG1 bitfields
 */

/*!
 * @name Register CAN_IFLAG1, field BUF4I_BUF0I[4:0] (RW)
 *
 * If the Rx FIFO is not enabled, these bits flag the interrupts for MB0 to MB4.
 * If the Rx FIFO is enabled, these flags are not used and must be considered as
 * reserved locations. These flags are cleared by the FlexCAN whenever the bit
 * MCR[RFEN] is changed by ARM writes.
 *
 * Values:
 * - 1 - Corresponding MB completed transmission/reception
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_IFLAG1_BUF4I_BUF0I (0U)     /*!< Bit position for CAN_IFLAG1_BUF4I_BUF0I. */
#define BM_CAN_IFLAG1_BUF4I_BUF0I (0x0000001FU) /*!< Bit mask for CAN_IFLAG1_BUF4I_BUF0I. */
#define BS_CAN_IFLAG1_BUF4I_BUF0I (5U)     /*!< Bit field size in bits for CAN_IFLAG1_BUF4I_BUF0I. */

/*! @brief Read current value of the CAN_IFLAG1_BUF4I_BUF0I field. */
#define BR_CAN_IFLAG1_BUF4I_BUF0I(x) (HW_CAN_IFLAG1(x).B.BUF4I_BUF0I)

/*! @brief Format value for bitfield CAN_IFLAG1_BUF4I_BUF0I. */
#define BF_CAN_IFLAG1_BUF4I_BUF0I(v) ((uint32_t)((uint32_t)(v) << BP_CAN_IFLAG1_BUF4I_BUF0I) & BM_CAN_IFLAG1_BUF4I_BUF0I)

/*! @brief Set the BUF4I_BUF0I field to a new value. */
#define BW_CAN_IFLAG1_BUF4I_BUF0I(x, v) (HW_CAN_IFLAG1_WR(x, (HW_CAN_IFLAG1_RD(x) & ~BM_CAN_IFLAG1_BUF4I_BUF0I) | BF_CAN_IFLAG1_BUF4I_BUF0I(v)))
/*@}*/

/*!
 * @name Register CAN_IFLAG1, field BUF5I[5] (RW)
 *
 * If the Rx FIFO is not enabled, this bit flags the interrupt for MB5. If the
 * Rx FIFO is enabled, this flag indicates that at least one frame is available to
 * be read from the Rx FIFO. This flag is cleared by the FlexCAN whenever the
 * bit MCR[RFEN] is changed by ARM writes.
 *
 * Values:
 * - 1 - MB5 completed transmission/reception or frames available in the FIFO
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_IFLAG1_BUF5I  (5U)          /*!< Bit position for CAN_IFLAG1_BUF5I. */
#define BM_CAN_IFLAG1_BUF5I  (0x00000020U) /*!< Bit mask for CAN_IFLAG1_BUF5I. */
#define BS_CAN_IFLAG1_BUF5I  (1U)          /*!< Bit field size in bits for CAN_IFLAG1_BUF5I. */

/*! @brief Read current value of the CAN_IFLAG1_BUF5I field. */
#define BR_CAN_IFLAG1_BUF5I(x) (HW_CAN_IFLAG1(x).B.BUF5I)

/*! @brief Format value for bitfield CAN_IFLAG1_BUF5I. */
#define BF_CAN_IFLAG1_BUF5I(v) ((uint32_t)((uint32_t)(v) << BP_CAN_IFLAG1_BUF5I) & BM_CAN_IFLAG1_BUF5I)

/*! @brief Set the BUF5I field to a new value. */
#define BW_CAN_IFLAG1_BUF5I(x, v) (HW_CAN_IFLAG1_WR(x, (HW_CAN_IFLAG1_RD(x) & ~BM_CAN_IFLAG1_BUF5I) | BF_CAN_IFLAG1_BUF5I(v)))
/*@}*/

/*!
 * @name Register CAN_IFLAG1, field BUF6I[6] (RW)
 *
 * If the Rx FIFO is not enabled, this bit flags the interrupt for MB6. If the
 * MCR[RFEN] bit is asserted, this flag indicates when the number of unread
 * messages within the Rx FIFO is increased to 5 from 4 due to the reception of a new
 * one, meaning that the Rx FIFO is almost full. Note that if the flag is cleared
 * while the number of unread messages is greater than 4 it will not assert again
 * until the number of unread messages within the Rx FIFO is decreased to equal
 * or less than 4. This flag is cleared by the FlexCAN whenever the bit MCR[RFEN]
 * is changed by ARM writes.
 *
 * Values:
 * - 1 - MB6 completed transmission/reception or FIFO almost full
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_IFLAG1_BUF6I  (6U)          /*!< Bit position for CAN_IFLAG1_BUF6I. */
#define BM_CAN_IFLAG1_BUF6I  (0x00000040U) /*!< Bit mask for CAN_IFLAG1_BUF6I. */
#define BS_CAN_IFLAG1_BUF6I  (1U)          /*!< Bit field size in bits for CAN_IFLAG1_BUF6I. */

/*! @brief Read current value of the CAN_IFLAG1_BUF6I field. */
#define BR_CAN_IFLAG1_BUF6I(x) (HW_CAN_IFLAG1(x).B.BUF6I)

/*! @brief Format value for bitfield CAN_IFLAG1_BUF6I. */
#define BF_CAN_IFLAG1_BUF6I(v) ((uint32_t)((uint32_t)(v) << BP_CAN_IFLAG1_BUF6I) & BM_CAN_IFLAG1_BUF6I)

/*! @brief Set the BUF6I field to a new value. */
#define BW_CAN_IFLAG1_BUF6I(x, v) (HW_CAN_IFLAG1_WR(x, (HW_CAN_IFLAG1_RD(x) & ~BM_CAN_IFLAG1_BUF6I) | BF_CAN_IFLAG1_BUF6I(v)))
/*@}*/

/*!
 * @name Register CAN_IFLAG1, field BUF7I[7] (RW)
 *
 * If the Rx FIFO is not enabled, this bit flags the interrupt for MB7. If the
 * MCR[RFEN] bit is asserted, this flag indicates that a message was lost because
 * Rx FIFO is full. Note that the flag will not be asserted when the Rx FIFO is
 * full and the message was captured by a Mailbox. This flag is cleared by the
 * FlexCAN whenever the bit MCR[RFEN] is changed by ARM writes.
 *
 * Values:
 * - 1 - MB7 completed transmission/reception or FIFO overflow
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_IFLAG1_BUF7I  (7U)          /*!< Bit position for CAN_IFLAG1_BUF7I. */
#define BM_CAN_IFLAG1_BUF7I  (0x00000080U) /*!< Bit mask for CAN_IFLAG1_BUF7I. */
#define BS_CAN_IFLAG1_BUF7I  (1U)          /*!< Bit field size in bits for CAN_IFLAG1_BUF7I. */

/*! @brief Read current value of the CAN_IFLAG1_BUF7I field. */
#define BR_CAN_IFLAG1_BUF7I(x) (HW_CAN_IFLAG1(x).B.BUF7I)

/*! @brief Format value for bitfield CAN_IFLAG1_BUF7I. */
#define BF_CAN_IFLAG1_BUF7I(v) ((uint32_t)((uint32_t)(v) << BP_CAN_IFLAG1_BUF7I) & BM_CAN_IFLAG1_BUF7I)

/*! @brief Set the BUF7I field to a new value. */
#define BW_CAN_IFLAG1_BUF7I(x, v) (HW_CAN_IFLAG1_WR(x, (HW_CAN_IFLAG1_RD(x) & ~BM_CAN_IFLAG1_BUF7I) | BF_CAN_IFLAG1_BUF7I(v)))
/*@}*/

/*!
 * @name Register CAN_IFLAG1, field BUF31I_BUF8I[31:8] (RW)
 *
 * Each bit flags the respective FLEXCAN Message Buffer (MB8 to MB31) interrupt.
 *
 * Values:
 * - 1 - The corresponding MB has successfully completed transmission or
 *     reception
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_IFLAG1_BUF31I_BUF8I (8U)    /*!< Bit position for CAN_IFLAG1_BUF31I_BUF8I. */
#define BM_CAN_IFLAG1_BUF31I_BUF8I (0xFFFFFF00U) /*!< Bit mask for CAN_IFLAG1_BUF31I_BUF8I. */
#define BS_CAN_IFLAG1_BUF31I_BUF8I (24U)   /*!< Bit field size in bits for CAN_IFLAG1_BUF31I_BUF8I. */

/*! @brief Read current value of the CAN_IFLAG1_BUF31I_BUF8I field. */
#define BR_CAN_IFLAG1_BUF31I_BUF8I(x) (HW_CAN_IFLAG1(x).B.BUF31I_BUF8I)

/*! @brief Format value for bitfield CAN_IFLAG1_BUF31I_BUF8I. */
#define BF_CAN_IFLAG1_BUF31I_BUF8I(v) ((uint32_t)((uint32_t)(v) << BP_CAN_IFLAG1_BUF31I_BUF8I) & BM_CAN_IFLAG1_BUF31I_BUF8I)

/*! @brief Set the BUF31I_BUF8I field to a new value. */
#define BW_CAN_IFLAG1_BUF31I_BUF8I(x, v) (HW_CAN_IFLAG1_WR(x, (HW_CAN_IFLAG1_RD(x) & ~BM_CAN_IFLAG1_BUF31I_BUF8I) | BF_CAN_IFLAG1_BUF31I_BUF8I(v)))
/*@}*/

/*******************************************************************************
 * HW_CAN_CTRL2 - Control 2 Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_CTRL2 - Control 2 Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register contains control bits for CAN errors, FIFO features and mode
 * selection. Rx FIFO Filters RFFN[3:0] Number of Rx FIFO filters Message Buffers
 * occupied by Rx FIFO and ID Filter Table Remaining Available Mailboxes The
 * number of the last remaining available mailboxes is defined by the MCR[MAXMB]
 * field. Rx FIFO ID Filter Table Elements Affected by Rx Individual Masks If Rx
 * Individual Mask Registers are not enabled then all Rx FIFO filters are affected by
 * the Rx FIFO Global Mask. Rx FIFO ID Filter Table Elements Affected by Rx FIFO
 * Global Mask 0x0 8 MB 0-7 MB 8-63 Elements 0-7 none 0x1 16 MB 0-9 MB 10-63
 * Elements 0-9 Elements 10-15 0x2 24 MB 0-11 MB 12-63 Elements 0-11 Elements 12-23
 * 0x3 32 MB 0-13 MB 14-63 Elements 0-13 Elements 14-31 0x4 40 MB 0-15 MB 16-63
 * Elements 0-15 Elements 16-39 0x5 48 MB 0-17 MB 18-63 Elements 0-17 Elements
 * 18-47 0x6 56 MB 0-19 MB 20-63 Elements 0-19 Elements 20-55 0x7 64 MB 0-21 MB 22-63
 * Elements 0-21 Elements 22-63 0x8 72 MB 0-23 MB 24-63 Elements 0-23 Elements
 * 24-71 0x9 80 MB 0-25 MB 26-63 Elements 0-25 Elements 26-79 0xA 88 MB 0-27 MB
 * 28-63 Elements 0-27 Elements 28-87 0xB 96 MB 0-29 MB 30-63 Elements 0-29
 * Elements 30-95 0xC 104 MB 0-31 MB 32-63 Elements 0-31 Elements 32-103 0xD 112 MB 0-33
 * MB 34-63 Elements 0-31 Elements 32-111 0xE 120 MB 0-35 MB 36-63 Elements 0-31
 * Elements 32-119 0xF 128 MB 0-37 MB 38-63 Elements 0-31 Elements 32-127 Each
 * group of eight filters occupies a memory space equivalent to two Message
 * Buffers which means that the more filters are implemented the less Mailboxes will be
 * available. Considering that the Rx FIFO occupies the memory space originally
 * reserved for MB0-5, RFFN should be programmed with a value corresponding to a
 * number of filters not greater than the number of available memory words which
 * can be calculated as follows: where SETUP_MB is MAXMB. The number of remaining
 * Mailboxes available will be: If the Number of Rx FIFO Filters programmed
 * through RFFN exceeds the SETUP_MB value, the exceeding ones will not be
 * functional.Unshaded regions in indicate the valid combinations of MAXMB, RFEN and RFFN,
 * shaded regions are not functional. Valid Combinations of MAXMB, RFEN and RFFN
 * RFFN 0 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 RFEN 0 1 1 1 1 1 1 1 1 1 1 1 1 1
 * 1 1 1 MAXMB 0 - 6 7 - 8 9 - 10 11 - 12 13 -14 15 - 16 17 -18 19 - 20 21 - 22
 * 23 - 24 25 - 26 27 - 28 29 -30 31 - 32 33 - 34 35 - 36 37 - 63
 */
typedef union _hw_can_ctrl2
{
    uint32_t U;
    struct _hw_can_ctrl2_bitfields
    {
        uint32_t RESERVED0 : 16;       /*!< [15:0]  */
        uint32_t EACEN : 1;            /*!< [16]  */
        uint32_t RRS : 1;              /*!< [17]  */
        uint32_t MRP : 1;              /*!< [18]  */
        uint32_t TASD : 5;             /*!< [23:19]  */
        uint32_t RFEN : 4;             /*!< [27:24]  */
        uint32_t WRMFRZ : 1;           /*!< [28]  */
        uint32_t RESERVED1 : 3;        /*!< [31:29]  */
    } B;
} hw_can_ctrl2_t;

/*!
 * @name Constants and macros for entire CAN_CTRL2 register
 */
/*@{*/
#define HW_CAN_CTRL2_ADDR(x)     ((uintptr_t)(x) + 0x34U)

#define HW_CAN_CTRL2(x)          (*(__IO hw_can_ctrl2_t *) HW_CAN_CTRL2_ADDR(x))
#define HW_CAN_CTRL2_RD(x)       (HW_CAN_CTRL2(x).U)
#define HW_CAN_CTRL2_WR(x, v)    (HW_CAN_CTRL2(x).U = (v))
#define HW_CAN_CTRL2_SET(x, v)   (HW_CAN_CTRL2_WR(x, HW_CAN_CTRL2_RD(x) |  (v)))
#define HW_CAN_CTRL2_CLR(x, v)   (HW_CAN_CTRL2_WR(x, HW_CAN_CTRL2_RD(x) & ~(v)))
#define HW_CAN_CTRL2_TOG(x, v)   (HW_CAN_CTRL2_WR(x, HW_CAN_CTRL2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_CTRL2 bitfields
 */

/*!
 * @name Register CAN_CTRL2, field EACEN[16] (RW)
 *
 * This bit controls the comparison of IDE and RTR bits within Rx Mailboxes
 * filters with their corresponding bits in the incoming frame by the matching
 * process. This bit does not affect matching for Rx FIFO. This bit can only be written
 * in Freeze mode as it is blocked by hardware in other modes.
 *
 * Values:
 * - 1 - Enables the comparison of both Rx Mailbox filter's IDE and RTR bit with
 *     their corresponding bits within the incoming frame. Mask bits do apply.
 * - 0 - Rx Mailbox filter's IDE bit is always compared and RTR is never
 *     compared despite mask bits.
 */
/*@{*/
#define BP_CAN_CTRL2_EACEN   (16U)         /*!< Bit position for CAN_CTRL2_EACEN. */
#define BM_CAN_CTRL2_EACEN   (0x00010000U) /*!< Bit mask for CAN_CTRL2_EACEN. */
#define BS_CAN_CTRL2_EACEN   (1U)          /*!< Bit field size in bits for CAN_CTRL2_EACEN. */

/*! @brief Read current value of the CAN_CTRL2_EACEN field. */
#define BR_CAN_CTRL2_EACEN(x) (HW_CAN_CTRL2(x).B.EACEN)

/*! @brief Format value for bitfield CAN_CTRL2_EACEN. */
#define BF_CAN_CTRL2_EACEN(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL2_EACEN) & BM_CAN_CTRL2_EACEN)

/*! @brief Set the EACEN field to a new value. */
#define BW_CAN_CTRL2_EACEN(x, v) (HW_CAN_CTRL2_WR(x, (HW_CAN_CTRL2_RD(x) & ~BM_CAN_CTRL2_EACEN) | BF_CAN_CTRL2_EACEN(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL2, field RRS[17] (RW)
 *
 * If this bit is asserted Remote Request Frame is submitted to a matching
 * process and stored in the corresponding Message Buffer in the same fashion of a
 * Data Frame. No automatic Remote Response Frame will be generated. If this bit is
 * negated the Remote Request Frame is submitted to a matching process and an
 * automatic Remote Response Frame is generated if a Message Buffer with CODE=0b1010
 * is found with the same ID. This bit can only be written in Freeze mode as it
 * is blocked by hardware in other modes.
 *
 * Values:
 * - 1 - Remote Request Frame is stored
 * - 0 - Remote Response Frame is generated
 */
/*@{*/
#define BP_CAN_CTRL2_RRS     (17U)         /*!< Bit position for CAN_CTRL2_RRS. */
#define BM_CAN_CTRL2_RRS     (0x00020000U) /*!< Bit mask for CAN_CTRL2_RRS. */
#define BS_CAN_CTRL2_RRS     (1U)          /*!< Bit field size in bits for CAN_CTRL2_RRS. */

/*! @brief Read current value of the CAN_CTRL2_RRS field. */
#define BR_CAN_CTRL2_RRS(x)  (HW_CAN_CTRL2(x).B.RRS)

/*! @brief Format value for bitfield CAN_CTRL2_RRS. */
#define BF_CAN_CTRL2_RRS(v)  ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL2_RRS) & BM_CAN_CTRL2_RRS)

/*! @brief Set the RRS field to a new value. */
#define BW_CAN_CTRL2_RRS(x, v) (HW_CAN_CTRL2_WR(x, (HW_CAN_CTRL2_RD(x) & ~BM_CAN_CTRL2_RRS) | BF_CAN_CTRL2_RRS(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL2, field MRP[18] (RW)
 *
 * If this bit is set the matching process starts from the Mailboxes and if no
 * match occurs the matching continues on the Rx FIFO. This bit can only be
 * written in Freeze mode as it is blocked by hardware in other modes.
 *
 * Values:
 * - 1 - Matching starts from Mailboxes and continues on Rx FIFO
 * - 0 - Matching starts from Rx FIFO and continues on Mailboxes
 */
/*@{*/
#define BP_CAN_CTRL2_MRP     (18U)         /*!< Bit position for CAN_CTRL2_MRP. */
#define BM_CAN_CTRL2_MRP     (0x00040000U) /*!< Bit mask for CAN_CTRL2_MRP. */
#define BS_CAN_CTRL2_MRP     (1U)          /*!< Bit field size in bits for CAN_CTRL2_MRP. */

/*! @brief Read current value of the CAN_CTRL2_MRP field. */
#define BR_CAN_CTRL2_MRP(x)  (HW_CAN_CTRL2(x).B.MRP)

/*! @brief Format value for bitfield CAN_CTRL2_MRP. */
#define BF_CAN_CTRL2_MRP(v)  ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL2_MRP) & BM_CAN_CTRL2_MRP)

/*! @brief Set the MRP field to a new value. */
#define BW_CAN_CTRL2_MRP(x, v) (HW_CAN_CTRL2_WR(x, (HW_CAN_CTRL2_RD(x) & ~BM_CAN_CTRL2_MRP) | BF_CAN_CTRL2_MRP(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL2, field TASD[23:19] (RW)
 *
 * This 5-bit field indicates how many CAN bits the Tx arbitration process start
 * point can be delayed from the first bit of CRC field on CAN bus. This field
 * can only be written in Freeze mode as it is blocked by hardware in other modes.
 * This field is useful to optimize the transmit performance based on factors
 * such as: peripheral/serial clock ratio, CAN bit timing and number of MBs. The
 * duration of an arbitration process, in terms of CAN bits, is directly
 * proportional to the number of available MBs and CAN baud rate and inversely proportional
 * to the peripheral clock frequency. The optimal arbitration timing is that in
 * which the last MB is scanned right before the first bit of the Intermission
 * field of a CAN frame. Therefore, if there are few MBs and the system/serial
 * clock ratio is high and the CAN baud rate is low then the arbitration can be
 * delayed and vice-versa. If TASD is 0 then the arbitration start is not delayed,
 * thus ARM has less time to configure a Tx MB for the next arbitration, but more
 * time is reserved for arbitration. In the other hand, if TASD is 24 then ARM can
 * configure a Tx MB later and less time is reserved for arbitration. If too
 * little time is reserved for arbitration the FlexCAN may be not able to find winner
 * MBs in time to compete with other nodes for the CAN bus. If the arbitration
 * ends too much time before the first bit of Intermission field then there is a
 * chance that ARM reconfigure some Tx MBs and the winner MB is not the best to be
 * transmitted. The reset value is different on various platforms, according to
 * their peripheral clock frequency, number of MBs and target CAN baud rate. The
 * optimal configuration for TASD can be calculated as: where: fCANCLK is the
 * Protocol Engine (PE) Clock in Hz; PE clock is derrived from CAN_CLK_ROOT in CCM.
 * See Clock Root GeneratorThe Clock Root Generator (CCM_CLK_ROOT_GEN) sub-module
 * generates the root clocks to be delivered to LPCG. fSYS is the peripheral
 * clock in Hz; MAXMB is the value in CTRL1[MAXMB] field; RFEN is the value in
 * CTRL1[RFEN] bit; RFFN is the value in CTRL2[RFFN] field; PSEG1 is the value in
 * CTRL1[PSEG1] field; PSEG2 is the value in CTRL1[PSEG2] field; PROPSEG is the value
 * in CTRL1[PROPSEG] field; PRESDIV is the value in CTRL1[PRESDIV] field. Please
 * refer to Arbitration processThe arbitration process scans the Mailboxes
 * searching the Tx one that holds the message to be sent in the next opportunity.
 * This Mailbox is called the arbitration winner. and Protocol Timing for more
 * details.
 */
/*@{*/
#define BP_CAN_CTRL2_TASD    (19U)         /*!< Bit position for CAN_CTRL2_TASD. */
#define BM_CAN_CTRL2_TASD    (0x00F80000U) /*!< Bit mask for CAN_CTRL2_TASD. */
#define BS_CAN_CTRL2_TASD    (5U)          /*!< Bit field size in bits for CAN_CTRL2_TASD. */

/*! @brief Read current value of the CAN_CTRL2_TASD field. */
#define BR_CAN_CTRL2_TASD(x) (HW_CAN_CTRL2(x).B.TASD)

/*! @brief Format value for bitfield CAN_CTRL2_TASD. */
#define BF_CAN_CTRL2_TASD(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL2_TASD) & BM_CAN_CTRL2_TASD)

/*! @brief Set the TASD field to a new value. */
#define BW_CAN_CTRL2_TASD(x, v) (HW_CAN_CTRL2_WR(x, (HW_CAN_CTRL2_RD(x) & ~BM_CAN_CTRL2_TASD) | BF_CAN_CTRL2_TASD(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL2, field RFEN[27:24] (RW)
 *
 * This 4-bit field defines the number of Rx FIFO filters according to . The
 * maximum selectable number of filters is determined by the ARM. This field can
 * only be written in Freeze mode as it is blocked by hardware in other modes. RFFN
 * defines a number of Message Buffers occupied by Rx FIFO and ID Filter (see )
 * that may not e xceed the number of available Mailboxes present in module,
 * defined by MCR[MAXMB].Default RFFN value is 0x0, which leads to a total of 8 Rx
 * FIFO filters, occupies the first 8 Message Buffers (MB 0-7) and makes available
 * the next Message Buffers (MB 8-63) for Mailboxes. As a second example, when
 * RFFN is set to 0xD, there will be 112 Rx FIFO filters, located in MB 0-33, and MB
 * 34-63 are available for Mailboxes. Notice that, in this case, individual
 * masks (RXIMR) will just cover Rx FIFO filters in 0-31 range, and filters 32-111
 * will use RXFGMASK. In case of reducing the number of last Message Buffers,
 * MCR[MAXMB] (see MCRModule Configuration Register ) can be adjusted by the
 * application to minimum of 33, in order to give room to the Rx FIFO and its ID Filter
 * Table defined by RFFN. On the contrary, if the application sets MCR[MAXMB] to
 * 16, for instance, the maximum RFFN is limited to 0x4. RFFN also impacts the
 * definition of the minimum number of peripheral clocks per CAN bit as described in
 * (see Arbitration and Matching Timing).
 */
/*@{*/
#define BP_CAN_CTRL2_RFEN    (24U)         /*!< Bit position for CAN_CTRL2_RFEN. */
#define BM_CAN_CTRL2_RFEN    (0x0F000000U) /*!< Bit mask for CAN_CTRL2_RFEN. */
#define BS_CAN_CTRL2_RFEN    (4U)          /*!< Bit field size in bits for CAN_CTRL2_RFEN. */

/*! @brief Read current value of the CAN_CTRL2_RFEN field. */
#define BR_CAN_CTRL2_RFEN(x) (HW_CAN_CTRL2(x).B.RFEN)

/*! @brief Format value for bitfield CAN_CTRL2_RFEN. */
#define BF_CAN_CTRL2_RFEN(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL2_RFEN) & BM_CAN_CTRL2_RFEN)

/*! @brief Set the RFEN field to a new value. */
#define BW_CAN_CTRL2_RFEN(x, v) (HW_CAN_CTRL2_WR(x, (HW_CAN_CTRL2_RD(x) & ~BM_CAN_CTRL2_RFEN) | BF_CAN_CTRL2_RFEN(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL2, field WRMFRZ[28] (RW)
 *
 * Enable unrestricted write access to FlexCAN memory in Freeze mode. This bit
 * can only be written in Freeze mode and has no effect out of Freeze mode.
 *
 * Values:
 * - 1 - Enable unrestricted write access to FlexCAN memory
 * - 0 - Keep the write access restricted in some regions of FlexCAN memory
 */
/*@{*/
#define BP_CAN_CTRL2_WRMFRZ  (28U)         /*!< Bit position for CAN_CTRL2_WRMFRZ. */
#define BM_CAN_CTRL2_WRMFRZ  (0x10000000U) /*!< Bit mask for CAN_CTRL2_WRMFRZ. */
#define BS_CAN_CTRL2_WRMFRZ  (1U)          /*!< Bit field size in bits for CAN_CTRL2_WRMFRZ. */

/*! @brief Read current value of the CAN_CTRL2_WRMFRZ field. */
#define BR_CAN_CTRL2_WRMFRZ(x) (HW_CAN_CTRL2(x).B.WRMFRZ)

/*! @brief Format value for bitfield CAN_CTRL2_WRMFRZ. */
#define BF_CAN_CTRL2_WRMFRZ(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL2_WRMFRZ) & BM_CAN_CTRL2_WRMFRZ)

/*! @brief Set the WRMFRZ field to a new value. */
#define BW_CAN_CTRL2_WRMFRZ(x, v) (HW_CAN_CTRL2_WR(x, (HW_CAN_CTRL2_RD(x) & ~BM_CAN_CTRL2_WRMFRZ) | BF_CAN_CTRL2_WRMFRZ(v)))
/*@}*/

/*******************************************************************************
 * HW_CAN_ESR2 - Error and Status 2 Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_ESR2 - Error and Status 2 Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * This register reflects various interrupt flags and some general status.
 */
typedef union _hw_can_esr2
{
    uint32_t U;
    struct _hw_can_esr2_bitfields
    {
        uint32_t RESERVED0 : 13;       /*!< [12:0]  */
        uint32_t IMB : 1;              /*!< [13]  */
        uint32_t VPS : 1;              /*!< [14]  */
        uint32_t RESERVED1 : 1;        /*!< [15]  */
        uint32_t LPTM : 7;             /*!< [22:16]  */
        uint32_t RESERVED2 : 9;        /*!< [31:23]  */
    } B;
} hw_can_esr2_t;

/*!
 * @name Constants and macros for entire CAN_ESR2 register
 */
/*@{*/
#define HW_CAN_ESR2_ADDR(x)      ((uintptr_t)(x) + 0x38U)

#define HW_CAN_ESR2(x)           (*(__I hw_can_esr2_t *) HW_CAN_ESR2_ADDR(x))
#define HW_CAN_ESR2_RD(x)        (HW_CAN_ESR2(x).U)
/*@}*/

/*
 * Constants & macros for individual CAN_ESR2 bitfields
 */

/*!
 * @name Register CAN_ESR2, field IMB[13] (RO)
 *
 * If ESR2[VPS] is asserted, this bit indicates whether there is any inactive
 * Mailbox (CODE field is either 0b1000 or 0b0000). This bit is asserted in the
 * following cases: (1) During arbitration, if a LPTM is found and it is inactive.
 * (2) If IMB is not asserted and a frame is transmitted successfully. (3) This
 * bit is cleared in all start of arbitration (see Arbitration processThe
 * arbitration process scans the Mailboxes searching the Tx one that holds the message to
 * be sent in the next opportunity. This Mailbox is called the arbitration
 * winner. ). LPTM mechanism have the following behavior: if a MB is successfully
 * transmitted and ESR2[IMB]=0 (no inactive Mailbox), then ESR2[VPS] and ESR2[IMB] are
 * asserted and the index related to the MB just transmitted is loaded into
 * ESR2[LPTM].
 *
 * Values:
 * - 1 - If ESR2[VPS] is asserted, there is at least one inactive Mailbox. LPTM
 *     content is the number of the first one.
 * - 0 - If ESR2[VPS] is asserted, the ESR2[LPTM] is not an inactive Mailbox.
 */
/*@{*/
#define BP_CAN_ESR2_IMB      (13U)         /*!< Bit position for CAN_ESR2_IMB. */
#define BM_CAN_ESR2_IMB      (0x00002000U) /*!< Bit mask for CAN_ESR2_IMB. */
#define BS_CAN_ESR2_IMB      (1U)          /*!< Bit field size in bits for CAN_ESR2_IMB. */

/*! @brief Read current value of the CAN_ESR2_IMB field. */
#define BR_CAN_ESR2_IMB(x)   (HW_CAN_ESR2(x).B.IMB)
/*@}*/

/*!
 * @name Register CAN_ESR2, field VPS[14] (RO)
 *
 * This bit indicates whether IMB and LPTM contents are currently valid or not.
 * VPS is asserted upon every complete Tx arbitration process unless the ARM
 * writes to Control and Status word of a Mailbox that has already been scanned (i.e.
 * it is behind Tx Arbitration Pointer) during the Tx arbitration process. If
 * there is no inactive Mailbox and only one Tx Mailbox which is being transmitted
 * then VPS is not asserted. VPS is negated upon the start of every Tx
 * arbitration process or upon a write to Control and Status word of any Mailbox.ESR2[VPS]
 * is not affected by any ARM write into Control Status (C/S) of a MB which is
 * blocked by abort mechanism. When MCR[AEN] is asserted, the abort code write in
 * C/S of a MB that is been transmitted (pending abort), or any write attempt into
 * a Tx MB with IFLAG set is blocked.
 *
 * Values:
 * - 1 - Contents of IMB and LPTM are valid
 * - 0 - Contents of IMB and LPTM are invalid
 */
/*@{*/
#define BP_CAN_ESR2_VPS      (14U)         /*!< Bit position for CAN_ESR2_VPS. */
#define BM_CAN_ESR2_VPS      (0x00004000U) /*!< Bit mask for CAN_ESR2_VPS. */
#define BS_CAN_ESR2_VPS      (1U)          /*!< Bit field size in bits for CAN_ESR2_VPS. */

/*! @brief Read current value of the CAN_ESR2_VPS field. */
#define BR_CAN_ESR2_VPS(x)   (HW_CAN_ESR2(x).B.VPS)
/*@}*/

/*!
 * @name Register CAN_ESR2, field LPTM[22:16] (RO)
 *
 * If ESR2[VPS] is asserted, his 7-bit field indicates the lowest number
 * inactive Mailbox (refer to IMB bit description). If there is no inactive Mailbox then
 * the Mailbox indicated depends on CTRL1[LBUF] bit value. If CTRL1[LBUF] bit is
 * negated then the Mailbox indicated is the one which has the greatest
 * arbitration value (see Highest Mailbox priority firstIf CTRL1[LBUF] bit is negated
 * then the arbitration process searches the active Tx Mailbox with the highest
 * priority, and this Mailbox would have a higher probability to win the arbitration
 * on CAN bus. ). If CTRL1[LBUF] bit is asserted then the Mailbox indicated is
 * the highest number active Tx Mailbox. If a Tx Mailbox is being transmitted it is
 * not considered in LPTM calculation. If ESR2[IMB] is not asserted and a frame
 * is transmitted successfully, LPTM is updated with its Mailbox number.
 */
/*@{*/
#define BP_CAN_ESR2_LPTM     (16U)         /*!< Bit position for CAN_ESR2_LPTM. */
#define BM_CAN_ESR2_LPTM     (0x007F0000U) /*!< Bit mask for CAN_ESR2_LPTM. */
#define BS_CAN_ESR2_LPTM     (7U)          /*!< Bit field size in bits for CAN_ESR2_LPTM. */

/*! @brief Read current value of the CAN_ESR2_LPTM field. */
#define BR_CAN_ESR2_LPTM(x)  (HW_CAN_ESR2(x).B.LPTM)
/*@}*/

/*******************************************************************************
 * HW_CAN_CRCR - CRC Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_CRCR - CRC Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * This register provides information about the CRC of transmitted messages
 */
typedef union _hw_can_crcr
{
    uint32_t U;
    struct _hw_can_crcr_bitfields
    {
        uint32_t TXCRC : 15;           /*!< [14:0]  */
        uint32_t RESERVED0 : 1;        /*!< [15]  */
        uint32_t MBCRC : 7;            /*!< [22:16]  */
        uint32_t RESERVED1 : 9;        /*!< [31:23]  */
    } B;
} hw_can_crcr_t;

/*!
 * @name Constants and macros for entire CAN_CRCR register
 */
/*@{*/
#define HW_CAN_CRCR_ADDR(x)      ((uintptr_t)(x) + 0x44U)

#define HW_CAN_CRCR(x)           (*(__I hw_can_crcr_t *) HW_CAN_CRCR_ADDR(x))
#define HW_CAN_CRCR_RD(x)        (HW_CAN_CRCR(x).U)
/*@}*/

/*
 * Constants & macros for individual CAN_CRCR bitfields
 */

/*!
 * @name Register CAN_CRCR, field TXCRC[14:0] (RO)
 *
 * This field indicates the CRC value of the last message transmitted. This
 * field is updated at the same time the Tx Interrupt Flag is asserted.
 */
/*@{*/
#define BP_CAN_CRCR_TXCRC    (0U)          /*!< Bit position for CAN_CRCR_TXCRC. */
#define BM_CAN_CRCR_TXCRC    (0x00007FFFU) /*!< Bit mask for CAN_CRCR_TXCRC. */
#define BS_CAN_CRCR_TXCRC    (15U)         /*!< Bit field size in bits for CAN_CRCR_TXCRC. */

/*! @brief Read current value of the CAN_CRCR_TXCRC field. */
#define BR_CAN_CRCR_TXCRC(x) (HW_CAN_CRCR(x).B.TXCRC)
/*@}*/

/*!
 * @name Register CAN_CRCR, field MBCRC[22:16] (RO)
 *
 * This field indicates the number of the Mailbox corresponding to the value in
 * TXCRC field.
 */
/*@{*/
#define BP_CAN_CRCR_MBCRC    (16U)         /*!< Bit position for CAN_CRCR_MBCRC. */
#define BM_CAN_CRCR_MBCRC    (0x007F0000U) /*!< Bit mask for CAN_CRCR_MBCRC. */
#define BS_CAN_CRCR_MBCRC    (7U)          /*!< Bit field size in bits for CAN_CRCR_MBCRC. */

/*! @brief Read current value of the CAN_CRCR_MBCRC field. */
#define BR_CAN_CRCR_MBCRC(x) (HW_CAN_CRCR(x).B.MBCRC)
/*@}*/

/*******************************************************************************
 * HW_CAN_RXFGMASK - Rx FIFO Global Mask Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_RXFGMASK - Rx FIFO Global Mask Register (RW)
 *
 * Reset value: 0xFFFFFFFFU
 *
 * If Rx FIFO is enabled RXFGMASK is used to mask the Rx FIFO ID Filter Table
 * elements that do not have a corresponding RXIMR according to CTRL2[RFFN] field
 * setting. This register can only be written in Freeze Mode as it is blocked by
 * hardware in other modes. Rx FIFO Global Mask usage Rx FIFO ID Filter Table
 * Elements Format (MCR[IDAM]) Identifier Acceptance Filter fields RTR IDE RXIDA
 * RXIDB RXIDC reserved A FGM[31] FGM[30] FGM[29:1] - - FGM[0] B FGM[31] FGM[15]
 * FGM[30] FGM[14] - FGM[29:16] FGM[13:0] If MCR[IDAM] field is equivalent to the
 * format B only the fourteen most significant bits of the Identifier of the
 * incoming frame are compared with the Rx FIFO filter. - C - - - FGM[31:24] FGM[23:16]
 * FGM[15:8] FGM[7:0] If MCR[IDAM] field is equivalent to the format C only the
 * eight most significant bits of the Identifier of the incoming frame are
 * compared with the Rx FIFO filter.
 */
typedef union _hw_can_rxfgmask
{
    uint32_t U;
    struct _hw_can_rxfgmask_bitfields
    {
        uint32_t FGM31_FGM0 : 32;      /*!< [31:0]  */
    } B;
} hw_can_rxfgmask_t;

/*!
 * @name Constants and macros for entire CAN_RXFGMASK register
 */
/*@{*/
#define HW_CAN_RXFGMASK_ADDR(x)  ((uintptr_t)(x) + 0x48U)

#define HW_CAN_RXFGMASK(x)       (*(__IO hw_can_rxfgmask_t *) HW_CAN_RXFGMASK_ADDR(x))
#define HW_CAN_RXFGMASK_RD(x)    (HW_CAN_RXFGMASK(x).U)
#define HW_CAN_RXFGMASK_WR(x, v) (HW_CAN_RXFGMASK(x).U = (v))
#define HW_CAN_RXFGMASK_SET(x, v) (HW_CAN_RXFGMASK_WR(x, HW_CAN_RXFGMASK_RD(x) |  (v)))
#define HW_CAN_RXFGMASK_CLR(x, v) (HW_CAN_RXFGMASK_WR(x, HW_CAN_RXFGMASK_RD(x) & ~(v)))
#define HW_CAN_RXFGMASK_TOG(x, v) (HW_CAN_RXFGMASK_WR(x, HW_CAN_RXFGMASK_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_RXFGMASK bitfields
 */

/*!
 * @name Register CAN_RXFGMASK, field FGM31_FGM0[31:0] (RW)
 *
 * These bits mask the ID Filter Table elements bits in a perfect
 * alignment.RXFGMASKRx FIFO Global Mask Register shows in detail which FGM bits mask each IDAF
 * field. Clear this register has the effect of disabling the ID Filter.
 *
 * Values:
 * - 1 - The corresponding bit in the filter is checked
 * - 0 - The corresponding bit in the filter is "don't care"
 */
/*@{*/
#define BP_CAN_RXFGMASK_FGM31_FGM0 (0U)    /*!< Bit position for CAN_RXFGMASK_FGM31_FGM0. */
#define BM_CAN_RXFGMASK_FGM31_FGM0 (0xFFFFFFFFU) /*!< Bit mask for CAN_RXFGMASK_FGM31_FGM0. */
#define BS_CAN_RXFGMASK_FGM31_FGM0 (32U)   /*!< Bit field size in bits for CAN_RXFGMASK_FGM31_FGM0. */

/*! @brief Read current value of the CAN_RXFGMASK_FGM31_FGM0 field. */
#define BR_CAN_RXFGMASK_FGM31_FGM0(x) (HW_CAN_RXFGMASK(x).U)

/*! @brief Format value for bitfield CAN_RXFGMASK_FGM31_FGM0. */
#define BF_CAN_RXFGMASK_FGM31_FGM0(v) ((uint32_t)((uint32_t)(v) << BP_CAN_RXFGMASK_FGM31_FGM0) & BM_CAN_RXFGMASK_FGM31_FGM0)

/*! @brief Set the FGM31_FGM0 field to a new value. */
#define BW_CAN_RXFGMASK_FGM31_FGM0(x, v) (HW_CAN_RXFGMASK_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_CAN_RXFIR - Rx FIFO Information Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_RXFIR - Rx FIFO Information Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * RXFIR provides information on Rx FIFO. This register is the port through
 * which ARM accesses the output of the RXFIR FIFO located in RAM. The RXFIR FIFO is
 * written by the FlexCAN whenever a new message is moved into the Rx FIFO as
 * well as its output is updated whenever the output of the Rx FIFO is updated with
 * the next message. Refer to Rx FIFOThe receive-only FIFO is enabled by
 * asserting the RFEN bit in the MCR. to find instructions on reading this register.
 */
typedef union _hw_can_rxfir
{
    uint32_t U;
    struct _hw_can_rxfir_bitfields
    {
        uint32_t IDHIT : 9;            /*!< [8:0]  */
        uint32_t RESERVED0 : 23;       /*!< [31:9]  */
    } B;
} hw_can_rxfir_t;

/*!
 * @name Constants and macros for entire CAN_RXFIR register
 */
/*@{*/
#define HW_CAN_RXFIR_ADDR(x)     ((uintptr_t)(x) + 0x4CU)

#define HW_CAN_RXFIR(x)          (*(__I hw_can_rxfir_t *) HW_CAN_RXFIR_ADDR(x))
#define HW_CAN_RXFIR_RD(x)       (HW_CAN_RXFIR(x).U)
/*@}*/

/*
 * Constants & macros for individual CAN_RXFIR bitfields
 */

/*!
 * @name Register CAN_RXFIR, field IDHIT[8:0] (RO)
 *
 * This 9-bit field indicates which Identifier Acceptance Filter (see Rx FIFO
 * StructureWhen the MCR[RFEN] bit is set, the memory area from $80 to $DC (which
 * is normally occupied by MBs 0 to 5) is used by the reception FIFO engine. ) was
 * hit by the received message that is in the output of the Rx FIFO. (refer to
 * Rx FIFOThe receive-only FIFO is enabled by asserting the RFEN bit in the MCR.
 * for details) If multiple filters match the incoming message ID then the first
 * matching IDAF found (lowest number) by the matching process is indicated. This
 * field is valid only while the IFLAG[BUF5I] is asserted.
 */
/*@{*/
#define BP_CAN_RXFIR_IDHIT   (0U)          /*!< Bit position for CAN_RXFIR_IDHIT. */
#define BM_CAN_RXFIR_IDHIT   (0x000001FFU) /*!< Bit mask for CAN_RXFIR_IDHIT. */
#define BS_CAN_RXFIR_IDHIT   (9U)          /*!< Bit field size in bits for CAN_RXFIR_IDHIT. */

/*! @brief Read current value of the CAN_RXFIR_IDHIT field. */
#define BR_CAN_RXFIR_IDHIT(x) (HW_CAN_RXFIR(x).B.IDHIT)
/*@}*/

/*******************************************************************************
 * HW_CAN_CSn - Message Buffer 0 CS Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_CSn - Message Buffer 0 CS Register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_can_csn
{
    uint32_t U;
    struct _hw_can_csn_bitfields
    {
        uint32_t TIME_STAMP : 16;      /*!< [15:0] Free-Running Counter Time
                                        * stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx
                                        * and Rx frames at the time when the beginning of the Identifier field
                                        * appears on the CAN bus. */
        uint32_t DLC : 4;              /*!< [19:16] Length of the data to be
                                        * stored/transmitted. */
        uint32_t RTR : 1;              /*!< [20] Remote Transmission Request. One/zero for
                                        * remote/data frame. */
        uint32_t IDE : 1;              /*!< [21] ID Extended. One/zero for
                                        * extended/standard format frame. */
        uint32_t SRR : 1;              /*!< [22] Substitute Remote Request. Contains a
                                        * fixed recessive bit. */
        uint32_t RESERVED0 : 1;        /*!< [23] Reserved */
        uint32_t CODE : 4;             /*!< [27:24] Reserved */
        uint32_t RESERVED1 : 4;        /*!< [31:28] Reserved */
    } B;
} hw_can_csn_t;

/*!
 * @name Constants and macros for entire CAN_CSn register
 */
/*@{*/
#define HW_CAN_CSn_COUNT (64U)

#define HW_CAN_CSn_ADDR(x, n)    ((uintptr_t)(x) + 0x80U + (0x10U * (n)))

#define HW_CAN_CSn(x, n)         (*(__IO hw_can_csn_t *) HW_CAN_CSn_ADDR(x, n))
#define HW_CAN_CSn_RD(x, n)      (HW_CAN_CSn(x, n).U)
#define HW_CAN_CSn_WR(x, n, v)   (HW_CAN_CSn(x, n).U = (v))
#define HW_CAN_CSn_SET(x, n, v)  (HW_CAN_CSn_WR(x, n, HW_CAN_CSn_RD(x, n) |  (v)))
#define HW_CAN_CSn_CLR(x, n, v)  (HW_CAN_CSn_WR(x, n, HW_CAN_CSn_RD(x, n) & ~(v)))
#define HW_CAN_CSn_TOG(x, n, v)  (HW_CAN_CSn_WR(x, n, HW_CAN_CSn_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_CSn bitfields
 */

/*!
 * @name Register CAN_CSn, field TIME_STAMP[15:0] (RW)
 */
/*@{*/
#define BP_CAN_CSn_TIME_STAMP (0U)         /*!< Bit position for CAN_CSn_TIME_STAMP. */
#define BM_CAN_CSn_TIME_STAMP (0x0000FFFFU) /*!< Bit mask for CAN_CSn_TIME_STAMP. */
#define BS_CAN_CSn_TIME_STAMP (16U)        /*!< Bit field size in bits for CAN_CSn_TIME_STAMP. */

/*! @brief Read current value of the CAN_CSn_TIME_STAMP field. */
#define BR_CAN_CSn_TIME_STAMP(x, n) (HW_CAN_CSn(x, n).B.TIME_STAMP)

/*! @brief Format value for bitfield CAN_CSn_TIME_STAMP. */
#define BF_CAN_CSn_TIME_STAMP(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CSn_TIME_STAMP) & BM_CAN_CSn_TIME_STAMP)

/*! @brief Set the TIME_STAMP field to a new value. */
#define BW_CAN_CSn_TIME_STAMP(x, n, v) (HW_CAN_CSn_WR(x, n, (HW_CAN_CSn_RD(x, n) & ~BM_CAN_CSn_TIME_STAMP) | BF_CAN_CSn_TIME_STAMP(v)))
/*@}*/

/*!
 * @name Register CAN_CSn, field DLC[19:16] (RW)
 */
/*@{*/
#define BP_CAN_CSn_DLC       (16U)         /*!< Bit position for CAN_CSn_DLC. */
#define BM_CAN_CSn_DLC       (0x000F0000U) /*!< Bit mask for CAN_CSn_DLC. */
#define BS_CAN_CSn_DLC       (4U)          /*!< Bit field size in bits for CAN_CSn_DLC. */

/*! @brief Read current value of the CAN_CSn_DLC field. */
#define BR_CAN_CSn_DLC(x, n) (HW_CAN_CSn(x, n).B.DLC)

/*! @brief Format value for bitfield CAN_CSn_DLC. */
#define BF_CAN_CSn_DLC(v)    ((uint32_t)((uint32_t)(v) << BP_CAN_CSn_DLC) & BM_CAN_CSn_DLC)

/*! @brief Set the DLC field to a new value. */
#define BW_CAN_CSn_DLC(x, n, v) (HW_CAN_CSn_WR(x, n, (HW_CAN_CSn_RD(x, n) & ~BM_CAN_CSn_DLC) | BF_CAN_CSn_DLC(v)))
/*@}*/

/*!
 * @name Register CAN_CSn, field RTR[20] (RW)
 */
/*@{*/
#define BP_CAN_CSn_RTR       (20U)         /*!< Bit position for CAN_CSn_RTR. */
#define BM_CAN_CSn_RTR       (0x00100000U) /*!< Bit mask for CAN_CSn_RTR. */
#define BS_CAN_CSn_RTR       (1U)          /*!< Bit field size in bits for CAN_CSn_RTR. */

/*! @brief Read current value of the CAN_CSn_RTR field. */
#define BR_CAN_CSn_RTR(x, n) (HW_CAN_CSn(x, n).B.RTR)

/*! @brief Format value for bitfield CAN_CSn_RTR. */
#define BF_CAN_CSn_RTR(v)    ((uint32_t)((uint32_t)(v) << BP_CAN_CSn_RTR) & BM_CAN_CSn_RTR)

/*! @brief Set the RTR field to a new value. */
#define BW_CAN_CSn_RTR(x, n, v) (HW_CAN_CSn_WR(x, n, (HW_CAN_CSn_RD(x, n) & ~BM_CAN_CSn_RTR) | BF_CAN_CSn_RTR(v)))
/*@}*/

/*!
 * @name Register CAN_CSn, field IDE[21] (RW)
 */
/*@{*/
#define BP_CAN_CSn_IDE       (21U)         /*!< Bit position for CAN_CSn_IDE. */
#define BM_CAN_CSn_IDE       (0x00200000U) /*!< Bit mask for CAN_CSn_IDE. */
#define BS_CAN_CSn_IDE       (1U)          /*!< Bit field size in bits for CAN_CSn_IDE. */

/*! @brief Read current value of the CAN_CSn_IDE field. */
#define BR_CAN_CSn_IDE(x, n) (HW_CAN_CSn(x, n).B.IDE)

/*! @brief Format value for bitfield CAN_CSn_IDE. */
#define BF_CAN_CSn_IDE(v)    ((uint32_t)((uint32_t)(v) << BP_CAN_CSn_IDE) & BM_CAN_CSn_IDE)

/*! @brief Set the IDE field to a new value. */
#define BW_CAN_CSn_IDE(x, n, v) (HW_CAN_CSn_WR(x, n, (HW_CAN_CSn_RD(x, n) & ~BM_CAN_CSn_IDE) | BF_CAN_CSn_IDE(v)))
/*@}*/

/*!
 * @name Register CAN_CSn, field SRR[22] (RW)
 */
/*@{*/
#define BP_CAN_CSn_SRR       (22U)         /*!< Bit position for CAN_CSn_SRR. */
#define BM_CAN_CSn_SRR       (0x00400000U) /*!< Bit mask for CAN_CSn_SRR. */
#define BS_CAN_CSn_SRR       (1U)          /*!< Bit field size in bits for CAN_CSn_SRR. */

/*! @brief Read current value of the CAN_CSn_SRR field. */
#define BR_CAN_CSn_SRR(x, n) (HW_CAN_CSn(x, n).B.SRR)

/*! @brief Format value for bitfield CAN_CSn_SRR. */
#define BF_CAN_CSn_SRR(v)    ((uint32_t)((uint32_t)(v) << BP_CAN_CSn_SRR) & BM_CAN_CSn_SRR)

/*! @brief Set the SRR field to a new value. */
#define BW_CAN_CSn_SRR(x, n, v) (HW_CAN_CSn_WR(x, n, (HW_CAN_CSn_RD(x, n) & ~BM_CAN_CSn_SRR) | BF_CAN_CSn_SRR(v)))
/*@}*/

/*!
 * @name Register CAN_CSn, field CODE[27:24] (RW)
 */
/*@{*/
#define BP_CAN_CSn_CODE      (24U)         /*!< Bit position for CAN_CSn_CODE. */
#define BM_CAN_CSn_CODE      (0x0F000000U) /*!< Bit mask for CAN_CSn_CODE. */
#define BS_CAN_CSn_CODE      (4U)          /*!< Bit field size in bits for CAN_CSn_CODE. */

/*! @brief Read current value of the CAN_CSn_CODE field. */
#define BR_CAN_CSn_CODE(x, n) (HW_CAN_CSn(x, n).B.CODE)

/*! @brief Format value for bitfield CAN_CSn_CODE. */
#define BF_CAN_CSn_CODE(v)   ((uint32_t)((uint32_t)(v) << BP_CAN_CSn_CODE) & BM_CAN_CSn_CODE)

/*! @brief Set the CODE field to a new value. */
#define BW_CAN_CSn_CODE(x, n, v) (HW_CAN_CSn_WR(x, n, (HW_CAN_CSn_RD(x, n) & ~BM_CAN_CSn_CODE) | BF_CAN_CSn_CODE(v)))
/*@}*/
/*******************************************************************************
 * HW_CAN_IDn - Message Buffer 0 ID Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_IDn - Message Buffer 0 ID Register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_can_idn
{
    uint32_t U;
    struct _hw_can_idn_bitfields
    {
        uint32_t EXT : 18;             /*!< [17:0] Contains extended (LOW word)
                                        * identifier of message buffer. */
        uint32_t STD : 11;             /*!< [28:18] Contains standard/extended (HIGH
                                        * word) identifier of message buffer. */
        uint32_t PRIO : 3;             /*!< [31:29] Local priority. This 3-bit fieldis
                                        * only used when LPRIO_EN bit is set in MCR and it only makes sense for Tx
                                        * buffers. These bits are not transmitted. They are appended to the regular
                                        * ID to define the transmission priority. */
    } B;
} hw_can_idn_t;

/*!
 * @name Constants and macros for entire CAN_IDn register
 */
/*@{*/
#define HW_CAN_IDn_COUNT (64U)

#define HW_CAN_IDn_ADDR(x, n)    ((uintptr_t)(x) + 0x84U + (0x10U * (n)))

#define HW_CAN_IDn(x, n)         (*(__IO hw_can_idn_t *) HW_CAN_IDn_ADDR(x, n))
#define HW_CAN_IDn_RD(x, n)      (HW_CAN_IDn(x, n).U)
#define HW_CAN_IDn_WR(x, n, v)   (HW_CAN_IDn(x, n).U = (v))
#define HW_CAN_IDn_SET(x, n, v)  (HW_CAN_IDn_WR(x, n, HW_CAN_IDn_RD(x, n) |  (v)))
#define HW_CAN_IDn_CLR(x, n, v)  (HW_CAN_IDn_WR(x, n, HW_CAN_IDn_RD(x, n) & ~(v)))
#define HW_CAN_IDn_TOG(x, n, v)  (HW_CAN_IDn_WR(x, n, HW_CAN_IDn_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_IDn bitfields
 */

/*!
 * @name Register CAN_IDn, field EXT[17:0] (RW)
 */
/*@{*/
#define BP_CAN_IDn_EXT       (0U)          /*!< Bit position for CAN_IDn_EXT. */
#define BM_CAN_IDn_EXT       (0x0003FFFFU) /*!< Bit mask for CAN_IDn_EXT. */
#define BS_CAN_IDn_EXT       (18U)         /*!< Bit field size in bits for CAN_IDn_EXT. */

/*! @brief Read current value of the CAN_IDn_EXT field. */
#define BR_CAN_IDn_EXT(x, n) (HW_CAN_IDn(x, n).B.EXT)

/*! @brief Format value for bitfield CAN_IDn_EXT. */
#define BF_CAN_IDn_EXT(v)    ((uint32_t)((uint32_t)(v) << BP_CAN_IDn_EXT) & BM_CAN_IDn_EXT)

/*! @brief Set the EXT field to a new value. */
#define BW_CAN_IDn_EXT(x, n, v) (HW_CAN_IDn_WR(x, n, (HW_CAN_IDn_RD(x, n) & ~BM_CAN_IDn_EXT) | BF_CAN_IDn_EXT(v)))
/*@}*/

/*!
 * @name Register CAN_IDn, field STD[28:18] (RW)
 */
/*@{*/
#define BP_CAN_IDn_STD       (18U)         /*!< Bit position for CAN_IDn_STD. */
#define BM_CAN_IDn_STD       (0x1FFC0000U) /*!< Bit mask for CAN_IDn_STD. */
#define BS_CAN_IDn_STD       (11U)         /*!< Bit field size in bits for CAN_IDn_STD. */

/*! @brief Read current value of the CAN_IDn_STD field. */
#define BR_CAN_IDn_STD(x, n) (HW_CAN_IDn(x, n).B.STD)

/*! @brief Format value for bitfield CAN_IDn_STD. */
#define BF_CAN_IDn_STD(v)    ((uint32_t)((uint32_t)(v) << BP_CAN_IDn_STD) & BM_CAN_IDn_STD)

/*! @brief Set the STD field to a new value. */
#define BW_CAN_IDn_STD(x, n, v) (HW_CAN_IDn_WR(x, n, (HW_CAN_IDn_RD(x, n) & ~BM_CAN_IDn_STD) | BF_CAN_IDn_STD(v)))
/*@}*/

/*!
 * @name Register CAN_IDn, field PRIO[31:29] (RW)
 */
/*@{*/
#define BP_CAN_IDn_PRIO      (29U)         /*!< Bit position for CAN_IDn_PRIO. */
#define BM_CAN_IDn_PRIO      (0xE0000000U) /*!< Bit mask for CAN_IDn_PRIO. */
#define BS_CAN_IDn_PRIO      (3U)          /*!< Bit field size in bits for CAN_IDn_PRIO. */

/*! @brief Read current value of the CAN_IDn_PRIO field. */
#define BR_CAN_IDn_PRIO(x, n) (HW_CAN_IDn(x, n).B.PRIO)

/*! @brief Format value for bitfield CAN_IDn_PRIO. */
#define BF_CAN_IDn_PRIO(v)   ((uint32_t)((uint32_t)(v) << BP_CAN_IDn_PRIO) & BM_CAN_IDn_PRIO)

/*! @brief Set the PRIO field to a new value. */
#define BW_CAN_IDn_PRIO(x, n, v) (HW_CAN_IDn_WR(x, n, (HW_CAN_IDn_RD(x, n) & ~BM_CAN_IDn_PRIO) | BF_CAN_IDn_PRIO(v)))
/*@}*/
/*******************************************************************************
 * HW_CAN_WORD0n - Message Buffer 0 WORD0 Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_WORD0n - Message Buffer 0 WORD0 Register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_can_word0n
{
    uint32_t U;
    struct _hw_can_word0n_bitfields
    {
        uint32_t DATA_BYTE_3 : 8;      /*!< [7:0] Data byte 3 of Rx/Tx frame. */
        uint32_t DATA_BYTE_2 : 8;      /*!< [15:8] Data byte 2 of Rx/Tx frame. */
        uint32_t DATA_BYTE_1 : 8;      /*!< [23:16] Data byte 1 of Rx/Tx frame. */
        uint32_t DATA_BYTE_0 : 8;      /*!< [31:24] Data byte 0 of Rx/Tx frame. */
    } B;
} hw_can_word0n_t;

/*!
 * @name Constants and macros for entire CAN_WORD0n register
 */
/*@{*/
#define HW_CAN_WORD0n_COUNT (64U)

#define HW_CAN_WORD0n_ADDR(x, n) ((uintptr_t)(x) + 0x88U + (0x10U * (n)))

#define HW_CAN_WORD0n(x, n)      (*(__IO hw_can_word0n_t *) HW_CAN_WORD0n_ADDR(x, n))
#define HW_CAN_WORD0n_RD(x, n)   (HW_CAN_WORD0n(x, n).U)
#define HW_CAN_WORD0n_WR(x, n, v) (HW_CAN_WORD0n(x, n).U = (v))
#define HW_CAN_WORD0n_SET(x, n, v) (HW_CAN_WORD0n_WR(x, n, HW_CAN_WORD0n_RD(x, n) |  (v)))
#define HW_CAN_WORD0n_CLR(x, n, v) (HW_CAN_WORD0n_WR(x, n, HW_CAN_WORD0n_RD(x, n) & ~(v)))
#define HW_CAN_WORD0n_TOG(x, n, v) (HW_CAN_WORD0n_WR(x, n, HW_CAN_WORD0n_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_WORD0n bitfields
 */

/*!
 * @name Register CAN_WORD0n, field DATA_BYTE_3[7:0] (RW)
 */
/*@{*/
#define BP_CAN_WORD0n_DATA_BYTE_3 (0U)     /*!< Bit position for CAN_WORD0n_DATA_BYTE_3. */
#define BM_CAN_WORD0n_DATA_BYTE_3 (0x000000FFU) /*!< Bit mask for CAN_WORD0n_DATA_BYTE_3. */
#define BS_CAN_WORD0n_DATA_BYTE_3 (8U)     /*!< Bit field size in bits for CAN_WORD0n_DATA_BYTE_3. */

/*! @brief Read current value of the CAN_WORD0n_DATA_BYTE_3 field. */
#define BR_CAN_WORD0n_DATA_BYTE_3(x, n) (HW_CAN_WORD0n(x, n).B.DATA_BYTE_3)

/*! @brief Format value for bitfield CAN_WORD0n_DATA_BYTE_3. */
#define BF_CAN_WORD0n_DATA_BYTE_3(v) ((uint32_t)((uint32_t)(v) << BP_CAN_WORD0n_DATA_BYTE_3) & BM_CAN_WORD0n_DATA_BYTE_3)

/*! @brief Set the DATA_BYTE_3 field to a new value. */
#define BW_CAN_WORD0n_DATA_BYTE_3(x, n, v) (HW_CAN_WORD0n_WR(x, n, (HW_CAN_WORD0n_RD(x, n) & ~BM_CAN_WORD0n_DATA_BYTE_3) | BF_CAN_WORD0n_DATA_BYTE_3(v)))
/*@}*/

/*!
 * @name Register CAN_WORD0n, field DATA_BYTE_2[15:8] (RW)
 */
/*@{*/
#define BP_CAN_WORD0n_DATA_BYTE_2 (8U)     /*!< Bit position for CAN_WORD0n_DATA_BYTE_2. */
#define BM_CAN_WORD0n_DATA_BYTE_2 (0x0000FF00U) /*!< Bit mask for CAN_WORD0n_DATA_BYTE_2. */
#define BS_CAN_WORD0n_DATA_BYTE_2 (8U)     /*!< Bit field size in bits for CAN_WORD0n_DATA_BYTE_2. */

/*! @brief Read current value of the CAN_WORD0n_DATA_BYTE_2 field. */
#define BR_CAN_WORD0n_DATA_BYTE_2(x, n) (HW_CAN_WORD0n(x, n).B.DATA_BYTE_2)

/*! @brief Format value for bitfield CAN_WORD0n_DATA_BYTE_2. */
#define BF_CAN_WORD0n_DATA_BYTE_2(v) ((uint32_t)((uint32_t)(v) << BP_CAN_WORD0n_DATA_BYTE_2) & BM_CAN_WORD0n_DATA_BYTE_2)

/*! @brief Set the DATA_BYTE_2 field to a new value. */
#define BW_CAN_WORD0n_DATA_BYTE_2(x, n, v) (HW_CAN_WORD0n_WR(x, n, (HW_CAN_WORD0n_RD(x, n) & ~BM_CAN_WORD0n_DATA_BYTE_2) | BF_CAN_WORD0n_DATA_BYTE_2(v)))
/*@}*/

/*!
 * @name Register CAN_WORD0n, field DATA_BYTE_1[23:16] (RW)
 */
/*@{*/
#define BP_CAN_WORD0n_DATA_BYTE_1 (16U)    /*!< Bit position for CAN_WORD0n_DATA_BYTE_1. */
#define BM_CAN_WORD0n_DATA_BYTE_1 (0x00FF0000U) /*!< Bit mask for CAN_WORD0n_DATA_BYTE_1. */
#define BS_CAN_WORD0n_DATA_BYTE_1 (8U)     /*!< Bit field size in bits for CAN_WORD0n_DATA_BYTE_1. */

/*! @brief Read current value of the CAN_WORD0n_DATA_BYTE_1 field. */
#define BR_CAN_WORD0n_DATA_BYTE_1(x, n) (HW_CAN_WORD0n(x, n).B.DATA_BYTE_1)

/*! @brief Format value for bitfield CAN_WORD0n_DATA_BYTE_1. */
#define BF_CAN_WORD0n_DATA_BYTE_1(v) ((uint32_t)((uint32_t)(v) << BP_CAN_WORD0n_DATA_BYTE_1) & BM_CAN_WORD0n_DATA_BYTE_1)

/*! @brief Set the DATA_BYTE_1 field to a new value. */
#define BW_CAN_WORD0n_DATA_BYTE_1(x, n, v) (HW_CAN_WORD0n_WR(x, n, (HW_CAN_WORD0n_RD(x, n) & ~BM_CAN_WORD0n_DATA_BYTE_1) | BF_CAN_WORD0n_DATA_BYTE_1(v)))
/*@}*/

/*!
 * @name Register CAN_WORD0n, field DATA_BYTE_0[31:24] (RW)
 */
/*@{*/
#define BP_CAN_WORD0n_DATA_BYTE_0 (24U)    /*!< Bit position for CAN_WORD0n_DATA_BYTE_0. */
#define BM_CAN_WORD0n_DATA_BYTE_0 (0xFF000000U) /*!< Bit mask for CAN_WORD0n_DATA_BYTE_0. */
#define BS_CAN_WORD0n_DATA_BYTE_0 (8U)     /*!< Bit field size in bits for CAN_WORD0n_DATA_BYTE_0. */

/*! @brief Read current value of the CAN_WORD0n_DATA_BYTE_0 field. */
#define BR_CAN_WORD0n_DATA_BYTE_0(x, n) (HW_CAN_WORD0n(x, n).B.DATA_BYTE_0)

/*! @brief Format value for bitfield CAN_WORD0n_DATA_BYTE_0. */
#define BF_CAN_WORD0n_DATA_BYTE_0(v) ((uint32_t)((uint32_t)(v) << BP_CAN_WORD0n_DATA_BYTE_0) & BM_CAN_WORD0n_DATA_BYTE_0)

/*! @brief Set the DATA_BYTE_0 field to a new value. */
#define BW_CAN_WORD0n_DATA_BYTE_0(x, n, v) (HW_CAN_WORD0n_WR(x, n, (HW_CAN_WORD0n_RD(x, n) & ~BM_CAN_WORD0n_DATA_BYTE_0) | BF_CAN_WORD0n_DATA_BYTE_0(v)))
/*@}*/
/*******************************************************************************
 * HW_CAN_WORD1n - Message Buffer 0 WORD1 Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_WORD1n - Message Buffer 0 WORD1 Register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_can_word1n
{
    uint32_t U;
    struct _hw_can_word1n_bitfields
    {
        uint32_t DATA_BYTE_7 : 8;      /*!< [7:0] Data byte 7 of Rx/Tx frame. */
        uint32_t DATA_BYTE_6 : 8;      /*!< [15:8] Data byte 6 of Rx/Tx frame. */
        uint32_t DATA_BYTE_5 : 8;      /*!< [23:16] Data byte 5 of Rx/Tx frame. */
        uint32_t DATA_BYTE_4 : 8;      /*!< [31:24] Data byte 4 of Rx/Tx frame. */
    } B;
} hw_can_word1n_t;

/*!
 * @name Constants and macros for entire CAN_WORD1n register
 */
/*@{*/
#define HW_CAN_WORD1n_COUNT (64U)

#define HW_CAN_WORD1n_ADDR(x, n) ((uintptr_t)(x) + 0x8CU + (0x10U * (n)))

#define HW_CAN_WORD1n(x, n)      (*(__IO hw_can_word1n_t *) HW_CAN_WORD1n_ADDR(x, n))
#define HW_CAN_WORD1n_RD(x, n)   (HW_CAN_WORD1n(x, n).U)
#define HW_CAN_WORD1n_WR(x, n, v) (HW_CAN_WORD1n(x, n).U = (v))
#define HW_CAN_WORD1n_SET(x, n, v) (HW_CAN_WORD1n_WR(x, n, HW_CAN_WORD1n_RD(x, n) |  (v)))
#define HW_CAN_WORD1n_CLR(x, n, v) (HW_CAN_WORD1n_WR(x, n, HW_CAN_WORD1n_RD(x, n) & ~(v)))
#define HW_CAN_WORD1n_TOG(x, n, v) (HW_CAN_WORD1n_WR(x, n, HW_CAN_WORD1n_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_WORD1n bitfields
 */

/*!
 * @name Register CAN_WORD1n, field DATA_BYTE_7[7:0] (RW)
 */
/*@{*/
#define BP_CAN_WORD1n_DATA_BYTE_7 (0U)     /*!< Bit position for CAN_WORD1n_DATA_BYTE_7. */
#define BM_CAN_WORD1n_DATA_BYTE_7 (0x000000FFU) /*!< Bit mask for CAN_WORD1n_DATA_BYTE_7. */
#define BS_CAN_WORD1n_DATA_BYTE_7 (8U)     /*!< Bit field size in bits for CAN_WORD1n_DATA_BYTE_7. */

/*! @brief Read current value of the CAN_WORD1n_DATA_BYTE_7 field. */
#define BR_CAN_WORD1n_DATA_BYTE_7(x, n) (HW_CAN_WORD1n(x, n).B.DATA_BYTE_7)

/*! @brief Format value for bitfield CAN_WORD1n_DATA_BYTE_7. */
#define BF_CAN_WORD1n_DATA_BYTE_7(v) ((uint32_t)((uint32_t)(v) << BP_CAN_WORD1n_DATA_BYTE_7) & BM_CAN_WORD1n_DATA_BYTE_7)

/*! @brief Set the DATA_BYTE_7 field to a new value. */
#define BW_CAN_WORD1n_DATA_BYTE_7(x, n, v) (HW_CAN_WORD1n_WR(x, n, (HW_CAN_WORD1n_RD(x, n) & ~BM_CAN_WORD1n_DATA_BYTE_7) | BF_CAN_WORD1n_DATA_BYTE_7(v)))
/*@}*/

/*!
 * @name Register CAN_WORD1n, field DATA_BYTE_6[15:8] (RW)
 */
/*@{*/
#define BP_CAN_WORD1n_DATA_BYTE_6 (8U)     /*!< Bit position for CAN_WORD1n_DATA_BYTE_6. */
#define BM_CAN_WORD1n_DATA_BYTE_6 (0x0000FF00U) /*!< Bit mask for CAN_WORD1n_DATA_BYTE_6. */
#define BS_CAN_WORD1n_DATA_BYTE_6 (8U)     /*!< Bit field size in bits for CAN_WORD1n_DATA_BYTE_6. */

/*! @brief Read current value of the CAN_WORD1n_DATA_BYTE_6 field. */
#define BR_CAN_WORD1n_DATA_BYTE_6(x, n) (HW_CAN_WORD1n(x, n).B.DATA_BYTE_6)

/*! @brief Format value for bitfield CAN_WORD1n_DATA_BYTE_6. */
#define BF_CAN_WORD1n_DATA_BYTE_6(v) ((uint32_t)((uint32_t)(v) << BP_CAN_WORD1n_DATA_BYTE_6) & BM_CAN_WORD1n_DATA_BYTE_6)

/*! @brief Set the DATA_BYTE_6 field to a new value. */
#define BW_CAN_WORD1n_DATA_BYTE_6(x, n, v) (HW_CAN_WORD1n_WR(x, n, (HW_CAN_WORD1n_RD(x, n) & ~BM_CAN_WORD1n_DATA_BYTE_6) | BF_CAN_WORD1n_DATA_BYTE_6(v)))
/*@}*/

/*!
 * @name Register CAN_WORD1n, field DATA_BYTE_5[23:16] (RW)
 */
/*@{*/
#define BP_CAN_WORD1n_DATA_BYTE_5 (16U)    /*!< Bit position for CAN_WORD1n_DATA_BYTE_5. */
#define BM_CAN_WORD1n_DATA_BYTE_5 (0x00FF0000U) /*!< Bit mask for CAN_WORD1n_DATA_BYTE_5. */
#define BS_CAN_WORD1n_DATA_BYTE_5 (8U)     /*!< Bit field size in bits for CAN_WORD1n_DATA_BYTE_5. */

/*! @brief Read current value of the CAN_WORD1n_DATA_BYTE_5 field. */
#define BR_CAN_WORD1n_DATA_BYTE_5(x, n) (HW_CAN_WORD1n(x, n).B.DATA_BYTE_5)

/*! @brief Format value for bitfield CAN_WORD1n_DATA_BYTE_5. */
#define BF_CAN_WORD1n_DATA_BYTE_5(v) ((uint32_t)((uint32_t)(v) << BP_CAN_WORD1n_DATA_BYTE_5) & BM_CAN_WORD1n_DATA_BYTE_5)

/*! @brief Set the DATA_BYTE_5 field to a new value. */
#define BW_CAN_WORD1n_DATA_BYTE_5(x, n, v) (HW_CAN_WORD1n_WR(x, n, (HW_CAN_WORD1n_RD(x, n) & ~BM_CAN_WORD1n_DATA_BYTE_5) | BF_CAN_WORD1n_DATA_BYTE_5(v)))
/*@}*/

/*!
 * @name Register CAN_WORD1n, field DATA_BYTE_4[31:24] (RW)
 */
/*@{*/
#define BP_CAN_WORD1n_DATA_BYTE_4 (24U)    /*!< Bit position for CAN_WORD1n_DATA_BYTE_4. */
#define BM_CAN_WORD1n_DATA_BYTE_4 (0xFF000000U) /*!< Bit mask for CAN_WORD1n_DATA_BYTE_4. */
#define BS_CAN_WORD1n_DATA_BYTE_4 (8U)     /*!< Bit field size in bits for CAN_WORD1n_DATA_BYTE_4. */

/*! @brief Read current value of the CAN_WORD1n_DATA_BYTE_4 field. */
#define BR_CAN_WORD1n_DATA_BYTE_4(x, n) (HW_CAN_WORD1n(x, n).B.DATA_BYTE_4)

/*! @brief Format value for bitfield CAN_WORD1n_DATA_BYTE_4. */
#define BF_CAN_WORD1n_DATA_BYTE_4(v) ((uint32_t)((uint32_t)(v) << BP_CAN_WORD1n_DATA_BYTE_4) & BM_CAN_WORD1n_DATA_BYTE_4)

/*! @brief Set the DATA_BYTE_4 field to a new value. */
#define BW_CAN_WORD1n_DATA_BYTE_4(x, n, v) (HW_CAN_WORD1n_WR(x, n, (HW_CAN_WORD1n_RD(x, n) & ~BM_CAN_WORD1n_DATA_BYTE_4) | BF_CAN_WORD1n_DATA_BYTE_4(v)))
/*@}*/

/*******************************************************************************
 * HW_CAN_RXIMRn - RXIMR
 ******************************************************************************/

/*!
 * @brief HW_CAN_RXIMRn - RXIMR (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_can_rximrn
{
    uint32_t U;
    struct _hw_can_rximrn_bitfields
    {
        uint32_t MI : 32;              /*!< [31:0] MI */
    } B;
} hw_can_rximrn_t;

/*!
 * @name Constants and macros for entire CAN_RXIMRn register
 */
/*@{*/
#define HW_CAN_RXIMRn_COUNT (64U)

#define HW_CAN_RXIMRn_ADDR(x, n) ((uintptr_t)(x) + 0x880U + (0x4U * (n)))

#define HW_CAN_RXIMRn(x, n)      (*(__IO hw_can_rximrn_t *) HW_CAN_RXIMRn_ADDR(x, n))
#define HW_CAN_RXIMRn_RD(x, n)   (HW_CAN_RXIMRn(x, n).U)
#define HW_CAN_RXIMRn_WR(x, n, v) (HW_CAN_RXIMRn(x, n).U = (v))
#define HW_CAN_RXIMRn_SET(x, n, v) (HW_CAN_RXIMRn_WR(x, n, HW_CAN_RXIMRn_RD(x, n) |  (v)))
#define HW_CAN_RXIMRn_CLR(x, n, v) (HW_CAN_RXIMRn_WR(x, n, HW_CAN_RXIMRn_RD(x, n) & ~(v)))
#define HW_CAN_RXIMRn_TOG(x, n, v) (HW_CAN_RXIMRn_WR(x, n, HW_CAN_RXIMRn_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_RXIMRn bitfields
 */

/*!
 * @name Register CAN_RXIMRn, field MI[31:0] (RW)
 */
/*@{*/
#define BP_CAN_RXIMRn_MI     (0U)          /*!< Bit position for CAN_RXIMRn_MI. */
#define BM_CAN_RXIMRn_MI     (0xFFFFFFFFU) /*!< Bit mask for CAN_RXIMRn_MI. */
#define BS_CAN_RXIMRn_MI     (32U)         /*!< Bit field size in bits for CAN_RXIMRn_MI. */

/*! @brief Read current value of the CAN_RXIMRn_MI field. */
#define BR_CAN_RXIMRn_MI(x, n) (HW_CAN_RXIMRn(x, n).U)

/*! @brief Format value for bitfield CAN_RXIMRn_MI. */
#define BF_CAN_RXIMRn_MI(v)  ((uint32_t)((uint32_t)(v) << BP_CAN_RXIMRn_MI) & BM_CAN_RXIMRn_MI)

/*! @brief Set the MI field to a new value. */
#define BW_CAN_RXIMRn_MI(x, n, v) (HW_CAN_RXIMRn_WR(x, n, v))
/*@}*/

/*******************************************************************************
 * HW_CAN_GFWR - Glitch Filter Width Registers
 ******************************************************************************/

/*!
 * @brief HW_CAN_GFWR - Glitch Filter Width Registers (RW)
 *
 * Reset value: 0x0000007FU
 *
 * The Glitch Filter just takes effects when FLEXCAN enters the STOP mode.
 */
typedef union _hw_can_gfwr
{
    uint32_t U;
    struct _hw_can_gfwr_bitfields
    {
        uint32_t GFWR : 8;             /*!< [7:0]  */
        uint32_t RESERVED0 : 24;       /*!< [31:8]  */
    } B;
} hw_can_gfwr_t;

/*!
 * @name Constants and macros for entire CAN_GFWR register
 */
/*@{*/
#define HW_CAN_GFWR_ADDR(x)      ((uintptr_t)(x) + 0x9E0U)

#define HW_CAN_GFWR(x)           (*(__IO hw_can_gfwr_t *) HW_CAN_GFWR_ADDR(x))
#define HW_CAN_GFWR_RD(x)        (HW_CAN_GFWR(x).U)
#define HW_CAN_GFWR_WR(x, v)     (HW_CAN_GFWR(x).U = (v))
#define HW_CAN_GFWR_SET(x, v)    (HW_CAN_GFWR_WR(x, HW_CAN_GFWR_RD(x) |  (v)))
#define HW_CAN_GFWR_CLR(x, v)    (HW_CAN_GFWR_WR(x, HW_CAN_GFWR_RD(x) & ~(v)))
#define HW_CAN_GFWR_TOG(x, v)    (HW_CAN_GFWR_WR(x, HW_CAN_GFWR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_GFWR bitfields
 */

/*!
 * @name Register CAN_GFWR, field GFWR[7:0] (RW)
 *
 * It determines the Glitch Filter Width. The width will be divided from
 * Oscillator clock by GFWR values. By default, it is 5.33us when the oscillator is
 * 24MHz.
 */
/*@{*/
#define BP_CAN_GFWR_GFWR     (0U)          /*!< Bit position for CAN_GFWR_GFWR. */
#define BM_CAN_GFWR_GFWR     (0x000000FFU) /*!< Bit mask for CAN_GFWR_GFWR. */
#define BS_CAN_GFWR_GFWR     (8U)          /*!< Bit field size in bits for CAN_GFWR_GFWR. */

/*! @brief Read current value of the CAN_GFWR_GFWR field. */
#define BR_CAN_GFWR_GFWR(x)  (HW_CAN_GFWR(x).B.GFWR)

/*! @brief Format value for bitfield CAN_GFWR_GFWR. */
#define BF_CAN_GFWR_GFWR(v)  ((uint32_t)((uint32_t)(v) << BP_CAN_GFWR_GFWR) & BM_CAN_GFWR_GFWR)

/*! @brief Set the GFWR field to a new value. */
#define BW_CAN_GFWR_GFWR(x, v) (HW_CAN_GFWR_WR(x, (HW_CAN_GFWR_RD(x) & ~BM_CAN_GFWR_GFWR) | BF_CAN_GFWR_GFWR(v)))
/*@}*/

/*******************************************************************************
 * hw_can_t - module struct
 ******************************************************************************/
/*!
 * @brief All CAN module registers.
 */
#pragma pack(1)
typedef struct _hw_can
{
    __IO hw_can_mcr_t MCR;                 /*!< [0x0] Module Configuration Register */
    __IO hw_can_ctrl1_t CTRL1;             /*!< [0x4] Control 1 Register */
    __IO hw_can_timer_t TIMER;             /*!< [0x8] Free Running Timer Register */
    uint8_t _reserved0[4];
    __IO hw_can_rxmgmask_t RXMGMASK;       /*!< [0x10] Rx Mailboxes Global Mask Register */
    __IO hw_can_rx14mask_t RX14MASK;       /*!< [0x14] Rx Buffer 14 Mask Register */
    __IO hw_can_rx15mask_t RX15MASK;       /*!< [0x18] Rx Buffer 15 Mask Register */
    __IO hw_can_ecr_t ECR;                 /*!< [0x1C] Error Counter Register */
    __IO hw_can_esr1_t ESR1;               /*!< [0x20] Error and Status 1 Register */
    __IO hw_can_imask2_t IMASK2;           /*!< [0x24] Interrupt Masks 2 Register */
    __IO hw_can_imask1_t IMASK1;           /*!< [0x28] Interrupt Masks 1 Register */
    __IO hw_can_iflag2_t IFLAG2;           /*!< [0x2C] Interrupt Flags 2 Register */
    __IO hw_can_iflag1_t IFLAG1;           /*!< [0x30] Interrupt Flags 1 Register */
    __IO hw_can_ctrl2_t CTRL2;             /*!< [0x34] Control 2 Register */
    __I hw_can_esr2_t ESR2;                /*!< [0x38] Error and Status 2 Register */
    uint8_t _reserved1[8];
    __I hw_can_crcr_t CRCR;                /*!< [0x44] CRC Register */
    __IO hw_can_rxfgmask_t RXFGMASK;       /*!< [0x48] Rx FIFO Global Mask Register */
    __I hw_can_rxfir_t RXFIR;              /*!< [0x4C] Rx FIFO Information Register */
    uint8_t _reserved2[48];
    struct {
        __IO hw_can_csn_t CSn;             /*!< [0x80] Message Buffer 0 CS Register */
        __IO hw_can_idn_t IDn;             /*!< [0x84] Message Buffer 0 ID Register */
        __IO hw_can_word0n_t WORD0n;       /*!< [0x88] Message Buffer 0 WORD0 Register */
        __IO hw_can_word1n_t WORD1n;       /*!< [0x8C] Message Buffer 0 WORD1 Register */
    } MB[64];
    uint8_t _reserved3[1024];
    __IO hw_can_rximrn_t RXIMRn[64];       /*!< [0x880] RXIMR */
    uint8_t _reserved4[96];
    __IO hw_can_gfwr_t GFWR;               /*!< [0x9E0] Glitch Filter Width Registers */
} hw_can_t;
#pragma pack()

/*! @brief Macro to access all CAN registers. */
/*! @param x CAN module instance base address. */
/*! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
 *     use the '&' operator, like <code>&HW_CAN_REGS(CAN1_BASE)</code>. */
#define HW_CAN_REGS(x) (*(hw_can_t *)(x))

/*
 * iMX6SX CCM
 *
 * CCM
 *
 * Registers defined in this header file:
 * - HW_CCM_CCR - CCM Control Register
 * - HW_CCM_CCDR - CCM Control Divider Register
 * - HW_CCM_CSR - CCM Status Register
 * - HW_CCM_CCSR - CCM Clock Switcher Register
 * - HW_CCM_CACRR - CCM Arm Clock Root Register
 * - HW_CCM_CBCDR - CCM Bus Clock Divider Register
 * - HW_CCM_CBCMR - CCM Bus Clock Multiplexer Register
 * - HW_CCM_CSCMR1 - CCM Serial Clock Multiplexer Register 1
 * - HW_CCM_CSCMR2 - CCM Serial Clock Multiplexer Register 2
 * - HW_CCM_CSCDR1 - CCM Serial Clock Divider Register 1
 * - HW_CCM_CS1CDR - CCM SSI1 Clock Divider Register
 * - HW_CCM_CS2CDR - CCM SSI2 Clock Divider Register
 * - HW_CCM_CDCDR - CCM D1 Clock Divider Register
 * - HW_CCM_CHSCCDR - CCM HSC Clock Divider Register
 * - HW_CCM_CSCDR2 - CCM Serial Clock Divider Register 2
 * - HW_CCM_CSCDR3 - CCM Serial Clock Divider Register 3
 * - HW_CCM_CWDR - CCM Wakeup Detector Register
 * - HW_CCM_CDHIPR - CCM Divider Handshake In-Process Register
 * - HW_CCM_CLPCR - CCM Low Power Control Register
 * - HW_CCM_CISR - CCM Interrupt Status Register
 * - HW_CCM_CIMR - CCM Interrupt Mask Register
 * - HW_CCM_CCOSR - CCM Clock Output Source Register
 * - HW_CCM_CGPR - CCM General Purpose Register
 * - HW_CCM_CCGR0 - CCM Clock Gating Register 0
 * - HW_CCM_CCGR1 - CCM Clock Gating Register 1
 * - HW_CCM_CCGR2 - CCM Clock Gating Register 2
 * - HW_CCM_CCGR3 - CCM Clock Gating Register 3
 * - HW_CCM_CCGR4 - CCM Clock Gating Register 4
 * - HW_CCM_CCGR5 - CCM Clock Gating Register 5
 * - HW_CCM_CCGR6 - CCM Clock Gating Register 6
 * - HW_CCM_CMEOR - CCM Module Enable Overide Register
 *
 * - hw_ccm_t - Struct containing all module registers.
 */

#define HW_CCM_INSTANCE_COUNT (1U) /*!< Number of instances of the CCM module. */
#define HW_CCM (0U) /*!< Instance number for CCM. */
#define CCM_BASE              (0x20C4000U) /*!< Base address for CCM. */
/*! Array initializer of CCM base addresses. */
#define CCM_BASE_ADDRS        { CCM_BASE }

/*******************************************************************************
 * HW_CCM_CCR - CCM Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CCR - CCM Control Register (RW)
 *
 * Reset value: 0x0401167FU
 *
 * The figure below represents the CCM Control Register (CCR), which contains
 * bits to control general operation of CCM. The table below provides its field
 * descriptions.
 */
typedef union _hw_ccm_ccr
{
    uint32_t U;
    struct _hw_ccm_ccr_bitfields
    {
        uint32_t OSCNT : 7;            /*!< [6:0]  */
        uint32_t RESERVED0 : 5;        /*!< [11:7]  */
        uint32_t COSC_EN : 1;          /*!< [12]  */
        uint32_t RESERVED1 : 8;        /*!< [20:13]  */
        uint32_t REG_BYPASS_COUNT : 6; /*!< [26:21]  */
        uint32_t RBC_EN : 1;           /*!< [27]  */
        uint32_t RESERVED2 : 4;        /*!< [31:28]  */
    } B;
} hw_ccm_ccr_t;

/*!
 * @name Constants and macros for entire CCM_CCR register
 */
/*@{*/
#define HW_CCM_CCR_ADDR(x)       ((uintptr_t)(x) + 0x0U)

#define HW_CCM_CCR(x)            (*(__IO hw_ccm_ccr_t *) HW_CCM_CCR_ADDR(x))
#define HW_CCM_CCR_RD(x)         (HW_CCM_CCR(x).U)
#define HW_CCM_CCR_WR(x, v)      (HW_CCM_CCR(x).U = (v))
#define HW_CCM_CCR_SET(x, v)     (HW_CCM_CCR_WR(x, HW_CCM_CCR_RD(x) |  (v)))
#define HW_CCM_CCR_CLR(x, v)     (HW_CCM_CCR_WR(x, HW_CCM_CCR_RD(x) & ~(v)))
#define HW_CCM_CCR_TOG(x, v)     (HW_CCM_CCR_WR(x, HW_CCM_CCR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CCR bitfields
 */

/*!
 * @name Register CCM_CCR, field OSCNT[6:0] (RW)
 *
 * Oscillator ready counter value. These bits define value of 32KHz counter,
 * that serve as counter for oscillator lock time. This is used for oscillator lock
 * time. Current estimation is ~5ms. This counter will be used in ignition
 * sequence and in wake from stop sequence if sbyos bit was defined, to notify that on
 * chip oscillator output is ready for the dpll_ip to use and only then the gate
 * in dpll_ip can be opened.
 *
 * Values:
 * - 0000000 - count 1 ckil
 * - 1111111 - count 128 ckil's
 */
/*@{*/
#define BP_CCM_CCR_OSCNT     (0U)          /*!< Bit position for CCM_CCR_OSCNT. */
#define BM_CCM_CCR_OSCNT     (0x0000007FU) /*!< Bit mask for CCM_CCR_OSCNT. */
#define BS_CCM_CCR_OSCNT     (7U)          /*!< Bit field size in bits for CCM_CCR_OSCNT. */

/*! @brief Read current value of the CCM_CCR_OSCNT field. */
#define BR_CCM_CCR_OSCNT(x)  (HW_CCM_CCR(x).B.OSCNT)

/*! @brief Format value for bitfield CCM_CCR_OSCNT. */
#define BF_CCM_CCR_OSCNT(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCR_OSCNT) & BM_CCM_CCR_OSCNT)

/*! @brief Set the OSCNT field to a new value. */
#define BW_CCM_CCR_OSCNT(x, v) (HW_CCM_CCR_WR(x, (HW_CCM_CCR_RD(x) & ~BM_CCM_CCR_OSCNT) | BF_CCM_CCR_OSCNT(v)))
/*@}*/

/*!
 * @name Register CCM_CCR, field COSC_EN[12] (RW)
 *
 * On chip oscillator enable bit - this bit value is reflected on the output
 * cosc_en. The system will start with on chip oscillator enabled to supply source
 * for the PLLs. Software can change this bit if a transition to the bypass PLL
 * clocks was performed for all the PLLs. In cases that this bit is changed from
 * '0' to '1' then CCM will enable the on chip oscillator and after counting oscnt
 * ckil clock cycles it will notify that on chip oscillator is ready by a
 * interrupt cosc_ready and by status bit cosc_ready. The cosc_en bit should be changed
 * only when on chip oscillator is not chosen as the clock source.
 *
 * Values:
 * - 0 - disable on chip oscillator
 * - 1 - enable on chip oscillator
 */
/*@{*/
#define BP_CCM_CCR_COSC_EN   (12U)         /*!< Bit position for CCM_CCR_COSC_EN. */
#define BM_CCM_CCR_COSC_EN   (0x00001000U) /*!< Bit mask for CCM_CCR_COSC_EN. */
#define BS_CCM_CCR_COSC_EN   (1U)          /*!< Bit field size in bits for CCM_CCR_COSC_EN. */

/*! @brief Read current value of the CCM_CCR_COSC_EN field. */
#define BR_CCM_CCR_COSC_EN(x) (HW_CCM_CCR(x).B.COSC_EN)

/*! @brief Format value for bitfield CCM_CCR_COSC_EN. */
#define BF_CCM_CCR_COSC_EN(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCR_COSC_EN) & BM_CCM_CCR_COSC_EN)

/*! @brief Set the COSC_EN field to a new value. */
#define BW_CCM_CCR_COSC_EN(x, v) (HW_CCM_CCR_WR(x, (HW_CCM_CCR_RD(x) & ~BM_CCM_CCR_COSC_EN) | BF_CCM_CCR_COSC_EN(v)))
/*@}*/

/*!
 * @name Register CCM_CCR, field REG_BYPASS_COUNT[26:21] (RW)
 *
 * Counter for analog_reg_bypass signal assertion after standby voltage request
 * by PMIC_STBY_REQ. Should be zeroed and reconfigured after exit from low power
 * mode. REG_BYPASS_COUNT can also be used for holding off interrupts when the
 * PGC unit is sending signals to power gate the core.
 *
 * Values:
 * - 000000 - no delay
 * - 000001 - 1 CKIL clock period delay
 * - 111111 - 63 CKIL clock periods delay
 */
/*@{*/
#define BP_CCM_CCR_REG_BYPASS_COUNT (21U)  /*!< Bit position for CCM_CCR_REG_BYPASS_COUNT. */
#define BM_CCM_CCR_REG_BYPASS_COUNT (0x07E00000U) /*!< Bit mask for CCM_CCR_REG_BYPASS_COUNT. */
#define BS_CCM_CCR_REG_BYPASS_COUNT (6U)   /*!< Bit field size in bits for CCM_CCR_REG_BYPASS_COUNT. */

/*! @brief Read current value of the CCM_CCR_REG_BYPASS_COUNT field. */
#define BR_CCM_CCR_REG_BYPASS_COUNT(x) (HW_CCM_CCR(x).B.REG_BYPASS_COUNT)

/*! @brief Format value for bitfield CCM_CCR_REG_BYPASS_COUNT. */
#define BF_CCM_CCR_REG_BYPASS_COUNT(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCR_REG_BYPASS_COUNT) & BM_CCM_CCR_REG_BYPASS_COUNT)

/*! @brief Set the REG_BYPASS_COUNT field to a new value. */
#define BW_CCM_CCR_REG_BYPASS_COUNT(x, v) (HW_CCM_CCR_WR(x, (HW_CCM_CCR_RD(x) & ~BM_CCM_CCR_REG_BYPASS_COUNT) | BF_CCM_CCR_REG_BYPASS_COUNT(v)))
/*@}*/

/*!
 * @name Register CCM_CCR, field RBC_EN[27] (RW)
 *
 * Enable for REG_BYPASS_COUNTER. If enabled, analog_reg_bypass signal will be
 * asserted after REG_BYPASS_COUNT clocks of CKIL, after standby voltage is
 * requested. If standby voltage is not requested analog_reg_bypass won't be asserted,
 * event if counter is enabled.
 *
 * Values:
 * - 1 - REG_BYPASS_COUNTER enabled.
 * - 0 - REG_BYPASS_COUNTER disabled
 */
/*@{*/
#define BP_CCM_CCR_RBC_EN    (27U)         /*!< Bit position for CCM_CCR_RBC_EN. */
#define BM_CCM_CCR_RBC_EN    (0x08000000U) /*!< Bit mask for CCM_CCR_RBC_EN. */
#define BS_CCM_CCR_RBC_EN    (1U)          /*!< Bit field size in bits for CCM_CCR_RBC_EN. */

/*! @brief Read current value of the CCM_CCR_RBC_EN field. */
#define BR_CCM_CCR_RBC_EN(x) (HW_CCM_CCR(x).B.RBC_EN)

/*! @brief Format value for bitfield CCM_CCR_RBC_EN. */
#define BF_CCM_CCR_RBC_EN(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCR_RBC_EN) & BM_CCM_CCR_RBC_EN)

/*! @brief Set the RBC_EN field to a new value. */
#define BW_CCM_CCR_RBC_EN(x, v) (HW_CCM_CCR_WR(x, (HW_CCM_CCR_RD(x) & ~BM_CCM_CCR_RBC_EN) | BF_CCM_CCR_RBC_EN(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CCDR - CCM Control Divider Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CCDR - CCM Control Divider Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The figure below represents the CCM Control Divider Register (CCDR), which
 * contains bits that control the loading of the dividers that need handshake with
 * the modules they affect. The table below provides its field descriptions.
 */
typedef union _hw_ccm_ccdr
{
    uint32_t U;
    struct _hw_ccm_ccdr_bitfields
    {
        uint32_t RESERVED0 : 16;       /*!< [15:0]  */
        uint32_t mmdc_mask : 1;        /*!< [16]  */
        uint32_t RESERVED1 : 15;       /*!< [31:17]  */
    } B;
} hw_ccm_ccdr_t;

/*!
 * @name Constants and macros for entire CCM_CCDR register
 */
/*@{*/
#define HW_CCM_CCDR_ADDR(x)      ((uintptr_t)(x) + 0x4U)

#define HW_CCM_CCDR(x)           (*(__IO hw_ccm_ccdr_t *) HW_CCM_CCDR_ADDR(x))
#define HW_CCM_CCDR_RD(x)        (HW_CCM_CCDR(x).U)
#define HW_CCM_CCDR_WR(x, v)     (HW_CCM_CCDR(x).U = (v))
#define HW_CCM_CCDR_SET(x, v)    (HW_CCM_CCDR_WR(x, HW_CCM_CCDR_RD(x) |  (v)))
#define HW_CCM_CCDR_CLR(x, v)    (HW_CCM_CCDR_WR(x, HW_CCM_CCDR_RD(x) & ~(v)))
#define HW_CCM_CCDR_TOG(x, v)    (HW_CCM_CCDR_WR(x, HW_CCM_CCDR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CCDR bitfields
 */

/*!
 * @name Register CCM_CCDR, field mmdc_mask[16] (RW)
 *
 * During divider ratio mmdc_axi_podf change or sync mux periph2_clk_sel change
 * (but not jtag) or SRC request during warm reset, mask handshake with mmdc
 * module.
 *
 * Values:
 * - 0 - allow handshake with mmdc module
 * - 1 - mask handshake with mmdc. Request signal will not be generated.
 */
/*@{*/
#define BP_CCM_CCDR_mmdc_mask (16U)        /*!< Bit position for CCM_CCDR_mmdc_mask. */
#define BM_CCM_CCDR_mmdc_mask (0x00010000U) /*!< Bit mask for CCM_CCDR_mmdc_mask. */
#define BS_CCM_CCDR_mmdc_mask (1U)         /*!< Bit field size in bits for CCM_CCDR_mmdc_mask. */

/*! @brief Read current value of the CCM_CCDR_mmdc_mask field. */
#define BR_CCM_CCDR_mmdc_mask(x) (HW_CCM_CCDR(x).B.mmdc_mask)

/*! @brief Format value for bitfield CCM_CCDR_mmdc_mask. */
#define BF_CCM_CCDR_mmdc_mask(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCDR_mmdc_mask) & BM_CCM_CCDR_mmdc_mask)

/*! @brief Set the mmdc_mask field to a new value. */
#define BW_CCM_CCDR_mmdc_mask(x, v) (HW_CCM_CCDR_WR(x, (HW_CCM_CCDR_RD(x) & ~BM_CCM_CCDR_mmdc_mask) | BF_CCM_CCDR_mmdc_mask(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CSR - CCM Status Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CSR - CCM Status Register (RO)
 *
 * Reset value: 0x00000010U
 *
 * The figure below represents the CCM status Register (CSR). The status bits
 * are read-only bits. The table below provides its field descriptions.
 */
typedef union _hw_ccm_csr
{
    uint32_t U;
    struct _hw_ccm_csr_bitfields
    {
        uint32_t REF_EN_B : 1;         /*!< [0]  */
        uint32_t RESERVED0 : 4;        /*!< [4:1]  */
        uint32_t cosc_ready : 1;       /*!< [5]  */
        uint32_t RESERVED1 : 26;       /*!< [31:6]  */
    } B;
} hw_ccm_csr_t;

/*!
 * @name Constants and macros for entire CCM_CSR register
 */
/*@{*/
#define HW_CCM_CSR_ADDR(x)       ((uintptr_t)(x) + 0x8U)

#define HW_CCM_CSR(x)            (*(__I hw_ccm_csr_t *) HW_CCM_CSR_ADDR(x))
#define HW_CCM_CSR_RD(x)         (HW_CCM_CSR(x).U)
/*@}*/

/*
 * Constants & macros for individual CCM_CSR bitfields
 */

/*!
 * @name Register CCM_CSR, field REF_EN_B[0] (RO)
 *
 * Status of the value of CCM_REF_EN_B output of ccm
 *
 * Values:
 * - 0 - value of CCM_REF_EN_B is '0'
 * - 1 - value of CCM_REF_EN_B is '1'
 */
/*@{*/
#define BP_CCM_CSR_REF_EN_B  (0U)          /*!< Bit position for CCM_CSR_REF_EN_B. */
#define BM_CCM_CSR_REF_EN_B  (0x00000001U) /*!< Bit mask for CCM_CSR_REF_EN_B. */
#define BS_CCM_CSR_REF_EN_B  (1U)          /*!< Bit field size in bits for CCM_CSR_REF_EN_B. */

/*! @brief Read current value of the CCM_CSR_REF_EN_B field. */
#define BR_CCM_CSR_REF_EN_B(x) (HW_CCM_CSR(x).B.REF_EN_B)
/*@}*/

/*!
 * @name Register CCM_CSR, field cosc_ready[5] (RO)
 *
 * Status indication of on board oscillator. This bit will be asserted if on
 * chip oscillator is enabled and on chip oscillator is not powered down, and if
 * oscnt counter has finished counting.
 *
 * Values:
 * - 0 - on board oscillator is not ready.
 * - 1 - on board oscillator is ready.
 */
/*@{*/
#define BP_CCM_CSR_cosc_ready (5U)         /*!< Bit position for CCM_CSR_cosc_ready. */
#define BM_CCM_CSR_cosc_ready (0x00000020U) /*!< Bit mask for CCM_CSR_cosc_ready. */
#define BS_CCM_CSR_cosc_ready (1U)         /*!< Bit field size in bits for CCM_CSR_cosc_ready. */

/*! @brief Read current value of the CCM_CSR_cosc_ready field. */
#define BR_CCM_CSR_cosc_ready(x) (HW_CCM_CSR(x).B.cosc_ready)
/*@}*/

/*******************************************************************************
 * HW_CCM_CCSR - CCM Clock Switcher Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CCSR - CCM Clock Switcher Register (RW)
 *
 * Reset value: 0x00000100U
 *
 * The figure below represents the CCM Clock Switcher register (CCSR). The CCSR
 * register contains bits to control the switcher sub-module dividers and
 * multiplexers. The table below provides its field descriptions.
 */
typedef union _hw_ccm_ccsr
{
    uint32_t U;
    struct _hw_ccm_ccsr_bitfields
    {
        uint32_t pll3_sw_clk_sel : 1;  /*!< [0]  */
        uint32_t RESERVED0 : 1;        /*!< [1]  */
        uint32_t pll1_sw_clk_sel : 1;  /*!< [2]  */
        uint32_t RESERVED1 : 5;        /*!< [7:3]  */
        uint32_t step_sel : 1;         /*!< [8]  */
        uint32_t RESERVED2 : 23;       /*!< [31:9]  */
    } B;
} hw_ccm_ccsr_t;

/*!
 * @name Constants and macros for entire CCM_CCSR register
 */
/*@{*/
#define HW_CCM_CCSR_ADDR(x)      ((uintptr_t)(x) + 0xCU)

#define HW_CCM_CCSR(x)           (*(__IO hw_ccm_ccsr_t *) HW_CCM_CCSR_ADDR(x))
#define HW_CCM_CCSR_RD(x)        (HW_CCM_CCSR(x).U)
#define HW_CCM_CCSR_WR(x, v)     (HW_CCM_CCSR(x).U = (v))
#define HW_CCM_CCSR_SET(x, v)    (HW_CCM_CCSR_WR(x, HW_CCM_CCSR_RD(x) |  (v)))
#define HW_CCM_CCSR_CLR(x, v)    (HW_CCM_CCSR_WR(x, HW_CCM_CCSR_RD(x) & ~(v)))
#define HW_CCM_CCSR_TOG(x, v)    (HW_CCM_CCSR_WR(x, HW_CCM_CCSR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CCSR bitfields
 */

/*!
 * @name Register CCM_CCSR, field pll3_sw_clk_sel[0] (RW)
 *
 * Selects source to generate pll3_sw_clk. This bit should only be used for
 * testing purposes.
 *
 * Values:
 * - 0 - pll3_main_clk
 * - 1 - pll3 bypass clock
 */
/*@{*/
#define BP_CCM_CCSR_pll3_sw_clk_sel (0U)   /*!< Bit position for CCM_CCSR_pll3_sw_clk_sel. */
#define BM_CCM_CCSR_pll3_sw_clk_sel (0x00000001U) /*!< Bit mask for CCM_CCSR_pll3_sw_clk_sel. */
#define BS_CCM_CCSR_pll3_sw_clk_sel (1U)   /*!< Bit field size in bits for CCM_CCSR_pll3_sw_clk_sel. */

/*! @brief Read current value of the CCM_CCSR_pll3_sw_clk_sel field. */
#define BR_CCM_CCSR_pll3_sw_clk_sel(x) (HW_CCM_CCSR(x).B.pll3_sw_clk_sel)

/*! @brief Format value for bitfield CCM_CCSR_pll3_sw_clk_sel. */
#define BF_CCM_CCSR_pll3_sw_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCSR_pll3_sw_clk_sel) & BM_CCM_CCSR_pll3_sw_clk_sel)

/*! @brief Set the pll3_sw_clk_sel field to a new value. */
#define BW_CCM_CCSR_pll3_sw_clk_sel(x, v) (HW_CCM_CCSR_WR(x, (HW_CCM_CCSR_RD(x) & ~BM_CCM_CCSR_pll3_sw_clk_sel) | BF_CCM_CCSR_pll3_sw_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CCSR, field pll1_sw_clk_sel[2] (RW)
 *
 * Selects source to generate pll1_sw_clk.
 *
 * Values:
 * - 0 - pll1_main_clk
 * - 1 - step_clk
 */
/*@{*/
#define BP_CCM_CCSR_pll1_sw_clk_sel (2U)   /*!< Bit position for CCM_CCSR_pll1_sw_clk_sel. */
#define BM_CCM_CCSR_pll1_sw_clk_sel (0x00000004U) /*!< Bit mask for CCM_CCSR_pll1_sw_clk_sel. */
#define BS_CCM_CCSR_pll1_sw_clk_sel (1U)   /*!< Bit field size in bits for CCM_CCSR_pll1_sw_clk_sel. */

/*! @brief Read current value of the CCM_CCSR_pll1_sw_clk_sel field. */
#define BR_CCM_CCSR_pll1_sw_clk_sel(x) (HW_CCM_CCSR(x).B.pll1_sw_clk_sel)

/*! @brief Format value for bitfield CCM_CCSR_pll1_sw_clk_sel. */
#define BF_CCM_CCSR_pll1_sw_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCSR_pll1_sw_clk_sel) & BM_CCM_CCSR_pll1_sw_clk_sel)

/*! @brief Set the pll1_sw_clk_sel field to a new value. */
#define BW_CCM_CCSR_pll1_sw_clk_sel(x, v) (HW_CCM_CCSR_WR(x, (HW_CCM_CCSR_RD(x) & ~BM_CCM_CCSR_pll1_sw_clk_sel) | BF_CCM_CCSR_pll1_sw_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CCSR, field step_sel[8] (RW)
 *
 * Selects the option to be chosen for the step frequency when shifting ARM
 * frequency. This will control the step_clk. This mux is allowed to be changed only
 * if its output is not used, i.e. ARM uses the output of pll1, and step_clk is
 * not used.
 *
 * Values:
 * - 0 - derive clock from osc_clk (24M) - source for lp_apm.
 * - 1 - derive clock from PLL2 PFD2
 */
/*@{*/
#define BP_CCM_CCSR_step_sel (8U)          /*!< Bit position for CCM_CCSR_step_sel. */
#define BM_CCM_CCSR_step_sel (0x00000100U) /*!< Bit mask for CCM_CCSR_step_sel. */
#define BS_CCM_CCSR_step_sel (1U)          /*!< Bit field size in bits for CCM_CCSR_step_sel. */

/*! @brief Read current value of the CCM_CCSR_step_sel field. */
#define BR_CCM_CCSR_step_sel(x) (HW_CCM_CCSR(x).B.step_sel)

/*! @brief Format value for bitfield CCM_CCSR_step_sel. */
#define BF_CCM_CCSR_step_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCSR_step_sel) & BM_CCM_CCSR_step_sel)

/*! @brief Set the step_sel field to a new value. */
#define BW_CCM_CCSR_step_sel(x, v) (HW_CCM_CCSR_WR(x, (HW_CCM_CCSR_RD(x) & ~BM_CCM_CCSR_step_sel) | BF_CCM_CCSR_step_sel(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CACRR - CCM Arm Clock Root Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CACRR - CCM Arm Clock Root Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The figure below represents the CCM Arm Clock Root register (CACRR). The
 * CACRR register contains bits to control the ARM clock root generation. The table
 * below provides its field descriptions.
 */
typedef union _hw_ccm_cacrr
{
    uint32_t U;
    struct _hw_ccm_cacrr_bitfields
    {
        uint32_t arm_podf : 3;         /*!< [2:0]  */
        uint32_t RESERVED0 : 29;       /*!< [31:3]  */
    } B;
} hw_ccm_cacrr_t;

/*!
 * @name Constants and macros for entire CCM_CACRR register
 */
/*@{*/
#define HW_CCM_CACRR_ADDR(x)     ((uintptr_t)(x) + 0x10U)

#define HW_CCM_CACRR(x)          (*(__IO hw_ccm_cacrr_t *) HW_CCM_CACRR_ADDR(x))
#define HW_CCM_CACRR_RD(x)       (HW_CCM_CACRR(x).U)
#define HW_CCM_CACRR_WR(x, v)    (HW_CCM_CACRR(x).U = (v))
#define HW_CCM_CACRR_SET(x, v)   (HW_CCM_CACRR_WR(x, HW_CCM_CACRR_RD(x) |  (v)))
#define HW_CCM_CACRR_CLR(x, v)   (HW_CCM_CACRR_WR(x, HW_CCM_CACRR_RD(x) & ~(v)))
#define HW_CCM_CACRR_TOG(x, v)   (HW_CCM_CACRR_WR(x, HW_CCM_CACRR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CACRR bitfields
 */

/*!
 * @name Register CCM_CACRR, field arm_podf[2:0] (RW)
 *
 * Divider for ARM clock root. If arm_freq_shift_divider is set to '1' then any
 * new write to arm_podf will be held until arm_clk_switch_req signal is asserted.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CACRR_arm_podf (0U)         /*!< Bit position for CCM_CACRR_arm_podf. */
#define BM_CCM_CACRR_arm_podf (0x00000007U) /*!< Bit mask for CCM_CACRR_arm_podf. */
#define BS_CCM_CACRR_arm_podf (3U)         /*!< Bit field size in bits for CCM_CACRR_arm_podf. */

/*! @brief Read current value of the CCM_CACRR_arm_podf field. */
#define BR_CCM_CACRR_arm_podf(x) (HW_CCM_CACRR(x).B.arm_podf)

/*! @brief Format value for bitfield CCM_CACRR_arm_podf. */
#define BF_CCM_CACRR_arm_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CACRR_arm_podf) & BM_CCM_CACRR_arm_podf)

/*! @brief Set the arm_podf field to a new value. */
#define BW_CCM_CACRR_arm_podf(x, v) (HW_CCM_CACRR_WR(x, (HW_CCM_CACRR_RD(x) & ~BM_CCM_CACRR_arm_podf) | BF_CCM_CACRR_arm_podf(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CBCDR - CCM Bus Clock Divider Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CBCDR - CCM Bus Clock Divider Register (RW)
 *
 * Reset value: 0x00018D00U
 *
 * The figure below represents the CCM Bus Clock Divider Register (CBCDR). The
 * CBCDR register contains bits to control the clock generation sub module
 * dividers. The table below provides its field descriptions.
 */
typedef union _hw_ccm_cbcdr
{
    uint32_t U;
    struct _hw_ccm_cbcdr_bitfields
    {
        uint32_t periph2_clk2_podf : 3; /*!< [2:0]  */
        uint32_t fabric_mmdc_podf : 3; /*!< [5:3]  */
        uint32_t ocram_clk_sel : 1;    /*!< [6]  */
        uint32_t ocram_alt_clk_sel : 1; /*!< [7]  */
        uint32_t ipg_podf : 2;         /*!< [9:8]  */
        uint32_t ahb_podf : 3;         /*!< [12:10]  */
        uint32_t RESERVED0 : 3;        /*!< [15:13]  */
        uint32_t ocram_podf : 3;       /*!< [18:16]  */
        uint32_t RESERVED1 : 6;        /*!< [24:19]  */
        uint32_t periph_clk_sel : 1;   /*!< [25]  */
        uint32_t periph2_clk_sel : 1;  /*!< [26]  */
        uint32_t periph_clk2_podf : 3; /*!< [29:27]  */
        uint32_t RESERVED2 : 2;        /*!< [31:30]  */
    } B;
} hw_ccm_cbcdr_t;

/*!
 * @name Constants and macros for entire CCM_CBCDR register
 */
/*@{*/
#define HW_CCM_CBCDR_ADDR(x)     ((uintptr_t)(x) + 0x14U)

#define HW_CCM_CBCDR(x)          (*(__IO hw_ccm_cbcdr_t *) HW_CCM_CBCDR_ADDR(x))
#define HW_CCM_CBCDR_RD(x)       (HW_CCM_CBCDR(x).U)
#define HW_CCM_CBCDR_WR(x, v)    (HW_CCM_CBCDR(x).U = (v))
#define HW_CCM_CBCDR_SET(x, v)   (HW_CCM_CBCDR_WR(x, HW_CCM_CBCDR_RD(x) |  (v)))
#define HW_CCM_CBCDR_CLR(x, v)   (HW_CCM_CBCDR_WR(x, HW_CCM_CBCDR_RD(x) & ~(v)))
#define HW_CCM_CBCDR_TOG(x, v)   (HW_CCM_CBCDR_WR(x, HW_CCM_CBCDR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CBCDR bitfields
 */

/*!
 * @name Register CCM_CBCDR, field periph2_clk2_podf[2:0] (RW)
 *
 * Divider for periph2_clk2 podf. Divider should be updated when output clock is
 * gated.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CBCDR_periph2_clk2_podf (0U) /*!< Bit position for CCM_CBCDR_periph2_clk2_podf. */
#define BM_CCM_CBCDR_periph2_clk2_podf (0x00000007U) /*!< Bit mask for CCM_CBCDR_periph2_clk2_podf. */
#define BS_CCM_CBCDR_periph2_clk2_podf (3U) /*!< Bit field size in bits for CCM_CBCDR_periph2_clk2_podf. */

/*! @brief Read current value of the CCM_CBCDR_periph2_clk2_podf field. */
#define BR_CCM_CBCDR_periph2_clk2_podf(x) (HW_CCM_CBCDR(x).B.periph2_clk2_podf)

/*! @brief Format value for bitfield CCM_CBCDR_periph2_clk2_podf. */
#define BF_CCM_CBCDR_periph2_clk2_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCDR_periph2_clk2_podf) & BM_CCM_CBCDR_periph2_clk2_podf)

/*! @brief Set the periph2_clk2_podf field to a new value. */
#define BW_CCM_CBCDR_periph2_clk2_podf(x, v) (HW_CCM_CBCDR_WR(x, (HW_CCM_CBCDR_RD(x) & ~BM_CCM_CBCDR_periph2_clk2_podf) | BF_CCM_CBCDR_periph2_clk2_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CBCDR, field fabric_mmdc_podf[5:3] (RW)
 *
 * Post divider for fabric / mmdc clock.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CBCDR_fabric_mmdc_podf (3U) /*!< Bit position for CCM_CBCDR_fabric_mmdc_podf. */
#define BM_CCM_CBCDR_fabric_mmdc_podf (0x00000038U) /*!< Bit mask for CCM_CBCDR_fabric_mmdc_podf. */
#define BS_CCM_CBCDR_fabric_mmdc_podf (3U) /*!< Bit field size in bits for CCM_CBCDR_fabric_mmdc_podf. */

/*! @brief Read current value of the CCM_CBCDR_fabric_mmdc_podf field. */
#define BR_CCM_CBCDR_fabric_mmdc_podf(x) (HW_CCM_CBCDR(x).B.fabric_mmdc_podf)

/*! @brief Format value for bitfield CCM_CBCDR_fabric_mmdc_podf. */
#define BF_CCM_CBCDR_fabric_mmdc_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCDR_fabric_mmdc_podf) & BM_CCM_CBCDR_fabric_mmdc_podf)

/*! @brief Set the fabric_mmdc_podf field to a new value. */
#define BW_CCM_CBCDR_fabric_mmdc_podf(x, v) (HW_CCM_CBCDR_WR(x, (HW_CCM_CBCDR_RD(x) & ~BM_CCM_CBCDR_fabric_mmdc_podf) | BF_CCM_CBCDR_fabric_mmdc_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CBCDR, field ocram_clk_sel[6] (RW)
 *
 * OCRAM clock source select
 *
 * Values:
 * - 0 - Periph_clk output will be used as OCRAM clock root
 * - 1 - AXI alternative clock will be used as OCRAM clock root
 */
/*@{*/
#define BP_CCM_CBCDR_ocram_clk_sel (6U)    /*!< Bit position for CCM_CBCDR_ocram_clk_sel. */
#define BM_CCM_CBCDR_ocram_clk_sel (0x00000040U) /*!< Bit mask for CCM_CBCDR_ocram_clk_sel. */
#define BS_CCM_CBCDR_ocram_clk_sel (1U)    /*!< Bit field size in bits for CCM_CBCDR_ocram_clk_sel. */

/*! @brief Read current value of the CCM_CBCDR_ocram_clk_sel field. */
#define BR_CCM_CBCDR_ocram_clk_sel(x) (HW_CCM_CBCDR(x).B.ocram_clk_sel)

/*! @brief Format value for bitfield CCM_CBCDR_ocram_clk_sel. */
#define BF_CCM_CBCDR_ocram_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCDR_ocram_clk_sel) & BM_CCM_CBCDR_ocram_clk_sel)

/*! @brief Set the ocram_clk_sel field to a new value. */
#define BW_CCM_CBCDR_ocram_clk_sel(x, v) (HW_CCM_CBCDR_WR(x, (HW_CCM_CBCDR_RD(x) & ~BM_CCM_CBCDR_ocram_clk_sel) | BF_CCM_CBCDR_ocram_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CBCDR, field ocram_alt_clk_sel[7] (RW)
 *
 * OCRAM alternative clock select
 *
 * Values:
 * - 0 - PLL2 PFD2 will be selected as alternative clock for OCRAM root clock
 * - 1 - PLL3 PFD1 will be selected as alternative clock for OCRAM root clock
 */
/*@{*/
#define BP_CCM_CBCDR_ocram_alt_clk_sel (7U) /*!< Bit position for CCM_CBCDR_ocram_alt_clk_sel. */
#define BM_CCM_CBCDR_ocram_alt_clk_sel (0x00000080U) /*!< Bit mask for CCM_CBCDR_ocram_alt_clk_sel. */
#define BS_CCM_CBCDR_ocram_alt_clk_sel (1U) /*!< Bit field size in bits for CCM_CBCDR_ocram_alt_clk_sel. */

/*! @brief Read current value of the CCM_CBCDR_ocram_alt_clk_sel field. */
#define BR_CCM_CBCDR_ocram_alt_clk_sel(x) (HW_CCM_CBCDR(x).B.ocram_alt_clk_sel)

/*! @brief Format value for bitfield CCM_CBCDR_ocram_alt_clk_sel. */
#define BF_CCM_CBCDR_ocram_alt_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCDR_ocram_alt_clk_sel) & BM_CCM_CBCDR_ocram_alt_clk_sel)

/*! @brief Set the ocram_alt_clk_sel field to a new value. */
#define BW_CCM_CBCDR_ocram_alt_clk_sel(x, v) (HW_CCM_CBCDR_WR(x, (HW_CCM_CBCDR_RD(x) & ~BM_CCM_CBCDR_ocram_alt_clk_sel) | BF_CCM_CBCDR_ocram_alt_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CBCDR, field ipg_podf[9:8] (RW)
 *
 * Divider for ipg podf. SDMA module will not support ratio of 1:3 and 1:4 for
 * ahb_clk:ipg_clk. In case SDMA is used, then those ratios should not be used.
 *
 * Values:
 * - 00 - divide by 1
 * - 01 - divide by 2
 * - 10 - divide by 3
 * - 11 - divide by 4
 */
/*@{*/
#define BP_CCM_CBCDR_ipg_podf (8U)         /*!< Bit position for CCM_CBCDR_ipg_podf. */
#define BM_CCM_CBCDR_ipg_podf (0x00000300U) /*!< Bit mask for CCM_CBCDR_ipg_podf. */
#define BS_CCM_CBCDR_ipg_podf (2U)         /*!< Bit field size in bits for CCM_CBCDR_ipg_podf. */

/*! @brief Read current value of the CCM_CBCDR_ipg_podf field. */
#define BR_CCM_CBCDR_ipg_podf(x) (HW_CCM_CBCDR(x).B.ipg_podf)

/*! @brief Format value for bitfield CCM_CBCDR_ipg_podf. */
#define BF_CCM_CBCDR_ipg_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCDR_ipg_podf) & BM_CCM_CBCDR_ipg_podf)

/*! @brief Set the ipg_podf field to a new value. */
#define BW_CCM_CBCDR_ipg_podf(x, v) (HW_CCM_CBCDR_WR(x, (HW_CCM_CBCDR_RD(x) & ~BM_CCM_CBCDR_ipg_podf) | BF_CCM_CBCDR_ipg_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CBCDR, field ahb_podf[12:10] (RW)
 *
 * Divider for AHB PODF. Any change of this divider might involve handshake with
 * EMI. See CDHIPR register for the handshake busy bits.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CBCDR_ahb_podf (10U)        /*!< Bit position for CCM_CBCDR_ahb_podf. */
#define BM_CCM_CBCDR_ahb_podf (0x00001C00U) /*!< Bit mask for CCM_CBCDR_ahb_podf. */
#define BS_CCM_CBCDR_ahb_podf (3U)         /*!< Bit field size in bits for CCM_CBCDR_ahb_podf. */

/*! @brief Read current value of the CCM_CBCDR_ahb_podf field. */
#define BR_CCM_CBCDR_ahb_podf(x) (HW_CCM_CBCDR(x).B.ahb_podf)

/*! @brief Format value for bitfield CCM_CBCDR_ahb_podf. */
#define BF_CCM_CBCDR_ahb_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCDR_ahb_podf) & BM_CCM_CBCDR_ahb_podf)

/*! @brief Set the ahb_podf field to a new value. */
#define BW_CCM_CBCDR_ahb_podf(x, v) (HW_CCM_CBCDR_WR(x, (HW_CCM_CBCDR_RD(x) & ~BM_CCM_CBCDR_ahb_podf) | BF_CCM_CBCDR_ahb_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CBCDR, field ocram_podf[18:16] (RW)
 *
 * Post divider for ocram clock. Any change of this divider might involve
 * handshake with EMI. See CDHIPR register for the handshake busy bits.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CBCDR_ocram_podf (16U)      /*!< Bit position for CCM_CBCDR_ocram_podf. */
#define BM_CCM_CBCDR_ocram_podf (0x00070000U) /*!< Bit mask for CCM_CBCDR_ocram_podf. */
#define BS_CCM_CBCDR_ocram_podf (3U)       /*!< Bit field size in bits for CCM_CBCDR_ocram_podf. */

/*! @brief Read current value of the CCM_CBCDR_ocram_podf field. */
#define BR_CCM_CBCDR_ocram_podf(x) (HW_CCM_CBCDR(x).B.ocram_podf)

/*! @brief Format value for bitfield CCM_CBCDR_ocram_podf. */
#define BF_CCM_CBCDR_ocram_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCDR_ocram_podf) & BM_CCM_CBCDR_ocram_podf)

/*! @brief Set the ocram_podf field to a new value. */
#define BW_CCM_CBCDR_ocram_podf(x, v) (HW_CCM_CBCDR_WR(x, (HW_CCM_CBCDR_RD(x) & ~BM_CCM_CBCDR_ocram_podf) | BF_CCM_CBCDR_ocram_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CBCDR, field periph_clk_sel[25] (RW)
 *
 * Selector for peripheral main clock (source of MMDC_CLK_ROOT). Alternative
 * clock source should be used when PLL is relocked. For PLL relock procedure pls
 * refer to the PLL chapter. Any change of this sync mux select will involve
 * handshake with the MMDC. Refer to the CCDR and CDHIPR registers for the handshake
 * bypass and busy bits.
 *
 * Values:
 * - 0 - PLL2 (pll2_main_clk)
 * - 1 - derive clock from periph_clk2_clk clock source.
 */
/*@{*/
#define BP_CCM_CBCDR_periph_clk_sel (25U)  /*!< Bit position for CCM_CBCDR_periph_clk_sel. */
#define BM_CCM_CBCDR_periph_clk_sel (0x02000000U) /*!< Bit mask for CCM_CBCDR_periph_clk_sel. */
#define BS_CCM_CBCDR_periph_clk_sel (1U)   /*!< Bit field size in bits for CCM_CBCDR_periph_clk_sel. */

/*! @brief Read current value of the CCM_CBCDR_periph_clk_sel field. */
#define BR_CCM_CBCDR_periph_clk_sel(x) (HW_CCM_CBCDR(x).B.periph_clk_sel)

/*! @brief Format value for bitfield CCM_CBCDR_periph_clk_sel. */
#define BF_CCM_CBCDR_periph_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCDR_periph_clk_sel) & BM_CCM_CBCDR_periph_clk_sel)

/*! @brief Set the periph_clk_sel field to a new value. */
#define BW_CCM_CBCDR_periph_clk_sel(x, v) (HW_CCM_CBCDR_WR(x, (HW_CCM_CBCDR_RD(x) & ~BM_CCM_CBCDR_periph_clk_sel) | BF_CCM_CBCDR_periph_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CBCDR, field periph2_clk_sel[26] (RW)
 *
 * Selector for peripheral2 main clock (source of mmdc_clk_root ). Any change of
 * this mux select will involve handshake with the MMDC. Refer to the CCDR and
 * CDHIPR registers for the handshake bypass and busy bits.
 *
 * Values:
 * - 0 - PLL2 (pll2_main_clk)
 * - 1 - derive clock from periph2_clk2_clk clock source.
 */
/*@{*/
#define BP_CCM_CBCDR_periph2_clk_sel (26U) /*!< Bit position for CCM_CBCDR_periph2_clk_sel. */
#define BM_CCM_CBCDR_periph2_clk_sel (0x04000000U) /*!< Bit mask for CCM_CBCDR_periph2_clk_sel. */
#define BS_CCM_CBCDR_periph2_clk_sel (1U)  /*!< Bit field size in bits for CCM_CBCDR_periph2_clk_sel. */

/*! @brief Read current value of the CCM_CBCDR_periph2_clk_sel field. */
#define BR_CCM_CBCDR_periph2_clk_sel(x) (HW_CCM_CBCDR(x).B.periph2_clk_sel)

/*! @brief Format value for bitfield CCM_CBCDR_periph2_clk_sel. */
#define BF_CCM_CBCDR_periph2_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCDR_periph2_clk_sel) & BM_CCM_CBCDR_periph2_clk_sel)

/*! @brief Set the periph2_clk_sel field to a new value. */
#define BW_CCM_CBCDR_periph2_clk_sel(x, v) (HW_CCM_CBCDR_WR(x, (HW_CCM_CBCDR_RD(x) & ~BM_CCM_CBCDR_periph2_clk_sel) | BF_CCM_CBCDR_periph2_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CBCDR, field periph_clk2_podf[29:27] (RW)
 *
 * Divider for periph2 clock podf.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CBCDR_periph_clk2_podf (27U) /*!< Bit position for CCM_CBCDR_periph_clk2_podf. */
#define BM_CCM_CBCDR_periph_clk2_podf (0x38000000U) /*!< Bit mask for CCM_CBCDR_periph_clk2_podf. */
#define BS_CCM_CBCDR_periph_clk2_podf (3U) /*!< Bit field size in bits for CCM_CBCDR_periph_clk2_podf. */

/*! @brief Read current value of the CCM_CBCDR_periph_clk2_podf field. */
#define BR_CCM_CBCDR_periph_clk2_podf(x) (HW_CCM_CBCDR(x).B.periph_clk2_podf)

/*! @brief Format value for bitfield CCM_CBCDR_periph_clk2_podf. */
#define BF_CCM_CBCDR_periph_clk2_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCDR_periph_clk2_podf) & BM_CCM_CBCDR_periph_clk2_podf)

/*! @brief Set the periph_clk2_podf field to a new value. */
#define BW_CCM_CBCDR_periph_clk2_podf(x, v) (HW_CCM_CBCDR_WR(x, (HW_CCM_CBCDR_RD(x) & ~BM_CCM_CBCDR_periph_clk2_podf) | BF_CCM_CBCDR_periph_clk2_podf(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CBCMR - CCM Bus Clock Multiplexer Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CBCMR - CCM Bus Clock Multiplexer Register (RW)
 *
 * Reset value: 0x04860324U
 *
 * The figure below represents the CCM Bus Clock Multiplexer Register (CBCMR).
 * The CBCMR register contains bits to control the multiplexers that generate the
 * bus clocks. The table below provides its field descriptions. Any change on the
 * above multiplexer will have to be done while the module that its clock is
 * affected is not functional and the respective clock is gated in LPCG. If the
 * change will be done during operation of the module, then it is not guaranteed that
 * the modules operation will not be harmed. The change for arm_clk_sel should
 * be done through sdma so that ARM will not use this clock during the change and
 * the clock will be gated in LPCG.
 */
typedef union _hw_ccm_cbcmr
{
    uint32_t U;
    struct _hw_ccm_cbcmr_bitfields
    {
        uint32_t RESERVED0 : 4;        /*!< [3:0]  */
        uint32_t gpu_core_sel : 2;     /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t gpu_axi_sel : 2;      /*!< [9:8]  */
        uint32_t pcie_axi_clk_sel : 1; /*!< [10]  */
        uint32_t RESERVED2 : 1;        /*!< [11]  */
        uint32_t periph_clk2_sel : 2;  /*!< [13:12]  */
        uint32_t RESERVED3 : 4;        /*!< [17:14]  */
        uint32_t pre_periph_clk_sel : 2; /*!< [19:18]  */
        uint32_t periph2_clk2_sel : 1; /*!< [20]  */
        uint32_t pre_periph2_clk_sel : 2; /*!< [22:21]  */
        uint32_t lcdif1_podf : 3;      /*!< [25:23]  */
        uint32_t gpu_axi_podf : 3;     /*!< [28:26]  */
        uint32_t gpu_core_podf : 3;    /*!< [31:29]  */
    } B;
} hw_ccm_cbcmr_t;

/*!
 * @name Constants and macros for entire CCM_CBCMR register
 */
/*@{*/
#define HW_CCM_CBCMR_ADDR(x)     ((uintptr_t)(x) + 0x18U)

#define HW_CCM_CBCMR(x)          (*(__IO hw_ccm_cbcmr_t *) HW_CCM_CBCMR_ADDR(x))
#define HW_CCM_CBCMR_RD(x)       (HW_CCM_CBCMR(x).U)
#define HW_CCM_CBCMR_WR(x, v)    (HW_CCM_CBCMR(x).U = (v))
#define HW_CCM_CBCMR_SET(x, v)   (HW_CCM_CBCMR_WR(x, HW_CCM_CBCMR_RD(x) |  (v)))
#define HW_CCM_CBCMR_CLR(x, v)   (HW_CCM_CBCMR_WR(x, HW_CCM_CBCMR_RD(x) & ~(v)))
#define HW_CCM_CBCMR_TOG(x, v)   (HW_CCM_CBCMR_WR(x, HW_CCM_CBCMR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CBCMR bitfields
 */

/*!
 * @name Register CCM_CBCMR, field gpu_core_sel[5:4] (RW)
 *
 * Selector for gpu_core clock multiplexer
 *
 * Values:
 * - 00 - derive clock from PLL3 PFD1 clk
 * - 01 - derive clock from PLL3 PFD0
 * - 10 - derive clock from PLL2
 * - 11 - derive clock from PLL2 PFD2
 */
/*@{*/
#define BP_CCM_CBCMR_gpu_core_sel (4U)     /*!< Bit position for CCM_CBCMR_gpu_core_sel. */
#define BM_CCM_CBCMR_gpu_core_sel (0x00000030U) /*!< Bit mask for CCM_CBCMR_gpu_core_sel. */
#define BS_CCM_CBCMR_gpu_core_sel (2U)     /*!< Bit field size in bits for CCM_CBCMR_gpu_core_sel. */

/*! @brief Read current value of the CCM_CBCMR_gpu_core_sel field. */
#define BR_CCM_CBCMR_gpu_core_sel(x) (HW_CCM_CBCMR(x).B.gpu_core_sel)

/*! @brief Format value for bitfield CCM_CBCMR_gpu_core_sel. */
#define BF_CCM_CBCMR_gpu_core_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCMR_gpu_core_sel) & BM_CCM_CBCMR_gpu_core_sel)

/*! @brief Set the gpu_core_sel field to a new value. */
#define BW_CCM_CBCMR_gpu_core_sel(x, v) (HW_CCM_CBCMR_WR(x, (HW_CCM_CBCMR_RD(x) & ~BM_CCM_CBCMR_gpu_core_sel) | BF_CCM_CBCMR_gpu_core_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CBCMR, field gpu_axi_sel[9:8] (RW)
 *
 * Selector for gpu_axi clock multiplexer
 *
 * Values:
 * - 00 - derive clock from PLL2 PFD2 clk
 * - 01 - derive clock from PLL3 PFD0
 * - 10 - derive clock from PLL3 PFD1
 * - 11 - derive clock from PLL2
 */
/*@{*/
#define BP_CCM_CBCMR_gpu_axi_sel (8U)      /*!< Bit position for CCM_CBCMR_gpu_axi_sel. */
#define BM_CCM_CBCMR_gpu_axi_sel (0x00000300U) /*!< Bit mask for CCM_CBCMR_gpu_axi_sel. */
#define BS_CCM_CBCMR_gpu_axi_sel (2U)      /*!< Bit field size in bits for CCM_CBCMR_gpu_axi_sel. */

/*! @brief Read current value of the CCM_CBCMR_gpu_axi_sel field. */
#define BR_CCM_CBCMR_gpu_axi_sel(x) (HW_CCM_CBCMR(x).B.gpu_axi_sel)

/*! @brief Format value for bitfield CCM_CBCMR_gpu_axi_sel. */
#define BF_CCM_CBCMR_gpu_axi_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCMR_gpu_axi_sel) & BM_CCM_CBCMR_gpu_axi_sel)

/*! @brief Set the gpu_axi_sel field to a new value. */
#define BW_CCM_CBCMR_gpu_axi_sel(x, v) (HW_CCM_CBCMR_WR(x, (HW_CCM_CBCMR_RD(x) & ~BM_CCM_CBCMR_gpu_axi_sel) | BF_CCM_CBCMR_gpu_axi_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CBCMR, field pcie_axi_clk_sel[10] (RW)
 *
 * Selector for pcie_axi clock multiplexer
 *
 * Values:
 * - 0 - derive clock from AXI clock
 * - 1 - derive clock from AHB clock
 */
/*@{*/
#define BP_CCM_CBCMR_pcie_axi_clk_sel (10U) /*!< Bit position for CCM_CBCMR_pcie_axi_clk_sel. */
#define BM_CCM_CBCMR_pcie_axi_clk_sel (0x00000400U) /*!< Bit mask for CCM_CBCMR_pcie_axi_clk_sel. */
#define BS_CCM_CBCMR_pcie_axi_clk_sel (1U) /*!< Bit field size in bits for CCM_CBCMR_pcie_axi_clk_sel. */

/*! @brief Read current value of the CCM_CBCMR_pcie_axi_clk_sel field. */
#define BR_CCM_CBCMR_pcie_axi_clk_sel(x) (HW_CCM_CBCMR(x).B.pcie_axi_clk_sel)

/*! @brief Format value for bitfield CCM_CBCMR_pcie_axi_clk_sel. */
#define BF_CCM_CBCMR_pcie_axi_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCMR_pcie_axi_clk_sel) & BM_CCM_CBCMR_pcie_axi_clk_sel)

/*! @brief Set the pcie_axi_clk_sel field to a new value. */
#define BW_CCM_CBCMR_pcie_axi_clk_sel(x, v) (HW_CCM_CBCMR_WR(x, (HW_CCM_CBCMR_RD(x) & ~BM_CCM_CBCMR_pcie_axi_clk_sel) | BF_CCM_CBCMR_pcie_axi_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CBCMR, field periph_clk2_sel[13:12] (RW)
 *
 * Selector for peripheral clk2 clock multiplexer
 *
 * Values:
 * - 00 - derive clock from pll3_sw_clk
 * - 01 - derive clock from osc_clk (pll1_ref_clk)
 * - 10 - derive clock from PLL2 (pll2_main_clk)
 * - 11 - reserved
 */
/*@{*/
#define BP_CCM_CBCMR_periph_clk2_sel (12U) /*!< Bit position for CCM_CBCMR_periph_clk2_sel. */
#define BM_CCM_CBCMR_periph_clk2_sel (0x00003000U) /*!< Bit mask for CCM_CBCMR_periph_clk2_sel. */
#define BS_CCM_CBCMR_periph_clk2_sel (2U)  /*!< Bit field size in bits for CCM_CBCMR_periph_clk2_sel. */

/*! @brief Read current value of the CCM_CBCMR_periph_clk2_sel field. */
#define BR_CCM_CBCMR_periph_clk2_sel(x) (HW_CCM_CBCMR(x).B.periph_clk2_sel)

/*! @brief Format value for bitfield CCM_CBCMR_periph_clk2_sel. */
#define BF_CCM_CBCMR_periph_clk2_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCMR_periph_clk2_sel) & BM_CCM_CBCMR_periph_clk2_sel)

/*! @brief Set the periph_clk2_sel field to a new value. */
#define BW_CCM_CBCMR_periph_clk2_sel(x, v) (HW_CCM_CBCMR_WR(x, (HW_CCM_CBCMR_RD(x) & ~BM_CCM_CBCMR_periph_clk2_sel) | BF_CCM_CBCMR_periph_clk2_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CBCMR, field pre_periph_clk_sel[19:18] (RW)
 *
 * Selector for pre_periph clock multiplexer
 *
 * Values:
 * - 00 - derive clock from PLL2
 * - 01 - derive clock from PLL2 PFD2
 * - 10 - derive clock from PLL2 PFD0
 * - 11 - derive clock from divided (/2) PLL2 PFD2
 */
/*@{*/
#define BP_CCM_CBCMR_pre_periph_clk_sel (18U) /*!< Bit position for CCM_CBCMR_pre_periph_clk_sel. */
#define BM_CCM_CBCMR_pre_periph_clk_sel (0x000C0000U) /*!< Bit mask for CCM_CBCMR_pre_periph_clk_sel. */
#define BS_CCM_CBCMR_pre_periph_clk_sel (2U) /*!< Bit field size in bits for CCM_CBCMR_pre_periph_clk_sel. */

/*! @brief Read current value of the CCM_CBCMR_pre_periph_clk_sel field. */
#define BR_CCM_CBCMR_pre_periph_clk_sel(x) (HW_CCM_CBCMR(x).B.pre_periph_clk_sel)

/*! @brief Format value for bitfield CCM_CBCMR_pre_periph_clk_sel. */
#define BF_CCM_CBCMR_pre_periph_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCMR_pre_periph_clk_sel) & BM_CCM_CBCMR_pre_periph_clk_sel)

/*! @brief Set the pre_periph_clk_sel field to a new value. */
#define BW_CCM_CBCMR_pre_periph_clk_sel(x, v) (HW_CCM_CBCMR_WR(x, (HW_CCM_CBCMR_RD(x) & ~BM_CCM_CBCMR_pre_periph_clk_sel) | BF_CCM_CBCMR_pre_periph_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CBCMR, field periph2_clk2_sel[20] (RW)
 *
 * Selector for periph2_clk2 clock multiplexer
 *
 * Values:
 * - 0 - derive clock from pll3_sw_clk
 * - 1 - derive clock fromOSC
 */
/*@{*/
#define BP_CCM_CBCMR_periph2_clk2_sel (20U) /*!< Bit position for CCM_CBCMR_periph2_clk2_sel. */
#define BM_CCM_CBCMR_periph2_clk2_sel (0x00100000U) /*!< Bit mask for CCM_CBCMR_periph2_clk2_sel. */
#define BS_CCM_CBCMR_periph2_clk2_sel (1U) /*!< Bit field size in bits for CCM_CBCMR_periph2_clk2_sel. */

/*! @brief Read current value of the CCM_CBCMR_periph2_clk2_sel field. */
#define BR_CCM_CBCMR_periph2_clk2_sel(x) (HW_CCM_CBCMR(x).B.periph2_clk2_sel)

/*! @brief Format value for bitfield CCM_CBCMR_periph2_clk2_sel. */
#define BF_CCM_CBCMR_periph2_clk2_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCMR_periph2_clk2_sel) & BM_CCM_CBCMR_periph2_clk2_sel)

/*! @brief Set the periph2_clk2_sel field to a new value. */
#define BW_CCM_CBCMR_periph2_clk2_sel(x, v) (HW_CCM_CBCMR_WR(x, (HW_CCM_CBCMR_RD(x) & ~BM_CCM_CBCMR_periph2_clk2_sel) | BF_CCM_CBCMR_periph2_clk2_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CBCMR, field pre_periph2_clk_sel[22:21] (RW)
 *
 * Selector for pre_periph2 clock multiplexer
 *
 * Values:
 * - 00 - derive clock from PLL2
 * - 01 - derive clock from PLL2 PFD2
 * - 10 - derive clock from PLL2 PFD0
 * - 11 - derive clock from PLL4
 */
/*@{*/
#define BP_CCM_CBCMR_pre_periph2_clk_sel (21U) /*!< Bit position for CCM_CBCMR_pre_periph2_clk_sel. */
#define BM_CCM_CBCMR_pre_periph2_clk_sel (0x00600000U) /*!< Bit mask for CCM_CBCMR_pre_periph2_clk_sel. */
#define BS_CCM_CBCMR_pre_periph2_clk_sel (2U) /*!< Bit field size in bits for CCM_CBCMR_pre_periph2_clk_sel. */

/*! @brief Read current value of the CCM_CBCMR_pre_periph2_clk_sel field. */
#define BR_CCM_CBCMR_pre_periph2_clk_sel(x) (HW_CCM_CBCMR(x).B.pre_periph2_clk_sel)

/*! @brief Format value for bitfield CCM_CBCMR_pre_periph2_clk_sel. */
#define BF_CCM_CBCMR_pre_periph2_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCMR_pre_periph2_clk_sel) & BM_CCM_CBCMR_pre_periph2_clk_sel)

/*! @brief Set the pre_periph2_clk_sel field to a new value. */
#define BW_CCM_CBCMR_pre_periph2_clk_sel(x, v) (HW_CCM_CBCMR_WR(x, (HW_CCM_CBCMR_RD(x) & ~BM_CCM_CBCMR_pre_periph2_clk_sel) | BF_CCM_CBCMR_pre_periph2_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CBCMR, field lcdif1_podf[25:23] (RW)
 *
 * Post-divider for lcdif1 clock.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CBCMR_lcdif1_podf (23U)     /*!< Bit position for CCM_CBCMR_lcdif1_podf. */
#define BM_CCM_CBCMR_lcdif1_podf (0x03800000U) /*!< Bit mask for CCM_CBCMR_lcdif1_podf. */
#define BS_CCM_CBCMR_lcdif1_podf (3U)      /*!< Bit field size in bits for CCM_CBCMR_lcdif1_podf. */

/*! @brief Read current value of the CCM_CBCMR_lcdif1_podf field. */
#define BR_CCM_CBCMR_lcdif1_podf(x) (HW_CCM_CBCMR(x).B.lcdif1_podf)

/*! @brief Format value for bitfield CCM_CBCMR_lcdif1_podf. */
#define BF_CCM_CBCMR_lcdif1_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCMR_lcdif1_podf) & BM_CCM_CBCMR_lcdif1_podf)

/*! @brief Set the lcdif1_podf field to a new value. */
#define BW_CCM_CBCMR_lcdif1_podf(x, v) (HW_CCM_CBCMR_WR(x, (HW_CCM_CBCMR_RD(x) & ~BM_CCM_CBCMR_lcdif1_podf) | BF_CCM_CBCMR_lcdif1_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CBCMR, field gpu_axi_podf[28:26] (RW)
 *
 * Divider for gpu_axi_podf. Divider should be updated when output clock is
 * gated.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CBCMR_gpu_axi_podf (26U)    /*!< Bit position for CCM_CBCMR_gpu_axi_podf. */
#define BM_CCM_CBCMR_gpu_axi_podf (0x1C000000U) /*!< Bit mask for CCM_CBCMR_gpu_axi_podf. */
#define BS_CCM_CBCMR_gpu_axi_podf (3U)     /*!< Bit field size in bits for CCM_CBCMR_gpu_axi_podf. */

/*! @brief Read current value of the CCM_CBCMR_gpu_axi_podf field. */
#define BR_CCM_CBCMR_gpu_axi_podf(x) (HW_CCM_CBCMR(x).B.gpu_axi_podf)

/*! @brief Format value for bitfield CCM_CBCMR_gpu_axi_podf. */
#define BF_CCM_CBCMR_gpu_axi_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCMR_gpu_axi_podf) & BM_CCM_CBCMR_gpu_axi_podf)

/*! @brief Set the gpu_axi_podf field to a new value. */
#define BW_CCM_CBCMR_gpu_axi_podf(x, v) (HW_CCM_CBCMR_WR(x, (HW_CCM_CBCMR_RD(x) & ~BM_CCM_CBCMR_gpu_axi_podf) | BF_CCM_CBCMR_gpu_axi_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CBCMR, field gpu_core_podf[31:29] (RW)
 *
 * Post divider for gpu_core clock. Divider should be updated when output clock
 * is gated.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CBCMR_gpu_core_podf (29U)   /*!< Bit position for CCM_CBCMR_gpu_core_podf. */
#define BM_CCM_CBCMR_gpu_core_podf (0xE0000000U) /*!< Bit mask for CCM_CBCMR_gpu_core_podf. */
#define BS_CCM_CBCMR_gpu_core_podf (3U)    /*!< Bit field size in bits for CCM_CBCMR_gpu_core_podf. */

/*! @brief Read current value of the CCM_CBCMR_gpu_core_podf field. */
#define BR_CCM_CBCMR_gpu_core_podf(x) (HW_CCM_CBCMR(x).B.gpu_core_podf)

/*! @brief Format value for bitfield CCM_CBCMR_gpu_core_podf. */
#define BF_CCM_CBCMR_gpu_core_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCMR_gpu_core_podf) & BM_CCM_CBCMR_gpu_core_podf)

/*! @brief Set the gpu_core_podf field to a new value. */
#define BW_CCM_CBCMR_gpu_core_podf(x, v) (HW_CCM_CBCMR_WR(x, (HW_CCM_CBCMR_RD(x) & ~BM_CCM_CBCMR_gpu_core_podf) | BF_CCM_CBCMR_gpu_core_podf(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CSCMR1 - CCM Serial Clock Multiplexer Register 1
 ******************************************************************************/

/*!
 * @brief HW_CCM_CSCMR1 - CCM Serial Clock Multiplexer Register 1 (RW)
 *
 * Reset value: 0x04900080U
 *
 * The figure below represents the CCM Serial Clock Multiplexer Register 1
 * (CSCMR1). The CSCMR1 register contains bits to control the multiplexers that
 * generate the serial clocks. The table below provides its field descriptions. Any
 * change on the above multiplexer will have to be done while the module that its
 * clock is affected is not functional and the clock is gated. If the change will
 * be done during operation of the module, then it is not guaranteed that the
 * modules operation will not be harmed.
 */
typedef union _hw_ccm_cscmr1
{
    uint32_t U;
    struct _hw_ccm_cscmr1_bitfields
    {
        uint32_t perclk_podf : 6;      /*!< [5:0]  */
        uint32_t perclk_clk_sel : 1;   /*!< [6]  */
        uint32_t qspi1_sel : 3;        /*!< [9:7]  */
        uint32_t ssi1_clk_sel : 2;     /*!< [11:10]  */
        uint32_t ssi2_clk_sel : 2;     /*!< [13:12]  */
        uint32_t ssi3_clk_sel : 2;     /*!< [15:14]  */
        uint32_t usdhc1_clk_sel : 1;   /*!< [16]  */
        uint32_t usdhc2_clk_sel : 1;   /*!< [17]  */
        uint32_t usdhc3_clk_sel : 1;   /*!< [18]  */
        uint32_t usdhc4_clk_sel : 1;   /*!< [19]  */
        uint32_t lcdif2_podf : 3;      /*!< [22:20]  */
        uint32_t aclk_eim_slow_podf : 3; /*!< [25:23]  */
        uint32_t qspi1_podf : 3;       /*!< [28:26]  */
        uint32_t aclk_eim_slow_sel : 2; /*!< [30:29]  */
        uint32_t RESERVED0 : 1;        /*!< [31]  */
    } B;
} hw_ccm_cscmr1_t;

/*!
 * @name Constants and macros for entire CCM_CSCMR1 register
 */
/*@{*/
#define HW_CCM_CSCMR1_ADDR(x)    ((uintptr_t)(x) + 0x1CU)

#define HW_CCM_CSCMR1(x)         (*(__IO hw_ccm_cscmr1_t *) HW_CCM_CSCMR1_ADDR(x))
#define HW_CCM_CSCMR1_RD(x)      (HW_CCM_CSCMR1(x).U)
#define HW_CCM_CSCMR1_WR(x, v)   (HW_CCM_CSCMR1(x).U = (v))
#define HW_CCM_CSCMR1_SET(x, v)  (HW_CCM_CSCMR1_WR(x, HW_CCM_CSCMR1_RD(x) |  (v)))
#define HW_CCM_CSCMR1_CLR(x, v)  (HW_CCM_CSCMR1_WR(x, HW_CCM_CSCMR1_RD(x) & ~(v)))
#define HW_CCM_CSCMR1_TOG(x, v)  (HW_CCM_CSCMR1_WR(x, HW_CCM_CSCMR1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CSCMR1 bitfields
 */

/*!
 * @name Register CCM_CSCMR1, field perclk_podf[5:0] (RW)
 *
 * Divider for perclk podf.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CSCMR1_perclk_podf (0U)     /*!< Bit position for CCM_CSCMR1_perclk_podf. */
#define BM_CCM_CSCMR1_perclk_podf (0x0000003FU) /*!< Bit mask for CCM_CSCMR1_perclk_podf. */
#define BS_CCM_CSCMR1_perclk_podf (6U)     /*!< Bit field size in bits for CCM_CSCMR1_perclk_podf. */

/*! @brief Read current value of the CCM_CSCMR1_perclk_podf field. */
#define BR_CCM_CSCMR1_perclk_podf(x) (HW_CCM_CSCMR1(x).B.perclk_podf)

/*! @brief Format value for bitfield CCM_CSCMR1_perclk_podf. */
#define BF_CCM_CSCMR1_perclk_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCMR1_perclk_podf) & BM_CCM_CSCMR1_perclk_podf)

/*! @brief Set the perclk_podf field to a new value. */
#define BW_CCM_CSCMR1_perclk_podf(x, v) (HW_CCM_CSCMR1_WR(x, (HW_CCM_CSCMR1_RD(x) & ~BM_CCM_CSCMR1_perclk_podf) | BF_CCM_CSCMR1_perclk_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CSCMR1, field perclk_clk_sel[6] (RW)
 *
 * Selector for the perclk clock multiplexor
 *
 * Values:
 * - 0 - derive clock from ipg clk root
 * - 1 - derive clock from osc_clk
 */
/*@{*/
#define BP_CCM_CSCMR1_perclk_clk_sel (6U)  /*!< Bit position for CCM_CSCMR1_perclk_clk_sel. */
#define BM_CCM_CSCMR1_perclk_clk_sel (0x00000040U) /*!< Bit mask for CCM_CSCMR1_perclk_clk_sel. */
#define BS_CCM_CSCMR1_perclk_clk_sel (1U)  /*!< Bit field size in bits for CCM_CSCMR1_perclk_clk_sel. */

/*! @brief Read current value of the CCM_CSCMR1_perclk_clk_sel field. */
#define BR_CCM_CSCMR1_perclk_clk_sel(x) (HW_CCM_CSCMR1(x).B.perclk_clk_sel)

/*! @brief Format value for bitfield CCM_CSCMR1_perclk_clk_sel. */
#define BF_CCM_CSCMR1_perclk_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCMR1_perclk_clk_sel) & BM_CCM_CSCMR1_perclk_clk_sel)

/*! @brief Set the perclk_clk_sel field to a new value. */
#define BW_CCM_CSCMR1_perclk_clk_sel(x, v) (HW_CCM_CSCMR1_WR(x, (HW_CCM_CSCMR1_RD(x) & ~BM_CCM_CSCMR1_perclk_clk_sel) | BF_CCM_CSCMR1_perclk_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CSCMR1, field qspi1_sel[9:7] (RW)
 *
 * QSPI1 clock select
 *
 * Values:
 * - 000 - Derive clock from PLL3
 * - 001 - Derive clock from PLL2 PFD0
 * - 010 - Derive clock from PLL2 PFD2
 * - 011 - Derive clock from PLL2
 * - 100 - Derive clock from PLL3 PFD3
 * - 101 - Derive clock from PLL3 PFD2
 */
/*@{*/
#define BP_CCM_CSCMR1_qspi1_sel (7U)       /*!< Bit position for CCM_CSCMR1_qspi1_sel. */
#define BM_CCM_CSCMR1_qspi1_sel (0x00000380U) /*!< Bit mask for CCM_CSCMR1_qspi1_sel. */
#define BS_CCM_CSCMR1_qspi1_sel (3U)       /*!< Bit field size in bits for CCM_CSCMR1_qspi1_sel. */

/*! @brief Read current value of the CCM_CSCMR1_qspi1_sel field. */
#define BR_CCM_CSCMR1_qspi1_sel(x) (HW_CCM_CSCMR1(x).B.qspi1_sel)

/*! @brief Format value for bitfield CCM_CSCMR1_qspi1_sel. */
#define BF_CCM_CSCMR1_qspi1_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCMR1_qspi1_sel) & BM_CCM_CSCMR1_qspi1_sel)

/*! @brief Set the qspi1_sel field to a new value. */
#define BW_CCM_CSCMR1_qspi1_sel(x, v) (HW_CCM_CSCMR1_WR(x, (HW_CCM_CSCMR1_RD(x) & ~BM_CCM_CSCMR1_qspi1_sel) | BF_CCM_CSCMR1_qspi1_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CSCMR1, field ssi1_clk_sel[11:10] (RW)
 *
 * Selector for ssi1 clock multiplexer
 *
 * Values:
 * - 00 - derive clock from PLL3 PFD2
 * - 01 - derive clock from PLL5
 * - 10 - derive clock from PLL4
 * - 11 - Reserved
 */
/*@{*/
#define BP_CCM_CSCMR1_ssi1_clk_sel (10U)   /*!< Bit position for CCM_CSCMR1_ssi1_clk_sel. */
#define BM_CCM_CSCMR1_ssi1_clk_sel (0x00000C00U) /*!< Bit mask for CCM_CSCMR1_ssi1_clk_sel. */
#define BS_CCM_CSCMR1_ssi1_clk_sel (2U)    /*!< Bit field size in bits for CCM_CSCMR1_ssi1_clk_sel. */

/*! @brief Read current value of the CCM_CSCMR1_ssi1_clk_sel field. */
#define BR_CCM_CSCMR1_ssi1_clk_sel(x) (HW_CCM_CSCMR1(x).B.ssi1_clk_sel)

/*! @brief Format value for bitfield CCM_CSCMR1_ssi1_clk_sel. */
#define BF_CCM_CSCMR1_ssi1_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCMR1_ssi1_clk_sel) & BM_CCM_CSCMR1_ssi1_clk_sel)

/*! @brief Set the ssi1_clk_sel field to a new value. */
#define BW_CCM_CSCMR1_ssi1_clk_sel(x, v) (HW_CCM_CSCMR1_WR(x, (HW_CCM_CSCMR1_RD(x) & ~BM_CCM_CSCMR1_ssi1_clk_sel) | BF_CCM_CSCMR1_ssi1_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CSCMR1, field ssi2_clk_sel[13:12] (RW)
 *
 * Selector for ssi2 clock multiplexer
 *
 * Values:
 * - 00 - derive clock from PLL3 PFD2
 * - 01 - derive clock from PLL5
 * - 10 - derive clock from PLL4
 * - 11 - Reserved
 */
/*@{*/
#define BP_CCM_CSCMR1_ssi2_clk_sel (12U)   /*!< Bit position for CCM_CSCMR1_ssi2_clk_sel. */
#define BM_CCM_CSCMR1_ssi2_clk_sel (0x00003000U) /*!< Bit mask for CCM_CSCMR1_ssi2_clk_sel. */
#define BS_CCM_CSCMR1_ssi2_clk_sel (2U)    /*!< Bit field size in bits for CCM_CSCMR1_ssi2_clk_sel. */

/*! @brief Read current value of the CCM_CSCMR1_ssi2_clk_sel field. */
#define BR_CCM_CSCMR1_ssi2_clk_sel(x) (HW_CCM_CSCMR1(x).B.ssi2_clk_sel)

/*! @brief Format value for bitfield CCM_CSCMR1_ssi2_clk_sel. */
#define BF_CCM_CSCMR1_ssi2_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCMR1_ssi2_clk_sel) & BM_CCM_CSCMR1_ssi2_clk_sel)

/*! @brief Set the ssi2_clk_sel field to a new value. */
#define BW_CCM_CSCMR1_ssi2_clk_sel(x, v) (HW_CCM_CSCMR1_WR(x, (HW_CCM_CSCMR1_RD(x) & ~BM_CCM_CSCMR1_ssi2_clk_sel) | BF_CCM_CSCMR1_ssi2_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CSCMR1, field ssi3_clk_sel[15:14] (RW)
 *
 * Selector for ssi3 clock multiplexer
 *
 * Values:
 * - 00 - derive clock from PLL3 PFD2
 * - 01 - derive clock from PLL5
 * - 10 - derive clock from PLL4
 * - 11 - Reserved
 */
/*@{*/
#define BP_CCM_CSCMR1_ssi3_clk_sel (14U)   /*!< Bit position for CCM_CSCMR1_ssi3_clk_sel. */
#define BM_CCM_CSCMR1_ssi3_clk_sel (0x0000C000U) /*!< Bit mask for CCM_CSCMR1_ssi3_clk_sel. */
#define BS_CCM_CSCMR1_ssi3_clk_sel (2U)    /*!< Bit field size in bits for CCM_CSCMR1_ssi3_clk_sel. */

/*! @brief Read current value of the CCM_CSCMR1_ssi3_clk_sel field. */
#define BR_CCM_CSCMR1_ssi3_clk_sel(x) (HW_CCM_CSCMR1(x).B.ssi3_clk_sel)

/*! @brief Format value for bitfield CCM_CSCMR1_ssi3_clk_sel. */
#define BF_CCM_CSCMR1_ssi3_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCMR1_ssi3_clk_sel) & BM_CCM_CSCMR1_ssi3_clk_sel)

/*! @brief Set the ssi3_clk_sel field to a new value. */
#define BW_CCM_CSCMR1_ssi3_clk_sel(x, v) (HW_CCM_CSCMR1_WR(x, (HW_CCM_CSCMR1_RD(x) & ~BM_CCM_CSCMR1_ssi3_clk_sel) | BF_CCM_CSCMR1_ssi3_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CSCMR1, field usdhc1_clk_sel[16] (RW)
 *
 * Selector for usdhc1 clock multiplexer
 *
 * Values:
 * - 0 - derive clock from PLL2 PFD2
 * - 1 - derive clock from PLL2 PFD0
 */
/*@{*/
#define BP_CCM_CSCMR1_usdhc1_clk_sel (16U) /*!< Bit position for CCM_CSCMR1_usdhc1_clk_sel. */
#define BM_CCM_CSCMR1_usdhc1_clk_sel (0x00010000U) /*!< Bit mask for CCM_CSCMR1_usdhc1_clk_sel. */
#define BS_CCM_CSCMR1_usdhc1_clk_sel (1U)  /*!< Bit field size in bits for CCM_CSCMR1_usdhc1_clk_sel. */

/*! @brief Read current value of the CCM_CSCMR1_usdhc1_clk_sel field. */
#define BR_CCM_CSCMR1_usdhc1_clk_sel(x) (HW_CCM_CSCMR1(x).B.usdhc1_clk_sel)

/*! @brief Format value for bitfield CCM_CSCMR1_usdhc1_clk_sel. */
#define BF_CCM_CSCMR1_usdhc1_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCMR1_usdhc1_clk_sel) & BM_CCM_CSCMR1_usdhc1_clk_sel)

/*! @brief Set the usdhc1_clk_sel field to a new value. */
#define BW_CCM_CSCMR1_usdhc1_clk_sel(x, v) (HW_CCM_CSCMR1_WR(x, (HW_CCM_CSCMR1_RD(x) & ~BM_CCM_CSCMR1_usdhc1_clk_sel) | BF_CCM_CSCMR1_usdhc1_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CSCMR1, field usdhc2_clk_sel[17] (RW)
 *
 * Selector for usdhc2 clock multiplexer
 *
 * Values:
 * - 0 - derive clock from PLL2 PFD2
 * - 1 - derive clock from PLL2 PFD0
 */
/*@{*/
#define BP_CCM_CSCMR1_usdhc2_clk_sel (17U) /*!< Bit position for CCM_CSCMR1_usdhc2_clk_sel. */
#define BM_CCM_CSCMR1_usdhc2_clk_sel (0x00020000U) /*!< Bit mask for CCM_CSCMR1_usdhc2_clk_sel. */
#define BS_CCM_CSCMR1_usdhc2_clk_sel (1U)  /*!< Bit field size in bits for CCM_CSCMR1_usdhc2_clk_sel. */

/*! @brief Read current value of the CCM_CSCMR1_usdhc2_clk_sel field. */
#define BR_CCM_CSCMR1_usdhc2_clk_sel(x) (HW_CCM_CSCMR1(x).B.usdhc2_clk_sel)

/*! @brief Format value for bitfield CCM_CSCMR1_usdhc2_clk_sel. */
#define BF_CCM_CSCMR1_usdhc2_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCMR1_usdhc2_clk_sel) & BM_CCM_CSCMR1_usdhc2_clk_sel)

/*! @brief Set the usdhc2_clk_sel field to a new value. */
#define BW_CCM_CSCMR1_usdhc2_clk_sel(x, v) (HW_CCM_CSCMR1_WR(x, (HW_CCM_CSCMR1_RD(x) & ~BM_CCM_CSCMR1_usdhc2_clk_sel) | BF_CCM_CSCMR1_usdhc2_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CSCMR1, field usdhc3_clk_sel[18] (RW)
 *
 * Selector for usdhc3 clock multiplexer
 *
 * Values:
 * - 0 - derive clock from PLL2 PFD2
 * - 1 - derive clock from PLL2 PFD0
 */
/*@{*/
#define BP_CCM_CSCMR1_usdhc3_clk_sel (18U) /*!< Bit position for CCM_CSCMR1_usdhc3_clk_sel. */
#define BM_CCM_CSCMR1_usdhc3_clk_sel (0x00040000U) /*!< Bit mask for CCM_CSCMR1_usdhc3_clk_sel. */
#define BS_CCM_CSCMR1_usdhc3_clk_sel (1U)  /*!< Bit field size in bits for CCM_CSCMR1_usdhc3_clk_sel. */

/*! @brief Read current value of the CCM_CSCMR1_usdhc3_clk_sel field. */
#define BR_CCM_CSCMR1_usdhc3_clk_sel(x) (HW_CCM_CSCMR1(x).B.usdhc3_clk_sel)

/*! @brief Format value for bitfield CCM_CSCMR1_usdhc3_clk_sel. */
#define BF_CCM_CSCMR1_usdhc3_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCMR1_usdhc3_clk_sel) & BM_CCM_CSCMR1_usdhc3_clk_sel)

/*! @brief Set the usdhc3_clk_sel field to a new value. */
#define BW_CCM_CSCMR1_usdhc3_clk_sel(x, v) (HW_CCM_CSCMR1_WR(x, (HW_CCM_CSCMR1_RD(x) & ~BM_CCM_CSCMR1_usdhc3_clk_sel) | BF_CCM_CSCMR1_usdhc3_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CSCMR1, field usdhc4_clk_sel[19] (RW)
 *
 * Selector for usdhc4 clock multiplexer
 *
 * Values:
 * - 0 - derive clock from PLL2 PFD2
 * - 1 - derive clock from PLL2 PFD0
 */
/*@{*/
#define BP_CCM_CSCMR1_usdhc4_clk_sel (19U) /*!< Bit position for CCM_CSCMR1_usdhc4_clk_sel. */
#define BM_CCM_CSCMR1_usdhc4_clk_sel (0x00080000U) /*!< Bit mask for CCM_CSCMR1_usdhc4_clk_sel. */
#define BS_CCM_CSCMR1_usdhc4_clk_sel (1U)  /*!< Bit field size in bits for CCM_CSCMR1_usdhc4_clk_sel. */

/*! @brief Read current value of the CCM_CSCMR1_usdhc4_clk_sel field. */
#define BR_CCM_CSCMR1_usdhc4_clk_sel(x) (HW_CCM_CSCMR1(x).B.usdhc4_clk_sel)

/*! @brief Format value for bitfield CCM_CSCMR1_usdhc4_clk_sel. */
#define BF_CCM_CSCMR1_usdhc4_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCMR1_usdhc4_clk_sel) & BM_CCM_CSCMR1_usdhc4_clk_sel)

/*! @brief Set the usdhc4_clk_sel field to a new value. */
#define BW_CCM_CSCMR1_usdhc4_clk_sel(x, v) (HW_CCM_CSCMR1_WR(x, (HW_CCM_CSCMR1_RD(x) & ~BM_CCM_CSCMR1_usdhc4_clk_sel) | BF_CCM_CSCMR1_usdhc4_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CSCMR1, field lcdif2_podf[22:20] (RW)
 *
 * Post-divider for lcdif2 clock.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CSCMR1_lcdif2_podf (20U)    /*!< Bit position for CCM_CSCMR1_lcdif2_podf. */
#define BM_CCM_CSCMR1_lcdif2_podf (0x00700000U) /*!< Bit mask for CCM_CSCMR1_lcdif2_podf. */
#define BS_CCM_CSCMR1_lcdif2_podf (3U)     /*!< Bit field size in bits for CCM_CSCMR1_lcdif2_podf. */

/*! @brief Read current value of the CCM_CSCMR1_lcdif2_podf field. */
#define BR_CCM_CSCMR1_lcdif2_podf(x) (HW_CCM_CSCMR1(x).B.lcdif2_podf)

/*! @brief Format value for bitfield CCM_CSCMR1_lcdif2_podf. */
#define BF_CCM_CSCMR1_lcdif2_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCMR1_lcdif2_podf) & BM_CCM_CSCMR1_lcdif2_podf)

/*! @brief Set the lcdif2_podf field to a new value. */
#define BW_CCM_CSCMR1_lcdif2_podf(x, v) (HW_CCM_CSCMR1_WR(x, (HW_CCM_CSCMR1_RD(x) & ~BM_CCM_CSCMR1_lcdif2_podf) | BF_CCM_CSCMR1_lcdif2_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CSCMR1, field aclk_eim_slow_podf[25:23] (RW)
 *
 * Divider for aclk_eim_slow clock root.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CSCMR1_aclk_eim_slow_podf (23U) /*!< Bit position for CCM_CSCMR1_aclk_eim_slow_podf. */
#define BM_CCM_CSCMR1_aclk_eim_slow_podf (0x03800000U) /*!< Bit mask for CCM_CSCMR1_aclk_eim_slow_podf. */
#define BS_CCM_CSCMR1_aclk_eim_slow_podf (3U) /*!< Bit field size in bits for CCM_CSCMR1_aclk_eim_slow_podf. */

/*! @brief Read current value of the CCM_CSCMR1_aclk_eim_slow_podf field. */
#define BR_CCM_CSCMR1_aclk_eim_slow_podf(x) (HW_CCM_CSCMR1(x).B.aclk_eim_slow_podf)

/*! @brief Format value for bitfield CCM_CSCMR1_aclk_eim_slow_podf. */
#define BF_CCM_CSCMR1_aclk_eim_slow_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCMR1_aclk_eim_slow_podf) & BM_CCM_CSCMR1_aclk_eim_slow_podf)

/*! @brief Set the aclk_eim_slow_podf field to a new value. */
#define BW_CCM_CSCMR1_aclk_eim_slow_podf(x, v) (HW_CCM_CSCMR1_WR(x, (HW_CCM_CSCMR1_RD(x) & ~BM_CCM_CSCMR1_aclk_eim_slow_podf) | BF_CCM_CSCMR1_aclk_eim_slow_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CSCMR1, field qspi1_podf[28:26] (RW)
 *
 * Divider for QSPI1 clock root
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CSCMR1_qspi1_podf (26U)     /*!< Bit position for CCM_CSCMR1_qspi1_podf. */
#define BM_CCM_CSCMR1_qspi1_podf (0x1C000000U) /*!< Bit mask for CCM_CSCMR1_qspi1_podf. */
#define BS_CCM_CSCMR1_qspi1_podf (3U)      /*!< Bit field size in bits for CCM_CSCMR1_qspi1_podf. */

/*! @brief Read current value of the CCM_CSCMR1_qspi1_podf field. */
#define BR_CCM_CSCMR1_qspi1_podf(x) (HW_CCM_CSCMR1(x).B.qspi1_podf)

/*! @brief Format value for bitfield CCM_CSCMR1_qspi1_podf. */
#define BF_CCM_CSCMR1_qspi1_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCMR1_qspi1_podf) & BM_CCM_CSCMR1_qspi1_podf)

/*! @brief Set the qspi1_podf field to a new value. */
#define BW_CCM_CSCMR1_qspi1_podf(x, v) (HW_CCM_CSCMR1_WR(x, (HW_CCM_CSCMR1_RD(x) & ~BM_CCM_CSCMR1_qspi1_podf) | BF_CCM_CSCMR1_qspi1_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CSCMR1, field aclk_eim_slow_sel[30:29] (RW)
 *
 * Selector for aclk_eim_slow root clock multiplexer
 *
 * Values:
 * - 00 - derive clock from AXI
 * - 01 - derive clock from pll3_sw_clk
 * - 10 - derive clock from PLL2 PFD2
 * - 11 - derive clock from PLL3 PFD0
 */
/*@{*/
#define BP_CCM_CSCMR1_aclk_eim_slow_sel (29U) /*!< Bit position for CCM_CSCMR1_aclk_eim_slow_sel. */
#define BM_CCM_CSCMR1_aclk_eim_slow_sel (0x60000000U) /*!< Bit mask for CCM_CSCMR1_aclk_eim_slow_sel. */
#define BS_CCM_CSCMR1_aclk_eim_slow_sel (2U) /*!< Bit field size in bits for CCM_CSCMR1_aclk_eim_slow_sel. */

/*! @brief Read current value of the CCM_CSCMR1_aclk_eim_slow_sel field. */
#define BR_CCM_CSCMR1_aclk_eim_slow_sel(x) (HW_CCM_CSCMR1(x).B.aclk_eim_slow_sel)

/*! @brief Format value for bitfield CCM_CSCMR1_aclk_eim_slow_sel. */
#define BF_CCM_CSCMR1_aclk_eim_slow_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCMR1_aclk_eim_slow_sel) & BM_CCM_CSCMR1_aclk_eim_slow_sel)

/*! @brief Set the aclk_eim_slow_sel field to a new value. */
#define BW_CCM_CSCMR1_aclk_eim_slow_sel(x, v) (HW_CCM_CSCMR1_WR(x, (HW_CCM_CSCMR1_RD(x) & ~BM_CCM_CSCMR1_aclk_eim_slow_sel) | BF_CCM_CSCMR1_aclk_eim_slow_sel(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CSCMR2 - CCM Serial Clock Multiplexer Register 2
 ******************************************************************************/

/*!
 * @brief HW_CCM_CSCMR2 - CCM Serial Clock Multiplexer Register 2 (RW)
 *
 * Reset value: 0x02B92F06U
 *
 * The figure below represents the CCM Serial Clock Multiplexer Register 2
 * (CSCMR2). The CSCMR2 register contains bits to control the multiplexers that
 * generate the serial clocks. The table below provides its field descriptions. Any
 * change on the above multiplexer will have to be done while the module that its
 * clock is affected is not functional and the clock is gated. If the change will
 * be done during operation of the module, then it is not guaranteed that the
 * modules operation will not be harmed.
 */
typedef union _hw_ccm_cscmr2
{
    uint32_t U;
    struct _hw_ccm_cscmr2_bitfields
    {
        uint32_t RESERVED0 : 2;        /*!< [1:0]  */
        uint32_t can_clk_podf : 6;     /*!< [7:2]  */
        uint32_t can_clk_sel : 2;      /*!< [9:8]  */
        uint32_t ldb_di0_div : 1;      /*!< [10]  */
        uint32_t ldb_di1_div : 1;      /*!< [11]  */
        uint32_t RESERVED1 : 7;        /*!< [18:12]  */
        uint32_t esai_clk_sel : 2;     /*!< [20:19]  */
        uint32_t vid_clk_sel : 3;      /*!< [23:21]  */
        uint32_t vid_clk_pre_podf : 2; /*!< [25:24]  */
        uint32_t vid_clk_podf : 3;     /*!< [28:26]  */
        uint32_t RESERVED2 : 3;        /*!< [31:29]  */
    } B;
} hw_ccm_cscmr2_t;

/*!
 * @name Constants and macros for entire CCM_CSCMR2 register
 */
/*@{*/
#define HW_CCM_CSCMR2_ADDR(x)    ((uintptr_t)(x) + 0x20U)

#define HW_CCM_CSCMR2(x)         (*(__IO hw_ccm_cscmr2_t *) HW_CCM_CSCMR2_ADDR(x))
#define HW_CCM_CSCMR2_RD(x)      (HW_CCM_CSCMR2(x).U)
#define HW_CCM_CSCMR2_WR(x, v)   (HW_CCM_CSCMR2(x).U = (v))
#define HW_CCM_CSCMR2_SET(x, v)  (HW_CCM_CSCMR2_WR(x, HW_CCM_CSCMR2_RD(x) |  (v)))
#define HW_CCM_CSCMR2_CLR(x, v)  (HW_CCM_CSCMR2_WR(x, HW_CCM_CSCMR2_RD(x) & ~(v)))
#define HW_CCM_CSCMR2_TOG(x, v)  (HW_CCM_CSCMR2_WR(x, HW_CCM_CSCMR2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CSCMR2 bitfields
 */

/*!
 * @name Register CCM_CSCMR2, field can_clk_podf[7:2] (RW)
 *
 * Divider for can clock podf.
 *
 * Values:
 * - 000000 - divide by 1
 * - 000111 - divide by 8
 * - 111111 - divide by 2^6
 */
/*@{*/
#define BP_CCM_CSCMR2_can_clk_podf (2U)    /*!< Bit position for CCM_CSCMR2_can_clk_podf. */
#define BM_CCM_CSCMR2_can_clk_podf (0x000000FCU) /*!< Bit mask for CCM_CSCMR2_can_clk_podf. */
#define BS_CCM_CSCMR2_can_clk_podf (6U)    /*!< Bit field size in bits for CCM_CSCMR2_can_clk_podf. */

/*! @brief Read current value of the CCM_CSCMR2_can_clk_podf field. */
#define BR_CCM_CSCMR2_can_clk_podf(x) (HW_CCM_CSCMR2(x).B.can_clk_podf)

/*! @brief Format value for bitfield CCM_CSCMR2_can_clk_podf. */
#define BF_CCM_CSCMR2_can_clk_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCMR2_can_clk_podf) & BM_CCM_CSCMR2_can_clk_podf)

/*! @brief Set the can_clk_podf field to a new value. */
#define BW_CCM_CSCMR2_can_clk_podf(x, v) (HW_CCM_CSCMR2_WR(x, (HW_CCM_CSCMR2_RD(x) & ~BM_CCM_CSCMR2_can_clk_podf) | BF_CCM_CSCMR2_can_clk_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CSCMR2, field can_clk_sel[9:8] (RW)
 *
 * Selector for FlexCAN clock multiplexer
 *
 * Values:
 * - 00 - derive clock from pll3_sw_clk divided clock (60M)
 * - 01 - derive clock from osc_clk (24M)
 * - 10 - derive clock from pll3_sw_clk divided clock (80M)
 * - 11 - Disable FlexCAN clock
 */
/*@{*/
#define BP_CCM_CSCMR2_can_clk_sel (8U)     /*!< Bit position for CCM_CSCMR2_can_clk_sel. */
#define BM_CCM_CSCMR2_can_clk_sel (0x00000300U) /*!< Bit mask for CCM_CSCMR2_can_clk_sel. */
#define BS_CCM_CSCMR2_can_clk_sel (2U)     /*!< Bit field size in bits for CCM_CSCMR2_can_clk_sel. */

/*! @brief Read current value of the CCM_CSCMR2_can_clk_sel field. */
#define BR_CCM_CSCMR2_can_clk_sel(x) (HW_CCM_CSCMR2(x).B.can_clk_sel)

/*! @brief Format value for bitfield CCM_CSCMR2_can_clk_sel. */
#define BF_CCM_CSCMR2_can_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCMR2_can_clk_sel) & BM_CCM_CSCMR2_can_clk_sel)

/*! @brief Set the can_clk_sel field to a new value. */
#define BW_CCM_CSCMR2_can_clk_sel(x, v) (HW_CCM_CSCMR2_WR(x, (HW_CCM_CSCMR2_RD(x) & ~BM_CCM_CSCMR2_can_clk_sel) | BF_CCM_CSCMR2_can_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CSCMR2, field ldb_di0_div[10] (RW)
 *
 * Control for divider of ldb clock for di0
 *
 * Values:
 * - 0 - divide by 3.5
 * - 1 - divide by 7
 */
/*@{*/
#define BP_CCM_CSCMR2_ldb_di0_div (10U)    /*!< Bit position for CCM_CSCMR2_ldb_di0_div. */
#define BM_CCM_CSCMR2_ldb_di0_div (0x00000400U) /*!< Bit mask for CCM_CSCMR2_ldb_di0_div. */
#define BS_CCM_CSCMR2_ldb_di0_div (1U)     /*!< Bit field size in bits for CCM_CSCMR2_ldb_di0_div. */

/*! @brief Read current value of the CCM_CSCMR2_ldb_di0_div field. */
#define BR_CCM_CSCMR2_ldb_di0_div(x) (HW_CCM_CSCMR2(x).B.ldb_di0_div)

/*! @brief Format value for bitfield CCM_CSCMR2_ldb_di0_div. */
#define BF_CCM_CSCMR2_ldb_di0_div(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCMR2_ldb_di0_div) & BM_CCM_CSCMR2_ldb_di0_div)

/*! @brief Set the ldb_di0_div field to a new value. */
#define BW_CCM_CSCMR2_ldb_di0_div(x, v) (HW_CCM_CSCMR2_WR(x, (HW_CCM_CSCMR2_RD(x) & ~BM_CCM_CSCMR2_ldb_di0_div) | BF_CCM_CSCMR2_ldb_di0_div(v)))
/*@}*/

/*!
 * @name Register CCM_CSCMR2, field ldb_di1_div[11] (RW)
 *
 * Control for divider of ldb clock for di1
 *
 * Values:
 * - 0 - divide by 3.5
 * - 1 - divide by 7
 */
/*@{*/
#define BP_CCM_CSCMR2_ldb_di1_div (11U)    /*!< Bit position for CCM_CSCMR2_ldb_di1_div. */
#define BM_CCM_CSCMR2_ldb_di1_div (0x00000800U) /*!< Bit mask for CCM_CSCMR2_ldb_di1_div. */
#define BS_CCM_CSCMR2_ldb_di1_div (1U)     /*!< Bit field size in bits for CCM_CSCMR2_ldb_di1_div. */

/*! @brief Read current value of the CCM_CSCMR2_ldb_di1_div field. */
#define BR_CCM_CSCMR2_ldb_di1_div(x) (HW_CCM_CSCMR2(x).B.ldb_di1_div)

/*! @brief Format value for bitfield CCM_CSCMR2_ldb_di1_div. */
#define BF_CCM_CSCMR2_ldb_di1_div(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCMR2_ldb_di1_div) & BM_CCM_CSCMR2_ldb_di1_div)

/*! @brief Set the ldb_di1_div field to a new value. */
#define BW_CCM_CSCMR2_ldb_di1_div(x, v) (HW_CCM_CSCMR2_WR(x, (HW_CCM_CSCMR2_RD(x) & ~BM_CCM_CSCMR2_ldb_di1_div) | BF_CCM_CSCMR2_ldb_di1_div(v)))
/*@}*/

/*!
 * @name Register CCM_CSCMR2, field esai_clk_sel[20:19] (RW)
 *
 * Selector for esai clock multiplexer
 *
 * Values:
 * - 00 - derive clock from PLL4 clock
 * - 01 - derive clock from PLL3 PFD2 clock
 * - 10 - derive clock from PLL5 clock
 * - 11 - derive clock from pll3_sw_clk
 */
/*@{*/
#define BP_CCM_CSCMR2_esai_clk_sel (19U)   /*!< Bit position for CCM_CSCMR2_esai_clk_sel. */
#define BM_CCM_CSCMR2_esai_clk_sel (0x00180000U) /*!< Bit mask for CCM_CSCMR2_esai_clk_sel. */
#define BS_CCM_CSCMR2_esai_clk_sel (2U)    /*!< Bit field size in bits for CCM_CSCMR2_esai_clk_sel. */

/*! @brief Read current value of the CCM_CSCMR2_esai_clk_sel field. */
#define BR_CCM_CSCMR2_esai_clk_sel(x) (HW_CCM_CSCMR2(x).B.esai_clk_sel)

/*! @brief Format value for bitfield CCM_CSCMR2_esai_clk_sel. */
#define BF_CCM_CSCMR2_esai_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCMR2_esai_clk_sel) & BM_CCM_CSCMR2_esai_clk_sel)

/*! @brief Set the esai_clk_sel field to a new value. */
#define BW_CCM_CSCMR2_esai_clk_sel(x, v) (HW_CCM_CSCMR2_WR(x, (HW_CCM_CSCMR2_RD(x) & ~BM_CCM_CSCMR2_esai_clk_sel) | BF_CCM_CSCMR2_esai_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CSCMR2, field vid_clk_sel[23:21] (RW)
 *
 * Selector for vid clock multiplexer
 *
 * Values:
 * - 000 - PLL3 PFD1
 * - 001 - PLL3
 * - 010 - PLL3 PFD3
 * - 011 - PLL4
 * - 100 - PLL5
 */
/*@{*/
#define BP_CCM_CSCMR2_vid_clk_sel (21U)    /*!< Bit position for CCM_CSCMR2_vid_clk_sel. */
#define BM_CCM_CSCMR2_vid_clk_sel (0x00E00000U) /*!< Bit mask for CCM_CSCMR2_vid_clk_sel. */
#define BS_CCM_CSCMR2_vid_clk_sel (3U)     /*!< Bit field size in bits for CCM_CSCMR2_vid_clk_sel. */

/*! @brief Read current value of the CCM_CSCMR2_vid_clk_sel field. */
#define BR_CCM_CSCMR2_vid_clk_sel(x) (HW_CCM_CSCMR2(x).B.vid_clk_sel)

/*! @brief Format value for bitfield CCM_CSCMR2_vid_clk_sel. */
#define BF_CCM_CSCMR2_vid_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCMR2_vid_clk_sel) & BM_CCM_CSCMR2_vid_clk_sel)

/*! @brief Set the vid_clk_sel field to a new value. */
#define BW_CCM_CSCMR2_vid_clk_sel(x, v) (HW_CCM_CSCMR2_WR(x, (HW_CCM_CSCMR2_RD(x) & ~BM_CCM_CSCMR2_vid_clk_sel) | BF_CCM_CSCMR2_vid_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CSCMR2, field vid_clk_pre_podf[25:24] (RW)
 *
 * Post-divider for vid clock root
 *
 * Values:
 * - 00 - divide by 1
 * - 01 - divide by 2
 * - 10 - divide by 3
 * - 11 - divide by 4
 */
/*@{*/
#define BP_CCM_CSCMR2_vid_clk_pre_podf (24U) /*!< Bit position for CCM_CSCMR2_vid_clk_pre_podf. */
#define BM_CCM_CSCMR2_vid_clk_pre_podf (0x03000000U) /*!< Bit mask for CCM_CSCMR2_vid_clk_pre_podf. */
#define BS_CCM_CSCMR2_vid_clk_pre_podf (2U) /*!< Bit field size in bits for CCM_CSCMR2_vid_clk_pre_podf. */

/*! @brief Read current value of the CCM_CSCMR2_vid_clk_pre_podf field. */
#define BR_CCM_CSCMR2_vid_clk_pre_podf(x) (HW_CCM_CSCMR2(x).B.vid_clk_pre_podf)

/*! @brief Format value for bitfield CCM_CSCMR2_vid_clk_pre_podf. */
#define BF_CCM_CSCMR2_vid_clk_pre_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCMR2_vid_clk_pre_podf) & BM_CCM_CSCMR2_vid_clk_pre_podf)

/*! @brief Set the vid_clk_pre_podf field to a new value. */
#define BW_CCM_CSCMR2_vid_clk_pre_podf(x, v) (HW_CCM_CSCMR2_WR(x, (HW_CCM_CSCMR2_RD(x) & ~BM_CCM_CSCMR2_vid_clk_pre_podf) | BF_CCM_CSCMR2_vid_clk_pre_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CSCMR2, field vid_clk_podf[28:26] (RW)
 *
 * Post-divider for vid clock root
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CSCMR2_vid_clk_podf (26U)   /*!< Bit position for CCM_CSCMR2_vid_clk_podf. */
#define BM_CCM_CSCMR2_vid_clk_podf (0x1C000000U) /*!< Bit mask for CCM_CSCMR2_vid_clk_podf. */
#define BS_CCM_CSCMR2_vid_clk_podf (3U)    /*!< Bit field size in bits for CCM_CSCMR2_vid_clk_podf. */

/*! @brief Read current value of the CCM_CSCMR2_vid_clk_podf field. */
#define BR_CCM_CSCMR2_vid_clk_podf(x) (HW_CCM_CSCMR2(x).B.vid_clk_podf)

/*! @brief Format value for bitfield CCM_CSCMR2_vid_clk_podf. */
#define BF_CCM_CSCMR2_vid_clk_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCMR2_vid_clk_podf) & BM_CCM_CSCMR2_vid_clk_podf)

/*! @brief Set the vid_clk_podf field to a new value. */
#define BW_CCM_CSCMR2_vid_clk_podf(x, v) (HW_CCM_CSCMR2_WR(x, (HW_CCM_CSCMR2_RD(x) & ~BM_CCM_CSCMR2_vid_clk_podf) | BF_CCM_CSCMR2_vid_clk_podf(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CSCDR1 - CCM Serial Clock Divider Register 1
 ******************************************************************************/

/*!
 * @brief HW_CCM_CSCDR1 - CCM Serial Clock Divider Register 1 (RW)
 *
 * Reset value: 0x00490B00U
 *
 * The figure below represents the CCM Serial Clock Divider Register 1 (CSCDR1).
 * The CSCDR1 register contains bits to control the clock generation sub-module
 * dividers. The table below provides its field descriptions. Any change on the
 * above dividers will have to be done while the module that its clock is affected
 * is not functional and the affected clock is gated. If the change will be done
 * during operation of the module, then it is not guaranteed that the modules
 * operation will not be harmed.
 */
typedef union _hw_ccm_cscdr1
{
    uint32_t U;
    struct _hw_ccm_cscdr1_bitfields
    {
        uint32_t uart_clk_podf : 6;    /*!< [5:0]  */
        uint32_t uart_clk_sel : 1;     /*!< [6]  */
        uint32_t RESERVED0 : 4;        /*!< [10:7]  */
        uint32_t usdhc1_podf : 3;      /*!< [13:11]  */
        uint32_t RESERVED1 : 2;        /*!< [15:14]  */
        uint32_t usdhc2_podf : 3;      /*!< [18:16]  */
        uint32_t usdhc3_podf : 3;      /*!< [21:19]  */
        uint32_t usdhc4_podf : 3;      /*!< [24:22]  */
        uint32_t RESERVED2 : 7;        /*!< [31:25]  */
    } B;
} hw_ccm_cscdr1_t;

/*!
 * @name Constants and macros for entire CCM_CSCDR1 register
 */
/*@{*/
#define HW_CCM_CSCDR1_ADDR(x)    ((uintptr_t)(x) + 0x24U)

#define HW_CCM_CSCDR1(x)         (*(__IO hw_ccm_cscdr1_t *) HW_CCM_CSCDR1_ADDR(x))
#define HW_CCM_CSCDR1_RD(x)      (HW_CCM_CSCDR1(x).U)
#define HW_CCM_CSCDR1_WR(x, v)   (HW_CCM_CSCDR1(x).U = (v))
#define HW_CCM_CSCDR1_SET(x, v)  (HW_CCM_CSCDR1_WR(x, HW_CCM_CSCDR1_RD(x) |  (v)))
#define HW_CCM_CSCDR1_CLR(x, v)  (HW_CCM_CSCDR1_WR(x, HW_CCM_CSCDR1_RD(x) & ~(v)))
#define HW_CCM_CSCDR1_TOG(x, v)  (HW_CCM_CSCDR1_WR(x, HW_CCM_CSCDR1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CSCDR1 bitfields
 */

/*!
 * @name Register CCM_CSCDR1, field uart_clk_podf[5:0] (RW)
 *
 * Divider for uart clock podf.
 *
 * Values:
 * - 000000 - divide by 1
 * - 111111 - divide by 2^6
 */
/*@{*/
#define BP_CCM_CSCDR1_uart_clk_podf (0U)   /*!< Bit position for CCM_CSCDR1_uart_clk_podf. */
#define BM_CCM_CSCDR1_uart_clk_podf (0x0000003FU) /*!< Bit mask for CCM_CSCDR1_uart_clk_podf. */
#define BS_CCM_CSCDR1_uart_clk_podf (6U)   /*!< Bit field size in bits for CCM_CSCDR1_uart_clk_podf. */

/*! @brief Read current value of the CCM_CSCDR1_uart_clk_podf field. */
#define BR_CCM_CSCDR1_uart_clk_podf(x) (HW_CCM_CSCDR1(x).B.uart_clk_podf)

/*! @brief Format value for bitfield CCM_CSCDR1_uart_clk_podf. */
#define BF_CCM_CSCDR1_uart_clk_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCDR1_uart_clk_podf) & BM_CCM_CSCDR1_uart_clk_podf)

/*! @brief Set the uart_clk_podf field to a new value. */
#define BW_CCM_CSCDR1_uart_clk_podf(x, v) (HW_CCM_CSCDR1_WR(x, (HW_CCM_CSCDR1_RD(x) & ~BM_CCM_CSCDR1_uart_clk_podf) | BF_CCM_CSCDR1_uart_clk_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CSCDR1, field uart_clk_sel[6] (RW)
 *
 * Selector for the UART clock multiplexor
 *
 * Values:
 * - 0 - derive clock from pll3_80m
 * - 1 - derive clock from osc_clk
 */
/*@{*/
#define BP_CCM_CSCDR1_uart_clk_sel (6U)    /*!< Bit position for CCM_CSCDR1_uart_clk_sel. */
#define BM_CCM_CSCDR1_uart_clk_sel (0x00000040U) /*!< Bit mask for CCM_CSCDR1_uart_clk_sel. */
#define BS_CCM_CSCDR1_uart_clk_sel (1U)    /*!< Bit field size in bits for CCM_CSCDR1_uart_clk_sel. */

/*! @brief Read current value of the CCM_CSCDR1_uart_clk_sel field. */
#define BR_CCM_CSCDR1_uart_clk_sel(x) (HW_CCM_CSCDR1(x).B.uart_clk_sel)

/*! @brief Format value for bitfield CCM_CSCDR1_uart_clk_sel. */
#define BF_CCM_CSCDR1_uart_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCDR1_uart_clk_sel) & BM_CCM_CSCDR1_uart_clk_sel)

/*! @brief Set the uart_clk_sel field to a new value. */
#define BW_CCM_CSCDR1_uart_clk_sel(x, v) (HW_CCM_CSCDR1_WR(x, (HW_CCM_CSCDR1_RD(x) & ~BM_CCM_CSCDR1_uart_clk_sel) | BF_CCM_CSCDR1_uart_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CSCDR1, field usdhc1_podf[13:11] (RW)
 *
 * Divider for usdhc1 clock podf. Divider should be updated when output clock is
 * gated.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CSCDR1_usdhc1_podf (11U)    /*!< Bit position for CCM_CSCDR1_usdhc1_podf. */
#define BM_CCM_CSCDR1_usdhc1_podf (0x00003800U) /*!< Bit mask for CCM_CSCDR1_usdhc1_podf. */
#define BS_CCM_CSCDR1_usdhc1_podf (3U)     /*!< Bit field size in bits for CCM_CSCDR1_usdhc1_podf. */

/*! @brief Read current value of the CCM_CSCDR1_usdhc1_podf field. */
#define BR_CCM_CSCDR1_usdhc1_podf(x) (HW_CCM_CSCDR1(x).B.usdhc1_podf)

/*! @brief Format value for bitfield CCM_CSCDR1_usdhc1_podf. */
#define BF_CCM_CSCDR1_usdhc1_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCDR1_usdhc1_podf) & BM_CCM_CSCDR1_usdhc1_podf)

/*! @brief Set the usdhc1_podf field to a new value. */
#define BW_CCM_CSCDR1_usdhc1_podf(x, v) (HW_CCM_CSCDR1_WR(x, (HW_CCM_CSCDR1_RD(x) & ~BM_CCM_CSCDR1_usdhc1_podf) | BF_CCM_CSCDR1_usdhc1_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CSCDR1, field usdhc2_podf[18:16] (RW)
 *
 * Divider for usdhc2 clock. Divider should be updated when output clock is
 * gated.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CSCDR1_usdhc2_podf (16U)    /*!< Bit position for CCM_CSCDR1_usdhc2_podf. */
#define BM_CCM_CSCDR1_usdhc2_podf (0x00070000U) /*!< Bit mask for CCM_CSCDR1_usdhc2_podf. */
#define BS_CCM_CSCDR1_usdhc2_podf (3U)     /*!< Bit field size in bits for CCM_CSCDR1_usdhc2_podf. */

/*! @brief Read current value of the CCM_CSCDR1_usdhc2_podf field. */
#define BR_CCM_CSCDR1_usdhc2_podf(x) (HW_CCM_CSCDR1(x).B.usdhc2_podf)

/*! @brief Format value for bitfield CCM_CSCDR1_usdhc2_podf. */
#define BF_CCM_CSCDR1_usdhc2_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCDR1_usdhc2_podf) & BM_CCM_CSCDR1_usdhc2_podf)

/*! @brief Set the usdhc2_podf field to a new value. */
#define BW_CCM_CSCDR1_usdhc2_podf(x, v) (HW_CCM_CSCDR1_WR(x, (HW_CCM_CSCDR1_RD(x) & ~BM_CCM_CSCDR1_usdhc2_podf) | BF_CCM_CSCDR1_usdhc2_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CSCDR1, field usdhc3_podf[21:19] (RW)
 *
 * Divider for usdhc3 clock podf. Divider should be updated when output clock is
 * gated.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CSCDR1_usdhc3_podf (19U)    /*!< Bit position for CCM_CSCDR1_usdhc3_podf. */
#define BM_CCM_CSCDR1_usdhc3_podf (0x00380000U) /*!< Bit mask for CCM_CSCDR1_usdhc3_podf. */
#define BS_CCM_CSCDR1_usdhc3_podf (3U)     /*!< Bit field size in bits for CCM_CSCDR1_usdhc3_podf. */

/*! @brief Read current value of the CCM_CSCDR1_usdhc3_podf field. */
#define BR_CCM_CSCDR1_usdhc3_podf(x) (HW_CCM_CSCDR1(x).B.usdhc3_podf)

/*! @brief Format value for bitfield CCM_CSCDR1_usdhc3_podf. */
#define BF_CCM_CSCDR1_usdhc3_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCDR1_usdhc3_podf) & BM_CCM_CSCDR1_usdhc3_podf)

/*! @brief Set the usdhc3_podf field to a new value. */
#define BW_CCM_CSCDR1_usdhc3_podf(x, v) (HW_CCM_CSCDR1_WR(x, (HW_CCM_CSCDR1_RD(x) & ~BM_CCM_CSCDR1_usdhc3_podf) | BF_CCM_CSCDR1_usdhc3_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CSCDR1, field usdhc4_podf[24:22] (RW)
 *
 * Divider for usdhc4 clock pred. Divider should be updated when output clock is
 * gated.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CSCDR1_usdhc4_podf (22U)    /*!< Bit position for CCM_CSCDR1_usdhc4_podf. */
#define BM_CCM_CSCDR1_usdhc4_podf (0x01C00000U) /*!< Bit mask for CCM_CSCDR1_usdhc4_podf. */
#define BS_CCM_CSCDR1_usdhc4_podf (3U)     /*!< Bit field size in bits for CCM_CSCDR1_usdhc4_podf. */

/*! @brief Read current value of the CCM_CSCDR1_usdhc4_podf field. */
#define BR_CCM_CSCDR1_usdhc4_podf(x) (HW_CCM_CSCDR1(x).B.usdhc4_podf)

/*! @brief Format value for bitfield CCM_CSCDR1_usdhc4_podf. */
#define BF_CCM_CSCDR1_usdhc4_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCDR1_usdhc4_podf) & BM_CCM_CSCDR1_usdhc4_podf)

/*! @brief Set the usdhc4_podf field to a new value. */
#define BW_CCM_CSCDR1_usdhc4_podf(x, v) (HW_CCM_CSCDR1_WR(x, (HW_CCM_CSCDR1_RD(x) & ~BM_CCM_CSCDR1_usdhc4_podf) | BF_CCM_CSCDR1_usdhc4_podf(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CS1CDR - CCM SSI1 Clock Divider Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CS1CDR - CCM SSI1 Clock Divider Register (RW)
 *
 * Reset value: 0x0EC102C1U
 *
 * The figure below represents the CCM SSI1, SSI3, ESAI Clock Divider Register
 * (CS1CDR). The CS1CDR register contains bits to control the ssi1 clock
 * generation dividers. The table below provides its field descriptions.
 */
typedef union _hw_ccm_cs1cdr
{
    uint32_t U;
    struct _hw_ccm_cs1cdr_bitfields
    {
        uint32_t ssi1_clk_podf : 6;    /*!< [5:0]  */
        uint32_t ssi1_clk_pred : 3;    /*!< [8:6]  */
        uint32_t esai_clk_pred : 3;    /*!< [11:9]  */
        uint32_t RESERVED0 : 4;        /*!< [15:12]  */
        uint32_t ssi3_clk_podf : 6;    /*!< [21:16]  */
        uint32_t ssi3_clk_pred : 3;    /*!< [24:22]  */
        uint32_t esai_clk_podf : 3;    /*!< [27:25]  */
        uint32_t RESERVED1 : 4;        /*!< [31:28]  */
    } B;
} hw_ccm_cs1cdr_t;

/*!
 * @name Constants and macros for entire CCM_CS1CDR register
 */
/*@{*/
#define HW_CCM_CS1CDR_ADDR(x)    ((uintptr_t)(x) + 0x28U)

#define HW_CCM_CS1CDR(x)         (*(__IO hw_ccm_cs1cdr_t *) HW_CCM_CS1CDR_ADDR(x))
#define HW_CCM_CS1CDR_RD(x)      (HW_CCM_CS1CDR(x).U)
#define HW_CCM_CS1CDR_WR(x, v)   (HW_CCM_CS1CDR(x).U = (v))
#define HW_CCM_CS1CDR_SET(x, v)  (HW_CCM_CS1CDR_WR(x, HW_CCM_CS1CDR_RD(x) |  (v)))
#define HW_CCM_CS1CDR_CLR(x, v)  (HW_CCM_CS1CDR_WR(x, HW_CCM_CS1CDR_RD(x) & ~(v)))
#define HW_CCM_CS1CDR_TOG(x, v)  (HW_CCM_CS1CDR_WR(x, HW_CCM_CS1CDR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CS1CDR bitfields
 */

/*!
 * @name Register CCM_CS1CDR, field ssi1_clk_podf[5:0] (RW)
 *
 * Divider for ssi1 clock podf. The input clock to this divider should be lower
 * than 300Mhz, the predivider can be used to achieve this.
 *
 * Values:
 * - 000000 - divide by 1
 * - 111111 - divide by 2^6
 */
/*@{*/
#define BP_CCM_CS1CDR_ssi1_clk_podf (0U)   /*!< Bit position for CCM_CS1CDR_ssi1_clk_podf. */
#define BM_CCM_CS1CDR_ssi1_clk_podf (0x0000003FU) /*!< Bit mask for CCM_CS1CDR_ssi1_clk_podf. */
#define BS_CCM_CS1CDR_ssi1_clk_podf (6U)   /*!< Bit field size in bits for CCM_CS1CDR_ssi1_clk_podf. */

/*! @brief Read current value of the CCM_CS1CDR_ssi1_clk_podf field. */
#define BR_CCM_CS1CDR_ssi1_clk_podf(x) (HW_CCM_CS1CDR(x).B.ssi1_clk_podf)

/*! @brief Format value for bitfield CCM_CS1CDR_ssi1_clk_podf. */
#define BF_CCM_CS1CDR_ssi1_clk_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CS1CDR_ssi1_clk_podf) & BM_CCM_CS1CDR_ssi1_clk_podf)

/*! @brief Set the ssi1_clk_podf field to a new value. */
#define BW_CCM_CS1CDR_ssi1_clk_podf(x, v) (HW_CCM_CS1CDR_WR(x, (HW_CCM_CS1CDR_RD(x) & ~BM_CCM_CS1CDR_ssi1_clk_podf) | BF_CCM_CS1CDR_ssi1_clk_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CS1CDR, field ssi1_clk_pred[8:6] (RW)
 *
 * Divider for ssi1 clock pred.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CS1CDR_ssi1_clk_pred (6U)   /*!< Bit position for CCM_CS1CDR_ssi1_clk_pred. */
#define BM_CCM_CS1CDR_ssi1_clk_pred (0x000001C0U) /*!< Bit mask for CCM_CS1CDR_ssi1_clk_pred. */
#define BS_CCM_CS1CDR_ssi1_clk_pred (3U)   /*!< Bit field size in bits for CCM_CS1CDR_ssi1_clk_pred. */

/*! @brief Read current value of the CCM_CS1CDR_ssi1_clk_pred field. */
#define BR_CCM_CS1CDR_ssi1_clk_pred(x) (HW_CCM_CS1CDR(x).B.ssi1_clk_pred)

/*! @brief Format value for bitfield CCM_CS1CDR_ssi1_clk_pred. */
#define BF_CCM_CS1CDR_ssi1_clk_pred(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CS1CDR_ssi1_clk_pred) & BM_CCM_CS1CDR_ssi1_clk_pred)

/*! @brief Set the ssi1_clk_pred field to a new value. */
#define BW_CCM_CS1CDR_ssi1_clk_pred(x, v) (HW_CCM_CS1CDR_WR(x, (HW_CCM_CS1CDR_RD(x) & ~BM_CCM_CS1CDR_ssi1_clk_pred) | BF_CCM_CS1CDR_ssi1_clk_pred(v)))
/*@}*/

/*!
 * @name Register CCM_CS1CDR, field esai_clk_pred[11:9] (RW)
 *
 * Divider for esai clock pred.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CS1CDR_esai_clk_pred (9U)   /*!< Bit position for CCM_CS1CDR_esai_clk_pred. */
#define BM_CCM_CS1CDR_esai_clk_pred (0x00000E00U) /*!< Bit mask for CCM_CS1CDR_esai_clk_pred. */
#define BS_CCM_CS1CDR_esai_clk_pred (3U)   /*!< Bit field size in bits for CCM_CS1CDR_esai_clk_pred. */

/*! @brief Read current value of the CCM_CS1CDR_esai_clk_pred field. */
#define BR_CCM_CS1CDR_esai_clk_pred(x) (HW_CCM_CS1CDR(x).B.esai_clk_pred)

/*! @brief Format value for bitfield CCM_CS1CDR_esai_clk_pred. */
#define BF_CCM_CS1CDR_esai_clk_pred(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CS1CDR_esai_clk_pred) & BM_CCM_CS1CDR_esai_clk_pred)

/*! @brief Set the esai_clk_pred field to a new value. */
#define BW_CCM_CS1CDR_esai_clk_pred(x, v) (HW_CCM_CS1CDR_WR(x, (HW_CCM_CS1CDR_RD(x) & ~BM_CCM_CS1CDR_esai_clk_pred) | BF_CCM_CS1CDR_esai_clk_pred(v)))
/*@}*/

/*!
 * @name Register CCM_CS1CDR, field ssi3_clk_podf[21:16] (RW)
 *
 * Divider for ssi3 clock podf. The input clock to this divider should be lower
 * than 300Mhz, the predivider can be used to achieve this.
 *
 * Values:
 * - 000000 - divide by 1
 * - 111111 - divide by 2^6
 */
/*@{*/
#define BP_CCM_CS1CDR_ssi3_clk_podf (16U)  /*!< Bit position for CCM_CS1CDR_ssi3_clk_podf. */
#define BM_CCM_CS1CDR_ssi3_clk_podf (0x003F0000U) /*!< Bit mask for CCM_CS1CDR_ssi3_clk_podf. */
#define BS_CCM_CS1CDR_ssi3_clk_podf (6U)   /*!< Bit field size in bits for CCM_CS1CDR_ssi3_clk_podf. */

/*! @brief Read current value of the CCM_CS1CDR_ssi3_clk_podf field. */
#define BR_CCM_CS1CDR_ssi3_clk_podf(x) (HW_CCM_CS1CDR(x).B.ssi3_clk_podf)

/*! @brief Format value for bitfield CCM_CS1CDR_ssi3_clk_podf. */
#define BF_CCM_CS1CDR_ssi3_clk_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CS1CDR_ssi3_clk_podf) & BM_CCM_CS1CDR_ssi3_clk_podf)

/*! @brief Set the ssi3_clk_podf field to a new value. */
#define BW_CCM_CS1CDR_ssi3_clk_podf(x, v) (HW_CCM_CS1CDR_WR(x, (HW_CCM_CS1CDR_RD(x) & ~BM_CCM_CS1CDR_ssi3_clk_podf) | BF_CCM_CS1CDR_ssi3_clk_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CS1CDR, field ssi3_clk_pred[24:22] (RW)
 *
 * Divider for ssi3 clock pred.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CS1CDR_ssi3_clk_pred (22U)  /*!< Bit position for CCM_CS1CDR_ssi3_clk_pred. */
#define BM_CCM_CS1CDR_ssi3_clk_pred (0x01C00000U) /*!< Bit mask for CCM_CS1CDR_ssi3_clk_pred. */
#define BS_CCM_CS1CDR_ssi3_clk_pred (3U)   /*!< Bit field size in bits for CCM_CS1CDR_ssi3_clk_pred. */

/*! @brief Read current value of the CCM_CS1CDR_ssi3_clk_pred field. */
#define BR_CCM_CS1CDR_ssi3_clk_pred(x) (HW_CCM_CS1CDR(x).B.ssi3_clk_pred)

/*! @brief Format value for bitfield CCM_CS1CDR_ssi3_clk_pred. */
#define BF_CCM_CS1CDR_ssi3_clk_pred(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CS1CDR_ssi3_clk_pred) & BM_CCM_CS1CDR_ssi3_clk_pred)

/*! @brief Set the ssi3_clk_pred field to a new value. */
#define BW_CCM_CS1CDR_ssi3_clk_pred(x, v) (HW_CCM_CS1CDR_WR(x, (HW_CCM_CS1CDR_RD(x) & ~BM_CCM_CS1CDR_ssi3_clk_pred) | BF_CCM_CS1CDR_ssi3_clk_pred(v)))
/*@}*/

/*!
 * @name Register CCM_CS1CDR, field esai_clk_podf[27:25] (RW)
 *
 * Divider for esai clock podf.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CS1CDR_esai_clk_podf (25U)  /*!< Bit position for CCM_CS1CDR_esai_clk_podf. */
#define BM_CCM_CS1CDR_esai_clk_podf (0x0E000000U) /*!< Bit mask for CCM_CS1CDR_esai_clk_podf. */
#define BS_CCM_CS1CDR_esai_clk_podf (3U)   /*!< Bit field size in bits for CCM_CS1CDR_esai_clk_podf. */

/*! @brief Read current value of the CCM_CS1CDR_esai_clk_podf field. */
#define BR_CCM_CS1CDR_esai_clk_podf(x) (HW_CCM_CS1CDR(x).B.esai_clk_podf)

/*! @brief Format value for bitfield CCM_CS1CDR_esai_clk_podf. */
#define BF_CCM_CS1CDR_esai_clk_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CS1CDR_esai_clk_podf) & BM_CCM_CS1CDR_esai_clk_podf)

/*! @brief Set the esai_clk_podf field to a new value. */
#define BW_CCM_CS1CDR_esai_clk_podf(x, v) (HW_CCM_CS1CDR_WR(x, (HW_CCM_CS1CDR_RD(x) & ~BM_CCM_CS1CDR_esai_clk_podf) | BF_CCM_CS1CDR_esai_clk_podf(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CS2CDR - CCM SSI2 Clock Divider Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CS2CDR - CCM SSI2 Clock Divider Register (RW)
 *
 * Reset value: 0x000336C1U
 *
 * The figure below represents the CCM SSI2, LDB Clock Divider Register
 * (CS2CDR). The CS2CDR register contains bits to control the ssi2 clock generation
 * dividers, and ldb serial clocks select. The table below provides its field
 * descriptions.
 */
typedef union _hw_ccm_cs2cdr
{
    uint32_t U;
    struct _hw_ccm_cs2cdr_bitfields
    {
        uint32_t ssi2_clk_podf : 6;    /*!< [5:0]  */
        uint32_t ssi2_clk_pred : 3;    /*!< [8:6]  */
        uint32_t ldb_di0_clk_sel : 3;  /*!< [11:9]  */
        uint32_t ldb_di1_clk_sel : 3;  /*!< [14:12]  */
        uint32_t qspi2_clk_sel : 3;    /*!< [17:15]  */
        uint32_t qspi2_clk_pred : 3;   /*!< [20:18]  */
        uint32_t qspi2_clk_podf : 6;   /*!< [26:21]  */
        uint32_t RESERVED0 : 5;        /*!< [31:27]  */
    } B;
} hw_ccm_cs2cdr_t;

/*!
 * @name Constants and macros for entire CCM_CS2CDR register
 */
/*@{*/
#define HW_CCM_CS2CDR_ADDR(x)    ((uintptr_t)(x) + 0x2CU)

#define HW_CCM_CS2CDR(x)         (*(__IO hw_ccm_cs2cdr_t *) HW_CCM_CS2CDR_ADDR(x))
#define HW_CCM_CS2CDR_RD(x)      (HW_CCM_CS2CDR(x).U)
#define HW_CCM_CS2CDR_WR(x, v)   (HW_CCM_CS2CDR(x).U = (v))
#define HW_CCM_CS2CDR_SET(x, v)  (HW_CCM_CS2CDR_WR(x, HW_CCM_CS2CDR_RD(x) |  (v)))
#define HW_CCM_CS2CDR_CLR(x, v)  (HW_CCM_CS2CDR_WR(x, HW_CCM_CS2CDR_RD(x) & ~(v)))
#define HW_CCM_CS2CDR_TOG(x, v)  (HW_CCM_CS2CDR_WR(x, HW_CCM_CS2CDR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CS2CDR bitfields
 */

/*!
 * @name Register CCM_CS2CDR, field ssi2_clk_podf[5:0] (RW)
 *
 * Divider for ssi2 clock podf. The input clock to this divider should be lower
 * than 300Mhz, the predivider can be used to achieve this.Divider should be
 * updated when output clock is gated.
 *
 * Values:
 * - 000000 - divide by 1
 * - 111111 - divide by 2^6
 */
/*@{*/
#define BP_CCM_CS2CDR_ssi2_clk_podf (0U)   /*!< Bit position for CCM_CS2CDR_ssi2_clk_podf. */
#define BM_CCM_CS2CDR_ssi2_clk_podf (0x0000003FU) /*!< Bit mask for CCM_CS2CDR_ssi2_clk_podf. */
#define BS_CCM_CS2CDR_ssi2_clk_podf (6U)   /*!< Bit field size in bits for CCM_CS2CDR_ssi2_clk_podf. */

/*! @brief Read current value of the CCM_CS2CDR_ssi2_clk_podf field. */
#define BR_CCM_CS2CDR_ssi2_clk_podf(x) (HW_CCM_CS2CDR(x).B.ssi2_clk_podf)

/*! @brief Format value for bitfield CCM_CS2CDR_ssi2_clk_podf. */
#define BF_CCM_CS2CDR_ssi2_clk_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CS2CDR_ssi2_clk_podf) & BM_CCM_CS2CDR_ssi2_clk_podf)

/*! @brief Set the ssi2_clk_podf field to a new value. */
#define BW_CCM_CS2CDR_ssi2_clk_podf(x, v) (HW_CCM_CS2CDR_WR(x, (HW_CCM_CS2CDR_RD(x) & ~BM_CCM_CS2CDR_ssi2_clk_podf) | BF_CCM_CS2CDR_ssi2_clk_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CS2CDR, field ssi2_clk_pred[8:6] (RW)
 *
 * Divider for ssi2 clock pred.Divider should be updated when output clock is
 * gated.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CS2CDR_ssi2_clk_pred (6U)   /*!< Bit position for CCM_CS2CDR_ssi2_clk_pred. */
#define BM_CCM_CS2CDR_ssi2_clk_pred (0x000001C0U) /*!< Bit mask for CCM_CS2CDR_ssi2_clk_pred. */
#define BS_CCM_CS2CDR_ssi2_clk_pred (3U)   /*!< Bit field size in bits for CCM_CS2CDR_ssi2_clk_pred. */

/*! @brief Read current value of the CCM_CS2CDR_ssi2_clk_pred field. */
#define BR_CCM_CS2CDR_ssi2_clk_pred(x) (HW_CCM_CS2CDR(x).B.ssi2_clk_pred)

/*! @brief Format value for bitfield CCM_CS2CDR_ssi2_clk_pred. */
#define BF_CCM_CS2CDR_ssi2_clk_pred(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CS2CDR_ssi2_clk_pred) & BM_CCM_CS2CDR_ssi2_clk_pred)

/*! @brief Set the ssi2_clk_pred field to a new value. */
#define BW_CCM_CS2CDR_ssi2_clk_pred(x, v) (HW_CCM_CS2CDR_WR(x, (HW_CCM_CS2CDR_RD(x) & ~BM_CCM_CS2CDR_ssi2_clk_pred) | BF_CCM_CS2CDR_ssi2_clk_pred(v)))
/*@}*/

/*!
 * @name Register CCM_CS2CDR, field ldb_di0_clk_sel[11:9] (RW)
 *
 * Selector for ldb_di1 clock multiplexerMultiplexor should be updated when both
 * input and output clocks are gated.
 *
 * Values:
 * - 000 - PLL5 clock
 * - 001 - PLL2 PFD0
 * - 010 - PLL2 PFD2
 * - 011 - PLL2 PFD3
 * - 100 - PLL2 PFD1
 * - 101 - PLL3 PFD3
 * - 110 - Reserved
 * - 111 - Reserved
 */
/*@{*/
#define BP_CCM_CS2CDR_ldb_di0_clk_sel (9U) /*!< Bit position for CCM_CS2CDR_ldb_di0_clk_sel. */
#define BM_CCM_CS2CDR_ldb_di0_clk_sel (0x00000E00U) /*!< Bit mask for CCM_CS2CDR_ldb_di0_clk_sel. */
#define BS_CCM_CS2CDR_ldb_di0_clk_sel (3U) /*!< Bit field size in bits for CCM_CS2CDR_ldb_di0_clk_sel. */

/*! @brief Read current value of the CCM_CS2CDR_ldb_di0_clk_sel field. */
#define BR_CCM_CS2CDR_ldb_di0_clk_sel(x) (HW_CCM_CS2CDR(x).B.ldb_di0_clk_sel)

/*! @brief Format value for bitfield CCM_CS2CDR_ldb_di0_clk_sel. */
#define BF_CCM_CS2CDR_ldb_di0_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CS2CDR_ldb_di0_clk_sel) & BM_CCM_CS2CDR_ldb_di0_clk_sel)

/*! @brief Set the ldb_di0_clk_sel field to a new value. */
#define BW_CCM_CS2CDR_ldb_di0_clk_sel(x, v) (HW_CCM_CS2CDR_WR(x, (HW_CCM_CS2CDR_RD(x) & ~BM_CCM_CS2CDR_ldb_di0_clk_sel) | BF_CCM_CS2CDR_ldb_di0_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CS2CDR, field ldb_di1_clk_sel[14:12] (RW)
 *
 * Selector for ldb_di1 clock multiplexerMultiplexor should be updated when both
 * input and output clocks are gated.
 *
 * Values:
 * - 000 - derive clock from pll3_sw_clk
 * - 001 - derive clock from PLL2 PFD0
 * - 010 - derive clock from PLL2 PFD2
 * - 011 - derive clock from PLL2
 * - 100 - derive clock from PLL3 PFD3
 * - 101 - derive clock from PLL3 PFD2
 * - 110 - Reserved
 * - 111 - Reserved
 */
/*@{*/
#define BP_CCM_CS2CDR_ldb_di1_clk_sel (12U) /*!< Bit position for CCM_CS2CDR_ldb_di1_clk_sel. */
#define BM_CCM_CS2CDR_ldb_di1_clk_sel (0x00007000U) /*!< Bit mask for CCM_CS2CDR_ldb_di1_clk_sel. */
#define BS_CCM_CS2CDR_ldb_di1_clk_sel (3U) /*!< Bit field size in bits for CCM_CS2CDR_ldb_di1_clk_sel. */

/*! @brief Read current value of the CCM_CS2CDR_ldb_di1_clk_sel field. */
#define BR_CCM_CS2CDR_ldb_di1_clk_sel(x) (HW_CCM_CS2CDR(x).B.ldb_di1_clk_sel)

/*! @brief Format value for bitfield CCM_CS2CDR_ldb_di1_clk_sel. */
#define BF_CCM_CS2CDR_ldb_di1_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CS2CDR_ldb_di1_clk_sel) & BM_CCM_CS2CDR_ldb_di1_clk_sel)

/*! @brief Set the ldb_di1_clk_sel field to a new value. */
#define BW_CCM_CS2CDR_ldb_di1_clk_sel(x, v) (HW_CCM_CS2CDR_WR(x, (HW_CCM_CS2CDR_RD(x) & ~BM_CCM_CS2CDR_ldb_di1_clk_sel) | BF_CCM_CS2CDR_ldb_di1_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CS2CDR, field qspi2_clk_sel[17:15] (RW)
 *
 * Selector for QSPI2 clock multiplexer
 *
 * Values:
 * - 000 - derive clock from PLL2 PFD0
 * - 001 - derive clock from PLL2
 * - 010 - derive clock from pll3_sw_clk
 * - 011 - derive clock from PLL2 PFD2
 * - 100 - derive clock from PLL3 PFD3
 * - 110 - Reserved
 * - 111 - Reserved
 */
/*@{*/
#define BP_CCM_CS2CDR_qspi2_clk_sel (15U)  /*!< Bit position for CCM_CS2CDR_qspi2_clk_sel. */
#define BM_CCM_CS2CDR_qspi2_clk_sel (0x00038000U) /*!< Bit mask for CCM_CS2CDR_qspi2_clk_sel. */
#define BS_CCM_CS2CDR_qspi2_clk_sel (3U)   /*!< Bit field size in bits for CCM_CS2CDR_qspi2_clk_sel. */

/*! @brief Read current value of the CCM_CS2CDR_qspi2_clk_sel field. */
#define BR_CCM_CS2CDR_qspi2_clk_sel(x) (HW_CCM_CS2CDR(x).B.qspi2_clk_sel)

/*! @brief Format value for bitfield CCM_CS2CDR_qspi2_clk_sel. */
#define BF_CCM_CS2CDR_qspi2_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CS2CDR_qspi2_clk_sel) & BM_CCM_CS2CDR_qspi2_clk_sel)

/*! @brief Set the qspi2_clk_sel field to a new value. */
#define BW_CCM_CS2CDR_qspi2_clk_sel(x, v) (HW_CCM_CS2CDR_WR(x, (HW_CCM_CS2CDR_RD(x) & ~BM_CCM_CS2CDR_qspi2_clk_sel) | BF_CCM_CS2CDR_qspi2_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CS2CDR, field qspi2_clk_pred[20:18] (RW)
 *
 * Divider for QSPI1 clock pred divider.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CS2CDR_qspi2_clk_pred (18U) /*!< Bit position for CCM_CS2CDR_qspi2_clk_pred. */
#define BM_CCM_CS2CDR_qspi2_clk_pred (0x001C0000U) /*!< Bit mask for CCM_CS2CDR_qspi2_clk_pred. */
#define BS_CCM_CS2CDR_qspi2_clk_pred (3U)  /*!< Bit field size in bits for CCM_CS2CDR_qspi2_clk_pred. */

/*! @brief Read current value of the CCM_CS2CDR_qspi2_clk_pred field. */
#define BR_CCM_CS2CDR_qspi2_clk_pred(x) (HW_CCM_CS2CDR(x).B.qspi2_clk_pred)

/*! @brief Format value for bitfield CCM_CS2CDR_qspi2_clk_pred. */
#define BF_CCM_CS2CDR_qspi2_clk_pred(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CS2CDR_qspi2_clk_pred) & BM_CCM_CS2CDR_qspi2_clk_pred)

/*! @brief Set the qspi2_clk_pred field to a new value. */
#define BW_CCM_CS2CDR_qspi2_clk_pred(x, v) (HW_CCM_CS2CDR_WR(x, (HW_CCM_CS2CDR_RD(x) & ~BM_CCM_CS2CDR_qspi2_clk_pred) | BF_CCM_CS2CDR_qspi2_clk_pred(v)))
/*@}*/

/*!
 * @name Register CCM_CS2CDR, field qspi2_clk_podf[26:21] (RW)
 *
 * Divider for QSPI2 clock divider.
 *
 * Values:
 * - 000000 - divide by 1
 * - 000001 - divide by 2
 * - 111111 - divide by 2^6
 */
/*@{*/
#define BP_CCM_CS2CDR_qspi2_clk_podf (21U) /*!< Bit position for CCM_CS2CDR_qspi2_clk_podf. */
#define BM_CCM_CS2CDR_qspi2_clk_podf (0x07E00000U) /*!< Bit mask for CCM_CS2CDR_qspi2_clk_podf. */
#define BS_CCM_CS2CDR_qspi2_clk_podf (6U)  /*!< Bit field size in bits for CCM_CS2CDR_qspi2_clk_podf. */

/*! @brief Read current value of the CCM_CS2CDR_qspi2_clk_podf field. */
#define BR_CCM_CS2CDR_qspi2_clk_podf(x) (HW_CCM_CS2CDR(x).B.qspi2_clk_podf)

/*! @brief Format value for bitfield CCM_CS2CDR_qspi2_clk_podf. */
#define BF_CCM_CS2CDR_qspi2_clk_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CS2CDR_qspi2_clk_podf) & BM_CCM_CS2CDR_qspi2_clk_podf)

/*! @brief Set the qspi2_clk_podf field to a new value. */
#define BW_CCM_CS2CDR_qspi2_clk_podf(x, v) (HW_CCM_CS2CDR_WR(x, (HW_CCM_CS2CDR_RD(x) & ~BM_CCM_CS2CDR_qspi2_clk_podf) | BF_CCM_CS2CDR_qspi2_clk_podf(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CDCDR - CCM D1 Clock Divider Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CDCDR - CCM D1 Clock Divider Register (RW)
 *
 * Reset value: 0x33F71F92U
 *
 * The figure below represents the CCM DI Clock Divider Register (CDCDR). The
 * table below provides its field descriptions.
 */
typedef union _hw_ccm_cdcdr
{
    uint32_t U;
    struct _hw_ccm_cdcdr_bitfields
    {
        uint32_t RESERVED0 : 7;        /*!< [6:0]  */
        uint32_t audio_clk_sel : 2;    /*!< [8:7]  */
        uint32_t audio_clk_podf : 3;   /*!< [11:9]  */
        uint32_t audio_clk_pred : 3;   /*!< [14:12]  */
        uint32_t RESERVED1 : 5;        /*!< [19:15]  */
        uint32_t spdif0_clk_sel : 2;   /*!< [21:20]  */
        uint32_t spdif0_clk_podf : 3;  /*!< [24:22]  */
        uint32_t spdif0_clk_pred : 3;  /*!< [27:25]  */
        uint32_t RESERVED2 : 4;        /*!< [31:28]  */
    } B;
} hw_ccm_cdcdr_t;

/*!
 * @name Constants and macros for entire CCM_CDCDR register
 */
/*@{*/
#define HW_CCM_CDCDR_ADDR(x)     ((uintptr_t)(x) + 0x30U)

#define HW_CCM_CDCDR(x)          (*(__IO hw_ccm_cdcdr_t *) HW_CCM_CDCDR_ADDR(x))
#define HW_CCM_CDCDR_RD(x)       (HW_CCM_CDCDR(x).U)
#define HW_CCM_CDCDR_WR(x, v)    (HW_CCM_CDCDR(x).U = (v))
#define HW_CCM_CDCDR_SET(x, v)   (HW_CCM_CDCDR_WR(x, HW_CCM_CDCDR_RD(x) |  (v)))
#define HW_CCM_CDCDR_CLR(x, v)   (HW_CCM_CDCDR_WR(x, HW_CCM_CDCDR_RD(x) & ~(v)))
#define HW_CCM_CDCDR_TOG(x, v)   (HW_CCM_CDCDR_WR(x, HW_CCM_CDCDR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CDCDR bitfields
 */

/*!
 * @name Register CCM_CDCDR, field audio_clk_sel[8:7] (RW)
 *
 * Selector for audio clock multiplexer
 *
 * Values:
 * - 00 - derive clock from PLL4
 * - 01 - derive clock from PLL3 PFD2
 * - 10 - derive clock from PLL5
 * - 11 - derive clock from PLL3
 */
/*@{*/
#define BP_CCM_CDCDR_audio_clk_sel (7U)    /*!< Bit position for CCM_CDCDR_audio_clk_sel. */
#define BM_CCM_CDCDR_audio_clk_sel (0x00000180U) /*!< Bit mask for CCM_CDCDR_audio_clk_sel. */
#define BS_CCM_CDCDR_audio_clk_sel (2U)    /*!< Bit field size in bits for CCM_CDCDR_audio_clk_sel. */

/*! @brief Read current value of the CCM_CDCDR_audio_clk_sel field. */
#define BR_CCM_CDCDR_audio_clk_sel(x) (HW_CCM_CDCDR(x).B.audio_clk_sel)

/*! @brief Format value for bitfield CCM_CDCDR_audio_clk_sel. */
#define BF_CCM_CDCDR_audio_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CDCDR_audio_clk_sel) & BM_CCM_CDCDR_audio_clk_sel)

/*! @brief Set the audio_clk_sel field to a new value. */
#define BW_CCM_CDCDR_audio_clk_sel(x, v) (HW_CCM_CDCDR_WR(x, (HW_CCM_CDCDR_RD(x) & ~BM_CCM_CDCDR_audio_clk_sel) | BF_CCM_CDCDR_audio_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CDCDR, field audio_clk_podf[11:9] (RW)
 *
 * Divider for audio clock podf. Divider should be updated when output clock is
 * gated.
 *
 * Values:
 * - 000 - divide by 1
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CDCDR_audio_clk_podf (9U)   /*!< Bit position for CCM_CDCDR_audio_clk_podf. */
#define BM_CCM_CDCDR_audio_clk_podf (0x00000E00U) /*!< Bit mask for CCM_CDCDR_audio_clk_podf. */
#define BS_CCM_CDCDR_audio_clk_podf (3U)   /*!< Bit field size in bits for CCM_CDCDR_audio_clk_podf. */

/*! @brief Read current value of the CCM_CDCDR_audio_clk_podf field. */
#define BR_CCM_CDCDR_audio_clk_podf(x) (HW_CCM_CDCDR(x).B.audio_clk_podf)

/*! @brief Format value for bitfield CCM_CDCDR_audio_clk_podf. */
#define BF_CCM_CDCDR_audio_clk_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CDCDR_audio_clk_podf) & BM_CCM_CDCDR_audio_clk_podf)

/*! @brief Set the audio_clk_podf field to a new value. */
#define BW_CCM_CDCDR_audio_clk_podf(x, v) (HW_CCM_CDCDR_WR(x, (HW_CCM_CDCDR_RD(x) & ~BM_CCM_CDCDR_audio_clk_podf) | BF_CCM_CDCDR_audio_clk_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CDCDR, field audio_clk_pred[14:12] (RW)
 *
 * Divider for audio clock pred. Divider should be updated when output clock is
 * gated.
 *
 * Values:
 * - 000 - divide by 1 (do not use with high input frequencies)
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CDCDR_audio_clk_pred (12U)  /*!< Bit position for CCM_CDCDR_audio_clk_pred. */
#define BM_CCM_CDCDR_audio_clk_pred (0x00007000U) /*!< Bit mask for CCM_CDCDR_audio_clk_pred. */
#define BS_CCM_CDCDR_audio_clk_pred (3U)   /*!< Bit field size in bits for CCM_CDCDR_audio_clk_pred. */

/*! @brief Read current value of the CCM_CDCDR_audio_clk_pred field. */
#define BR_CCM_CDCDR_audio_clk_pred(x) (HW_CCM_CDCDR(x).B.audio_clk_pred)

/*! @brief Format value for bitfield CCM_CDCDR_audio_clk_pred. */
#define BF_CCM_CDCDR_audio_clk_pred(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CDCDR_audio_clk_pred) & BM_CCM_CDCDR_audio_clk_pred)

/*! @brief Set the audio_clk_pred field to a new value. */
#define BW_CCM_CDCDR_audio_clk_pred(x, v) (HW_CCM_CDCDR_WR(x, (HW_CCM_CDCDR_RD(x) & ~BM_CCM_CDCDR_audio_clk_pred) | BF_CCM_CDCDR_audio_clk_pred(v)))
/*@}*/

/*!
 * @name Register CCM_CDCDR, field spdif0_clk_sel[21:20] (RW)
 *
 * Selector for spdif0 clock multiplexer
 *
 * Values:
 * - 00 - derive clock from PLL4
 * - 01 - derive clock from PLL3 PFD2
 * - 10 - derive clock from PLL5
 * - 11 - derive clock from pll3_sw_clk
 */
/*@{*/
#define BP_CCM_CDCDR_spdif0_clk_sel (20U)  /*!< Bit position for CCM_CDCDR_spdif0_clk_sel. */
#define BM_CCM_CDCDR_spdif0_clk_sel (0x00300000U) /*!< Bit mask for CCM_CDCDR_spdif0_clk_sel. */
#define BS_CCM_CDCDR_spdif0_clk_sel (2U)   /*!< Bit field size in bits for CCM_CDCDR_spdif0_clk_sel. */

/*! @brief Read current value of the CCM_CDCDR_spdif0_clk_sel field. */
#define BR_CCM_CDCDR_spdif0_clk_sel(x) (HW_CCM_CDCDR(x).B.spdif0_clk_sel)

/*! @brief Format value for bitfield CCM_CDCDR_spdif0_clk_sel. */
#define BF_CCM_CDCDR_spdif0_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CDCDR_spdif0_clk_sel) & BM_CCM_CDCDR_spdif0_clk_sel)

/*! @brief Set the spdif0_clk_sel field to a new value. */
#define BW_CCM_CDCDR_spdif0_clk_sel(x, v) (HW_CCM_CDCDR_WR(x, (HW_CCM_CDCDR_RD(x) & ~BM_CCM_CDCDR_spdif0_clk_sel) | BF_CCM_CDCDR_spdif0_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CDCDR, field spdif0_clk_podf[24:22] (RW)
 *
 * Divider for spdif0 clock podf. Divider should be updated when output clock is
 * gated.
 *
 * Values:
 * - 000 - divide by 1
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CDCDR_spdif0_clk_podf (22U) /*!< Bit position for CCM_CDCDR_spdif0_clk_podf. */
#define BM_CCM_CDCDR_spdif0_clk_podf (0x01C00000U) /*!< Bit mask for CCM_CDCDR_spdif0_clk_podf. */
#define BS_CCM_CDCDR_spdif0_clk_podf (3U)  /*!< Bit field size in bits for CCM_CDCDR_spdif0_clk_podf. */

/*! @brief Read current value of the CCM_CDCDR_spdif0_clk_podf field. */
#define BR_CCM_CDCDR_spdif0_clk_podf(x) (HW_CCM_CDCDR(x).B.spdif0_clk_podf)

/*! @brief Format value for bitfield CCM_CDCDR_spdif0_clk_podf. */
#define BF_CCM_CDCDR_spdif0_clk_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CDCDR_spdif0_clk_podf) & BM_CCM_CDCDR_spdif0_clk_podf)

/*! @brief Set the spdif0_clk_podf field to a new value. */
#define BW_CCM_CDCDR_spdif0_clk_podf(x, v) (HW_CCM_CDCDR_WR(x, (HW_CCM_CDCDR_RD(x) & ~BM_CCM_CDCDR_spdif0_clk_podf) | BF_CCM_CDCDR_spdif0_clk_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CDCDR, field spdif0_clk_pred[27:25] (RW)
 *
 * Divider for spdif0 clock pred. Divider should be updated when output clock is
 * gated.
 *
 * Values:
 * - 000 - divide by 1 (do not use with high input frequencies)
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CDCDR_spdif0_clk_pred (25U) /*!< Bit position for CCM_CDCDR_spdif0_clk_pred. */
#define BM_CCM_CDCDR_spdif0_clk_pred (0x0E000000U) /*!< Bit mask for CCM_CDCDR_spdif0_clk_pred. */
#define BS_CCM_CDCDR_spdif0_clk_pred (3U)  /*!< Bit field size in bits for CCM_CDCDR_spdif0_clk_pred. */

/*! @brief Read current value of the CCM_CDCDR_spdif0_clk_pred field. */
#define BR_CCM_CDCDR_spdif0_clk_pred(x) (HW_CCM_CDCDR(x).B.spdif0_clk_pred)

/*! @brief Format value for bitfield CCM_CDCDR_spdif0_clk_pred. */
#define BF_CCM_CDCDR_spdif0_clk_pred(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CDCDR_spdif0_clk_pred) & BM_CCM_CDCDR_spdif0_clk_pred)

/*! @brief Set the spdif0_clk_pred field to a new value. */
#define BW_CCM_CDCDR_spdif0_clk_pred(x, v) (HW_CCM_CDCDR_WR(x, (HW_CCM_CDCDR_RD(x) & ~BM_CCM_CDCDR_spdif0_clk_pred) | BF_CCM_CDCDR_spdif0_clk_pred(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CHSCCDR - CCM HSC Clock Divider Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CHSCCDR - CCM HSC Clock Divider Register (RW)
 *
 * Reset value: 0x000248A4U
 *
 * The figure below represents the CCM HSC Clock Divider Register (CHSCCDR). The
 * CHSCCDR register contains bits to control the clock generation dividers. The
 * table below provides its field descriptions.
 */
typedef union _hw_ccm_chsccdr
{
    uint32_t U;
    struct _hw_ccm_chsccdr_bitfields
    {
        uint32_t m4_clk_sel : 3;       /*!< [2:0]  */
        uint32_t m4_podf : 3;          /*!< [5:3]  */
        uint32_t m4_pre_clk_sel : 3;   /*!< [8:6]  */
        uint32_t enet_clk_sel : 3;     /*!< [11:9]  */
        uint32_t enet_podf : 3;        /*!< [14:12]  */
        uint32_t enet_pre_clk_sel : 3; /*!< [17:15]  */
        uint32_t RESERVED0 : 14;       /*!< [31:18]  */
    } B;
} hw_ccm_chsccdr_t;

/*!
 * @name Constants and macros for entire CCM_CHSCCDR register
 */
/*@{*/
#define HW_CCM_CHSCCDR_ADDR(x)   ((uintptr_t)(x) + 0x34U)

#define HW_CCM_CHSCCDR(x)        (*(__IO hw_ccm_chsccdr_t *) HW_CCM_CHSCCDR_ADDR(x))
#define HW_CCM_CHSCCDR_RD(x)     (HW_CCM_CHSCCDR(x).U)
#define HW_CCM_CHSCCDR_WR(x, v)  (HW_CCM_CHSCCDR(x).U = (v))
#define HW_CCM_CHSCCDR_SET(x, v) (HW_CCM_CHSCCDR_WR(x, HW_CCM_CHSCCDR_RD(x) |  (v)))
#define HW_CCM_CHSCCDR_CLR(x, v) (HW_CCM_CHSCCDR_WR(x, HW_CCM_CHSCCDR_RD(x) & ~(v)))
#define HW_CCM_CHSCCDR_TOG(x, v) (HW_CCM_CHSCCDR_WR(x, HW_CCM_CHSCCDR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CHSCCDR bitfields
 */

/*!
 * @name Register CCM_CHSCCDR, field m4_clk_sel[2:0] (RW)
 *
 * Selector for M4 root clock multiplexer
 *
 * Values:
 * - 000 - derive clock from divided pre-muxed M4 clock
 * - 001 - derive clock from ipp_di0_clk
 * - 010 - derive clock from ipp_di1_clk
 * - 011 - derive clock from ldb_di0_clk
 * - 100 - derive clock from ldb_di1_clk
 */
/*@{*/
#define BP_CCM_CHSCCDR_m4_clk_sel (0U)     /*!< Bit position for CCM_CHSCCDR_m4_clk_sel. */
#define BM_CCM_CHSCCDR_m4_clk_sel (0x00000007U) /*!< Bit mask for CCM_CHSCCDR_m4_clk_sel. */
#define BS_CCM_CHSCCDR_m4_clk_sel (3U)     /*!< Bit field size in bits for CCM_CHSCCDR_m4_clk_sel. */

/*! @brief Read current value of the CCM_CHSCCDR_m4_clk_sel field. */
#define BR_CCM_CHSCCDR_m4_clk_sel(x) (HW_CCM_CHSCCDR(x).B.m4_clk_sel)

/*! @brief Format value for bitfield CCM_CHSCCDR_m4_clk_sel. */
#define BF_CCM_CHSCCDR_m4_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CHSCCDR_m4_clk_sel) & BM_CCM_CHSCCDR_m4_clk_sel)

/*! @brief Set the m4_clk_sel field to a new value. */
#define BW_CCM_CHSCCDR_m4_clk_sel(x, v) (HW_CCM_CHSCCDR_WR(x, (HW_CCM_CHSCCDR_RD(x) & ~BM_CCM_CHSCCDR_m4_clk_sel) | BF_CCM_CHSCCDR_m4_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CHSCCDR, field m4_podf[5:3] (RW)
 *
 * Divider for M4 clock divider. Divider should be updated when output clock is
 * gated.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CHSCCDR_m4_podf (3U)        /*!< Bit position for CCM_CHSCCDR_m4_podf. */
#define BM_CCM_CHSCCDR_m4_podf (0x00000038U) /*!< Bit mask for CCM_CHSCCDR_m4_podf. */
#define BS_CCM_CHSCCDR_m4_podf (3U)        /*!< Bit field size in bits for CCM_CHSCCDR_m4_podf. */

/*! @brief Read current value of the CCM_CHSCCDR_m4_podf field. */
#define BR_CCM_CHSCCDR_m4_podf(x) (HW_CCM_CHSCCDR(x).B.m4_podf)

/*! @brief Format value for bitfield CCM_CHSCCDR_m4_podf. */
#define BF_CCM_CHSCCDR_m4_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CHSCCDR_m4_podf) & BM_CCM_CHSCCDR_m4_podf)

/*! @brief Set the m4_podf field to a new value. */
#define BW_CCM_CHSCCDR_m4_podf(x, v) (HW_CCM_CHSCCDR_WR(x, (HW_CCM_CHSCCDR_RD(x) & ~BM_CCM_CHSCCDR_m4_podf) | BF_CCM_CHSCCDR_m4_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CHSCCDR, field m4_pre_clk_sel[8:6] (RW)
 *
 * Selector for M4 root clock pre-multiplexer
 *
 * Values:
 * - 000 - derive clock from PLL2
 * - 001 - derive clock from pll3_sw_clk
 * - 010 - derive clock from osc_clk (24M)
 * - 011 - derive clock from PLL2 PFD0
 * - 100 - derive clock from PLL2 PFD2
 * - 101 - derive clock from PLL3 PFD3
 */
/*@{*/
#define BP_CCM_CHSCCDR_m4_pre_clk_sel (6U) /*!< Bit position for CCM_CHSCCDR_m4_pre_clk_sel. */
#define BM_CCM_CHSCCDR_m4_pre_clk_sel (0x000001C0U) /*!< Bit mask for CCM_CHSCCDR_m4_pre_clk_sel. */
#define BS_CCM_CHSCCDR_m4_pre_clk_sel (3U) /*!< Bit field size in bits for CCM_CHSCCDR_m4_pre_clk_sel. */

/*! @brief Read current value of the CCM_CHSCCDR_m4_pre_clk_sel field. */
#define BR_CCM_CHSCCDR_m4_pre_clk_sel(x) (HW_CCM_CHSCCDR(x).B.m4_pre_clk_sel)

/*! @brief Format value for bitfield CCM_CHSCCDR_m4_pre_clk_sel. */
#define BF_CCM_CHSCCDR_m4_pre_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CHSCCDR_m4_pre_clk_sel) & BM_CCM_CHSCCDR_m4_pre_clk_sel)

/*! @brief Set the m4_pre_clk_sel field to a new value. */
#define BW_CCM_CHSCCDR_m4_pre_clk_sel(x, v) (HW_CCM_CHSCCDR_WR(x, (HW_CCM_CHSCCDR_RD(x) & ~BM_CCM_CHSCCDR_m4_pre_clk_sel) | BF_CCM_CHSCCDR_m4_pre_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CHSCCDR, field enet_clk_sel[11:9] (RW)
 *
 * Selector for ENET root clock multiplexer
 *
 * Values:
 * - 000 - derive clock from divided pre-muxed ENET clock
 * - 001 - derive clock from ipp_di0_clk
 * - 010 - derive clock from ipp_di1_clk
 * - 011 - derive clock from ldb_di0_clk
 * - 100 - derive clock from ldb_di1_clk
 */
/*@{*/
#define BP_CCM_CHSCCDR_enet_clk_sel (9U)   /*!< Bit position for CCM_CHSCCDR_enet_clk_sel. */
#define BM_CCM_CHSCCDR_enet_clk_sel (0x00000E00U) /*!< Bit mask for CCM_CHSCCDR_enet_clk_sel. */
#define BS_CCM_CHSCCDR_enet_clk_sel (3U)   /*!< Bit field size in bits for CCM_CHSCCDR_enet_clk_sel. */

/*! @brief Read current value of the CCM_CHSCCDR_enet_clk_sel field. */
#define BR_CCM_CHSCCDR_enet_clk_sel(x) (HW_CCM_CHSCCDR(x).B.enet_clk_sel)

/*! @brief Format value for bitfield CCM_CHSCCDR_enet_clk_sel. */
#define BF_CCM_CHSCCDR_enet_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CHSCCDR_enet_clk_sel) & BM_CCM_CHSCCDR_enet_clk_sel)

/*! @brief Set the enet_clk_sel field to a new value. */
#define BW_CCM_CHSCCDR_enet_clk_sel(x, v) (HW_CCM_CHSCCDR_WR(x, (HW_CCM_CHSCCDR_RD(x) & ~BM_CCM_CHSCCDR_enet_clk_sel) | BF_CCM_CHSCCDR_enet_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CHSCCDR, field enet_podf[14:12] (RW)
 *
 * Divider for ENET clock divider. Divider should be updated when output clock
 * is gated.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CHSCCDR_enet_podf (12U)     /*!< Bit position for CCM_CHSCCDR_enet_podf. */
#define BM_CCM_CHSCCDR_enet_podf (0x00007000U) /*!< Bit mask for CCM_CHSCCDR_enet_podf. */
#define BS_CCM_CHSCCDR_enet_podf (3U)      /*!< Bit field size in bits for CCM_CHSCCDR_enet_podf. */

/*! @brief Read current value of the CCM_CHSCCDR_enet_podf field. */
#define BR_CCM_CHSCCDR_enet_podf(x) (HW_CCM_CHSCCDR(x).B.enet_podf)

/*! @brief Format value for bitfield CCM_CHSCCDR_enet_podf. */
#define BF_CCM_CHSCCDR_enet_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CHSCCDR_enet_podf) & BM_CCM_CHSCCDR_enet_podf)

/*! @brief Set the enet_podf field to a new value. */
#define BW_CCM_CHSCCDR_enet_podf(x, v) (HW_CCM_CHSCCDR_WR(x, (HW_CCM_CHSCCDR_RD(x) & ~BM_CCM_CHSCCDR_enet_podf) | BF_CCM_CHSCCDR_enet_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CHSCCDR, field enet_pre_clk_sel[17:15] (RW)
 *
 * Selector for ENET root clock pre-multiplexer
 *
 * Values:
 * - 000 - derive clock from PLL2
 * - 001 - derive clock from pll3_sw_clk
 * - 010 - derive clock from PLL5
 * - 011 - derive clock from PLL2 PFD0
 * - 100 - derive clock from PLL2 PFD2
 * - 101 - derive clock from PLL3 PFD2
 */
/*@{*/
#define BP_CCM_CHSCCDR_enet_pre_clk_sel (15U) /*!< Bit position for CCM_CHSCCDR_enet_pre_clk_sel. */
#define BM_CCM_CHSCCDR_enet_pre_clk_sel (0x00038000U) /*!< Bit mask for CCM_CHSCCDR_enet_pre_clk_sel. */
#define BS_CCM_CHSCCDR_enet_pre_clk_sel (3U) /*!< Bit field size in bits for CCM_CHSCCDR_enet_pre_clk_sel. */

/*! @brief Read current value of the CCM_CHSCCDR_enet_pre_clk_sel field. */
#define BR_CCM_CHSCCDR_enet_pre_clk_sel(x) (HW_CCM_CHSCCDR(x).B.enet_pre_clk_sel)

/*! @brief Format value for bitfield CCM_CHSCCDR_enet_pre_clk_sel. */
#define BF_CCM_CHSCCDR_enet_pre_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CHSCCDR_enet_pre_clk_sel) & BM_CCM_CHSCCDR_enet_pre_clk_sel)

/*! @brief Set the enet_pre_clk_sel field to a new value. */
#define BW_CCM_CHSCCDR_enet_pre_clk_sel(x, v) (HW_CCM_CHSCCDR_WR(x, (HW_CCM_CHSCCDR_RD(x) & ~BM_CCM_CHSCCDR_enet_pre_clk_sel) | BF_CCM_CHSCCDR_enet_pre_clk_sel(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CSCDR2 - CCM Serial Clock Divider Register 2
 ******************************************************************************/

/*!
 * @brief HW_CCM_CSCDR2 - CCM Serial Clock Divider Register 2 (RW)
 *
 * Reset value: 0x00029B48U
 *
 * The figure below represents the CCM Serial Clock Divider Register 2(CSCDR2).
 * The CSCDR2 register contains bits to control the clock generation sub-module
 * dividers. The table below provides its field descriptions.
 */
typedef union _hw_ccm_cscdr2
{
    uint32_t U;
    struct _hw_ccm_cscdr2_bitfields
    {
        uint32_t lcdif2_clk_sel : 3;   /*!< [2:0]  */
        uint32_t lcdif2_pred : 3;      /*!< [5:3]  */
        uint32_t lcdif2_pre_clk_sel : 3; /*!< [8:6]  */
        uint32_t lcdif1_clk_sel : 3;   /*!< [11:9]  */
        uint32_t lcdif1_pred : 3;      /*!< [14:12]  */
        uint32_t lcdif1_pre_clk_sel : 3; /*!< [17:15]  */
        uint32_t ecspi_clk_sel : 1;    /*!< [18]  */
        uint32_t ecspi_clk_podf : 6;   /*!< [24:19]  */
        uint32_t RESERVED0 : 7;        /*!< [31:25]  */
    } B;
} hw_ccm_cscdr2_t;

/*!
 * @name Constants and macros for entire CCM_CSCDR2 register
 */
/*@{*/
#define HW_CCM_CSCDR2_ADDR(x)    ((uintptr_t)(x) + 0x38U)

#define HW_CCM_CSCDR2(x)         (*(__IO hw_ccm_cscdr2_t *) HW_CCM_CSCDR2_ADDR(x))
#define HW_CCM_CSCDR2_RD(x)      (HW_CCM_CSCDR2(x).U)
#define HW_CCM_CSCDR2_WR(x, v)   (HW_CCM_CSCDR2(x).U = (v))
#define HW_CCM_CSCDR2_SET(x, v)  (HW_CCM_CSCDR2_WR(x, HW_CCM_CSCDR2_RD(x) |  (v)))
#define HW_CCM_CSCDR2_CLR(x, v)  (HW_CCM_CSCDR2_WR(x, HW_CCM_CSCDR2_RD(x) & ~(v)))
#define HW_CCM_CSCDR2_TOG(x, v)  (HW_CCM_CSCDR2_WR(x, HW_CCM_CSCDR2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CSCDR2 bitfields
 */

/*!
 * @name Register CCM_CSCDR2, field lcdif2_clk_sel[2:0] (RW)
 *
 * Selector for lcdif2 root clock multiplexer
 *
 * Values:
 * - 000 - derive clock from divided pre-muxed lcdif2 clock
 * - 001 - derive clock from ipp_di0_clk
 * - 010 - derive clock from ipp_di1_clk
 * - 011 - derive clock from ldb_di0_clk
 * - 100 - derive clock from ldb_di1_clk
 */
/*@{*/
#define BP_CCM_CSCDR2_lcdif2_clk_sel (0U)  /*!< Bit position for CCM_CSCDR2_lcdif2_clk_sel. */
#define BM_CCM_CSCDR2_lcdif2_clk_sel (0x00000007U) /*!< Bit mask for CCM_CSCDR2_lcdif2_clk_sel. */
#define BS_CCM_CSCDR2_lcdif2_clk_sel (3U)  /*!< Bit field size in bits for CCM_CSCDR2_lcdif2_clk_sel. */

/*! @brief Read current value of the CCM_CSCDR2_lcdif2_clk_sel field. */
#define BR_CCM_CSCDR2_lcdif2_clk_sel(x) (HW_CCM_CSCDR2(x).B.lcdif2_clk_sel)

/*! @brief Format value for bitfield CCM_CSCDR2_lcdif2_clk_sel. */
#define BF_CCM_CSCDR2_lcdif2_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCDR2_lcdif2_clk_sel) & BM_CCM_CSCDR2_lcdif2_clk_sel)

/*! @brief Set the lcdif2_clk_sel field to a new value. */
#define BW_CCM_CSCDR2_lcdif2_clk_sel(x, v) (HW_CCM_CSCDR2_WR(x, (HW_CCM_CSCDR2_RD(x) & ~BM_CCM_CSCDR2_lcdif2_clk_sel) | BF_CCM_CSCDR2_lcdif2_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CSCDR2, field lcdif2_pred[5:3] (RW)
 *
 * Pre-divider for lcdif2 clock. Divider should be updated when output clock is
 * gated.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CSCDR2_lcdif2_pred (3U)     /*!< Bit position for CCM_CSCDR2_lcdif2_pred. */
#define BM_CCM_CSCDR2_lcdif2_pred (0x00000038U) /*!< Bit mask for CCM_CSCDR2_lcdif2_pred. */
#define BS_CCM_CSCDR2_lcdif2_pred (3U)     /*!< Bit field size in bits for CCM_CSCDR2_lcdif2_pred. */

/*! @brief Read current value of the CCM_CSCDR2_lcdif2_pred field. */
#define BR_CCM_CSCDR2_lcdif2_pred(x) (HW_CCM_CSCDR2(x).B.lcdif2_pred)

/*! @brief Format value for bitfield CCM_CSCDR2_lcdif2_pred. */
#define BF_CCM_CSCDR2_lcdif2_pred(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCDR2_lcdif2_pred) & BM_CCM_CSCDR2_lcdif2_pred)

/*! @brief Set the lcdif2_pred field to a new value. */
#define BW_CCM_CSCDR2_lcdif2_pred(x, v) (HW_CCM_CSCDR2_WR(x, (HW_CCM_CSCDR2_RD(x) & ~BM_CCM_CSCDR2_lcdif2_pred) | BF_CCM_CSCDR2_lcdif2_pred(v)))
/*@}*/

/*!
 * @name Register CCM_CSCDR2, field lcdif2_pre_clk_sel[8:6] (RW)
 *
 * Selector for lcdif2 root clock pre-multiplexer
 *
 * Values:
 * - 000 - derive clock from PLL2
 * - 001 - derive clock from PLL3 PFD3
 * - 010 - derive clock from PLL5
 * - 011 - derive clock from PLL2 PFD0
 * - 100 - derive clock from PLL2 PFD3
 * - 101 - derive clock from PLL3 PFD1
 */
/*@{*/
#define BP_CCM_CSCDR2_lcdif2_pre_clk_sel (6U) /*!< Bit position for CCM_CSCDR2_lcdif2_pre_clk_sel. */
#define BM_CCM_CSCDR2_lcdif2_pre_clk_sel (0x000001C0U) /*!< Bit mask for CCM_CSCDR2_lcdif2_pre_clk_sel. */
#define BS_CCM_CSCDR2_lcdif2_pre_clk_sel (3U) /*!< Bit field size in bits for CCM_CSCDR2_lcdif2_pre_clk_sel. */

/*! @brief Read current value of the CCM_CSCDR2_lcdif2_pre_clk_sel field. */
#define BR_CCM_CSCDR2_lcdif2_pre_clk_sel(x) (HW_CCM_CSCDR2(x).B.lcdif2_pre_clk_sel)

/*! @brief Format value for bitfield CCM_CSCDR2_lcdif2_pre_clk_sel. */
#define BF_CCM_CSCDR2_lcdif2_pre_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCDR2_lcdif2_pre_clk_sel) & BM_CCM_CSCDR2_lcdif2_pre_clk_sel)

/*! @brief Set the lcdif2_pre_clk_sel field to a new value. */
#define BW_CCM_CSCDR2_lcdif2_pre_clk_sel(x, v) (HW_CCM_CSCDR2_WR(x, (HW_CCM_CSCDR2_RD(x) & ~BM_CCM_CSCDR2_lcdif2_pre_clk_sel) | BF_CCM_CSCDR2_lcdif2_pre_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CSCDR2, field lcdif1_clk_sel[11:9] (RW)
 *
 * Selector for lcdif1 root clock multiplexer
 *
 * Values:
 * - 000 - derive clock from divided pre-muxed lcdif1 clock
 * - 001 - derive clock from ipp_di0_clk
 * - 010 - derive clock from ipp_di1_clk
 * - 011 - derive clock from ldb_di0_clk
 * - 100 - derive clock from ldb_di1_clk
 */
/*@{*/
#define BP_CCM_CSCDR2_lcdif1_clk_sel (9U)  /*!< Bit position for CCM_CSCDR2_lcdif1_clk_sel. */
#define BM_CCM_CSCDR2_lcdif1_clk_sel (0x00000E00U) /*!< Bit mask for CCM_CSCDR2_lcdif1_clk_sel. */
#define BS_CCM_CSCDR2_lcdif1_clk_sel (3U)  /*!< Bit field size in bits for CCM_CSCDR2_lcdif1_clk_sel. */

/*! @brief Read current value of the CCM_CSCDR2_lcdif1_clk_sel field. */
#define BR_CCM_CSCDR2_lcdif1_clk_sel(x) (HW_CCM_CSCDR2(x).B.lcdif1_clk_sel)

/*! @brief Format value for bitfield CCM_CSCDR2_lcdif1_clk_sel. */
#define BF_CCM_CSCDR2_lcdif1_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCDR2_lcdif1_clk_sel) & BM_CCM_CSCDR2_lcdif1_clk_sel)

/*! @brief Set the lcdif1_clk_sel field to a new value. */
#define BW_CCM_CSCDR2_lcdif1_clk_sel(x, v) (HW_CCM_CSCDR2_WR(x, (HW_CCM_CSCDR2_RD(x) & ~BM_CCM_CSCDR2_lcdif1_clk_sel) | BF_CCM_CSCDR2_lcdif1_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CSCDR2, field lcdif1_pred[14:12] (RW)
 *
 * Pre-divider for lcdif1 clock. Divider should be updated when output clock is
 * gated.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CSCDR2_lcdif1_pred (12U)    /*!< Bit position for CCM_CSCDR2_lcdif1_pred. */
#define BM_CCM_CSCDR2_lcdif1_pred (0x00007000U) /*!< Bit mask for CCM_CSCDR2_lcdif1_pred. */
#define BS_CCM_CSCDR2_lcdif1_pred (3U)     /*!< Bit field size in bits for CCM_CSCDR2_lcdif1_pred. */

/*! @brief Read current value of the CCM_CSCDR2_lcdif1_pred field. */
#define BR_CCM_CSCDR2_lcdif1_pred(x) (HW_CCM_CSCDR2(x).B.lcdif1_pred)

/*! @brief Format value for bitfield CCM_CSCDR2_lcdif1_pred. */
#define BF_CCM_CSCDR2_lcdif1_pred(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCDR2_lcdif1_pred) & BM_CCM_CSCDR2_lcdif1_pred)

/*! @brief Set the lcdif1_pred field to a new value. */
#define BW_CCM_CSCDR2_lcdif1_pred(x, v) (HW_CCM_CSCDR2_WR(x, (HW_CCM_CSCDR2_RD(x) & ~BM_CCM_CSCDR2_lcdif1_pred) | BF_CCM_CSCDR2_lcdif1_pred(v)))
/*@}*/

/*!
 * @name Register CCM_CSCDR2, field lcdif1_pre_clk_sel[17:15] (RW)
 *
 * Selector for lcdif1 root clock pre-multiplexer
 *
 * Values:
 * - 000 - derive clock from PLL2
 * - 001 - derive clock from PLL3 PFD3
 * - 010 - derive clock from PLL5
 * - 011 - derive clock from PLL2 PFD0
 * - 100 - derive clock from PLL2 PFD1
 * - 101 - derive clock from PLL3 PFD1
 */
/*@{*/
#define BP_CCM_CSCDR2_lcdif1_pre_clk_sel (15U) /*!< Bit position for CCM_CSCDR2_lcdif1_pre_clk_sel. */
#define BM_CCM_CSCDR2_lcdif1_pre_clk_sel (0x00038000U) /*!< Bit mask for CCM_CSCDR2_lcdif1_pre_clk_sel. */
#define BS_CCM_CSCDR2_lcdif1_pre_clk_sel (3U) /*!< Bit field size in bits for CCM_CSCDR2_lcdif1_pre_clk_sel. */

/*! @brief Read current value of the CCM_CSCDR2_lcdif1_pre_clk_sel field. */
#define BR_CCM_CSCDR2_lcdif1_pre_clk_sel(x) (HW_CCM_CSCDR2(x).B.lcdif1_pre_clk_sel)

/*! @brief Format value for bitfield CCM_CSCDR2_lcdif1_pre_clk_sel. */
#define BF_CCM_CSCDR2_lcdif1_pre_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCDR2_lcdif1_pre_clk_sel) & BM_CCM_CSCDR2_lcdif1_pre_clk_sel)

/*! @brief Set the lcdif1_pre_clk_sel field to a new value. */
#define BW_CCM_CSCDR2_lcdif1_pre_clk_sel(x, v) (HW_CCM_CSCDR2_WR(x, (HW_CCM_CSCDR2_RD(x) & ~BM_CCM_CSCDR2_lcdif1_pre_clk_sel) | BF_CCM_CSCDR2_lcdif1_pre_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CSCDR2, field ecspi_clk_sel[18] (RW)
 *
 * Selector for the ECSPI clock multiplexor
 *
 * Values:
 * - 0 - derive clock from pll3_60m
 * - 1 - derive clock from osc_clk
 */
/*@{*/
#define BP_CCM_CSCDR2_ecspi_clk_sel (18U)  /*!< Bit position for CCM_CSCDR2_ecspi_clk_sel. */
#define BM_CCM_CSCDR2_ecspi_clk_sel (0x00040000U) /*!< Bit mask for CCM_CSCDR2_ecspi_clk_sel. */
#define BS_CCM_CSCDR2_ecspi_clk_sel (1U)   /*!< Bit field size in bits for CCM_CSCDR2_ecspi_clk_sel. */

/*! @brief Read current value of the CCM_CSCDR2_ecspi_clk_sel field. */
#define BR_CCM_CSCDR2_ecspi_clk_sel(x) (HW_CCM_CSCDR2(x).B.ecspi_clk_sel)

/*! @brief Format value for bitfield CCM_CSCDR2_ecspi_clk_sel. */
#define BF_CCM_CSCDR2_ecspi_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCDR2_ecspi_clk_sel) & BM_CCM_CSCDR2_ecspi_clk_sel)

/*! @brief Set the ecspi_clk_sel field to a new value. */
#define BW_CCM_CSCDR2_ecspi_clk_sel(x, v) (HW_CCM_CSCDR2_WR(x, (HW_CCM_CSCDR2_RD(x) & ~BM_CCM_CSCDR2_ecspi_clk_sel) | BF_CCM_CSCDR2_ecspi_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CSCDR2, field ecspi_clk_podf[24:19] (RW)
 *
 * Divider for ecspi clock podf. Divider should be updated when output clock is
 * gated. The input clock to this divider should be lower than 300Mhz, the
 * predivider can be used to achieve this.
 *
 * Values:
 * - 000000 - divide by 1
 * - 111111 - divide by 2^6
 */
/*@{*/
#define BP_CCM_CSCDR2_ecspi_clk_podf (19U) /*!< Bit position for CCM_CSCDR2_ecspi_clk_podf. */
#define BM_CCM_CSCDR2_ecspi_clk_podf (0x01F80000U) /*!< Bit mask for CCM_CSCDR2_ecspi_clk_podf. */
#define BS_CCM_CSCDR2_ecspi_clk_podf (6U)  /*!< Bit field size in bits for CCM_CSCDR2_ecspi_clk_podf. */

/*! @brief Read current value of the CCM_CSCDR2_ecspi_clk_podf field. */
#define BR_CCM_CSCDR2_ecspi_clk_podf(x) (HW_CCM_CSCDR2(x).B.ecspi_clk_podf)

/*! @brief Format value for bitfield CCM_CSCDR2_ecspi_clk_podf. */
#define BF_CCM_CSCDR2_ecspi_clk_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCDR2_ecspi_clk_podf) & BM_CCM_CSCDR2_ecspi_clk_podf)

/*! @brief Set the ecspi_clk_podf field to a new value. */
#define BW_CCM_CSCDR2_ecspi_clk_podf(x, v) (HW_CCM_CSCDR2_WR(x, (HW_CCM_CSCDR2_RD(x) & ~BM_CCM_CSCDR2_ecspi_clk_podf) | BF_CCM_CSCDR2_ecspi_clk_podf(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CSCDR3 - CCM Serial Clock Divider Register 3
 ******************************************************************************/

/*!
 * @brief HW_CCM_CSCDR3 - CCM Serial Clock Divider Register 3 (RW)
 *
 * Reset value: 0x00014041U
 *
 * The figure below represents the CCM Serial Clock Divider Register 3(CSCDR3).
 * The CSCDR3 register contains bits to control the clock generation sub-module
 * dividers. The table below provides its field descriptions.
 */
typedef union _hw_ccm_cscdr3
{
    uint32_t U;
    struct _hw_ccm_cscdr3_bitfields
    {
        uint32_t RESERVED0 : 9;        /*!< [8:0]  */
        uint32_t csi_clk_sel : 2;      /*!< [10:9]  */
        uint32_t csi_podf : 3;         /*!< [13:11]  */
        uint32_t display_clk_sel : 2;  /*!< [15:14]  */
        uint32_t display_podf : 3;     /*!< [18:16]  */
        uint32_t RESERVED1 : 13;       /*!< [31:19]  */
    } B;
} hw_ccm_cscdr3_t;

/*!
 * @name Constants and macros for entire CCM_CSCDR3 register
 */
/*@{*/
#define HW_CCM_CSCDR3_ADDR(x)    ((uintptr_t)(x) + 0x3CU)

#define HW_CCM_CSCDR3(x)         (*(__IO hw_ccm_cscdr3_t *) HW_CCM_CSCDR3_ADDR(x))
#define HW_CCM_CSCDR3_RD(x)      (HW_CCM_CSCDR3(x).U)
#define HW_CCM_CSCDR3_WR(x, v)   (HW_CCM_CSCDR3(x).U = (v))
#define HW_CCM_CSCDR3_SET(x, v)  (HW_CCM_CSCDR3_WR(x, HW_CCM_CSCDR3_RD(x) |  (v)))
#define HW_CCM_CSCDR3_CLR(x, v)  (HW_CCM_CSCDR3_WR(x, HW_CCM_CSCDR3_RD(x) & ~(v)))
#define HW_CCM_CSCDR3_TOG(x, v)  (HW_CCM_CSCDR3_WR(x, HW_CCM_CSCDR3_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CSCDR3 bitfields
 */

/*!
 * @name Register CCM_CSCDR3, field csi_clk_sel[10:9] (RW)
 *
 * Selector for csi clock multiplexer
 *
 * Values:
 * - 00 - derive clock from osc_clk (24M)
 * - 01 - derive clock from PLL2 PFD2
 * - 10 - derive clock from pll3_120M
 * - 11 - derive clock from PLL3 PFD1
 */
/*@{*/
#define BP_CCM_CSCDR3_csi_clk_sel (9U)     /*!< Bit position for CCM_CSCDR3_csi_clk_sel. */
#define BM_CCM_CSCDR3_csi_clk_sel (0x00000600U) /*!< Bit mask for CCM_CSCDR3_csi_clk_sel. */
#define BS_CCM_CSCDR3_csi_clk_sel (2U)     /*!< Bit field size in bits for CCM_CSCDR3_csi_clk_sel. */

/*! @brief Read current value of the CCM_CSCDR3_csi_clk_sel field. */
#define BR_CCM_CSCDR3_csi_clk_sel(x) (HW_CCM_CSCDR3(x).B.csi_clk_sel)

/*! @brief Format value for bitfield CCM_CSCDR3_csi_clk_sel. */
#define BF_CCM_CSCDR3_csi_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCDR3_csi_clk_sel) & BM_CCM_CSCDR3_csi_clk_sel)

/*! @brief Set the csi_clk_sel field to a new value. */
#define BW_CCM_CSCDR3_csi_clk_sel(x, v) (HW_CCM_CSCDR3_WR(x, (HW_CCM_CSCDR3_RD(x) & ~BM_CCM_CSCDR3_csi_clk_sel) | BF_CCM_CSCDR3_csi_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CSCDR3, field csi_podf[13:11] (RW)
 *
 * Post divider for csi_core clock. Divider should be updated when output clock
 * is gated.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CSCDR3_csi_podf (11U)       /*!< Bit position for CCM_CSCDR3_csi_podf. */
#define BM_CCM_CSCDR3_csi_podf (0x00003800U) /*!< Bit mask for CCM_CSCDR3_csi_podf. */
#define BS_CCM_CSCDR3_csi_podf (3U)        /*!< Bit field size in bits for CCM_CSCDR3_csi_podf. */

/*! @brief Read current value of the CCM_CSCDR3_csi_podf field. */
#define BR_CCM_CSCDR3_csi_podf(x) (HW_CCM_CSCDR3(x).B.csi_podf)

/*! @brief Format value for bitfield CCM_CSCDR3_csi_podf. */
#define BF_CCM_CSCDR3_csi_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCDR3_csi_podf) & BM_CCM_CSCDR3_csi_podf)

/*! @brief Set the csi_podf field to a new value. */
#define BW_CCM_CSCDR3_csi_podf(x, v) (HW_CCM_CSCDR3_WR(x, (HW_CCM_CSCDR3_RD(x) & ~BM_CCM_CSCDR3_csi_podf) | BF_CCM_CSCDR3_csi_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CSCDR3, field display_clk_sel[15:14] (RW)
 *
 * Selector for display clock multiplexer
 *
 * Values:
 * - 00 - derive clock from PLL2
 * - 01 - derive clock from PLL2 PFD2
 * - 10 - derive clock from PLL3
 * - 11 - derive clock from PLL3 PFD1
 */
/*@{*/
#define BP_CCM_CSCDR3_display_clk_sel (14U) /*!< Bit position for CCM_CSCDR3_display_clk_sel. */
#define BM_CCM_CSCDR3_display_clk_sel (0x0000C000U) /*!< Bit mask for CCM_CSCDR3_display_clk_sel. */
#define BS_CCM_CSCDR3_display_clk_sel (2U) /*!< Bit field size in bits for CCM_CSCDR3_display_clk_sel. */

/*! @brief Read current value of the CCM_CSCDR3_display_clk_sel field. */
#define BR_CCM_CSCDR3_display_clk_sel(x) (HW_CCM_CSCDR3(x).B.display_clk_sel)

/*! @brief Format value for bitfield CCM_CSCDR3_display_clk_sel. */
#define BF_CCM_CSCDR3_display_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCDR3_display_clk_sel) & BM_CCM_CSCDR3_display_clk_sel)

/*! @brief Set the display_clk_sel field to a new value. */
#define BW_CCM_CSCDR3_display_clk_sel(x, v) (HW_CCM_CSCDR3_WR(x, (HW_CCM_CSCDR3_RD(x) & ~BM_CCM_CSCDR3_display_clk_sel) | BF_CCM_CSCDR3_display_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CSCDR3, field display_podf[18:16] (RW)
 *
 * Divider for display clock. Divider should be updated when output clock is
 * gated.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CSCDR3_display_podf (16U)   /*!< Bit position for CCM_CSCDR3_display_podf. */
#define BM_CCM_CSCDR3_display_podf (0x00070000U) /*!< Bit mask for CCM_CSCDR3_display_podf. */
#define BS_CCM_CSCDR3_display_podf (3U)    /*!< Bit field size in bits for CCM_CSCDR3_display_podf. */

/*! @brief Read current value of the CCM_CSCDR3_display_podf field. */
#define BR_CCM_CSCDR3_display_podf(x) (HW_CCM_CSCDR3(x).B.display_podf)

/*! @brief Format value for bitfield CCM_CSCDR3_display_podf. */
#define BF_CCM_CSCDR3_display_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCDR3_display_podf) & BM_CCM_CSCDR3_display_podf)

/*! @brief Set the display_podf field to a new value. */
#define BW_CCM_CSCDR3_display_podf(x, v) (HW_CCM_CSCDR3_WR(x, (HW_CCM_CSCDR3_RD(x) & ~BM_CCM_CSCDR3_display_podf) | BF_CCM_CSCDR3_display_podf(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CWDR - CCM Wakeup Detector Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CWDR - CCM Wakeup Detector Register (ROZ)
 *
 * Reset value: 0x00000000U
 *
 * The figure below represents the CCM Wakeup Detector Register (CWDR). The CWDR
 * register contains reserved, read-only bits.The table below provides its field
 * descriptions.
 */
typedef union _hw_ccm_cwdr
{
    uint32_t U;
    struct _hw_ccm_cwdr_bitfields
    {
        uint32_t RESERVED0 : 32;       /*!< [31:0]  */
    } B;
} hw_ccm_cwdr_t;

/*!
 * @name Constants and macros for entire CCM_CWDR register
 */
/*@{*/
#define HW_CCM_CWDR_ADDR(x)      ((uintptr_t)(x) + 0x44U)

#define HW_CCM_CWDR(x)           (*(__I hw_ccm_cwdr_t *) HW_CCM_CWDR_ADDR(x))
#define HW_CCM_CWDR_RD(x)        (HW_CCM_CWDR(x).U)
/*@}*/

/*
 * Constants & macros for individual CCM_CWDR bitfields
 */

/*******************************************************************************
 * HW_CCM_CDHIPR - CCM Divider Handshake In-Process Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CDHIPR - CCM Divider Handshake In-Process Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * The figure below represents the CCM Divider Handshake In-Process Register
 * (CDHIPR). The CDHIPR register contains read-only bits that indicate that CCM is
 * in the process of updating dividers or muxes that might need handshake with
 * modules.
 */
typedef union _hw_ccm_cdhipr
{
    uint32_t U;
    struct _hw_ccm_cdhipr_bitfields
    {
        uint32_t ocram_podf_busy : 1;  /*!< [0]  */
        uint32_t ahb_podf_busy : 1;    /*!< [1]  */
        uint32_t mmdc_podf_busy : 1;   /*!< [2]  */
        uint32_t periph2_clk_sel_busy : 1; /*!< [3]  */
        uint32_t RESERVED0 : 1;        /*!< [4]  */
        uint32_t periph_clk_sel_busy : 1; /*!< [5]  */
        uint32_t RESERVED1 : 10;       /*!< [15:6]  */
        uint32_t arm_podf_busy : 1;    /*!< [16]  */
        uint32_t RESERVED2 : 15;       /*!< [31:17]  */
    } B;
} hw_ccm_cdhipr_t;

/*!
 * @name Constants and macros for entire CCM_CDHIPR register
 */
/*@{*/
#define HW_CCM_CDHIPR_ADDR(x)    ((uintptr_t)(x) + 0x48U)

#define HW_CCM_CDHIPR(x)         (*(__I hw_ccm_cdhipr_t *) HW_CCM_CDHIPR_ADDR(x))
#define HW_CCM_CDHIPR_RD(x)      (HW_CCM_CDHIPR(x).U)
/*@}*/

/*
 * Constants & macros for individual CCM_CDHIPR bitfields
 */

/*!
 * @name Register CCM_CDHIPR, field ocram_podf_busy[0] (RO)
 *
 * Busy indicator for ocram_podf.
 *
 * Values:
 * - 0 - divider is not busy and its value represents the actual division.
 * - 1 - divider is busy with handshake process with module. The value read in
 *     the divider represents the previous value of the division factor, and after
 *     the handshake the written value of the ocram_podf will be applied.
 */
/*@{*/
#define BP_CCM_CDHIPR_ocram_podf_busy (0U) /*!< Bit position for CCM_CDHIPR_ocram_podf_busy. */
#define BM_CCM_CDHIPR_ocram_podf_busy (0x00000001U) /*!< Bit mask for CCM_CDHIPR_ocram_podf_busy. */
#define BS_CCM_CDHIPR_ocram_podf_busy (1U) /*!< Bit field size in bits for CCM_CDHIPR_ocram_podf_busy. */

/*! @brief Read current value of the CCM_CDHIPR_ocram_podf_busy field. */
#define BR_CCM_CDHIPR_ocram_podf_busy(x) (HW_CCM_CDHIPR(x).B.ocram_podf_busy)
/*@}*/

/*!
 * @name Register CCM_CDHIPR, field ahb_podf_busy[1] (RO)
 *
 * Busy indicator for ahb_podf.
 *
 * Values:
 * - 0 - divider is not busy and its value represents the actual division.
 * - 1 - divider is busy with handshake process with module. The value read in
 *     the divider represents the previous value of the division factor, and after
 *     the handshake the written value of the ahb_podf will be applied.
 */
/*@{*/
#define BP_CCM_CDHIPR_ahb_podf_busy (1U)   /*!< Bit position for CCM_CDHIPR_ahb_podf_busy. */
#define BM_CCM_CDHIPR_ahb_podf_busy (0x00000002U) /*!< Bit mask for CCM_CDHIPR_ahb_podf_busy. */
#define BS_CCM_CDHIPR_ahb_podf_busy (1U)   /*!< Bit field size in bits for CCM_CDHIPR_ahb_podf_busy. */

/*! @brief Read current value of the CCM_CDHIPR_ahb_podf_busy field. */
#define BR_CCM_CDHIPR_ahb_podf_busy(x) (HW_CCM_CDHIPR(x).B.ahb_podf_busy)
/*@}*/

/*!
 * @name Register CCM_CDHIPR, field mmdc_podf_busy[2] (RO)
 *
 * Busy indicator for mmdc_axi_podf.
 *
 * Values:
 * - 0 - divider is not busy and its value represents the actual division.
 * - 1 - divider is busy with handshake process with module. The value read in
 *     the divider represents the previous value of the division factor, and after
 *     the handshake the written value of the mmdc_axi_podf will be applied.
 */
/*@{*/
#define BP_CCM_CDHIPR_mmdc_podf_busy (2U)  /*!< Bit position for CCM_CDHIPR_mmdc_podf_busy. */
#define BM_CCM_CDHIPR_mmdc_podf_busy (0x00000004U) /*!< Bit mask for CCM_CDHIPR_mmdc_podf_busy. */
#define BS_CCM_CDHIPR_mmdc_podf_busy (1U)  /*!< Bit field size in bits for CCM_CDHIPR_mmdc_podf_busy. */

/*! @brief Read current value of the CCM_CDHIPR_mmdc_podf_busy field. */
#define BR_CCM_CDHIPR_mmdc_podf_busy(x) (HW_CCM_CDHIPR(x).B.mmdc_podf_busy)
/*@}*/

/*!
 * @name Register CCM_CDHIPR, field periph2_clk_sel_busy[3] (RO)
 *
 * Busy indicator for periph2_clk_sel mux control.
 *
 * Values:
 * - 0 - mux is not busy and its value represents the actual division.
 * - 1 - mux is busy with handshake process with module. The value read in the
 *     periph2_clk_sel represents the previous value of select, and after the
 *     handshake periph2_clk_sel value will be applied.
 */
/*@{*/
#define BP_CCM_CDHIPR_periph2_clk_sel_busy (3U) /*!< Bit position for CCM_CDHIPR_periph2_clk_sel_busy. */
#define BM_CCM_CDHIPR_periph2_clk_sel_busy (0x00000008U) /*!< Bit mask for CCM_CDHIPR_periph2_clk_sel_busy. */
#define BS_CCM_CDHIPR_periph2_clk_sel_busy (1U) /*!< Bit field size in bits for CCM_CDHIPR_periph2_clk_sel_busy. */

/*! @brief Read current value of the CCM_CDHIPR_periph2_clk_sel_busy field. */
#define BR_CCM_CDHIPR_periph2_clk_sel_busy(x) (HW_CCM_CDHIPR(x).B.periph2_clk_sel_busy)
/*@}*/

/*!
 * @name Register CCM_CDHIPR, field periph_clk_sel_busy[5] (RO)
 *
 * Busy indicator for periph_clk_sel mux control.
 *
 * Values:
 * - 0 - mux is not busy and its value represents the actual division.
 * - 1 - mux is busy with handshake process with module. The value read in the
 *     periph_clk_sel represents the previous value of select, and after the
 *     handshake periph_clk_sel value will be applied.
 */
/*@{*/
#define BP_CCM_CDHIPR_periph_clk_sel_busy (5U) /*!< Bit position for CCM_CDHIPR_periph_clk_sel_busy. */
#define BM_CCM_CDHIPR_periph_clk_sel_busy (0x00000020U) /*!< Bit mask for CCM_CDHIPR_periph_clk_sel_busy. */
#define BS_CCM_CDHIPR_periph_clk_sel_busy (1U) /*!< Bit field size in bits for CCM_CDHIPR_periph_clk_sel_busy. */

/*! @brief Read current value of the CCM_CDHIPR_periph_clk_sel_busy field. */
#define BR_CCM_CDHIPR_periph_clk_sel_busy(x) (HW_CCM_CDHIPR(x).B.periph_clk_sel_busy)
/*@}*/

/*!
 * @name Register CCM_CDHIPR, field arm_podf_busy[16] (RO)
 *
 * Busy indicator for arm_podf.
 *
 * Values:
 * - 0 - divider is not busy and its value represents the actual division.
 * - 1 - divider is busy with handshake process with module. The value read in
 *     the divider represents the previous value of the division factor, and after
 *     the handshake the written value of the arm_podf will be applied.
 */
/*@{*/
#define BP_CCM_CDHIPR_arm_podf_busy (16U)  /*!< Bit position for CCM_CDHIPR_arm_podf_busy. */
#define BM_CCM_CDHIPR_arm_podf_busy (0x00010000U) /*!< Bit mask for CCM_CDHIPR_arm_podf_busy. */
#define BS_CCM_CDHIPR_arm_podf_bus