/*******************************************************************************/
/**
Copyright (c) 2007 Freescale Semiconductor
Freescale Confidential Proprietary
\file       FlexRay_handler.c
\brief      FlexRay module handling routines.
            Code based on the Transmit/Receive application example 
            for the FlexRay UNIFIED driver in interrupt driven mode
            (transmit_receive_node1.c) made by R62779.            
\author     Freescale Semiconductor
\author     Guadalajara Applications Laboratory RTAC Americas
\author     Jaime Orozco
\version    1.0
\date       March/12/2007
*/
/*******************************************************************************/
/*                                                                             */
/* All software, source code, included documentation, and any implied know-how */
/* are property of Freescale Semiconductor and therefore considered            */ 
/* CONFIDENTIAL INFORMATION.                                                   */
/*                                                                             */
/* This confidential information is disclosed FOR DEMONSTRATION PURPOSES ONLY. */
/*                                                                             */
/* All Confidential Information remains the property of Freescale Semiconductor*/
/* and will not be copied or reproduced without the express written permission */
/* of the Discloser, except for copies that are absolutely necessary in order  */
/* to fulfill the Purpose.                                                     */
/*                                                                             */
/* Services performed by FREESCALE in this matter are performed AS IS and      */
/* without any warranty. CUSTOMER retains the final decision relative to the   */
/* total design and functionality of the end product.                          */
/*                                                                             */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the    */
/* success of this project.                                                    */
/*                                                                             */
/* FREESCALE disclaims all warranties, express, implied or statutory including,*/
/* but not limited to, implied warranty of merchantability or fitness for a    */
/* particular purpose on any hardware, software or advise supplied to the      */
/* project by FREESCALE, and or any product resulting from FREESCALE services. */
/*                                                                             */
/* In no event shall FREESCALE be liable for incidental or consequential       */
/* damages arising out of this agreement. CUSTOMER agrees to hold FREESCALE    */
/* harmless against any and all claims demands or actions by anyone on account */
/* of any damage,or injury, whether commercial, contractual, or tortuous,      */
/* rising directly or indirectly as a result of the advise or assistance       */
/* supplied CUSTOMER in connection with product, services or goods supplied    */
/* under this Agreement.                                                       */
/*                                                                             */
/*******************************************************************************/

/** S12X derivative information */ 
#include "M9S12XF512.h"       

/** Standard and driver types */
#include "Fr_UNIFIED_types.h"  

/** UNIFIED driver implementation */         
#include "Fr_UNIFIED.h"        
         
/** Configuration data for the FlexRay node */
#include "Fr_UNIFIED_cfg.h"


/** Return values */
Fr_return_type return_value;      
/** Current protocol state */      
Fr_POC_state_type protocol_state;       
/** Current wakeup status */
Fr_wakeup_state_type wakeup_status;  


/******************************************************************************/
/**
* \brief    Error function for debugging 
* \author   R62779
* \param    u8number: error code
* \return   void
*/
void Failed(uint8 u8number)               
{    
    while(1);       /* Function only for debugging, CC should be restarted  */
}


/*******************************************************************************/
/**
* \brief    FlexRay module configuration
* \author   Jaime Orozco
* \param    void
* \return   void
*/
void vfnFlexRay_Init(void) {   
 
    /* Enable the FlexRay CC and force it into FR_POCSTATE_CONFIG */
    return_value = Fr_init(&Fr_HW_cfg_00, &Fr_low_level_cfg_set_00);
    if(return_value == FR_NOT_SUCCESS) 
        Failed(1);   /* Call debug function in case of any error */

    /* Initialization of the FlexRay CC with protocol configuration parameter */
    Fr_set_configuration(&Fr_HW_cfg_00, &Fr_low_level_cfg_set_00);
    
    
    /* Leave FR_POCSTATE_CONFIG state */
    return_value = Fr_leave_configuration_mode();
    if(return_value == FR_NOT_SUCCESS)
        Failed(2);   /* Call debug function in case of any error */

    /* Retrieve the wakeup state */
    wakeup_status = Fr_get_wakeup_state();
    
    /* Check whether a wakeup pattern has been received */
    if(wakeup_status == FR_WAKEUPSTATE_UNDEFINED)
    {   /* No wakeup pattern has been received */
        /* Initiate wakeup procedure */
        return_value = Fr_send_wakeup();
        if(return_value == FR_NOT_SUCCESS)
            Failed(3);   /* Call debug function in case of any error */    
    }
    
   
    protocol_state = Fr_get_POC_state();    /* Load current POC state */
    
    /* Wait till the FR CC is not in the FR_POCSTATE_READY */
    while(Fr_get_POC_state() != FR_POCSTATE_READY)  
    {
        protocol_state = Fr_get_POC_state();    /* Load current POC state */
    }  
                 
} 


/************************************************************************************/

