/*******************************************************************************/
/**
Copyright (c) 2007 Freescale Semiconductor
Freescale Confidential Proprietary
\file       S12XFRIPLL.h
\brief      S12XF512 FlexRay IPLL module definitions 
\author     Freescale Semiconductor
\author     Guadalajara Applications Laboratory RTAC Americas
\author     Jaime Orozco
\version    1.0
\date       March/09/2007
*/
/*******************************************************************************/
/*                                                                             */
/* All software, source code, included documentation, and any implied know-how */
/* are property of Freescale Semiconductor and therefore considered            */ 
/* CONFIDENTIAL INFORMATION.                                                   */
/*                                                                             */
/* This confidential information is disclosed FOR DEMONSTRATION PURPOSES ONLY. */
/*                                                                             */
/* All Confidential Information remains the property of Freescale Semiconductor*/
/* and will not be copied or reproduced without the express written permission */
/* of the Discloser, except for copies that are absolutely necessary in order  */
/* to fulfill the Purpose.                                                     */
/*                                                                             */
/* Services performed by FREESCALE in this matter are performed AS IS and      */
/* without any warranty. CUSTOMER retains the final decision relative to the   */
/* total design and functionality of the end product.                          */
/*                                                                             */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the    */
/* success of this project.                                                    */
/*                                                                             */
/* FREESCALE disclaims all warranties, express, implied or statutory including,*/
/* but not limited to, implied warranty of merchantability or fitness for a    */
/* particular purpose on any hardware, software or advise supplied to the      */
/* project by FREESCALE, and or any product resulting from FREESCALE services. */
/*                                                                             */
/* In no event shall FREESCALE be liable for incidental or consequential       */
/* damages arising out of this agreement. CUSTOMER agrees to hold FREESCALE    */
/* harmless against any and all claims demands or actions by anyone on account */
/* of any damage,or injury, whether commercial, contractual, or tortuous,      */
/* rising directly or indirectly as a result of the advise or assistance       */
/* supplied CUSTOMER in connection with product, services or goods supplied    */
/* under this Agreement.                                                       */
/*                                                                             */
/*******************************************************************************/

#ifndef S12XFRIPLL_H         /*prevent duplicated includes */
#define S12XFRIPLL_H


/*** CGMSYN - CGM Synthesizer Register; 0x00000300 ***/
typedef union {
  byte Byte;
  struct {
    byte SYN0        :1;                                       
    byte SYN1        :1;                                       
    byte SYN2        :1;                                       
    byte SYN3        :1;                                       
    byte SYN4        :1;                                       
    byte SYN5        :1;                                       
    byte VCOFRQ0     :1;                                       
    byte VCOFRQ1     :1; 
  } Bits;
  struct {
    byte grpSYN  :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} CGMSYNSTR;
extern volatile CGMSYNSTR _CGMSYN @(REG_BASE + 0x00000300);
#define CGMSYN                            _CGMSYN.Byte
#define CGMSYN_SYN0                       _CGMSYN.Bits.SYN0
#define CGMSYN_SYN1                       _CGMSYN.Bits.SYN1
#define CGMSYN_SYN2                       _CGMSYN.Bits.SYN2
#define CGMSYN_SYN3                       _CGMSYN.Bits.SYN3
#define CGMSYN_SYN4                       _CGMSYN.Bits.SYN4
#define CGMSYN_SYN5                       _CGMSYN.Bits.SYN5
#define CGMSYN_SYN                        _CGMSYN.MergedBits.grpSYN
#define CGMSYN_VCOFRQ0                    _CGMSYN.Bits.VCOFRQ0
#define CGMSYN_VCOFRQ1                    _CGMSYN.Bits.VCOFRQ1

#define CGMSYN_SYN0_MASK                  1
#define CGMSYN_SYN1_MASK                  2
#define CGMSYN_SYN2_MASK                  4
#define CGMSYN_SYN3_MASK                  8
#define CGMSYN_SYN4_MASK                  16
#define CGMSYN_SYN5_MASK                  32
#define CGMSYN_SYN_MASK                   63
#define CGMSYN_SYN_BITNUM                 0
#define CGMSYN_VCOFRQ0_MASK               64
#define CGMSYN_VCOFRQ1_MASK               128


/*** CGMREF - CGM Reference Divider Register; 0x00000301 ***/
typedef union {
  byte Byte;
  struct {
    byte REFDIV0     :1;                                       
    byte REFDIV1     :1;                                       
    byte REFDIV2     :1;                                       
    byte REFDIV3     :1;                                       
    byte REFDIV4     :1;                                       
    byte REFDIV5     :1;                                       
    byte REFFRQ0     :1;                                       
    byte REFFRQ1     :1; 
  } Bits;
  struct {
    byte grpREFDIV :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} CGMREFSTR;
extern volatile CGMREFSTR _CGMREF @(REG_BASE + 0x00000301);
#define CGMREF                           _CGMREF.Byte
#define CGMREF_REFDIV0                    _CGMREF.Bits.REFDIV0
#define CGMREF_REFDIV1                    _CGMREF.Bits.REFDIV1
#define CGMREF_REFDIV2                    _CGMREF.Bits.REFDIV2
#define CGMREF_REFDIV3                    _CGMREF.Bits.REFDIV3
#define CGMREF_REFDIV4                    _CGMREF.Bits.REFDIV4
#define CGMREF_REFDIV5                    _CGMREF.Bits.REFDIV5
#define CGMREF_REFDIV                     _CGMREF.MergedBits.grpREFDIV
#define CGMREF_REFFRQ0                   _CGMREF.Bits.REFFRQ0
#define CGMREF_REFFRQ1                   _CGMREF.Bits.REFFRQ1

#define CGMREF_REFDIV0_MASK               1
#define CGMREF_REFDIV1_MASK               2
#define CGMREF_REFDIV2_MASK               4
#define CGMREF_REFDIV3_MASK               8
#define CGMREF_REFDIV4_MASK               16
#define CGMREF_REFDIV5_MASK               32
#define CGMREF_REFDIV_MASK                63
#define CGMREF_REFDIV_BITNUM              0
#define CGMREF_REFFRQ0_MASK              64
#define CGMREF_REFFRQ1_MASK              128
 


/*** CGMFLG - CGM Flags Register; 0x00000303 ***/
typedef union {
  byte Byte;
  struct {
    byte UNLOCKF     :1;    
    byte             :1;
    byte             :1; 
    byte LOCK        :1;
    byte LOCKIF      :1;
    byte             :1;
    byte             :1;
    byte LOCKIE      :1;
  } Bits;
} CGMFLGSTR;
extern volatile CGMFLGSTR _CGMFLG @(REG_BASE + 0x00000303);
#define CGMFLG                          _CGMFLG.Byte
#define CGMFLG_UNLOCKF                  _CGMFLG.Bits.UNLOCKF
#define CGMFLG_LOCK                     _CGMFLG.Bits.LOCK
#define CGMFLG_LOCKIF                   _CGMFLG.Bits.LOCKIF
#define CGMFLG_LOCKIE                   _CGMFLG.Bits.LOCKIE

#define CGMFLG_UNLOCKF_MASK             1
#define CGMFLG_LOCK_MASK                8
#define CGMFLG_LOCKIF_MASK              16
#define CGMFLG_LOCKIE_MASK              128



/*** CGMCTL - CGM CGM Control Register; 0x00000304 ***/
typedef union {
  byte Byte;
  struct {
    byte PLLON       :1;
    byte FM0         :1;                                       
    byte FM1         :1;                                         
    byte DIV2        :1;                                       
    byte             :1;                                       
    byte             :1;                                                                                
    byte             :1;                                       
    byte             :1;                                       
  } Bits;
} CGMCTLSTR;
extern volatile CGMCTLSTR _CGMCTL @(REG_BASE + 0x00000304);
#define CGMCTL                          _CGMCTL.Byte
#define CGMCTL_PLLON                    _CGMCTL.Bits.PLLON
#define CGMCTL_FM0                      _CGMCTL.Bits.FM0
#define CGMCTL_FM1                      _CGMCTL.Bits.FM1
#define CGMCTL_DIV2                     _CGMCTL.Bits.DIV2

#define CGMCTL_PLLON_MASK               1    
#define CGMCTL_FM0_MASK                 2
#define CGMCTL_FM1_MASK                 4
#define CGMCTL_DIV2_MASK                8


#endif   /*S12XFRIPLL_H */

/*******************************************************************************/