/*******************************************************************************/
/**
Copyright (c) 2007 Freescale Semiconductor
Freescale Confidential Proprietary
\file       Scheduler.c
\brief      Task scheduler.
\author     Freescale Semiconductor
\author     Guadalajara Applications Laboratory RTAC Americas
\author     Jaime Orozco
\version    1.3
\date       March/12/2007
*/
/*******************************************************************************/
/*                                                                             */
/* All software, source code, included documentation, and any implied know-how */
/* are property of Freescale Semiconductor and therefore considered            */ 
/* CONFIDENTIAL INFORMATION.                                                   */
/*                                                                             */
/* This confidential information is disclosed FOR DEMONSTRATION PURPOSES ONLY. */
/*                                                                             */
/* All Confidential Information remains the property of Freescale Semiconductor*/
/* and will not be copied or reproduced without the express written permission */
/* of the Discloser, except for copies that are absolutely necessary in order  */
/* to fulfill the Purpose.                                                     */
/*                                                                             */
/* Services performed by FREESCALE in this matter are performed AS IS and      */
/* without any warranty. CUSTOMER retains the final decision relative to the   */
/* total design and functionality of the end product.                          */
/*                                                                             */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the    */
/* success of this project.                                                    */
/*                                                                             */
/* FREESCALE disclaims all warranties, express, implied or statutory including,*/
/* but not limited to, implied warranty of merchantability or fitness for a    */
/* particular purpose on any hardware, software or advise supplied to the      */
/* project by FREESCALE, and or any product resulting from FREESCALE services. */
/*                                                                             */
/* In no event shall FREESCALE be liable for incidental or consequential       */
/* damages arising out of this agreement. CUSTOMER agrees to hold FREESCALE    */
/* harmless against any and all claims demands or actions by anyone on account */
/* of any damage,or injury, whether commercial, contractual, or tortuous,      */
/* rising directly or indirectly as a result of the advise or assistance       */
/* supplied CUSTOMER in connection with product, services or goods supplied    */
/* under this Agreement.                                                       */
/*                                                                             */
/*******************************************************************************/

/** S12X derivative information */ 
#include "M9S12XF512.h"     

/** Macro definitions for general purpose I/O handling  */
#include "GPIO_macros.h"

/** Variable types and common definitions */
#include "typedefs.h"   

/** CAN channel definitions and function prototypes  */
#include "CAN_driver.h"

/** Error flag for CAN transmission*/
UINT8 u8ErrorFlag = NO_ERR;
    
/** Transmission buffer */
UINT8 u8TxBuffer[] = "S12XF512";


/*******************************************************************************/
/**
* \brief    Scheduler - Real Time Interrupt service routine
* \author   Jaime Orozco
* \param    u8Task: Code associated to a task
* \return   void
*/
UINT8 u8Scheduler(UINT8 u8Task)
{      
    CRGFLG_RTIF = 1;       /* Clear the real time interrupt flag */        
    
    LED_TOGGLE(D22);       /* Set LED indicator */  
    
        switch (u8Task)    /* Scheduler */
        {
            case 2:                                  
                /* Set CAN transmission indicator */ 
                LED_ON(D27);   
                
                /* CAN frame transmission */     
                u8ErrorFlag = u8CAN_SendFrame((ST_ID_100),
                                 0x00, sizeof(u8TxBuffer)-1, u8TxBuffer);            
                break;
                
            case 4:
                /* Clear CAN transmission and reception indicators */
                LED_OFF(D27);
                LED_OFF(D29);                         
                break;
                
            case 6:               
                u8Task = 0;     /* Initialize the task code */                                              
                break;
                
            default:   
                /* Set FlexRay activity indicators */ 
                LED_ON(D23);
                LED_ON(D25);
                LED_ON(D28);               
                break;  
        }
        
        return u8Task+1;        /* Update the task code */                
}

/*******************************************************************************/