/*******************************************************************************/
/**
Copyright (c) 2007 Freescale Semiconductor
Freescale Confidential Proprietary
\file       CAN_driver.c
\brief      MSCAN initialization and CAN frames basic functions
\author     Freescale Semiconductor
\author     Guadalajara Applications Laboratory RTAC Americas
\author     Jaime Orozco
\version    1.1
\date       March/09/2007   
*/
/*******************************************************************************/
/*                                                                             */
/* All software, source code, included documentation, and any implied know-how */
/* are property of Freescale Semiconductor and therefore considered            */ 
/* CONFIDENTIAL INFORMATION.                                                   */
/*                                                                             */
/* This confidential information is disclosed FOR DEMONSTRATION PURPOSES ONLY. */
/*                                                                             */
/* All Confidential Information remains the property of Freescale Semiconductor*/
/* and will not be copied or reproduced without the express written permission */
/* of the Discloser, except for copies that are absolutely necessary in order  */
/* to fulfill the Purpose.                                                     */
/*                                                                             */
/* Services performed by FREESCALE in this matter are performed AS IS and      */
/* without any warranty. CUSTOMER retains the final decision relative to the   */
/* total design and functionality of the end product.                          */
/*                                                                             */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the    */
/* success of this project.                                                    */
/*                                                                             */
/* FREESCALE disclaims all warranties, express, implied or statutory including,*/
/* but not limited to, implied warranty of merchantability or fitness for a    */
/* particular purpose on any hardware, software or advise supplied to the      */
/* project by FREESCALE, and or any product resulting from FREESCALE services. */
/*                                                                             */
/* In no event shall FREESCALE be liable for incidental or consequential       */
/* damages arising out of this agreement. CUSTOMER agrees to hold FREESCALE    */
/* harmless against any and all claims demands or actions by anyone on account */
/* of any damage,or injury, whether commercial, contractual, or tortuous,      */
/* rising directly or indirectly as a result of the advise or assistance       */
/* supplied CUSTOMER in connection with product, services or goods supplied    */
/* under this Agreement.                                                       */
/*                                                                             */
/*******************************************************************************/

/** S12X derivative information */ 
#include "M9S12XF512.h"   

/** CAN channel definitions  */
#include "CAN_driver.h"

/*******************************************************************************/
/**
* \brief    MSCAN configuration, baud rate = 500kbps, 16 bit acceptance filters
* \author   Jaime Orozco
* \param    void
* \return   void
*/
void vfnCAN_Init(void) 
{
    CAN0CTL0 = 0x01;    /* MSCAN in initialization mode */
        while (!(CAN0CTL1_INITAK))
            ;	        /* Wait for initialization mode acknowledge */
            
    CAN0CTL1_CANE = 1;      /* Enable MSCAN module */
    CAN0CTL1_CLKSRC = 0;    /* Clock source is OSCCLK, CANCLK = 4MHz */    
    CAN0CTL1_LOOPB = 0;     /* Set to 1 for LoopBack Mode, 0 otherwise */
    CAN0CTL1_LISTEN = 0;    /* Not listen only mode */            
           
    /* Baud rate = CANCLK/(Prescaler * time quantas) */                                                                           
    CAN0BTR1_TSEG_10 = 0x04;    /* Time Segment 1 = 5 */
    CAN0BTR1_TSEG_20 = 0x01;    /* Time Segment 2 = 2 */
                                /* TSEG1 + TSEG2 + SYNCH_SEG = 8 time quantas */                              
                                    
    /* Prescaler = CANCLK/(Baud rate * time quantas) = 4MHz/(500kHz * 8) = 1 */    
    CAN0BTR0_BRP = 0x00;    /* Baud rate prescaler = 1 */  
    CAN0BTR0_SJW = 0x01;    /* Sinchronization jump width = 2 clock cycles */
                                  
    CAN0BTR1_SAMP = 0;      /* One sample per bit */	      
         
    
    CAN0IDAC_IDAM = 0x01;               /* Four 16-bit acceptance filters */                                                          
    
    CAN0IDAR0 = ACC_CODE_ID100_HIGH;    /* 16 bit Filter 0 */
    CAN0IDMR0 = MASK_CODE_ST_ID_HIGH;   
    CAN0IDAR1 = ACC_CODE_ID100_LOW;     
    CAN0IDMR1 = MASK_CODE_ST_ID_LOW;    
    
    CAN0IDAR2 = 0x00;                   /* 16 bit Filter 1 */
    CAN0IDMR2 = MASK_CODE_ST_ID_HIGH;   
    CAN0IDAR3 = 0x00;                   
    CAN0IDMR3 = MASK_CODE_ST_ID_LOW;    
    
    CAN0IDAR4 = 0x00;                   /* 16 bit Filter 2 */
    CAN0IDMR4 = MASK_CODE_ST_ID_HIGH;   
    CAN0IDAR5 = 0x00;                   
    CAN0IDMR5 = MASK_CODE_ST_ID_LOW;    
    
    CAN0IDAR6 = 0x00;                   /* 16 bit Filter 3 */
    CAN0IDMR6 = MASK_CODE_ST_ID_HIGH;   
    CAN0IDAR7 = 0x00;                   
    CAN0IDMR7 = MASK_CODE_ST_ID_LOW;    
    
    
    CAN0CTL0 = 0x00;            /* Exit initialization mode request */
        while (CAN0CTL1_INITAK)
            ;               	/* Wait for normal mode */
                   
        while(!(CAN0CTL0_SYNCH))
            ;                   /* Wait for CAN synchronization */
   
    CAN0RFLG_RXF = 1;       /* Clear receiver flags */                                   
    CAN0RIER_RXFIE = 1;     /* Enable Full Receive Buffer interrupt */
                                  
}

/*******************************************************************************/
/**
* \brief    CAN frame transmission
* \author   Jaime Orozco
* \param    u32ID: Identifier, u8Prio: Priority, \n
            u8Length: Frame size, u8TxData: Data array
* \return   void
*/
UINT8 u8CAN_SendFrame(UINT32 u32ID, UINT8 u8Prio, UINT8 u8Length, UINT8 *u8TxData)
{   
    /* Transmission buffer */
    UINT8 u8TxBuffer = {0};
    
    /* Index to data within the transmission buffer */ 
    UINT8 u8Index;
    
    if (!CAN0TFLG)              /* Retrun if Transmit Buffer is full */
        return ERR_BUFFER_FULL;

    CAN0TBSEL = CAN0TFLG;       /* Select lowest empty buffer */
    u8TxBuffer = CAN0TBSEL;		/* Backup selected buffer */
    
    
    *((UINT32 *) ((UINT32)(&CAN0TXIDR0)))= u32ID;   /* Load Id to IDR Registers */
        
        /* Load data to Data Segment Registers */
        for (u8Index=0;u8Index<u8Length;u8Index++) {
            *(&CAN0TXDSR0 + u8Index) = u8TxData[u8Index];  
        }

    CAN0TXDLR = u8Length;   /* Set Data Length Code */
    CAN0TXTBPR = u8Prio;    /* Set Priority */

    CAN0TFLG = u8TxBuffer;  /* Start transmission */
                
        while ( (CAN0TFLG & u8TxBuffer) != u8TxBuffer)
            ;  /* Wait for Transmission completion */
            
    return NO_ERR;
 }

/*******************************************************************************/
/**
* \brief    Read CAN reception buffer
* \author   Jaime Orozco
* \param    void
* \return   void
*/
void vfnCAN_ReceivedFrame(void)
{
    /* Length of received frame */
    UINT8 u8Length;
    
    /* Index for extracting/storing received data */
    UINT8 u8Index;
    
    /* Reception array */
    UINT8 u8RxData[8];

    u8Length = (CAN0RXDLR & 0x0F);  /* Extract received frame data length */
	
	    /* Read and store each of the received data */
	    for (u8Index=0; u8Index<u8Length; u8Index++)
  	        u8RxData[u8Index] = *(&CAN0RXDSR0 + u8Index); 

    CAN0RFLG_RXF = 1;   /* Clear reception flag */     
}

/*******************************************************************************/