/******************************************************************************
*
*       COPYRIGHT (c) 2001-2003 MOTOROLA INC.
*       ALL RIGHTS RESERVED
*
*       The code is the property of Motorola.
*
*       The copyright notice above does not evidence any
*       actual or intended publication of such source code.
*
* Filename:     $Source: /proj/cvsroot/mgt/MGT5200/apps/AC97Sample/src/configure.h,v $
* Author:       $Author: ra6707 $
* Locker:       $Locker:  $
* State:        $State: Exp $
* Revision:     $Revision: 1.1 $
*
* Functions:    
*
* History:      Use the RCS command rlog to display revision history
*               information.
*
* Description:  
*
* Notes:                
*
******************************************************************************/

#define MHz *1000000


/*****************************************************************************
 * GENERIC SETTINGS
 * Used in multiple modules
 *****************************************************************************/

/*
 * Exactly one of these defines must be active. By that the processor type is
 * defined.
 */
/*
#define MGT5100
*/
#define MGT5200

/*
 * QUARTZ_FREQ defines the frequency of the external quartz. The define is used
 * if no calibration of the external quartz is desired or the calibration
 * yields inacceptable results.
 */
#define QUARTZ_FREQ	(33 MHz)
 
/*
 * If IPBI_FREQ is defined it must be set to the IPBI frequency. If it is not
 * defined a call to freqIPBI () will determine IPBI frequency.
 * NOTE: A call to freqIPBI () can take up to two seconds.
 */ 
/*
#define IPBI_FREQ	(QUARTZ_FREQ * 1)
*/

/*
 * If XLB_FREQ is defined it must be set to the XLB bus frequency. If it is not
 * defined a call to freqXLB () will determine XLB bus frequency.
 * NOTE: A call to freqXLB () can take up to two seconds.
 */ 
/*
#define XLB_FREQ	(QUARTZ_FREQ * 2)
*/


/*****************************************************************************
 * FREQUENCY SETTINGS
 * Used to configure the Frequency module
 *****************************************************************************/
/*
 * If NO_FREQ_CALIBRATION is defined, the value of QUARTZ_FREQ will be taken as
 * the frequency of the external quartz. Otherwise, the frequency of the
 * external quartz is calculated using an internal timer (SCTMR or DEC) and the
 * RTC.
 */
/* 
#define NO_FREQ_CALIBRATION
*/

/*
 * QUARTZ_FREQ_MIN and QUARTZ_FREQ_MAX define the range in which a calibrated
 * frequency of the external quartz will be accepted. If the frequency is not
 * from withing this range QUARTZ_FREQ is taken instead.
 */
#define QUARTZ_FREQ_MIN		(26 MHz)
#define QUARTZ_FREQ_MAX		(34 MHz)

/*
 * If USE_SCTMR is defined SmartComm Timer 1 will be used instead of the
 * Decrementer for calibrating the quartz. Please note that using the
 * Decrementer should be favoured as it offers a higher accuracy.
 */
/* 
#define USE_SCTMR
*/
 

/*****************************************************************************
 * PSC UART SETTINGS
 * Used to configure the PSC UART module
 *****************************************************************************/

/*
 * PSC_UART_PORT defines which PSC to use.
 */ 
#define PSC_UART_PORT 	3


/*
 * If PSC_UART_NOINIT_dBUG is defined the PSC UART will not be initialized for
 * the dBUG Version target. Thus, if PSC_UART_NOINIT_dBUG is defined and the
 * target is dBUG Version the settings of PSC_UART_BAUDRATE and
 * HARDWARE_FLOW_CTRL will be irgnored.
 */
#define PSC_UART_NOINIT_dBUG

/*
 * If PSC_UART_BAUDRATE is defined the baudrate set by MSL (57600) is overruled
 * and set to the value of PSC_UART_BAUDRATE. 
 */
#define PSC_UART_BAUDRATE	115200

/*
 * If HARDWARE_FLOW_CTRL is defined hardware flow control will be enabled
 * during initilization of the UART.
 */
/* #define HARDWARE_FLOW_CTRL */

/*
 * If RCV_ECHO is defined every received character will be echoed.
 */
#define RCV_ECHO

/*
 * If SND_LF_TO_CRLF is defined and a LF should be send actually a CR followed
 * by a LF is send.
 */
#define SND_LF_TO_CRLF

/*
 * If RCV_CR_TO_LF is defined a received CR will be translated into a LF.
 */
#define RCV_CR_TO_LF


/*****************************************************************************
 * ENCHILADA SETTINGS
 * Used to configure the Enchilada board module
 *****************************************************************************/

/*
 * CPLD_ADDR must match the address Enchilada's CPLD is mapped to.
 */
#define CPLD_ADDR	0x30000000UL
