/******************************************************************************
*
*       COPYRIGHT (c) 2001 MOTOROLA INC.
*       ALL RIGHTS RESERVED
*
*       The code is the property of Sector Technology and is Motorola
*       Confidential Proprietary Information.
*
*       The copyright notice above does not evidence any
*       actual or intended publication of such source code.
*
* Filename:     $Source: /proj/cvsroot/mgt/MGT5200/apps/AC97Sample/modules/Exceptions/exc5xxx.asm,v $
* Author:       $Author: ra6707 $
* Locker:       $Locker:  $
* State:        $State: Exp $
* Revision:     $Revision: 1.1 $
*
* Functions:    
*
* History:      Use the RCS command rlog to display revision history
*               information.
*
* Description:  
*
* Notes:                
*
******************************************************************************/

/*
 * void exceptionHandlerMaster (uint32 excvec)
 */
.extern exceptionHandlerMaster

/*
 * exception_prologue saves all EABI volatile registers plus CTR, XER, CR, LR,
 * SRR0 and SRR1 in a stack frame. All other GPRs will be saved by the
 * exception handler written in C as they are EABI nonvolatile and thefore the
 * C compiler has to take care of them.
 *
 * ATTENTION: EABI volatile floating-point registers are not saved. Therefore,
 * modifying floating-point registers is not allowed during exception handling.
 */
exception_prologue: 	.macro
	
				stwu     rsp,-80(rsp)		// allocate space on stack
				stw      r0,8(rsp)			// store R0
				mfsrr0   r0					// store SRR0 (must be stored asap)
				stw      r0,28(rsp)
				mfsrr1   r0					// store SRR1 (must be stored asap)
				stw      r0,32(rsp)
				mfctr    r0					// store CTR
				stw      r0,12(rsp)
				mfxer    r0					// store XER
				stw      r0,16(rsp)
				mfcr     r0					// store CR
				stw      r0,20(rsp)
				mflr     r0					// store LR
				stw      r0,24(rsp)
				stw      r3,40(rsp)			// store R3 
				stw      r4,44(rsp) 		// store R4
				stw      r5,48(rsp) 		// store R5
				stw      r6,52(rsp) 		// store R6
				stw      r7,56(rsp) 		// store R7
				stw      r8,60(rsp) 		// store R8
				stw      r9,64(rsp) 		// store R9
				stw      r10,68(rsp) 		// store R10
				stw      r11,72(rsp) 		// store R11
				stw      r12,76(rsp) 		// store R12

				mfmsr    r0					// modify msr to ...
				ori      r0,r0,0x2000		//   enable floating-point instructions
				li       r3,0x0010			//   enable data address translation if
				mfsrr1   r4					//     it was enabled before
				and      r4,r4,r3
				or       r0,r0,r4
				mtmsr    r0
				isync
	
				.endm

/*
 * exception_epilogue restores the registers stored by exception_prologue.
 * A rfi instruction must immediately follow to not jeopardize the the
 * restored registers.
 */
exception_epilogue: 	.macro

				lwz      r3,40(rsp)			// restore R3
				lwz      r4,44(rsp)			// restore R4
				lwz      r5,48(rsp)			// restore R5
				lwz      r6,52(rsp)			// restore R6
				lwz      r7,56(rsp)			// restore R7
				lwz      r8,60(rsp)			// restore R8
				lwz      r9,64(rsp)			// restore R9
				lwz      r10,68(rsp)		// restore R10
				lwz      r11,72(rsp)		// restore R11
				lwz      r12,76(rsp)		// restore R12
				lwz      r0,24(rsp)			// restore LR
				mtlr     r0
				lwz      r0,20(rsp)			// restore CR
				mtcrf    0xff,r0
				lwz      r0,16(rsp)			// restore XER
				mtxer    r0
				lwz      r0,12(rsp)			// restore CTR
				mtctr    r0
				lwz      r0,32(rsp)			// restore SRR1
				mtsrr1   r0
				lwz      r0,28(rsp)			// restore SRR0
				mtsrr0   r0
				lwz      r0,8(rsp)			// restore R0
				addi     rsp,rsp,80			// deallocate space on stack
				rfi

				.endm

/*
 * crit_irq_prologue saves all EABI volatile registers plus CTR, XER, CR, LR,
 * SRR0 and SRR1 in a stack frame. All other GPRs will be saved by the
 * exception handler written in C as they are EABI nonvolatile and thefore the
 * C compiler has to take care of them.
 *
 * The difference to a normal exception handler prologue is that the registers
 * CSSR0 and CSSR1 are used to store the effective address of the exception and
 * the contents of the MSR register.
 *  
 * ATTENTION: EABI volatile floating-point registers are not saved. Therefore,
 * modifying floating-point registers is not allowed during exception handling.
 */
crit_irq_prologue: 	.macro
	
				stwu     rsp,-88(rsp)		// allocate space on stack
				stw      r0,8(rsp)			// store R0
				mfsrr0   r0					// store SRR0 (must be stored asap)
				stw      r0,28(rsp)
				mfsrr1   r0					// store SRR1 (must be stored asap)
				stw      r0,32(rsp)
				mfspr    r0,58				// store CSRR0
				stw      r0,80(rsp)
				mfspr    r0,59				// store CSRR1
				stw      r0,84(rsp)
				mfctr    r0					// store CTR
				stw      r0,12(rsp)
				mfxer    r0					// store XER
				stw      r0,16(rsp)
				mfcr     r0					// store CR
				stw      r0,20(rsp)
				mflr     r0					// store LR
				stw      r0,24(rsp)
				stw      r3,40(rsp)			// store R3 
				stw      r4,44(rsp) 		// store R4
				stw      r5,48(rsp) 		// store R5
				stw      r6,52(rsp) 		// store R6
				stw      r7,56(rsp) 		// store R7
				stw      r8,60(rsp) 		// store R8
				stw      r9,64(rsp) 		// store R9
				stw      r10,68(rsp) 		// store R10
				stw      r11,72(rsp) 		// store R11
				stw      r12,76(rsp) 		// store R12

				mfmsr    r0					// modify msr to ...
				ori      r0,r0,0x2000		//   enable floating-point instructions
				li       r3,0x0010			//   enable data address translation if
				mfspr    r4,59					//     it was enabled before
				and      r4,r4,r3
				or       r0,r0,r4
				mtmsr    r0
				isync
	
				.endm

/*
 * crit_irq_epilogue restores the registers stored by exception_prologue.
 * A rfci instruction must immediately follow to not jeopardize the the
 * restored registers.
 */
crit_irq_epilogue: 	.macro

				lwz      r3,40(rsp)			// restore R3
				lwz      r4,44(rsp)			// restore R4
				lwz      r5,48(rsp)			// restore R5
				lwz      r6,52(rsp)			// restore R6
				lwz      r7,56(rsp)			// restore R7
				lwz      r8,60(rsp)			// restore R8
				lwz      r9,64(rsp)			// restore R9
				lwz      r10,68(rsp)		// restore R10
				lwz      r11,72(rsp)		// restore R11
				lwz      r12,76(rsp)		// restore R12
				lwz      r0,24(rsp)			// restore LR
				mtlr     r0
				lwz      r0,20(rsp)			// restore CR
				mtcrf    0xff,r0
				lwz      r0,16(rsp)			// restore XER
				mtxer    r0
				lwz      r0,12(rsp)			// restore CTR
				mtctr    r0
				lwz      r0,84(rsp)			// restore CSRR1
				mtspr    59,r0
				lwz      r0,80(rsp)			// restore CSRR0
				mtspr    58,r0
				lwz      r0,32(rsp)			// restore SRR1
				mtsrr1   r0
				lwz      r0,28(rsp)			// restore SRR0
				mtsrr0   r0
				lwz      r0,8(rsp)			// restore R0
				addi     rsp,rsp,88			// deallocate space on stack
				rfci

				.endm

.text	

.globl exceptionTable
exceptionTable:

/*
 * 0x0000 - Free space; to be used OS dependend
 */
.org 0x0000

/*
 * 0x0100 - System Reset Exception
 */
.org 0x0100
		exception_prologue
		
		li		r3,0x0100
		lis		r4,exceptionHandlerMaster@h
		ori		r4,r4,exceptionHandlerMaster@l
		mtlr	r4 
		blrl
		
		exception_epilogue		

/*
 * 0x0200 - Machine Check Exception
 */
.org 0x0200
		exception_prologue
		
		li		r3,0x0200
		lis		r4,exceptionHandlerMaster@h
		ori		r4,r4,exceptionHandlerMaster@l
		mtlr	r4 
		blrl
		
		exception_epilogue
		
/*
 * 0x0300 - Data Storage Interrupt
 */
.org 0x0300
		exception_prologue
			
		li		r3,0x0300
		lis		r4,exceptionHandlerMaster@h
		ori		r4,r4,exceptionHandlerMaster@l
		mtlr	r4 
		blrl
		
		exception_epilogue

/*
 * 0x0400 - Instruction Storage Interrupt
 */
.org 0x0400
		exception_prologue
		
		li		r3,0x0400
		lis		r4,exceptionHandlerMaster@h
		ori		r4,r4,exceptionHandlerMaster@l
		mtlr	r4 
		blrl
		
		exception_epilogue

/*
 * 0x0500 - External Interrupt
 */
.org 0x0500
		exception_prologue
		
		li		r3,0x0500
		lis		r4,exceptionHandlerMaster@h
		ori		r4,r4,exceptionHandlerMaster@l
		mtlr	r4 
		blrl
		
		exception_epilogue

/*
 * 0x0600 - Alignment Exception
 */
.org 0x0600
		exception_prologue
		
		li		r3,0x0600
		lis		r4,exceptionHandlerMaster@h
		ori		r4,r4,exceptionHandlerMaster@l
		mtlr	r4 
		blrl
		
		exception_epilogue

/*
 * 0x0700 - Program Exception
 */
.org 0x0700
		exception_prologue
		
		li		r3,0x0700
		lis		r4,exceptionHandlerMaster@h
		ori		r4,r4,exceptionHandlerMaster@l
		mtlr	r4 
		blrl
		
		exception_epilogue

/*
 * 0x0800 - Floating-Point Unavailable Exception
 */
.org 0x0800
		exception_prologue
		
		li		r3,0x0800
		lis		r4,exceptionHandlerMaster@h
		ori		r4,r4,exceptionHandlerMaster@l
		mtlr	r4 
		blrl
		
		exception_epilogue

/*
 * 0x0900 - Decrementer Exception
 */
.org 0x0900
		exception_prologue
		
		li		r3,0x0900
		lis		r4,exceptionHandlerMaster@h
		ori		r4,r4,exceptionHandlerMaster@l
		mtlr	r4 
		blrl
		
		exception_epilogue

/*
 * 0x0A00 - Critical Interrupt
 *
 * ATTENTION: Right now this code does not take into account that a Critical
 *            Interrupt exception might occur during a page table traversal.
 *            In that case additional registers must be saved. See application
 *            note "MGT5200 Programming Considerations" for additional
 *            information on this topic.
 */
.org 0x0A00
		crit_irq_prologue
		
		li		r3,0x0A00
		lis		r4,exceptionHandlerMaster@h
		ori		r4,r4,exceptionHandlerMaster@l
		mtlr	r4 
		blrl
		
		crit_irq_epilogue

/*
 * 0x0B00 - Reserved
 *
 * Right now the Critical Interrupt Exception handler uses this space.
 *
 .org 0x0B00
 */

/*
 * 0x0C00 - System Call Exception
 */
.org 0x0C00
		exception_prologue
		
		li		r3,0x0C00
		lis		r4,exceptionHandlerMaster@h
		ori		r4,r4,exceptionHandlerMaster@l
		mtlr	r4 
		blrl
		
		exception_epilogue

/*
 * 0x0D00 - Trace Exception
 */
.org 0x0D00
		exception_prologue
		
		li		r3,0x0D00
		lis		r4,exceptionHandlerMaster@h
		ori		r4,r4,exceptionHandlerMaster@l
		mtlr	r4 
		blrl
		
		exception_epilogue

/*
 * 0x0E00 - Floating-Point Assist Exception
 */
.org 0x0E00
		exception_prologue
		
		li		r3,0x0E00
		lis		r4,exceptionHandlerMaster@h
		ori		r4,r4,exceptionHandlerMaster@l
		mtlr	r4 
		blrl
		
		exception_epilogue

/*
 * 0x1000 - Instruction TLB Miss Exception
 */
.org 0x1000
		exception_prologue
		
		li		r3,0x1000
		lis		r4,exceptionHandlerMaster@h
		ori		r4,r4,exceptionHandlerMaster@l
		mtlr	r4 
		blrl
		
		exception_epilogue

/*
 * 0x1100 - Data TLB Miss on Load Exception
 */
.org 0x1100
		exception_prologue
		
		li		r3,0x1100
		lis		r4,exceptionHandlerMaster@h
		ori		r4,r4,exceptionHandlerMaster@l
		mtlr	r4 
		blrl
		
		exception_epilogue

/*
 * 0x1200 - Data TLB Miss on Store Exception
 */
.org 0x1200
		exception_prologue
		
		li		r3,0x1200
		lis		r4,exceptionHandlerMaster@h
		ori		r4,r4,exceptionHandlerMaster@l
		mtlr	r4 
		blrl
		
		exception_epilogue

/*
 * 0x1300 - Instruction Address Breakpoint Exception
 */
.org 0x1300
		exception_prologue
		
		li		r3,0x1300
		lis		r4,exceptionHandlerMaster@h
		ori		r4,r4,exceptionHandlerMaster@l
		mtlr	r4 
		blrl
		
		exception_epilogue

/*
 * 0x1400 - System Management Interrupt
 */
.org 0x1400
		exception_prologue
		
		li		r3,0x1400
		lis		r4,exceptionHandlerMaster@h
		ori		r4,r4,exceptionHandlerMaster@l
		mtlr	r4 
		blrl
		
		exception_epilogue

/*
 * End of Exception Table
 */
.org 0x1500
