#ifndef MGT5200_SCPCI_H
#define MGT5200_SCPCI_H

/*
* (C) Copyright Motorola, Inc., 2000
*     All rights reserved.
*
* Module Name: scpci.h
* Description: tabasco pci header file
* Rev History: see "cvs log scpci.h"
*
* scpci.h,v 1.3 2000/06/09 13:41:15 weintrit Exp
*
*/

typedef struct scpci_register_set {
	/* put scpci register declarations here */
	/*Register 0 is configuration register for Chip Select 0*/
	volatile uint16 tx_packet_size;			/*MBAR_SCPCI + 0x00*/
	volatile uint16 tx_RES0;				/*MBAR_SCPCI + 0x02*/
	volatile uint32 tx_start_add;			/*MBAR_SCPCI + 0x04*/
	volatile uint8  tx_command;			/*MBAR_SCPCI + 0x08*/
	volatile uint8  tx_max_retry;			/*MBAR_SCPCI + 0x09*/
	volatile uint8  tx_max_beats;			/*MBAR_SCPCI + 0x0A*/
	volatile uint8  tx_word;				/*MBAR_SCPCI + 0x0B*/
	volatile uint8  tx_enables;			/*MBAR_SCPCI + 0x0C*/
	volatile uint8  tx_int_en;			/*MBAR_SCPCI + 0x0D*/
	volatile uint8  tx_RES2[2];			/*MBAR_SCPCI + 0x0E*/
	volatile uint32 tx_next_address;			/*MBAR_SCPCI + 0x10*/
	volatile uint32 tx_last_word;			/*MBAR_SCPCI + 0x14*/
	volatile uint16 tx_bytes_done;			/*MBAR_SCPCI + 0x18*/
	volatile uint16 tx_packets_done;			/*MBAR_SCPCI + 0x1A*/
	volatile uint8  tx_ntbit;			/*MBAR_SCPCI + 0x1C*/
	volatile uint8  tx_status;			/*MBAR_SCPCI + 0x1D*/
	volatile uint16 tx_RES3;				/*MBAR_SCPCI + 0x1E*/
	volatile uint32 tx_RES4[8];			/*MBAR_SCPCI + 0x20*/
	volatile uint32 tx_fifo_data;			/*MBAR_SCPCI + 0x40*/
	volatile uint8  tx_fifo_status_frame;		/*MBAR_SCPCI + 0x44*/
	volatile uint8  tx_fifo_status;			/*MBAR_SCPCI + 0x45*/
	volatile uint16 tx_RES5;				/*MBAR_SCPCI + 0x46*/
	volatile uint8  tx_fifo_control;			/*MBAR_SCPCI + 0x48*/
	volatile uint8  tx_fifo_mask;		/*MBAR_SCPCI + 0x49*/
	volatile uint8  tx_RES6[4];			/*MBAR_SCPCI + 0x4A*/
	volatile uint16 tx_fifo_alarm;			/*MBAR_SCPCI + 0x4E*/
	volatile uint16 tx_RES7;				/*MBAR_SCPCI + 0x50*/
	volatile uint16 tx_fifo_rdp;			/*MBAR_SCPCI + 0x52*/
	volatile uint16 tx_RES8;  			/*MBAR_SCPCI + 0x54*/
	volatile uint16 tx_fifo_wrp;			/*MBAR_SCPCI + 0x56*/
	volatile uint16 tx_RES9;				/*MBAR_SCPCI + 0x58*/
	volatile uint16 tx_fifo_lfrdp;			/*MBAR_SCPCI + 0x5A*/
	volatile uint16 tx_RES10;			/*MBAR_SCPCI + 0x5C*/
	volatile uint16 tx_fifo_lfwrp;			/*MBAR_SCPCI + 0x5E*/
	volatile uint32 tx_RES11[8];			/*MBAR_SCPCI + 0x60*/
	/*START RECEIVE SECTION*/
	volatile uint16 rx_packet_size;			/*MBAR_SCPCI + 0x80*/
	volatile uint16 rx_RES0;				/*MBAR_SCPCI + 0x82*/
	volatile uint32 rx_start_add;			/*MBAR_SCPCI + 0x84*/
	volatile uint8  rx_command;			/*MBAR_SCPCI + 0x88*/
	volatile uint8  rx_max_retry;			/*MBAR_SCPCI + 0x89*/
	volatile uint8  rx_max_beats;			/*MBAR_SCPCI + 0x8A*/
	volatile uint8  rx_word;				/*MBAR_SCPCI + 0x8B*/
	volatile uint8  rx_enables;			/*MBAR_SCPCI + 0x8C*/
	volatile uint8  rx_int_en;			/*MBAR_SCPCI + 0x8D*/
	volatile uint8  rx_RES2[2];			/*MBAR_SCPCI + 0x8E*/
	volatile uint32 rx_next_address;			/*MBAR_SCPCI + 0x90*/
	volatile uint32 rx_last_word;			/*MBAR_SCPCI + 0x94*/
	volatile uint16 rx_bytes_done;			/*MBAR_SCPCI + 0x98*/
	volatile uint16 rx_packets_done;			/*MBAR_SCPCI + 0x9A*/
	volatile uint8  rx_ntbit;			/*MBAR_SCPCI + 0x9C*/
	volatile uint8  rx_status;			/*MBAR_SCPCI + 0x9D*/
	volatile uint16 rx_RES3;				/*MBAR_SCPCI + 0x9E*/
	volatile uint32 rx_RES4[8];			/*MBAR_SCPCI + 0xA0*/
	volatile uint32 rx_fifo_data;			/*MBAR_SCPCI + 0xC0*/
	volatile uint8  rx_fifo_status_frame;		/*MBAR_SCPCI + 0xC4*/
	volatile uint8  rx_fifo_status;			/*MBAR_SCPCI + 0xC5*/
	volatile uint16 rx_RES5;				/*MBAR_SCPCI + 0xC6*/
	volatile uint8  rx_fifo_control;			/*MBAR_SCPCI + 0xC8*/
	volatile uint8  rx_fifo_mask;			/*MBAR_SCPCI + 0xC9*/
	volatile uint8  rx_RES6[4];			/*MBAR_SCPCI + 0xCA*/
	volatile uint16 rx_fifo_alarm;			/*MBAR_SCPCI + 0xCE*/
	volatile uint16 rx_RES7;				/*MBAR_SCPCI + 0xD0*/
	volatile uint16 rx_fifo_rdp;			/*MBAR_SCPCI + 0xD2*/
	volatile uint16 rx_RES8;  			/*MBAR_SCPCI + 0xD4*/
	volatile uint16 rx_fifo_wrp;			/*MBAR_SCPCI + 0xD6*/
	volatile uint16 rx_RES9;				/*MBAR_SCPCI + 0xD8*/
	volatile uint16 rx_fifo_lfrdp;			/*MBAR_SCPCI + 0xDA*/
	volatile uint16 rx_RES10;			/*MBAR_SCPCI + 0xDC*/
	volatile uint16 rx_fifo_lfwrp;			/*MBAR_SCPCI + 0xDE*/
	volatile uint32 rx_RES11[8];			/*MBAR_SCPCI + 0xE0*/
} scpci_regs;

#define PCI_CMD_INTACK			0x00
#define PCI_CMD_SCYCLE			0x01
#define PCI_CMD_IOREAD			0x02
#define PCI_CMD_IOWRITE			0x03
#define PCI_CMD_MEMREAD			0x06
#define PCI_CMD_MEMWRITE		0x07
#define PCI_CMD_CONFREAD		0x0A
#define PCI_CMD_CONFWRITE		0x0B
#define PCI_CMD_MEMREADMULT		0x0C
#define PCI_CMD_DUALADDRCYCLE	0x0D
#define PCI_CMD_MEMREADLINE		0x0E
#define PCI_CMD_MEMWRITEINVAL	0x0F

#define SCPCI_TX_ENABLES_RC		0x80
#define SCPCI_TX_ENABLES_RF		0x40
#define SCPCI_TX_ENABLES_CM		0x10
#define SCPCI_TX_ENABLES_BE		0x08
#define SCPCI_TX_ENABLES_ME		0x01

#define SCPCI_TX_INT_EN_FEE		0x20
#define SCPCI_TX_INT_EN_SE		0x10
#define SCPCI_TX_INT_EN_RE		0x08
#define SCPCI_TX_INT_EN_TAE		0x04
#define SCPCI_TX_INT_EN_IAE		0x02
#define SCPCI_TX_INT_EN_NE		0x01

#define SCPCI_TX_NTBIT_NT		0x01

#define SCPCI_TX_STATUS_BE3		0x80
#define SCPCI_TX_STATUS_BE2		0x40
#define SCPCI_TX_STATUS_BE1		0x20
#define SCPCI_TX_STATUS_FE		0x10
#define SCPCI_TX_STATUS_SE		0x08
#define SCPCI_TX_STATUS_RE		0x04
#define SCPCI_TX_STATUS_TA		0x02
#define SCPCI_TX_STATUS_IA		0x01

#define SCPCI_RX_ENABLES_RC		0x80
#define SCPCI_RX_ENABLES_RF		0x40
#define SCPCI_RX_ENABLES_FE		0x20
#define SCPCI_RX_ENABLES_CM		0x10
#define SCPCI_RX_ENABLES_BE		0x08
#define SCPCI_RX_ENABLES_ME		0x01

#define SCPCI_RX_INT_EN_FEE		0x20
#define SCPCI_RX_INT_EN_SE		0x10
#define SCPCI_RX_INT_EN_RE		0x08
#define SCPCI_RX_INT_EN_TAE		0x04
#define SCPCI_RX_INT_EN_IAE		0x02
#define SCPCI_RX_INT_EN_NE		0x01

#define SCPCI_RX_NTBIT_NT		0x01

#define SCPCI_RX_STATUS_BE3		0x80
#define SCPCI_RX_STATUS_BE2		0x40
#define SCPCI_RX_STATUS_BE1		0x20
#define SCPCI_RX_STATUS_FE		0x10
#define SCPCI_RX_STATUS_SE		0x08
#define SCPCI_RX_STATUS_RE		0x04
#define SCPCI_RX_STATUS_TA		0x02
#define SCPCI_RX_STATUS_IA		0x01

#endif /* MGT5200_SCPCI_H */
