
/***********************************************************************
 * Defines the SmartDMA internal debug register interface, access with
 * the SDMA_DBG_PTD, SDMA_DBG_ADS, SDMA_DBG_MDE macros in dmacntrl.h
 ***********************************************************************/

#define SDMA_PTD_CREQUEST        0
#define SDMA_PTD_INIT            1
#define SDMA_PTD_TASK_VALID      2
#define SDMA_PTD_HOLD_OR_INIT    3
#define SDMA_PTD_TASK_ENABLE     4
#define SDMA_PTD_TASK_RUN        5
#define SDMA_PTD_DBG_TASK_BLK    6
#define SDMA_PTD_ALWAYS_INIT     7
#define SDMA_PTD_TASK_START      8

#define SDMA_ADS_IDX(i)          i
#define SDMA_ADS_TERM_REG(i)    24+i
#define SDMA_ADS_CMP_ATERM      38
#define SDMA_ADS_CMP_BTERM      39

#define SDMA_MDE_VERSION         0
#define SDMA_MDE_STATE           1
#define SDMA_MDE_LCD(i)          2+i
#define SDMA_MDE_DRD(i)          6+i
#define SDMA_MDE_CURR_DRD       14
#define SDMA_MDE_PARSE_PTR      15
#define SDMA_MDE_PARSE_PTRD     16
#define SDMA_MDE_PREFETCH       17
#define SDMA_MDE_RD_ADDR        18
#define SDMA_MDE_WR_ADDR        19
#define SDMA_MDE_WR_DATA        20
#define SDMA_MDE_ST_PTR         21
#define SDMA_MDE_CURR_PTR_TRG   22
#define SDMA_MDE_RD_DATA        23
#define SDMA_MDE_RUN_STATE      24
#define SDMA_MDE_PARSE_STATE    25
#define SDMA_MDE_CURR_PTR       32

/***********************************************************************
 * Contents of the MDE debug regsiters
 ***********************************************************************
MDEDebug:
---------
SDMA_MDE_STATE:
    mdeState[2:0],
    parseAddressState[3:0],
    parseDataState[3:0],
    setupTaskAddressState[4:0],
    setupTaskDataState[4:0],
    1'b0, decodeLcdAddressState[3:0],
    decodeLcdDataState[4:0],
    contextSaveState[4:0],
    contextSaveAddressState[1:0]
SDMA_MDE_LCD(i):
    i=0  lcd0
    i=1  lcd1
    i=2  lcdA
    i=3  lcdD
SDMA_MDE_PREFETCH:
    prefetchBuffer[31:4],
    prefetchNestLevel[2:0],
    prefetchValid
SDMA_MDE_RD_ADDR:
    mdeReadAddress[31:2],
    mdeReadAddressPhaseB,
    1'b0
SDMA_MDE_WR_ADDR:
    mdeWriteAddress[31:2],
    mdeWriteAddressPhaseB,
    1'b0
SDMA_MDE_RUN_STATE:
    currentTaskNumber[3:0],
    currentNestLevel[2:0],
    nextFetchNestLevel[2:0],
    decodeNestLevelA[2:0],
    decodeNestLevelD[2:0],
    taskControl[7:0],
    drdValid[7:0]
SDMA_MDE_PARSE_STATE:
    morePending[7:1],
    previousMorePending[7:1],
    morePendingDrd,
    regParseForward,
    restoreFlag,
    restoreContext,
    rcdState[1:0],
    contextRestored,
    skipMultiples,
    skipToCurrentPointer,
    consecutiveCurrentPointer,
    firstDrdInCache[7:0]
SDMA_MDE_26:
    levelStarted[7:1],
    1'b0,
    multipleLcd,
    regMultipleLcd,
    drdCacheFull,
    regDrdCacheFull,
    regDrdCacheOverflow,
    restoreConsecutiveLcds[17:0]
SDMA_MDE_27:
    consecutiveLcds[17:0],
    initialEncounteredNestLevel[7:0],
    encounteredNestLevel[7:0]
SDMA_MDE_28:
    adsStopped,
    failNestLevel[2:0],
    extensionCounts[27:0]
SDMA_MDE_29:
    previousDescriptorAddressPlus4[31:0]
SDMA_MDE_30:
    regMdeNextState[2:0],
    regParseNextAddressState[3:0],
    regParseNextDataState[3:0],
    regSetupTaskNextAddressState[4:0],
    regSetupTaskNextDataState[4:0],
    1'b0, regDecodeLcdNextAddressState[3:0],
    regDecodeLcdNextDataState[4:0],
    regContextSaveNextState[4:0],
    regContextSaveNextAddressState[1:0]
SDMA_MDE_31:
    27'd0,
    initiator,
    differentTask,
    saveNestLevel[2:0]


ADSDebug:
---------
SDMA_ADS_16:
   5'b00000;  
   termIncrementTag0[2:0];  
   {1'b0,loopIndexTag0[2:0]};
   compareTypeIncrRegTag0[2:0];
   1'b0;
   incrementReg0[15:0];   
SDMA_ADS_17:
   5'b00000;  
   termIncrementTag1[2:0];  
   {1'b0,loopIndexTag1[2:0]};
   compareTypeIncrRegTag1[2:0];
   1'b0;
   incrementReg1[15:0];   
SDMA_ADS_18:
   5'b00000;  
   termIncrementTag2[2:0];  
   {1'b0,loopIndexTag2[2:0]};
   compareTypeIncrRegTag2[2:0];
   incrementReg2[15:0];
   1'b0;
SDMA_ADS_19:
   5'b00000;  
   termIncrementTag3[2:0];  
   {1'b0,loopIndexTag3[2:0]};
   compareTypeIncrRegTag3[2:0];
   incrementReg3[15:0];   
   1'b0;
SDMA_ADS_20:
   5'b00000;  
   termIncrementTag4[2:0];  
   {1'b0,loopIndexTag4[2:0]};
   compareTypeIncrRegTag4[2:0];
   incrementReg4[15:0];  
   1'b0;
SDMA_ADS_21:
   5'b00000;  
   termIncrementTag5[2:0];  
   {1'b0,loopIndexTag5[2:0]};
   compareTypeIncrRegTag5[2:0];
   incrementReg5[15:0];  
   1'b0;
SDMA_ADS_22:
   5'b00000;  
   termIncrementTag6[2:0];  
   {1'b0,loopIndexTag6[2:0]};
   compareTypeIncrRegTag6[2:0];
   incrementReg6[15:0];   
   1'b0;
SDMA_ADS_23:
   5'b00000;  
   termIncrementTag7[2:0];  
   {1'b0,loopIndexTag7[2:0]};
   compareTypeIncrRegTag7[2:0];
   incrementReg7[15:0]; 
   1'b0;
SDMA_ADS_32:
   8'b00000000;
   incrementTag7,  incrementTag6,
   incrementTag5,  incrementTag4,
   incrementTag3,  incrementTag2,
   incrementTag1,  incrementTag0};
SDMA_ADS_34:
   8'b00000000;
   nestLevelTag7,  nestLevelTag6,
   nestLevelTag5,  nestLevelTag4,
   nestLevelTag3,  nestLevelTag2,
   nestLevelTag1,  nestLevelTag0};
SDMA_ADS_36:
   {initLevel[7:2], sdInitEnd, adsInit,   // 8
   1'b0,dirtyInitLevel[7:1],             // 8
   2'b0,checkLevel[6:1], checkNestLevel[2:0], // 2+10 
   1'b0,currentPointerTag, endPointerTag, variablePointerTag}; //4
SDMA_ADS_37:
   {runAds, loopDone, onceDone, adsStopped,
   startNewIteration, regStartNewIteration, loopIterationDone, 
   regLoopIterationDone,
   checkTermDone, terminationMet, compareAEnable, compareBEnable,
   1'b0, packEnable, unpackEnable, integerMode, 
   iterateOnce, initiator, multipleDrdIteration, 
   preciseIncrementEnable, 
   1'b0, internalRead, cBusReadAddressPhaseB, adsReadAddressPhaseB,
   1'b0, internalWriteEnable, cBusWriteAddressPhaseB,adsWriteAddressPhaseB,  
   4'h0 };
SDMA_ADS_40:
   {2'h0, euUsed,drdMemWrtDest[5:0], drdMemWrtSrc[6:0], //14 +2 
   compareBSameSigns, regCompareBCompareTypeTag,  
   compareBLoopDataMuxSelect[5:0],              //8
   compareASameSigns, regCompareACompareTypeTag, 
   compareALoopDataMuxSelect[5:0]};             //8
 ***********************************************************************/
