/*
 * File:		init.h
 * Purpose:		Function prototypes and memory map information.
 *
 * Notes:
 *
 * Author:		Michael Norman
 * Date:
 *
 * Modifications:
 *
 */

#ifndef _INIT_H
#define _INIT_H

/********************************************************************/

#define FLASH_ADDRESS		(0xFFE00000)
#define SDRAM_ADDRESS		(0x00000000)
#define SDRAM_ADDRESS_BANK0	(0x00000000)

#define SDRAM_ADDRESS_BANK1	(0x00800000)
#define SDRAM_SIZE			(0x01000000)

#define IMM_ADDRESS			(0x10000000)
#define EXT_SRAM_ADDRESS    (0xFE400000)
#define EXT_SRAM_SIZE	    (0x00080000)
#define INT_SRAM_ADDRESS    (0x20000000)
#define INT_SRAM_SIZE       (0x00001000)

/*
 * Macro which returns a pointer to the Internal Memory Map
 */ 
#define mcf5307_get_immp()	((MCF5307_IMM *)(IMM_ADDRESS))

/********************************************************************
*	Function Prototypes 
********************************************************************/

void 
mcf5307_sim_init (MCF5307_IMM *);

void 
mcf5307_timer_init	(MCF5307_IMM *);

void 
mcf5307_sdramc_init1 (MCF5307_IMM *);

void 
mcf5307_pp_init (MCF5307_IMM *);

void 
mcf5307_mbus_init (MCF5307_IMM *);

void 
mcf5307_dma_init (MCF5307_IMM *);

void 
mcf5307_cs_init (MCF5307_IMM *);

void 
mcf5307_sdramc_init2 (MCF5307_IMM *);

void 
mcf5307_uart_init (MCF5307_IMM *);

void
mcf5307_sdram_test(void);

int 
probe (uint32, uint32);

int
in_char (void);

void
out_char (int);

int
char_present (void);

int
printf (const char *, ... );

int
sprintf (char *, const char *, ... );


__interrupt__
void exception_handler (void);

__interrupt__
void irq_handler (void);

#endif /* _INIT_H */
