/** ###################################################################
**     THIS BEAN MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename  : PWMC1.H
**     Project   : voltmeter_led
**     Processor : MC56F8006_48_LQFP
**     Beantype  : PWMMC
**     Version   : Bean 01.561, Driver 01.29, CPU db: 3.00.177
**     Compiler  : Metrowerks DSP C Compiler
**     Date/Time : 11/26/2008, 2:51 PM
**     Abstract  :
**         This bean "PWMMC" implements 6-channel center-aligned or 
**         edge-aligned pulse-width modulator for AC motor control, which 
**         is presented on chip. The device is capable of controlling most 
**         motor types: AC induction motors (ACIM), both brushless (BLDC) 
**         and brush DC motors (BDC), switched (SRM) and variable reluctance  
**         motors (VRM),and stepper motors.
**         Another possibility of using this bean is as a pulse-width modulation 
**         generator that generates 6 signals with variable duty and fixed cycle.
**     Settings  :
**         Used output pins            :
**             ----------------------------------------------------
**                Number (on package)  |    Name
**             ----------------------------------------------------
**                       44            |  GPIOA0_PWM0
**                       43            |  GPIOA1_PWM1
**                       35            |  GPIOA2_PWM2
**                       36            |  GPIOA3_PWM3_TXD_EXTAL
**                       33            |  GPIOA4_PWM4_FAULT1_SDA_TIN2
**                       29            |  GPIOA5_PWM5_FAULT2_EXT_SYNC_TIN3
**             ----------------------------------------------------
**
**         Device                      : PWM_Timer [15-bit]
**
**         Counter                     : PWM_CNTR  [F024]
**         Mode register               : PWM_CNFG  [F030]
**         Run register                : PWM_CTRL  [F020]
**         Prescaler                   : PWM_CTRL  [F020]
**         Modulo register             : PWM_CMOD  [F025]
**         Compare 0 register          : PWM_VAL0  [F026]
**         Compare 1 register          : PWM_VAL1  [F027]
**         Compare 2 register          : PWM_VAL2  [F028]
**         Compare 3 register          : PWM_VAL3  [F029]
**         Compare 4 register          : PWM_VAL4  [F02A]
**         Compare 5 register          : PWM_VAL5  [F02B]
**         Fault Control register      : PWM_FCTRL [F021]
**         Fault Status register       : PWM_FLTACK [F022]
**         Fault Acknowledge register  : PWM_FLTACK [F022]
**         Output Control register     : PWM_OUT   [F023]
**         Dead-Time register          : PWM_DTIM0 [F02C]
**         Dead-Time 1 register        : PWM_DTIM1 [F02D]
**         Disable Mapping register  1 : PWM_DMAP1 [F02E]
**         Disable Mapping register  2 : PWM_DMAP2 [F02F]
**         Channel Control register    : PWM_CCTRL [F031]
**         Port register               : PWM_PORT  [F032]
**         Internal Corr. Control reg. : PWM_ICCTRL [F033]
**         PWM Source Control register : PWM_SCTRL [F034]
**
**         User handling procedure     : not specified
**
**
**     Initialization:
**          Align                      : edge-aligned mode
**          Mode of PWM pair 0         : independent
**          Mode of PWM pair 1         : independent
**          Mode of PWM pair 2         : independent
**          Top-side PWM pair 0 polarity : positive
**          Top-side PWM pair 1 polarity : positive
**          Top-side PWM pair 2 polarity : positive
**          Bottom-side PWM pair 0 polarity : positive
**          Bottom-side PWM pair 1 polarity : positive
**          Bottom-side PWM pair 2 polarity : positive
**          Write protect              : no
**          Output                     : Enabled
**          Enable in Wait mode        : no
**          Enable in EnOnCE mode      : yes
**          Reload                     : every 1 PWM cycle
**          Half cycle reload          : no
**          Hardware acceleration      : disabled
**
**          Dead Time
**          High speed mode
**              Prescaler              : divide-by-0
**              Clock                  : undef Hz
**              Xtal ticks             : 0
**              microseconds           : 0
**              seconds (real)         : 0.00000000000000E+0000
**
** Output control channel 0            : Disabled
** Output control channel 1            : Disabled
** Output control channel 2            : Disabled
** Output control channel 3            : Disabled
** Output control channel 4            : Disabled
** Output control channel 5            : Disabled
**
**   Channel masks
**     Mask channel 0                  : no
**     Mask channel 1                  : no
**     Mask channel 2                  : no
**     Mask channel 3                  : no
**     Mask channel 4                  : no
**     Mask channel 5                  : no
**
**
** Mask fault pins
** Channel 0
**   Mask fault 0                      : yes
**   Mask fault 1                      : yes
**   Mask fault 2                      : yes
**   Mask fault 3                      : yes
** Channel 1
**   Mask fault 0                      : yes
**   Mask fault 1                      : yes
**   Mask fault 2                      : yes
**   Mask fault 3                      : yes
** Channel 2
**   Mask fault 0                      : yes
**   Mask fault 1                      : yes
**   Mask fault 2                      : yes
**   Mask fault 3                      : yes
** Channel 3
**   Mask fault 0                      : yes
**   Mask fault 1                      : yes
**   Mask fault 2                      : yes
**   Mask fault 3                      : yes
** Channel 4
**   Mask fault 0                      : yes
**   Mask fault 1                      : yes
**   Mask fault 2                      : yes
**   Mask fault 3                      : yes
** Channel 5
**   Mask fault 0                      : yes
**   Mask fault 1                      : yes
**   Mask fault 2                      : yes
**   Mask fault 3                      : yes
**
**  Device                             : Enabled
**  Event                              : Enabled
**  High speed mode
**    Prescaler                        : divide-by-1
**    Clock                            : 96000000 Hz
**    Unit                              Xtal ticks
**      Period                         : 2731
**      Channel 0 pulse width          : 0
**      Channel 1 pulse width          : 0
**      Channel 2 pulse width          : 0
**      Channel 3 pulse width          : 0
**      Channel 4 pulse width          : 0
**      Channel 5 pulse width          : 0
**    Unit                              microseconds
**      Period                         : 341
**      Channel 0 pulse width          : 0
**      Channel 1 pulse width          : 0
**      Channel 2 pulse width          : 0
**      Channel 3 pulse width          : 0
**      Channel 4 pulse width          : 0
**      Channel 5 pulse width          : 0
**    Unit                              seconds (real)
**      Period                         : 0.000341322917
**      Channel 0 pulse width          : 0.00000000000000E+0000
**      Channel 1 pulse width          : 0.00000000000000E+0000
**      Channel 2 pulse width          : 0.00000000000000E+0000
**      Channel 3 pulse width          : 0.00000000000000E+0000
**      Channel 4 pulse width          : 0.00000000000000E+0000
**      Channel 5 pulse width          : 0.00000000000000E+0000
**
**     Contents  :
**         SetDuty          - byte PWMC1_SetDuty(byte channel, int duty);
**         Load             - void PWMC1_Load(void);
**         OutputPadEnable  - void PWMC1_OutputPadEnable(void);
**         OutputPadDisable - void PWMC1_OutputPadDisable(void);
**
**     (c) Copyright UNIS, a.s. 1997-2008
**     UNIS, a.s.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/

#ifndef __PWMC1
#define __PWMC1

/*Include shared modules, which are used for whole project*/
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
/* Include inherited beans */

#include "Cpu.h"


#ifndef __BWUserType_TChannels
#define __BWUserType_TChannels
  typedef struct {
    byte channel0  : 1;                                           /* Channel 0 bit */
    byte channel1  : 1;                                           /* Channel 1 bit */
    byte channel2  : 1;                                           /* Channel 2 bit */
    byte channel3  : 1;                                           /* Channel 3 bit */
    byte channel4  : 1;                                           /* channel 4 bit */
    byte channel5  : 1;                                           /* channel 5 bit */
  } TChannels;                         /* Structure contains bit information for 6 channels, one bit for each channel. */
#endif
#ifndef __BWUserType_TChannelPairs
#define __BWUserType_TChannelPairs
  typedef struct {
    byte pair0 : 1;                                               /* PWM pair 0 */
    byte pair1 : 1;                                               /* PWM pair 1 */
    byte pair2 : 1;                                               /* PWM pair 2 */
  } TChannelPairs;                     /* 3 channel pairs represented by bit in structure. */
#endif

/* MODULE PWMC1. */

#ifndef __BWUserType_TChannels
#define __BWUserType_TChannels
  typedef struct {
    byte channel0  : 1;                                           /* Channel 0 bit */
    byte channel1  : 1;                                           /* Channel 1 bit */
    byte channel2  : 1;                                           /* Channel 2 bit */
    byte channel3  : 1;                                           /* Channel 3 bit */
    byte channel4  : 1;                                           /* channel 4 bit */
    byte channel5  : 1;                                           /* channel 5 bit */
  } TChannels;                         /* Structure contains bit informations for 6 channels, one bit for each channel. */
#endif
#ifndef __BWUserType_TChannelPairs
#define __BWUserType_TChannelPairs
  typedef struct {
    byte pair0 : 1;                                               /* PWM pair 0 */
    byte pair1 : 1;                                               /* PWM pair 1 */
    byte pair2 : 1;                                               /* PWM pair 2 */
  } TChannelPairs;                     /* 3 channel pairs represented by bit in structure. */
#endif


void PWMC1_SetHigh(void);
/*
** ===================================================================
**     Method      :  PWMC1_SetHigh (bean PWMMC)
**
**     Description :
**         The method reconfigures the bean and its selected peripheral(s)
**         when the CPU is switched to the High speed mode. The method is 
**         called automatically as s part of the CPU SetHighSpeed method.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

void PWMC1_Init(void);
/*
** ===================================================================
**     Method      :  PWMC1_Init (bean PWMMC)
**
**     Description :
**         Initializes the associated peripheral(s) and the bean internal 
**         variables. The method is called automatically as a part of the 
**         application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

byte PWMC1_SetDuty(byte channel,int duty);
/*
** ===================================================================
**     Method      :  PWMC1_SetDuty (bean PWMMC)
**
**     Description :
**         Setting duty(value) register of selected channel.  The
**         value is loaded after calling Load() method.
**     Parameters  :
**         NAME            - DESCRIPTION
**         channel         - channel 0-5
**         duty            - Duty value for selected channel.
**                           Writing a number less than or equal to 0
**                           causes the PWM to be off for the entire
**                           PWM period. Writing a number greater
**                           than or equal to the 15 bit (12-bit on
**                           HC08MR32 CPU) modulus causes the PWM to
**                           be on for the entire PWM period.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_NOTAVAIL - Channel is disabled
**                           ERR_RANGE - Parameter channel is out of
**                           range
** ===================================================================
*/

#define PWMC1_Load() setRegBit(PWM_CTRL,LDOK)
/*
** ===================================================================
**     Method      :  PWMC1_Load (bean PWMMC)
**
**     Description :
**         Apply last setting of the methods SetDuty, SetDutyPercent,
**         SetPeriod and SetPrescaler.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

#define PWMC1_OutputPadEnable() setRegBit(PWM_OUT,PAD_EN)
/*
** ===================================================================
**     Method      :  PWMC1_OutputPadEnable (bean PWMMC)
**
**     Description :
**         Method enables output pads.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

#define PWMC1_OutputPadDisable() clrRegBit(PWM_OUT,PAD_EN)
/*
** ===================================================================
**     Method      :  PWMC1_OutputPadDisable (bean PWMMC)
**
**     Description :
**         Method disables output pads.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

/* END PWMC1. */

#endif /* ifndef __PWMC1 */
/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 2.99 [04.17]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
