/** ###################################################################
**     THIS BEAN MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename  : PWMC1.C
**     Project   : voltmeter_led
**     Processor : MC56F8006_48_LQFP
**     Beantype  : PWMMC
**     Version   : Bean 01.561, Driver 01.29, CPU db: 3.00.177
**     Compiler  : Metrowerks DSP C Compiler
**     Date/Time : 11/26/2008, 2:51 PM
**     Abstract  :
**         This bean "PWMMC" implements 6-channel center-aligned or 
**         edge-aligned pulse-width modulator for AC motor control, which 
**         is presented on chip. The device is capable of controlling most 
**         motor types: AC induction motors (ACIM), both brushless (BLDC) 
**         and brush DC motors (BDC), switched (SRM) and variable reluctance  
**         motors (VRM),and stepper motors.
**         Another possibility of using this bean is as a pulse-width modulation 
**         generator that generates 6 signals with variable duty and fixed cycle.
**     Settings  :
**         Used output pins            :
**             ----------------------------------------------------
**                Number (on package)  |    Name
**             ----------------------------------------------------
**                       44            |  GPIOA0_PWM0
**                       43            |  GPIOA1_PWM1
**                       35            |  GPIOA2_PWM2
**                       36            |  GPIOA3_PWM3_TXD_EXTAL
**                       33            |  GPIOA4_PWM4_FAULT1_SDA_TIN2
**                       29            |  GPIOA5_PWM5_FAULT2_EXT_SYNC_TIN3
**             ----------------------------------------------------
**
**         Device                      : PWM_Timer [15-bit]
**
**         Counter                     : PWM_CNTR  [F024]
**         Mode register               : PWM_CNFG  [F030]
**         Run register                : PWM_CTRL  [F020]
**         Prescaler                   : PWM_CTRL  [F020]
**         Modulo register             : PWM_CMOD  [F025]
**         Compare 0 register          : PWM_VAL0  [F026]
**         Compare 1 register          : PWM_VAL1  [F027]
**         Compare 2 register          : PWM_VAL2  [F028]
**         Compare 3 register          : PWM_VAL3  [F029]
**         Compare 4 register          : PWM_VAL4  [F02A]
**         Compare 5 register          : PWM_VAL5  [F02B]
**         Fault Control register      : PWM_FCTRL [F021]
**         Fault Status register       : PWM_FLTACK [F022]
**         Fault Acknowledge register  : PWM_FLTACK [F022]
**         Output Control register     : PWM_OUT   [F023]
**         Dead-Time register          : PWM_DTIM0 [F02C]
**         Dead-Time 1 register        : PWM_DTIM1 [F02D]
**         Disable Mapping register  1 : PWM_DMAP1 [F02E]
**         Disable Mapping register  2 : PWM_DMAP2 [F02F]
**         Channel Control register    : PWM_CCTRL [F031]
**         Port register               : PWM_PORT  [F032]
**         Internal Corr. Control reg. : PWM_ICCTRL [F033]
**         PWM Source Control register : PWM_SCTRL [F034]
**
**         User handling procedure     : not specified
**
**
**     Initialization:
**          Align                      : edge-aligned mode
**          Mode of PWM pair 0         : independent
**          Mode of PWM pair 1         : independent
**          Mode of PWM pair 2         : independent
**          Top-side PWM pair 0 polarity : positive
**          Top-side PWM pair 1 polarity : positive
**          Top-side PWM pair 2 polarity : positive
**          Bottom-side PWM pair 0 polarity : positive
**          Bottom-side PWM pair 1 polarity : positive
**          Bottom-side PWM pair 2 polarity : positive
**          Write protect              : no
**          Output                     : Enabled
**          Enable in Wait mode        : no
**          Enable in EnOnCE mode      : yes
**          Reload                     : every 1 PWM cycle
**          Half cycle reload          : no
**          Hardware acceleration      : disabled
**
**          Dead Time
**          High speed mode
**              Prescaler              : divide-by-0
**              Clock                  : undef Hz
**              Xtal ticks             : 0
**              microseconds           : 0
**              seconds (real)         : 0.00000000000000E+0000
**
** Output control channel 0            : Disabled
** Output control channel 1            : Disabled
** Output control channel 2            : Disabled
** Output control channel 3            : Disabled
** Output control channel 4            : Disabled
** Output control channel 5            : Disabled
**
**   Channel masks
**     Mask channel 0                  : no
**     Mask channel 1                  : no
**     Mask channel 2                  : no
**     Mask channel 3                  : no
**     Mask channel 4                  : no
**     Mask channel 5                  : no
**
**
** Mask fault pins
** Channel 0
**   Mask fault 0                      : yes
**   Mask fault 1                      : yes
**   Mask fault 2                      : yes
**   Mask fault 3                      : yes
** Channel 1
**   Mask fault 0                      : yes
**   Mask fault 1                      : yes
**   Mask fault 2                      : yes
**   Mask fault 3                      : yes
** Channel 2
**   Mask fault 0                      : yes
**   Mask fault 1                      : yes
**   Mask fault 2                      : yes
**   Mask fault 3                      : yes
** Channel 3
**   Mask fault 0                      : yes
**   Mask fault 1                      : yes
**   Mask fault 2                      : yes
**   Mask fault 3                      : yes
** Channel 4
**   Mask fault 0                      : yes
**   Mask fault 1                      : yes
**   Mask fault 2                      : yes
**   Mask fault 3                      : yes
** Channel 5
**   Mask fault 0                      : yes
**   Mask fault 1                      : yes
**   Mask fault 2                      : yes
**   Mask fault 3                      : yes
**
**  Device                             : Enabled
**  Event                              : Enabled
**  High speed mode
**    Prescaler                        : divide-by-1
**    Clock                            : 96000000 Hz
**    Unit                              Xtal ticks
**      Period                         : 2731
**      Channel 0 pulse width          : 0
**      Channel 1 pulse width          : 0
**      Channel 2 pulse width          : 0
**      Channel 3 pulse width          : 0
**      Channel 4 pulse width          : 0
**      Channel 5 pulse width          : 0
**    Unit                              microseconds
**      Period                         : 341
**      Channel 0 pulse width          : 0
**      Channel 1 pulse width          : 0
**      Channel 2 pulse width          : 0
**      Channel 3 pulse width          : 0
**      Channel 4 pulse width          : 0
**      Channel 5 pulse width          : 0
**    Unit                              seconds (real)
**      Period                         : 0.000341322917
**      Channel 0 pulse width          : 0.00000000000000E+0000
**      Channel 1 pulse width          : 0.00000000000000E+0000
**      Channel 2 pulse width          : 0.00000000000000E+0000
**      Channel 3 pulse width          : 0.00000000000000E+0000
**      Channel 4 pulse width          : 0.00000000000000E+0000
**      Channel 5 pulse width          : 0.00000000000000E+0000
**
**     Contents  :
**         SetDuty          - byte PWMC1_SetDuty(byte channel, int duty);
**         Load             - void PWMC1_Load(void);
**         OutputPadEnable  - void PWMC1_OutputPadEnable(void);
**         OutputPadDisable - void PWMC1_OutputPadDisable(void);
**
**     (c) Copyright UNIS, a.s. 1997-2008
**     UNIS, a.s.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/


/* MODULE PWMC1. */

#include "PWMC1.h"


/*
** ===================================================================
**     Method      :  PWMC1_Init (bean PWMMC)
**
**     Description :
**         Initializes the associated peripheral(s) and the bean internal 
**         variables. The method is called automatically as a part of the 
**         application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void PWMC1_Init(void)
{
  /* PWM_CTRL: LDFQ=0,HALF=0,IPOL2=0,IPOL1=0,IPOL0=0,PRSC=0,PWMRIE=0,PWMF=0,ISENS=0,LDOK=0,PWMEN=0 */
  setReg16(PWM_CTRL, 0x00);            /* Set up PWM control register */ 
  /* PWM_FCTRL: ??=0,??=0,??=0,??=0,FPOL3=0,FPOL2=0,FPOL1=0,FPOL0=0,FIE3=0,FMODE3=0,FIE2=0,FMODE2=0,FIE1=0,FMODE1=0,FIE0=0,FMODE0=0 */
  setReg16(PWM_FCTRL, 0x00);           /* Set up Fault Control Register */ 
  /* PWM_ICCTRL: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,PEC2=0,PEC1=0,PEC0=0,ICC2=0,ICC1=0,ICC0=0 */
  setReg16(PWM_ICCTRL, 0x00);          /* Set up Internal Correction Control Register */ 
  /* PWM_DMAP1: DISMAP_15_0=0 */
  setReg16(PWM_DMAP1, 0x00);            
  /* PWM_DMAP2: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,DISMAP_23_16=0 */
  setReg16(PWM_DMAP2, 0x00);            
  /* PWM_OUT: PAD_EN=1,??=0,OUTCTL5=0,OUTCTL4=0,OUTCTL3=0,OUTCTL2=0,OUTCTL1=0,OUTCTL0=0,??=0,??=0,OUT5=0,OUT4=0,OUT3=0,OUT2=0,OUT1=0,OUT0=0 */
  setReg16(PWM_OUT, 0x8000);            
  /* PWM_CCTRL: ENHA=0,nBX=0,MSK5=0,MSK4=0,MSK3=0,MSK2=0,MSK1=0,MSK0=0,??=0,??=0,VLMODE=0,??=0,SWP45=0,SWP23=0,SWP01=0 */
  setReg16(PWM_CCTRL, 0x00);            
  /* PWM_SCTRL: ??=0,??=0,CINV5=0,CINV4=0,CINV3=0,CINV2=0,CINV1=0,CINV0=0,??=0,SRC2=0,??=0,SRC1=0,??=0,SRC0=0 */
  setReg16(PWM_SCTRL, 0x00);            
  /* PWM_FFILT0: GSTR0=0,??=0,??=0,??=0,??=0,FILT0_CNT=0,FILT0_PER=0 */
  setReg16(PWM_FFILT0, 0x00);           
  /* PWM_FFILT1: GSTR1=0,??=0,??=0,??=0,??=0,FILT1_CNT=0,FILT1_PER=0 */
  setReg16(PWM_FFILT1, 0x00);           
  /* PWM_FFILT2: GSTR2=0,??=0,??=0,??=0,??=0,FILT2_CNT=0,FILT2_PER=0 */
  setReg16(PWM_FFILT2, 0x00);           
  /* PWM_FFILT3: GSTR3=0,??=0,??=0,??=0,??=0,FILT3_CNT=0,FILT3_PER=0 */
  setReg16(PWM_FFILT3, 0x00);           
  /* PWM_DTIM0: ??=0,??=0,??=0,??=0,PWMDT0=0 */
  setReg16(PWM_DTIM0, 0x00);            
  /* PWM_DTIM1: ??=0,??=0,??=0,??=0,PWMDT1=0 */
  setReg16(PWM_DTIM1, 0x00);            
  /* PWM_VAL0: PMVAL=0 */
  setReg16(PWM_VAL0, 0x00);             
  /* PWM_VAL1: PMVAL=0 */
  setReg16(PWM_VAL1, 0x00);             
  /* PWM_VAL2: PMVAL=0 */
  setReg16(PWM_VAL2, 0x00);             
  /* PWM_VAL3: PMVAL=0 */
  setReg16(PWM_VAL3, 0x00);             
  /* PWM_VAL4: PMVAL=0 */
  setReg16(PWM_VAL4, 0x00);             
  /* PWM_VAL5: PMVAL=0 */
  setReg16(PWM_VAL5, 0x00);             
  /* PWM_CMOD: ??=0,PWMCM=0x7FFF */
  setReg16(PWM_CMOD, 0x7FFF);           
  /* PWM_CNFG: ??=0,DBG_EN=1,WAIT_EN=0,EDG=1,??=0,TOPNEG45=0,TOPNEG23=0,TOPNEG01=0,??=0,BOTNEG45=0,BOTNEG23=0,BOTNEG01=0,INDEP45=1,INDEP23=1,INDEP01=1,WP=0 */
  setReg16(PWM_CNFG, 0x500E);          /* Set up PWM configure register */ 
  /* PWM_CTRL: LDOK=1 */
  setReg16Bits(PWM_CTRL, 0x02);        /* Load counter and modulo registers into buffers */ 
  /* PWM_CTRL: PWMEN=1 */
  setReg16Bits(PWM_CTRL, 0x01);        /* Run counter */ 
  /* PWM_CTRL: PWMF=1 */
  setReg16Bits(PWM_CTRL, 0x10);        /* Clear reload flag made by PWMEN bit */ 

}

/*
** ===================================================================
**     Method      :  PWMC1_SetDuty (bean PWMMC)
**
**     Description :
**         Setting duty(value) register of selected channel.  The
**         value is loaded after calling Load() method.
**     Parameters  :
**         NAME            - DESCRIPTION
**         channel         - channel 0-5
**         duty            - Duty value for selected channel.
**                           Writing a number less than or equal to 0
**                           causes the PWM to be off for the entire
**                           PWM period. Writing a number greater
**                           than or equal to the 15 bit (12-bit on
**                           HC08MR32 CPU) modulus causes the PWM to
**                           be on for the entire PWM period.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_NOTAVAIL - Channel is disabled
**                           ERR_RANGE - Parameter channel is out of
**                           range
** ===================================================================
*/
byte PWMC1_SetDuty(byte channel,int duty)
{
  switch (channel) {
  case 0 :
      setReg(PWM_VAL0,duty);           /* Store value to the duty-compare register 0 */
      break;
  case 1 :
      setReg(PWM_VAL1,duty);           /* Store value to the duty-compare register 1 */
      break;
  case 2 :
      setReg(PWM_VAL2,duty);           /* Store value to the duty-compare register 2 */
      break;
  case 3 :
      setReg(PWM_VAL3,duty);           /* Store value to the duty-compare register 3 */
      break;
  case 4 :
      setReg(PWM_VAL4,duty);           /* Store value to the duty-compare register 4 */
      break;
  case 5 :
      setReg(PWM_VAL5,duty);           /* Store value to the duty-compare register 5 */
      break;
  default: return ERR_RANGE;
  }
  return ERR_OK;
}

/*
** ===================================================================
**     Method      :  PWMC1_Load (bean PWMMC)
**
**     Description :
**         Apply last setting of the methods SetDuty, SetDutyPercent,
**         SetPeriod and SetPrescaler.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void PWMC1_Load(void)

**  This method is implemented as a macro. See PWMC1.h file.  **

*/

/*
** ===================================================================
**     Method      :  PWMC1_OutputPadEnable (bean PWMMC)
**
**     Description :
**         Method enables output pads.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void PWMC1_OutputPadEnable(void)

**  This method is implemented as a macro. See PWMC1.h file.  **

*/

/*
** ===================================================================
**     Method      :  PWMC1_OutputPadDisable (bean PWMMC)
**
**     Description :
**         Method disables output pads.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void PWMC1_OutputPadDisable(void)

**  This method is implemented as a macro. See PWMC1.h file.  **

*/

/* END PWMC1. */

/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 2.99 [04.17]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
