###############################################################################
#
#       COPYRIGHT (c) 2003 MOTOROLA INC.
#       ALL RIGHTS RESERVED
#
# Filename:     vectors.S
# Author:       Mark Jonas
# Revision:     1.0
#
# History:      2003-May-30: First release.
#
# Description:  Vector table for a MPC5200 processor.
#
# Notes:        
#
###############################################################################

.global	_start

	.macro	vector NUM,HANDLER
exc_\NUM:
	b	\HANDLER
	.space (0x0100 - 4),0
	.endm

.text

	# Here only the reset handler points to a real function.
	# All other vectors point to themselves and implement and
	# endless loop in case there are used.

	vector	0000,exc_0000		# reserved
	vector	0100,reset_handler	# reset
	vector	0200,exc_0200		# machine check
	vector	0300,exc_0300		# data access
	vector	0400,exc_0400		# instruction access
	vector	0500,exc_0500		# external interrupt
	vector	0600,exc_0600		# alignment
	vector	0700,exc_0700		# program
	vector	0800,exc_0800		# floating-point unavail
	vector	0900,exc_0900		# decrementer
	vector	0A00,exc_0A00		# critical interrupt
	vector	0B00,exc_0B00		# reserved
	vector	0C00,exc_0C00		# system call
	vector	0D00,exc_0D00		# trace
	vector	0E00,exc_0E00		# reserved
	vector	0F00,exc_0F00		# performance monitor
	vector	1000,exc_1000		# instruction tlb miss
	vector	1100,exc_1100		# data tlb miss
	vector	1200,exc_1200		# data store tlb miss
	vector	1300,exc_1300		# instruction breakpoint
	vector	1400,exc_1400		# system management interrupt
	vector	1500,exc_1500		# reserved
	vector	1600,exc_1600		# reserved
	vector	1700,exc_1700		# reserved
	vector	1800,exc_1800		# reserved
	vector	1900,exc_1900		# reserved
	vector	1A00,exc_1A00		# reserved
	vector	1B00,exc_1B00		# reserved
	vector	1C00,exc_1C00		# reserved
	vector	1D00,exc_1D00		# reserved
	vector	1E00,exc_1E00		# reserved
	vector	1F00,exc_1F00		# reserved
	vector	2000,exc_2000		# reserved
	vector	2100,exc_2100		# reserved
	vector	2200,exc_2200		# reserved
	vector	2300,exc_2300		# reserved
	vector	2400,exc_2400		# reserved
	vector	2500,exc_2500		# reserved
	vector	2600,exc_2600		# reserved
	vector	2700,exc_2700		# reserved
	vector	2800,exc_2800		# reserved
	vector	2900,exc_2900		# reserved
	vector	2A00,exc_2A00		# reserved
	vector	2B00,exc_2B00		# reserved
	vector	2C00,exc_2C00		# reserved
	vector	2D00,exc_2D00		# reserved
	vector	2E00,exc_2E00		# reserved
	vector	2F00,exc_2F00		# reserved
	
.end