/******************************************************************************
*
*       COPYRIGHT (c) 2003 MOTOROLA INC.
*       ALL RIGHTS RESERVED
*
* Filename:     linkerscript.lds
* Author:       Mark Jonas
* Revision:     1.0
*
* History:      2003-May-30: First release.
*
* Description:  This is a linker script for the GNU ld linker.
*
* Notes:        
*
******************************************************************************/

SECTIONS
{
	/*
	 * Load Memory Address (LMA)
	 * Where the image will be downloaded to.
	 * 0x00020000 for downloading and flashing with dBUG
	 */
	LOAD_ADDRESS = 0x00020000;

	/*
	 * Virtual Memory Address (VMA)
	 * Where the image will be executed from.
	 * Must be 0x00000000 for the example code CS0 mapping and
	 * relocation to work.
	 */	
	TEXT_START = 0x00000000;
	
	/*
	 * The text section is the first section in the image.
	 * _text_start and _text_end indicate the start and end
	 * address. _text_size is the length of the text section in
	 * bytes and is a multiple of 64.
	 */
	_text_start = TEXT_START;
	.text _text_start : AT (LOAD_ADDRESS)
	{
		*(.text)
		*(.rodata)
		*(.rodata1)
		*(.got1);
		. = ALIGN (64);
	}
	_text_end = .;
	_text_size = _text_end - _text_start;

	/*
	 * The data section is located right after the text section.
	 * Start and end address as well as the size of the section
	 * are stored in _data_start, _data_end and _data_size.
	 */
	_data_start = .;
	.data _data_start : AT (LOAD_ADDRESS + _text_size)
	{
		*(.data)
		*(.data1)
		*(.sdata)
		*(.sdata2)
		*(.got.plt)
		*(.got)
		*(.dynamic)
		*(.fixup);
		. = ALIGN (64);
	}
	_data_end = .;
	_data_size = _data_end - _data_start;

	/*
	 * The bss section is located right after the data section.
	 * Start and end address as well as the size of the section
	 * are stored in _bss_start, _bss_end and _bss_size.
	 */
	_bss_start = .;
	.bss _bss_start (NOLOAD) :
	{
		*(.sbss)
		*(.scommon)
		*(.dynbss)
		*(.bss)
		*(COMMON) ;
		. = ALIGN (64);
	}
	_bss_end = . ;
	_bss_size = _bss_end - _bss_start;

	/*
	 * STAB debug sections
	 */
	.stab 0 : { *(.stab) }
	.stabstr 0 : { *(.stabstr) }

	/*
	 * DWARF debug sections
	 */
	.debug 0 : {*(.debug)}
	.debug_srcinfo 0 : {*(.debug_srcinfo)}
	.debug_aranges 0 : {*(.debug_aranges)}
	.debug_pubnames 0 : {*(.debug_pubnames)}
	.debug_sfnames 0 : {*(.debug_sfnames)}
	.line 0 : {*(.line)}
}
