// vim: ts=4 softtabstop=4 shiftwidth=4 columns=120 lines=48
// +FHDR------------------------------------------------------------------------
// Copyright (c) 2016 NXP Semiconductors.
// All rights reserved
//
// This is unpublished proprietary source code of NXP Semiconductors.
// The copyright notice above does not evidence any actual
// or intended publication of such source code.
//
// -----------------------------------------------------------------------------
// FILE NAME:           interrupts.v
// DEPARTMENT:          Austin Hardware Design
// AUTHOR:              Gary Milliorn
// AUTHOR'S EMAIL:      gary.milliorn@freescale.com
// -----------------------------------------------------------------------------
// RELEASE HISTORY
// VERSION  DATE        AUTHOR                DESCRIPTION
// 1.0      2011-02-15  Gary Milliorn         New
// 1.1      2014-01-15  Gary Milliorn         Minimal version for QIXMIN.
// 1.2      2014-10-14  Gary Milliorn         Reduced version for LS2085A_RDB
// -----------------------------------------------------------------------------
// KEYWORDS:            INTERRUPT IRQ QIXMIN
// -----------------------------------------------------------------------------
// PURPOSE:             Handles the interrupt assignment.
// -----------------------------------------------------------------------------
// PARAMETERS
// PARAM NAME RANGE:    DESCRIPTION : DEFAULT : UNITS
// -----------------------------------------------------------------------------
// REUSE ISSUES
// Reset Strategy: 		<none>
// Clock Domains: 		<none>
// Critical Timing: 	<none>
// Test Features: 		<none>
// Asynchronous I/F: 	<none>
// Scan Methodology: 	<none>
// Instantiations: 		
// Synthesizable (y/n): y
// Other: 
// -FHDR------------------------------------------------------------------------

`resetall
`timescale 1ns/10ps

module interrupts( 
    // Interrupt sources.
    //
    input   wire    [2:1]   irq_tdm_b,
    input   wire            irq_aqr105_b,
    input   wire            irq_qsphy1_b,
    input   wire            irq_qsphy2_b,
    input   wire            irq_rtc_b,
    input   wire            irq_pcie1wake_b,
    input   wire            irq_pcie2wake_b,

	// Registers
	//
	output	wire	[7:0]	irq_stat0,
	output	wire	[7:0]	irq_stat1,

    // DUT interface.
    //
    output  wire    [2:0]   irq_b, 
    output  wire            evt9_b, 

    input   wire            disable_io_b
);


//---------------------------------------------------------------------------
// IRQ Assignment and Monitoring.
//    Set IRQ_STATx[Y] to '1' if the interrupt is asserted.
//	  From PPC legacy, the MSB is 0 etc.
//
	assign	irq_stat0[7]	= (~irq_aqr105_b);

	assign	irq_stat0[6]    = (~irq_qsphy1_b)		| (~irq_qsphy2_b);

	assign	irq_stat0[5]    = (~irq_tdm_b[1])		| (~irq_tdm_b[2])
							| (~irq_rtc_b)
							| (~irq_pcie1wake_b)	| (~irq_pcie2wake_b);

	assign	irq_stat0[4:0]	= 5'b1_1111;
	assign	irq_stat1		= 8'b1111_1111;


//---------------------------------------------------------------------------
// IRQ/EVT drive:
//      Only drive low, allow pullups to float signals high.
//
	assign	irq_b[0]	= (disable_io_b  &&  irq_stat0[7])	? 1'b1	: 1'bZ;
	assign	irq_b[1]	= (disable_io_b  &&  irq_stat0[6])	? 1'b1	: 1'bZ;
	assign	irq_b[2]	= (disable_io_b  &&  irq_stat0[5])	? 1'b1	: 1'bZ;
    assign  evt9_b      = (disable_io_b)					? 1'b1  : 1'bZ;


//---------------------------------------------------------------------------
// Unused.
//

endmodule
