# LIBUSBSIO Library

## Mission
The aim of this project is to deliver a dynamic library which enables USB-HID communication between PC Host 
and a target MCU over SPI, I2C or GPIO using a USB-connected bridge device. Two types of bridge devices are currently 
supported: LPCLink2 and MCULink. The library is supported on Windows/Linux/MacOS platforms.

The project uses the [HID_API](https://github.com/signal11/hidapi) open source library code and partially also its 
new [libusb/hidapi](https://github.com/libusb/hidapi) version to access 
the USB HID interface on all supported OS platforms.

## Links
- [Home page](https://www.nxp.com/design/software/development-software/library-for-windows-macos-and-ubuntu-linux:LIBUSBSIO)
- [MCUlink Pro](https://www.nxp.com/design/microcontrollers-developer-resources/mcu-link-pro-debug-probe:MCU-LINK-PRO)
- [LPCLink2](https://www.nxp.com/design/microcontrollers-developer-resources/lpc-microcontroller-utilities/lpc-link2:OM13054)

## Build
The library binaries are available in the repository. Default output path is bin/[platform]:
- `linux_x86_64`  ... ubuntu 20.04 x86_64 64bit version
- `linux_i686`    ... ubuntu 16.04 386 32bit version
- `linux_armv7l`  ... debian arm 32bit version, tested with imx6ulevk
- `linux_aarch64` ... debian arm 64bit version, tested with imx8mqevk
- `osx_x86_64`    ... macOS 11.3 64bit version
- `osx_arm64`     ... macOS ARM 64bit version (M1)
- `Win32`         ... Windows 32bit version (VS2015, build tools v14.0)
- `x64`           ... Windows 64bit version (VS2015, build tools v14.0)

The `bin_debug` folder contains the Debug build outputs.

### Windows
- Use Microsoft Visual Studio 2012 or later
- Open `vsproj/libusbsio.sln` or import the `vcxproj` project
- Build configurations exist for both Win32 and x64
- Select static library bulild (ReleaseS, DebugS targets)
  or DLL library build (Release, Debug)

### macOS
- The `makefile` is available
- Use `make` or `make debug` to build both static `.a` and dynamic `.dylib` libraries 

### Linux
- The `makefile` is available
- Use `make` or `make debug` to build both static `.a` and dynamic `.so` libraries 


## History
### v2.2.0 - October 2025
- Add OpenBySerial and OpenByPath more robust calls, immune to index reordering upon re-enumeration.
- Enumerated devices list remains valid after device close; GetNumPorts re-enumeration is no longer needed
- Python wrapper extended so multiple LIBUSBSIO objects may be open and used simultaneously.
### v2.1.13 - October 2024
- Fix HID_API Windows enumeration to avoid accidental duplicate device enumeration.
### v2.1.12 - January 2023
- Fix HID_API Windows to enable both debugger interface and USBSIO device to be open simultaneously.
### v2.1.11 - February 2022
- Source code of the library made available under BSD-3-Clause license.
- macOS now use the libusb/hidapi version to use a new format of HID device path.
### v2.1.10 - February 2022
- Add GetDeviceInfo method to retrieve hid_api low-level information of the SIO port
### v2.1.8 - November 2021
- Add binaries for linux_armv7l and linux_aarch64
### v2.1.5 - August 2021
- Add binaries and support for arm64 macOS
### v2.1.4 - July 2021
- Extend by low-level HID_API access, fix read buffer length when reading data.
- Refactor "PIDVID" variables, arguments and tuples to a correctly ordered "VIDPID"
- Fix example code.
### v2.1.0 - April 2021
- The initial Python libusbsio library wrapper release supporting USBSIO library v2.1

----------------------------------
Copyright 2014, 2021-2025 NXP
