/*
 * Copyright 2013, 2015, 2017, 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Generic MIFARE(R) Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <ph_Status.h>
#include <phpalMifare.h>
#include <ph_RefDefs.h>
#include "phpalMifare_Int.h"

#ifdef NXPBUILD__PHPAL_MIFARE_STUB
#include "Stub/phpalMifare_Stub.h"
#endif /* NXPBUILD__PHPAL_MIFARE_STUB */

#ifdef NXPBUILD__PHPAL_MIFARE_SW
#include "Sw/phpalMifare_Sw.h"
#endif /* NXPBUILD__PHPAL_MIFARE_SW */





#ifdef NXPBUILD__PHPAL_MIFARE_RD710
#include "Rd710/phpalMifare_Rd710.h"
#endif /* NXPBUILD__PHPAL_MIFARE_RD710 */

#ifdef NXPBUILD__PHPAL_MIFARE_PCSC
#include "Pcsc/phpalMifare_Pcsc.h"
#endif /* NXPBUILD__PHPAL_MIFARE_PCSC */

#ifdef NXPBUILD__PHPAL_MIFARE

phStatus_t phpalMifare_ExchangeL3(void * pDataParams, uint16_t wOption, uint8_t * pTxBuffer, uint16_t wTxLength,
    uint8_t ** ppRxBuffer, uint16_t * pRxLength)
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phpalMifare_ExchangeL3");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wOption);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(pTxBuffer);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(ppRxBuffer);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, wOption_log, &wOption);
    PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG, pTxBuffer_log, pTxBuffer, wTxLength);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL(pDataParams);
    if(wTxLength) PH_ASSERT_NULL(pTxBuffer);

    /* Check data parameters */
    if(PH_GET_COMPCODE(pDataParams) != PH_COMP_PAL_MIFARE)
    {
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_PAL_MIFARE);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHPAL_MIFARE_STUB
        case PHPAL_MIFARE_STUB_ID:
            status = phpalMifare_Stub_ExchangeL3(
                (phpalMifare_Stub_DataParams_t *) pDataParams,
                wOption,
                pTxBuffer,
                wTxLength,
                ppRxBuffer,
                pRxLength);
            break;
#endif /* NXPBUILD__PHPAL_MIFARE_STUB */

#ifdef NXPBUILD__PHPAL_MIFARE_SW
        case PHPAL_MIFARE_SW_ID:
            status = phpalMifare_Sw_ExchangeL3(
                (phpalMifare_Sw_DataParams_t *) pDataParams,
                wOption,
                pTxBuffer,
                wTxLength,
                ppRxBuffer,
                pRxLength);
            break;
#endif /* NXPBUILD__PHPAL_MIFARE_SW */



#ifdef NXPBUILD__PHPAL_MIFARE_RD710
        case PHPAL_MIFARE_RD710_ID:
            status = phpalMifare_Rd710_ExchangeL3(
                (phpalMifare_Rd710_DataParams_t *) pDataParams,
                wOption,
                pTxBuffer,
                wTxLength,
                ppRxBuffer,
                pRxLength);
            break;
#endif /* NXPBUILD__PHPAL_MIFARE_RD710 */

#ifdef NXPBUILD__PHPAL_MIFARE_PCSC
        case PHPAL_MIFARE_PCSC_ID:
            status = phpalMifare_Pcsc_ExchangeL3(
                (phpalMifare_Pcsc_DataParams_t *) pDataParams,
                wOption,
                pTxBuffer,
                wTxLength,
                ppRxBuffer,
                pRxLength);
            break;
#endif /* NXPBUILD__PHPAL_MIFARE_PCSC */



        default:
            status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_PAL_MIFARE);
            break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
#ifdef NXPBUILD__PH_LOG
    if((((status & PH_ERR_MASK) == PH_ERR_SUCCESS) ||
        ((status & PH_ERR_MASK) == PH_ERR_SUCCESS_CHAINING) ||
        ((status & PH_ERR_MASK) == PH_ERR_SUCCESS_INCOMPLETE_BYTE)) &&
        !(wOption & PH_EXCHANGE_BUFFERED_BIT) &&
        (ppRxBuffer != NULL))
    {
        PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG, ppRxBuffer_log, *ppRxBuffer, *pRxLength);
    }
#endif /* NXPBUILD__PH_LOG */
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phpalMifare_ExchangeL4(void * pDataParams, uint16_t wOption, uint8_t * pTxBuffer, uint16_t wTxLength,
    uint8_t ** ppRxBuffer, uint16_t * pRxLength)
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phpalMifare_ExchangeL4");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wOption);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(pTxBuffer);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(ppRxBuffer);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, wOption_log, &wOption);
    PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG, pTxBuffer_log, pTxBuffer, wTxLength);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL(pDataParams);
    if(wTxLength) PH_ASSERT_NULL(pTxBuffer);

    /* Check data parameters */
    if(PH_GET_COMPCODE(pDataParams) != PH_COMP_PAL_MIFARE)
    {
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_PAL_MIFARE);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHPAL_MIFARE_STUB
        case PHPAL_MIFARE_STUB_ID:
            status = phpalMifare_Stub_ExchangeL4(
                (phpalMifare_Stub_DataParams_t *) pDataParams,
                wOption,
                pTxBuffer,
                wTxLength,
                ppRxBuffer,
                pRxLength);
            break;
#endif /* NXPBUILD__PHPAL_MIFARE_STUB */

#ifdef NXPBUILD__PHPAL_MIFARE_SW
        case PHPAL_MIFARE_SW_ID:
            status = phpalMifare_Sw_ExchangeL4(
                (phpalMifare_Sw_DataParams_t *) pDataParams,
                wOption,
                pTxBuffer,
                wTxLength,
                ppRxBuffer,
                pRxLength);
            break;
#endif /* NXPBUILD__PHPAL_MIFARE_SW */



#ifdef NXPBUILD__PHPAL_MIFARE_RD710
        case PHPAL_MIFARE_RD710_ID:
            status = phpalMifare_Rd710_ExchangeL4(
                (phpalMifare_Rd710_DataParams_t *) pDataParams,
                wOption,
                pTxBuffer,
                wTxLength,
                ppRxBuffer,
                pRxLength);
            break;
#endif /* NXPBUILD__PHPAL_MIFARE_RD710 */

#ifdef NXPBUILD__PHPAL_MIFARE_PCSC
        case PHPAL_MIFARE_PCSC_ID:
            status = phpalMifare_Pcsc_ExchangeL4(
                (phpalMifare_Pcsc_DataParams_t *) pDataParams,
                wOption,
                pTxBuffer,
                wTxLength,
                ppRxBuffer,
                pRxLength);
            break;
#endif /* NXPBUILD__PHPAL_MIFARE_PCSC */



        default:
            status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_PAL_MIFARE);
            break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
#ifdef NXPBUILD__PH_LOG
    if((((status & PH_ERR_MASK) == PH_ERR_SUCCESS) ||
        ((status & PH_ERR_MASK) == PH_ERR_SUCCESS_CHAINING) ||
        ((status & PH_ERR_MASK) == PH_ERR_SUCCESS_INCOMPLETE_BYTE)) &&
        !(wOption & PH_EXCHANGE_BUFFERED_BIT) &&
        (ppRxBuffer != NULL))
    {
        PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG, ppRxBuffer_log, *ppRxBuffer, *pRxLength);
    }
#endif /* NXPBUILD__PH_LOG */
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phpalMifare_ExchangePc(void * pDataParams, uint16_t wOption, uint8_t * pTxBuffer, uint16_t wTxLength,
    uint8_t ** ppRxBuffer, uint16_t * pRxLength)
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phpalMifare_ExchangePc");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wOption);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(pTxBuffer);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(ppRxBuffer);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, wOption_log, &wOption);
    PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG, pTxBuffer_log, pTxBuffer, wTxLength);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL(pDataParams);
    if(wTxLength) PH_ASSERT_NULL(pTxBuffer);

    /* Check data parameters */
    if(PH_GET_COMPCODE(pDataParams) != PH_COMP_PAL_MIFARE)
    {
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_PAL_MIFARE);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHPAL_MIFARE_STUB
        case PHPAL_MIFARE_STUB_ID:
            status = phpalMifare_Stub_ExchangePc(
                (phpalMifare_Stub_DataParams_t *) pDataParams,
                wOption,
                pTxBuffer,
                wTxLength,
                ppRxBuffer,
                pRxLength);
            break;
#endif /* NXPBUILD__PHPAL_MIFARE_STUB */

#ifdef NXPBUILD__PHPAL_MIFARE_SW
        case PHPAL_MIFARE_SW_ID:
            status = phpalMifare_Sw_ExchangePc(
                (phpalMifare_Sw_DataParams_t *) pDataParams,
                wOption,
                pTxBuffer,
                wTxLength,
                ppRxBuffer,
                pRxLength);
            break;
#endif /* NXPBUILD__PHPAL_MIFARE_SW */



#ifdef NXPBUILD__PHPAL_MIFARE_RD710
        case PHPAL_MIFARE_RD710_ID:
            status = phpalMifare_Rd710_ExchangePc(
                (phpalMifare_Rd710_DataParams_t *) pDataParams,
                wOption,
                pTxBuffer,
                wTxLength,
                ppRxBuffer,
                pRxLength);
            break;
#endif /* NXPBUILD__PHPAL_MIFARE_RD710 */

#ifdef NXPBUILD__PHPAL_MIFARE_PCSC
        case PHPAL_MIFARE_PCSC_ID:
            status = phpalMifare_Pcsc_ExchangePc(
                (phpalMifare_Pcsc_DataParams_t *) pDataParams,
                wOption,
                pTxBuffer,
                wTxLength,
                ppRxBuffer,
                pRxLength);
            break;
#endif /* NXPBUILD__PHPAL_MIFARE_PCSC */

        default:
            status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_PAL_MIFARE);
            break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
#ifdef NXPBUILD__PH_LOG
    if((((status & PH_ERR_MASK) == PH_ERR_SUCCESS) ||
        ((status & PH_ERR_MASK) == PH_ERR_SUCCESS_CHAINING) ||
        ((status & PH_ERR_MASK) == PH_ERR_SUCCESS_INCOMPLETE_BYTE)) &&
        !(wOption & PH_EXCHANGE_BUFFERED_BIT) &&
        (ppRxBuffer != NULL))
    {
        PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG, ppRxBuffer_log, *ppRxBuffer, *pRxLength);
    }
#endif /* NXPBUILD__PH_LOG */
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phpalMifare_ExchangeRaw(void * pDataParams, uint16_t wOption, uint8_t * pTxBuffer, uint16_t wTxLength,
    uint8_t bTxLastBits, uint8_t ** ppRxBuffer, uint16_t * pRxLength, uint8_t * pRxLastBits)
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phpalMifare_ExchangeRaw");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wOption);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(pTxBuffer);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bTxLastBits);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(ppRxBuffer);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(pRxLastBits);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, wOption_log, &wOption);
    PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG, pTxBuffer_log, pTxBuffer, wTxLength);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bTxLastBits_log, &bTxLastBits);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL(pDataParams);
    if(wTxLength) PH_ASSERT_NULL(pTxBuffer);

    /* Check data parameters */
    if(PH_GET_COMPCODE(pDataParams) != PH_COMP_PAL_MIFARE)
    {
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_PAL_MIFARE);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHPAL_MIFARE_STUB
        case PHPAL_MIFARE_STUB_ID:
            status = phpalMifare_Stub_ExchangeRaw(
                (phpalMifare_Stub_DataParams_t *) pDataParams,
                wOption,
                pTxBuffer,
                wTxLength,
                bTxLastBits,
                ppRxBuffer,
                pRxLength,
                pRxLastBits);
            break;
#endif /* NXPBUILD__PHPAL_MIFARE_STUB */

#ifdef NXPBUILD__PHPAL_MIFARE_SW
        case PHPAL_MIFARE_SW_ID:
            status = phpalMifare_Sw_ExchangeRaw(
                (phpalMifare_Sw_DataParams_t *) pDataParams,
                wOption,
                pTxBuffer,
                wTxLength,
                bTxLastBits,
                ppRxBuffer,
                pRxLength,
                pRxLastBits);
            break;
#endif /* NXPBUILD__PHPAL_MIFARE_SW */



#ifdef NXPBUILD__PHPAL_MIFARE_RD710
        case PHPAL_MIFARE_RD710_ID:
            status = phpalMifare_Rd710_ExchangeRaw(
                (phpalMifare_Rd710_DataParams_t *) pDataParams,
                wOption,
                pTxBuffer,
                wTxLength,
                bTxLastBits,
                ppRxBuffer,
                pRxLength,
                pRxLastBits);
            break;
#endif /* NXPBUILD__PHPAL_MIFARE_RD710 */

        default:
            status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_PAL_MIFARE);
            break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
#ifdef NXPBUILD__PH_LOG
    if((((status & PH_ERR_MASK) == PH_ERR_SUCCESS) ||
        ((status & PH_ERR_MASK) == PH_ERR_SUCCESS_CHAINING) ||
        ((status & PH_ERR_MASK) == PH_ERR_SUCCESS_INCOMPLETE_BYTE)) &&
        !(wOption & PH_EXCHANGE_BUFFERED_BIT) &&
        (ppRxBuffer != NULL))
    {
        PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG, ppRxBuffer_log, *ppRxBuffer, *pRxLength);
        PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, pRxLastBits_log, pRxLastBits);
    }
#endif /* NXPBUILD__PH_LOG */
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phpalMifare_MfcAuthenticateKeyNo(void * pDataParams, uint8_t bBlockNo, uint8_t bKeyType, uint16_t wKeyNo,
    uint16_t wKeyVersion,uint8_t * pUid)
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phpalMifare_MfcAuthenticateKeyNo");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bBlockNo);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bKeyType);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wKeyNo);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wKeyVersion);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(pUid);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bBlockNo_log, &bBlockNo);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bKeyType_log, &bKeyType);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, wKeyNo_log, &wKeyNo);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, wKeyVersion_log, &wKeyVersion);
    PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG, pUid_log, pUid, 4);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL(pDataParams);
    PH_ASSERT_NULL(pUid);

    /* Check data parameters */
    if(PH_GET_COMPCODE(pDataParams) != PH_COMP_PAL_MIFARE)
    {
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_PAL_MIFARE);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHPAL_MIFARE_STUB
        case PHPAL_MIFARE_STUB_ID:
            status = phpalMifare_Stub_MfcAuthenticateKeyNo(
                (phpalMifare_Stub_DataParams_t *) pDataParams,
                bBlockNo,
                bKeyType,
                wKeyNo,
                wKeyVersion,
                pUid);
            break;
#endif /* NXPBUILD__PHPAL_MIFARE_STUB */

#ifdef NXPBUILD__PHPAL_MIFARE_SW
        case PHPAL_MIFARE_SW_ID:
            status = phpalMifare_Sw_MfcAuthenticateKeyNo(
                (phpalMifare_Sw_DataParams_t *) pDataParams,
                bBlockNo,
                bKeyType,
                wKeyNo,
                wKeyVersion,
                pUid);
            break;
#endif /* NXPBUILD__PHPAL_MIFARE_SW */



#ifdef NXPBUILD__PHPAL_MIFARE_PCSC
        case PHPAL_MIFARE_PCSC_ID:
            status = phpalMifare_Pcsc_MfcAuthenticateKeyNo(
                (phpalMifare_Pcsc_DataParams_t *) pDataParams,
                bBlockNo,
                bKeyType,
                wKeyNo,
                wKeyVersion,
                pUid);
            break;
#endif /* NXPBUILD__PHPAL_MIFARE_PCSC */


#ifdef NXPBUILD__PHPAL_MIFARE_RD710
        case PHPAL_MIFARE_RD710_ID:
            status = phpalMifare_Rd710_MfcAuthenticateKeyNo(
                (phpalMifare_Rd710_DataParams_t *) pDataParams,
                bBlockNo,
                bKeyType,
                wKeyNo,
                wKeyVersion,
                pUid);
            break;
#endif /* NXPBUILD__PHPAL_MIFARE_RD710 */

        default:
            status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_PAL_MIFARE);
            break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phpalMifare_MfcAuthenticate(void * pDataParams, uint8_t bBlockNo, uint8_t bKeyType, uint8_t * pKey,
    uint8_t * pUid)
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phpalMifare_MfcAuthenticate");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bBlockNo);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bKeyType);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(pKey);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(pUid);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bBlockNo_log, &bBlockNo);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bKeyType_log, &bKeyType);
    PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG, pKey_log, pKey, 6);
    PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG, pUid_log, pUid, 4);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL(pDataParams);
    PH_ASSERT_NULL(pKey);
    PH_ASSERT_NULL(pUid);

    /* Check data parameters */
    if(PH_GET_COMPCODE(pDataParams) != PH_COMP_PAL_MIFARE)
    {
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_PAL_MIFARE);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHPAL_MIFARE_STUB
        case PHPAL_MIFARE_STUB_ID:
            status = phpalMifare_Stub_MfcAuthenticate(
                (phpalMifare_Stub_DataParams_t *) pDataParams,
                bBlockNo,
                bKeyType,
                pKey,
                pUid);
            break;
#endif /* NXPBUILD__PHPAL_MIFARE_STUB */

#ifdef NXPBUILD__PHPAL_MIFARE_SW
        case PHPAL_MIFARE_SW_ID:
            status = phpalMifare_Sw_MfcAuthenticate(
                (phpalMifare_Sw_DataParams_t *) pDataParams,
                bBlockNo,
                bKeyType,
                pKey,
                pUid);
            break;
#endif /* NXPBUILD__PHPAL_MIFARE_SW */



#ifdef NXPBUILD__PHPAL_MIFARE_PCSC
        case PHPAL_MIFARE_PCSC_ID:
            status = phpalMifare_Pcsc_MfcAuthenticate(
                (phpalMifare_Pcsc_DataParams_t *) pDataParams,
                bBlockNo,
                bKeyType,
                pKey,
                pUid);
            break;
#endif /* NXPBUILD__PHPAL_MIFARE_PCSC */

#ifdef NXPBUILD__PHPAL_MIFARE_RD710
        case PHPAL_MIFARE_RD710_ID:
            status = phpalMifare_Rd710_MfcAuthenticate(
                (phpalMifare_Rd710_DataParams_t *) pDataParams,
                bBlockNo,
                bKeyType,
                pKey,
                pUid);
            break;
#endif /* NXPBUILD__PHPAL_MIFARE_RD710 */

        default:
            status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_PAL_MIFARE);
            break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phpalMifare_SetMinFdtPc(void * pDataParams, uint16_t wValue)
{
    phStatus_t PH_MEMLOC_REM status;
    /* perform operation on active layer */
    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHPAL_MIFARE_SW
        case PHPAL_MIFARE_SW_ID:
            status = phpalMifare_Sw_SetMinFdtPc(
                (phpalMifare_Sw_DataParams_t *) pDataParams,
                wValue);
            break;

        default:
            status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_PAL_MIFARE);
            break;
#endif /* NXPBUILD__PHPAL_MIFARE_SW */
    }

    return status;
}

phStatus_t phpalMifare_GetConfig(void * pDataParams, uint16_t wConfig, uint16_t * pValue)
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phpalMifare_GetConfig");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wConfig);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(pValue);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, wConfig_log, &wConfig);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL(pDataParams);
    PH_ASSERT_NULL(pValue);

    /* Check data parameters */
    if(PH_GET_COMPCODE(pDataParams) != PH_COMP_PAL_MIFARE)
    {
        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_PAL_MIFARE);
    }

    /* perform operation on active layer */
    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHPAL_MIFARE_SW
        case PHPAL_MIFARE_SW_ID:
            status = phpalMifare_Sw_GetConfig(
                (phpalMifare_Sw_DataParams_t *) pDataParams,
                wConfig,
                pValue);
            break;
#endif /* NXPBUILD__PHPAL_MIFARE_SW */


#ifdef NXPBUILD__PHPAL_MIFARE_PCSC
        case PHPAL_MIFARE_PCSC_ID:
            status = phpalMifare_Pcsc_GetConfig(
                (phpalMifare_Pcsc_DataParams_t *) pDataParams,
                wConfig,
                pValue);
            break;
#endif /* NXPBUILD__PHPAL_MIFARE_PCSC */

        default:
            status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_PAL_MIFARE);
            break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, pValue_log, pValue);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phpalMifare_SetConfig(void * pDataParams, uint16_t wConfig, uint16_t wValue)
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phpalMifare_SetConfig");
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wConfig);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wValue);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, wConfig_log, &wConfig);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, wValue_log, &wValue);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL(pDataParams);

    /* Check data parameters */
    if(PH_GET_COMPCODE(pDataParams) != PH_COMP_PAL_MIFARE)
    {
        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_PAL_MIFARE);
    }

    /* perform operation on active layer */
    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHPAL_MIFARE_PCSC
        case PHPAL_MIFARE_PCSC_ID:
            status = phpalMifare_Pcsc_SetConfig(
                (phpalMifare_Pcsc_DataParams_t *) pDataParams,
                wConfig,
                wValue);
            break;
#endif /* NXPBUILD__PHPAL_MIFARE_PCSC */

        default:
            status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_PAL_MIFARE);
            break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

#endif /* NXPBUILD__PHPAL_MIFARE */
