/*
 * Copyright 2013, 2015, 2017, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal definitions for FPGA-Box Reader specific HAL-Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHHALHW_RDFPGAV6_INT_H
#define PHHALHW_RDFPGAV6_INT_H

#include <ph_Status.h>

#define PHHAL_HW_RDFPGAV6_CMD_JOINER_I  						0x8000
#define PHHAL_HW_RDFPGAV6_CMD_JOINER_Q  						0x8001
#define PHHAL_HW_RDFPGAV6_CMD_JOINER_BOTH  						0x8002

#define PHHAL_HW_RDFPGAV6_V6_I14443_ADD_DELAY_US				    84         /**< Additional digital timeout delay for ISO14443 (4 bits needed for reception detection). */
#define PHHAL_HW_RDFPGAV6_V6_I14443_ADD_DELAY_US_ANTICOLLISION      57         /**< Additional digital timeout delay for ISO14443 during anticollision as RxNoError is switched off and we imediately (1 bit) detect any received data. */
#define PHHAL_HW_RDFPGAV6_V6_I14443_ADD_DELAY_US_TYPEB              300        /**< Additional digital timeout delay for Type B Mode */
#define PHHAL_HW_RDFPGAV6_V6_I14443_ADD_DELAY_US_TYPEF              600        /**< Additional digital timeout delay for Type F Mode */

phStatus_t phhalHw_RdFpgaV6_Int_ConvertError(phhalHw_RdFpgaV6_DataParams_t * pDataParams,
                                             int16_t status);

phStatus_t phhalHw_RdFpgaV6_Int_Wait(uint16_t wWaitTime);

phStatus_t phhalHw_RdFpgaV6_Int_GetDigDelay(
    phhalHw_RdFpgaV6_DataParams_t * pDataParams,
    uint32_t * pdwTimeoutUs
    );

#endif /* PHHALHW_RDFPGAV6_INT_H */
