/*
 * Copyright 2013, 2015, 2017, 2020, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal definitions for Rc523 specific HAL-Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHHALHW_RC523_CONFIG_H
#define PHHALHW_RC523_CONFIG_H

#include <ph_Status.h>
#include <phhalHw.h>

/** \defgroup phhalHw_Rc523_Config Configuration
* \brief Custom Configuration of hardware related settings.
* @{
*/

/** \name Memory related constants
*/
/** @{ */
#define PHHAL_HW_RC523_PRECACHED_BYTES  0x40U   /**< Maximum number of bytes to precache into FIFO before triggering a command. */
/** @} */

/** \name Modulation indices
*/
/** @{ */
#define PHHAL_HW_RC523_MODINDEX_I14443B     0x11U   /**< Default modulation index for ISO14443B. */
#define PHHAL_HW_RC523_MODINDEX_FELICA      0x12U   /**< Default modulation index for Felica. */
#define PHHAL_HW_RC523_MODINDEX_TARGET      0xF2U   /**< Default conductance for LoadModulation. */
/** @} */

/** \name RxThreshold values
*/
/** @{ */
#define PHHAL_HW_RC523_RXTHRESHOLD_I14443A          0x55U   /**< RxThreshold for ISO14443A. */
#define PHHAL_HW_RC523_RXTHRESHOLD_I14443B          0x50U   /**< RxThreshold for ISO14443B. */
#define PHHAL_HW_RC523_RXTHRESHOLD_FELICA           0x55U   /**< RxThreshold for Felica. */
/** @} */

/** \name Feature selection
*/
/** @{ */
#define PHHAL_HW_RC523_FEATURE_FIFO_UNDERFLOW_CHECK /**< Checks for FIFO underflow during data transmission if defined. */
/** @} */

/**
* end of phhalHw_Rc523_Config group
* @}
*/

#endif /* PHHALHW_RC523_CONFIG_H */
