/*
 * Copyright 2013, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * BAL SocketWin Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHBALREG_SOCKETWIN_INT_H
#define PHBALREG_SOCKETWIN_INT_H

#include <ph_Status.h>

/** \addtogroup ph_Private
* @{
*/

/* MS Windows Socket Subsystem */
#ifdef _WIN32
#pragma warning(push)           /* PRQA S 3116 */
#pragma warning(disable:4001)   /* PRQA S 3116 */
#include <winsock2.h>           /* winsock has to be included first! */
#include <windows.h>
#include <ws2tcpip.h>
#include <ctype.h>
#include <stdlib.h>
#include <stdio.h>                  /* PRQA S 5124 */
#pragma warning(pop)                /* PRQA S 3116 */
#pragma comment(lib, "ws2_32.lib")  /* PRQA S 3116 */
#endif

/** Default host name. */
#define PHBAL_REG_SOCKETWIN_HOST_DEFAULT "localhost"

/** Default port number. */
#define PHBAL_REG_SOCKETWIN_PORT_DEFAULT "15200"

/** Default username number. */
#define PHBAL_REG_SOCKETWIN_USER_DEFAULT ""

#define PHBAL_REG_SOCKETWIN_ACK_RX  "ACK"   /**< ACK string on Rx from NcSim. */

#ifdef _WIN32

void phbalReg_SocketWin_Removechar(
                                   uint8_t * pStr,
                                   uint8_t Ch
                                   );

phStatus_t phbalReg_SocketWin_HexToString(
    uint8_t * pHex,
    uint16_t wHexLength,
    uint16_t wStringSize,
    uint8_t * pString
    );

phStatus_t phbalReg_SocketWin_StringToHex(
    uint8_t * pString,
    uint16_t * pNewLength
    );

#endif

/** @}
* end of ph_Private group
*/

#endif /* PHBALREG_SOCKETWIN_INT_H */
