/*
 * Copyright 2024 - 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Software implementation of NTAG X DNA application layer.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7462 $
 * $Date: 2025-08-29 14:09:06 +0530 (Fri, 29 Aug 2025) $
 *
 * History:
 *  Rajendran Kumar: Generated 22 Aug 2024
 *
 */

#ifndef PHALNTAGXDNA_SW_INT_H
#define PHALNTAGXDNA_SW_INT_H

#include <ph_Status.h>

#ifdef NXPBUILD__PHAL_NTAGXDNA_SW

#include <phalNtagXDna.h>

#define PHAL_NTAGXDNA_CMD_BUF                 pDataParams->pCmdBuf
#define PHAL_NTAGXDNA_CMD_BUF_SIZE            pDataParams->wCmdBufSize
#define PHAL_NTAGXDNA_CMD_BUF_LEN             pDataParams->wCmdBufLen
#define PHAL_NTAGXDNA_CMD_BUF_OFFSET          pDataParams->wCmdBufOffset

#define PHAL_NTAGXDNA_PRS_BUF                 pDataParams->pPrsBuf
#define PHAL_NTAGXDNA_PRS_BUF_SIZE            pDataParams->wPrsBufSize
#define PHAL_NTAGXDNA_PRS_BUF_LEN             pDataParams->wPrsBufLen
#define PHAL_NTAGXDNA_PRS_BUF_OFFSET          pDataParams->wPrsBufOffset

#define PHAL_NTAGXDNA_IS_PICC_DATA_COMPLETE   pDataParams->bPICCDataComplete

#ifdef NXPBUILD__PH_CRYPTOSYM
#define PHAL_NTAGXDNA_HAS_MAC_PROCESSED       pDataParams->bHasMACProcessed
#define PHAL_NTAGXDNA_IS_ENC_PENDING          pDataParams->bIsENCPending
#endif /* NXPBUILD__PH_CRYPTOSYM */

#ifdef NXPBUILD__PH_CRYPTOSYM
extern uint8_t PH_MEMLOC_CONST_ROM phalNtagXDna_Sw_ZeroIv[PH_CRYPTOSYM_AES_BLOCK_SIZE];
#endif /* NXPBUILD__PH_CRYPTOSYM */





phStatus_t phalNtagXDna_Sw_Int_ValidateResponse(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bOption, uint16_t wStatus,
    uint16_t wPiccRetCode);

phStatus_t phalNtagXDna_Sw_Int_CardExchange(phalNtagXDna_Sw_DataParams_t * pDataParams, uint16_t wBufferOption,
    uint8_t bCmdOption, uint16_t wTotDataLen, uint8_t bExchangeLE, uint8_t * pData, uint16_t wDataLen,
    uint8_t ** ppResponse, uint16_t * pRespLen, uint8_t * pPiccErrCode);

phStatus_t phalNtagXDna_Sw_Int_Send7816Apdu(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bOption, uint16_t wBufOption,
    uint8_t bExtendedLenApdu, uint8_t bClass, uint8_t bIns, uint8_t bP1, uint8_t bP2, uint8_t * pData,
    uint16_t wDataLen, uint32_t dwExpBytes, uint8_t ** ppResponse, uint16_t * pRspLen);




#ifdef NXPBUILD__PH_CRYPTOSYM
/* ISOGeneral Authenticate With Host as Initiator and Device as Responder -------------------------------------------------------------- */
phStatus_t phalNtagXDna_Sw_Int_ISOGeneralAuthenticate_Initiator(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bDeviceCert_Cached,
    uint8_t bCertRepoID, uint8_t bCert_Depth, uint8_t bKeySize_Host, uint16_t wPriv_KeyNo, uint16_t wPriv_KeyPos, uint16_t wPub_KeyNo,
    uint16_t wPub_KeyPos, uint8_t * pExpRspLen, uint8_t bExpRspLen, phalNtagXDna_Cert stHostCert, phalNtagXDna_Cert * pDeviceCert);

phStatus_t phalNtagXDna_Sw_Int_ISOGeneralAuthenticate_Initiator_Payload_A0(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bCertRepoID,
    uint8_t *pKeySize, uint8_t * pEPubKey, uint16_t * pEPubKeyLen, uint8_t * pExpRspLen, uint8_t bExpRspLen, uint8_t ** ppResponse,
    uint16_t * pRespLen);

phStatus_t phalNtagXDna_Sw_Int_ISOGeneralAuthenticate_Initiator_Payload_A1(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bCertRepoID,
    uint16_t wTagLen, uint16_t wPriv_KeyNo, uint16_t wPriv_KeyPos, uint8_t bKeySize_Host, uint8_t bKeySize_Device, uint8_t * pEndLeaf_Cert,
    uint16_t wEndLeaf_Cert_Len, uint8_t * pE_PubInit, uint16_t wE_PubInitLen, uint8_t * pE_PubResp, uint16_t wE_PubRespLen,
    uint8_t * pExpRspLen, uint8_t bExpRspLen, uint8_t ** ppResponse, uint16_t * pRespLen);

phStatus_t phalNtagXDna_Sw_Int_ISOGeneralAuthenticate_Initiator_Payload_A2(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bCertRepoID,
    uint16_t wTagLen, uint8_t * pCert_Depth, uint8_t * pExpRspLen, uint8_t bExpRspLen, uint8_t ** ppResponse, uint16_t * pRespLen);

phStatus_t phalNtagXDna_Sw_Int_ISOGeneralAuthenticate_Initiator_Payload_A3(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bCertRepoID,
    uint16_t wTagLen, uint8_t * pCert, uint16_t wCert_Len, uint8_t * pExpRspLen, uint8_t bExpRspLen, uint8_t ** ppResponse,
    uint16_t * pRespLen);

phStatus_t phalNtagXDna_Sw_Int_ISOGeneralAuthenticate_Initiator_Payload_B1(uint8_t bKeySize_Host, uint8_t * pInput, uint16_t wInputLen,
    uint8_t * pKeySize_Device, uint8_t * pEPubKey, uint16_t * pEPubKeyLen, uint8_t ** ppEncData, uint16_t * pEncDataLen);

phStatus_t phalNtagXDna_Sw_Int_ISOGeneralAuthenticate_Initiator_Payload_B2(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t * pInput,
    uint16_t wInputLen, uint8_t * pOutData);

phStatus_t phalNtagXDna_Sw_Int_ISOGeneralAuthenticate_Initiator_Payload_B3(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t * pInput,
    uint16_t wInputLen, uint8_t ** ppOutData, uint16_t * pOutDataLen);

/* ISOGeneral Authenticate with Host as Responder and Device as Initiator -------------------------------------------------------------- */
phStatus_t phalNtagXDna_Sw_Int_ISOGeneralAuthenticate_Responder(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bDeviceCert_Cached,
    uint8_t bCertRepoID, uint8_t bCert_Depth, uint8_t bKeySize_Host, uint16_t wPriv_KeyNo, uint16_t wPriv_KeyPos, uint16_t wPub_KeyNo,
    uint16_t wPub_KeyPos, uint8_t * pExpRspLen, uint8_t bExpRspLen, phalNtagXDna_Cert stHostCert, phalNtagXDna_Cert * pDeviceCert);

phStatus_t phalNtagXDna_Sw_Int_ISOGeneralAuthenticate_Responder_Payload_A2(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t * pInput,
    uint16_t wInputLen, uint8_t * pOutData);

phStatus_t phalNtagXDna_Sw_Int_ISOGeneralAuthenticate_Responder_Payload_A3(phalNtagXDna_Sw_DataParams_t * pDataParams, uint16_t wTagLen,
    uint8_t * pInput, uint16_t wInputLen, uint8_t ** ppOutData, uint16_t * pOutDataLen);

phStatus_t phalNtagXDna_Sw_Int_ISOGeneralAuthenticate_Responder_Payload_B0(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bCertRepoID,
    uint8_t bKeySize_Host, uint8_t * pExpRspLen, uint8_t bExpRspLen, uint8_t * pKeySize_Device, uint8_t * pEPubKey, uint16_t * pEPubKeyLen);

phStatus_t phalNtagXDna_Sw_Int_ISOGeneralAuthenticate_Responder_Payload_B1(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bCertRepoID,
    uint16_t wTagLen, uint16_t wPriv_KeyNo, uint16_t wPriv_KeyPos, uint8_t bKeySize_Host, uint8_t bKeySize_Device, uint8_t * pEndLeaf_Cert,
    uint16_t wEndLeaf_Cert_Len, uint8_t * pE_PubInit, uint16_t wE_PubInitLen, uint8_t * pE_PubResp, uint16_t wE_PubRespLen,
    uint8_t * pExpRspLen, uint8_t bExpRspLen, uint8_t ** ppResponse, uint16_t * pRespLen);

phStatus_t phalNtagXDna_Sw_Int_ISOGeneralAuthenticate_Responder_Payload_B2(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bCertRepoID,
    uint16_t wTagLen, uint8_t * pInput, uint16_t wInputLen, uint8_t * pExpRspLen, uint8_t bExpRspLen, uint8_t ** ppResponse,
    uint16_t * pRespLen);

phStatus_t phalNtagXDna_Sw_Int_ISOGeneralAuthenticate_Responder_Payload_B3(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bCertRepoID,
    uint16_t wTagLen, uint8_t * pCert, uint16_t wCert_Len, uint8_t * pExpRspLen, uint8_t bExpRspLen, uint8_t ** ppResponse,
    uint16_t * pRespLen);

phStatus_t phalNtagXDna_Sw_Int_ISOGeneralAuthenticate_GenerateSignature(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bIsHostResponder,
    uint16_t wPriv_KeyNo, uint16_t wPriv_KeyPos, uint8_t bKeySize_Host, uint8_t bKeySize_Device, uint8_t * pEndLeaf_Cert,
    uint16_t wEndLeaf_Cert_Len, uint8_t * pE_PubInit, uint16_t wE_PubInitLen, uint8_t * pE_PubResp, uint16_t wE_PubRespLen,
    uint8_t * pCertHash, uint16_t * pCertHashLen, uint8_t ** ppSignature, uint16_t * pSigLen);

phStatus_t phalNtagXDna_Sw_Int_ISOGeneralAuthenticate_VerifyCertHash(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t * pCertHash,
    uint16_t wCertHashLen, uint8_t *pCert, uint16_t wCertLen);

phStatus_t phalNtagXDna_Sw_Int_ISOGeneralAuthenticate_VerifySignature(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bIsHostResponder,
    uint16_t wPub_KeyNo, uint16_t wPub_KeyPos, uint8_t bKeySize_Host, uint8_t bKeySize_Device, uint8_t * pCertHash, uint8_t bCertHashLen,
    uint8_t * pE_PubInit, uint16_t wE_PubInitLen, uint8_t * pE_PubResp, uint16_t wE_PubRespLen, uint8_t * pSignature, uint16_t wSigLen);

phStatus_t phalNtagXDna_Sw_Int_GenerateSessionKeys_ASym(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bKeySize, uint8_t * pE_PubInit,
    uint16_t wE_PubInitLen, uint8_t * pE_PubResp, uint16_t wE_PubRespLen, uint8_t * pSharedSecret, uint16_t wSharedSecretLen);

phStatus_t phalNtagXDna_Sw_Int_GenerateSessionKeys_Sym(phalNtagXDna_Sw_DataParams_t * pDataParams, uint16_t wKeyType,
    uint8_t * pRndA, uint8_t * pRndB);
#endif /* NXPBUILD__PH_CRYPTOSYM */





phStatus_t phalNtagXDna_Sw_Int_ApplySM(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bIsFirstFrame, uint8_t bIsLastFrame,
    uint8_t bCommMode, uint8_t * pCmdHeader, uint16_t wCmdHeaderLen, uint8_t * pCmdData, uint16_t wCmdDataLen,
    uint8_t ** ppSMBuf, uint16_t * pSMBufLen);

phStatus_t phalNtagXDna_Sw_Int_RemoveSM(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bIsISOChained, uint8_t bIsFirstFrame,
    uint8_t bIsLastFrame, uint8_t bCommMode, uint8_t * pResponse, uint16_t wRespLen, uint8_t bPiccStat, uint8_t ** ppOutBuffer,
    uint16_t * pOutBufLen);

phStatus_t phalNtagXDna_Sw_Int_ReadData(phalNtagXDna_Sw_DataParams_t * pDataParams, uint16_t wOption, uint8_t bIsISOChained,
    uint8_t bCmd_ComMode, uint8_t bResp_ComMode, uint8_t * pCmdHeader, uint16_t wCmdHeaderLen, uint32_t dwDataToRead,
    uint8_t ** ppResponse, uint16_t * pRespLen);

phStatus_t phalNtagXDna_Sw_Int_WriteData(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bCmd_ComMode, uint8_t bResp_ComMode,
    uint8_t bResetAuth, uint8_t * pCmdHeader, uint16_t wCmdHeaderLen, uint8_t * pCmdData, uint32_t dwCmdDataLen,
    uint8_t ** ppResponse, uint16_t * pRespLen);





phStatus_t phalNtagXDna_Sw_Int_ISOSelectFile(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t * pData, uint16_t wDataLen,
    uint8_t * pLe, uint8_t bLeLen, uint8_t ** ppResponse, uint16_t * pRspLen);

phStatus_t phalNtagXDna_Sw_Int_ISOReadBinary(phalNtagXDna_Sw_DataParams_t * pDataParams, uint16_t wOption, uint8_t * pLe,
    uint8_t bLeLen, uint8_t ** ppResponse, uint16_t * pRspLen);

phStatus_t phalNtagXDna_Sw_Int_ISOUpdateBinary(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t * pData, uint16_t wDataLen);





phStatus_t phalNtagXDna_Sw_Int_ResetAuthStatus(phalNtagXDna_Sw_DataParams_t * pDataParams);

phStatus_t phalNtagXDna_Sw_Int_GetFrameLen(phalNtagXDna_Sw_DataParams_t * pDataParams, uint16_t * pFrameLen);

#ifdef NXPBUILD__PH_CRYPTOSYM
phStatus_t phalNtagXDna_Sw_Int_GenerateIv(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bIsResponse, uint8_t * pTi,
    uint16_t wCmdCtr);

phStatus_t phalNtagXDna_Sw_Int_ComputeSessionKey_SDM(phalNtagXDna_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t bSdmOption,
    uint16_t wKeyNo_SDM, uint16_t wKeyVer_SDM, uint8_t * pUid, uint8_t bUidLen, uint8_t * pSDMReadCtr);

void phalNtagXDna_Sw_Int_TruncateMac(uint8_t * pMac);
#endif /* NXPBUILD__PH_CRYPTOSYM */

#endif /* NXPBUILD__PHAL_NTAGXDNA_SW */

#endif /* PHALNTAGXDNA_SW_INT_H */
