/*
 * Copyright 2010 - 2017, 2020, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal functions and defines of the Felica application layer.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 *
 * History:
 *  RSn: Generated 01. February 2010
 *
 */

#ifndef PHALFELICA_INT_H
#define PHALFELICA_INT_H

#include <ph_Status.h>

/** \addtogroup ph_Private
* @{
*/

/**
* \name Felica Command Codes
*/
/** @{ */
#define PHAL_FELICA_CMD_REQUEST_RESPONSE    0x04U   /**< Get the PICCs current mode. */
#define PHAL_FELICA_CMD_REQUEST_SERVICE     0x02U   /**< Get area key version and service key version. */
#define PHAL_FELICA_CMD_READ                0x06U   /**< Read the record value of the specified service. */
#define PHAL_FELICA_CMD_WRITE               0x08U   /**< Write records of the specified service. */
#define PHAL_FELICA_RSP_REQUEST_RESPONSE    0x05U   /**< Response code to the Request Response command. */
#define PHAL_FELICA_RSP_REQUEST_SERVICE     0x03U   /**< Response code to the Request Service command. */
#define PHAL_FELICA_RSP_READ                0x07U   /**< Response code to the Read command. */
#define PHAL_FELICA_RSP_WRITE               0x09U   /**< Response code to the Write command. */
/** @} */

/**
* end of ph_Private
* @}
*/

#endif /* PHALFELICA_INT_H */
