/*
 * Copyright 2013, 2020, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Rc663 functions of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHKEYSTORE_RC663_INT_H
#define PHKEYSTORE_RC663_INT_H

#include <ph_Status.h>


#define PH_KEYSTORE_RC663_EEP_WR_TO_MS            06U   /**< Time out to perform EEPROM write in milliseconds. */

/**
* \name Rc663 register definitions
*/
/** @{ */
#define PH_KEYSTORE_RC663_REG_COMMAND           0x00U   /**< Command register. */
#define PH_KEYSTORE_RC663_REG_FIFOCONTROL       0x02U   /**< FIFO Control register. */
#define PH_KEYSTORE_RC663_REG_FIFODATA          0x05U   /**< FIFO Data register. */
#define PH_KEYSTORE_RC663_REG_IRQ0              0x06U   /**< Interrupt 0 register. */
#define PH_KEYSTORE_RC663_REG_IRQ1              0x07U   /**< Interrupt 1 register. */

/* Bit definitions */
#define PH_KEYSTORE_RC663_BIT_IRQ_SET           0x80U   /**< Bit SET of the Irq registers. */

/* Control register */
#define PH_KEYSTORE_RC663_BIT_FLUSHFIFO         0x10U   /**< Clears internal FIFO buffer when set. */

/* Command set */
#define PH_KEYSTORE_RC663_CMD_IDLE              0x00U    /**< Command Idle. */
#define PH_KEYSTORE_RC663_CMD_STOREKEYE2        0x0FU    /**< Command to store keys in EE. */
/** @} */

/**
* \brief Write Store Keys in Eeprom command implementation.
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
*/
phStatus_t phKeyStore_Rc663_StoreKeyE2_Int(
                                        phKeyStore_Rc663_DataParams_t * pDataParams,
                                        uint8_t bKeyNumber,
                                        uint8_t * pKey,
                                        uint8_t bNumKeys
                                        );

#endif /* PHKEYSTORE_RC663_INT_H */
