/*
 * Copyright 2013, 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Software specific Crypto-Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <ph_Status.h>
#include <phCryptoRng.h>
#include <ph_RefDefs.h>

#ifdef NXPBUILD__PH_CRYPTORNG_STUB

#include "phCryptoRng_Stub.h"

phStatus_t phCryptoRng_Stub_Init(phCryptoRng_Stub_DataParams_t * pDataParams, uint16_t wSizeOfDataParams)
{
    if(sizeof(phCryptoRng_Stub_DataParams_t) != wSizeOfDataParams)
    {
        return PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_CRYPTORNG);
    }
    PH_ASSERT_NULL_DATA_PARAM(pDataParams, PH_COMP_CRYPTORNG);

    /* Init. private data */
    pDataParams->wId = PH_COMP_CRYPTORNG | PH_CRYPTORNG_STUB_ID;

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_CRYPTORNG);
}

phStatus_t phCryptoRng_Stub_Seed(phCryptoRng_Stub_DataParams_t * pDataParams, uint8_t * pSeed, uint8_t bSeedLength)
{
    /* satisfy compiler */
    if(pDataParams || pSeed || bSeedLength);

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_CRYPTORNG);
}

phStatus_t phCryptoRng_Stub_Rnd(phCryptoRng_Stub_DataParams_t * pDataParams, uint16_t  wNoOfRndBytes, uint8_t * pRnd)
{
    /* satisfy compiler */
    if(pDataParams || wNoOfRndBytes || pRnd);

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_CRYPTORNG);
}

#endif /* NXPBUILD__PHCRYPTORNG_STUB */
