/*
 * Copyright 2013, 2017, 2019 - 2020, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Mp300 specific HAL-Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHHALHW_MP300_CMD_H
#define PHHALHW_MP300_CMD_H

#include <ph_Status.h>
#include <phhalHw.h>

#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

#ifdef NXPBUILD__PHHAL_HW_MP300

/** \defgroup phhalHw_Mp300_Cmd Commands
* \brief Supported ReaderIC commands.
* @{
*/

/**
* \brief The function sets the Trigger mode for the PCD
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions. If the parameters are correct the function
returns the command execution status of the PCD. The PCD command execution status is mapped to a library status codes.
*/
phStatus_t phhalHw_Mp300_Cmd_TriggerOut(
    phhalHw_Mp300_DataParams_t * pDataParams,   /**< [In] Pointer to an initialized HAL parameter structure. */
    uint8_t bTriggerPort,                       /**< [In] Number of Trigger to use (only Trigger 1 and 2 is allowed). */
    uint32_t dwConfig,                          /**< [In] Trigger Config according to documentation of Mp300. */
    uint32_t dwValue                            /**< [In] Trigger Value according to documentation of Mp300. */
    );

/**
* \brief The system will adjust the level of the separated Rx signal in order to get a constant level.
* If separated Rx configuration is used, this API must be called at each time the RF field changes.
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions. If the parameters are correct the function
returns the command execution status of the PCD. The PCD command execution status is mapped to a library status codes.
*/
phStatus_t phhalHw_Mp300_Cmd_AdjustRXChannel(
    phhalHw_Mp300_DataParams_t * pDataParams    /**< [In] Pointer to an initialized HAL parameter structure. */
    );

/**
* \brief Set the shape that is used for Type A or Type B
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions. If the parameters are correct the function
returns the command execution status of the PCD. The PCD command execution status is mapped to a library status codes.
*/
phStatus_t phhalHw_Mp300_Cmd_SetModulationShape(
    phhalHw_Mp300_DataParams_t * pDataParams,   /**< [In] Pointer to an initialized HAL parameter structure. */
    uint32_t dwNbPointsFallingEdge,             /**< [In] Number of points of falling edge. */
    uint16_t * pPointsFallingEdge,              /**< [In] points of falling edge. In a range of 0..1000 */
    uint32_t dwNbPointsRisingEdge,              /**< [In] Number of points of rising edge. */
    uint16_t * pPointsRisingEdge                /**< [In] points of rising edge. In a range of 0..1000 */
    );

/**
* \brief Opens a scenario
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions. If the parameters are correct the function
returns the command execution status of the PCD. The PCD command execution status is mapped to a library status codes.
*/
phStatus_t phhalHw_Mp300_Cmd_OpenScenario(
    phhalHw_Mp300_DataParams_t * pDataParams    /**< [In] Pointer to an initialized HAL parameter structure. */
    );

/**
* \brief Execute a scenario
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions. If the parameters are correct the function
returns the command execution status of the PCD. The PCD command execution status is mapped to a library status codes.
*/
phStatus_t phhalHw_Mp300_Cmd_ExecuteScenario(
    phhalHw_Mp300_DataParams_t * pDataParams    /**< [In] Pointer to an initialized HAL parameter structure. */
    );

/**
* \brief Close a scenario
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions. If the parameters are correct the function
returns the command execution status of the PCD. The PCD command execution status is mapped to a library status codes.
*/
phStatus_t phhalHw_Mp300_Cmd_CloseScenario(
    phhalHw_Mp300_DataParams_t * pDataParams    /**< [In] Pointer to an initialized HAL parameter structure. */
    );

/**
* \brief add Commands to a scenario
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions. If the parameters are correct the function
returns the command execution status of the PCD. The PCD command execution status is mapped to a library status codes.
*/
phStatus_t phhalHw_Mp300_Cmd_AddToScenario(
    phhalHw_Mp300_DataParams_t * pDataParams,    /**< [In] Pointer to an initialized HAL parameter structure. */
    uint32_t dwActionID,                         /**< [In] ID of the action that should be added */
    uint8_t * pParameter,                        /**< [In] string with parameter for the action. */
    uint16_t wParameterLength                    /**< [In] Length of the parameter string. */
    );

/**
* \brief Setup Card Emulation Mode
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions. If the parameters are correct the function
returns the command execution status of the PCD. The PCD command execution status is mapped to a library status codes.
*/
phStatus_t phhalHw_Mp300_Cmd_SetupCardEmulationMode(
    phhalHw_Mp300_DataParams_t * pDataParams,    /**< [In] Pointer to an initialized HAL parameter structure. */
    uint32_t dwAdjustTimeout,                    /**< [In] Timeout used to adjust the input channel */
    uint32_t dwMaxRetryCnt                       /**< [In] number of retries performed if adjust failed */
    );

/**
* \brief Close Card Emulation Mode
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions. If the parameters are correct the function
returns the command execution status of the PCD. The PCD command execution status is mapped to a library status codes.
*/
phStatus_t phhalHw_Mp300_Cmd_CloseCardEmulationMode(
    phhalHw_Mp300_DataParams_t * pDataParams     /**< [In] Pointer to an initialized HAL parameter structure. */
    );

/**
* \brief Opens a scenario for Card Emulation
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions. If the parameters are correct the function
returns the command execution status of the PCD. The PCD command execution status is mapped to a library status codes.
*/
phStatus_t phhalHw_Mp300_Cmd_OpenScenarioPcd(
    phhalHw_Mp300_DataParams_t * pDataParams    /**< [In] Pointer to an initialized HAL parameter structure. */
    );

/**
* \brief Execute a scenario for Card Emulation
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions. If the parameters are correct the function
returns the command execution status of the PCD. The PCD command execution status is mapped to a library status codes.
*/
phStatus_t phhalHw_Mp300_Cmd_ExecuteScenarioPcd(
    phhalHw_Mp300_DataParams_t * pDataParams,    /**< [In] Pointer to an initialized HAL parameter structure. */
    uint32_t dwTimeout                           /**< [In] Timeout for execution of the scenario in ms. */
    );

/**
* \brief Close a scenario for Card Emulation
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions. If the parameters are correct the function
returns the command execution status of the PCD. The PCD command execution status is mapped to a library status codes.
*/
phStatus_t phhalHw_Mp300_Cmd_CloseScenarioPcd(
    phhalHw_Mp300_DataParams_t * pDataParams    /**< [In] Pointer to an initialized HAL parameter structure. */
    );

/**
* \brief add Commands to a scenario for Card Emulation
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions. If the parameters are correct the function
returns the command execution status of the PCD. The PCD command execution status is mapped to a library status codes.
*/
phStatus_t phhalHw_Mp300_Cmd_AddToScenarioPcd(
    phhalHw_Mp300_DataParams_t * pDataParams,    /**< [In] Pointer to an initialized HAL parameter structure. */
    uint32_t dwActionID,                         /**< [In] ID of the action that should be added */
    uint8_t * pParameter,                        /**< [In] string with parameter for the action. */
    uint16_t wParameterLength                    /**< [In] Length of the parameter string. */
    );

/**
* \brief Get the license status for a specified license
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
*/
phStatus_t phhalHw_Mp300_Cmd_CouplerCheckLicense(
    phhalHw_Mp300_DataParams_t * pDataParams,    /**< [In] Pointer to an initialized HAL parameter structure. */
    uint32_t dwLicenseId,                        /**< [In] Specifies the license. */
    int32_t *pValidLicense                       /**< [Out] license status. */
    );

/**
* \brief Set the handler for Bal timeout
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
*/
phStatus_t phhalHw_Mp300_Cmd_SetBalTimeoutHandler(
    phhalHw_Mp300_DataParams_t * pDataParams,    /**< [In] Pointer to an initialized HAL parameter structure. */
    cbBalTimeoutHandling pBalTimeoutHandling,    /**< [In] Pointer to the handler function. */
    void * pContext                              /**< [In] Pointer to the context of the callback function */
    );

/**
* \brief Enables Spy
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions.
*/
phStatus_t phhalHw_Mp300_Cmd_EnableSpy(
    phhalHw_Mp300_DataParams_t * pDataParams,
    uint32_t dwEventMask,
    uint8_t * pFilename,
    uint16_t wDateFormat
    );

/**
* \brief Disables Spy
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions.
*/
phStatus_t phhalHw_Mp300_Cmd_DisableSpy(
    phhalHw_Mp300_DataParams_t * pDataParams
    );

/**
* \brief GenerateDisturbance
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions.
*/
phStatus_t phhalHw_Mp300_Cmd_GenerateDisturbance(
    phhalHw_Mp300_DataParams_t * pDataParams,
    uint8_t bDisturbanceOperation,
    uint8_t bDisturbanceType,
    int32_t dwAmplitude,
    int16_t wOffset,
    uint32_t dwDuration,
    uint32_t dwMaintainLevel
    );

/**
* \brief ResetDisturbance
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions.
*/
phStatus_t phhalHw_Mp300_Cmd_ResetDisturbance(
    phhalHw_Mp300_DataParams_t * pDataParams,
    uint8_t bDisturbanceOperation
    );

/**
* \brief SetDisturbanceTrigger
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions.
*/
phStatus_t phhalHw_Mp300_Cmd_SetDisturbanceTrigger(
    phhalHw_Mp300_DataParams_t * pDataParams,
    uint8_t bDisturbanceOperation,
    uint32_t dwBehavior,
    uint32_t dwDelay,
    uint16_t wLoop
    );

/**
* \brief SetAdvancedTrigger
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions.
*/
phStatus_t phhalHw_Mp300_Cmd_SetAdvancedTrigger(
    phhalHw_Mp300_DataParams_t * pDataParams,
    uint8_t bTriggerPort,
    uint32_t dwConfig,
    uint32_t dwValue,
    uint16_t wExchangeCount
    );

/** @} */
#endif /* NXPBUILD__PHHAL_HW_MP300 */

#ifdef __cplusplus
} /* Extern C */
#endif

#endif /* PHHALHW_MP300_CMD_H */
