/*
 * Copyright 2017, 2020, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Mp300 specific HAL-Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLSTEPPER_DENSOVS60_CMD_H
#define PHDLSTEPPER_DENSOVS60_CMD_H


#include <ph_Status.h>
#include <phdlStepper.h>





/**
* \brief Go down on the Z axis until head sensor reaches obstacle
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions. If the parameters are correct the function
*/
phStatus_t phdlStepper_DensoVS60_Cmd_GoDownUntilContact(
                                                        phdlStepper_DensoVS60_DataParams_t * pDataParams,                       /**< [In] Pointer to this layer's parameter structure. */
                                                        int32_t dwMinZPoint,                                                    /**< [In] Point on the Z axis to which the robot should go */
                                                        uint16_t dwRobotSpeed                                                    /**< [In] Speed of the robot arm */

                                                        );
/**
* \brief Execute the spline movement for the selected path
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions. If the parameters are correct the function
*/
phStatus_t phdlStepper_DensoVS60_Cmd_SplineExecuteMove(
                                                    phdlStepper_DensoVS60_DataParams_t * pDataParams,                           /**< [In] Pointer to this layer's parameter structure. */
                                                    uint8_t bPathIndex,                                                             /**< [In] Index of the choosen path (range 1 to 20) */
                                                    uint8_t bBlocking                                                               /**< [In] Flag that sets the movement on blocking(1) or non-blocking(0) */
                                                    );


/**
* \brief Clear all points from the internal memory of the selected path
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions. If the parameters are correct the function
*/
phStatus_t phdlStepper_DensoVS60_Cmd_SplineClearPath(
                                                    phdlStepper_DensoVS60_DataParams_t * pDataParams,                           /**< [In] Pointer to this layer's parameter structure. */
                                                    uint8_t bPathIndex                                                           /**< [In] Index of the choosen path (range 1 to 20) */
                                                    );
/**
* \brief Add path point to the internal memory of the selected path
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions. If the parameters are correct the function
*/
phStatus_t phdlStepper_DensoVS60_Cmd_SplineAddPathPoint(
                                                         phdlStepper_DensoVS60_DataParams_t * pDataParams,                      /**< [In] Pointer to this layer's parameter structure. */
                                                         uint8_t   bPathIndex,                                                        /**< [In] Index of the choosen path (range 1 to 20) */
                                                         uint32_t dwPositionX,                                                   /**< [In] Value of X coodinate in micrometers */
                                                         uint32_t dwPositionY,                                                   /**< [In] Value of Y coodinate in micrometers */
                                                         uint32_t dwPositionZ                                                    /**< [In] Value of Z coodinate in micrometers */
                                                        );

/**
* \brief Load the inverse path of the selected path in the last internal slot(20)
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions. If the parameters are correct the function
*/
phStatus_t phdlStepper_DensoVS60_Cmd_SplineExecuteMoveInverse(
                                                         phdlStepper_DensoVS60_DataParams_t * pDataParams,                      /**< [In] Pointer to this layer's parameter structure. */
                                                         uint8_t bPathIndex,                                                        /**< [In] Index of the choosen path (range 1 to 20) */
                                                         uint8_t bBlocking                                                          /**< Flag for blocking or non-blockig movement */
                                                         );

/**
* \brief Checks if the current movement is done, or the robots still moves
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions. If the parameters are correct the function
*/
phStatus_t phdlStepper_DensoVS60_Cmd_WaitUntilMoveFinished(
                                                         phdlStepper_DensoVS60_DataParams_t * pDataParams                      /**< [In] Pointer to this layer's parameter structure. */
                                                         );

/**
* \brief Set the ip addrese of the robot arm
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions. If the parameters are correct the function
*/
phStatus_t phdlStepper_DensoVS60_Cmd_SetPort(
                                                         phdlStepper_DensoVS60_DataParams_t * pDataParams,
                                                         uint8_t*  pPortName
                                                          );

/**
* \brief Set a new ToolDef and the corresponding ToolDefNumber
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions. If the parameters are correct the function
*/
phStatus_t phdlStepper_DensoVS60_Cmd_SetToolDef(
                                                phdlStepper_DensoVS60_DataParams_t * pDataParams,       /**< [In] Pointer to this layer's parameter structure. */
                                                float64_t x,                                            /**< [In] Coordinate to set the new ToolDef. */
                                                float64_t y,                                            /**< [In] Coordinate to set the new ToolDef. */
                                                float64_t z,                                            /**< [In] Coordinate to set the new ToolDef. */
                                                float64_t rx,                                           /**< [In] Coordinate to set the new ToolDef. */
                                                float64_t ry,                                           /**< [In] Coordinate to set the new ToolDef. */
                                                float64_t rz,                                           /**< [In] Coordinate to set the new ToolDef. */
                                                uint16_t wtoolNumber                                    /**< [In] ToolNumber to be set. */
                                                );

/**
* \brief Moves the robot down, activates the pump and picks up a card.
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions. If the parameters are correct the function
*/
phStatus_t phdlStepper_DensoVS60_Cmd_PickupCard(
                                                phdlStepper_DensoVS60_DataParams_t * pDataParams
                                                );

/**
* \brief Moves the robot down, deactivates the pump and drops the card.
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions. If the parameters are correct the function
*/
phStatus_t phdlStepper_DensoVS60_Cmd_DropCard(
                                              phdlStepper_DensoVS60_DataParams_t * pDataParams
                                              );

#endif /* PHDLSTEPPER_DENSOVS60_CMD_H */
