/*
 * Copyright 2019 - 2020, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * ISO3 FPGA soft scope.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLOSCI_ISO3SOFTSCOPE_CMD_H
#define PHDLOSCI_ISO3SOFTSCOPE_CMD_H

#include <ph_Status.h>
#include <phdlOsci.h>

/**
* \brief Get rise and fall counter offset within soft scope buffer for channels:
*   -> PHDL_OSCI_ISO3SOFTSCOPE_CHANNEL_TRG1_RISE
*   -> PHDL_OSCI_ISO3SOFTSCOPE_CHANNEL_TRG1_FALL
*   -> PHDL_OSCI_ISO3SOFTSCOPE_CHANNEL_TRG2_RISE
*   -> PHDL_OSCI_ISO3SOFTSCOPE_CHANNEL_TRG2_FALL
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
*/
phStatus_t phdlOsci_ISO3SoftScope_Cmd_GetTriggerCounter(
    phdlOsci_ISO3SoftScope_DataParams_t * pDataParams,
    uint8_t bChannel,
    uint32_t * dwRiseCounter,
    uint32_t * dwFallCounter
    );

/**
* \brief Reset scope trigger events.
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
*/
phStatus_t phdlOsci_ISO3SoftScope_Cmd_Reset(
    phdlOsci_ISO3SoftScope_DataParams_t * pDataParams
    );

/**
* \brief Store big buffer data within remote buffer for online calculation (iir filter).
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
*/
phStatus_t phdlOsci_ISO3SoftScope_Cmd_StoreBigBufferDataInRemoteBuffer(
    phdlOsci_ISO3SoftScope_DataParams_t * pDataParams,
    uint8_t bRemoteBufferID,
    uint32_t dwMaxBufferSizeBytes
    );

/**
* \brief Forces softscope capture.
* \return Status code
*/
phStatus_t phdlOsci_ISO3SoftScope_Cmd_ForceTrigger(phdlOsci_ISO3SoftScope_DataParams_t * pDataParams);

/**
* \brief Checks if signal CAL or SENS is within range.
* \return Status code
*/
phStatus_t phdlOsci_ISO3SoftScope_Cmd_IsSignalInRange(phdlOsci_ISO3SoftScope_DataParams_t * pDataParams,
                                                      uint32_t dwDataSource,
                                                      uint8_t * overflow);

/**
* \brief get the current displayed waveform after softscope finishes aquiring data
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
* \retval Other Depending on implementation and underlying component.
*/
phStatus_t phdlOsci_ISO3SoftScope_Cmd_GetWaveFormBlocking(
                                                     phdlOsci_ISO3SoftScope_DataParams_t * pDataParams,
                                                     uint8_t  bChannel,
                                                     uint32_t dwWaveFormBufferSize,
                                                     uint32_t * pdwWaveFormLength,
                                                     uint8_t * pbWaveFormBuffer,
                                                     uint8_t * pbHeaderOffset
                                                     );

#endif /* PHDLOSCI_ISO3SOFTSCOPE_CMD_H */
