/*
 * Copyright 2022 - 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Example program to demonstrate Random number features.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PH_EXAMPLE_CRYPTOLIBFOOTPRINT_RND_H
#define PH_EXAMPLE_CRYPTOLIBFOOTPRINT_RND_H

#include "Example-CryptoLibFootprint.h"

#ifdef NXPBUILD__PH_CRYPTORNG
#include <phCryptoSym.h>
#include <phCryptoRng.h>

enum Component_Rng
{
    CRYPTORNG_TEMPORARY = 0,

#ifdef NXPBUILD__PH_CRYPTORNG_SW
    CRYPTORNG_SOFTWARE,
#endif /* NXPBUILD__PH_CRYPTORNG_SW */

#ifdef NXPBUILD__PH_CRYPTORNG_MBEDTLS
    CRYPTORNG_MBEDTLS,
#endif /* NXPBUILD__PH_CRYPTORNG_MBEDTLS */

#if !defined (NXPBUILD__PH_CRYPTORNG_SW) && !defined (NXPBUILD__PH_CRYPTORNG_MBEDTLS) && !defined (NXPBUILD__PH_CRYPTORNG_DUT)
#error Please enable any one of Random Number generation component to proceed
#endif /* NXPBUILD__PH_CRYPTORNG_SW */

    CRYPTORNG_MAX
};

#ifdef NXPBUILD__PH_CRYPTORNG_SW
phCryptoSym_Sw_DataParams_t stCryptoSymRng_Sw;
phCryptoRng_Sw_DataParams_t stCryptoRng_Sw;
#endif /* NXPBUILD__PH_CRYPTORNG_SW */

#ifdef NXPBUILD__PH_CRYPTORNG_MBEDTLS
phCryptoRng_mBedTLS_DataParams_t stCryptoRng_mBedTLS;
#endif /* NXPBUILD__PH_CRYPTORNG_MBEDTLS */

phStatus_t Demo_RandomNumber_Main();

#endif /* NXPBUILD__PH_CRYPTORNG */

#endif /* PH_EXAMPLE_CRYPTOLIBFOOTPRINT_RND_H */
