/*
 * Copyright 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
* SAM (AV4 and future SAM's) MIFARE Component of Reader Library Framework.
* $Author: Rajendran Kumar (nxp99556) $
* $Revision: 7230 $
* $Date: 2025-03-14 10:27:23 +0530 (Fri, 14 Mar 2025) $
*/

#ifndef PHPALMIFARE_SAM_X_H
#define PHPALMIFARE_SAM_X_H

#include <ph_Status.h>

phStatus_t phpalMifare_Sam_X_ExchangeL3(phpalMifare_Sam_X_DataParams_t * pDataParams, uint16_t wOption,
    uint8_t * pTxBuffer, uint16_t wTxBuffLen, uint8_t ** ppResponse, uint16_t * pRespLen);

phStatus_t phpalMifare_Sam_X_ExchangeL4(phpalMifare_Sam_X_DataParams_t * pDataParams, uint16_t wOption,
    uint8_t * pTxBuffer, uint16_t wTxBuffLen, uint8_t ** ppResponse, uint16_t * pRespLen);

phStatus_t phpalMifare_Sam_X_ConvertNak(phStatus_t wStatus);

#endif /* PHPALMIFARE_SAM_X_H */
