/*
 * Copyright 2017, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Dummy Android Component Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHPALI14443P4_ANDROID_INT_H
#define PHPALI14443P4_ANDROID_INT_H

#include <ph_Status.h>

/** \addtogroup ph_Private
* @{
*/
/** Command Header */
#define PHPAL_I14443P4_ANDROID_COMMAND_GET_SYS_INFO                0xED
#define PHPAL_I14443P4_ANDROID_COMMAND_ERROR                       0xEE
#define PHPAL_I14443P4_ANDROID_COMMAND_GET_TECHS                   0xEF
#define PHPAL_I14443P4_ANDROID_COMMAND_TAG_PRESENT                 0xFF
#define PHPAL_I14443P4_ANDROID_COMMAND_CONNECT                     0x00
#define PHPAL_I14443P4_ANDROID_COMMAND_CLOSE                       0x01
#define PHPAL_I14443P4_ANDROID_COMMAND_HI_LAYER                    0x02
#define PHPAL_I14443P4_ANDROID_COMMAND_HIST_BYTES                  0x03
#define PHPAL_I14443P4_ANDROID_COMMAND_GET_TRANSCEIVE_LENGTH       0x04
#define PHPAL_I14443P4_ANDROID_COMMAND_GET_TIMEOUT                 0x05
#define PHPAL_I14443P4_ANDROID_COMMAND_SET_TIMEOUT                 0x06
#define PHPAL_I14443P4_ANDROID_COMMAND_IS_CONNECTED                0x07
#define PHPAL_I14443P4_ANDROID_COMMAND_TRANSCEIVE                  0x08

phStatus_t phpalI14443p4_Android_OpenConnection(
    phpalI14443p4_Android_DataParams_t * pDataParams,
    uint8_t bTechnologie
    );

phStatus_t phpalI14443p4_Android_GetNewTagMessage(
    phpalI14443p4_Android_DataParams_t * pDataParams,
    uint16_t wTimeout
    );

phStatus_t phpalI14443p4_Android_CloseConnection(
    phpalI14443p4_Android_DataParams_t * pDataParams,
    uint8_t bTechnologie
    );

phStatus_t phpalI14443p4_Android_Transceive(
    phpalI14443p4_Android_DataParams_t * pDataParams,
    uint8_t bCommandHeader,
    uint8_t bTechnologie,
    uint8_t *pData,
    uint16_t wDataLength,
    uint8_t **ppResponse,
    uint16_t *pwResponseLength,
    uint64_t *pqwTimeUsed
    );

phStatus_t phpalI14443p4_Android_ClearReceiveBuffer(
    phpalI14443p4_Android_DataParams_t * pDataParams,
    uint32_t dwLength
    );

/** @}
* end of ph_Private group
*/

#endif /* PHPALI14443P4_ANDROID_INT_H */
