/**********************************************************************
                        SYST
                        For IRQ events
 MLOS32 Only
 **********************************************************************
 09/09/2003 Marc LEGOUX V2r08 - Move to KRN32
 **********************************************************************/
#ifndef systirq_h
#define systirq_h

#include <err.h>

/*----------------------------------------------------------------------*
                        Current task is interrupted by IRQ
 MANDATORY: Each task that is interrupted by an irq must be marked
 with this flag before it may be scheduled. 
 Reserved to the System.
 *----------------------------------------------------------------------*/
err_Type syst_IrqBreak(
        int On		/* Set the mode (else reset) */
        );
/*----------------------------------------------------------------------*
		Fast Irq Event
 *----------------------------------------------------------------------*/
typedef
  struct {
    void * task;		/* Task waiting in Irq mode or 0 */
    void * taski;		/* Interrupted task or 0 */
    void * tasko;		/* Owner Task waiting or 0 */
    unsigned	lvl;		/* Irq Level (syst_CS format)*/
  } syst_IrqEvtType;

/*----------------------------------------------------------------------*
                        IRQs
 syst_IrqTake
 syst_IrqWait
 	<- syst_IrqSignal
 ...
 syst_IrqWait
 	<- syst_IrqSignal
 syst_IrqRelease
 *----------------------------------------------------------------------*/
/*---------------------------------------------------------------------*
                        Init Irq
 *---------------------------------------------------------------------*/
err_Type syst_IrqInit(
        register void * IrqEvt0
        );
/*----------------------------------------------------------------------*
			A task is waiting
 Returns !=0 if yes
 *----------------------------------------------------------------------*/
#define syst_IrqIsWaiting(IrqEvt0) (IrqEvt0)->task
/*---------------------------------------------------------------------*
                        Wait for Irq
 Returns : restarting error 
 *---------------------------------------------------------------------*/
err_Type syst_IrqWait(
        register void * IrqEvt0
        );
/*---------------------------------------------------------------------*
                        Signal task from Irq
 To call by IRQ routine
 *---------------------------------------------------------------------*/
err_Type syst_IrqSignal(
        register void * IrqEvt0,
        register void * sigid		/* Signal Id (or task erno) */
        );
/*---------------------------------------------------------------------*
                        Take Irq
 Errors: syst__Timeout if Irq not available
 *---------------------------------------------------------------------*/
err_Type syst_IrqTake(
        register void * IrqEvt0,
        register unsigned timeout
        );
/*---------------------------------------------------------------------*
                        Release Irq
 *---------------------------------------------------------------------*/
err_Type syst_IrqRelease(
        register void * IrqEvt0
        );
#endif
