/*************************************************************************
                        MLOS USER
                        Main for DLL
 *************************************************************************
 21/04/2004 - Marc LEGOUX WNT6R11 : Adapt parameter types of syscfg calls
 08/12/2003 - Marc LEGOUX WNT6R10 : Add verberr and allow Start/End only once
 10/08/2002 - Marc LEGOUX WNT6R06 : Remove err_Verbose
 24/04/2001 - Marc LEGOUX WNT6R03 : From maindll
 *************************************************************************/
#include <stdlib.h>

#include <syst.h>
#include <syscfg.h>
#include <usercfg.h>

#define ModName	"USERDLL"

#define verberr	1

static unsigned usercfg_Started = 0;
static syst_MutexType	Mutex;
#define MutexTimeout	2000
/*-----------------------------------------------------------------------*
                        Start package at first call
 Package is not started if error
 *-----------------------------------------------------------------------*/
err_Type usercfg_Start(
	usercfg_Type * Cfg
	)
{
  err_Type erno;
  
  erno = syst_MutexTake(&Mutex, 0, MutexTimeout);
  if (erno) return(erno);
  do {
    if (usercfg_Started++) {
      err_Printf(verberr,"-%s.Start : Already started\n", ModName);
      break;
    }
    erno = syscfg_Start((mloscfg_Type *)Cfg);
    if (erno) {
      err_Printf(verberr,"-%s.Start : Error %lu\n",ModName,erno);
      break;
    }
    
  } while(0);
  if (erno) usercfg_Started--;
  syst_MutexRelease(&Mutex);
  return(erno);
}
/*-----------------------------------------------------------------------*
                        End package at last call
 Package is not ended if error
 *-----------------------------------------------------------------------*/
err_Type usercfg_End(usercfg_Type * Cfg)
{
  err_Type erno;
  
  erno = syst_MutexTake(&Mutex, 0, MutexTimeout);
  if (erno) return(erno);
  do {
    if (usercfg_Started == 0) break;
    if (--usercfg_Started > 0) break;
    
    erno = syscfg_End((mloscfg_Type *)Cfg);
    if (erno) {
      usercfg_Started++;
      err_Printf(verberr,"-%s.End : Error %lu\n", ModName,erno);
    }
  } while(0);
  syst_MutexRelease(&Mutex);
  return(erno);
}
/*-------------------------------------------------------------------*/
static 
HANDLE hDllInstance=NULL;
static 
long dllmain_PAttachNb = 0;
static 
long dllmain_TAttachNb = 0;
/*-------------------------------------------------------------------*
			MAIN
 			for DLL
 *-------------------------------------------------------------------*/
BOOL APIENTRY DllMain (HANDLE hModule, DWORD Reason, LPVOID lpReserved)
{
  switch (Reason)
  {
    case DLL_PROCESS_ATTACH : 
      dllmain_PAttachNb++;
      hDllInstance = hModule;
      syst_MutexOpen(&Mutex, 0);
      break;
    
    case DLL_PROCESS_DETACH :
      dllmain_PAttachNb--;
      
      if (usercfg_Started) {
        usercfg_Started =1;
        usercfg_End(0);		// End package if not
      }
      syst_MutexClose(&Mutex);
      break;
    
    case DLL_THREAD_ATTACH :
      // Init all needed TLS 
      dllmain_TAttachNb++;
      break;
    
    case DLL_THREAD_DETACH :
      dllmain_TAttachNb--;
      break;
  }
  return(TRUE);
}
