/************************************************************************
			Class entries
 ************************************************************************
 2009/10/23 - OBJNET - V2r14a: Create
 ************************************************************************/
#include <config.h>
#include <usercfg.h>
#include <pac.h>

#if config_MLOSREP
#include <pach.h>
#endif
#include <SYSTF.H>

#define verberr	1

#define ModName		"SYST_FILE"

#define pGlob	((pac_EntryType *)pGlob0)
/*----------------------------------------------------------------------*
		Define "Local" Globals
 *----------------------------------------------------------------------*/
#define Version_Len 35

#if !config_MLOSREP
//Client
static pac_EntryXType(Version_Len) GlobEntry;


typedef
 err_Type syst_FileAccessOBNType();
static
syst_FileAccessOBNType * syst_FileAccess0	= 0;
err_Type syst_FileAccess(
	char * path
	,unsigned  attr
	
	)
{
  
  if (syst_FileAccess0 == 0) return(pac__EntryNoFunc);
  return((*syst_FileAccess0)(
           path
           ,attr
           
           ));
}

typedef
 err_Type syst_FileAttrOBNType();
static
syst_FileAttrOBNType * syst_FileAttr0	= 0;
err_Type syst_FileAttr(
	char * path
	,unsigned * pAttr
	
	)
{
  
  if (syst_FileAttr0 == 0) return(pac__EntryNoFunc);
  return((*syst_FileAttr0)(
           path
           ,pAttr
           
           ));
}

typedef
 err_Type syst_FileAttrSetOBNType();
static
syst_FileAttrSetOBNType * syst_FileAttrSet0	= 0;
err_Type syst_FileAttrSet(
	char * path
	,unsigned  AttrMask
	,unsigned  Attr
	
	)
{
  
  if (syst_FileAttrSet0 == 0) return(pac__EntryNoFunc);
  return((*syst_FileAttrSet0)(
           path
           ,AttrMask
           ,Attr
           
           ));
}

typedef
 err_Type syst_FileInfoOBNType();
static
syst_FileInfoOBNType * syst_FileInfo0	= 0;
err_Type syst_FileInfo(
	char * path
	,syst_FileInfoType * pInfo
	
	)
{
  
  if (syst_FileInfo0 == 0) return(pac__EntryNoFunc);
  return((*syst_FileInfo0)(
           path
           ,pInfo
           
           ));
}

typedef
 err_Type syst_FileTimeSetOBNType();
static
syst_FileTimeSetOBNType * syst_FileTimeSet0	= 0;
err_Type syst_FileTimeSet(
	char * path
	,ulong  tm
	,int  mode
	
	)
{
  
  if (syst_FileTimeSet0 == 0) return(pac__EntryNoFunc);
  return((*syst_FileTimeSet0)(
           path
           ,tm
           ,mode
           
           ));
}

typedef
 err_Type syst_FileCopyOBNType();
static
syst_FileCopyOBNType * syst_FileCopy0	= 0;
err_Type syst_FileCopy(
	char * pathfrom
	,char * pathto
	,unsigned  mode
	
	)
{
  
  if (syst_FileCopy0 == 0) return(pac__EntryNoFunc);
  return((*syst_FileCopy0)(
           pathfrom
           ,pathto
           ,mode
           
           ));
}

typedef
 err_Type syst_FileRenameOBNType();
static
syst_FileRenameOBNType * syst_FileRename0	= 0;
err_Type syst_FileRename(
	char * pathfrom
	,char * pathto
	,unsigned  mode
	
	)
{
  
  if (syst_FileRename0 == 0) return(pac__EntryNoFunc);
  return((*syst_FileRename0)(
           pathfrom
           ,pathto
           ,mode
           
           ));
}

typedef
 err_Type syst_FileNewOBNType();
static
syst_FileNewOBNType * syst_FileNew0	= 0;
err_Type syst_FileNew(
	char * path
	,unsigned  Attr
	
	)
{
  
  if (syst_FileNew0 == 0) return(pac__EntryNoFunc);
  return((*syst_FileNew0)(
           path
           ,Attr
           
           ));
}

typedef
 err_Type syst_FileDeleteOBNType();
static
syst_FileDeleteOBNType * syst_FileDelete0	= 0;
err_Type syst_FileDelete(
	char * pathname
	
	)
{
  
  if (syst_FileDelete0 == 0) return(pac__EntryNoFunc);
  return((*syst_FileDelete0)(
           pathname
           
           ));
}

typedef
 err_Type syst_FileUnlinkOBNType();
static
syst_FileUnlinkOBNType * syst_FileUnlink0	= 0;
err_Type syst_FileUnlink(
	char * path
	
	)
{
  
  if (syst_FileUnlink0 == 0) return(pac__EntryNoFunc);
  return((*syst_FileUnlink0)(
           path
           
           ));
}

typedef
 err_Type syst_FileCreateOBNType();
static
syst_FileCreateOBNType * syst_FileCreate0	= 0;
err_Type syst_FileCreate(
	syst_FileRef * phFile
	,char * FPath
	,unsigned  Mode
	
	)
{
  
  if (syst_FileCreate0 == 0) return(pac__EntryNoFunc);
  return((*syst_FileCreate0)(
           phFile
           ,FPath
           ,Mode
           
           ));
}

typedef
 err_Type syst_FileCloseOBNType();
static
syst_FileCloseOBNType * syst_FileClose0	= 0;
err_Type syst_FileClose(
	syst_FileRef  hFile
	
	)
{
  
  if (syst_FileClose0 == 0) return(pac__EntryNoFunc);
  return((*syst_FileClose0)(
           hFile
           
           ));
}

typedef
 err_Type syst_FileReadOBNType();
static
syst_FileReadOBNType * syst_FileRead0	= 0;
err_Type syst_FileRead(
	syst_FileRef  hFile
	,void * Buffer
	,ulong  Len
	,ulong * pLen
	,syst_TType  TimeOut
	
	)
{
  
  if (syst_FileRead0 == 0) return(pac__EntryNoFunc);
  return((*syst_FileRead0)(
           hFile
           ,Buffer
           ,Len
           ,pLen
           ,TimeOut
           
           ));
}

typedef
 err_Type syst_FileWriteOBNType();
static
syst_FileWriteOBNType * syst_FileWrite0	= 0;
err_Type syst_FileWrite(
	syst_FileRef  hFile
	,void * Buffer
	,ulong  Len
	,ulong * pLen
	
	)
{
  
  if (syst_FileWrite0 == 0) return(pac__EntryNoFunc);
  return((*syst_FileWrite0)(
           hFile
           ,Buffer
           ,Len
           ,pLen
           
           ));
}

typedef
 err_Type syst_FileDirNewOBNType();
static
syst_FileDirNewOBNType * syst_FileDirNew0	= 0;
err_Type syst_FileDirNew(
	char * path
	
	)
{
  
  if (syst_FileDirNew0 == 0) return(pac__EntryNoFunc);
  return((*syst_FileDirNew0)(
           path
           
           ));
}

typedef
 err_Type syst_FileDirDeleteOBNType();
static
syst_FileDirDeleteOBNType * syst_FileDirDelete0	= 0;
err_Type syst_FileDirDelete(
	char * path
	
	)
{
  
  if (syst_FileDirDelete0 == 0) return(pac__EntryNoFunc);
  return((*syst_FileDirDelete0)(
           path
           
           ));
}

typedef
 err_Type syst_FileDirIsOBNType();
static
syst_FileDirIsOBNType * syst_FileDirIs0	= 0;
err_Type syst_FileDirIs(
	char * fpath
	
	)
{
  
  if (syst_FileDirIs0 == 0) return(pac__EntryNoFunc);
  return((*syst_FileDirIs0)(
           fpath
           
           ));
}

typedef
 err_Type syst_FileDirCopyOBNType();
static
syst_FileDirCopyOBNType * syst_FileDirCopy0	= 0;
err_Type syst_FileDirCopy(
	char * pathfrom
	,char * pathto
	,unsigned  mode
	
	)
{
  
  if (syst_FileDirCopy0 == 0) return(pac__EntryNoFunc);
  return((*syst_FileDirCopy0)(
           pathfrom
           ,pathto
           ,mode
           
           ));
}

typedef
 err_Type syst_FileDirCurSetOBNType();
static
syst_FileDirCurSetOBNType * syst_FileDirCurSet0	= 0;
err_Type syst_FileDirCurSet(
	char * path
	
	)
{
  
  if (syst_FileDirCurSet0 == 0) return(pac__EntryNoFunc);
  return((*syst_FileDirCurSet0)(
           path
           
           ));
}

typedef
 err_Type syst_FileDirCurGetOBNType();
static
syst_FileDirCurGetOBNType * syst_FileDirCurGet0	= 0;
err_Type syst_FileDirCurGet(
	char * pPath
	,int  MaxLen
	
	)
{
  
  if (syst_FileDirCurGet0 == 0) return(pac__EntryNoFunc);
  return((*syst_FileDirCurGet0)(
           pPath
           ,MaxLen
           
           ));
}

typedef
 err_Type syst_FileDirIterInitOBNType();
static
syst_FileDirIterInitOBNType * syst_FileDirIterInit0	= 0;
err_Type syst_FileDirIterInit(
	syst_FileDirIterType * Iter
	,char * path
	
	)
{
  
  if (syst_FileDirIterInit0 == 0) return(pac__EntryNoFunc);
  return((*syst_FileDirIterInit0)(
           Iter
           ,path
           
           ));
}

typedef
 err_Type syst_FileDirIterInitAttrOBNType();
static
syst_FileDirIterInitAttrOBNType * syst_FileDirIterInitAttr0	= 0;
err_Type syst_FileDirIterInitAttr(
	syst_FileDirIterType * Iter
	,char * path
	,unsigned  attrib
	,unsigned  notattrib
	
	)
{
  
  if (syst_FileDirIterInitAttr0 == 0) return(pac__EntryNoFunc);
  return((*syst_FileDirIterInitAttr0)(
           Iter
           ,path
           ,attrib
           ,notattrib
           
           ));
}

typedef
 err_Type syst_FileDirIterOBNType();
static
syst_FileDirIterOBNType * syst_FileDirIter0	= 0;
err_Type syst_FileDirIter(
	syst_FileDirIterType * Iter
	,char * pName
	,int  MaxLen
	
	)
{
  
  if (syst_FileDirIter0 == 0) return(pac__EntryNoFunc);
  return((*syst_FileDirIter0)(
           Iter
           ,pName
           ,MaxLen
           
           ));
}

typedef
 err_Type syst_FileDirIterEndOBNType();
static
syst_FileDirIterEndOBNType * syst_FileDirIterEnd0	= 0;
err_Type syst_FileDirIterEnd(
	syst_FileDirIterType * Iter
	
	)
{
  
  if (syst_FileDirIterEnd0 == 0) return(pac__EntryNoFunc);
  return((*syst_FileDirIterEnd0)(
           Iter
           
           ));
}

typedef
 err_Type syst_FileDiskExtractOBNType();
static
syst_FileDiskExtractOBNType * syst_FileDiskExtract0	= 0;
err_Type syst_FileDiskExtract(
	char * fpath
	,char * fdisk
	,unsigned  maxdl
	,char * fpath0
	
	)
{
  
  if (syst_FileDiskExtract0 == 0) return(pac__EntryNoFunc);
  return((*syst_FileDiskExtract0)(
           fpath
           ,fdisk
           ,maxdl
           ,fpath0
           
           ));
}

typedef
 err_Type syst_FileDirExtractOBNType();
static
syst_FileDirExtractOBNType * syst_FileDirExtract0	= 0;
err_Type syst_FileDirExtract(
	char * fpath
	
	)
{
  
  if (syst_FileDirExtract0 == 0) return(pac__EntryNoFunc);
  return((*syst_FileDirExtract0)(
           fpath
           
           ));
}

typedef
 err_Type syst_FileNameExtractOBNType();
static
syst_FileNameExtractOBNType * syst_FileNameExtract0	= 0;
err_Type syst_FileNameExtract(
	char * fpath
	,char ** pname
	
	)
{
  
  if (syst_FileNameExtract0 == 0) return(pac__EntryNoFunc);
  return((*syst_FileNameExtract0)(
           fpath
           ,pname
           
           ));
}

typedef
 err_Type syst_FileSuffixExtractOBNType();
static
syst_FileSuffixExtractOBNType * syst_FileSuffixExtract0	= 0;
err_Type syst_FileSuffixExtract(
	char * fpath
	,char ** psuffix
	
	)
{
  
  if (syst_FileSuffixExtract0 == 0) return(pac__EntryNoFunc);
  return((*syst_FileSuffixExtract0)(
           fpath
           ,psuffix
           
           ));
}

typedef
 err_Type syst_FileExtractOBNType();
static
syst_FileExtractOBNType * syst_FileExtract0	= 0;
err_Type syst_FileExtract(
	char * fpath
	,char * fname
	,int  size
	
	)
{
  
  if (syst_FileExtract0 == 0) return(pac__EntryNoFunc);
  return((*syst_FileExtract0)(
           fpath
           ,fname
           ,size
           
           ));
}

typedef
 err_Type syst_FilePathAbsOBNType();
static
syst_FilePathAbsOBNType * syst_FilePathAbs0	= 0;
err_Type syst_FilePathAbs(
	char * fpath
	,char * path
	,unsigned  maxl
	,char * root
	
	)
{
  
  if (syst_FilePathAbs0 == 0) return(pac__EntryNoFunc);
  return((*syst_FilePathAbs0)(
           fpath
           ,path
           ,maxl
           ,root
           
           ));
}

typedef
 err_Type syst_FilePathRelOBNType();
static
syst_FilePathRelOBNType * syst_FilePathRel0	= 0;
err_Type syst_FilePathRel(
	char * rpath
	,char * path
	,unsigned  maxl
	,char * root
	
	)
{
  
  if (syst_FilePathRel0 == 0) return(pac__EntryNoFunc);
  return((*syst_FilePathRel0)(
           rpath
           ,path
           ,maxl
           ,root
           
           ));
}

typedef
 err_Type syst_FileRootExtractOBNType();
static
syst_FileRootExtractOBNType * syst_FileRootExtract0	= 0;
err_Type syst_FileRootExtract(
	char * fpath
	,char * rpath
	,char * lname
	,int  size
	
	)
{
  
  if (syst_FileRootExtract0 == 0) return(pac__EntryNoFunc);
  return((*syst_FileRootExtract0)(
           fpath
           ,rpath
           ,lname
           ,size
           
           ));
}

typedef
 err_Type syst_FileRootCommonOBNType();
static
syst_FileRootCommonOBNType * syst_FileRootCommon0	= 0;
err_Type syst_FileRootCommon(
	char * rpath
	,char * path1
	,char * path2
	,int  size
	
	)
{
  
  if (syst_FileRootCommon0 == 0) return(pac__EntryNoFunc);
  return((*syst_FileRootCommon0)(
           rpath
           ,path1
           ,path2
           ,size
           
           ));
}

typedef
 err_Type syst_FileCompressOBNType();
static
syst_FileCompressOBNType * syst_FileCompress0	= 0;
err_Type syst_FileCompress(
	char * fpath
	,char * hpath
	,char * lpath
	,int  size
	
	)
{
  
  if (syst_FileCompress0 == 0) return(pac__EntryNoFunc);
  return((*syst_FileCompress0)(
           fpath
           ,hpath
           ,lpath
           ,size
           
           ));
}

typedef
 err_Type syst_FileExpandOBNType();
static
syst_FileExpandOBNType * syst_FileExpand0	= 0;
err_Type syst_FileExpand(
	char * lpath
	,char * path
	,int  size
	,int  mode
	
	)
{
  
  if (syst_FileExpand0 == 0) return(pac__EntryNoFunc);
  return((*syst_FileExpand0)(
           lpath
           ,path
           ,size
           ,mode
           
           ));
}


#endif
/*----------------------------------------------------------------------*
                Get Globals from inside
 *----------------------------------------------------------------------*/
#if !config_MLOSREP
// Package client 
// Defined in upper level 
extern
err_Type syst_FileEntryGet(
        pac_Type * Pac,
        unsigned Mode,		// Take, release
        char * Name, 		// Interface name
        void * pGlob0	// OUT: List of globals
        );
/*----------------------------------------------------------------------*/
#else
// Package REP
err_Type syst_FileEntryGet(
        pac_Type * Pac,
        unsigned Mode,		// Take, release
        char * Name, 		// Interface name
        void * pGlob0		// OUT: List of globals
        )
{
  err_Type erno = 0;
  pac_EntryItemType * p = (pac_EntryItemType *)pGlob->ObjList;
  
  if ((pGlob->Mode & pac_EntryModeX)==0) return(pac__EntryLength);
  if (pGlob->SizeOf < pac_EntryXSizeOf(0)) return(pac__EntryLength);
  
  strcpy(pGlob->Name, "syst_File");
  
  if (Mode & pac_EntryModeRelease) {
    erno = pac_EntryUpdate(pGlob, Mode | pac_EntryModeAll, 0,0,0,0,0);
    goto fin;
  }
  do {

    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           1,
                           syst_FileAccess, 
                           pac_EntryItemModeFunc, // Type of method
                           0,			  // Num of method
                           "Access"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           2,
                           syst_FileAttr, 
                           pac_EntryItemModeFunc, // Type of method
                           0,			  // Num of method
                           "Attr"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           3,
                           syst_FileAttrSet, 
                           pac_EntryItemModeFunc, // Type of method
                           0,			  // Num of method
                           "AttrSet"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           4,
                           syst_FileInfo, 
                           pac_EntryItemModeFunc, // Type of method
                           0,			  // Num of method
                           "Info"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           5,
                           syst_FileTimeSet, 
                           pac_EntryItemModeFunc, // Type of method
                           0,			  // Num of method
                           "TimeSet"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           6,
                           syst_FileCopy, 
                           pac_EntryItemModeFunc, // Type of method
                           0,			  // Num of method
                           "Copy"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           7,
                           syst_FileRename, 
                           pac_EntryItemModeFunc, // Type of method
                           0,			  // Num of method
                           "Rename"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           8,
                           syst_FileNew, 
                           pac_EntryItemModeFunc, // Type of method
                           0,			  // Num of method
                           "New"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           9,
                           syst_FileDelete, 
                           pac_EntryItemModeFunc, // Type of method
                           0,			  // Num of method
                           "Delete"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           10,
                           syst_FileUnlink, 
                           pac_EntryItemModeFunc, // Type of method
                           0,			  // Num of method
                           "Unlink"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           11,
                           syst_FileCreate, 
                           pac_EntryItemModeFunc, // Type of method
                           0,			  // Num of method
                           "Create"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           12,
                           syst_FileClose, 
                           pac_EntryItemModeFunc, // Type of method
                           0,			  // Num of method
                           "Close"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           13,
                           syst_FileRead, 
                           pac_EntryItemModeFunc, // Type of method
                           0,			  // Num of method
                           "Read"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           14,
                           syst_FileWrite, 
                           pac_EntryItemModeFunc, // Type of method
                           0,			  // Num of method
                           "Write"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           15,
                           syst_FileDirNew, 
                           pac_EntryItemModeFunc, // Type of method
                           0,			  // Num of method
                           "DirNew"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           16,
                           syst_FileDirDelete, 
                           pac_EntryItemModeFunc, // Type of method
                           0,			  // Num of method
                           "DirDelete"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           17,
                           syst_FileDirIs, 
                           pac_EntryItemModeFunc, // Type of method
                           0,			  // Num of method
                           "DirIs"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           18,
                           syst_FileDirCopy, 
                           pac_EntryItemModeFunc, // Type of method
                           0,			  // Num of method
                           "DirCopy"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           19,
                           syst_FileDirCurSet, 
                           pac_EntryItemModeFunc, // Type of method
                           0,			  // Num of method
                           "DirCurSet"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           20,
                           syst_FileDirCurGet, 
                           pac_EntryItemModeFunc, // Type of method
                           0,			  // Num of method
                           "DirCurGet"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           21,
                           syst_FileDirIterInit, 
                           pac_EntryItemModeFunc, // Type of method
                           0,			  // Num of method
                           "DirIterInit"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           22,
                           syst_FileDirIterInitAttr, 
                           pac_EntryItemModeFunc, // Type of method
                           0,			  // Num of method
                           "DirIterInitAttr"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           23,
                           syst_FileDirIter, 
                           pac_EntryItemModeFunc, // Type of method
                           0,			  // Num of method
                           "DirIter"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           24,
                           syst_FileDirIterEnd, 
                           pac_EntryItemModeFunc, // Type of method
                           0,			  // Num of method
                           "DirIterEnd"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           25,
                           syst_FileDiskExtract, 
                           pac_EntryItemModeFunc, // Type of method
                           0,			  // Num of method
                           "DiskExtract"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           26,
                           syst_FileDirExtract, 
                           pac_EntryItemModeFunc, // Type of method
                           0,			  // Num of method
                           "DirExtract"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           27,
                           syst_FileNameExtract, 
                           pac_EntryItemModeFunc, // Type of method
                           0,			  // Num of method
                           "NameExtract"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           28,
                           syst_FileSuffixExtract, 
                           pac_EntryItemModeFunc, // Type of method
                           0,			  // Num of method
                           "SuffixExtract"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           29,
                           syst_FileExtract, 
                           pac_EntryItemModeFunc, // Type of method
                           0,			  // Num of method
                           "Extract"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           30,
                           syst_FilePathAbs, 
                           pac_EntryItemModeFunc, // Type of method
                           0,			  // Num of method
                           "PathAbs"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           31,
                           syst_FilePathRel, 
                           pac_EntryItemModeFunc, // Type of method
                           0,			  // Num of method
                           "PathRel"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           32,
                           syst_FileRootExtract, 
                           pac_EntryItemModeFunc, // Type of method
                           0,			  // Num of method
                           "RootExtract"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           33,
                           syst_FileRootCommon, 
                           pac_EntryItemModeFunc, // Type of method
                           0,			  // Num of method
                           "RootCommon"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           34,
                           syst_FileCompress, 
                           pac_EntryItemModeFunc, // Type of method
                           0,			  // Num of method
                           "Compress"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           35,
                           syst_FileExpand, 
                           pac_EntryItemModeFunc, // Type of method
                           0,			  // Num of method
                           "Expand"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
  } while(0);
  fin:;
  return(erno);
}
#endif
/*----------------------------------------------------------------------*
                        Init
 *----------------------------------------------------------------------*/
#if !config_MLOSREP
// Client
static
err_Type EntryInit(
        void * pGlob0	// IN/OUT: List of globals
        )
{
  err_Type erno=0;
  pac_EntryItemType * p;
  char * Interface = "MAIN"; 
  
  pGlob->SizeOf		= pac_EntryXSizeOf(Version_Len);
  pGlob->Mode		= pac_EntryModeX;
  strcpy(pGlob->Name, Interface);
  pGlob->ObjListLen	= Version_Len;
  
  p = (pac_EntryItemType *)pGlob->ObjList;
  memset(&p[0], 0, sizeof(pac_EntryItemType));
  
  do {

    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           1,
                           0, 
                           pac_EntryItemModeFunc, 
                           0,
                           "Access"
                           );
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           2,
                           0, 
                           pac_EntryItemModeFunc, 
                           0,
                           "Attr"
                           );
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           3,
                           0, 
                           pac_EntryItemModeFunc, 
                           0,
                           "AttrSet"
                           );
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           4,
                           0, 
                           pac_EntryItemModeFunc, 
                           0,
                           "Info"
                           );
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           5,
                           0, 
                           pac_EntryItemModeFunc, 
                           0,
                           "TimeSet"
                           );
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           6,
                           0, 
                           pac_EntryItemModeFunc, 
                           0,
                           "Copy"
                           );
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           7,
                           0, 
                           pac_EntryItemModeFunc, 
                           0,
                           "Rename"
                           );
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           8,
                           0, 
                           pac_EntryItemModeFunc, 
                           0,
                           "New"
                           );
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           9,
                           0, 
                           pac_EntryItemModeFunc, 
                           0,
                           "Delete"
                           );
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           10,
                           0, 
                           pac_EntryItemModeFunc, 
                           0,
                           "Unlink"
                           );
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           11,
                           0, 
                           pac_EntryItemModeFunc, 
                           0,
                           "Create"
                           );
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           12,
                           0, 
                           pac_EntryItemModeFunc, 
                           0,
                           "Close"
                           );
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           13,
                           0, 
                           pac_EntryItemModeFunc, 
                           0,
                           "Read"
                           );
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           14,
                           0, 
                           pac_EntryItemModeFunc, 
                           0,
                           "Write"
                           );
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           15,
                           0, 
                           pac_EntryItemModeFunc, 
                           0,
                           "DirNew"
                           );
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           16,
                           0, 
                           pac_EntryItemModeFunc, 
                           0,
                           "DirDelete"
                           );
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           17,
                           0, 
                           pac_EntryItemModeFunc, 
                           0,
                           "DirIs"
                           );
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           18,
                           0, 
                           pac_EntryItemModeFunc, 
                           0,
                           "DirCopy"
                           );
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           19,
                           0, 
                           pac_EntryItemModeFunc, 
                           0,
                           "DirCurSet"
                           );
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           20,
                           0, 
                           pac_EntryItemModeFunc, 
                           0,
                           "DirCurGet"
                           );
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           21,
                           0, 
                           pac_EntryItemModeFunc, 
                           0,
                           "DirIterInit"
                           );
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           22,
                           0, 
                           pac_EntryItemModeFunc, 
                           0,
                           "DirIterInitAttr"
                           );
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           23,
                           0, 
                           pac_EntryItemModeFunc, 
                           0,
                           "DirIter"
                           );
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           24,
                           0, 
                           pac_EntryItemModeFunc, 
                           0,
                           "DirIterEnd"
                           );
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           25,
                           0, 
                           pac_EntryItemModeFunc, 
                           0,
                           "DiskExtract"
                           );
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           26,
                           0, 
                           pac_EntryItemModeFunc, 
                           0,
                           "DirExtract"
                           );
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           27,
                           0, 
                           pac_EntryItemModeFunc, 
                           0,
                           "NameExtract"
                           );
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           28,
                           0, 
                           pac_EntryItemModeFunc, 
                           0,
                           "SuffixExtract"
                           );
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           29,
                           0, 
                           pac_EntryItemModeFunc, 
                           0,
                           "Extract"
                           );
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           30,
                           0, 
                           pac_EntryItemModeFunc, 
                           0,
                           "PathAbs"
                           );
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           31,
                           0, 
                           pac_EntryItemModeFunc, 
                           0,
                           "PathRel"
                           );
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           32,
                           0, 
                           pac_EntryItemModeFunc, 
                           0,
                           "RootExtract"
                           );
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           33,
                           0, 
                           pac_EntryItemModeFunc, 
                           0,
                           "RootCommon"
                           );
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           34,
                           0, 
                           pac_EntryItemModeFunc, 
                           0,
                           "Compress"
                           );
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           35,
                           0, 
                           pac_EntryItemModeFunc, 
                           0,
                           "Expand"
                           );
    if (erno) break;
  } while(0);
  return(erno);
}
/*----------------------------------------------------------------------*
			Set
 *----------------------------------------------------------------------*/
// Client
static
err_Type EntrySet(
        void * pGlob0,	// IN: List of globals
        unsigned Mode
        )
{
  err_Type erno = 0;
  pac_EntryItemType * p;
  ulong Idx;
  
  if (pGlob->ObjListLen < Version_Len) return(pac__EntryLength);
  if ((pGlob->Mode & pac_EntryModeX)==0) return(pac__EntryLength);
  p = (pac_EntryItemType *)pGlob->ObjList;
  
  if ((Mode & pac_EntryModeRelease)==0) {
    // Take (After Release ModeSet is off)
    // Assume all items are correctly returned and in the good order
    // A missing item raises an error
    for (Idx=1;Idx <= Version_Len;Idx++) {
      if ((p[Idx].Mode & pac_EntryItemModeSet)==0) {
        erno = pac__EntryNotFound;
        err_Printf(verberr,"-%s.EntrySet: <%s.%s> entry is missing\n", ModName, 
                            pGlob->Name,p[Idx].Name
                            );
      }
    } // for 
    if (erno) return(erno);
  }
  

  syst_FileAccess0 = (syst_FileAccessOBNType *)p[1].Val;
  syst_FileAttr0 = (syst_FileAttrOBNType *)p[2].Val;
  syst_FileAttrSet0 = (syst_FileAttrSetOBNType *)p[3].Val;
  syst_FileInfo0 = (syst_FileInfoOBNType *)p[4].Val;
  syst_FileTimeSet0 = (syst_FileTimeSetOBNType *)p[5].Val;
  syst_FileCopy0 = (syst_FileCopyOBNType *)p[6].Val;
  syst_FileRename0 = (syst_FileRenameOBNType *)p[7].Val;
  syst_FileNew0 = (syst_FileNewOBNType *)p[8].Val;
  syst_FileDelete0 = (syst_FileDeleteOBNType *)p[9].Val;
  syst_FileUnlink0 = (syst_FileUnlinkOBNType *)p[10].Val;
  syst_FileCreate0 = (syst_FileCreateOBNType *)p[11].Val;
  syst_FileClose0 = (syst_FileCloseOBNType *)p[12].Val;
  syst_FileRead0 = (syst_FileReadOBNType *)p[13].Val;
  syst_FileWrite0 = (syst_FileWriteOBNType *)p[14].Val;
  syst_FileDirNew0 = (syst_FileDirNewOBNType *)p[15].Val;
  syst_FileDirDelete0 = (syst_FileDirDeleteOBNType *)p[16].Val;
  syst_FileDirIs0 = (syst_FileDirIsOBNType *)p[17].Val;
  syst_FileDirCopy0 = (syst_FileDirCopyOBNType *)p[18].Val;
  syst_FileDirCurSet0 = (syst_FileDirCurSetOBNType *)p[19].Val;
  syst_FileDirCurGet0 = (syst_FileDirCurGetOBNType *)p[20].Val;
  syst_FileDirIterInit0 = (syst_FileDirIterInitOBNType *)p[21].Val;
  syst_FileDirIterInitAttr0 = (syst_FileDirIterInitAttrOBNType *)p[22].Val;
  syst_FileDirIter0 = (syst_FileDirIterOBNType *)p[23].Val;
  syst_FileDirIterEnd0 = (syst_FileDirIterEndOBNType *)p[24].Val;
  syst_FileDiskExtract0 = (syst_FileDiskExtractOBNType *)p[25].Val;
  syst_FileDirExtract0 = (syst_FileDirExtractOBNType *)p[26].Val;
  syst_FileNameExtract0 = (syst_FileNameExtractOBNType *)p[27].Val;
  syst_FileSuffixExtract0 = (syst_FileSuffixExtractOBNType *)p[28].Val;
  syst_FileExtract0 = (syst_FileExtractOBNType *)p[29].Val;
  syst_FilePathAbs0 = (syst_FilePathAbsOBNType *)p[30].Val;
  syst_FilePathRel0 = (syst_FilePathRelOBNType *)p[31].Val;
  syst_FileRootExtract0 = (syst_FileRootExtractOBNType *)p[32].Val;
  syst_FileRootCommon0 = (syst_FileRootCommonOBNType *)p[33].Val;
  syst_FileCompress0 = (syst_FileCompressOBNType *)p[34].Val;
  syst_FileExpand0 = (syst_FileExpandOBNType *)p[35].Val;
  return(erno);
}
#endif
/*----------------------------------------------------------------------*
                        Start for REP
 Init "local" globals
 MANDATORY: Do not declare in .DEF
 *----------------------------------------------------------------------*/
err_Type syst_FileEntryStart(
        usercfg_Type * cfg
        )
{
  err_Type erno = 0;
  
  #if !config_MLOSREP
  // Package client
  erno = EntryInit(&GlobEntry);
  if (erno) return(erno);
  erno = syst_FileEntryGet(0, 0, "syst_File", &GlobEntry);
  if (erno) return(erno);
  erno = EntrySet(&GlobEntry, 0);
  #endif
  
  return(erno);
}
/*----------------------------------------------------------------------*
                        End for REP
 Init "local" globals
 MANDATORY: Do not declare in .DEF
 *----------------------------------------------------------------------*/
err_Type syst_FileEntryEnd(
        usercfg_Type * cfg
        )
{
  err_Type erno = 0;
  
  #if !config_MLOSREP
  // Client
  erno = syst_FileEntryGet(0, pac_EntryModeRelease, "syst_File", &GlobEntry);
  if (erno) return(erno);
  erno = EntrySet(&GlobEntry, pac_EntryModeRelease);
  #endif
  
  return(erno);
}
