/************************************************************************
			Package Interface
			MLOS_MAIN
 ************************************************************************
 To be Started and Ended inside client. 
 To be Started and Ended inside MLOS package with 
 config_MLOSREP defined in config.h.
 ************************************************************************
 2009/10/23 - OBJNET - V2r14a: Create
 ************************************************************************/
#include <config.h>
#include <usercfg.h>

#if config_MLOSREP
// Package
#include <pach.h>
#else
// Client
typedef
  err_Type pac_EntryGetType();
#endif
#include <pac.h>
#include <MLOSMAIN.h>

#define verberr	1

#if !config_MLOSREP

extern err_Type syst_FileEntryStart(usercfg_Type * cfg);
extern err_Type syst_FileEntryEnd(usercfg_Type * cfg);

extern err_Type file_FSEntryStart(usercfg_Type * cfg);
extern err_Type file_FSEntryEnd(usercfg_Type * cfg);

#endif

#define ModName		"MLOSMAIN"
#define PacName		"MLOS"
#define PacName2	"MLOS:001"

#define pGlob	((pac_EntryType *)pGlob0)
/*----------------------------------------------------------------------*
		Define access to modules
 *----------------------------------------------------------------------*/
#define Version_Len 2

#if config_MLOSREP

extern err_Type syst_FileEntryGet(	
        pac_Type * Pac,
        unsigned Mode,		// Take, release
        char * Name, 		// Interface name
        pac_EntryType * pGlob0	// IN/OUT: List of globals
	);

extern err_Type file_FSEntryGet(	
        pac_Type * Pac,
        unsigned Mode,		// Take, release
        char * Name, 		// Interface name
        pac_EntryType * pGlob0	// IN/OUT: List of globals
	);

#else
// Client 
static pac_Type * GlobPack = 0;
static pac_EntryXType(Version_Len) GlobEntry;


static
pac_EntryGetType * syst_FileEntryGet0	= 0;
err_Type syst_FileEntryGet(
        pac_Type * Pac,
        unsigned Mode,		// Take, release
        char * Name, 		// Interface name
        pac_EntryType * pGlob0	// IN/OUT: List of globals
	)
{
  if (syst_FileEntryGet0 == 0) return(pac__EntryNoFunc);
  return((*syst_FileEntryGet0)(Pac, Mode, Name, pGlob0));
}

static
pac_EntryGetType * file_FSEntryGet0	= 0;
err_Type file_FSEntryGet(
        pac_Type * Pac,
        unsigned Mode,		// Take, release
        char * Name, 		// Interface name
        pac_EntryType * pGlob0	// IN/OUT: List of globals
	)
{
  if (file_FSEntryGet0 == 0) return(pac__EntryNoFunc);
  return((*file_FSEntryGet0)(Pac, Mode, Name, pGlob0));
}

#endif

/*----------------------------------------------------------------------*
                Get Globals from inside
 *----------------------------------------------------------------------*/
#if config_MLOSREP
// Package REP
err_Type mlos_MAINEntryGet(
        pac_Type * Pac,
        unsigned Mode,		// Take, release
        char * Name, 		// Interface name
        pac_EntryType * pGlob0		// OUT: List of globals
	)
{
  err_Type erno = 0;
  pac_EntryItemType * p = (pac_EntryItemType *)pGlob->ObjList;
  
  if ((pGlob->Mode & pac_EntryModeX)==0) return(pac__EntryLength);
  if (pGlob->SizeOf < pac_EntryXSizeOf(0)) return(pac__EntryLength);
  
  strcpy(pGlob->Name, ModName);
  
  if (Mode & pac_EntryModeRelease) {
    erno = pac_EntryUpdate(pGlob, Mode | pac_EntryModeAll, 0,0,0,0,0);
    goto fin;
  }
  
  do {

    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           1,
                           syst_FileEntryGet, 
                           pac_EntryItemModeEntry, 
                           0,
                           "syst_FileEntryGet"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           Mode, 
                           2,
                           file_FSEntryGet, 
                           pac_EntryItemModeEntry, 
                           0,
                           "file_FSEntryGet"
                           );
    // Ignore entries that can not be updated
    if (erno == pac__EntryNotFound) erno = 0;
    if (erno) break;
  } while(0);
  fin:;
  return(erno);
}
#endif
/*----------------------------------------------------------------------*
                        Init
 *----------------------------------------------------------------------*/
#if !config_MLOSREP
// Client
static
err_Type EntryInit(
        void * pGlob0	// IN/OUT: List of globals
        )
{
  err_Type erno=0;
  pac_EntryItemType * p;
  char * Interface = "MAIN"; 
  
  pGlob->SizeOf		= pac_EntryXSizeOf(Version_Len);
  pGlob->Mode		= pac_EntryModeX;
  strcpy(pGlob->Name, Interface);
  pGlob->ObjListLen	= Version_Len;
  p = (pac_EntryItemType *)pGlob->ObjList;
  
  memset(&p[0], 0, sizeof(pac_EntryItemType));
  do {

    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           1,
                           0, 
                           pac_EntryItemModeEntry, 
                           0,
                           "syst_FileEntryGet"
                           );
    if (erno) break;
    erno = pac_EntryUpdate(pGlob, 
                           pac_EntryModeInit, 
                           2,
                           0, 
                           pac_EntryItemModeEntry, 
                           0,
                           "file_FSEntryGet"
                           );
    if (erno) break;
  } while(0);
  return(erno);
}
/*----------------------------------------------------------------------*
                        Set
 *----------------------------------------------------------------------*/
static
err_Type EntrySet(
        void * pGlob0,	// IN: List of globals
        unsigned Mode
        )
{
  err_Type erno=0;
  pac_EntryItemType * p;
  ulong Idx;
  
  if (pGlob->ObjListLen < Version_Len) return(pac__EntryLength);
  if ((pGlob->Mode & pac_EntryModeX)==0) return(pac__EntryLength);
  p = (pac_EntryItemType *)pGlob->ObjList;
  
  if ((Mode & pac_EntryModeRelease)==0) {
    // Take (After Release ModeSet is off)
    // Assume all items are correctly returned in the good order
    // A missing item raises an error
    for (Idx=1;Idx <= Version_Len;Idx++) {
      if ((p[Idx].Mode & pac_EntryItemModeSet)==0) {
        erno = pac__EntryNotFound;
        err_Printf(verberr,"-%s.EntrySet: <%s> entry is missing\n", ModName, 
                            p[Idx].Name
                            );
      }
    } // for 
    if (erno) return(erno);
  }
  

  syst_FileEntryGet0 = (pac_EntryGetType *)p[1].Val;
  file_FSEntryGet0 = (pac_EntryGetType *)p[2].Val;
  return(0);
}
#endif
/*----------------------------------------------------------------------*
                        Start
 Init "local" globals
 MANDATORY: Do not declare in .DEF
 *----------------------------------------------------------------------*/
err_Type mlos_MAINEntryStart(usercfg_Type * cfg)
{
  err_Type erno = 0;
  char * Interface = "MAIN"; 
  
  #if config_MLOSREP
  //====================PACKAGE
  // Define this interface
  pac_Type * Pack = 0;
  
  do {
    if (cfg == 0 || cfg->Package==0) {
      erno = pac_Find(&Pack, 0, (uchar *)PacName, 0);
      if (erno) {
        erno = pac_Find(&Pack, 0, (uchar *)PacName2, 0);
        if (erno) {
          err_Printf(verberr,"-%s.Entry: No %s nor %s package found\n", ModName, PacName, PacName2);
          break;
        }
      }
    } else {
      Pack = (pac_Type *)cfg->Package;
      drv_RefAdd(Pack);
    }
    erno = pac_EntryListAdd(
          (pac_HType *)Pack, 
          0,
          Interface,
          mlos_MAINEntryGet
          );
  } while(0);
  drv_RefDel(Pack);
  
  #else
  //====================CLIENT
  erno = pac_Find(&GlobPack, 0, (uchar *)PacName, 0);
  if (erno) {
    erno = pac_Find(&GlobPack, 0, (uchar *)PacName2, 0);
    if (erno) {
      err_Printf(verberr,"-%s.Entry: No %s nor %s package found\n", ModName, PacName, PacName2);
      goto fin;
    }
  }
  do {
    erno = EntryInit(&GlobEntry);
    if (erno) break;
    erno = pac_Entry(GlobPack, 0, Interface, (pac_EntryType *)&GlobEntry);
    if (erno) break;
    
    do {
      // Define specific entries
      erno = EntrySet(&GlobEntry, 0);
      if (erno) break;
      
      // Start module entries

      erno = syst_FileEntryStart(cfg);
      if (erno) break;

      erno = file_FSEntryStart(cfg);
      if (erno) break;


    } while(0);
    if (erno) 
      pac_Entry(GlobPack, pac_EntryModeRelease, Interface, (pac_EntryType *)&GlobEntry);
  } while(0);
  if (erno) drv_RefDel(GlobPack);
  fin:;
  
  #endif
  
  if (erno)
    err_Printf(verberr,"-%s.Entry: ERROR %u\n", ModName, erno);
  return(erno);
}
/*----------------------------------------------------------------------*
                        END
 *----------------------------------------------------------------------*/
err_Type mlos_MAINEntryEnd(usercfg_Type * cfg)
{
  err_Type erno = 0;
  char * Interface = "MAIN"; 
  
  #if config_MLOSREP
  //====================Package
  pac_Type * Pack = 0;
  
  do {
    if (cfg == 0 || cfg->Package==0) {
      erno = pac_Find(&Pack, 0, (uchar *)PacName, 0);
      if (erno) {
        erno = pac_Find(&Pack, 0, (uchar *)PacName2, 0);
        if (erno) {
          err_Printf(verberr,"-%s.EntryEnd: No %s nor %s package found\n", ModName, PacName, PacName2);
          break;
        }
      }
    } else {
      Pack = (pac_Type *)cfg->Package;
      drv_RefAdd(Pack);
    }
    erno = pac_EntryListRemove(
          (pac_HType *)Pack, 
          0,
          Interface
          );
  } while(0);
  drv_RefDel(Pack);
  
  #else
  //====================Client
  do {
    // End module entries

      erno = syst_FileEntryEnd(cfg);
      if (erno) break;

      erno = file_FSEntryEnd(cfg);
      if (erno) break;


    erno = pac_Entry(GlobPack, 
                     pac_EntryModeRelease, 
                     Interface,
                     (pac_EntryType *)&GlobEntry);
    if (erno) break;
    erno = EntrySet(&GlobEntry, pac_EntryModeRelease);
    
  } while(0);
  drv_RefDel(GlobPack);
  #endif
  
  if (erno)
    err_Printf(verberr,"-%s.EntryEnd: ERROR %u\n", ModName, erno);
  return(erno);
}
